/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.io.File;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.util.ClasspathURLStreamHandler;

public class ServerManager {
    private static ServerManager instance;
    private static final Log log;
    private String axis2Repolocation;
    private ListenerManager listenerManager;
    private ConfigurationContext configctx;

    public static ServerManager getInstance() {
        if (instance == null) {
            instance = new ServerManager();
        }
        return instance;
    }

    public void setAxis2Repolocation(String axis2Repolocation) {
        this.axis2Repolocation = axis2Repolocation;
    }

    public void start() {
        try {
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactoryImpl());
        }
        catch (Throwable t) {
            log.warn((Object)"Unable to register a URLStreamHandlerFactory - Custom URL protocols may not work properly (e.g. classpath://)");
        }
        if (this.axis2Repolocation == null) {
            log.fatal((Object)"The Axis2 Repository must be provided");
            return;
        }
        log.info((Object)("Using the Axis2 Repository " + new File(this.axis2Repolocation).getAbsolutePath()));
        try {
            this.configctx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.axis2Repolocation, null);
            this.listenerManager = this.configctx.getListenerManager();
            if (this.listenerManager == null) {
                this.listenerManager = new ListenerManager();
                this.listenerManager.init(this.configctx);
            }
            ServerManager.selectPort(this.configctx);
            for (String trp : this.configctx.getAxisConfiguration().getTransportsIn().keySet()) {
                TransportInDescription trsIn = (TransportInDescription)this.configctx.getAxisConfiguration().getTransportsIn().get(trp);
                this.listenerManager.addListener(trsIn, false);
                String msg = "Starting transport " + trsIn.getName();
                if (trsIn.getParameter("port") != null) {
                    msg = msg + " on port " + trsIn.getParameter("port").getValue();
                }
                log.info((Object)msg);
            }
            Parameter synEnv = this.configctx.getAxisConfiguration().getParameter("synapse.env");
            Parameter synCfg = this.configctx.getAxisConfiguration().getParameter("synapse.config");
            String message = "Unable to initialize the Synapse Configuration : Can not find the ";
            if (synCfg == null || synCfg.getValue() == null || !(synCfg.getValue() instanceof SynapseConfiguration)) {
                log.fatal((Object)(message + "Synapse Configuration"));
                throw new SynapseException(message + "Synapse Configuration");
            }
            if (synEnv == null || synEnv.getValue() == null || !(synEnv.getValue() instanceof SynapseEnvironment)) {
                log.fatal((Object)(message + "Synapse Environment"));
                throw new SynapseException(message + "Synapse Environment");
            }
            ((SynapseEnvironment)synEnv.getValue()).setInitialized(true);
            Collection startups = ((SynapseConfiguration)synCfg.getValue()).getStartups();
            for (Object o : startups) {
                if (!(o instanceof ManagedLifecycle)) continue;
                ManagedLifecycle m = (ManagedLifecycle)o;
                m.init((SynapseEnvironment)synEnv.getValue());
            }
            log.info((Object)"Ready for processing");
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.fatal((Object)"Startup failed...");
            System.exit(1);
        }
    }

    public void stop() {
        try {
            if (this.listenerManager != null) {
                this.listenerManager.stop();
                this.listenerManager.destroy();
            }
            if (this.configctx != null) {
                this.configctx.terminate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void selectPort(ConfigurationContext configCtx) {
        TransportInDescription trsIn = (TransportInDescription)configCtx.getAxisConfiguration().getTransportsIn().get("http");
        if (trsIn != null) {
            Parameter param;
            int port = 8080;
            String bindAddress = null;
            String strPort = System.getProperty("port");
            if (strPort != null) {
                try {
                    port = new Integer(strPort);
                }
                catch (NumberFormatException e) {
                    log.error((Object)"System property 'port' does not provide a valid integer");
                }
            }
            if ((param = trsIn.getParameter("port")) != null && param.getValue() != null) {
                port = Integer.parseInt(param.getValue().toString());
            }
            if ((param = trsIn.getParameter("bind-address")) != null && param.getValue() != null) {
                bindAddress = ((String)param.getValue()).trim();
            }
            while (true) {
                ServerSocket sock = null;
                try {
                    sock = bindAddress == null ? new ServerSocket(port) : new ServerSocket(port, 50, InetAddress.getByName(bindAddress));
                    trsIn.getParameter("port").setValue((Object)Integer.toString(port));
                }
                catch (Exception e) {
                    log.warn((Object)("Port " + port + " already in use. Trying alternate"));
                    if (port == 8080) {
                        port = 8008;
                        continue;
                    }
                    ++port;
                    continue;
                }
                finally {
                    if (sock == null) continue;
                    try {
                        sock.close();
                    }
                    catch (Exception e) {}
                    continue;
                }
                break;
            }
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configctx;
    }

    static {
        log = LogFactory.getLog(ServerManager.class);
    }

    private static final class URLStreamHandlerFactoryImpl
    implements URLStreamHandlerFactory {
        private URLStreamHandlerFactoryImpl() {
        }

        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol == null) {
                throw new IllegalArgumentException("'protocol' cannot be null");
            }
            ClasspathURLStreamHandler urlSH = null;
            if (protocol.equals("classpath")) {
                urlSH = new ClasspathURLStreamHandler();
            }
            return urlSH;
        }
    }
}

