/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;

public abstract class FaultHandler {
    private static final Log log = LogFactory.getLog(FaultHandler.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");

    public void handleFault(MessageContext synCtx) {
        block3: {
            boolean traceOrDebugOn;
            boolean traceOn = synCtx.getTracingState() == 1;
            boolean bl = traceOrDebugOn = traceOn || log.isDebugEnabled();
            if (traceOrDebugOn) {
                this.traceOrDebugWarn(traceOn, "FaultHandler executing impl: " + this.getClass().getName());
            }
            try {
                synCtx.getServiceLog().info((Object)("FaultHandler executing impl: " + this.getClass().getName()));
                this.onFault(synCtx);
            }
            catch (SynapseException e) {
                Stack faultStack = synCtx.getFaultStack();
                if (faultStack == null || faultStack.isEmpty()) break block3;
                ((FaultHandler)faultStack.pop()).handleFault(synCtx);
            }
        }
    }

    public void handleFault(MessageContext synCtx, Exception e) {
        block3: {
            boolean traceOn = synCtx.getTracingState() == 1;
            boolean traceOrDebugOn = traceOn || log.isDebugEnabled();
            synCtx.setProperty("ERROR_CODE", "00000");
            synCtx.setProperty("ERROR_MESSAGE", e.getMessage().split("\n")[0]);
            synCtx.setProperty("ERROR_DETAIL", FaultHandler.getStackTrace(e));
            synCtx.setProperty("ERROR_EXCEPTION", e);
            if (traceOrDebugOn) {
                this.traceOrDebugWarn(traceOn, "Fault handler - setting ERROR_MESSAGE : " + synCtx.getProperty("ERROR_MESSAGE"));
                this.traceOrDebugWarn(traceOn, "Fault handler - setting ERROR_DETAIL : " + synCtx.getProperty("ERROR_DETAIL"));
                this.traceOrDebugWarn(traceOn, "Fault handler - setting ERROR_EXCEPTION : " + synCtx.getProperty("ERROR_EXCEPTION"));
            }
            synCtx.getServiceLog().warn((Object)("Fault handler - setting ERROR_MESSAGE : " + synCtx.getProperty("ERROR_MESSAGE")));
            try {
                this.onFault(synCtx);
            }
            catch (SynapseException se) {
                Stack faultStack = synCtx.getFaultStack();
                if (faultStack == null || faultStack.isEmpty()) break block3;
                ((FaultHandler)faultStack.pop()).handleFault(synCtx, se);
            }
        }
    }

    public abstract void onFault(MessageContext var1);

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    private void traceOrDebugWarn(boolean traceOn, String msg) {
        if (traceOn) {
            trace.warn((Object)msg);
        }
        log.warn((Object)msg);
    }
}

