/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;

public class Choose
extends Instruction {
    private Expression[] conditions;
    private Expression[] actions;

    public Choose(Expression[] expressionArray, Expression[] expressionArray2) {
        int n;
        this.conditions = expressionArray;
        this.actions = expressionArray2;
        for (n = 0; n < expressionArray.length; ++n) {
            this.adoptChildExpression(expressionArray[n]);
        }
        for (n = 0; n < expressionArray2.length; ++n) {
            this.adoptChildExpression(expressionArray2[n]);
        }
    }

    public int getInstructionNameCode() {
        return this.conditions.length == 1 ? 150 : 135;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        int n;
        for (n = 0; n < this.conditions.length; ++n) {
            this.conditions[n] = this.conditions[n].simplify(staticContext);
        }
        for (n = 0; n < this.actions.length; ++n) {
            this.actions[n] = this.actions[n].simplify(staticContext);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        int n;
        for (n = 0; n < this.conditions.length; ++n) {
            this.conditions[n] = this.conditions[n].typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.conditions[n]);
            XPathException xPathException = TypeChecker.ebvError(this.conditions[n], staticContext.getConfiguration().getTypeHierarchy());
            if (xPathException == null) continue;
            xPathException.setLocator(this.conditions[n]);
            throw xPathException;
        }
        for (n = 0; n < this.actions.length; ++n) {
            this.actions[n] = this.actions[n].typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.actions[n]);
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        int n;
        for (n = 0; n < this.conditions.length; ++n) {
            Expression[] expressionArray;
            Expression[] expressionArray2;
            boolean bl;
            this.conditions[n] = this.conditions[n].optimize(optimizer, staticContext, itemType);
            if (!(this.conditions[n] instanceof Literal)) continue;
            try {
                bl = ((Literal)this.conditions[n]).getValue().effectiveBooleanValue();
            }
            catch (XPathException xPathException) {
                xPathException.setLocator(this);
                throw xPathException;
            }
            if (bl) {
                if (n == 0) {
                    Expression.setParentExpression(this.actions[0], this.getParentExpression());
                    return this.actions[0];
                }
                if (n == this.conditions.length - 1) continue;
                expressionArray2 = new Expression[n + 1];
                expressionArray = new Expression[n + 1];
                System.arraycopy(this.conditions, 0, expressionArray2, 0, n + 1);
                System.arraycopy(this.actions, 0, expressionArray, 0, n + 1);
                this.conditions = expressionArray2;
                this.actions = expressionArray;
                break;
            }
            expressionArray2 = new Expression[this.conditions.length - 1];
            expressionArray = new Expression[this.conditions.length - 1];
            System.arraycopy(this.conditions, 0, expressionArray2, 0, n);
            System.arraycopy(this.actions, 0, expressionArray, 0, n);
            System.arraycopy(this.conditions, n + 1, expressionArray2, n, this.conditions.length - n - 1);
            System.arraycopy(this.actions, n + 1, expressionArray, n, this.conditions.length - n - 1);
            this.conditions = expressionArray2;
            this.actions = expressionArray;
            --n;
        }
        for (n = 0; n < this.actions.length; ++n) {
            this.actions[n] = this.actions[n].optimize(optimizer, staticContext, itemType);
        }
        if (this.actions.length == 0) {
            return Literal.makeLiteral(EmptySequence.getInstance());
        }
        return this;
    }

    public int getImplementationMethod() {
        return 6;
    }

    public int markTailFunctionCalls(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.actions.length; ++i) {
            n3 = Math.max(n3, this.actions[i].markTailFunctionCalls(n, n2));
        }
        return n3;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        ItemType itemType = this.actions[0].getItemType(typeHierarchy);
        for (int i = 1; i < this.actions.length; ++i) {
            itemType = Type.getCommonSuperType(itemType, this.actions[i].getItemType(typeHierarchy), typeHierarchy);
        }
        return itemType;
    }

    public int computeCardinality() {
        int n = 0;
        for (int i = 0; i < this.actions.length; ++i) {
            n = Cardinality.union(n, this.actions[i].getCardinality());
        }
        return n;
    }

    public final boolean createsNewNodes() {
        for (int i = 0; i < this.actions.length; ++i) {
            int n = this.actions[i].getSpecialProperties();
            if ((n & 0x400000) != 0) continue;
            return true;
        }
        return false;
    }

    public Iterator iterateSubExpressions() {
        int n;
        ArrayList<Expression> arrayList = new ArrayList<Expression>(this.conditions.length + this.actions.length);
        for (n = 0; n < this.conditions.length; ++n) {
            arrayList.add(this.conditions[n]);
        }
        for (n = 0; n < this.actions.length; ++n) {
            arrayList.add(this.actions[n]);
        }
        return arrayList.iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        int n;
        boolean bl = false;
        for (n = 0; n < this.conditions.length; ++n) {
            if (this.conditions[n] != expression) continue;
            this.conditions[n] = expression2;
            bl = true;
        }
        for (n = 0; n < this.actions.length; ++n) {
            if (this.actions[n] != expression) continue;
            this.actions[n] = expression2;
            bl = true;
        }
        return bl;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (promotionOffer.action == 13 || promotionOffer.action == 12 || promotionOffer.action == 14) {
            int n;
            for (n = 0; n < this.conditions.length; ++n) {
                this.conditions[n] = this.doPromotion(this.conditions[n], promotionOffer);
            }
            for (n = 0; n < this.actions.length; ++n) {
                this.actions[n] = this.doPromotion(this.actions[n], promotionOffer);
            }
        } else {
            this.conditions[0] = this.doPromotion(this.conditions[0], promotionOffer);
        }
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].checkPermittedContents(schemaType, staticContext, bl);
        }
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        for (int i = 0; i < this.conditions.length; ++i) {
            printStream.println(ExpressionTool.indent(n) + (i == 0 ? "if" : "else if"));
            this.conditions[i].display(n + 1, printStream, configuration);
            printStream.println(ExpressionTool.indent(n) + "then");
            this.actions[i].display(n + 1, printStream, configuration);
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean bl;
            try {
                bl = this.conditions[i].effectiveBooleanValue(xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    if (this.conditions[i] instanceof SourceLocator) {
                        xPathException.setLocator(this.conditions[i]);
                    } else {
                        xPathException.setLocator(this);
                    }
                }
                throw xPathException;
            }
            if (!bl) continue;
            if (this.actions[i] instanceof TailCallReturner) {
                return ((TailCallReturner)((Object)this.actions[i])).processLeavingTail(xPathContext);
            }
            this.actions[i].process(xPathContext);
            return null;
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean bl;
            try {
                bl = this.conditions[i].effectiveBooleanValue(xPathContext);
            }
            catch (XPathException xPathException) {
                xPathException.setLocator(this);
                throw xPathException;
            }
            if (!bl) continue;
            return this.actions[i].evaluateItem(xPathContext);
        }
        return null;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean bl;
            try {
                bl = this.conditions[i].effectiveBooleanValue(xPathContext);
            }
            catch (XPathException xPathException) {
                xPathException.setLocator(this);
                throw xPathException;
            }
            if (!bl) continue;
            return this.actions[i].iterate(xPathContext);
        }
        return EmptyIterator.getInstance();
    }
}

