<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->
## Change Log
### 1.3.2
**Fixes**
- [#16928](https://github.com/apache/superset/pull/16928) fix: handle mixed time-series error (@yougyoung94)
- [#16955](https://github.com/apache/superset/pull/16955) fix: don't log invalid redirect URL sent by user (@dpgaspar)
- [#16953](https://github.com/apache/superset/pull/16953) fix(examples): incorrect covid row component id (@villebro)
- [#16949](https://github.com/apache/superset/pull/16949) fix(explore): Ensuring parameters key is included (@craig-rueda)
- [#16933](https://github.com/apache/superset/pull/16933) fix(dashboard): recursive parent on dashboard components (@villebro)
- [#16893](https://github.com/apache/superset/pull/16893) fix: Clear native filters state (@simcha90)

### 1.3.1
**Features**
- [#16711](https://github.com/apache/superset/pull/16711) feat(jinja): improve url parameter formatting (@villebro)
- [#14955](https://github.com/apache/superset/pull/14955) feat: show build number value in the About if present in the config (@cccs-joel)
- [#16594](https://github.com/apache/superset/pull/16594) feat: Experimental cross-filter plugins (@simcha90)
- [#16416](https://github.com/apache/superset/pull/16416) feat: add Shillelagh DB engine spec (@betodealmeida)
- [#16167](https://github.com/apache/superset/pull/16167) feat: Adding Rockset db engine spec (@srinify)

**Fixes**
- [#16776](https://github.com/apache/superset/pull/16776) fix(dataset): retain is_dttm if set on metadata sync (@villebro)
- [#16716](https://github.com/apache/superset/pull/16716) fix(pandas-postprocessing): percentage compare to use correct column (@villebro)
- [#16692](https://github.com/apache/superset/pull/16692) fix: catch exception when create connection (@zhaoyongjie)
- [#16699](https://github.com/apache/superset/pull/16699) fix(explore): only refresh data panel on relevant changes (@villebro)
- [#16687](https://github.com/apache/superset/pull/16687) fix: don't send invalid URLs back to the user (@dpgaspar)
- [#16662](https://github.com/apache/superset/pull/16662) fix: fix assignment in FilterBoxViz (@tianhe1986)
- [#16634](https://github.com/apache/superset/pull/16634) fix(sqla): support for date adhoc filter (@villebro)
- [#16536](https://github.com/apache/superset/pull/16536) fix: params in sql lab are jumpy in the ace editor (@eschutho)
- [#16614](https://github.com/apache/superset/pull/16614) fix: TemporalWrapperType string representation (@villebro)
- [#16452](https://github.com/apache/superset/pull/16452) fix: queryEditor bug (@AAfghahi)
- [#16374](https://github.com/apache/superset/pull/16374) fix: update table ID in query context on chart import (@betodealmeida)
- [#16289](https://github.com/apache/superset/pull/16289) fix: improve pivot post-processing (@betodealmeida)
- [#16262](https://github.com/apache/superset/pull/16262) fix: pivot col names in post_process (@betodealmeida)
- [#16592](https://github.com/apache/superset/pull/16592) fix: Remove export CSV in old filter box (@duynguyenhoang)
- [#16573](https://github.com/apache/superset/pull/16573) fix: impersonate user label/tooltip (@betodealmeida)
- [#16412](https://github.com/apache/superset/pull/16412) fix: Support Jinja template functions in global async queries (@robdiciuccio)
- [#16482](https://github.com/apache/superset/pull/16482) fix: can't drop column when name overlap (@zhaoyongjie)
- [#16526](https://github.com/apache/superset/pull/16526) fix: Set correct comparison operator for snowflake-sqlalchemy pinning (@danielewood)
- [#16372](https://github.com/apache/superset/pull/16372) fix: ensure setting operator to `None` (#16371) (@grumpy-miner)
- [#16515](https://github.com/apache/superset/pull/16515) fix: Pin snowflake-sqlalchemy to 1.2.4 (@danielewood)
- [#16468](https://github.com/apache/superset/pull/16468) fix(native-filters): handle undefined control value gracefully (@villebro)
- [#16464](https://github.com/apache/superset/pull/16464) fix: prevent page crash when chart can't render (@zhaoyongjie)
- [#16460](https://github.com/apache/superset/pull/16460) fix(native-filters): handle null values in value filter (@villebro)
- [#16299](https://github.com/apache/superset/pull/16299) fix: copy to Clipboard order (@AAfghahi)
- [#16369](https://github.com/apache/superset/pull/16369) fix: call external metadata endpoint with correct rison object (@villebro)
- [#16293](https://github.com/apache/superset/pull/16293) fix(sqlite): week grain refer to day of week (@villebro)

**Others**
- [#16702](https://github.com/apache/superset/pull/16702) perf(dashboard): native filter select will be stuck if there has a filter box. (@stephenLYZ)
- [#16648](https://github.com/apache/superset/pull/16648) chore: Bump Flask-OpenID to 1.3.0 (@dpgaspar)
- [#16193](https://github.com/apache/superset/pull/16193) refactor: external metadata fetch API (@zhaoyongjie)

### 1.3.0 (Fri Aug 13 20:41:03 2021 -0700)
**Database Migrations**
- [#16160](https://github.com/apache/superset/pull/16160) feat: change query predicate to text (@eschutho)
- [#16077](https://github.com/apache/superset/pull/16077) fix: ensure that users viewing chart does not automatically save edit data (@pkdotson)
- [#16098](https://github.com/apache/superset/pull/16098) fix: migrate_roles (@betodealmeida)
- [#16078](https://github.com/apache/superset/pull/16078) chore: simplify chart permissions (@betodealmeida)
- [#16045](https://github.com/apache/superset/pull/16045) feat(explore): add automatic conditional formatter to pivot table v2 (@villebro)
- [#16038](https://github.com/apache/superset/pull/16038) fix: handle schemas_allowed_for_csv_upload serde (@betodealmeida)
- [#15909](https://github.com/apache/superset/pull/15909) fix: Ensure table uniqueness on update (@john-bodley)
- [#15747](https://github.com/apache/superset/pull/15747) feat: migration to add timezone to report schedule (@eschutho)
- [#15824](https://github.com/apache/superset/pull/15824) feat: store query context when saving charts (@betodealmeida)
- [#15822](https://github.com/apache/superset/pull/15822) fix: benchmark_migration.py needs to close sssion (@betodealmeida)
- [#15807](https://github.com/apache/superset/pull/15807) fix: migration script can't drop constraint (@betodealmeida)
- [#15791](https://github.com/apache/superset/pull/15791) fix: migration downgrade references wrong column (@betodealmeida)
- [#15725](https://github.com/apache/superset/pull/15725) fix: change to alerts_reports (@AAfghahi)
- [#15683](https://github.com/apache/superset/pull/15683) feat: add Column to reports model (@AAfghahi)
- [#15507](https://github.com/apache/superset/pull/15507) chore(python-testing): move memoized tests to unit tests (@amitmiran137)
- [#15032](https://github.com/apache/superset/pull/15032) fix: benchmark migration script (@betodealmeida)
- [#14433](https://github.com/apache/superset/pull/14433) feat: Adding configuration_method column to Database Model (@AAfghahi)

**Features**
- [#16199](https://github.com/apache/superset/pull/16199) feat: Changing Dataset names (@AAfghahi)
- [#16183](https://github.com/apache/superset/pull/16183) feat: update covid dashboard (@eschutho)
- [#16178](https://github.com/apache/superset/pull/16178) feat: CLI cleanup  (@AAfghahi)
- [#16170](https://github.com/apache/superset/pull/16170) feat: Added multi-regional IPs to Database Connections (@AAfghahi)
- [#16158](https://github.com/apache/superset/pull/16158) feat: add chart image info to reports from charts (@eschutho)
- [#16139](https://github.com/apache/superset/pull/16139) feat(cross-filters): add support for temporal filters (@villebro)
- [#16156](https://github.com/apache/superset/pull/16156) feat: add config to hide some user menu items (@eschutho)
- [#16102](https://github.com/apache/superset/pull/16102) feat: add sticky state to tables and loadingcards state. (@pkdotson)
- [#16131](https://github.com/apache/superset/pull/16131) feat: better errors for report in charts and dashboard (@AAfghahi)
- [#16095](https://github.com/apache/superset/pull/16095) feat: added google alert to DB Connection Form (@AAfghahi)
- [#16052](https://github.com/apache/superset/pull/16052) feat: handle subtle bug with load-examples (@betodealmeida)
- [#16027](https://github.com/apache/superset/pull/16027) feat: Self subscribe reports (@eschutho)
- [#15887](https://github.com/apache/superset/pull/15887) feat: auto sync table columns when change dataset (@zhaoyongjie)
- [#15953](https://github.com/apache/superset/pull/15953) feat: send post-processed data in reports (@betodealmeida)
- [#15853](https://github.com/apache/superset/pull/15853) feat(homepage): add more cards and new layout (@pkdotson)
- [#15879](https://github.com/apache/superset/pull/15879) feat: post-processing for pivot table v2 (@betodealmeida)
- [#15806](https://github.com/apache/superset/pull/15806) feat: send report data to Slack (@betodealmeida)
- [#15801](https://github.com/apache/superset/pull/15801) feat(dbc ui): Adding Google Sheets Dynamic Form (@hughhhh)
- [#15920](https://github.com/apache/superset/pull/15920) feat: add timezone selector to alerts and reports (@eschutho)
- [#15805](https://github.com/apache/superset/pull/15805) feat: send data embedded in report email (@betodealmeida)
- [#15279](https://github.com/apache/superset/pull/15279) feat: run extra query on QueryObject and add compare operator for post_processing (@zhaoyongjie)
- [#15849](https://github.com/apache/superset/pull/15849) feat: add timezones to report cron (@eschutho)
- [#15846](https://github.com/apache/superset/pull/15846) feat: call screenshot to store `query_context` (@betodealmeida)
- [#15864](https://github.com/apache/superset/pull/15864) feat(explore): new datasets have autocomplete filters enabled if UX_BETA is set (@kgabryje)
- [#15843](https://github.com/apache/superset/pull/15843) feat: apply post processing to chart data (@betodealmeida)
- [#15880](https://github.com/apache/superset/pull/15880) feat: add timezone selector component (@eschutho)
- [#15882](https://github.com/apache/superset/pull/15882) feat: deprecate plugins by their metadata (@suddjian)
- [#15792](https://github.com/apache/superset/pull/15792) feat(homepage): conditionally render viewed tab and move examples to chart and dashboard table (@pkdotson)
- [#15798](https://github.com/apache/superset/pull/15798) feat(explore): default aggregate for string/numeric columns when creating metric (@kgabryje)
- [#15830](https://github.com/apache/superset/pull/15830) feat: use new API endpoint to build CSV reports (@betodealmeida)
- [#15827](https://github.com/apache/superset/pull/15827) feat: add `GET /api/v1/chart/{chart_id}/data/?format{format}` API (@betodealmeida)
- [#15719](https://github.com/apache/superset/pull/15719) feat: adding Progress Bar to Benchmark script (@AAfghahi)
- [#15712](https://github.com/apache/superset/pull/15712) feat: add show columns to Reports model (@AAfghahi)
- [#15740](https://github.com/apache/superset/pull/15740) feat(explore): UX improvements for drag'n'dropping time column (@kgabryje)
- [#15685](https://github.com/apache/superset/pull/15685) feat: add logic to creation_method for reports schedule (@AAfghahi)
- [#15711](https://github.com/apache/superset/pull/15711) feat(homepage): move savequeries table and render open conditionally (@pkdotson)
- [#15628](https://github.com/apache/superset/pull/15628) feat(menu): expand support for custom branding (@nytai)
- [#15403](https://github.com/apache/superset/pull/15403) feat: cancel db query on stop (@koszti)
- [#15651](https://github.com/apache/superset/pull/15651) feat(explore): Implement conditional formatting component (@kgabryje)
- [#15303](https://github.com/apache/superset/pull/15303) feat(explore): Upgraded viz select gallery (@suddjian)
- [#15578](https://github.com/apache/superset/pull/15578) feat: validate_parameters for GSheets (@betodealmeida)
- [#15502](https://github.com/apache/superset/pull/15502) feat: supporting jinja templating in saved metrics  (@guydou)
- [#15500](https://github.com/apache/superset/pull/15500) feat(cross-filters): add option to clear set cross filters (@villebro)
- [#14775](https://github.com/apache/superset/pull/14775) feat: extra table metadata for Google Sheets (@betodealmeida)
- [#14881](https://github.com/apache/superset/pull/14881) feat: Database Connection UI  (@hughhhh)
- [#15419](https://github.com/apache/superset/pull/15419) feat(native-filters): add null option to value filter (@mironovmeow)
- [#15273](https://github.com/apache/superset/pull/15273) feat: update ingress api version to v1 (@mvoitko)
- [#15454](https://github.com/apache/superset/pull/15454) feat(dashboard-groupby): group by - add ability to exclude columns (@einatbar)
- [#15482](https://github.com/apache/superset/pull/15482) feat: more SIP-40 errors (@betodealmeida)
- [#15475](https://github.com/apache/superset/pull/15475) feat(add IBM Netezza support): documentation changes for Netezza (@abhishekjog)
- [#15450](https://github.com/apache/superset/pull/15450) feat(add Netezza database): Add IBM Netezza support (@abhishekjog)
- [#15177](https://github.com/apache/superset/pull/15177) feat(trino): add support for query cost estimate #15166 (@rijojoseph07)
- [#15426](https://github.com/apache/superset/pull/15426) feat: add env vars from multiple secrets in Helm chart (@mvoitko)
- [#15436](https://github.com/apache/superset/pull/15436) feat: add more SIP-40 errors to SQL Lab (@betodealmeida)
- [#15432](https://github.com/apache/superset/pull/15432) feat: Better Errors in SQL Lab (@AAfghahi)
- [#15427](https://github.com/apache/superset/pull/15427) feat(native-filters): add support for preselect filters (@villebro)
- [#15409](https://github.com/apache/superset/pull/15409) feat: more SIP-40 error messages for SQL Lab (@betodealmeida)
- [#15153](https://github.com/apache/superset/pull/15153) feat: Adding a show all button to the column/metrics list in the explore view (Allow more than 50 columns to be shown) (@cccs-RyanS)
- [#15385](https://github.com/apache/superset/pull/15385) feat(native-filters): Hide non-numeric columns in numeric range filter (@kgabryje)
- [#15340](https://github.com/apache/superset/pull/15340) feat: add possibility to specify Service Account name for the Deployment in the Helm chart (@mvoitko)
- [#15342](https://github.com/apache/superset/pull/15342) feat: custom error SQL Lab timeout (@betodealmeida)
- [#15302](https://github.com/apache/superset/pull/15302) feat(native-filters): Set default scope by filters' and charts' datasets  (@kgabryje)
- [#15206](https://github.com/apache/superset/pull/15206) feat: implement specific errors for SQL Lab (@betodealmeida)
- [#15270](https://github.com/apache/superset/pull/15270) feat(editable-title): move cursor and scroll to the end (@stephenLYZ)
- [#15157](https://github.com/apache/superset/pull/15157) feat: Synchronously return cached charts (@benjreinhart)
- [#15276](https://github.com/apache/superset/pull/15276) feat(native-filters): Show/Highlight errored/focused status (@simcha90)
- [#15253](https://github.com/apache/superset/pull/15253) feat(native-filters): add support for import/export dashboard (@villebro)
- [#15247](https://github.com/apache/superset/pull/15247) feat(sql): add jinja support to metrics and expressions (@villebro)
- [#14682](https://github.com/apache/superset/pull/14682) feat(db_engine_specs): Add quirks to support Ascend.io/HiveServer2 with Impala driver. (@danielewood)
- [#15225](https://github.com/apache/superset/pull/15225) feat(native-filters): Hide time filters if loaded datasets don't have temporal columns (@kgabryje)
- [#15222](https://github.com/apache/superset/pull/15222) feat(native-filters): Disable Apply button if filter required (@simcha90)
- [#15158](https://github.com/apache/superset/pull/15158) feat: show rich error messages on past failed queries (@betodealmeida)
- [#15121](https://github.com/apache/superset/pull/15121) feat: Select component (Iteration 1) (@geido)
- [#15188](https://github.com/apache/superset/pull/15188) feat(api): add featured datatypes to dashboard dataset ep (@villebro)
- [#14703](https://github.com/apache/superset/pull/14703) feat(helm): Make local admin optional (@danielewood)
- [#15117](https://github.com/apache/superset/pull/15117) feat(native-filters): add optional time col to time range (@villebro)
- [#15105](https://github.com/apache/superset/pull/15105) feat(webpack): configure publicPath via ASSET_BASE_URL env var (@nytai)
- [#14872](https://github.com/apache/superset/pull/14872) feat(Explore): add sort to edit dataset modal (@pkdotson)
- [#15046](https://github.com/apache/superset/pull/15046) feat(dashboard): Let users download full CSV of a table (@m-ajay)
- [#15107](https://github.com/apache/superset/pull/15107) feat: show spinner on exports (@betodealmeida)
- [#15120](https://github.com/apache/superset/pull/15120) feat(native-filters): Defer loading filters data until filter is visible (@kgabryje)
- [#15063](https://github.com/apache/superset/pull/15063) feat(native-filters): Hide filters which don't affect any visible charts (@kgabryje)
- [#15055](https://github.com/apache/superset/pull/15055) feat: spinner for imports (@betodealmeida)
- [#15057](https://github.com/apache/superset/pull/15057) feat: style import button (@betodealmeida)
- [#14868](https://github.com/apache/superset/pull/14868) feat: add more timeout configuration on screenshots (@dpgaspar)
- [#14921](https://github.com/apache/superset/pull/14921) feat(filter-box): hide druid options if druid not enabled (@villebro)
- [#14869](https://github.com/apache/superset/pull/14869) feat(native-filters): Support default to first value in select filter (@simcha90)
- [#14981](https://github.com/apache/superset/pull/14981) feat(native-filters): add markers and number formatter to range filter (@villebro)
- [#14966](https://github.com/apache/superset/pull/14966) feat(native-filters): apply cascading without instant filtering (@villebro)
- [#14863](https://github.com/apache/superset/pull/14863) feat: add type_generic and is_dttm to table metadata (@zhaoyongjie)
- [#14934](https://github.com/apache/superset/pull/14934) feat: Adding FORCE_SSL as feature flag in config.py (@AAfghahi)
- [#14933](https://github.com/apache/superset/pull/14933) feat(dashboard/native-filters): Hide filters out of scope of current tab (@kgabryje)
- [#14818](https://github.com/apache/superset/pull/14818) feat: Icon Button (@lyndsiWilliams)
- [#14832](https://github.com/apache/superset/pull/14832) feat: validation db modal (@eschutho)
- [#14765](https://github.com/apache/superset/pull/14765) feat: add support for filters in sqlLab (@cccs-jc)
- [#14784](https://github.com/apache/superset/pull/14784) feat(native-filter): Hide native filters (@simcha90)
- [#14843](https://github.com/apache/superset/pull/14843) feat(trino): add support for user impersonation (@rijojoseph07)
- [#14865](https://github.com/apache/superset/pull/14865) feat(dashboard): Highlight tabs that contain a chart in scope of focused native filter (@kgabryje)
- [#14873](https://github.com/apache/superset/pull/14873) feat(native-filters): improve inverse selection indicators (@villebro)
- [#14883](https://github.com/apache/superset/pull/14883) feat: validate database parameters (@betodealmeida)
- [#14842](https://github.com/apache/superset/pull/14842) feat(native-filters): sort selected values on blur (@villebro)
- [#14486](https://github.com/apache/superset/pull/14486) feat(native-filter): limit max tag count for selected filter values (@einatbar)
- [#14686](https://github.com/apache/superset/pull/14686) feat: ability to pull from your own docker registry using a secret (@jmistry)
- [#14803](https://github.com/apache/superset/pull/14803) feat: return parameters only for DB with default driver (@betodealmeida)
- [#14484](https://github.com/apache/superset/pull/14484) feat: chart gallery search improvement (@einatbar)
- [#14661](https://github.com/apache/superset/pull/14661) feat(explore): Remove default for time range filter and Metrics (@kgabryje)
- [#14710](https://github.com/apache/superset/pull/14710) feat(native-filters): add search all filter options (@villebro)
- [#14721](https://github.com/apache/superset/pull/14721) feat: Create BigQuery Parameters for DatabaseModal (@hughhhh)
- [#14767](https://github.com/apache/superset/pull/14767) feat: enable user impersonation in GSheets (@betodealmeida)
- [#14583](https://github.com/apache/superset/pull/14583) feat: save database with new dynamic form (@eschutho)
- [#14695](https://github.com/apache/superset/pull/14695) feat: make tabs sticky in homepage (@pkdotson)
- [#14507](https://github.com/apache/superset/pull/14507) feat: Add a remove_filter flag to the jinja filter_values function and add a new get_filters function (see issue 13943 for more details) (@cccs-jc)
- [#14693](https://github.com/apache/superset/pull/14693) feat(native-filters): Highlight charts affected by focused native filter (@kgabryje)
- [#14530](https://github.com/apache/superset/pull/14530) feat: Labeled Error-bound Input (@lyndsiWilliams)
- [#14652](https://github.com/apache/superset/pull/14652) feat: Add `make update` cmd (@hughhhh)
- [#14724](https://github.com/apache/superset/pull/14724) feat: do not redirect on 404/500 (@betodealmeida)
- [#14647](https://github.com/apache/superset/pull/14647) feat: Add headers for DatabaseModal (@hughhhh)
- [#14680](https://github.com/apache/superset/pull/14680) feat: Expanded Parameters for Mysql (@AAfghahi)
- [#14653](https://github.com/apache/superset/pull/14653) feat: Add Parameters fields to GET Database (@hughhhh)
- [#14677](https://github.com/apache/superset/pull/14677) feat: redirect 404/500 to static pages (@betodealmeida)
- [#14675](https://github.com/apache/superset/pull/14675) feat: redirect to /login when CSRF expired (@betodealmeida)
- [#14667](https://github.com/apache/superset/pull/14667) feat(dashboard): View query of the chart in dashboard (@m-ajay)
- [#14381](https://github.com/apache/superset/pull/14381) feat: Better return messages in SQL Editor (@AAfghahi)
- [#14673](https://github.com/apache/superset/pull/14673) feat: add SSL to new DB parameters (@betodealmeida)
- [#14668](https://github.com/apache/superset/pull/14668) feat: make config method optional (@AAfghahi)
- [#14451](https://github.com/apache/superset/pull/14451) feat: Configuration Method and expanded parameters for Database Model (@AAfghahi)
- [#14560](https://github.com/apache/superset/pull/14560) feat: bumping echarts plugin, adding new treemap plugin (@rusackas)
- [#14547](https://github.com/apache/superset/pull/14547) feat: add generic type to column payload (@villebro)
- [#14420](https://github.com/apache/superset/pull/14420) feat: API endpoint to validate databases using separate parameters (@betodealmeida)
- [#14527](https://github.com/apache/superset/pull/14527) feat(alert&report):  set image width for email (@lilykuang)
- [#14514](https://github.com/apache/superset/pull/14514) feat: Containerize WebSocket server (@benjreinhart)
- [#14493](https://github.com/apache/superset/pull/14493) feat(explore): collapse time section if no ts columns (@villebro)
- [#14516](https://github.com/apache/superset/pull/14516) feat(viz): new tree chart (@mayurnewase)
- [#14491](https://github.com/apache/superset/pull/14491) feat: add `make format` command (@hughhhh)
- [#14470](https://github.com/apache/superset/pull/14470) feat: db modal split (@eschutho)
- [#14480](https://github.com/apache/superset/pull/14480) feat(viz): add funnel chart (@villebro)

**Fixes**
- [#16260](https://github.com/apache/superset/pull/16260) fix: check roles before fetching reports (@eschutho)
- [#16259](https://github.com/apache/superset/pull/16259) fix: pivot columns with ints for name (@betodealmeida)
- [#16253](https://github.com/apache/superset/pull/16253) fix: Homepage dashboard examples tab does not show user created objects (@pkdotson)
- [#16233](https://github.com/apache/superset/pull/16233) fix(dashboard): cross filter chart highlight when filters badge icon clicked (@kgabryje)
- [#16241](https://github.com/apache/superset/pull/16241) fix: validate_parameters and query (@betodealmeida)
- [#16240](https://github.com/apache/superset/pull/16240) fix: Remove Advanced Analytics tag for 2 charts (@rusackas)
- [#16214](https://github.com/apache/superset/pull/16214) fix: remove encryption from db params (@eschutho)
- [#16230](https://github.com/apache/superset/pull/16230) fix(explore): conditional formatting value validators (@kgabryje)
- [#16212](https://github.com/apache/superset/pull/16212) fix: example tabs filter (@pkdotson)
- [#16208](https://github.com/apache/superset/pull/16208) fix: sorting on "Modified By" in chart table (@pkdotson)
- [#16196](https://github.com/apache/superset/pull/16196) fix(explore): adhoc metrics popover resets label after hovering outside (@kgabryje)
- [#16190](https://github.com/apache/superset/pull/16190) fix(explore): metric label disappearing in some scenarios (@kgabryje)
- [#16171](https://github.com/apache/superset/pull/16171) fix: change listivew card layouts to the new homepage card layout (@pkdotson)
- [#16176](https://github.com/apache/superset/pull/16176) fix: ensure created user entities do not show inside examples (@pkdotson)
- [#16175](https://github.com/apache/superset/pull/16175) fix: isDynamic function (@betodealmeida)
- [#16162](https://github.com/apache/superset/pull/16162) fix: revert data endpoint name (@betodealmeida)
- [#16151](https://github.com/apache/superset/pull/16151) fix:  turn on SSL in database edit form show 500 error (@hughhhh)
- [#16089](https://github.com/apache/superset/pull/16089) fix: Safari is not showing scroll bars in Explore (@michael-s-molina)
- [#16094](https://github.com/apache/superset/pull/16094) fix: Multiple dashboard refresh triggers for the same session (@michael-s-molina)
- [#16107](https://github.com/apache/superset/pull/16107) fix: boolean type into SQL 'in' operator (@zhaoyongjie)
- [#16053](https://github.com/apache/superset/pull/16053) fix(dashboard): 500 error caused by data_for_slices API (@ktmud)
- [#16161](https://github.com/apache/superset/pull/16161) fix: Big Query additional parameters field doesn't keep value (@lyndsiWilliams)
- [#16118](https://github.com/apache/superset/pull/16118) fix: change Alert Permissions (@AAfghahi)
- [#16088](https://github.com/apache/superset/pull/16088) fix(explore): dnd error when dragging metric if multi: false (@kgabryje)
- [#16092](https://github.com/apache/superset/pull/16092) fix(Explore): Adjust width of cell in Time-Series Table chart (@geido)
- [#16132](https://github.com/apache/superset/pull/16132) fix: virtual dataset wont work (@zhaoyongjie)
- [#16115](https://github.com/apache/superset/pull/16115) fix(explore): revert dnd column dependency array change to fix infinite rerenders (@kgabryje)
- [#16097](https://github.com/apache/superset/pull/16097) fix: move watermark to about section (@nytai)
- [#16073](https://github.com/apache/superset/pull/16073) fix(explore): drag & drop column select component triggering onChange unnecessarily (@suddjian)
- [#15592](https://github.com/apache/superset/pull/15592) fix(dashboard): user id can be null when there is an anonymous user (@suddjian)
- [#16091](https://github.com/apache/superset/pull/16091) fix: load tabbed dash only for tests (@betodealmeida)
- [#16093](https://github.com/apache/superset/pull/16093) fix: Calendar color change (@AAfghahi)
- [#16054](https://github.com/apache/superset/pull/16054) fix: Remove grey bar for TableElement component when `metadata` is empty (@hughhhh)
- [#16065](https://github.com/apache/superset/pull/16065) fix: Adding report bug (@AAfghahi)
- [#16061](https://github.com/apache/superset/pull/16061) fix(native-filters): add support for boolean cols to select (@villebro)
- [#16062](https://github.com/apache/superset/pull/16062) fix: Fixes the Select unselect for object values (@michael-s-molina)
- [#16042](https://github.com/apache/superset/pull/16042) fix: sync columns in explore page (@zhaoyongjie)
- [#16044](https://github.com/apache/superset/pull/16044) fix: make dataset update methods static instead of global (@etr2460)
- [#16037](https://github.com/apache/superset/pull/16037) fix: DB exported with incorrect type (@betodealmeida)
- [#15954](https://github.com/apache/superset/pull/15954) fix: Fix long dashboards screenshot emails (@hughhhh)
- [#16024](https://github.com/apache/superset/pull/16024) fix(explore): filter popover opening after removing a filter (@kgabryje)
- [#16035](https://github.com/apache/superset/pull/16035) fix: Modal is blinking when opening (@michael-s-molina)
- [#16022](https://github.com/apache/superset/pull/16022) fix: Select the right section when categories and tags have the same name in Viz Gallery (@geido)
- [#16026](https://github.com/apache/superset/pull/16026) fix: missing mulitiple metrics on pivot operator (@zhaoyongjie)
- [#16031](https://github.com/apache/superset/pull/16031) fix: add feature flag to header bar (@eschutho)
- [#16020](https://github.com/apache/superset/pull/16020) fix(explore): fix undefined error when using dnd (@kgabryje)
- [#16017](https://github.com/apache/superset/pull/16017) fix(native-filters): add support for versioned import/export (@villebro)
- [#15971](https://github.com/apache/superset/pull/15971) fix: Sort Metrics by ID DESC (order of creation) in the Datasource Editor (@geido)
- [#15994](https://github.com/apache/superset/pull/15994) fix(explore): highlight Run button correctly when query is stale (@suddjian)
- [#15991](https://github.com/apache/superset/pull/15991) fix: save DB with with query (@betodealmeida)
- [#15975](https://github.com/apache/superset/pull/15975) fix: eliminate cartesian product columns in pivot operator (@zhaoyongjie)
- [#15993](https://github.com/apache/superset/pull/15993) fix(dashboard): FilterBox JS error when datasets API is slow (@ktmud)
- [#15978](https://github.com/apache/superset/pull/15978) fix: three button styles to tertiary (@stellalc7)
- [#15992](https://github.com/apache/superset/pull/15992) fix(sqllab): revert #15891 to fix sqllab delay (@serenajiang)
- [#15986](https://github.com/apache/superset/pull/15986) fix: remove select width (@eschutho)
- [#15985](https://github.com/apache/superset/pull/15985) fix: Dataset field required 2 clicks to select when dashboard was empty (@michael-s-molina)
- [#15981](https://github.com/apache/superset/pull/15981) fix: DB add modal (@betodealmeida)
- [#15925](https://github.com/apache/superset/pull/15925) fix: Cancel alert is not appearing to all native filters modal fields (@michael-s-molina)
- [#15952](https://github.com/apache/superset/pull/15952) fix: Name change is not lost in left side of modal when return to edition after aborting changes (@michael-s-molina)
- [#15946](https://github.com/apache/superset/pull/15946) fix: Drag inner tab to outer tab while editing a dashboard will show an error (@michael-s-molina)
- [#15941](https://github.com/apache/superset/pull/15941) fix(dashboard): Add required message in the tooltip for the time range filter (@geido)
- [#15949](https://github.com/apache/superset/pull/15949) fix: Update gsheets mapping for documentation (@hughhhh)
- [#15933](https://github.com/apache/superset/pull/15933) fix(dashboard): Show the filters popover behind the dashboard header when scrolling (@geido)
- [#15921](https://github.com/apache/superset/pull/15921) fix(dashboard): check dashboard id before calling redux methods (@suddjian)
- [#15918](https://github.com/apache/superset/pull/15918) fix: Keep chosen columns sort option when changing a column (@geido)
- [#14969](https://github.com/apache/superset/pull/14969) fix: remove unused time column when update dataset (@zhaoyongjie)
- [#15891](https://github.com/apache/superset/pull/15891) fix: Select a query from History and Run (@graceguo-supercat)
- [#15585](https://github.com/apache/superset/pull/15585) fix: no roles being returned for anonymous user (@aspedrosa)
- [#15893](https://github.com/apache/superset/pull/15893) fix: dashboard url error when edit slug (@zhaoyongjie)
- [#15813](https://github.com/apache/superset/pull/15813) fix: Incorrect translations in Chinese in messages.po (@chuancyzhang)
- [#15841](https://github.com/apache/superset/pull/15841) fix(Explore): "Customize" tab rendering behavior (@geido)
- [#15890](https://github.com/apache/superset/pull/15890) fix(dashboard): Refresh Native Filters when Dashboard refreshes (@geido)
- [#15865](https://github.com/apache/superset/pull/15865) fix: Update Query Context on Explore loading (@hughhhh)
- [#15896](https://github.com/apache/superset/pull/15896) fix: Charts sort by in edit mode gets cut off (@michael-s-molina)
- [#15897](https://github.com/apache/superset/pull/15897) fix: Download as image of dashboard chart did not work (@michael-s-molina)
- [#15888](https://github.com/apache/superset/pull/15888) fix: Side menu of the dashboard component will scroll out of dashboard (@michael-s-molina)
- [#15889](https://github.com/apache/superset/pull/15889) fix: New time range filter initially show advance section (@michael-s-molina)
- [#15878](https://github.com/apache/superset/pull/15878) fix(15403): Re-enable canceling query for Hive and Presto (@john-bodley)
- [#15874](https://github.com/apache/superset/pull/15874) fix(15482): Propagate SupersetSecurityException error (@john-bodley)
- [#15848](https://github.com/apache/superset/pull/15848) fix: Ensure DatabaseErrorMessage works when extra is undefined (@john-bodley)
- [#15760](https://github.com/apache/superset/pull/15760) fix: Unable to create alerts/report after introduced creation_method (@duynguyenhoang)
- [#15869](https://github.com/apache/superset/pull/15869) fix: revert DEFAULT_SQLLAB_LIMIT to default (@betodealmeida)
- [#15840](https://github.com/apache/superset/pull/15840) fix(explore): show multi queries results in View query modal and data pane (@kgabryje)
- [#15709](https://github.com/apache/superset/pull/15709) fix(dashboard): Remove edit from url params when discarding changes (@geido)
- [#15820](https://github.com/apache/superset/pull/15820) fix: Render value immediately on SQL Editor for Calculated Columns in Edit Dataset modal (@geido)
- [#15817](https://github.com/apache/superset/pull/15817) fix: dataTablesPane cell render undefine when the dot in metric label (@zhaoyongjie)
- [#15803](https://github.com/apache/superset/pull/15803) fix: publish the new example dashboards (@betodealmeida)
- [#15828](https://github.com/apache/superset/pull/15828) fix: Report Schema fix (@AAfghahi)
- [#15821](https://github.com/apache/superset/pull/15821) fix(Explore): Cell height and spacing for Data panel  (@geido)
- [#15786](https://github.com/apache/superset/pull/15786) fix: Bust chart cache when metric/column is changed (@etr2460)
- [#15804](https://github.com/apache/superset/pull/15804) fix: create fk model in benchmark script (@betodealmeida)
- [#15800](https://github.com/apache/superset/pull/15800) fix(dashboard): Add z-index to dashboard only when maximizing chart (@geido)
- [#15778](https://github.com/apache/superset/pull/15778) fix(dashboard): Add resize handles to right and bottom of component (@kgabryje)
- [#15715](https://github.com/apache/superset/pull/15715) fix: margin right on warning icon to 8px (@stellalc7)
- [#15770](https://github.com/apache/superset/pull/15770) fix: Edit physical dataset from the Edit Dataset modal (@geido)
- [#15781](https://github.com/apache/superset/pull/15781) fix(explore): dnd multiple columns doesn't work (@kgabryje)
- [#15752](https://github.com/apache/superset/pull/15752) fix: Revert "quote column name if db requires (#15465)" (@eschutho)
- [#15750](https://github.com/apache/superset/pull/15750) fix: Fixing `schemas_allowed_for_upload` field in database connection UX (@hughhhh)
- [#15710](https://github.com/apache/superset/pull/15710) fix(explore): Set label max width with Drag&Drop in Datasource panel (@geido)
- [#15732](https://github.com/apache/superset/pull/15732) fix(explore): wrong error message in conditional formatting (@kgabryje)
- [#15721](https://github.com/apache/superset/pull/15721) fix: Reduce js bundle size (@etr2460)
- [#15731](https://github.com/apache/superset/pull/15731) fix(explore): DndColumnSelect sometimes not working with multi: false (@kgabryje)
- [#15707](https://github.com/apache/superset/pull/15707) fix: use expected label in metrics map (@zhaoyongjie)
- [#15727](https://github.com/apache/superset/pull/15727) fix: Incorrect translations in the SQLLab in Chinese (@chuancyzhang)
- [#15610](https://github.com/apache/superset/pull/15610) fix: Add waiting time for chart animation when screenshot (@u-aiaa)
- [#15662](https://github.com/apache/superset/pull/15662) fix: Action icons on Antd Card in Homepage (@geido)
- [#15669](https://github.com/apache/superset/pull/15669) fix: no lazy translation on SupersetError (@betodealmeida)
- [#15680](https://github.com/apache/superset/pull/15680) fix: remove form title (@xiezhongfu)
- [#15668](https://github.com/apache/superset/pull/15668) fix(dashboard): Make the View Chart In Explore menu option a link (@suddjian)
- [#15634](https://github.com/apache/superset/pull/15634) fix: Show affected charts when interacting with the filters (@michael-s-molina)
- [#15661](https://github.com/apache/superset/pull/15661) fix(dashboard): Filters panel height (@geido)
- [#15670](https://github.com/apache/superset/pull/15670) fix: small fixes for Makefile (@betodealmeida)
- [#15650](https://github.com/apache/superset/pull/15650) fix: safe removal of empty tab with scoped filters (@rusackas)
- [#15645](https://github.com/apache/superset/pull/15645) fix: Fix test connection for extra fields (@hughhhh)
- [#15642](https://github.com/apache/superset/pull/15642) fix: change sslmode to require for Postgres (@hughhhh)
- [#15635](https://github.com/apache/superset/pull/15635) fix: Remove default values for engine and schemas (@hughhhh)
- [#15614](https://github.com/apache/superset/pull/15614) fix: duplicate DB names (@betodealmeida)
- [#15572](https://github.com/apache/superset/pull/15572) fix(native-filters): Fix required filters (@simcha90)
- [#15590](https://github.com/apache/superset/pull/15590) fix: avoid fetching favorite status for anonymous user (@aspedrosa)
- [#15623](https://github.com/apache/superset/pull/15623) fix: clear errors on closing DB Connection Modal (@AAfghahi)
- [#15620](https://github.com/apache/superset/pull/15620) fix: error page status codes (@etr2460)
- [#15619](https://github.com/apache/superset/pull/15619) fix: Database List Sorted  (@AAfghahi)
- [#15609](https://github.com/apache/superset/pull/15609) fix: update db for expose in sqllab param (@hughhhh)
- [#15612](https://github.com/apache/superset/pull/15612) fix: Database Connection Modal - corrected tooltip alignment and info alert width (@lyndsiWilliams)
- [#15186](https://github.com/apache/superset/pull/15186) fix(dashboard-list): change name of dashboard is not reflected instantly (@stephenLYZ)
- [#15588](https://github.com/apache/superset/pull/15588) fix: Revert "fix(dashboard): Open "View Chart in Explore" in the same window" (@rusackas)
- [#15589](https://github.com/apache/superset/pull/15589) fix: Revert "chore: Bump @svgr/webpack to 5.5.0" (@rusackas)
- [#15594](https://github.com/apache/superset/pull/15594) fix: Hide Dynamic Link when editing (@AAfghahi)
- [#15595](https://github.com/apache/superset/pull/15595) fix: DBC UI tooltip aligment (@hughhhh)
- [#15587](https://github.com/apache/superset/pull/15587) fix: available endpoint showing specs without drivers (@betodealmeida)
- [#15581](https://github.com/apache/superset/pull/15581) fix: downloadasimage for dashboard (@pkdotson)
- [#15558](https://github.com/apache/superset/pull/15558) fix: revert #15405 #15435 #15444 (@betodealmeida)
- [#15546](https://github.com/apache/superset/pull/15546) fix: examples remove app context at the module level (@dpgaspar)
- [#15547](https://github.com/apache/superset/pull/15547) fix: indentation in helm chart (@mvoitko)
- [#15511](https://github.com/apache/superset/pull/15511) fix: variable context (@jeffreykoetsier)
- [#15526](https://github.com/apache/superset/pull/15526) fix: chartlist card-link to 404 (@xiezhongfu)
- [#15506](https://github.com/apache/superset/pull/15506) fix(native-filters): Fix native filters config modal (@simcha90)
- [#15527](https://github.com/apache/superset/pull/15527) fix: base requirements missing deprecation pkg (@dpgaspar)
- [#15534](https://github.com/apache/superset/pull/15534) fix: show all DBs in available endpoint (@betodealmeida)
- [#15465](https://github.com/apache/superset/pull/15465) fix: quote column name if db requires (@eschutho)
- [#15486](https://github.com/apache/superset/pull/15486) fix: Database connection R6 fixes (@lyndsiWilliams)
- [#15519](https://github.com/apache/superset/pull/15519) fix: Utilizing dashboard native filter feature flag (@john-bodley)
- [#15492](https://github.com/apache/superset/pull/15492) fix(sqllab): add new tab when add sql query (@stephenLYZ)
- [#15487](https://github.com/apache/superset/pull/15487) fix: GSheets supports JOINs (@betodealmeida)
- [#15498](https://github.com/apache/superset/pull/15498) fix(native-filters): chartsInScope were not recalculated in some cases (@kgabryje)
- [#15493](https://github.com/apache/superset/pull/15493) fix: skip set and log when use NullCache (@zhaoyongjie)
- [#15430](https://github.com/apache/superset/pull/15430) fix: bump Redis minor version (@mvoitko)
- [#15438](https://github.com/apache/superset/pull/15438) fix(native-filters): Fix clear all button (@simcha90)
- [#15318](https://github.com/apache/superset/pull/15318) fix: nvd3 bar chart sortby metric (@zhaoyongjie)
- [#15353](https://github.com/apache/superset/pull/15353) fix: raise unexpected error when orderby is empty (@zhaoyongjie)
- [#15455](https://github.com/apache/superset/pull/15455) fix(dashboard): native filters highlight with multiple tabs jumps to first tab (@kgabryje)
- [#15448](https://github.com/apache/superset/pull/15448) fix: refactor(feature_flags configurations): revert of "remove redundant addi… (@villebro)
- [#15446](https://github.com/apache/superset/pull/15446) fix(native-filters): filter type check when using experimental flag (@villebro)
- [#15422](https://github.com/apache/superset/pull/15422) fix: remove unnecessary app context on celery (@dpgaspar)
- [#15444](https://github.com/apache/superset/pull/15444) fix: import superset_config (@villebro)
- [#15314](https://github.com/apache/superset/pull/15314) fix(explore): switch to correct scheme registry for custom sequential color schemes (@sonyasha)
- [#15418](https://github.com/apache/superset/pull/15418) fix: add dashboard markdown id (@krsnik93)
- [#14778](https://github.com/apache/superset/pull/14778) fix(dashboard): Open "View Chart in Explore" in the same window (@geido)
- [#15435](https://github.com/apache/superset/pull/15435) fix: remove pydash merge (@betodealmeida)
- [#15328](https://github.com/apache/superset/pull/15328) fix: downgrade selenium log level on timeout (@dpgaspar)
- [#15429](https://github.com/apache/superset/pull/15429) fix: Select item when allowNewOptions is true and Enter is pressed (@michael-s-molina)
- [#15390](https://github.com/apache/superset/pull/15390) fix: Cascading filter popover widens automatically (@michael-s-molina)
- [#15400](https://github.com/apache/superset/pull/15400) fix: double click slq lab table cell (@graceguo-supercat)
- [#13467](https://github.com/apache/superset/pull/13467) fix: Typo in the `positionJSON` too large warning (@mrshu)
- [#15411](https://github.com/apache/superset/pull/15411) fix(native-filters): show human readable time grain label in indicator (@villebro)
- [#15297](https://github.com/apache/superset/pull/15297) fix: bootstrapScript in values.yaml of the helm chart (@mvoitko)
- [#15407](https://github.com/apache/superset/pull/15407) fix(regression): removed flask_app property can break derived class (@ofekisr)
- [#15373](https://github.com/apache/superset/pull/15373) fix: Enlarged select filter value (@michael-s-molina)
- [#15355](https://github.com/apache/superset/pull/15355) fix: follow up pr 15343 (@zhaoyongjie)
- [#15343](https://github.com/apache/superset/pull/15343) fix: missing orderby in query on the nvd3 timeseries chart (@zhaoyongjie)
- [#15351](https://github.com/apache/superset/pull/15351) fix(native-filters): show default text on filter scoping tree (@villebro)
- [#15339](https://github.com/apache/superset/pull/15339) fix(explore): Fix issue #15335 - Filter comparator losing focus (@m-ajay)
- [#15315](https://github.com/apache/superset/pull/15315) fix(api): handle undefined column type_generic (@serenajiang)
- [#15285](https://github.com/apache/superset/pull/15285) fix: Revert "build(webpack): use [contenthash] instead of [chunkhash]" (@etr2460)
- [#15319](https://github.com/apache/superset/pull/15319) fix: Capitalize time granularity weekdays (@john-bodley)
- [#15184](https://github.com/apache/superset/pull/15184) fix: datasource payload is incorrect (@betodealmeida)
- [#15324](https://github.com/apache/superset/pull/15324) fix(native-filters): Assume that temporal columns exist if column_types is undefined (@kgabryje)
- [#15305](https://github.com/apache/superset/pull/15305) fix(dashboard): Close FiltersBadge popover on window resize (@kgabryje)
- [#15207](https://github.com/apache/superset/pull/15207) fix: return query if it already exists (@eschutho)
- [#15301](https://github.com/apache/superset/pull/15301) fix: Revert "fix: SQL Lab show "Refetch Results" button while fetching new query results" (@graceguo-supercat)
- [#15238](https://github.com/apache/superset/pull/15238) fix: adding new feature flag (@AAfghahi)
- [#15295](https://github.com/apache/superset/pull/15295) fix(native-filters): improve time range filter performance (@villebro)
- [#14704](https://github.com/apache/superset/pull/14704) fix(helm): Use import_datasources.yaml, if it exists (@danielewood)
- [#15257](https://github.com/apache/superset/pull/15257) fix(native-filters): default value checkbox in config modal (@villebro)
- [#15228](https://github.com/apache/superset/pull/15228) fix: Filter bar not occupying 100% height when filter sets FF unset (@michael-s-molina)
- [#15173](https://github.com/apache/superset/pull/15173) fix(examples): calendar chart metric should be metrics (@villebro)
- [#15219](https://github.com/apache/superset/pull/15219) fix(native-filters): Fix Select `Default First Value` by clicked `Clear All` (@simcha90)
- [#15134](https://github.com/apache/superset/pull/15134) fix(dashboard): charts in nested tab is missing control and filter indicator (@stephenLYZ)
- [#15203](https://github.com/apache/superset/pull/15203) fix: fix dataset select list (@pkdotson)
- [#15198](https://github.com/apache/superset/pull/15198) fix: Fix dremio dialect not having a `driver` field (@hughhhh)
- [#15109](https://github.com/apache/superset/pull/15109) fix: SQL Lab show "Refetch Results" button while fetching new query results (@graceguo-supercat)
- [#15123](https://github.com/apache/superset/pull/15123) fix(logging): downgrade csv export log to debug (@nytai)
- [#14891](https://github.com/apache/superset/pull/14891) fix(aarch64): Bump pyarrow version to 4.0.1 (@danielewood)
- [#13614](https://github.com/apache/superset/pull/13614) fix(helm): Set working defaults for google OAuth2 example (@danielewood)
- [#15138](https://github.com/apache/superset/pull/15138) fix(dashboard): avoid duplicated toast component (@stephenLYZ)
- [#15007](https://github.com/apache/superset/pull/15007) fix(docker/helm): Make webserver query timeout adjustable (@danielewood)
- [#15181](https://github.com/apache/superset/pull/15181) fix: ignore errors in GetLog (@betodealmeida)
- [#15175](https://github.com/apache/superset/pull/15175) fix: trim string value of spaces in listview search (@pkdotson)
- [#15108](https://github.com/apache/superset/pull/15108) fix: add another wait for chart element (@eschutho)
- [#15160](https://github.com/apache/superset/pull/15160) fix: use npm v7 in docker compose (@suddjian)
- [#15163](https://github.com/apache/superset/pull/15163) fix: Presto postgres test (@betodealmeida)
- [#15172](https://github.com/apache/superset/pull/15172) fix(dashboard): Prevent rerendering View Query modal on window resize (@kgabryje)
- [#15155](https://github.com/apache/superset/pull/15155) fix: validate DB-specific parameters (@betodealmeida)
- [#15152](https://github.com/apache/superset/pull/15152) fix(typo): in contributing.md (@stellalc7)
- [#15100](https://github.com/apache/superset/pull/15100) fix: Test connection before starting on create transaction (@hughhhh)
- [#15140](https://github.com/apache/superset/pull/15140) fix: Filter overlay in dashboard when scrolling (@michael-s-molina)
- [#15146](https://github.com/apache/superset/pull/15146) fix(native-filters): Don't send unnecessary PUT request on dashboard render (@kgabryje)
- [#15139](https://github.com/apache/superset/pull/15139) fix: improve dashboard fullscreen text (@xiezhongfu)
- [#15091](https://github.com/apache/superset/pull/15091) fix(explore): fix y-axis lower bound  0 value (@stephenLYZ)
- [#15112](https://github.com/apache/superset/pull/15112) fix(native-filters): handle descending sorting correctly (@villebro)
- [#15090](https://github.com/apache/superset/pull/15090) fix(native-filters): fix Select filter crashing when changing filter type (@kgabryje)
- [#14959](https://github.com/apache/superset/pull/14959) fix: show custom errors in SQL Lab (@betodealmeida)
- [#14952](https://github.com/apache/superset/pull/14952) fix(explore): Explore page boolean filter is broken for Presto DB (@m-ajay)
- [#15084](https://github.com/apache/superset/pull/15084) fix(native-filters): empty label indicator (@villebro)
- [#15005](https://github.com/apache/superset/pull/15005) fix(native-filters): show error if default value query failed (@villebro)
- [#15015](https://github.com/apache/superset/pull/15015) fix(native-filters): remove hard-coded default time range (@villebro)
- [#15080](https://github.com/apache/superset/pull/15080) fix(dnd): add isExtra prop to Option (@villebro)
- [#15014](https://github.com/apache/superset/pull/15014) fix(datasets): consistent dataset list (@zhaoyongjie)
- [#15073](https://github.com/apache/superset/pull/15073) fix: disappearing tooltips on dashboards (@etr2460)
- [#15056](https://github.com/apache/superset/pull/15056) fix: confirm overwrite and password on import (@betodealmeida)
- [#15069](https://github.com/apache/superset/pull/15069) fix: move metric parsing to state instantiation (@eschutho)
- [#15047](https://github.com/apache/superset/pull/15047) fix: import metrics with extra (@betodealmeida)
- [#14960](https://github.com/apache/superset/pull/14960) fix: font regression in SQL Lab (@betodealmeida)
- [#15048](https://github.com/apache/superset/pull/15048) fix: edit BQ w/o encrypted_extra (@betodealmeida)
- [#15024](https://github.com/apache/superset/pull/15024) fix: Adds left padding to dashboard edit mode when filter bar is closed (@michael-s-molina)
- [#15038](https://github.com/apache/superset/pull/15038) fix(native-filters): show overridden chart name on scoping tree (@villebro)
- [#15033](https://github.com/apache/superset/pull/15033) fix(explore): Datepicker glitch on hover outside the modal (@kgabryje)
- [#14878](https://github.com/apache/superset/pull/14878) fix: Empty tab component in Dashboard cannot be deleted (@geido)
- [#14954](https://github.com/apache/superset/pull/14954) fix(explore): Long labels should wrap to new line (@geido)
- [#15031](https://github.com/apache/superset/pull/15031) fix: display all metric results in editor (@eschutho)
- [#15025](https://github.com/apache/superset/pull/15025) fix(dashboard): custom css should be removed on unmount (@suddjian)
- [#14995](https://github.com/apache/superset/pull/14995) fix: adding additional configs and colors for queryHistory (@AAfghahi)
- [#15012](https://github.com/apache/superset/pull/15012) fix(native-filters): avoid double load on select initialization (@villebro)
- [#14996](https://github.com/apache/superset/pull/14996) fix: apply template_params on external_metadata (@betodealmeida)
- [#14979](https://github.com/apache/superset/pull/14979) fix: toggle fullscreen on the dashboard (@zhaoyongjie)
- [#14984](https://github.com/apache/superset/pull/14984) fix(native-filters): Fix "undefined" error after editing a filter (@kgabryje)
- [#14982](https://github.com/apache/superset/pull/14982) fix(native-filters): remove implied fetch predicate (@villebro)
- [#14980](https://github.com/apache/superset/pull/14980) fix(native-filters): update cascaded filter state on change (@villebro)
- [#14900](https://github.com/apache/superset/pull/14900) fix(filter box): replace freeform where clause with ilike (@villebro)
- [#14971](https://github.com/apache/superset/pull/14971) fix: renamed sqllab filters to _filters (@cccs-jc)
- [#14964](https://github.com/apache/superset/pull/14964) fix(native-filters): cascading filters not rendering in tab (@villebro)
- [#14953](https://github.com/apache/superset/pull/14953) fix: additional safeguard for ResultSet (@AAfghahi)
- [#14945](https://github.com/apache/superset/pull/14945) fix: time parser truncate to first day of year/month (@zhaoyongjie)
- [#14894](https://github.com/apache/superset/pull/14894) fix: is_temporal should overwrite is_dttm (@zhaoyongjie)
- [#14902](https://github.com/apache/superset/pull/14902) fix: Remove Icon and align close button on DatasetModal (@AAfghahi)
- [#14885](https://github.com/apache/superset/pull/14885) fix: Query History cosmetic issues (@AAfghahi)
- [#14840](https://github.com/apache/superset/pull/14840) fix: Full width tabs flaky behavior (@geido)
- [#14903](https://github.com/apache/superset/pull/14903) fix: permission denied when starting docker with uid 1000 (@shawnzhu)
- [#14855](https://github.com/apache/superset/pull/14855) fix: leverage qs to create new tab (@hughhhh)
- [#14888](https://github.com/apache/superset/pull/14888) fix: Redshift parameters not rendering (@hughhhh)
- [#14839](https://github.com/apache/superset/pull/14839) fix(explore): Icons in "Customize Columns" in "Customize" tab break to a new line (@geido)
- [#14890](https://github.com/apache/superset/pull/14890) fix: time range in filter box error (@zhaoyongjie)
- [#14851](https://github.com/apache/superset/pull/14851) fix: show error on invalid import (@betodealmeida)
- [#14687](https://github.com/apache/superset/pull/14687) fix(explore): Don't run data panel query when control panel has errors (@kgabryje)
- [#14849](https://github.com/apache/superset/pull/14849) fix: DatabaseConnection Modal Margin Bottom (@AAfghahi)
- [#14756](https://github.com/apache/superset/pull/14756) fix: small code review fix (@cccs-jc)
- [#14816](https://github.com/apache/superset/pull/14816) fix(native-filter): Default value multi-select height in native filters (@geido)
- [#14841](https://github.com/apache/superset/pull/14841) fix: filterbox apply single value (@zhaoyongjie)
- [#14838](https://github.com/apache/superset/pull/14838) fix(native-filters): remove indicators outside scope (@villebro)
- [#14852](https://github.com/apache/superset/pull/14852) fix: report dropdown (@AAfghahi)
- [#14850](https://github.com/apache/superset/pull/14850) fix: Big Query Edit Form (@hughhhh)
- [#14813](https://github.com/apache/superset/pull/14813) fix: the calculated columns explicit type convert into date (@zhaoyongjie)
- [#14736](https://github.com/apache/superset/pull/14736) fix(docker): superset permissions and firefox config (@dpgaspar)
- [#14827](https://github.com/apache/superset/pull/14827) fix: OpenAPI boolean type (@betodealmeida)
- [#14822](https://github.com/apache/superset/pull/14822) fix: Fix Big Query API for POST w/ no parameters (@hughhhh)
- [#14489](https://github.com/apache/superset/pull/14489) fix: set table name width to not hide icons when name is too long (@einatbar)
- [#14788](https://github.com/apache/superset/pull/14788) fix(native-filters): fix loop caused by external state handler (@villebro)
- [#14785](https://github.com/apache/superset/pull/14785) fix(native-filters): Manage default value of filters by superset (@simcha90)
- [#14741](https://github.com/apache/superset/pull/14741) fix: Additional ResultSet tests (@AAfghahi)
- [#14528](https://github.com/apache/superset/pull/14528) fix: make dataset list sort case insensitive (@mistercrunch)
- [#14790](https://github.com/apache/superset/pull/14790) fix: use encodeURIComponent when getting table metadata (@betodealmeida)
- [#14787](https://github.com/apache/superset/pull/14787) fix: ensure engine is outside parameters (@betodealmeida)
- [#14771](https://github.com/apache/superset/pull/14771) fix: database modal should close on connect with tab layout (@eschutho)
- [#14770](https://github.com/apache/superset/pull/14770) fix: extra query in Dashboard when native filter enabled (@zhaoyongjie)
- [#14779](https://github.com/apache/superset/pull/14779) fix(native filters): Fix explore state - backend pagination checkbox in table (@simcha90)
- [#14737](https://github.com/apache/superset/pull/14737) fix(explore): DndColumnSelect not handling controls with "multi: false" (@kgabryje)
- [#14766](https://github.com/apache/superset/pull/14766) fix: add DB should not say it's Postgres (@betodealmeida)
- [#14759](https://github.com/apache/superset/pull/14759) fix: save non-parameter DBs (@betodealmeida)
- [#14717](https://github.com/apache/superset/pull/14717) fix(explore): Icons width (@geido)
- [#14742](https://github.com/apache/superset/pull/14742) fix: Set g.user to anon user in Celery (@benjreinhart)
- [#14702](https://github.com/apache/superset/pull/14702) fix: Use g.user for getting the user_id for async queries (@benjreinhart)
- [#14689](https://github.com/apache/superset/pull/14689) fix: Fixes right menu layout in different screen sizes (@michael-s-molina)
- [#14734](https://github.com/apache/superset/pull/14734) fix(dashboard): multiple query trigger when native filter enabled (@zhaoyongjie)
- [#14748](https://github.com/apache/superset/pull/14748) fix(pivot): default missing series to NULL_STRING (@villebro)
- [#14725](https://github.com/apache/superset/pull/14725) fix: homepage card layout (@pkdotson)
- [#14739](https://github.com/apache/superset/pull/14739) fix(native-filters): Unable to clear default value in native select filter (@michael-s-molina)
- [#14722](https://github.com/apache/superset/pull/14722) fix(sqllab): don't store user in localstorage (@suddjian)
- [#14708](https://github.com/apache/superset/pull/14708) fix: reindex when combine metric in legacy pivot table (@zhaoyongjie)
- [#14221](https://github.com/apache/superset/pull/14221) fix(explore): fix clearing select data causes popover dismiss (@stephenLYZ)
- [#14719](https://github.com/apache/superset/pull/14719) fix: check limiting factor on query results (@eschutho)
- [#14679](https://github.com/apache/superset/pull/14679) fix(explore): add margin to the adhoc filter value select (@suddjian)
- [#14701](https://github.com/apache/superset/pull/14701) fix(explore): checkbox form control formatting (@suddjian)
- [#14657](https://github.com/apache/superset/pull/14657) fix(explore): Filter box full chart height (@geido)
- [#14529](https://github.com/apache/superset/pull/14529) fix(Explore): fixes broken layout of tooltips (@rusackas)
- [#14698](https://github.com/apache/superset/pull/14698) fix: import dataset with extra; Vertica URI (@betodealmeida)
- [#14567](https://github.com/apache/superset/pull/14567) fix(explore): #10098 boolean filter not working (@m-ajay)
- [#14664](https://github.com/apache/superset/pull/14664) fix: Fixes email body when sharing a chart by email (@michael-s-molina)
- [#14651](https://github.com/apache/superset/pull/14651) fix(sqllab): fix error message (@stephenLYZ)
- [#14656](https://github.com/apache/superset/pull/14656) fix: Tooltip position of table title (@geido)
- [#14663](https://github.com/apache/superset/pull/14663) fix(explore): Tag component overlap (@geido)
- [#14665](https://github.com/apache/superset/pull/14665) fix(explore): Fix column number calculation (@geido)
- [#14580](https://github.com/apache/superset/pull/14580) fix: nav submenu dropdown styles (@pkdotson)
- [#14674](https://github.com/apache/superset/pull/14674) fix: Fixes group by control icon colors (@michael-s-molina)
- [#14655](https://github.com/apache/superset/pull/14655) fix: Clear search on deleting search keyword (@geido)
- [#14631](https://github.com/apache/superset/pull/14631) fix: fix submenu header double line (@pkdotson)
- [#14648](https://github.com/apache/superset/pull/14648) fix: roles undefined on public dashboards (@suddjian)
- [#14636](https://github.com/apache/superset/pull/14636) fix: DB parameter validation API (@betodealmeida)
- [#14626](https://github.com/apache/superset/pull/14626) fix(dashboard): check edit permissions correctly on frontend (@suddjian)
- [#14624](https://github.com/apache/superset/pull/14624) fix: Fixes top level tabs and automatic scroll (@michael-s-molina)
- [#14609](https://github.com/apache/superset/pull/14609) fix(explore): Missing border in the Popover SQL Editor (@geido)
- [#14120](https://github.com/apache/superset/pull/14120) fix: do not render favorite favStars and filters for anonymous user (@trepmag)
- [#14637](https://github.com/apache/superset/pull/14637) fix: Removing specific column widths, letting things flex naturally. (@rusackas)
- [#14478](https://github.com/apache/superset/pull/14478) fix: fix adhocpopovers tab animate. (@pkdotson)
- [#14627](https://github.com/apache/superset/pull/14627) fix: Pin itsdangerous (@john-bodley)
- [#14557](https://github.com/apache/superset/pull/14557) fix: Consolidating dropdown/NavDropdown user experience (removing React-bootstrap, using AntD)  (@michael-s-molina)
- [#14525](https://github.com/apache/superset/pull/14525) fix: add action buttons to time series column popover  (@michael-s-molina)
- [#14618](https://github.com/apache/superset/pull/14618) fix(explore): Filters Tooltip is not showing the full content (@geido)
- [#14585](https://github.com/apache/superset/pull/14585) fix: don't show busted label for unknown data types (@rusackas)
- [#14597](https://github.com/apache/superset/pull/14597) fix: error icon spacing in explore (@pkdotson)
- [#14579](https://github.com/apache/superset/pull/14579) fix: properly keep state on queryEditorSetSql on tabstateview PUT (@hughhhh)
- [#14584](https://github.com/apache/superset/pull/14584) fix: bring back dashboard perf logger (@graceguo-supercat)
- [#14582](https://github.com/apache/superset/pull/14582) fix: Adds space under dataset change warning (@rusackas)
- [#14566](https://github.com/apache/superset/pull/14566) fix: Menu does not appear on scroll in Dashboard (@geido)
- [#14551](https://github.com/apache/superset/pull/14551) fix: Column name and icons alignment in the Datasource Panel (Explore) (@geido)
- [#14561](https://github.com/apache/superset/pull/14561) fix: select country in examples chart (@betodealmeida)
- [#14495](https://github.com/apache/superset/pull/14495) fix: White space between Chart and Data panel in Explore (@geido)
- [#14539](https://github.com/apache/superset/pull/14539) fix(viz): apply uniform sorting to all nvd3 timeseries charts (@villebro)
- [#14544](https://github.com/apache/superset/pull/14544) fix: flaky test on reports (@dpgaspar)
- [#14531](https://github.com/apache/superset/pull/14531) fix: bringing metric type icon styles into SelectControl (@rusackas)
- [#14492](https://github.com/apache/superset/pull/14492) fix: Add extra check to loggerMiddleware (@geido)
- [#14506](https://github.com/apache/superset/pull/14506) fix: disable pylint error breaking CI (@hughhhh)
- [#14498](https://github.com/apache/superset/pull/14498) fix: Query History (@AAfghahi)
- [#14490](https://github.com/apache/superset/pull/14490) fix: Fix #13831 (@michael-s-molina)
- [#14467](https://github.com/apache/superset/pull/14467) fix(dashboard): Prevent char overflow when displaying chart description (@m-ajay)
- [#14481](https://github.com/apache/superset/pull/14481) fix: Explore layout is sometimes too short for the viewport (@rusackas)
- [#14471](https://github.com/apache/superset/pull/14471) fix: dashboard datasources filter None (@etr2460)
- [#14465](https://github.com/apache/superset/pull/14465) fix: Ignore database extra fields when saving (@michael-s-molina)
- [#14466](https://github.com/apache/superset/pull/14466) fix: Revert "refactor: split db modal file (#14436)" (@eschutho)
- [#13713](https://github.com/apache/superset/pull/13713) fix(explore): CSV Export Permission is incorrect on Explore page (@duynguyenhoang)
- [#14450](https://github.com/apache/superset/pull/14450) fix: dashboard changed on calculation (@etr2460)
- [#14399](https://github.com/apache/superset/pull/14399) fix(logging): log unexpected exceptions as exceptions (@nytai)
- [#14416](https://github.com/apache/superset/pull/14416) fix: fixing mysql error message (@AAfghahi)
- [#14435](https://github.com/apache/superset/pull/14435) fix: Change relationship filter for datasets to relationOneMany (@hughhhh)
- [#14348](https://github.com/apache/superset/pull/14348) fix: bootstrap data permissions (@dpgaspar)
- [#14360](https://github.com/apache/superset/pull/14360) fix: parse simple string error message values (@samtfm)

**Others**
- [#16251](https://github.com/apache/superset/pull/16251) chore: bump superset-ui packages to 0.17.84 (@pkdotson)
- [#16186](https://github.com/apache/superset/pull/16186) chore: bump superset-ui to 0.17.81 (@villebro)
- [#16174](https://github.com/apache/superset/pull/16174) chore: switch back tag name to popular from highly-used (@junlincc)
- [#16116](https://github.com/apache/superset/pull/16116) chore(explore): change dnd placeholders (@kgabryje)
- [#16133](https://github.com/apache/superset/pull/16133) chore: add stats logging to thumbnail api (@mistercrunch)
- [#16086](https://github.com/apache/superset/pull/16086) chore(explore): bump deckgl to 0.4.9 (@kgabryje)
- [#15942](https://github.com/apache/superset/pull/15942) chore(explore): Create new entrypoints for Echarts Timeseries (@kgabryje)
- [#16058](https://github.com/apache/superset/pull/16058) chore: bump superset-ui to 0.17.78 (@villebro)
- [#16039](https://github.com/apache/superset/pull/16039) chore: Revert Celery 5 upgrade (@robdiciuccio)
- [#16029](https://github.com/apache/superset/pull/16029) chore: Use datetime.timedelta for defining durations in config (@john-bodley)
- [#16034](https://github.com/apache/superset/pull/16034) chore: bump superset-ui to 0.17.77 (@villebro)
- [#16025](https://github.com/apache/superset/pull/16025) chore: Auto focus the viz gallery select (@michael-s-molina)
- [#16032](https://github.com/apache/superset/pull/16032) docs: update api 2 (@nytai)
- [#15927](https://github.com/apache/superset/pull/15927) chore: Bump Celery to 5.1.2 (@john-bodley)
- [#15936](https://github.com/apache/superset/pull/15936) docs: add instructions for how to connect to local database from docker container (@sarthak)
- [#15950](https://github.com/apache/superset/pull/15950) docs: add Hydrolix to users list (@dsztykman)
- [#16005](https://github.com/apache/superset/pull/16005) docs: update api (@nytai)
- [#15958](https://github.com/apache/superset/pull/15958) chore: change dropdown icons from horizontal to vertical (@pkdotson)
- [#15987](https://github.com/apache/superset/pull/15987) chore: Add feature flags to bug report template (@suddjian)
- [#15929](https://github.com/apache/superset/pull/15929) chore: Changes the main menu order as defined in SIP-34 (@michael-s-molina)
- [#15931](https://github.com/apache/superset/pull/15931) docs: add .asf.yaml (@nytai)
- [#15823](https://github.com/apache/superset/pull/15823) chore: Mypy fix **kwargs type (@john-bodley)
- [#15923](https://github.com/apache/superset/pull/15923) chore: bump superset-ui to 0.17.74 (@villebro)
- [#15900](https://github.com/apache/superset/pull/15900) chore: small viz gallery tweaks (@suddjian)
- [#15907](https://github.com/apache/superset/pull/15907) chore: Improves the layout of the VizTypeGallery component (@michael-s-molina)
- [#15904](https://github.com/apache/superset/pull/15904) docs: Slack integration requires "chat:write" permissions scope (@jpuris)
- [#15901](https://github.com/apache/superset/pull/15901) chore: bumping superset-ui 0.17.73 (@zhaoyongjie)
- [#15724](https://github.com/apache/superset/pull/15724) chore: freeze the UUID of examples DB (@betodealmeida)
- [#15868](https://github.com/apache/superset/pull/15868) chore: implement new mockup to the new viz gallery (2nd iteration) (@stephenLYZ)
- [#15895](https://github.com/apache/superset/pull/15895) chore: bumping superset-ui 0.17.72 (@zhaoyongjie)
- [#15885](https://github.com/apache/superset/pull/15885) chore: Adds the tests that need to be coded for the Select component (@michael-s-molina)
- [#15847](https://github.com/apache/superset/pull/15847) chore: bump typescript (@eschutho)
- [#15799](https://github.com/apache/superset/pull/15799) chore: Adds lazy loading and fetchOnlyOnSearch to the Select component (@michael-s-molina)
- [#15839](https://github.com/apache/superset/pull/15839) chore: bump superset-ui to 0.17.71 (@kgabryje)
- [#15802](https://github.com/apache/superset/pull/15802) chore: Changes the pagination API of the Select component (@michael-s-molina)
- [#15787](https://github.com/apache/superset/pull/15787) chore: remove unnecessary deps (@betodealmeida)
- [#15757](https://github.com/apache/superset/pull/15757) chore: Enforce Mypy for non-tests (@john-bodley)
- [#15775](https://github.com/apache/superset/pull/15775) chore: Pylint reenable bad-option-value message (@john-bodley)
- [#15772](https://github.com/apache/superset/pull/15772) chore: Pylint reenable non-problematic messages (@john-bodley)
- [#15788](https://github.com/apache/superset/pull/15788) chore: remove `retry` dependency in favor of `backoff` (@betodealmeida)
- [#15480](https://github.com/apache/superset/pull/15480) chore: Improves the Select component UI/UX - iteration 4 (@michael-s-molina)
- [#15794](https://github.com/apache/superset/pull/15794) docs: Adding Sunbird to users list (@kumarks1122)
- [#15795](https://github.com/apache/superset/pull/15795) chore: bump superset-ui 0.17.70 (@zhaoyongjie)
- [#15734](https://github.com/apache/superset/pull/15734) chore: Add tags to the new viz gallery (@zhaoyongjie)
- [#15776](https://github.com/apache/superset/pull/15776) docs: Update INTHEWILD.md (@MaiTiano)
- [#15555](https://github.com/apache/superset/pull/15555) chore: Select component refactoring - ColorSchemeControl - Iteration 5 (@geido)
- [#15571](https://github.com/apache/superset/pull/15571) chore: Select component refactoring - DateFilterControl - Iteration 5 (@geido)
- [#15753](https://github.com/apache/superset/pull/15753) chore: Reformat Pylint disable checks to multiline (@john-bodley)
- [#15767](https://github.com/apache/superset/pull/15767) chore: bump superet-ui 0.17.69 (@zhaoyongjie)
- [#15742](https://github.com/apache/superset/pull/15742) chore(explore): Bump plugin-chart-pivot-table (@kgabryje)
- [#15718](https://github.com/apache/superset/pull/15718) docs: update dev superset version (@nytai)
- [#15699](https://github.com/apache/superset/pull/15699) perf(dashboard): make loading datasets non-blocking (@ktmud)
- [#15714](https://github.com/apache/superset/pull/15714) chore: better copy for SQL dialog (@betodealmeida)
- [#15690](https://github.com/apache/superset/pull/15690) refactor: remove old Icon component (@pkdotson)
- [#15647](https://github.com/apache/superset/pull/15647) refactor: icon to icons for IconButton and Header component (@pkdotson)
- [#15688](https://github.com/apache/superset/pull/15688) chore: Removes unnecessary uses of preselectNativeFilters (@michael-s-molina)
- [#15648](https://github.com/apache/superset/pull/15648) perf: Refactor Dashboard.datasets_trimmed_for_slices et al. (@john-bodley)
- [#15599](https://github.com/apache/superset/pull/15599) chore: Add documentation for DB Connection UI (@hughhhh)
- [#15646](https://github.com/apache/superset/pull/15646) chore: Add metrics_b as viable metric form data parameter (@john-bodley)
- [#15665](https://github.com/apache/superset/pull/15665) refactor: icon to icons for Querytable, datasource test, and copyclipboard story (@pkdotson)
- [#15574](https://github.com/apache/superset/pull/15574) docs: Add section about updating Python requirements (@john-bodley)
- [#15583](https://github.com/apache/superset/pull/15583) chore: Preserve native filters selection after refresh (@michael-s-molina)
- [#15643](https://github.com/apache/superset/pull/15643) refactor: icon to icons for navbar (@pkdotson)
- [#15644](https://github.com/apache/superset/pull/15644) chore: Reverts reset form in native filters (@michael-s-molina)
- [#15633](https://github.com/apache/superset/pull/15633) chore: bump superset-ui/plugin-chart-echarts 0.17.65 (@zhaoyongjie)
- [#15618](https://github.com/apache/superset/pull/15618) refactor: icon to icons for syntaxhighlighter and querylist components (@pkdotson)
- [#15593](https://github.com/apache/superset/pull/15593) refactor: icon to icons for sqllab  (@pkdotson)
- [#15624](https://github.com/apache/superset/pull/15624) refactor: icon to icons for homepage and card compompents (@pkdotson)
- [#15113](https://github.com/apache/superset/pull/15113) docs: fix typos in docs (@jacobhjkim)
- [#15410](https://github.com/apache/superset/pull/15410) docs: Small addition in add new databases with docker (@JavierLopezT)
- [#15607](https://github.com/apache/superset/pull/15607) docs(docker): update README (@jhult)
- [#15579](https://github.com/apache/superset/pull/15579) refactor: icon to icons for toasts component (@pkdotson)
- [#15611](https://github.com/apache/superset/pull/15611) refactor: icon to icons for annotations & css templates modals (@pkdotson)
- [#15597](https://github.com/apache/superset/pull/15597) refactor: icon to icons for Alert & Reports (@pkdotson)
- [#15608](https://github.com/apache/superset/pull/15608) chore: update dataset count badge and tash icon sizing (@andrewbastian)
- [#15615](https://github.com/apache/superset/pull/15615) chore: bumping superset-ui 0.17.64 (@zhaoyongjie)
- [#15359](https://github.com/apache/superset/pull/15359) refactor(annotation): improve annotation modal (@stephenLYZ)
- [#15568](https://github.com/apache/superset/pull/15568) refactor: icon to icons for controls (@pkdotson)
- [#15567](https://github.com/apache/superset/pull/15567) refactor: icon to icons for sliceheader component (@pkdotson)
- [#15591](https://github.com/apache/superset/pull/15591) chore: results of npm audit fix on superset-websocket (@rusackas)
- [#15557](https://github.com/apache/superset/pull/15557) refactor: icon to icons for filterbadge components (@pkdotson)
- [#15542](https://github.com/apache/superset/pull/15542) chore: add changed_on_delta_humanized field on dashboard schema (@zhaoyongjie)
- [#15528](https://github.com/apache/superset/pull/15528) refactor: icon to icons for nativeFilter components (@pkdotson)
- [#15575](https://github.com/apache/superset/pull/15575) docs: updated dremio connection string (@srinify)
- [#15551](https://github.com/apache/superset/pull/15551) refactor: icon to icons for tabs (@pkdotson)
- [#15560](https://github.com/apache/superset/pull/15560) refactor: icon to icons for headeractionsdropdown (@pkdotson)
- [#15550](https://github.com/apache/superset/pull/15550) chore: Enhance Select component (@geido)
- [#15540](https://github.com/apache/superset/pull/15540) refactor: type hints should not be load in runtime (@ofekisr)
- [#15461](https://github.com/apache/superset/pull/15461) refactor: icon to icons for popoversection (@pkdotson)
- [#15521](https://github.com/apache/superset/pull/15521) chore: add metadata for filter box plugin (@suddjian)
- [#15533](https://github.com/apache/superset/pull/15533) refactor: migrate to icons for searchinput icons (@pkdotson)
- [#15523](https://github.com/apache/superset/pull/15523) chore(release-docs): svn update after svn commit (@amitmiran137)
- [#15514](https://github.com/apache/superset/pull/15514) chore(docs): update DASHBOARD_RBAC (@amitmiran137)
- [#15451](https://github.com/apache/superset/pull/15451) refactor: icon to icons for popovercomponent (@pkdotson)
- [#15384](https://github.com/apache/superset/pull/15384) refactor(dashboard): [chart-maximize-mode]put chart full-size state in redux (@stephenLYZ)
- [#15408](https://github.com/apache/superset/pull/15408) refactor: icon to icons for listviewcomponent (@pkdotson)
- [#15398](https://github.com/apache/superset/pull/15398) refactor: icon to icons for infotooltip component (@pkdotson)
- [#15473](https://github.com/apache/superset/pull/15473) refactor(tests): decouple unittests from integration tests (@ofekisr)
- [#14102](https://github.com/apache/superset/pull/14102) docs: improve docs on running tests locally (@EBoisseauSierra)
- [#15365](https://github.com/apache/superset/pull/15365) chore(native-filters): remove instant filtering option (@villebro)
- [#15467](https://github.com/apache/superset/pull/15467) refactor: Moving get_user_datasources to security manager (@john-bodley)
- [#15466](https://github.com/apache/superset/pull/15466) refactor: icon to icons for refreshlabel  (@pkdotson)
- [#15437](https://github.com/apache/superset/pull/15437) chore: simplify errors and issue codes (@betodealmeida)
- [#15424](https://github.com/apache/superset/pull/15424) perf(dashboard): Improve perf of highlighting charts in scope of active filter (@kgabryje)
- [#15413](https://github.com/apache/superset/pull/15413) chore(docs): Manage access to Dashboards (@amitmiran137)
- [#14994](https://github.com/apache/superset/pull/14994) docs: add missing logging import (@Bonifacio2)
- [#14630](https://github.com/apache/superset/pull/14630) docs: fix wrong filename mentioned in INSTALL.md (@jeverling)
- [#15401](https://github.com/apache/superset/pull/15401) refactor: icon to icons for lastupdated component (@pkdotson)
- [#15397](https://github.com/apache/superset/pull/15397) refactor: icon to icons for inderteminatecheckbox icon (@pkdotson)
- [#15433](https://github.com/apache/superset/pull/15433) chore: Uses mixed case for native filters headers (@michael-s-molina)
- [#14880](https://github.com/apache/superset/pull/14880) chore: Update CONTRIBUTING.md (@Ibby-B)
- [#15425](https://github.com/apache/superset/pull/15425) refactor(feature_flags configurations): remove defaults values  (@ofekisr)
- [#15405](https://github.com/apache/superset/pull/15405) chore(refactor): load configuration and merge recursively  (@ofekisr)
- [#15417](https://github.com/apache/superset/pull/15417) chore: add DASHBOARD_FILTERS_EXPERIMENTAL ff to BE default value (@amitmiran137)
- [#14278](https://github.com/apache/superset/pull/14278) docs: Update SIP template (@john-bodley)
- [#14908](https://github.com/apache/superset/pull/14908) chore: Add Slovenian (sl_SI) translation (@dkrat7)
- [#14572](https://github.com/apache/superset/pull/14572) docs: release documentation for 1.2 (@garden-of-delete)
- [#15392](https://github.com/apache/superset/pull/15392) chore: remove unused icon from ImportModal (@pkdotson)
- [#14174](https://github.com/apache/superset/pull/14174) chore: Rewrites dashboard IconButton component (@michael-s-molina)
- [#15265](https://github.com/apache/superset/pull/15265) chore: Migrates ControlHeader icons (@michael-s-molina)
- [#15363](https://github.com/apache/superset/pull/15363) chore: Improves the Select component UI/UX - iteration 3 (@michael-s-molina)
- [#15371](https://github.com/apache/superset/pull/15371) refactor: icon to icons for favestar component (@pkdotson)
- [#15380](https://github.com/apache/superset/pull/15380) refactor: icon to icons infotooltip (@pkdotson)
- [#15320](https://github.com/apache/superset/pull/15320) chore: Add Druid SQL time grains for parity with Druid NoSQL (@john-bodley)
- [#15349](https://github.com/apache/superset/pull/15349) chore: Bump @svgr/webpack to 5.5.0 (@kgabryje)
- [#15341](https://github.com/apache/superset/pull/15341) refactor: icon to icons in erroralert component (@pkdotson)
- [#15336](https://github.com/apache/superset/pull/15336) refactor: icon to icons for basicerror componenet (@pkdotson)
- [#15200](https://github.com/apache/superset/pull/15200) style(sqllab): update table count styling (@stellalc7)
- [#15306](https://github.com/apache/superset/pull/15306) refactor: Icon to icons for certifiedIcon (@pkdotson)
- [#15245](https://github.com/apache/superset/pull/15245) docs: fix hyperlink (@kamalkeshavani-aiinside)
- [#15309](https://github.com/apache/superset/pull/15309) refactor: migrate icon to icons in tablecollection (@pkdotson)
- [#15240](https://github.com/apache/superset/pull/15240) refactor: icon to icons in DatasourceEditor (@pkdotson)
- [#15235](https://github.com/apache/superset/pull/15235) chore: Improves the Select component UI/UX - iteration 2 (@michael-s-molina)
- [#15281](https://github.com/apache/superset/pull/15281) chore: encapsulate flask app into superset app (@ofekisr)
- [#15278](https://github.com/apache/superset/pull/15278) refactor: move SupersetAppInitializer to specific initialization package (@ofekisr)
- [#15223](https://github.com/apache/superset/pull/15223) chore: move calling configure_feature_flags more earlier (@ofekisr)
- [#14691](https://github.com/apache/superset/pull/14691) chore: add dry false config to CleanWebpackPlugin (@MatanBobi)
- [#15040](https://github.com/apache/superset/pull/15040) chore(docs): update releasing docs (@amitmiran137)
- [#15261](https://github.com/apache/superset/pull/15261) refactor: icon to icons for alerts component (@pkdotson)
- [#14956](https://github.com/apache/superset/pull/14956) chore: Add height/width TrashIcon SVG(18px/18px)-Edit Dataset modal (@andrewbastian)
- [#15233](https://github.com/apache/superset/pull/15233) docs: fix naming: Flask-Cache -> Flask-Caching (@shawnzhu)
- [#15220](https://github.com/apache/superset/pull/15220) chore: bump superset-ui to 0.17.58 (@villebro)
- [#14463](https://github.com/apache/superset/pull/14463) refactor: refactor Icon to Icons in sqlEditor component (@pkdotson)
- [#15192](https://github.com/apache/superset/pull/15192) chore: Changes the dashboard highlight color when selecting a filter (@michael-s-molina)
- [#15194](https://github.com/apache/superset/pull/15194) chore: Makes the refresh button only appear when the filter has a datasource (@michael-s-molina)
- [#15178](https://github.com/apache/superset/pull/15178) chore: Allows the user to force fetch the default values (@michael-s-molina)
- [#15115](https://github.com/apache/superset/pull/15115) chore: Improves the native filters bar layout (@michael-s-molina)
- [#14978](https://github.com/apache/superset/pull/14978) refactor: Convert TableElement to TypeScript (@corbinrobb)
- [#15147](https://github.com/apache/superset/pull/15147) refactor(explore): remove side effect in render from CalendarFrame for DatePicker (@MatanBobi)
- [#15168](https://github.com/apache/superset/pull/15168) chore: Bump plugin-chart-pivot-table to 0.17.57 (@kgabryje)
- [#15141](https://github.com/apache/superset/pull/15141) chore: Scrolls top when opening a select filter (@michael-s-molina)
- [#15156](https://github.com/apache/superset/pull/15156) chore: Disable comment logging for ephemeral envs (@robdiciuccio)
- [#15093](https://github.com/apache/superset/pull/15093) chore: update documentation for frontend feature flags (@etr2460)
- [#14823](https://github.com/apache/superset/pull/14823) chore: Homepage cleanup (@pkdotson)
- [#14928](https://github.com/apache/superset/pull/14928) docs: add Ontruck to users list (@rc-ontruck)
- [#15062](https://github.com/apache/superset/pull/15062) refactor: stop using deprecated celery task API (@shawnzhu)
- [#15078](https://github.com/apache/superset/pull/15078) chore: rename 'tables' to 'datasets' in error message (@mistercrunch)
- [#15017](https://github.com/apache/superset/pull/15017) chore: Improves the native filters UI/UX - iteration 7 (@michael-s-molina)
- [#15064](https://github.com/apache/superset/pull/15064) chore: Add 'fetching' status to QueryStatus (@AAfghahi)
- [#14942](https://github.com/apache/superset/pull/14942) build(webpack): use [contenthash] instead of [chunkhash] (@nytai)
- [#15019](https://github.com/apache/superset/pull/15019) docs: jinja (@srinify)
- [#15053](https://github.com/apache/superset/pull/15053) refactor: adopt --app as celery global option (@shawnzhu)
- [#15044](https://github.com/apache/superset/pull/15044) docs: provide config option for openid-connect provider #13948 (@shawnzhu)
- [#14870](https://github.com/apache/superset/pull/14870) chore: Bulk Select X Button Alignment (@lyndsiWilliams)
- [#14846](https://github.com/apache/superset/pull/14846) chore: Align down icons on header (@lyndsiWilliams)
- [#15013](https://github.com/apache/superset/pull/15013) refactor: Add "is_select_query" method to base engine spec to unlock non-SQL dialects (@Ceridan)
- [#15021](https://github.com/apache/superset/pull/15021) chore: rename 'Source' to 'Database' for consistency (@mistercrunch)
- [#15016](https://github.com/apache/superset/pull/15016) chore(ci): fix ci conflict (@villebro)
- [#15010](https://github.com/apache/superset/pull/15010) docs: required information for OAuth2 configuration (@shawnzhu)
- [#14990](https://github.com/apache/superset/pull/14990) docs: Updates index.mdx (@brian-childress)
- [#14950](https://github.com/apache/superset/pull/14950) docs: fix typos on installation.rst (@Bonifacio2)
- [#14997](https://github.com/apache/superset/pull/14997) docs: fix custom oauth config (@nytai)
- [#14830](https://github.com/apache/superset/pull/14830) refactor: Convert TableElement.jsx component from class to functional with hooks (@corbinrobb)
- [#14968](https://github.com/apache/superset/pull/14968) chore: bump superset-ui to 0.17.53 (@villebro)
- [#14932](https://github.com/apache/superset/pull/14932) chore: Improves the native filters UI/UX - iteration 6 (@michael-s-molina)
- [#14896](https://github.com/apache/superset/pull/14896) chore: customize adhoc filter icon and fix creatable label (@villebro)
- [#14919](https://github.com/apache/superset/pull/14919) test(native-filters): add test for Select filter (@simcha90)
- [#14907](https://github.com/apache/superset/pull/14907) chore: upgrade bleach dependency (@willbarrett)
- [#14906](https://github.com/apache/superset/pull/14906) chore: Upgrade cryptography package (@willbarrett)
- [#14871](https://github.com/apache/superset/pull/14871) chore: Bump @superset-ui/legacy-preset-chart-deckgl to 0.4.7 (@kgabryje)
- [#14882](https://github.com/apache/superset/pull/14882) chore: Improves the native filters UI/UX - iteration 5 (@michael-s-molina)
- [#14854](https://github.com/apache/superset/pull/14854) chore: Improves the native filters UI/UX - iteration 4 (@michael-s-molina)
- [#14814](https://github.com/apache/superset/pull/14814) chore(native-filters): introduce experimental feature flag (@villebro)
- [#14824](https://github.com/apache/superset/pull/14824) chore: Improves the native filters UI/UX - iteration 3 (@michael-s-molina)
- [#14826](https://github.com/apache/superset/pull/14826) chore: Update docs on MySQL recommended driver (@betodealmeida)
- [#14752](https://github.com/apache/superset/pull/14752) chore: added BasicParametersMixin to Redshift (@AAfghahi)
- [#14753](https://github.com/apache/superset/pull/14753) chore: Improves the native filters UI/UX - iteration 2 (@michael-s-molina)
- [#14762](https://github.com/apache/superset/pull/14762) other: "revert fix(dashboard): multiple query trigger when native filter enabled" (@zhaoyongjie)
- [#14199](https://github.com/apache/superset/pull/14199) chore: Removes ColorSchemeControl.less (@michael-s-molina)
- [#14684](https://github.com/apache/superset/pull/14684) chore: Perform feature/config condition checks at request time (@benjreinhart)
- [#14723](https://github.com/apache/superset/pull/14723) chore: Update pull request template (@suddjian)
- [#14714](https://github.com/apache/superset/pull/14714) chore: Improves the native filters UI/UX - iteration 1 (@michael-s-molina)
- [#14448](https://github.com/apache/superset/pull/14448) chore: Removes less from SliceAdder (@michael-s-molina)
- [#14558](https://github.com/apache/superset/pull/14558) docs: Update docs for GLOBAL_ASYNC_QUERIES_TRANSPORT (@robdiciuccio)
- [#14650](https://github.com/apache/superset/pull/14650) chore: Register dynamic plugins and add feature checks (@benjreinhart)
- [#14469](https://github.com/apache/superset/pull/14469) chore: Replaces Icon with Icons component - iteration 1 (@michael-s-molina)
- [#14644](https://github.com/apache/superset/pull/14644) chore: Adjust language picker theme to match other menus (@michael-s-molina)
- [#14641](https://github.com/apache/superset/pull/14641) chore: Removes react-bootstrap and react-bootstrap-slider (@michael-s-molina)
- [#14568](https://github.com/apache/superset/pull/14568) chore: use before_request hook for dynamic routes (@benjreinhart)
- [#14633](https://github.com/apache/superset/pull/14633) chore: Bump pip-compile-multi (@john-bodley)
- [#14638](https://github.com/apache/superset/pull/14638) perf: memoize db_engine_spec in database (@villebro)
- [#14625](https://github.com/apache/superset/pull/14625) chore: Change name to `BaseParameters` to `BasicParameters` (@hughhhh)
- [#14546](https://github.com/apache/superset/pull/14546) chore: Consolidating form experience (Bootstrap to AntD) - iteration 4 (@michael-s-molina)
- [#14419](https://github.com/apache/superset/pull/14419) refactor: change xsm Icons and dnd icons to new dynamic icons (@pkdotson)
- [#14581](https://github.com/apache/superset/pull/14581) chore: Update `make py-format` to use pre-commit (@hughhhh)
- [#14227](https://github.com/apache/superset/pull/14227) build(deps): bump ssri from 6.0.1 to 6.0.2 in /docs (@dependabot[bot])
- [#14569](https://github.com/apache/superset/pull/14569) style: adds padding badges to look less claustrophobic (@rusackas)
- [#14536](https://github.com/apache/superset/pull/14536) docs: typo on CONTRIBUTING.md (@Bonifacio2)
- [#14556](https://github.com/apache/superset/pull/14556) chore: Update FAB to 3.3.0 (@benjreinhart)
- [#14476](https://github.com/apache/superset/pull/14476) chore: Adding logging for datasource/save requests (@michellethomas)
- [#13095](https://github.com/apache/superset/pull/13095) chore: update CONTRIBUTING.md tag --lts (@bawantha)
- [#14364](https://github.com/apache/superset/pull/14364) refactor: remove panel from userinfo component (@pkdotson)
- [#14184](https://github.com/apache/superset/pull/14184) refactor(navbar): migrate Bootstrap navbar to AntD menus (@pkdotson)
- [#14496](https://github.com/apache/superset/pull/14496) chore: Removes tabs pane animation by default (@michael-s-molina)
- [#14502](https://github.com/apache/superset/pull/14502) refactor: Bootstrap to AntD - Form - iteration 3 (@michael-s-molina)
- [#14513](https://github.com/apache/superset/pull/14513) docs(UPDATING): Adding downtime for #14234 (@john-bodley)
- [#14412](https://github.com/apache/superset/pull/14412) chore: Improved translation into Russian language (@aleksandrgordienko)
- [#14515](https://github.com/apache/superset/pull/14515) chore: bump superset-ui to 0.17.44 (@villebro)
- [#14494](https://github.com/apache/superset/pull/14494) refactor(utils): replace strtobool with parse_boolean_string (@villebro)
- [#14380](https://github.com/apache/superset/pull/14380) chore: Moves spec files to the src folder - iteration 4 (@michael-s-molina)
- [#14379](https://github.com/apache/superset/pull/14379) refactor: Bootstrap to AntD - Form - iteration 2 (@michael-s-molina)
- [#14195](https://github.com/apache/superset/pull/14195) chore: Adds QueryParamProvider to the testing helper (@michael-s-molina)
- [#14497](https://github.com/apache/superset/pull/14497) test: Attempt to reduce asyncEvent test flakiness (@robdiciuccio)
- [#14477](https://github.com/apache/superset/pull/14477) chore: bump sankey and pivot table chart to 0.17.43 (@ktmud)
- [#14418](https://github.com/apache/superset/pull/14418) chore: Removes common storybook (@michael-s-molina)
- [#14485](https://github.com/apache/superset/pull/14485) chore: Move styles from .less stylesheet to emotion in Explore (@kgabryje)
- [#14417](https://github.com/apache/superset/pull/14417) chore: Update WebSocket server code from feedback (@benjreinhart)
- [#14454](https://github.com/apache/superset/pull/14454) chore: upgrade @emotion (@ktmud)
- [#14356](https://github.com/apache/superset/pull/14356) chore(dashboard): Integrate dashboard app into the SPA bundle (@suddjian)
- [#14436](https://github.com/apache/superset/pull/14436) refactor: split db modal file (@eschutho)
- [#14382](https://github.com/apache/superset/pull/14382) chore: add stack trace to all calls of logger.error (@samtfm)
- [#14432](https://github.com/apache/superset/pull/14432) docs: update README with new docs and recordings (@srinify)
- [#14425](https://github.com/apache/superset/pull/14425) docs: Renamed impyla from implya and updated PIP name to impyla from impala. (@jagamts1)

### 1.2.0 (2021-06-04)
**Features**
- [11498](https://github.com/apache/superset/pull/11498) feat(SIP-39): Websocket sidecar app (#11498) (@Rob DiCiuccio)
- [13894](https://github.com/apache/superset/pull/13894) feat(alert/report): add ALERTS_ATTACH_REPORTS feature flags + feature (#13894) (@Lily Kuang)
- [13828](https://github.com/apache/superset/pull/13828) feat(alert/report): chart as csv format attachment for email and slack (#13828) (@Lily Kuang)
- [14235](https://github.com/apache/superset/pull/14235) feat(alert/report): update content format radio buttons (#14235) (@Lily Kuang)
- [13752](https://github.com/apache/superset/pull/13752) feat(alerts & reports): Easier to read execution logs (#13752) (@Jack Fragassi)
- [14076](https://github.com/apache/superset/pull/14076) feat(can_share): can share chart and dashboard (#14076) (@Amit Miran)
- [13687](https://github.com/apache/superset/pull/13687) feat(cross-filter): Cross filter badge (#13687) (@simcha90)
- [13625](https://github.com/apache/superset/pull/13625) feat(cross-filters): Add scoping for cross filters (#13625) (@simcha90)
- [13523](https://github.com/apache/superset/pull/13523) feat(dashboard): dashboard/id/datasets endpoint (#13523) (@David Aaron Suddjian)
- [13145](https://github.com/apache/superset/pull/13145) feat(dashboard_rbac): manage roles for dashboard (#13145) (@simcha90)
- [13992](https://github.com/apache/superset/pull/13992) feat(dashboard_rbac): provide data access based on dashboard access (#13992) (@Amit Miran)
- [14519](https://github.com/apache/superset/pull/14519) feat(dremio): implement convert_dttm method (#14519) (@Ville Brofeldt)
- [13210](https://github.com/apache/superset/pull/13210) feat(explore): ColumnSelectControl with drag-and-drop (#13210) (@Yongjie Zhao)
- [13598](https://github.com/apache/superset/pull/13598) feat(explore): Drag and drop UX improvements (#13598) (@Kamil Gabryjelski)
- [13294](https://github.com/apache/superset/pull/13294) feat(explore): Postgres datatype conversion (#13294) (@Nikola Gigić)
- [13758](https://github.com/apache/superset/pull/13758) feat(explore): adhoc column formatting for Table chart (#13758) (@Jesse Yang)
- [14340](https://github.com/apache/superset/pull/14340) feat(filter-box): sort by metric on backend (#14340) (@Ville Brofeldt)
- [13576](https://github.com/apache/superset/pull/13576) feat(filter-set): Filter set edge cases (#13576) (@simcha90)
- [13529](https://github.com/apache/superset/pull/13529) feat(filter-set): Filter set history (#13529) (@simcha90)
- [13545](https://github.com/apache/superset/pull/13545) feat(filter-set): Update existing filter set (#13545) (@simcha90)
- [13515](https://github.com/apache/superset/pull/13515) feat(filter-set): adding new filters (#13515) (@simcha90)
- [13678](https://github.com/apache/superset/pull/13678) feat(helm): Add optional apt-get install to superset_bootstrap.sh (#13678) (@Daniel Wood)
- [14030](https://github.com/apache/superset/pull/14030) feat(helm): add pod and deployment annotations to template (#14030) (@Bruno FERNANDO)
- [13683](https://github.com/apache/superset/pull/13683) feat(homescreen and cards): Toggle thumbnails off or on and feature flag (#13683) (@Phillip Kelley-Dotson)
- [13726](https://github.com/apache/superset/pull/13726) feat(native-filters): Add default first value to select filter (#13726) (@simcha90)
- [14461](https://github.com/apache/superset/pull/14461) feat(native-filters): Auto apply changes in FiltersConfigModal (#14461) (@simcha90)
- [13507](https://github.com/apache/superset/pull/13507) feat(native-filters): Filter set tabs (#13507) (@simcha90)
- [14313](https://github.com/apache/superset/pull/14313) feat(native-filters): Implement adhoc filters and time picker in Range and Select native filters (#14313) (@Kamil Gabryjelski)
- [14261](https://github.com/apache/superset/pull/14261) feat(native-filters): Show/Hide filter bar by metdata ff (#14261) (@simcha90)
- [13506](https://github.com/apache/superset/pull/13506) feat(native-filters): Update filter bar buttons (#13506) (@simcha90)
- [14374](https://github.com/apache/superset/pull/14374) feat(native-filters): Use datasets in dashboard as default options for native filters (#14374) (@Kamil Gabryjelski)
- [14314](https://github.com/apache/superset/pull/14314) feat(native-filters): add option to create value in select filter (#14314) (@Ville Brofeldt)
- [14346](https://github.com/apache/superset/pull/14346) feat(native-filters): add optional sort metric to select filter (#14346) (@Ville Brofeldt)
- [14375](https://github.com/apache/superset/pull/14375) feat(native-filters): add refresh button to default value picker (#14375) (@Ville Brofeldt)
- [13569](https://github.com/apache/superset/pull/13569) feat(native-filters): add sort option to select filter (#13569) (@Ville Brofeldt)
- [13622](https://github.com/apache/superset/pull/13622) feat(native-filters): add temporal support to select filter (#13622) (@Ville Brofeldt)
- [13484](https://github.com/apache/superset/pull/13484) feat(native-filters): add timegrain and column filter (#13484) (@Ville Brofeldt)
- [14312](https://github.com/apache/superset/pull/14312) feat(native-filters): add tooltip to control values (#14312) (@Ville Brofeldt)
- [14217](https://github.com/apache/superset/pull/14217) feat(native-filters): select group by support (#14217) (@Amit Miran)
- [13634](https://github.com/apache/superset/pull/13634) feat(reports): SLACK_API_TOKEN as callable or str (#13634) (@ʈᵃᵢ)
- [13135](https://github.com/apache/superset/pull/13135) feat(reports): send notification on error with grace (#13135) (@Daniel Vaz Gaspar)
- [13772](https://github.com/apache/superset/pull/13772) feat(rls): enable row level security by default (#13772) (@Ville Brofeldt)
- [14197](https://github.com/apache/superset/pull/14197) feat(viz): add mixed and radar chart (#14197) (@Ville Brofeldt)
- [13377](https://github.com/apache/superset/pull/13377) feat(viz): implement time picker on filter box (#13377) (@Yongjie Zhao)
- [13144](https://github.com/apache/superset/pull/13144) feat: Add error pages (#13144) (@Sam Faber-Manning)
- [14357](https://github.com/apache/superset/pull/14357) feat: Add etag caching to dashboard APIs (#14357) (@Erik Ritter)
- [14110](https://github.com/apache/superset/pull/14110) feat: Add health endpoint to WebSocket server (#14110) (@Ben Reinhart)
- [13190](https://github.com/apache/superset/pull/13190) feat: Added Rows Returned (#13190) (@AAfghahi)
- [14109](https://github.com/apache/superset/pull/14109) feat: Adding encrypted field factory (#14109) (@Craig Rueda)
- [14234](https://github.com/apache/superset/pull/14234) feat: Adding limiting_factor column to Query model (#14234) (@AAfghahi)
- [14318](https://github.com/apache/superset/pull/14318) feat: Dynamic imports for the Icons component (#14318) (@Geido)
- [13981](https://github.com/apache/superset/pull/13981) feat: FE: Export for Queries II (#13981) (@Lyndsi Kay Williams)
- [14091](https://github.com/apache/superset/pull/14091) feat: FE: Import for Queries II (#14091) (@Lyndsi Kay Williams)
- [13740](https://github.com/apache/superset/pull/13740) feat: Implement Celery SoftTimeLimit handling (#13740) (@Lily Kuang)
- [13340](https://github.com/apache/superset/pull/13340) feat: Implement drag and drop columns for filters (#13340) (@Kamil Gabryjelski)
- [13575](https://github.com/apache/superset/pull/13575) feat: Implement drag and drop for metrics (#13575) (@Kamil Gabryjelski)
- [13521](https://github.com/apache/superset/pull/13521) feat: Logic added to limiting factor column in Query model (#13521) (@AAfghahi)
- [14007](https://github.com/apache/superset/pull/14007) feat: Make async query JWT cookie domain configurable (#14007) (@Ben Reinhart)
- [12862](https://github.com/apache/superset/pull/12862) feat: Make initial user configurable in helm chart (#12862) (@Andreas Eberle)
- [13696](https://github.com/apache/superset/pull/13696) feat: Refactor asyncEvent middleware and add websocket support (#13696) (@Rob DiCiuccio)
- [14256](https://github.com/apache/superset/pull/14256) feat: Setup `supersetText` configuration to overwrite errors (#14256) (@Hugh A. Miles II)
- [14398](https://github.com/apache/superset/pull/14398) feat: Support env vars configuration for WebSocket server (#14398) (@Ben Reinhart)
- [14008](https://github.com/apache/superset/pull/14008) feat: Support feature flag overrides in ephemeral test envs (#14008) (@Rob DiCiuccio)
- [14122](https://github.com/apache/superset/pull/14122) feat: TrinoEngineSpec.adjust_database_uri (#14122) (@Đặng Minh Dũng)
- [13662](https://github.com/apache/superset/pull/13662) feat: add 'extra' column to saved_queries GET (#13662) (@Maxime Beauchemin)
- [13682](https://github.com/apache/superset/pull/13682) feat: add Databricks DB engine spec (#13682) (@Beto Dealmeida)
- [14072](https://github.com/apache/superset/pull/14072) feat: add Echarts gauge chart (#14072) (@krsnik93)
- [13584](https://github.com/apache/superset/pull/13584) feat: add ErrorBoundary to chart controls (#13584) (@Jesse Yang)
- [14267](https://github.com/apache/superset/pull/14267) feat: add alerts & reports to docker compose (#14267) (@Daniel Vaz Gaspar)
- [13152](https://github.com/apache/superset/pull/13152) feat: add connector for CrateDB (#13152) (@Srini Kadamati)
- [13827](https://github.com/apache/superset/pull/13827) feat: add descriptions to report emails (#13827) (@Sam Faber-Manning)
- [14208](https://github.com/apache/superset/pull/14208) feat: add endpoint to fetch available DBs (#14208) (@Beto Dealmeida)
- [13468](https://github.com/apache/superset/pull/13468) feat: add event_logger to test_connection and create_database commands (#13468) (@Hugh A. Miles II)
- [13997](https://github.com/apache/superset/pull/13997) feat: add extract_errors to Postgres (#13997) (@Beto Dealmeida)
- [13586](https://github.com/apache/superset/pull/13586) feat: add more big data for testing (#13586) (@Beto Dealmeida)
- [13448](https://github.com/apache/superset/pull/13448) feat: add option to load big/wide tables (#13448) (@Beto Dealmeida)
- [13364](https://github.com/apache/superset/pull/13364) feat: add unit test for LimitMethod.FETCH_MANY (#13364) (@Beto Dealmeida)
- [13606](https://github.com/apache/superset/pull/13606) feat: add warning metadata to tables and metrics (#13606) (@Erik Ritter)
- [13610](https://github.com/apache/superset/pull/13610) feat: added support to configure the default explorer viz (#13610) (@cccs-jc)
- [13601](https://github.com/apache/superset/pull/13601) feat: better error message when adding DBs (#13601) (@Beto Dealmeida)
- [14250](https://github.com/apache/superset/pull/14250) feat: catch errors on do_ping (#14250) (@Beto Dealmeida)
- [13893](https://github.com/apache/superset/pull/13893) feat: create backend routes and API for importing saved queries (#13893) (@AAfghahi)
- [13487](https://github.com/apache/superset/pull/13487) feat: create hooks to redux component (#13487) (@AAfghahi)
- [13871](https://github.com/apache/superset/pull/13871) feat: create table with long name (#13871) (@Beto Dealmeida)
- [14172](https://github.com/apache/superset/pull/14172) feat: error messages for Presto connections  (#14172) (@Beto Dealmeida)
- [14093](https://github.com/apache/superset/pull/14093) feat: error messages when connecting to MSSQL (#14093) (@Beto Dealmeida)
- [14171](https://github.com/apache/superset/pull/14171) feat: error messages when connecting to mssql (#14171) (@AAfghahi)
- [14040](https://github.com/apache/superset/pull/14040) feat: handle chart/data API errors (#14040) (@Erik Ritter)
- [14204](https://github.com/apache/superset/pull/14204) feat: improve engine spec discoverability (#14204) (@Beto Dealmeida)
- [13960](https://github.com/apache/superset/pull/13960) feat: initial work to make v1 API compatible with SIP-40 and SIP-41 (#13960) (@Beto Dealmeida)
- [14146](https://github.com/apache/superset/pull/14146) feat: invalid DB name error messages (MySQL/Postgres/Redshift)  (#14146) (@AAfghahi)
- [14089](https://github.com/apache/superset/pull/14089) feat: invalid hostname and password error messages (MySQL) (#14089) (@AAfghahi)
- [14111](https://github.com/apache/superset/pull/14111) feat: invalid hostname and password error messages (Redshift) (#14111) (@AAfghahi)
- [14038](https://github.com/apache/superset/pull/14038) feat: invalid password error message (Postgres) (#14038) (@Beto Dealmeida)
- [13862](https://github.com/apache/superset/pull/13862) feat: only send alert error emails to owners of the alert (#13862) (@Sam Faber-Manning)
- [14163](https://github.com/apache/superset/pull/14163) feat: publish superset helm chart (#14163) (@jawabuu)
- [13441](https://github.com/apache/superset/pull/13441) feat: refactor on DBEventLogger to allow for context management (#13441) (@Hugh A. Miles II)
- [14092](https://github.com/apache/superset/pull/14092) feat: restyle database modal (#14092) (@Elizabeth Thompson)
- [13561](https://github.com/apache/superset/pull/13561) feat: script to benchmark DB migrations (#13561) (@Beto Dealmeida)
- [13720](https://github.com/apache/superset/pull/13720) feat: sort time grain configs (#13720) (@Elizabeth Thompson)
- [13743](https://github.com/apache/superset/pull/13743) feat: use cross-env when running dev-server (#13743) (@Cemre Mengu)

**Fixes**
- [13585](https://github.com/apache/superset/pull/13585) fix antd select dropdown issue (#13585) (@Lily Kuang)
- [14369](https://github.com/apache/superset/pull/14369) fix error getting partitionQuery from table.partition (#14369) (@eriendeng)
- [13878](https://github.com/apache/superset/pull/13878) fix(#13378): Ensure g.user is set for impersonation (#13878) (@Ben Reinhart)
- [13756](https://github.com/apache/superset/pull/13756) fix(CI): use presto docker image from starburst (#13756) (@Jesse Yang)
- [13718](https://github.com/apache/superset/pull/13718) fix(alerts and reports): Unify timestamp format on execution log view (#13718) (@Jack Fragassi)
- [13436](https://github.com/apache/superset/pull/13436) fix(alerts&reports): add celery soft timeout support (#13436) (@Daniel Vaz Gaspar)
- [13911](https://github.com/apache/superset/pull/13911) fix(alerts/reports): working timeout with celery kill and logic fix (#13911) (@Daniel Vaz Gaspar)
- [14483](https://github.com/apache/superset/pull/14483) fix(annotations): pass force param to annotation request (#14483) (@Ville Brofeldt)
- [14526](https://github.com/apache/superset/pull/14526) fix(chart-data): handle url_params in csv export and native filters (#14526) (@Ville Brofeldt)
- [13945](https://github.com/apache/superset/pull/13945) fix(colors): fix color schemes (#13945) (@simcha90)
- [14063](https://github.com/apache/superset/pull/14063) fix(country-map): update geojson and control layout (#14063) (@Jesse Yang)
- [13665](https://github.com/apache/superset/pull/13665) fix(cross-filter): fix scheme py (#13665) (@simcha90)
- [14220](https://github.com/apache/superset/pull/14220) fix(cross-filters): Fix missed metadata (#14220) (@simcha90)
- [13692](https://github.com/apache/superset/pull/13692) fix(cross-filters): add a control panel to range filter (#13692) (@Ville Brofeldt)
- [13703](https://github.com/apache/superset/pull/13703) fix(cross-filters): expand relevant indicator sections (#13703) (@Ville Brofeldt)
- [13704](https://github.com/apache/superset/pull/13704) fix(cross-filters): only apply filters if ff is set (#13704) (@Ville Brofeldt)
- [13825](https://github.com/apache/superset/pull/13825) fix(cypress): avoid referencing detached dom nodes (#13825) (@David Aaron Suddjian)
- [14306](https://github.com/apache/superset/pull/14306) fix(dashboard): Add caching for dashboard datasets (#14306) (@David Aaron Suddjian)
- [13352](https://github.com/apache/superset/pull/13352) fix(dashboard): Get dashboard by slug (#13352) (@David Aaron Suddjian)
- [14207](https://github.com/apache/superset/pull/14207) fix(dashboard): draft dashboards should be viewable (#14207) (@Jesse Yang)
- [14129](https://github.com/apache/superset/pull/14129) fix(dashboard): filter set hydration not working (#14129) (@Ville Brofeldt)
- [14148](https://github.com/apache/superset/pull/14148) fix(dashboard): incorrect perm for users with multiple roles (#14148) (@Jesse Yang)
- [13691](https://github.com/apache/superset/pull/13691) fix(dashboard): missing parents in directPathToFilter (#13691) (@Ville Brofeldt)
- [13769](https://github.com/apache/superset/pull/13769) fix(dashboard): rename native filter configuration property (#13769) (@Ville Brofeldt)
- [13652](https://github.com/apache/superset/pull/13652) fix(datasets): log create exceptions as warning (#13652) (@ʈᵃᵢ)
- [14295](https://github.com/apache/superset/pull/14295) fix(db2): change name and add legacy alias (#14295) (@Ville Brofeldt)
- [14362](https://github.com/apache/superset/pull/14362) fix(emotion): add separate namespace for menu app (#14362) (@ʈᵃᵢ)
- [13826](https://github.com/apache/superset/pull/13826) fix(errors): Downgrade error on stop query to a warning (#13826) (@Will Barrett)
- [13621](https://github.com/apache/superset/pull/13621) fix(explore): Add int and bool regex pattern (#13621) (@Nikola Gigić)
- [14194](https://github.com/apache/superset/pull/14194) fix(explore): CUSTOM SQL tab should automatically update (#14194) (@Yaozong Liu)
- [13566](https://github.com/apache/superset/pull/13566) fix(explore): make horizontal scroll appears in data panel (#13566) (@Yaozong Liu)
- [13473](https://github.com/apache/superset/pull/13473) fix(explore): make sure sort by metric is not duplicated (#13473) (@Jesse Yang)
- [13801](https://github.com/apache/superset/pull/13801) fix(explore): strip semicolons in virtual table SQL (#13801) (@Phillip Kelley-Dotson)
- [13613](https://github.com/apache/superset/pull/13613) fix(helm): Add missing extraConfigs template volume mapping and fix type error on template. (#13613) (@Daniel Wood)
- [14255](https://github.com/apache/superset/pull/14255) fix(hive): Update CSV to Hive upload prefix (#14255) (@John Bodley)
- [14240](https://github.com/apache/superset/pull/14240) fix(hive): Use parquet rather than textfile when uploading CSV files to Hive (#14240) (@John Bodley)
- [13906](https://github.com/apache/superset/pull/13906) fix(listview): update listview feature flag (#13906) (@Phillip Kelley-Dotson)
- [14332](https://github.com/apache/superset/pull/14332) fix(native-filters): Fix first loading of charts (#14332) (@simcha90)
- [14334](https://github.com/apache/superset/pull/14334) fix(native-filters): Fix indicators (#14334) (@simcha90)
- [14370](https://github.com/apache/superset/pull/14370) fix(native-filters): Update filter saving (#14370) (@simcha90)
- [13837](https://github.com/apache/superset/pull/13837) fix(native-filters): add global async query support to native filters (#13837) (@Ville Brofeldt)
- [14353](https://github.com/apache/superset/pull/14353) fix(native-filters): allowClear only when required not checked (#14353) (@Ville Brofeldt)
- [14409](https://github.com/apache/superset/pull/14409) fix(native-filters): always show filters without dataset (#14409) (@Ville Brofeldt)
- [14401](https://github.com/apache/superset/pull/14401) fix(native-filters): default value not populated on second opening (#14401) (@Ville Brofeldt)
- [14426](https://github.com/apache/superset/pull/14426) fix(native-filters): fix filter scope error (#14426) (@Ville Brofeldt)
- [14387](https://github.com/apache/superset/pull/14387) fix(native-filters): fix lint (#14387) (@simcha90)
- [14218](https://github.com/apache/superset/pull/14218) fix(native-filters): fix remove native filters (#14218) (@simcha90)
- [13688](https://github.com/apache/superset/pull/13688) fix(native-filters): fix removing native filter (#13688) (@simcha90)
- [14385](https://github.com/apache/superset/pull/14385) fix(native-filters): force update control value on change (#14385) (@Ville Brofeldt)
- [13794](https://github.com/apache/superset/pull/13794) fix(native-filters): improve loading styles for filter component (#13794) (@Ville Brofeldt)
- [14244](https://github.com/apache/superset/pull/14244) fix(native-filters): merge_extra_form_data extras processing (#14244) (@Ville Brofeldt)
- [13434](https://github.com/apache/superset/pull/13434) fix(query): order by adhoc metrics should trigger group by (#13434) (@Jesse Yang)
- [13331](https://github.com/apache/superset/pull/13331) fix(query-object): extra time-range-endpoints (#13331) (@John Bodley)
- [14014](https://github.com/apache/superset/pull/14014) fix(sqla): apply sqla type on calculated columns (#14014) (@Ville Brofeldt)
- [14095](https://github.com/apache/superset/pull/14095) fix(sqla): labels_expected contains mutated label (#14095) (@Ville Brofeldt)
- [14297](https://github.com/apache/superset/pull/14297) fix(sqla): timeseries limit not applied when using columns (#14297) (@Ville Brofeldt)
- [13739](https://github.com/apache/superset/pull/13739) fix(sqla-query): order by aggregations in Presto and Hive (#13739) (@Jesse Yang)
- [13636](https://github.com/apache/superset/pull/13636) fix(sqllab): Table name and schema are encoded twice during fetching table metadata on SQL Lab page. (#13636) (@Dmytro Mudrov)
- [14390](https://github.com/apache/superset/pull/14390) fix(sqllab): fix error due to anonymous user (#14390) (@Ville Brofeldt)
- [13288](https://github.com/apache/superset/pull/13288) fix(sqllab): per-tab hide left bar (#13288) (@Beto Dealmeida)
- [13841](https://github.com/apache/superset/pull/13841) fix(sqllab): warning message when rows limited (#13841) (@zuzana-vej)
- [14045](https://github.com/apache/superset/pull/14045) fix(viz): bump superset-ui 0.17.30 (#14045) (@Ville Brofeldt)
- [14438](https://github.com/apache/superset/pull/14438) fix(viz): bump superset-ui to fix bugs in table and graph chart (#14438) (@Jesse Yang)
- [14191](https://github.com/apache/superset/pull/14191) fix(viz): time shift read-only error (#14191) (@Ville Brofeldt)
- [13657](https://github.com/apache/superset/pull/13657) fix: 'Run in SQL Lab' redirect bug (#13657) (@Maxime Beauchemin)
- [13444](https://github.com/apache/superset/pull/13444) fix: API to allow importing old exports (JSON/YAML) (#13444) (@Beto Dealmeida)
- [14180](https://github.com/apache/superset/pull/14180) fix: Add extra requires for shillelagh (#14180) (@Erik Ritter)
- [14192](https://github.com/apache/superset/pull/14192) fix: Center each import icon and add a tooltip II (#14192) (@Lyndsi Kay Williams)
- [13859](https://github.com/apache/superset/pull/13859) fix: Check for permissions in FilterBox (#13859) (@Erik Ritter)
- [14317](https://github.com/apache/superset/pull/14317) fix: Cleanup serialization and hashing code (#14317) (@Ben Reinhart)
- [13972](https://github.com/apache/superset/pull/13972) fix: Data table z index in sql Editor (#13972) (@AAfghahi)
- [13749](https://github.com/apache/superset/pull/13749) fix: Disallows negative options remaining (#13749) (@Michael S. Molina)
- [14291](https://github.com/apache/superset/pull/14291) fix: Fix unintended cache misses with async queries (#14291) (@Ben Reinhart)
- [14086](https://github.com/apache/superset/pull/14086) fix: Fixed saved query export (#14086) (@Lyndsi Kay Williams)
- [13858](https://github.com/apache/superset/pull/13858) fix: Floating Menu in SQL Left Bar (#13858) (@AAfghahi)
- [14147](https://github.com/apache/superset/pull/14147) fix: Handle bad permission errors for bigquery test connections (#14147) (@Hugh A. Miles II)
- [13980](https://github.com/apache/superset/pull/13980) fix: Issue 13956 (#13980) (@John Bodley)
- [13602](https://github.com/apache/superset/pull/13602) fix: ParsedQuery subselect edge case (#13602) (@Erik Ritter)
- [13987](https://github.com/apache/superset/pull/13987) fix: Pie chart not displayed in viz (#13987) (@Yongjie Zhao)
- [13852](https://github.com/apache/superset/pull/13852) fix: Pin Prophet dependency after breaking changes (#13852) (@Étienne Boisseau-Sierra)
- [13469](https://github.com/apache/superset/pull/13469) fix: Remove view in sql lab from druid datasources (#13469) (@Erik Ritter)
- [13464](https://github.com/apache/superset/pull/13464) fix: SHOW is not DML (#13464) (@Beto Dealmeida)
- [13946](https://github.com/apache/superset/pull/13946) fix: SQL -> Explore Overwrite flow (#13946) (@Hugh A. Miles II)
- [14358](https://github.com/apache/superset/pull/14358) fix: SQL Statement on QUERY_LOGGER prints none to log (#14358) (@cccs-rc)
- [14372](https://github.com/apache/superset/pull/14372) fix: SQLLab role permissions (#14372) (@Daniel Vaz Gaspar)
- [13655](https://github.com/apache/superset/pull/13655) fix: Slack dashboard has stale charts (#13655) (@Beto Dealmeida)
- [14170](https://github.com/apache/superset/pull/14170) fix: Switching to local codecov script (#14170) (@Craig Rueda)
- [13974](https://github.com/apache/superset/pull/13974) fix: Use superset generic db to catch external_metadata queries (#13974) (@Hugh A. Miles II)
- [13830](https://github.com/apache/superset/pull/13830) fix: Use utils.json_iso_dttm_ser to dump jsons when async query execution (#13830) (@Carlos Fidel Selva Ochoa)
- [13496](https://github.com/apache/superset/pull/13496) fix: `IS NULL` filter operator for numeric columns (#13496) (@Jesse Yang)
- [14036](https://github.com/apache/superset/pull/14036) fix: add exception to catch session not having JWT (#14036) (@Hugh A. Miles II)
- [13822](https://github.com/apache/superset/pull/13822) fix: adjusted tab height (#13822) (@AAfghahi)
- [13488](https://github.com/apache/superset/pull/13488) fix: allow option to generate new query (#13488) (@Elizabeth Thompson)
- [13800](https://github.com/apache/superset/pull/13800) fix: allow spaces in DB names (#13800) (@Beto Dealmeida)
- [13563](https://github.com/apache/superset/pull/13563) fix: always pass a string as a value to ace editor (#13563) (@Elizabeth Thompson)
- [12341](https://github.com/apache/superset/pull/12341) fix: annotation layer modal err handling (#12341) (@Moriah Kreeger)
- [13969](https://github.com/apache/superset/pull/13969) fix: annotation modal dateRangePicker saved invalid value (#13969) (@Yongjie Zhao)
- [13790](https://github.com/apache/superset/pull/13790) fix: bad copy-and-paste in API spec (#13790) (@Beto Dealmeida)
- [13578](https://github.com/apache/superset/pull/13578) fix: better handle datasource exceptions (#13578) (@Daniel Vaz Gaspar)
- [13642](https://github.com/apache/superset/pull/13642) fix: bump FAB to 3.2.1, SQLAlchemy fix (#13642) (@Daniel Vaz Gaspar)
- [13868](https://github.com/apache/superset/pull/13868) fix: change status code for generic errors to 400 (#13868) (@Hugh A. Miles II)
- [13681](https://github.com/apache/superset/pull/13681) fix: clean up incorrect usage of TypeScript type in PropTypes (#13681) (@Jesse Yang)
- [14084](https://github.com/apache/superset/pull/14084) fix: custom TimeRange can not input value (#14084) (@Yongjie Zhao)
- [13695](https://github.com/apache/superset/pull/13695) fix: dashboard filter scope bug (#13695) (@Grace Guo)
- [13624](https://github.com/apache/superset/pull/13624) fix: data column in SQL lab left panel open by default  (#13624) (@AAfghahi)
- [13330](https://github.com/apache/superset/pull/13330) fix: date picker support date unit with singular and plural (#13330) (@Yongjie Zhao)
- [13603](https://github.com/apache/superset/pull/13603) fix: default when adding tab_state.hide_left_bar (#13603) (@Beto Dealmeida)
- [13389](https://github.com/apache/superset/pull/13389) fix: delete dataset columns and metrics on the REST API (#13389) (@Daniel Vaz Gaspar)
- [13917](https://github.com/apache/superset/pull/13917) fix: do not run containers as root by default in Helm chart (#13917) (@Stanislav Simovski)
- [13926](https://github.com/apache/superset/pull/13926) fix: enable installing docker/requirements-local.txt in docker-compose-non-dev.yml (#13926) (@ʈᵃᵢ)
- [13998](https://github.com/apache/superset/pull/13998) fix: execution log crashes for logs with no uuid (#13998) (@Jack Fragassi)
- [14081](https://github.com/apache/superset/pull/14081) fix: fix bug when remove chart not  removing it's related cross filter data (#14081) (@simcha90)
- [13546](https://github.com/apache/superset/pull/13546) fix: fix initial filter loading (#13546) (@simcha90)
- [14082](https://github.com/apache/superset/pull/14082) fix: flacky test in test_update_dataset_item_w_override_columns (#14082) (@Hugh A. Miles II)
- [14347](https://github.com/apache/superset/pull/14347) fix: flaky test for alerts and reports (#14347) (@Daniel Vaz Gaspar)
- [13979](https://github.com/apache/superset/pull/13979) fix: import dataset/dashboard empty keys (#13979) (@Beto Dealmeida)
- [14258](https://github.com/apache/superset/pull/14258) fix: incorrect module reference (#14258) (@Yongjie Zhao)
- [13737](https://github.com/apache/superset/pull/13737) fix: log exceptions for thumbnail generation as warnings (#13737) (@Sam Faber-Manning)
- [14057](https://github.com/apache/superset/pull/14057) fix: logs table - user_id is NULL (#14057) (@Hugh A. Miles II)
- [13493](https://github.com/apache/superset/pull/13493) fix: merge 67da9ef1ef9c and 1412ec1e5a7b migrations (#13493) (@Hugh A. Miles II)
- [13921](https://github.com/apache/superset/pull/13921) fix: new import/export CLI (#13921) (@Beto Dealmeida)
- [13955](https://github.com/apache/superset/pull/13955) fix: null exception from adhoc metric popover (#13955) (@Grace Guo)
- [14509](https://github.com/apache/superset/pull/14509) fix: parameterize titles correctly (#14509) (@David Aaron Suddjian)
- [14338](https://github.com/apache/superset/pull/14338) fix: pybabel extract fails (#14338) (@ume)
- [13780](https://github.com/apache/superset/pull/13780) fix: restart superset container in test script (#13780) (@Ben Reinhart)
- [13694](https://github.com/apache/superset/pull/13694) fix: select table overlay (#13694) (@AAfghahi)
- [14074](https://github.com/apache/superset/pull/14074) fix: unable to apply logging format (#14074) (@Yongjie Zhao)
- [14319](https://github.com/apache/superset/pull/14319) fix: unbreak CI (#14319) (@Erik Ritter)
- [13679](https://github.com/apache/superset/pull/13679) fix: use FeatureFlags in @superset-ui/core (#13679) (@Jesse Yang)
- [14099](https://github.com/apache/superset/pull/14099) fix:fix get permission function (#14099) (@simcha90)

**Documentation**
- [13770](https://github.com/apache/superset/pull/13770) docs(contributing): fix backend port (#13770) (@Cemre Mengu)
- [13813](https://github.com/apache/superset/pull/13813) docs: Documenting how to debug Flask app (#13813) (@cccs-jc)
- [13455](https://github.com/apache/superset/pull/13455) docs: Fix typo in footer (#13455) (@Holger Stitz)
- [14304](https://github.com/apache/superset/pull/14304) docs: add publish step (#14304) (@ʈᵃᵢ)
- [13611](https://github.com/apache/superset/pull/13611) docs: correct sentence (#13611) (@Erfan Mirzapour)
- [13440](https://github.com/apache/superset/pull/13440) docs: deprecate old alerts and dash/charts reports (#13440) (@Daniel Vaz Gaspar)
- [14394](https://github.com/apache/superset/pull/14394) docs: improved clickhouse connection details (#14394) (@Srini Kadamati)
- [14321](https://github.com/apache/superset/pull/14321) docs: multiple small fixes around databases (#14321) (@Srini Kadamati)
- [12932](https://github.com/apache/superset/pull/12932) docs: update helm documentation (#12932) (@Anthony Corletti)
- [14027](https://github.com/apache/superset/pull/14027) docs: update outdated country map tools instructions (#14027) (@Jesse Yang)
- [13781](https://github.com/apache/superset/pull/13781) docs: update setup instructions (#13781) (@Ben Reinhart)

**Other**
- [13759](https://github.com/apache/superset/pull/13759) Add CODEOWNERS (#13759) (@Rob DiCiuccio)
- [14238](https://github.com/apache/superset/pull/14238) Add Preset code owners for ephemeral test env workflows (#14238) (@Rob DiCiuccio)
- [13553](https://github.com/apache/superset/pull/13553) Add dedicated dir and storybook (#13553) (@Geido)
- [13961](https://github.com/apache/superset/pull/13961) Add docs for configuring Docker Compose setup (#13961) (@Alex Kreidler)
- [13728](https://github.com/apache/superset/pull/13728) Add extraSecrets config to allow specifying extra secret files (#13728) (@Andreas Eberle)
- [14223](https://github.com/apache/superset/pull/14223) Add superset helm repository (#14223) (@jawabuu)
- [13778](https://github.com/apache/superset/pull/13778) Add tests (#13778) (@Geido)
- [13950](https://github.com/apache/superset/pull/13950) Add tests for FilterBar CascadeFilterControl (#13950) (@Geido)
- [13425](https://github.com/apache/superset/pull/13425) Adding v0 import/export fields to dashboard metadata schema (#13425) (@michellethomas)
- [13359](https://github.com/apache/superset/pull/13359) Adds tests and storybook to CopyToClipboard component (#13359) (@Michael S. Molina)
- [13658](https://github.com/apache/superset/pull/13658) Bump pyyaml to latest (#13658) (@Rob DiCiuccio)
- [13854](https://github.com/apache/superset/pull/13854) Displays row limit warning with Alert component (#13854) (@Michael S. Molina)
- [14187](https://github.com/apache/superset/pull/14187) Enable the new pivot table (#14187) (@Kamil Gabryjelski)
- [13861](https://github.com/apache/superset/pull/13861) Fix broken link (#13861) (@Eric Anderson)
- [14039](https://github.com/apache/superset/pull/14039) Fix broken port-forward instructions (#14039) (@Caleb Collins-Parks)
- [14243](https://github.com/apache/superset/pull/14243) Fix filter edit popover not opening in DnD mode (#14243) (@Kamil Gabryjelski)
- [13608](https://github.com/apache/superset/pull/13608) Fix: Add SASL dependency module (#13608) (@Daniel Wood)
- [13505](https://github.com/apache/superset/pull/13505) Fixed KeyError by making kwarg explicit (#13505) (@Richard Nordin)
- [13905](https://github.com/apache/superset/pull/13905) Fixing condition around left margin for dashboard layout. Fixes #13863 (#13905) (@Evan Rusackas)
- [14323](https://github.com/apache/superset/pull/14323) Fixing spelling: `clint` -> `client` (#14323) (@Chris Carini)
- [13570](https://github.com/apache/superset/pull/13570) Given port in dockerfile set to same port in config (#13570) (@İbrahim Ercan)
- [13273](https://github.com/apache/superset/pull/13273) Improves ButtonGroup tests (#13273) (@Michael S. Molina)
- [14046](https://github.com/apache/superset/pull/14046) Make chart exclude itself from cross filtering (#14046) (@Kamil Gabryjelski)
- [14287](https://github.com/apache/superset/pull/14287) Make g.user attribute access safe for public users (#14287) (@Rob DiCiuccio)
- [13643](https://github.com/apache/superset/pull/13643) Make preliminary suggested changes to CONTRIBUTING.md (#13643) (@Kris Stern)
- [13314](https://github.com/apache/superset/pull/13314) Moves AsyncSelect component and tests to own folder (#13314) (@Michael S. Molina)
- [13901](https://github.com/apache/superset/pull/13901) Revert "fix: select table overlay (#13694)" (#13901) (@Erik Ritter)
- [13876](https://github.com/apache/superset/pull/13876) Tests for "CrossFilterScopingModal/utils" (#13876) (@Bruno Motta)
- [13991](https://github.com/apache/superset/pull/13991) Tests for ColumnSelect (#13991) (@Bruno Motta)
- [13975](https://github.com/apache/superset/pull/13975) Tests for ControlItems (#13975) (@Bruno Motta)
- [13872](https://github.com/apache/superset/pull/13872) Tests for DetailsPanel (#13872) (@Bruno Motta)
- [14025](https://github.com/apache/superset/pull/14025) Update CONTRIBUTING.md (#14025) (@Hugh A. Miles II)
- [13607](https://github.com/apache/superset/pull/13607) Update UPDATING.md (#13607) (@Beto Dealmeida)
- [13934](https://github.com/apache/superset/pull/13934) Update docs to use the newer WEBDRIVER_TYPE name (#13934) (@Octavian)
- [14219](https://github.com/apache/superset/pull/14219) Update trino connection docs (#14219) (@Aakash Nand)
- [14031](https://github.com/apache/superset/pull/14031) Use consistent chart value (#14031) (@Tom Vendetta)
- [13323](https://github.com/apache/superset/pull/13323) Use redis:latest in docker-compose workflow (#13323) (@Rob DiCiuccio)
- [13730](https://github.com/apache/superset/pull/13730) Use stringData instead of data in Secrets and remove manual base64 encoding (#13730) (@Andreas Eberle)
- [13936](https://github.com/apache/superset/pull/13936) Use the right variable for Celery results in Redis (#13936) (@Octavian)
- [14252](https://github.com/apache/superset/pull/14252) WIP (#14252) (@Beto Dealmeida)
- [14446](https://github.com/apache/superset/pull/14446) add migration (#14446) (@Ville Brofeldt)
- [13365](https://github.com/apache/superset/pull/13365) add more documentation around python testing and linting (#13365) (@Elizabeth Thompson)
- [13527](https://github.com/apache/superset/pull/13527) build(deps): bump elliptic from 6.5.3 to 6.5.4 in /docs (#13527) (@dependabot[bot])
- [12636](https://github.com/apache/superset/pull/12636) build(deps): bump socket.io from 2.3.0 to 2.4.1 in /docs (#12636) (@dependabot[bot])
- [13391](https://github.com/apache/superset/pull/13391) build(deps): bump three from 0.68.87 to 0.125.0 in /docs (#13391) (@dependabot[bot])
- [13393](https://github.com/apache/superset/pull/13393) build(deps): bump urijs from 1.19.4 to 1.19.6 in /superset-frontend (#13393) (@dependabot[bot])
- [13874](https://github.com/apache/superset/pull/13874) build(deps): bump y18n from 4.0.0 to 4.0.1 in /docs (#13874) (@dependabot[bot])
- [13886](https://github.com/apache/superset/pull/13886) build(deps): bump y18n from 4.0.0 to 4.0.1 in /superset-frontend (#13886) (@dependabot[bot])
- [13452](https://github.com/apache/superset/pull/13452) build(test env): Shutdown test environments on PR close (#13452) (@Rob DiCiuccio)
- [13189](https://github.com/apache/superset/pull/13189) build: Ephemeral environments for PRs via slash command (#13189) (@Rob DiCiuccio)
- [13498](https://github.com/apache/superset/pull/13498) build: check potential db migration conflict for open PRs (#13498) (@Jesse Yang)
- [13375](https://github.com/apache/superset/pull/13375) build: fix codecov informational config (#13375) (@Jesse Yang)
- [13421](https://github.com/apache/superset/pull/13421) build: ignore Storybook stories in CodeCov (#13421) (@Jesse Yang)
- [13677](https://github.com/apache/superset/pull/13677) build: implement codecov carryforward flags (#13677) (@Jack Fragassi)
- [13927](https://github.com/apache/superset/pull/13927) catch collapse onchange (#13927) (@Elizabeth Thompson)
- [13757](https://github.com/apache/superset/pull/13757) chore(CI): dont run Hive tests on Py 3.7 (#13757) (@Jesse Yang)
- [13784](https://github.com/apache/superset/pull/13784) chore(cypress): Make the e2e tests more behavior-driven (#13784) (@David Aaron Suddjian)
- [13939](https://github.com/apache/superset/pull/13939) chore(dashboard): Datasource -> Dataset (#13939) (@David Aaron Suddjian)
- [14342](https://github.com/apache/superset/pull/14342) chore(docker-compose): use dev image for docker-compose-non-dev.yml (#14342) (@ʈᵃᵢ)
- [14331](https://github.com/apache/superset/pull/14331) chore(docs):  remove .py from db migrate -m (#14331) (@Amit Miran)
- [13660](https://github.com/apache/superset/pull/13660) chore(explore): added debounce in DateFilter (#13660) (@Yongjie Zhao)
- [13593](https://github.com/apache/superset/pull/13593) chore(explore): bump superset-ui 0.17.19 (#13593) (@Yongjie Zhao)
- [13767](https://github.com/apache/superset/pull/13767) chore(git): ignore superset/app/ folder (#13767) (@Cemre Mengu)
- [13500](https://github.com/apache/superset/pull/13500) chore(homepage): separate out api calls to make homepage load more dynamically (#13500) (@Phillip Kelley-Dotson)
- [14228](https://github.com/apache/superset/pull/14228) chore(prophet): bump prophet to 1.0.1 (#14228) (@Ville Brofeldt)
- [13306](https://github.com/apache/superset/pull/13306) chore(spa refactor): refactoring dashboard to use api's instead of bootstrapdata (#13306) (@Phillip Kelley-Dotson)
- [14013](https://github.com/apache/superset/pull/14013) chore(toggle thumbnails): use localstorage for toggle (#14013) (@Phillip Kelley-Dotson)
- [14274](https://github.com/apache/superset/pull/14274) chore: Add Redis password option to helm chart (#14274) (@Rob DiCiuccio)
- [13418](https://github.com/apache/superset/pull/13418) chore: Added rockset and firebird (#13418) (@Srini Kadamati)
- [13951](https://github.com/apache/superset/pull/13951) chore: Adds dataMask reducer to reducerIndex (#13951) (@Michael S. Molina)
- [14203](https://github.com/apache/superset/pull/14203) chore: Bumping lodash version in Superset (#14203) (@Evan Rusackas)
- [14196](https://github.com/apache/superset/pull/14196) chore: Code cleanup in DatabaseModal (#14196) (@Lyndsi Kay Williams)
- [14164](https://github.com/apache/superset/pull/14164) chore: Configures Jest to ignore storybook files when collecting coverage statistics (#14164) (@Michael S. Molina)
- [14339](https://github.com/apache/superset/pull/14339) chore: Improve Japanese translation (#14339) (@ume)
- [13722](https://github.com/apache/superset/pull/13722) chore: Improve Korean translation (#13722) (@김세환)
- [13376](https://github.com/apache/superset/pull/13376) chore: Improve japannese translation (#13376) (@Tetsushi Watanabe)
- [14193](https://github.com/apache/superset/pull/14193) chore: Improves Icons storybook (#14193) (@Michael S. Molina)
- [13274](https://github.com/apache/superset/pull/13274) chore: Migrates RefreshChartOverlay into Chart (#13274) (@Michael S. Molina)
- [13361](https://github.com/apache/superset/pull/13361) chore: Migrating dashboard/components/menu from jsx to tsx (#13361) (@Ayan Ginet)
- [13460](https://github.com/apache/superset/pull/13460) chore: Moves BootstrapSliderWrapper to own folder (#13460) (@Michael S. Molina)
- [14139](https://github.com/apache/superset/pull/14139) chore: Moves Card to the components folder (#14139) (@Michael S. Molina)
- [13454](https://github.com/apache/superset/pull/13454) chore: Moves ChartIcon to own folder (#13454) (@Michael S. Molina)
- [13459](https://github.com/apache/superset/pull/13459) chore: Moves CheckboxIcons to Checkbox folder (#13459) (@Michael S. Molina)
- [14124](https://github.com/apache/superset/pull/14124) chore: Moves Collapse to the components folder (#14124) (@Michael S. Molina)
- [14125](https://github.com/apache/superset/pull/14125) chore: Moves CronPicker to the components folder (#14125) (@Michael S. Molina)
- [14126](https://github.com/apache/superset/pull/14126) chore: Moves Dropdown to the components folder (#14126) (@Michael S. Molina)
- [14127](https://github.com/apache/superset/pull/14127) chore: Moves DropdownButton to the components folder (#14127) (@Michael S. Molina)
- [13458](https://github.com/apache/superset/pull/13458) chore: Moves Fade component into TableElement (#13458) (@Michael S. Molina)
- [13322](https://github.com/apache/superset/pull/13322) chore: Moves FilterableTable test to component folder (#13322) (@Michael S. Molina)
- [13485](https://github.com/apache/superset/pull/13485) chore: Moves InfoTooltip component to own folder (#13485) (@Michael S. Molina)
- [14128](https://github.com/apache/superset/pull/14128) chore: Moves InfoTooltip to the components folder (#14128) (@Michael S. Molina)
- [13324](https://github.com/apache/superset/pull/13324) chore: Moves ListView test to component folder (#13324) (@Michael S. Molina)
- [14130](https://github.com/apache/superset/pull/14130) chore: Moves Modal to the components folder (#14130) (@Michael S. Molina)
- [13338](https://github.com/apache/superset/pull/13338) chore: Moves OnPasteSelect tests to component's folder (#13338) (@Michael S. Molina)
- [14133](https://github.com/apache/superset/pull/14133) chore: Moves Radio to the components folder (#14133) (@Michael S. Molina)
- [14135](https://github.com/apache/superset/pull/14135) chore: Moves Switch to the components folder (#14135) (@Michael S. Molina)
- [13411](https://github.com/apache/superset/pull/13411) chore: Moves TableSelector tests to component's folder (#13411) (@Michael S. Molina)
- [14136](https://github.com/apache/superset/pull/14136) chore: Moves Tabs to the components folder (#14136) (@Michael S. Molina)
- [14137](https://github.com/apache/superset/pull/14137) chore: Moves Tooltip to the components folder (#14137) (@Michael S. Molina)
- [14123](https://github.com/apache/superset/pull/14123) chore: Moves WarningIconWithTooltip to own folder (#14123) (@Michael S. Molina)
- [14200](https://github.com/apache/superset/pull/14200) chore: Moves spec files to the src folder - iteration 1 (#14200) (@Michael S. Molina)
- [14201](https://github.com/apache/superset/pull/14201) chore: Moves spec files to the src folder - iteration 2 (#14201) (@Michael S. Molina)
- [14202](https://github.com/apache/superset/pull/14202) chore: Moves spec files to the src folder - iteration 3 (#14202) (@Michael S. Molina)
- [14166](https://github.com/apache/superset/pull/14166) chore: Moves the branding folder to the assets folder (#14166) (@Michael S. Molina)
- [14167](https://github.com/apache/superset/pull/14167) chore: Moves the staticPages folder to the assets folder (#14167) (@Michael S. Molina)
- [13462](https://github.com/apache/superset/pull/13462) chore: Removes Popover duplication (#13462) (@Michael S. Molina)
- [13477](https://github.com/apache/superset/pull/13477) chore: Removes Select duplication (#13477) (@Michael S. Molina)
- [13408](https://github.com/apache/superset/pull/13408) chore: Removes unused Hotkeys component (#13408) (@Michael S. Molina)
- [14298](https://github.com/apache/superset/pull/14298) chore: SQLLab row limit warning using Alert component (#14298) (@zuzana-vej)
- [13332](https://github.com/apache/superset/pull/13332) chore: Update OAuth2 configuration guide to match with FlaskAppBuilder (#13332) (@Liam)
- [13855](https://github.com/apache/superset/pull/13855) chore: Update PR template for SIP-59 DB migrations process (#13855) (@Rob DiCiuccio)
- [13738](https://github.com/apache/superset/pull/13738) chore: Update presto.mdx (#13738) (@Hugh A. Miles II)
- [14257](https://github.com/apache/superset/pull/14257) chore: WebSocket server improvements (#14257) (@Ben Reinhart)
- [14354](https://github.com/apache/superset/pull/14354) chore: add some basic instrumentation to Node WebSocket server (#14354) (@Ben Reinhart)
- [13811](https://github.com/apache/superset/pull/13811) chore: add success log whenever a connection is working (#13811) (@Hugh A. Miles II)
- [14355](https://github.com/apache/superset/pull/14355) chore: bump 0.17.38 (#14355) (@Amit Miran)
- [13953](https://github.com/apache/superset/pull/13953) chore: bump @superset-ui/plugin-chart-table to 0.17.28 (#13953) (@Jesse Yang)
- [14222](https://github.com/apache/superset/pull/14222) chore: bump package.json (#14222) (@Amit Miran)
- [14253](https://github.com/apache/superset/pull/14253) chore: bump superset-ui (#14253) (@Erik Ritter)
- [14460](https://github.com/apache/superset/pull/14460) chore: bump table plugin to 0.17.42 (#14460) (@Amit Miran)
- [13932](https://github.com/apache/superset/pull/13932) chore: bump to new superset-ui version (#13932) (@Amit Miran)
- [13374](https://github.com/apache/superset/pull/13374) chore: convert chartReducer to TypeScript (#13374) (@Jesse Yang)
- [13450](https://github.com/apache/superset/pull/13450) chore: disable drag metrics and columns in datasourcePanel (#13450) (@Yongjie Zhao)
- [13342](https://github.com/apache/superset/pull/13342) chore: improve modal error handling (#13342) (@Lily Kuang)
- [13596](https://github.com/apache/superset/pull/13596) chore: metric refactor iteration 1 (#13596) (@Yongjie Zhao)
- [13296](https://github.com/apache/superset/pull/13296) chore: migrating some LESS (#13296) (@Evan Rusackas)
- [14169](https://github.com/apache/superset/pull/14169) chore: rename connection errors (#14169) (@Beto Dealmeida)
- [13970](https://github.com/apache/superset/pull/13970) chore: starter make file (#13970) (@Hugh A. Miles II)
- [14088](https://github.com/apache/superset/pull/14088) chore: stop logging `SupersetExceptions` if status < 500 (#14088) (@Hugh A. Miles II)
- [14178](https://github.com/apache/superset/pull/14178) chore: type some SQL Lab components (#14178) (@Erik Ritter)
- [14152](https://github.com/apache/superset/pull/14152) chore: update RELEASING readme (#14152) (@Lily Kuang)
- [13104](https://github.com/apache/superset/pull/13104) chore: update docs for new alerts and reporting feature (#13104) (@leocape)
- [14033](https://github.com/apache/superset/pull/14033) chore: well component to card component(Updating PR #12200) (#14033) (@Bruno Motta)
- [13518](https://github.com/apache/superset/pull/13518) ci: increase page size of GH PR API call (#13518) (@Ville Brofeldt)
- [14350](https://github.com/apache/superset/pull/14350) ci: set remote URL to https and bump sha (#14350) (@Daniel Vaz Gaspar)
- [14211](https://github.com/apache/superset/pull/14211) ci: use git submodules for  Chart Actions (#14211) (@jawabuu)
- [13587](https://github.com/apache/superset/pull/13587) create better link for badge (#13587) (@Elizabeth Thompson)
- [13626](https://github.com/apache/superset/pull/13626) dynamic dttm fix for test_convert_dttm (#13626) (@Nikola Gigić)
- [14140](https://github.com/apache/superset/pull/14140) horizontal scroll (#14140) (@AAfghahi)
- [13367](https://github.com/apache/superset/pull/13367) npm audit security updates (#13367) (@Elizabeth Thompson)
- [14443](https://github.com/apache/superset/pull/14443) perf(native-filters): Load native filters after charts (#14443) (@simcha90)
- [14408](https://github.com/apache/superset/pull/14408) perf(native-filters): avoid unnecessary reloading of charts (#14408) (@simcha90)
- [14035](https://github.com/apache/superset/pull/14035) refactor(addslicecontainer): move slice container panel from bootstrap panel to ant-d (#14035) (@Phillip Kelley-Dotson)
- [14366](https://github.com/apache/superset/pull/14366) refactor(db_engine_specs): Removing top-level import of app (#14366) (@John Bodley)
- [13221](https://github.com/apache/superset/pull/13221) refactor(explore): convert ControlPanelsContainer to typescript (#13221) (@Jesse Yang)
- [13437](https://github.com/apache/superset/pull/13437) refactor(native-filters): Move `filtersState` to `dataMask` redux root  (#13437) (@simcha90)
- [14441](https://github.com/apache/superset/pull/14441) refactor(native-filters): allow cascading only for filter_select (#14441) (@simcha90)
- [13723](https://github.com/apache/superset/pull/13723) refactor(native-filters): refactor filter bar (#13723) (@simcha90)
- [13983](https://github.com/apache/superset/pull/13983) refactor(native-filters): update dataMask and ExtraFormData schema (#13983) (@simcha90)
- [13137](https://github.com/apache/superset/pull/13137) refactor(self-trigger): Split native filters state (#13137) (@simcha90)
- [14090](https://github.com/apache/superset/pull/14090) refactor(userInfo): userinfo panel to styled component (#14090) (@Phillip Kelley-Dotson)
- [14100](https://github.com/apache/superset/pull/14100) refactor: Boostrap to AntD - Row/Col (#14100) (@Michael S. Molina)
- [14048](https://github.com/apache/superset/pull/14048) refactor: Boostrap to AntD - Tabs (#14048) (@Michael S. Molina)
- [14106](https://github.com/apache/superset/pull/14106) refactor: Bootstrap to AntD - Form - iteration 1 (#14106) (@Michael S. Molina)
- [13996](https://github.com/apache/superset/pull/13996) refactor: Bootstrap to AntD - ListGroup (#13996) (@Michael S. Molina)
- [13989](https://github.com/apache/superset/pull/13989) refactor: Bootstrap to AntD - Slider (#13989) (@Michael S. Molina)
- [13218](https://github.com/apache/superset/pull/13218) refactor: Introduce api resource hooks, fetch owners for chart errors (#13218) (@David Aaron Suddjian)
- [12229](https://github.com/apache/superset/pull/12229) refactor: New Icon system with Enhanced Antd Custom Icon (#12229) (@Geido)
- [13797](https://github.com/apache/superset/pull/13797) refactor: New schedule query button (#13797) (@AAfghahi)
- [13102](https://github.com/apache/superset/pull/13102) refactor: Query search into functional component (#13102) (@AAfghahi)
- [13785](https://github.com/apache/superset/pull/13785) refactor: Revert "refactor: ScheduleQueryButton into functional component (#134… (#13785) (@Hugh A. Miles II)
- [13443](https://github.com/apache/superset/pull/13443) refactor: ScheduleQueryButton into functional component (#13443) (@AAfghahi)
- [13630](https://github.com/apache/superset/pull/13630) refactor: Share sql lab query (#13630) (@AAfghahi)
- [13676](https://github.com/apache/superset/pull/13676) refactor: SouthPane into functional component (#13676) (@AAfghahi)
- [13417](https://github.com/apache/superset/pull/13417) refactor: add set data mask to build query (#13417) (@simcha90)
- [13401](https://github.com/apache/superset/pull/13401) refactor: convert controlUtils to TypeScript (1 of 2) (#13401) (@Jesse Yang)
- [13520](https://github.com/apache/superset/pull/13520) refactor: convert controlUtils to TypeScript (2 of 2) (#13520) (@Jesse Yang)
- [13877](https://github.com/apache/superset/pull/13877) refactor: move CTAS/CVAS field II (#13877) (@Hugh A. Miles II)
- [14309](https://github.com/apache/superset/pull/14309) refactor: reorganize dateFilterUtils.tx (#14309) (@Yongjie Zhao)
- [13174](https://github.com/apache/superset/pull/13174) sql Lab buttons (#13174) (@AAfghahi)
- [13537](https://github.com/apache/superset/pull/13537) switch message content between chart and dashboard  AlertReportModal (#13537) (@Lily Kuang)
- [14371](https://github.com/apache/superset/pull/14371) test(maximize-chart): Add tests to maximize chart action (#14371) (@simcha90)
- [14245](https://github.com/apache/superset/pull/14245) test(native-filters): Filter config modal test (#14245) (@simcha90)
- [14098](https://github.com/apache/superset/pull/14098) test(native-filters): add integration tests for filter bar (#14098) (@simcha90)
- [13973](https://github.com/apache/superset/pull/13973) test: Add tests for Dashboard Header and HeaderActionsDropdown components (#13973) (@Geido)
- [13517](https://github.com/apache/superset/pull/13517) test: Adds storybook and tests to AsyncEsmComponent (#13517) (@Michael S. Molina)
- [13547](https://github.com/apache/superset/pull/13547) test: Adds storybook and tests to PopoverDropdown component (#13547) (@Michael S. Molina)
- [13516](https://github.com/apache/superset/pull/13516) test: Adds storybook to AlteredSliceTag component (#13516) (@Michael S. Molina)
- [13406](https://github.com/apache/superset/pull/13406) test: Adds storybook to AnchorLink component (#13406) (@Michael S. Molina)
- [13412](https://github.com/apache/superset/pull/13412) test: Adds storybook to ConfirmStatusChange component (#13412) (@Michael S. Molina)
- [13482](https://github.com/apache/superset/pull/13482) test: Adds storybook to Dropdown and DropdownButton components (#13482) (@Michael S. Molina)
- [13362](https://github.com/apache/superset/pull/13362) test: Adds storybook to EditableTitle component (#13362) (@Michael S. Molina)
- [13407](https://github.com/apache/superset/pull/13407) test: Adds storybook to FormRow component (#13407) (@Michael S. Molina)
- [13415](https://github.com/apache/superset/pull/13415) test: Adds storybook to IconTooltip component (#13415) (@Michael S. Molina)
- [13410](https://github.com/apache/superset/pull/13410) test: Adds storybook to SearchInput component (#13410) (@Michael S. Molina)
- [13479](https://github.com/apache/superset/pull/13479) test: Adds storybook to Switch component (#13479) (@Michael S. Molina)
- [13343](https://github.com/apache/superset/pull/13343) test: Adds storybook to Timer component (#13343) (@Michael S. Molina)
- [13457](https://github.com/apache/superset/pull/13457) test: Adds tests and storybook to CertifiedIcon component (#13457) (@Michael S. Molina)
- [13438](https://github.com/apache/superset/pull/13438) test: Adds tests and storybook to PopoverSection component (#13438) (@Michael S. Molina)
- [13409](https://github.com/apache/superset/pull/13409) test: Adds tests and storybook to RefreshLabel (#13409) (@Michael S. Molina)
- [13705](https://github.com/apache/superset/pull/13705) test: Adds tests for the FixedOrMetricControl component (#13705) (@Michael S. Molina)
- [13299](https://github.com/apache/superset/pull/13299) test: Adds tests to TableLoader component (#13299) (@Michael S. Molina)
- [13319](https://github.com/apache/superset/pull/13319) test: Adds tests to URLShortLinkButton component (#13319) (@Michael S. Molina)
- [13650](https://github.com/apache/superset/pull/13650) test: Adds tests to dnd controls (#13650) (@Michael S. Molina)
- [13664](https://github.com/apache/superset/pull/13664) test: Adds tests to the AdvancedFrame component (#13664) (@Michael S. Molina)
- [13748](https://github.com/apache/superset/pull/13748) test: Adds tests to the AnnotationLayer component (#13748) (@Michael S. Molina)
- [13933](https://github.com/apache/superset/pull/13933) test: Adds tests to the CssEditor component (#13933) (@Michael S. Molina)
- [13675](https://github.com/apache/superset/pull/13675) test: Adds tests to the CustomFrame component (#13675) (@Michael S. Molina)
- [13729](https://github.com/apache/superset/pull/13729) test: Adds tests to the OptionControls component (#13729) (@Michael S. Molina)
- [13892](https://github.com/apache/superset/pull/13892) test: Adds tests to the PublishedStatus component (#13892) (@Michael S. Molina)
- [13712](https://github.com/apache/superset/pull/13712) test: Adds tests to the TimeSeriesColumnControl component (#13712) (@Michael S. Molina)
- [13919](https://github.com/apache/superset/pull/13919) test: Adds tests to the UndoRedoKeyListeners component (#13919) (@Michael S. Molina)
- [13887](https://github.com/apache/superset/pull/13887) test: Adds tests to the filter scope components (#13887) (@Michael S. Molina)
- [13787](https://github.com/apache/superset/pull/13787) test: AdhocMetricEditPopover (#13787) (@Bruno Motta)
- [13318](https://github.com/apache/superset/pull/13318) test: CacheLabel (#13318) (@Bruno Motta)
- [13656](https://github.com/apache/superset/pull/13656) test: CollectionControl (#13656) (@Bruno Motta)
- [13549](https://github.com/apache/superset/pull/13549) test: CronPicker (#13549) (@Bruno Motta)
- [13875](https://github.com/apache/superset/pull/13875) test: CrossFilterScopingForm (#13875) (@Bruno Motta)
- [13668](https://github.com/apache/superset/pull/13668) test: DataTableControl (#13668) (@Bruno Motta)
- [13736](https://github.com/apache/superset/pull/13736) test: DataTablesPane (#13736) (@Bruno Motta)
- [13581](https://github.com/apache/superset/pull/13581) test: DatabaseSelector (#13581) (@Bruno Motta)
- [13605](https://github.com/apache/superset/pull/13605) test: DatasourceControl (#13605) (@Bruno Motta)
- [13627](https://github.com/apache/superset/pull/13627) test: DatasourcePanelDragWrapper (#13627) (@Bruno Motta)
- [13750](https://github.com/apache/superset/pull/13750) test: DisplayQueryButton (#13750) (@Bruno Motta)
- [13745](https://github.com/apache/superset/pull/13745) test: Enhance tests and directory structure for FilterControl components (#13745) (@Geido)
- [13276](https://github.com/apache/superset/pull/13276) test: ErrorBoundary dedicated directory and tests (#13276) (@Geido)
- [13358](https://github.com/apache/superset/pull/13358) test: ErrorMessage components tests (#13358) (@Geido)
- [13753](https://github.com/apache/superset/pull/13753) test: FilterBoxItemControl (#13753) (@Bruno Motta)
- [14028](https://github.com/apache/superset/pull/14028) test: FilterSets-utils (#14028) (@Bruno Motta)
- [13548](https://github.com/apache/superset/pull/13548) test: Fixes PropertiesModal_spec (#13548) (@Michael S. Molina)
- [13270](https://github.com/apache/superset/pull/13270) test: FormLabel dedicated directory and tests (#13270) (@Geido)
- [13302](https://github.com/apache/superset/pull/13302) test: Menu component tests (#13302) (@Geido)
- [13277](https://github.com/apache/superset/pull/13277) test: Pagination component (#13277) (@Bruno Motta)
- [13818](https://github.com/apache/superset/pull/13818) test: PropertiesModal (#13818) (@Bruno Motta)
- [13931](https://github.com/apache/superset/pull/13931) test: PropertiesModal (Dashboard) (#13931) (@Bruno Motta)
- [13799](https://github.com/apache/superset/pull/13799) test: Refactor and enhance tests for the Explore DatasourcePanel Component (#13799) (@Geido)
- [13638](https://github.com/apache/superset/pull/13638) test: SelectAsyncControl (#13638) (@Bruno Motta)
- [13860](https://github.com/apache/superset/pull/13860) test: ShareMenuItems (#13860) (@Bruno Motta)
- [13888](https://github.com/apache/superset/pull/13888) test: SliceHeader (#13888) (@Bruno Motta)
- [13895](https://github.com/apache/superset/pull/13895) test: SliceHeaderControls (#13895) (@Bruno Motta)
- [13937](https://github.com/apache/superset/pull/13937) test: Tab (#13937) (@Bruno Motta)
- [13583](https://github.com/apache/superset/pull/13583) test: TableCollection  (#13583) (@Bruno Motta)
- [13941](https://github.com/apache/superset/pull/13941) test: Tabs (#13941) (@Bruno Motta)
- [13502](https://github.com/apache/superset/pull/13502) test: Tests and Storybook entry for the IndeterminateCheckbox Component (#13502) (@Geido)
- [13501](https://github.com/apache/superset/pull/13501) test: Tests and Storybook entry for the TableView Component (#13501) (@Geido)
- [13508](https://github.com/apache/superset/pull/13508) test: Tests and dedicated directory for the SupersetResourceSelect Component (#13508) (@Geido)
- [13916](https://github.com/apache/superset/pull/13916) test: Tests audit for the Dashboard FilterBar (#13916) (@Geido)
- [13286](https://github.com/apache/superset/pull/13286) test: Tests for DeleteModal component (#13286) (@Bruno Motta)
- [13305](https://github.com/apache/superset/pull/13305) test: Tests for OmniContainer (#13305) (@Bruno Motta)
- [13513](https://github.com/apache/superset/pull/13513) test: Tests, dedicated directory and Storybook for the Badge component (#13513) (@Geido)
- [13534](https://github.com/apache/superset/pull/13534) test: Tests, dedicated directory and Storybook for the ProgressBar component (#13534) (@Geido)
- [13751](https://github.com/apache/superset/pull/13751) test: changing logger.exception to logger.errors in databases api (#13751) (@AAfghahi)
- [13719](https://github.com/apache/superset/pull/13719) test: exploreUtils (#13719) (@Bruno Motta)
- [13329](https://github.com/apache/superset/pull/13329) test: optimize codecov config (#13329) (@Jesse Yang)
- [13984](https://github.com/apache/superset/pull/13984) test: prevent flaky frontend unit test case (#13984) (@Yongjie Zhao)
- [13320](https://github.com/apache/superset/pull/13320) test: tests for component FaveStar (#13320) (@Bruno Motta)
- [13555](https://github.com/apache/superset/pull/13555) test: useChangeEffect (#13555) (@Bruno Motta)
- [13554](https://github.com/apache/superset/pull/13554) test: usePrevious hook (#13554) (@Bruno Motta)
- [13873](https://github.com/apache/superset/pull/13873) tests for FilterIndicator (#13873) (@Bruno Motta)
- [13896](https://github.com/apache/superset/pull/13896) tests for function handleScroll (#13896) (@Bruno Motta)
- [14363](https://github.com/apache/superset/pull/14363) update default cron settings for new alerts and reports (#14363) (@Sam Faber-Manning)
- [13463](https://github.com/apache/superset/pull/13463) update test (#13463) (@Lily Kuang)
- [13897](https://github.com/apache/superset/pull/13897) updates load_examples to load-examples (#13897) (@Alex Simoes)
- [14009](https://github.com/apache/superset/pull/14009) use dynamic time_grains for schema (#14009) (@Elizabeth Thompson)
- [13424](https://github.com/apache/superset/pull/13424) use semver for badge sort (#13424) (@Elizabeth Thompson)

### 1.1 (Wed Feb 24 12:08:28 2021 +0200)

**Database Migrations**
- [#13111](https://github.com/apache/superset/pull/13111) feat: add Echarts Graph chart (@mayurnewase)
- [#13262](https://github.com/apache/superset/pull/13262) fix: migration script message formatting issue (@ktmud)
- [#13216](https://github.com/apache/superset/pull/13216) fix: add missing columns (@betodealmeida)
- [#12960](https://github.com/apache/superset/pull/12960) fix: Retroactively add granularity param to charts (@etr2460)
- [#13052](https://github.com/apache/superset/pull/13052) fix(explore): pie chart label bugs (@villebro)
- [#13015](https://github.com/apache/superset/pull/13015) fix: time filter db migration optimization (@ktmud)
- [#12950](https://github.com/apache/superset/pull/12950) chore: rename revision to match naming scheme (@etr2460)
- [#12680](https://github.com/apache/superset/pull/12680) feat(dashboard_rbac): dashboard lists (@amitmiran137)
- [#12552](https://github.com/apache/superset/pull/12552) fix(explore): deprecated x periods pattern in new time picker value (@zhaoyongjie)
- [#12336](https://github.com/apache/superset/pull/12336) chore: remove additional incubator references (@amitmiran137)

**Features**
- [#13353](https://github.com/apache/superset/pull/13353) feat: add Firebird DB engine spec (@betodealmeida)
- [#13271](https://github.com/apache/superset/pull/13271) feat(chart-data): add rowcount, timegrain and column result types (@villebro)
- [#13214](https://github.com/apache/superset/pull/13214) feat(presto): add support for user impersonation (@rijojoseph07)
- [#13049](https://github.com/apache/superset/pull/13049) feat: Add sort by for dist bar chart (@maloun96)
- [#13057](https://github.com/apache/superset/pull/13057) feat: Add sort by metric for charts with multiple metrics (@maloun96)
- [#13182](https://github.com/apache/superset/pull/13182) feat: Move SQLAlchemy url reference to config (@hughhhh)
- [#13130](https://github.com/apache/superset/pull/13130) feat(helm): Evaluate configOverrides as templates (@Yann-J)
- [#13205](https://github.com/apache/superset/pull/13205) feat(filter-sets): Saving filter sets in metadata (@simcha90)
- [#13037](https://github.com/apache/superset/pull/13037) feat: add autocopy functionality to CopyToClipboard (#10328) (@michael-s-molina)
- [#13031](https://github.com/apache/superset/pull/13031) feat(filters-set): basic implementation for managing user filter sets (@simcha90)
- [#13150](https://github.com/apache/superset/pull/13150) feat(alerts): apply SQL limit to all alerts (@dpgaspar)
- [#13116](https://github.com/apache/superset/pull/13116) feat(helm): Helm template for Celery beat (for reporting and alerting) (@Yann-J)
- [#13114](https://github.com/apache/superset/pull/13114) feat: Added annotations and loadBalancerIP option in helm service.yaml (@cheunhong)
- [#13148](https://github.com/apache/superset/pull/13148) feat(native-filters): enable filter indicator and make datasource optional (@simcha90)
- [#12978](https://github.com/apache/superset/pull/12978) feat(dashboard): API to get a dashboard's charts (@suddjian)
- [#13105](https://github.com/apache/superset/pull/13105) feat: first step native support Trino (@dungdm93)
- [#13058](https://github.com/apache/superset/pull/13058) feat: add sort_by_metric for charts with single metric (@maloun96)
- [#13035](https://github.com/apache/superset/pull/13035) feat(dashboard_rbac): add support for related roles (@amitmiran137)
- [#13108](https://github.com/apache/superset/pull/13108) feat(native-filters): hide filterBar and toggle icon when in editMode (@amitmiran137)
- [#13096](https://github.com/apache/superset/pull/13096) feat: Custom superset_config.py + secret envs (@Yann-J)
- [#13005](https://github.com/apache/superset/pull/13005) feat(native-filters): add storybook entry for select filter (@simcha90)
- [#12992](https://github.com/apache/superset/pull/12992) feat(native-filters): Time native filter (@simcha90)
- [#13056](https://github.com/apache/superset/pull/13056) feat: Force pod restart on config changes (@Yann-J)
- [#12662](https://github.com/apache/superset/pull/12662) feat(cross-filters): add cross filters (@simcha90)
- [#12918](https://github.com/apache/superset/pull/12918) feat(style): hide dashboard header by url parameter (@simcha90)
- [#12602](https://github.com/apache/superset/pull/12602) feat(db engines): add support for Opendistro Elasticsearch (AWS ES) (@dpgaspar)
- [#12996](https://github.com/apache/superset/pull/12996) feat: Save datapanel state in local storage (@kgabryje)
- [#12865](https://github.com/apache/superset/pull/12865) feat(dashboard_rbac): dashboards API support for roles create/update + roles validation (@amitmiran137)
- [#12782](https://github.com/apache/superset/pull/12782) feat: reset metrics on dataset change (@pkdotson)
- [#12875](https://github.com/apache/superset/pull/12875) feat(dashboard_rbac): dashboard_view access enforcement (@amitmiran137)
- [#12887](https://github.com/apache/superset/pull/12887) feat(time-table): add row limit control for timeseries table (@maloun96)
- [#12909](https://github.com/apache/superset/pull/12909) feat: clear search on dataset change (@pkdotson)
- [#12840](https://github.com/apache/superset/pull/12840) feat: add separate endpoint to fetch function names for autocomplete (@betodealmeida)
- [#12858](https://github.com/apache/superset/pull/12858) feat(style-theme): add support for custom superset themes (@simcha90)
- [#12199](https://github.com/apache/superset/pull/12199) feat(native-filters): Add defaultValue for Native filters modal (@simcha90)
- [#12663](https://github.com/apache/superset/pull/12663) feat: request ids on API related endpoints (@dpgaspar)
- [#12716](https://github.com/apache/superset/pull/12716) feat(native-filters): apply scoping of native filters to dashboard (@simcha90)
- [#12609](https://github.com/apache/superset/pull/12609) feat: default timepicker to last week when dataset is changed (@pkdotson)
- [#12740](https://github.com/apache/superset/pull/12740) feat: Adding option to set_database_uri CLI command (@craig-rueda)
- [#12635](https://github.com/apache/superset/pull/12635) feat: add decorator to guard public APIs (@betodealmeida)
- [#12581](https://github.com/apache/superset/pull/12581) feat(bigquery): implement custom minute time grains (@villebro)
- [#11720](https://github.com/apache/superset/pull/11720) feat(db-engine-specs): add support for Postgres root cert (@villebro)
- [#12415](https://github.com/apache/superset/pull/12415) feat: new Slack dashboard (@betodealmeida)

**Fixes**
- [#13735](https://github.com/apache/superset/pull/13735) fix: Properly escape special characters in CSV output (@benjreinhart)
- [#13461](https://github.com/apache/superset/pull/13461) fix: url shortener invalid input (@dpgaspar)
- [#13157](https://github.com/apache/superset/pull/13157) fix(alerts&reports): Alerts & Reports will use values from WEBDRIVER_WINDOW option (@iercan)
- [#13350](https://github.com/apache/superset/pull/13350) fix(celery): Reset DB connection pools for forked worker processes (@robdiciuccio)
- [#13300](https://github.com/apache/superset/pull/13300) fix: exception when saving dash (@amitmiran137)
- [#13284](https://github.com/apache/superset/pull/13284) fix(listview): preserve bulk selections when view mode is changed (@nytai)
- [#13289](https://github.com/apache/superset/pull/13289) fix(alerts): Handle None on results (@dpgaspar)
- [#12937](https://github.com/apache/superset/pull/12937) fix: chart keys in MultiLineViz (@rwspielman)
- [#13254](https://github.com/apache/superset/pull/13254) fix: style tweaks for inconsistent button spacing (@rusackas)
- [#13291](https://github.com/apache/superset/pull/13291) fix(home): missing key and invalid dates in Recents cards (@ktmud)
- [#12926](https://github.com/apache/superset/pull/12926) fix: add alert report timeout limits (@riahk)
- [#13283](https://github.com/apache/superset/pull/13283) fix(menu): links that result in 404s (@nytai)
- [#13245](https://github.com/apache/superset/pull/13245) fix: bulk select on card view (@lilykuang)
- [#13233](https://github.com/apache/superset/pull/13233) fix(viz): calendar heatmap granularity (@maloun96)
- [#13186](https://github.com/apache/superset/pull/13186) fix: SqlEditor_spec tests (@michael-s-molina)
- [#13222](https://github.com/apache/superset/pull/13222) fix(alert/report): alert modal loading dropdown options (@lilykuang)
- [#13122](https://github.com/apache/superset/pull/13122) fix: TimeTable average with nulls calculations (@pavlozt)
- [#13181](https://github.com/apache/superset/pull/13181) fix(explore): Fix downloading as image charts which use Mapbox (@kgabryje)
- [#13163](https://github.com/apache/superset/pull/13163) fix: Fixing pinot query generation for date format conversion from python datetime format to java simple date format (@fx19880617)
- [#13123](https://github.com/apache/superset/pull/13123) fix: add the untranslated text content of Chart page, Sql Editor page and some dashboard label in messages.pot (@cdmikechen)
- [#13211](https://github.com/apache/superset/pull/13211) fix(explore): Reset values in TextControl only when datasource changes (@kgabryje)
- [#13219](https://github.com/apache/superset/pull/13219) fix: Update display string when sqlalchemy doc config us changed (@hughhhh)
- [#13217](https://github.com/apache/superset/pull/13217) fix(native-filters): uncapitalize filter name (@amitmiran137)
- [#13160](https://github.com/apache/superset/pull/13160) fix: Grab datasets initially onMount (@hughhhh)
- [#13086](https://github.com/apache/superset/pull/13086) fix: accept null groupby in form data for timeseries table viz (@michellethomas)
- [#13173](https://github.com/apache/superset/pull/13173) fix(api): apply dashboard filter to get dash charts API (@dpgaspar)
- [#13178](https://github.com/apache/superset/pull/13178) fix(cross-filters): apply cross filters for all charts (@simcha90)
- [#13141](https://github.com/apache/superset/pull/13141) fix: handle lack of dynamic plugins (@suddjian)
- [#13153](https://github.com/apache/superset/pull/13153) fix: engines that don't support comments (@dpgaspar)
- [#12977](https://github.com/apache/superset/pull/12977) fix(alert/report): bulk select mode should be deactivated (@lilykuang)
- [#13180](https://github.com/apache/superset/pull/13180) fix(sqllab): menu link results in 404 (@nytai)
- [#13164](https://github.com/apache/superset/pull/13164) fix(native-filters): Apply range filter (@simcha90)
- [#13165](https://github.com/apache/superset/pull/13165) fix(native-filters): correct apply of native filter scopes (@simcha90)
- [#13154](https://github.com/apache/superset/pull/13154) fix(explore): Chart panel overflowing (@kgabryje)
- [#13120](https://github.com/apache/superset/pull/13120) fix: misspelling Erik Ritter (@etr2460)
- [#12955](https://github.com/apache/superset/pull/12955) fix(alert/report): add/edit modal issue (@lilykuang)
- [#13133](https://github.com/apache/superset/pull/13133) fix(explore): Certificate icon not displaying for certified metrics (@kgabryje)
- [#13147](https://github.com/apache/superset/pull/13147) fix(database): ensure pk_constraint is JSON serializable (@villebro)
- [#13138](https://github.com/apache/superset/pull/13138) fix(chart-data-api): support numeric temporal columns (@villebro)
- [#13090](https://github.com/apache/superset/pull/13090) fix(alerts): void query with numeric comparison (@dpgaspar)
- [#13109](https://github.com/apache/superset/pull/13109) fix(FilterBox): treat empty defaultValues as null (@ktmud)
- [#13094](https://github.com/apache/superset/pull/13094) fix: Fix switching viz type to and from Filter box (@kgabryje)
- [#13022](https://github.com/apache/superset/pull/13022) fix: Add some missing Chinese translation content, including superset-ui project (@cdmikechen)
- [#13000](https://github.com/apache/superset/pull/13000) fix(native-filters): set currentValue null when empty (@villebro)
- [#13061](https://github.com/apache/superset/pull/13061) fix: Update http error code from 400 to 403 for permission error (@duynguyenhoang)
- [#13029](https://github.com/apache/superset/pull/13029) fix(explore): Enable selecting an option not included in suggestions (@kgabryje)
- [#13076](https://github.com/apache/superset/pull/13076) fix: API tests, make them possible to run independently again (@dpgaspar)
- [#13051](https://github.com/apache/superset/pull/13051) fix: add config to disable dataset ownership on the old api (@dpgaspar)
- [#12931](https://github.com/apache/superset/pull/12931) fix: add required \* indicator to message content/notif method in alert/report modal (@riahk)
- [#13075](https://github.com/apache/superset/pull/13075) fix(ci): multiline regex in change detection (@villebro)
- [#13008](https://github.com/apache/superset/pull/13008) fix: Disabled state button transition time (@AAfghahi)
- [#13059](https://github.com/apache/superset/pull/13059) fix: sorting by saved metric (@villebro)
- [#13041](https://github.com/apache/superset/pull/13041) fix: timeout context manager on Windows (@betodealmeida)
- [#13042](https://github.com/apache/superset/pull/13042) fix: vertical scroll in query history (@betodealmeida)
- [#13026](https://github.com/apache/superset/pull/13026) fix: UI toast typo (@dpgaspar)
- [#13039](https://github.com/apache/superset/pull/13039) fix(build): black failing on master, add to required checks (@robdiciuccio)
- [#13024](https://github.com/apache/superset/pull/13024) fix: fix the untranslated text content of Dashboard page (@cdmikechen)
- [#13034](https://github.com/apache/superset/pull/13034) fix(ci): remove signature requirements for commits to master (@nytai)
- [#12999](https://github.com/apache/superset/pull/12999) fix: add alerts and report to default config (@dpgaspar)
- [#12945](https://github.com/apache/superset/pull/12945) fix: refresh dashboard list after bulk delete (@michael-s-molina)
- [#12923](https://github.com/apache/superset/pull/12923) fix: added text and changed margins (@AAfghahi)
- [#12966](https://github.com/apache/superset/pull/12966) fix: typo to apache/superset (@AAfghahi)
- [#12973](https://github.com/apache/superset/pull/12973) fix: SQL Lab editor height in Safari (@betodealmeida)
- [#12956](https://github.com/apache/superset/pull/12956) fix: SqlLab Run button fix (@AAfghahi)
- [#12953](https://github.com/apache/superset/pull/12953) fix: Detecting top scroll on Dashboard header (@kkucharc)
- [#12933](https://github.com/apache/superset/pull/12933) fix(viz): improve dtype inference logic (@villebro)
- [#12859](https://github.com/apache/superset/pull/12859) fix: Add inclusive and exclusive text for start date and end date (@maloun96)
- [#12930](https://github.com/apache/superset/pull/12930) fix(viz): bump table viz to fix ordering bug (@villebro)
- [#12906](https://github.com/apache/superset/pull/12906) fix: Config for dataset health check (@graceguo-supercat)
- [#12905](https://github.com/apache/superset/pull/12905) fix(chart): allow `null` for optional query object props (@ktmud)
- [#12898](https://github.com/apache/superset/pull/12898) fix: comment typo (@etr2460)
- [#12890](https://github.com/apache/superset/pull/12890) fix(explore): missing select when groupby without metrics (@villebro)
- [#12579](https://github.com/apache/superset/pull/12579) fix: Installing Superset Locally Using Docker Compose (@mephinet)
- [#12841](https://github.com/apache/superset/pull/12841) fix: correct title weights in UPDATING.md (@eschutho)
- [#12836](https://github.com/apache/superset/pull/12836) fix: remove explicit cursor closing for BQ (@betodealmeida)
- [#12625](https://github.com/apache/superset/pull/12625) fix(CI): properly configure cancel duplicates (@ktmud)
- [#12736](https://github.com/apache/superset/pull/12736) fix: Remove double tooltip from metric label (@kgabryje)
- [#12800](https://github.com/apache/superset/pull/12800) fix: rm grace period field for reports modal (@riahk)
- [#12821](https://github.com/apache/superset/pull/12821) fix: don't close cursor before closing connection (@betodealmeida)
- [#12811](https://github.com/apache/superset/pull/12811) fix(reports): handle exceptions properly in scope (@dpgaspar)
- [#12742](https://github.com/apache/superset/pull/12742) fix: Prevent dashboard with filter_values template cause incompatible indicator (@graceguo-supercat)
- [#12219](https://github.com/apache/superset/pull/12219) fix: tests errors and warnings - iteration 3 (#12212) (@michael-s-molina)
- [#12224](https://github.com/apache/superset/pull/12224) fix: tests errors and warnings - iteration 5 (#12212) (@michael-s-molina)
- [#12227](https://github.com/apache/superset/pull/12227) fix: tests errors and warnings - iteration 6 (#12212) (@michael-s-molina)
- [#12223](https://github.com/apache/superset/pull/12223) fix: tests errors and warnings - iteration 4 (#12212) (@michael-s-molina)
- [#12245](https://github.com/apache/superset/pull/12245) fix: tests errors and warnings - iteration 7 (#12212) (@michael-s-molina)
- [#12214](https://github.com/apache/superset/pull/12214) fix: test errors and warnings - iteration 2 (#12212) (@michael-s-molina)
- [#12706](https://github.com/apache/superset/pull/12706) fix: update latest tag action to use set-output (@eschutho)
- [#12658](https://github.com/apache/superset/pull/12658) fix(dashboard): top dropdown indicator in tab moved closer to the bottom edge (@kkucharc)
- [#12519](https://github.com/apache/superset/pull/12519) fix(native-filters): Reset column field for removed dataset (@agatapst)
- [#12524](https://github.com/apache/superset/pull/12524) fix(native-filters): Improve UI for long native filters names (@agatapst)
- [#12687](https://github.com/apache/superset/pull/12687) fix(native-filters): Show incompatible native filters indicator (@agatapst)
- [#12702](https://github.com/apache/superset/pull/12702) fix(load_examples): better fix for load_data (@betodealmeida)
- [#12692](https://github.com/apache/superset/pull/12692) fix: Adding gatsby remove serviceworker (@craig-rueda)
- [#12659](https://github.com/apache/superset/pull/12659) fix(explore): Error message not displayed correctly in Timeseries table chart (@kgabryje)
- [#12627](https://github.com/apache/superset/pull/12627) fix: Stabilize and deprecate legacy alerts module (@robdiciuccio)
- [#12638](https://github.com/apache/superset/pull/12638) fix(CI): remove duplicate hive and presto tests (@ktmud)
- [#12607](https://github.com/apache/superset/pull/12607) fix: save tabs when saving the query bug (@hughhhh)
- [#12240](https://github.com/apache/superset/pull/12240) fix: helm chart to use Bitnami chart (@liamnv)
- [#12567](https://github.com/apache/superset/pull/12567) fix: update helm chart repository (@palindrom615)
- [#12526](https://github.com/apache/superset/pull/12526) fix: ignore system files on import (@betodealmeida)
- [#12182](https://github.com/apache/superset/pull/12182) fix: Add Omnibar Feature Flag (@hughhhh)
- [#12252](https://github.com/apache/superset/pull/12252) fix: Displaying filter indicators (@agatapst)
- [#12360](https://github.com/apache/superset/pull/12360) fix: css templates modal cleanup: keep modal open on error, utilize useEffect (@riahk)
- [#12467](https://github.com/apache/superset/pull/12467) fix(alert/report): remove crontab guru link from add/edit modal (@lilykuang)
- [#12461](https://github.com/apache/superset/pull/12461) fix(releasing): svn dockerfile requirements path (@villebro)
- [#12412](https://github.com/apache/superset/pull/12412) fix: uneven list header padding (#12029) (@michael-s-molina)
- [#12432](https://github.com/apache/superset/pull/12432) fix(explore): fixed table header in chrome (@junlincc)
- [#12433](https://github.com/apache/superset/pull/12433) fix: update savedatasetmodal message (@hughhhh)
- [#12354](https://github.com/apache/superset/pull/12354) fix(api): prefix class names on events actions (@dpgaspar)
- [#12404](https://github.com/apache/superset/pull/12404) fix(explore): Prevent duplicated query by data table (@graceguo-supercat)

**Others**
- [#13777](https://github.com/apache/superset/pull/13777) docs: added release notes for 1.1 (@srinify)
- [#13588](https://github.com/apache/superset/pull/13588) chore: script for changelog (@lilykuang)
- [#13402](https://github.com/apache/superset/pull/13402) docs: add file for users to see status of feature flags (@eschutho)
- [#13431](https://github.com/apache/superset/pull/13431) chore: clean remaining old directed force graph code (@mayurnewase)
- [#12882](https://github.com/apache/superset/pull/12882) chore: bump pyarrow and pandas (@villebro)
- [#13304](https://github.com/apache/superset/pull/13304) test: change data-test-id to data-test in FlashProvider (@yardz)
- [#13171](https://github.com/apache/superset/pull/13171) docs: Connecting to Trino Databases (@dungdm93)
- [#12238](https://github.com/apache/superset/pull/12238) chore: update instructions for Pinot in connecting to databases (@pablo-tech)
- [#12920](https://github.com/apache/superset/pull/12920) refactor: Bootstrap to AntD - Collapse (@michael-s-molina)
- [#13292](https://github.com/apache/superset/pull/13292) test: replace data-test-id with data-test (@ktmud)
- [#13220](https://github.com/apache/superset/pull/13220) test: Switching FlashProvider to function component & creating tests (@yardz)
- [#13235](https://github.com/apache/superset/pull/13235) refactor: Move raise_for_dashboard_access to security manager (@bolkedebruin)
- [#13212](https://github.com/apache/superset/pull/13212) refactor(api): csrf token on the new REST API (@dpgaspar)
- [#12870](https://github.com/apache/superset/pull/12870) test: fix schedules tests (@kstrz)
- [#12864](https://github.com/apache/superset/pull/12864) test: reports/commands_tests (@kstrz)
- [#13241](https://github.com/apache/superset/pull/13241) test: add Tests and Storybook for AsyncAceEditor (@michael-s-molina)
- [#13268](https://github.com/apache/superset/pull/13268) refactor(native-filters): Refactor filters config modal module (@simcha90)
- [#13258](https://github.com/apache/superset/pull/13258) chore(viz): bump superset-ui 0.17.10 (@villebro)
- [#13260](https://github.com/apache/superset/pull/13260) ci: always execute tests on non-PRs (@villebro)
- [#12122](https://github.com/apache/superset/pull/12122) refactor: Bootstrap to AntD - Alert (@michael-s-molina)
- [#13215](https://github.com/apache/superset/pull/13215) chore: bump node.js to v14 (@kgabryje)
- [#13250](https://github.com/apache/superset/pull/13250) refactor: add frontend debounce constants (@ktmud)
- [#13213](https://github.com/apache/superset/pull/13213) test: Tests and Storybook entry for the ModalTrigger Component (@geido)
- [#13176](https://github.com/apache/superset/pull/13176) test: Tests and Storybook entry for the Popover component (@geido)
- [#12773](https://github.com/apache/superset/pull/12773) chore: Tab title to be empty when creating a new tab (@geido)
- [#13002](https://github.com/apache/superset/pull/13002) refactor: Bootstrap to AntD - DropdownButton (@michael-s-molina)
- [#13098](https://github.com/apache/superset/pull/13098) refactor: HighligthedSQL into functional component with Typescript (@AAfghahi)
- [#13143](https://github.com/apache/superset/pull/13143) chore: add non-dev docker-compose workflow (@nytai)
- [#13185](https://github.com/apache/superset/pull/13185) chore: use shillelagh instead of gsheetsdb (@betodealmeida)
- [#13201](https://github.com/apache/superset/pull/13201) docs: Fix typo in pyathena connection string (@ctSkennerton)
- [#13179](https://github.com/apache/superset/pull/13179) test: Adding test and storybook to "Loading" component. (@yardz)
- [#13184](https://github.com/apache/superset/pull/13184) test: creates storybook and tests for Tooltip component (@michael-s-molina)
- [#13136](https://github.com/apache/superset/pull/13136) test(coverage): ignore database migrations on coverage reports (@willbarrett)
- [#13142](https://github.com/apache/superset/pull/13142) refactor: remove deprecated field from frontend usage (@suddjian)
- [#13087](https://github.com/apache/superset/pull/13087) perf: add lazy loading along react-router routes and router links in menu (@nytai)
- [#13139](https://github.com/apache/superset/pull/13139) style(list view): table sort icon alignment (@nytai)
- [#13149](https://github.com/apache/superset/pull/13149) chore: change test environment to jsdom (@michael-s-molina)
- [#13100](https://github.com/apache/superset/pull/13100) chore: upgrade to npm 7 and superset-ui 0.17.9 (@ktmud)
- [#13113](https://github.com/apache/superset/pull/13113) build: add more files to .dockerignore (@ktmud)
- [#13021](https://github.com/apache/superset/pull/13021) refactor(native-filters): decouple params from filter config modal (first phase) (@simcha90)
- [#13079](https://github.com/apache/superset/pull/13079) test(frontend): improves react-testing-library configuration (@michael-s-molina)
- [#13083](https://github.com/apache/superset/pull/13083) docs: Added a note about the ! prefix for breaking changes to CONTRIBUTING.md (@garden-of-delete)
- [#13069](https://github.com/apache/superset/pull/13069) chore: lock down npm to v6 (@ktmud)
- [#13063](https://github.com/apache/superset/pull/13063) style: fix typo in documentation (@dbz10)
- [#12981](https://github.com/apache/superset/pull/12981) docs(changelog): add entries for 1.0.1 (@villebro)
- [#12982](https://github.com/apache/superset/pull/12982) ci: skip cypress if no code changes (@villebro)
- [#12970](https://github.com/apache/superset/pull/12970) chore: add cypress required checks for branch protection (@eschutho)
- [#13014](https://github.com/apache/superset/pull/13014) chore: updates storybook to version 6.1.17 (@michael-s-molina)
- [#13004](https://github.com/apache/superset/pull/13004) chore: Swap Slack Url 2 more places (@srinify)
- [#12889](https://github.com/apache/superset/pull/12889) refactor(native-filters): refactor code of native filters (@simcha90)
- [#12991](https://github.com/apache/superset/pull/12991) docs: typo fix in release notes (@iercan)
- [#12873](https://github.com/apache/superset/pull/12873) refactor: TemplateParamsEditor.jsx converted from class to functional component (@lyndsiWilliams)
- [#12806](https://github.com/apache/superset/pull/12806) refactor: speed up conversion from dataframe to list of records (@TColl)
- [#12980](https://github.com/apache/superset/pull/12980) chore: rename action to docker-build (@eschutho)
- [#12969](https://github.com/apache/superset/pull/12969) chore: add more required checks for branch protection (@eschutho)
- [#12974](https://github.com/apache/superset/pull/12974) chore: swap slack url on ASF docs (@srinify)
- [#12972](https://github.com/apache/superset/pull/12972) chore: cleanup no-op Cypress (chrome) job (@ktmud)
- [#12968](https://github.com/apache/superset/pull/12968) chore: change name of lint action (@eschutho)
- [#12967](https://github.com/apache/superset/pull/12967) chore: remove example token to avoid confusion (@ktmud)
- [#12928](https://github.com/apache/superset/pull/12928) chore: add more required checks (@eschutho)
- [#12583](https://github.com/apache/superset/pull/12583) ci: conditionally skip python and frontend tests (@villebro)
- [#12180](https://github.com/apache/superset/pull/12180) test: Added some Cypress tests for Native Filters (@adam-stasiak)
- [#12936](https://github.com/apache/superset/pull/12936) test: fix table chart sort order E2E tests (@ktmud)
- [#12921](https://github.com/apache/superset/pull/12921) chore: rename duplicate build jobs (@eschutho)
- [#12885](https://github.com/apache/superset/pull/12885) test: speedup celery tests (@kstrz)
- [#12901](https://github.com/apache/superset/pull/12901) build(deps): Bump jinja2 to 2.11.3 (@robdiciuccio)
- [#12848](https://github.com/apache/superset/pull/12848) chore(dashboard_rbac): remove overlapping security tests (@amitmiran137)
- [#12894](https://github.com/apache/superset/pull/12894) chore: remove SIP-38 feature flag (@villebro)
- [#12694](https://github.com/apache/superset/pull/12694) chore: add required review on master (@eschutho)
- [#12738](https://github.com/apache/superset/pull/12738) refactor: Bootstrap to AntD - Radio (@michael-s-molina)
- [#12869](https://github.com/apache/superset/pull/12869) refactor: dbapi exception mapping for dbapi's (@dpgaspar)
- [#12884](https://github.com/apache/superset/pull/12884) chore(lint): fix pre-commit error (@villebro)
- [#12857](https://github.com/apache/superset/pull/12857) refactor(color-schemes): refactor setting of color schemes (@simcha90)
- [#12774](https://github.com/apache/superset/pull/12774) refactor: Bootstrap to AntD - Label (@michael-s-molina)
- [#10771](https://github.com/apache/superset/pull/10771) [Helm] Automate datasource import (@ejianu)
- [#12610](https://github.com/apache/superset/pull/12610) build: Skip loading example data from configs in CI (@robdiciuccio)
- [#12832](https://github.com/apache/superset/pull/12832) refactor: Bootstrap to AntD - Button (@michael-s-molina)
- [#12854](https://github.com/apache/superset/pull/12854) chore: bump superset-ui packages to v0.17.2 and v0.17.3 (@ktmud)
- [#12846](https://github.com/apache/superset/pull/12846) chore: Slight formatting fixes in exploring-data.mdx (@neilsmiller)
- [#12812](https://github.com/apache/superset/pull/12812) chore(native-filters): Connect indicator magnifier with Filter Bar (@agatapst)
- [#12828](https://github.com/apache/superset/pull/12828) chore: update capitalization guideline (@ktmud)
- [#12831](https://github.com/apache/superset/pull/12831) docs: fix config comment (@zsellami)
- [#12778](https://github.com/apache/superset/pull/12778) chore: Added documentation for 1.0 flags (@srinify)
- [#12743](https://github.com/apache/superset/pull/12743) docs: wrong port name in NOTES.txt (@maddyobrienjones)
- [#12816](https://github.com/apache/superset/pull/12816) docs: add Cape Crypto to users list (@leocape)
- [#12833](https://github.com/apache/superset/pull/12833) docs: fix broken link to spark. (@pr-lawrence)
- [#12772](https://github.com/apache/superset/pull/12772) refactor: change Windows new tab shortcut to ctrl + q (@lyndsiWilliams)
- [#10270](https://github.com/apache/superset/pull/10270) refactor: migrate table chart to new API (@ktmud)
- [#12815](https://github.com/apache/superset/pull/12815) chore: Upgrade react-dnd to 11.1.3 (@kgabryje)
- [#12710](https://github.com/apache/superset/pull/12710) docs: Add support for Hologres (@TimothyDing)
- [#12818](https://github.com/apache/superset/pull/12818) docs: add A3Data to users list (@neylsoncrepalde)
- [#12795](https://github.com/apache/superset/pull/12795) refactor: Updated tooltip help text in edit database > SQL Lab settings (@lyndsiWilliams)
- [#12813](https://github.com/apache/superset/pull/12813) chore: adding feature flags v1 documentation in Release Notes (@srinify)
- [#12748](https://github.com/apache/superset/pull/12748) chore(docs): update tox testing run to relevant python env (@amitmiran137)
- [#12754](https://github.com/apache/superset/pull/12754) chore: add breaking change to title regex (@eschutho)
- [#12749](https://github.com/apache/superset/pull/12749) docs: Adding design guidelines to CONTRIBUTING.md (@mihir174)
- [#12792](https://github.com/apache/superset/pull/12792) docs: fix 1.0.0 README images (v2) (@dpgaspar)
- [#12781](https://github.com/apache/superset/pull/12781) docs: 1.0.0 release notes update: media + feature flags (@garden-of-delete)
- [#12777](https://github.com/apache/superset/pull/12777) docs: update changelog for 1.0.0 (@eschutho)
- [#12626](https://github.com/apache/superset/pull/12626) docs: Updates to Superset Site for 1.0 (@srinify)
- [#12655](https://github.com/apache/superset/pull/12655) test(native-filters): scoping tree in native filters modal (@simcha90)
- [#12605](https://github.com/apache/superset/pull/12605) chore: upgrade Cypress to 6.2.1 (@ktmud)
- [#12218](https://github.com/apache/superset/pull/12218) refactor(explore): Enhance Dataset and Control panel Collapse components (@geido)
- [#12739](https://github.com/apache/superset/pull/12739) docs: Fixed typo on line 348 (@lyndsiWilliams)
- [#12693](https://github.com/apache/superset/pull/12693) docs: Remove gatsby-plugin-offline (@robdiciuccio)
- [#12615](https://github.com/apache/superset/pull/12615) test: oracle engine spec (@kstrz)
- [#12520](https://github.com/apache/superset/pull/12520) test: hive db engine spec (@kstrz)
- [#12737](https://github.com/apache/superset/pull/12737) chore: Replace Expired Join Slack Community URL With New One (@srinify)
- [#12718](https://github.com/apache/superset/pull/12718) docs: link fix in CONTRIBUTING.md (@ayanginet)
- [#12709](https://github.com/apache/superset/pull/12709) ci: use git submodules for (securely) using third party Github Actions (@TobKed)
- [#12678](https://github.com/apache/superset/pull/12678) chore: add a note about using Draft PR's importance (@amitmiran137)
- [#12673](https://github.com/apache/superset/pull/12673) docs(db engines): Updade DB2 connection prefix (@cabo40)
- [#12682](https://github.com/apache/superset/pull/12682) docs: updates updating.md with 1.0 (@dpgaspar)
- [#12455](https://github.com/apache/superset/pull/12455) chore: apply capitalization guidelines - iteration 9 (#12343) (@michael-s-molina)
- [#12666](https://github.com/apache/superset/pull/12666) chore: skip CI on draft PR (@amitmiran137)
- [#12594](https://github.com/apache/superset/pull/12594) test: presto engine spec tests (@kstrz)
- [#12539](https://github.com/apache/superset/pull/12539) test(hana): add test_convert_dttm (@kstrz)
- [#12633](https://github.com/apache/superset/pull/12633) docs(release): add some improvements from 1.0.0 release round (@villebro)
- [#12616](https://github.com/apache/superset/pull/12616) test: sqlite db engine spec (@kstrz)
- [#12642](https://github.com/apache/superset/pull/12642) docs: fix redirect from bad find/replace (@mistercrunch)
- [#12637](https://github.com/apache/superset/pull/12637) docs: README.md navigation changes for 1.0.0 (@garden-of-delete)
- [#12617](https://github.com/apache/superset/pull/12617) refactor: rename DbColumnType to GenericDataType (@ktmud)
- [#12171](https://github.com/apache/superset/pull/12171) refactor: Sync Scoping tree with Forms data (@simcha90)
- [#12413](https://github.com/apache/superset/pull/12413) chore(chart): Save modal select placeholder value (@nikolagigic)
- [#12591](https://github.com/apache/superset/pull/12591) docs(release): add vote thread to result template (@villebro)
- [#12570](https://github.com/apache/superset/pull/12570) refactor: extract to method is_user_admin (@amitmiran137)
- [#12571](https://github.com/apache/superset/pull/12571) chore: update contribution guide (@amitmiran137)
- [#12511](https://github.com/apache/superset/pull/12511) docs : release notes 1.0 (@garden-of-delete)
- [#12563](https://github.com/apache/superset/pull/12563) chore: upgrade CI runner to Ubuntu 20.04 (@ktmud)
- [#12534](https://github.com/apache/superset/pull/12534) build(cypress): Add Cypress parallelization with obfuscated record key (@robdiciuccio)
- [#12490](https://github.com/apache/superset/pull/12490) test: /postgres engine spec test coverage (@kstrz)
- [#12548](https://github.com/apache/superset/pull/12548) test: mysql engine spec (@kstrz)
- [#12510](https://github.com/apache/superset/pull/12510) build: fix emotion theme errors when npm link @superset-ui/core (@ktmud)
- [#12523](https://github.com/apache/superset/pull/12523) ci(cypress): disable failing test (@villebro)
- [#12405](https://github.com/apache/superset/pull/12405) chore: remove duplicate DashboardFilter class and change imports accordingly (@amitmiran137)
- [#12420](https://github.com/apache/superset/pull/12420) chore: Add owner field to the alerts list (@bkyryliuk)
- [#12394](https://github.com/apache/superset/pull/12394) build: add cancel-workflow-runs action locally (@ktmud)
- [#12267](https://github.com/apache/superset/pull/12267) docs: fix styles and add algolia search classes (@pkdotson)
- [#12020](https://github.com/apache/superset/pull/12020) build(deps): bump ini from 1.3.5 to 1.3.8 in /docs (@dependabot[bot])
- [#12232](https://github.com/apache/superset/pull/12232) build(deps): bump urijs from 1.19.1 to 1.19.4 in /superset-frontend (@dependabot[bot])
- [#11869](https://github.com/apache/superset/pull/11869) docs: reword and cleanup docs for local dev server (@ktmud)

### 1.0.1 (Tue Feb 2 09:24:40 2021 +0000)
- [#12872](https://github.com/apache/superset/pull/12872) feat(release): add github token to changelog script (#12872) (@dpgaspar)
- [#12886](https://github.com/apache/superset/pull/12886) fix: allow users to reset their passwords (#12886) (@dpgaspar)
- [#12877](https://github.com/apache/superset/pull/12877) fix(menu): always show settings dropdown (#12877) (@nytai)
- [#12648](https://github.com/apache/superset/pull/12648) fix(release): add typing-extensions as dependency (#12648) (@villebro)
- [#12861](https://github.com/apache/superset/pull/12861) fix: Presto column_type_mappings time and timestamp (#12861) (@rmgpinto)
- [#12665](https://github.com/apache/superset/pull/12665) fix: bar chart data order (#12665) (@kstrz)
- [#12661](https://github.com/apache/superset/pull/12661) add order by for bar charts (#12661) (@bryanck)
- [#12664](https://github.com/apache/superset/pull/12664) docs: fix, keep old names from screenshot images to pypi releases (#12664) (@dpgaspar)
- [#12835](https://github.com/apache/superset/pull/12835) fix(explore): add current savedMetric to dropdown (#12835) (@villebro)
- [#12817](https://github.com/apache/superset/pull/12817) chore(explore): Metric/Column and Filter popover unexpectedly closes on scroll (#12817) (@nikolagigic)
- [#12657](https://github.com/apache/superset/pull/12657) fix(explore): don't allow selecting duplicated saved metric (#12657) (@kgabryje)
- [#12798](https://github.com/apache/superset/pull/12798) docs:add deprecations to updating.md (#12798) (@eschutho)
- [#12796](https://github.com/apache/superset/pull/12796) fix: samples should not be timeseries (#12796) (@betodealmeida)
- [#12793](https://github.com/apache/superset/pull/12793) fix(explore): time picker can not be switched between now and specific (#12793) (@zhaoyongjie)
- [#12789](https://github.com/apache/superset/pull/12789) fix(explore): pass partitionColumn when creating new adhoc filter (#12789) (@villebro)
- [#12787](https://github.com/apache/superset/pull/12787) fix: uuid generatiion for mysql fixed (#12787) (@iercan)
- [#12770](https://github.com/apache/superset/pull/12770) chore(explore): Reorder dataset search results based on property relevance (#12770) (@nikolagigic)
- [#12761](https://github.com/apache/superset/pull/12761) fix(explore): Dataset icon remains constant when dragging.  (#12761) (@ayanginet)
- [#12760](https://github.com/apache/superset/pull/12760) fix: session error fixed related to thumbnails. (#12760) (@iercan)
- [#12758](https://github.com/apache/superset/pull/12758) fix(explore): incorrect missing datasource condition (#12758) (@ktmud)
- [#12747](https://github.com/apache/superset/pull/12747) feat(explore): Make metric title respond to changes immediately (#12747) (@kgabryje)
- [#12705](https://github.com/apache/superset/pull/12705) feat(explore): allow opening charts with missing dataset (#12705) (@ktmud)
- [#12468](https://github.com/apache/superset/pull/12468) fix: Added message flash when chart with missing dataset is accessed. (#12468) (@kkucharc)
- [#12804](https://github.com/apache/superset/pull/12804) fix(release): pin pyjwt to version <2 (#12804) (@villebro)
- [#12499](https://github.com/apache/superset/pull/12499) docs: update README.MD and FAQ Page for Superset 1.0 launch (#12499) (@srinify)
- [#12620](https://github.com/apache/superset/pull/12620) fix: missing key when verifying adhoc filters in merge_extra_filters (#12620) (@bryanck)
- [#12417](https://github.com/apache/superset/pull/12417) fix(explore): preserve metric column order in bar chart (#12417) (@duynguyenhoang)
- [#12103](https://github.com/apache/superset/pull/12103) fix(async queries): Remove "force" param on cached data retrieval (#12103) (@robdiciuccio)
- [#12779](https://github.com/apache/superset/pull/12779) fix(alerts/reports): misconfigured useEffect hook breaks form validation in prod builds (#12779) (@nytai)
- [#12759](https://github.com/apache/superset/pull/12759) fix: missing select menu background (#12759) (@ktmud)
- [#12730](https://github.com/apache/superset/pull/12730) Replace space with tabulator and enter as separators (#12730) (@kgabryje)
- [#12696](https://github.com/apache/superset/pull/12696) Update translation files after capitalization PRs (1-9) (#12696) (@michael-s-molina)
- [#12595](https://github.com/apache/superset/pull/12595) Fix translation files and update documentation (#12595) (@michael-s-molina)
- [#12731](https://github.com/apache/superset/pull/12731) chore[explore]: Save date if Ok not clicked (#12731) (@nikolagigic)
- [#12699](https://github.com/apache/superset/pull/12699) fix: remove whitespace at the bottom of select dropdown (#12699) (@ktmud)
- [#12685](https://github.com/apache/superset/pull/12685) chore: add capitalization guidelines to CONTRIBUTING.md (#12685) (@michael-s-molina)
- [#12675](https://github.com/apache/superset/pull/12675) feat(explore): better search for dataset pane (#12675) (@ktmud)
- [#12549](https://github.com/apache/superset/pull/12549) feat(chart): Add expression, description and verbose name to search filter (#12549) (@nikolagigic)
- [#12690](https://github.com/apache/superset/pull/12690) fix(explore): Certified metric icons are various sizes (#12690) (@geido)
- [#12660](https://github.com/apache/superset/pull/12660) fix(multiline): return all chart data on initial request (#12660) (@villebro)
- [#12632](https://github.com/apache/superset/pull/12632) chore(viz): bump superset-ui packages to 0.16.9 (#12632) (@villebro)
- [#12606](https://github.com/apache/superset/pull/12606) fix: chart disappears in standalone slice (#12606) (@duynguyenhoang)
- [#12604](https://github.com/apache/superset/pull/12604) Switch button position (#12604) (@geido)
- [#12603](https://github.com/apache/superset/pull/12603) [12601] Hovered menu items on dashboard - brought back padding and added margin on top of chart (#12603) (@kkucharc)
- [#12593](https://github.com/apache/superset/pull/12593) chore(explore): Save Resizable width to localStorage (#12593) (@nikolagigic)
- [#12649](https://github.com/apache/superset/pull/12649) fix: explore page style fix, remove unnecessary scroll bars (#12649) (@ktmud)
- [#12586](https://github.com/apache/superset/pull/12586) fix: error while parsing invalid json form_data (#12586) (@duynguyenhoang)
- [#12161](https://github.com/apache/superset/pull/12161) test: World bank examples (#12161) (@kstrz)
- [#12226](https://github.com/apache/superset/pull/12226) test: birth names (#12226) (@kstrz)
- [#12584](https://github.com/apache/superset/pull/12584) fix: dropdown indicator in tabs has proper width and position (#12584) (@kkucharc)
- [#12580](https://github.com/apache/superset/pull/12580) chore(explore): added tooltips to timepicker (#12580) (@zhaoyongjie)
- [#12577](https://github.com/apache/superset/pull/12577) corrected typo in connections index in the documentation (#12577) (@96RadhikaJadhav)
- [#12575](https://github.com/apache/superset/pull/12575) fix: return appropriate response when payload has error (#12575) (@zhaoyongjie)
- [#12573](https://github.com/apache/superset/pull/12573) Add docs for GLOBAL_ASYNC_QUERIES (SIP-39) (#12573) (@robdiciuccio)
- [#12564](https://github.com/apache/superset/pull/12564) chore: bumping superset UI packages (0.16.7 + 0.16.8) (#12564) (@rusackas)
- [#12498](https://github.com/apache/superset/pull/12498) fix: row component handler is visible (#12498) (@kkucharc)
- [#12454](https://github.com/apache/superset/pull/12454) Apply capitalization guidelines - iteration 8 (#12343) (#12454) (@michael-s-molina)
- [#12453](https://github.com/apache/superset/pull/12453) Apply capitalization guidelines - iteration 7 (#12343) (#12453) (@michael-s-molina)
- [#12452](https://github.com/apache/superset/pull/12452) Apply capitalization guidelines - iteration 6 (#12343) (#12452) (@michael-s-molina)
- [#12451](https://github.com/apache/superset/pull/12451) Apply capitalization guidelines - iteration 5 (#12343) (#12451) (@michael-s-molina)
- [#12582](https://github.com/apache/superset/pull/12582) fix(explore): Disable saved metric name edit in Metric popover (#12582) (@kgabryje)
- [#12446](https://github.com/apache/superset/pull/12446) refactor(explore): move MetricControl and FilterControl to sub-component (#12446) (@zhaoyongjie)
- [#12450](https://github.com/apache/superset/pull/12450) Apply capitalization guidelines - iteration 4 (#12343) (#12450) (@michael-s-molina)
- [#12554](https://github.com/apache/superset/pull/12554) feat(native-filters): Show alert for unsaved filters after cancelling Filter Config Modal (#12554) (@agatapst)
- [#12449](https://github.com/apache/superset/pull/12449) Apply capitalization guidelines - iteration 3 (#12343) (#12449) (@michael-s-molina)
- [#12598](https://github.com/apache/superset/pull/12598) fix(explore): Scroll only table in Change Dataset and Edit Dataset Modals (#12598) (@geido)
- [#12471](https://github.com/apache/superset/pull/12471) fix: styling for change dataset confirmation (#12471) (@hughhhh)
- [#12669](https://github.com/apache/superset/pull/12669) fix: faster search for Change Dataset modal (#12669) (@ktmud)
- [#12448](https://github.com/apache/superset/pull/12448) Apply capitalization guidelines - iteration 2 (#12343) (#12448) (@michael-s-molina)
- [#12447](https://github.com/apache/superset/pull/12447) chore: apply capitalization guidelines - iteration 1 (#12447) (@michael-s-molina)
- [#12423](https://github.com/apache/superset/pull/12423) fix: incorrect cursor position Firefox (#12423) (@betodealmeida)

### 1.0.0 (Fri Jan 15 14:09:06 2021 -0800)
- [#12535](https://github.com/apache/superset/pull/12535) Fix 500 error when loading dashboards with slice having deleted dataset (#12535) (@bechob)
- [#12562](https://github.com/apache/superset/pull/12562) fix: case expression should not have double quotes (#12562) (@betodealmeida)
- [#12558](https://github.com/apache/superset/pull/12558) fix: height on grid results (#12558) (@betodealmeida)
- [#12556](https://github.com/apache/superset/pull/12556) fix(viz): missing groupby and broken adhoc metrics for boxplot (#12556) (@ktmud)
- [#12555](https://github.com/apache/superset/pull/12555) fix: Add MAX_SQL_ROW value to LIMIT_DROPDOWN (#12555) (@hughhhh)
- [#12410](https://github.com/apache/superset/pull/12410) fix: Popover closes on change of dropdowns values (#12410) (@geido)
- [#12337](https://github.com/apache/superset/pull/12337) chore: rename docker image in build_docker_image.sh, docker-compose.yml and helm values.yaml (#12337) (@amitmiran137)
- [#12403](https://github.com/apache/superset/pull/12403) feat(db-engine): Add support for Apache Solr (#12403) (@aadel)
- [#12497](https://github.com/apache/superset/pull/12497) Fix list filters vertical alignment (#12497) (@michael-s-molina)
- [#12522](https://github.com/apache/superset/pull/12522) fix: Select options overflowing Save chart modal on Explore view (#12522) (@kgabryje)
- [#12536](https://github.com/apache/superset/pull/12536) Fixing Pinot queries for time granularities: WEEKS/MONTHS/QUARTERS/YEARS (#12536) (@fx19880617)
- [#12537](https://github.com/apache/superset/pull/12537) fix(explore): Add Time section back to FilterBox (#12537) (@ktmud)
- [#12532](https://github.com/apache/superset/pull/12532) fix(explore): time table control panel (#12532) (@ktmud)
- [#12530](https://github.com/apache/superset/pull/12530) fix: lowercase all columns in examples (#12530) (@betodealmeida)
- [#12518](https://github.com/apache/superset/pull/12518) ci: remove refs/tags from docker tags on a release (#12518) (@dpgaspar)
- [#12491](https://github.com/apache/superset/pull/12491) fix: impose dataset ownership check on old API (#12491) (@dpgaspar)
- [#12425](https://github.com/apache/superset/pull/12425) fix: import ZIP files that have been modified (#12425) (@betodealmeida)
- [#12472](https://github.com/apache/superset/pull/12472) fix (SQL Lab): disappearing results on tab switch (#12472) (@betodealmeida)
- [#12489](https://github.com/apache/superset/pull/12489) fix(timepicker): make pyparsing thread safe (#12489) (@zhaoyongjie)
- [#12483](https://github.com/apache/superset/pull/12483) fix(dashboard): use datasource id from slice metadata (#12483) (@ktmud)
- [#12478](https://github.com/apache/superset/pull/12478) fix: do not show vertical scrollbar for charts in dashboard (#12478) (@graceguo-supercat)
- [#12466](https://github.com/apache/superset/pull/12466) chore: bump superset-ui deckgl plugin (#12466) (@rusackas)
- [#12426](https://github.com/apache/superset/pull/12426) bump superset-ui packages for rolling window change (#12426) (@pkdotson)
- [#12418](https://github.com/apache/superset/pull/12418) fix(dashboard): artefacts shown while drag and dropping deck.gl charts (#12418) (@kkucharc)
- [#12411](https://github.com/apache/superset/pull/12411) feat: Resizable dataset and controls panels on Explore view (#12411) (@kgabryje)
- [#12326](https://github.com/apache/superset/pull/12326) Fixes control panel fields styling (#12236) (#12326) (@michael-s-molina)
- [#12408](https://github.com/apache/superset/pull/12408) refactor: from superset.utils.core break down date_parser (#12408) (@zhaoyongjie)
- [#12409](https://github.com/apache/superset/pull/12409) fix(native-filters): incorrect queriesData state (#12409) (@villebro)
- [#12406](https://github.com/apache/superset/pull/12406) fix: Refresh Interval Modal dropdown (#12406) (@agatapst)
- [#12402](https://github.com/apache/superset/pull/12402) chore: change Datasource to Dataset in Explore ui (#12402) (@junlincc)
- [#12401](https://github.com/apache/superset/pull/12401) feat(explore): add tooltip to timepicker label (#12401) (@zhaoyongjie)
- [#12393](https://github.com/apache/superset/pull/12393) chore: upgrade eslint, babel, and prettier (#12393) (@ktmud)
- [#12392](https://github.com/apache/superset/pull/12392) chore: Fix typo "Rest" to "Reset" (#12392) (@junlincc)
- [#12391](https://github.com/apache/superset/pull/12391) chore: Show datasets when search input is empty (#12391) (@geido)
- [#12387](https://github.com/apache/superset/pull/12387) fix(explore): long metric name display (#12387) (@zhaoyongjie)
- [#12359](https://github.com/apache/superset/pull/12359) fix: explore replace wrong standalone slice url (#12359) (@duynguyenhoang)
- [#12390](https://github.com/apache/superset/pull/12390) Closes #12389 (#12390) (@geido)
- [#12383](https://github.com/apache/superset/pull/12383) fix: Data tables styling issues on Explore view (#12383) (@kgabryje)
- [#12385](https://github.com/apache/superset/pull/12385) Fix new metric popover showing previous popover's title (#12385) (@kgabryje)
- [#12381](https://github.com/apache/superset/pull/12381) fix(explore): adhoc metric label and control value not consistent (#12381) (@zhaoyongjie)
- [#12382](https://github.com/apache/superset/pull/12382) fix(explore): clear custom label if removed (#12382) (@villebro)
- [#12377](https://github.com/apache/superset/pull/12377) Fix filter popover under data table (#12377) (@kgabryje)
- [#12378](https://github.com/apache/superset/pull/12378) Update samples table when datasource changes (#12378) (@kgabryje)
- [#12368](https://github.com/apache/superset/pull/12368) fix: datasets populating after user creation (#12368) (@hughhhh)
- [#12365](https://github.com/apache/superset/pull/12365) chore: make datasource search input sticky (#12365) (@pkdotson)
- [#12362](https://github.com/apache/superset/pull/12362) fix: Fix chart resizing when using split view (#12362) (@kgabryje)
- [#12096](https://github.com/apache/superset/pull/12096) ci(docker): fix release published event checkout tag-sha (#12096) (@dpgaspar)
- [#12082](https://github.com/apache/superset/pull/12082) test: rename column names for birth_names dataset (#12082) (@ktmud)
- [#12351](https://github.com/apache/superset/pull/12351) fix(load examples): load examples creating unnecessary main database (#12351) (@dpgaspar)
- [#12361](https://github.com/apache/superset/pull/12361) Fix running query on every change in chart controls (#12361) (@kgabryje)
- [#12357](https://github.com/apache/superset/pull/12357) fix: Fix dataset condition to allow query for datasets in sqllab (#12357) (@hughhhh)
- [#12257](https://github.com/apache/superset/pull/12257) perf: Optimize performance of Results and Samples tables on Explore (#12257) (@kgabryje)
- [#12353](https://github.com/apache/superset/pull/12353) Fix CSS injection order (#12265) (#12353) (@michael-s-molina)
- [#12352](https://github.com/apache/superset/pull/12352) chore(dashboard): Add ErrorBoudary for AdhocFilter components (#12352) (@nikolagigic)
- [#12350](https://github.com/apache/superset/pull/12350) fix(explore): improve filter translation (#12350) (@villebro)
- [#12306](https://github.com/apache/superset/pull/12306) fix: Set width to pseudoelement to wrap filter box (#12306) (@maloun96)
- [#12318](https://github.com/apache/superset/pull/12318) fix: south pane scrolling issues (#12318) (@eschutho)
- [#12349](https://github.com/apache/superset/pull/12349) chore: bumping nvd3 plugin (and thus, nvd3-fork) (#12349) (@rusackas)
- [#12307](https://github.com/apache/superset/pull/12307) refactor: test connection raises only command exceptions (#12307) (@dpgaspar)
- [#12154](https://github.com/apache/superset/pull/12154) feat: move filters from superset-ui to incubator (#12154) (@simchaNielsen)
- [#12347](https://github.com/apache/superset/pull/12347) window.location > history.push (#12347) (@rusackas)
- [#12315](https://github.com/apache/superset/pull/12315) feat: provide support for an overridable template to be included in every view (#12315) (@nytai)
- [#12344](https://github.com/apache/superset/pull/12344) remove datataset from title (#12344) (@pkdotson)
- [#12338](https://github.com/apache/superset/pull/12338) feat: new COVID vaccination dashboard (#12338) (@betodealmeida)
- [#12335](https://github.com/apache/superset/pull/12335) chore: change order of tab on explore data panel  (#12335) (@lilykuang)
- [#12320](https://github.com/apache/superset/pull/12320) fix: append orphan charts (#12320) (@betodealmeida)
- [#12067](https://github.com/apache/superset/pull/12067) feat: SQL Toolbar (#12067) (@hughhhh)
- [#12334](https://github.com/apache/superset/pull/12334) Reduce z-index (#12334) (@geido)
- [#12330](https://github.com/apache/superset/pull/12330) Fix menuPortal dropdown z-index (#12330) (@geido)
- [#12311](https://github.com/apache/superset/pull/12311) fix(alert/report): add/edit modal can't be saved (#12311) (@lilykuang)
- [#12327](https://github.com/apache/superset/pull/12327) Fix select overlap by aggregate button (#12312) (#12327) (@michael-s-molina)
- [#12090](https://github.com/apache/superset/pull/12090) build: try to speed up Github workflows (#12090) (@ktmud)
- [#12313](https://github.com/apache/superset/pull/12313) build: improve webpack configs for npm link (#12313) (@ktmud)
- [#12210](https://github.com/apache/superset/pull/12210) feat: Custom color schemes support (#12210) (@amitmiran137)
- [#12282](https://github.com/apache/superset/pull/12282) chore: improve styles for collapsed Native Filter sidebar (#12282) (@agatapst)
- [#12305](https://github.com/apache/superset/pull/12305) fix(explore): metrics caret not expanding in datasource panel (#12305) (@geido)
- [#12319](https://github.com/apache/superset/pull/12319) fix: update search in datasource panel to use matchSorter (#12319) (@pkdotson)
- [#12019](https://github.com/apache/superset/pull/12019) build(deps): bump ini in /superset-frontend/cypress-base (#12019) (@dependabot[bot])
- [#12284](https://github.com/apache/superset/pull/12284) docs: remove (some) references to incubating/incubation (#12284) (@nytai)
- [#12022](https://github.com/apache/superset/pull/12022) docs: Added release notes and associated media for 0.38 (#12022) (@garden-of-delete)
- [#12021](https://github.com/apache/superset/pull/12021) build(deps): bump ini from 1.3.5 to 1.3.8 in /superset-frontend (#12021) (@dependabot[bot])
- [#12308](https://github.com/apache/superset/pull/12308) fix(explore): refine previous calendar range (#12308) (@zhaoyongjie)
- [#12261](https://github.com/apache/superset/pull/12261) add related field filter to queries/user (#12261) (@riahk)
- [#12300](https://github.com/apache/superset/pull/12300) fix(explore): timepicker show human readable string in pill (#12300) (@zhaoyongjie)
- [#12278](https://github.com/apache/superset/pull/12278) fix(explore): bugs in Custom SQL editor in filter popover (#12278) (@kgabryje)
- [#12289](https://github.com/apache/superset/pull/12289) chore: remove harmless incubator refs (#12289) (@amitmiran137)
- [#12274](https://github.com/apache/superset/pull/12274) fix(database): OpenAPI spec for test_connection (#12274) (@dpgaspar)
- [#12277](https://github.com/apache/superset/pull/12277) fix(reports): don't log user errors and state change has errors (#12277) (@dpgaspar)
- [#12291](https://github.com/apache/superset/pull/12291) build: ignore github actions from dependabot (#12291) (@ktmud)
- [#12295](https://github.com/apache/superset/pull/12295) fix null check for condition threshold to allow 0 values (#12295) (@riahk)
- [#12280](https://github.com/apache/superset/pull/12280) Bump superset-ui deps (#12280) (@kgabryje)
- [#12221](https://github.com/apache/superset/pull/12221) fix: Fixed width for dataset panel (#12221) (@kgabryje)
- [#12239](https://github.com/apache/superset/pull/12239) chore(home): add ErrorBoundary to Charts section (#12239) (@maxamante)
- [#12292](https://github.com/apache/superset/pull/12292) fix: load example data into correct DB (#12292) (@betodealmeida)
- [#12297](https://github.com/apache/superset/pull/12297) Cypress: ignore unrelated ResizeObserver client errors (#12297) (@robdiciuccio)
- [#12253](https://github.com/apache/superset/pull/12253) test: fix flaky Python unit tests (#12253) (@kstrz)
- [#12213](https://github.com/apache/superset/pull/12213) Fix tests errors and warnings - iteration 1 (#12212) (#12213) (@michael-s-molina)
- [#12258](https://github.com/apache/superset/pull/12258) fix: Issue #12004 timegrain not visibile (#12258) (@geido)
- [#12250](https://github.com/apache/superset/pull/12250) fix: Show Data panel on resize (#12250) (@maloun96)
- [#12153](https://github.com/apache/superset/pull/12153) fix: Add visibility to box for viewing menu items (#12153) (@maloun96)
- [#12290](https://github.com/apache/superset/pull/12290) build: remove parallelization for E2E tests (#12290) (@ktmud)
- [#12288](https://github.com/apache/superset/pull/12288) fix: Add min-height for loading indicator to show up (#12288) (@geido)
- [#12192](https://github.com/apache/superset/pull/12192) build(deps-dev): bump storybook-addon-paddings in /superset-frontend (#12192) (@dependabot[bot])
- [#12205](https://github.com/apache/superset/pull/12205) fix: SaveDatasetModal save state on back button (#12205) (@hughhhh)
- [#12251](https://github.com/apache/superset/pull/12251) docs: fix build status badge to github actions (#12251) (@dpgaspar)
- [#12215](https://github.com/apache/superset/pull/12215) fix : Style caret for profile page (#12215) (@maloun96)
- [#12211](https://github.com/apache/superset/pull/12211) Set datasource panel open by default (#12211) (@kgabryje)
- [#12242](https://github.com/apache/superset/pull/12242) fix(explore): bump superset-ui to 0.16.3 and fix DeckGL bug (#12242) (@villebro)
- [#12208](https://github.com/apache/superset/pull/12208) feat(explore): Time picker enhancement follow up (#12208) (@zhaoyongjie)
- [#11960](https://github.com/apache/superset/pull/11960) fix: Altered button crashing and title not updating on Explore view (#11960) (@kgabryje)
- [#12217](https://github.com/apache/superset/pull/12217) Remove uppercase for tab names (#12217) (@maloun96)
- [#12248](https://github.com/apache/superset/pull/12248) build(deps): bump node-fetch in /.github/actions/file-changes-action (#12248) (@dependabot[bot])
- [#12246](https://github.com/apache/superset/pull/12246) build(deps): bump @actions/core in /.github/actions/file-changes-action (#12246) (@dependabot[bot])
- [#12050](https://github.com/apache/superset/pull/12050) docs(api): Script to generate API docs (openapi.json) (#12050) (@robdiciuccio)
- [#12165](https://github.com/apache/superset/pull/12165) fix: Change Datasource styling fixes (#12165) (@hughhhh)
- [#12188](https://github.com/apache/superset/pull/12188) fix: CTAS on multiple statements (#12188) (@betodealmeida)
- [#12183](https://github.com/apache/superset/pull/12183) feat(report): add/edit modal improvements (#12183) (@lilykuang)
- [#12241](https://github.com/apache/superset/pull/12241) build: inline external Github Actions to unblock CI (#12241) (@ktmud)
- [#11999](https://github.com/apache/superset/pull/11999) Refetch samples only when filters change (#11999) (@kgabryje)
- [#12184](https://github.com/apache/superset/pull/12184) feat: Implement drag & drop for metrics and filters labels (#12184) (@kgabryje)
- [#12196](https://github.com/apache/superset/pull/12196) fix(reports): make name unique between alerts and reports (#12196) (@dpgaspar)
- [#12193](https://github.com/apache/superset/pull/12193) fix: align submenu items (#12193) (@maloun96)
- [#12163](https://github.com/apache/superset/pull/12163) feat: add new dashboard with FCC data (#12163) (@betodealmeida)
- [#12189](https://github.com/apache/superset/pull/12189) fix(alerts/reports): ensure correct type is sent to api (#12189) (@nytai)
- [#12097](https://github.com/apache/superset/pull/12097) docs: update UPDATING.md with security simplification info (#12097) (@dpgaspar)
- [#12174](https://github.com/apache/superset/pull/12174) fix(reports): notification without standalone link back to superset (#12174) (@dpgaspar)
- [#12191](https://github.com/apache/superset/pull/12191) updated SQLAlchemy=1.3.21 is incompatible in setup.py file. (#12191) (@jagamts1)
- [#12179](https://github.com/apache/superset/pull/12179) fix(chart): rendering standalone chart and errors (#12179) (@agatapst)
- [#12158](https://github.com/apache/superset/pull/12158) chore: Add Loading icon to Filter Bar (#12158) (@agatapst)
- [#12091](https://github.com/apache/superset/pull/12091) refactor: remove queryFields in QueryObject and update chart control configs (#12091) (@ktmud)
- [#12187](https://github.com/apache/superset/pull/12187) fix: SQL Lab vertical space (#12187) (@betodealmeida)
- [#12166](https://github.com/apache/superset/pull/12166) fix: append ID to filename when exporting chart (#12166) (@betodealmeida)
- [#12185](https://github.com/apache/superset/pull/12185) fix: remove uniqueness for MySQL (#12185) (@betodealmeida)
- [#12186](https://github.com/apache/superset/pull/12186) fix: specify VARCHAR size when loading examples (#12186) (@betodealmeida)
- [#12178](https://github.com/apache/superset/pull/12178) fix(explore): save chart not working (#12178) (@villebro)
- [#12075](https://github.com/apache/superset/pull/12075) chore: Change chart_is_fav to chart_is_favorite (#12075) (@nikolagigic)
- [#12168](https://github.com/apache/superset/pull/12168) refactor: Refresh interval typescript (#12168) (@maloun96)
- [#12162](https://github.com/apache/superset/pull/12162) feat: add new dashboard with video game sales (#12162) (@betodealmeida)
- [#12156](https://github.com/apache/superset/pull/12156) Fix Filter Bar scrolling (#12156) (@agatapst)
- [#12010](https://github.com/apache/superset/pull/12010) refactor: Fix anchor-is-valid lint warnings (#12010) (@michael-s-molina)
- [#12151](https://github.com/apache/superset/pull/12151) test(dashboard): fix flaky Cypress test (#12151) (@ktmud)
- [#12159](https://github.com/apache/superset/pull/12159) chore: rename variable for clarity (#12159) (@betodealmeida)
- [#12136](https://github.com/apache/superset/pull/12136) fix: database alpha permissions (#12136) (@dpgaspar)
- [#12121](https://github.com/apache/superset/pull/12121) fix(report): fix last_eval_dttm sort and more tests (#12121) (@dpgaspar)
- [#12157](https://github.com/apache/superset/pull/12157) Fix Reset All filters button (#12157) (@agatapst)
- [#11997](https://github.com/apache/superset/pull/11997) refactor: Explore SaveModal to typescript (#11997) (@maloun96)
- [#12132](https://github.com/apache/superset/pull/12132) fix(report): fix start date format and paginated query (#12132) (@lilykuang)
- [#12146](https://github.com/apache/superset/pull/12146) fix(database): adjust column sizing for list view (#12146) (@nytai)
- [#10288](https://github.com/apache/superset/pull/10288) feat: Dynamically imported viz plugins (#10288) (@suddjian)
- [#12138](https://github.com/apache/superset/pull/12138) feat: Native filters fast-follow (#12138) (@rusackas)
- [#12144](https://github.com/apache/superset/pull/12144) fix(chart): replace viz_type with viz name from registry for list view (#12144) (@nytai)
- [#12145](https://github.com/apache/superset/pull/12145) fix height (#12145) (@pkdotson)
- [#11814](https://github.com/apache/superset/pull/11814) feat(dashboard): Dashboard-Native Filters (#11814) (@suddjian)
- [#12130](https://github.com/apache/superset/pull/12130) feat: estimate query cost in Postgres (#12130) (@betodealmeida)
- [#12113](https://github.com/apache/superset/pull/12113) feat: display suggestions when query has missing parameters (#12113) (@betodealmeida)
- [#12135](https://github.com/apache/superset/pull/12135) fix: make example table name safe (#12135) (@betodealmeida)
- [#12127](https://github.com/apache/superset/pull/12127) fix: remove SIP_34_ALERTS_UI from config (#12127) (@nytai)
- [#12129](https://github.com/apache/superset/pull/12129) fix(explore): overflow issue with metric options (#12129) (@rusackas)
- [#12125](https://github.com/apache/superset/pull/12125) Improves chart save and go button (#12125) (@michael-s-molina)
- [#12060](https://github.com/apache/superset/pull/12060) feat: View all fav charts and dashboards (#12060) (@geido)
- [#12123](https://github.com/apache/superset/pull/12123) feat: Add Saved Metrics tab to metrics popover (#12123) (@kgabryje)
- [#12116](https://github.com/apache/superset/pull/12116) fix: properly render booleans in FilterBox and explore page data preview (#12116) (@ktmud)
- [#12124](https://github.com/apache/superset/pull/12124) fix: fix the flaky FilterBox test re-introduced by #12114 (#12124) (@ktmud)
- [#11880](https://github.com/apache/superset/pull/11880) feat: Support multiple queries per request (#11880) (@simchaNielsen)
- [#12115](https://github.com/apache/superset/pull/12115) fix: remove keys in dashboard export (#12115) (@betodealmeida)
- [#12118](https://github.com/apache/superset/pull/12118) feat(chart-data-api): ignore unknown fields on QueryObject (#12118) (@villebro)
- [#12119](https://github.com/apache/superset/pull/12119) fix: security cleanup annotation and refresh permissions (#12119) (@dpgaspar)
- [#12117](https://github.com/apache/superset/pull/12117) docs(releasing): update release automation and docs for Apache graduation (#12117) (@dpgaspar)
- [#12008](https://github.com/apache/superset/pull/12008) feat(explore-datasource): add new datasource tab to explore view (#12008) (@pkdotson)
- [#12114](https://github.com/apache/superset/pull/12114) fix: FilterBox select lose focus when focused (#12114) (@ktmud)
- [#12045](https://github.com/apache/superset/pull/12045) fix: updates to alert/report modal + more tests (#12045) (@riahk)
- [#12085](https://github.com/apache/superset/pull/12085) feat(alerts/reports): remove SIP_34_UI feature flag (#12085) (@riahk)
- [#12110](https://github.com/apache/superset/pull/12110) fix(alerts/reports): modal submit button, copy changes, select apis (#12110) (@nytai)
- [#12080](https://github.com/apache/superset/pull/12080) feat: initial custom error messages for SQL Lab (#12080) (@betodealmeida)
- [#11418](https://github.com/apache/superset/pull/11418) feat(explore): time picker enhancement (#11418) (@zhaoyongjie)
- [#12081](https://github.com/apache/superset/pull/12081) feat: update alert/report icons and column order (#12081) (@lilykuang)
- [#12095](https://github.com/apache/superset/pull/12095) feat(explore): metrics and filters controls redesign (#12095) (@kgabryje)
- [#12071](https://github.com/apache/superset/pull/12071) feat(alerts/reports): add refresh action (#12071) (@nytai)
- [#11148](https://github.com/apache/superset/pull/11148) chore: add latest tag action (#11148) (@eschutho)
- [#12056](https://github.com/apache/superset/pull/12056) fix(reports): increase crontab size and alert fixes (#12056) (@dpgaspar)
- [#12099](https://github.com/apache/superset/pull/12099) Small typo fix in Athena connection docs (#12099) (@lamielle)
- [#12072](https://github.com/apache/superset/pull/12072) feat(queries): security perm simplification (#12072) (@dpgaspar)
- [#12036](https://github.com/apache/superset/pull/12036) feat(databases): security perm simplification (#12036) (@dpgaspar)
- [#12012](https://github.com/apache/superset/pull/12012) feat(dashboards): security permissions simplification (#12012) (@dpgaspar)
- [#12061](https://github.com/apache/superset/pull/12061) feat(logs): security permissions simplification (#12061) (@kkucharc)
- [#11972](https://github.com/apache/superset/pull/11972) chore: Remove unused CodeModal (#11972) (@maloun96)
- [#12074](https://github.com/apache/superset/pull/12074) Fix typescript error (#12074) (@ktmud)
- [#12088](https://github.com/apache/superset/pull/12088) fix: handle context-dependent feature flags in CLI (#12088) (@betodealmeida)
- [#12086](https://github.com/apache/superset/pull/12086) fix: Fix "View in SQLLab" bug (#12086) (@hughhhh)
- [#12077](https://github.com/apache/superset/pull/12077) feat(alert/report): add 'not null' condition option to modal (#12077) (@riahk)
- [#12078](https://github.com/apache/superset/pull/12078) bumping superset ui to 15.18 and deckgl to 0.3.2 (#12078) (@rusackas)
- [#12079](https://github.com/apache/superset/pull/12079) fix: Python dependencies in #11499 (#12079) (@john-bodley)
- [#12048](https://github.com/apache/superset/pull/12048) reset active tab on open (#12048) (@riahk)
- [#12070](https://github.com/apache/superset/pull/12070) fix: improve import flow UI/UX (#12070) (@betodealmeida)
- [#12053](https://github.com/apache/superset/pull/12053) feat(alerts/reports): delete and bulk delete actions (#12053) (@nytai)
- [#12025](https://github.com/apache/superset/pull/12025) feat: Global nav menus open on hover (#12025) (@rusackas)
- [#12076](https://github.com/apache/superset/pull/12076) Remove e2e pull_request event trigger (#12076) (@robdiciuccio)
- [#11750](https://github.com/apache/superset/pull/11750) build(cypress): Use pull_request_target event to run cypress (#11750) (@robdiciuccio)
- [#11979](https://github.com/apache/superset/pull/11979) fix(dataset): Page blanks on large data load (#11979) (@nikolagigic)
- [#12000](https://github.com/apache/superset/pull/12000) feat(datasets): security perm simplification (#12000) (@dpgaspar)
- [#12014](https://github.com/apache/superset/pull/12014) feat(annotations): security permissions simplification (#12014) (@kkucharc)
- [#12038](https://github.com/apache/superset/pull/12038) fix: Closes #11864 - Duplicate PropertiesModal (#12038) (@geido)
- [#12042](https://github.com/apache/superset/pull/12042) refactor: Migrate react-select to Antd Select in Metrics and Filters popovers (#12042) (@kgabryje)
- [#12049](https://github.com/apache/superset/pull/12049) feat: show missing parameters in query (#12049) (@betodealmeida)
- [#11970](https://github.com/apache/superset/pull/11970) feat: add hook for dataset health check (#11970) (@graceguo-supercat)
- [#11927](https://github.com/apache/superset/pull/11927) refactor: optimize backend log payload (#11927) (@ktmud)
- [#12044](https://github.com/apache/superset/pull/12044) feat: Add new default dashboard (#12044) (@betodealmeida)
- [#12026](https://github.com/apache/superset/pull/12026) feat: load examples from config instead of code (#12026) (@betodealmeida)
- [#12064](https://github.com/apache/superset/pull/12064) fix: small fixes to the new import/export (#12064) (@betodealmeida)
- [#12063](https://github.com/apache/superset/pull/12063) fix(annotation layers): remove redirect on layer edit (#12063) (@riahk)
- [#11803](https://github.com/apache/superset/pull/11803) feat: handle new export in CLI (#11803) (@betodealmeida)
- [#12057](https://github.com/apache/superset/pull/12057) fixed CONTRIBUTING typos (#12057) (@adam-stasiak)
- [#11971](https://github.com/apache/superset/pull/11971) refactor: Transform URLShortLinkModal to Typescript (#11971) (@maloun96)
- [#11981](https://github.com/apache/superset/pull/11981) feat(charts): security perm simplification (#11981) (@dpgaspar)
- [#12055](https://github.com/apache/superset/pull/12055) fix(viz): remove orderby from sample request (#12055) (@villebro)
- [#12054](https://github.com/apache/superset/pull/12054) upgrade react-split (#12054) (@rusackas)
- [#11853](https://github.com/apache/superset/pull/11853) feat(reports): security perm simplification (#11853) (@dpgaspar)
- [#12039](https://github.com/apache/superset/pull/12039) fix(reports): log duration and sort column (#12039) (@dpgaspar)
- [#12035](https://github.com/apache/superset/pull/12035) fix(reports): apply owners security validation (#12035) (@dpgaspar)
- [#11996](https://github.com/apache/superset/pull/11996) fix: Fix style for error modal (#11996) (@maloun96)
- [#11957](https://github.com/apache/superset/pull/11957) chore: bumping plugin packages to latest (#11957) (@rusackas)
- [#12032](https://github.com/apache/superset/pull/12032) feat: add cron picker to AlertReportModal (#12032) (@nytai)
- [#12043](https://github.com/apache/superset/pull/12043) fix: disable browser autocomplete for DeleteModal (#12043) (@nytai)
- [#12006](https://github.com/apache/superset/pull/12006) fix: Explore "Change Dataset" UX Enhancements (#12006) (@hughhhh)
- [#12018](https://github.com/apache/superset/pull/12018) fix schema datasource modal (#12018) (@lilykuang)
- [#11207](https://github.com/apache/superset/pull/11207) feat: Added setup for running Cypress tests in docker locally (#11207) (@adam-stasiak)
- [#12013](https://github.com/apache/superset/pull/12013) refactor: Existing Antd Collapse to enhanced (#12013) (@geido)
- [#12024](https://github.com/apache/superset/pull/12024) style: Restoring menu highlights (#12024) (@rusackas)
- [#11978](https://github.com/apache/superset/pull/11978) docs: restored page on roles in security, executed other touchups, and… (#11978) (@srinify)
- [#11993](https://github.com/apache/superset/pull/11993) refactor : Change menu name and reorder items (#11993) (@maloun96)
- [#11915](https://github.com/apache/superset/pull/11915) fix: Change url & add check for active item in menu (#11915) (@maloun96)
- [#11991](https://github.com/apache/superset/pull/11991) feat: update IDs when importing dashboards (#11991) (@betodealmeida)
- [#11983](https://github.com/apache/superset/pull/11983) feat: add confirmation dialog for imports (#11983) (@betodealmeida)
- [#11770](https://github.com/apache/superset/pull/11770) feat: alerts/reports add/edit modal (#11770) (@riahk)
- [#12007](https://github.com/apache/superset/pull/12007) fix: add default position to dash export (#12007) (@betodealmeida)
- [#12003](https://github.com/apache/superset/pull/12003) chore: remove generic type (#12003) (@betodealmeida)
- [#11973](https://github.com/apache/superset/pull/11973) fix(dataset): fetch metadata on dataset creation may raise broad exceptions (#11973) (@dpgaspar)
- [#11951](https://github.com/apache/superset/pull/11951) refactor : Transform SaveModal to typescript (#11951) (@maloun96)
- [#11499](https://github.com/apache/superset/pull/11499) feat(SIP-39): Async query support for charts (#11499) (@robdiciuccio)
- [#11994](https://github.com/apache/superset/pull/11994) feat: add invisible layer on loading chart (#11994) (@graceguo-supercat)
- [#11937](https://github.com/apache/superset/pull/11937) feat: alert/report execution log list view (#11937) (@lilykuang)
- [#11982](https://github.com/apache/superset/pull/11982) feat: confirm overwrite when importing (#11982) (@betodealmeida)
- [#12002](https://github.com/apache/superset/pull/12002) chore: move passwords needed message (#12002) (@betodealmeida)
- [#11977](https://github.com/apache/superset/pull/11977) refactor: Removes hard coded colors (#11977) (@michael-s-molina)
- [#11936](https://github.com/apache/superset/pull/11936) chore: consolidate common code in importers (#11936) (@betodealmeida)
- [#11980](https://github.com/apache/superset/pull/11980) fix : Fix style for header (sqllab) (#11980) (@maloun96)
- [#11946](https://github.com/apache/superset/pull/11946) fix(explore): changing metric aggregate doesn't update label (#11946) (@mayurnewase)
- [#11990](https://github.com/apache/superset/pull/11990) fixing rounded corners (#11990) (@rusackas)
- [#11964](https://github.com/apache/superset/pull/11964) refactor : Transform FilterScopeModal to Typescript (#11964) (@maloun96)
- [#11963](https://github.com/apache/superset/pull/11963) fix : adhoc filter dropdown (#11963) (@maloun96)
- [#11985](https://github.com/apache/superset/pull/11985) Debounce TextControl if change runs immediately after input (#11985) (@kgabryje)
- [#11975](https://github.com/apache/superset/pull/11975) Change paddings on ListView and SubMenu (#11975) (@kgabryje)
- [#11986](https://github.com/apache/superset/pull/11986) add user to sql lab state (#11986) (@eschutho)
- [#11987](https://github.com/apache/superset/pull/11987) fix: make "DELETE" confirmation work in other languages (#11987) (@betodealmeida)
- [#11308](https://github.com/apache/superset/pull/11308) tests: added fixture with energy usage instead of example (#11308) (@kkucharc)
- [#11967](https://github.com/apache/superset/pull/11967) refactor: Upgrade Redux (#11967) (@suddjian)
- [#11883](https://github.com/apache/superset/pull/11883) refactor: move enums to the beginning of utiuls/core.py (#11883) (@ktmud)
- [#11890](https://github.com/apache/superset/pull/11890) fix(reports): validator_config, report state machine, working_timeout (#11890) (@dpgaspar)
- [#11934](https://github.com/apache/superset/pull/11934) fix: always fetch database list on bootstrap payload (#11934) (@mistercrunch)
- [#11755](https://github.com/apache/superset/pull/11755) feat: Sqllab to Explore UX improvements (#11755) (@hughhhh)
- [#11940](https://github.com/apache/superset/pull/11940) build: cancel previous github action runs (#11940) (@ktmud)
- [#11950](https://github.com/apache/superset/pull/11950) fix(alerts, thumbnails): celery tasks using flask-sqlalchemy sessions (#11950) (@dpgaspar)
- [#11885](https://github.com/apache/superset/pull/11885) fix(event-flow-viz): handle null metadata selection (#11885) (@maloun96)
- [#11924](https://github.com/apache/superset/pull/11924) feat: add modal to import dashboards (#11924) (@betodealmeida)
- [#11956](https://github.com/apache/superset/pull/11956) feat: add modal to import charts (#11956) (@betodealmeida)
- [#11910](https://github.com/apache/superset/pull/11910) feat: add modal to import datasets (#11910) (@betodealmeida)
- [#11884](https://github.com/apache/superset/pull/11884) feat: add modal to import databases (#11884) (@betodealmeida)
- [#11947](https://github.com/apache/superset/pull/11947) chore: bump nvd3 plugin version (#11947) (@kristw)
- [#11931](https://github.com/apache/superset/pull/11931) fix(charts): screenshot API declaring an unnecessary rison arg (#11931) (@dpgaspar)
- [#11893](https://github.com/apache/superset/pull/11893) feat(releasing): support changelog csv export (#11893) (@dpgaspar)
- [#11854](https://github.com/apache/superset/pull/11854) feat: Results table on Explore view (#11854) (@kgabryje)
- [#11538](https://github.com/apache/superset/pull/11538) feat: add Postgres SQL validator (#11538) (@betodealmeida)
- [#11899](https://github.com/apache/superset/pull/11899) refactor: Move Badge to Antdesign (#11899) (@geido)
- [#11928](https://github.com/apache/superset/pull/11928) refactor: Extract copy functionality to utils (#11928) (@maloun96)
- [#11939](https://github.com/apache/superset/pull/11939) fix: make sure we log the logs (#11939) (@etr2460)
- [#11930](https://github.com/apache/superset/pull/11930) Quick fix for branch names in tags (#11930) (@craig-rueda)
- [#11877](https://github.com/apache/superset/pull/11877) Added check if SQL query is empty and disable shortcut for run query (#11877) (@kkucharc)
- [#11900](https://github.com/apache/superset/pull/11900) feat: filters for alerts and reports list view  (#11900) (@lilykuang)
- [#11920](https://github.com/apache/superset/pull/11920) fix: Remove expensive logs table migration (#11920) (@etr2460)
- [#11665](https://github.com/apache/superset/pull/11665) feat: add event and interval annotation support to chart data ep (#11665) (@villebro)
- [#11919](https://github.com/apache/superset/pull/11919) fix: Forgot to remove bad comments from SaveDatasetModal (#11919) (@hughhhh)
- [#11786](https://github.com/apache/superset/pull/11786) chore: add unit tests for the current import functionality (#11786) (@betodealmeida)
- [#11875](https://github.com/apache/superset/pull/11875) refactor: Move ProgressBar to Antd (#11875) (@geido)
- [#11904](https://github.com/apache/superset/pull/11904) feat: run BQ queries as single statement (#11904) (@betodealmeida)
- [#11911](https://github.com/apache/superset/pull/11911) fix: adjust width for non multi select inputs (#11911) (@eschutho)
- [#11861](https://github.com/apache/superset/pull/11861) feat: Adding SaveDatasetModal component (#11861) (@hughhhh)
- [#11868](https://github.com/apache/superset/pull/11868) chore: Support SET & SHOW commands as read only SQL commands (#11868) (@bkyryliuk)
- [#11876](https://github.com/apache/superset/pull/11876) fix: Check if annotation type is supported by the given chart type (#11876) (@agatapst)
- [#11912](https://github.com/apache/superset/pull/11912) fix: Button storybook component size knob (#11912) (@rusackas)
- [#11913](https://github.com/apache/superset/pull/11913) style: eslint curly rule (#11913) (@rusackas)
- [#11897](https://github.com/apache/superset/pull/11897) fix(query): sorting by user for Query History list view (#11897) (@nytai)
- [#11856](https://github.com/apache/superset/pull/11856) feat(css templates): security perm simplification (#11856) (@dpgaspar)
- [#11902](https://github.com/apache/superset/pull/11902) add fix for extra comments for #11781 (#11902) (@graceguo-supercat)
- [#11891](https://github.com/apache/superset/pull/11891) chore: Enable jsx-a11y/anchor-is-valid (#11891) (@nikolagigic)
- [#11887](https://github.com/apache/superset/pull/11887) chore: Update sqllab types (#11887) (@hughhhh)
- [#10770](https://github.com/apache/superset/pull/10770) Capture error when celery back-end does not support forgetting tasks (#10770) (@willbarrett)
- [#11816](https://github.com/apache/superset/pull/11816) feat: allow user to view their profile again (#11816) (@etr2460)
- [#11847](https://github.com/apache/superset/pull/11847) fix: Show copy icon (#11847) (@maloun96)
- [#11848](https://github.com/apache/superset/pull/11848) Align icon (#11848) (@maloun96)
- [#11843](https://github.com/apache/superset/pull/11843) style: remove react bootstrap fade component (#11843) (@nikolagigic)
- [#11802](https://github.com/apache/superset/pull/11802) feat: report/alert list CRUD view (#11802) (@lilykuang)
- [#11881](https://github.com/apache/superset/pull/11881) fix: certification icon order (#11881) (@etr2460)
- [#11781](https://github.com/apache/superset/pull/11781) fix (dataset editor): allow Source tab readOnly mode (#11781) (@graceguo-supercat)
- [#11845](https://github.com/apache/superset/pull/11845) fix: dashboard iframe to markdown db migration (#11845) (@dpgaspar)
- [#11771](https://github.com/apache/superset/pull/11771) test: add React Testing Library (#11771) (@ktmud)
- [#11580](https://github.com/apache/superset/pull/11580) fix: filters push out apply button on dashboard (#11580) (@kkucharc)
- [#11863](https://github.com/apache/superset/pull/11863) chore: remove SIP_34_QUERY_SEARCH_UI feature flag (#11863) (@nytai)
- [#11851](https://github.com/apache/superset/pull/11851) chore: Add home link to navbar (#11851) (@agatapst)
- [#11812](https://github.com/apache/superset/pull/11812) chore: move fixtures and helpers to root (#11812) (@eschutho)
- [#11702](https://github.com/apache/superset/pull/11702) feat: list view filters for Query History  (#11702) (@nytai)
- [#11855](https://github.com/apache/superset/pull/11855) feat:  Create api abstraction layer for dataset network calls (#11855) (@hughhhh)
- [#11858](https://github.com/apache/superset/pull/11858) fix(datasets): renaming openAPI columns (#11858) (@hughhhh)
- [#11678](https://github.com/apache/superset/pull/11678) feat(welcome): add SQL snippets to saved queries card (#11678) (@pkdotson)
- [#11766](https://github.com/apache/superset/pull/11766) Fix chart select borders in BuilderComponentPane (#11766) (@kgabryje)
- [#11852](https://github.com/apache/superset/pull/11852) fix: security converge downgrade procedure (#11852) (@dpgaspar)
- [#11830](https://github.com/apache/superset/pull/11830) fix: update chart doesn't remove all connections to dashboards (#11830) (@kkucharc)
- [#11238](https://github.com/apache/superset/pull/11238) feat: Option to run npm dev-server (hot reload) while calling docker-compose up (#11238) (@adam-stasiak)
- [#11836](https://github.com/apache/superset/pull/11836) feat: Sqllab to Explore UX improvements api changes (#11836) (@hughhhh)
- [#11778](https://github.com/apache/superset/pull/11778) fix: Download as image not working on Dashboard view (#11778) (@kgabryje)
- [#11764](https://github.com/apache/superset/pull/11764) feat(saved queries): security perm simplification (#11764) (@dpgaspar)
- [#11838](https://github.com/apache/superset/pull/11838) chore: type a couple easy to type files (#11838) (@etr2460)
- [#11779](https://github.com/apache/superset/pull/11779) chore: Move styles of Dashboard and FilterScopeSelector modals to Emotion (#11779) (@kgabryje)
- [#11834](https://github.com/apache/superset/pull/11834) Change subtabs order for Data tab (#11834) (@agatapst)
- [#11837](https://github.com/apache/superset/pull/11837) fix: improve Avatar text size consistency (#11837) (@etr2460)
- [#11824](https://github.com/apache/superset/pull/11824) fix: wrong key used  FEATURE_FLAGS[LISTVIEW_DEFAULT_CARD_VIEW]  (#11824) (@amitmiran137)
- [#11811](https://github.com/apache/superset/pull/11811) fix: Adding and removing annotations (#11811) (@agatapst)
- [#11828](https://github.com/apache/superset/pull/11828) ci(docker): build image on release (#11828) (@dpgaspar)
- [#11827](https://github.com/apache/superset/pull/11827) docs(release): small fixes and deprecate apache docs (#11827) (@dpgaspar)
- [#11825](https://github.com/apache/superset/pull/11825) fix(setup): disallow python 3.6 for pip install (#11825) (@dpgaspar)
- [#11801](https://github.com/apache/superset/pull/11801) fix: delete chart, dashboards, dbs with assoc reports (#11801) (@dpgaspar)
- [#11815](https://github.com/apache/superset/pull/11815) chore: Fix TableModelView super call (#11815) (@john-bodley)
- [#11683](https://github.com/apache/superset/pull/11683) feat: filter by me on CRUD list view (#11683) (@lilykuang)
- [#11805](https://github.com/apache/superset/pull/11805) fix: remove root dir from ZIP bundle (#11805) (@betodealmeida)
- [#11797](https://github.com/apache/superset/pull/11797) fix: add feature flag for domain sharding (#11797) (@graceguo-supercat)
- [#11714](https://github.com/apache/superset/pull/11714) chore: improve analytics (#11714) (@mistercrunch)
- [#10815](https://github.com/apache/superset/pull/10815) chore: type src/logger (#10815) (@etr2460)
- [#11809](https://github.com/apache/superset/pull/11809) docs: 0.38.0 CHANGELOG and UPDATING (#11809) (@dpgaspar)
- [#11762](https://github.com/apache/superset/pull/11762) fix: attachment filename error in sqllab with i18n (#11762) (@auxten)
- [#11795](https://github.com/apache/superset/pull/11795) fix: mutating input df in viz.py (#11795) (@villebro)
- [#11711](https://github.com/apache/superset/pull/11711) feat: new reports scheduler (#11711) (@dpgaspar)
- [#11751](https://github.com/apache/superset/pull/11751) feat: API endpoint to import dashboards (#11751) (@betodealmeida)
- [#11806](https://github.com/apache/superset/pull/11806) chore: unbreak frontend ci (#11806) (@etr2460)
- [#11737](https://github.com/apache/superset/pull/11737) refactor: Replace react-bootstrap tooltips with Antd tooltips (#11737) (@kgabryje)
- [#11798](https://github.com/apache/superset/pull/11798) fix: docker healthcheck (#11798) (@PMExtra)
- [#11785](https://github.com/apache/superset/pull/11785) feat: add certification info to table selector (#11785) (@etr2460)
- [#11783](https://github.com/apache/superset/pull/11783) update docs around email reports (#11783) (@eschutho)
- [#11794](https://github.com/apache/superset/pull/11794) build: split python CI jobs (#11794) (@etr2460)
- [#11675](https://github.com/apache/superset/pull/11675) refactor: use rison for list view filters stateful urls (#11675) (@riahk)
- [#11780](https://github.com/apache/superset/pull/11780) refactor: Replace SqlLab components' styles using Emotion & theme variables (#11780) (@agatapst)
- [#11754](https://github.com/apache/superset/pull/11754) chore: controls.test supporting v1 charts and added force=true to url when r… (#11754) (@adam-stasiak)
- [#11791](https://github.com/apache/superset/pull/11791) add tool tip to cards (#11791) (@pkdotson)
- [#11712](https://github.com/apache/superset/pull/11712) chore: enabled v1 verification in filter and url_params test files (#11712) (@adam-stasiak)
- [#11787](https://github.com/apache/superset/pull/11787) fix: annotation layer crashes when clearing type select (#11787) (@mistercrunch)
- [#11749](https://github.com/apache/superset/pull/11749) feat: add a command to import dashboards (#11749) (@betodealmeida)
- [#11775](https://github.com/apache/superset/pull/11775) docs: add Xite to users list (#11775) (@shashankkoppar)
- [#11732](https://github.com/apache/superset/pull/11732) fix: style multiselect input (#11732) (@eschutho)
- [#11747](https://github.com/apache/superset/pull/11747) Fix docker healthcheck. (#11747) (@PMExtra)
- [#11772](https://github.com/apache/superset/pull/11772) chore: fix typo (#11772) (@etr2460)
- [#11634](https://github.com/apache/superset/pull/11634) feat: SQL preview modal for Query History (#11634) (@nytai)
- [#11744](https://github.com/apache/superset/pull/11744) feat: API endpoint to import charts (#11744) (@betodealmeida)
- [#11743](https://github.com/apache/superset/pull/11743) feat: add a command to import charts (#11743) (@betodealmeida)
- [#11769](https://github.com/apache/superset/pull/11769) fix: Fixing issue around requirements-local.txt (#11769) (@craig-rueda)
- [#11760](https://github.com/apache/superset/pull/11760) feat: Add user info to sqllab via bootstrap data (#11760) (@hughhhh)
- [#11752](https://github.com/apache/superset/pull/11752) fix: Null error when deleting the last owner label in DatasourceEditor/settings (#11752) (@kgabryje)
- [#11709](https://github.com/apache/superset/pull/11709) Make spacings in Settings menu more consistent (#11709) (@kgabryje)
- [#11611](https://github.com/apache/superset/pull/11611) style: dark filter popover background (#11611) (@rusackas)
- [#11736](https://github.com/apache/superset/pull/11736) chore: Text change Allow Data Upload (#11736) (@amitmiran137)
- [#11740](https://github.com/apache/superset/pull/11740) fix: Adding __init__.py in superset.commands.importers (#11740) (@craig-rueda)
- [#11731](https://github.com/apache/superset/pull/11731) fix: do not drop calculated column on metadata sync (#11731) (@villebro)
- [#11703](https://github.com/apache/superset/pull/11703) docs: fix docker config paths (#11703) (@suddjian)
- [#11726](https://github.com/apache/superset/pull/11726) Fix missing styles in FilterScopeSelector modal (#11726) (@kgabryje)
- [#11728](https://github.com/apache/superset/pull/11728) feat: API endpoints to upload dataset/db (#11728) (@betodealmeida)
- [#11727](https://github.com/apache/superset/pull/11727) chore: remove SIP_34_ANNOTATIONS_UI feature flag (#11727) (@lilykuang)
- [#11704](https://github.com/apache/superset/pull/11704) feat(templating): Safer Jinja template processing (#11704) (@robdiciuccio)
- [#11692](https://github.com/apache/superset/pull/11692) Fix "Select all" option in SelectControl (#11692) (@kgabryje)
- [#11719](https://github.com/apache/superset/pull/11719) Fix ModalTriggers styling in SqlLab (#11719) (@kgabryje)
- [#11670](https://github.com/apache/superset/pull/11670) feat: new import commands for dataset and databases (#11670) (@betodealmeida)
- [#11693](https://github.com/apache/superset/pull/11693) Remove "required" from SaveModal Add to dashboard field (#11693) (@kgabryje)
- [#11684](https://github.com/apache/superset/pull/11684) fix: default dashboard/chart cards are vector with perfect corners (#11684) (@rusackas)
- [#11707](https://github.com/apache/superset/pull/11707) Switching Docker compose over to the official image (#11707) (@craig-rueda)
- [#11701](https://github.com/apache/superset/pull/11701) chore: statds metrics for cache invalidation (#11701) (@bkyryliuk)
- [#11685](https://github.com/apache/superset/pull/11685) chore: V1 charts load cypress tests (#11685) (@adam-stasiak)
- [#11698](https://github.com/apache/superset/pull/11698) build(cypress): Fix issue with cypress code-coverage plugin when running locally (#11698) (@robdiciuccio)
- [#11676](https://github.com/apache/superset/pull/11676) chore: remove a few obsolete logic (#11676) (@graceguo-supercat)
- [#11691](https://github.com/apache/superset/pull/11691) Fix overflow hidden issues in Dashboard Builder tabs (#11691) (@kgabryje)
- [#11509](https://github.com/apache/superset/pull/11509) feat: rename TABLE_NAMES_CACHE_CONFIG to DATA_CACHE_CONFIG (#11509) (@ktmud)
- [#11700](https://github.com/apache/superset/pull/11700) feat: Helm improvements (#11700) (@craig-rueda)
- [#11679](https://github.com/apache/superset/pull/11679) fix(saved query): handle null sql field (#11679) (@nytai)
- [#11616](https://github.com/apache/superset/pull/11616) feat: Adding docker build/push (#11616) (@craig-rueda)
- [#11618](https://github.com/apache/superset/pull/11618) feat: keep modal open when saving database failed (#11618) (@ktmud)
- [#11671](https://github.com/apache/superset/pull/11671) fix: Dropdown menu not closing on Dashboard view (#11671) (@kgabryje)
- [#11613](https://github.com/apache/superset/pull/11613) docs: add support for Google Analytics on superset.apache.org (#11613) (@mistercrunch)
- [#11574](https://github.com/apache/superset/pull/11574) feat: Query History CRUD list view (#11574) (@nytai)
- [#11606](https://github.com/apache/superset/pull/11606) feat: new reports models api (#11606) (@dpgaspar)
- [#11672](https://github.com/apache/superset/pull/11672) fix(dashboard): ordering for add chart widget (#11672) (@nytai)
- [#11661](https://github.com/apache/superset/pull/11661) fix (dashboard): remove default filters parameters in dashboard url (#11661) (@graceguo-supercat)
- [#11673](https://github.com/apache/superset/pull/11673) fix: make higher chart box resizable (#11673) (@kkucharc)
- [#11289](https://github.com/apache/superset/pull/11289) keep placeholder on multiselect (#11289) (@eschutho)
- [#11663](https://github.com/apache/superset/pull/11663) chore: clean up a debug line from #11653 (#11663) (@ktmud)
- [#11199](https://github.com/apache/superset/pull/11199) feat: add ECharts BoxPlot chart (#11199) (@villebro)
- [#11653](https://github.com/apache/superset/pull/11653) fix: database connection validation when creation (#11653) (@ktmud)
- [#11533](https://github.com/apache/superset/pull/11533) chore: consolidate datasource import logic (#11533) (@betodealmeida)
- [#11643](https://github.com/apache/superset/pull/11643) Restructure chart header to wrap nicely (#11643) (@kgabryje)
- [#11529](https://github.com/apache/superset/pull/11529) chore: consolidate dashboard import logic (#11529) (@betodealmeida)
- [#11652](https://github.com/apache/superset/pull/11652) add import icon (#11652) (@eschutho)
- [#11644](https://github.com/apache/superset/pull/11644) build: set actions/setup-python to v2 (#11644) (@ktmud)
- [#11648](https://github.com/apache/superset/pull/11648) feat(dev): dont override asset manifest in dev-server (#11648) (@ktmud)
- [#11655](https://github.com/apache/superset/pull/11655) [fix] handle null value in date filter (#11655) (@graceguo-supercat)
- [#11656](https://github.com/apache/superset/pull/11656) fix(chart-data): ignore orderby on sample result type (#11656) (@villebro)
- [#11649](https://github.com/apache/superset/pull/11649) fix(saved-query): handle case where sql_tables in undefined (#11649) (@nytai)
- [#11650](https://github.com/apache/superset/pull/11650) style: various little tweaks to home screen stylin' (#11650) (@rusackas)
- [#11646](https://github.com/apache/superset/pull/11646) chore: pin node and npm versions (#11646) (@ktmud)
- [#11626](https://github.com/apache/superset/pull/11626) feat(sankey-viz): allow sort by metric and bump superset-ui packages (#11626) (@ktmud)
- [#11603](https://github.com/apache/superset/pull/11603) build(deps-dev): update cypress to 5.5.0, improvements for running locally (#11603) (@robdiciuccio)
- [#11458](https://github.com/apache/superset/pull/11458) chore: enabled cypress test in filter file (#11458) (@adam-stasiak)
- [#11535](https://github.com/apache/superset/pull/11535) refactor: Remove reactable arc (#11535) (@kgabryje)
- [#11584](https://github.com/apache/superset/pull/11584) Enabled artifacts for failing tests (#11584) (@adam-stasiak)
- [#11636](https://github.com/apache/superset/pull/11636) chore: rename IMPORT_EXPORT_VERSION (#11636) (@betodealmeida)
- [#11638](https://github.com/apache/superset/pull/11638) fix: card thumbnails now always show border. (#11638) (@rusackas)
- [#11521](https://github.com/apache/superset/pull/11521) Chore: simplify Apache Kylin datetime convert (#11521) (@zhaoyongjie)
- [#11635](https://github.com/apache/superset/pull/11635) fix: CommandInvalidError had invalid init (#11635) (@betodealmeida)
- [#11630](https://github.com/apache/superset/pull/11630) Disabled bubble test (#11630) (@adam-stasiak)
- [#11632](https://github.com/apache/superset/pull/11632) fix: js unit test when save dash (#11632) (@graceguo-supercat)
- [#11631](https://github.com/apache/superset/pull/11631) style: fixing tall filter indicators (#11631) (@rusackas)
- [#11592](https://github.com/apache/superset/pull/11592) feat(dashboard): leaner filter indicator panel with wrapped text (#11592) (@suddjian)
- [#11621](https://github.com/apache/superset/pull/11621) Fix datetime picker issues (#11621) (@kgabryje)
- [#11614](https://github.com/apache/superset/pull/11614) fix(dashboard): use server-side lastModifiedTime for co-edit check (#11614) (@graceguo-supercat)
- [#11540](https://github.com/apache/superset/pull/11540) feat: annotation delete modal, bulk delete and empty state (#11540) (@lilykuang)
- [#11570](https://github.com/apache/superset/pull/11570) fix: minor style touch on dashboards (#11570) (@ktmud)
- [#11569](https://github.com/apache/superset/pull/11569) chore: clean up mountedTab (#11569) (@ktmud)
- [#11583](https://github.com/apache/superset/pull/11583) Fixed unstable test (#11583) (@adam-stasiak)
- [#11525](https://github.com/apache/superset/pull/11525) fix: extended droppable area on the top of dashboards (#11525) (@kkucharc)
- [#11597](https://github.com/apache/superset/pull/11597) build(deps-dev): bump less from 3.9.0 to 3.12.2 in /superset-frontend (#11597) (@dependabot[bot])
- [#11564](https://github.com/apache/superset/pull/11564) chore: cleaning out old deckgl controls (#11564) (@rusackas)
- [#11557](https://github.com/apache/superset/pull/11557) chore(home-screen): fixes for loading states, flicker issue, and reduction of api calls (#11557) (@pkdotson)
- [#11607](https://github.com/apache/superset/pull/11607) fix: Filter and Metric popovers not closing after clicking Save (#11607) (@kgabryje)
- [#11602](https://github.com/apache/superset/pull/11602) style: Wrap chart titles again (#11602) (@rusackas)
- [#11594](https://github.com/apache/superset/pull/11594) fix(dashboard): order charts by changed_on (#11594) (@nytai)
- [#11550](https://github.com/apache/superset/pull/11550) feat: new report schedule models (#11550) (@dpgaspar)
- [#11578](https://github.com/apache/superset/pull/11578) fix: Issues with filters and metrics popovers (#11578) (@kgabryje)
- [#11554](https://github.com/apache/superset/pull/11554) refactor: Replace react-bootstrap MenuItems with Antd Menu (#11554) (@kgabryje)
- [#11579](https://github.com/apache/superset/pull/11579) Changed top overflow for charts. (#11579) (@kkucharc)
- [#11518](https://github.com/apache/superset/pull/11518) build(deps): bump @emotion/core in /superset-frontend (#11518) (@dependabot[bot])
- [#11573](https://github.com/apache/superset/pull/11573) build(deps-dev): bump @storybook/addon-essentials in /superset-frontend (#11573) (@dependabot[bot])
- [#11575](https://github.com/apache/superset/pull/11575) chore(rls): move to feature flag and disable related view (#11575) (@villebro)
- [#11522](https://github.com/apache/superset/pull/11522) build(deps): bump core-js from 3.2.1 to 3.6.5 in /superset-frontend (#11522) (@dependabot[bot])
- [#11314](https://github.com/apache/superset/pull/11314) chore: Cypress dashboard list selectors refactor (#11314) (@adam-stasiak)
- [#11555](https://github.com/apache/superset/pull/11555) refactor: Replace react-bootstrap MenuItems with Antd Menu (#11555) (@kgabryje)
- [#11558](https://github.com/apache/superset/pull/11558) fix(dashboard): properly unset mountedTab in  reducer (#11558) (@suddjian)
- [#11559](https://github.com/apache/superset/pull/11559) Front end for VERSIONED_EXPORT (#11559) (@betodealmeida)
- [#11445](https://github.com/apache/superset/pull/11445) fix: Pasting text issues in MetricsControl and AdhocFilterControl inputs (#11445) (@kgabryje)
- [#11487](https://github.com/apache/superset/pull/11487) refactor: Replace react-bootstrap MenuItems with Antd Menu (#11487) (@kgabryje)
- [#11311](https://github.com/apache/superset/pull/11311) style: database modal updates (#11311) (@riahk)
- [#11370](https://github.com/apache/superset/pull/11370) fix: add sort option to filters, sort chart list filter options (#11370) (@riahk)
- [#11551](https://github.com/apache/superset/pull/11551) docs: add Avesta to users list (#11551) (@TheRum)
- [#11527](https://github.com/apache/superset/pull/11527) refactor: Replace react-bootstrap dialogs with Antd dialogs (#11527) (@kgabryje)
- [#11531](https://github.com/apache/superset/pull/11531) chore: remove directory importexport (#11531) (@betodealmeida)
- [#11528](https://github.com/apache/superset/pull/11528) refactor: Use Antd Menu in Menu component (#11528) (@kgabryje)
- [#11530](https://github.com/apache/superset/pull/11530) feat: annotation layers delete logic + linking w/ annotation view (#11530) (@riahk)
- [#11500](https://github.com/apache/superset/pull/11500) feat: annotation edit modal with antd datepicker (#11500) (@lilykuang)
- [#11526](https://github.com/apache/superset/pull/11526) fix(tests): flaky test with dttm on Query API (#11526) (@dpgaspar)
- [#11361](https://github.com/apache/superset/pull/11361) docs: add Xendit to users list (#11361) (@LieAlbertTriAdrian)
- [#11502](https://github.com/apache/superset/pull/11502) refactor: reduce number of api calls needed to fetch favorite status for charts and dashboards (#11502) (@nytai)
- [#11532](https://github.com/apache/superset/pull/11532) chore: remove sanitize (#11532) (@betodealmeida)
- [#11435](https://github.com/apache/superset/pull/11435) refactor: rewrite and enhance chart control withVerification (#11435) (@ktmud)
- [#11501](https://github.com/apache/superset/pull/11501) fix(dashboard): multiple lines and indentation when editing json (#11501) (@suddjian)
- [#11160](https://github.com/apache/superset/pull/11160) refactor: Replace react-bootstrap Tabs with Antd Tabs in DashboardBuilder (#11160) (@kgabryje)
- [#11476](https://github.com/apache/superset/pull/11476) fix: Update "View In SQL Lab" Flow to render source query from datasource object (#11476) (@hughhhh)
- [#11491](https://github.com/apache/superset/pull/11491) feat: globally disable underscore for links in menu items (#11491) (@ktmud)
- [#11389](https://github.com/apache/superset/pull/11389) refactor: Replace react-bootstrap Modals with Antd in Explore (#11389) (@kgabryje)
- [#11519](https://github.com/apache/superset/pull/11519) feat: make logo link point to welcome page (#11519) (@mistercrunch)
- [#11512](https://github.com/apache/superset/pull/11512) chore: run 'npm audit fix', bump react-syntax-highlighter (#11512) (@mistercrunch)
- [#11510](https://github.com/apache/superset/pull/11510) chore: add dependabot.yml config file (#11510) (@mistercrunch)
- [#11511](https://github.com/apache/superset/pull/11511) chore: bump pypi cryptography from 2.4.2 to 3.2.1 (#11511) (@mistercrunch)
- [#11482](https://github.com/apache/superset/pull/11482) feat: query REST API more fields and tests (#11482) (@dpgaspar)
- [#11118](https://github.com/apache/superset/pull/11118) refactor: Replace react-bootstrap tabs with Antd tabs (#11118) (@kgabryje)
- [#11494](https://github.com/apache/superset/pull/11494) feat: annotation layers modal + filters (#11494) (@riahk)
- [#11485](https://github.com/apache/superset/pull/11485) build(deps-dev): bump node-fetch in /superset-frontend (#11485) (@dependabot[bot])
- [#11484](https://github.com/apache/superset/pull/11484) build(deps): bump object-path from 0.11.4 to 0.11.5 in /docs (#11484) (@dependabot[bot])
- [#11483](https://github.com/apache/superset/pull/11483) build(deps): bump lodash in /superset-frontend/cypress-base (#11483) (@dependabot[bot])
- [#11506](https://github.com/apache/superset/pull/11506) fix: import for moment in ActivityTable (#11506) (@pkdotson)
- [#11481](https://github.com/apache/superset/pull/11481) fix: show recent visited dashboards and charts in recent_activity (#11481) (@ktmud)
- [#11463](https://github.com/apache/superset/pull/11463) feat: create base class for export commands (#11463) (@betodealmeida)
- [#11450](https://github.com/apache/superset/pull/11450) feat: add certifications to tables (#11450) (@etr2460)
- [#11460](https://github.com/apache/superset/pull/11460) chore: rename ImportMixin to ImportExportMixin (#11460) (@betodealmeida)
- [#11447](https://github.com/apache/superset/pull/11447) feat: add endpoint to export saved queries using new format (#11447) (@betodealmeida)
- [#11504](https://github.com/apache/superset/pull/11504) docs: fix db drivers PG and ES (#11504) (@dpgaspar)
- [#11503](https://github.com/apache/superset/pull/11503) fix(api): don't log db conn failures on db create/update (#11503) (@dpgaspar)
- [#11206](https://github.com/apache/superset/pull/11206) feat: home screen mvp  (#11206) (@pkdotson)
- [#11496](https://github.com/apache/superset/pull/11496) chore: Cleaning up ENABLE_REACT_CRUD_VIEWS config (#11496) (@john-bodley)
- [#11493](https://github.com/apache/superset/pull/11493) feat: disable save button when saving datasource (#11493) (@ktmud)
- [#11307](https://github.com/apache/superset/pull/11307) other: Improvements to bug report template (#11307) (@suddjian)
- [#11497](https://github.com/apache/superset/pull/11497) Revert "fix: change chart title by clicking (#11335)" (#11497) (@graceguo-supercat)
- [#11449](https://github.com/apache/superset/pull/11449) fix: prevent race condition when canceling query (#11449) (@betodealmeida)
- [#11452](https://github.com/apache/superset/pull/11452) fix(datasets): add custom filter for virtual datasets based on sql attribute (#11452) (@nytai)
- [#11456](https://github.com/apache/superset/pull/11456) Added z index to resizible char (#11456) (@kkucharc)
- [#11281](https://github.com/apache/superset/pull/11281) feat(explore): change save button text when users cannot override (#11281) (@ktmud)
- [#11480](https://github.com/apache/superset/pull/11480) fix: dashboard tab only shows move cursor when editing (#11480) (@rusackas)
- [#11473](https://github.com/apache/superset/pull/11473) Add IBM Cloud deployment guide (#11473) (@aklin)
- [#11474](https://github.com/apache/superset/pull/11474) fix: Unwinds icon fallout that came along with filters PR (#11474) (@rusackas)
- [#10936](https://github.com/apache/superset/pull/10936) feat(dashboards): Filter status indicators (#10936) (@suddjian)
- [#11432](https://github.com/apache/superset/pull/11432) feat: annotation layers CRUD list view (#11432) (@riahk)
- [#11390](https://github.com/apache/superset/pull/11390) refactor: Replace react-bootstrap Modals with Antd in Datasource (#11390) (@kgabryje)
- [#11446](https://github.com/apache/superset/pull/11446) feat: annotations list CRUD view (#11446) (@lilykuang)
- [#11459](https://github.com/apache/superset/pull/11459) Disabled chaning caret (#11459) (@kkucharc)
- [#11457](https://github.com/apache/superset/pull/11457) docs: improve docs and update apache release scripts (#11457) (@dpgaspar)
- [#11455](https://github.com/apache/superset/pull/11455) enabled skipped tests in AdhocMetrics Cypress (#11455) (@adam-stasiak)
- [#11428](https://github.com/apache/superset/pull/11428) fix: Explore popovers issues (#11428) (@kgabryje)
- [#11437](https://github.com/apache/superset/pull/11437) fix: add init.py to the annotations module (#11437) (@bkyryliuk)
- [#11401](https://github.com/apache/superset/pull/11401) fix: a space adds the space. (#11401) (@rusackas)
- [#11453](https://github.com/apache/superset/pull/11453) fix: Fixing broken Cypress test (#11453) (@rusackas)
- [#11366](https://github.com/apache/superset/pull/11366) refactor: Use Antd Modals instead of react-bootstrap Modals (#11366) (@kgabryje)
- [#11309](https://github.com/apache/superset/pull/11309) chore: cypress selectors refactor in explore module (#11309) (@adam-stasiak)
- [#11312](https://github.com/apache/superset/pull/11312) chore: Cypress chart selectors refactor (#11312) (@adam-stasiak)
- [#11414](https://github.com/apache/superset/pull/11414) fix: [email report] add multiple schedules per hour (#11414) (@graceguo-supercat)
- [#11397](https://github.com/apache/superset/pull/11397) feat: add UUID column to saved_query for export/import (#11397) (@betodealmeida)
- [#11439](https://github.com/apache/superset/pull/11439) fix filter highlighting (#11439) (@suddjian)
- [#11444](https://github.com/apache/superset/pull/11444) fix: bump FAB to 3.1.1 (#11444) (@dpgaspar)
- [#11407](https://github.com/apache/superset/pull/11407) fix: added meaningful exception for loading births error (#11407) (@kkucharc)
- [#11315](https://github.com/apache/superset/pull/11315) chore: Update testconn logic (#11315) (@john-bodley)
- [#10645](https://github.com/apache/superset/pull/10645) feat: enable metadata sync for virtual tables (#10645) (@villebro)
- [#11429](https://github.com/apache/superset/pull/11429) fix: is_temporal should be overridden by is_dttm value (#11429) (@villebro)
- [#11427](https://github.com/apache/superset/pull/11427) Moved css of inline inputs of DateFilterControl to css of FilterBox where it appears. (#11427) (@kkucharc)
- [#11412](https://github.com/apache/superset/pull/11412) fix: multiple issues with FilterPopover (#11412) (@mistercrunch)
- [#11327](https://github.com/apache/superset/pull/11327) Configured babel plugin for removing data-test from production code (#11327) (@adam-stasiak)
- [#11424](https://github.com/apache/superset/pull/11424) feat(explore): update the order of datasource dropdown menu (#11424) (@hughhhh)
- [#11371](https://github.com/apache/superset/pull/11371) feat: hide datasource legacy based on featureflag (#11371) (@hughhhh)
- [#11382](https://github.com/apache/superset/pull/11382) fix: better error messages for dashboard properties modal (#11382) (@nytai)
- [#11430](https://github.com/apache/superset/pull/11430) fix: saved query list sort by database (#11430) (@nytai)
- [#11433](https://github.com/apache/superset/pull/11433) build: disable pr reviews for pr-lint action (#11433) (@nytai)
- [#11381](https://github.com/apache/superset/pull/11381) fix: better error message for chart properties modal (#11381) (@nytai)
- [#10724](https://github.com/apache/superset/pull/10724) Let the header wrap! (#10724) (@rusackas)
- [#11330](https://github.com/apache/superset/pull/11330) refactor: Use Modals from Antd instead of react-bootstrap (#11330) (@kgabryje)
- [#11391](https://github.com/apache/superset/pull/11391) feat: saved queries with execution info (#11391) (@dpgaspar)
- [#11392](https://github.com/apache/superset/pull/11392) fix: keeping Markdown content while resizing window on Dashboard (#11392) (@kkucharc)
- [#11423](https://github.com/apache/superset/pull/11423) Moved frame from below to currently focused window (#11423) (@kkucharc)
- [#11239](https://github.com/apache/superset/pull/11239) refactor: Replace usages of reactable in TimeTable (#11239) (@kgabryje)
- [#11417](https://github.com/apache/superset/pull/11417) fix(examples): specify 'time_range_endpoints' to prevent toast warning (#11417) (@mistercrunch)
- [#11422](https://github.com/apache/superset/pull/11422) docs: Update Dremio doc with Arrow Flight connection details (#11422) (@narendrans)
- [#11421](https://github.com/apache/superset/pull/11421) chore: upgrade TypeScript (3.8.3 -> 4.0.3) (#11421) (@ktmud)
- [#11415](https://github.com/apache/superset/pull/11415) style: fix labels vertical align (#11415) (@mistercrunch)
- [#11420](https://github.com/apache/superset/pull/11420) fix: error handling for webpack proxy (#11420) (@ktmud)
- [#11416](https://github.com/apache/superset/pull/11416) refactor: typing for explore Control and messageToasts (#11416) (@ktmud)
- [#11336](https://github.com/apache/superset/pull/11336) feat(dashboard): fetch charts by owners instead of created_by (#11336) (@nytai)
- [#11375](https://github.com/apache/superset/pull/11375) chore: Fixed skipped cypress test - refresh dashboard function (#11375) (@adam-stasiak)
- [#11342](https://github.com/apache/superset/pull/11342) chore: Button cruft cleanup (#11342) (@rusackas)
- [#11395](https://github.com/apache/superset/pull/11395) refactor: Use Antd Dropdown instead of react-bootstrap in DatasourceControl (#11395) (@kgabryje)
- [#11344](https://github.com/apache/superset/pull/11344) feat: annotations REST API (#11344) (@dpgaspar)
- [#11396](https://github.com/apache/superset/pull/11396) fix dataset editor for saving schema (#11396) (@lilykuang)
- [#11351](https://github.com/apache/superset/pull/11351) feat: export dashboards as ZIP files (#11351) (@betodealmeida)
- [#11400](https://github.com/apache/superset/pull/11400) fix: long labels now truncate with ellipsis (#11400) (@rusackas)
- [#11398](https://github.com/apache/superset/pull/11398) docs: Add semantic prefix info for PR titles (#11398) (@robdiciuccio)
- [#11335](https://github.com/apache/superset/pull/11335) fix: change chart title by clicking (#11335) (@lilykuang)
- [#11403](https://github.com/apache/superset/pull/11403) build: bump pr-lint-action (#11403) (@nytai)
- [#11129](https://github.com/apache/superset/pull/11129) docs: fix typo (#11129) (@curlup)
- [#10834](https://github.com/apache/superset/pull/10834) fix: dashboard edit/save errors (#10834) (@eschutho)
- [#11211](https://github.com/apache/superset/pull/11211) refactor: Replace react-bootstrap tabs with Antd tabs on Profile (#11211) (@kgabryje)
- [#11240](https://github.com/apache/superset/pull/11240) refactor: Replace usages of reactable in TableLoader (#11240) (@kgabryje)
- [#11376](https://github.com/apache/superset/pull/11376) build: let webpack proxy server handle more content encoding (#11376) (@ktmud)
- [#11369](https://github.com/apache/superset/pull/11369) fix: dashboard cache invalid join query (#11369) (@ktmud)
- [#11349](https://github.com/apache/superset/pull/11349) feat: export charts as ZIP files (#11349) (@betodealmeida)
- [#11332](https://github.com/apache/superset/pull/11332) feat: export datasets as ZIP files (#11332) (@betodealmeida)
- [#11383](https://github.com/apache/superset/pull/11383) style: improve the "Create New Chart" screen's usability (#11383) (@mistercrunch)
- [#11386](https://github.com/apache/superset/pull/11386) docs: add VLMedia to users list (#11386) (@iercan)
- [#11362](https://github.com/apache/superset/pull/11362) feat: add statsd metrics to FAB rest API post, put and delete (#11362) (@dpgaspar)
- [#11346](https://github.com/apache/superset/pull/11346) perf(api): improve API info performance (#11346) (@dpgaspar)
- [#11372](https://github.com/apache/superset/pull/11372) removing outlines on a few key elements (#11372) (@rusackas)
- [#11026](https://github.com/apache/superset/pull/11026) docs: Fix typo in installing from scratch (#11026) (@philipqnguyen)
- [#11334](https://github.com/apache/superset/pull/11334) chore(prophet): ignore logged warning for missing plotly package (#11334) (@villebro)
- [#11271](https://github.com/apache/superset/pull/11271) feat: CSS Templates List Actions (#11271) (@riahk)
- [#11367](https://github.com/apache/superset/pull/11367) Fix overflowing tabs (#11367) (@kgabryje)
- [#11374](https://github.com/apache/superset/pull/11374) Log warning for failure to get table/view names from DB (#11374) (@robdiciuccio)
- [#11354](https://github.com/apache/superset/pull/11354) style(sqllab): wrap text in monospace db-provided error messages (#11354) (@mistercrunch)
- [#11338](https://github.com/apache/superset/pull/11338) fix: 'Save Chart' modal's dashboard dropdown isn't sticky (#11338) (@mistercrunch)
- [#11355](https://github.com/apache/superset/pull/11355) style: make <Label/> not uppercase (#11355) (@mistercrunch)
- [#11340](https://github.com/apache/superset/pull/11340) feat: adding feature flags to escape/hide html in markdown (#11340) (@rusackas)
- [#11286](https://github.com/apache/superset/pull/11286) fix: saved_query search on schema and database not working (#11286) (@dpgaspar)
- [#11348](https://github.com/apache/superset/pull/11348) fix: Allow "EXPLAIN" queries when "Allow DML" setting is False (#11348) (@hughhhh)
- [#11337](https://github.com/apache/superset/pull/11337) fix(listview): hide actions column if no actions are allowed (#11337) (@nytai)
- [#11353](https://github.com/apache/superset/pull/11353) style: using correct + icon on New Query button (#11353) (@rusackas)
- [#11169](https://github.com/apache/superset/pull/11169) docs: add a roadmap page pointing to SIP-53 (#11169) (@mistercrunch)
- [#11274](https://github.com/apache/superset/pull/11274) fix: error around latest partition in BigQuery (#11274) (@mistercrunch)
- [#11227](https://github.com/apache/superset/pull/11227) style(menu): clean up right menu - leaving only "Settings" (#11227) (@mistercrunch)
- [#11343](https://github.com/apache/superset/pull/11343) Fix tabs switching in SouthPane (#11343) (@kgabryje)
- [#11296](https://github.com/apache/superset/pull/11296) feat: css template add/edit modal (#11296) (@lilykuang)
- [#11218](https://github.com/apache/superset/pull/11218) fix: update table_name and schema on dataset editor (#11218) (@lilykuang)
- [#11313](https://github.com/apache/superset/pull/11313) tests: Parameterize some tests in alerts_tests.py (#11313) (@hnle)
- [#11280](https://github.com/apache/superset/pull/11280) chore: Dashboard cypress refactor (#11280) (@adam-stasiak)
- [#11241](https://github.com/apache/superset/pull/11241) refactor: Replace usages of reactable in ChangeDatasourceModal (#11241) (@kgabryje)
- [#11163](https://github.com/apache/superset/pull/11163) refactor: Replace usages of Popover from react-bootstrap with Antd (#11163) (@kgabryje)
- [#11279](https://github.com/apache/superset/pull/11279) refactor: replace AvatarIcon instances with FacePile  (#11279) (@nytai)
- [#11290](https://github.com/apache/superset/pull/11290) tests: added fixtures to created dashboards and updated test with proper value (#11290) (@kkucharc)
- [#11333](https://github.com/apache/superset/pull/11333) Fix: bring back type ignore for config import (#11333) (@kkucharc)
- [#11326](https://github.com/apache/superset/pull/11326) fix(chart-api): cached-indicator always shows value is cached (#11326) (@villebro)
- [#11216](https://github.com/apache/superset/pull/11216) refactor: Refactor QueryTable to use react-table (#11216) (@kgabryje)
- [#11259](https://github.com/apache/superset/pull/11259) chore: make config ENABLE_REACT_CRUD_VIEWS = True by default (#11259) (@mistercrunch)
- [#11303](https://github.com/apache/superset/pull/11303) Fix overflowing tab's styling in TabbedSqlEditors (#11303) (@kgabryje)
- [#11229](https://github.com/apache/superset/pull/11229) feat: export databases as a ZIP bundle (#11229) (@betodealmeida)
- [#11305](https://github.com/apache/superset/pull/11305) fix: should update last_modified_time in client-side after save dash (#11305) (@graceguo-supercat)
- [#11300](https://github.com/apache/superset/pull/11300) fix CTAS and CVAS buttons invisible (#11300) (@zhaoyongjie)
- [#11294](https://github.com/apache/superset/pull/11294) feat: update time_compare description and choices (#11294) (@etr2460)
- [#11187](https://github.com/apache/superset/pull/11187) fix: button translations missing (#11187) (@rubenSastre)
- [#11293](https://github.com/apache/superset/pull/11293) fix: use dashboard id for stable cache key (#11293) (@ktmud)
- [#11278](https://github.com/apache/superset/pull/11278) fix: add schema name to datasource field in chart list (#11278) (@nytai)
- [#11287](https://github.com/apache/superset/pull/11287) fix: Fix styling in SqlLab when tabs overflow (#11287) (@kgabryje)
- [#11254](https://github.com/apache/superset/pull/11254) chore: Added data-test attributes for testing (#11254) (@adam-stasiak)
- [#11273](https://github.com/apache/superset/pull/11273) fix: delete the correct dashboard cache key (#11273) (@ktmud)
- [#11260](https://github.com/apache/superset/pull/11260) fix(query search): use new api to fetch users (#11260) (@nytai)
- [#11270](https://github.com/apache/superset/pull/11270) Revert "fix: keep placeholder in multivalue select when a value exists (#11181)" (#11270) (@etr2460)
- [#11249](https://github.com/apache/superset/pull/11249) Refactored api_tests in charts. Split filter test into several unit tests cases. Added table id based on database id (#11249) (@kkucharc)
- [#11217](https://github.com/apache/superset/pull/11217) refactor: Implement TableView component (#11217) (@kgabryje)
- [#11222](https://github.com/apache/superset/pull/11222) refactor: use contextmanager for event_logger decorators (#11222) (@ktmud)
- [#11256](https://github.com/apache/superset/pull/11256) docs: add note about migration in #11098 to Changelog (#11256) (@betodealmeida)
- [#11233](https://github.com/apache/superset/pull/11233) chore(engine): adapt postgres backend connection URI (#11233) (@zhaoyongjie)
- [#11261](https://github.com/apache/superset/pull/11261) docs: Add utair to list of companies using Apache Superset (#11261) (@dmitrijkir)
- [#11193](https://github.com/apache/superset/pull/11193) fix: do not import superset_config on tests (#11193) (@betodealmeida)
- [#11258](https://github.com/apache/superset/pull/11258) update dashboard edit modal (#11258) (@lilykuang)
- [#11234](https://github.com/apache/superset/pull/11234) perf: cache dashboard bootstrap data (#11234) (@ktmud)
- [#11252](https://github.com/apache/superset/pull/11252) fix: improve time compare range error (#11252) (@etr2460)
- [#11242](https://github.com/apache/superset/pull/11242) docs: don't link to database engine pages (#11242) (@mistercrunch)
- [#11181](https://github.com/apache/superset/pull/11181) fix: keep placeholder in multivalue select when a value exists (#11181) (@eschutho)
- [#11209](https://github.com/apache/superset/pull/11209) perf:  speed up uuid column generation (#11209) (@ktmud)
- [#11228](https://github.com/apache/superset/pull/11228) test: add admin to the owners of birth_names slices (#11228) (@ktmud)
- [#11246](https://github.com/apache/superset/pull/11246) fix: Ensure consistent naming for testconn (#11246) (@john-bodley)
- [#11210](https://github.com/apache/superset/pull/11210) fix: show TIME COLUMN options in dashboard (#11210) (@graceguo-supercat)
- [#11220](https://github.com/apache/superset/pull/11220) feat: prevent co-edit dashboard collision (#11220) (@graceguo-supercat)
- [#11244](https://github.com/apache/superset/pull/11244) chore: deprecate REDUCE_DASHBOARD_BOOTSTRAP_PAYLOAD (#11244) (@etr2460)
- [#11153](https://github.com/apache/superset/pull/11153) fix: questioning a few lines that force an ORDER clause (#11153) (@mistercrunch)
- [#11231](https://github.com/apache/superset/pull/11231) docs: Added Dremio to superset home page (#11231) (@narendrans)
- [#11223](https://github.com/apache/superset/pull/11223) chore: Leverage SQLALchemy ping rather than explicit SELECT 1 for testconn (#11223) (@john-bodley)
- [#11230](https://github.com/apache/superset/pull/11230) fix(cypress): table viz failed to run in postgres12 (#11230) (@zhaoyongjie)
- [#11225](https://github.com/apache/superset/pull/11225) fix: adding nofollow (#11225) (@rusackas)
- [#11212](https://github.com/apache/superset/pull/11212) refactor: Replace react-bootstrap tabs with Antd tabs in SqlLab (#11212) (@kgabryje)
- [#11179](https://github.com/apache/superset/pull/11179) chore: simplify alerting data model to leverage a single class  (#11179) (@bkyryliuk)
- [#11189](https://github.com/apache/superset/pull/11189) feat: CSS Templates List (#11189) (@riahk)
- [#11101](https://github.com/apache/superset/pull/11101) style(listview): various changes to get closer to SIP-34 designs (#11101) (@nytai)
- [#11214](https://github.com/apache/superset/pull/11214) Changed cache uid to be depending on table in test_csv_response_format (#11214) (@kkucharc)
- [#11213](https://github.com/apache/superset/pull/11213) test: test_cache_logging is not depending on other dashboard (#11213) (@kkucharc)
- [#11208](https://github.com/apache/superset/pull/11208) chore: Add __pycache__ to  gitignore (#11208) (@ktmud)
- [#11204](https://github.com/apache/superset/pull/11204) Fix typo "insode" -> "inside" (#11204) (@jharding-blw)
- [#11203](https://github.com/apache/superset/pull/11203) fix: revert eTag cache feature for dashboard (#11203) (@graceguo-supercat)
- [#11196](https://github.com/apache/superset/pull/11196) fix: skip unit test that is failing in master for test-postgres-hive (#11196) (@betodealmeida)
- [#11172](https://github.com/apache/superset/pull/11172) chore: turn SQL templating off by default (#11172) (@dpgaspar)
- [#11194](https://github.com/apache/superset/pull/11194) Revert "refactor: Replace react-bootstrap tabs with Antd tabs (#11090)" (#11194) (@john-bodley)
- [#11098](https://github.com/apache/superset/pull/11098) feat: add UUID column to ImportMixin (#11098) (@betodealmeida)
- [#11155](https://github.com/apache/superset/pull/11155) chore: cleanup FAB update perms (#11155) (@john-bodley)
- [#11131](https://github.com/apache/superset/pull/11131) test: removed unicode_test example from unit tests (#11131) (@kkucharc)
- [#11173](https://github.com/apache/superset/pull/11173) fix(viz): downgrade exception for missing viz/datasource (#11173) (@villebro)
- [#11180](https://github.com/apache/superset/pull/11180) fixed undefined names error (#11180) (@lilykuang)
- [#11164](https://github.com/apache/superset/pull/11164) fix: save query modal/button styling + convert to ant-d modal (#11164) (@riahk)
- [#11176](https://github.com/apache/superset/pull/11176) fix: cosmetic issue template (#11176) (@mistercrunch)
- [#11175](https://github.com/apache/superset/pull/11175) chore: remove SIP_34_SAVED_QUERIES_UI feature flag (#11175) (@lilykuang)
- [#11174](https://github.com/apache/superset/pull/11174) chore: add issue template for 'Cosmetic Issue' (#11174) (@mistercrunch)
- [#11168](https://github.com/apache/superset/pull/11168) fix: 📜 `/docs/api` won't render (#11168) (@mistercrunch)
- [#11170](https://github.com/apache/superset/pull/11170) style(dashboard): minor improvements to chart context menu (#11170) (@mistercrunch)
- [#11056](https://github.com/apache/superset/pull/11056) style: fix too light form labels in DatabaseModal + DRY css (#11056) (@mistercrunch)
- [#11075](https://github.com/apache/superset/pull/11075) style(sqllab): make database errors more clear and render as monospace (#11075) (@mistercrunch)
- [#11137](https://github.com/apache/superset/pull/11137) fix: enable consistent etag across workers and force no-cache for dashboards (#11137) (@ktmud)
- [#11055](https://github.com/apache/superset/pull/11055) chore: more 'datasource' -> 'dataset' renaming (#11055) (@mistercrunch)
- [#11108](https://github.com/apache/superset/pull/11108) Remove erroneous package-lock.json (#11108) (@robdiciuccio)
- [#11135](https://github.com/apache/superset/pull/11135) feat: saved query preview modal (#11135) (@lilykuang)
- [#11040](https://github.com/apache/superset/pull/11040) allow passing bash args into the pytest (#11040) (@amitmiran137)
- [#11152](https://github.com/apache/superset/pull/11152) docs: typo (#11152) (@jolange)
- [#11154](https://github.com/apache/superset/pull/11154) docs: add API page to docs using Swagger UI (#11154) (@mistercrunch)
- [#11143](https://github.com/apache/superset/pull/11143) chore: Remove obsolete creating missing metric permissions (#11143) (@john-bodley)
- [#11150](https://github.com/apache/superset/pull/11150) Revert "refactor: Remove usages of reactable from TimeTable (#11046)" (#11150) (@etr2460)
- [#11145](https://github.com/apache/superset/pull/11145) fix: fixing CI workflow (#11145) (@henryyeh)
- [#11058](https://github.com/apache/superset/pull/11058) fix: Enable ESLint rule default-props-match-prop-types (#11058) (@kgabryje)
- [#11120](https://github.com/apache/superset/pull/11120) fix: clean up prop type errors in jest tests (#11120) (@eschutho)
- [#11090](https://github.com/apache/superset/pull/11090) refactor: Replace react-bootstrap tabs with Antd tabs (#11090) (@kgabryje)
- [#10924](https://github.com/apache/superset/pull/10924) perf(explore): render datasource details only when needed (#10924) (@ktmud)
- [#11139](https://github.com/apache/superset/pull/11139) style: override ace edit error icon (#11139) (@nytai)

### 1.0.0 (Fri Jan 15 15:33:21 2021 -0800)
- [#12535](https://github.com/apache/superset/pull/12535) Fix 500 error when loading dashboards with slice having deleted dataset (#12535) (@bechob)
- [#12562](https://github.com/apache/superset/pull/12562) fix: case expression should not have double quotes (#12562) (@betodealmeida)
- [#12558](https://github.com/apache/superset/pull/12558) fix: height on grid results (#12558) (@betodealmeida)
- [#12556](https://github.com/apache/superset/pull/12556) fix(viz): missing groupby and broken adhoc metrics for boxplot (#12556) (@ktmud)
- [#12555](https://github.com/apache/superset/pull/12555) fix: Add MAX_SQL_ROW value to LIMIT_DROPDOWN (#12555) (@hughhhh)
- [#1410](https://github.com/apache/superset/pull/12410) fix: Popover closes on change of dropdowns values (#12410) (@geido)
- [#12337](https://github.com/apache/superset/pull/12337) chore: rename docker image from incubator-superset to superset (#1337) (@amitmiran137)
- [#12403](https://github.com/apache/superset/pull/12403) feat(db-engine): Add support for Apache Solr (#12403) (@aadel)
- [#12497](https://github.com/apache/superset/pull/12497) Fix list filters vertical alignment (#12497) (@michael-s-molina)
- [#12522](https://github.com/apache/superset/pull/12522) fix: Select options overflowing Save chart modal on Explore view (#12522) (@kgabryje)
- [#12536](https://github.com/apache/superset/pull/12536) Fixing Pinot queries for time granularities: WEEKS/MONTHS/QUARTERS/YEARS (#12536) (@fx19880617)
- [#12537](https://github.com/apache/superset/pull/12537) fix(explore): Add Time section back to FilterBox (#12537) (@ktmud)
- [#12532](https://github.com/apache/superset/pull/12532) fix(explore): time table control panel (#12532) (@ktmud)
- [#12530](https://github.com/apache/superset/pull/12530) fix: lowercase all columns in examples (#12530) (@betodealmeida)
- [#12518](https://github.com/apache/superset/pull/12518) ci: remove refs/tags from docker tags on a release (#12518) (@dpgaspar)
- [#12491](https://github.com/apache/superset/pull/12491) fix: impose dataset ownership check on old API (#12491) (@dpgaspar)
- [#12425](https://github.com/apache/superset/pull/12425) fix: import ZIP files that have been modified (#12425) (@betodealmeida)
- [#12472](https://github.com/apache/superset/pull/12472) fix (SQL Lab): disappearing results on tab switch (#12472) (@betodealmeida)
- [#12489](https://github.com/apache/superset/pull/12489) fix(timepicker): make pyparsing thread safe (#12489) (@zhaoyongjie)
- [#12483](https://github.com/apache/superset/pull/12483) fix(dashboard): use datasource id from slice metadata (#12483) (@ktmud)
- [#12478](https://github.com/apache/superset/pull/12478) fix: do not show vertical scrollbar for charts in dashboard (#12478) (@graceguo-supercat)
- [#12466](https://github.com/apache/superset/pull/12466) chore: bump superset-ui deckgl plugin (#12466) (@rusackas)
- [#12426](https://github.com/apache/superset/pull/12426) bump superset-ui packages for rolling window change (#12426) (@pkdotson)
- [#12418](https://github.com/apache/superset/pull/12418) fix(dashboard): artefacts shown while drag and dropping deck.gl charts (#12418) (@kkucharc)
- [#12411](https://github.com/apache/superset/pull/12411) feat: Resizable dataset and controls panels on Explore view (#12411) (@kgabryje)
- [#12326](https://github.com/apache/superset/pull/12326) Fixes control panel fields styling (#12236) (#12326) (@michael-s-molina)
- [#12408](https://github.com/apache/superset/pull/12408) refactor: from superset.utils.core break down date_parser (#12408) (@zhaoyongjie)
- [#12409](https://github.com/apache/superset/pull/12409) fix(native-filters): incorrect queriesData state (#12409) (@villebro)
- [#12406](https://github.com/apache/superset/pull/12406) fix: Refresh Interval Modal dropdown (#12406) (@agatapst)
- [#12402](https://github.com/apache/superset/pull/12402) chore: change Datasource to Dataset in Explore ui (#12402) (@junlincc)
- [#12401](https://github.com/apache/superset/pull/12401) feat(explore): add tooltip to timepicker label (#12401) (@zhaoyongjie)
- [#12393](https://github.com/apache/superset/pull/12393) chore: upgrade eslint, babel, and prettier (#12393) (@ktmud)
- [#12392](https://github.com/apache/superset/pull/12392) chore: Fix typo “Rest” to “Reset” (#12392) (@junlincc)
- [#12391](https://github.com/apache/superset/pull/12391) chore: Show datasets when search input is empty (#12391) (@geido)
- [#12387](https://github.com/apache/superset/pull/12387) fix(explore): long metric name display (#12387) (@zhaoyongjie)
- [#12359](https://github.com/apache/superset/pull/12359) fix: explore replace wrong standalone slice url (#12359) (@duynguyenhoang)
- [#12390](https://github.com/apache/superset/pull/12390) Closes #12389 (#12390) (@geido)
- [#12383](https://github.com/apache/superset/pull/12383) fix: Data tables styling issues on Explore view (#12383) (@kgabryje)
- [#12385](https://github.com/apache/superset/pull/12385) Fix new metric popover showing previous popover's title (#12385) (@kgabryje)
- [#12381](https://github.com/apache/superset/pull/12381) fix(explore): adhoc metric label and control value not consistent (#12381) (@zhaoyongjie)
- [#12382](https://github.com/apache/superset/pull/12382) fix(explore): clear custom label if removed (#12382) (@villebro)
- [#12377](https://github.com/apache/superset/pull/12377) Fix filter popover under data table (#12377) (@kgabryje)
- [#12378](https://github.com/apache/superset/pull/12378) Update samples table when datasource changes (#12378) (@kgabryje)
- [#12368](https://github.com/apache/superset/pull/12368) fix: datasets populating after user creation (#12368) (@hughhhh)
- [#12365](https://github.com/apache/superset/pull/12365) chore: make datasource search input sticky (#12365) (@pkdotson)
- [#12362](https://github.com/apache/superset/pull/12362) fix: Fix chart resizing when using split view (#12362) (@kgabryje)
- [#12096](https://github.com/apache/superset/pull/12096) ci(docker): fix release published event checkout tag-sha (#12096) (@dpgaspar)
- [#12082](https://github.com/apache/superset/pull/12082) test: rename column names for birth_names dataset (#12082) (@ktmud)
- [#12351](https://github.com/apache/superset/pull/12351) fix(load examples): load examples creating unnecessary main database (#12351) (@dpgaspar)
- [#12361](https://github.com/apache/superset/pull/12361) Fix running query on every change in chart controls (#12361) (@kgabryje)
- [#12357](https://github.com/apache/superset/pull/12357) fix: Fix dataset condition to allow query for datasets in sqllab (#12357) (@hughhhh)
- [#12257](https://github.com/apache/superset/pull/12257) perf: Optimize performance of Results and Samples tables on Explore (#12257) (@kgabryje)
- [#12353](https://github.com/apache/superset/pull/12353) Fix CSS injection order (#12265) (#12353) (@michael-s-molina)
- [#12352](https://github.com/apache/superset/pull/12352) chore(dashboard): Add ErrorBoudary for AdhocFilter components (#12352) (@nikolagigic)
- [#12350](https://github.com/apache/superset/pull/12350) fix(explore): improve filter translation (#12350) (@villebro)
- [#12306](https://github.com/apache/superset/pull/12306) fix: Set width to pseudoelement to wrap filter box (#12306) (@maloun96)
- [#12318](https://github.com/apache/superset/pull/12318) fix: south pane scrolling issues (#12318) (@eschutho)
- [#12349](https://github.com/apache/superset/pull/12349) chore: bumping nvd3 plugin (and thus, nvd3-fork) (#12349) (@rusackas)
- [#12307](https://github.com/apache/superset/pull/12307) refactor: test connection raises only command exceptions (#12307) (@dpgaspar)
- [#12154](https://github.com/apache/superset/pull/12154) feat: move filters from superset-ui to incubator (#12154) (@simchaNielsen)
- [#12347](https://github.com/apache/superset/pull/12347) window.location > history.push (#12347) (@rusackas)
- [#12315](https://github.com/apache/superset/pull/12315) feat: provide support for an overridable template to be included in every view (#12315) (@nytai)
- [#12344](https://github.com/apache/superset/pull/12344) remove datataset from title (#12344) (@pkdotson)
- [#12338](https://github.com/apache/superset/pull/12338) feat: new COVID vaccination dashboard (#12338) (@betodealmeida)
- [#12335](https://github.com/apache/superset/pull/12335) chore: change order of tab on explore data panel  (#12335) (@lilykuang)
- [#12320](https://github.com/apache/superset/pull/12320) fix: append orphan charts (#12320) (@betodealmeida)
- [#12067](https://github.com/apache/superset/pull/12067) feat: SQL Toolbar (#12067) (@hughhhh)
- [#12334](https://github.com/apache/superset/pull/12334) Reduce z-index (#12334) (@geido)
- [#12330](https://github.com/apache/superset/pull/12330) Fix menuPortal dropdown z-index (#12330) (@geido)
- [#12311](https://github.com/apache/superset/pull/12311) fix(alert/report): add/edit modal can't be saved (#12311) (@lilykuang)
- [#12327](https://github.com/apache/superset/pull/12327) Fix select overlap by aggregate button (#12312) (#12327) (@michael-s-molina)
- [#12090](https://github.com/apache/superset/pull/12090) build: try to speed up Github workflows (#12090) (@ktmud)
- [#12313](https://github.com/apache/superset/pull/12313) build: improve webpack configs for npm link (#12313) (@ktmud)
- [#12210](https://github.com/apache/superset/pull/12210) feat: Custom color schemes support (#12210) (@amitmiran137)
- [#12282](https://github.com/apache/superset/pull/12282) chore: improve styles for collapsed Native Filter sidebar (#12282) (@agatapst)
- [#12305](https://github.com/apache/superset/pull/12305) fix(explore): metrics caret not expanding in datasource panel (#12305) (@geido)
- [#12319](https://github.com/apache/superset/pull/12319) fix: update search in datasource panel to use matchSorter (#12319) (@pkdotson)
- [#12019](https://github.com/apache/superset/pull/12019) build(deps): bump ini in /superset-frontend/cypress-base (#12019) (@dependabot[bot])
- [#12284](https://github.com/apache/superset/pull/12284) docs: remove (some) references to incubating/incubation (#12284) (@nytai)
- [#12022](https://github.com/apache/superset/pull/12022) docs: Added release notes and associated media for 0.38 (#12022) (@garden-of-delete)
- [#12021](https://github.com/apache/superset/pull/12021) build(deps): bump ini from 1.3.5 to 1.3.8 in /superset-frontend (#12021) (@dependabot[bot])
- [#12308](https://github.com/apache/superset/pull/12308) fix(explore): refine previous calendar range (#12308) (@zhaoyongjie)
- [#12261](https://github.com/apache/superset/pull/12261) add related field filter to queries/user (#12261) (@riahk)
- [#12300](https://github.com/apache/superset/pull/12300) fix(explore): timepicker show human readable string in pill (#12300) (@zhaoyongjie)
- [#12278](https://github.com/apache/superset/pull/12278) fix(explore): bugs in Custom SQL editor in filter popover (#12278) (@kgabryje)
- [#12289](https://github.com/apache/superset/pull/12289) chore: remove harmless incubator refs (#12289) (@amitmiran137)
- [#12274](https://github.com/apache/superset/pull/12274) fix(database): OpenAPI spec for test_connection (#12274) (@dpgaspar)
- [#12277](https://github.com/apache/superset/pull/12277) fix(reports): don't log user errors and state change has errors (#12277) (@dpgaspar)
- [#12291](https://github.com/apache/superset/pull/12291) build: ignore github actions from dependabot (#12291) (@ktmud)
- [#12295](https://github.com/apache/superset/pull/12295) fix null check for condition threshold to allow 0 values (#12295) (@riahk)
- [#12280](https://github.com/apache/superset/pull/12280) Bump superset-ui deps (#12280) (@kgabryje)
- [#12221](https://github.com/apache/superset/pull/12221) fix: Fixed width for dataset panel (#12221) (@kgabryje)
- [#12239](https://github.com/apache/superset/pull/12239) chore(home): add ErrorBoundary to Charts section (#12239) (@maxamante)
- [#12292](https://github.com/apache/superset/pull/12292) fix: load example data into correct DB (#12292) (@betodealmeida)
- [#12297](https://github.com/apache/superset/pull/12297) Cypress: ignore unrelated ResizeObserver client errors (#12297) (@robdiciuccio)
- [#12253](https://github.com/apache/superset/pull/12253) test: fix flaky Python unit tests (#12253) (@kstrz)
- [#12213](https://github.com/apache/superset/pull/12213) Fix tests errors and warnings - iteration 1 (#12212) (#12213) (@michael-s-molina)
- [#12258](https://github.com/apache/superset/pull/12258) fix: Issue #12004 timegrain not visibile (#12258) (@geido)
- [#12250](https://github.com/apache/superset/pull/12250) fix: Show Data panel on resize (#12250) (@maloun96)
- [#12153](https://github.com/apache/superset/pull/12153) fix: Add visibility to box for viewing menu items (#12153) (@maloun96)
- [#12290](https://github.com/apache/superset/pull/12290) build: remove parallelization for E2E tests (#12290) (@ktmud)
- [#12288](https://github.com/apache/superset/pull/12288) fix: Add min-height for loading indicator to show up (#12288) (@geido)
- [#12192](https://github.com/apache/superset/pull/12192) build(deps-dev): bump storybook-addon-paddings in /superset-frontend (#12192) (@dependabot[bot])
- [#12205](https://github.com/apache/superset/pull/12205) fix: SaveDatasetModal save state on back button (#12205) (@hughhhh)
- [#12251](https://github.com/apache/superset/pull/12251) docs: fix build status badge to github actions (#12251) (@dpgaspar)
- [#12215](https://github.com/apache/superset/pull/12215) fix : Style caret for profile page (#12215) (@maloun96)
- [#12211](https://github.com/apache/superset/pull/12211) Set datasource panel open by default (#12211) (@kgabryje)
- [#12242](https://github.com/apache/superset/pull/12242) fix(explore): bump superset-ui to 0.16.3 and fix DeckGL bug (#12242) (@villebro)
- [#12208](https://github.com/apache/superset/pull/12208) feat(explore): Time picker enhancement follow up (#12208) (@zhaoyongjie)
- [#11960](https://github.com/apache/superset/pull/11960) fix: Altered button crashing and title not updating on Explore view (#11960) (@kgabryje)
- [#12217](https://github.com/apache/superset/pull/12217) Remove uppercase for tab names (#12217) (@maloun96)
- [#12248](https://github.com/apache/superset/pull/12248) build(deps): bump node-fetch in /.github/actions/file-changes-action (#12248) (@dependabot[bot])
- [#12246](https://github.com/apache/superset/pull/12246) build(deps): bump @actions/core in /.github/actions/file-changes-action (#12246) (@dependabot[bot])
- [#12050](https://github.com/apache/superset/pull/12050) docs(api): Script to generate API docs (openapi.json) (#12050) (@robdiciuccio)
- [#12165](https://github.com/apache/superset/pull/12165) fix: Change Datasource styling fixes (#12165) (@hughhhh)
- [#12188](https://github.com/apache/superset/pull/12188) fix: CTAS on multiple statements (#12188) (@betodealmeida)
- [#12183](https://github.com/apache/superset/pull/12183) feat(report): add/edit modal improvements (#12183) (@lilykuang)
- [#12241](https://github.com/apache/superset/pull/12241) build: inline external Github Actions to unblock CI (#12241) (@ktmud)
- [#11999](https://github.com/apache/superset/pull/11999) Refetch samples only when filters change (#11999) (@kgabryje)
- [#12184](https://github.com/apache/superset/pull/12184) feat: Implement drag & drop for metrics and filters labels (#12184) (@kgabryje)
- [#12196](https://github.com/apache/superset/pull/12196) fix(reports): make name unique between alerts and reports (#12196) (@dpgaspar)
- [#12193](https://github.com/apache/superset/pull/12193) fix: align submenu items (#12193) (@maloun96)
- [#12163](https://github.com/apache/superset/pull/12163) feat: add new dashboard with FCC data (#12163) (@betodealmeida)
- [#12189](https://github.com/apache/superset/pull/12189) fix(alerts/reports): ensure correct type is sent to api (#12189) (@nytai)
- [#12097](https://github.com/apache/superset/pull/12097) docs: update UPDATING.md with security simplification info (#12097) (@dpgaspar)
- [#12174](https://github.com/apache/superset/pull/12174) fix(reports): notification without standalone link back to superset (#12174) (@dpgaspar)
- [#12191](https://github.com/apache/superset/pull/12191) updated SQLAlchemy=1.3.21 is incompatible in setup.py file. (#12191) (@jagamts1)
- [#12179](https://github.com/apache/superset/pull/12179) fix(chart): rendering standalone chart and errors (#12179) (@agatapst)
- [#12158](https://github.com/apache/superset/pull/12158) chore: Add Loading icon to Filter Bar (#12158) (@agatapst)
- [#12091](https://github.com/apache/superset/pull/12091) refactor: remove queryFields in QueryObject and update chart control configs (#12091) (@ktmud)
- [#12187](https://github.com/apache/superset/pull/12187) fix: SQL Lab vertical space (#12187) (@betodealmeida)
- [#12166](https://github.com/apache/superset/pull/12166) fix: append ID to filename when exporting chart (#12166) (@betodealmeida)
- [#12185](https://github.com/apache/superset/pull/12185) fix: remove uniqueness for MySQL (#12185) (@betodealmeida)
- [#12186](https://github.com/apache/superset/pull/12186) fix: specify VARCHAR size when loading examples (#12186) (@betodealmeida)
- [#12178](https://github.com/apache/superset/pull/12178) fix(explore): save chart not working (#12178) (@villebro)
- [#12075](https://github.com/apache/superset/pull/12075) chore: Change chart_is_fav to chart_is_favorite (#12075) (@nikolagigic)
- [#12168](https://github.com/apache/superset/pull/12168) refactor: Refresh interval typescript (#12168) (@maloun96)
- [#12162](https://github.com/apache/superset/pull/12162) feat: add new dashboard with video game sales (#12162) (@betodealmeida)
- [#12156](https://github.com/apache/superset/pull/12156) Fix Filter Bar scrolling (#12156) (@agatapst)
- [#12010](https://github.com/apache/superset/pull/12010) refactor: Fix anchor-is-valid lint warnings (#12010) (@michael-s-molina)
- [#12151](https://github.com/apache/superset/pull/12151) test(dashboard): fix flaky Cypress test (#12151) (@ktmud)
- [#12159](https://github.com/apache/superset/pull/12159) chore: rename variable for clarity (#12159) (@betodealmeida)
- [#12136](https://github.com/apache/superset/pull/12136) fix: database alpha permissions (#12136) (@dpgaspar)
- [#12121](https://github.com/apache/superset/pull/12121) fix(report): fix last_eval_dttm sort and more tests (#12121) (@dpgaspar)
- [#12157](https://github.com/apache/superset/pull/12157) Fix Reset All filters button (#12157) (@agatapst)
- [#11997](https://github.com/apache/superset/pull/11997) refactor: Explore SaveModal to typescript (#11997) (@maloun96)
- [#12132](https://github.com/apache/superset/pull/12132) fix(report): fix start date format and paginated query (#12132) (@lilykuang)
- [#12146](https://github.com/apache/superset/pull/12146) fix(database): adjust column sizing for list view (#12146) (@nytai)
- [#10288](https://github.com/apache/superset/pull/10288) feat: Dynamically imported viz plugins (#10288) (@suddjian)
- [#12138](https://github.com/apache/superset/pull/12138) feat: Native filters fast-follow (#12138) (@rusackas)
- [#12144](https://github.com/apache/superset/pull/12144) fix(chart): replace viz_type with viz name from registry for list view (#12144) (@nytai)
- [#12145](https://github.com/apache/superset/pull/12145) fix height (#12145) (@pkdotson)
- [#11814](https://github.com/apache/superset/pull/11814) feat(dashboard): Dashboard-Native Filters (#11814) (@suddjian)
- [#12130](https://github.com/apache/superset/pull/12130) feat: estimate query cost in Postgres (#12130) (@betodealmeida)
- [#12113](https://github.com/apache/superset/pull/12113) feat: display suggestions when query has missing parameters (#12113) (@betodealmeida)
- [#12135](https://github.com/apache/superset/pull/12135) fix: make example table name safe (#12135) (@betodealmeida)
- [#12127](https://github.com/apache/superset/pull/12127) fix: remove SIP_34_ALERTS_UI from config (#12127) (@nytai)
- [#12129](https://github.com/apache/superset/pull/12129) fix(explore): overflow issue with metric options (#12129) (@rusackas)
- [#12125](https://github.com/apache/superset/pull/12125) Improves chart save and go button (#12125) (@michael-s-molina)
- [#12060](https://github.com/apache/superset/pull/12060) feat: View all fav charts and dashboards (#12060) (@geido)
- [#12123](https://github.com/apache/superset/pull/12123) feat: Add Saved Metrics tab to metrics popover (#12123) (@kgabryje)
- [#12116](https://github.com/apache/superset/pull/12116) fix: properly render booleans in FilterBox and explore page data preview (#12116) (@ktmud)
- [#12124](https://github.com/apache/superset/pull/12124) fix: fix the flaky FilterBox test re-introduced by #12114 (#12124) (@ktmud)
- [#11880](https://github.com/apache/superset/pull/11880) feat: Support multiple queries per request (#11880) (@simchaNielsen)
- [#12115](https://github.com/apache/superset/pull/12115) fix: remove keys in dashboard export (#12115) (@betodealmeida)
- [#12118](https://github.com/apache/superset/pull/12118) feat(chart-data-api): ignore unknown fields on QueryObject (#12118) (@villebro)
- [#12119](https://github.com/apache/superset/pull/12119) fix: security cleanup annotation and refresh permissions (#12119) (@dpgaspar)
- [#12117](https://github.com/apache/superset/pull/12117) docs(releasing): update release automation and docs for Apache graduation (#12117) (@dpgaspar)
- [#12008](https://github.com/apache/superset/pull/12008) feat(explore-datasource): add new datasource tab to explore view (#12008) (@pkdotson)
- [#12114](https://github.com/apache/superset/pull/12114) fix: FilterBox select lose focus when focused (#12114) (@ktmud)
- [#12045](https://github.com/apache/superset/pull/12045) fix: updates to alert/report modal + more tests (#12045) (@riahk)
- [#12085](https://github.com/apache/superset/pull/12085) feat(alerts/reports): remove SIP_34_UI feature flag (#12085) (@riahk)
- [#12110](https://github.com/apache/superset/pull/12110) fix(alerts/reports): modal submit button, copy changes, select apis (#12110) (@nytai)
- [#12080](https://github.com/apache/superset/pull/12080) feat: initial custom error messages for SQL Lab (#12080) (@betodealmeida)
- [#11418](https://github.com/apache/superset/pull/11418) feat(explore): time picker enhancement (#11418) (@zhaoyongjie)
- [#12081](https://github.com/apache/superset/pull/12081) feat: update alert/report icons and column order (#12081) (@lilykuang)
- [#12095](https://github.com/apache/superset/pull/12095) feat(explore): metrics and filters controls redesign (#12095) (@kgabryje)
- [#12071](https://github.com/apache/superset/pull/12071) feat(alerts/reports): add refresh action (#12071) (@nytai)
- [#11148](https://github.com/apache/superset/pull/11148) chore: add latest tag action (#11148) (@eschutho)
- [#12056](https://github.com/apache/superset/pull/12056) fix(reports): increase crontab size and alert fixes (#12056) (@dpgaspar)
- [#12099](https://github.com/apache/superset/pull/12099) Small typo fix in Athena connection docs (#12099) (@lamielle)
- [#12072](https://github.com/apache/superset/pull/12072) feat(queries): security perm simplification (#12072) (@dpgaspar)
- [#12036](https://github.com/apache/superset/pull/12036) feat(databases): security perm simplification (#12036) (@dpgaspar)
- [#12012](https://github.com/apache/superset/pull/12012) feat(dashboards): security permissions simplification (#12012) (@dpgaspar)
- [#12061](https://github.com/apache/superset/pull/12061) feat(logs): security permissions simplification (#12061) (@kkucharc)
- [#11972](https://github.com/apache/superset/pull/11972) chore: Remove unused CodeModal (#11972) (@maloun96)
- [#12074](https://github.com/apache/superset/pull/12074) Fix typescript error (#12074) (@ktmud)
- [#12088](https://github.com/apache/superset/pull/12088) fix: handle context-dependent feature flags in CLI (#12088) (@betodealmeida)
- [#12086](https://github.com/apache/superset/pull/12086) fix: Fix "View in SQLLab" bug (#12086) (@hughhhh)
- [#12077](https://github.com/apache/superset/pull/12077) feat(alert/report): add 'not null' condition option to modal (#12077) (@riahk)
- [#12078](https://github.com/apache/superset/pull/12078) bumping superset ui to 15.18 and deckgl to 0.3.2 (#12078) (@rusackas)
- [#12079](https://github.com/apache/superset/pull/12079) fix: Python dependencies in #11499 (#12079) (@john-bodley)
- [#12048](https://github.com/apache/superset/pull/12048) reset active tab on open (#12048) (@riahk)
- [#12070](https://github.com/apache/superset/pull/12070) fix: improve import flow UI/UX (#12070) (@betodealmeida)
- [#12053](https://github.com/apache/superset/pull/12053) feat(alerts/reports): delete and bulk delete actions (#12053) (@nytai)
- [#12025](https://github.com/apache/superset/pull/12025) feat: Global nav menus open on hover (#12025) (@rusackas)
- [#12076](https://github.com/apache/superset/pull/12076) Remove e2e pull_request event trigger (#12076) (@robdiciuccio)
- [#11750](https://github.com/apache/superset/pull/11750) build(cypress): Use pull_request_target event to run cypress (#11750) (@robdiciuccio)
- [#11979](https://github.com/apache/superset/pull/11979) fix(dataset): Page blanks on large data load (#11979) (@nikolagigic)
- [#12000](https://github.com/apache/superset/pull/12000) feat(datasets): security perm simplification (#12000) (@dpgaspar)
- [#12014](https://github.com/apache/superset/pull/12014) feat(annotations): security permissions simplification (#12014) (@kkucharc)
- [#12038](https://github.com/apache/superset/pull/12038) fix: Closes #11864 - Duplicate PropertiesModal (#12038) (@geido)
- [#12042](https://github.com/apache/superset/pull/12042) refactor: Migrate react-select to Antd Select in Metrics and Filters popovers (#12042) (@kgabryje)
- [#12049](https://github.com/apache/superset/pull/12049) feat: show missing parameters in query (#12049) (@betodealmeida)
- [#11970](https://github.com/apache/superset/pull/11970) feat: add hook for dataset health check (#11970) (@graceguo-supercat)
- [#11927](https://github.com/apache/superset/pull/11927) refactor: optimize backend log payload (#11927) (@ktmud)
- [#12044](https://github.com/apache/superset/pull/12044) feat: Add new default dashboard (#12044) (@betodealmeida)
- [#12026](https://github.com/apache/superset/pull/12026) feat: load examples from config instead of code (#12026) (@betodealmeida)
- [#12064](https://github.com/apache/superset/pull/12064) fix: small fixes to the new import/export (#12064) (@betodealmeida)
- [#12063](https://github.com/apache/superset/pull/12063) fix(annotation layers): remove redirect on layer edit (#12063) (@riahk)
- [#11803](https://github.com/apache/superset/pull/11803) feat: handle new export in CLI (#11803) (@betodealmeida)
- [#12057](https://github.com/apache/superset/pull/12057) fixed CONTRIBUTING typos (#12057) (@adam-stasiak)
- [#11971](https://github.com/apache/superset/pull/11971) refactor: Transform URLShortLinkModal to Typescript (#11971) (@maloun96)
- [#11981](https://github.com/apache/superset/pull/11981) feat(charts): security perm simplification (#11981) (@dpgaspar)
- [#12055](https://github.com/apache/superset/pull/12055) fix(viz): remove orderby from sample request (#12055) (@villebro)
- [#12054](https://github.com/apache/superset/pull/12054) upgrade react-split (#12054) (@rusackas)
- [#11853](https://github.com/apache/superset/pull/11853) feat(reports): security perm simplification (#11853) (@dpgaspar)
- [#12039](https://github.com/apache/superset/pull/12039) fix(reports): log duration and sort column (#12039) (@dpgaspar)
- [#12035](https://github.com/apache/superset/pull/12035) fix(reports): apply owners security validation (#12035) (@dpgaspar)
- [#11996](https://github.com/apache/superset/pull/11996) fix: Fix style for error modal (#11996) (@maloun96)
- [#11957](https://github.com/apache/superset/pull/11957) chore: bumping plugin packages to latest (#11957) (@rusackas)
- [#12032](https://github.com/apache/superset/pull/12032) feat: add cron picker to AlertReportModal (#12032) (@nytai)
- [#12043](https://github.com/apache/superset/pull/12043) fix: disable browser autocomplete for DeleteModal (#12043) (@nytai)
- [#12006](https://github.com/apache/superset/pull/12006) fix: Explore "Change Dataset" UX Enhancements (#12006) (@hughhhh)
- [#12018](https://github.com/apache/superset/pull/12018) fix schema datasource modal (#12018) (@lilykuang)
- [#11207](https://github.com/apache/superset/pull/11207) feat: Added setup for running Cypress tests in docker locally (#11207) (@adam-stasiak)
- [#12013](https://github.com/apache/superset/pull/12013) refactor: Existing Antd Collapse to enhanced (#12013) (@geido)
- [#12024](https://github.com/apache/superset/pull/12024) style: Restoring menu highlights (#12024) (@rusackas)
- [#11978](https://github.com/apache/superset/pull/11978) docs: restored page on roles in security, executed other touchups, and… (#11978) (@srinify)
- [#11993](https://github.com/apache/superset/pull/11993) refactor : Change menu name and reorder items (#11993) (@maloun96)
- [#11915](https://github.com/apache/superset/pull/11915) fix: Change url & add check for active item in menu (#11915) (@maloun96)
- [#11991](https://github.com/apache/superset/pull/11991) feat: update IDs when importing dashboards (#11991) (@betodealmeida)
- [#11983](https://github.com/apache/superset/pull/11983) feat: add confirmation dialog for imports (#11983) (@betodealmeida)
- [#11770](https://github.com/apache/superset/pull/11770) feat: alerts/reports add/edit modal (#11770) (@riahk)
- [#12007](https://github.com/apache/superset/pull/12007) fix: add default position to dash export (#12007) (@betodealmeida)
- [#12003](https://github.com/apache/superset/pull/12003) chore: remove generic type (#12003) (@betodealmeida)
- [#11973](https://github.com/apache/superset/pull/11973) fix(dataset): fetch metadata on dataset creation may raise broad exceptions (#11973) (@dpgaspar)
- [#11951](https://github.com/apache/superset/pull/11951) refactor : Transform SaveModal to typescript (#11951) (@maloun96)
- [#11499](https://github.com/apache/superset/pull/11499) feat(SIP-39): Async query support for charts (#11499) (@robdiciuccio)
- [#11994](https://github.com/apache/superset/pull/11994) feat: add invisible layer on loading chart (#11994) (@graceguo-supercat)
- [#11937](https://github.com/apache/superset/pull/11937) feat: alert/report execution log list view (#11937) (@lilykuang)
- [#11982](https://github.com/apache/superset/pull/11982) feat: confirm overwrite when importing (#11982) (@betodealmeida)
- [#12002](https://github.com/apache/superset/pull/12002) chore: move passwords needed message (#12002) (@betodealmeida)
- [#11977](https://github.com/apache/superset/pull/11977) refactor: Removes hard coded colors (#11977) (@michael-s-molina)
- [#11936](https://github.com/apache/superset/pull/11936) chore: consolidate common code in importers (#11936) (@betodealmeida)
- [#11980](https://github.com/apache/superset/pull/11980) fix : Fix style for header (sqllab) (#11980) (@maloun96)
- [#11946](https://github.com/apache/superset/pull/11946) fix(explore): changing metric aggregate doesn't update label (#11946) (@mayurnewase)
- [#11990](https://github.com/apache/superset/pull/11990) fixing rounded corners (#11990) (@rusackas)
- [#11964](https://github.com/apache/superset/pull/11964) refactor : Transform FilterScopeModal to Typescript (#11964) (@maloun96)
- [#11963](https://github.com/apache/superset/pull/11963) fix : adhoc filter dropdown (#11963) (@maloun96)
- [#11985](https://github.com/apache/superset/pull/11985) Debounce TextControl if change runs immediately after input (#11985) (@kgabryje)
- [#11975](https://github.com/apache/superset/pull/11975) Change paddings on ListView and SubMenu (#11975) (@kgabryje)
- [#11986](https://github.com/apache/superset/pull/11986) add user to sql lab state (#11986) (@eschutho)
- [#11987](https://github.com/apache/superset/pull/11987) fix: make "DELETE" confirmation work in other languages (#11987) (@betodealmeida)
- [#11308](https://github.com/apache/superset/pull/11308) tests: added fixture with energy usage instead of example (#11308) (@kkucharc)
- [#11967](https://github.com/apache/superset/pull/11967) refactor: Upgrade Redux (#11967) (@suddjian)
- [#11883](https://github.com/apache/superset/pull/11883) refactor: move enums to the beginning of utiuls/core.py (#11883) (@ktmud)
- [#11890](https://github.com/apache/superset/pull/11890) fix(reports): validator_config, report state machine, working_timeout (#11890) (@dpgaspar)
- [#11934](https://github.com/apache/superset/pull/11934) fix: always fetch database list on bootstrap payload (#11934) (@mistercrunch)
- [#11755](https://github.com/apache/superset/pull/11755) feat: Sqllab to Explore UX improvements (#11755) (@hughhhh)
- [#11940](https://github.com/apache/superset/pull/11940) build: cancel previous github action runs (#11940) (@ktmud)
- [#11950](https://github.com/apache/superset/pull/11950) fix(alerts, thumbnails): celery tasks using flask-sqlalchemy sessions (#11950) (@dpgaspar)
- [#11885](https://github.com/apache/superset/pull/11885) fix(event-flow-viz): handle null metadata selection (#11885) (@maloun96)
- [#11924](https://github.com/apache/superset/pull/11924) feat: add modal to import dashboards (#11924) (@betodealmeida)
- [#11956](https://github.com/apache/superset/pull/11956) feat: add modal to import charts (#11956) (@betodealmeida)
- [#11910](https://github.com/apache/superset/pull/11910) feat: add modal to import datasets (#11910) (@betodealmeida)
- [#11884](https://github.com/apache/superset/pull/11884) feat: add modal to import databases (#11884) (@betodealmeida)
- [#11947](https://github.com/apache/superset/pull/11947) chore: bump nvd3 plugin version (#11947) (@kristw)
- [#11931](https://github.com/apache/superset/pull/11931) fix(charts): screenshot API declaring an unnecessary rison arg (#11931) (@dpgaspar)
- [#11893](https://github.com/apache/superset/pull/11893) feat(releasing): support changelog csv export (#11893) (@dpgaspar)
- [#11854](https://github.com/apache/superset/pull/11854) feat: Results table on Explore view (#11854) (@kgabryje)
- [#11538](https://github.com/apache/superset/pull/11538) feat: add Postgres SQL validator (#11538) (@betodealmeida)
- [#11899](https://github.com/apache/superset/pull/11899) refactor: Move Badge to Antdesign (#11899) (@geido)
- [#11928](https://github.com/apache/superset/pull/11928) refactor: Extract copy functionality to utils (#11928) (@maloun96)
- [#11939](https://github.com/apache/superset/pull/11939) fix: make sure we log the logs (#11939) (@etr2460)
- [#11930](https://github.com/apache/superset/pull/11930) Quick fix for branch names in tags (#11930) (@craig-rueda)
- [#11877](https://github.com/apache/superset/pull/11877) Added check if SQL query is empty and disable shortcut for run query (#11877) (@kkucharc)
- [#11900](https://github.com/apache/superset/pull/11900) feat: filters for alerts and reports list view  (#11900) (@lilykuang)
- [#11920](https://github.com/apache/superset/pull/11920) fix: Remove expensive logs table migration (#11920) (@etr2460)
- [#11665](https://github.com/apache/superset/pull/11665) feat: add event and interval annotation support to chart data ep (#11665) (@villebro)
- [#11919](https://github.com/apache/superset/pull/11919) fix: Forgot to remove bad comments from SaveDatasetModal (#11919) (@hughhhh)
- [#11786](https://github.com/apache/superset/pull/11786) chore: add unit tests for the current import functionality (#11786) (@betodealmeida)
- [#11875](https://github.com/apache/superset/pull/11875) refactor: Move ProgressBar to Antd (#11875) (@geido)
- [#11904](https://github.com/apache/superset/pull/11904) feat: run BQ queries as single statement (#11904) (@betodealmeida)
- [#11911](https://github.com/apache/superset/pull/11911) fix: adjust width for non multi select inputs (#11911) (@eschutho)
- [#11861](https://github.com/apache/superset/pull/11861) feat: Adding SaveDatasetModal component (#11861) (@hughhhh)
- [#11868](https://github.com/apache/superset/pull/11868) chore: Support SET & SHOW commands as read only SQL commands (#11868) (@bkyryliuk)
- [#11876](https://github.com/apache/superset/pull/11876) fix: Check if annotation type is supported by the given chart type (#11876) (@agatapst)
- [#11912](https://github.com/apache/superset/pull/11912) fix: Button storybook component size knob (#11912) (@rusackas)
- [#11913](https://github.com/apache/superset/pull/11913) style: eslint curly rule (#11913) (@rusackas)
- [#11897](https://github.com/apache/superset/pull/11897) fix(query): sorting by user for Query History list view (#11897) (@nytai)
- [#11856](https://github.com/apache/superset/pull/11856) feat(css templates): security perm simplification (#11856) (@dpgaspar)
- [#11902](https://github.com/apache/superset/pull/11902) add fix for extra comments for #11781 (#11902) (@graceguo-supercat)
- [#11891](https://github.com/apache/superset/pull/11891) chore: Enable jsx-a11y/anchor-is-valid (#11891) (@nikolagigic)
- [#11887](https://github.com/apache/superset/pull/11887) chore: Update sqllab types (#11887) (@hughhhh)
- [#10770](https://github.com/apache/superset/pull/10770) Capture error when celery back-end does not support forgetting tasks (#10770) (@willbarrett)
- [#11816](https://github.com/apache/superset/pull/11816) feat: allow user to view their profile again (#11816) (@etr2460)
- [#11847](https://github.com/apache/superset/pull/11847) fix: Show copy icon (#11847) (@maloun96)
- [#11848](https://github.com/apache/superset/pull/11848) Align icon (#11848) (@maloun96)
- [#11843](https://github.com/apache/superset/pull/11843) style: remove react bootstrap fade component (#11843) (@nikolagigic)
- [#11802](https://github.com/apache/superset/pull/11802) feat: report/alert list CRUD view (#11802) (@lilykuang)
- [#11881](https://github.com/apache/superset/pull/11881) fix: certification icon order (#11881) (@etr2460)
- [#11781](https://github.com/apache/superset/pull/11781) fix (dataset editor): allow Source tab readOnly mode (#11781) (@graceguo-supercat)
- [#11845](https://github.com/apache/superset/pull/11845) fix: dashboard iframe to markdown db migration (#11845) (@dpgaspar)
- [#11771](https://github.com/apache/superset/pull/11771) test: add React Testing Library (#11771) (@ktmud)
- [#11580](https://github.com/apache/superset/pull/11580) fix: filters push out apply button on dashboard (#11580) (@kkucharc)
- [#11863](https://github.com/apache/superset/pull/11863) chore: remove SIP_34_QUERY_SEARCH_UI feature flag (#11863) (@nytai)
- [#11851](https://github.com/apache/superset/pull/11851) chore: Add home link to navbar (#11851) (@agatapst)
- [#11812](https://github.com/apache/superset/pull/11812) chore: move fixtures and helpers to root (#11812) (@eschutho)
- [#11702](https://github.com/apache/superset/pull/11702) feat: list view filters for Query History  (#11702) (@nytai)
- [#11855](https://github.com/apache/superset/pull/11855) feat:  Create api abstraction layer for dataset network calls (#11855) (@hughhhh)
- [#11858](https://github.com/apache/superset/pull/11858) fix(datasets): renaming openAPI columns (#11858) (@hughhhh)
- [#11678](https://github.com/apache/superset/pull/11678) feat(welcome): add SQL snippets to saved queries card (#11678) (@pkdotson)
- [#11766](https://github.com/apache/superset/pull/11766) Fix chart select borders in BuilderComponentPane (#11766) (@kgabryje)
- [#11852](https://github.com/apache/superset/pull/11852) fix: security converge downgrade procedure (#11852) (@dpgaspar)
- [#11830](https://github.com/apache/superset/pull/11830) fix: update chart doesn't remove all connections to dashboards (#11830) (@kkucharc)
- [#11238](https://github.com/apache/superset/pull/11238) feat: Option to run npm dev-server (hot reload) while calling docker-compose up (#11238) (@adam-stasiak)
- [#11836](https://github.com/apache/superset/pull/11836) feat: Sqllab to Explore UX improvements api changes (#11836) (@hughhhh)
- [#11778](https://github.com/apache/superset/pull/11778) fix: Download as image not working on Dashboard view (#11778) (@kgabryje)
- [#11764](https://github.com/apache/superset/pull/11764) feat(saved queries): security perm simplification (#11764) (@dpgaspar)
- [#11838](https://github.com/apache/superset/pull/11838) chore: type a couple easy to type files (#11838) (@etr2460)
- [#11779](https://github.com/apache/superset/pull/11779) chore: Move styles of Dashboard and FilterScopeSelector modals to Emotion (#11779) (@kgabryje)
- [#11834](https://github.com/apache/superset/pull/11834) Change subtabs order for Data tab (#11834) (@agatapst)
- [#11837](https://github.com/apache/superset/pull/11837) fix: improve Avatar text size consistency (#11837) (@etr2460)
- [#11824](https://github.com/apache/superset/pull/11824) fix: wrong key used  FEATURE_FLAGS[LISTVIEW_DEFAULT_CARD_VIEW]  (#11824) (@amitmiran137)
- [#11811](https://github.com/apache/superset/pull/11811) fix: Adding and removing annotations (#11811) (@agatapst)
- [#11828](https://github.com/apache/superset/pull/11828) ci(docker): build image on release (#11828) (@dpgaspar)
- [#11827](https://github.com/apache/superset/pull/11827) docs(release): small fixes and deprecate apache docs (#11827) (@dpgaspar)
- [#11825](https://github.com/apache/superset/pull/11825) fix(setup): disallow python 3.6 for pip install (#11825) (@dpgaspar)
- [#11801](https://github.com/apache/superset/pull/11801) fix: delete chart, dashboards, dbs with assoc reports (#11801) (@dpgaspar)
- [#11815](https://github.com/apache/superset/pull/11815) chore: Fix TableModelView super call (#11815) (@john-bodley)
- [#11683](https://github.com/apache/superset/pull/11683) feat: filter by me on CRUD list view (#11683) (@lilykuang)
- [#11805](https://github.com/apache/superset/pull/11805) fix: remove root dir from ZIP bundle (#11805) (@betodealmeida)
- [#11797](https://github.com/apache/superset/pull/11797) fix: add feature flag for domain sharding (#11797) (@graceguo-supercat)
- [#11714](https://github.com/apache/superset/pull/11714) chore: improve analytics (#11714) (@mistercrunch)
- [#10815](https://github.com/apache/superset/pull/10815) chore: type src/logger (#10815) (@etr2460)
- [#11809](https://github.com/apache/superset/pull/11809) docs: 0.38.0 CHANGELOG and UPDATING (#11809) (@dpgaspar)
- [#11762](https://github.com/apache/superset/pull/11762) fix: attachment filename error in sqllab with i18n (#11762) (@auxten)
- [#11795](https://github.com/apache/superset/pull/11795) fix: mutating input df in viz.py (#11795) (@villebro)
- [#11711](https://github.com/apache/superset/pull/11711) feat: new reports scheduler (#11711) (@dpgaspar)
- [#11751](https://github.com/apache/superset/pull/11751) feat: API endpoint to import dashboards (#11751) (@betodealmeida)
- [#11806](https://github.com/apache/superset/pull/11806) chore: unbreak frontend ci (#11806) (@etr2460)
- [#11737](https://github.com/apache/superset/pull/11737) refactor: Replace react-bootstrap tooltips with Antd tooltips (#11737) (@kgabryje)
- [#11798](https://github.com/apache/superset/pull/11798) fix: docker healthcheck (#11798) (@PMExtra)
- [#11785](https://github.com/apache/superset/pull/11785) feat: add certification info to table selector (#11785) (@etr2460)
- [#11783](https://github.com/apache/superset/pull/11783) update docs around email reports (#11783) (@eschutho)
- [#11794](https://github.com/apache/superset/pull/11794) build: split python CI jobs (#11794) (@etr2460)
- [#11675](https://github.com/apache/superset/pull/11675) refactor: use rison for list view filters stateful urls (#11675) (@riahk)
- [#11780](https://github.com/apache/superset/pull/11780) refactor: Replace SqlLab components' styles using Emotion & theme variables (#11780) (@agatapst)
- [#11754](https://github.com/apache/superset/pull/11754) chore: controls.test supporting v1 charts and added force=true to url when r… (#11754) (@adam-stasiak)
- [#11791](https://github.com/apache/superset/pull/11791) add tool tip to cards (#11791) (@pkdotson)
- [#11712](https://github.com/apache/superset/pull/11712) chore: enabled v1 verification in filter and url_params test files (#11712) (@adam-stasiak)
- [#11787](https://github.com/apache/superset/pull/11787) fix: annotation layer crashes when clearing type select (#11787) (@mistercrunch)
- [#11749](https://github.com/apache/superset/pull/11749) feat: add a command to import dashboards (#11749) (@betodealmeida)
- [#11775](https://github.com/apache/superset/pull/11775) docs: add Xite to users list (#11775) (@shashankkoppar)
- [#11732](https://github.com/apache/superset/pull/11732) fix: style multiselect input (#11732) (@eschutho)
- [#11747](https://github.com/apache/superset/pull/11747) Fix docker healthcheck. (#11747) (@PMExtra)
- [#11772](https://github.com/apache/superset/pull/11772) chore: fix typo (#11772) (@etr2460)
- [#11634](https://github.com/apache/superset/pull/11634) feat: SQL preview modal for Query History (#11634) (@nytai)
- [#11744](https://github.com/apache/superset/pull/11744) feat: API endpoint to import charts (#11744) (@betodealmeida)
- [#11743](https://github.com/apache/superset/pull/11743) feat: add a command to import charts (#11743) (@betodealmeida)
- [#11769](https://github.com/apache/superset/pull/11769) fix: Fixing issue around requirements-local.txt (#11769) (@craig-rueda)
- [#11760](https://github.com/apache/superset/pull/11760) feat: Add user info to sqllab via bootstrap data (#11760) (@hughhhh)
- [#11752](https://github.com/apache/superset/pull/11752) fix: Null error when deleting the last owner label in DatasourceEditor/settings (#11752) (@kgabryje)
- [#11709](https://github.com/apache/superset/pull/11709) Make spacings in Settings menu more consistent (#11709) (@kgabryje)
- [#11611](https://github.com/apache/superset/pull/11611) style: dark filter popover background (#11611) (@rusackas)
- [#11736](https://github.com/apache/superset/pull/11736) chore: Text change Allow Data Upload (#11736) (@amitmiran137)
- [#11740](https://github.com/apache/superset/pull/11740) fix: Adding __init__.py in superset.commands.importers (#11740) (@craig-rueda)
- [#11731](https://github.com/apache/superset/pull/11731) fix: do not drop calculated column on metadata sync (#11731) (@villebro)
- [#11703](https://github.com/apache/superset/pull/11703) docs: fix docker config paths (#11703) (@suddjian)
- [#11726](https://github.com/apache/superset/pull/11726) Fix missing styles in FilterScopeSelector modal (#11726) (@kgabryje)
- [#11728](https://github.com/apache/superset/pull/11728) feat: API endpoints to upload dataset/db (#11728) (@betodealmeida)
- [#11727](https://github.com/apache/superset/pull/11727) chore: remove SIP_34_ANNOTATIONS_UI feature flag (#11727) (@lilykuang)
- [#11704](https://github.com/apache/superset/pull/11704) feat(templating): Safer Jinja template processing (#11704) (@robdiciuccio)
- [#11692](https://github.com/apache/superset/pull/11692) Fix "Select all" option in SelectControl (#11692) (@kgabryje)
- [#11719](https://github.com/apache/superset/pull/11719) Fix ModalTriggers styling in SqlLab (#11719) (@kgabryje)
- [#11670](https://github.com/apache/superset/pull/11670) feat: new import commands for dataset and databases (#11670) (@betodealmeida)
- [#11693](https://github.com/apache/superset/pull/11693) Remove "required" from SaveModal Add to dashboard field (#11693) (@kgabryje)
- [#11684](https://github.com/apache/superset/pull/11684) fix: default dashboard/chart cards are vector with perfect corners (#11684) (@rusackas)
- [#11707](https://github.com/apache/superset/pull/11707) Switching Docker compose over to the official image (#11707) (@craig-rueda)
- [#11701](https://github.com/apache/superset/pull/11701) chore: statds metrics for cache invalidation (#11701) (@bkyryliuk)
- [#11685](https://github.com/apache/superset/pull/11685) chore: V1 charts load cypress tests (#11685) (@adam-stasiak)
- [#11698](https://github.com/apache/superset/pull/11698) build(cypress): Fix issue with cypress code-coverage plugin when running locally (#11698) (@robdiciuccio)
- [#11676](https://github.com/apache/superset/pull/11676) chore: remove a few obsolete logic (#11676) (@graceguo-supercat)
- [#11691](https://github.com/apache/superset/pull/11691) Fix overflow hidden issues in Dashboard Builder tabs (#11691) (@kgabryje)
- [#11509](https://github.com/apache/superset/pull/11509) feat: rename TABLE_NAMES_CACHE_CONFIG to DATA_CACHE_CONFIG (#11509) (@ktmud)
- [#11700](https://github.com/apache/superset/pull/11700) feat: Helm improvements (#11700) (@craig-rueda)
- [#11679](https://github.com/apache/superset/pull/11679) fix(saved query): handle null sql field (#11679) (@nytai)
- [#11616](https://github.com/apache/superset/pull/11616) feat: Adding docker build/push (#11616) (@craig-rueda)
- [#11618](https://github.com/apache/superset/pull/11618) feat: keep modal open when saving database failed (#11618) (@ktmud)
- [#11671](https://github.com/apache/superset/pull/11671) fix: Dropdown menu not closing on Dashboard view (#11671) (@kgabryje)
- [#11613](https://github.com/apache/superset/pull/11613) docs: add support for Google Analytics on superset.apache.org (#11613) (@mistercrunch)
- [#11574](https://github.com/apache/superset/pull/11574) feat: Query History CRUD list view (#11574) (@nytai)
- [#11606](https://github.com/apache/superset/pull/11606) feat: new reports models api (#11606) (@dpgaspar)
- [#11672](https://github.com/apache/superset/pull/11672) fix(dashboard): ordering for add chart widget (#11672) (@nytai)
- [#11661](https://github.com/apache/superset/pull/11661) fix (dashboard): remove default filters parameters in dashboard url (#11661) (@graceguo-supercat)
- [#11673](https://github.com/apache/superset/pull/11673) fix: make higher chart box resizable (#11673) (@kkucharc)
- [#11289](https://github.com/apache/superset/pull/11289) keep placeholder on multiselect (#11289) (@eschutho)
- [#11663](https://github.com/apache/superset/pull/11663) chore: clean up a debug line from #11653 (#11663) (@ktmud)
- [#11199](https://github.com/apache/superset/pull/11199) feat: add ECharts BoxPlot chart (#11199) (@villebro)
- [#11653](https://github.com/apache/superset/pull/11653) fix: database connection validation when creation (#11653) (@ktmud)
- [#11533](https://github.com/apache/superset/pull/11533) chore: consolidate datasource import logic (#11533) (@betodealmeida)
- [#11643](https://github.com/apache/superset/pull/11643) Restructure chart header to wrap nicely (#11643) (@kgabryje)
- [#11529](https://github.com/apache/superset/pull/11529) chore: consolidate dashboard import logic (#11529) (@betodealmeida)
- [#11652](https://github.com/apache/superset/pull/11652) add import icon (#11652) (@eschutho)
- [#11644](https://github.com/apache/superset/pull/11644) build: set actions/setup-python to v2 (#11644) (@ktmud)
- [#11648](https://github.com/apache/superset/pull/11648) feat(dev): dont override asset manifest in dev-server (#11648) (@ktmud)
- [#11655](https://github.com/apache/superset/pull/11655) [fix] handle null value in date filter (#11655) (@graceguo-supercat)
- [#11656](https://github.com/apache/superset/pull/11656) fix(chart-data): ignore orderby on sample result type (#11656) (@villebro)
- [#11649](https://github.com/apache/superset/pull/11649) fix(saved-query): handle case where sql_tables in undefined (#11649) (@nytai)
- [#11650](https://github.com/apache/superset/pull/11650) style: various little tweaks to home screen stylin' (#11650) (@rusackas)
- [#11646](https://github.com/apache/superset/pull/11646) chore: pin node and npm versions (#11646) (@ktmud)
- [#11626](https://github.com/apache/superset/pull/11626) feat(sankey-viz): allow sort by metric and bump superset-ui packages (#11626) (@ktmud)
- [#11603](https://github.com/apache/superset/pull/11603) build(deps-dev): update cypress to 5.5.0, improvements for running locally (#11603) (@robdiciuccio)
- [#11458](https://github.com/apache/superset/pull/11458) chore: enabled cypress test in filter file (#11458) (@adam-stasiak)
- [#11535](https://github.com/apache/superset/pull/11535) refactor: Remove reactable arc (#11535) (@kgabryje)
- [#11584](https://github.com/apache/superset/pull/11584) Enabled artifacts for failing tests (#11584) (@adam-stasiak)
- [#11636](https://github.com/apache/superset/pull/11636) chore: rename IMPORT_EXPORT_VERSION (#11636) (@betodealmeida)
- [#11638](https://github.com/apache/superset/pull/11638) fix: card thumbnails now always show border. (#11638) (@rusackas)
- [#11521](https://github.com/apache/superset/pull/11521) Chore: simplify Apache Kylin datetime convert (#11521) (@zhaoyongjie)
- [#11635](https://github.com/apache/superset/pull/11635) fix: CommandInvalidError had invalid init (#11635) (@betodealmeida)
- [#11630](https://github.com/apache/superset/pull/11630) Disabled bubble test (#11630) (@adam-stasiak)
- [#11632](https://github.com/apache/superset/pull/11632) fix: js unit test when save dash (#11632) (@graceguo-supercat)
- [#11631](https://github.com/apache/superset/pull/11631) style: fixing tall filter indicators (#11631) (@rusackas)
- [#11592](https://github.com/apache/superset/pull/11592) feat(dashboard): leaner filter indicator panel with wrapped text (#11592) (@suddjian)
- [#11621](https://github.com/apache/superset/pull/11621) Fix datetime picker issues (#11621) (@kgabryje)
- [#11614](https://github.com/apache/superset/pull/11614) fix(dashboard): use server-side lastModifiedTime for co-edit check (#11614) (@graceguo-supercat)
- [#11540](https://github.com/apache/superset/pull/11540) feat: annotation delete modal, bulk delete and empty state (#11540) (@lilykuang)
- [#11570](https://github.com/apache/superset/pull/11570) fix: minor style touch on dashboards (#11570) (@ktmud)
- [#11569](https://github.com/apache/superset/pull/11569) chore: clean up mountedTab (#11569) (@ktmud)
- [#11583](https://github.com/apache/superset/pull/11583) Fixed unstable test (#11583) (@adam-stasiak)
- [#11525](https://github.com/apache/superset/pull/11525) fix: extended droppable area on the top of dashboards (#11525) (@kkucharc)
- [#11597](https://github.com/apache/superset/pull/11597) build(deps-dev): bump less from 3.9.0 to 3.12.2 in /superset-frontend (#11597) (@dependabot[bot])
- [#11564](https://github.com/apache/superset/pull/11564) chore: cleaning out old deckgl controls (#11564) (@rusackas)
- [#11557](https://github.com/apache/superset/pull/11557) chore(home-screen): fixes for loading states, flicker issue, and reduction of api calls (#11557) (@pkdotson)
- [#11607](https://github.com/apache/superset/pull/11607) fix: Filter and Metric popovers not closing after clicking Save (#11607) (@kgabryje)
- [#11602](https://github.com/apache/superset/pull/11602) style: Wrap chart titles again (#11602) (@rusackas)
- [#11594](https://github.com/apache/superset/pull/11594) fix(dashboard): order charts by changed_on (#11594) (@nytai)
- [#11550](https://github.com/apache/superset/pull/11550) feat: new report schedule models (#11550) (@dpgaspar)
- [#11578](https://github.com/apache/superset/pull/11578) fix: Issues with filters and metrics popovers (#11578) (@kgabryje)
- [#11554](https://github.com/apache/superset/pull/11554) refactor: Replace react-bootstrap MenuItems with Antd Menu (#11554) (@kgabryje)
- [#11579](https://github.com/apache/superset/pull/11579) Changed top overflow for charts. (#11579) (@kkucharc)
- [#11518](https://github.com/apache/superset/pull/11518) build(deps): bump @emotion/core in /superset-frontend (#11518) (@dependabot[bot])
- [#11573](https://github.com/apache/superset/pull/11573) build(deps-dev): bump @storybook/addon-essentials in /superset-frontend (#11573) (@dependabot[bot])
- [#11575](https://github.com/apache/superset/pull/11575) chore(rls): move to feature flag and disable related view (#11575) (@villebro)
- [#11522](https://github.com/apache/superset/pull/11522) build(deps): bump core-js from 3.2.1 to 3.6.5 in /superset-frontend (#11522) (@dependabot[bot])
- [#11314](https://github.com/apache/superset/pull/11314) chore: Cypress dashboard list selectors refactor (#11314) (@adam-stasiak)
- [#11555](https://github.com/apache/superset/pull/11555) refactor: Replace react-bootstrap MenuItems with Antd Menu (#11555) (@kgabryje)
- [#11558](https://github.com/apache/superset/pull/11558) fix(dashboard): properly unset mountedTab in  reducer (#11558) (@suddjian)
- [#11559](https://github.com/apache/superset/pull/11559) Front end for VERSIONED_EXPORT (#11559) (@betodealmeida)
- [#11445](https://github.com/apache/superset/pull/11445) fix: Pasting text issues in MetricsControl and AdhocFilterControl inputs (#11445) (@kgabryje)
- [#11487](https://github.com/apache/superset/pull/11487) refactor: Replace react-bootstrap MenuItems with Antd Menu (#11487) (@kgabryje)
- [#11311](https://github.com/apache/superset/pull/11311) style: database modal updates (#11311) (@riahk)
- [#11370](https://github.com/apache/superset/pull/11370) fix: add sort option to filters, sort chart list filter options (#11370) (@riahk)
- [#11551](https://github.com/apache/superset/pull/11551) docs: add Avesta to users list (#11551) (@TheRum)
- [#11527](https://github.com/apache/superset/pull/11527) refactor: Replace react-bootstrap dialogs with Antd dialogs (#11527) (@kgabryje)
- [#11531](https://github.com/apache/superset/pull/11531) chore: remove directory importexport (#11531) (@betodealmeida)
- [#11528](https://github.com/apache/superset/pull/11528) refactor: Use Antd Menu in Menu component (#11528) (@kgabryje)
- [#11530](https://github.com/apache/superset/pull/11530) feat: annotation layers delete logic + linking w/ annotation view (#11530) (@riahk)
- [#11500](https://github.com/apache/superset/pull/11500) feat: annotation edit modal with antd datepicker (#11500) (@lilykuang)
- [#11526](https://github.com/apache/superset/pull/11526) fix(tests): flaky test with dttm on Query API (#11526) (@dpgaspar)
- [#11361](https://github.com/apache/superset/pull/11361) docs: add Xendit to users list (#11361) (@LieAlbertTriAdrian)
- [#11502](https://github.com/apache/superset/pull/11502) refactor: reduce number of api calls needed to fetch favorite status for charts and dashboards (#11502) (@nytai)
- [#11532](https://github.com/apache/superset/pull/11532) chore: remove sanitize (#11532) (@betodealmeida)
- [#11435](https://github.com/apache/superset/pull/11435) refactor: rewrite and enhance chart control withVerification (#11435) (@ktmud)
- [#11501](https://github.com/apache/superset/pull/11501) fix(dashboard): multiple lines and indentation when editing json (#11501) (@suddjian)
- [#11160](https://github.com/apache/superset/pull/11160) refactor: Replace react-bootstrap Tabs with Antd Tabs in DashboardBuilder (#11160) (@kgabryje)
- [#11476](https://github.com/apache/superset/pull/11476) fix: Update "View In SQL Lab" Flow to render source query from datasource object (#11476) (@hughhhh)
- [#11491](https://github.com/apache/superset/pull/11491) feat: globally disable underscore for links in menu items (#11491) (@ktmud)
- [#11389](https://github.com/apache/superset/pull/11389) refactor: Replace react-bootstrap Modals with Antd in Explore (#11389) (@kgabryje)
- [#11519](https://github.com/apache/superset/pull/11519) feat: make logo link point to welcome page (#11519) (@mistercrunch)
- [#11512](https://github.com/apache/superset/pull/11512) chore: run 'npm audit fix', bump react-syntax-highlighter (#11512) (@mistercrunch)
- [#11510](https://github.com/apache/superset/pull/11510) chore: add dependabot.yml config file (#11510) (@mistercrunch)
- [#11511](https://github.com/apache/superset/pull/11511) chore: bump pypi cryptography from 2.4.2 to 3.2.1 (#11511) (@mistercrunch)
- [#11482](https://github.com/apache/superset/pull/11482) feat: query REST API more fields and tests (#11482) (@dpgaspar)
- [#11118](https://github.com/apache/superset/pull/11118) refactor: Replace react-bootstrap tabs with Antd tabs (#11118) (@kgabryje)
- [#11494](https://github.com/apache/superset/pull/11494) feat: annotation layers modal + filters (#11494) (@riahk)
- [#11485](https://github.com/apache/superset/pull/11485) build(deps-dev): bump node-fetch in /superset-frontend (#11485) (@dependabot[bot])
- [#11484](https://github.com/apache/superset/pull/11484) build(deps): bump object-path from 0.11.4 to 0.11.5 in /docs (#11484) (@dependabot[bot])
- [#11483](https://github.com/apache/superset/pull/11483) build(deps): bump lodash in /superset-frontend/cypress-base (#11483) (@dependabot[bot])
- [#11506](https://github.com/apache/superset/pull/11506) fix: import for moment in ActivityTable (#11506) (@pkdotson)
- [#11481](https://github.com/apache/superset/pull/11481) fix: show recent visited dashboards and charts in recent_activity (#11481) (@ktmud)
- [#11463](https://github.com/apache/superset/pull/11463) feat: create base class for export commands (#11463) (@betodealmeida)
- [#11450](https://github.com/apache/superset/pull/11450) feat: add certifications to tables (#11450) (@etr2460)
- [#11460](https://github.com/apache/superset/pull/11460) chore: rename ImportMixin to ImportExportMixin (#11460) (@betodealmeida)
- [#11447](https://github.com/apache/superset/pull/11447) feat: add endpoint to export saved queries using new format (#11447) (@betodealmeida)
- [#11504](https://github.com/apache/superset/pull/11504) docs: fix db drivers PG and ES (#11504) (@dpgaspar)
- [#11503](https://github.com/apache/superset/pull/11503) fix(api): don't log db conn failures on db create/update (#11503) (@dpgaspar)
- [#11206](https://github.com/apache/superset/pull/11206) feat: home screen mvp  (#11206) (@pkdotson)
- [#11496](https://github.com/apache/superset/pull/11496) chore: Cleaning up ENABLE_REACT_CRUD_VIEWS config (#11496) (@john-bodley)
- [#11493](https://github.com/apache/superset/pull/11493) feat: disable save button when saving datasource (#11493) (@ktmud)
- [#11307](https://github.com/apache/superset/pull/11307) other: Improvements to bug report template (#11307) (@suddjian)
- [#11497](https://github.com/apache/superset/pull/11497) Revert "fix: change chart title by clicking (#11335)" (#11497) (@graceguo-supercat)
- [#11449](https://github.com/apache/superset/pull/11449) fix: prevent race condition when canceling query (#11449) (@betodealmeida)
- [#11452](https://github.com/apache/superset/pull/11452) fix(datasets): add custom filter for virtual datasets based on sql attribute (#11452) (@nytai)
- [#11456](https://github.com/apache/superset/pull/11456) Added z index to resizible char (#11456) (@kkucharc)
- [#11281](https://github.com/apache/superset/pull/11281) feat(explore): change save button text when users cannot override (#11281) (@ktmud)
- [#11480](https://github.com/apache/superset/pull/11480) fix: dashboard tab only shows move cursor when editing (#11480) (@rusackas)
- [#11473](https://github.com/apache/superset/pull/11473) Add IBM Cloud deployment guide (#11473) (@aklin)
- [#11474](https://github.com/apache/superset/pull/11474) fix: Unwinds icon fallout that came along with filters PR (#11474) (@rusackas)
- [#10936](https://github.com/apache/superset/pull/10936) feat(dashboards): Filter status indicators (#10936) (@suddjian)
- [#11432](https://github.com/apache/superset/pull/11432) feat: annotation layers CRUD list view (#11432) (@riahk)
- [#11390](https://github.com/apache/superset/pull/11390) refactor: Replace react-bootstrap Modals with Antd in Datasource (#11390) (@kgabryje)
- [#11446](https://github.com/apache/superset/pull/11446) feat: annotations list CRUD view (#11446) (@lilykuang)
- [#11459](https://github.com/apache/superset/pull/11459) Disabled chaning caret (#11459) (@kkucharc)
- [#11457](https://github.com/apache/superset/pull/11457) docs: improve docs and update apache release scripts (#11457) (@dpgaspar)
- [#11455](https://github.com/apache/superset/pull/11455) enabled skipped tests in AdhocMetrics Cypress (#11455) (@adam-stasiak)
- [#11428](https://github.com/apache/superset/pull/11428) fix: Explore popovers issues (#11428) (@kgabryje)
- [#11437](https://github.com/apache/superset/pull/11437) fix: add init.py to the annotations module (#11437) (@bkyryliuk)
- [#11401](https://github.com/apache/superset/pull/11401) fix: a space adds the space. (#11401) (@rusackas)
- [#11453](https://github.com/apache/superset/pull/11453) fix: Fixing broken Cypress test (#11453) (@rusackas)
- [#11366](https://github.com/apache/superset/pull/11366) refactor: Use Antd Modals instead of react-bootstrap Modals (#11366) (@kgabryje)
- [#11309](https://github.com/apache/superset/pull/11309) chore: cypress selectors refactor in explore module (#11309) (@adam-stasiak)
- [#11312](https://github.com/apache/superset/pull/11312) chore: Cypress chart selectors refactor (#11312) (@adam-stasiak)
- [#11414](https://github.com/apache/superset/pull/11414) fix: [email report] add multiple schedules per hour (#11414) (@graceguo-supercat)
- [#11397](https://github.com/apache/superset/pull/11397) feat: add UUID column to saved_query for export/import (#11397) (@betodealmeida)
- [#11439](https://github.com/apache/superset/pull/11439) fix filter highlighting (#11439) (@suddjian)
- [#11444](https://github.com/apache/superset/pull/11444) fix: bump FAB to 3.1.1 (#11444) (@dpgaspar)
- [#11407](https://github.com/apache/superset/pull/11407) fix: added meaningful exception for loading births error (#11407) (@kkucharc)
- [#11315](https://github.com/apache/superset/pull/11315) chore: Update testconn logic (#11315) (@john-bodley)
- [#10645](https://github.com/apache/superset/pull/10645) feat: enable metadata sync for virtual tables (#10645) (@villebro)
- [#11429](https://github.com/apache/superset/pull/11429) fix: is_temporal should be overridden by is_dttm value (#11429) (@villebro)
- [#11427](https://github.com/apache/superset/pull/11427) Moved css of inline inputs of DateFilterControl to css of FilterBox where it appears. (#11427) (@kkucharc)
- [#11412](https://github.com/apache/superset/pull/11412) fix: multiple issues with FilterPopover (#11412) (@mistercrunch)
- [#11327](https://github.com/apache/superset/pull/11327) Configured babel plugin for removing data-test from production code (#11327) (@adam-stasiak)
- [#11424](https://github.com/apache/superset/pull/11424) feat(explore): update the order of datasource dropdown menu (#11424) (@hughhhh)
- [#11371](https://github.com/apache/superset/pull/11371) feat: hide datasource legacy based on featureflag (#11371) (@hughhhh)
- [#11382](https://github.com/apache/superset/pull/11382) fix: better error messages for dashboard properties modal (#11382) (@nytai)
- [#11430](https://github.com/apache/superset/pull/11430) fix: saved query list sort by database (#11430) (@nytai)
- [#11433](https://github.com/apache/superset/pull/11433) build: disable pr reviews for pr-lint action (#11433) (@nytai)
- [#11381](https://github.com/apache/superset/pull/11381) fix: better error message for chart properties modal (#11381) (@nytai)
- [#10724](https://github.com/apache/superset/pull/10724) Let the header wrap! (#10724) (@rusackas)
- [#11330](https://github.com/apache/superset/pull/11330) refactor: Use Modals from Antd instead of react-bootstrap (#11330) (@kgabryje)
- [#11391](https://github.com/apache/superset/pull/11391) feat: saved queries with execution info (#11391) (@dpgaspar)
- [#11392](https://github.com/apache/superset/pull/11392) fix: keeping Markdown content while resizing window on Dashboard (#11392) (@kkucharc)
- [#11423](https://github.com/apache/superset/pull/11423) Moved frame from below to currently focused window (#11423) (@kkucharc)
- [#11239](https://github.com/apache/superset/pull/11239) refactor: Replace usages of reactable in TimeTable (#11239) (@kgabryje)
- [#11417](https://github.com/apache/superset/pull/11417) fix(examples): specify 'time_range_endpoints' to prevent toast warning (#11417) (@mistercrunch)
- [#11422](https://github.com/apache/superset/pull/11422) docs: Update Dremio doc with Arrow Flight connection details (#11422) (@narendrans)
- [#11421](https://github.com/apache/superset/pull/11421) chore: upgrade TypeScript (3.8.3 -> 4.0.3) (#11421) (@ktmud)
- [#11415](https://github.com/apache/superset/pull/11415) style: fix labels vertical align (#11415) (@mistercrunch)
- [#11420](https://github.com/apache/superset/pull/11420) fix: error handling for webpack proxy (#11420) (@ktmud)
- [#11416](https://github.com/apache/superset/pull/11416) refactor: typing for explore Control and messageToasts (#11416) (@ktmud)
- [#11336](https://github.com/apache/superset/pull/11336) feat(dashboard): fetch charts by owners instead of created_by (#11336) (@nytai)
- [#11375](https://github.com/apache/superset/pull/11375) chore: Fixed skipped cypress test - refresh dashboard function (#11375) (@adam-stasiak)
- [#11342](https://github.com/apache/superset/pull/11342) chore: Button cruft cleanup (#11342) (@rusackas)
- [#11395](https://github.com/apache/superset/pull/11395) refactor: Use Antd Dropdown instead of react-bootstrap in DatasourceControl (#11395) (@kgabryje)
- [#11344](https://github.com/apache/superset/pull/11344) feat: annotations REST API (#11344) (@dpgaspar)
- [#11396](https://github.com/apache/superset/pull/11396) fix dataset editor for saving schema (#11396) (@lilykuang)
- [#11351](https://github.com/apache/superset/pull/11351) feat: export dashboards as ZIP files (#11351) (@betodealmeida)
- [#11400](https://github.com/apache/superset/pull/11400) fix: long labels now truncate with ellipsis (#11400) (@rusackas)
- [#11398](https://github.com/apache/superset/pull/11398) docs: Add semantic prefix info for PR titles (#11398) (@robdiciuccio)
- [#11335](https://github.com/apache/superset/pull/11335) fix: change chart title by clicking (#11335) (@lilykuang)
- [#11403](https://github.com/apache/superset/pull/11403) build: bump pr-lint-action (#11403) (@nytai)
- [#11129](https://github.com/apache/superset/pull/11129) docs: fix typo (#11129) (@curlup)
- [#10834](https://github.com/apache/superset/pull/10834) fix: dashboard edit/save errors (#10834) (@eschutho)
- [#11211](https://github.com/apache/superset/pull/11211) refactor: Replace react-bootstrap tabs with Antd tabs on Profile (#11211) (@kgabryje)
- [#11240](https://github.com/apache/superset/pull/11240) refactor: Replace usages of reactable in TableLoader (#11240) (@kgabryje)
- [#11376](https://github.com/apache/superset/pull/11376) build: let webpack proxy server handle more content encoding (#11376) (@ktmud)
- [#11369](https://github.com/apache/superset/pull/11369) fix: dashboard cache invalid join query (#11369) (@ktmud)
- [#11349](https://github.com/apache/superset/pull/11349) feat: export charts as ZIP files (#11349) (@betodealmeida)
- [#11332](https://github.com/apache/superset/pull/11332) feat: export datasets as ZIP files (#11332) (@betodealmeida)
- [#11383](https://github.com/apache/superset/pull/11383) style: improve the "Create New Chart" screen's usability (#11383) (@mistercrunch)
- [#11386](https://github.com/apache/superset/pull/11386) docs: add VLMedia to users list (#11386) (@iercan)
- [#11362](https://github.com/apache/superset/pull/11362) feat: add statsd metrics to FAB rest API post, put and delete (#11362) (@dpgaspar)
- [#11346](https://github.com/apache/superset/pull/11346) perf(api): improve API info performance (#11346) (@dpgaspar)
- [#11372](https://github.com/apache/superset/pull/11372) removing outlines on a few key elements (#11372) (@rusackas)
- [#11026](https://github.com/apache/superset/pull/11026) docs: Fix typo in installing from scratch (#11026) (@philipqnguyen)
- [#11334](https://github.com/apache/superset/pull/11334) chore(prophet): ignore logged warning for missing plotly package (#11334) (@villebro)
- [#11271](https://github.com/apache/superset/pull/11271) feat: CSS Templates List Actions (#11271) (@riahk)
- [#11367](https://github.com/apache/superset/pull/11367) Fix overflowing tabs (#11367) (@kgabryje)
- [#11374](https://github.com/apache/superset/pull/11374) Log warning for failure to get table/view names from DB (#11374) (@robdiciuccio)
- [#11354](https://github.com/apache/superset/pull/11354) style(sqllab): wrap text in monospace db-provided error messages (#11354) (@mistercrunch)
- [#11338](https://github.com/apache/superset/pull/11338) fix: 'Save Chart' modal's dashboard dropdown isn't sticky (#11338) (@mistercrunch)
- [#11355](https://github.com/apache/superset/pull/11355) style: make <Label/> not uppercase (#11355) (@mistercrunch)
- [#11340](https://github.com/apache/superset/pull/11340) feat: adding feature flags to escape/hide html in markdown (#11340) (@rusackas)
- [#11286](https://github.com/apache/superset/pull/11286) fix: saved_query search on schema and database not working (#11286) (@dpgaspar)
- [#11348](https://github.com/apache/superset/pull/11348) fix: Allow "EXPLAIN" queries when "Allow DML" setting is False (#11348) (@hughhhh)
- [#11337](https://github.com/apache/superset/pull/11337) fix(listview): hide actions column if no actions are allowed (#11337) (@nytai)
- [#11353](https://github.com/apache/superset/pull/11353) style: using correct + icon on New Query button (#11353) (@rusackas)
- [#11169](https://github.com/apache/superset/pull/11169) docs: add a roadmap page pointing to SIP-53 (#11169) (@mistercrunch)
- [#11274](https://github.com/apache/superset/pull/11274) fix: error around latest partition in BigQuery (#11274) (@mistercrunch)
- [#11227](https://github.com/apache/superset/pull/11227) style(menu): clean up right menu - leaving only "Settings" (#11227) (@mistercrunch)
- [#11343](https://github.com/apache/superset/pull/11343) Fix tabs switching in SouthPane (#11343) (@kgabryje)
- [#11296](https://github.com/apache/superset/pull/11296) feat: css template add/edit modal (#11296) (@lilykuang)
- [#11218](https://github.com/apache/superset/pull/11218) fix: update table_name and schema on dataset editor (#11218) (@lilykuang)
- [#11313](https://github.com/apache/superset/pull/11313) tests: Parameterize some tests in alerts_tests.py (#11313) (@hnle)
- [#11280](https://github.com/apache/superset/pull/11280) chore: Dashboard cypress refactor (#11280) (@adam-stasiak)
- [#11241](https://github.com/apache/superset/pull/11241) refactor: Replace usages of reactable in ChangeDatasourceModal (#11241) (@kgabryje)
- [#11163](https://github.com/apache/superset/pull/11163) refactor: Replace usages of Popover from react-bootstrap with Antd (#11163) (@kgabryje)
- [#11279](https://github.com/apache/superset/pull/11279) refactor: replace AvatarIcon instances with FacePile  (#11279) (@nytai)
- [#11290](https://github.com/apache/superset/pull/11290) tests: added fixtures to created dashboards and updated test with proper value (#11290) (@kkucharc)
- [#11333](https://github.com/apache/superset/pull/11333) Fix: bring back type ignore for config import (#11333) (@kkucharc)
- [#11326](https://github.com/apache/superset/pull/11326) fix(chart-api): cached-indicator always shows value is cached (#11326) (@villebro)
- [#11216](https://github.com/apache/superset/pull/11216) refactor: Refactor QueryTable to use react-table (#11216) (@kgabryje)
- [#11259](https://github.com/apache/superset/pull/11259) chore: make config ENABLE_REACT_CRUD_VIEWS = True by default (#11259) (@mistercrunch)
- [#11303](https://github.com/apache/superset/pull/11303) Fix overflowing tab's styling in TabbedSqlEditors (#11303) (@kgabryje)
- [#11229](https://github.com/apache/superset/pull/11229) feat: export databases as a ZIP bundle (#11229) (@betodealmeida)
- [#11305](https://github.com/apache/superset/pull/11305) fix: should update last_modified_time in client-side after save dash (#11305) (@graceguo-supercat)
- [#11300](https://github.com/apache/superset/pull/11300) fix CTAS and CVAS buttons invisible (#11300) (@zhaoyongjie)
- [#11294](https://github.com/apache/superset/pull/11294) feat: update time_compare description and choices (#11294) (@etr2460)
- [#11187](https://github.com/apache/superset/pull/11187) fix: button translations missing (#11187) (@rubenSastre)
- [#11293](https://github.com/apache/superset/pull/11293) fix: use dashboard id for stable cache key (#11293) (@ktmud)
- [#11278](https://github.com/apache/superset/pull/11278) fix: add schema name to datasource field in chart list (#11278) (@nytai)
- [#11287](https://github.com/apache/superset/pull/11287) fix: Fix styling in SqlLab when tabs overflow (#11287) (@kgabryje)
- [#11254](https://github.com/apache/superset/pull/11254) chore: Added data-test attributes for testing (#11254) (@adam-stasiak)
- [#11273](https://github.com/apache/superset/pull/11273) fix: delete the correct dashboard cache key (#11273) (@ktmud)
- [#11260](https://github.com/apache/superset/pull/11260) fix(query search): use new api to fetch users (#11260) (@nytai)
- [#11270](https://github.com/apache/superset/pull/11270) Revert "fix: keep placeholder in multivalue select when a value exists (#11181)" (#11270) (@etr2460)
- [#11249](https://github.com/apache/superset/pull/11249) Refactored api_tests in charts. Split filter test into several unit tests cases. Added table id based on database id (#11249) (@kkucharc)
- [#11217](https://github.com/apache/superset/pull/11217) refactor: Implement TableView component (#11217) (@kgabryje)
- [#11222](https://github.com/apache/superset/pull/11222) refactor: use contextmanager for event_logger decorators (#11222) (@ktmud)
- [#11256](https://github.com/apache/superset/pull/11256) docs: add note about migration in #11098 to Changelog (#11256) (@betodealmeida)
- [#11233](https://github.com/apache/superset/pull/11233) chore(engine): adapt postgres backend connection URI (#11233) (@zhaoyongjie)
- [#11261](https://github.com/apache/superset/pull/11261) docs: Add utair to list of companies using Apache Superset (#11261) (@dmitrijkir)
- [#11193](https://github.com/apache/superset/pull/11193) fix: do not import superset_config on tests (#11193) (@betodealmeida)
- [#11258](https://github.com/apache/superset/pull/11258) update dashboard edit modal (#11258) (@lilykuang)
- [#11234](https://github.com/apache/superset/pull/11234) perf: cache dashboard bootstrap data (#11234) (@ktmud)
- [#11252](https://github.com/apache/superset/pull/11252) fix: improve time compare range error (#11252) (@etr2460)
- [#11242](https://github.com/apache/superset/pull/11242) docs: don't link to database engine pages (#11242) (@mistercrunch)
- [#11181](https://github.com/apache/superset/pull/11181) fix: keep placeholder in multivalue select when a value exists (#11181) (@eschutho)
- [#11209](https://github.com/apache/superset/pull/11209) perf:  speed up uuid column generation (#11209) (@ktmud)
- [#11228](https://github.com/apache/superset/pull/11228) test: add admin to the owners of birth_names slices (#11228) (@ktmud)
- [#11246](https://github.com/apache/superset/pull/11246) fix: Ensure consistent naming for testconn (#11246) (@john-bodley)
- [#11210](https://github.com/apache/superset/pull/11210) fix: show TIME COLUMN options in dashboard (#11210) (@graceguo-supercat)
- [#11220](https://github.com/apache/superset/pull/11220) feat: prevent co-edit dashboard collision (#11220) (@graceguo-supercat)
- [#11244](https://github.com/apache/superset/pull/11244) chore: deprecate REDUCE_DASHBOARD_BOOTSTRAP_PAYLOAD (#11244) (@etr2460)
- [#11153](https://github.com/apache/superset/pull/11153) fix: questioning a few lines that force an ORDER clause (#11153) (@mistercrunch)
- [#11231](https://github.com/apache/superset/pull/11231) docs: Added Dremio to superset home page (#11231) (@narendrans)
- [#11223](https://github.com/apache/superset/pull/11223) chore: Leverage SQLALchemy ping rather than explicit SELECT 1 for testconn (#11223) (@john-bodley)
- [#11230](https://github.com/apache/superset/pull/11230) fix(cypress): table viz failed to run in postgres12 (#11230) (@zhaoyongjie)
- [#11225](https://github.com/apache/superset/pull/11225) fix: adding nofollow (#11225) (@rusackas)
- [#11212](https://github.com/apache/superset/pull/11212) refactor: Replace react-bootstrap tabs with Antd tabs in SqlLab (#11212) (@kgabryje)
- [#11179](https://github.com/apache/superset/pull/11179) chore: simplify alerting data model to leverage a single class  (#11179) (@bkyryliuk)
- [#11189](https://github.com/apache/superset/pull/11189) feat: CSS Templates List (#11189) (@riahk)
- [#11101](https://github.com/apache/superset/pull/11101) style(listview): various changes to get closer to SIP-34 designs (#11101) (@nytai)
- [#11214](https://github.com/apache/superset/pull/11214) Changed cache uid to be depending on table in test_csv_response_format (#11214) (@kkucharc)
- [#11213](https://github.com/apache/superset/pull/11213) test: test_cache_logging is not depending on other dashboard (#11213) (@kkucharc)
- [#11208](https://github.com/apache/superset/pull/11208) chore: Add __pycache__ to  gitignore (#11208) (@ktmud)
- [#11204](https://github.com/apache/superset/pull/11204) Fix typo "insode" -> "inside" (#11204) (@jharding-blw)
- [#11203](https://github.com/apache/superset/pull/11203) fix: revert eTag cache feature for dashboard (#11203) (@graceguo-supercat)
- [#11196](https://github.com/apache/superset/pull/11196) fix: skip unit test that is failing in master for test-postgres-hive (#11196) (@betodealmeida)
- [#11172](https://github.com/apache/superset/pull/11172) chore: turn SQL templating off by default (#11172) (@dpgaspar)
- [#11194](https://github.com/apache/superset/pull/11194) Revert "refactor: Replace react-bootstrap tabs with Antd tabs (#11090)" (#11194) (@john-bodley)
- [#11098](https://github.com/apache/superset/pull/11098) feat: add UUID column to ImportMixin (#11098) (@betodealmeida)
- [#11155](https://github.com/apache/superset/pull/11155) chore: cleanup FAB update perms (#11155) (@john-bodley)
- [#11131](https://github.com/apache/superset/pull/11131) test: removed unicode_test example from unit tests (#11131) (@kkucharc)
- [#11173](https://github.com/apache/superset/pull/11173) fix(viz): downgrade exception for missing viz/datasource (#11173) (@villebro)
- [#11180](https://github.com/apache/superset/pull/11180) fixed undefined names error (#11180) (@lilykuang)
- [#11164](https://github.com/apache/superset/pull/11164) fix: save query modal/button styling + convert to ant-d modal (#11164) (@riahk)
- [#11176](https://github.com/apache/superset/pull/11176) fix: cosmetic issue template (#11176) (@mistercrunch)
- [#11175](https://github.com/apache/superset/pull/11175) chore: remove SIP_34_SAVED_QUERIES_UI feature flag (#11175) (@lilykuang)
- [#11174](https://github.com/apache/superset/pull/11174) chore: add issue template for 'Cosmetic Issue' (#11174) (@mistercrunch)
- [#11168](https://github.com/apache/superset/pull/11168) fix: 📜 `/docs/api` won't render (#11168) (@mistercrunch)
- [#11170](https://github.com/apache/superset/pull/11170) style(dashboard): minor improvements to chart context menu (#11170) (@mistercrunch)
- [#11056](https://github.com/apache/superset/pull/11056) style: fix too light form labels in DatabaseModal + DRY css (#11056) (@mistercrunch)
- [#11075](https://github.com/apache/superset/pull/11075) style(sqllab): make database errors more clear and render as monospace (#11075) (@mistercrunch)
- [#11137](https://github.com/apache/superset/pull/11137) fix: enable consistent etag across workers and force no-cache for dashboards (#11137) (@ktmud)
- [#11055](https://github.com/apache/superset/pull/11055) chore: more 'datasource' -> 'dataset' renaming (#11055) (@mistercrunch)
- [#11108](https://github.com/apache/superset/pull/11108) Remove erroneous package-lock.json (#11108) (@robdiciuccio)
- [#11135](https://github.com/apache/superset/pull/11135) feat: saved query preview modal (#11135) (@lilykuang)
- [#11040](https://github.com/apache/superset/pull/11040) allow passing bash args into the pytest (#11040) (@amitmiran137)
- [#11152](https://github.com/apache/superset/pull/11152) docs: typo (#11152) (@jolange)
- [#11154](https://github.com/apache/superset/pull/11154) docs: add API page to docs using Swagger UI (#11154) (@mistercrunch)
- [#11143](https://github.com/apache/superset/pull/11143) chore: Remove obsolete creating missing metric permissions (#11143) (@john-bodley)
- [#11150](https://github.com/apache/superset/pull/11150) Revert "refactor: Remove usages of reactable from TimeTable (#11046)" (#11150) (@etr2460)
- [#11145](https://github.com/apache/superset/pull/11145) fix: fixing CI workflow (#11145) (@henryyeh)
- [#11058](https://github.com/apache/superset/pull/11058) fix: Enable ESLint rule default-props-match-prop-types (#11058) (@kgabryje)
- [#11120](https://github.com/apache/superset/pull/11120) fix: clean up prop type errors in jest tests (#11120) (@eschutho)
- [#11090](https://github.com/apache/superset/pull/11090) refactor: Replace react-bootstrap tabs with Antd tabs (#11090) (@kgabryje)
- [#10924](https://github.com/apache/superset/pull/10924) perf(explore): render datasource details only when needed (#10924) (@ktmud)
- [#11139](https://github.com/apache/superset/pull/11139) style: override ace edit error icon (#11139) (@nytai)

### 0.38.0 (Mon Nov 17 07:23:54 2020 +00:00)
- [#11724](https://github.com/apache/superset/pull/11724) fix: prior npm font source had a glitch (#11724) (@rusackas)
- [#11718](https://github.com/apache/superset/pull/11718) refactor: Load fonts from packages rather than local binaries (#11718) (@rusackas)
- [#11365](https://github.com/apache/superset/pull/11365) fix(sqla): allow 'unknown' type queries in explore view (#11365) (@serenajiang)
- [#11253](https://github.com/apache/superset/pull/11253) build: update webpack for npm linking plugins (#11253) (@ktmud)
- [#11469](https://github.com/apache/superset/pull/11469) docs(release): script to generate a CHANGELOG.md (#11469) (@dpgaspar)
- [#11393](https://github.com/apache/superset/pull/11393) chore(chart-data): add annotations and url params to chart data schema (#11393) (@villebro)
- [#11272](https://github.com/apache/superset/pull/11272) chore: upgrade vis plugins npm packages (#11272) (@ktmud)
- [#11149](https://github.com/apache/superset/pull/11149) fix: Fix Time Column dropdown for date filter (#11149) (@graceguo-supercat)
- [#11262](https://github.com/apache/superset/pull/11262) fix(crud): set default extra value (#11262) (@villebro)
- [#11221](https://github.com/apache/superset/pull/11221) fix(dataset): update user list endpoint (#11221) (@lilykuang)
- [#11237](https://github.com/apache/superset/pull/11237) feat(datasets): REST API bulk delete (#11237) (@dpgaspar)
- [#11236](https://github.com/apache/superset/pull/11236) chore(sqla): assert query is single read-only statement (#11236) (@villebro)
- [#11201](https://github.com/apache/superset/pull/11201) chore(sql-lab): catch PyArrow deserialization error (#11201) (@villebro)
- [#11141](https://github.com/apache/superset/pull/11141) fix(examples): missing expressions in birth_names (#11141) (@villebro)
- [#11136](https://github.com/apache/superset/pull/11136) fix: Alembic migration 18532d70ab98 (#11136) (@john-bodley)
- [#11140](https://github.com/apache/superset/pull/11140) docs: docs site footer link tweak (#11140) (@rusackas)
- [#11133](https://github.com/apache/superset/pull/11133) docs: comply to ASF requirements (#11133) (@mistercrunch)
- [#11124](https://github.com/apache/superset/pull/11124) add info about case sensitive search (#11124) (@eschutho)
- [#11111](https://github.com/apache/superset/pull/11111) style(listview): dynamic card size and grid spacing (#11111) (@nytai)
- [#11126](https://github.com/apache/superset/pull/11126) style: rename label 'table name'->'dataset name' (#11126) (@mistercrunch)
- [#11083](https://github.com/apache/superset/pull/11083) feat: custom favorite filter for dashboards, charts and saved queries (#11083) (@dpgaspar)
- [#11102](https://github.com/apache/superset/pull/11102) chore: refactor submenu's right nav to accept list of buttons (#11102) (@pkdotson)
- [#11132](https://github.com/apache/superset/pull/11132) docs: use the Apache-Superset logo on README / pypi (#11132) (@mistercrunch)
- [#11121](https://github.com/apache/superset/pull/11121) fix: remove extra flash import (#11121) (@eschutho)
- [#11125](https://github.com/apache/superset/pull/11125) fix: Revert "Replace reactable with DataTable from superset-ui in QueryTable (#10981)" (#11125) (@nytai)
- [#11115](https://github.com/apache/superset/pull/11115) fix: alembic migration error msg trying to delete constraint on tables (#11115) (@dpgaspar)
- [#11114](https://github.com/apache/superset/pull/11114) feat: CRUD REST API for CSS Templates (#11114) (@dpgaspar)
- [#11127](https://github.com/apache/superset/pull/11127) fix: SpatialControl popover won't open (#11127) (@mistercrunch)
- [#11109](https://github.com/apache/superset/pull/11109) feat: saved query list actions (#11109) (@riahk)
- [#11067](https://github.com/apache/superset/pull/11067) feat: add created by chart CRUD view (#11067) (@lilykuang)
- [#11107](https://github.com/apache/superset/pull/11107) fix: Disabling timezone of dataframe before passing Prophet (#11107) (@kkalyan)
- [#11112](https://github.com/apache/superset/pull/11112) fix(chart-data-api): ignore missing filters (#11112) (@villebro)
- [#11099](https://github.com/apache/superset/pull/11099) feat: more specific presto error messages (#11099) (@etr2460)
- [#11110](https://github.com/apache/superset/pull/11110) Fix alembic migration (#11110) (@bkyryliuk)
- [#11066](https://github.com/apache/superset/pull/11066) fix: fix table existence validation function (#11066) (@bkyryliuk)
- [#11100](https://github.com/apache/superset/pull/11100) style: fix secondary label border (#11100) (@rusackas)
- [#11005](https://github.com/apache/superset/pull/11005) feat: saved query list view + sort/filters (#11005) (@riahk)
- [#10972](https://github.com/apache/superset/pull/10972) chore: Remove Obsolete WARNING_MSG from config (#10972) (@john-bodley)
- [#10963](https://github.com/apache/superset/pull/10963) feat: enable ETag header for dashboard GET requests (#10963) (@graceguo-supercat)
- [#11045](https://github.com/apache/superset/pull/11045) Updated lint in schedules.py in tasks: unused_import, ungrouped_import and changed argument name to remove unused-argument (#11045) (@kkucharc)
- [#11019](https://github.com/apache/superset/pull/11019) fix(api): unable to delete virtual dataset, wrong permission name (#11019) (@dpgaspar)
- [#11103](https://github.com/apache/superset/pull/11103) fix: echarts timeseries groupby (#11103) (@villebro)
- [#11095](https://github.com/apache/superset/pull/11095) fix: double scroll bars on dataset editor (#11095) (@lilykuang)
- [#11059](https://github.com/apache/superset/pull/11059) docs: Add Zeta to list of companies using Apache Superset (#11059) (@shaikidris)
- [#11064](https://github.com/apache/superset/pull/11064) chore: pylint fixes in files in project's root (#11064) (@kkucharc)
- [#11062](https://github.com/apache/superset/pull/11062) chore: updated utils with pylint rules (#11062) (@kkucharc)
- [#10914](https://github.com/apache/superset/pull/10914) refactor: table selector on dataset editor (#10914) (@lilykuang)
- [#11015](https://github.com/apache/superset/pull/11015) Reorganize steps (#11015) (@brylie)
- [#11054](https://github.com/apache/superset/pull/11054) feat(charts): modify custom api filter to include more fields (#11054) (@nytai)
- [#11061](https://github.com/apache/superset/pull/11061) chore: Clean up some console warnings (#11061) (@kgabryje)
- [#11046](https://github.com/apache/superset/pull/11046) refactor: Remove usages of reactable from TimeTable (#11046) (@kgabryje)
- [#11012](https://github.com/apache/superset/pull/11012) refactor: Remove usages of reactable from AlteredSliceTag (#11012) (@kgabryje)
- [#11069](https://github.com/apache/superset/pull/11069) feat: improve presto query perf (#11069) (@etr2460)
- [#10971](https://github.com/apache/superset/pull/10971) style: improve "Datasource & Chart Type" <Label>s (#10971) (@mistercrunch)
- [#11086](https://github.com/apache/superset/pull/11086) docs: add changelog entries for 0.37.2 (#11086) (@villebro)
- [#11074](https://github.com/apache/superset/pull/11074) fix: Adding timeout to flaky cypress test, to wait for animation to complete (#11074) (@rusackas)
- [#11076](https://github.com/apache/superset/pull/11076) chore: cleaning out unused code from utils (#11076) (@rusackas)
- [#11077](https://github.com/apache/superset/pull/11077) fix: surface connection error messages on the client (#11077) (@mistercrunch)
- [#11079](https://github.com/apache/superset/pull/11079) fix(jest): using UTC mock date (#11079) (@zhaoyongjie)
- [#11072](https://github.com/apache/superset/pull/11072) removing unused component (#11072) (@rusackas)
- [#11073](https://github.com/apache/superset/pull/11073) changing to the correct hex color (#11073) (@rusackas)
- [#11071](https://github.com/apache/superset/pull/11071) style: remove unecessary padding (#11071) (@mistercrunch)
- [#11068](https://github.com/apache/superset/pull/11068) fix: database list checkboxes (#11068) (@riahk)
- [#11033](https://github.com/apache/superset/pull/11033) feat: adding all icons from the design system to the codebase (#11033) (@rusackas)
- [#11063](https://github.com/apache/superset/pull/11063) fix: sql lab autocomplete width (#11063) (@etr2460)
- [#11034](https://github.com/apache/superset/pull/11034) clickable labels have outlines, storybook shows them (#11034) (@rusackas)
- [#11052](https://github.com/apache/superset/pull/11052) fixed routes for customer in docs (#11052) (@srinify)
- [#11051](https://github.com/apache/superset/pull/11051) Revert "style: fix checkbox color (#10970)" (#11051) (@graceguo-supercat)
- [#11030](https://github.com/apache/superset/pull/11030) feat: add "created by" to dashboard CRUD view (#11030) (@lilykuang)
- [#11037](https://github.com/apache/superset/pull/11037) Changed `tags.py` and `helpers.py` in `models` module: removed disabled pylint rule `unused_import`, changed unused arguments to private and removed disabled rule `unused-argument. Removed redundant rules.` (#11037) (@kkucharc)
- [#11036](https://github.com/apache/superset/pull/11036) chore: updated lint rules in models module (#11036) (@kkucharc)
- [#11038](https://github.com/apache/superset/pull/11038) Removed disable global pytlint rule `standarderror-builtin` which isn't appearing for Python3 (#11038) (@kkucharc)
- [#11039](https://github.com/apache/superset/pull/11039) Enabled argument-differ for bulk_delete (#11039) (@kkucharc)
- [#11041](https://github.com/apache/superset/pull/11041) Enabled no-self-use pylint rule in security. Formatter (#11041) (@kkucharc)
- [#11044](https://github.com/apache/superset/pull/11044) Changed variable name from capitals to lowercase and changed lint rule (#11044) (@kkucharc)
- [#11050](https://github.com/apache/superset/pull/11050) Revert "ESLint: Re-enable rule default-props-match-prop-types (#10868)" (#11050) (@graceguo-supercat)
- [#11031](https://github.com/apache/superset/pull/11031) feat(saved_queries): add custom api filter for all string & text fields (#11031) (@nytai)
- [#11008](https://github.com/apache/superset/pull/11008) Support jinja templates (#11008) (@bkyryliuk)
- [#11018](https://github.com/apache/superset/pull/11018) chore: bump pandas to latest stable version (#11018) (@villebro)
- [#11029](https://github.com/apache/superset/pull/11029) fix: dashboard edit button (again) (#11029) (@graceguo-supercat)
- [#11011](https://github.com/apache/superset/pull/11011) style(explore): use tertiary button against gray background (#11011) (@mistercrunch)
- [#11023](https://github.com/apache/superset/pull/11023) docs: add security vulnerability GH issue template (#11023) (@robdiciuccio)
- [#11024](https://github.com/apache/superset/pull/11024) fix: [dashboard] should not show edit button when user has no edit permit (#11024) (@graceguo-supercat)
- [#11004](https://github.com/apache/superset/pull/11004) fix: timer component, fixes #10849, closes #11002 (#11004) (@ktmud)
- [#11000](https://github.com/apache/superset/pull/11000) fix: enable several pylint rules partially in db_engines_specs module (#11000) (@kkucharc)
- [#10974](https://github.com/apache/superset/pull/10974) fix: pylint checks in connectors/sqla/models.py (#10974) (@kkucharc)
- [#11014](https://github.com/apache/superset/pull/11014) fix: reenable pylint rule `unused-import` in charts and connectors modules (#11014) (@kkucharc)
- [#11016](https://github.com/apache/superset/pull/11016) Enabled pylint rules in `db_engines` module: (#11016) (@kkucharc)
- [#10978](https://github.com/apache/superset/pull/10978) fix: changes a pylint check in dashboard module (#10978) (@kkucharc)
- [#11009](https://github.com/apache/superset/pull/11009) fix: menu shows a 0 when there are not settings (#11009) (@nytai)
- [#11017](https://github.com/apache/superset/pull/11017) fix: query search low privileged user search access denied (#11017) (@dpgaspar)
- [#10994](https://github.com/apache/superset/pull/10994) chore: downgrade expected exception from error to info (#10994) (@nytai)
- [#10983](https://github.com/apache/superset/pull/10983) fix: Add Item Overflow on Dataset Editor (#10983) (@lilykuang)
- [#11007](https://github.com/apache/superset/pull/11007) Bring back import menu (#11007) (@betodealmeida)
- [#10986](https://github.com/apache/superset/pull/10986) feat(listview): feature flag config to set default viewing mode (#10986) (@nytai)
- [#11006](https://github.com/apache/superset/pull/11006) build: add react-hooks linting (#11006) (@ktmud)
- [#11003](https://github.com/apache/superset/pull/11003) fix: unbreak ci (#11003) (@etr2460)
- [#10998](https://github.com/apache/superset/pull/10998) fix: enable pylint rules in db_engine_specs module (#10998) (@kkucharc)
- [#10981](https://github.com/apache/superset/pull/10981) Replace reactable with DataTable from superset-ui in QueryTable (#10981) (@kgabryje)
- [#10868](https://github.com/apache/superset/pull/10868) ESLint: Re-enable rule default-props-match-prop-types (#10868) (@kgabryje)
- [#10966](https://github.com/apache/superset/pull/10966) feat: add ECharts Pie chart (#10966) (@villebro)
- [#10991](https://github.com/apache/superset/pull/10991) Enable subqueries in gsheetsdb (#10991) (@betodealmeida)
- [#10710](https://github.com/apache/superset/pull/10710) fix: deprecation warnings due to invalid escape sequences. (#10710) (@tirkarthi)
- [#10753](https://github.com/apache/superset/pull/10753) fix(presto): default unknown types to string type (#10753) (@villebro)
- [#10946](https://github.com/apache/superset/pull/10946) feat(row-level-security): add base filter type and filter grouping (#10946) (@villebro)
- [#10988](https://github.com/apache/superset/pull/10988) docs: add gallery screenshot & link in README (#10988) (@mistercrunch)
- [#10968](https://github.com/apache/superset/pull/10968) docs: add a "Gallery" page (#10968) (@mistercrunch)
- [#10990](https://github.com/apache/superset/pull/10990) build: add PR lint action (#10990) (@nytai)
- [#10989](https://github.com/apache/superset/pull/10989) adding filters back that caused issues (#10989) (@rusackas)
- [#10944](https://github.com/apache/superset/pull/10944) chore: selectors refactor in SQLLab test suite (Cypress) (#10944) (@adam-stasiak)
- [#10933](https://github.com/apache/superset/pull/10933) ESLint: Remove ts-ignore comments (#10933) (@kgabryje)
- [#10970](https://github.com/apache/superset/pull/10970) style: fix checkbox color (#10970) (@mistercrunch)
- [#10979](https://github.com/apache/superset/pull/10979) fix: changed disabled rules in datasets module (#10979) (@kkucharc)
- [#10829](https://github.com/apache/superset/pull/10829) fix: update the time filter for 'Last Year' option in explore (#10829) (@riahk)
- [#10938](https://github.com/apache/superset/pull/10938) fix: use nullpool even for user lookup in the celery (#10938) (@bkyryliuk)
- [#10939](https://github.com/apache/superset/pull/10939) Allow empty observations in alerting (#10939) (@bkyryliuk)
- [#10957](https://github.com/apache/superset/pull/10957) fix: re-enabling several globally disabled lint rules (#10957) (@kkucharc)
- [#10942](https://github.com/apache/superset/pull/10942) fix: setting specific exceptions common/query_context.py (#10942) (@kkucharc)
- [#10975](https://github.com/apache/superset/pull/10975) Pylint disabled rule `pointless-string-statement` is not raising warining anymore - removing (#10975) (@kkucharc)
- [#10976](https://github.com/apache/superset/pull/10976) fix: pylint disabled rules in dashboard/api.py (#10976) (@kkucharc)
- [#10958](https://github.com/apache/superset/pull/10958) fix: removed disabled lint rule `too-many-locals` in connectors/base/models.py (#10958) (@kkucharc)
- [#10870](https://github.com/apache/superset/pull/10870) ESLint: Re-enable rule no-access-state-in-setstate (#10870) (@kgabryje)
- [#10879](https://github.com/apache/superset/pull/10879) ESLint: Enable rule no-named-as-default (#10879) (@kgabryje)
- [#10961](https://github.com/apache/superset/pull/10961) ESLint: Remove ts-ignore (#10961) (@kgabryje)
- [#10921](https://github.com/apache/superset/pull/10921) docs: set up client-side redirects from previous era docs urls (#10921) (@srinify)
- [#10949](https://github.com/apache/superset/pull/10949) Ignore '/docs' on some GH actions, give docs its own action (#10949) (@rusackas)
- [#10959](https://github.com/apache/superset/pull/10959) fix: typo in prefer typescript (#10959) (@ktmud)
- [#10889](https://github.com/apache/superset/pull/10889) ESLint: no-restricted-syntax (#10889) (@kgabryje)
- [#10909](https://github.com/apache/superset/pull/10909) fix: several disabled pylint rules in models/helpers.py (#10909) (@kkucharc)
- [#10941](https://github.com/apache/superset/pull/10941) fix: update pylint disabled checks in common/query_context.py (#10941) (@kkucharc)
- [#10906](https://github.com/apache/superset/pull/10906) Updated `type: ignore` in model's helper: (#10906) (@kkucharc)
- [#10923](https://github.com/apache/superset/pull/10923) chore: upgrade cypress to use retries (#10923) (@eschutho)
- [#10926](https://github.com/apache/superset/pull/10926) chore: remove SIP_34_DATABASE_UI (#10926) (@nytai)
- [#10932](https://github.com/apache/superset/pull/10932) fix: address all disabled pylint checks in charts/api.py (#10932) (@kkucharc)
- [#10915](https://github.com/apache/superset/pull/10915) Removed global pylintrc rule: old-ne-operator. Which is not applicable in code anymore. (#10915) (@kkucharc)
- [#10922](https://github.com/apache/superset/pull/10922) feat: update saved query backend routing + add savedquery list (#10922) (@riahk)
- [#10911](https://github.com/apache/superset/pull/10911) Removed disabled linting redefined-outer-name. Url parameters are renamed where url was already defined in class attributes (#10911) (@kkucharc)
- [#10840](https://github.com/apache/superset/pull/10840) feat: adding dashboard toggle fullscreen button (#10840) (@zhaoyongjie)
- [#10918](https://github.com/apache/superset/pull/10918) fix lint errors (#10918) (@eschutho)
- [#10902](https://github.com/apache/superset/pull/10902) fix: babel script broken by format string (#10902) (@zhaoyongjie)
- [#10848](https://github.com/apache/superset/pull/10848) Update FOSSA configuration for new requirements layout (#10848) (@robdiciuccio)
- [#10908](https://github.com/apache/superset/pull/10908) Enable anchor-has-content rule (#10908) (@kgabryje)
- [#10898](https://github.com/apache/superset/pull/10898) docs: Client side redirects (one POC) (#10898) (@rusackas)
- [#10847](https://github.com/apache/superset/pull/10847) chore: update port that cypress runs on for local vs test (#10847) (@eschutho)
- [#10799](https://github.com/apache/superset/pull/10799) feat: use svg for checkbox component (#10799) (@eschutho)
- [#10897](https://github.com/apache/superset/pull/10897) fix:  front end CI tests and test runner (#10897) (@eschutho)
- [#10891](https://github.com/apache/superset/pull/10891) fix: superset alerting misc fixes (#10891) (@bkyryliuk)
- [#10882](https://github.com/apache/superset/pull/10882) simplifying/clarifying youtube video code/datastructures (#10882) (@rusackas)
- [#10886](https://github.com/apache/superset/pull/10886) Fixing docs site home screen mobile layout issues (#10886) (@rusackas)
- [#10912](https://github.com/apache/superset/pull/10912) fix: spelling in docs homepage (#10912) (@etr2460)
- [#10903](https://github.com/apache/superset/pull/10903) docs: add back issue code links (#10903) (@mistercrunch)
- [#10901](https://github.com/apache/superset/pull/10901) build: optimize eslint import resolver configs (#10901) (@ktmud)
- [#10900](https://github.com/apache/superset/pull/10900) docs: redirect http -> https (#10900) (@mistercrunch)
- [#10875](https://github.com/apache/superset/pull/10875) refactor: ASF only dependencies on base.txt (#10875) (@dpgaspar)
- [#10893](https://github.com/apache/superset/pull/10893) docs: add changelog entries for 0.37.1 (#10893) (@villebro)
- [#10899](https://github.com/apache/superset/pull/10899) correcting 2 steps in docs deployment readme (#10899) (@rusackas)
- [#10895](https://github.com/apache/superset/pull/10895) chore: enable eslint-import-resolver-typescript (#10895) (@ktmud)
- [#10880](https://github.com/apache/superset/pull/10880) feat: data menu routing (#10880) (@riahk)
- [#10892](https://github.com/apache/superset/pull/10892) fix(cypress): prevent CI failure on codecov failure (#10892) (@nytai)
- [#10837](https://github.com/apache/superset/pull/10837) feat: move ace-editor and mathjs to async modules (#10837) (@ktmud)
- [#10885](https://github.com/apache/superset/pull/10885) fixing broken links (#10885) (@rusackas)
- [#10887](https://github.com/apache/superset/pull/10887) chore: Using cache factory method (#10887) (@john-bodley)
- [#10761](https://github.com/apache/superset/pull/10761) feat: implement cache invalidation api (#10761) (@bkyryliuk)
- [#10888](https://github.com/apache/superset/pull/10888) docs: fix ubuntu 20.04 installation instructions (#10888) (@villebro)
- [#10884](https://github.com/apache/superset/pull/10884) fix(cypress): wait for filterValues request (#10884) (@nytai)
- [#10877](https://github.com/apache/superset/pull/10877) Reviewed and repaired disabled pylint in dashboard file (#10877) (@kkucharc)
- [#10844](https://github.com/apache/superset/pull/10844) Feat: Adding table comment and columns comment for SQLLab (#10844) (@zhaoyongjie)
- [#10883](https://github.com/apache/superset/pull/10883) chore: clean up aphrodite (#10883) (@ktmud)
- [#10865](https://github.com/apache/superset/pull/10865) ESLint: Re-enable rule no-unused-vars (#10865) (@kgabryje)
- [#10862](https://github.com/apache/superset/pull/10862) Re-enable rule line-between-class-members (#10862) (@kgabryje)
- [#10873](https://github.com/apache/superset/pull/10873) Re-enable rule state-in-constructor (#10873) (@kgabryje)
- [#10866](https://github.com/apache/superset/pull/10866) ESLint: Re-enable rule control-has-associated-label (#10866) (@kgabryje)
- [#10861](https://github.com/apache/superset/pull/10861) Re-enable rule no-else-return (#10861) (@kgabryje)
- [#10876](https://github.com/apache/superset/pull/10876) Enable rule no-plusplus (#10876) (@kgabryje)
- [#10853](https://github.com/apache/superset/pull/10853) docs(style): make more responsive for mobile (#10853) (@mistercrunch)
- [#10872](https://github.com/apache/superset/pull/10872) Re-enable rule sort-comp (#10872) (@kgabryje)
- [#10869](https://github.com/apache/superset/pull/10869) Re-enable rule jsx-curly-brace-presence (#10869) (@kgabryje)
- [#10864](https://github.com/apache/superset/pull/10864) Re-enable rule no-non-null-assertion (#10864) (@kgabryje)
- [#10863](https://github.com/apache/superset/pull/10863) ESLint: Re-enable rule no-restricted-globals (#10863) (@kgabryje)
- [#10860](https://github.com/apache/superset/pull/10860) Re-enable no-useless-path-segments rule (#10860) (@kgabryje)
- [#10871](https://github.com/apache/superset/pull/10871) Re-enable rule no-unused-state (#10871) (@kgabryje)
- [#10867](https://github.com/apache/superset/pull/10867) Re-enable rule prefer-destructuring (only for objects) (#10867) (@kgabryje)
- [#10874](https://github.com/apache/superset/pull/10874) Re-enable no-confusing-arrow rule (#10874) (@kgabryje)
- [#10855](https://github.com/apache/superset/pull/10855) Adding editorconfig setting for IDE hints (#10855) (@zhaoyongjie)
- [#10859](https://github.com/apache/superset/pull/10859) Improvement contributing.md (#10859) (@zhaoyongjie)
- [#10839](https://github.com/apache/superset/pull/10839) Eslint dependencies versions updates (#10839) (@kgabryje)
- [#10850](https://github.com/apache/superset/pull/10850) feat: server side dashboard css for less repaint (#10850) (@ktmud)
- [#10846](https://github.com/apache/superset/pull/10846) Fix test_connection POST body (#10846) (@riahk)
- [#10851](https://github.com/apache/superset/pull/10851) style: white toolbar for SQL Lab (#10851) (@mistercrunch)
- [#10784](https://github.com/apache/superset/pull/10784) docs(new docs site): removes old sphinx doc site with gatsby (#10784) (@pkdotson)
- [#10745](https://github.com/apache/superset/pull/10745) feat: add/edit database modal form sections UI (#10745) (@riahk)
- [#10842](https://github.com/apache/superset/pull/10842) fix(test): missing auth on tests (#10842) (@dpgaspar)
- [#10841](https://github.com/apache/superset/pull/10841) update all python version in the Dockerfile to 3.7 (#10841) (@cyw233)
- [#10793](https://github.com/apache/superset/pull/10793) feat: SavedQuery REST API for bulk delete and new API fields (#10793) (@dpgaspar)
- [#10823](https://github.com/apache/superset/pull/10823) fix: Making the database read-only (#10823) (@john-bodley)
- [#10831](https://github.com/apache/superset/pull/10831) build: optimize webpack code split (#10831) (@ktmud)
- [#10824](https://github.com/apache/superset/pull/10824) fix(databases): test connection api endpoint (#10824) (@lilykuang)
- [#10819](https://github.com/apache/superset/pull/10819) fix: use nullpool in the celery workers (#10819) (@bkyryliuk)
- [#10821](https://github.com/apache/superset/pull/10821) build: split hive and presto tests to separate jobs (#10821) (@ktmud)
- [#10818](https://github.com/apache/superset/pull/10818) fix(tests): export dataset tests fails with presto (#10818) (@dpgaspar)
- [#10822](https://github.com/apache/superset/pull/10822) Revert "chore: add logging for "dashboard" action (#10744)" (#10822) (@graceguo-supercat)
- [#10798](https://github.com/apache/superset/pull/10798) Spanish translations (#10798) (@rubenSastre)
- [#10723](https://github.com/apache/superset/pull/10723) feat(databases): test connection api (#10723) (@lilykuang)
- [#10790](https://github.com/apache/superset/pull/10790) refactor: merge/upgrade superset-ui packages (#10790) (@ktmud)
- [#10813](https://github.com/apache/superset/pull/10813) fix: bump node version on Dockerfile to be on par with docker-compose (#10813) (@fguarini)
- [#10795](https://github.com/apache/superset/pull/10795) fix: Database API missing allow none on fields (#10795) (@dpgaspar)
- [#10803](https://github.com/apache/superset/pull/10803) chore: deprecate python 3.6 support (#10803) (@villebro)
- [#10800](https://github.com/apache/superset/pull/10800) feat: database delete warning (#10800) (@nytai)
- [#10810](https://github.com/apache/superset/pull/10810) test: add rls jinja extra cache key test (#10810) (@villebro)
- [#10796](https://github.com/apache/superset/pull/10796) docs: Add a note to contributing.md on reporting security vulnerabilities (#10796) (@suddjian)
- [#10772](https://github.com/apache/superset/pull/10772) feat: filters for database list view (#10772) (@nytai)
- [#10781](https://github.com/apache/superset/pull/10781) fix: MVC show saved query (#10781) (@dpgaspar)
- [#10789](https://github.com/apache/superset/pull/10789) added creator column and adjusted order columns (#10789) (@JasonD28)
- [#10777](https://github.com/apache/superset/pull/10777) feat: CRUD REST API for saved queries (#10777) (@dpgaspar)
- [#10787](https://github.com/apache/superset/pull/10787) fix: disable domain sharding on explore view (#10787) (@graceguo-supercat)
- [#10778](https://github.com/apache/superset/pull/10778) fix: can not type `0.05` in `TextControl` (#10778) (@hushaoqing)
- [#10762](https://github.com/apache/superset/pull/10762) fix: add validator information to email/slack alerts (#10762) (@JasonD28)
- [#10722](https://github.com/apache/superset/pull/10722) More Label touchups (margins) (#10722) (@rusackas)
- [#10692](https://github.com/apache/superset/pull/10692) fix: dashboard extra filters (#10692) (@john-bodley)
- [#10766](https://github.com/apache/superset/pull/10766) fix: re-installing local superset in cache image (#10766) (@craig-rueda)
- [#10705](https://github.com/apache/superset/pull/10705) feat: SIP-34 table list view for databases (#10705) (@nytai)
- [#10746](https://github.com/apache/superset/pull/10746) refactor: convert DatasetList schema filter to use new distinct api (#10746) (@nytai)
- [#10751](https://github.com/apache/superset/pull/10751) chore: removing fsevents dependency (#10751) (@rusackas)
- [#10759](https://github.com/apache/superset/pull/10759) Fix precommit hook for docs/installation.rst (#10759) (@willbarrett)
- [#10741](https://github.com/apache/superset/pull/10741) feat(database): POST, PUT, DELETE API endpoints (#10741) (@dpgaspar)
- [#10748](https://github.com/apache/superset/pull/10748) docs: Update OAuth configuration in installation.rst (#10748) (@jagamts1)
- [#10752](https://github.com/apache/superset/pull/10752) feat(viz): add ECharts Timeseries chart (#10752) (@villebro)
- [#10744](https://github.com/apache/superset/pull/10744) chore: add logging for "dashboard" action (#10744) (@graceguo-supercat)
- [#10758](https://github.com/apache/superset/pull/10758) merge db migrations (#10758) (@JasonD28)
- [#10738](https://github.com/apache/superset/pull/10738) fix: local docker deployment (#10738) (@vigneshTheDev)
- [#10750](https://github.com/apache/superset/pull/10750) moving all @types to dev dependencies (#10750) (@rusackas)
- [#10511](https://github.com/apache/superset/pull/10511) docs: Updated Docker local install instructions (#10511) (@ceohockey60)
- [#10605](https://github.com/apache/superset/pull/10605) feat: refractored SQL-based alerting framework (#10605) (@JasonD28)
- [#10678](https://github.com/apache/superset/pull/10678) chore: log cache keys to the logs (#10678) (@bkyryliuk)
- [#10747](https://github.com/apache/superset/pull/10747) Fix: Rejiggering some dependencies, trying to get CI to pass (#10747) (@rusackas)
- [#10728](https://github.com/apache/superset/pull/10728) style: Tabs now support AntD compound components (+ basic stories) (#10728) (@rusackas)
- [#10733](https://github.com/apache/superset/pull/10733) chore: bump pyarrow (#10733) (@villebro)
- [#10715](https://github.com/apache/superset/pull/10715) style: rename 'Source' top nav item to 'Data' (#10715) (@mistercrunch)
- [#10649](https://github.com/apache/superset/pull/10649) style: Pass at propagating (and enhancing) Button component throughout Superset (#10649) (@rusackas)
- [#10704](https://github.com/apache/superset/pull/10704) Covert celery tests to the pytest (#10704) (@bkyryliuk)
- [#10720](https://github.com/apache/superset/pull/10720) chore: update samesite config documentation (#10720) (@etr2460)
- [#10717](https://github.com/apache/superset/pull/10717) fix: move menu reorg logic from crud app into Menu component (#10717) (@nytai)
- [#10674](https://github.com/apache/superset/pull/10674) fix: change public role like gamma procedure (#10674) (@dpgaspar)
- [#10668](https://github.com/apache/superset/pull/10668) feat: base tabbed modal for new database CRUD UI (#10668) (@riahk)
- [#10698](https://github.com/apache/superset/pull/10698) style: add border between menu and submenu (#10698) (@nytai)
- [#10695](https://github.com/apache/superset/pull/10695) Use test name for the custom macros testing: (#10695) (@bkyryliuk)
- [#10699](https://github.com/apache/superset/pull/10699) fix: card view failed cypress tests (#10699) (@lilykuang)
- [#10439](https://github.com/apache/superset/pull/10439) style: Move security/manage navigation tabs into a settings dropdown (#10439) (@riahk)
- [#10693](https://github.com/apache/superset/pull/10693) fix: shorten url with extra request parameters (#10693) (@graceguo-supercat)
- [#10593](https://github.com/apache/superset/pull/10593) chore: ci Initial hive support (#10593) (@bkyryliuk)
- [#10691](https://github.com/apache/superset/pull/10691) feat(listview): set default view mode based on THUMBNAIL feature flag (#10691) (@nytai)
- [#10669](https://github.com/apache/superset/pull/10669) feat: chart and dashboard card list view e2e cypress test (#10669) (@lilykuang)
- [#10690](https://github.com/apache/superset/pull/10690) chore: Fix indentation issue (#10690) (@john-bodley)
- [#10680](https://github.com/apache/superset/pull/10680) refactor: useListViewResource hook for charts, dashboards, datasets (#10680) (@nytai)
- [#10682](https://github.com/apache/superset/pull/10682) fix: SubMenu css (#10682) (@nytai)
- [#10681](https://github.com/apache/superset/pull/10681) fix: layout flexiness (#10681) (@rusackas)
- [#10677](https://github.com/apache/superset/pull/10677) fix: only call signal if executing on the main thread (#10677) (@henryyeh)
- [#10675](https://github.com/apache/superset/pull/10675) feature: Adding extra_filters to warm_up_cache (#10675) (@john-bodley)
- [#10676](https://github.com/apache/superset/pull/10676) fix(sqllab): log exceptions caused by the user as debug and not error (#10676) (@nytai)
- [#10423](https://github.com/apache/superset/pull/10423) style: Fancier menus, more SIP-34-ish (#10423) (@rusackas)
- [#10657](https://github.com/apache/superset/pull/10657) Eslint error cleanup (#10657) (@rusackas)
- [#10658](https://github.com/apache/superset/pull/10658) fix(db_engine_specs): improve Presto column type matching (#10658) (@villebro)
- [#10661](https://github.com/apache/superset/pull/10661) fix(db_engine_specs): mysql longtext type should not be numeric (#10661) (@villebro)
- [#10652](https://github.com/apache/superset/pull/10652) Remove incorrect comment (#10652) (@willbarrett)
- [#9321](https://github.com/apache/superset/pull/9321) Fix add chart page frontend i18n issue (#9321) (@auxten)
- [#10401](https://github.com/apache/superset/pull/10401) fix: remove FAB rendered menu in favor of react based one (#10401) (@nytai)
- [#10651](https://github.com/apache/superset/pull/10651) feat: use shorten url in standalone iframe (#10651) (@graceguo-supercat)
- [#10606](https://github.com/apache/superset/pull/10606) feat(listview): skeleton loading states for table and card collections (#10606) (@nytai)
- [#10647](https://github.com/apache/superset/pull/10647) feat: Getting fancier with Storybook (#10647) (@rusackas)
- [#10650](https://github.com/apache/superset/pull/10650) feat: bump superset-ui for certified tag (#10650) (@etr2460)
- [#10642](https://github.com/apache/superset/pull/10642) feat: setup react page with submenu for datasources listview  (#10642) (@nytai)
- [#10630](https://github.com/apache/superset/pull/10630) feat: add certification to metrics (#10630) (@etr2460)
- [#10644](https://github.com/apache/superset/pull/10644) fix: controls scroll issue (#10644) (@rusackas)
- [#10634](https://github.com/apache/superset/pull/10634) feat: Allow tests files in  /src (plus Label component tests) (#10634) (@rusackas)
- [#10643](https://github.com/apache/superset/pull/10643) fix: remove duplicated params and cache_timeout from list_columns; add viz_type to list_columns (#10643) (@lilykuang)
- [#10631](https://github.com/apache/superset/pull/10631) chore: splitting button stories into separate stories (#10631) (@rusackas)
- [#10603](https://github.com/apache/superset/pull/10603) refactor: remove slice level label_colors from dashboard init load (#10603) (@graceguo-supercat)
- [#10607](https://github.com/apache/superset/pull/10607) feat: card view bulk select (#10607) (@lilykuang)
- [#10627](https://github.com/apache/superset/pull/10627) style: Label styling/storybook touchups (#10627) (@rusackas)
- [#10625](https://github.com/apache/superset/pull/10625) fix: removing unsupported modal sizes (#10625) (@rusackas)
- [#10619](https://github.com/apache/superset/pull/10619) feat(datasource): remove deleted columns and update column type on metadata refresh (#10619) (@villebro)
- [#10613](https://github.com/apache/superset/pull/10613) chore: npm audit fix as of 2020-08-15 (#10613) (@mistercrunch)
- [#10595](https://github.com/apache/superset/pull/10595) feat: dataset REST API for distinct values (#10595) (@dpgaspar)
- [#10602](https://github.com/apache/superset/pull/10602) chore: bump react-redux to 5.1.2, whittling console noise (#10602) (@rusackas)
- [#10604](https://github.com/apache/superset/pull/10604) fixing console error about bad html attribute (#10604) (@rusackas)
- [#10608](https://github.com/apache/superset/pull/10608) chore: migrate console logs to logging service (#10608) (@rusackas)
- [#10590](https://github.com/apache/superset/pull/10590) refactor: [migration] convert iframe chart into dashboard markdown component (#10590) (@graceguo-supercat)
- [#10601](https://github.com/apache/superset/pull/10601) feat: sort card view by Alphabetical, Recently Modified, and Least Recently Modified (#10601) (@lilykuang)
- [#10600](https://github.com/apache/superset/pull/10600) docs: update CHANGELOG.md and UPDATING.md for 0.37.0 (#10600) (@villebro)
- [#10562](https://github.com/apache/superset/pull/10562) fix(thumbnails): missing field, logging and new config var (#10562) (@dpgaspar)
- [#10526](https://github.com/apache/superset/pull/10526) feat: SIP-34 card/grid views for dashboards and charts  (#10526) (@nytai)
- [#10504](https://github.com/apache/superset/pull/10504) fix: More tweaks needed after adding Doctype tag (#10504) (@rusackas)
- [#10592](https://github.com/apache/superset/pull/10592) feat: add extra column to tables and sql_metrics (#10592) (@etr2460)
- [#10567](https://github.com/apache/superset/pull/10567) chore: Migrating reports to AuthWebdriverProxy (#10567) (@craig-rueda)
- [#10509](https://github.com/apache/superset/pull/10509) docs: Update engine installation (#10509) (@john-bodley)
- [#10584](https://github.com/apache/superset/pull/10584) fix: add None checking to cast_to_num (#10584) (@villebro)
- [#10580](https://github.com/apache/superset/pull/10580) fix: error message modal overflow (#10580) (@etr2460)
- [#10581](https://github.com/apache/superset/pull/10581) Update .asf.yaml (#10581) (@etr2460)
- [#10549](https://github.com/apache/superset/pull/10549) feat(table-viz): translation and metric column header align right (#10549) (@ktmud)
- [#10573](https://github.com/apache/superset/pull/10573) fix: add translate for dropdown menu (#10573) (@stuarthu)
- [#10566](https://github.com/apache/superset/pull/10566) feat: slack integration for SQL-based alerts (#10566) (@JasonD28)
- [#10518](https://github.com/apache/superset/pull/10518) fix(sqllab): Handle long table names in SQL Lab (#10518) (@suddjian)
- [#10529](https://github.com/apache/superset/pull/10529) fix: misaligned LimitControl buttons and port jsx->tsx (#10529) (@mistercrunch)
- [#10545](https://github.com/apache/superset/pull/10545) chore: move load examples to the fixture (#10545) (@bkyryliuk)
- [#10558](https://github.com/apache/superset/pull/10558) fix drill installation (#10558) (@blcksrx)
- [#10556](https://github.com/apache/superset/pull/10556) chore: clean up csv tests (#10556) (@bkyryliuk)
- [#10542](https://github.com/apache/superset/pull/10542) fix: add retry to SQL-based alerting celery task (#10542) (@JasonD28)
- [#10536](https://github.com/apache/superset/pull/10536) fix: Resolves #10535 (#10536) (@john-bodley)
- [#10550](https://github.com/apache/superset/pull/10550) fix: Updating Dockerfile to work with updated python requirements. (#10550) (@craig-rueda)
- [#10557](https://github.com/apache/superset/pull/10557) Removing trailing space and fix CI (#10557) (@bkyryliuk)
- [#10527](https://github.com/apache/superset/pull/10527) fix(dashboard): changing the chart title, except not (#10527) (@suddjian)
- [#10553](https://github.com/apache/superset/pull/10553) docs: add additional project tags (#10553) (@ceohockey60)
- [#10455](https://github.com/apache/superset/pull/10455) chore: Migrate Timer component from jsx to tsx (#10455) (@tanmaylaud)
- [#10477](https://github.com/apache/superset/pull/10477) docs: Update and refresh homepage of superset.apache.org (#10477) (@ceohockey60)
- [#10494](https://github.com/apache/superset/pull/10494) chore: TypeScript <Label /> (#10494) (@mistercrunch)
- [#10541](https://github.com/apache/superset/pull/10541) ci: bump pre-commit py36 to py37 (#10541) (@villebro)
- [#10537](https://github.com/apache/superset/pull/10537) Revert "chore: Cleanup database sessions (#10427)" (#10537) (@etr2460)
- [#10473](https://github.com/apache/superset/pull/10473) feat: refactor error components and add database issue code (#10473) (@etr2460)
- [#10498](https://github.com/apache/superset/pull/10498) feat: welcome presto to the suite of tested databases (#10498) (@bkyryliuk)
- [#10394](https://github.com/apache/superset/pull/10394) style: use tabs in dashboard edit pane (#10394) (@mistercrunch)
- [#10508](https://github.com/apache/superset/pull/10508) feat: Add antd to the codebase (#10508) (@nruhe)
- [#10110](https://github.com/apache/superset/pull/10110) ci: bump tests to 3.7 and add support for 3.8 (#10110) (@villebro)
- [#10412](https://github.com/apache/superset/pull/10412) fix: show label for filters in filter box in explore (#10412) (@simchaNielsen)
- [#10515](https://github.com/apache/superset/pull/10515) feat: storybook for Icon component (#10515) (@rusackas)
- [#10425](https://github.com/apache/superset/pull/10425) fix db installaion (#10425) (@blcksrx)
- [#10499](https://github.com/apache/superset/pull/10499) chore: Adding pip-compile-multi et al. (#10499) (@john-bodley)
- [#10510](https://github.com/apache/superset/pull/10510) feat: add favorite star to dashboard and chart lists (#10510) (@riahk)
- [#10519](https://github.com/apache/superset/pull/10519) fix: make SQL-based alert email links user friendly (#10519) (@JasonD28)
- [#10505](https://github.com/apache/superset/pull/10505) fix: explore panel missing padding (#10505) (@ktmud)
- [#10513](https://github.com/apache/superset/pull/10513) Add link to July community meetup (#10513) (@ceohockey60)
- [#10512](https://github.com/apache/superset/pull/10512) feat: updated email format for SQL-based email alerts (#10512) (@JasonD28)
- [#10444](https://github.com/apache/superset/pull/10444) feat: dataset editor improvements (#10444) (@lilykuang)
- [#10506](https://github.com/apache/superset/pull/10506) fix: refactored SQL-based alerts to not pass sqlalchemy objects as args (#10506) (@JasonD28)
- [#10507](https://github.com/apache/superset/pull/10507) docs: new contributing language around adding new plugins (#10507) (@rusackas)
- [#10502](https://github.com/apache/superset/pull/10502) docs: add a '.asf.yaml' file to configure our GitHub (#10502) (@mistercrunch)
- [#10368](https://github.com/apache/superset/pull/10368) docs: Add supported database logos (#10368) (@ceohockey60)
- [#10378](https://github.com/apache/superset/pull/10378) authentication type methods docs (#10378) (@blcksrx)
- [#10487](https://github.com/apache/superset/pull/10487) Sample test data (#10487) (@bkyryliuk)
- [#10500](https://github.com/apache/superset/pull/10500) chore: pre-commit run --all-files (#10500) (@john-bodley)
- [#10492](https://github.com/apache/superset/pull/10492) test: schedules test refactor (#10492) (@ktmud)
- [#10481](https://github.com/apache/superset/pull/10481) add translate string to zh locale (#10481) (@stuarthu)
- [#10420](https://github.com/apache/superset/pull/10420) style: replace inclusive/exclusive on DateFilterControl with </≤ (#10420) (@villebro)
- [#10482](https://github.com/apache/superset/pull/10482) fix: enforce mandatory chart name on save and edit (#10482) (@villebro)
- [#10474](https://github.com/apache/superset/pull/10474) feat: add linear color scale to sunburst chart (#10474) (@villebro)
- [#10427](https://github.com/apache/superset/pull/10427) chore: Cleanup database sessions (#10427) (@john-bodley)
- [#10485](https://github.com/apache/superset/pull/10485) build: optimize GitHub Actions for building speed and stability (#10485) (@ktmud)
- [#10476](https://github.com/apache/superset/pull/10476) feat: add test email functionality to SQL-based email alerts (#10476) (@JasonD28)
- [#10472](https://github.com/apache/superset/pull/10472) made screenshot drivertype configurable (#10472) (@JasonD28)
- [#10302](https://github.com/apache/superset/pull/10302) style: DOCTYPE tag, and related CSS cleanup/refactoring (#10302) (@rusackas)
- [#10446](https://github.com/apache/superset/pull/10446) style: FilterSelect style tweaks (#10446) (@mistercrunch)
- [#10461](https://github.com/apache/superset/pull/10461) fix(sqllab): button width isn't wide enough for 'Run Selection' (#10461) (@mistercrunch)
- [#10462](https://github.com/apache/superset/pull/10462) style: make database list less bloated (#10462) (@mistercrunch)
- [#10478](https://github.com/apache/superset/pull/10478) fix: timeout error message (#10478) (@etr2460)
- [#10467](https://github.com/apache/superset/pull/10467) test: upload excel (#10467) (@blcksrx)
- [#10442](https://github.com/apache/superset/pull/10442) refactor(listviews): use correct filter endpoints for charts and datasets (#10442) (@nytai)
- [#10459](https://github.com/apache/superset/pull/10459) test: Add jest-enzyme assertion library for better frontend tests (#10459) (@suddjian)
- [#10436](https://github.com/apache/superset/pull/10436) feat(api): database schemas migration to new API  (#10436) (@dpgaspar)
- [#10457](https://github.com/apache/superset/pull/10457) fix: change "add new slice" copy to "add new chart" (#10457) (@riahk)
- [#10454](https://github.com/apache/superset/pull/10454) fix: Implement updates to SQL-based email alerts (#10454) (@JasonD28)
- [#10456](https://github.com/apache/superset/pull/10456) fix(presto): Handle ROW data stored as string (#10456) (@betodealmeida)
- [#10347](https://github.com/apache/superset/pull/10347) feat: update dataset editor modal (#10347) (@lilykuang)
- [#10422](https://github.com/apache/superset/pull/10422) style: update +NEW button to use Button component, add dropdownItems prop to Button (#10422) (@riahk)
- [#10453](https://github.com/apache/superset/pull/10453) chore: migrate Checkbox to tsx (#10453) (@tanmaylaud)
- [#10251](https://github.com/apache/superset/pull/10251) docs: pointers to plugins blog post (#10251) (@mistercrunch)
- [#10445](https://github.com/apache/superset/pull/10445) chore: removing VictoryTheme.js (#10445) (@rusackas)
- [#10335](https://github.com/apache/superset/pull/10335) feat(listviews): SIP-34 filters for charts, dashboards, datasets (#10335) (@nytai)
- [#10426](https://github.com/apache/superset/pull/10426) chore: migrated Menu component to tsx (#10426) (@tanmaylaud)
- [#10241](https://github.com/apache/superset/pull/10241) fix(permissions): alpha role has all full features (#10241) (@dpgaspar)
- [#10403](https://github.com/apache/superset/pull/10403) style: SIP-34 labels (#10403) (@mistercrunch)
- [#10369](https://github.com/apache/superset/pull/10369) fix: allow creating table option and remove schema requirement in dataset add modal (#10369) (@nytai)
- [#10404](https://github.com/apache/superset/pull/10404) style(sqllab): fixed button width as label changes (#10404) (@mistercrunch)
- [#10406](https://github.com/apache/superset/pull/10406) chore: deactive flaky filter test (#10406) (@mistercrunch)
- [#10402](https://github.com/apache/superset/pull/10402) style: add fade transition to bottom border on navbar menu items (#10402) (@riahk)
- [#10392](https://github.com/apache/superset/pull/10392) fix(api): fixes perf on charts and introduces sorting by database on datasets (#10392) (@dpgaspar)
- [#10397](https://github.com/apache/superset/pull/10397) fix(charts): disable CSRF for chart data endpoint (#10397) (@dpgaspar)
- [#10393](https://github.com/apache/superset/pull/10393) fix(api): fixes openapi spec errors and adds a test to validate all spec (#10393) (@dpgaspar)
- [#10388](https://github.com/apache/superset/pull/10388) chore: wiring ControlLabel to a new FormLabel (#10388) (@mistercrunch)
- [#10355](https://github.com/apache/superset/pull/10355) feat: SIP-34 explore save modal (#10355) (@mistercrunch)
- [#10398](https://github.com/apache/superset/pull/10398) fix: dataset list filters bug (#10398) (@lilykuang)
- [#10383](https://github.com/apache/superset/pull/10383) feat: adding Storybook to Superset (#10383) (@rusackas)
- [#10380](https://github.com/apache/superset/pull/10380) fix(datasets): sort and humanized modified by (#10380) (@dpgaspar)
- [#10384](https://github.com/apache/superset/pull/10384) style: make listviews overflow scroll; convert less to emotion (#10384) (@nytai)
- [#10381](https://github.com/apache/superset/pull/10381) style: SIP-34 control-label (#10381) (@mistercrunch)
- [#10379](https://github.com/apache/superset/pull/10379) style: add warning msg to "Change Datasource" modal (#10379) (@mistercrunch)
- [#10162](https://github.com/apache/superset/pull/10162) chore: remove QueryView (ModelView) (#10162) (@mistercrunch)
- [#10371](https://github.com/apache/superset/pull/10371) feat: add TXT as default CSV extension (#10371) (@villebro)
- [#10363](https://github.com/apache/superset/pull/10363) chore: uniform icons across list views (#10363) (@mistercrunch)
- [#10274](https://github.com/apache/superset/pull/10274) feat: update timeout error UX (#10274) (@etr2460)
- [#10366](https://github.com/apache/superset/pull/10366) docs: add and update README badges (#10366) (@ceohockey60)
- [#10346](https://github.com/apache/superset/pull/10346) move control panel to filterbox folder (#10346) (@pkdotson)
- [#10324](https://github.com/apache/superset/pull/10324) feat: add optional prophet forecasting functionality to chart data api (#10324) (@villebro)
- [#10361](https://github.com/apache/superset/pull/10361) check for empty dataframes before processing results (#10361) (@bryanck)
- [#10360](https://github.com/apache/superset/pull/10360) fix: update community Slack link (#10360) (@ceohockey60)
- [#10291](https://github.com/apache/superset/pull/10291) chore: Silencing unused thumbnail cache config (#10291) (@john-bodley)
- [#10351](https://github.com/apache/superset/pull/10351) chore: enable no-static-element-interactions eslint rule (#10351) (@etr2460)
- [#10350](https://github.com/apache/superset/pull/10350) chore: enable no-unused-vars and prefer-template eslint rules (#10350) (@etr2460)
- [#10298](https://github.com/apache/superset/pull/10298) feat(listviews): SIP-34 Bulk Select (#10298) (@nytai)
- [#10339](https://github.com/apache/superset/pull/10339) tests: update test run doc and add some improvements  (#10339) (@dpgaspar)
- [#10303](https://github.com/apache/superset/pull/10303) refactor: database API OpenAPI spec and location (#10303) (@dpgaspar)
- [#10315](https://github.com/apache/superset/pull/10315) docs(readme): move Slack guidelines to CODE_OF_CONDUCT (#10315) (@mistercrunch)
- [#10275](https://github.com/apache/superset/pull/10275) fix: add additional ui tweaks (#10275) (@graceguo-supercat)
- [#10320](https://github.com/apache/superset/pull/10320) chore: prefer allow/deny terminology (#10320) (@villebro)
- [#10318](https://github.com/apache/superset/pull/10318) chore: remove unused files from root (#10318) (@mistercrunch)
- [#10297](https://github.com/apache/superset/pull/10297) feat: add download as image button to explore (#10297) (@etr2460)
- [#10267](https://github.com/apache/superset/pull/10267) fix: broken glyphicons used in react-json-schema (#10267) (@mistercrunch)
- [#10314](https://github.com/apache/superset/pull/10314) docs(readme): license info in README is redundant (#10314) (@mistercrunch)
- [#10301](https://github.com/apache/superset/pull/10301) refactor: dashboards OpenAPI spec (#10301) (@dpgaspar)
- [#10306](https://github.com/apache/superset/pull/10306) chore: clarify logging source field (#10306) (@etr2460)
- [#10271](https://github.com/apache/superset/pull/10271) Add more fields to the log API (#10271) (@bkyryliuk)
- [#10287](https://github.com/apache/superset/pull/10287) refactor: charts OpenAPI spec (#10287) (@dpgaspar)
- [#10289](https://github.com/apache/superset/pull/10289) fix: saving custom CSS correctly (#10289) (@rusackas)
- [#10212](https://github.com/apache/superset/pull/10212) docs: create INTHEWILD.md (#10212) (@ceohockey60)
- [#10290](https://github.com/apache/superset/pull/10290) fix: fetch datasets list after dataset created successfully (#10290) (@lilykuang)

### 0.37.2 (2020/09/21 11:45 +00:00)
- [#10964](https://github.com/apache/superset/pull/10964) fix: simply is_adhoc_metric (#10964) (@villebro)
- [#10934](https://github.com/apache/superset/pull/10934) fix(jinja): make context attrs private on SQL templates (#10934) (@dpgaspar)
- [#10931](https://github.com/apache/superset/pull/10931) fix(legacy-druid): undefined filter key (#10931) (@villebro)
- [#10451](https://github.com/apache/superset/pull/10451) fix(chart-data-api): assert referenced columns are present in datasource (#10451) (@villebro)
- [#10816](https://github.com/apache/superset/pull/10816) fix(sql-lab): relax column name restrictions (#10816) (@villebro)
- [#10814](https://github.com/apache/superset/pull/10814) fix: ColorSchemeControl should not use CreatableSelect (#10814) (@ktmud)
- [#10805](https://github.com/apache/superset/pull/10805) Fix: Include RLS filters for cache keys (#10805) (@gtg472b)
- [#10774](https://github.com/apache/superset/pull/10774) fix: pivot table timestamp grouping (#10774) (@villebro)
- [#10706](https://github.com/apache/superset/pull/10706) fix(db-engine-spec): execute oracle DML statement bug in sqllab (#10706) (@chuancyzhang)
- [#10684](https://github.com/apache/superset/pull/10684) fix(jinja): extract form_data from json body (#10684) (@villebro)
- [#10707](https://github.com/apache/superset/pull/10707) refactor(database): use SupersetResultSet on SqlaTable.get_df() (#10707) (@villebro)
- [#10687](https://github.com/apache/superset/pull/10687) fix(filter-box): don't add empty filter to filtersChoices (#10687) (@villebro)
- [#10683](https://github.com/apache/superset/pull/10683) feat(row-level-security): add hook for customizing form dropdowns (#10683) (@villebro)
- [#10633](https://github.com/apache/superset/pull/10633) fix: dedup groupby in viz.py while preserving order (#10633) (@mistercrunch)
- [#10637](https://github.com/apache/superset/pull/10637) feat(viz-plugins): add date formatting to pivot-table (#10637) (@villebro)
- [#10621](https://github.com/apache/superset/pull/10621) improve documentation for country maps (#10621) (@czue)
- [#10572](https://github.com/apache/superset/pull/10572) fix: show error if rolling window returns empty df (#10572) (@villebro)
- [#10578](https://github.com/apache/superset/pull/10578) fix: dataset delete and perm delete (#10578) (@dpgaspar)
- [#10576](https://github.com/apache/superset/pull/10576) fix: disable false positive error (#10576) (@dpgaspar)
- [#10475](https://github.com/apache/superset/pull/10475) fix(dashboard): add animation state to fix tab switch re-renders (#10475) (@ktmud)
- [#10552](https://github.com/apache/superset/pull/10552) fix: table viz query mode switch not working (#10552) (@ktmud)
- [#10551](https://github.com/apache/superset/pull/10551) fix: embedded chart height (#10551) (@etr2460)
- [#10548](https://github.com/apache/superset/pull/10548) fix: handle query exceptions gracefully (#10548) (@villebro)
- [#10544](https://github.com/apache/superset/pull/10544) bugfix: table chart query mode initial value (#10544) (@ktmud)
- [#10538](https://github.com/apache/superset/pull/10538) fix: remove unnecessary exception when exploring non-legacy viz plugins (#10538) (@villebro)
- [#10522](https://github.com/apache/superset/pull/10522) fix(log): don't log exceptions on test connection (#10522) (@dpgaspar)
- [#10517](https://github.com/apache/superset/pull/10517) feat: make screenshot timeout configurable (#10517) (@JasonD28)
- [#10458](https://github.com/apache/superset/pull/10458) fix: update time range select tooltip (#10458) (@riahk)
- [#10493](https://github.com/apache/superset/pull/10493) fix: support non-string groupbys for pie chart (#10493) (@villebro)
- [#10435](https://github.com/apache/superset/pull/10435) fix(log): log endpoint authentication (#10435) (@dpgaspar)
- [#10430](https://github.com/apache/superset/pull/10430) update code (#10430) (@stuarthu)
- [#10391](https://github.com/apache/superset/pull/10391) fix: pie chart multiple groupbys (#10391) (@villebro)

### 0.37.1 (2020/09/05 17:28 +00:00)
- [#10794](https://github.com/apache/superset/pull/10794) security: disallow uuid package on jinja1 (#10794) (@dpgaspar)

### 0.37.0 (2020/08/01 06:59 +00:00)
- [#10450](https://github.com/apache/superset/pull/10450) fix: excel sheet upload is not working (#10450) (@pphszx)
- [#10389](https://github.com/apache/superset/pull/10389) feat: support non-numeric columns in pivot table (#10389) (@villebro)
- [#10432](https://github.com/apache/superset/pull/10432) fix(dashboard): chart rerender when switching tabs (#10432) (@ktmud)
- [#10421](https://github.com/apache/superset/pull/10421) fix: incorrect filter operator emitted by Filter Box (#10421) (@villebro)
- [#10400](https://github.com/apache/superset/pull/10400) fix: bump pivot-table and rose (#10400) (@villebro)
- [#10382](https://github.com/apache/superset/pull/10382) fix: treemap template literal (#10382) (@villebro)
- [#10344](https://github.com/apache/superset/pull/10344) fix: group by with timestamp granularity (#10344) (@dpgaspar)
- [#10340](https://github.com/apache/superset/pull/10340) fix: modified by column on charts and dashboards (#10340) (@dpgaspar)
- [#10359](https://github.com/apache/superset/pull/10359) fix: extra filters for chart data endpoint (#10359) (@villebro)
- [#10345](https://github.com/apache/superset/pull/10345) Pin slack client, breaking change (#10345) (@bkyryliuk)
- [#10336](https://github.com/apache/superset/pull/10336) fix: make __time an ok column name in SQL Lab (#10336) (@villebro)
- [#10325](https://github.com/apache/superset/pull/10325) fix(table-viz): value "undefined" for column.name (#10325) (@ktmud)
- [#10321](https://github.com/apache/superset/pull/10321) fix: humanised changed on UTC on dashboards and charts (#10321) (@dpgaspar)
- [#10317](https://github.com/apache/superset/pull/10317) chore: type welcome (#10317) (@etr2460)
- [#10278](https://github.com/apache/superset/pull/10278) chore: add typing to more sqllab components (#10278) (@etr2460)
- [#10282](https://github.com/apache/superset/pull/10282) chore: add typing to profile (#10282) (@etr2460)
- [#10310](https://github.com/apache/superset/pull/10310) fix: Bump FAB to 3.0.1 fix superset init (#10310) (@dpgaspar)
- [#10313](https://github.com/apache/superset/pull/10313) fix: leave null timestamp unformatted in view results table (#10313) (@villebro)
- [#10312](https://github.com/apache/superset/pull/10312) fix: fix csv and query result type and QueryObject schema (#10312) (@villebro)
- [#10300](https://github.com/apache/superset/pull/10300) fix(chart-data-api): improve chart data endpoint errors (#10300) (@villebro)
- [#10293](https://github.com/apache/superset/pull/10293) fix(table-viz): table chart time column should use default (#10293) (@ktmud)
- [#10299](https://github.com/apache/superset/pull/10299) fix(chart-data-api): case insensitive evaluation of filter op (#10299) (@villebro)
- [#10292](https://github.com/apache/superset/pull/10292) chore: improve release documentation (#10292) (@villebro)
- [#10281](https://github.com/apache/superset/pull/10281) logo gets the vertically-centered flexbox treatment in jinja template (#10281) (@rusackas)
- [#10178](https://github.com/apache/superset/pull/10178) style: new toast design closer to SIP-34 (#10178) (@lilykuang)
- [#10258](https://github.com/apache/superset/pull/10258) feat: update delete modal for dataset (#10258) (@lilykuang)
- [#10284](https://github.com/apache/superset/pull/10284) fix(explore): edit datasource does not update control states (#10284) (@ktmud)
- [#10279](https://github.com/apache/superset/pull/10279) chore: Releasing SQL Lab Celery results (#10279) (@john-bodley)
- [#10280](https://github.com/apache/superset/pull/10280) chore: Bumping Celery (#10280) (@john-bodley)
- [#10286](https://github.com/apache/superset/pull/10286) feat: add contribution operation and fix cache_key bug (#10286) (@villebro)
- [#10283](https://github.com/apache/superset/pull/10283) fix(explore): 'Edit Datasource' is missing from btn-dropdown (#10283) (@mistercrunch)
- [#10277](https://github.com/apache/superset/pull/10277) fix: deckgl dimension select missing options (#10277) (@ktmud)
- [#10276](https://github.com/apache/superset/pull/10276) docs(fix): /swaggerview/v1 has moved to /swagger/v1 (#10276) (@mistercrunch)
- [#10273](https://github.com/apache/superset/pull/10273) fix(csv upload): hive params typo (#10273) (@serenajiang)
- [#10268](https://github.com/apache/superset/pull/10268) feat: show formatted dates instead of epoch on results (#10268) (@villebro)
- [#10269](https://github.com/apache/superset/pull/10269) fix: Fixed bug for issue #9967 (#10269) (@Nj-kol)
- [#10220](https://github.com/apache/superset/pull/10220) fix: dashboard endpoint sig changed (#10220) (@dpgaspar)
- [#10264](https://github.com/apache/superset/pull/10264) fix: optimize mapStateToProps for chart controls (#10264) (@ktmud)
- [#10263](https://github.com/apache/superset/pull/10263) feat: revised icons (#10263) (@rusackas)
- [#10262](https://github.com/apache/superset/pull/10262) fix: issue in getting filter_box config (#10262) (@graceguo-supercat)
- [#10259](https://github.com/apache/superset/pull/10259) chore: nixing requiresTime (#10259) (@rusackas)
- [#10260](https://github.com/apache/superset/pull/10260) [fix] disable search all options by default (#10260) (@graceguo-supercat)
- [#10257](https://github.com/apache/superset/pull/10257) feat: minor reorder SQL Lab Tab controls (#10257) (@graceguo-supercat)
- [#10255](https://github.com/apache/superset/pull/10255) feat(chart-data-api): make pivoted columns flattenable (#10255) (@villebro)
- [#10253](https://github.com/apache/superset/pull/10253) docs: update upgrading for FAB3 OAuth change (#10253) (@dpgaspar)
- [#10252](https://github.com/apache/superset/pull/10252) fix: datasets related objects, apply filter and openapi spec (#10252) (@dpgaspar)
- [#10250](https://github.com/apache/superset/pull/10250) fix(table-viz): JS error when sort time column (#10250) (@ktmud)
- [#10210](https://github.com/apache/superset/pull/10210) feat: Typeahead searchable filter_box for dashboard (#10210) (@graceguo-supercat)
- [#9964](https://github.com/apache/superset/pull/9964) feat(api): bump marshmallow and FAB to version 3 (#9964) (@dpgaspar)
- [#10248](https://github.com/apache/superset/pull/10248) chore: Cleaning up types and names for SQLA models (#10248) (@john-bodley)
- [#10237](https://github.com/apache/superset/pull/10237) chore: Revised logo (new color), w/CSS for vert alignment (#10237) (@rusackas)
- [#10235](https://github.com/apache/superset/pull/10235) feat: dataset api endpoint for charts and dashboards count (#10235) (@lilykuang)
- [#10208](https://github.com/apache/superset/pull/10208) feat: support nulls in the csv uploads (#10208) (@bkyryliuk)
- [#9944](https://github.com/apache/superset/pull/9944) feat: Alerts! allowing users to set SQL-based email alerts with screenshots (#9944) (@mistercrunch)
- [#10165](https://github.com/apache/superset/pull/10165) fix: downgrade sqlparse and add unit test (#10165) (@bkyryliuk)
- [#10243](https://github.com/apache/superset/pull/10243) feat: support new errors payload in SQL Lab (#10243) (@etr2460)
- [#10118](https://github.com/apache/superset/pull/10118) feat: add database dropdown to dashboard import (#10118) (@mistercrunch)
- [#10146](https://github.com/apache/superset/pull/10146) refactor: Using self.get_session in security manager (#10146) (@john-bodley)
- [#10197](https://github.com/apache/superset/pull/10197) [log] Updating form-data logic (#10197) (@john-bodley)
- [#10233](https://github.com/apache/superset/pull/10233) chore: Deprecating ENABLE_FLASK_COMPRESS (#10233) (@john-bodley)
- [#10236](https://github.com/apache/superset/pull/10236) Removing node_modules volume in docker-compose.yml (#10236) (@craig-rueda)
- [#9825](https://github.com/apache/superset/pull/9825) Upload excel (#9825) (@blcksrx)
- [#10222](https://github.com/apache/superset/pull/10222) fix: Remove double pickling for cached payloads (#10222) (@john-bodley)
- [#10234](https://github.com/apache/superset/pull/10234) fix(table-viz): format non-numeric metrics (#10234) (@ktmud)
- [#10226](https://github.com/apache/superset/pull/10226) chore: type ResultSet.tsx (#10226) (@etr2460)
- [#10223](https://github.com/apache/superset/pull/10223) fix(listview): use disableSortBy to disable sorting in table columns (#10223) (@nytai)
- [#10221](https://github.com/apache/superset/pull/10221) Update README.md (#10221) (@ceohockey60)
- [#10225](https://github.com/apache/superset/pull/10225) fix(table-vis): bump to v0.14.6 to fix missing anchor links (#10225) (@ktmud)
- [#10224](https://github.com/apache/superset/pull/10224) fix: chart validation error not cleared on control value update (#10224) (@ktmud)
- [#10219](https://github.com/apache/superset/pull/10219) fix: better backward compatibility for table viz (#10219) (@ktmud)
- [#10192](https://github.com/apache/superset/pull/10192) docs: update release instructions for Github releases (#10192) (@etr2460)
- [#10209](https://github.com/apache/superset/pull/10209) docs: added slack community guidelines (#10209) (@srinify)
- [#10211](https://github.com/apache/superset/pull/10211) fix: tooltips on nvd3 charts rendering in the wrong location (#10211) (@etr2460)
- [#10206](https://github.com/apache/superset/pull/10206) build: enable Cypress tests for visualizations (#10206) (@ktmud)
- [#10205](https://github.com/apache/superset/pull/10205) fix: datatable dependencies for pivot-table in dev (#10205) (@ktmud)
- [#10191](https://github.com/apache/superset/pull/10191) feat: add configuration for Presto cursor poll interval (#10191) (@etr2460)
- [#10195](https://github.com/apache/superset/pull/10195) s/assertEqual/assertEquals (#10195) (@bkyryliuk)
- [#10177](https://github.com/apache/superset/pull/10177) feat: Switch from nosetest to pytest (#10177) (@bkyryliuk)
- [#10174](https://github.com/apache/superset/pull/10174) added explore database for ctas/cvas (#10174) (@JasonD28)
- [#10170](https://github.com/apache/superset/pull/10170) build: enable typescript for cypress (#10170) (@ktmud)
- [#10188](https://github.com/apache/superset/pull/10188) update to last pyathena >= 1.10.8, to fix athena CSV upload (#10188) (@thibault-ketterer)
- [#10187](https://github.com/apache/superset/pull/10187) fix: make time grain nullable in chart data endpoint (#10187) (@villebro)
- [#10172](https://github.com/apache/superset/pull/10172) fix: make auth for hive optional (#10172) (@0xBADBAC0N)
- [#10113](https://github.com/apache/superset/pull/10113) feat(viz): add query mode switch to table chart (#10113) (@ktmud)
- [#10180](https://github.com/apache/superset/pull/10180) refactor: better naming for config flags (#10180) (@nytai)
- [#10179](https://github.com/apache/superset/pull/10179) fix: row count container alignment (#10179) (@etr2460)
- [#10175](https://github.com/apache/superset/pull/10175) Break some static methods out of superset.views.core.Superset (#10175) (@willbarrett)
- [#10155](https://github.com/apache/superset/pull/10155) chore: Updating UPDATING.md (#10155) (@john-bodley)
- [#10121](https://github.com/apache/superset/pull/10121) style: bring new SIP-34 palettes in controls (#10121) (@mistercrunch)
- [#10164](https://github.com/apache/superset/pull/10164) feat: Added configuration to SQL Lab results "Explore" button (#10164) (@JasonD28)
- [#9210](https://github.com/apache/superset/pull/9210) Add maximize and minimize feature to charts (#9210) (@oashton)
- [#10120](https://github.com/apache/superset/pull/10120) refactor: Fix lint on superset/utils/core.py (#10120) (@willbarrett)
- [#10171](https://github.com/apache/superset/pull/10171) fix: return slice owners for /user_slices ep (#10171) (@villebro)
- [#10161](https://github.com/apache/superset/pull/10161) build: dont prefer ts for cypress tests (#10161) (@ktmud)
- [#10158](https://github.com/apache/superset/pull/10158) build: upgrade Cypress and re-enable visualization tests (#10158) (@ktmud)
- [#10128](https://github.com/apache/superset/pull/10128) fix: [search query view] edit link is broken (#10128) (@mistercrunch)
- [#10106](https://github.com/apache/superset/pull/10106) refactor: Re-enable pylint on 5 files (#10106) (@willbarrett)
- [#10135](https://github.com/apache/superset/pull/10135) fix: implement legacy druid dashboard import (#10135) (@villebro)
- [#10160](https://github.com/apache/superset/pull/10160) feat: Add new timegrains and convert_dttm to Druid engine spec (#10160) (@villebro)
- [#10157](https://github.com/apache/superset/pull/10157) refactor: import emotion-theming methods from @superset-ui/style (#10157) (@ktmud)
- [#10124](https://github.com/apache/superset/pull/10124) refactor: Re-enable lint for 3 files (#10124) (@willbarrett)
- [#10105](https://github.com/apache/superset/pull/10105) fix: Loading overlay bugfix and cleanup (#10105) (@rusackas)
- [#10154](https://github.com/apache/superset/pull/10154) fix: Fixed Attribute Error when running core_tests.py (#10154) (@JasonD28)
- [#10156](https://github.com/apache/superset/pull/10156) Fix alembic migrations order (#10156) (@bkyryliuk)
- [#10130](https://github.com/apache/superset/pull/10130) fix(security): dbs/clusters perm (#10130) (@john-bodley)
- [#9794](https://github.com/apache/superset/pull/9794) Implement create view as functionality (#9794) (@bkyryliuk)
- [#10148](https://github.com/apache/superset/pull/10148) fix: refine shouldUseLegacyApi and add tests (#10148) (@villebro)
- [#10143](https://github.com/apache/superset/pull/10143) fix: FilterBox JS when no results (#10143) (@ktmud)
- [#10147](https://github.com/apache/superset/pull/10147) Fix CTAS explore flow (#10147) (@bkyryliuk)
- [#10034](https://github.com/apache/superset/pull/10034) chore(security): Updating assert logic (#10034) (@john-bodley)
- [#10094](https://github.com/apache/superset/pull/10094) style: listviews closer to SIP-34 (#10094) (@nytai)
- [#10104](https://github.com/apache/superset/pull/10104) feat: dataset add modal (#10104) (@lilykuang)
- [#10138](https://github.com/apache/superset/pull/10138) Break down Superset 101 Getting Started content (#10138) (@ceohockey60)
- [#10112](https://github.com/apache/superset/pull/10112) chore: bump superset-ui to v0.14.1 (#10112) (@ktmud)
- [#10114](https://github.com/apache/superset/pull/10114) fix: dashboard filter scope bug (#10114) (@graceguo-supercat)
- [#10080](https://github.com/apache/superset/pull/10080) [logging] add selected tab name into perf logging (#10080) (@graceguo-supercat)
- [#10127](https://github.com/apache/superset/pull/10127) chore: type src/addSlice (#10127) (@etr2460)
- [#10129](https://github.com/apache/superset/pull/10129) chore: fix add datasource help string (#10129) (@etr2460)
- [#10131](https://github.com/apache/superset/pull/10131) chore: extract translateable strings (#10131) (@etr2460)
- [#10117](https://github.com/apache/superset/pull/10117) chore: Bump sqlalchemy-utils and cachelib and refresh requirements.txt (#10117) (@villebro)
- [#9751](https://github.com/apache/superset/pull/9751) feat: Add multiple table filters for Row Level Security (#9751) (@axelet)
- [#10111](https://github.com/apache/superset/pull/10111) perf(datasets): improve datasets API performance for attr kind (#10111) (@dpgaspar)
- [#10123](https://github.com/apache/superset/pull/10123) style: replace broken glyphs with font-awesome (#10123) (@mistercrunch)
- [#10122](https://github.com/apache/superset/pull/10122) Add Nielsen to users list (#10122) (@amitNielsen)
- [#10119](https://github.com/apache/superset/pull/10119) chore(mypy): Fixing can_access_database types (#10119) (@john-bodley)
- [#10115](https://github.com/apache/superset/pull/10115) fix: dashboard should not add extra_filters onto chart annotation (#10115) (@graceguo-supercat)
- [#10092](https://github.com/apache/superset/pull/10092) fix: Visualization settings were lost when editing a datasource from Explore (#10092) (@willbarrett)
- [#10073](https://github.com/apache/superset/pull/10073) chore: type FilterableTable (#10073) (@etr2460)
- [#10056](https://github.com/apache/superset/pull/10056) style: push bootstrap theme towards SIP-34 styles (#10056) (@mistercrunch)
- [#10101](https://github.com/apache/superset/pull/10101) chore: Upgrade pylint to 2.5.3 and fix most new rules (#10101) (@willbarrett)
- [#10077](https://github.com/apache/superset/pull/10077) chore(metricoption): remove metricoption and columntypelable dependency (#10077) (@pkdotson)
- [#10090](https://github.com/apache/superset/pull/10090) style: Change logo color to new branding (#10090) (@willbarrett)
- [#10035](https://github.com/apache/superset/pull/10035) fix: adds pagination/infinite scroll to owners select in DashboardList and ChartList (#10035) (@nytai)
- [#9444](https://github.com/apache/superset/pull/9444) feat: implement dttm column configuration through db extra config (#9444) (@bkyryliuk)
- [#10078](https://github.com/apache/superset/pull/10078) refactor: Break up superset/views/core.py (#10078) (@willbarrett)
- [#10068](https://github.com/apache/superset/pull/10068) chore: type src/dashboard/util/charts (#10068) (@etr2460)
- [#10076](https://github.com/apache/superset/pull/10076) fix(sqllab): table refresh API endpoint (#10076) (@ktmud)
- [#9810](https://github.com/apache/superset/pull/9810) feat: superset report slack integration (#9810) (@bkyryliuk)
- [#10071](https://github.com/apache/superset/pull/10071) docs: FAQ entry for 'Does Superset have an API' (#10071) (@mistercrunch)
- [#10079](https://github.com/apache/superset/pull/10079) fix: Ensuring queries route accepts float or int (#10079) (@john-bodley)
- [#10075](https://github.com/apache/superset/pull/10075) add GrowthSimple to list of users on readme (#10075) (@AnimeshAgrawal)
- [#10074](https://github.com/apache/superset/pull/10074) other: add TypeScript tracker generation script (#10074) (@etr2460)
- [#10043](https://github.com/apache/superset/pull/10043) feat: add more columns and icons to dataset listview (#10043) (@nytai)
- [#10059](https://github.com/apache/superset/pull/10059) chore: bumping superset-ui theme version (#10059) (@rusackas)
- [#10070](https://github.com/apache/superset/pull/10070) fix: use custom int parsing over flask int parsing in sqllab queries endpoint (#10070) (@nytai)
- [#10069](https://github.com/apache/superset/pull/10069) Update prefer_typescript.yml (#10069) (@etr2460)
- [#10062](https://github.com/apache/superset/pull/10062) fix: chart export fails when buildQuery not present (#10062) (@villebro)
- [#10061](https://github.com/apache/superset/pull/10061) fix: caching on viz with relative time ranges and time compare (#10061) (@etr2460)
- [#10065](https://github.com/apache/superset/pull/10065) docs: Add DouroECI to list of users on readme (#10065) (@nunohelibeires)
- [#10060](https://github.com/apache/superset/pull/10060) fix: dashboard export raises schema issues (#10060) (@mistercrunch)
- [#10041](https://github.com/apache/superset/pull/10041) feat: owners profile icon on dataset list view (#10041) (@lilykuang)
- [#10037](https://github.com/apache/superset/pull/10037) fix: native annotations (#10037) (@villebro)
- [#10046](https://github.com/apache/superset/pull/10046) fix: bump pydruid version (#10046) (@villebro)
- [#10048](https://github.com/apache/superset/pull/10048) feat: add deafult buildQuery for V1 chart data requests (#10048) (@villebro)
- [#10042](https://github.com/apache/superset/pull/10042) other: [logging] add dashboard is_published into perf logging (#10042) (@graceguo-supercat)
- [#10031](https://github.com/apache/superset/pull/10031) chore(security): Renaming access methods (#10031) (@john-bodley)
- [#10030](https://github.com/apache/superset/pull/10030) chore(security): Renaming schemas_accessible_by_user (#10030) (@john-bodley)
- [#10039](https://github.com/apache/superset/pull/10039) fix(security): can_access with None crashes on builtin roles (#10039) (@dpgaspar)
- [#9971](https://github.com/apache/superset/pull/9971) [csv upload][hive] support other delimiters (#9971) (@serenajiang)
- [#10036](https://github.com/apache/superset/pull/10036) Fix chart annotation source type showing perpetual loading when re-selecting the same value. (#10036) (@nruhe)
- [#10033](https://github.com/apache/superset/pull/10033) fix: Resolves a regression from #9939 (#10033) (@john-bodley)
- [#10014](https://github.com/apache/superset/pull/10014) fix: bump pydruid to 0.6.0 (#10014) (@karen-pal)
- [#10025](https://github.com/apache/superset/pull/10025) feat: Add owners and physical/virtual status to Datasets API list endpoint (#10025) (@willbarrett)
- [#9982](https://github.com/apache/superset/pull/9982) feat: implement secondary navigation for datasets (#9982) (@lilykuang)
- [#9764](https://github.com/apache/superset/pull/9764) feat: add replace option to hive csv upload (#9764) (@etr2460)
- [#9859](https://github.com/apache/superset/pull/9859) fix: raise error in sqllab when using reserved column name (#9859) (@villebro)
- [#10018](https://github.com/apache/superset/pull/10018) chore: bump superset-ui to 0.13.27 (#10018) (@villebro)
- [#9673](https://github.com/apache/superset/pull/9673) refactor(sql): optimize sql query parser (#9673) (@lilykuang)
- [#9997](https://github.com/apache/superset/pull/9997) chore: remove markup from viz.py (#9997) (@villebro)
- [#10003](https://github.com/apache/superset/pull/10003) fix(SankeyViz): enforce source/target order (#10003) (@serenajiang)
- [#10021](https://github.com/apache/superset/pull/10021) fix: flaky test_copy_dash test in dashboard_tests.py (#10021) (@villebro)
- [#10010](https://github.com/apache/superset/pull/10010) feat: add support for query offset (#10010) (@villebro)
- [#10015](https://github.com/apache/superset/pull/10015) Quick fix for bad regex in GH Workflow (#10015) (@craig-rueda)
- [#10001](https://github.com/apache/superset/pull/10001) style(mypy): Spit-and-polish pass (#10001) (@john-bodley)
- [#10000](https://github.com/apache/superset/pull/10000) fix: [logging] fix render chart error type (#10000) (@graceguo-supercat)
- [#9939](https://github.com/apache/superset/pull/9939) style(mypy): Enforcing typing for superset.views (#9939) (@john-bodley)
- [#9975](https://github.com/apache/superset/pull/9975) feat: finalize Word Cloud move to new chart data endpoint (#9975) (@villebro)
- [#9989](https://github.com/apache/superset/pull/9989) fix: remove -1,-1 from owners request in charts, dashboards list and propertiesModal (#9989) (@nytai)
- [#9965](https://github.com/apache/superset/pull/9965) fix(api): Wrong parameter name on database openapi spec (#9965) (@dpgaspar)
- [#9960](https://github.com/apache/superset/pull/9960) docs: add ELMO Cloud HR & Payroll to list of users on readme (#9960) (@rayzor65)
- [#9934](https://github.com/apache/superset/pull/9934) fix: display python_date_format in react views as well (#9934) (@bkyryliuk)
- [#9784](https://github.com/apache/superset/pull/9784) fix: fetch all owners for dashboard, chart listview filters and properties modal (#9784) (@nytai)
- [#9943](https://github.com/apache/superset/pull/9943) style(mypy): Enforcing typing for superset (#9943) (@john-bodley)
- [#9886](https://github.com/apache/superset/pull/9886) feat: [dashboard] notification and warning for auto force refresh (#9886) (@graceguo-supercat)
- [#9973](https://github.com/apache/superset/pull/9973) fix(mypy): Resolves regression introducted in #9824 (#9973) (@john-bodley)
- [#9456](https://github.com/apache/superset/pull/9456) fix #8302, disabling save button when can_add: false, can_overwrite: false (#9456) (@micimize)
- [#9954](https://github.com/apache/superset/pull/9954) fix: pinot select query logic (#9954) (@fx19880617)
- [#9888](https://github.com/apache/superset/pull/9888) feat: make CRUD annotations inline (#9888) (@mistercrunch)
- [#9969](https://github.com/apache/superset/pull/9969) Revert "[caching] Using request context rather than globals" (#9969) (@john-bodley)
- [#9970](https://github.com/apache/superset/pull/9970) style(mypy): Fix memoize watch type (#9970) (@john-bodley)
- [#9962](https://github.com/apache/superset/pull/9962) feat: implement new version of word cloud (#9962) (@villebro)
- [#9903](https://github.com/apache/superset/pull/9903) feat: expand new chart data endpoint coverage (#9903) (@villebro)
- [#9901](https://github.com/apache/superset/pull/9901) build: add workflow preferring TypeScript files (#9901) (@etr2460)
- [#9952](https://github.com/apache/superset/pull/9952) [filter_box] disable instant_filtering by defult (#9952) (@graceguo-supercat)
- [#9940](https://github.com/apache/superset/pull/9940) fix: FilterBox Select should be Creatable (#9940) (@ktmud)
- [#9905](https://github.com/apache/superset/pull/9905) [mypy] Enforcing typing for superset.utils (#9905) (@john-bodley)
- [#9912](https://github.com/apache/superset/pull/9912) style(mypy): Enforcing mypy typing for views.chart (#9912) (@john-bodley)
- [#9920](https://github.com/apache/superset/pull/9920) style(mypy): Enforcing typing for views.database (#9920) (@john-bodley)
- [#9921](https://github.com/apache/superset/pull/9921) style(mypy): Enforcing typing for views.dashboard (#9921) (@john-bodley)
- [#9933](https://github.com/apache/superset/pull/9933) fix(react-select): FilterBox focus event and adhoc filter popup height (#9933) (@ktmud)
- [#9908](https://github.com/apache/superset/pull/9908) Revert "feat: bump superset-ui and implement queryFields in formData (#9908)" (#9931) (@villebro)
- [#9926](https://github.com/apache/superset/pull/9926) feat: bump sinon to latest (#9926) (@villebro)
- [#9915](https://github.com/apache/superset/pull/9915) fix: annotation layer json (#9915) (@etr2460)
- [#9890](https://github.com/apache/superset/pull/9890) css: beautify roles CRUD (#9890) (@mistercrunch)
- [#9919](https://github.com/apache/superset/pull/9919) fix: bump nvd3 plugin for annotation styles (#9919) (@etr2460)
- [#9916](https://github.com/apache/superset/pull/9916) feat: paired t testchart control migration (#9916) (@pkdotson)
- [#9851](https://github.com/apache/superset/pull/9851) feat: remove para controls (#9851) (@pkdotson)
- [#9908](https://github.com/apache/superset/pull/9908) feat: bump superset-ui and implement queryFields in formData (#9908) (@villebro)
- [#9891](https://github.com/apache/superset/pull/9891) fix: [dashboard] should not trigger chart refresh when filter not applicable (#9891) (@graceguo-supercat)
- [#9824](https://github.com/apache/superset/pull/9824) style: enforcing mypy typing for connectors (#9824) (@john-bodley)
- [#9826](https://github.com/apache/superset/pull/9826) chore(ts): convert base js files to typescript (#9826) (@etr2460)
- [#9895](https://github.com/apache/superset/pull/9895) Fix missing line break in Database 'extra' instructions (#9895) (@tooptoop4)
- [#9883](https://github.com/apache/superset/pull/9883) [mypy] Enforcing typing for superset.models (#9883) (@john-bodley)
- [#9884](https://github.com/apache/superset/pull/9884) fix: reenable table chart page length (#9884) (@ktmud)
- [#9881](https://github.com/apache/superset/pull/9881) fix: don't create examples db on 'superset init' (#9881) (@mistercrunch)
- [#9734](https://github.com/apache/superset/pull/9734) feat: implement csv upload configuration func for the schema enforcement (#9734) (@bkyryliuk)
- [#9847](https://github.com/apache/superset/pull/9847) feat: tablechart plugin controls migration (#9847) (@pkdotson)
- [#9864](https://github.com/apache/superset/pull/9864) Update README Resources section (#9864) (@ceohockey60)
- [#9839](https://github.com/apache/superset/pull/9839) fix: chart datasource explore URL showing datasource name for druid (#9839) (@dpgaspar)
- [#9820](https://github.com/apache/superset/pull/9820) refactor(frontend): move utils to TypeScript (#9820) (@ChristianMurphy)
- [#9865](https://github.com/apache/superset/pull/9865) only skip fossa on PRs (#9865) (@nytai)
- [#9811](https://github.com/apache/superset/pull/9811) fix: Emit a warning message rather than an exception on query failure (#9811) (@willbarrett)
- [#9853](https://github.com/apache/superset/pull/9853) feat: Adding Emotion ThemeProviders for all React apps (#9853) (@rusackas)
- [#9848](https://github.com/apache/superset/pull/9848) upgrade plugins, remove unnecessary code (#9848) (@suddjian)
- [#9841](https://github.com/apache/superset/pull/9841) feat: Add new result formats and types to chart data API (#9841) (@villebro)
- [#9832](https://github.com/apache/superset/pull/9832) fix: Removing the logic to add timeseries_limit_metric to the data for table (#9832) (@michellethomas)
- [#9862](https://github.com/apache/superset/pull/9862) Revert "[sqllab] fix, strip comments before parsing statements" (#9862) (@john-bodley)
- [#9850](https://github.com/apache/superset/pull/9850) fix: Fix for updated cache dependency (#9850) (@craig-rueda)
- [#9816](https://github.com/apache/superset/pull/9816) fixes: limit no authorization error for sentry (#9816) (@lilykuang)
- [#9846](https://github.com/apache/superset/pull/9846) docs: Disable sphinx-autodoc-typehints (#9846) (@john-bodley)
- [#9806](https://github.com/apache/superset/pull/9806) feat: markupchart plugin controls migration (#9806) (@pkdotson)
- [#9628](https://github.com/apache/superset/pull/9628) feat: upgrade react-select and make multi-select sortable (#9628) (@ktmud)
- [#9814](https://github.com/apache/superset/pull/9814) build: conditionally run fossa check if dependency files change (#9814) (@nytai)
- [#9837](https://github.com/apache/superset/pull/9837) fix: issue with duplicated dependencies (#9837) (@craig-rueda)
- [#9817](https://github.com/apache/superset/pull/9817) [explore view] inline edit slice name should not overwrite (#9817) (@graceguo-supercat)
- [#9833](https://github.com/apache/superset/pull/9833) build: Updating the sphinx configuration (#9833) (@john-bodley)
- [#9829](https://github.com/apache/superset/pull/9829) fix: [filter_box] fix 2 issues in single value filter_box (#9829) (@graceguo-supercat)
- [#9834](https://github.com/apache/superset/pull/9834) Update the link to ClickHouse official website (#9834) (@blinkov)
- [#9768](https://github.com/apache/superset/pull/9768) feat: partitionchart controls migration (#9768) (@pkdotson)
- [#9808](https://github.com/apache/superset/pull/9808) feat: bump superset-ui/time-format and big-number (#9808) (@ktmud)
- [#9835](https://github.com/apache/superset/pull/9835) fix: use snake_case for error_type (#9835) (@etr2460)
- [#9831](https://github.com/apache/superset/pull/9831) refactor: simplify getExploreUrl functions (#9831) (@villebro)
- [#9828](https://github.com/apache/superset/pull/9828) build: tox leveraging conditional factors (#9828) (@john-bodley)
- [#9819](https://github.com/apache/superset/pull/9819) feat(frontend): add ability to download dashboard and chart as image (#9819) (@ChristianMurphy)
- [#9827](https://github.com/apache/superset/pull/9827) build: Add python 3.8 to the build matrix (#9827) (@etr2460)
- [#9800](https://github.com/apache/superset/pull/9800) [mypy] Enforcing typing for translations (#9800) (@john-bodley)
- [#9789](https://github.com/apache/superset/pull/9789) FilterBox,BigNumber,WorldMap: Handle empty results - second attempt (#9789) (@elukey)
- [#9790](https://github.com/apache/superset/pull/9790) fix(babel): broken babel extract (#9790) (@dpgaspar)
- [#9774](https://github.com/apache/superset/pull/9774) upgrade migrated plugins, remove controlPanel configs (#9774) (@suddjian)
- [#9803](https://github.com/apache/superset/pull/9803) fix: invalid JSON in FR and DE translations (#9803) (@villebro)
- [#9752](https://github.com/apache/superset/pull/9752) fix(mssql): reverts #9644 and displays a better error msg (#9752) (@dpgaspar)
- [#9775](https://github.com/apache/superset/pull/9775) tests(celery): improve celery tests infra (#9775) (@dpgaspar)
- [#9796](https://github.com/apache/superset/pull/9796) feat: return security errors in the SIP-40 format (#9796) (@etr2460)
- [#9799](https://github.com/apache/superset/pull/9799) fix: construct SupersetErrors properly (#9799) (@etr2460)
- [#9798](https://github.com/apache/superset/pull/9798) fix: add flag for time series table (#9798) (@kristw)
- [#9342](https://github.com/apache/superset/pull/9342) Add extra configration to the email reports (#9342) (@bkyryliuk)
- [#9786](https://github.com/apache/superset/pull/9786) chore: bump python dependencies (#9786) (@villebro)
- [#9795](https://github.com/apache/superset/pull/9795) docs: add whale.im to list of users (#9795) (@Fullstop000)
- [#9753](https://github.com/apache/superset/pull/9753) feat: convert backend chart errors to the new error type (#9753) (@etr2460)
- [#9791](https://github.com/apache/superset/pull/9791) build: disable webpack progress for CI (#9791) (@ktmud)
- [#9655](https://github.com/apache/superset/pull/9655) chore: add support for prlint: a commit msg linter (#9655) (@mistercrunch)
- [#9715](https://github.com/apache/superset/pull/9715) [caching] Using request context rather than globals (#9715) (@john-bodley)
- [#9773](https://github.com/apache/superset/pull/9773) chore: move bullet string manipulation to frontend (#9773) (@villebro)
- [#9782](https://github.com/apache/superset/pull/9782) fix: make tests work individually (#9782) (@villebro)
- [#9779](https://github.com/apache/superset/pull/9779) tests: Fix, script to help run single tests (#9779) (@dpgaspar)
- [#9778](https://github.com/apache/superset/pull/9778) Add QueryContext deserialization test (#9778) (@villebro)
- [#9767](https://github.com/apache/superset/pull/9767) [docs] Add SSL config options for postgres (#9767) (@nytai)
- [#9756](https://github.com/apache/superset/pull/9756) Fix SQL Lab schema permission checks (#9756) (@bkyryliuk)
- [#9691](https://github.com/apache/superset/pull/9691) fix: Catch db_engine_spec.get_function_names exceptions (#9691) (@bkyryliuk)
- [#9714](https://github.com/apache/superset/pull/9714) fix bug where error at import dashboard fails to show toast in "welcome" app (#9714) (@pkdotson)
- [#9771](https://github.com/apache/superset/pull/9771) use the builtin calendar control panel (#9771) (@suddjian)
- [#9770](https://github.com/apache/superset/pull/9770) use word cloud's built in control panel (#9770) (@suddjian)
- [#9761](https://github.com/apache/superset/pull/9761) test(frontend): use absolute path for src imports (#9761) (@ktmud)
- [#9766](https://github.com/apache/superset/pull/9766) [docs] add postgres documentation (#9766) (@nytai)
- [#9762](https://github.com/apache/superset/pull/9762) fix: implement force refresh in chart data request (#9762) (@villebro)
- [#9710](https://github.com/apache/superset/pull/9710) Query the new chart data api for charts that support it (#9710) (@suddjian)
- [#9758](https://github.com/apache/superset/pull/9758) fix: removing controls from superset that are now in the plugin (#9758) (@rusackas)
- [#9757](https://github.com/apache/superset/pull/9757) build: bump superset-ui to 0.13 (#9757) (@kristw)
- [#9731](https://github.com/apache/superset/pull/9731) Update README.md (#9731) (@ceohockey60)
- [#9671](https://github.com/apache/superset/pull/9671) Revert "FilterBox,BigNumber,WorldMap: Handle empty results (#9671)" (#9755) (@etr2460)
- [#9745](https://github.com/apache/superset/pull/9745) [perf logging] Add extra logging for new/editMode dash (#9745) (@graceguo-supercat)
- [#9652](https://github.com/apache/superset/pull/9652) fix: adhoc filter 'equals' doesn't let you save (#9652) (@mistercrunch)
- [#9709](https://github.com/apache/superset/pull/9709) Use monospace (#9709) (@bkyryliuk)
- [#9740](https://github.com/apache/superset/pull/9740) feat: Add controlGroups to formData (#9740) (@villebro)
- [#9739](https://github.com/apache/superset/pull/9739) perf(dataset): improve performance on get list (#9739) (@dpgaspar)
- [#9749](https://github.com/apache/superset/pull/9749) fix: Add force flag to QueryContext schema (#9749) (@villebro)
- [#9654](https://github.com/apache/superset/pull/9654) fix: autocomplete search in AdhocFilter operator dropdown (#9654) (@mistercrunch)
- [#9744](https://github.com/apache/superset/pull/9744) fix: re-add all time grain options to the new chart API (#9744) (@etr2460)
- [#9728](https://github.com/apache/superset/pull/9728) chore: update README screenshots (#9728) (@etr2460)
- [#9733](https://github.com/apache/superset/pull/9733) [perf logging] Add timing event when browser tab is hidden (#9733) (@graceguo-supercat)
- [#9742](https://github.com/apache/superset/pull/9742) fix: css prop is now overwhelmed with emotion (#9742) (@suddjian)
- [#9724](https://github.com/apache/superset/pull/9724) docs(api): improve openapi documentation for dash, charts and queries (#9724) (@dpgaspar)
- [#9703](https://github.com/apache/superset/pull/9703) fix(dependencies): Bump FAB to 2.3.4 (#9703) (@dpgaspar)
- [#9704](https://github.com/apache/superset/pull/9704) perf(dashboards): improve API performance for dashboards (#9704) (@dpgaspar)
- [#9735](https://github.com/apache/superset/pull/9735) Fix bad test (#9735) (@bkyryliuk)
- [#9671](https://github.com/apache/superset/pull/9671) FilterBox,BigNumber,WorldMap: Handle empty results (#9671) (@elukey)
- [#9692](https://github.com/apache/superset/pull/9692) [sqllab] fix, strip comments before parsing statements (#9692) (@nytai)
- [#9716](https://github.com/apache/superset/pull/9716) [hive][csv upload] make INTs BIGINTs (#9716) (@serenajiang)
- [#9712](https://github.com/apache/superset/pull/9712) feat: add logging to warm_up_cache endpoint (#9712) (@etr2460)
- [#9695](https://github.com/apache/superset/pull/9695) Fix email reports (#9695) (@bkyryliuk)
- [#9707](https://github.com/apache/superset/pull/9707) migrate bignumber to use builtin controls (#9707) (@suddjian)
- [#9706](https://github.com/apache/superset/pull/9706) [table editor] hide Edit Datasource option when no onDatasourceSave (#9706) (@graceguo-supercat)
- [#9693](https://github.com/apache/superset/pull/9693) chore(ts): type getClientErrorObject (#9693) (@etr2460)
- [#9696](https://github.com/apache/superset/pull/9696) chore: Bump PyArrow to latest stable version (#9696) (@villebro)
- [#9694](https://github.com/apache/superset/pull/9694) [Helm] - Allow for customization of release name (#9694) (@craig-rueda)
- [#9702](https://github.com/apache/superset/pull/9702) tests(engine_specs): full bigquery engine coverage (#9702) (@dpgaspar)
- [#9705](https://github.com/apache/superset/pull/9705) fix(security) Fixing regression in #9689 (#9705) (@john-bodley)
- [#9619](https://github.com/apache/superset/pull/9619) perf(charts): improve performance on GET list (#9619) (@dpgaspar)
- [#9684](https://github.com/apache/superset/pull/9684) fix: migrate all slices off the old time grain format (#9684) (@etr2460)
- [#9649](https://github.com/apache/superset/pull/9649) [sql] Adding lighweight Table class (#9649) (@john-bodley)
- [#9651](https://github.com/apache/superset/pull/9651) [Chart & Dashboard] improve listview filter ui and add expandable list support (#9651) (@nytai)
- [#9677](https://github.com/apache/superset/pull/9677) feat(errors): add client scaffolding for custom error messages (#9677) (@etr2460)
- [#9688](https://github.com/apache/superset/pull/9688) Make cache work again for annotations (#9688) (@bkyryliuk)
- [#9689](https://github.com/apache/superset/pull/9689) Fix ENABLE_ROW_LEVEL_SECURITY flag usage (#9689) (@bkyryliuk)
- [#9665](https://github.com/apache/superset/pull/9665) [debug] Debugging caching issue (#9665) (@john-bodley)
- [#9685](https://github.com/apache/superset/pull/9685) [fix] reduce table metadata fetch for latest_partition check (#9685) (@graceguo-supercat)
- [#9682](https://github.com/apache/superset/pull/9682) tests(engine_specs): full postgres engine coverage (#9682) (@dpgaspar)
- [#9679](https://github.com/apache/superset/pull/9679) fix(tests): custom filter flaky tests on dash and charts (#9679) (@dpgaspar)
- [#9637](https://github.com/apache/superset/pull/9637) [explore view] add partition as adhoc filter option (#9637) (@graceguo-supercat)
- [#9669](https://github.com/apache/superset/pull/9669) fix: catch viz exceptions (#9669) (@villebro)
- [#9662](https://github.com/apache/superset/pull/9662) [logging] deprecation notices for SQLite (#9662) (@lilykuang)
- [#9676](https://github.com/apache/superset/pull/9676) gotta catch 'em all (#9676) (@rusackas)
- [#9666](https://github.com/apache/superset/pull/9666) [fix] Support APP_ICON_WIDTH configuration parameter in SPA menu (#9666) (@nruhe)
- [#9661](https://github.com/apache/superset/pull/9661) feat: Add geospatial post processing operations (#9661) (@villebro)
- [#9624](https://github.com/apache/superset/pull/9624) [fix] Push browser history on pagination in react listviews (#9624) (@lilykuang)
- [#9663](https://github.com/apache/superset/pull/9663) chore(ts): refactor and migrate StackTraceMessage to TypeScript (#9663) (@etr2460)
- [#9634](https://github.com/apache/superset/pull/9634) fix(database): test connection error message for module not found (#9634) (@dpgaspar)
- [#9644](https://github.com/apache/superset/pull/9644) fix(mssql): apply limit and set alias for functions (#9644) (@dpgaspar)
- [#9578](https://github.com/apache/superset/pull/9578) Controls cleanup pass (#9578) (@rusackas)
- [#9640](https://github.com/apache/superset/pull/9640) [dashboard] increase tab count limit (#9640) (@graceguo-supercat)
- [#9586](https://github.com/apache/superset/pull/9586) [mypy] Enforcing typing for a number of modules (#9586) (@john-bodley)
- [#9639](https://github.com/apache/superset/pull/9639) docs: remove references to superset-ui-plugins (#9639) (@ktmud)
- [#9577](https://github.com/apache/superset/pull/9577) [datesets] feat: add statsd to datasets api (#9577) (@lilykuang)
- [#9572](https://github.com/apache/superset/pull/9572) [fix] Automatically add relevant Jinja methods to cache key if present (#9572) (@john-bodley)
- [#9643](https://github.com/apache/superset/pull/9643) Cast raw 'fetch_values_predicate' to Sqlalchemy Text (#9643) (@vnnw)
- [#9641](https://github.com/apache/superset/pull/9641) [fix] Fixing regression from #9161 (#9641) (@john-bodley)
- [#9599](https://github.com/apache/superset/pull/9599) chore: Improve chart data API + schemas + tests (#9599) (@villebro)
- [#9612](https://github.com/apache/superset/pull/9612) [sql_lab] Improve performance, only use slow func when needed (#9612) (@dpgaspar)
- [#9605](https://github.com/apache/superset/pull/9605) use new @superset-ui/style package for theming (#9605) (@suddjian)
- [#9608](https://github.com/apache/superset/pull/9608) fix: change number format to original value to "~g" (#9608) (@ktmud)
- [#9613](https://github.com/apache/superset/pull/9613) fix: broken IS NULL and IS NOT NULL operator (#9613) (@villebro)
- [#9592](https://github.com/apache/superset/pull/9592) fix: move docs image symlink to _static (#9592) (@villebro)
- [#9614](https://github.com/apache/superset/pull/9614) [statsd] Send time metrics in ms not seconds (#9614) (@dpgaspar)
- [#9346](https://github.com/apache/superset/pull/9346) improve helm chart (#9346) (@fbalicchia)
- [#9587](https://github.com/apache/superset/pull/9587) [SQL Lab] Lock result set controls to be always visible (#9587) (@etr2460)
- [#9530](https://github.com/apache/superset/pull/9530) [charts] adds new filters ui (#9530) (@nytai)
- [#9547](https://github.com/apache/superset/pull/9547) [tests] Helper script to run single tests (#9547) (@dpgaspar)
- [#9571](https://github.com/apache/superset/pull/9571) [charts] feat: add statsd to charts api (#9571) (@lilykuang)
- [#9602](https://github.com/apache/superset/pull/9602) Bump superset-ui-connection to 0.12.22 (#9602) (@etr2460)
- [#9562](https://github.com/apache/superset/pull/9562) Add raw number/integer option to d3 number formats (#9562) (@ktmud)
- [#9569](https://github.com/apache/superset/pull/9569) Add documentation build to Github Actions (#9569) (@willbarrett)
- [#9591](https://github.com/apache/superset/pull/9591) [Build] moves prettier check to separate script (#9591) (@nytai)
- [#9582](https://github.com/apache/superset/pull/9582) [fix] Fixing issue with Jinja filter_value (#9582) (@john-bodley)
- [#9598](https://github.com/apache/superset/pull/9598) [docs] fix, elastic.co elasticsearch product location (#9598) (@dpgaspar)
- [#9585](https://github.com/apache/superset/pull/9585) [config] Enable dashboard bootstrap payload reduction by default (#9585) (@etr2460)
- [#9443](https://github.com/apache/superset/pull/9443) Re-enable the AnnotationLayerModelView read API (#9443) (@etr2460)
- [#9583](https://github.com/apache/superset/pull/9583) [mypy] Enforcing typing for superset.migrations (#9583) (@john-bodley)
- [#9579](https://github.com/apache/superset/pull/9579) fix: Add deprecated fields to QueryObject schema (#9579) (@villebro)
- [#9525](https://github.com/apache/superset/pull/9525) Migrating shared NVD3 controls to new module (#9525) (@rusackas)
- [#9570](https://github.com/apache/superset/pull/9570) doc: Add changelog for 0.36.0 (#9570) (@villebro)
- [#9567](https://github.com/apache/superset/pull/9567) [pypi] Include compiled translations on Pypi pkg (#9567) (@dpgaspar)
- [#9556](https://github.com/apache/superset/pull/9556) chore: Add OpenAPI docs to /api/v1/chart/data EP (#9556) (@villebro)
- [#9566](https://github.com/apache/superset/pull/9566) chore: Migrate unique FilterBox controls from controls.jsx (#9566) (@villebro)
- [#9555](https://github.com/apache/superset/pull/9555) [Build] Collect frontend code coverage from Cypress tests (#9555) (@ktmud)
- [#9550](https://github.com/apache/superset/pull/9550) [fix] dashboard filter scope bug (#9550) (@graceguo-supercat)
- [#9560](https://github.com/apache/superset/pull/9560) [fix] warm up cache error handling (#9560) (@john-bodley)
- [#9519](https://github.com/apache/superset/pull/9519) [dashboard] New, add statsd metrics to the API (#9519) (@dpgaspar)
- [#9549](https://github.com/apache/superset/pull/9549) Bump @superset-ui/legacy-plugin-chart-table to 0.12.14 (#9549) (@ktmud)
- [#9548](https://github.com/apache/superset/pull/9548) Ditching travis config in favor of Github Actions (#9548) (@craig-rueda)
- [#9539](https://github.com/apache/superset/pull/9539) Bump copyright notice (#9539) (@villebro)
- [#9536](https://github.com/apache/superset/pull/9536) docs: point our README the maintained Docker image (#9536) (@mistercrunch)
- [#9523](https://github.com/apache/superset/pull/9523) Make email parsing more robust (#9523) (@bkyryliuk)
- [#9541](https://github.com/apache/superset/pull/9541) [copy] fix: Row Level Security get_rls_filters func SELECT statement (#9541) (@axelet)
- [#8947](https://github.com/apache/superset/pull/8947) [thumbnails] API and celery task for dashboards and charts (#8947) (@dpgaspar)
- [#9537](https://github.com/apache/superset/pull/9537) [list views] add work-break css for table layouts (#9537) (@nytai)
- [#9538](https://github.com/apache/superset/pull/9538) Run CI on all pushes / PR's (#9538) (@craig-rueda)
- [#9535](https://github.com/apache/superset/pull/9535) Disabling recording in Cypress tests (#9535) (@craig-rueda)
- [#9517](https://github.com/apache/superset/pull/9517) [Build] Add Github workflows (#9517) (@ktmud)
- [#9533](https://github.com/apache/superset/pull/9533) Fix typo in viz.py (#9533) (@willbarrett)
- [#9465](https://github.com/apache/superset/pull/9465) Importing validators module from superset-ui (#9465) (@rusackas)
- [#9520](https://github.com/apache/superset/pull/9520) [api] refactor, remove unnecessary code, using command pattern now (#9520) (@dpgaspar)
- [#9521](https://github.com/apache/superset/pull/9521) [dashboard] Fix, improve test for custom filter (#9521) (@dpgaspar)
- [#9366](https://github.com/apache/superset/pull/9366) deprecate groupby controls in query_obj (#9366) (@villebro)
- [#9522](https://github.com/apache/superset/pull/9522) Another attempt to fix a viz.py bug (#9522) (@willbarrett)
- [#9500](https://github.com/apache/superset/pull/9500) control to turn off table bar-chart backgrounds (#9500) (@rusackas)
- [#9507](https://github.com/apache/superset/pull/9507) chore: auto label issues based on the template chosen (#9507) (@mistercrunch)
- [#9462](https://github.com/apache/superset/pull/9462) [Dashboard] new listview filters & emotion infra (#9462) (@nytai)
- [#9509](https://github.com/apache/superset/pull/9509) docker node_modules in its own volume (#9509) (@octaviancorlade)
- [#9492](https://github.com/apache/superset/pull/9492) [charts] New, custom filter for name OR description (#9492) (@dpgaspar)
- [#9503](https://github.com/apache/superset/pull/9503) Bump sqlalchemy and dremio deps (#9503) (@villebro)
- [#9370](https://github.com/apache/superset/pull/9370) Add visualization flow to the CTA queries (#9370) (@bkyryliuk)
- [#9427](https://github.com/apache/superset/pull/9427) feat: Add post processing to QueryObject (#9427) (@villebro)
- [#9496](https://github.com/apache/superset/pull/9496) fix: add lineWidth to Shared_DeckGL.jsx (#9496) (@villebro)
- [#9435](https://github.com/apache/superset/pull/9435) [dashboards] New, tittle and slug OR filter (#9435) (@dpgaspar)
- [#9484](https://github.com/apache/superset/pull/9484) [dashboards] Fix, update dashboard owners not propagating to charts o… (#9484) (@dpgaspar)
- [#9491](https://github.com/apache/superset/pull/9491) Bump FAB to 2.3.2 (#9491) (@dpgaspar)
- [#9479](https://github.com/apache/superset/pull/9479) [query] Migrate api v1 query to new location (#9479) (@dpgaspar)
- [#9495](https://github.com/apache/superset/pull/9495) fix: add explore control tabOverride at the section level (#9495) (@ktmud)
- [#9486](https://github.com/apache/superset/pull/9486) feat: change default time range in sql lab explore (#9486) (@ktmud)
- [#9493](https://github.com/apache/superset/pull/9493) Upgrade table chart plugin to 0.12.13 (#9493) (@ktmud)
- [#9460](https://github.com/apache/superset/pull/9460) pylint: accept specific 2 character names by default (#9460) (@villebro)
- [#9487](https://github.com/apache/superset/pull/9487) [tests] refactor, change datasets and charts to it's own folder (#9487) (@dpgaspar)
- [#9376](https://github.com/apache/superset/pull/9376) [sqllab] Add CUSTOM_TEMPLATE_PROCESSOR config (#9376) (@dandanhub)
- [#9480](https://github.com/apache/superset/pull/9480) Handle empty dataframes in TableViz (#9480) (@elukey)
- [#9337](https://github.com/apache/superset/pull/9337) Filter owners select by text input (#9337) (@suddjian)
- [#9437](https://github.com/apache/superset/pull/9437) [datasets] Add strict type annotation (#9437) (@dpgaspar)
- [#9418](https://github.com/apache/superset/pull/9418) [mypy] Enforcing typing for superset.dashboards (#9418) (@dpgaspar)
- [#9464](https://github.com/apache/superset/pull/9464) [Doc] Update installation doc for Dremio (#9464) (@narendrans)
- [#9455](https://github.com/apache/superset/pull/9455) Migrating shared DeckGL controls (#9455) (@rusackas)
- [#9469](https://github.com/apache/superset/pull/9469) [mypy] Enforcing typing for superset.examples (#9469) (@john-bodley)
- [#9403](https://github.com/apache/superset/pull/9403) [query] New, readonly API (#9403) (@dpgaspar)
- [#9472](https://github.com/apache/superset/pull/9472) Added dremio (#9472) (@narendrans)
- [#9451](https://github.com/apache/superset/pull/9451) release: Add support for ZSH in RELEASING and add tagging instructions (#9451) (@villebro)
- [#9378](https://github.com/apache/superset/pull/9378) chore: bump black to 19.10b0 and mypy to 0.770 (#9378) (@ktmud)
- [#9416](https://github.com/apache/superset/pull/9416) [mypy] Enforcing typing for some modules (#9416) (@john-bodley)
- [#9466](https://github.com/apache/superset/pull/9466) Eslint prefer-object-spread (#9466) (@rusackas)
- [#9454](https://github.com/apache/superset/pull/9454) Migrating NVD3 Area's stacked_style config (#9454) (@rusackas)
- [#9445](https://github.com/apache/superset/pull/9445) Migrating unique NVD3 viz controls (#9445) (@rusackas)
- [#9440](https://github.com/apache/superset/pull/9440) Migrating unique bigNumber(total) controls (#9440) (@rusackas)
- [#9356](https://github.com/apache/superset/pull/9356) Enforcing linting of LESS (#9356) (@rusackas)
- [#9446](https://github.com/apache/superset/pull/9446) migrating unique controls (#9446) (@rusackas)

### 0.36.0 (2020/04/02 07:57 +00:00)
- [#9436](https://github.com/apache/superset/pull/9436) Add check for SSL certificate and add form validators (#9436) (@villebro)
- [#9428](https://github.com/apache/superset/pull/9428) [fix]some translation not work better (#9428) (@venter-zhu)
- [#9425](https://github.com/apache/superset/pull/9425) fix pagination for list views (#9425) (@nytai)
- [#9401](https://github.com/apache/superset/pull/9401) [fix] dashboard filter indicator no showing single number value (#9401) (@graceguo-supercat)
- [#9408](https://github.com/apache/superset/pull/9408) [fix] allow force refresh for No Results chart (#9408) (@graceguo-supercat)
- [#9400](https://github.com/apache/superset/pull/9400) Build: fix hot reload for charts (#9400) (@ktmud)
- [#9417](https://github.com/apache/superset/pull/9417) [dashboards] Fix, API update slug uniqueness refusing empty string (#9417) (@dpgaspar)
- [#9411](https://github.com/apache/superset/pull/9411) [mypy] Enforcing typing for charts (#9411) (@john-bodley)
- [#9413](https://github.com/apache/superset/pull/9413) [dependency] Fix, Bump FAB to 2.3.1 (#9413) (@dpgaspar)
- [#9382](https://github.com/apache/superset/pull/9382) [fix] Fixing cache key inconsistencies (#9382) (@john-bodley)
- [#9396](https://github.com/apache/superset/pull/9396) feat: add SSL certificate validation for Druid (#9396) (@villebro)
- [#9385](https://github.com/apache/superset/pull/9385) Mirgrating unique Partition chart controls (#9385) (@rusackas)
- [#9397](https://github.com/apache/superset/pull/9397) [sip-15] fix messaging (#9397) (@john-bodley)
- [#9387](https://github.com/apache/superset/pull/9387) [charts] New, bulk delete API endpoint (#9387) (@dpgaspar)
- [#9367](https://github.com/apache/superset/pull/9367) [dataset] New, export API endpoint (#9367) (@dpgaspar)
- [#9373](https://github.com/apache/superset/pull/9373) migrating controls (#9373) (@rusackas)
- [#9333](https://github.com/apache/superset/pull/9333) build: use manifest hooks for dev server proxy and fix hot reload for charts (#9333) (@ktmud)
- [#9368](https://github.com/apache/superset/pull/9368) Migrating horizon controls (#9368) (@rusackas)
- [#9374](https://github.com/apache/superset/pull/9374) migrating unique controls (#9374) (@rusackas)
- [#9372](https://github.com/apache/superset/pull/9372) upgrade to react-bootstrap v0.33.1 (#9372) (@suddjian)
- [#9392](https://github.com/apache/superset/pull/9392) Migrating unique BoxPlot controls (#9392) (@rusackas)
- [#9388](https://github.com/apache/superset/pull/9388) Migrating unique Table controls (#9388) (@rusackas)
- [#9386](https://github.com/apache/superset/pull/9386) migrating controls 🎛 (#9386) (@rusackas)
- [#9375](https://github.com/apache/superset/pull/9375) [cache] Cleaning up viz/cache logic (#9375) (@john-bodley)
- [#9350](https://github.com/apache/superset/pull/9350) [dashboard] handle markdown error (#9350) (@graceguo-supercat)
- [#9391](https://github.com/apache/superset/pull/9391) Removing WordCloud controls from CONTRIBUTING.md (#9391) (@rusackas)
- [#9381](https://github.com/apache/superset/pull/9381) fix: [dashboard] add row padding (#9381) (@nytai)
- [#9261](https://github.com/apache/superset/pull/9261) Update MANIFEST.in (#9261) (@amancevice)
- [#9359](https://github.com/apache/superset/pull/9359) Migrating unique DirectedForce controls (#9359) (@rusackas)
- [#9383](https://github.com/apache/superset/pull/9383) fix a typo in set prop value (#9383) (@graceguo-supercat)
- [#9345](https://github.com/apache/superset/pull/9345) [explore view] fix long query issue from Run in SQL LAB Button (#9345) (@graceguo-supercat)
- [#9377](https://github.com/apache/superset/pull/9377) [sip-15] Fixing typo in docstring (#9377) (@john-bodley)
- [#9351](https://github.com/apache/superset/pull/9351) fix: don't parseFloat when the *already numeric* value ends in a decimal point (#9351) (@rusackas)
- [#9360](https://github.com/apache/superset/pull/9360) Migrate unique Heatmap controls (#9360) (@villebro)
- [#9357](https://github.com/apache/superset/pull/9357) Adding requirements-local.txt support (#9357) (@craig-rueda)
- [#9268](https://github.com/apache/superset/pull/9268) [dataset] columns and metrics API (nested) (#9268) (@dpgaspar)
- [#9310](https://github.com/apache/superset/pull/9310) Add global install of webpack and webpack-cli to docker-compose (#9310) (@willbarrett)
- [#9329](https://github.com/apache/superset/pull/9329) [charts] Refactor API using SIP-35 (#9329) (@dpgaspar)
- [#9340](https://github.com/apache/superset/pull/9340) feat: [explore] don't save filters inherited from a dashboard (#9340) (@mistercrunch)
- [#9352](https://github.com/apache/superset/pull/9352) Treemap controls migration (#9352) (@rusackas)
- [#9358](https://github.com/apache/superset/pull/9358) migrating unique EventFlow controls (#9358) (@rusackas)
- [#9355](https://github.com/apache/superset/pull/9355) Cal heatmap controls migration (#9355) (@rusackas)
- [#9338](https://github.com/apache/superset/pull/9338) feat: [SQLLAB] add checkbox to control autocomplete (#9338) (@nytai)
- [#9339](https://github.com/apache/superset/pull/9339) [config] Fixing GET_FEATURE_FLAGS_FUNC example (#9339) (@john-bodley)
- [#9332](https://github.com/apache/superset/pull/9332) refactor: remove settooltip (#9332) (@kristw)
- [#9343](https://github.com/apache/superset/pull/9343) fix: suburst chart when secondary metric is defined (#9343) (@villebro)
- [#9331](https://github.com/apache/superset/pull/9331) [requirements] Telling Celery 4.4.1 it is not welcome here (#9331) (@john-bodley)
- [#9315](https://github.com/apache/superset/pull/9315) [dashboard] Refactor API using SIP-35 (#9315) (@dpgaspar)
- [#9325](https://github.com/apache/superset/pull/9325) feat: bump deckgl plugin version (#9325) (@kristw)
- [#9326](https://github.com/apache/superset/pull/9326) Build: optimize frontend build configs to improve superset-ui-plugin dev experience (#9326) (@ktmud)
- [#9330](https://github.com/apache/superset/pull/9330) [chart] fix, bulk delete endpoint and error message (#9330) (@nytai)
- [#9211](https://github.com/apache/superset/pull/9211) show edit modal on dashboards list view (#9211) (@suddjian)
- [#9277](https://github.com/apache/superset/pull/9277) Revert "[requirements] Bumpy Celery (#9277)" (#9323) (@etr2460)
- [#9322](https://github.com/apache/superset/pull/9322) fix: handle list of lists from fetch_data (#9322) (@villebro)
- [#9319](https://github.com/apache/superset/pull/9319) fix: cannot assign to read only property exports of object (#9319) (@kristw)
- [#9311](https://github.com/apache/superset/pull/9311) [cache warm_up] warm_up slice with dashboard default_filters (#9311) (@graceguo-supercat)
- [#8940](https://github.com/apache/superset/pull/8940) Add Iran to Country Visualization (#8940) (@ali-bahjati)
- [#9296](https://github.com/apache/superset/pull/9296) chore: allow webpack-dev-server proxy to any destination (#9296) (@ktmud)
- [#9318](https://github.com/apache/superset/pull/9318) bump FAB to 2.3.0 (#9318) (@nytai)
- [#9316](https://github.com/apache/superset/pull/9316) fix: remove character set and collate column info by default (#9316) (@villebro)
- [#9314](https://github.com/apache/superset/pull/9314) fix: big number to handle NULL as it did in the past (#9314) (@mistercrunch)
- [#9312](https://github.com/apache/superset/pull/9312) [datasets] fix typo (#9312) (@nytai)
- [#9309](https://github.com/apache/superset/pull/9309) fix: add saved metrics to point size metric dropdown in deckgl scatterplot (#9309) (@villebro)
- [#9287](https://github.com/apache/superset/pull/9287) [sqllab] fix exception caused by casting string to int with psycopg2 (#9287) (@nytai)
- [#9305](https://github.com/apache/superset/pull/9305) Fixed two typos in the README (#9305) (@mfharding)
- [#9267](https://github.com/apache/superset/pull/9267) [Charts] Use the Edit Properties modal throughout React views (#9267) (@suddjian)
- [#9299](https://github.com/apache/superset/pull/9299) fix: bump click in setup.py and requirements.txt (#9299) (@villebro)
- [#9197](https://github.com/apache/superset/pull/9197) [datasets] new, listview (react) (#9197) (@nytai)
- [#9284](https://github.com/apache/superset/pull/9284) Reduce dashboard bootstrap payload (#9284) (@etr2460)
- [#9285](https://github.com/apache/superset/pull/9285) Docker-Compose Memory Issue Fix? (#9285) (@craig-rueda)
- [#9290](https://github.com/apache/superset/pull/9290) [SIP-36] Migrate RunQueryActionButton.jsx to RunQueryActionButton.tsx (#9290) (#9291) (@asif-ir)
- [#9283](https://github.com/apache/superset/pull/9283) [api] Fix, related fields need to be explicitly defined (#9283) (@dpgaspar)
- [#9279](https://github.com/apache/superset/pull/9279) [dashboard][api] Fix, PUT publish/draft to not clean slug and owners (#9279) (@dpgaspar)
- [#9286](https://github.com/apache/superset/pull/9286) fix: bump legacy-table-chart to 0.11.20 (#9286) (@ktmud)
- [#9277](https://github.com/apache/superset/pull/9277) [requirements] Bumpy Celery (#9277) (@john-bodley)
- [#9275](https://github.com/apache/superset/pull/9275) fix(table-chart): bump legacy-table-chart to 0.11.18 (#9275) (@ktmud)
- [#9274](https://github.com/apache/superset/pull/9274) fix: remove duplicate metric from bullet chart (#9274) (@villebro)
- [#9272](https://github.com/apache/superset/pull/9272) fix: add connection testing params for snowflake (#9272) (@villebro)
- [#9271](https://github.com/apache/superset/pull/9271) [fix] copy filter_scopes with duplicate charts (#9271) (@graceguo-supercat)
- [#9107](https://github.com/apache/superset/pull/9107) feat: add rolling window support to 'Big Number with Trendline' viz (#9107) (@mistercrunch)
- [#9269](https://github.com/apache/superset/pull/9269) fix: upgrade legacy table chart to 0.11.17 (#9269) (@ktmud)
- [#9255](https://github.com/apache/superset/pull/9255) fix: change database save in DatasourceEditor (#9255) (@mistercrunch)
- [#9263](https://github.com/apache/superset/pull/9263) Adds default username and password created at installation to documentation (#9263) (@willbarrett)
- [#9264](https://github.com/apache/superset/pull/9264) removing safari "fix" for ACE editor font width jank. (#9264) (@rusackas)
- [#9259](https://github.com/apache/superset/pull/9259) New entry into superset user (#9259) (@Better-Boy)
- [#9243](https://github.com/apache/superset/pull/9243) [log] Add dashboard_id param to explore_json request (#9243) (@graceguo-supercat)
- [#9119](https://github.com/apache/superset/pull/9119) Update PyArrow to 0.16.0 (#9119) (@robdiciuccio)
- [#9250](https://github.com/apache/superset/pull/9250) [webpack] fix copying images when running dev server (#9250) (@nytai)
- [#9129](https://github.com/apache/superset/pull/9129) [datasets] new, API using command pattern (#9129) (@dpgaspar)
- [#9247](https://github.com/apache/superset/pull/9247) [chart] fix, datasource link in listview (#9247) (@nytai)
- [#9254](https://github.com/apache/superset/pull/9254) fix: update release testing FLASK_APP param (#9254) (@villebro)
- [#9252](https://github.com/apache/superset/pull/9252) Add PubNub to list of organizations that use Superset (#9252) (@jzucker2)
- [#9235](https://github.com/apache/superset/pull/9235) [fix] use filter_scopes in dashboard warmup strategy (#9235) (@graceguo-supercat)
- [#9248](https://github.com/apache/superset/pull/9248) Bump node from v10 to v12 in release Dockerfiles (#9248) (@kristw)
- [#9241](https://github.com/apache/superset/pull/9241) [build] Bump superset-ui packages and update build (#9241) (@etr2460)
- [#9246](https://github.com/apache/superset/pull/9246) [UPDATING] Adding notes regarding #8867 (#9246) (@villebro)
- [#9238](https://github.com/apache/superset/pull/9238) Add option to specify type specific date truncation functions (#9238) (@villebro)
- [#9207](https://github.com/apache/superset/pull/9207) Introducing Inter UI & Fira typefaces (#9207) (@etr2460)
- [#9215](https://github.com/apache/superset/pull/9215) fix: choose language link for local dev (#9215) (@etr2460)
- [#9240](https://github.com/apache/superset/pull/9240) fix: Oracle fetch_query and datetime conversion (#9240) (@villebro)
- [#9161](https://github.com/apache/superset/pull/9161) fix: share column type matching between model and result set (#9161) (@villebro)
- [#9232](https://github.com/apache/superset/pull/9232) [security] Fix, let admin's be able to reset user passwords on AUTH_DB (#9232) (@dpgaspar)
- [#8867](https://github.com/apache/superset/pull/8867) Make schema name for the CTA queries and limit configurable (#8867) (@bkyryliuk)
- [#9205](https://github.com/apache/superset/pull/9205) [api] enable CSRF by default (#9205) (@dpgaspar)
- [#9220](https://github.com/apache/superset/pull/9220) [SQL Lab] Implement refetch results button properly (#9220) (@etr2460)
- [#9218](https://github.com/apache/superset/pull/9218) Prevent database connections to sqlite (#9218) (@suddjian)
- [#9224](https://github.com/apache/superset/pull/9224) refactor copy filter_scopes and add tests (#9224) (@graceguo-supercat)
- [#9219](https://github.com/apache/superset/pull/9219) [fix] Adding SIP-15 support for the query context (#9219) (@john-bodley)
- [#9212](https://github.com/apache/superset/pull/9212) [dashboard, chart] fix ordering and filtering in listviews (#9212) (@nytai)
- [#9213](https://github.com/apache/superset/pull/9213) [fix] remove chart id from filter_scopes metadata if chart is not in dash anymore (#9213) (@graceguo-supercat)
- [#9196](https://github.com/apache/superset/pull/9196) [Bug Fix] Returning timeseries_limit_metric in table viz get_data (#9196) (@michellethomas)
- [#9203](https://github.com/apache/superset/pull/9203) [annotation] upgrade chart plugin version (#9203) (@graceguo-supercat)
- [#9202](https://github.com/apache/superset/pull/9202) [dashboard perf logging] add dashboard url anchor component id (#9202) (@graceguo-supercat)
- [#9106](https://github.com/apache/superset/pull/9106) chore: run 'npm audit fix' to fix 2 vulnerabilities (#9106) (@mistercrunch)
- [#9063](https://github.com/apache/superset/pull/9063) Removing (unused?) Victory theme file (#9063) (@rusackas)
- [#9189](https://github.com/apache/superset/pull/9189) Upgrade typescript to 3.8.2 (#9189) (@ktmud)
- [#9133](https://github.com/apache/superset/pull/9133) [config] Disable FAB's permission and view menus views (#9133) (@dpgaspar)
- [#9185](https://github.com/apache/superset/pull/9185) docs: update CONTRIBUTING with TypeScript details from [SIP-36] (#9185) (@etr2460)
- [#9180](https://github.com/apache/superset/pull/9180) [SIP-36] Migrate setupApp.js to setupApp.ts (#9180) (@etr2460)
- [#9188](https://github.com/apache/superset/pull/9188) [dashboard] fix filter_scopes when copy dashboard with duplicate_slices (#9188) (@graceguo-supercat)
- [#9165](https://github.com/apache/superset/pull/9165) Bump FAB to 2.2.4 (#9165) (@dpgaspar)
- [#9086](https://github.com/apache/superset/pull/9086) adds FAB style filter types (#9086) (@nytai)
- [#9183](https://github.com/apache/superset/pull/9183) forcing fixed width fonts on ace editor (fixes #9095) (#9183) (@rusackas)
- [#9167](https://github.com/apache/superset/pull/9167) [log] Set detailed query info to log debug level (#9167) (@dpgaspar)
- [#9178](https://github.com/apache/superset/pull/9178) [core] Fix, sanitize errors returned from testconn (#9178) (@dpgaspar)
- [#9184](https://github.com/apache/superset/pull/9184) docs: remove focus on Druid in README.md (#9184) (@mistercrunch)
- [#9191](https://github.com/apache/superset/pull/9191) Make JSX Menu links open in new tab (#9191) (@etr2460)
- [#8699](https://github.com/apache/superset/pull/8699) [SIP-29] Add support for row-level security (#8699) (@altef)
- [#9181](https://github.com/apache/superset/pull/9181) Infer SQL_LAB QuerySource from referrer (#9181) (@etr2460)
- [#9173](https://github.com/apache/superset/pull/9173) [fix] SQL query source (#9173) (@john-bodley)
- [#9172](https://github.com/apache/superset/pull/9172) deprecate tslint and configure eslint for typescript (#9172) (@nytai)
- [#9144](https://github.com/apache/superset/pull/9144) [database] Fix, tables API endpoint (#9144) (@dpgaspar)
- [#9146](https://github.com/apache/superset/pull/9146) [dashboard] clean up usage for old filter immune metadata (#9146) (@graceguo-supercat)
- [#9120](https://github.com/apache/superset/pull/9120) Add feature flags to control query sharing, KV exposure (#9120) (@willbarrett)
- [#9145](https://github.com/apache/superset/pull/9145) [dashboard] use filter_scopes metadata when import old dashboard (#9145) (@graceguo-supercat)
- [#9162](https://github.com/apache/superset/pull/9162) [SIP-36] Migrate Link.jsx to Link.tsx (#9162) (@etr2460)
- [#9163](https://github.com/apache/superset/pull/9163) filter out markdown containing XSS (#9163) (@nytai)
- [#9138](https://github.com/apache/superset/pull/9138) [mypy] Enforcing typing for db_engine_specs (#9138) (@john-bodley)
- [#8925](https://github.com/apache/superset/pull/8925) Add release refinements from 0.35.2 release (#8925) (@villebro)
- [#9142](https://github.com/apache/superset/pull/9142) Support human readable datetime type for PinotDB (#9142) (@fx19880617)
- [#9139](https://github.com/apache/superset/pull/9139) Catch TypeError on PyArrow array instantiation (#9139) (@robdiciuccio)
- [#9122](https://github.com/apache/superset/pull/9122) [fix] Fix table viz column order (#9122) (@john-bodley)
- [#9150](https://github.com/apache/superset/pull/9150) [mypy] Disallowing implicit optional (#9150) (@john-bodley)
- [#9149](https://github.com/apache/superset/pull/9149) fix adhoc metric bug in chord diagram (#9149) (@villebro)
- [#9102](https://github.com/apache/superset/pull/9102) [sqllab] fix: return pandas records in execute_sql_statements (#9102) (@nytai)
- [#8658](https://github.com/apache/superset/pull/8658) fix: handle duplicate groupby keys (#8658) (@mistercrunch)
- [#9109](https://github.com/apache/superset/pull/9109) [migration] metadata for dashboard filters (#9109) (@graceguo-supercat)
- [#9140](https://github.com/apache/superset/pull/9140) [dashboard] remove loading spinner in missing chart holder (#9140) (@graceguo-supercat)
- [#9054](https://github.com/apache/superset/pull/9054) [database] new, select star API migration (#9054) (@dpgaspar)
- [#9134](https://github.com/apache/superset/pull/9134) [charts] Fix, double registration of charts API (#9134) (@dpgaspar)
- [#9114](https://github.com/apache/superset/pull/9114) [docker] fix, Dockerfile for frontend builds (#9114) (@suddjian)
- [#9117](https://github.com/apache/superset/pull/9117) Bump FAB to 2.2.3 (#9117) (@dpgaspar)
- [#9121](https://github.com/apache/superset/pull/9121) [logging] Add data_age for cached chart (#9121) (@graceguo-supercat)
- [#9098](https://github.com/apache/superset/pull/9098) SIP-32: Moving frontend code to the base of the repo (#9098) (@suddjian)
- [#9043](https://github.com/apache/superset/pull/9043) Add support for Cockroach DB (#9043) (@derari)
- [#9099](https://github.com/apache/superset/pull/9099) Moving away from using the root logger everywhere (#9099) (@craig-rueda)
- [#9081](https://github.com/apache/superset/pull/9081) [dashboard] Fix for dashboard edit modal, loading user list (#9081) (@suddjian)
- [#9091](https://github.com/apache/superset/pull/9091) [datasources] Fix, Prevent gamma user's from accessing save datasources (#9091) (@dpgaspar)
- [#9096](https://github.com/apache/superset/pull/9096) SQL Lab: Use numpy structured arrays, fallback to JSON serialization (#9096) (@robdiciuccio)
- [#9097](https://github.com/apache/superset/pull/9097) [tox] Allowing running of specific tests (#9097) (@john-bodley)
- [#9044](https://github.com/apache/superset/pull/9044) [table] [columns] remove generic checkbox API (#9044) (@dpgaspar)
- [#9088](https://github.com/apache/superset/pull/9088) [dashboard] Fix metadata state (#9088) (@suddjian)
- [#9093](https://github.com/apache/superset/pull/9093) [fix] Temporary filename for CSV upload to Hive (#9093) (@john-bodley)
- [#8999](https://github.com/apache/superset/pull/8999) [chart] new, list view (react) (#8999) (@nytai)
- [#9087](https://github.com/apache/superset/pull/9087) [fix] Add Auto Refresh Dashboard user event into dashboard logging (#9087) (@graceguo-supercat)
- [#9078](https://github.com/apache/superset/pull/9078) Wrap tagging endpoints in a feature flag (disabled by default) (#9078) (@willbarrett)
- [#9046](https://github.com/apache/superset/pull/9046) [query] deprecate can_only_access_owned_queries (#9046) (@dpgaspar)
- [#9056](https://github.com/apache/superset/pull/9056) Do not show stacktraces on some intentionally-thrown errors (#9056) (@willbarrett)
- [#9082](https://github.com/apache/superset/pull/9082) [fix] Issue with previously defined SQL configuration (#9082) (@john-bodley)
- [#9047](https://github.com/apache/superset/pull/9047) [csv upload] Use python's named temp file (#9047) (@dpgaspar)
- [#9051](https://github.com/apache/superset/pull/9051) [explore] Modal to edit chart properties (#9051) (@suddjian)
- [#9069](https://github.com/apache/superset/pull/9069) [docs] add a link to versioned docs in the docs (#9069) (@mistercrunch)
- [#9076](https://github.com/apache/superset/pull/9076) Add Preset, Inc. to companies using Superset (#9076) (@willbarrett)
- [#9070](https://github.com/apache/superset/pull/9070) [logging] Add flag for document visibility (#9070) (@graceguo-supercat)
- [#9060](https://github.com/apache/superset/pull/9060) [domain sharding] Freeup main domain when domain sharding is enabled (#9060) (@graceguo-supercat)
- [#9017](https://github.com/apache/superset/pull/9017) [sip-15] Enabling SIP-15 by default (#9017) (@john-bodley)
- [#9075](https://github.com/apache/superset/pull/9075) add Dragonpass Com. Ltd. (#9075) (@zhxjdwh)
- [#9065](https://github.com/apache/superset/pull/9065) [sqla] Fixing ORDER BY logic (#9065) (@john-bodley)
- [#9068](https://github.com/apache/superset/pull/9068) update organisation name from WPSemantix to timbr.ai (#9068) (@semantiDan)
- [#9064](https://github.com/apache/superset/pull/9064) [SQL Lab] Improve autocomplete performance (#9064) (@etr2460)
- [#9062](https://github.com/apache/superset/pull/9062) [fix] Ensure that is_adhoc_metric returns a boolean (#9062) (@john-bodley)
- [#9023](https://github.com/apache/superset/pull/9023) LESS is more (#9023) (@rusackas)
- [#9058](https://github.com/apache/superset/pull/9058) [Viz/Query] Improve logging around cache hits (#9058) (@etr2460)
- [#9059](https://github.com/apache/superset/pull/9059) [SQL Lab] Remove space after schema autocomplete (#9059) (@etr2460)
- [#9052](https://github.com/apache/superset/pull/9052) [docs] update README.md Peak AI (#9052) (@azhar22k)
- [#9050](https://github.com/apache/superset/pull/9050) [UPDATING] Add metadata cache changes to 0.29.0 (#9050) (@john-bodley)
- [#9018](https://github.com/apache/superset/pull/9018) Add revert guidelines to CONTRIBUTING.md (#9018) (@willbarrett)
- [#9041](https://github.com/apache/superset/pull/9041) [sqllab] Showing schema length only when schema selected (#9041) (@john-bodley)
- [#9031](https://github.com/apache/superset/pull/9031) [fix] Pivot table metric ordering (#9031) (@john-bodley)
- [#8527](https://github.com/apache/superset/pull/8527) Avoid fetch fav dashboard stat not logged in (#8527) (@aspedrosa)
- [#9049](https://github.com/apache/superset/pull/9049) Remove endpoints allowing arbitrary cache access (#9049) (@willbarrett)
- [#9002](https://github.com/apache/superset/pull/9002) [database] new, API table metadata (#9002) (@dpgaspar)
- [#8982](https://github.com/apache/superset/pull/8982) [api] fix, set default columns to just id when not defined (#8982) (@dpgaspar)
- [#9038](https://github.com/apache/superset/pull/9038) Remove redirect endpoint /superset/explorev2 (#9038) (@willbarrett)
- [#9040](https://github.com/apache/superset/pull/9040) [fix] Adding show to FAB CRUD set (#9040) (@john-bodley)
- [#9007](https://github.com/apache/superset/pull/9007) Serialize nested columns as JSON strings (#9007) (@robdiciuccio)
- [#9036](https://github.com/apache/superset/pull/9036) [routes] Re-adding FAB API routes for  TableColumnInlineView (#9036) (@john-bodley)
- [#9035](https://github.com/apache/superset/pull/9035) [routes] Re-adding FAB API routes for SqlMetricInlineView and TableModelView (#9035) (@john-bodley)
- [#9030](https://github.com/apache/superset/pull/9030) [fix] Reverting metic logic from #8901 (#9030) (@john-bodley)
- [#9025](https://github.com/apache/superset/pull/9025) [dashboard] fix, add config to optionally enable react replacement fo… (#9025) (@nytai)
- [#8979](https://github.com/apache/superset/pull/8979) [dashboard] new, bulk actions for delete & export (#8979) (@nytai)
- [#9026](https://github.com/apache/superset/pull/9026) [refactor] Centralizing custom Python types (#9026) (@john-bodley)
- [#8993](https://github.com/apache/superset/pull/8993) [log] fix, log model view permissions (#8993) (@dpgaspar)
- [#9020](https://github.com/apache/superset/pull/9020) [Caching] Ensure cache is always created (#9020) (@etr2460)
- [#9015](https://github.com/apache/superset/pull/9015) [dashboard] fix, enable info endpoint (#9015) (@nytai)
- [#9019](https://github.com/apache/superset/pull/9019) [SQL Lab] Cache function names query (#9019) (@etr2460)
- [#9010](https://github.com/apache/superset/pull/9010) [i18n] enable spanish (#9010) (@serenajiang)
- [#9011](https://github.com/apache/superset/pull/9011) [fix] Ensure sunburst column ordering adheres to hierarchy (#9011) (@john-bodley)
- [#9012](https://github.com/apache/superset/pull/9012) [SQL Lab] Add function names to autocomplete (#9012) (@etr2460)
- [#8984](https://github.com/apache/superset/pull/8984) Z index registry / clean-up (#8984) (@rusackas)
- [#9009](https://github.com/apache/superset/pull/9009) [perf_logging] Add is_cached status when chart has error (#9009) (@graceguo-supercat)
- [#9008](https://github.com/apache/superset/pull/9008) [SQL Lab] Disable autocomplete when typing numbers (#9008) (@etr2460)
- [#9006](https://github.com/apache/superset/pull/9006) [fix] pydruid export_pandas (#9006) (@john-bodley)
- [#8998](https://github.com/apache/superset/pull/8998) docs: remove reference to Panoramix and Caravel (#8998) (@mistercrunch)
- [#9004](https://github.com/apache/superset/pull/9004) Bump FAB to 2.2.2 (#9004) (@dpgaspar)
- [#8960](https://github.com/apache/superset/pull/8960) fix: shut off unneeded endpoints (#8960) (@mistercrunch)
- [#8988](https://github.com/apache/superset/pull/8988) Timing and radii (#8988) (@rusackas)
- [#8992](https://github.com/apache/superset/pull/8992) Bump requirements.txt to what setup.py would pull in (#8992) (@villebro)
- [#8995](https://github.com/apache/superset/pull/8995) [druid] Making scaning/refreshing Druid datasource view items optional (#8995) (@john-bodley)
- [#8997](https://github.com/apache/superset/pull/8997) [SQL Lab] Open request access link in a new tab (#8997) (@etr2460)
- [#8996](https://github.com/apache/superset/pull/8996) [druid] make cluster_name editable (#8996) (@serenajiang)
- [#8985](https://github.com/apache/superset/pull/8985) Bump pandas to 0.25.3 (#8985) (@villebro)
- [#8972](https://github.com/apache/superset/pull/8972) [dashboards] New, API for Bulk delete (#8972) (@dpgaspar)
- [#8917](https://github.com/apache/superset/pull/8917) [charts] New, REST API (#8917) (@dpgaspar)
- [#8817](https://github.com/apache/superset/pull/8817) [sip-15] Displaying endpoints for all start/end time ranges (#8817) (@john-bodley)
- [#8901](https://github.com/apache/superset/pull/8901) fix: add datasource.changed_on to cache_key (#8901) (@villebro)
- [#8958](https://github.com/apache/superset/pull/8958) [docs] Fix CORS section in installation (#8958) (@graceguo-supercat)
- [#8845](https://github.com/apache/superset/pull/8845) [dashboard] New, list view (react) (#8845) (@nytai)
- [#8974](https://github.com/apache/superset/pull/8974) fix empty slug breaking url (#8974) (@suddjian)
- [#8967](https://github.com/apache/superset/pull/8967) Refactor sql editor autocomplete (#8967) (@etr2460)
- [#8941](https://github.com/apache/superset/pull/8941) [dashboards] New, export api (#8941) (@dpgaspar)
- [#8971](https://github.com/apache/superset/pull/8971) Add changelog for 0.35.2 (#8971) (@villebro)
- [#8969](https://github.com/apache/superset/pull/8969) docs: fix bad extras_require reference (#8969) (@mistercrunch)
- [#8964](https://github.com/apache/superset/pull/8964) Fixing RewardGateway URL (https://rewardgateway.com/ gave a cert error) (#8964) (@craig-rueda)
- [#8966](https://github.com/apache/superset/pull/8966) fix: lighten CSS border for data preview table (#8966) (@mistercrunch)
- [#8876](https://github.com/apache/superset/pull/8876) [dashboard] Modal for editing dashboard properties & metadata (#8876) (@suddjian)
- [#8949](https://github.com/apache/superset/pull/8949) [filter_box] Fix ; separated filter_box default values (#8949) (@graceguo-supercat)
- [#8950](https://github.com/apache/superset/pull/8950) docs: add Reward Gateway to README (#8950) (@mistercrunch)
- [#8576](https://github.com/apache/superset/pull/8576) [db migration] change datasources-clusters foreign key to cluster_id (#8576) (@serenajiang)
- [#8781](https://github.com/apache/superset/pull/8781) [css] Bringing Bootswatch in line with external variables, and other CSS tweaks (#8781) (@rusackas)
- [#8948](https://github.com/apache/superset/pull/8948) [fix] Enforce the QueryResult.df to be a pandas.DataFrame (Phase II) (#8948) (@john-bodley)
- [#8946](https://github.com/apache/superset/pull/8946) Ensure proper JSON serialization of numpy.ndarray (#8946) (@robdiciuccio)
- [#8945](https://github.com/apache/superset/pull/8945) [app] Fix, manage menu should be before charts (#8945) (@dpgaspar)
- [#8939](https://github.com/apache/superset/pull/8939) Add support for Dremio as a new source (#8939) (@narendrans)
- [#8914](https://github.com/apache/superset/pull/8914) [dashboard] Deprecate superset published API (#8914) (@dpgaspar)
- [#8942](https://github.com/apache/superset/pull/8942) [dashboards] Fix, missing mulexport permission (#8942) (@dpgaspar)
- [#8935](https://github.com/apache/superset/pull/8935) [fix] Enforce the query result to contain a data-frame (#8935) (@john-bodley)
- [#8912](https://github.com/apache/superset/pull/8912) Moving appbuilder.xxx out of view files and into app.py (#8912) (@craig-rueda)
- [#8931](https://github.com/apache/superset/pull/8931) Fix docstrings in superset/config.py (#8931) (@moshthepitt)
- [#8598](https://github.com/apache/superset/pull/8598) Revert "Make select_star work with SQL Lab views (#8598)" (#8930) (@graceguo-supercat)

### 0.35.2 (2020/01/03 16:42 +00:00)
- [#8918](https://github.com/apache/superset/pull/8918) [database] [log] Fix, Limit the amount of info on response (#8918) (@dpgaspar)
- [#8759](https://github.com/apache/superset/pull/8759) Bump viz plugins for bug bash (#8759) (@etr2460)
- [#8729](https://github.com/apache/superset/pull/8729) fix: don't show filter popover on explore view load (#8729) (@mistercrunch)
- [#8718](https://github.com/apache/superset/pull/8718) Migrate filter_immune_slice_fields (#8718) (@betodealmeida)
- [#8714](https://github.com/apache/superset/pull/8714) [fix] Druid IS NULL/IS NOT NULL filters (#8714) (@john-bodley)
- [#8678](https://github.com/apache/superset/pull/8678) fix: default missing values to zero on area chart (#8678) (@villebro)
- [#8573](https://github.com/apache/superset/pull/8573) [SECURITY] bump packages with security vulnerabilities (#8573) (@nytai)
- [#8583](https://github.com/apache/superset/pull/8583) Bump pyarrow to 0.15.1 due to CVE (#8583) (@robdiciuccio)
- [#8581](https://github.com/apache/superset/pull/8581) Fix error when templateParams is undefined (#8581) (@betodealmeida)
- [#8575](https://github.com/apache/superset/pull/8575) Math.max(...array) considered harmful (#8575) (@betodealmeida)
- [#8550](https://github.com/apache/superset/pull/8550) [Dashboard Import] Log error on dashboard import failure (#8550) (@etr2460)
- [#8427](https://github.com/apache/superset/pull/8427) Default page: remove title attribute to fall back on appbuilder.app_name (#8427) (@Zanoellia)
- [#8495](https://github.com/apache/superset/pull/8495) [datasource editor] Only one click target for edit action (#8495) (@graceguo-supercat)
- [#8465](https://github.com/apache/superset/pull/8465) Update UPDATING.md (#8465) (@john-bodley)
- [#8471](https://github.com/apache/superset/pull/8471) [Datasource Editor] A few small UI changes in modal to prevent accidental edits (#8471) (@graceguo-supercat)
- [#8439](https://github.com/apache/superset/pull/8439) [setup] Fix, download_url (#8439) (@dpgaspar)
- [#8449](https://github.com/apache/superset/pull/8449) Split up tests/db_engine_test.py (#8449) (@willbarrett)
- [#8438](https://github.com/apache/superset/pull/8438) introduce a space in command line option (#8438) (@christophlingg)
- [#8444](https://github.com/apache/superset/pull/8444) explain the need to enable async queries (#8444) (@christophlingg)
- [#8442](https://github.com/apache/superset/pull/8442) spelling fix (#8442) (@austinpray)
- [#8419](https://github.com/apache/superset/pull/8419) docs: add a note to RELEASING about Slack Channel (#8419) (@mistercrunch)

### 0.35.1 (2019/11/15 13:47 +00:00)
- [#8457](https://github.com/apache/superset/pull/8457) [fix] Improve csv upload functionality (#8457) (@villebro)
- [#8566](https://github.com/apache/superset/pull/8566) [druid] Fix, pydruid forced dependency (#8566) (@dpgaspar)
- [#8558](https://github.com/apache/superset/pull/8558) bump legacy-preset-chart-nvd3 to 0.11.5 (#8558) (@nytai)
- [#8498](https://github.com/apache/superset/pull/8498) build: bump dompurify version because of nasty xss bypass. (#8498) (@MarcusSorealheis)
- [#8477](https://github.com/apache/superset/pull/8477) [cli] Fix, import datasources exported by UI (#8477) (@dpgaspar)
- [#8487](https://github.com/apache/superset/pull/8487) fixing typo. (#8487) (@MarcusSorealheis)
- [#8430](https://github.com/apache/superset/pull/8430) [pydruid] Bumping the pydruid version (#8430) (@john-bodley)

### 0.35.0 (2019/10/31 11:12 +00:00)
- [#8436](https://github.com/apache/superset/pull/8436) [fix] Updating parse_human_timedelta typing (#8436) (@john-bodley)
- [#8423](https://github.com/apache/superset/pull/8423) chore: disable another flaky cypress test (#8423) (@mistercrunch)
- [#8331](https://github.com/apache/superset/pull/8331) Add improved typed casting to BigQuery (#8331) (@betodealmeida)
- [#8353](https://github.com/apache/superset/pull/8353) [tests] Fix, removing deprecated function for future Python release compatibility. (#8353) (@MarcusSorealheis)
- [#8413](https://github.com/apache/superset/pull/8413) fixed typo in installation instructions (#8413) (@francishemingway)
- [#8409](https://github.com/apache/superset/pull/8409) [ci] Deprecate flake8 (#8409) (@john-bodley)
- [#7702](https://github.com/apache/superset/pull/7702) [sqla] Enforcing ISO 8601 date/timestamp formats (#7702) (@john-bodley)
- [#8370](https://github.com/apache/superset/pull/8370) [Config] Cache static resources (#8370) (@etr2460)
- [#8367](https://github.com/apache/superset/pull/8367) [docs] CTAS on PostgreSQL needs commit to apply (#8367) (@dpgaspar)
- [#8399](https://github.com/apache/superset/pull/8399) Update Slack invitation link (#8399) (@robdiciuccio)
- [#8371](https://github.com/apache/superset/pull/8371) [fix] make names non-nullable (#8371) (@serenajiang)
- [#8390](https://github.com/apache/superset/pull/8390) [form-data] Deleting obsolete Superset.get_form_data method (#8390) (@john-bodley)
- [#8376](https://github.com/apache/superset/pull/8376) Add 0.34.1 PRs to CHANGELOG (#8376) (@villebro)
- [#8372](https://github.com/apache/superset/pull/8372) [migration] Migrating since/until to time_range (#8372) (@john-bodley)
- [#8374](https://github.com/apache/superset/pull/8374) [Cypress] Skip another flaky sqllab test (#8374) (@etr2460)
- [#8369](https://github.com/apache/superset/pull/8369) Add incubating to NOTICE (#8369) (@villebro)
- [#8368](https://github.com/apache/superset/pull/8368) [Docs] Put superset users in abc order (#8368) (@etr2460)
- [#8365](https://github.com/apache/superset/pull/8365) Update README.md (#8365) (@christophlingg)
- [#8332](https://github.com/apache/superset/pull/8332) Revert "[fix] make datasource names non-nullable (#8332)" (#8363) (@serenajiang)
- [#8345](https://github.com/apache/superset/pull/8345) [dashboard] show less filter indicators (#8345) (@graceguo-supercat)
- [#8330](https://github.com/apache/superset/pull/8330) Fix pypi link and replace gitter badge with slack (#8330) (@villebro)
- [#7992](https://github.com/apache/superset/pull/7992) Revert "[init] Setting up cache before registering blueprints (#7992)" (#8005) (@john-bodley)
- [#8343](https://github.com/apache/superset/pull/8343) Add support for Exasol (#8343) (@kevang)
- [#8351](https://github.com/apache/superset/pull/8351) fix saving new sql lab queries (#8351) (@suddjian)
- [#8350](https://github.com/apache/superset/pull/8350) Remove unused methods from Presto (#8350) (@betodealmeida)
- [#8338](https://github.com/apache/superset/pull/8338) Fix lint in `superset/db_engine_spec` (#8338) (@willbarrett)
- [#8332](https://github.com/apache/superset/pull/8332) [fix] make datasource names non-nullable (#8332) (@serenajiang)
- [#8344](https://github.com/apache/superset/pull/8344) Add Fanatics to companies that use Superset (#8344) (@coderfender)
- [#8347](https://github.com/apache/superset/pull/8347) [docs] Add Deepomatic in organization list (#8347) (@Zanoellia)
- [#8296](https://github.com/apache/superset/pull/8296) feat: Set moment library language during app setup (#8296) (@oskarhinc)
- [#8299](https://github.com/apache/superset/pull/8299) fix: npm audit fix bumps handlebars 4.1.2->4.3.1 (#8299) (@mistercrunch)
- [#8175](https://github.com/apache/superset/pull/8175) [metric] Adding security for restricted metrics (#8175) (@john-bodley)
- [#8304](https://github.com/apache/superset/pull/8304) [Presto] Handle uncaught exception in get_create_view (#8304) (@etr2460)
- [#8305](https://github.com/apache/superset/pull/8305) [SQL Lab] Improve autocomplete (#8305) (@etr2460)
- [#8298](https://github.com/apache/superset/pull/8298) Allow overwriting a SQLLab query that has previously been saved (#8298) (@suddjian)
- [#8300](https://github.com/apache/superset/pull/8300) refactor: remove unused code (#8300) (@kristw)
- [#8320](https://github.com/apache/superset/pull/8320) Update RunQueryActionButton.jsx (#8320) (@nabinkhadka)
- [#8317](https://github.com/apache/superset/pull/8317) Adding explicit Flask session cookie options to default config (#8317) (@craig-rueda)
- [#8239](https://github.com/apache/superset/pull/8239) [superset] Fix, missing return on error and improved query (#8239) (@dpgaspar)
- [#8307](https://github.com/apache/superset/pull/8307) allow non-relative LOGO_TARGET_PATH (#8307) (@nytai)
- [#8311](https://github.com/apache/superset/pull/8311) Add safaricom to companies using superset (#8311) (@mmutiso)
- [#8309](https://github.com/apache/superset/pull/8309) Add explicit support for python 3.7 (#8309) (@villebro)
- [#8272](https://github.com/apache/superset/pull/8272) Refine release instructions (#8272) (@villebro)
- [#8262](https://github.com/apache/superset/pull/8262) Add commit to attempt to resolve query table lock (#8262) (@etr2460)
- [#8282](https://github.com/apache/superset/pull/8282) chore: skip flaky SQL Lab test (#8282) (@mistercrunch)
- [#8261](https://github.com/apache/superset/pull/8261) [migration] Stripping leading and trailing whitespace (#8261) (@john-bodley)
- [#8256](https://github.com/apache/superset/pull/8256) [sql_json] Ensuring the request body is JSON encoded (#8256) (@john-bodley)
- [#8240](https://github.com/apache/superset/pull/8240) [database] Improve form and API validation for invalid URI (#8240) (@dpgaspar)
- [#8274](https://github.com/apache/superset/pull/8274) More intuitive display of negative time deltas (#8274) (#8276) (@benvdh)
- [#8268](https://github.com/apache/superset/pull/8268) Fix no data in Presto (#8268) (@betodealmeida)
- [#8258](https://github.com/apache/superset/pull/8258) refactor: use deck.gl plugins from npm package (#8258) (@kristw)
- [#8138](https://github.com/apache/superset/pull/8138) [typing] add typing for superset/connectors and superset/common (#8138) (@serenajiang)
- [#8163](https://github.com/apache/superset/pull/8163) [SQLLab] Refactor sql json endpoint (#8163) (@dpgaspar)
- [#8257](https://github.com/apache/superset/pull/8257) Remove __row_id (#8257) (@betodealmeida)
- [#8250](https://github.com/apache/superset/pull/8250) Update another pypi case from superset to apache-superset (#8250) (@etr2460)
- [#8244](https://github.com/apache/superset/pull/8244) docs: reflect the pypi move from superset to apache-superset (#8244) (@mistercrunch)
- [#8224](https://github.com/apache/superset/pull/8224) [sqllab] create query slightly earlier (#8224) (@serenajiang)
- [#8253](https://github.com/apache/superset/pull/8253) Fix array casting (#8253) (@betodealmeida)
- [#8243](https://github.com/apache/superset/pull/8243) Show Presto views as views, not tables (#8243) (@betodealmeida)
- [#8251](https://github.com/apache/superset/pull/8251) Small fix for Presto dtype map (#8251) (@betodealmeida)
- [#8246](https://github.com/apache/superset/pull/8246) Update README.md (#8246) (@MaiTiano)
- [#8185](https://github.com/apache/superset/pull/8185) Add RegisteredLookupExtraction support to extraction function (#8185) (@1AB9502)
- [#8213](https://github.com/apache/superset/pull/8213) Better distinction between tables and views, and show CREATE VIEW (#8213) (@betodealmeida)
- [#8233](https://github.com/apache/superset/pull/8233) Simplify and improve `expand_data` in Presto (#8233) (@betodealmeida)
- [#8172](https://github.com/apache/superset/pull/8172) Allow users to estimate query cost before executing it (#8172) (@betodealmeida)
- [#8226](https://github.com/apache/superset/pull/8226) Handle int64 columns with missing data in SQL Lab (#8226) (@betodealmeida)
- [#8222](https://github.com/apache/superset/pull/8222) refactor: prepare control panel configs for separation into plugins (#8222) (@kristw)
- [#8221](https://github.com/apache/superset/pull/8221) fix: initialize control state for inline control config object (#8221) (@kristw)
- [#8214](https://github.com/apache/superset/pull/8214) [talisman] Enforcing HTTP for status checks (#8214) (@john-bodley)
- [#8173](https://github.com/apache/superset/pull/8173) feat: read control panel configs from registry (#8173) (@kristw)
- [#8196](https://github.com/apache/superset/pull/8196) chore: fix version info (#8196) (@mistercrunch)
- [#8212](https://github.com/apache/superset/pull/8212) fix: attempt to fix the flaky SQL Lab test (#8212) (@mistercrunch)
- [#8210](https://github.com/apache/superset/pull/8210) Update messages.json (#8210) (@klxiang)
- [#8166](https://github.com/apache/superset/pull/8166) [feature][dashboard] Show/hide filter indicator on the applicable charts when filter options are open/close (#8166) (@graceguo-supercat)
- [#8206](https://github.com/apache/superset/pull/8206) Update README.md (#8206) (@garnservo)
- [#8208](https://github.com/apache/superset/pull/8208) chore: update UPDATING.md with a 0.34.0 section (#8208) (@mistercrunch)
- [#8034](https://github.com/apache/superset/pull/8034) [viz] Adding get_def typing (#8034) (@john-bodley)
- [#8197](https://github.com/apache/superset/pull/8197) chore: deprecate restricted metrics (#8197) (@mistercrunch)
- [#8198](https://github.com/apache/superset/pull/8198) Update messages.json (#8198) (@klxiang)
- [#8204](https://github.com/apache/superset/pull/8204) change log from csv_export to data_export; fix db name in log (#8204) (@DiggidyDave)
- [#8164](https://github.com/apache/superset/pull/8164) more detailed async error messages (#8164) (@serenajiang)
- [#8182](https://github.com/apache/superset/pull/8182) [Config] Disable celery acks late (#8182) (@etr2460)
- [#8038](https://github.com/apache/superset/pull/8038) Prevent 'main' database connection creation (#8038) (@mistercrunch)
- [#8187](https://github.com/apache/superset/pull/8187) ignore formatting for `<Select>` (#8187) (@gbates101)
- [#8184](https://github.com/apache/superset/pull/8184) [fix] retry stop_query on all exceptions (#8184) (@serenajiang)
- [#8179](https://github.com/apache/superset/pull/8179) Update messages.json (#8179) (@klxiang)
- [#8158](https://github.com/apache/superset/pull/8158) Bump cypress from 3.1.5 to 3.4.1 (#8158) (@mistercrunch)
- [#8139](https://github.com/apache/superset/pull/8139) [sqllab] add retries for stop_query (#8139) (@serenajiang)
- [#8143](https://github.com/apache/superset/pull/8143) [Codemod] Rename react unsafe lifecycles (#8143) (@etr2460)
- [#8149](https://github.com/apache/superset/pull/8149) chore: remove PY3 conditional logic (#8149) (@mistercrunch)
- [#8156](https://github.com/apache/superset/pull/8156) Forward SIGTERM signal to gunicorn (#8156) (@smacker)
- [#8148](https://github.com/apache/superset/pull/8148) Adding explicit include for version_info.json (#8148) (@craig-rueda)
- [#7822](https://github.com/apache/superset/pull/7822) Revert "Fix tooltips not visible for NVD3 charts on Firefox (#7822) (#7929)" (#8147) (@etr2460)
- [#8099](https://github.com/apache/superset/pull/8099) Revert "Allow resizing width of SQL Lab left bar / editor (#8099)" (#8146) (@etr2460)
- [#8130](https://github.com/apache/superset/pull/8130) removes unused state values and redundant presence checks (#8130) (@nytai)
- [#8136](https://github.com/apache/superset/pull/8136) Add duration formatter for numeric data (#8136) (@villebro)
- [#8140](https://github.com/apache/superset/pull/8140) remove unused files (#8140) (@kristw)
- [#8135](https://github.com/apache/superset/pull/8135) [setup] use new python requires metadata key (#8135) (@dpgaspar)
- [#8109](https://github.com/apache/superset/pull/8109) Moving towards a whitelist approach for MANIFEST.in (#8109) (@craig-rueda)
- [#8069](https://github.com/apache/superset/pull/8069) [SQL Lab] Async query results serialization with MessagePack and PyArrow (#8069) (@robdiciuccio)
- [#8115](https://github.com/apache/superset/pull/8115) feat: bump superset-ui dependencies to v0.12 and plugins to v0.11 (#8115) (@kristw)
- [#8085](https://github.com/apache/superset/pull/8085) Add LogConfigurator, and add logging for CSV export (#8085) (@DiggidyDave)
- [#8111](https://github.com/apache/superset/pull/8111) removed database deps from reqs-dev.txt and typo. (#8111) (@MarcusSorealheis)
- [#8104](https://github.com/apache/superset/pull/8104) [logging] add query id to SQL Lab logs (#8104) (@serenajiang)
- [#8098](https://github.com/apache/superset/pull/8098) [Hive Engine Spec] Fix latest partition logic (#8098) (@etr2460)
- [#8099](https://github.com/apache/superset/pull/8099) Allow resizing width of SQL Lab left bar / editor (#8099) (@betodealmeida)
- [#8106](https://github.com/apache/superset/pull/8106) Fix cache set kwargs (#8106) (@etr2460)
- [#8105](https://github.com/apache/superset/pull/8105) Fix sqla query cache keys function (#8105) (@etr2460)
- [#7569](https://github.com/apache/superset/pull/7569) refactor: separate vis-specific controls from centralized controls (#7569) (@felixcodes)
- [#8100](https://github.com/apache/superset/pull/8100) docs: remove unused release instruction (#8100) (@mistercrunch)
- [#8093](https://github.com/apache/superset/pull/8093) Move Darwin-specific JS libs to optional (#8093) (@friendzis)
- [#8097](https://github.com/apache/superset/pull/8097) [fix] checks for stopped queries (#8097) (@serenajiang)
- [#8087](https://github.com/apache/superset/pull/8087) fix: minor release/license related issues (#8087) (@mistercrunch)
- [#8083](https://github.com/apache/superset/pull/8083) feat: replace table and box plot vis with new plugins (#8083) (@kristw)
- [#8058](https://github.com/apache/superset/pull/8058) Add docstrings and typing to db_engine_specs and sql_parse (#8058) (@villebro)
- [#7908](https://github.com/apache/superset/pull/7908) [Feature] Dashboard filter indicators (#7908) (@graceguo-supercat)
- [#8078](https://github.com/apache/superset/pull/8078) Remove gevent installation as a separate layer (#8078) (@aspedrosa)
- [#8067](https://github.com/apache/superset/pull/8067) remove idna req from setup.py (#8067) (@DiggidyDave)
- [#8075](https://github.com/apache/superset/pull/8075) Move more Presto nested types behind feature flag (#8075) (@betodealmeida)
- [#8051](https://github.com/apache/superset/pull/8051) bump a set of test-related JS libs (#8051) (@mistercrunch)
- [#8035](https://github.com/apache/superset/pull/8035) Make package.json cross platform (#8035) (@fzzylogic)
- [#8057](https://github.com/apache/superset/pull/8057) Adding support for filter box in annotations (#8057) (@KKcorps)
- [#8042](https://github.com/apache/superset/pull/8042) Improve birth example dashboard (#8042) (@mistercrunch)
- [#8040](https://github.com/apache/superset/pull/8040) [viz] Revert dropna logic for pivot tables (#8040) (@john-bodley)
- [#8056](https://github.com/apache/superset/pull/8056) Add feature flag for Presto expand data (#8056) (@betodealmeida)
- [#8039](https://github.com/apache/superset/pull/8039) Disable flaky cypress test (#8039) (@mistercrunch)
- [#8045](https://github.com/apache/superset/pull/8045) Added WPSemantix to list of companies using Apache Superset in README.md file (#8045) (@semantiDan)
- [#8032](https://github.com/apache/superset/pull/8032) Fix bug where lists in queries cannot contain multiple types (#8032) (@serenajiang)
- [#8026](https://github.com/apache/superset/pull/8026) Two more organisations using Superset - Zalora, GFG (#8026) (@ksaagariconic)
- [#8018](https://github.com/apache/superset/pull/8018) [Dashboard] Hide slice titles when they're empty (#8018) (@etr2460)
- [#8016](https://github.com/apache/superset/pull/8016) Improve release instructions (#8016) (@mistercrunch)
- [#8011](https://github.com/apache/superset/pull/8011) [SQL Lab] Improve perf for filterable table rendering (#8011) (@etr2460)
- [#7822](https://github.com/apache/superset/pull/7822) Fix tooltips not visible for NVD3 charts on Firefox (#7822) (#7929) (@schoel-bis)
- [#8003](https://github.com/apache/superset/pull/8003) Added better display of NULL values in FilterableTable (as in SQL Lab Results) (#8003) (@semantiDan)

### 0.34.1 (2019/09/27 18:22 +00:00)
- [#8271](https://github.com/apache/superset/pull/8271) Fix: Missing time series datapoints in druid show up as absurd values in line chart (#8271) (@KKcorps)
- [#8265](https://github.com/apache/superset/pull/8265) Fixed korean translation error. (#8265) (@kuckjwi0928)
- [#8223](https://github.com/apache/superset/pull/8223) Fix sync failed when datasource is schema-less (#8223) (@zhaoyongjie)
- [#8231](https://github.com/apache/superset/pull/8231) [SQL Lab] Fix bug when filtering on results that include nulls (#8231) (@etr2460)
- [#8174](https://github.com/apache/superset/pull/8174) Bump flask-appbuilder to 2.1.13 (#8174) (@paulvic)
- [#8176](https://github.com/apache/superset/pull/8176) Bump FAB to 2.1.13 (#8176) (@dpgaspar)
- [#8209](https://github.com/apache/superset/pull/8209) [examples] Fix, sf population polygons div by zero error (#8209) (@dpgaspar)
- [#8070](https://github.com/apache/superset/pull/8070) [Explore view] Fix extra data fetch when user clicks Run Query (#8070) (@graceguo-supercat)
- [#8054](https://github.com/apache/superset/pull/8054) [sql lab] persist tables list in localStorage (#8054) (@graceguo-supercat)
- [#8077](https://github.com/apache/superset/pull/8077) Revert "Fixed Histogram visualization bug.  (#8077)" (#8145) (@etr2460)
- [#8044](https://github.com/apache/superset/pull/8044) fix: issues #8041 - bubble support for complex metrics (#8044) (@mistercrunch)
- [#8126](https://github.com/apache/superset/pull/8126) adding spaces missing from string concatenations (#8126) (@rusackas)
- [#8191](https://github.com/apache/superset/pull/8191) Update core.py (#8191) (@john-bodley)
- [#7951](https://github.com/apache/superset/pull/7951) [feat] Add d3 legend formatting for Arc, Polygon and Scatter deck.gl maps (#7951) (@thunter009)
- [#8181](https://github.com/apache/superset/pull/8181) [bugfix] Correctly quote table and schema in select_star (#8181) (@villebro)
- [#8180](https://github.com/apache/superset/pull/8180) Make orderby native sqla construct (#8180) (@villebro)
- [#8165](https://github.com/apache/superset/pull/8165) [bugfix] fix timegrain addon regression (#8165) (@villebro)
- [#8128](https://github.com/apache/superset/pull/8128) Add check for calls to cache_key_wrapper (#8128) (@villebro)
- [#8117](https://github.com/apache/superset/pull/8117) Fix to Werkzeug ProxyFix; expose ProxyFix configuration items (#8117) (@ericandrewmeadows)
- [#8117](https://github.com/apache/superset/pull/8077) Fixed Histogram visualization bug. (#8077) (@kuckjwi0928)
- [#8052](https://github.com/apache/superset/pull/8052) Set disableErrorBoundary in SuperChart to fix chart error handling (#8052) (@michellethomas)
- [#8049](https://github.com/apache/superset/pull/8049) fix: onSave datasource raises React error (#8049) (@mistercrunch)
- [#8037](https://github.com/apache/superset/pull/8037) fix: handle case where result exists but corresponding query cannot be found (#8037) (@serenajiang)
- [#8025](https://github.com/apache/superset/pull/8025) [bugfix] Fix deck_polygon metric bug and update examples chart (#8025) (@villebro)
- [#8014](https://github.com/apache/superset/pull/8014) [fix] Allow dashboard viewer auto refresh dashboard (#8014) (@graceguo-supercat)
- [#8013](https://github.com/apache/superset/pull/8013) Fix: There was an issue fetching the favorite status of this dashboard #6824 (#8013) (@arthurpduarte)

### 0.34.0 (2019/08/09 00:58 +00:00)
- [#7997](https://github.com/apache/superset/pull/7997) Event logger config takes instance instead of class (#7997) (@DiggidyDave)
- [#8006](https://github.com/apache/superset/pull/8006) Local config no longer fails to import silently (#8006) (@DiggidyDave)
- [#8002](https://github.com/apache/superset/pull/8002) [SQLLab] Fix, database api unlimited page size v2 (#8002) (@dpgaspar)
- [#7999](https://github.com/apache/superset/pull/7999) Setup FOSSA as part of CI (#7999) (@mistercrunch)
- [#7949](https://github.com/apache/superset/pull/7949) Update to fix the broken blueprints link (#7949) (@mmutiso)
- [#7981](https://github.com/apache/superset/pull/7981) Fix Pandas 0.24 DateOffset bug pt. 2 (#7981) (@villebro)
- [#7993](https://github.com/apache/superset/pull/7993) [Jinja] Make Presto template functions backwards compatible (#7993) (@etr2460)
- [#7998](https://github.com/apache/superset/pull/7998) [fix] reduce content in sql lab localStorage (#7998) (@graceguo-supercat)
- [#7985](https://github.com/apache/superset/pull/7985) Fix #7984 (#7985) (@mistercrunch)
- [#7986](https://github.com/apache/superset/pull/7986) Revert "Bump FAB to 2.1.8 (#7986)" (#7996) (@etr2460)
- [#7987](https://github.com/apache/superset/pull/7987) Revert "[database] Fix, Removes the limit for the page size (#7987)" (#7995) (@etr2460)
- [#7994](https://github.com/apache/superset/pull/7994) Bump nvd3 charts for tooltip fix (#7994) (@etr2460)
- [#7992](https://github.com/apache/superset/pull/7992) [init] Setting up cache before registering blueprints (#7992) (@john-bodley)
- [#7989](https://github.com/apache/superset/pull/7989) Bump @superset-ui versions (#7989) (@kristw)
- [#7987](https://github.com/apache/superset/pull/7987) [database] Fix, Removes the limit for the page size (#7987) (@dpgaspar)
- [#7986](https://github.com/apache/superset/pull/7986) Bump FAB to 2.1.8 (#7986) (@dpgaspar)
- [#7988](https://github.com/apache/superset/pull/7988) [flake8] Ignoring I202 (#7988) (@john-bodley)
- [#7977](https://github.com/apache/superset/pull/7977) [DB Engine] Support old and new Presto syntax (#7977) (@etr2460)
- [#7952](https://github.com/apache/superset/pull/7952) [security] Adding docstrings and type hints (#7952) (@john-bodley)
- [#7963](https://github.com/apache/superset/pull/7963) Remove collation info from MSSQL column type (#7963) (@villebro)
- [#7973](https://github.com/apache/superset/pull/7973) Bump sqlparse to 0.3.0 (#7973) (@villebro)
- [#7975](https://github.com/apache/superset/pull/7975) Fix for new Pandas API (#7975) (@betodealmeida)
- [#7643](https://github.com/apache/superset/pull/7643) 7620: Start removing dependencies on requests (#7643) (@sturmer)
- [#7965](https://github.com/apache/superset/pull/7965) Bump python requirements file (#7965) (@villebro)
- [#7964](https://github.com/apache/superset/pull/7964) Use python3 for black to support py>=3.6 (#7964) (@villebro)
- [#7955](https://github.com/apache/superset/pull/7955) Fix createDatasource (#7955) (@betodealmeida)
- [#7858](https://github.com/apache/superset/pull/7858) [fix] Isolate and improve performance on tagging system (#7858) (@betodealmeida)
- [#7943](https://github.com/apache/superset/pull/7943) Update .travis.yml (#7943) (@john-bodley)
- [#7932](https://github.com/apache/superset/pull/7932) Bump nvd3 chart plugin (#7932) (@etr2460)
- [#7924](https://github.com/apache/superset/pull/7924) [fix] bug on FixedOrMetricControl component causing issues with deck.gl polygon height + deck.gl scatter radius controls (#7924) (@thunter009)
- [#7935](https://github.com/apache/superset/pull/7935) [feature flag] Enforce csrf protection on explore_json endpoint (#7935) (@graceguo-supercat)
- [#7940](https://github.com/apache/superset/pull/7940) fixing error related to install codecove in travis (#7940) (@blcksrx)
- [#7933](https://github.com/apache/superset/pull/7933) [revert] Partial revert of #7888 (#7933) (@john-bodley)
- [#7918](https://github.com/apache/superset/pull/7918) [cli] New, command line option to create or set a db URI (#7918) (@dpgaspar)
- [#7926](https://github.com/apache/superset/pull/7926) Fix #7130 - SQL Lab table name autocomplete (#7926) (@mistercrunch)
- [#7920](https://github.com/apache/superset/pull/7920) [log] Disable Log view when FAB security views are disabled (#7920) (@dpgaspar)
- [#7930](https://github.com/apache/superset/pull/7930) [sqllab] Fix, #7928 query async not working (#7930) (@dpgaspar)
- [#7931](https://github.com/apache/superset/pull/7931) Fixing the build after travis upgraded Ubuntu (#7931) (@mistercrunch)
- [#7895](https://github.com/apache/superset/pull/7895) [dashboard] fix chart showing loading icon when filter updated immuned fields (#7895) (@graceguo-supercat)
- [#7864](https://github.com/apache/superset/pull/7864) [Profile] Fix 5xx when user not found (#7864) (@etr2460)
- [#7912](https://github.com/apache/superset/pull/7912) [sqllab] Fix limit parsing bug when using limit-offset comma notation (#7912) (@villebro)
- [#7896](https://github.com/apache/superset/pull/7896) [Bugfix] Remove prequery properties from query_obj (#7896) (@villebro)
- [#7892](https://github.com/apache/superset/pull/7892) Fix incorrect datasource_name in dashboard export (#7892) (@smacker)
- [#7894](https://github.com/apache/superset/pull/7894) Set owner to dashboards and charts on import (#7894) (@smacker)
- [#7665](https://github.com/apache/superset/pull/7665) [api] [database] New, migrate to new FAB API side by side (#7665) (@dpgaspar)
- [#7880](https://github.com/apache/superset/pull/7880) [migration] add unique constraint on dashboard_slices table (#7880) (@graceguo-supercat)
- [#7915](https://github.com/apache/superset/pull/7915) Bump nvd3 charts for responsive y axis fix (#7915) (@etr2460)
- [#7868](https://github.com/apache/superset/pull/7868) [SQL Lab] Fix TableSelector perf for large option sets (#7868) (@etr2460)
- [#7907](https://github.com/apache/superset/pull/7907) [Bugfix] Response header and response mismatch on explore result from sqllab (#7907) (@arpit-agarwal)
- [#7816](https://github.com/apache/superset/pull/7816) Add cache_key_wrapper to Jinja template processor (#7816) (@villebro)
- [#7898](https://github.com/apache/superset/pull/7898) [test] Fix test data remove slice_name (#7898) (@graceguo-supercat)
- [#7897](https://github.com/apache/superset/pull/7897) [fix] Adding space after -- for SQL comments (#7897) (@john-bodley)
- [#7744](https://github.com/apache/superset/pull/7744) Fix missing `gevent` extra dependency in Docker setup (#7744) (@bmfs)
- [#7888](https://github.com/apache/superset/pull/7888) [sqla] Adding check for invalid filter columns (#7888) (@john-bodley)
- [#7883](https://github.com/apache/superset/pull/7883) Sort dashboards exported json (#7883) (@smacker)
- [#7879](https://github.com/apache/superset/pull/7879) Remove unnecessary fields from dashboard exported json (#7879) (@smacker)
- [#7882](https://github.com/apache/superset/pull/7882) Corrected ISO codes on India Country Map (#7882) (@TheLastSultan)
- [#7881](https://github.com/apache/superset/pull/7881) [sql lab] improve TableElement controls (#7881) (@mistercrunch)
- [#7773](https://github.com/apache/superset/pull/7773) Improve examples & related tests (#7773) (@mistercrunch)
- [#7877](https://github.com/apache/superset/pull/7877) Avoid removing custom sql adhoc metric when columns change (#7877) (@michellethomas)
- [#7827](https://github.com/apache/superset/pull/7827) Fix docker configurations and docker installation guide. (#7827) (@ali-bahjati)
- [#7863](https://github.com/apache/superset/pull/7863) DruidEngineSpec: set allows_subquery to True (#7863) (@michalmisiewicz)
- [#7878](https://github.com/apache/superset/pull/7878) fix: add check to re-render only if underlying layers change (#7878) (@thunter009)
- [#7875](https://github.com/apache/superset/pull/7875) bug fix for all_database_access() call (#7875) (@rahul-rahul-sp)
- [#7872](https://github.com/apache/superset/pull/7872) [docs] Advise about celery 4.3.0 requirement on redis (#7872) (@dpgaspar)
- [#7853](https://github.com/apache/superset/pull/7853) [cypress] Disable chromeWebSecurity globally (#7853) (@graceguo-supercat)
- [#7852](https://github.com/apache/superset/pull/7852) Bump pandas to 0.24 (#7852) (@villebro)
- [#7866](https://github.com/apache/superset/pull/7866) [wip] fix: multi deck.gl bug fixes (pt 2) (#7866) (@thunter009)
- [#7867](https://github.com/apache/superset/pull/7867) Update tox.ini (#7867) (@john-bodley)
- [#7856](https://github.com/apache/superset/pull/7856) Adds the ability to replace/extend caching backend (#7856) (@robdiciuccio)
- [#7854](https://github.com/apache/superset/pull/7854) fix: multi deck.gl bug fixes (#7854) (@thunter009)
- [#7845](https://github.com/apache/superset/pull/7845) Make SHOW_STACKTRACE config apply across the board (#7845) (@mistercrunch)
- [#7848](https://github.com/apache/superset/pull/7848) [celery] Bump celery to 4.3.0 (#7848) (@dpgaspar)
- [#7850](https://github.com/apache/superset/pull/7850) Update down_revision to fix migrations (#7850) (@1AB9502)
- [#7843](https://github.com/apache/superset/pull/7843) Quick fix (#7843) (@betodealmeida)
- [#4725](https://github.com/apache/superset/pull/4725) Add "Published" feature to dashboards (#4725) (@Tresdon)
- [#7835](https://github.com/apache/superset/pull/7835) Update requirements.txt (#7835) (@john-bodley)
- [#7728](https://github.com/apache/superset/pull/7728) * hacky string coercion to fix bug in cli datasource export (#7728) (@Aylr)
- [#7717](https://github.com/apache/superset/pull/7717) Refactor testconn to use get_sqla_engine (#7717) (@thoralf-gutierrez)
- [#7837](https://github.com/apache/superset/pull/7837) Updating superset-ui/legacy-preset-chart-nvd3 to 0.10.35 (#7837) (@michellethomas)
- [#7830](https://github.com/apache/superset/pull/7830) Set up a few more pre-commit hook (#7830) (@mistercrunch)
- [#7705](https://github.com/apache/superset/pull/7705) [log] New, make action log configurable and generic (#7705) (@dpgaspar)
- [#7832](https://github.com/apache/superset/pull/7832) Bump FAB to 2.1.6 (#7832) (@dpgaspar)
- [#7817](https://github.com/apache/superset/pull/7817) Add missing 'babies.png' image (#7817) (@mistercrunch)
- [#7376](https://github.com/apache/superset/pull/7376) Fixing the examples (#7376) (@mistercrunch)
- [#7821](https://github.com/apache/superset/pull/7821) Add source{d} to user list in README.md (#7821) (@marnovo)
- [#7539](https://github.com/apache/superset/pull/7539) Improvements related to ASF release process (#7539) (@mistercrunch)
- [#7747](https://github.com/apache/superset/pull/7747) fix: unicode word cloud example (#7747) (@mistercrunch)
- [#7796](https://github.com/apache/superset/pull/7796) Added possibility to translate the phrase 'No results found' in FilterBox (#7796) (@dserkowski)
- [#7621](https://github.com/apache/superset/pull/7621) fix: Better error message for dashboard import (#7621) (@smacker)
- [#7812](https://github.com/apache/superset/pull/7812) [dashboard] Fix URLShortLinkButton position after click anchor link (#7812) (@graceguo-supercat)
- [#7653](https://github.com/apache/superset/pull/7653) [schema] Deprecating the table_columns.database_expression column (#7653) (@john-bodley)
- [#7810](https://github.com/apache/superset/pull/7810) Add second and minute grains (#7810) (@villebro)
- [#7813](https://github.com/apache/superset/pull/7813) Improve documentation (#7813) (@villebro)
- [#7799](https://github.com/apache/superset/pull/7799) [fix] Updating Pandas resample logic (#7799) (@john-bodley)
- [#7502](https://github.com/apache/superset/pull/7502) Add Table List Refresh Button (#7502) (@MarcusSorealheis)
- [#7809](https://github.com/apache/superset/pull/7809) [travis] Adding Black tox environment (#7809) (@john-bodley)
- [#7325](https://github.com/apache/superset/pull/7325) [Viz] transpose pivot table (#7325) (@zhaoyongjie)
- [#7435](https://github.com/apache/superset/pull/7435) Update messages.json (#7435) (@JesusEkie)
- [#7770](https://github.com/apache/superset/pull/7770) Autocomplete in the table browser in SQL lab is broken - Fix part 2 (#7770) (@khtruong)
- [#7755](https://github.com/apache/superset/pull/7755) [fix] Handling of non-existent datasource (#7755) (@john-bodley)
- [#7791](https://github.com/apache/superset/pull/7791) Improve performance for add slice container (#7791) (@etr2460)
- [#7801](https://github.com/apache/superset/pull/7801) add new user (#7801) (@pokyu)
- [#7777](https://github.com/apache/superset/pull/7777) Truncate data that is expanded (#7777) (@betodealmeida)
- [#7783](https://github.com/apache/superset/pull/7783) [SQL Lab] Add hard time limit fallback for async queries (#7783) (@etr2460)
- [#7788](https://github.com/apache/superset/pull/7788) Fix SQL editor tooltip to not cut off long column names (#7788) (@cguan7)
- [#7467](https://github.com/apache/superset/pull/7467) Change kv content-type to text/plain (#7467) (@rahul-rahul-sp)
- [#7787](https://github.com/apache/superset/pull/7787) Updating legacy-plugin-chart-heatmap to fix an issue with heatmap (#7787) (@michellethomas)
- [#7782](https://github.com/apache/superset/pull/7782) feat: query based on all partitions (#7782) (@khtruong)
- [#7767](https://github.com/apache/superset/pull/7767) bugfix: Oracle timegrains fail to render when wrapped in outer query (#7767) (@villebro)
- [#7769](https://github.com/apache/superset/pull/7769) [format] Using Black (#7769) (@john-bodley)
- [#7753](https://github.com/apache/superset/pull/7753) [testconn] Fixing response (#7753) (@john-bodley)
- [#7764](https://github.com/apache/superset/pull/7764) Show generic error msg and hide stacktrace if feature flag is enabled (#7764) (@rahul-rahul-sp)
- [#7605](https://github.com/apache/superset/pull/7605) chore: taking db dependencies out of requirements-dev.txt (#7605) (@mistercrunch)
- [#7749](https://github.com/apache/superset/pull/7749) Fix deck.gl sample charts with js (#7749) (@villebro)
- [#7011](https://github.com/apache/superset/pull/7011) fix(filterbox): fixed  runtime exception in filterbox for allow multiple selection is false (#7011) (@jitendra-kumawat)
- [#7756](https://github.com/apache/superset/pull/7756) Add csv upload support for BigQuery (#7756) (@villebro)
- [#7724](https://github.com/apache/superset/pull/7724) [security] [ui] Make security views use superset's list widget (#7724) (@dpgaspar)
- [#7750](https://github.com/apache/superset/pull/7750) Bump FAB to 2.1.5 (#7750) (@dpgaspar)
- [#7720](https://github.com/apache/superset/pull/7720) [SQL Lab] Add JSON modal when clicking on cells with JSON objects (#7720) (@etr2460)
- [#7745](https://github.com/apache/superset/pull/7745) [fix] Force refresh table list broken (#7745) (@betodealmeida)
- [#7736](https://github.com/apache/superset/pull/7736) Revert "Autocomplete in the table browser in SQL lab is broken (#7736)" (#7743) (@khtruong)
- [#7736](https://github.com/apache/superset/pull/7736) Autocomplete in the table browser in SQL lab is broken (#7736) (@khtruong)
- [#7646](https://github.com/apache/superset/pull/7646) compile column names (#7646) (@villebro)
- [#7722](https://github.com/apache/superset/pull/7722) [SQL Lab] Polish side pane animation (#7722) (@etr2460)
- [#7616](https://github.com/apache/superset/pull/7616) Fixing time comparison to look for past deltas (#7616) (@michellethomas)
- [#7729](https://github.com/apache/superset/pull/7729) Bump sqla to 1.3.5 (#7729) (@villebro)
- [#7652](https://github.com/apache/superset/pull/7652) Allowing withVerification to remove all options if none are valid (#7652) (@michellethomas)
- [#7679](https://github.com/apache/superset/pull/7679) css: add margin-top to ResultSet (#7679) (@mistercrunch)
- [#7723](https://github.com/apache/superset/pull/7723) [CSV Upload] Fix Index Column input filter (#7723) (@etr2460)
- [#7700](https://github.com/apache/superset/pull/7700) [dashboard] fix nested tab component visible logic (#7700) (@graceguo-supercat)
- [#7709](https://github.com/apache/superset/pull/7709) [docker] Fix docker-init missing FLASK_APP (#7709) (@dpgaspar)
- [#7701](https://github.com/apache/superset/pull/7701) Update @superset-ui/legacy-preset-chart-nvd3 (#7701) (@etr2460)
- [#7696](https://github.com/apache/superset/pull/7696) [docs] Fix, flask fab cli does not need app parameter (#7696) (@dpgaspar)
- [#7691](https://github.com/apache/superset/pull/7691) [SQL Lab] Fix proptypes warning (#7691) (@etr2460)
- [#7693](https://github.com/apache/superset/pull/7693) Render columns dynamically on wide tables (#7693) (@betodealmeida)
- [#7687](https://github.com/apache/superset/pull/7687) Add Intercom to Superset users (#7687) (@kate-gallo)
- [#7688](https://github.com/apache/superset/pull/7688) Adding 6play as users (#7688) (@CoryChaplin)
- [#7667](https://github.com/apache/superset/pull/7667) [epoch] Remove non-UTC epoch logic (#7667) (@john-bodley)
- [#7672](https://github.com/apache/superset/pull/7672) Update index.rst (#7672) (@john-bodley)
- [#7678](https://github.com/apache/superset/pull/7678) Revert "Allow bigint to be used as time column in Presto" #7670 (#7678) (@john-bodley)
- [#7073](https://github.com/apache/superset/pull/7073) [connectors] Make cluster/database and datasource/table unselectable in CRUD view (#7073) (@john-bodley)
- [#7598](https://github.com/apache/superset/pull/7598) adding command for seeing changes reflected. (#7598) (@MarcusSorealheis)
- [#7478](https://github.com/apache/superset/pull/7478) Bump FAB to 2.1.4 (#7478) (@dpgaspar)
- [#7526](https://github.com/apache/superset/pull/7526) Fixed SQL Lab Query Search scrolling issue(#7526) (#7674) (@rusackas)
- [#7676](https://github.com/apache/superset/pull/7676) Break up db_engine_specs (#7676) (@villebro)
- [#7392](https://github.com/apache/superset/pull/7392) Remove duplicate paragraph in celery tasks documentation (#7392) (@thoralf-gutierrez)
- [#7567](https://github.com/apache/superset/pull/7567) Add epoch funcs for BigQuery (#7567) (@villebro)
- [#7641](https://github.com/apache/superset/pull/7641) [SQL Lab] Clarify SQL Lab query and display limits (#7641) (@etr2460)
- [#7642](https://github.com/apache/superset/pull/7642) [dashboard] pass dashboard filters to share chart url in dropdown (#7642) (@graceguo-supercat)
- [#7572](https://github.com/apache/superset/pull/7572) [SQL Lab] Show warning when user used up localStorage (#7572) (@graceguo-supercat)
- [#7610](https://github.com/apache/superset/pull/7610) docs: Add Tenable to the List of Users (#7610) (@dflionis)
- [#7475](https://github.com/apache/superset/pull/7475) Apply DashboardFilter to the dashboards in SliceModeView (#7475) (@rahul-rahul-sp)
- [#7638](https://github.com/apache/superset/pull/7638) Add new escape characters to OnPasteSelect (#7638) (@1AB9502)
- [#7660](https://github.com/apache/superset/pull/7660) [docs] Fix, deprecate fabmanager cli (#7660) (@dpgaspar)
- [#5096](https://github.com/apache/superset/pull/5096) Revert "Boxplot should not require a datetime column (#5096)" (#7655) (@khtruong)
- [#7175](https://github.com/apache/superset/pull/7175) [SQL Lab] CTAS now uses the right async configuration (#7175) (@enricoberti)
- [#7647](https://github.com/apache/superset/pull/7647) [Profile] Fix react gravitar size prop type warning (#7647) (@etr2460)
- [#7618](https://github.com/apache/superset/pull/7618) Add Filter on DatabaseView that filters DBs Based on Role Access (#7618) (@dflionis)
- [#7640](https://github.com/apache/superset/pull/7640) [dashboard] click tab anchor link (#7640) (@graceguo-supercat)
- [#7632](https://github.com/apache/superset/pull/7632) Fix colors in ellipsis (#7632) (@betodealmeida)
- [#7433](https://github.com/apache/superset/pull/7433) Adding codecov targets and thresholds (#7433) (@michellethomas)
- [#7490](https://github.com/apache/superset/pull/7490) [fix] SQL parsing of table names (#7490) (@john-bodley)
- [#7494](https://github.com/apache/superset/pull/7494) make filter_values() macro to properly accept value from filter box with single value setting (#7494) (@jimhorng)
- [#7606](https://github.com/apache/superset/pull/7606) fix: SqlaColumn.type overflow on mysql (#7606) (@mistercrunch)
- [#7636](https://github.com/apache/superset/pull/7636) [query] Fix, remove not possible to order columns (#7636) (@dpgaspar)
- [#7635](https://github.com/apache/superset/pull/7635) Fixed Time Grain and Added Drill to README (#7635) (@cgivre)
- [#7593](https://github.com/apache/superset/pull/7593) fix: address issue #7458 (#7593) (@mistercrunch)
- [#7561](https://github.com/apache/superset/pull/7561) [FAB] set AppBuilder to update_perms=False (#7561) (@mistercrunch)
- [#7575](https://github.com/apache/superset/pull/7575) Alternative fix for #7559 (#7575) (@mistercrunch)
- [#7633](https://github.com/apache/superset/pull/7633) Wrapping up #7130 (#7633) (@mistercrunch)
- [#7617](https://github.com/apache/superset/pull/7617) Allow trailing spaces in simple filter values (#7617) (@etr2460)
- [#7622](https://github.com/apache/superset/pull/7622) [requirements] Bumping pydruid version (#7622) (@john-bodley)
- [#7624](https://github.com/apache/superset/pull/7624) [SQL Lab] Prevent failed query error from disappearing (#7624) (@etr2460)
- [#7628](https://github.com/apache/superset/pull/7628) [SQL Lab] Old query showing success state but not showing results (#7628) (@graceguo-supercat)
- [#7583](https://github.com/apache/superset/pull/7583) Update bug_report.md (#7583) (@john-bodley)
- [#7630](https://github.com/apache/superset/pull/7630) fix: handle presto columns with whitespace (#7630) (@khtruong)
- [#7625](https://github.com/apache/superset/pull/7625) View Presto row and array objects clearly in the data grid (#7625) (@khtruong)
- [#7627](https://github.com/apache/superset/pull/7627) Show expanded columns in gray in SQL Editor (#7627) (@betodealmeida)
- [#7525](https://github.com/apache/superset/pull/7525) Add relative start param for time filters (#7525) (@villebro)
- [#7594](https://github.com/apache/superset/pull/7594) [SQL Lab] fix unnecessary offline action (#7594) (@graceguo-supercat)
- [#7615](https://github.com/apache/superset/pull/7615) Fix SQL Lab window resizing layout bug (#7615) (@etr2460)
- [#7131](https://github.com/apache/superset/pull/7131) Make timestamp expression native SQLAlchemy element (#7131) (@villebro)
- [#6610](https://github.com/apache/superset/pull/6610) Add support for Apache Drill (#6610) (@cgivre)
- [#7550](https://github.com/apache/superset/pull/7550) Bump python libs, address insecure releases (#7550) (@mistercrunch)
- [#7579](https://github.com/apache/superset/pull/7579) Add "Auto" option to Mapbox visualization point radius (#7579) (@ali-bahjati)
- [#7379](https://github.com/apache/superset/pull/7379) Remove the use of Pandas' iloc() in  WorldMapViz (#7379) (@elukey)
- [#7453](https://github.com/apache/superset/pull/7453) Add support for period character in table names (#7453) (@villebro)
- [#7586](https://github.com/apache/superset/pull/7586) Remove aggregates from metric options if datasource has no columns (#7586) (@michellethomas)

### 0.32.0rc2.dev2 (2019/05/24 03:28 +00:00)
- [#7498](https://github.com/apache/superset/pull/7498) [sql lab]revert #4833 (#7498) (@graceguo-supercat)
- [#7576](https://github.com/apache/superset/pull/7576) add American Express to list of users on readme (#7576) (@TheLastSultan)
- [#7584](https://github.com/apache/superset/pull/7584) Add link to scheduled pipeline (#7584) (@betodealmeida)
- [#7559](https://github.com/apache/superset/pull/7559) Fix for polling queries (#7559) (@betodealmeida)
- [#7585](https://github.com/apache/superset/pull/7585) A few improvements to scheduling queries (#7585) (@betodealmeida)
- [#7468](https://github.com/apache/superset/pull/7468) Adding controls for verifying options (#7468) (@michellethomas)
- [#7570](https://github.com/apache/superset/pull/7570) [testconn] Explicit closing engine connection (#7570) (@john-bodley)
- [#7573](https://github.com/apache/superset/pull/7573) [ad-hoc] Fixing type for count distinct (#7573) (@john-bodley)
- [#7552](https://github.com/apache/superset/pull/7552) [cypress] fix accessing a cross-origin frame error (#7552) (@graceguo-supercat)
- [#7330](https://github.com/apache/superset/pull/7330) Add dotenv to dependencies (#7330) (@mistercrunch)
- [#5096](https://github.com/apache/superset/pull/5096) Boxplot should not require a datetime column (#5096) (@AxelMathei)
- [#7355](https://github.com/apache/superset/pull/7355) [security] New, deprecate merge_perm, FAB method is fixed (#7355) (@dpgaspar)
- [#7426](https://github.com/apache/superset/pull/7426) Rjurney master docs update (#7426) (@rjurney)
- [#7535](https://github.com/apache/superset/pull/7535) Disabling flask-talisman by default (#7535) (@mistercrunch)
- [#7556](https://github.com/apache/superset/pull/7556) feat: add header tooltip (#7556) (@khtruong)

### 0.33.0rc1 (2019/05/18 19:51 +00:00)
- [#7545](https://github.com/apache/superset/pull/7545) Show scheduled queries (#7545) (@betodealmeida)
- [#7544](https://github.com/apache/superset/pull/7544) Validate start/end when scheduling queries (#7544) (@betodealmeida)
- [#7529](https://github.com/apache/superset/pull/7529) Talisman config (#7529) (@craig-rueda)
- [#7523](https://github.com/apache/superset/pull/7523) [sql lab] Fix new query stuck at pending state (#7523) (@graceguo-supercat)
- [#7499](https://github.com/apache/superset/pull/7499) chore: Truncate progressbar percentage decimals (#7499) (#7517) (#7519) (@bearcage)
- [#7461](https://github.com/apache/superset/pull/7461) feat: Live query validation in the SQL Lab UI (#7461) (#7516) (#7518) (@bearcage)
- [#7507](https://github.com/apache/superset/pull/7507) fix: cache issue for api/v1/query (#7507) (@conglei)
- [#7506](https://github.com/apache/superset/pull/7506) Change Visual Properties tab label to Customize (#7506) (@felixcodes)
- [#7500](https://github.com/apache/superset/pull/7500) Flatten legacy preset charts (#7500) (@felixcodes)
- [#7443](https://github.com/apache/superset/pull/7443) [security] Adding Flask-Talisman (#7443) (@john-bodley)
- [#7485](https://github.com/apache/superset/pull/7485) Break line before LIMIT statement to prevent trailing comment issue (#7485) (@mistercrunch)
- [#7481](https://github.com/apache/superset/pull/7481) Add Chinese translation (#7481) (@cscainiao)
- [#7377](https://github.com/apache/superset/pull/7377) druid connector: avoid using 'dimensions' for scan queries (#7377) (@elukey)
- [#7464](https://github.com/apache/superset/pull/7464) Revised Chinese translation (#7464) (@cscainiao)
- [#7428](https://github.com/apache/superset/pull/7428) Refactor ConsoleLog (#7428) (@betodealmeida)
- [#7476](https://github.com/apache/superset/pull/7476) fix: alter sql columns to long text #7463 (#7476) (@khtruong)
- [#7233](https://github.com/apache/superset/pull/7233) [dashboard] After update filter, trigger new queries when charts are visible (#7233) (@graceguo-supercat)
- [#7297](https://github.com/apache/superset/pull/7297) bugfix: Improve support for special characters in schema and table names (#7297) (@villebro)
- [#7375](https://github.com/apache/superset/pull/7375) fix: calendar heatmap examples (#7375) (@mistercrunch)
- [#7471](https://github.com/apache/superset/pull/7471) Late import for optional lib pyhive (#7471) (@mistercrunch)
- [#7452](https://github.com/apache/superset/pull/7452) Adds missing metric sum__SP_RUR_TOTL (#7452) (@rjurney)
- [#7422](https://github.com/apache/superset/pull/7422) feat: Add `validate_sql_json` endpoint for checking that a given sql query is valid for the chosen database (#7422) (#7462) (@bearcage)
- [#7416](https://github.com/apache/superset/pull/7416) feat: Scheduling queries from SQL Lab (#7416) (#7446) (@DiggidyDave)
- [#7445](https://github.com/apache/superset/pull/7445) feat: view presto row objects in data grid (#7445) (@khtruong)
- [#7434](https://github.com/apache/superset/pull/7434) Quick fix to address deadlock issue (#7434) (@craig-rueda)
- [#7402](https://github.com/apache/superset/pull/7402) add chinese translate (#7402) (@cscainiao)
- [#7374](https://github.com/apache/superset/pull/7374) [fix] Fixing SQL parsing issue (#7374) (@john-bodley)
- [#6604](https://github.com/apache/superset/pull/6604) Added additional German translations to string file (#6604) (@KilimAnnejaro)
- [#7427](https://github.com/apache/superset/pull/7427) Fixes dashboard export button missing download and #7353 (#7427) (@rjurney)
- [#7421](https://github.com/apache/superset/pull/7421) Removed --console-log and superset runserver (#7421) (@rjurney)
- [#7413](https://github.com/apache/superset/pull/7413) feature: see Presto row and array data types (#7413) (@DiggidyDave)
- [#7350](https://github.com/apache/superset/pull/7350) Refactor out controlUtils.js module + unit tests (#7350) (@mistercrunch)
- [#7410](https://github.com/apache/superset/pull/7410) Setting renderTrigger on label_colors (#7410) (@michellethomas)
- [#7326](https://github.com/apache/superset/pull/7326) [annotations] Improves UX on annotation validation, start_dttm, end_dttm (#7326) (@dpgaspar)
- [#7323](https://github.com/apache/superset/pull/7323) Bump FAB to 2.0.0 (#7323) (@dpgaspar)
- [#7411](https://github.com/apache/superset/pull/7411) [SQL Lab] Increase timeout threshold for offline check (#7411) (@graceguo-supercat)
- [#7390](https://github.com/apache/superset/pull/7390) [dashboard] allow user re-order top-level tabs (#7390) (@graceguo-supercat)
- [#7407](https://github.com/apache/superset/pull/7407) Added living goods as among the users of Superset (#7407) (@chelule)
- [#7365](https://github.com/apache/superset/pull/7365) Fix NoneType bug & fill the test recipients with original recipients if empty (#7365) (@tssujt)
- [929fb6b](https://github.com/apache/superset/commit/929fb6bbb8fdc5c03ba4f88898c91183ab2bad11) Merge branch 'lyftga' (@mistercrunch)
- [#5453](https://github.com/apache/superset/pull/5453) [schema] Updating the base metric schema (#5453) (@john-bodley)
- [#7181](https://github.com/apache/superset/pull/7181) Store last selected dashboard in sessionStorage (#7181) (@leakingoxide)
- [#7371](https://github.com/apache/superset/pull/7371) [schema] Adding commits and removing unnecessary foreign-key definitions (#7371) (@john-bodley)
- [#7360](https://github.com/apache/superset/pull/7360) SUPERSET-8: Update text in docs copyright footer (#7360) (@andrewmusselman)
- [#7359](https://github.com/apache/superset/pull/7359) SUPERSET-7: Docker compose config version breaks on Ubuntu 16.04 (#7359) (@andrewmusselman)
- [#7087](https://github.com/apache/superset/pull/7087) [bubbles] issue when using duplicated metrics (#7087) (@mistercrunch)
- [#7331](https://github.com/apache/superset/pull/7331) remove backendSync.json (#7331) (@kristw)
- [#7338](https://github.com/apache/superset/pull/7338) Fix raw HTML in SliceAdder (#7338) (@mistercrunch)
- [#7348](https://github.com/apache/superset/pull/7348) Feature flag for client cache (#7348) (@betodealmeida)
- [#7361](https://github.com/apache/superset/pull/7361) Update 937d04c16b64_update_datasources.py (#7361) (@john-bodley)
- [#5452](https://github.com/apache/superset/pull/5452) [schema] Updating the base column schema (#5452) (@john-bodley)
- [#7342](https://github.com/apache/superset/pull/7342) Add type anno (#7342) (@craig-rueda)
- [#7358](https://github.com/apache/superset/pull/7358) limit tables/views returned if schema is not provided (#7358) (@datability-io)
- [#5451](https://github.com/apache/superset/pull/5451) [schema] Updating the datasources schema (#5451) (@john-bodley)
- [#7084](https://github.com/apache/superset/pull/7084) [wtforms] Strip leading/trailing whitespace (#7084) (@john-bodley)
- [#7347](https://github.com/apache/superset/pull/7347) fix: do not save colors without a color scheme (#7347) (@khtruong)
- [#7341](https://github.com/apache/superset/pull/7341) Create issue_label_bot.yaml (#7341) (@hamelsmu)
- [#7345](https://github.com/apache/superset/pull/7345) improve not rich tooltip (#7345) (@datability-io)
- [#6936](https://github.com/apache/superset/pull/6936) Allow Gamma and Alpha to access '/users/userinfo/' (#6936) (@mistercrunch)
- [#7013](https://github.com/apache/superset/pull/7013) [table] highlight selected <td>s (#7013) (@mistercrunch)
- [#7335](https://github.com/apache/superset/pull/7335) fixes #6353 by changing tag on base image (#7335) (@connor924)
- [#7076](https://github.com/apache/superset/pull/7076) Fix #7056 'Unhashable type' in paired t-test chart (#7076) (@mistercrunch)
- [#7329](https://github.com/apache/superset/pull/7329) [docs] improve the RELEASING.md docs (#7329) (@mistercrunch)

### 0.32.0rc2 (2019/04/19 22:08 +00:00)
- [#7313](https://github.com/apache/superset/pull/7313) filter out all nan series (#7313) (@datability-io)
- [5f28027](https://github.com/apache/superset/commit/5f28027ce745dfda67e18fe7df8468184400be50) Merging lyftga into master (@mistercrunch)

### 0.32.0rc1 (2019/04/19 05:26 +00:00)
- [#7161](https://github.com/apache/superset/pull/7161) fix: typos in translations placeholders (#7161) (@leakingoxide)
- [#7231](https://github.com/apache/superset/pull/7231) Fix control validation handling (#7231) (@mistercrunch)
- [#7234](https://github.com/apache/superset/pull/7234) Adding permission for can_only_access_owned_queries (#7234) (@michellethomas)
- [#7289](https://github.com/apache/superset/pull/7289) fix: propagate color mapping from dashboard to charts (#7289) (@khtruong)
- [#7318](https://github.com/apache/superset/pull/7318) Remove LICENSE entry around dataset (#7318) (@mistercrunch)
- [#7294](https://github.com/apache/superset/pull/7294) feat: bump superset-ui versions to 0.11 (#7294) (@kristw)
- [#7314](https://github.com/apache/superset/pull/7314) [load_examples] download data at runtime (#7314) (@mistercrunch)
- [#7302](https://github.com/apache/superset/pull/7302) fix: time series table (#7302) (#7312) (@michellethomas)
- [#7315](https://github.com/apache/superset/pull/7315) Update AceEditorWrapper.jsx (#7315) (@ddna1021)
- [#7113](https://github.com/apache/superset/pull/7113) [slice] Fix, remove duplicate label_columns property (#7113) (@dpgaspar)
- [#7302](https://github.com/apache/superset/pull/7302) fix: time series table (#7302) (@khtruong)
- [#6959](https://github.com/apache/superset/pull/6959) Revert "bugfix: improve 'Time Table' (#6959)" (#7304) (@khtruong)
- [#7296](https://github.com/apache/superset/pull/7296) Add details to release instructions (#7296) (@mistercrunch)
- [#7271](https://github.com/apache/superset/pull/7271) Add all database access permission to 'Alpha' role (#7271) (@mistercrunch)
- [#7293](https://github.com/apache/superset/pull/7293) chore: update legacy packages (#7293) (@khtruong)
- [#7292](https://github.com/apache/superset/pull/7292) Bump nvd3 dep and 'npm audit fix' (#7292) (@mistercrunch)
- [#6959](https://github.com/apache/superset/pull/6959) bugfix: improve 'Time Table' (#6959) (@mistercrunch)
- [#7261](https://github.com/apache/superset/pull/7261) Minor improvements to <Hotkeys /> component (#7261) (@mistercrunch)
- [#7100](https://github.com/apache/superset/pull/7100) Improve code smell, use py3k super() call (#7100) (@zhaoyongjie)
- [#7279](https://github.com/apache/superset/pull/7279) fix: make the bot more descriptive (#7279) (@kristw)
- [#7278](https://github.com/apache/superset/pull/7278) fix: make SIPs exempt from stale bots (#7278) (@kristw)
- [#7211](https://github.com/apache/superset/pull/7211) Deprecate npm run backend-sync and related logic (#7211) (@mistercrunch)
- [#7249](https://github.com/apache/superset/pull/7249) chore: add bot config files and update issue templates (#7249) (@kristw)
- [#7263](https://github.com/apache/superset/pull/7263) Run 'npm audit fix' to address vulnerabilities (#7263) (@mistercrunch)
- [#7268](https://github.com/apache/superset/pull/7268) chore: update big number package (#7268) (@khtruong)
- [#7266](https://github.com/apache/superset/pull/7266) Do not add tag to non-saved objects (#7266) (@betodealmeida)
- [#7121](https://github.com/apache/superset/pull/7121) [SQL Lab] fix table metadata loading spinner (#7121) (@mistercrunch)
- [#7009](https://github.com/apache/superset/pull/7009) Revert "Fix issues around Database permissions (#7009)" (#7267) (@betodealmeida)
- [#7264](https://github.com/apache/superset/pull/7264) Add extra bucket when max outside range (#7264) (@betodealmeida)
- [#7260](https://github.com/apache/superset/pull/7260) Bump pydruid to 0.5.2 (#7260) (@betodealmeida)
- [#7258](https://github.com/apache/superset/pull/7258) update migration Revision for #6945 (#7258) (@graceguo-supercat)
- [#7255](https://github.com/apache/superset/pull/7255) Pass viz type to GET requests (#7255) (@betodealmeida)
- [#7256](https://github.com/apache/superset/pull/7256) fix: Handle rendering a single point (#7256) (@khtruong)
- [#6964](https://github.com/apache/superset/pull/6964) feat(dashboard): direct link to single chart/tab/header in dashboard (#6964) (@graceguo-supercat)
- [#6945](https://github.com/apache/superset/pull/6945) add parent ids into Dashboard layout metadata (#6945) (@graceguo-supercat)
- [#7164](https://github.com/apache/superset/pull/7164) [cache] Render label when cached (#7164) (@john-bodley)
- [#7217](https://github.com/apache/superset/pull/7217) fix: Remove ASF license from github templates (PR and issues) (#7217) (@mistercrunch)
- [#7248](https://github.com/apache/superset/pull/7248) Fix refresh frequency (#7248) (@betodealmeida)
- [#7227](https://github.com/apache/superset/pull/7227) Improve cache (#7227) (@betodealmeida)
- [#7251](https://github.com/apache/superset/pull/7251) Add link to documentation (#7251) (@betodealmeida)
- [#7250](https://github.com/apache/superset/pull/7250) Fix partition query in Presto (#7250) (@betodealmeida)
- [#7105](https://github.com/apache/superset/pull/7105) Fix logo / branding files (#7105) (@mistercrunch)
- [#7247](https://github.com/apache/superset/pull/7247) Fix spinning in Welcome page (#7247) (@betodealmeida)
- [#7245](https://github.com/apache/superset/pull/7245) increment version numbers (#7245) (@datability-io)
- [#7212](https://github.com/apache/superset/pull/7212) Tweaks to word cloud controls (#7212) (@mistercrunch)
- [#7220](https://github.com/apache/superset/pull/7220) [filter_box] allow empty filters list (#7220) (#7244) (@michellethomas)
- [#7198](https://github.com/apache/superset/pull/7198) Fix race condition when fetching results in SQL Lab (#7198) (#7242) (@michellethomas)
- [#7240](https://github.com/apache/superset/pull/7240) Fix for tagging backend (#7240) (@betodealmeida)
- [#7232](https://github.com/apache/superset/pull/7232) increment version number for nvd3 (#7232) (@datability-io)
- [#7220](https://github.com/apache/superset/pull/7220) [filter_box] allow empty filters list (#7220) (@mistercrunch)
- [#7221](https://github.com/apache/superset/pull/7221) fix: give a more accurate time (#7221) (@khtruong)
- [#7228](https://github.com/apache/superset/pull/7228) Fix time grain after revert (#7228) (@betodealmeida)
- [#7226](https://github.com/apache/superset/pull/7226) fix: add check for polygon tooltips (#7226) (@khtruong)
- [#7148](https://github.com/apache/superset/pull/7148) Celery task for warming up cache (#7148) (@betodealmeida)
- [#7206](https://github.com/apache/superset/pull/7206) feat: [lyftga] add tooltips to deck.gl viz types (#7206) (@khtruong)
- [e714dc1](https://github.com/apache/superset/commit/e714dc19feb42fefbc573272edc06a50963b0849) Merge branch 'master' into lyftga (@mistercrunch)
- [#7215](https://github.com/apache/superset/pull/7215) Fix `<Select>` clearable (#7215) (@mistercrunch)
- [#7218](https://github.com/apache/superset/pull/7218) Allow bigint to be used as time column in Presto (#7218) (@betodealmeida)
- [#7032](https://github.com/apache/superset/pull/7032) Fetch charts with GET to benefit from browser cache and conditional requests (#7032) (@betodealmeida)
- [#7210](https://github.com/apache/superset/pull/7210) chore: revert bignumber.js patch for charts and reapply the original bignumber.js change to SQL editor in an opt-in fashion (#7210) (@xtinec)
- [#7123](https://github.com/apache/superset/pull/7123) [Data Source Editor] Use type of NUMERIC instead of NUMBER and make editor accept freeform types (#7123) (@agrawaldevesh)
- [#7208](https://github.com/apache/superset/pull/7208) fix: [lyftga] pass the latest deckgl props (#7208) (@khtruong)
- [#7205](https://github.com/apache/superset/pull/7205) Update necessary packages (#7205) (@khtruong)
- [#6979](https://github.com/apache/superset/pull/6979) Show tooltip with time frame (#6979) (@betodealmeida)
- [#6978](https://github.com/apache/superset/pull/6978) Fix time filter control (#6978) (@betodealmeida)
- [#7003](https://github.com/apache/superset/pull/7003) feat: add ability to change font size in big number (#7003) (@khtruong)
- [#7052](https://github.com/apache/superset/pull/7052) Allow LIMIT to be specified in parameters (#7052) (@betodealmeida)
- [#7135](https://github.com/apache/superset/pull/7135) [Lyft-GA] Enable color consistency in a dashboard (#7135) (@khtruong)
- [#7162](https://github.com/apache/superset/pull/7162) Revert PR #6933 (#7162) (@betodealmeida)
- [#7198](https://github.com/apache/superset/pull/7198) Fix race condition when fetching results in SQL Lab (#7198) (@betodealmeida)
- [#7137](https://github.com/apache/superset/pull/7137) Change number format default (#7137) (@khtruong)
- [#7188](https://github.com/apache/superset/pull/7188) fix: deck.gl polygon tooltip (#7188) (@datability-io)
- [#7036](https://github.com/apache/superset/pull/7036) [security] make it easier to redefine Alpha/Gamma (#7036) (@mistercrunch)
- [#7197](https://github.com/apache/superset/pull/7197) [fix] a typo in variable name (#7197) (@graceguo-supercat)
- [#7194](https://github.com/apache/superset/pull/7194) feat: added i18n statements to sqllab (#7194) (@enricoberti)
- [#7180](https://github.com/apache/superset/pull/7180) fix: do not crash when a vis type is disabled. (#7180) (@kristw)
- [#7126](https://github.com/apache/superset/pull/7126) fix(sqllab): remove duplicate selector in style file (#7126) (@rasmi-ranjan-guavus)
- [#7179](https://github.com/apache/superset/pull/7179) fix PRODUCT-67916 Click OK button cannot close error message modal (#7179) (@hannahsquier)
- [#7166](https://github.com/apache/superset/pull/7166) Update __init__.py (#7166) (@john-bodley)
- [#7120](https://github.com/apache/superset/pull/7120) [SQL Lab] Show tooltip on schema and table select options (#7120) (@enricoberti)
- [#7176](https://github.com/apache/superset/pull/7176) chore: add main pull request template (#7176) (@michellethomas)
- [#7159](https://github.com/apache/superset/pull/7159) Adding pull request templates (#7159) (@michellethomas)
- [#7168](https://github.com/apache/superset/pull/7168) Fix double scroll bars when content of sql result table overflows horizontally (#7168) (@xtinec)
- [#7158](https://github.com/apache/superset/pull/7158) docs: add cloudsmith to company list (#7158) (@alancarson)
- [#7145](https://github.com/apache/superset/pull/7145) [migration] Fixing issue with fb13d49b72f9 downgrade (#7145) (@john-bodley)
- [#7144](https://github.com/apache/superset/pull/7144) [migration] Fixing issue with c82ee8a39623 downgrade (#7144) (@john-bodley)
- [#7104](https://github.com/apache/superset/pull/7104) [bugfix] SQL Lab 'Filter Results' doesn't stick (#7104) (@mistercrunch)
- [#7138](https://github.com/apache/superset/pull/7138) Injectable statsd client (#7138) (@DiggidyDave)
- [#7118](https://github.com/apache/superset/pull/7118) fix: Superset logo link when logged out (#7118) (@enricoberti)
- [#7115](https://github.com/apache/superset/pull/7115) chore: updating extra requires (#7115) (@john-bodley)
- [#7111](https://github.com/apache/superset/pull/7111) [SQL Lab] Avoid closing save query modal on backdrop click (#7111) (@enricoberti)
- [#7103](https://github.com/apache/superset/pull/7103) [docs] CONTRIBUTING.md - how to setup SQL Lab in async mode (#7103) (@mistercrunch)
- [#7132](https://github.com/apache/superset/pull/7132) Bump python lib croniter to an existing version (#7132) (@mistercrunch)
- [#7122](https://github.com/apache/superset/pull/7122) Remove super verbose `logging.debug` call (#7122) (@mistercrunch)
- [#7090](https://github.com/apache/superset/pull/7090) fix(useless-self-assignment): correct useless-self-assignment (#7090) (@rasmi-ranjan-guavus)
- [#7054](https://github.com/apache/superset/pull/7054) Scripts & instructions to craft official Apache source releases (#7054) (@mistercrunch)
- [#6795](https://github.com/apache/superset/pull/6795) Add HTTP Basic Auth for Druid (Issue #4776) (#6795) (@donbowman)
- [#7102](https://github.com/apache/superset/pull/7102) SQL editor layout makeover (#7102) (@xtinec)
- [#7117](https://github.com/apache/superset/pull/7117) [docs] improve UPDATING.md around 0.31's [now] optional deps (#7117) (@mistercrunch)
- [#7106](https://github.com/apache/superset/pull/7106) Use metric name instead of metric in filter box (#7106) (@michellethomas)
- [#7078](https://github.com/apache/superset/pull/7078) [forms] Fix handling of NULLs (#7078) (@john-bodley)
- [#7099](https://github.com/apache/superset/pull/7099) Bump SQLAlchemy to 1.3 (#7099) (@villebro)
- [#7053](https://github.com/apache/superset/pull/7053) [mypy] Adding mypy linting (#7053) (@john-bodley)
- [#7063](https://github.com/apache/superset/pull/7063) handle null column_name in sqla and druid models (#7063) (@graceguo-supercat)
- [#7097](https://github.com/apache/superset/pull/7097) [api] add `available_domains/` endpoint (#7097) (@williaster)
- [#5741](https://github.com/apache/superset/pull/5741) [Dashboard] Keeping refresh frequency value in Dashboard (#5741) (@zhaoyongjie)
- [#7088](https://github.com/apache/superset/pull/7088) fix: bump pivot table version (#7088) (@kristw)
- [#5835](https://github.com/apache/superset/pull/5835) [bugfix] throw "TypeError: 'NoneType'..." when save chart to new/existing dash. (#5835) (@hitdemo)
- [#7085](https://github.com/apache/superset/pull/7085) Bump FAB to 1.12.5 (#7085) (@dpgaspar)
- [#7082](https://github.com/apache/superset/pull/7082) [SQL Lab] Improved query and results tabs rendering reliability (#7082) (@enricoberti)
- [#7066](https://github.com/apache/superset/pull/7066) Fix filter_box migration PR #6523 (#7066) (@mistercrunch)
- [#4905](https://github.com/apache/superset/pull/4905) [missing values] Removing replacing missing values (#4905) (@john-bodley)
- [#7069](https://github.com/apache/superset/pull/7069) [SQL Lab] Fixed TableElement sorting functionality and tests (#7069) (#7070) (@enricoberti)
- [#7068](https://github.com/apache/superset/pull/7068) [SQL Lab] Copy to clipboard should work on the preview tab too (#7068) (#7071) (@enricoberti)
- [#7060](https://github.com/apache/superset/pull/7060) [tox] Enforcing consistent ordering (#7060) (@john-bodley)
- [#7062](https://github.com/apache/superset/pull/7062) Handle memoryview like bytes instances and decode bytes to utf8 (#7062) (@villebro)
- [#7065](https://github.com/apache/superset/pull/7065) docs: add hostnfly to company list (#7065) (@kristw)
- [84109be](https://github.com/apache/superset/commit/84109be1bfa42480865b7bc766de2680fbd9aba2) fix: search for visualizations with case-insensitive keyword (@bipinsoniguavus)

### 0.31.0rc18 (2019/03/19 06:32 +00:00)
- [#7012](https://github.com/apache/superset/pull/7012) docs: fix RST issues while building docs (#7012) (@mistercrunch)
- [#6938](https://github.com/apache/superset/pull/6938) feat: add Bulgaria to country map (#6938) (@djok)
- [#7051](https://github.com/apache/superset/pull/7051) feat: bump superset-ui-plugins to v0.10.2 (#7051) (@kristw)

### 0.31.0rc1 (2019/03/18 23:17 +00:00)
- [#7028](https://github.com/apache/superset/pull/7028) Adding warning message for sqllab save query (#7028) (@michellethomas)
- [#7037](https://github.com/apache/superset/pull/7037) [datasource] Ensuring consistent behavior of datasource editing/saving. (#7037) (@john-bodley)
- [#7040](https://github.com/apache/superset/pull/7040) [fix] Use HTTPS, not HTTP wherever practical (#7040) (@hajdbo)
- [#7009](https://github.com/apache/superset/pull/7009) Fix issues around Database permissions (#7009) (@mistercrunch)
- [#7046](https://github.com/apache/superset/pull/7046) [fix] explore chart from dashboard missed slice title (#7046) (@graceguo-supercat)
- [#6821](https://github.com/apache/superset/pull/6821) User can turn off download - export csv from a dashboard (#6821) (@emacip)
- [#6993](https://github.com/apache/superset/pull/6993) fix: groupable only columns populating in filters (#6993) (@1AB9502)
- [#7038](https://github.com/apache/superset/pull/7038) [fix] Cursor jumping when editing chart and dashboard titles (#7038) (@graceguo-supercat)
- [#7029](https://github.com/apache/superset/pull/7029) [sqlparse] Fixing table name extraction for ill-defined query (#7029) (@john-bodley)
- [#7039](https://github.com/apache/superset/pull/7039) [api/v1][query_obj] add default prequeries array (#7039) (@williaster)
- [#6987](https://github.com/apache/superset/pull/6987) Add handling for memoryview (#6987) (@villebro)
- [#7034](https://github.com/apache/superset/pull/7034) fix(css-selector): Fixed incorrect css-selector for CRUD page reported by sonarqube report as a critical vulnerability (#7034) (@bipinsoniguavus)
- [#7035](https://github.com/apache/superset/pull/7035) fix inaccurate data calculation with adata rolling and contribution (#7035) (@conglei)
- [#7027](https://github.com/apache/superset/pull/7027) [WIP] fix user specified JSON metadata not updating dashboard on refresh (#7027) (@thunter009)
- [#7007](https://github.com/apache/superset/pull/7007) [db-engine-spec] Aligning Hive/Presto partition logic (#7007) (@john-bodley)
- [#7020](https://github.com/apache/superset/pull/7020) Changing time table viz to pass formatTime a date (#7020) (@michellethomas)
- [#7000](https://github.com/apache/superset/pull/7000) Bump sqlalchemy dependency (#7000) (@mistercrunch)
- [#7005](https://github.com/apache/superset/pull/7005) fixing a broken link for the ORM documentation (#7005) (@MarcusSorealheis)
- [#6989](https://github.com/apache/superset/pull/6989) [fix] /superset/slice/id url is too long (#6989) (@graceguo-supercat)
- [#6990](https://github.com/apache/superset/pull/6990) Retrieve df from get_df_payload to hit cache (#6990) (@villebro)
- [#7002](https://github.com/apache/superset/pull/7002) Split tags migration (#7002) (@xtinec)
- [#6980](https://github.com/apache/superset/pull/6980) fix(fetch-datasource-meta-data): Chart data is not showing after in charts added by edit mode (#6980) (@ankursinghal2005)
- [#6982](https://github.com/apache/superset/pull/6982) refactor: bump @superset-ui versions  (#6982) (@kristw)
- [#6956](https://github.com/apache/superset/pull/6956) Adding custom control overrides (#6956) (@michellethomas)
- [#6925](https://github.com/apache/superset/pull/6925) docs: warn that docker installation instructions are `contrib/` (#6925) (@mistercrunch)
- [#6849](https://github.com/apache/superset/pull/6849) Sort Chart Types based on Usage (#6849) (@datability-io)
- [#6963](https://github.com/apache/superset/pull/6963) [sql-parse] Fixing LIMIT exceptions (#6963) (@john-bodley)
- [#6859](https://github.com/apache/superset/pull/6859) [dashboard editor] use the theme's btn-primary (#6859) (@mistercrunch)
- [#6857](https://github.com/apache/superset/pull/6857) auto-set 'Is Temporal' to true where column_name == '__time' (#6857) (@mistercrunch)
- [#6962](https://github.com/apache/superset/pull/6962) Enhancement of query context and object. (#6962) (@conglei)
- [#6968](https://github.com/apache/superset/pull/6968) [date-filter] Adding minus infinity (#6968) (@john-bodley)
- [#6971](https://github.com/apache/superset/pull/6971) [csv-upload] Fixing message encoding (#6971) (@john-bodley)
- [#6965](https://github.com/apache/superset/pull/6965) Exclude venv for python linter to ignore (#6965) (@khtruong)
- [#6933](https://github.com/apache/superset/pull/6933) Show charts and dashboards based also on database permissions (#6933) (@betodealmeida)
- [#6952](https://github.com/apache/superset/pull/6952) re-added deleted example file (#6952) (@srggrs)
- [#6958](https://github.com/apache/superset/pull/6958) VIZ-190 fix (#6958) (@khtruong)
- [#6955](https://github.com/apache/superset/pull/6955) All french translations (#6955) (@Benji81)
- [#6808](https://github.com/apache/superset/pull/6808) Allow for dynamic feature flags (#6808) (@mistercrunch)
- [#6953](https://github.com/apache/superset/pull/6953) Fix deck.gl form data (#6953) (@betodealmeida)
- [#6912](https://github.com/apache/superset/pull/6912) Remove Cypress from package.json (#6912) (@mistercrunch)
- [#6904](https://github.com/apache/superset/pull/6904) [js deps] fix dependencies vulnerabilities (#6904) (@mistercrunch)
- [#6905](https://github.com/apache/superset/pull/6905) Erase previously shown chart on error (#6905) (@mistercrunch)
- [#6944](https://github.com/apache/superset/pull/6944) Fixes #6842: Refreshes all metadata and datasource (#6944) (@prashant-shahi)
- [#6937](https://github.com/apache/superset/pull/6937) Fix rendering regression from the introduction of bignumber (#6937) (@xtinec)
- [#6927](https://github.com/apache/superset/pull/6927) [datasource editor] Add description and label fields (#6927) (@moonboots)
- [#6786](https://github.com/apache/superset/pull/6786) Remove redundant UTC casts (#6786) (@villebro)
- [#6831](https://github.com/apache/superset/pull/6831) Do label name mutation before anything else on the dataframe (#6831) (@agrawaldevesh)
- [#6934](https://github.com/apache/superset/pull/6934) [fix] fix for css not loading on docker dev mode (#6934) (@iaperez)
- [#6897](https://github.com/apache/superset/pull/6897) Force quotes on non-expression time grains on Postgres (#6897) (@villebro)
- [#6847](https://github.com/apache/superset/pull/6847) Refactor dataframe and column name mutation logic (#6847) (@villebro)
- [#6920](https://github.com/apache/superset/pull/6920) Update CHANGELOG.md (#6920) (@wushenchao)
- [#6922](https://github.com/apache/superset/pull/6922) [fix] minor fix for Superset logger (#6922) (@graceguo-supercat)
- [#6816](https://github.com/apache/superset/pull/6816) Adding dropdown to DatasourceControl and ability to change datasource (#6816) (@michellethomas)
- [#6923](https://github.com/apache/superset/pull/6923) Add a safety check before getting clientHeight (#6923) (@xtinec)
- [#6917](https://github.com/apache/superset/pull/6917) Fix database typeahead in SQL Lab (#6917) (@betodealmeida)
- [#6895](https://github.com/apache/superset/pull/6895) Fix tooltip (#6895) (@betodealmeida)
- [#6903](https://github.com/apache/superset/pull/6903) [box plot] add X tick layout control (#6903) (@mistercrunch)
- [#6911](https://github.com/apache/superset/pull/6911) Add show metadata button back to the explore view (#6911) (@xtinec)
- [#6867](https://github.com/apache/superset/pull/6867) Raise exception if long or lat not set in mapbox viz (#6867) (@villebro)
- [#6885](https://github.com/apache/superset/pull/6885) add Filters copy change (#6885) (@MarcusSorealheis)
- [#6894](https://github.com/apache/superset/pull/6894) Fix npm warning by bumping @superset-ui version (#6894) (@kristw)
- [#6901](https://github.com/apache/superset/pull/6901) [fix] Typo on config comments for SILENCE_FAB (#6901) (@dpgaspar)
- [#6879](https://github.com/apache/superset/pull/6879) Improve Superset logger (#6879) (@graceguo-supercat)
- [#6884](https://github.com/apache/superset/pull/6884) remove dead code (#6884) (@kristw)
- [#6862](https://github.com/apache/superset/pull/6862) [sqla] Fixing order-by for non-inner-joins (#6862) (@john-bodley)
- [#6869](https://github.com/apache/superset/pull/6869) Adding template_params to datasource editor for sqla tables (#6869) (@michellethomas)
- [#6882](https://github.com/apache/superset/pull/6882) [ci] take #2, improve build times by saving TerserPlugin cache (#6882) (@mistercrunch)
- [#6872](https://github.com/apache/superset/pull/6872) Relayout SQL Editor (#6872) (@xtinec)
- [#6880](https://github.com/apache/superset/pull/6880) Update webpack config to facilitate debugging charts via npm link (#6880) (@kristw)
- [#6874](https://github.com/apache/superset/pull/6874) Speed up CI by caching TerserPlugin cache (#6874) (@mistercrunch)
- [#6838](https://github.com/apache/superset/pull/6838) Use chart plugins and remove code under visualizations (#6838) (@kristw)
- [#6865](https://github.com/apache/superset/pull/6865) Update docs for pinot support (#6865) (@agrawaldevesh)
- [#6845](https://github.com/apache/superset/pull/6845) [main] Disable resetting main DB attributes (#6845) (@john-bodley)
- [#6870](https://github.com/apache/superset/pull/6870) Docs: update user list in README (#6870) (@haaspt)
- [#6832](https://github.com/apache/superset/pull/6832) Adding chart-id to chartrenderer (#6832) (@kakoni)
- [#6848](https://github.com/apache/superset/pull/6848) Adding BigQuery to the list of supported DBs. (#6848) (@pabloem)
- [#6854](https://github.com/apache/superset/pull/6854) Bump FAB to 1.12.3 (#6854) (@mistercrunch)
- [#6852](https://github.com/apache/superset/pull/6852) Fixing issue where tooltip gets hidden on dashboard for all charts (#6852) (@michellethomas)
- [#6840](https://github.com/apache/superset/pull/6840) [config] clarifications around SUPERSET_WEBSERVER_TIMEOUT (#6840) (@mistercrunch)
- [#6844](https://github.com/apache/superset/pull/6844) fix dist-bar overflow css (#6844) (@kristw)
- [#6828](https://github.com/apache/superset/pull/6828) Add check for invalid color scheme (#6828) (@kristw)
- [#6839](https://github.com/apache/superset/pull/6839) Use SuperChart from package and remove one in apache (#6839) (@kristw)
- [#6830](https://github.com/apache/superset/pull/6830) update @superset-ui/packages (#6830) (@kristw)
- [#6829](https://github.com/apache/superset/pull/6829) Fix line chart overflowing the right side (#6829) (@kristw)
- [#6815](https://github.com/apache/superset/pull/6815) Make the target path of the superset logo configuable (#6815) (@xtinec)
- [#6823](https://github.com/apache/superset/pull/6823) Backend only tagging system (#6823) (@betodealmeida)
- [#6802](https://github.com/apache/superset/pull/6802) Removing additional unguarded calls to JSON.stringify (#6802) (@mrmcduff)
- [#6826](https://github.com/apache/superset/pull/6826) added docs on proper function call for db mutator (#6826) (@hughhhh)
- [#6719](https://github.com/apache/superset/pull/6719) Adding support for Pinot (#6719) (@agrawaldevesh)
- [#6811](https://github.com/apache/superset/pull/6811) Add .standalone class to <body> when in standalone mode (#6811) (@raphaelmerx)
- [#6793](https://github.com/apache/superset/pull/6793) [sql lab] improve table name detection in free form SQL (#6793) (@mistercrunch)
- [#6722](https://github.com/apache/superset/pull/6722) SelectControl hackery: Fixing freeform select and allowing group by and non group-by column selectors to take in arbitrary expressions including select-all semantics. (#6722) (@agrawaldevesh)
- [#5445](https://github.com/apache/superset/pull/5445) [wtforms] Using wtforms-json which supports None (#5445) (@john-bodley)
- [#6809](https://github.com/apache/superset/pull/6809) Add Korean translations (#6809) (@wonjin911)
- [#6745](https://github.com/apache/superset/pull/6745) Omnibar (#6745) (@hughhhh)
- [#6721](https://github.com/apache/superset/pull/6721) Summary: Introduce configs for default relative end time and the epoch-tz (#6721) (@agrawaldevesh)

### test_tag (2019/02/01 23:07 +00:00)
- [#6805](https://github.com/apache/superset/pull/6805) Merge pull request #6805 from lyft/xtinec--fix-sticky-tooltip (@lyft)
- [#6801](https://github.com/apache/superset/pull/6801) Add missing license (#6801) (@mistercrunch)
- [#6781](https://github.com/apache/superset/pull/6781) Merge pull request #6781 from lyft/xtinec--merge-feature-flags (@lyft)
- [501340b](https://github.com/apache/superset/commit/501340b5db07d0ec1711dccf0a7e4669fde77192) Fix sticky tooltips on nvd3 vizzes (@xtinec)
- [19b3753](https://github.com/apache/superset/commit/19b3753d2c4dd6826f73feeb9db253edf9761c28) Move feature flag utility function into superset/__init__.py (@xtinec)
- [#6800](https://github.com/apache/superset/pull/6800) fix: don't remove leading new line (#6800) (@AlexRRR)
- [#6783](https://github.com/apache/superset/pull/6783) [cosmetic] TableSelector use <i> instead of <Button> for refresh (#6783) (@mistercrunch)
- [#6797](https://github.com/apache/superset/pull/6797) Merge pull request #6797 from lyft/VIZ-187 (@lyft)
- [a09348d](https://github.com/apache/superset/commit/a09348d0ec27463a394d9914dcd5cbfd5670a5ee) Fix playslider (@betodealmeida)
- [#6790](https://github.com/apache/superset/pull/6790) Add Korean Translation (#6790) (@wonjin911)
- [#6777](https://github.com/apache/superset/pull/6777) Revert "Removing uniqueness constraints on tables table" (#6777) (@john-bodley)
- [b70a9ae](https://github.com/apache/superset/commit/b70a9ae524ce4ec66695bbc62a0991d98e78e6df) Merge default feature flags and user defined feature flags (@xtinec)
- [#6764](https://github.com/apache/superset/pull/6764) Allow any column to be filterable or groupable (#6764) (@agrawaldevesh)
- [#6782](https://github.com/apache/superset/pull/6782) [sql lab] fix stuck offline (#6782) (@mistercrunch)

### 0.29.0rc8 (2019/01/30 05:37 +00:00)
- [#6772](https://github.com/apache/superset/pull/6772) creating new circular-json safe stringify and replacing one call (#6772) (@mrmcduff)
- [#6690](https://github.com/apache/superset/pull/6690) Improve Unicode support for MSSQL (#6690) (@villebro)
- [#6718](https://github.com/apache/superset/pull/6718) Fix uniqueness constraints on tables table (#6718) (@agrawaldevesh)
- [#6762](https://github.com/apache/superset/pull/6762) fix #6760 (#6762) (@wonjin911)
- [#6766](https://github.com/apache/superset/pull/6766) [docs] improve upgrading instructions (#6766) (@mistercrunch)
- [#6769](https://github.com/apache/superset/pull/6769) [fix] Add action for update chart id (#6769) (@graceguo-supercat)
- [#6765](https://github.com/apache/superset/pull/6765) [fix] `pandas`>=0.24.0 datetimelike API changes (#6765) (@zihengCat)
- [#6755](https://github.com/apache/superset/pull/6755) [docs] bump cryptography lib version in docs (#6755) (@mistercrunch)
- [#6754](https://github.com/apache/superset/pull/6754) [cosmetic] Align table sort icons to the left (#6754) (@mistercrunch)
- [#6358](https://github.com/apache/superset/pull/6358) Fixing sort issue with area chart and adding tests (#6358) (@michellethomas)
- [#6756](https://github.com/apache/superset/pull/6756) fix dashboard links in welcome page (#6756) (@hughhhh)
- [#6758](https://github.com/apache/superset/pull/6758) Update User List in README.md (#6758) (@davidkohcw)
- [#6751](https://github.com/apache/superset/pull/6751) bump PyHive version for prod requirements.txt (#6751) (@MarcusSorealheis)
- [#6752](https://github.com/apache/superset/pull/6752) [fix] JS error out when rename a new chart (#6752) (@graceguo-supercat)
- [#6546](https://github.com/apache/superset/pull/6546) Make it easier to select dropdown options in control tests (#6546) (@michellethomas)
- [#6720](https://github.com/apache/superset/pull/6720) A few fixes for Presto connection (#6720) (@agrawaldevesh)
- [#6725](https://github.com/apache/superset/pull/6725) [cosmetic] remove 'List' prefix from list headers (#6725) (@mistercrunch)
- [#6741](https://github.com/apache/superset/pull/6741) Add iframe and markup legacy plugin (#6741) (@kristw)
- [#6742](https://github.com/apache/superset/pull/6742) Update gitignore (#6742) (@kristw)
- [#6730](https://github.com/apache/superset/pull/6730) Adding a note about 0.30 to updating (#6730) (@michellethomas)
- [#6740](https://github.com/apache/superset/pull/6740) Remove test URL (#6740) (@betodealmeida)
- [#6739](https://github.com/apache/superset/pull/6739) Allow specifying custom width for logo (#6739) (@betodealmeida)
- [#6738](https://github.com/apache/superset/pull/6738) Add disclaimer and remove counter (#6738) (@bolkedebruin)
- [#6732](https://github.com/apache/superset/pull/6732) Add licenses to translations (#6732) (@bolkedebruin)
- [#6526](https://github.com/apache/superset/pull/6526) Hotkeys in Explore View (#6526) (@hughhhh)
- [#6731](https://github.com/apache/superset/pull/6731) Add cc-by 4.0 for geojson files (#6731) (@bolkedebruin)
- [#6696](https://github.com/apache/superset/pull/6696) Making thrift, pyhive and tableschema as extra_requires (#6696) (@mistercrunch)
- [#6701](https://github.com/apache/superset/pull/6701) Update CONTRIBUTING.md based on SIP-13 and add how to use labels (#6701) (@kristw)
- [#6677](https://github.com/apache/superset/pull/6677) Fix setup.py ASF issues (#6677) (@bolkedebruin)
- [#6698](https://github.com/apache/superset/pull/6698) Fix link to SQLAlchemy docs about database URLs format (#6698) (@akovalyov)
- [#6631](https://github.com/apache/superset/pull/6631) Revert "Truncate long labels (#6631)" (#6723) (@mistercrunch)
- [#6729](https://github.com/apache/superset/pull/6729) Merge heads (#6729) (@betodealmeida)
- [#6695](https://github.com/apache/superset/pull/6695) Allow empty results in Hive (from SET, eg) (#6695) (@betodealmeida)
- [#6717](https://github.com/apache/superset/pull/6717) Insert a space after auto complete (#6717) (@betodealmeida)
- [#6686](https://github.com/apache/superset/pull/6686) Expose more columns in saved queries API (#6686) (@betodealmeida)
- [#6687](https://github.com/apache/superset/pull/6687) Add `extra` column to `SavedQuery` (#6687) (@betodealmeida)
- [#5827](https://github.com/apache/superset/pull/5827) Improve support for BigQuery, Redshift, Oracle, Db2, Snowflake (#5827) (@villebro)
- [#6693](https://github.com/apache/superset/pull/6693) Explicitly declare flags as flags (#6693) (@jeffreythewang)
- [#6627](https://github.com/apache/superset/pull/6627) [cosmetic] remove margin-bottom on dropdowns (#6627) (@mistercrunch)
- [#6711](https://github.com/apache/superset/pull/6711) More ASF licenses (css + html/jinja) (#6711) (@mistercrunch)
- [#6670](https://github.com/apache/superset/pull/6670) Add universal "New" button (#6670) (@mistercrunch)
- [#6703](https://github.com/apache/superset/pull/6703) Trim query before parsing (#6703) (@betodealmeida)
- [#6709](https://github.com/apache/superset/pull/6709) Add more format shims (#6709) (@kristw)
- [#6702](https://github.com/apache/superset/pull/6702) Fix Text field to edit SQL snippet of a metric is not large enough (#6702) (@soboko)
- [#5461](https://github.com/apache/superset/pull/5461) Deprecate auto-generated metrics (#5461) (@mistercrunch)
- [#6699](https://github.com/apache/superset/pull/6699) Fix url_param macro when param is missing (#6699) (@mistercrunch)
- [#6700](https://github.com/apache/superset/pull/6700) Bump some of the requirements-dev.txt (#6700) (@mistercrunch)
- [#6682](https://github.com/apache/superset/pull/6682) Update README.md (#6682) (@Yukinoshita-Yukino)
- [#5800](https://github.com/apache/superset/pull/5800) Apply ASF licenses throughout the code base (#5800) (@mistercrunch)
- [#6046](https://github.com/apache/superset/pull/6046) [table editor] allow selecting physical table (#6046) (@mistercrunch)
- [#6689](https://github.com/apache/superset/pull/6689) Committing some licenses to fix master (#6689) (@mistercrunch)
- [#6591](https://github.com/apache/superset/pull/6591) Fix for #6590: Numeric values in columns sometimes returned as quoted strings  (#6591) (@soboko)
- [#6600](https://github.com/apache/superset/pull/6600) Add doc about translation using poedit (#6600) (@zhouyao1994)
- [#6631](https://github.com/apache/superset/pull/6631) Truncate long labels (#6631) (@betodealmeida)
- [#6436](https://github.com/apache/superset/pull/6436) [bugfix] show results in query history & revert #5848 (#6436) (@youngyjd)
- [#6621](https://github.com/apache/superset/pull/6621) Add fix for pyodbc+mssql (#6621) (@chinhngt)
- [#6673](https://github.com/apache/superset/pull/6673) Remove dep on unidecode (#6673) (@mistercrunch)
- [#6678](https://github.com/apache/superset/pull/6678) Update Dockerfile (#6678) (@kocomic)
- [#6512](https://github.com/apache/superset/pull/6512) Fix scheduled reports for mysql (#6512) (@mahendra)
- [#6663](https://github.com/apache/superset/pull/6663) Add Apache Rat for license checks (#6663) (@bolkedebruin)
- [#6671](https://github.com/apache/superset/pull/6671) Add NOTICE file and include initial third party licenses (#6671) (@bolkedebruin)
- [#6669](https://github.com/apache/superset/pull/6669) Remove bad git conflicts from Readme (#6669) (@kaxil)
- [#6617](https://github.com/apache/superset/pull/6617) #6588 Clear all other query tabs (#6617) (@zhaoyongjie)
- [#6629](https://github.com/apache/superset/pull/6629) [README] use a numbered list instead of bullets for org list (#6629) (@mistercrunch)
- [#6523](https://github.com/apache/superset/pull/6523) Improving Filter Box (#6523) (@mistercrunch)
- [#6662](https://github.com/apache/superset/pull/6662) Minor doc fix for superset (#6662) (@feng-tao)
- [#6628](https://github.com/apache/superset/pull/6628) [pie] allow formating nubmers on pie chart (#6628) (@mistercrunch)
- [#6497](https://github.com/apache/superset/pull/6497) pass source to db api mutator (#6497) (@timifasubaa)
- [#6630](https://github.com/apache/superset/pull/6630) Add kuaishou to README.md (#6630) (@zhaoyu89730105)
- [#6614](https://github.com/apache/superset/pull/6614) data point no clipEdge (#6614) (@zhaoyu89730105)
- [#6625](https://github.com/apache/superset/pull/6625) Bump requirements (#6625) (@mahendra)
- [#6626](https://github.com/apache/superset/pull/6626) Improve padding in NVD3Vis (#6626) (@betodealmeida)
- [#6607](https://github.com/apache/superset/pull/6607) Upgrade webpack-dev-server to fix 'npm audit' issue (#6607) (@mistercrunch)
- [#6578](https://github.com/apache/superset/pull/6578) Improve false negative on AlteredSliceTag (#6578) (@mistercrunch)
- [#6593](https://github.com/apache/superset/pull/6593) Introduce a more visible resize grabber to the SQL editor (#6593) (@xtinec)
- [#6271](https://github.com/apache/superset/pull/6271) fix(i18n) syntax errors detected by grammarly while translating (#6271) (@joebordes)
- [#6609](https://github.com/apache/superset/pull/6609) Upgrade gsheetsdb (#6609) (@betodealmeida)
- [#6003](https://github.com/apache/superset/pull/6003) Make NULL value grouping keys show up properly in rich tooltip (#6003) (@hmanuel)
- [#6449](https://github.com/apache/superset/pull/6449) [fix] url shortner for long explore url (#6449) (@graceguo-supercat)
- [#6574](https://github.com/apache/superset/pull/6574) Fix 'Uncaught TypeError: Cannot read property 'value' of undefined' #6556 (#6574) (@mistercrunch)
- [#6596](https://github.com/apache/superset/pull/6596) shift labels down along y-axis (#6596) (@MarcusSorealheis)
- [#6598](https://github.com/apache/superset/pull/6598) Fix bug: some word not translate in js. (#6598) (@zhouyao1994)
- [#6592](https://github.com/apache/superset/pull/6592) add chinese translate (#6592) (@zhouyao1994)
- [#6504](https://github.com/apache/superset/pull/6504) Enhance Docker (#6504) (@oliviermichaelis)
- [#6573](https://github.com/apache/superset/pull/6573) Finish move to babel 7 (#6573) (@mistercrunch)
- [#6581](https://github.com/apache/superset/pull/6581) Using batch_op in db migration 0b1f1ab473c0 (#6581) (@mistercrunch)
- [#6576](https://github.com/apache/superset/pull/6576) [bugfix] moving from reactable to reactable-arc fork (#6576) (@mistercrunch)
- [#6575](https://github.com/apache/superset/pull/6575) Change margin for slice description in charts for the dashboard view (#6575) (@BrayanArrieta)
- [#6580](https://github.com/apache/superset/pull/6580) fixing issue #6572 with Oracle date handling (#6580) (@ghsalem)
- [#6564](https://github.com/apache/superset/pull/6564) [design] use angle icons instead of carets for expandable panels (#6564) (@mistercrunch)
- [#6571](https://github.com/apache/superset/pull/6571) Fix multi/dual when no right y axis (#6571) (@betodealmeida)
- [#6516](https://github.com/apache/superset/pull/6516) Fix: updated required cryptography version to 2.4.2 to resolve #6509 (#6516) (@haaspt)
- [#6569](https://github.com/apache/superset/pull/6569) fix #6530 and add some other chinese translation (#6569) (@shizidushu)
- [#6563](https://github.com/apache/superset/pull/6563) json_iso_dttm_ser use for TableViz (#6563) (@kakoni)
- [#5769](https://github.com/apache/superset/pull/5769) [refactor] moving some datasource-related code to the frontend (#5769) (@mistercrunch)
- [#6567](https://github.com/apache/superset/pull/6567) Adding missing slash (#6567) (@kakoni)
- [#6112](https://github.com/apache/superset/pull/6112) [SQL Lab] Allow running multiple statements (#6112) (@mistercrunch)
- [#6540](https://github.com/apache/superset/pull/6540) Make boto3/botocore installation optional (#6540) (@mistercrunch)
- [#6541](https://github.com/apache/superset/pull/6541) [SIP-14] remove dependency on yarn in favor of npm (#6541) (@mistercrunch)
- [#6560](https://github.com/apache/superset/pull/6560) Fix multiple db_migrations heads (#6560) (@mistercrunch)
- [#6544](https://github.com/apache/superset/pull/6544) Make owner a m2m relation on datasources (#6544) (@leakingoxide)
- [#6550](https://github.com/apache/superset/pull/6550) minor, auto tune debug mode when use flask_env (#6550) (@zhaoyongjie)
- [#6519](https://github.com/apache/superset/pull/6519) [RfC] Fix URL too long (#6519) (@mistercrunch)
- [#6522](https://github.com/apache/superset/pull/6522) [cosmetic] add css no-wrap on CRUD's last modified (#6522) (@mistercrunch)
- [#6553](https://github.com/apache/superset/pull/6553) Secure unsecured views and prevent regressions (#6553) (@mistercrunch)
- [#6545](https://github.com/apache/superset/pull/6545) Fix deck.gl Polygon not show (#6545) (@MukaJiTrue)
- [#6551](https://github.com/apache/superset/pull/6551) fix addr_str format bug (#6551) (@DoNobody)
- [#6532](https://github.com/apache/superset/pull/6532) Increase size of column `name` in table `ab_view_meu` (#6532) (@betodealmeida)
- [#6548](https://github.com/apache/superset/pull/6548) Pass security manager to QUERY_LOGGER (#6548) (@betodealmeida)
- [#5977](https://github.com/apache/superset/pull/5977) filter_values documentation fix (#5977) (@AMilkov)
- [#6398](https://github.com/apache/superset/pull/6398) Remove note about snowflake-sqlalchemy stable version regression (#6398) (@villebro)
- [#6549](https://github.com/apache/superset/pull/6549) Documentation Correction to use http.server for Python3 (#6549) (@chnkya)
- [#6534](https://github.com/apache/superset/pull/6534) Fix string value displaying NaN (#6534) (@wenchma)
- [#6547](https://github.com/apache/superset/pull/6547) adding in a dependency version to fix an error with Flask CLI (#6547) (@MarcusSorealheis)
- [#6507](https://github.com/apache/superset/pull/6507) Add docker files to gitignore (#6507) (@hughhhh)
- [#6539](https://github.com/apache/superset/pull/6539) Refactor teradata to new time_grain_functions spec (#6539) (@villebro)
- [#6536](https://github.com/apache/superset/pull/6536) Avoid resetting margin to 0 (#6536) (@michellethomas)
- [#6531](https://github.com/apache/superset/pull/6531) [warm] Enforcing consistent form-data (#6531) (@john-bodley)
- [#6510](https://github.com/apache/superset/pull/6510) Update requests version (#6510) (@betodealmeida)
- [#6409](https://github.com/apache/superset/pull/6409) Fix malformed table in docs/visualization.rst (#6409) (@sekikn)
- [#6513](https://github.com/apache/superset/pull/6513) Update contributing.md with latest local dev instructions (#6513) (@kristw)
- [#6087](https://github.com/apache/superset/pull/6087) Typo: Fixed link (#6087) (@httpsOmkar)
- [#5294](https://github.com/apache/superset/pull/5294) [SIP-3] Scheduled email reports for Slices / Dashboards (#5294) (@mahendra)
- [#5915](https://github.com/apache/superset/pull/5915) Google spreadsheets (#5915) (@betodealmeida)
- [#6498](https://github.com/apache/superset/pull/6498) Adding tests for time table, formatting, and annotations (#6498) (@michellethomas)
- [#6457](https://github.com/apache/superset/pull/6457) Fix Annotation (#6457) (@aboganas)
- [#6493](https://github.com/apache/superset/pull/6493) Pypi has a 60mb package size limit, and we're over (#6493) (@mistercrunch)
- [#6454](https://github.com/apache/superset/pull/6454) Bump pydruid to 0.5.0 (#6454) (@mistercrunch)
- [#6484](https://github.com/apache/superset/pull/6484) Hook for auditing queries (#6484) (@betodealmeida)
- [#6461](https://github.com/apache/superset/pull/6461) Add copy to clipboard buttons in explore and sqllab (#6461) (@leakingoxide)
- [#6483](https://github.com/apache/superset/pull/6483) [Bug Fix]Prevent re-rendering when non-instant controls change (#6483) (@conglei)

### 0.29.0rc6 (2018/12/05 19:27 +00:00)
- [#6432](https://github.com/apache/superset/pull/6432) FixBug druidMetricModels No attribute get_perm (#6432) (@zhaoyu89730105)
- [#6430](https://github.com/apache/superset/pull/6430) Add See Tableview Form button to the Datasource Editor modal (#6430) (@leakingoxide)
- [#6485](https://github.com/apache/superset/pull/6485) make loading icon bigger (#6485) (@youngyjd)
- [#6470](https://github.com/apache/superset/pull/6470) Use @superset-ui/number-format and @superset-ui/time-format for formatting.  (#6470) (@kristw)
- [#6448](https://github.com/apache/superset/pull/6448) Use py3's f-strings instead of s.format(**locals()) (#6448) (@mistercrunch)

### 0.29.0rc5 (2018/12/01 20:39 +00:00)
- [#6469](https://github.com/apache/superset/pull/6469) Update sqllab.rst (#6469) (@mrshu)
- [#5039](https://github.com/apache/superset/pull/5039) allow domain sharding in frontend (#5039) (@graceguo-supercat)
- [#6464](https://github.com/apache/superset/pull/6464) Update `@superset-ui/colors` (#6464) (@kristw)
- [#6423](https://github.com/apache/superset/pull/6423) [SIP-5] Build metrics in query_object in the client (#6423) (@williaster)
- [#6465](https://github.com/apache/superset/pull/6465) Fixing error when clearing big number (#6465) (@michellethomas)
- [#6376](https://github.com/apache/superset/pull/6376) [READY] Update SuperChart onRenderXXX listeners (#6376) (@kristw)
- [e06f873](https://github.com/apache/superset/commit/e06f87304c4448eeb2ca80ff34468f4d620572bd) Adding a comment for metrictype values (@xtinec)
- [c11e9c8](https://github.com/apache/superset/commit/c11e9c8b675340a1349dce105257375f6acbcaee) [SIP-5] Build metrics in query_object in the client (@xtinec)
- [a4597af](https://github.com/apache/superset/commit/a4597afee0ca368110cf76f81c7016a6b609b492) addressing PR comments (@xtinec)
- [#6458](https://github.com/apache/superset/pull/6458) fix metadata cache bug (#6458) (@youngyjd)
- [#6459](https://github.com/apache/superset/pull/6459) override get_view_names in PrestoEngineSpec (#6459) (@youngyjd)
- [#6453](https://github.com/apache/superset/pull/6453) Ensure that dttm is of same timezone as epoch_with_tz (#6453) (@villebro)
- [#6444](https://github.com/apache/superset/pull/6444) replace missing round function in d3 to fix MapBox (#6444) (@aboganas)
- [#4961](https://github.com/apache/superset/pull/4961) Deprecate database attribute allow_run_sync (#4961) (@mistercrunch)
- [#6445](https://github.com/apache/superset/pull/6445) fix Calendar Heatmap (#6445) (@aboganas)
- [#6451](https://github.com/apache/superset/pull/6451) fix sunburst breadcrumbs (#6451) (@aboganas)
- [#6419](https://github.com/apache/superset/pull/6419) Rename Druid to Apache Druid (Incubating) (#6419) (@Fokko)
- [#6401](https://github.com/apache/superset/pull/6401) [Docs] Make sure venv is py3 and export app (#6401) (@hughhhh)
- [#5966](https://github.com/apache/superset/pull/5966) Improve development experience with Docker (#5966) (@victornoel)
- [#6438](https://github.com/apache/superset/pull/6438) [fix] edit chart title cause JS error (#6438) (@graceguo-supercat)
- [#5164](https://github.com/apache/superset/pull/5164) Remove coordinator in Druid Cluster config (#5164) (#6443) (@jiaz)
- [#6439](https://github.com/apache/superset/pull/6439) Grammatical Error (#6439) (@pavitranrambo)
- [#6422](https://github.com/apache/superset/pull/6422) [logging] Add render failure error into log (#6422) (@graceguo-supercat)
- [#6428](https://github.com/apache/superset/pull/6428) Updated local dev instructions to include missing step (#6428) (@craig-rueda)
- [#6417](https://github.com/apache/superset/pull/6417) [bugfix] Display raw value in addition to ERROR (#6417) (@kristw)
- [#6433](https://github.com/apache/superset/pull/6433) FixBug sqlMetricModels No attribute get_perm (#6433) (@zhaoyu89730105)
- [#6435](https://github.com/apache/superset/pull/6435) Fix French typos (#6435) (@cjauvin)
- [#6406](https://github.com/apache/superset/pull/6406) Link to the ASF's code of conduct (#6406) (@mistercrunch)
- [#6412](https://github.com/apache/superset/pull/6412) use same xaxis formatter for line chart tooltip (#6412) (@kristw)
- [#6298](https://github.com/apache/superset/pull/6298) Reduce data loaded before loading tests (#6298) (@timifasubaa)
- [#6410](https://github.com/apache/superset/pull/6410) Update README.md (#6410) (@evans)
- [#6365](https://github.com/apache/superset/pull/6365) [bugfix] deckgl legend is not interactive (#6365) (@mistercrunch)
- [#6391](https://github.com/apache/superset/pull/6391) Minor improvements to Histogram viz (#6391) (@mistercrunch)
- [#6407](https://github.com/apache/superset/pull/6407) Adding cypress tests for showing errors, time range filter, and verbose name (#6407) (@michellethomas)
- [#6364](https://github.com/apache/superset/pull/6364) 'Fligth' filename typo (#6364) (@andy-clapson)
- [#6388](https://github.com/apache/superset/pull/6388) Expose Sqllab status in databases list view (#6388) (@zhaoyongjie)
- [#6405](https://github.com/apache/superset/pull/6405) [fix] view results in sql lab (#6405) (@graceguo-supercat)
- [#6363](https://github.com/apache/superset/pull/6363) [bugfix] deck.gl grid&hex don't respond to zoom&drag (#6363) (@mistercrunch)
- [#6399](https://github.com/apache/superset/pull/6399) Fix adhoc metrics in Polygon (#6399) (@mistercrunch)
- [#6377](https://github.com/apache/superset/pull/6377) [SIP-5] QueryBuilder in the client for granularity and groupby in word cloud (#6377) (@xtinec)
- [#6378](https://github.com/apache/superset/pull/6378) [migration]clean up __from and __to parameters in dashboard json_metadata (#6378) (@graceguo-supercat)
- [#6400](https://github.com/apache/superset/pull/6400) Set default limit on creation of new qe and on run (#6400) (@jeffreythewang)
- [#6241](https://github.com/apache/superset/pull/6241) Split cypress tests (#6241) (@timifasubaa)
- [#6393](https://github.com/apache/superset/pull/6393) [fix] JS error after delete row level tab (#6393) (@graceguo-supercat)
- [#6368](https://github.com/apache/superset/pull/6368) Add Japan country map (#6368) (@sekikn)
- [#6302](https://github.com/apache/superset/pull/6302) Disable flaky cypress SQL Lab test (#6302) (@mistercrunch)
- [#6370](https://github.com/apache/superset/pull/6370) Update the installation document based on Python 3.6+ (#6370) (@sekikn)
- [#6386](https://github.com/apache/superset/pull/6386) [bugfix] prevent d3-format from raising (#6386) (@mistercrunch)
- [#6384](https://github.com/apache/superset/pull/6384) do not convert value to lowercase when looking up color (#6384) (@kristw)
- [#6345](https://github.com/apache/superset/pull/6345) remove user params (#6345) (@timifasubaa)
- [#6375](https://github.com/apache/superset/pull/6375) Fixed the cache issue for BigNumber (#6375) (@conglei)

### 0.29.0rc4 (2018/11/12 18:54 +00:00)
- [#6374](https://github.com/apache/superset/pull/6374) [bugfix] visualization flickers when rerunning query (#6374) (@mistercrunch)
- [#6367](https://github.com/apache/superset/pull/6367) [bugfix] EventFlow does not display (#6367) (@jnishiyama)
- [#6355](https://github.com/apache/superset/pull/6355) [404] Aborting for views with invalid dashboard/slice IDs (#6355) (@john-bodley)
- [#6357](https://github.com/apache/superset/pull/6357) [hive] Fixing where lastest partition logic (#6357) (@john-bodley)
- [#6361](https://github.com/apache/superset/pull/6361) [cypress] Test dashboard save/save_as functions (#6361) (@graceguo-supercat)
- [#6234](https://github.com/apache/superset/pull/6234) [reviewable] Integrate @superset-ui/{core,color,chart} modules (#6234) (@kristw)
- [#6282](https://github.com/apache/superset/pull/6282) [nvd3] refactor margins (#6282) (@mistercrunch)
- [#6359](https://github.com/apache/superset/pull/6359) Parse datasource_id as integer on the server side (#6359) (@xtinec)

### 0.29.0rc3 (2018/11/10 20:39 +00:00)
- [#6287](https://github.com/apache/superset/pull/6287) [reviewable] Organize d3 utilities usage (#6287) (@kristw)
- [#6350](https://github.com/apache/superset/pull/6350) [dashboard] fix save/save-as flow (#6350) (@williaster)
- [#6354](https://github.com/apache/superset/pull/6354) change to camelcase (#6354) (@kristw)
- [#6346](https://github.com/apache/superset/pull/6346) Update docker-entrypoint.sh (#6346) (@BrayanArrieta)
- [#6349](https://github.com/apache/superset/pull/6349) [bugfix] don't parse save dashboard response (#6349) (@williaster)
- [#6290](https://github.com/apache/superset/pull/6290) [reviewable] [refactor] Split visTypes into one file for each visualization type (#6290) (@kristw)

### 0.29.0rc2 (2018/11/08 17:39 +00:00)
- [#6299](https://github.com/apache/superset/pull/6299) Make stacktraces available in many more cases (#6299) (@mistercrunch)
- [#6308](https://github.com/apache/superset/pull/6308) Add Showmax among users (#6308) (@bobek)
- [#6293](https://github.com/apache/superset/pull/6293) [fix warning] Warning: Failed prop type: Invalid prop bsSize of value md (#6293) (@mistercrunch)
- [#6289](https://github.com/apache/superset/pull/6289) Docker Demo, Port Change (#6289) (@IrfanFaizullabhoy)
- [#6286](https://github.com/apache/superset/pull/6286) [annotation] Only allow override whole time_range (#6286) (@graceguo-supercat)
- [#6297](https://github.com/apache/superset/pull/6297) add logging to csv upload (#6297) (@timifasubaa)
- [#6220](https://github.com/apache/superset/pull/6220) [SIP-5] Open a new /api/v1/query endpoint that takes query_obj (#6220) (@xtinec)
- [#6294](https://github.com/apache/superset/pull/6294) Wrap <LoadableRenderer /> with <ErrorBoundary /> (#6294) (@mistercrunch)
- [#6260](https://github.com/apache/superset/pull/6260) Geoviz state management fix (#6260) (@betodealmeida)
- [#4941](https://github.com/apache/superset/pull/4941) Add separate limit setting for SqlLab (#4941) (@jeffreythewang)
- [#6292](https://github.com/apache/superset/pull/6292) [bugfix] handle Loading spinner properly (#6292) (@mistercrunch)
- [#6257](https://github.com/apache/superset/pull/6257) sql lab localStorage config (#6257) (@graceguo-supercat)
- [#6288](https://github.com/apache/superset/pull/6288) [bugfix] deckgl scatter CategoricalDeckGLContainer (#6288) (@mistercrunch)
- [#6277](https://github.com/apache/superset/pull/6277) Avoid clearing metric when saving from datasource editor (#6277) (@michellethomas)
- [#6283](https://github.com/apache/superset/pull/6283) [dashboard] fix spinners disapear too early (#6283) (@mistercrunch)
- [#6280](https://github.com/apache/superset/pull/6280) Fix Infinity css warning (#6280) (@mistercrunch)
- [#6274](https://github.com/apache/superset/pull/6274) rename @superset-ui/core to @superset-ui/connection (#6274) (@kristw)
- [#6269](https://github.com/apache/superset/pull/6269) Adding backwards compatable check to add ago to since if it doesn't exist (#6269) (@michellethomas)
- [#6276](https://github.com/apache/superset/pull/6276) [superset-client] getClientErrorObject for everyone (#6276) (@williaster)
- [#6273](https://github.com/apache/superset/pull/6273) Add chart names translation (#6273) (@kristw)
- [#6229](https://github.com/apache/superset/pull/6229) Fix typo in druid granularity (#6229) (@jeffreythewang)
- [#6252](https://github.com/apache/superset/pull/6252) [explore] raise attention to row_limit being reached (#6252) (@mistercrunch)
- [#6258](https://github.com/apache/superset/pull/6258) Dockerfile change because error: E: The method driver /usr/lib/apt/methods/https… (#6258) (@kk580kk)
- [#6270](https://github.com/apache/superset/pull/6270) i18n(es) (#6270) (@joebordes)
- [#6208](https://github.com/apache/superset/pull/6208) I18n es002 (#6208) (@joebordes)
- [#6264](https://github.com/apache/superset/pull/6264) Externally Visible Server (#6264) (@mlboy)
- [#6261](https://github.com/apache/superset/pull/6261) Remove label and showOnExplore. Specific import validators (#6261) (@kristw)
- [#6251](https://github.com/apache/superset/pull/6251) [Fix] merge since,until request parameter with time_range (#6251) (@graceguo-supercat)
- [#6235](https://github.com/apache/superset/pull/6235) Make VizTypeControl use metadata from plugin (#6235) (@kristw)
- [#6259](https://github.com/apache/superset/pull/6259) Update CONTRIBUTING.md (#6259) (@betodealmeida)
- [#6244](https://github.com/apache/superset/pull/6244) Setting line chart row_limit to 50000 (#6244) (@michellethomas)
- [#6236](https://github.com/apache/superset/pull/6236) Dashboard filter box default (#6236) (@michellethomas)
- [#6255](https://github.com/apache/superset/pull/6255) revert the change in config.py (#6255) (@youngyjd)
- [#6239](https://github.com/apache/superset/pull/6239) Bump Flask, bleach and  sync pip-compile (#6239) (@mistercrunch)
- [#5881](https://github.com/apache/superset/pull/5881) Fix examples charts/dashboards and refactor (#5881) (@mistercrunch)
- [#6246](https://github.com/apache/superset/pull/6246) Fixed grammatical errors. (#6246) (@rakshitkumarcse)
- [#6245](https://github.com/apache/superset/pull/6245) Fixed grammatical errors. (#6245) (@rakshitkumarcse)
- [#6247](https://github.com/apache/superset/pull/6247) Fixed grammatical errors (#6247) (@rakshitkumarcse)
- [#6248](https://github.com/apache/superset/pull/6248) Fixed typos and grammatical errors (#6248) (@rakshitkumarcse)
- [#6249](https://github.com/apache/superset/pull/6249) fixed grammatical errors and typos (#6249) (@rakshitkumarcse)
- [#6250](https://github.com/apache/superset/pull/6250) Corrected name of an area and fixed major grammatical errors (#6250) (@rakshitkumarcse)
- [#6153](https://github.com/apache/superset/pull/6153) Move metadata cache one layer up (#6153) (@youngyjd)
- [#6231](https://github.com/apache/superset/pull/6231) [bugfix] cannot add options to FilterBox (#6231) (@mistercrunch)
- [#6228](https://github.com/apache/superset/pull/6228) [sql lab] improve placeholder strings for query search form (#6228) (@mistercrunch)
- [#6237](https://github.com/apache/superset/pull/6237) fix misstake (#6237) (@mlboy)
- [#6195](https://github.com/apache/superset/pull/6195) [datasource] Ensure SQL Lab link opens in a new tab (#6195) (@john-bodley)
- [#6222](https://github.com/apache/superset/pull/6222) Integrate translation module @superset-ui/translation (#6222) (@kristw)

### 0.29.0rc1 (2018/10/30 21:22 +00:00)
- [#6223](https://github.com/apache/superset/pull/6223) Fix time range filter dropdown (#6223) (@michellethomas)
- [#6233](https://github.com/apache/superset/pull/6233) [fix] typo until (#6233) (@graceguo-supercat)
- [#6226](https://github.com/apache/superset/pull/6226) fix bug : docker build error with no permission with this floder (#6226) (@kk580kk)
- [#6219](https://github.com/apache/superset/pull/6219) A few setup.py improvements, removing future lib (#6219) (@mistercrunch)
- [#6221](https://github.com/apache/superset/pull/6221) [fix][Annotation] Fix override since/until for annotation (#6221) (@graceguo-supercat)
- [#6212](https://github.com/apache/superset/pull/6212) partition and clustering bigquery keys (#6212) (@sumedhsakdeo)
- [#6198](https://github.com/apache/superset/pull/6198) [deck] allow an array of dynamic of aggregations (#6198) (@mistercrunch)
- [#6071](https://github.com/apache/superset/pull/6071) [setup.py] allow for range on boto library (#6071) (@mistercrunch)
- [#6201](https://github.com/apache/superset/pull/6201) [build] fix pip install issues on OSX High Sierra (#6201) (@mistercrunch)
- [#6171](https://github.com/apache/superset/pull/6171) [explore] Include "Autocomplete Query Predicate" field to Table Editor (#6171) (@mistercrunch)
- [#6209](https://github.com/apache/superset/pull/6209) i18n(App) syntax errors detected by Grammarly while translating (#6209) (@joebordes)
- [#6210](https://github.com/apache/superset/pull/6210) Update ISSUE_TEMPLATE.md (#6210) (@superkd37)
- [#6204](https://github.com/apache/superset/pull/6204) [fix] hide annotation layer (#6204) (@graceguo-supercat)
- [#6205](https://github.com/apache/superset/pull/6205) [fix] should set chartUpdateEndTime when chart fetch failed or stopped (#6205) (@graceguo-supercat)
- [#6154](https://github.com/apache/superset/pull/6154) Implement SuperChart and enable the chart plugins (#6154) (@kristw)
- [#6193](https://github.com/apache/superset/pull/6193) Fix typo in load-examples command (#6193) (@maxg203)
- [#6167](https://github.com/apache/superset/pull/6167) Update docker-init.sh (#6167) (@haolong7)
- [#6196](https://github.com/apache/superset/pull/6196) [external-metadata] Fix unknown column types (#6196) (@john-bodley)
- [#6194](https://github.com/apache/superset/pull/6194) fix sql lab permission issue (#6194) (@youngyjd)
- [#6191](https://github.com/apache/superset/pull/6191) [datasource-editor] Correcting tooltip (#6191) (@john-bodley)
- [#6169](https://github.com/apache/superset/pull/6169) add error details into log (#6169) (@graceguo-supercat)
- [#6185](https://github.com/apache/superset/pull/6185) add get_data method to IFrameViz (#6185) (@MikeRoetgers)
- [#6189](https://github.com/apache/superset/pull/6189) [dashboard][bugfix][save as] re-direct to copied dashboard upon saveas (#6189) (@williaster)
- [#6183](https://github.com/apache/superset/pull/6183) pass width and height (#6183) (@kristw)
- [#6180](https://github.com/apache/superset/pull/6180) [sqllab] more robust copy to clipboard (#6180) (@williaster)
- [#6178](https://github.com/apache/superset/pull/6178) Improvements to the polygon spatial viz (#6178) (@betodealmeida)
- [#6181](https://github.com/apache/superset/pull/6181) [fix] should allow force refresh when having charts under tab (#6181) (@graceguo-supercat)
- [#6139](https://github.com/apache/superset/pull/6139) Update CHANGELOG from 0.26 to 0.28.1 (#6139) (@mistercrunch)
- [#6179](https://github.com/apache/superset/pull/6179) [superset-client][bugfix] fix stop query (#6179) (@williaster)
- [#6034](https://github.com/apache/superset/pull/6034) [Ready][Dashboard] disable force refresh when chart is still loading (#6034) (@graceguo-supercat)
- [#6117](https://github.com/apache/superset/pull/6117) Add TrustMedis to the userlist (#6117) (@famasya)
- [#6120](https://github.com/apache/superset/pull/6120) [SIP-9] Introduce TypeScript (#6120) (@xtinec)
- [#6138](https://github.com/apache/superset/pull/6138) Bump FAB to 1.12.1 (#6138) (@mistercrunch)
- [#6166](https://github.com/apache/superset/pull/6166) [bugfix] Fix language switch (#6166) (@kristw)
- [#6163](https://github.com/apache/superset/pull/6163) [superset-client] use getClientErrorObject for client error handling (#6163) (@williaster)
- [#6133](https://github.com/apache/superset/pull/6133) [superset-client][logger] replace ajax with SupersetClient (#6133) (@williaster)
- [#6013](https://github.com/apache/superset/pull/6013) [Sqllab] Add offline state to sqllab (#6013) (@timifasubaa)
- [#6150](https://github.com/apache/superset/pull/6150) [Refactor] Extend color scheme management to sequential schemes (#6150) (@kristw)
- [#6135](https://github.com/apache/superset/pull/6135) [superset-client] replace misc ajax calls  (#6135) (@williaster)
- [#6134](https://github.com/apache/superset/pull/6134) [superset-client][datasource editor] replace ajax with SupersetClient (#6134) (@williaster)
- [#6144](https://github.com/apache/superset/pull/6144) Define chart presets (#6144) (@kristw)
- [#6148](https://github.com/apache/superset/pull/6148) [superset-client] pass csrfToken as configuration (#6148) (@williaster)
- [#6146](https://github.com/apache/superset/pull/6146) add build query as part of plugin (#6146) (@kristw)
- [#6145](https://github.com/apache/superset/pull/6145) fix bar chart value overlap with legend (#6145) (@kristw)
- [#6143](https://github.com/apache/superset/pull/6143) remove reactable from Hotkeys.jsx (#6143) (@kristw)
- [#6136](https://github.com/apache/superset/pull/6136) Add annotation information to ChartMetadata (#6136) (@kristw)
- [#6125](https://github.com/apache/superset/pull/6125) [Ready] Define ChartProps data structure (#6125) (@kristw)
- [#6142](https://github.com/apache/superset/pull/6142) downgrade reactable and remove fastdom (#6142) (@kristw)
- [#6141](https://github.com/apache/superset/pull/6141) Turning off flaky link tests (#6141) (@michellethomas)
- [#6106](https://github.com/apache/superset/pull/6106) Remove isNumeric util function and use Number.isFinite instead (#6106) (@kristw)
- [#6123](https://github.com/apache/superset/pull/6123) change viewport dimension (#6123) (@kristw)
------------------------------

### 0.28.1 (2018/10/18 17:48 +00:00)
- Bump FAB to 1.18.1

### 0.28.0 (2018/10/17 ??:?? +00:00)
- [#5896](https://github.com/apache/superset/pull/5896) [SIP-4] replace SQL Lab ajax calls with `SupersetClient` (#5896) (@williaster)
- [#6104](https://github.com/apache/superset/pull/6104) Use @vx/responsive to provide Chart width on Explore page (#6104) (@kristw)
- [#6095](https://github.com/apache/superset/pull/6095) [utils.py] gathering/refactoring into a "utils/" folder (#6095) (@mistercrunch)
- [#5869](https://github.com/apache/superset/pull/5869) [SIP-4] replace explorer ajax calls with `SupersetClient` (#5869) (@williaster)
- [#6058](https://github.com/apache/superset/pull/6058) [SIP-5&6] Refactor line_multi (#6058) (@kristw)
- [#5854](https://github.com/apache/superset/pull/5854) [SIP-4] replace dashboard ajax calls with `SupersetClient` (#5854) (@williaster)
- [#6078](https://github.com/apache/superset/pull/6078) allow cache and force refresh on table list (#6078) (@youngyjd)
- [#6121](https://github.com/apache/superset/pull/6121) This control test is flaky and affecting travis runs, turning it off for now (#6121) (@michellethomas)
- [#6038](https://github.com/apache/superset/pull/6038) Fixes to the CategoricalDeckGLContainer and filter box (#6038) (@betodealmeida)
- [#6113](https://github.com/apache/superset/pull/6113) send username in sync request (#6113) (@youngyjd)
- [#5875](https://github.com/apache/superset/pull/5875) [SIP-4] replace chart ajax calls with `SupersetClient` (#5875) (@williaster)
- [#6079](https://github.com/apache/superset/pull/6079) [refactor] Migrate from Mocha+Chai to Jest (#6079) (@xtinec)
- [#6096](https://github.com/apache/superset/pull/6096) remove utf8 declaration (#6096) (@timifasubaa)
- [#6102](https://github.com/apache/superset/pull/6102) fix dependency issue #6086 (#6102) (@aflyhorse)
- [#6103](https://github.com/apache/superset/pull/6103) Rename onTooltip to setTooltip (#6103) (@kristw)
- [#6105](https://github.com/apache/superset/pull/6105) make BigNumber PureComponent (#6105) (@kristw)
- [#6097](https://github.com/apache/superset/pull/6097) Fix link formating in README.md (#6097) (@ad-m)
- [#6088](https://github.com/apache/superset/pull/6088) move countries directory under CountryMap (#6088) (@kristw)
- [#6065](https://github.com/apache/superset/pull/6065) remove future (#6065) (@timifasubaa)
- [#6091](https://github.com/apache/superset/pull/6091) remove six dependency (#6091) (@timifasubaa)
- [#6090](https://github.com/apache/superset/pull/6090) Add ChartPlugin and metadata for deck.gl vis (#6090) (@kristw)
- [#6085](https://github.com/apache/superset/pull/6085) Add ChartPlugin and metadata for nvd3 and BigNumber vis (#6085) (@kristw)
- [#6089](https://github.com/apache/superset/pull/6089) [cypress][sqllab] increase timeout for sqllab results (#6089) (@williaster)
- [#6039](https://github.com/apache/superset/pull/6039) [SIP-5] Remove references to slice from all deck.gl components.  (#6039) (@kristw)
- [#6072](https://github.com/apache/superset/pull/6072) Create chart plugins and metadata (#6072) (@kristw)
- [#6063](https://github.com/apache/superset/pull/6063) remove future imports from db migrations (#6063) (@timifasubaa)
- [#6069](https://github.com/apache/superset/pull/6069) Cypress tests for controls and explore links (#6069) (@michellethomas)
- [#6074](https://github.com/apache/superset/pull/6074) Rename color constants and move util function into separate file (#6074) (@kristw)
- [#5998](https://github.com/apache/superset/pull/5998) Fix the horizon title only show the first key (#5998) (@Narcissus7)
- [#6050](https://github.com/apache/superset/pull/6050) remove future imports (#6050) (@timifasubaa)
- [#6073](https://github.com/apache/superset/pull/6073) Fix top groups with user defined metrics (#6073) (@betodealmeida)
- [#5974](https://github.com/apache/superset/pull/5974) [cypress] add SQL lab tests (#5974) (@williaster)
- [#6061](https://github.com/apache/superset/pull/6061) feat: import/export dashboards via cli  (#6061) (@arpit-agarwal)
- [#6054](https://github.com/apache/superset/pull/6054) [setup] Using pip-tools to create requirements.txt (#6054) (@john-bodley)
- [#6062](https://github.com/apache/superset/pull/6062) Add increment back arrow to time player (#6062) (@betodealmeida)
- [#6028](https://github.com/apache/superset/pull/6028) Add data structures for chart plugin system (#6028) (@kristw)
- [#6002](https://github.com/apache/superset/pull/6002) [cypress] add integration tests for dashboard (#6002) (@graceguo-supercat)
- [#6037](https://github.com/apache/superset/pull/6037) [Dashboard] Fix margin issue in dashboard modal (#6037) (@graceguo-supercat)
- [#6004](https://github.com/apache/superset/pull/6004) check db extra and metadata params preemptively (#6004) (@youngyjd)
- [#5933](https://github.com/apache/superset/pull/5933) Allow user to force refresh metadata (#5933) (@youngyjd)
- [#6051](https://github.com/apache/superset/pull/6051) [select-star] Adding optional schema to view (#6051) (@john-bodley)
- [#6030](https://github.com/apache/superset/pull/6030) Upgrade flask-appbuilder to latest. (#6030) (@jmcarp)
- [#6056](https://github.com/apache/superset/pull/6056) Revert old precision formatters (#6056) (@theikkila)
- [#6043](https://github.com/apache/superset/pull/6043) Search queries when enter is pressed (#6043) (@betodealmeida)
- [#6047](https://github.com/apache/superset/pull/6047) fix for annotation layer bug (#6047) (@yuguang)
- [#6049](https://github.com/apache/superset/pull/6049) remove redundant mysql (#6049) (@timifasubaa)
- [#6023](https://github.com/apache/superset/pull/6023) [tablemodelview] Fixing JSON api/read serializable issue (#6023) (@john-bodley)
- [#5985](https://github.com/apache/superset/pull/5985) Deprecate support for Python 3_6 (#5985) (@mistercrunch)
- [#6031](https://github.com/apache/superset/pull/6031) refer to default color scheme in colorpickercontrol instead of pointing to specific scheme (#6031) (@kristw)
- [#6027](https://github.com/apache/superset/pull/6027) Sorting tables by "modified" is broken (#6027) (@betodealmeida)
- [#6016](https://github.com/apache/superset/pull/6016) [ci] Update ci config to reduce javascript test time and some of cypress. (#6016) (@kristw)
- [#6029](https://github.com/apache/superset/pull/6029) use world map only bundle (#6029) (@kristw)
- [#5997](https://github.com/apache/superset/pull/5997) [SIP-6] Migrate visualizations to new directory structure (part 2) (#5997) (@kristw)
- [#6035](https://github.com/apache/superset/pull/6035) Revert #5991 (#6035) (@graceguo-supercat)
- [#6033](https://github.com/apache/superset/pull/6033) log query fetch time (#6033) (@timifasubaa)
- [#5566](https://github.com/apache/superset/pull/5566) [bugfix] Fix Tableviz metrics column disorder (#5566) (@yamyamyuo)
- [#5924](https://github.com/apache/superset/pull/5924) [cypress] Add integration test for area, pie, pivot_table, world_map, dual_line, sunburst, sankey, big_number, bubble, box_plot, treemap (#5924) (@kristw)
- [#6006](https://github.com/apache/superset/pull/6006) [SIP-6] Migrate visualizations to new directory structure (part 3 - nvd3) (#6006) (@kristw)
- [#6019](https://github.com/apache/superset/pull/6019) [cypress] Combine multiple tests under visualizations into single test to save running time (#6019) (@kristw)
- [#5991](https://github.com/apache/superset/pull/5991) feat: import/export dashboards via cli (#5991) (@arpit-agarwal)
- [#5960](https://github.com/apache/superset/pull/5960) [feat] Feature flag system via config (#5960) (@xtinec)
- [#6005](https://github.com/apache/superset/pull/6005) Removing the key from cypress build and removing parallel flag (#6005) (@michellethomas)
- [#6008](https://github.com/apache/superset/pull/6008) disable dashboard test (#6008) (@kristw)
- [#5995](https://github.com/apache/superset/pull/5995) wait and verify one-by-one (#5995) (@kristw)
- [#5949](https://github.com/apache/superset/pull/5949) [SIP-6] Migrate visualizations to new directory structure.  (#5949) (@kristw)
- [#5983](https://github.com/apache/superset/pull/5983) Update webpack bundle configuration (#5983) (@kristw)
- [#5957](https://github.com/apache/superset/pull/5957) [cypress] Update dashboard test to remove 10s timeout (#5957) (@kristw)
- [#5959](https://github.com/apache/superset/pull/5959) Explicit set markdown version to >= 3.0 (#5959) (@manhtai)
- [#5946](https://github.com/apache/superset/pull/5946) Remove lodash.throttle and replace underscore calls with lodash (#5946) (@kristw)
- [#5975](https://github.com/apache/superset/pull/5975) Pinning a version of click to fix travis (#5975) (@michellethomas)
- [#5970](https://github.com/apache/superset/pull/5970) Add fordeal to superset user list (#5970) (@Renkai)
- [#5967](https://github.com/apache/superset/pull/5967) Constrain the max version of markdown (#5967) (@victornoel)
- [#5937](https://github.com/apache/superset/pull/5937) Deprecate getColorFromSchem (#5937) (@kristw)
- [#5906](https://github.com/apache/superset/pull/5906) fix sqllab querysearch typeahead permission error (#5906) (@youngyjd)
- [#5934](https://github.com/apache/superset/pull/5934) ensure npm run build is in production mode (#5934) (@kristw)
- [#5952](https://github.com/apache/superset/pull/5952) [deck_polyline] show metric in geohash (#5952) (@mistercrunch)
- [#5948](https://github.com/apache/superset/pull/5948) [deck_polygon] implement null locations flag (#5948) (@mistercrunch)
- [#5931](https://github.com/apache/superset/pull/5931) [bugfix] metrics issue in 'Periodicity Pivot' (#5931) (@mistercrunch)
- [#5770](https://github.com/apache/superset/pull/5770) [explore] add "View samples" modal to action buttons (#5770) (@mistercrunch)
- [#5923](https://github.com/apache/superset/pull/5923) [docs] iterating to get to ASF compliance on project site (#5923) (@mistercrunch)
- [#5945](https://github.com/apache/superset/pull/5945) [eslint] add no-only-tests (#5945) (@williaster)
- [#5926](https://github.com/apache/superset/pull/5926) Adding configuration to cypress to enable dashboard (#5926) (@michellethomas)
- [#5787](https://github.com/apache/superset/pull/5787) Add schema level access control on csv upload (#5787) (@youngyjd)
- [#5848](https://github.com/apache/superset/pull/5848) fix sqlab progress bar and status inconsistency (#5848) (@youngyjd)
- [#5943](https://github.com/apache/superset/pull/5943) remove .only (#5943) (@kristw)
- [#5940](https://github.com/apache/superset/pull/5940) fix csv upload bugs (#5940) (@timifasubaa)
- [#5938](https://github.com/apache/superset/pull/5938) use es6 import (#5938) (@kristw)
- [#5790](https://github.com/apache/superset/pull/5790) Some linting (#5790) (@mistercrunch)
- [#5932](https://github.com/apache/superset/pull/5932) Allow removing legend (#5932) (@betodealmeida)
- [#5866](https://github.com/apache/superset/pull/5866) Fix regression around low row limit for CSV exports (#5866) (@mistercrunch)
- [#5911](https://github.com/apache/superset/pull/5911) Clean up CONTRIBUTING.md: (#5911) (@alekstorm)
- [#5893](https://github.com/apache/superset/pull/5893) [SIP-6] Add reactify function and convert world map to new directory structure. (#5893) (@kristw)
- [#5778](https://github.com/apache/superset/pull/5778) [explore flow] handling duplicated column aliases (#5778) (@mistercrunch)
- [#5905](https://github.com/apache/superset/pull/5905) [bugfix] ignore history.pushState errors (#5905) (@mistercrunch)
- [#5890](https://github.com/apache/superset/pull/5890) [bugfix] De-dup script tags. #5883 (#5890) (@kristw)
- [#5901](https://github.com/apache/superset/pull/5901) Table and dist bar tests (#5901) (@michellethomas)
- [#5921](https://github.com/apache/superset/pull/5921) [contributing.md] swap cypress command order (#5921) (@williaster)
- [#5902](https://github.com/apache/superset/pull/5902) [refactor] Remove dependency on personal fork of supercluster from mapbox visualizations (#5902) (@xtinec)
- [#5917](https://github.com/apache/superset/pull/5917) [bugfix] Fix percent metric display and check for string columns in table (#5917) (@kristw)
- [#5868](https://github.com/apache/superset/pull/5868) Remove unused functions and jquery dependency (#5868) (@kristw)
- [#5891](https://github.com/apache/superset/pull/5891) [bugfix] Fix color scheme picker (#5891) (@kristw)
- [#5918](https://github.com/apache/superset/pull/5918) Fixing linting error in macro_tests (#5918) (@xtinec)
- [#5907](https://github.com/apache/superset/pull/5907) Remove jquery usage to highlight sql lab menu (#5907) (@kristw)
- [#5547](https://github.com/apache/superset/pull/5547) Adds a new macro to allow getting filter values easily (#5547) (@mjsilva)
- [#5838](https://github.com/apache/superset/pull/5838) [SIP-5] Refactor nvd3 (#5838) (@kristw)
- [#5903](https://github.com/apache/superset/pull/5903) [react16] fix React type checking (#5903) (@mistercrunch)
- [#5900](https://github.com/apache/superset/pull/5900) Add cypress artifacts directory (videos/screenshots) to gitignore and sort items in gitignore (#5900) (@kristw)
- [#5811](https://github.com/apache/superset/pull/5811) [treemap] add row_limit control (#5811) (@mistercrunch)
- [#5851](https://github.com/apache/superset/pull/5851) remove duplicated utils (#5851) (@youngyjd)
- [#5879](https://github.com/apache/superset/pull/5879) [lint] turn no-undef back on, set browser, cypress, and mocha env's (#5879) (@williaster)
- [#5775](https://github.com/apache/superset/pull/5775) [SIP-5] Refactor Time Series Table (#5775) (@kristw)
- [#5885](https://github.com/apache/superset/pull/5885) Addded documentation for Teradata DB (#5885) (@livinm)
- [#5870](https://github.com/apache/superset/pull/5870) Enable Teradata (#5870) (@livinm)
- [#5877](https://github.com/apache/superset/pull/5877) [bug fix] Fixed adhoc metric is not working for WordCloud (#5877) (@conglei)
- [#5865](https://github.com/apache/superset/pull/5865) fixed modal close issue (#5865) (@conglei)
- [#5861](https://github.com/apache/superset/pull/5861) [SIP-6] removed get_data for BigNumber (#5861) (@conglei)

### 0.28.0rc6 (2018/09/13 00:37 +00:00)
- [#5880](https://github.com/apache/superset/pull/5880) Fix CSS theme flickering on FAB pages (#5880) (@mistercrunch)
- [#5878](https://github.com/apache/superset/pull/5878) remove getColorFromScheme in favor of CategoricalColorNamespace.getScale() for histogram (#5878) (@kristw)
- [#5709](https://github.com/apache/superset/pull/5709) fix: Pivot table not sorting formatted numeric column properly (#5709) (@arpit-agarwal)
- [#5815](https://github.com/apache/superset/pull/5815) Improve categorical color management (#5815) (@kristw)
- [#5874](https://github.com/apache/superset/pull/5874) [tests] fix sqllab/TableElement_spec (#5874) (@williaster)
- [#5863](https://github.com/apache/superset/pull/5863) [time table] fix sorting on missing values (#5863) (@mistercrunch)
- [#5748](https://github.com/apache/superset/pull/5748) [Docs] Running DB migration (#5748) (@hughhhh)
- [#5867](https://github.com/apache/superset/pull/5867) correctly compute slice width in dashboard (#5867) (@kristw)
- [#5864](https://github.com/apache/superset/pull/5864) Moving get_main_db out of tests and into superset utils (#5864) (@michellethomas)
- [#5862](https://github.com/apache/superset/pull/5862) fix sqllab logging (#5862) (@timifasubaa)
- [#5860](https://github.com/apache/superset/pull/5860) fix Object.assign try to write to read-only option.style (#5860) (@kristw)
- [#5859](https://github.com/apache/superset/pull/5859) make access request open new tab (#5859) (@timifasubaa)
- [#5858](https://github.com/apache/superset/pull/5858) [bugfix] mapbox pan on filter (#5858) (@xtinec)
- [#5846](https://github.com/apache/superset/pull/5846) Adding line and big number total integration tests (#5846) (@michellethomas)
- [#5855](https://github.com/apache/superset/pull/5855) [dev] fix redux devtools (#5855) (@williaster)
- [#5850](https://github.com/apache/superset/pull/5850) update dashboard sidepane title (#5850) (@graceguo-supercat)
- [#5736](https://github.com/apache/superset/pull/5736) [sqllab]More granular sqllab logging (#5736) (@timifasubaa)
- [#5849](https://github.com/apache/superset/pull/5849) [bugfix] fix rows not showing on welcome page (retry) (#5849) (@kristw)
- [#5853](https://github.com/apache/superset/pull/5853) [bugfix] 'No numeric types to aggregate' in NVD3 chart (#5853) (@mistercrunch)
- [#5829](https://github.com/apache/superset/pull/5829) [sql lab] handle large ints, prevent overflow (#5829) (@mistercrunch)
- [#5359](https://github.com/apache/superset/pull/5359) Upgrade to React==16.4.1 &  Enzyme==3.3.0 (#5359) (@mistercrunch)
- [#5844](https://github.com/apache/superset/pull/5844) add timing to stats logger (#5844) (@timifasubaa)
- [#5785](https://github.com/apache/superset/pull/5785) Handle "ambiguous durations" (#5785) (@betodealmeida)
- [#5819](https://github.com/apache/superset/pull/5819) Update time filter to use `react-datetime` (#5819) (@betodealmeida)
- [#5841](https://github.com/apache/superset/pull/5841) Enable hot module replacement for React via react-hot-loader (#5841) (@kristw)
- [#5834](https://github.com/apache/superset/pull/5834) [docs] suggest using python3.6 in installation docs (#5834) (@mistercrunch)
- [#5828](https://github.com/apache/superset/pull/5828) Fix cache for multiple time comparisons (#5828) (@betodealmeida)
- [#5830](https://github.com/apache/superset/pull/5830) Get 'Test Connection' button to take 'engine_params' into account (#5830) (@mistercrunch)
- [#5840](https://github.com/apache/superset/pull/5840) Adding instructions on how to run Cypress in Contributing.md (#5840) (@michellethomas)
- [#5839](https://github.com/apache/superset/pull/5839) [bugfix] Fix bignumber overflow in dashboard (#5839) (@kristw)
- [#5762](https://github.com/apache/superset/pull/5762) [SIP-5] Refactor Paired t-test (#5762) (@kristw)
- [#5789](https://github.com/apache/superset/pull/5789) [SIP-5] Refactor filterbox (#5789) (@kristw)
- [#5693](https://github.com/apache/superset/pull/5693) Adding simple Cypress tests (#5693) (@michellethomas)
- [#5771](https://github.com/apache/superset/pull/5771) [dashboard] Add alert on user delete root level tab (#5771) (@graceguo-supercat)
- [#5730](https://github.com/apache/superset/pull/5730) [sql_json] allow not specifying client_id (#5730) (@mistercrunch)
- [#5818](https://github.com/apache/superset/pull/5818) Update Readme that support Apache Kylin (#5818) (@zhaoyongjie)
- [#5823](https://github.com/apache/superset/pull/5823) Adding 'Resources' section to the docs (#5823) (@mistercrunch)
- [#5826](https://github.com/apache/superset/pull/5826) fix bug with react-syntax-highlighter import (#5826) (@kristw)
- [#5705](https://github.com/apache/superset/pull/5705) [SIP-5] Refactor pivot table (#5705) (@kristw)
- [#5825](https://github.com/apache/superset/pull/5825) [SIP-5] Remove unused function #easy-review (#5825) (@kristw)
- [#5761](https://github.com/apache/superset/pull/5761) [SIP-5] Refactor parallel coordinates (#5761) (@kristw)
- [#5783](https://github.com/apache/superset/pull/5783) [SIP-5] Refactor MapBox (#5783) (@kristw)
- [#5758](https://github.com/apache/superset/pull/5758) [SIP-5] Refactor and improve histogram (#5758) (@kristw)
- [#5760](https://github.com/apache/superset/pull/5760) [SIP-5] Refactor calendar chart (#5760) (@kristw)
- [#5813](https://github.com/apache/superset/pull/5813) Enable CSS Hot Module Replacement and optimize css output for production (#5813) (@kristw)
- [#5814](https://github.com/apache/superset/pull/5814) bug: don't show query overlay when panning mapbox maps (#5814) (@xtinec)
- [#5812](https://github.com/apache/superset/pull/5812) [celery] setting default (#5812) (@john-bodley)
- [#5786](https://github.com/apache/superset/pull/5786) Configure webpack-dev-server (#5786) (@kristw)
- [#5796](https://github.com/apache/superset/pull/5796) make some text in [druid,CRUD,datasource] localizable (#5796) (@hitdemo)
- [#5686](https://github.com/apache/superset/pull/5686) Force quoted column aliases for Oracle-like databases (#5686) (@villebro)
- [#5707](https://github.com/apache/superset/pull/5707) [SIP-5] Refactor table (#5707) (@kristw)
- [#5745](https://github.com/apache/superset/pull/5745) Update annotation model to have JSON Metadata field (#5745) (@hughhhh)
- [#5782](https://github.com/apache/superset/pull/5782) update thumbnail (#5782) (@hughhhh)
- [#5721](https://github.com/apache/superset/pull/5721) [SIP-5] Repair and refactor CountryMap (#5721) (@kristw)
- [#5753](https://github.com/apache/superset/pull/5753) remove backend logic for wordcloud (#5753) (@conglei)
- [#5777](https://github.com/apache/superset/pull/5777) Fix redirect to SQL Lab (#5777) (@betodealmeida)
- [#5776](https://github.com/apache/superset/pull/5776) New branding images (#5776) (@elibrumbaugh)
- [#5767](https://github.com/apache/superset/pull/5767) Fix multilayer geoviz and color picker error (#5767) (@youngyjd)
- [#5718](https://github.com/apache/superset/pull/5718) [SIP-5] Refactor and repair partition (#5718) (@kristw)
- [#5763](https://github.com/apache/superset/pull/5763) [SIP-5] Refactor rose (#5763) (@kristw)
- [#5719](https://github.com/apache/superset/pull/5719) [SIP-5] Refactor World Map (#5719) (@kristw)
- [#5722](https://github.com/apache/superset/pull/5722) [dashboard] Update font style for markdown component (#5722) (@graceguo-supercat)
- [#5768](https://github.com/apache/superset/pull/5768) fix sqlparse bug and refactor (#5768) (@timifasubaa)

### 0.28.0rc5 (2018/08/29 04:05 +00:00)
- [#5765](https://github.com/apache/superset/pull/5765) [bugfix] 'DruidCluster' object has no attribute 'db_engine_spec' (#5765) (@mistercrunch)
- [#5715](https://github.com/apache/superset/pull/5715) [Table view] Handle empty arrays in fd.timeseries_limit_metric (#5715) (@betodealmeida)
- [#5759](https://github.com/apache/superset/pull/5759) Bug: fixing async syntax for python 3.7 (#5759) (@xtinec)
- [#5766](https://github.com/apache/superset/pull/5766) Disable input when IS (NOT) NULL selected in filters (#5766) (@betodealmeida)
- [#5764](https://github.com/apache/superset/pull/5764) [bugfix] IS NOT NULL filter triggers KeyError: 'val' (#5764) (@mistercrunch)
- [#5756](https://github.com/apache/superset/pull/5756) Add Myra Labs to user list in README (#5756) (@viksit)
- [#5712](https://github.com/apache/superset/pull/5712) [deck polygon] add support for geohash (#5712) (@mistercrunch)
- [#5729](https://github.com/apache/superset/pull/5729) Silence error on migration 4736ec66ce19 constraint drop (#5729) (@mistercrunch)
- [#5749](https://github.com/apache/superset/pull/5749) Prevent deleting databases that have attached tables (#5749) (@mistercrunch)
- [#5750](https://github.com/apache/superset/pull/5750) Merge pull request #5750 from mistercrunch/updating_0_28 (@mistercrunch)
- [#5732](https://github.com/apache/superset/pull/5732) Merge pull request #5732 from mistercrunch/build_docs (@mistercrunch)
- [#5731](https://github.com/apache/superset/pull/5731) Merge pull request #5731 from mistercrunch/faq_db_engines (@mistercrunch)
- [#5701](https://github.com/apache/superset/pull/5701) [SIP-5] Refactor sankey (#5701) (@kristw)
- [#5704](https://github.com/apache/superset/pull/5704) [SIP-5] Refactor and update heatmap (#5704) (@kristw)
- [13e48e8](https://github.com/apache/superset/commit/13e48e8c8eff626f0a6543d440bf3399c0938765) typo-delipo (@mistercrunch)
- [#5725](https://github.com/apache/superset/pull/5725) Merge pull request #5725 from mistercrunch/label_verbose_name (@mistercrunch)
- [ceda309](https://github.com/apache/superset/commit/ceda3092e3fed092a4ff5f11096a0718b9446145) UPDATING.md entry about dashboard v2 forced migration in 0.28 (@mistercrunch)
- [#5744](https://github.com/apache/superset/pull/5744) update webpack (#5744) (@hughhhh)
- [#5706](https://github.com/apache/superset/pull/5706) Merge pull request #5706 from mistercrunch/color_arcs (@mistercrunch)
- [#5724](https://github.com/apache/superset/pull/5724) Merge pull request #5724 from mistercrunch/css_editable_input (@mistercrunch)
- [#5723](https://github.com/apache/superset/pull/5723) Merge pull request #5723 from mistercrunch/fix_autocomplete_filters (@mistercrunch)
- [#5746](https://github.com/apache/superset/pull/5746) [bugfix] BigNumber crash, Horizon indent and Myanmar geojson (#5746) (@kristw)
- [#5699](https://github.com/apache/superset/pull/5699) [SIP-5] Refactor sunburst (#5699) (@kristw)
- [#5690](https://github.com/apache/superset/pull/5690) [SIP-5] Repair and refactor Horizon Chart (#5690) (@kristw)
- [#5738](https://github.com/apache/superset/pull/5738) remove unneeded console.log (#5738) (@hughhhh)
- [#5726](https://github.com/apache/superset/pull/5726) [celery] Using preferred configuration proceedure (#5726) (@john-bodley)
- [09d46a7](https://github.com/apache/superset/commit/09d46a7864a67d3e2ef70fb41a5c43b28d6c14c9) Fix tests (@mistercrunch)
- [#5717](https://github.com/apache/superset/pull/5717) Autofocus aggregation in metric control (#5717) (@betodealmeida)
- [#5735](https://github.com/apache/superset/pull/5735) make some text localizable, mainly in explore, query (#5735) (@hitdemo)
- [12cc2fb](https://github.com/apache/superset/commit/12cc2fbe15533c673b12bd3cf6bed2a5c8b8a46e) [docs] note as to how to build and view the docs (@mistercrunch)
- [bddc952](https://github.com/apache/superset/commit/bddc9522e82f77942e0797694fd619fe1653ff48) [docs] FAQ entry 'Does Superset work with [database engine]?' (@mistercrunch)
- [#5720](https://github.com/apache/superset/pull/5720) Fix FAQ on filters (#5720) (@betodealmeida)
- [e964d83](https://github.com/apache/superset/commit/e964d83b45b21b95f21218fa0f25fb44c7f95b18) [table editor] better table header for Metrics tab (@mistercrunch)
- [c447a97](https://github.com/apache/superset/commit/c447a970de3e6d240a5a9a0d7a1a5b737bd2332c) [css] show border around editable input while editing (@mistercrunch)
- [ba32944](https://github.com/apache/superset/commit/ba329440bcece3f2e7033b8c02bd27460b7dfb11) [table editor] fix 'Autocomplete filters' checkbox doesn't stick (@mistercrunch)
- [#5670](https://github.com/apache/superset/pull/5670) [SIP-5] Refactor treemap (#5670) (@kristw)
- [#5714](https://github.com/apache/superset/pull/5714) [bugfix] add item is missing on table editor metrics tab (#5714) (@mistercrunch)
- [#5716](https://github.com/apache/superset/pull/5716) Merge pull request #5716 from lyft/DPTOOLS-976 (@lyft)
- [c567a89](https://github.com/apache/superset/commit/c567a89ee7529e88649d78f415a54988b01e218e) Use 403 (@betodealmeida)
- [9827925](https://github.com/apache/superset/commit/9827925015a42a47d12db82595fd88de6a259d62) Return 401 on no authorization (@betodealmeida)
- [#5708](https://github.com/apache/superset/pull/5708) Geojson property names (#5708) (@joshbrooks)
- [#5702](https://github.com/apache/superset/pull/5702) remove console.log and change wording (#5702) (@kristw)
- [#5672](https://github.com/apache/superset/pull/5672) Revise markup.js and iframe.js (#5672) (@kristw)
- [#5703](https://github.com/apache/superset/pull/5703) [sqlparse] fix sqlparse bug (#5703) (@timifasubaa)
- [71866f6](https://github.com/apache/superset/commit/71866f6a127c616da07f221572ca04a95902e7e0) [deck arcs] add JS hooks for sourceColor & targetColor (@mistercrunch)

- [#5684](https://github.com/apache/superset/pull/5684) [security] Moving set/merge perm to security manager (#5684) (@john-bodley)
- [#5623](https://github.com/apache/superset/pull/5623) Merge pull request #5623 from mistercrunch/fix_templates (@mistercrunch)
- [#5694](https://github.com/apache/superset/pull/5694) Allow users to select color for big number (#5694) (@hughhhh)
- [#5697](https://github.com/apache/superset/pull/5697) Adds geodata for Myanmar (#5697) (@joshbrooks)
- [#5698](https://github.com/apache/superset/pull/5698) adds TimorLeste geodata (#5698) (@joshbrooks)
- [#5695](https://github.com/apache/superset/pull/5695) [bugfix] geohash lat/long is reversed (#5695) (@mistercrunch)
- [#5663](https://github.com/apache/superset/pull/5663) Make brush send events (#5663) (@betodealmeida)
- [#5634](https://github.com/apache/superset/pull/5634) [viz flow] detect TIMESTAMP, transition to line chart (#5634) (@mistercrunch)
- [#5638](https://github.com/apache/superset/pull/5638) Add categories and time slider to arc deck.gl viz (#5638) (@betodealmeida)
- [#5675](https://github.com/apache/superset/pull/5675) Fixes to the play slider (#5675) (@betodealmeida)
- [#5646](https://github.com/apache/superset/pull/5646) Increase pylint jobs (#5646) (@betodealmeida)
- [#5669](https://github.com/apache/superset/pull/5669) Repair and refactor Word Cloud (#5669) (@kristw)
- [#5691](https://github.com/apache/superset/pull/5691) Refactor force-directed graph (#5691) (@kristw)
- [#5687](https://github.com/apache/superset/pull/5687) [bugfix] Encode unicode error message response (#5687) (@zhaoyongjie)
- [#5641](https://github.com/apache/superset/pull/5641) Field names in big query can contain only alphanumeric and underscore (#5641) (@sumedhsakdeo)

### 0.27.0 (2018/08/21 20:16 +00:00)
- [#5682](https://github.com/apache/superset/pull/5682) [bugfix] making secondary_metric optional (#5682) (@mistercrunch)
- [#5665](https://github.com/apache/superset/pull/5665) Upgrade mysqlclient to 1.3.13 (#5665) (@emlittleworth)
- [#5640](https://github.com/apache/superset/pull/5640) Fix CSS (#5640) (@betodealmeida)
- [#5688](https://github.com/apache/superset/pull/5688) change title from hotkeys to keyboard shortcuts (#5688) (@kristw)

### 0.28.0rc3 (2018/08/21 17:19 +00:00)
- [#5683](https://github.com/apache/superset/pull/5683) [bug] 'an error has ooccured' when saving datasource (#5683) (@mistercrunch)
- [#5685](https://github.com/apache/superset/pull/5685) make some text localizable, mainly in dashboard, explore, datasource editor, webpage title (#5685) (@hitdemo)
- [#5655](https://github.com/apache/superset/pull/5655) Handling bigquery dialect when previewing data (#5655) (@sumedhsakdeo)
- [#5657](https://github.com/apache/superset/pull/5657) [bugfix] df is None breaks df.empty check (#5657) (@mistercrunch)
- [#5671](https://github.com/apache/superset/pull/5671) Refactor Chord vis (#5671) (@kristw)
- [#5681](https://github.com/apache/superset/pull/5681) Fix time filter in cache (#5681) (@betodealmeida)
- [#5662](https://github.com/apache/superset/pull/5662) Minor improvements to SQL Lab UI (#5662) (@kristw)
- [#5642](https://github.com/apache/superset/pull/5642) Filter out null locations by default (#5642) (@betodealmeida)
- [#5668](https://github.com/apache/superset/pull/5668) Update CONTRIBUTING.md (#5668) (@hughhhh)
- [#5652](https://github.com/apache/superset/pull/5652) [sqllab] call out transient state of tabs to users (#5652) (@williaster)
- [#5661](https://github.com/apache/superset/pull/5661) [bugfix] TypeError: adhocMetric.comparator.join is not a function (#5661) (@mistercrunch)
- [#5645](https://github.com/apache/superset/pull/5645) Fix checkbox is fails When disable Druid datasource (#5645) (@zhaoyongjie)
- [#5649](https://github.com/apache/superset/pull/5649) fix multilayer viz backend error (#5649) (@youngyjd)
- [#5644](https://github.com/apache/superset/pull/5644) handle exception and set dtype value to JSON, when column type JSON (#5644) (@sumedhsakdeo)
- [#5567](https://github.com/apache/superset/pull/5567) make filters use security manager (#5567) (@timifasubaa)
- [#5648](https://github.com/apache/superset/pull/5648) Updating yarn.lock for the vx upgrade (#5648) (@michellethomas)
- [#5647](https://github.com/apache/superset/pull/5647) Upgrading vx responsive to fix ResizeObserver issue (#5647) (@michellethomas)
- [#5643](https://github.com/apache/superset/pull/5643) use_slice_data in slice_json calls (#5643) (@michellethomas)
- [#5637](https://github.com/apache/superset/pull/5637) Explore View Perf Fix (#5637) (@sumedhsakdeo)
- [#5100](https://github.com/apache/superset/pull/5100) Fix form data issue switching viz types (#5100) (@michellethomas)
- [#5433](https://github.com/apache/superset/pull/5433) [title] Fix issue with non-string names in series title (#5433) (@john-bodley)
- [#5632](https://github.com/apache/superset/pull/5632) Fetch a batch of rows from bigquery (#5632) (@sumedhsakdeo)
- [#5630](https://github.com/apache/superset/pull/5630) [bubble] Fixing ad-hoc metric labels (#5630) (@john-bodley)
- [#5626](https://github.com/apache/superset/pull/5626) Tackling late-arriving comments from #5186 (#5626) (@mistercrunch)
- [#5612](https://github.com/apache/superset/pull/5612) [sql lab] always use NullPool (#5612) (@mistercrunch)
- [#5631](https://github.com/apache/superset/pull/5631) [bug fix] Fixed forced percentage format on tooltips and bubble chart tooltips format. (#5631) (@conglei)
- [#5629](https://github.com/apache/superset/pull/5629) [bugfix] TIMESTAMP not detected as date (#5629) (@mistercrunch)
- [#5621](https://github.com/apache/superset/pull/5621) Fix annotation_json endpoint (#5621) (@hughhhh)
- [#5624](https://github.com/apache/superset/pull/5624) [Dashobard]Fix bad merge (#5624) (@graceguo-supercat)
- [#5568](https://github.com/apache/superset/pull/5568) [bugfix] line_multi chart crashed on chosen (#5568) (#5572) (@kristw)
- [#5549](https://github.com/apache/superset/pull/5549) Add additional heatmap schemas (#5549) (@jerowe)
- [#5597](https://github.com/apache/superset/pull/5597) No exception on no data (#5597) (@betodealmeida)
- [d04d714](https://github.com/apache/superset/commit/d04d714fe594798f9a27a395cef1b748d7b13f37) Fix menu on 'import dashboards' page (@mistercrunch)
- [#5622](https://github.com/apache/superset/pull/5622) Add option to run query with ctrl+enter (#5622) (@betodealmeida)
- [#5603](https://github.com/apache/superset/pull/5603) [feature] Allow min/max value for the sparkline in time series table (#5603) (@kristw)
- [#5618](https://github.com/apache/superset/pull/5618) [dashboards] Increasing position_json to MEDIUMTEXT for MySQL (#5618) (@john-bodley)
- [#5584](https://github.com/apache/superset/pull/5584) [fix] Enforcing main dttm column (#5584) (@john-bodley)
- [#5611](https://github.com/apache/superset/pull/5611) make some text localizable (#5611) (@hitdemo)
- [#5480](https://github.com/apache/superset/pull/5480) fix cal_heatmap tips location error (#5480) (#5587) (@Narcissus7)

### 0.27.0rc1 (2018/08/12 17:03 +00:00)
- [#5589](https://github.com/apache/superset/pull/5589) [ad-hoc filters] Fixing legacy conversion (#5589) (@john-bodley)
- [#5596](https://github.com/apache/superset/pull/5596) [sql lab - explore flow] make sure groupby is empty (#5596) (@mistercrunch)
- [#5592](https://github.com/apache/superset/pull/5592) [bug]Fix load_examples dashboard version key name (#5592) (@graceguo-supercat)
- [#5579](https://github.com/apache/superset/pull/5579) [sql lab] visualization flow to detect unaliased columns (#5579) (@mistercrunch)
- [#5580](https://github.com/apache/superset/pull/5580) [table editor] disable 'Sync table metadata' button for Superset views (#5580) (@mistercrunch)
- [#5550](https://github.com/apache/superset/pull/5550) Template dashboard (#5550) (@betodealmeida)
- [#5562](https://github.com/apache/superset/pull/5562) update python3 version for testing to 3.6 (#5562) (@octaviancorlade)
- [#5574](https://github.com/apache/superset/pull/5574) Fixed the wrong icon for Source -> Table (#5574) (@conglei)
- [#5573](https://github.com/apache/superset/pull/5573) remove deep-equal and use _.isEqual instead (#5573) (@kristw)
- [#5186](https://github.com/apache/superset/pull/5186) Implement a React-based table editor (#5186) (@mistercrunch)
- [#5552](https://github.com/apache/superset/pull/5552) Add option for BigNumber to not start y-axis at 0 (#5552) (@kristw)
- [#5561](https://github.com/apache/superset/pull/5561) A collection of small bug fixes on master (#5561) (@mistercrunch)
- [#5564](https://github.com/apache/superset/pull/5564) remove uneccessary comma (#5564) (@hitdemo)
- [#5560](https://github.com/apache/superset/pull/5560) Remove function since_until_to_time_range (#5560) (@mistercrunch)
- [#5558](https://github.com/apache/superset/pull/5558) [sql lab] allow EXPlAIN queries (#5558) (@mistercrunch)
- [#5515](https://github.com/apache/superset/pull/5515) convert position to v2 for Superset load_examples (#5515) (@graceguo-supercat)
- [#5544](https://github.com/apache/superset/pull/5544) Improve URLs for Chart and Dashboard ModelViews (#5544) (@mistercrunch)
- [#5559](https://github.com/apache/superset/pull/5559) permissions bug fixes (#5559) (@timifasubaa)
- [#5546](https://github.com/apache/superset/pull/5546) [bugfix] time filter on dashboard view (#5546) (@mistercrunch)
- [#5543](https://github.com/apache/superset/pull/5543) Reduce dashboard position_json data size (#5543) (@graceguo-supercat)
- [#5487](https://github.com/apache/superset/pull/5487) Match viz dataframe column case to form_data fields for Snowflake, Oracle and Redshift (#5487) (@villebro)
- [#5398](https://github.com/apache/superset/pull/5398) Re-add dashboard short links (#5398) (@jaylindquist)
- [#5554](https://github.com/apache/superset/pull/5554) Add Thailand country map (#5554) (@ekasitk)
- [#5514](https://github.com/apache/superset/pull/5514) remove js packages that are not referenced in js code (#5514) (@kristw)
- [#4874](https://github.com/apache/superset/pull/4874) Portuguese translation (#4874) (@nunohelibeires)
- [#5523](https://github.com/apache/superset/pull/5523) [sql lab] simplify the visualize flow (#5523) (@mistercrunch)
- [#5469](https://github.com/apache/superset/pull/5469) Update BigNumber design (#5469) (@kristw)
- [#5536](https://github.com/apache/superset/pull/5536) Replace metadata refresh stacktrace with danger flash (#5536) (@villebro)
- [#5540](https://github.com/apache/superset/pull/5540) fix superset error message flow (#5540) (@timifasubaa)
- [#5531](https://github.com/apache/superset/pull/5531) Include README in MANIFEST (#5531) (@jeffreythewang)
- [#5437](https://github.com/apache/superset/pull/5437) Annotation Styles for Time Series Annotations (#5437) (@JamshedRahman)
- [#5538](https://github.com/apache/superset/pull/5538) Stop pretty printing dashboard json (#5538) (@michellethomas)
- [#5533](https://github.com/apache/superset/pull/5533) [ad-hoc filters] Remove legacy split in /explore (#5533) (@john-bodley)
- [#5517](https://github.com/apache/superset/pull/5517) [get_df] Updating multi-statement logic (#5517) (@john-bodley)
- [#5521](https://github.com/apache/superset/pull/5521) Adding 364 days to time compare option (#5521) (@michellethomas)
- [#5525](https://github.com/apache/superset/pull/5525) [ad-hoc filters] Fixing issue with legacy filters (#5525) (@john-bodley)
- [#5529](https://github.com/apache/superset/pull/5529) Fix time shift (#5529) (@betodealmeida)
- [#5380](https://github.com/apache/superset/pull/5380) Add time grain blacklist and addons to config.py (#5380) (@villebro)
- [#5522](https://github.com/apache/superset/pull/5522) added clickhouse as supported db (#5522) (@The-Alchemist)
- [#5512](https://github.com/apache/superset/pull/5512) hotfix - pass link not error message (#5512) (@timifasubaa)
- [#5504](https://github.com/apache/superset/pull/5504) Set max width for tooltips (#5504) (@jeffreythewang)
- [#5516](https://github.com/apache/superset/pull/5516) Fixed the issue of Zambia country map. (#5516) (@visshaljagtap)
- [#5500](https://github.com/apache/superset/pull/5500) allow security manager provide error message (#5500) (@timifasubaa)
- [#5425](https://github.com/apache/superset/pull/5425) set default layout for new added charts (#5425) (@graceguo-supercat)
- [#5459](https://github.com/apache/superset/pull/5459) Added India in country map visualizaion. (#5459) (@visshaljagtap)
- [#5508](https://github.com/apache/superset/pull/5508) Fix 5479 - unicode columns issue. (#5508) (@mmuru)
- [#5502](https://github.com/apache/superset/pull/5502) Improve hive/pyhive error message regex (#5502) (@mistercrunch)
- [#5505](https://github.com/apache/superset/pull/5505) Remove dashboard transition related config (#5505) (@graceguo-supercat)
- [#5490](https://github.com/apache/superset/pull/5490) [sqllab] fix unexpected keyword argument 'ignore_nan' (#5490) (@mistercrunch)
- [#5493](https://github.com/apache/superset/pull/5493) Apply SQL_QUERY_MUTATOR to explore & dashboard (#5493) (@mistercrunch)
- [#5494](https://github.com/apache/superset/pull/5494) [sql lab] fix Hive 'Transport' not open issue (#5494) (@mistercrunch)
- [#5495](https://github.com/apache/superset/pull/5495) [sql lab] extract Hive error messages (#5495) (@mistercrunch)
- [#5387](https://github.com/apache/superset/pull/5387) Visualization Unicode bug fix (#5387) (@JamshedRahman)
- [#5497](https://github.com/apache/superset/pull/5497) [migration] bug fix in dashboard migration (bebcf3fed1fe_) (#5497) (@graceguo-supercat)
- [#5492](https://github.com/apache/superset/pull/5492) Modify Athena connection description (#5492) (@yoonian)
- [#5478](https://github.com/apache/superset/pull/5478) Remove is-react dep (#5478) (@betodealmeida)
- [#5418](https://github.com/apache/superset/pull/5418) retire dashboard v1 (js and python) (#5418) (@graceguo-supercat)
- [#5463](https://github.com/apache/superset/pull/5463) Migrate dashboard positions data from v1 to v2 format (#5463) (@graceguo-supercat)
- [#5471](https://github.com/apache/superset/pull/5471) [migration] Fix migration 3dda56f1c (#5471) (@john-bodley)
- [#5468](https://github.com/apache/superset/pull/5468) fix migration 3dda56f1c (#5468) (@timifasubaa)
- [#5460](https://github.com/apache/superset/pull/5460) Move flake8-related packages deps to reqs-dev.txt (#5460) (@mistercrunch)
- [#5426](https://github.com/apache/superset/pull/5426) Add row_limit control to line chart (#5426) (@mistercrunch)
- [#5467](https://github.com/apache/superset/pull/5467) Fix broken dedup and remove redundant db_spec logic (#5467) (@villebro)
- [#5464](https://github.com/apache/superset/pull/5464) Fix the build by merging both db migrations heads (#5464) (@mistercrunch)
- [#5178](https://github.com/apache/superset/pull/5178) [sql] Correct SQL parameter formatting (#5178) (@john-bodley)
- [#5454](https://github.com/apache/superset/pull/5454) Clarify title when importing a table (#5454) (@mistercrunch)
- [#5455](https://github.com/apache/superset/pull/5455) Add week granularity for Clickhouse (#5455) (@qeorqe)
- [#5436](https://github.com/apache/superset/pull/5436) Added Zambia geojson up to district level. (#5436) (@AndreLesa)
- [#5410](https://github.com/apache/superset/pull/5410) Migrated to click (#5410) (@gbates101)
- [#5443](https://github.com/apache/superset/pull/5443) Add Snowflake connection string instructions (#5443) (@villebro)
- [#5448](https://github.com/apache/superset/pull/5448) Time filter fixes (#5448) (@betodealmeida)
- [#5413](https://github.com/apache/superset/pull/5413) remove limiting at the display level (#5413) (@timifasubaa)
- [#5432](https://github.com/apache/superset/pull/5432) Typo fixes in viz.py and CONTRIBUTING.md (#5432) (@visshaljagtap)
- [#5416](https://github.com/apache/superset/pull/5416) Add pylint back as a tox env (#5416) (@mistercrunch)
- [#5424](https://github.com/apache/superset/pull/5424) Avoid expensive select_star on dashboard bootstrap data (#5424) (@mistercrunch)
- [#5419](https://github.com/apache/superset/pull/5419) Fixed typos in currently modified files (#5419) (@visshaljagtap)
- [#5393](https://github.com/apache/superset/pull/5393) allow selection of dbs where csv can be uploaded to (#5393) (@timifasubaa)
- [#5415](https://github.com/apache/superset/pull/5415) Fix db migration 3dda56f1c4c6 (#5415) (@mistercrunch)
- [#5370](https://github.com/apache/superset/pull/5370) [webpack 4] third time's the charm ;) (#5370) (@williaster)
- [#5412](https://github.com/apache/superset/pull/5412) Fix time filter in dashboard v2 (#5412) (@betodealmeida)
- [#5411](https://github.com/apache/superset/pull/5411) allow 7 tabs, remove 'slice_' prefix in logs (#5411) (@williaster)
- [#5177](https://github.com/apache/superset/pull/5177) Time shift difference (#5177) (@betodealmeida)
- [#5295](https://github.com/apache/superset/pull/5295) [sqllab] Fix sqllab limit regex issue with sqlparse (#5295) (@timifasubaa)
- [#5101](https://github.com/apache/superset/pull/5101) Explore to SQL Lab (#5101) (@betodealmeida)
- [#5404](https://github.com/apache/superset/pull/5404) [big_number] tooltip shows in the wrong place (#5404) (@mistercrunch)
- [#4981](https://github.com/apache/superset/pull/4981) Make time filter more usable (#4981) (@betodealmeida)
- [#5329](https://github.com/apache/superset/pull/5329) [Table Viz] columns not match with group_by control (#5329) (@graceguo-supercat)
- [#5376](https://github.com/apache/superset/pull/5376) [bugfix] make MetricsControl work with DECK visualizations (#5376) (@mistercrunch)
- [#5375](https://github.com/apache/superset/pull/5375) Add `IS NOT NULL` and `IS NULL` as filter options (#5375) (@hughhhh)
- [#5352](https://github.com/apache/superset/pull/5352) Make Pypi upload support markdown (#5352) (@mistercrunch)
- [#5392](https://github.com/apache/superset/pull/5392) Fix display limit in sql lab (#5392) (@villebro)
- [#5403](https://github.com/apache/superset/pull/5403) Fix the build (#5403) (@mistercrunch)
- [#5368](https://github.com/apache/superset/pull/5368) quote hive column names (#5368) (@timifasubaa)
- [#5355](https://github.com/apache/superset/pull/5355) get rid of global `notify` (#5355) (@williaster)
- [#5236](https://github.com/apache/superset/pull/5236) [pie] improvements to pie charts (#5236) (@mistercrunch)
- [#5357](https://github.com/apache/superset/pull/5357) Set control 'percent_metrics's default to [] (#5357) (@mistercrunch)
- [#5379](https://github.com/apache/superset/pull/5379) Adding Druid Time Granularities (#5379) (@JamshedRahman)
- [#5371](https://github.com/apache/superset/pull/5371) Set ignore NaN as true for TableViz (#5371) (@hughhhh)
- [#5362](https://github.com/apache/superset/pull/5362) [dashboard] should use forceV2Edit property name (#5362) (@graceguo-supercat)
- [#5360](https://github.com/apache/superset/pull/5360) [dashboard] Fix save issue at Force_V2_Edit mode (#5360) (@graceguo-supercat)
- [#5334](https://github.com/apache/superset/pull/5334) CHANGELOG entry for 0.25.0 to 0.26.0 (#5334) (@mistercrunch)
- [#5303](https://github.com/apache/superset/pull/5303) use schema form field in upload csv (#5303) (@timifasubaa)
- [#5354](https://github.com/apache/superset/pull/5354) [cache] Adding description for a zero cache timeout (#5354) (@john-bodley)
- [#5356](https://github.com/apache/superset/pull/5356) added a 'no_trend_line' option (#5356) (@xiaoyugit)

### 0.26.2 (2018/07/05 13:37 +00:00)
- [#5349](https://github.com/apache/superset/pull/5349) impala support for epoch timestamps (#5349) (@aaronbannin)
- [#5211](https://github.com/apache/superset/pull/5211) [Bug fix] Divide by 1000.000 in epoch_ms_to_dttm() to not lose precision in Presto (#5211) (@EvelynTurner)
- [#5328](https://github.com/apache/superset/pull/5328) Implement rolling api introduced in pandas 0.18 (#5328) (@villebro)
- [#5337](https://github.com/apache/superset/pull/5337) normalize column names for Redshift (#5337) (@minh5)

### 0.26.1 (2018/07/04 21:16 +00:00)
- [#5338](https://github.com/apache/superset/pull/5338) A couple of setup.py fixes (#5338) (@xrmx)
- [#5346](https://github.com/apache/superset/pull/5346) RST formatting fix for Installation docs (#5346) (@kulte)
- [#5348](https://github.com/apache/superset/pull/5348) Fix typo in Start with Docker (#5348) (@kulte)
### 0.26.0 (2018/07/03 14:13 +00:00)
- [#5315](https://github.com/apache/superset/pull/5315) [cache] Allowing zero cache-timeout (#5315) (@john-bodley)
- [#5313](https://github.com/apache/superset/pull/5313) Fix flaky unit test - remove 'Markup' object in data (#5313) (@mistercrunch)
- [#5309](https://github.com/apache/superset/pull/5309) [bugfix] README encoding-related UnicodeDecodeError on setup.py (#5309) (@mistercrunch)
- [#5320](https://github.com/apache/superset/pull/5320) Update core.py (#5320) (@fly-high-bj)
- [#5323](https://github.com/apache/superset/pull/5323) [dashboard fix]Fix copy_dash unit test (#5323) (@graceguo-supercat)
- [#5302](https://github.com/apache/superset/pull/5302) [DeckGL] Raise error with null values (#5302) (@hughhhh)
- [#5305](https://github.com/apache/superset/pull/5305) Adding THE ICONIC to the list (#5305) (@ksaagariconic)

### 0.26.0rc2 (2018/06/28 04:40 +00:00)
- [#4724](https://github.com/apache/superset/pull/4724) Improve database type inference (#4724) (@mistercrunch)
- [#5296](https://github.com/apache/superset/pull/5296) [dashboard v2] add MissingChart component in the case that chart component has no slice definition, add tests. (#5296) (@williaster)
- [#5297](https://github.com/apache/superset/pull/5297) [dashobard fix]: fix validation check for default_filters (#5297) (@graceguo-supercat)
- [#5274](https://github.com/apache/superset/pull/5274) [get_df] Fix datetime conversion (#5274) (@john-bodley)
- [#5290](https://github.com/apache/superset/pull/5290) Pin boto3 to 1.4.7 (#5290) (@jeffreythewang)
- [#5291](https://github.com/apache/superset/pull/5291) [dashboard fix] force refresh charts under tabs (#5291) (@graceguo-supercat)
- [#5293](https://github.com/apache/superset/pull/5293) fix sqllab <Loading /> css, fix double AddSliceCard margin and drag border (#5293) (@williaster)
- [#5267](https://github.com/apache/superset/pull/5267) add more precise types to hive table from csv (#5267) (@timifasubaa)
- [#5268](https://github.com/apache/superset/pull/5268) specify hve namespace for tables (#5268) (@timifasubaa)
- [#4528](https://github.com/apache/superset/pull/4528) [wip] dashboard builder v2 (#4528) (@williaster)
- [#5271](https://github.com/apache/superset/pull/5271) [metric] Fixing ad-hoc metric for dual-line chart (#5271) (@john-bodley)
- [#5249](https://github.com/apache/superset/pull/5249) [druid] Adding verbose_name to editable columns (#5249) (@john-bodley)
- [#5257](https://github.com/apache/superset/pull/5257) make sure there is a val to be set for existing filters (#5257) (@hughhhh)
- [#4964](https://github.com/apache/superset/pull/4964) Fix edge case around NaN values (#4964) (@mistercrunch)
- [#5154](https://github.com/apache/superset/pull/5154) [bugfix] add support for numeric nodes in Sankey (#5154) (@mistercrunch)
- [#5248](https://github.com/apache/superset/pull/5248) [bugfix] get word_cloud to support complex metrics (#5248) (@mistercrunch)
- [#5266](https://github.com/apache/superset/pull/5266) fixing regex displaying as undefined in the pill (#5266) (@GabeLoins)
- [#5262](https://github.com/apache/superset/pull/5262) Bump pydruid to 0.4.4 (#5262) (@mistercrunch)
- [#5264](https://github.com/apache/superset/pull/5264) Update db_engine_specs.py (#5264) (@timifasubaa)
- [#5263](https://github.com/apache/superset/pull/5263) [timeseries table] use verbose date in tooltip by default (#5263) (@williaster)
- [#5214](https://github.com/apache/superset/pull/5214) Moving homogenize_types to after no data exception (#5214) (@michellethomas)
- [#5241](https://github.com/apache/superset/pull/5241) [Explore] Handle empty metrics control data (#5241) (@graceguo-supercat)
- [#5121](https://github.com/apache/superset/pull/5121) [sql lab] Fix issue around VARBINARY type in Presto (#5121) (@mistercrunch)
- [#4520](https://github.com/apache/superset/pull/4520) Allow users to view dashboards they own (#4520) (@jeffreythewang)
- [#5253](https://github.com/apache/superset/pull/5253) Revert "[perf] add webpack 4 + SplitChunks + lazy load visualizations" (#5253) (@john-bodley)
- [#5216](https://github.com/apache/superset/pull/5216) [sqllab] Fix sql lab resolution link (#5216) (@timifasubaa)
- [#5184](https://github.com/apache/superset/pull/5184) Pin botocore version (#5184) (@ledor473)
- [#5220](https://github.com/apache/superset/pull/5220) Describe the use of custom OAuth2 authorization servers (#5220) (@ricard2k)
- [#5237](https://github.com/apache/superset/pull/5237) [bubble-chart] Fixing issue w/ metric names (#5237) (@john-bodley)
- [#5206](https://github.com/apache/superset/pull/5206) [adhoc-filters] Adding adhoc-filters to all viz types (#5206) (@john-bodley)
- [#5240](https://github.com/apache/superset/pull/5240) [perf] add webpack 4 + SplitChunks + lazy load visualizations (#5240) (@williaster)
- [#5217](https://github.com/apache/superset/pull/5217) [CRUD] disable user change slices from dashboardmodelview (#5217) (@graceguo-supercat)
- [#5238](https://github.com/apache/superset/pull/5238) [CRUD] Improving performance by disabling editing Associated Chart] (#5238) (@john-bodley)
- [#5215](https://github.com/apache/superset/pull/5215) [Explore] Enable Rich tooltip by default (#5215) (@graceguo-supercat)
- [#5226](https://github.com/apache/superset/pull/5226) setup: improve description (#5226) (@xrmx)
- [#5195](https://github.com/apache/superset/pull/5195) [sql lab] quote schema and table name (#5195) (@mistercrunch)
- [#5222](https://github.com/apache/superset/pull/5222) Bump Celery to 4.2.0 (#5222) (@villebro)
- [#5227](https://github.com/apache/superset/pull/5227) README: update Maieutical Labs url (#5227) (@xrmx)
- [#5219](https://github.com/apache/superset/pull/5219) Revert "[webpack] setup lazy loading for all visualizations" (#5219) (@williaster)
- [#5204](https://github.com/apache/superset/pull/5204) [explore] fix autocomplete on verbose names (#5204) (@mistercrunch)
- [#4727](https://github.com/apache/superset/pull/4727) [webpack] setup lazy loading for all visualizations (#4727) (@williaster)
- [#5203](https://github.com/apache/superset/pull/5203) [pie-chart] Restricting query to single metric (#5203) (@john-bodley)
- [#5205](https://github.com/apache/superset/pull/5205) Fixing issue with table viz for table with no metrics (#5205) (@michellethomas)
- [#5194](https://github.com/apache/superset/pull/5194) Merge pull request #5194 from timifasubaa/pass_error_link_separately (@timifasubaa)
- [7fa5559](https://github.com/apache/superset/commit/7fa5559a66afd7ef06bf35ad72f284f6f253d2b9) remove resolution link prop (@timifasubaa)
- [#5118](https://github.com/apache/superset/pull/5118) Merge pull request #5118 from michellethomas/add_metrics_control_sort_by (@michellethomas)
- [#5181](https://github.com/apache/superset/pull/5181) fix Formula type annotation, it doesn't show up since #4630 (#5181) (@graceguo-supercat)
- [#5176](https://github.com/apache/superset/pull/5176) Introduce class attr BaseViz.enforce_numerical_metrics (#5176) (@mistercrunch)
- [#5187](https://github.com/apache/superset/pull/5187) Repoint .istambul.yml to the right location (#5187) (@mistercrunch)
- [7a107fa](https://github.com/apache/superset/commit/7a107fac6270e6866a00b5c6e2373ea67564d310) pass_error_message_separately (@timifasubaa)
- [#5190](https://github.com/apache/superset/pull/5190) Merge pull request #5190 from timifasubaa/fix_null_metrics (@timifasubaa)
- [b380a57](https://github.com/apache/superset/commit/b380a57c91f9918e7dbc8f858df840e3ccb8d24d) Fixing sortby adhoc metrics for table viz (@michellethomas)
- [95bb175](https://github.com/apache/superset/commit/95bb1753ab3a9fef572b40d7b7762fd7b4982374) fix empty metrics (@timifasubaa)
- [#5179](https://github.com/apache/superset/pull/5179) Adding column only if it doesn't already exist (#5179) (@michellethomas)
- [#5183](https://github.com/apache/superset/pull/5183) fetch datasources from broker endpoint when refresh new datasources (#5183) (@liyuance)
- [#5167](https://github.com/apache/superset/pull/5167) [migrations] Cleaning up migration logic (#5167) (@john-bodley)
- [#5155](https://github.com/apache/superset/pull/5155) [migrations] Cleanup recent migrations (#5155) (@john-bodley)
- [#5055](https://github.com/apache/superset/pull/5055) Fixing tooltip displaying metrics in heatmap (#5055) (@michellethomas)
- [#5108](https://github.com/apache/superset/pull/5108) Fix bullet chart rendering (#5108) (@Tresdon)
- [#5122](https://github.com/apache/superset/pull/5122) Pin FAB and bump a bunch of JS libs (#5122) (@mistercrunch)
- [#4193](https://github.com/apache/superset/pull/4193) Init docker for local development environment. (#4193) (@xiaohanyu)
- [#5028](https://github.com/apache/superset/pull/5028) [druid] Fixing Druid version check (#5028) (@john-bodley)
- [#5156](https://github.com/apache/superset/pull/5156) Restore translations as of 459cb701fb2140fcce8b97a1839a9511574375c7 (#5156) (@mistercrunch)
- [#5162](https://github.com/apache/superset/pull/5162) [Explore][Adhoc Metrics/ Filters] disabled message for custom sql tab in druid (#5162) (@GabeLoins)
- [#5161](https://github.com/apache/superset/pull/5161) [migration] Adding migration to remove empty in/not-in filters (#5161) (@john-bodley)
- [#5160](https://github.com/apache/superset/pull/5160) empty lists are invalid comparators (#5160) (@GabeLoins)
- [#5140](https://github.com/apache/superset/pull/5140) Improve time shift (#5140) (@betodealmeida)
- [#5135](https://github.com/apache/superset/pull/5135) [migrations] Fix time grain SQLA (#5135) (@john-bodley)
- [#5150](https://github.com/apache/superset/pull/5150) pin kombu dependency (#5150) (@timifasubaa)
- [#5136](https://github.com/apache/superset/pull/5136) [crud] Improving performance (#5136) (@john-bodley)
- [#5132](https://github.com/apache/superset/pull/5132) Optimize presto SQL Lab query performance. (#5132) (@xiaohanyu)
- [#5134](https://github.com/apache/superset/pull/5134) Bump celery to 4.1.1 (#5134) (@mistercrunch)
- [#5133](https://github.com/apache/superset/pull/5133) Pin FAB to 1.10.0 (#5133) (@mistercrunch)

### 0.25.6 (2018/06/04 15:56 +00:00)
- [#4760](https://github.com/apache/superset/pull/4760) URL shortner for dashboards (#4760) (@ttannis)
- [4776828](https://github.com/apache/superset/commit/47768284d01453968e9b2e5aef8024110b6dc33e) Adding tests for adhoc metric as timeseries_limit_metric (@michellethomas)
- [#5105](https://github.com/apache/superset/pull/5105) updating adhoc metric filtering (#5105) (@GabeLoins)
- [#5112](https://github.com/apache/superset/pull/5112) docs: Add new Athena URI scheme awsathena+rest:// (#5112) (@icy)
- [#5067](https://github.com/apache/superset/pull/5067) Allow multiple time shifts (#5067) (@betodealmeida)
- [#5111](https://github.com/apache/superset/pull/5111) adding null checks to adhoc filter popover (#5111) (@GabeLoins)

### 0.26.0rc1 (2018/06/01 00:21 +00:00)
- [#5106](https://github.com/apache/superset/pull/5106) Refactor NULL handling into method, disable for DECK.gl vizes (#5106) (@mistercrunch)
- [#5117](https://github.com/apache/superset/pull/5117) Fixing time table viz for adhoc metrics (#5117) (@michellethomas)
- [6f05b48](https://github.com/apache/superset/commit/6f05b48385d80bc6adca3e0aa3b545d34243acfa) Adding the MetricsControl to the timeseries_limit_metric field (@michellethomas)
- [#5107](https://github.com/apache/superset/pull/5107) [bugfix] deck.gl on druid always shows animation (#5107) (@mistercrunch)
- [#5110](https://github.com/apache/superset/pull/5110) fixing LIKE constant name (#5110) (@GabeLoins)
- [#5023](https://github.com/apache/superset/pull/5023) Merge pull request #5023 from timifasubaa/fix_sqllab_commit (@timifasubaa)
- [#5084](https://github.com/apache/superset/pull/5084) Override time grain in annotations (#5084) (@betodealmeida)
- [#5109](https://github.com/apache/superset/pull/5109) Merge pull request #5109 from cxmcc/patch-1 (@cxmcc)
- [21967f4](https://github.com/apache/superset/commit/21967f40e720cfcc7d5cbe33cf5504e90c21b412) Add Lime to Superset user list. (@cxmcc)
- [a9d7faf](https://github.com/apache/superset/commit/a9d7fafd9f2dca7c569effa477e3ff3240d3032e) add tests (@timifasubaa)
- [#5098](https://github.com/apache/superset/pull/5098) Bump dep on pydruid to 0.4.3 (#5098) (@mistercrunch)
- [#5086](https://github.com/apache/superset/pull/5086) [get_df] Adding support for multi-statement SQL (#5086) (@john-bodley)
- [#5094](https://github.com/apache/superset/pull/5094) add CnOvit to Superset users list (#5094) (@xieshaohu)
- [#5083](https://github.com/apache/superset/pull/5083) Add more time grains (#5083) (@betodealmeida)
- [#4428](https://github.com/apache/superset/pull/4428) Proper error handling in Hive Queries (#4428) (@maver1ck)
- [#5093](https://github.com/apache/superset/pull/5093) Fix python2 str() in visualization (#5093) (@zjj)
- [d38315a](https://github.com/apache/superset/commit/d38315a307f7b3c2a41c63b7f654fae90183c03e) reuse_regex_logic (@timifasubaa)
- [1aced9b](https://github.com/apache/superset/commit/1aced9b56207fccc839afb5c32f9ee76aa0a6b47) force limit only when there is no existing limit (@timifasubaa)
- [#5080](https://github.com/apache/superset/pull/5080) [bugfix] fix visualization with adhocMetric (#5080) (@zhaoyongjie)
- [#5068](https://github.com/apache/superset/pull/5068) Add 24 hours refresh for dashboard (#5068) (@aok1425)
- [#5000](https://github.com/apache/superset/pull/5000) Use a dummy version number on master (#5000) (@mistercrunch)
- [#5078](https://github.com/apache/superset/pull/5078) Revert "[get_df] Adding support for multi-statement SQL" (#5078) (@john-bodley)
- [#5057](https://github.com/apache/superset/pull/5057) Translate string to array for multi fields in getControlsState (#5057) (@michellethomas)
- [#5065](https://github.com/apache/superset/pull/5065) Fix time shift color assignements (#5065) (@mistercrunch)
- [#5062](https://github.com/apache/superset/pull/5062) [markup] Enable allow-forms (#5062) (@john-bodley)
- [#5056](https://github.com/apache/superset/pull/5056) integrating dashboard filters with adhoc filters (#5056) (@GabeLoins)
- [#5060](https://github.com/apache/superset/pull/5060) [get_df] Adding support for multi-statement SQL (#5060) (@john-bodley)
- [#5051](https://github.com/apache/superset/pull/5051) [Dashboard] Allow Superset Alpha, Gamma users to save dashboard as a copy (#5051) (@graceguo-supercat)
- [#5021](https://github.com/apache/superset/pull/5021) Allow MetricsControl to aggregate on a column with an expression (#5021) (@michellethomas)
- [#5025](https://github.com/apache/superset/pull/5025) fix metrics type error in pivot table viz (#5025) (@gangh)
- [#5008](https://github.com/apache/superset/pull/5008) Rename "slice" to "chart" and update translations (#5008) (@betodealmeida)
- [#4819](https://github.com/apache/superset/pull/4819) Visualization for multiple line charts (#4819) (@betodealmeida)
- [#5032](https://github.com/apache/superset/pull/5032) expanding simple tab (#5032) (@GabeLoins)
- [#5038](https://github.com/apache/superset/pull/5038) forcing ace editor to refresh when it is shown (#5038) (@GabeLoins)
- [#5027](https://github.com/apache/superset/pull/5027) Add missing dep on contextlib2 (#5027) (@mistercrunch)
- [#5030](https://github.com/apache/superset/pull/5030) treating floats like doubles for druid versions lower than 11.0.0 (#5030) (@GabeLoins)
- [#5026](https://github.com/apache/superset/pull/5026) [bugfix] Fix ZeroDivisionError and get metrics label with percent metrics (#5026) (@zhaoyongjie)
- [#5019](https://github.com/apache/superset/pull/5019) Merge pull request #5019 from timifasubaa/fix_error_message_for_missing_datasource (@timifasubaa)
- [63115fb](https://github.com/apache/superset/commit/63115fbb879a2b67e2a701f376364c52dc49a7c9) nit (@timifasubaa)
- [f52f7aa](https://github.com/apache/superset/commit/f52f7aa7cfb9898e898ba77a07073c53627fee85) raise exception early (@timifasubaa)

### 0.25.5 (2018/05/17 19:45 +00:00)
- [#5022](https://github.com/apache/superset/pull/5022) Merge pull request #5022 from mistercrunch/flask_sub_1 (@mistercrunch)
- [2ba929a](https://github.com/apache/superset/commit/2ba929ac9e1d9e6ce7120e021e3f62ba769f8f6e) Fix flask 1.0.0 (@mistercrunch)

### 0.25.4 (2018/05/16 23:31 +00:00)
- [#5020](https://github.com/apache/superset/pull/5020) Make port number optional in superset for druid (#5020) (@amalakar)
- [cf374ef](https://github.com/apache/superset/commit/cf374efb3f8b347e912ef2174492994152fc7ddb) fix missing datasource error message (@timifasubaa)

### 0.25.3 (2018/05/16 18:25 +00:00)
- [#5007](https://github.com/apache/superset/pull/5007) Fix EncryptedType error (#5007) (@mistercrunch)
- [#5012](https://github.com/apache/superset/pull/5012) Fix AdhocFilterControl for single metric options (#5012) (@michellethomas)
- [#4914](https://github.com/apache/superset/pull/4914) Make MetricsControl the standard across visualizations (#4914) (@mistercrunch)
- [#4947](https://github.com/apache/superset/pull/4947) [sql lab] a better approach at limiting queries (#4947) (@mistercrunch)
- [#4965](https://github.com/apache/superset/pull/4965) Update Apache Kylin dbengine with supported week/quarter grains (#4965) (@zhaoyongjie)
- [#4992](https://github.com/apache/superset/pull/4992) cleaning up the table fab view since we hide these autogenerated metrics anyway (#4992) (@GabeLoins)
- [#4994](https://github.com/apache/superset/pull/4994) Force lowercase column names for Snowflake and Oracle (#4994) (@villebro)
- [#4991](https://github.com/apache/superset/pull/4991) Merge pull request #4991 from michellethomas/fix_filter_blank_custom_sql (@michellethomas)

### 0.25.1 (2018/05/14 16:07 +00:00)
- [#4959](https://github.com/apache/superset/pull/4959) [deps] force flask 1.0.0 (#4959) (@mistercrunch)
- [ad4912d](https://github.com/apache/superset/commit/ad4912d6012849eb900ac74fe05d1d3e368883c9) Allowing sqlExpression to be blank (@michellethomas)
- [#4990](https://github.com/apache/superset/pull/4990) expanding regex for automated columns (#4990) (@GabeLoins)
- [#4977](https://github.com/apache/superset/pull/4977) Merge pull request #4977 from timifasubaa/bump_pyhive_version (@timifasubaa)
- [6720255](https://github.com/apache/superset/commit/67202558681884e7a1a1f1ea2b09c629c347a320) bump pyhive version (@timifasubaa)
- [#4909](https://github.com/apache/superset/pull/4909) [Explore] Adding Adhoc Filters (#4909) (@GabeLoins)
- [#4927](https://github.com/apache/superset/pull/4927) [sql lab] Use context manager for sqllab sessions (#4927) (@grafke)
- [#4971](https://github.com/apache/superset/pull/4971) Fix templating in sqla datasource (#4971) (@villebro)
- [#4972](https://github.com/apache/superset/pull/4972) superset/import_dashboards.html: Update title, clean up html (#4972) (@sodevious)
- [#4943](https://github.com/apache/superset/pull/4943) [bugfix] handling UTF8 in Druid dimensions (#4943) (@mistercrunch)
- [#4740](https://github.com/apache/superset/pull/4740) Add extraction function support for Druid queries (#4740) (@jasnovak)
- [#4948](https://github.com/apache/superset/pull/4948) CHANGELOG for 0.25.0 (#4948) (@mistercrunch)
- [#4954](https://github.com/apache/superset/pull/4954) add 30 minutes support under time granularity (#4954) (@liyuance)
- [#4950](https://github.com/apache/superset/pull/4950) Support hours in relative time range selection (#4950) (@liyuance)
- [#4944](https://github.com/apache/superset/pull/4944) Move from deprecated flask-cache to flask-caching (#4944) (@mistercrunch)
- [#4946](https://github.com/apache/superset/pull/4946) Fix naming for geojson (#4946) (@hughhhh)

### 0.25.0 (2018/05/08 05:20 +00:00)
- [#4942](https://github.com/apache/superset/pull/4942) [docs] add entry for Hive in installation.rst (#4942) (@mistercrunch)
- [#4928](https://github.com/apache/superset/pull/4928) [sql lab] handle query stop race condition (#4928) (@mistercrunch)
- [#4930](https://github.com/apache/superset/pull/4930) Update installation.rst (#4930) (@vihar)
- [#4833](https://github.com/apache/superset/pull/4833) Merge pull request #4833 from timifasubaa/help_sqllab_forget_the_past (@timifasubaa)
- [ab958c6](https://github.com/apache/superset/commit/ab958c67e6b7fde14e3d79c535045ca87fc5b732) make queries older than 6 hours timeout (@timifasubaa)
- [#4939](https://github.com/apache/superset/pull/4939) Add Portugal to country_map visualization  (#4939) (@joaomg)
- [#4938](https://github.com/apache/superset/pull/4938) add Airboxlab to Superset users list (#4938) (@antoine-galataud)
- [#4940](https://github.com/apache/superset/pull/4940) Add Windsor.ai to the list of organizations (#4940) (@octaviancorlade)
- [#4899](https://github.com/apache/superset/pull/4899) rm-slices (#4899) (@hughhhh)
- [#4887](https://github.com/apache/superset/pull/4887) [druid] Updating Druid refresh metadata tests (#4887) (@john-bodley)
- [#4900](https://github.com/apache/superset/pull/4900) Hide restricted ui elements, remove <br> from error message (#4900) (@jasnovak)
- [#4923](https://github.com/apache/superset/pull/4923) Install superset in Kubernetes with helm chart (#4923) (@cychiang)
- [#4925](https://github.com/apache/superset/pull/4925) Support Apache Kylin in EngineSpec (#4925) (@zhaoyongjie)
- [#4921](https://github.com/apache/superset/pull/4921) [bufix] filtered column was removed (#4921) (@mistercrunch)
- [#4917](https://github.com/apache/superset/pull/4917) Add doc entry for BigQuery support (#4917) (@mistercrunch)
- [#4918](https://github.com/apache/superset/pull/4918) Fix typos from linting (#4918) (@mistercrunch)
- [#4911](https://github.com/apache/superset/pull/4911) Fix for week_start_sunday and week_ending_saturday (#4911) (@betodealmeida)
- [#4908](https://github.com/apache/superset/pull/4908) Replace NaN/Infinity with null (#4908) (@betodealmeida)
- [#4913](https://github.com/apache/superset/pull/4913) Fix country_map visualization URL (#4913) (@mistercrunch)
- [#4883](https://github.com/apache/superset/pull/4883) Add note about 0.25.0 upgrade in UPDATING.md (#4883) (@mistercrunch)
- [#4897](https://github.com/apache/superset/pull/4897) Heatmap improvements (#4897) (@mistercrunch)
- [#4906](https://github.com/apache/superset/pull/4906) requirements: bump gunicorn to 19.8.0 (#4906) (@xrmx)
- [#4907](https://github.com/apache/superset/pull/4907) translations: rename pt_BR gettext files (#4907) (@xrmx)
- [#4884](https://github.com/apache/superset/pull/4884) [pylint] prepping for enabling pylint for non-errors (#4884) (@john-bodley)
- [#4901](https://github.com/apache/superset/pull/4901) Fix 'Uncaught TypeError: pe.clamp is not a function' (#4901) (@mistercrunch)
- [#4896](https://github.com/apache/superset/pull/4896) [sql lab] allow stoping 'pending' queries (#4896) (@mistercrunch)
- [#4886](https://github.com/apache/superset/pull/4886) remove hard code http scheme of short url #4656 (#4886) (@ripoul)
- [#4891](https://github.com/apache/superset/pull/4891) Allow limiting rows on Pivot Table (#4891) (@mistercrunch)
- [#4890](https://github.com/apache/superset/pull/4890) [bugfix] temporal columns with expression fail (#4890) (@mistercrunch)
- [#4882](https://github.com/apache/superset/pull/4882) Implement Snowflake engine with supported time grains (#4882) (@villebro)
- [#4841](https://github.com/apache/superset/pull/4841) Move a few JS files (#4841) (@mistercrunch)
- [#4872](https://github.com/apache/superset/pull/4872) Remove spurious "has" from README (#4872) (@davidthewatson)
- [#4869](https://github.com/apache/superset/pull/4869) remove DISTINCT ON statement (#4869) (@stillmatic)
- [#4866](https://github.com/apache/superset/pull/4866) [axis formatting] Override the valueformat to be percentage when contribution is selected (#4866) (@conglei)
- [#4836](https://github.com/apache/superset/pull/4836) Refactoring on exploreReducer.js (#4836) (@hughhhh)
- [#4856](https://github.com/apache/superset/pull/4856) Fix 'pip install .' (#4856) (@mistercrunch)
- [#4842](https://github.com/apache/superset/pull/4842) Safely passing data to d3.html (#4842) (@michellethomas)
- [#4867](https://github.com/apache/superset/pull/4867) Add Astronomer to list of organizations using Apache Superset (#4867) (@ryw)
- [#4843](https://github.com/apache/superset/pull/4843) [formats] add better defaults for time + number formatting (#4843) (@williaster)
- [#4853](https://github.com/apache/superset/pull/4853) [sql] Using read_sql_query instead of read_sql (#4853) (@john-bodley)
- [#4854](https://github.com/apache/superset/pull/4854) correct config language key to pt_BR (#4854) (@pld)
- [#4850](https://github.com/apache/superset/pull/4850) Remove obsolete TODO.md (#4850) (@mistercrunch)
- [#4844](https://github.com/apache/superset/pull/4844) [docs] minor file name and format fix for the setup document (#4844) (@sekikn)
- [#4821](https://github.com/apache/superset/pull/4821) Fix time granularity-related issues (#4821) (@mistercrunch)
- [#4829](https://github.com/apache/superset/pull/4829) ensure directory exists before saving csv file (#4829) (@timifasubaa)
- [e47d8a5](https://github.com/apache/superset/commit/e47d8a59a4773f29e62d9b33d7ad6ad2b343abdd) help sqllab forget the past (@timifasubaa)
- [#4651](https://github.com/apache/superset/pull/4651) [explore] proper filtering of NULLs and '' (#4651) (@mistercrunch)
- [#4835](https://github.com/apache/superset/pull/4835) [setup] Dropping 3.4 and adding 3.6 (#4835) (@john-bodley)
- [#4820](https://github.com/apache/superset/pull/4820) Moving some JS folders (#4820) (@mistercrunch)
- [#4828](https://github.com/apache/superset/pull/4828) [travis] Fixing environments (#4828) (@john-bodley)
- [#4831](https://github.com/apache/superset/pull/4831) db_engine_specs: use correct sqlite week time grain (#4831) (@xrmx)
- [#4825](https://github.com/apache/superset/pull/4825) Update README with fresher screenshots (#4825) (@mistercrunch)
- [#4736](https://github.com/apache/superset/pull/4736) [Explore] Adding custom expressions to adhoc metrics (#4736) (@GabeLoins)
- [#4817](https://github.com/apache/superset/pull/4817) [docs] many improvements to the documentation / cleanup (#4817) (@mistercrunch)
- [#4823](https://github.com/apache/superset/pull/4823) docs: use proper dialect for redshift (#4823) (@xrmx)
- [#4702](https://github.com/apache/superset/pull/4702) RFC: add logger that logs into browser console (#4702) (@betodealmeida)
- [#4798](https://github.com/apache/superset/pull/4798) [DeckGL] Added fixtures and Deck test (#4798) (@hughhhh)
- [#4800](https://github.com/apache/superset/pull/4800) Improve the calendar heatmap (#4800) (@mistercrunch)
- [#4746](https://github.com/apache/superset/pull/4746) Filtering out SQLLab views out of table list view by default (#4746) (@mistercrunch)
- [#4815](https://github.com/apache/superset/pull/4815) [migrations] Fixing issue #4810 (#4815) (@john-bodley)
- [#4807](https://github.com/apache/superset/pull/4807) Make the bottom margin a bit taller (#4807) (@mistercrunch)
- [#4801](https://github.com/apache/superset/pull/4801) [bugfix] dedup groupby columns in Deck visualizations (#4801) (@mistercrunch)
- [#4803](https://github.com/apache/superset/pull/4803) [explore] set working default for MetricsControl (#4803) (@mistercrunch)
- [#4806](https://github.com/apache/superset/pull/4806) [tests] cleaning up test configuration (#4806) (@john-bodley)
- [#4659](https://github.com/apache/superset/pull/4659) Adding tests for the time table viz (#4659) (@michellethomas)
- [#3658](https://github.com/apache/superset/pull/3658) BugFix(#3658) (#4133) (@hidetoshiito)
- [#4804](https://github.com/apache/superset/pull/4804) call next() the right way (#4804) (@timifasubaa)
- [#4808](https://github.com/apache/superset/pull/4808) filter recently viewed to just have explore and dashboard types (#4808) (@hughhhh)
- [#4525](https://github.com/apache/superset/pull/4525) adding option for multiple metrics, group by, opacity, legends (#4525) (@ArielStv)
- [#4587](https://github.com/apache/superset/pull/4587) [logs] Dropping dt column (#4587) (@john-bodley)
- [#4802](https://github.com/apache/superset/pull/4802) [homepage] Fix Favorites chart list (#4802) (@graceguo-supercat)
- [#4552](https://github.com/apache/superset/pull/4552) [travis/tox] Restructuring configuration (#4552) (@john-bodley)
- [#4799](https://github.com/apache/superset/pull/4799) [bugfix] when num_period_compare is not set (#4799) (@mistercrunch)
- [#4756](https://github.com/apache/superset/pull/4756) Improve xAxis ticks, thinner bottom margin (#4756) (@mistercrunch)
- [#4792](https://github.com/apache/superset/pull/4792) Add Ascendica Development in organizations list who use Superset (#4792) (@davidhassan)
- [#4774](https://github.com/apache/superset/pull/4774) [explore] forcing .1% number format when using 'Period Ratio' (#4774) (@mistercrunch)
- [#4647](https://github.com/apache/superset/pull/4647) Add play slider to screengrid (#4647) (@betodealmeida)
- [#4781](https://github.com/apache/superset/pull/4781) Rename UPDATING.MD to UPDATING.md (#4781) (@john-bodley)
- [#4765](https://github.com/apache/superset/pull/4765) [line] fix verbose names in time shift (#4765) (@mistercrunch)
- [#4777](https://github.com/apache/superset/pull/4777) [doc] module header for controls.jsx and visTypes.jsx (#4777) (@mistercrunch)
- [#4772](https://github.com/apache/superset/pull/4772) [dashboard] open in edit mode when adding a chart (#4772) (@mistercrunch)
- [#4768](https://github.com/apache/superset/pull/4768) [Bug fix] Resolving key conflicts in Timeseries Annotation Layer when key is a string (#4768) (@EvelynTurner)
- [#4767](https://github.com/apache/superset/pull/4767) Improve controls layout for Table visualization (#4767) (@mistercrunch)
- [#4755](https://github.com/apache/superset/pull/4755) Pass granularity from backend to frontend as ISO duration (#4755) (@betodealmeida)
- [#4773](https://github.com/apache/superset/pull/4773) Fix brush with annotations (#4773) (@betodealmeida)
- [#4778](https://github.com/apache/superset/pull/4778) Add notes to contrib file about testing and code coverage (#4778) (@ttannis)
- [#4766](https://github.com/apache/superset/pull/4766) [explore] set control default for *showminmax = false (#4766) (@mistercrunch)
- [#4673](https://github.com/apache/superset/pull/4673) Add context to templates / respect slice timeout (#4673) (@daoready)
- [#4761](https://github.com/apache/superset/pull/4761) [druid] Excluding refreshing verbose name (#4761) (@john-bodley)
- [#4754](https://github.com/apache/superset/pull/4754) [deck_multi] fixing issues with deck_multi (#4754) (@mistercrunch)
- [#4741](https://github.com/apache/superset/pull/4741) Set longer CSRF token duration (one week) (#4741) (@mistercrunch)
- [#4742](https://github.com/apache/superset/pull/4742) [sql lab] preserve schema through visualize flow (#4742) (@mistercrunch)
- [#4005](https://github.com/apache/superset/pull/4005) [BUGFIX]: JavaScripts max int is 2^53 - 1, longs are bigger (#4005) (@fabianmenges)
- [#4728](https://github.com/apache/superset/pull/4728) [sql_lab]Disabled run query button if sql query editor is empty (#4728) (@lprashant-94)
- [#4726](https://github.com/apache/superset/pull/4726) [bugfix] convert metrics to numeric in dataframe (#4726) (@mistercrunch)
- [#4648](https://github.com/apache/superset/pull/4648) Pass timezone to Druid Query granularity (#4648) (@ktong)
- [#4646](https://github.com/apache/superset/pull/4646) [BugFix] Allowing limit ordering by post-aggregation metrics (#4646) (@jeffreythewang)
- [#4603](https://github.com/apache/superset/pull/4603) [flask-appbuilder] Bumping version to 1.10.0 (#4603) (@john-bodley)
- [#4730](https://github.com/apache/superset/pull/4730) Fix deep equality logic (#4730) (@mistercrunch)
- [#4654](https://github.com/apache/superset/pull/4654) Expose metrics to JS (#4654) (@betodealmeida)
- [#4718](https://github.com/apache/superset/pull/4718) including auto generated avg metrics in druid (#4718) (@GabeLoins)
- [#4738](https://github.com/apache/superset/pull/4738) easier tab closing in sqllab (#4738) (@GabeLoins)
- [#4729](https://github.com/apache/superset/pull/4729) [explore] don't prompt to 'Run Query' on viewport change (#4729) (@mistercrunch)
- [#4720](https://github.com/apache/superset/pull/4720) Add '.1%' to number format options (#4720) (@mistercrunch)
- [#4717](https://github.com/apache/superset/pull/4717) [sqllab] fix data grid's instant search function (#4717) (@mistercrunch)
- [#4451](https://github.com/apache/superset/pull/4451) [cli] Deprecating gunicorn/flower dependencies (#4451) (@john-bodley)
- [#4689](https://github.com/apache/superset/pull/4689) Remove redundant has_access definition in superset (#4689) (@timifasubaa)
- [#4669](https://github.com/apache/superset/pull/4669) [sqllab] Using app context for Celery task (#4669) (@john-bodley)
- [#4693](https://github.com/apache/superset/pull/4693) Use 3 letters month prefix in default date format (#4693) (@mistercrunch)
- [#4719](https://github.com/apache/superset/pull/4719) [sql lab] ctrl-r hotkey should run latest SQL (#4719) (@mistercrunch)
- [#4714](https://github.com/apache/superset/pull/4714) Add missing perms to sql_lab role (#4714) (@mistercrunch)
- [#4709](https://github.com/apache/superset/pull/4709) Remove trailing '/' from Mailing list link in README file (#4709) (@Alagappan)
- [#4663](https://github.com/apache/superset/pull/4663) [Explore] Streamlined metric definitions for SQLA and Druid (#4663) (@GabeLoins)
- [#4703](https://github.com/apache/superset/pull/4703) Rename no_reload (#4703) (@betodealmeida)
- [#4700](https://github.com/apache/superset/pull/4700) Fixing label issue when columnType is null (#4700) (@michellethomas)
- [#4687](https://github.com/apache/superset/pull/4687) i18n(es_es) (#4687) (@joebordes)
- [#4565](https://github.com/apache/superset/pull/4565) [security] Refactor security code into SupersetSecurityManager (#4565) (@timifasubaa)
- [#4680](https://github.com/apache/superset/pull/4680) Hotkeys in SQL Lab (#4680) (@mistercrunch)
- [#4697](https://github.com/apache/superset/pull/4697) Docs on how to package a release + CHANGELOG for 0.24.0 (#4697) (@mistercrunch)
### 0.24.0 (2018/03/27 06:50 +00:00)
- [#4655](https://github.com/apache/superset/pull/4655) [druid] Updating refresh logic (#4655) (@john-bodley)
- [#4683](https://github.com/apache/superset/pull/4683) Fix bug with sorting columns in group by using time shift (#4683) (@michellethomas)
- [#4645](https://github.com/apache/superset/pull/4645) CRUD hints around SQL expressions (#4645) (@mistercrunch)
- [#4686](https://github.com/apache/superset/pull/4686) Preprocess SQL Lab query prior to checking syntax (#4686) (@villebro)
- [#4684](https://github.com/apache/superset/pull/4684) Fix up the Lyft color scheme (#4684) (@mistercrunch)
- [#4682](https://github.com/apache/superset/pull/4682) Add lyftColor to the game 💯 (#4682) (@hughhhh)
- [#4679](https://github.com/apache/superset/pull/4679) add yarn lock info to contributing.md (#4679) (@timifasubaa)
- [#4639](https://github.com/apache/superset/pull/4639) forms: make csv import parse dates accepts a list of columns (#4639) (@xrmx)
- [#4674](https://github.com/apache/superset/pull/4674) add yarn.lock (#4674) (@timifasubaa)
- [#4676](https://github.com/apache/superset/pull/4676) Fix setup.py, comma makes download_url a tuple (#4676) (@mistercrunch)
- [#4630](https://github.com/apache/superset/pull/4630) [Bug fix] Fixed/Refactored annotation layer code so that non-timeseries annotations are applied based on the updated chart object after adding all data (#4630) (@EvelynTurner)
- [#4670](https://github.com/apache/superset/pull/4670) Update messages.po (#4670) (@aleksi75)
- [#4664](https://github.com/apache/superset/pull/4664) fix: epoch_s and epoch_ms to date time (#4664) (@deatheyes)
- [#4660](https://github.com/apache/superset/pull/4660) Better default for MAPBOX_API_KEY (#4660) (@betodealmeida)
- [#4633](https://github.com/apache/superset/pull/4633) Cache the query string (#4633) (@jeffreythewang)
- [#4628](https://github.com/apache/superset/pull/4628) [sql lab] search to use fist&last name instead of username (#4628) (@mistercrunch)
- [#4608](https://github.com/apache/superset/pull/4608) Set filter_select_enabled default to True for Druid (#4608) (@mistercrunch)
- [#4555](https://github.com/apache/superset/pull/4555) [examples] let's not use 'date' as a col name (#4555) (@mistercrunch)
- [#4606](https://github.com/apache/superset/pull/4606) Use 'count' as the default metric when available (#4606) (@mistercrunch)
- [#4629](https://github.com/apache/superset/pull/4629) Fix sqllab numpy array (#4629) (@michellethomas)
- [#4601](https://github.com/apache/superset/pull/4601) Only show overlay if container is set (#4601) (@betodealmeida)
- [#4638](https://github.com/apache/superset/pull/4638) [cosmetic] removing table border in ModelView list (#4638) (@mistercrunch)
- [#4641](https://github.com/apache/superset/pull/4641) part1 (#4641) (@hughhhh)
- [#4632](https://github.com/apache/superset/pull/4632) Adding to list of generated-members to fix pylint errors (#4632) (@michellethomas)
- [#4566](https://github.com/apache/superset/pull/4566) Adding column type label to dropdowns (#4566) (@michellethomas)
- [#4627](https://github.com/apache/superset/pull/4627) Merge pull request #4627 from mistercrunch/fix_run_extra (@mistercrunch)
- [b906fec](https://github.com/apache/superset/commit/b906fece68bee8ccfba4d1f46da2221c37b5d0fa) Move run_extra_queries outsize of BaseViz init (@mistercrunch)
- [#4593](https://github.com/apache/superset/pull/4593) [sql lab] reduce the number of metadata calls when loading a table (#4593) (@mistercrunch)
- [#4620](https://github.com/apache/superset/pull/4620) Fix function name (#4620) (@betodealmeida)
- [#4622](https://github.com/apache/superset/pull/4622) Remove group by from deck.gl viz (#4622) (@betodealmeida)
- [#4617](https://github.com/apache/superset/pull/4617) Allowing config flag to turn off flask-compress (#4617) (@mistercrunch)
- [#4194](https://github.com/apache/superset/pull/4194) [bug fixes] annotations  x domains, zeros in text (#4194) (@williaster)
- [#4621](https://github.com/apache/superset/pull/4621) fix mapbox viz (#4621) (@graceguo-supercat)
- [#4616](https://github.com/apache/superset/pull/4616) [contributing] Removing obsolete code climate reference (#4616) (@john-bodley)
- [#4572](https://github.com/apache/superset/pull/4572) Legend for deck.gl scatterplot (#4572) (@betodealmeida)
- [#4604](https://github.com/apache/superset/pull/4604) Show "Range Filter" by default (#4604) (@betodealmeida)
- [#4609](https://github.com/apache/superset/pull/4609) overriding annotation and layers control tab (#4609) (@GabeLoins)
- [#4607](https://github.com/apache/superset/pull/4607) [slice_json] pass slice id to get_form_data() (#4607) (@williaster)
- [#4590](https://github.com/apache/superset/pull/4590) Merge pull request #4590 from michellethomas/fixing_double_escape_presto (@michellethomas)
- [#4579](https://github.com/apache/superset/pull/4579) Merge pull request #4579 from michellethomas/removing_title_label (@michellethomas)
- [#4573](https://github.com/apache/superset/pull/4573) Merge pull request #4573 from john-bodley/john-bodley-cache-fix-datasource-uid (@john-bodley)
- [#4602](https://github.com/apache/superset/pull/4602) Merge pull request #4602 from john-bodley/john-bodley-druid-sync-fix-filter (@john-bodley)

### 0.23.3 (2018/03/13 17:14 +00:00)
- [#4581](https://github.com/apache/superset/pull/4581) timeseries_limit should not be required for phase 2 (#4581) (@michellethomas)
- [8829218](https://github.com/apache/superset/commit/882921825ca6508b598dee52c9dea73e54982b1b) Changing the title for explore pages (@michellethomas)
- [9604e1d](https://github.com/apache/superset/commit/9604e1dd1466521c0de4e81b53f2b1ae61b88942) [druid] Adding cluster filter for refresh
- [#4597](https://github.com/apache/superset/pull/4597) [BugFix] Resizing widgets problem #4596 (#4597) (@oxydash)
- [26257d9](https://github.com/apache/superset/commit/26257d94f5f43a5d3b745c1b08a29cc40980f211) [cache] Ensuring that the datasource UID is defined
- [#4514](https://github.com/apache/superset/pull/4514) Added new exception class and start of better exception/error handling (#4514) (@hughhhh)
- [#4599](https://github.com/apache/superset/pull/4599) Add ignore git @eaDir Synology directory (#4599) (@oxydash)
- [#4591](https://github.com/apache/superset/pull/4591) Add Aktia Bank in organizations list who use Superset (#4591) (@villebro)
- [#4594](https://github.com/apache/superset/pull/4594) docs: fixup code blocks rendering (#4594) (@xrmx)
- [e1af421](https://github.com/apache/superset/commit/e1af421f0c7426391e7124d1bae5aae9f8a49792) Removing escape_sql so we dont double escape (@michellethomas)
- [#4532](https://github.com/apache/superset/pull/4532) histograms: fixup left margin assigment (#4532) (@xrmx)
- [#4504](https://github.com/apache/superset/pull/4504) Return time in Druid scan (#4504) (@betodealmeida)
- [#4584](https://github.com/apache/superset/pull/4584) [sqllab] Added share button to bottom menu (#4584) (@hughhhh)
- [#4551](https://github.com/apache/superset/pull/4551) [sql lab] option to disable cross schema search (#4551) (@mistercrunch)
- [#4585](https://github.com/apache/superset/pull/4585) [sql lab] comment injection hook (#4585) (@mistercrunch)
- [#4586](https://github.com/apache/superset/pull/4586) [Translate] Added Full Russian Translation (#4586) (@oxydash)
- [#4582](https://github.com/apache/superset/pull/4582) Merge pull request #4582 from john-bodley/john-bodley-javascript-codecov (@john-bodley)
- [3fbadd6](https://github.com/apache/superset/commit/3fbadd68a471e4dcbdc8f0d37352af9c556e4e94) [code-climate] Deprecating Code Climate from JavaScript tests
- [#4570](https://github.com/apache/superset/pull/4570) Adding option to visualize negative values in Table view (#4570) (@tanvach)
- [402c7dd](https://github.com/apache/superset/commit/402c7ddb26399d4ef984bcf786e2514eaeb7f355) Removing [dashboard] and [slice] titles to show name (@michellethomas)
- [#4578](https://github.com/apache/superset/pull/4578) [Explore] Save custom url parameters when user save slices (#4578) (@graceguo-supercat)
- [#4550](https://github.com/apache/superset/pull/4550) Evelynturner/annotation timezone fix2 (#4550) (@EvelynTurner)
- [#4472](https://github.com/apache/superset/pull/4472) Basic Portuguese Brazilian Translation (#4472) (@AcNeidert)
- [#4562](https://github.com/apache/superset/pull/4562) [bug] Fix CSV upload feature for DB with password (#4562) (@ktravis)
- [#4563](https://github.com/apache/superset/pull/4563) [landscape.io] Deprecating .landscape.yml (#4563) (@john-bodley)
- [#4564](https://github.com/apache/superset/pull/4564) [requires.io] Removing obsolete requires.io link (#4564) (@john-bodley)
- [#4567](https://github.com/apache/superset/pull/4567) Merge pull request #4567 from john-bodley/john-bodley-payload-error-status-code (@john-bodley)
- [1e8cd0e](https://github.com/apache/superset/commit/1e8cd0e61e7bb442af7eab9997da487a82c91673) [payload] Set status code on error rather than query status
- [#4560](https://github.com/apache/superset/pull/4560) [bug] fix shortener url (#4560) (@graceguo-supercat)
- [#4505](https://github.com/apache/superset/pull/4505) Expose hook to inject database connection logic on the fly (#4505) (@mistercrunch)
- [#4543](https://github.com/apache/superset/pull/4543) Setting up compression using flask-compress (#4543) (@mistercrunch)
- [#4549](https://github.com/apache/superset/pull/4549) [bugfix] Fixing regression from #4500 (#4549) (@john-bodley)
- [#4553](https://github.com/apache/superset/pull/4553) [landing] Making Dashboards the first/default tab (#4553) (@john-bodley)
- [#4542](https://github.com/apache/superset/pull/4542) Removing files from MANIFEST.in (#4542) (@mistercrunch)
- [#4533](https://github.com/apache/superset/pull/4533) Merge pull request #4533 from john-bodley/john-bodley-replace-coveralls-with-codecov (@john-bodley)
- [#4530](https://github.com/apache/superset/pull/4530) [presto] Removing patched presto (#4530) (@john-bodley)
- [#4536](https://github.com/apache/superset/pull/4536) [dump.rdb] Removing rouge file (#4536) (@john-bodley)
- [#4541](https://github.com/apache/superset/pull/4541) Add ScopeAI (#4541) (@lucianoiscool)

### 0.23.1 (2018/03/06 06:41 +00:00)
- [#4534](https://github.com/apache/superset/pull/4534) Merge pull request #4534 from john-bodley/john-bodley-setup-url (@john-bodley)

### 0.23.0 (2018/03/06 00:59 +00:00)
- [#4500](https://github.com/apache/superset/pull/4500) Merge pull request #4500 from john-bodley/john-bodley-fix-pr-4396 (@john-bodley)
- [b01a9bb](https://github.com/apache/superset/commit/b01a9bba1f2043435e6fc1b189661e27b7dbbaea) [setup] Fixing URLs
- [#4538](https://github.com/apache/superset/pull/4538) Pass datasource as form_data param (#4538) (@Pek1s)
- [4f7258a](https://github.com/apache/superset/commit/4f7258aacaa5acf37c64769fa18da57f7dbd606e) [coverage] Replacing coveralls with codecov
- [#4513](https://github.com/apache/superset/pull/4513) Superset issue #4512: fixing histogram (#4513) (@ArielStv)
- [#4511](https://github.com/apache/superset/pull/4511) Fix how the annotation layer interpretes the timestamp string without timezone info; use it as UTC (#4511) (@EvelynTurner)
- [#4515](https://github.com/apache/superset/pull/4515) [dashboard] (#4515) (@graceguo-supercat)
- [#4482](https://github.com/apache/superset/pull/4482) chart style options get their own tab (#4482) (@GabeLoins)
- [#4487](https://github.com/apache/superset/pull/4487) Make margin width based on container width instead of slice width (#4487) (@jeffreythewang)
- [7440d34](https://github.com/apache/superset/commit/7440d34936784283f692a39402bcb11a9eeaa6a3) [payload] Fixing regression introducted in ##4396
- [#4486](https://github.com/apache/superset/pull/4486) [Explore] applying refresh chart overlay when chart is stale (#4486) (@GabeLoins)
- [#4480](https://github.com/apache/superset/pull/4480) Add https support for Druid (#4480) (@mistercrunch)
- [#4491](https://github.com/apache/superset/pull/4491) Introduce an onInit method for when a new viz_type is selected (#4491) (@mistercrunch)
- [#4488](https://github.com/apache/superset/pull/4488) fixes to csv - hive upload (#4488) (@timifasubaa)
- [#4469](https://github.com/apache/superset/pull/4469) check for access before requesting access (#4469) (@timifasubaa)
- [#4496](https://github.com/apache/superset/pull/4496) Change limit form 50k to 10k (#4496) (@mistercrunch)
- [#4490](https://github.com/apache/superset/pull/4490) [WiP] Cleanup & fix URL scheme for the explore view (#4490) (@mistercrunch)
- [#4485](https://github.com/apache/superset/pull/4485) [dashboard] Fix JS error when position_json data is empty (#4485) (@graceguo-supercat)
- [#4463](https://github.com/apache/superset/pull/4463) New Landing Page v1.0 (#4463) (@hughhhh)
- [#4459](https://github.com/apache/superset/pull/4459) [Explore] highlighting run query when chart is stale on explore view (#4459) (@GabeLoins)
- [#4467](https://github.com/apache/superset/pull/4467) [geo] add controls for minRadiusPixels and maxRadiusPixels in deck_scatter (#4467) (@mistercrunch)
- [#4477](https://github.com/apache/superset/pull/4477) [flake8] Adding flake8-coding (#4477) (@john-bodley)
- [#4478](https://github.com/apache/superset/pull/4478) add organization (#4478) (@ailurus1991)
- [#4466](https://github.com/apache/superset/pull/4466) [FilterBox] Make filterbox localizable (#4466) (@raffas)
- [#4476](https://github.com/apache/superset/pull/4476) [flake8] Adding future-import check (#4476) (@john-bodley)
- [#4474](https://github.com/apache/superset/pull/4474) [flake8] Fixing additional flake8 issue w/ the presence of ignore (#4474) (@john-bodley)
- [#4475](https://github.com/apache/superset/pull/4475) Pass param of limit for recent activity (#4475) (@hughhhh)
- [#4461](https://github.com/apache/superset/pull/4461) [hotfix] resolve utf-8 encoding issue in db migration (#4461) (@timifasubaa)
- [#4457](https://github.com/apache/superset/pull/4457) [explore] allow URL shortner even if no slice exist (#4457) (@mistercrunch)
- [#4400](https://github.com/apache/superset/pull/4400) Allowing config flag to turn off javascript controls (#4400) (@mistercrunch)
- [#4449](https://github.com/apache/superset/pull/4449) Make instant controls store state in URL (#4449) (@betodealmeida)
- [#4454](https://github.com/apache/superset/pull/4454) Make npm run dev-fast the default (#4454) (@mistercrunch)
- [#4456](https://github.com/apache/superset/pull/4456) [gitignore] Adding venv to .gitignore (#4456) (@GabeLoins)
- [#4444](https://github.com/apache/superset/pull/4444) A collection of bug fixes (#4444) (@mistercrunch)
- [#4455](https://github.com/apache/superset/pull/4455) fixing spacing issue on internationalization dropdown (#4455) (@GabeLoins)
- [#4452](https://github.com/apache/superset/pull/4452) [bugfix] address issue 4206 (#4452) (@mistercrunch)
- [#4446](https://github.com/apache/superset/pull/4446) for 48 columns layout, adjust default size and layout for newly added slices (#4446) (@graceguo-supercat)
- [#4413](https://github.com/apache/superset/pull/4413) Remove comments from queries in SQL Lab that break Explore view (#4413) (@villebro)
- [#4450](https://github.com/apache/superset/pull/4450) fix typo. "グルプ分け可能" => "グループ分け可能" (#4450) (@m4neda)
- [#4447](https://github.com/apache/superset/pull/4447) remove html tag in timeout error message (#4447) (@graceguo-supercat)
- [#4442](https://github.com/apache/superset/pull/4442) Improve default placeholder text on SelectControl (#4442) (@mistercrunch)
- [#4448](https://github.com/apache/superset/pull/4448) Removed double call to ConnectorRegistry.sources (#4448) (@villebro)
- [#4408](https://github.com/apache/superset/pull/4408) Add link on how to get permission to permission error (#4408) (@timifasubaa)
- [#4434](https://github.com/apache/superset/pull/4434) Added Example snippet for setting up Redis cache (#4434) (@hughhhh)
- [#4336](https://github.com/apache/superset/pull/4336) Play scrubber (#4336) (@betodealmeida)
- [#4430](https://github.com/apache/superset/pull/4430) Change current thumbnails to smaller ones. (#4430) (@mistercrunch)
- [#4436](https://github.com/apache/superset/pull/4436) Pass in cache timeout for async queries (#4436) (@jeffreythewang)
- [#4437](https://github.com/apache/superset/pull/4437) Fix separator visualization by propagating header height (#4437) (@jaylindquist)
- [#4438](https://github.com/apache/superset/pull/4438) Make chart title backgrounds transparent to prevent buttonface color in IE (#4438) (@jaylindquist)
- [#4416](https://github.com/apache/superset/pull/4416) [dashboard] more granular grid layout (#4416) (@mistercrunch)
- [#4432](https://github.com/apache/superset/pull/4432) Added check cache key util (#4432) (@hughhhh)
- [#4418](https://github.com/apache/superset/pull/4418) Updated Italian Translation (#4418) (@raffas)
- [#4431](https://github.com/apache/superset/pull/4431) Add .1s option to D3 Format dropdown (#4431) (@raffas)
- [#4405](https://github.com/apache/superset/pull/4405) Disable user access request (#4405) (@timifasubaa)
- [#4427](https://github.com/apache/superset/pull/4427) Bump dependencies with security issues (#4427) (@xrmx)
- [#3993](https://github.com/apache/superset/pull/3993) [Explore view] Use POST method for charting requests (#3993) (@graceguo-supercat)
- [#4410](https://github.com/apache/superset/pull/4410) Unset 'series limit' default from 50 to null (#4410) (@mistercrunch)
- [#4411](https://github.com/apache/superset/pull/4411) use full path in case of there are query params (#4411) (@Chun-LingChen)
- [#4389](https://github.com/apache/superset/pull/4389) [geo] introduce "Auto Zoom" control (#4389) (@mistercrunch)
- [#4401](https://github.com/apache/superset/pull/4401) [SqlLab] Fix a few UI issues (#4401) (@graceguo-supercat)
- [#4404](https://github.com/apache/superset/pull/4404) Check class name string instead of checking the instance (#4404) (@mxmzdlv)
- [#4380](https://github.com/apache/superset/pull/4380) [error handling] 'Time Comparison' query returns no data (#4380) (@mistercrunch)
- [#4383](https://github.com/apache/superset/pull/4383) Typo fix: dashbaord -> dashboard. (#4383) (@xiaohanyu)
- [#4396](https://github.com/apache/superset/pull/4396) Fix markup broken since cache related changes (#4396) (@mistercrunch)
- [#4178](https://github.com/apache/superset/pull/4178) Add PeopleDoc in organizations list who use superset (#4178) (@rodo)
- [#4390](https://github.com/apache/superset/pull/4390) Fix 4 security vulnerabilities (#4390) (@ddworken-sc)
- [#4349](https://github.com/apache/superset/pull/4349) Minor fixes to sunburst (#4349) (@mistercrunch)
- [#4346](https://github.com/apache/superset/pull/4346) Add permission checks to save_or_overwrite_slice (#4346) (@jaylindquist)
- [#4388](https://github.com/apache/superset/pull/4388) Remove permission check for frontend logging API (#4388) (@graceguo-supercat)
- [#4353](https://github.com/apache/superset/pull/4353) Superset issue #4323 (#4353) (@maver1ck)
- [#4377](https://github.com/apache/superset/pull/4377) Bump pydruid to 0.4.1 (#4377) (@mistercrunch)
- [#4359](https://github.com/apache/superset/pull/4359) [revert] Reverting PR #4062 (#4359) (@john-bodley)
- [#4316](https://github.com/apache/superset/pull/4316) Fix caching issues (#4316) (@mistercrunch)
- [#4372](https://github.com/apache/superset/pull/4372) Set default row_limit to 50k (#4372) (@mistercrunch)
- [#4363](https://github.com/apache/superset/pull/4363) [line] improve  feature (#4363) (@mistercrunch)
- [#4373](https://github.com/apache/superset/pull/4373) Remove dangerouslySetInnerHTML in StackTraceMessage component (#4373) (@mistercrunch)
- [#4341](https://github.com/apache/superset/pull/4341) Bump python dependencies (#4341) (@mistercrunch)
- [#4333](https://github.com/apache/superset/pull/4333) Add hour grain to Sqlite (#4333) (@betodealmeida)
- [#4358](https://github.com/apache/superset/pull/4358) [druid] fix bug around handling NULLs (#4358) (@mistercrunch)
- [#4368](https://github.com/apache/superset/pull/4368) Add ipdb to dev dependencies. (#4368) (@xiaohanyu)
- [#4319](https://github.com/apache/superset/pull/4319) convert postgresql date_trunc() to UTC to prevent pandas error (#4319) (@habalux)
- [#4367](https://github.com/apache/superset/pull/4367) Remove useless empty npm-debug.log (#4367) (@xiaohanyu)
- [#4364](https://github.com/apache/superset/pull/4364) New options for european time format in in D3_TIME_FORMAT_OPTIONS (#4364) (@raffas)
- [#4344](https://github.com/apache/superset/pull/4344) Adding dashboard add view (#4344) (@michellethomas)
- [#4345](https://github.com/apache/superset/pull/4345) fix uri form data' (#4345) (@timifasubaa)
- [#4337](https://github.com/apache/superset/pull/4337) read query params for json in dashboard endpoint (#4337) (@hughhhh)
- [#4339](https://github.com/apache/superset/pull/4339) 1. fix check filters change logic (#4339) (@graceguo-supercat)
- [#4338](https://github.com/apache/superset/pull/4338) Fix the bug of charts/slices cannot be filtered by datasource name. (#4338) (@liutgnu)
- [#4298](https://github.com/apache/superset/pull/4298) Refactor import csv (#4298) (@timifasubaa)
- [#3676](https://github.com/apache/superset/pull/3676) [New Viz] Nightingale Rose Chart (#3676) (@Mogball)
- [#4241](https://github.com/apache/superset/pull/4241) [cli] permission cleanup on 'superset init' (#4241) (@mistercrunch)
- [#4224](https://github.com/apache/superset/pull/4224) [BugFix]: Creating a PostgresBaseEngineSpec so changes to the Postgre… (#4224) (@fabianmenges)
- [#4325](https://github.com/apache/superset/pull/4325) Bump pyrdruid to 0.4.0 (#4325) (@mistercrunch)
- [#4326](https://github.com/apache/superset/pull/4326) [explore] fix missing CacheLabel (#4326) (@mistercrunch)
- [#4321](https://github.com/apache/superset/pull/4321) Update installation.rst for Ubuntu 16.04 LTS (#4321) (@raffas)
- [#4322](https://github.com/apache/superset/pull/4322) [Bug] Resize should trigger chart re-render (#4322) (@graceguo-supercat)
- [#4301](https://github.com/apache/superset/pull/4301) [Explore] Fix Stop Query Button behavior (#4301) (@graceguo-supercat)
- [#4293](https://github.com/apache/superset/pull/4293) Refactoring deckgl (#4293) (@betodealmeida)
- [#4226](https://github.com/apache/superset/pull/4226) add frontend logging utility function (#4226) (@graceguo-supercat)
- [#4242](https://github.com/apache/superset/pull/4242) Added Path, Polygon, and Arcs to deckGL example dashboard (#4242) (@hughhhh)
- [#4260](https://github.com/apache/superset/pull/4260) Use the query_obj as the basis for the cache key (#4260) (@mistercrunch)
- [#4299](https://github.com/apache/superset/pull/4299) Bump sqlalchemy to 1.2.2 (#4299) (@xrmx)
- [#4303](https://github.com/apache/superset/pull/4303) Reverts apache/superset#4244 (#4303) (@mistercrunch)
- [#4291](https://github.com/apache/superset/pull/4291) Fixing json decode error on druiddatasourcemodelview/api/read (#4291) (@michellethomas)
- [#4272](https://github.com/apache/superset/pull/4272) [geo] Add JS controls to remaining layers (#4272) (@hughhhh)
- [#4261](https://github.com/apache/superset/pull/4261) Set point size control's default for deck_scatter viz (#4261) (@mistercrunch)
- [#4270](https://github.com/apache/superset/pull/4270) deck_multi to pass down filters to layers (#4270) (@mistercrunch)
- [#4275](https://github.com/apache/superset/pull/4275) Handle 'pd.Timestamp' when jsonifying (#4275) (@mistercrunch)
- [#4276](https://github.com/apache/superset/pull/4276) Prevent FilterBox extra query (#4276) (@mistercrunch)
- [#4277](https://github.com/apache/superset/pull/4277) Fix SUPERSET_WEBSERVER_TIMEOUT in VisualizeModal (#4277) (@mistercrunch)
- [#4262](https://github.com/apache/superset/pull/4262) [geo] JS function to receive the whole data array instead of individual object (#4262) (@mistercrunch)
- [#4265](https://github.com/apache/superset/pull/4265) Fix click on now in DateFilterControl (#4265) (@mistercrunch)
- [#4273](https://github.com/apache/superset/pull/4273) [explore] fix empty query message in 'View Query' (#4273) (@mistercrunch)
- [#4279](https://github.com/apache/superset/pull/4279) Always use fluid container for navbar. (#4279) (@xiaohanyu)
- [#4108](https://github.com/apache/superset/pull/4108) [BUGFIX]: Check datatype of results before converting to DataFrame (#4108) (@marcusianlevine)
- [#4243](https://github.com/apache/superset/pull/4243) Use json for imports and exports, not pickle (#4243) (@timifasubaa)
- [#4251](https://github.com/apache/superset/pull/4251) Using a NullPool for external connections by default (#4251) (@mistercrunch)
- [#4264](https://github.com/apache/superset/pull/4264) Set 'Range Filter' default to false (#4264) (@mistercrunch)
- [#4268](https://github.com/apache/superset/pull/4268) Fix heatmap tooltip disappears under the slice's header (#4268) (@abotero)
- [#4263](https://github.com/apache/superset/pull/4263) Bump flower==0.9.2 (#4263) (@mistercrunch)
- [#4240](https://github.com/apache/superset/pull/4240) [cache] Fixing json.dumps for timestamp (#4240) (@john-bodley)
- [#4246](https://github.com/apache/superset/pull/4246) [Sql Lab] Fix query results display at the bottom of screen (#4246) (@graceguo-supercat)
- [#4244](https://github.com/apache/superset/pull/4244) [Sql Lab] Fix Autorefresh component pulling not stopped. (#4244) (@graceguo-supercat)
- [#4237](https://github.com/apache/superset/pull/4237) Fix 'argument to reversed() must be a sequence' (#4237) (@mistercrunch)
- [#4227](https://github.com/apache/superset/pull/4227) Added DeckGL.Polygon Layer w/ JS controls  (#4227) (@hughhhh)
- [#4235](https://github.com/apache/superset/pull/4235) remove setting spatial in DeckPathViz class (#4235) (@hughhhh)
- [#4229](https://github.com/apache/superset/pull/4229) Don't cache if there's no cache key (#4229) (@michellethomas)
- [#4234](https://github.com/apache/superset/pull/4234) add Ona as a user (#4234) (@pld)
- [#4220](https://github.com/apache/superset/pull/4220) Improve deck.gl GeoJSON visualization (#4220) (@mistercrunch)
- [#4221](https://github.com/apache/superset/pull/4221) [bugfix] time_pivot entry got missing in merge conflict (#4221) (@mistercrunch)
- [#4225](https://github.com/apache/superset/pull/4225) [bugfix] markup and iframe viz raise 'Empty query' (#4225) (@mistercrunch)
- [#4215](https://github.com/apache/superset/pull/4215) Fix tutorial doesn't match the current interface #4138 (#4215) (@zhaoyongjie)
- [#4217](https://github.com/apache/superset/pull/4217) templates: open code and documentation on a new tab (#4217) (@xrmx)
- [#4207](https://github.com/apache/superset/pull/4207) Adding limit to time_table viz to get druid query to work (#4207) (@michellethomas)
- [#4202](https://github.com/apache/superset/pull/4202) [line chart] fix time shift color (#4202) (@mistercrunch)
- [#4016](https://github.com/apache/superset/pull/4016) [cache] Using the query as the basis of the cache key (#4016) (@john-bodley)
- [#4203](https://github.com/apache/superset/pull/4203) [druid] fix 2 phases queries that specify 'Sort By' on 'Series limit' (#4203) (@mistercrunch)
- [#4200](https://github.com/apache/superset/pull/4200) [bugfix] dealing with DBAPIs that return unserilizable types (#4200) (@mistercrunch)
- [#4134](https://github.com/apache/superset/pull/4134) [Geo] Added DeckGL Arc Layer and Refactor on BaseDeckGL class (#4134) (@hughhhh)
- [#4126](https://github.com/apache/superset/pull/4126) Hanization (#4126) (@asdf2014)
- [#4114](https://github.com/apache/superset/pull/4114) Superset was using undefined metrics for specifying limits (#4114) (@bolkedebruin)
- [#4173](https://github.com/apache/superset/pull/4173) Using user-defined Javascript to customize geospatial visualization (#4173) (@mistercrunch)
- [#4183](https://github.com/apache/superset/pull/4183) [datasource editor] click checkbox creates metrics instantly (#4183) (@mistercrunch)
- [#4201](https://github.com/apache/superset/pull/4201) [explore] fix json highlighting for Druid queries (#4201) (@mistercrunch)
- [#4186](https://github.com/apache/superset/pull/4186) Sort out dependencies in travis/tox (#4186) (@mistercrunch)
- [#4184](https://github.com/apache/superset/pull/4184) Enable SQL syntax highlighting in View Query (#4184) (@betodealmeida)
- [#4187](https://github.com/apache/superset/pull/4187) [annotations] Fixing migration for annotation layers (#4187) (@john-bodley)
- [#4176](https://github.com/apache/superset/pull/4176) fix since or until is empty value #4170 (#4176) (@zhaoyongjie)
- [#4182](https://github.com/apache/superset/pull/4182) Moving the custom_password_store out of Database class (#4182) (@fabianmenges)
- [#4180](https://github.com/apache/superset/pull/4180) [security] Adding all derived FAB UserModelView views to admin only (#4180) (@john-bodley)
- [#4101](https://github.com/apache/superset/pull/4101) Don't use fully qualified column names in metric definitions (#4101) (@mistercrunch)
- [#4172](https://github.com/apache/superset/pull/4172) [FAB] configuring updating of permissions (#4172) (@john-bodley)
- [#4164](https://github.com/apache/superset/pull/4164) Allow alpha role import csv (#4164) (@timifasubaa)
- [#4147](https://github.com/apache/superset/pull/4147) Make Welcome page into a simple React app (#4147) (@mistercrunch)
- [#4156](https://github.com/apache/superset/pull/4156) Fix chart rendering error in time series table (#4156) (@graceguo-supercat)
- [#4157](https://github.com/apache/superset/pull/4157) [Bug] Closing change datasource modal throws JS error (#4157) (@graceguo-supercat)
- [#4162](https://github.com/apache/superset/pull/4162) Check for non-None database before using. (#4162) (@atronchi)
- [#4163](https://github.com/apache/superset/pull/4163) Druid support via SQLAlchemy (#4163) (@betodealmeida)
- [#4125](https://github.com/apache/superset/pull/4125) Fix invaild gitter url (#4125) (@asdf2014)
- [#4148](https://github.com/apache/superset/pull/4148) Adding Apache Kylin datasource for documentation (#4148) (@zhaoyongjie)
- [#4143](https://github.com/apache/superset/pull/4143) Create DATA_DIR after importing config (#4143) (@leorochael)
- [#4121](https://github.com/apache/superset/pull/4121) Fix USA's state geojson for 'Country Map' visualization (#4121) (@mistercrunch)
- [#4139](https://github.com/apache/superset/pull/4139) fix variable name (#4139) (@timifasubaa)
- [#4130](https://github.com/apache/superset/pull/4130) Remedy for dual axis annotation (#4130) (@Mogball)
- [#4104](https://github.com/apache/superset/pull/4104) [explore] add datasource metadata (#4104) (@mistercrunch)
- [#4135](https://github.com/apache/superset/pull/4135) better thumbnail for deck_geojson (#4135) (@hughhhh)
- [#4124](https://github.com/apache/superset/pull/4124) Added guard statement for spatial controls (#4124) (@hughhhh)
- [#4096](https://github.com/apache/superset/pull/4096) Multi layers DECK.GL visualization (#4096) (@mistercrunch)
- [#4116](https://github.com/apache/superset/pull/4116) Fix rst grammar problems (#4116) (@asdf2014)
- [#4118](https://github.com/apache/superset/pull/4118) Update UserInfo.jsx and set additional properties for react-gravatar (#4118) (@jpesculis)
- [#4097](https://github.com/apache/superset/pull/4097) [geo] Added DeckGL GeoJson layer (#4097) (@hughhhh)
- [#4076](https://github.com/apache/superset/pull/4076) Introduce Javascript controls (#4076) (@mistercrunch)
- [#4042](https://github.com/apache/superset/pull/4042) [Bugfix] Issues with merge_extra_filters (#4042) (#4091) (@nbonnotte)
- [#3996](https://github.com/apache/superset/pull/3996) [sql lab] deeper support for templating (#3996) (@mistercrunch)
- [#4067](https://github.com/apache/superset/pull/4067) [geo] add support for deck.gl's path layer (#4067) (@mistercrunch)
- [#4090](https://github.com/apache/superset/pull/4090) Using TextAreaControl for WHERE and HAVING clause section (#4090) (@mistercrunch)
- [#4071](https://github.com/apache/superset/pull/4071) Fix for SQL editor throwing can't deserialize google.cloud.bigquery._helpers.Row with BigQuery (#4071) (@kuriancheeramelil)
- [#4089](https://github.com/apache/superset/pull/4089) Bugfix: Druid having filters are broken (#4089) (@fabianmenges)
- [#4083](https://github.com/apache/superset/pull/4083) Event annotation should have min width (#4083) (@fabianmenges)
- [#4082](https://github.com/apache/superset/pull/4082) [bugfix] iframe and markup are broken (#4082) (@mistercrunch)
- [#4072](https://github.com/apache/superset/pull/4072) DB migration of annotation_layers on slice objects and slimming down annotation object. (#4072) (@fabianmenges)
- [#4073](https://github.com/apache/superset/pull/4073) [Bugfix] Issues with table filtering (#4073) (@Mogball)
- [#3530](https://github.com/apache/superset/pull/3530) [Feature] enhanced memoized on get_sqla_engine and other functions (#3530) (@Mogball)
- [#3518](https://github.com/apache/superset/pull/3518) Full Annotation Framework (#3518) (@fabianmenges)
- [#4065](https://github.com/apache/superset/pull/4065) #4058 Fix Oracle timestamps (Oracle "ORA-00907: missing right parenthesis" error) (#4065) (@nichobbs)
- [#4066](https://github.com/apache/superset/pull/4066) [geo] turn off renderTrigger on viewport control (#4066) (@mistercrunch)
- [#4062](https://github.com/apache/superset/pull/4062) [health] Adding DB check to /health (#4062) (@john-bodley)
- [#4059](https://github.com/apache/superset/pull/4059) Adding rowcount label to explore view header (#4059) (@mistercrunch)
- [#4032](https://github.com/apache/superset/pull/4032) [geo] provide more flexible Spatial controls (#4032) (@mistercrunch)
- [#4063](https://github.com/apache/superset/pull/4063) Add db_engine_spec for Druid (#4063) (@mistercrunch)
- [#4048](https://github.com/apache/superset/pull/4048) Bump dev version on trunk (#4048) (@mistercrunch)
- [#4045](https://github.com/apache/superset/pull/4045) Changelog for 0.21.0 (#4045) (@mistercrunch)
- [#4047](https://github.com/apache/superset/pull/4047) Fix the pypi build (#4047) (@mistercrunch)
- [#4049](https://github.com/apache/superset/pull/4049) Change reference for slices to chart (#4049) (@hughhhh)

### 0.22.1
Fixes 0.22.0

### 0.22.0
Bad empty release

### 0.21.2 (2017/12/11 21:18 +00:00)
- [#3974](https://github.com/apache/superset/pull/3974) [Bugfix] `_add_filters_from_pre_query` doesn't handle dim specs (#3974) (@Mogball)
- [#4041](https://github.com/apache/superset/pull/4041) [API] Deprecate /update_role/ API endpoint (#4041) (@john-bodley)
- [#4030](https://github.com/apache/superset/pull/4030) resolve python2 str() issue (#4030) (@timifasubaa)

### 0.21.1
Bad-empty release

### 0.21.0 (2017/12/08 09:11 +00:00)
- [#4031](https://github.com/apache/superset/pull/4031) apply custom css for dashboard initially load (#4031) (@graceguo-supercat)
- [#3891](https://github.com/apache/superset/pull/3891) [BUGFIX]: Fixing dttm_sql_literal to use python_date_format when specified. (#3891) (@fabianmenges)
- [#3947](https://github.com/apache/superset/pull/3947) Add fastdom js dependency (#3947) (@mistercrunch)
- [#4015](https://github.com/apache/superset/pull/4015) Remove unused callbacks when setting state (#4015) (@betodealmeida)
- [#4017](https://github.com/apache/superset/pull/4017) Fixed finding postaggregations (#4017) (@Mogball)
- [#3941](https://github.com/apache/superset/pull/3941) New time_pivot visualization (#3941) (@mistercrunch)
- [#3959](https://github.com/apache/superset/pull/3959) Add type MONEY as numeric type (#3959) (@mistercrunch)
- [#3969](https://github.com/apache/superset/pull/3969) Add row_limit to heatmap controls (#3969) (@mistercrunch)
- [#4019](https://github.com/apache/superset/pull/4019) Add support of another DatabaseError format (#4019) (@dmigo)
- [#3975](https://github.com/apache/superset/pull/3975) asciifying http header for csv download; fixes #3952 (#3975) (@rumbin)
- [#4001](https://github.com/apache/superset/pull/4001) Add has_access to import_dashboard (#4001) (@timifasubaa)
- [#3999](https://github.com/apache/superset/pull/3999) [sql lab] fix position of 'save query' Popover (#3999) (@mistercrunch)
- [#4003](https://github.com/apache/superset/pull/4003) Call props.onChange only when closing filter (#4003) (@betodealmeida)
- [#3978](https://github.com/apache/superset/pull/3978) Adding YAML Import-Export for Datasources to CLI (#3978) (@fabianmenges)
- [#4009](https://github.com/apache/superset/pull/4009) Rollback bulk-delete of table columns (#4009) (@alanmcruickshank)
- [#4000](https://github.com/apache/superset/pull/4000) Add Datasource Name filter under slice list view (#4000) (@graceguo-supercat)
- [#3997](https://github.com/apache/superset/pull/3997) Alternate PR to #3970 (#3997) (@mistercrunch)
- [#3976](https://github.com/apache/superset/pull/3976) [doc] added setting X-Forwarded-Proto to https behind reverse proxy with ssl encryption; fixes #3655 (#3976) (@rumbin)
- [#3991](https://github.com/apache/superset/pull/3991) Create CODE_OF_CONDUCT.md (#3991) (@mistercrunch)
- [#3967](https://github.com/apache/superset/pull/3967) [Dashboard] fix a filter refresh bug and add Test (#3967) (@graceguo-supercat)
- [#3965](https://github.com/apache/superset/pull/3965) [docs] making it clear sqlite shouldn't be used in a cluster (#3965) (@mistercrunch)
- [#3957](https://github.com/apache/superset/pull/3957) [time series table] visual improvements (#3957) (@williaster)
- [#3958](https://github.com/apache/superset/pull/3958) Improving speed of dashboard import (#3958) (@michellethomas)
- [#3949](https://github.com/apache/superset/pull/3949) [Bugfix] Druid `run_query` dimensions part 3 + Unit tests (#3949) (@Mogball)
- [#3946](https://github.com/apache/superset/pull/3946) [country_map] use Albers USA projection (#3946) (@mistercrunch)
- [#3948](https://github.com/apache/superset/pull/3948) fix 'superset db history' (#3948) (@mistercrunch)
- [#3951](https://github.com/apache/superset/pull/3951) Allow underscores in slugs (#3951) (@michellethomas)
- [#3955](https://github.com/apache/superset/pull/3955) config: bring back sqlite default database (#3955) (@xrmx)
- [#3940](https://github.com/apache/superset/pull/3940) Add an "Edit Mode" to Dashboard view (#3940) (@mistercrunch)
- [#3920](https://github.com/apache/superset/pull/3920) Fixed branching condition with dimension spec (#3920) (@Mogball)
- [#3643](https://github.com/apache/superset/pull/3643) Import CSV (#3643) (@timifasubaa)
- [#3945](https://github.com/apache/superset/pull/3945) Fix  call in Chart (#3945) (@mistercrunch)
- [#3933](https://github.com/apache/superset/pull/3933) minor filter select enhancements (#3933) (@kkalyan)
- [#3929](https://github.com/apache/superset/pull/3929) Make Table Columns & Metrics Bulk-deletable (#3929) (@alanmcruickshank)
- [#3922](https://github.com/apache/superset/pull/3922) [travis] Standardizing before_install (#3922) (@john-bodley)
- [#3923](https://github.com/apache/superset/pull/3923) Switched to span instead of textarea for copytoclipboard (#3923) (@Mogball)
- [#3924](https://github.com/apache/superset/pull/3924) Moved percent metrics to its own row (#3924) (@Mogball)
- [#3875](https://github.com/apache/superset/pull/3875) Revert "Filter out unavailable databases (#3875)" (#3918) (@mistercrunch)
- [#3913](https://github.com/apache/superset/pull/3913) [bugfix] remove quotes from Postgres time grains (#3913) (@mistercrunch)
- [#3915](https://github.com/apache/superset/pull/3915) Fix left padding in dashboard widgets (#3915) (@mistercrunch)
- [#3916](https://github.com/apache/superset/pull/3916) [cosmetic] remove border from table viz (#3916) (@mistercrunch)
- [#3912](https://github.com/apache/superset/pull/3912) When checking if you should renderTriggered make sure key exists in controls (#3912) (@michellethomas)
- [#3906](https://github.com/apache/superset/pull/3906) fix the schema-fetching problem for impala in sql_lab (#3906) (@xiaoyugit)
- [#3911](https://github.com/apache/superset/pull/3911) Add UK Metropolitan Districts and Isle of Man (#3911) (@alanmcruickshank)
- [#3904](https://github.com/apache/superset/pull/3904) Bumping webpack related deps (#3904) (@mistercrunch)
- [#3902](https://github.com/apache/superset/pull/3902) [bugfix] allow limiting word cloud (#3902) (@mistercrunch)

### 0.21.0rc2 (2017/11/20 17:18 +00:00)
- [#3903](https://github.com/apache/superset/pull/3903) Fixes default hanlding in Altered slice tag (#3903) (@mistercrunch)
- [#3910](https://github.com/apache/superset/pull/3910) Workaround pandas bug in datetimes with time zones (#3910) (@bolkedebruin)
- [#3583](https://github.com/apache/superset/pull/3583) [3541] Augmenting datasources uniqueness constraints (#3583) (@john-bodley)
- [#3895](https://github.com/apache/superset/pull/3895) [druid] Fixing issue 3894  multi-processing w/ Gunicorn (#3895) (@john-bodley)
- [#3897](https://github.com/apache/superset/pull/3897) [druid] Catch IOError when fetching Druid datasource time boundary (#3897) (@john-bodley)
- [#3899](https://github.com/apache/superset/pull/3899) [druid] Renaming refresh_async method (#3899) (@john-bodley)
- [#3884](https://github.com/apache/superset/pull/3884) Add datasource to the SliceAddView modal (#3884) (#3900) (@alanmcruickshank)
- [#3890](https://github.com/apache/superset/pull/3890) [dashboard bug]Instant control should take effect instantly (#3890) (@graceguo-supercat)
- [#3879](https://github.com/apache/superset/pull/3879) Allow users to specify label->color mapping (#3879) (@mistercrunch)
- [#3893](https://github.com/apache/superset/pull/3893) Only refreshing non instant filters on apply (#3893) (@michellethomas)

### 0.21.0rc1 (2017/11/17 17:33 +00:00)
- [#3896](https://github.com/apache/superset/pull/3896) [druid] Fix datasource column enumeration (#3896) (@john-bodley)
- [#3852](https://github.com/apache/superset/pull/3852) fix input height to match with react-select (#3852) (@graceguo-supercat)
- [#3887](https://github.com/apache/superset/pull/3887) Fixing the build's linting errors (#3887) (@mistercrunch)
- [#3851](https://github.com/apache/superset/pull/3851) A better looking favicon (#3851) (@mistercrunch)
- [#3876](https://github.com/apache/superset/pull/3876) Fix slug function (#3876) (@mistercrunch)
- [#3880](https://github.com/apache/superset/pull/3880) [table] show 'Time' column header instead of '__timestamp' (#3880) (@mistercrunch)
- [#3771](https://github.com/apache/superset/pull/3771) DECKGL integration - Phase 1 (#3771) (@mistercrunch)
- [#3843](https://github.com/apache/superset/pull/3843) Further refactoring around dashboards (#3843) (@mistercrunch)
- [#3877](https://github.com/apache/superset/pull/3877) [dashboard bug] Fix standalone slice (#3877) (@graceguo-supercat)
- [#3872](https://github.com/apache/superset/pull/3872) Add mailing list and move screenshot at the end of README (#3872) (@xrmx)
- [#3875](https://github.com/apache/superset/pull/3875) Filter out unavailable databases (#3875) (@dmigo)

### 0.20.6 (2017/11/15 05:26 +00:00)
- [#3865](https://github.com/apache/superset/pull/3865) [issue] Resolving issue 2530 (#3865) (@john-bodley)
- [#3809](https://github.com/apache/superset/pull/3809) [cache] Fixing cache key w/ merged extra filters (#3809) (@john-bodley)
- [#3869](https://github.com/apache/superset/pull/3869) Fixing an issue with stripping filter values (#3869) (@michellethomas)
- [#3862](https://github.com/apache/superset/pull/3862) [flake8] Updaing CONTRIBUTING.md (#3862) (@john-bodley)
- [#3866](https://github.com/apache/superset/pull/3866) [Dashboard bug] Fix merged filter param name (#3866) (@graceguo-supercat)
- [#3858](https://github.com/apache/superset/pull/3858) Fix cachedDttm prop type (#3858) (@graceguo-supercat)
- [#3847](https://github.com/apache/superset/pull/3847) [flake8] Resolving Q??? errors (#3847) (@john-bodley)
- [#3856](https://github.com/apache/superset/pull/3856) adding support for getting list of foreign tables for PostgreSQL (#3856) (@mike-schiller)
- [#3834](https://github.com/apache/superset/pull/3834) [Dashboard bug] Slice doesn't show loading icon when loading (#3834) (@graceguo-supercat)
- [#3857](https://github.com/apache/superset/pull/3857) [Dashboard bug]Fix userId prop in Explore view Save_Modal (#3857) (@graceguo-supercat)
- [#3850](https://github.com/apache/superset/pull/3850) [sql lab] minor cosmetic touchups on Run / Save buttons (#3850) (@mistercrunch)
- [#3849](https://github.com/apache/superset/pull/3849) [sqllab] fix wrong error msg (#3849) (@mistercrunch)
- [#3842](https://github.com/apache/superset/pull/3842) Add CHANGELOG.md entries for 0.20.0 to 0.20.5 (#3842) (@mistercrunch)
- [#3846](https://github.com/apache/superset/pull/3846) [flake8] Resolving F5?? errors (#3846) (@john-bodley)
- [#3841](https://github.com/apache/superset/pull/3841) [Dashboard bug] should reset chartAlert when start new query (#3841) (@graceguo-supercat)
- [#3510](https://github.com/apache/superset/pull/3510) Update setup.py (#3510) (@joriewong)
- [#3833](https://github.com/apache/superset/pull/3833) [Dashboard bug] Fix Cache status and dttm information display for each slice (#3833) (@graceguo-supercat)
- [#3837](https://github.com/apache/superset/pull/3837) [Dashboard bug] should reset chartAlert when start new query (#3837) (@graceguo-supercat)
- [#3836](https://github.com/apache/superset/pull/3836) run_tests.sh: call coveralls only on CI (#3836) (@xrmx)
- [#3838](https://github.com/apache/superset/pull/3838) [slice] Removing deprecated argument (#3838) (@john-bodley)
- [#3839](https://github.com/apache/superset/pull/3839) [viz] Fix payload force logic (#3839) (@john-bodley)
- [#3668](https://github.com/apache/superset/pull/3668) [Explore] Altered Slice Tag (#3668) (@Mogball)
- [#3813](https://github.com/apache/superset/pull/3813) [docs] add StatsD setup instructions (#3813) (@mistercrunch)
- [#3814](https://github.com/apache/superset/pull/3814) [flake8] Resolving E3?? errors (#3814) (@john-bodley)
- [#3831](https://github.com/apache/superset/pull/3831) Bump celery to 4.1.0 (#3831) (@mistercrunch)
- [#3805](https://github.com/apache/superset/pull/3805) [flake8] Resolve E1?? errors (#3805) (@john-bodley)
- [#3815](https://github.com/apache/superset/pull/3815) [docstring] Refining warm_up_cache comment (#3815) (@john-bodley)
- [#3822](https://github.com/apache/superset/pull/3822) First time fetching chart should not force refresh. (#3822) (@graceguo-supercat)
- [#3740](https://github.com/apache/superset/pull/3740) Basic German Translation (#3740) (@alanmcruickshank)
- [#3816](https://github.com/apache/superset/pull/3816) [flake8] Resolving E7?? errors (#3816) (@john-bodley)
- [#3817](https://github.com/apache/superset/pull/3817) [flake8] Resolving E4?? errors (#3817) (@john-bodley)
- [#3819](https://github.com/apache/superset/pull/3819) Added /healthcheck endpoint for integrations with envoy (#3819) (@hughhhh)
- [#3818](https://github.com/apache/superset/pull/3818) Fix typo in installation.rst (#3818) (@pswaminathan)
- [#3825](https://github.com/apache/superset/pull/3825) Fix misleading SQL Lab timeout error message (#3825) (@mistercrunch)
- [#3823](https://github.com/apache/superset/pull/3823) fix error message format when long query timeout (#3823) (@graceguo-supercat)
- [#3810](https://github.com/apache/superset/pull/3810) Make overflow important to allow scrolling on dashboard (#3810) (@michellethomas)
- [#3811](https://github.com/apache/superset/pull/3811) [flake8] Resolving F4?? errors (#3811) (@john-bodley)
- [#3812](https://github.com/apache/superset/pull/3812) [flake8] Resolving E2?? errors (#3812) (@john-bodley)
- [#3808](https://github.com/apache/superset/pull/3808) Making time table viz scrollable (#3808) (@michellethomas)
- [#3581](https://github.com/apache/superset/pull/3581) Dashboard refactory (#3581) (@graceguo-supercat)
- [#3801](https://github.com/apache/superset/pull/3801) Stamping version to 0.21.0dev (#3801) (@mistercrunch)
- [#3433](https://github.com/apache/superset/pull/3433) Allowing Leading and Trailing spaces in connection (#3433) (@ishpreet-singh)
- [#3796](https://github.com/apache/superset/pull/3796) Fixed single extraction dimension error (#3796) (@Mogball)
- [#3787](https://github.com/apache/superset/pull/3787) [flake8] Resolving C??? errors (#3787) (@john-bodley)
- [#3716](https://github.com/apache/superset/pull/3716) Update messages.json (#3716) (@magicansk)
- [#3784](https://github.com/apache/superset/pull/3784) [flake8] Resolving W??? errors (#3784) (@john-bodley)
- [#3797](https://github.com/apache/superset/pull/3797) [flake8] Resolve I??? errors (#3797) (@john-bodley)
- [#3789](https://github.com/apache/superset/pull/3789) Add Lyft and Twitter to list of companies (#3789) (@mistercrunch)
- [#3794](https://github.com/apache/superset/pull/3794) [time table] use sparkData values in tooltip (#3794) (@williaster)
- [#3793](https://github.com/apache/superset/pull/3793) Adding back iso and correctly filtering iso from contrib total (#3793) (@michellethomas)
- [#3788](https://github.com/apache/superset/pull/3788) Removing iso from data (#3788) (@michellethomas)
- [#3778](https://github.com/apache/superset/pull/3778) [flake8] Resolving F8?? errors (#3778) (@john-bodley)
- [#3785](https://github.com/apache/superset/pull/3785) Rename files to allow RPM build (#3785) (@SpyderRivera)
- [#3783](https://github.com/apache/superset/pull/3783) [falke8] Resolving F6?? errors (#3783) (@john-bodley)
- [#3529](https://github.com/apache/superset/pull/3529) [explore] using verbose_name in 'Time Column' control (#3529) (@mistercrunch)
- [#3654](https://github.com/apache/superset/pull/3654) [Performance] VirtualizedSelect for SelectControl and FilterBox (#3654) (@Mogball)
- [#3697](https://github.com/apache/superset/pull/3697) DI-1113. ADDENDUM. Authentication: Enable user impersonation for Superset to HiveServer2 using hive.server2.proxy.user (a.fernandez) (#3697) (@afernandez)

### 0.20.5 (2017/11/06 07:18 +00:00)
- [#3776](https://github.com/apache/superset/pull/3776) [flake8] Enabling flake8 linting (#3776) (@john-bodley)
- [#3774](https://github.com/apache/superset/pull/3774) [sql-lab] Fixing Run Query tooltip (#3774) (@john-bodley)
- [#3773](https://github.com/apache/superset/pull/3773) Fix dashboard export download (#3773) (@michellethomas)
- [#3767](https://github.com/apache/superset/pull/3767) [time table] add tooltip to sparkline (#3767) (@williaster)
- [#3748](https://github.com/apache/superset/pull/3748) Update to reflect new version of cryptography (#3748) (@SpyderRivera)
- [#3763](https://github.com/apache/superset/pull/3763) docs: reword the FAQ regarding table changes (#3763) (@xrmx)
- [#3764](https://github.com/apache/superset/pull/3764) add stackoverflow tag (#3764) (@dmigo)
- [#3759](https://github.com/apache/superset/pull/3759) Add dummy file to fix symlink (#3759) (@mistercrunch)
- [#3751](https://github.com/apache/superset/pull/3751) fix https://github.com/apache/superset/pull/3726 (#3751) (@graceguo-supercat)
- [#3750](https://github.com/apache/superset/pull/3750) Consolidate all translation config (#3750) (@alanmcruickshank)
- [#3726](https://github.com/apache/superset/pull/3726) Bumping react-select to rc10 (#3726) (@mistercrunch)
- [#3741](https://github.com/apache/superset/pull/3741) Fix has_table method (#3741) (@mxmzdlv)
- [#3736](https://github.com/apache/superset/pull/3736) Escape columns names for time grains - postgres (#3736) (@Ryanthegiantlion)
- [#3739](https://github.com/apache/superset/pull/3739) Fix 3657 (#3739) (@baldoalessandro)
- [#3733](https://github.com/apache/superset/pull/3733) Using indexOf instead of includes for isXAxisString (#3733) (@michellethomas)
- [#3723](https://github.com/apache/superset/pull/3723) bump react-bootstrap version (#3723) (@graceguo-supercat)
- [#3721](https://github.com/apache/superset/pull/3721) Add CRUD action to refresh table metadata (#3721) (@mistercrunch)
- [#3720](https://github.com/apache/superset/pull/3720) Validate JSON in slice's params on save (#3720) (@mistercrunch)
- [#3722](https://github.com/apache/superset/pull/3722) Fix box_plot NaN issue (#3722) (@mistercrunch)
- [#3715](https://github.com/apache/superset/pull/3715) Update messages.po (#3715) (@magicansk)
- [#3686](https://github.com/apache/superset/pull/3686) Missing the data of one province and two regions of China (#3686) (@roganw)
- [#3685](https://github.com/apache/superset/pull/3685) Fix the ISO code description of region/province/department (#3685) (@roganw)
- [#3662](https://github.com/apache/superset/pull/3662) Set logging level to debug for DummyStatsLogger (#3662) (@mistercrunch)
- [#3692](https://github.com/apache/superset/pull/3692) fixes for bugs in #3689 (#3692) (@Mogball)
- [#3703](https://github.com/apache/superset/pull/3703) add VIPKID to the orgs. (#3703) (@killpanda)
- [#3696](https://github.com/apache/superset/pull/3696) changed metric heading from h1 to h3 (#3696) (@Mogball)
- [#3713](https://github.com/apache/superset/pull/3713) [translation] added japanese support (#3713) (@xiaoyugit)
- [#3663](https://github.com/apache/superset/pull/3663) [minor] fix label showing description in time_table's URL (#3663) (@mistercrunch)
- [#3711](https://github.com/apache/superset/pull/3711) fix the slice permission issue after user click-edit new slice title (#3711) (@graceguo-supercat)
- [#3701](https://github.com/apache/superset/pull/3701) [form-data] Quoting form data (#3701) (@john-bodley)
- [#3698](https://github.com/apache/superset/pull/3698) fixing the datasource inconsistence but in visualize flow (#3698) (@graceguo-supercat)
- [#3683](https://github.com/apache/superset/pull/3683) [cleanup] removing print() artefacts (#3683) (@mistercrunch)
- [#3702](https://github.com/apache/superset/pull/3702) Add support for IE 11 for markup slices (#3702) (@jaylindquist)
- [#3693](https://github.com/apache/superset/pull/3693) defaultSort should be false when no sort is necessary (#3693) (@michellethomas)
- [#3586](https://github.com/apache/superset/pull/3586) [Feature] Percentage columns in Table Viz (#3586) (@Mogball)
- [#3652](https://github.com/apache/superset/pull/3652) DI-1113. Authentication: Enable user impersonation for Superset to HiveServer2 using hive.server2.proxy.user (a.fernandez) (#3652) (@afernandez)
- [#3664](https://github.com/apache/superset/pull/3664) [minor] fix padding in Time Table (#3664) (@mistercrunch)
- [#3678](https://github.com/apache/superset/pull/3678) unit tests for OptionDescription component (#3678) (@Mogball)
- [#3679](https://github.com/apache/superset/pull/3679) Avoid dividing by zero for sparkline in time table viz (#3679) (@michellethomas)
- [#3680](https://github.com/apache/superset/pull/3680) Sqllab  error troubleshooting (#3680) (@timifasubaa)
- [#3653](https://github.com/apache/superset/pull/3653) Add a ColorPickerControl (#3653) (@mistercrunch)
- [#3642](https://github.com/apache/superset/pull/3642) [New Viz] Partition Diagram (#3642) (@Mogball)
- [#3665](https://github.com/apache/superset/pull/3665) Add description for running specific test (#3665) (@timifasubaa)
- [#3661](https://github.com/apache/superset/pull/3661) Making the sort order for metrics pull from fd for time table viz (#3661) (@michellethomas)
- [#3417](https://github.com/apache/superset/pull/3417) Make columns that return an exception on click unsortable. (#3417) (@aliavni)
- [#3651](https://github.com/apache/superset/pull/3651) Adding sort time table (#3651) (@michellethomas)
- [#3647](https://github.com/apache/superset/pull/3647) added aihello as superset user. (#3647) (@ganeshkrishnan1)
- [#3646](https://github.com/apache/superset/pull/3646) Fix #3612 - reverse sign in difference calculation (#3646) (@mistercrunch)
- [#3648](https://github.com/apache/superset/pull/3648) Fixing some warnings during tests (#3648) (@dennybiasiolli)

### 0.20.4 (2017/10/12 04:04 +00:00)
- [#3645](https://github.com/apache/superset/pull/3645) [Translations] Restored lost French translations (#3645) (@Mogball)
- [#3644](https://github.com/apache/superset/pull/3644) [sql lab] fix impersonation + template issue (#3644) (@mistercrunch)
- [#3641](https://github.com/apache/superset/pull/3641) Pin moment.js library since 2.19.0 creates problem (#3641) (@mistercrunch)
- [#3600](https://github.com/apache/superset/pull/3600) [time_table] adding support for URLs / links (#3600) (@mistercrunch)
- [#3626](https://github.com/apache/superset/pull/3626) Set tooltip to show extent of sparkData (#3626) (@michellethomas)
- [#3631](https://github.com/apache/superset/pull/3631) add explicit message display for 'Fetching Annotation Layer' error (#3631) (@graceguo-supercat)
- [#3637](https://github.com/apache/superset/pull/3637) [bugfix] Template rendering failed: '_AppCtxGlobals' object has no attribute 'user' (#3637) (@mistercrunch)
- [#3638](https://github.com/apache/superset/pull/3638) fix long title text wrapping in editable-title component (#3638) (@graceguo-supercat)
- [#3625](https://github.com/apache/superset/pull/3625) [minor] proper tooltip on ControlHeader's instant re-render trigger (#3625) (@mistercrunch)
- [#3634](https://github.com/apache/superset/pull/3634) add annotation option and a linear color map for heatmap viz. (#3634) (@xiaoyugit)
- [#3633](https://github.com/apache/superset/pull/3633) [bugfix] empty From date filter NoneType error (#3633) (@mistercrunch)
- [#3621](https://github.com/apache/superset/pull/3621) remove unused imports (#3621) (@xrmx)
- [#3611](https://github.com/apache/superset/pull/3611) fixing date/time filter keys (#3611) (@Mogball)

### 0.20.2 (2017/10/06 07:46 +00:00)
- [#3606](https://github.com/apache/superset/pull/3606) [bugfix] #3593 'Chart Options' panel is missing (#3606) (@mistercrunch)
- [#3601](https://github.com/apache/superset/pull/3601) Removing git artifact (#3601) (@mistercrunch)
- [#3599](https://github.com/apache/superset/pull/3599) [hotfix] fixing issues around new time_table viz (#3599) (@mistercrunch)
- [#3598](https://github.com/apache/superset/pull/3598) [hofix] work around circular deps (#3598) (@mistercrunch)
- [#3597](https://github.com/apache/superset/pull/3597) [time table] fix reversed ratio (#3597) (@mistercrunch)
- [#3508](https://github.com/apache/superset/pull/3508) [Feature/Bugfix] Datepicker and time granularity options to dashboard filters (#3508) (@Mogball)
- [#3596](https://github.com/apache/superset/pull/3596) updating react-alert dependency to v2.3.0 (#3596) (@dennybiasiolli)
- [#3577](https://github.com/apache/superset/pull/3577) [translations] generating missing strings (#3577) (@mistercrunch)
- [#3478](https://github.com/apache/superset/pull/3478) [Bugfix/Feature] Fixed slice render staggering on dashboard first load (#3478) (@Mogball)
- [#3543](https://github.com/apache/superset/pull/3543) New "Time Series - Table" visualization (#3543) (@mistercrunch)
- [#3587](https://github.com/apache/superset/pull/3587) [sql lab] fix numeric sort in data table (#3587) (@mistercrunch)
- [#3594](https://github.com/apache/superset/pull/3594) Fxing bug in label generation for multiple groupbys (#3594) (@fabianmenges)
- [#3591](https://github.com/apache/superset/pull/3591) update immutable.js to v3.8.2 (MIT license) (#3591) (@naoyak)
- [#3571](https://github.com/apache/superset/pull/3571) [Feature] Copy-to-clipboard button in View Query (#3571) (@Mogball)
- [#3585](https://github.com/apache/superset/pull/3585) Allow users to see query string when query returns no data (#3585) (@Mogball)
- [#3582](https://github.com/apache/superset/pull/3582) [Bugfix]: Explore view does not respect custom timeout. (#3582) (@fabianmenges)
- [#3584](https://github.com/apache/superset/pull/3584) Fixed creating new filter options in FilterBox (#3584) (@Mogball)
- [#3562](https://github.com/apache/superset/pull/3562) Added custom pasteSelect to handle paste events (#3562) (@Mogball)
- [#3569](https://github.com/apache/superset/pull/3569) Bumping React to 15.6.2 (MIT license) (#3569) (@mistercrunch)

### 0.20.1 (2017/10/03 07:04 +00:00)
- [#3576](https://github.com/apache/superset/pull/3576) v0.20.1 (#3576) (@mistercrunch)
- [#3572](https://github.com/apache/superset/pull/3572) After saving slice fixing redirect (#3572) (@michellethomas)
- [#3565](https://github.com/apache/superset/pull/3565) Added label+percent and label+value display options to pie chart (#3565) (@Mogball)
- [#3567](https://github.com/apache/superset/pull/3567) Removing yarn warnings during install (#3567) (@dennybiasiolli)
- [#3563](https://github.com/apache/superset/pull/3563) [nvd3] fix single metric showing up in legend (#3563) (@mistercrunch)
- [#3558](https://github.com/apache/superset/pull/3558) Add Pronto Tools to user list (#3558) (@zkan)
- [#3553](https://github.com/apache/superset/pull/3553) Minor documentation fix (#3553) (@gaborhermann)
- [#3545](https://github.com/apache/superset/pull/3545) CHANGELOG for 0.20.0 (#3545) (@mistercrunch)
- [#3534](https://github.com/apache/superset/pull/3534) Explore  update button labels (#3534) (@timifasubaa)
- [#3547](https://github.com/apache/superset/pull/3547) Fixing missing messages.json file (#3547) (@mistercrunch)

### 0.20.0 (2017/09/28 04:26 +00:00)
- [#3528](https://github.com/apache/superset/pull/3528) try to fix problem that chrome window not opening after ajax requrest (#3528) (@graceguo-supercat)
- [#3521](https://github.com/apache/superset/pull/3521) Time Series Annotation Layers (#3521) (@graceguo-supercat)
- [#3526](https://github.com/apache/superset/pull/3526) [explore] fix cached tooltip (#3526) (@mistercrunch)
- [#3544](https://github.com/apache/superset/pull/3544) v0.20.0 (#3544) (@mistercrunch)
- [#3506](https://github.com/apache/superset/pull/3506) setup: bump pandas to 0.20.3 (#3506) (@xrmx)
- [#3066](https://github.com/apache/superset/pull/3066) Add support for column specific fillna to viz (#3066) (@xrmx)
- [#3537](https://github.com/apache/superset/pull/3537) docs: QUERY_TIMEOUT_THRESHOLD is gone (#3537) (@xrmx)
- [#3531](https://github.com/apache/superset/pull/3531) [style] no bold on dashboard widget headers (#3531) (@mistercrunch)
- [#3532](https://github.com/apache/superset/pull/3532) Break word on InfoTooltip (#3532) (@michellethomas)
- [#3473](https://github.com/apache/superset/pull/3473) Feature: Paired t-test table visualization (#3473) (@Mogball)
- [#3513](https://github.com/apache/superset/pull/3513) Feature: query string API endpoint (#3513) (@Mogball)
- [#3504](https://github.com/apache/superset/pull/3504) Feature: Display the verbose name for metrics within Charts and legend. (#3504) (@fabianmenges)
- [#3527](https://github.com/apache/superset/pull/3527) Druid refresh metadata performance improvements (#3527) (@Mogball)
- [#3466](https://github.com/apache/superset/pull/3466) Allow user update slice title in visualize flow (#3466) (@graceguo-supercat)
- [#3467](https://github.com/apache/superset/pull/3467) allow user update slice name in dashboard view (#3467) (@graceguo-supercat)
- [#3509](https://github.com/apache/superset/pull/3509) Add Table performance improvements (#3509) (@Mogball)
- [#3499](https://github.com/apache/superset/pull/3499) Add metric warning (#3499) (@michellethomas)
- [#3390](https://github.com/apache/superset/pull/3390) js translation -- performance improvment (#3390) (@graceguo-supercat)
- [#3491](https://github.com/apache/superset/pull/3491) Remove repeated line (#3491) (@timifasubaa)
- [#3497](https://github.com/apache/superset/pull/3497) Fix idna requirement (#3497) (@timifasubaa)
- [#3495](https://github.com/apache/superset/pull/3495) update contributing.md (#3495) (@timifasubaa)
- [#3500](https://github.com/apache/superset/pull/3500) Removing super() call from refactor (#3500) (@mistercrunch)
- [#3493](https://github.com/apache/superset/pull/3493) Adding missing future imports (#3493) (@mistercrunch)
- [#3494](https://github.com/apache/superset/pull/3494) Removing dependency on pythrifthiveapi (#3494) (@mistercrunch)
- [#3474](https://github.com/apache/superset/pull/3474) [heatmap] account for bounds = 0 (#3474) (@mistercrunch)
- [#3480](https://github.com/apache/superset/pull/3480) Improve code quality (#3480) (@timifasubaa)
- [#3434](https://github.com/apache/superset/pull/3434) Feature/Fix: Get a full times_series for your filter instead of Topn for each point in time (#3434) (@fabianmenges)
- [#3486](https://github.com/apache/superset/pull/3486) Getting datatype with its dialect (#3486) (@datinho)
- [#3404](https://github.com/apache/superset/pull/3404) Feature: "Impersonate user" setting on Datasource (#3404) (@dmigo)
- [#3484](https://github.com/apache/superset/pull/3484) Create CsvResponse to manage csv exports encoding (#3484) (@JulieRossi)
- [#3469](https://github.com/apache/superset/pull/3469) Better installation docs (#3469) (@mistercrunch)
- [#3475](https://github.com/apache/superset/pull/3475) viz: fix reversed stats_logger label (#3475) (@xrmx)
- [#3477](https://github.com/apache/superset/pull/3477) docs: athena can be installed from pypi (#3477) (@xrmx)
- [#3476](https://github.com/apache/superset/pull/3476) Miscvizcleanups (#3476) (@xrmx)
- [#3435](https://github.com/apache/superset/pull/3435) Adding hook for CSRF exempting flask views. (#3435) (@fabianmenges)
- [#3409](https://github.com/apache/superset/pull/3409) bugfix/3321 Ensure text appears on buttons inside tables (#3409) (@jeffcarey)
- [#3415](https://github.com/apache/superset/pull/3415) Simple grammar and update to link (#3415) (@SpyderRivera)
- [#3441](https://github.com/apache/superset/pull/3441) config: allow changing default options for writting csv (#3441) (@JulieRossi)
- [#3425](https://github.com/apache/superset/pull/3425) Add shopee to user list. (#3425) (@xiaohanyu)
- [#3458](https://github.com/apache/superset/pull/3458) Fixed filter removal bug (#3458) (@Mogball)
- [#3424](https://github.com/apache/superset/pull/3424) fix encoding error in sql lab logging (#3424) (@graceguo-supercat)
- [#3459](https://github.com/apache/superset/pull/3459) Sqllab  dont send empty queries to db (#3459) (@timifasubaa)
- [#3461](https://github.com/apache/superset/pull/3461) Fixed dashboard filters carrying over to explore slice (#3461) (@Mogball)
- [#3436](https://github.com/apache/superset/pull/3436) Adding hook for external password store for databases (#3436) (@fabianmenges)
- [#3460](https://github.com/apache/superset/pull/3460) Allow specifying sort criteria on Table viz (#3460) (@mistercrunch)
- [#3456](https://github.com/apache/superset/pull/3456) [heatmap] numerous improvements (#3456) (@mistercrunch)
- [#3431](https://github.com/apache/superset/pull/3431) fix https://github.com/apache/superset/issues/3430 (#3431) (@graceguo-supercat)
- [#3440](https://github.com/apache/superset/pull/3440) fix https://github.com/apache/superset/issues/3422 (#3440) (@graceguo-supercat)
- [#3439](https://github.com/apache/superset/pull/3439) Adding order_desc flag to explore endpoint (#3439) (@fabianmenges)
- [#2937](https://github.com/apache/superset/pull/2937) Handling pandas ExtensionDtypes (#2937) (@fabianmenges)
- [#3444](https://github.com/apache/superset/pull/3444) [postgres] adding support to serialized timedelta (#3444) (@mistercrunch)
- [#3453](https://github.com/apache/superset/pull/3453) [explore] show validation error on control panel header (#3453) (@mistercrunch)
- [#3450](https://github.com/apache/superset/pull/3450) [heatmap] fix default sorting (#3450) (@mistercrunch)
- [#3452](https://github.com/apache/superset/pull/3452) Fix off-by-one error with linear color scales (#3452) (@mistercrunch)
- [#3454](https://github.com/apache/superset/pull/3454) [explore] checkbox control won't uncheck (#3454) (@mistercrunch)
- [#3446](https://github.com/apache/superset/pull/3446) Ignore intellij files (#3446) (@fabianmenges)
- [#3445](https://github.com/apache/superset/pull/3445) Fixing the build (#3445) (@mistercrunch)
- [#3405](https://github.com/apache/superset/pull/3405) setup: Bump sqlalchemy-utils to 0.32.16 (#3405) (@xrmx)
- [#3403](https://github.com/apache/superset/pull/3403) [hotfix] user dashboard says '150 weeks' (#3403) (@mistercrunch)
- [#3401](https://github.com/apache/superset/pull/3401) [hotfix] fix slices where since/until = None (#3401) (@mistercrunch)
- [#3391](https://github.com/apache/superset/pull/3391) [dashboard] adding an option to duplicate slices when "Saving AS" (#3391) (@mistercrunch)
- [#3399](https://github.com/apache/superset/pull/3399) Fix copypasta control label error 'Until' -> 'Since' (#3399) (@mistercrunch)
- [#3397](https://github.com/apache/superset/pull/3397) [line chart] add 'min_periods' control related to rolling windows (#3397) (@mistercrunch)
- [#3394](https://github.com/apache/superset/pull/3394) [hive] fix date casting in explore view (#3394) (@mistercrunch)
- [#3396](https://github.com/apache/superset/pull/3396) [hotfix] backward compatibility on date expressions (#3396) (@mistercrunch)
- [#3395](https://github.com/apache/superset/pull/3395) Add Capital Service to organizations list (#3395) (@pkonarzewski)
- [#3377](https://github.com/apache/superset/pull/3377) Fix datatable scroll height when using filter or pagination (#3377) (@mxmzdlv)
- [#3392](https://github.com/apache/superset/pull/3392) fix date picker Select alignment (#3392) (@graceguo-supercat)
- [#3378](https://github.com/apache/superset/pull/3378) Build optimizations (#3378) (@mistercrunch)
- [#3379](https://github.com/apache/superset/pull/3379) [dashboard] load list of slices at modal enter time (#3379) (@mistercrunch)
- [#3371](https://github.com/apache/superset/pull/3371) [explore] Improved time filters controls (#3371) (@mistercrunch)
- [#3363](https://github.com/apache/superset/pull/3363) [sql lab] using react-split-pane (#3363) (@mistercrunch)

### 0.19.1 (2017/08/26 22:07 +00:00)
- [#3376](https://github.com/apache/superset/pull/3376) v1.9.1 (#3376) (@mistercrunch)
- [#3373](https://github.com/apache/superset/pull/3373) Apply advanced analytics processing to comparison time series (#3373) (@mxmzdlv)
- [#3362](https://github.com/apache/superset/pull/3362) [webpack] add a 'npm run dev-fast' command that is much faster (#3362) (@mistercrunch)
- [#3366](https://github.com/apache/superset/pull/3366) bugfix for addTotalValues with negative values (#3366) (@hajdbo)
- [#3339](https://github.com/apache/superset/pull/3339) [explore] Fix and test slice id  logging  issue (#3339) (@timifasubaa)
- [#3364](https://github.com/apache/superset/pull/3364) Bump fab to 1.9.4 (#3364) (@mistercrunch)
- [#3242](https://github.com/apache/superset/pull/3242) Revert "[sql lab] Make sql editor resizable (#3242)" (#3360) (@mistercrunch)
- [#3357](https://github.com/apache/superset/pull/3357) [dist_bar] break down control groups (#3357) (@mistercrunch)
- [#3356](https://github.com/apache/superset/pull/3356) delete unused csv file (#3356) (@timifasubaa)
- [#3358](https://github.com/apache/superset/pull/3358) [hotfix] react-select dropdown autocomplete are invisible (#3358) (@mistercrunch)
- [#3354](https://github.com/apache/superset/pull/3354) Collapsible Control sections (#3354) (@mistercrunch)
- [#3353](https://github.com/apache/superset/pull/3353) [bugfix] `Y bounds` in line chart (#3353) (@mistercrunch)
- [#3351](https://github.com/apache/superset/pull/3351) [css] react-select only in theme (#3351) (@mistercrunch)
- [#3352](https://github.com/apache/superset/pull/3352) fix multi-value react select style (#3352) (@graceguo-supercat)
- [#3345](https://github.com/apache/superset/pull/3345) Better looking checkboxes (#3345) (@mistercrunch)
- [#3338](https://github.com/apache/superset/pull/3338) [hotfix] self-immune filter_box fix (#3338) (@mistercrunch)
- [#3242](https://github.com/apache/superset/pull/3242) [sql lab] Make sql editor resizable (#3242) (@dmigo)
- [#3308](https://github.com/apache/superset/pull/3308) [sql lab] improve error messages (#3308) (@mistercrunch)
- [#3329](https://github.com/apache/superset/pull/3329) Syncing the timeout param from backend (#3329) (@mistercrunch)
- [#3335](https://github.com/apache/superset/pull/3335) [dashboard] re-enabling cascading filters (#3335) (@mistercrunch)
- [#3332](https://github.com/apache/superset/pull/3332) [nvd3] fix bubble axis (#3332) (@mistercrunch)
- [#3333](https://github.com/apache/superset/pull/3333) [hotfix] hotfixing the hotfix (#3333) (@mistercrunch)
- [#3331](https://github.com/apache/superset/pull/3331) Unnecessary to specify order_columns for DatasourceModelView (#3331) (@RoganW)
- [#3328](https://github.com/apache/superset/pull/3328) disable immediately re-render for color scheme change (#3328) (@graceguo-supercat)
- [#3330](https://github.com/apache/superset/pull/3330) [hotfix] dashboard widget resize is broken (#3330) (@mistercrunch)
- [#3322](https://github.com/apache/superset/pull/3322) docs: add references to Flask-Appbuilder Security documentation (#3322) (@xrmx)
- [#3315](https://github.com/apache/superset/pull/3315) Use react-alert for backend message flashing (#3315) (@mistercrunch)
- [#3295](https://github.com/apache/superset/pull/3295) Allow for multiple color schemes (#3295) (@graceguo-supercat)
- [#3313](https://github.com/apache/superset/pull/3313) French translation (#3313) (@invenis-paris)
- [#3305](https://github.com/apache/superset/pull/3305) [hive] improve error messages (#3305) (@mistercrunch)
- [#3309](https://github.com/apache/superset/pull/3309) Fix styles in Separator widget (#3309) (@mistercrunch)
- [#3310](https://github.com/apache/superset/pull/3310) [sql lab] run button shortcut tooltip (#3310) (@mistercrunch)
- [#3291](https://github.com/apache/superset/pull/3291) [bugfix] Presto KeyError 'errorLocation' (#3291) (@mistercrunch)
- [#3292](https://github.com/apache/superset/pull/3292) [sql lab] add pending to the list of searchable statuses (#3292) (@mistercrunch)
- [#3293](https://github.com/apache/superset/pull/3293) [mapbox] fix viewport alterations (#3293) (@mistercrunch)
- [#3298](https://github.com/apache/superset/pull/3298) Fix raise error when query datasource (#3298) (@RoganW)
- [#3296](https://github.com/apache/superset/pull/3296) [docs] document how to compile/publish docs (#3296) (@mistercrunch)
- [#3280](https://github.com/apache/superset/pull/3280) [dashboard] add link to export CSV from dashboard (#3280) (@mistercrunch)
- [#3282](https://github.com/apache/superset/pull/3282) FAQ entry for backend support (#3282) (@mistercrunch)
- [#3286](https://github.com/apache/superset/pull/3286) [sql lab] fix sluggish backspace in editor (#3286) (@mistercrunch)
- [#3287](https://github.com/apache/superset/pull/3287) Fix Chart Error Message Display (#3287) (@graceguo-supercat)
- [#3284](https://github.com/apache/superset/pull/3284) [dashboard] fix standalone mode that hides the navbar (#3284) (@mistercrunch)
- [#3031](https://github.com/apache/superset/pull/3031) Improve superset list view content layout (#3031) (@graceguo-supercat)
- [#3281](https://github.com/apache/superset/pull/3281) [markup] fix CSS, remove scrollbar (#3281) (@mistercrunch)
- [#2033](https://github.com/apache/superset/pull/2033) Fix returned time parse_human_datetime (#2033) (@0x0ece)
- [#3032](https://github.com/apache/superset/pull/3032) Add translatable columns in label_columns of the view (#3032) (@RoganW)
- [#3211](https://github.com/apache/superset/pull/3211) [security] prevent XSS markup viz (#3211) (@mistercrunch)
- [#3034](https://github.com/apache/superset/pull/3034) add `_()` to Exception messages (#3034) (@RoganW)
- [#3275](https://github.com/apache/superset/pull/3275) display the verbose_name of columns in list view, just like in the metrics list (#3275) (@RoganW)
- [#3274](https://github.com/apache/superset/pull/3274) add placeholder to Select components (#3274) (@RoganW)
- [#3277](https://github.com/apache/superset/pull/3277) Added Konfio to 'Who uses Superset' list. (#3277) (@luis-rodriguez)
- [#3278](https://github.com/apache/superset/pull/3278) Fix celery worker (#3278) (@saguziel)
- [#3183](https://github.com/apache/superset/pull/3183) [add] Save filters to dashboard (#3183) (@RoganW)
- [#3110](https://github.com/apache/superset/pull/3110) Explore view save modal spec (#3110) (@graceguo-supercat)
- [#3279](https://github.com/apache/superset/pull/3279) [explore] fixed padding bug on filter section (#3279) (@timifasubaa)
- [#3088](https://github.com/apache/superset/pull/3088) [explore] Split large reducer logic in ExploreViewContainer (#3088) (@graceguo-supercat)
- [#3267](https://github.com/apache/superset/pull/3267) Use sane Celery defaults to prevent tasks from being delayed (#3267) (@saguziel)
- [#3268](https://github.com/apache/superset/pull/3268) [bugfix] preserve order in groupby (#3268) (@mistercrunch)
- [#3266](https://github.com/apache/superset/pull/3266) Set default ports Druid (#3266) (@Fokko)
- [#3262](https://github.com/apache/superset/pull/3262) [webpack] break CSS and JS files while webpackin' (#3262) (@mistercrunch)
- [#3241](https://github.com/apache/superset/pull/3241) Improve the chart type of Visualize in sqllab (#3241) (@eeve)
- [#3256](https://github.com/apache/superset/pull/3256) Modernize SQLA pessimistic handling (#3256) (@mistercrunch)
- [#3252](https://github.com/apache/superset/pull/3252) Explicitly add Flask as dependancy (#3252) (@Fokko)
- [#3261](https://github.com/apache/superset/pull/3261) Relying on FAB for font-awesome.min.css (#3261) (@mistercrunch)
- [#3264](https://github.com/apache/superset/pull/3264) import logging (#3264) (@cclauss)
- [#3244](https://github.com/apache/superset/pull/3244) [explore] make edit datasource a basic link (#3244) (@mistercrunch)
- [#3254](https://github.com/apache/superset/pull/3254) [bugfix] wrong 'Cant have overlap between Series and Breakdowns' (#3254) (@mistercrunch)
- [#3249](https://github.com/apache/superset/pull/3249) Fix Yahoo's website link (#3249) (@pedro-valentim)
- [#3246](https://github.com/apache/superset/pull/3246) Fix typo (#3246) (@zeeshanu)
- [#3235](https://github.com/apache/superset/pull/3235) docs: use yarn in making your own build (#3235) (@xrmx)
- [#3067](https://github.com/apache/superset/pull/3067) explore: redraw chart on width change too (#3067) (@xrmx)
- [#3225](https://github.com/apache/superset/pull/3225) Add basic Impala engine spec (#3225) (@mistercrunch)
- [#3237](https://github.com/apache/superset/pull/3237) Treemap vis verbose metric name (#3237) (@RichRadics)
- [#3240](https://github.com/apache/superset/pull/3240) [bug fix] Fix to #3137 and #3239 (#3240) (@FrederichCheng)
- [#3238](https://github.com/apache/superset/pull/3238) SUPERSET_HOME enviroment variable (#3238) (@RichRadics)
- [#3236](https://github.com/apache/superset/pull/3236) Handle Time at query_obj generation time (#3236) (@mistercrunch)
- [#3230](https://github.com/apache/superset/pull/3230) [pivot] add support for  in Pivot on Druid (#3230) (@mistercrunch)
- [#3229](https://github.com/apache/superset/pull/3229) Allowing to integrate time as a groupby value (#3229) (@mistercrunch)
- [#3227](https://github.com/apache/superset/pull/3227) 0.19.0 (#3227) (@mistercrunch)
- [#2974](https://github.com/apache/superset/pull/2974) Allow 'refresh_immune_slices' (#2974) (@RichRadics)
- [#3111](https://github.com/apache/superset/pull/3111) sql_lab: re-raise exception in get_sql_results (#3111) (@xrmx)

### 0.19.0 (2017/08/02 05:16 +00:00)
- [#3210](https://github.com/apache/superset/pull/3210) [explore] DatasourceControl to pick datasource in modal (#3210) (@mistercrunch)
- [#3214](https://github.com/apache/superset/pull/3214) [sqllab] fix UI shows 'The query returned no results' momentarily (#3214) (@mistercrunch)
- [#3197](https://github.com/apache/superset/pull/3197) [explore] nvd3 sort values in rich tooltip (#3197) (@mistercrunch)
- [#3222](https://github.com/apache/superset/pull/3222) [sqllab/cosmetics] add margin-top for labels in query history (#3222) (@mistercrunch)
- [#3212](https://github.com/apache/superset/pull/3212) [docs] update url in CONTRIBUTING.md (#3212) (@diggzhang)
- [#3213](https://github.com/apache/superset/pull/3213) [bugfix] capture Hive job_id pre-url transformation (#3213) (@mistercrunch)
- [#3205](https://github.com/apache/superset/pull/3205) fix issue 3204 (#3205) (@diggzhang)
- [#3203](https://github.com/apache/superset/pull/3203) Speed up JS build time (#3203) (@mistercrunch)
- [#2929](https://github.com/apache/superset/pull/2929) Autofocus search input in VizTypeControl modal onEnter (#2929) (@pariser)
- [#3086](https://github.com/apache/superset/pull/3086) add combine config for metrics in pivot table (#3086) (@RoganW)
- [#3146](https://github.com/apache/superset/pull/3146) [druid] Allow custom druid postaggregators (#3146) (@brianwolfe)
- [#3194](https://github.com/apache/superset/pull/3194) Adding 'apache' to docs (#3194) (@mistercrunch)
- [#3196](https://github.com/apache/superset/pull/3196) [bugfix] fix merge conflict that broke Hive support (#3196) (@mistercrunch)
- [#3193](https://github.com/apache/superset/pull/3193) Add BigQuery engine specifications (#3193) (@mistercrunch)
- [#3187](https://github.com/apache/superset/pull/3187) [sqllab] improve Hive support (#3187) (@mistercrunch)
- [#3186](https://github.com/apache/superset/pull/3186) Escaping the user's SQL in the explore view (#3186) (@mistercrunch)
- [#3065](https://github.com/apache/superset/pull/3065) Bump cryptography to 1.9 (#3065) (@xrmx)
- [#3174](https://github.com/apache/superset/pull/3174) Fix the segment interval for pulling metadata (#3174) (@Fokko)
- [#3181](https://github.com/apache/superset/pull/3181) [bugfix] visualize flow error: 'Metric x is not valid' (#3181) (@mistercrunch)
- [#3180](https://github.com/apache/superset/pull/3180) [bugfix] fix bar order (#3180) (@mistercrunch)
- [#3169](https://github.com/apache/superset/pull/3169) docs: fixup installation examples code indentation (#3169) (@xrmx)
- [#3171](https://github.com/apache/superset/pull/3171) add Zalando to the list of organizations (#3171) (@dmigo)
- [#2968](https://github.com/apache/superset/pull/2968) fix hive.fetch_logs (#2968) (@timfeirg)
- [#3036](https://github.com/apache/superset/pull/3036) [bugfix] numeric value for date fields in table viz (#3036) (@mistercrunch)
- [#3101](https://github.com/apache/superset/pull/3101) Add 'show/hide totals' option to pivot table vis (#3101) (@RichRadics)
- [#3045](https://github.com/apache/superset/pull/3045) add title description to model view (#3045) (@RoganW)
- [#3035](https://github.com/apache/superset/pull/3035) Datasource cannot be empty (#3035) (@RoganW)
- [#3105](https://github.com/apache/superset/pull/3105) [bugfix] only filterable columns should show up in FilterBox list (#3105) (@mistercrunch)
- [#3179](https://github.com/apache/superset/pull/3179) Fixing the damn build (#3179) (@mistercrunch)
- [#3102](https://github.com/apache/superset/pull/3102) Add event-flow visualization (#3102) (@williaster)
- [#3163](https://github.com/apache/superset/pull/3163) Prevent people from deleting datasources that have associate slices (#3163) (@mistercrunch)
- [#3164](https://github.com/apache/superset/pull/3164) More logging to csv endpoint (#3164) (@mistercrunch)
- [#3159](https://github.com/apache/superset/pull/3159) [bugfix] SQLA instance has been deleted (#3159) (@mistercrunch)
- [#3157](https://github.com/apache/superset/pull/3157) add douban to the orgs. (#3157) (@luchuan)
- [#3150](https://github.com/apache/superset/pull/3150) [docs] use yarn in CONTRIBUTING.md (#3150) (@mistercrunch)
- [#3155](https://github.com/apache/superset/pull/3155) [bugfix]  fails on None view_menu (#3155) (@mistercrunch)
- [#3112](https://github.com/apache/superset/pull/3112) allow user press Enter key to end editing title (#3112) (@graceguo-supercat)
- [#3116](https://github.com/apache/superset/pull/3116) [minor] change tooltip on 'Edit slice properties' (#3116) (@mistercrunch)
- [#3133](https://github.com/apache/superset/pull/3133) Prevent SQLA warning related to SQLALCHEMY_TRACK_MODIFICATION (#3133) (@mistercrunch)
- [#3138](https://github.com/apache/superset/pull/3138) [#3137] Use state.datasource.type instead of state.datasource_type when rendering ControlPanelsContainer (#3138) (@FrederichCheng)
- [#3119](https://github.com/apache/superset/pull/3119) [heatmap] basic non empty validation (#3119) (@mistercrunch)
- [#3135](https://github.com/apache/superset/pull/3135) Fixes #3134 by correct response content-type of /testconn (#3135) (@shawnzhu)
- [#3126](https://github.com/apache/superset/pull/3126) [Celery] fix the celery worker concurrency settings (#3126) (@dingguitao)
- [#3118](https://github.com/apache/superset/pull/3118) [CLI] Improve the missing perm creation logic (#3118) (@mistercrunch)
- [#3120](https://github.com/apache/superset/pull/3120) Using yarn instead of npm install (#3120) (@mistercrunch)
- [#3044](https://github.com/apache/superset/pull/3044) clarify Superset different timeout config (#3044) (@graceguo-supercat)
- [3d136aa](https://github.com/apache/superset/commit/3d136aa0a4d3c6ebb26821e1b308b6eff4c2fd8f) Update docs links on README (@mistercrunch)
- [#3042](https://github.com/apache/superset/pull/3042) fix default checkbox alignment (#3042) (@graceguo-supercat)
- [#3013](https://github.com/apache/superset/pull/3013) New chart type : Chord Diagrams (#3013) (@mistercrunch)
- [#3041](https://github.com/apache/superset/pull/3041) [bugfix] issue creating separators & markup slices (#3041) (@mistercrunch)
- [#3011](https://github.com/apache/superset/pull/3011) Bug fix: Datasource -> Slice relationship (#3011) (@fabianmenges)

### 0.18.5 (2017/06/22 22:46 +00:00)
- [fdbb569](https://github.com/apache/superset/commit/fdbb569c3e2842fdfc80e0418f5817593e5c64fb) 0.18.5 (@mistercrunch)
- [cc3e63f](https://github.com/apache/superset/commit/cc3e63f1de0a6e5c2fd68464297620ac878fe2a0) [docs] adding info on how to create new viz (@mistercrunch)
- [#3022](https://github.com/apache/superset/pull/3022) add test coverage for sql lab components (#3022) (@graceguo-supercat)
- [6eba6ca](https://github.com/apache/superset/commit/6eba6cac0b49a06172ba3dc817eb7aeef7cd310c) [hotfix] xAxis broken on time series viz (@mistercrunch)
- [bd706eb](https://github.com/apache/superset/commit/bd706ebbd17e6d147962df5f20dabdf3af3a6730) Fixing image sizes for horizon and country_map (@mistercrunch)
- [abbf138](https://github.com/apache/superset/commit/abbf138cfb6149277cbbfd1b38aa65a1e0170f3c) Bumping SQLLAB_ASYNC_TIME_LIMIT_SEC default config to 6 hours (@mistercrunch)
- [#3021](https://github.com/apache/superset/pull/3021) CONTRIBUTING: add python unittes setup (#3021) (@graceguo-supercat)
- [#3014](https://github.com/apache/superset/pull/3014) A set of minor fixes (#3014) (@mistercrunch)
- [5344a80](https://github.com/apache/superset/commit/5344a805359fe6b72bcc7a4298b22f0dfb0cccfa) Bumping flask-appbuilder to 1.9.1 (@mistercrunch)
- [0b09a74](https://github.com/apache/superset/commit/0b09a74d37874f9c6aa101c9566257873a6e41a0) Downgrading celery to 3.1.25 (@mistercrunch)
- [#3017](https://github.com/apache/superset/pull/3017) CONTRIBUTING: ask to quote python stacktraces (#3017) (@xrmx)
- [#3009](https://github.com/apache/superset/pull/3009) [bugfix] fix metrics/metric control default (#3009) (@mistercrunch)
- [53dead9](https://github.com/apache/superset/commit/53dead9c2983ca9e3f940354e1fecb3d85f62b2b) Revert "Bumping FAB to 1.9.1" (@mistercrunch)
- [f64e2ba](https://github.com/apache/superset/commit/f64e2ba7d52c442461b59ee1230476eae6b9ff22) Bumping FAB to 1.9.1 (@mistercrunch)
- [#3012](https://github.com/apache/superset/pull/3012) Revert change in npm run build command (#3012) (@yolken)
- [#3008](https://github.com/apache/superset/pull/3008) Adding missing dependency and linting webpack.js (#3008) (@mistercrunch)
- [#2981](https://github.com/apache/superset/pull/2981) Stabilizing Celery / SQL Lab (#2981) (@mistercrunch)
- [#2994](https://github.com/apache/superset/pull/2994) Misc. tweaks to improve webpack performance (#2994) (@yolken)
- [#2990](https://github.com/apache/superset/pull/2990) translations extracted by pybabel (#2990) (@RoganW)
- [#2983](https://github.com/apache/superset/pull/2983) Fix importing config from env var (#2983) (@andrewmchen)
- [#2988](https://github.com/apache/superset/pull/2988) Improving TextAreaControl to support code and modal (#2988) (@mistercrunch)
- [#2957](https://github.com/apache/superset/pull/2957) [pivot viz] fix formatting and verbose names (#2957) (@mistercrunch)
- [#2927](https://github.com/apache/superset/pull/2927) [explore] improve bubble viz (#2927) (@mistercrunch)
- [#2984](https://github.com/apache/superset/pull/2984) add test coverage for SqlEditorLeftBar (#2984) (@graceguo-supercat)
- [#2985](https://github.com/apache/superset/pull/2985) fix is_owner check (#2985) (@graceguo-supercat)
- [#2970](https://github.com/apache/superset/pull/2970) [FilterBox] use column verbose names (#2970) (@mistercrunch)
- [1ce3b81](https://github.com/apache/superset/commit/1ce3b81d01e1453fb34469fa6ba66f9b7d09bcb2) Imporving the README (@mistercrunch)
- [#2978](https://github.com/apache/superset/pull/2978) [bufix] superset views not getting from_dttm-to_dttm in template context (#2978) (@mistercrunch)
- [#2963](https://github.com/apache/superset/pull/2963) [CLI] adding 'superset flower' command (flower is a UI for Celery) (#2963) (@mistercrunch)
- [#2979](https://github.com/apache/superset/pull/2979) tests for saveQuery, fetchQueryResults, runQuery, postStopQuery (#2979) (@ascott)
- [#2896](https://github.com/apache/superset/pull/2896) fix local state 'columns' (#2896) (@graceguo-supercat)
- [#2977](https://github.com/apache/superset/pull/2977) test props on alert wrapper (#2977) (@ascott)
- [#2972](https://github.com/apache/superset/pull/2972) add test coverage for ResultSet component (#2972) (@graceguo-supercat)
- [#2976](https://github.com/apache/superset/pull/2976) [js-testing] add tests for explore actions (#2976) (@ascott)
- [#2940](https://github.com/apache/superset/pull/2940) Edit Dashboard title and Slice title in place (#2940) (@graceguo-supercat)
- [#2961](https://github.com/apache/superset/pull/2961) add test for ControlPanelSection (#2961) (@ascott)
- [#2952](https://github.com/apache/superset/pull/2952) [js] remove unused npm dependencies (#2952) (@mistercrunch)
- [#2939](https://github.com/apache/superset/pull/2939) add new slice test (#2939) (@ascott)
- [#2951](https://github.com/apache/superset/pull/2951) [js] version js file names using webpack chunkhash (#2951) (@ascott)
- [#2941](https://github.com/apache/superset/pull/2941) [dashboard] notify instead of modal onSave (#2941) (@mistercrunch)
- [987cb99](https://github.com/apache/superset/commit/987cb9978dcd053ebac550c790a9d87d8d25aee6) [hotfix] bumping pandas version to 0.20.2 (@mistercrunch)
- [#1742](https://github.com/apache/superset/pull/1742) Fix handling of Chunked requests (#1742) (@nishantmonu51)
- [#2943](https://github.com/apache/superset/pull/2943) [table viz] get metrics to right-align (#2943) (@mistercrunch)
- [#2945](https://github.com/apache/superset/pull/2945) Bumping some dependencies (#2945) (@mistercrunch)
- [#2946](https://github.com/apache/superset/pull/2946) remove reference for CSRF_ENABLED, and use WTF_CSRF_ENABLED instead (#2946) (@timfeirg)
- [#2921](https://github.com/apache/superset/pull/2921) [explore] improve metric(s) and groupby(s) controls (#2921) (@mistercrunch)
- [34f381b](https://github.com/apache/superset/commit/34f381bc250cf7c74669b52d5cc5f9061c7184c5) v 0.18.5-alpha.3 (@ascott)
- [#2928](https://github.com/apache/superset/pull/2928) add new slice form improvements (#2928) (@ascott)
- [#2912](https://github.com/apache/superset/pull/2912) [big number] various improvements (#2912) (@mistercrunch)
- [#2924](https://github.com/apache/superset/pull/2924) Fix #2814 - json serialization edge case (#2924) (@mistercrunch)
- [fb85f00](https://github.com/apache/superset/commit/fb85f008fac2694bea7f6705cf21dc666490bcd0) v 0.18.5-alpha.2 (@ascott)
- [85fb4a9](https://github.com/apache/superset/commit/85fb4a933d8ab7348082a6849ff96f199b8c02fa) [hotfix] only apply SQLAlchemy limit where needed (@mistercrunch)
- [#2893](https://github.com/apache/superset/pull/2893) [js-testing] type checking for dates.js (#2893) (@ascott)
- [#2889](https://github.com/apache/superset/pull/2889) add more tests for Timer (#2889) (@ascott)
- [#2800](https://github.com/apache/superset/pull/2800) [slices] add simple new slice form (#2800) (@ascott)
- [#2923](https://github.com/apache/superset/pull/2923) updating react-alert dependency to v2.0.1 (#2923) (@dennybiasiolli)
- [#2906](https://github.com/apache/superset/pull/2906) Ignore pyenv files in .gitignore. (#2906) (@xiaohanyu)
- [9aba77d](https://github.com/apache/superset/commit/9aba77db74f8c7e823fcba73fc4e0a1b7efbadd4) 0.18.5-alpha.1 (@mistercrunch)
- [#2910](https://github.com/apache/superset/pull/2910) [dashboard]Add timeout message on Dashboard view (#2910) (@graceguo-supercat)
- [#2908](https://github.com/apache/superset/pull/2908) [explore] fix IN filter on numeric field (#2908) (@mistercrunch)
- [#2911](https://github.com/apache/superset/pull/2911) Removed time column from druid metadata refresh, added long and double schema support (#2911) (@joshwalters)
- [#2897](https://github.com/apache/superset/pull/2897) fix visualize modal checkbox alignment (#2897) (@graceguo-supercat)
- [#2902](https://github.com/apache/superset/pull/2902) update for the italian translation (#2902) (@napo)
- [#2888](https://github.com/apache/superset/pull/2888) [docs faq] how do I add new columns to an existing table (#2888) (@mistercrunch)
- [#2903](https://github.com/apache/superset/pull/2903) update contributing a bit re contributing code (#2903) (@xrmx)
- [#2904](https://github.com/apache/superset/pull/2904) travis: no need to install python3.5 (#2904) (@xrmx)

### 0.18.4 (2017/06/05 00:54 +00:00)
- [72291d6](https://github.com/apache/superset/commit/72291d65c929306792bc62aeaff51e083bc8c09f) 0.18.4 (@mistercrunch)
- [#2895](https://github.com/apache/superset/pull/2895) fix a linting error (#2895) (@graceguo-supercat)
- [#2894](https://github.com/apache/superset/pull/2894) fix js error on explore view (#2894) (@ascott)
- [155fec0](https://github.com/apache/superset/commit/155fec0a6bcb9733c64301e9e8b86aa2c384673b) Updating CHANGELOG.md to 0.18.3 (@mistercrunch)

### 0.18.3 (2017/06/02 15:27 +00:00)
- [d90044c](https://github.com/airbnb/superset/commit/d90044cd523253aa01b5cdf6509b43abeef34079) 0.18.3 (@mistercrunch)
- [62bd4eb](https://github.com/airbnb/superset/commit/62bd4eb2118e4f1e771b58cd455b928be002a461) Converting filter argument to number if column is number (#2891) (@fabianmenges)
- [677c427](https://github.com/airbnb/superset/commit/677c427b1615a2a9b9054932b5e07868d7d63e42) delete DataPreviewModal, it doesn't get used anywhere (#2882) (@ascott)
- [52b0716](https://github.com/airbnb/superset/commit/52b0716571c5b68f65d08719e54343e0a6ec8c8e) [bugfix] allow database macro to work when CSRF is diabled (#2884) (@justinr1234)
- [04b662e](https://github.com/airbnb/superset/commit/04b662ea1154b75e2c362aed97e33946251d1bed) Fix a type error in rst' sub list. (#2881) (@xiaohanyu)
- [db052b1](https://github.com/airbnb/superset/commit/db052b17ea1782c472687095e1365d071e592dd0) Add visualize advise for long query (#2879) (@graceguo-supercat)
- [e300273](https://github.com/airbnb/superset/commit/e300273e71f0b6ca8b63ae974cc13534d94c56de) [explore] adding y_axis_bounds to force Y axis bounds (#2878) (@mistercrunch)
- [c5f2eaf](https://github.com/airbnb/superset/commit/c5f2eafc906bebf1d238e62ff5a8821cf549220c) [explore] 'Save as' -> 'Save' as it can be used to overwrite (#2875) (@mistercrunch)
- [90e4d64](https://github.com/airbnb/superset/commit/90e4d6469d3d420cf839a4c9f3a2408ab0ff0a42) [js-testing] more tests for SelectControl (#2877) (@ascott)
- [1e7773e](https://github.com/airbnb/superset/commit/1e7773eb169d29607991d0c4619ee930104e18de) Improve visualize modal test coverage (#2811) (@graceguo-supercat)
- [3c89c8c](https://github.com/airbnb/superset/commit/3c89c8cc4613d938e4e8726c30142fa32b1249f7) 0.18.3-alpha.3 (@mistercrunch)
- [74086da](https://github.com/airbnb/superset/commit/74086dae2ba66029917a7ed640cfcfc7555c0520) [bars] fix sort numeric bar on x axis (#2812) (@mistercrunch)
- [66403f1](https://github.com/airbnb/superset/commit/66403f1876bb7bcf31eb8187517c116a2d5b6b96) [explore] viz type selector as modal (#2787) (@mistercrunch)
- [3a4cd3a](https://github.com/airbnb/superset/commit/3a4cd3ae24c811e21fb76c5f9efecb2a6c4a6da2) Applying specified limit in bubble plot (#2815) (@mistercrunch)
- [4ffc1f6](https://github.com/airbnb/superset/commit/4ffc1f613e1d2bf012dc5eb66751fea8c698804e) Fix filter values populating for views (#2816) (@mistercrunch)
- [dfbba84](https://github.com/airbnb/superset/commit/dfbba84400986451f5068354a7626537e7b377a4) 0.18.3-alpha.2 (@mistercrunch)
- [77864e6](https://github.com/airbnb/superset/commit/77864e6cf4d5394a5080300097ae21cf9abfcc53) reduce clientside timeout limit (#2820) (@graceguo-supercat)
- [4d12251](https://github.com/airbnb/superset/commit/4d1225180618b4c4f05c67f6534bf273692a9243) [explore] include ControlHeader as part of Control interface (#2809) (@mistercrunch)
- [0c9f9b6](https://github.com/airbnb/superset/commit/0c9f9b695b921c7e17cec83e1d51e4aa3cae7cc9) [clarity/consistency] rename /explorev2/ -> /explore/ (#2802) (@ascott)
- [a4a2bf7](https://github.com/airbnb/superset/commit/a4a2bf7ae9cc1075a38cc980bb696d6512125f2b) filter_box: allow creatable entries (#2804) (@vavrusa)
- [d0a04cd](https://github.com/airbnb/superset/commit/d0a04cde49c86185b779b16f1da05450b1ccf571) apply redux for VisualizeModal (#2795) (@graceguo-supercat)
- [69685b9](https://github.com/airbnb/superset/commit/69685b9dcc0c26f819ff7edeedc10ee302e97f83) Fixing country maps (#2801) (@mistercrunch)
- [b308a3e](https://github.com/airbnb/superset/commit/b308a3eb4eb08de39edbff6490c06a6bef7b7ce1) Added Country Map : New Visualization tools (#2708) (@ymatagne)
- [bfa40bd](https://github.com/airbnb/superset/commit/bfa40bd360021874628477ee3eb2272033cd2d54) [hotfix] 'filter box from and to date filter #2649' (#2785) (@yamdraco)
- [b0e2904](https://github.com/airbnb/superset/commit/b0e2904c245e5569473f425af2806271e33a5176) Updating permission when refreshing druid datasource (#2655) (@ShengyaoQian)
- [ce506bd](https://github.com/airbnb/superset/commit/ce506bdf65b46f5bccee84ca8254417f63b124a5) Logging a few more actions (#2783) (@mistercrunch)
- [922cc03](https://github.com/airbnb/superset/commit/922cc037bf859c935cc5eacbcd96bf6fa004c5fe) 0.18.3-alpha.1 (@mistercrunch)
- [8252ada](https://github.com/airbnb/superset/commit/8252ada1f9ac94866b91eac55b77ed6d0ef7d02f) [docs] more details on how filters are applied (#2778) (@mistercrunch)
- [a2d2f8b](https://github.com/airbnb/superset/commit/a2d2f8bb8c006adcf80bb2ac18b82f3b486f366a) Enable filter value autocomplete in examples (#2781) (@mistercrunch)
- [7c5f61d](https://github.com/airbnb/superset/commit/7c5f61d6a61e1a3cb6d20d0918610abafa2cd326) Adding some STATSD logging (#2715) (@mistercrunch)
- [841e18a](https://github.com/airbnb/superset/commit/841e18a08c4b375fdff5b846f5d9f108903a3eb6) [sql lab] make database ordering alphabetical in left panel (#2769) (@mistercrunch)
- [dbc7fef](https://github.com/airbnb/superset/commit/dbc7fef7f501cd59ebd99524fa171d9e4dee0325) [sql lab] fix user timestamp is off (#2774) (@mistercrunch)

### 0.18.2 (2017/05/17 06:08 +00:00)
- [cbfe3cb](https://github.com/airbnb/superset/commit/cbfe3cb2dcadedeedfcf55f2bb4883b76a484b36) 0.18.2 (@mistercrunch)
- [5fcd25d](https://github.com/airbnb/superset/commit/5fcd25def15b5990c10b5045cb89b88f94ba8716) 0.18.1-alpha.2 (@mistercrunch)
- [fe3f5f6](https://github.com/airbnb/superset/commit/fe3f5f69ae83eaf96415926661b272ebb460a4e0) [hotfix] 'No numeric types to aggregate' (@mistercrunch)
- [2395fbb](https://github.com/airbnb/superset/commit/2395fbbdaaa5c81c3559f17cedf2e998b8341cb9) Adding `end_result_backend_time` to Query model (#2766) (@mistercrunch)
- [960b26c](https://github.com/airbnb/superset/commit/960b26c7a2cad58b39c359f44c385980434dacb8) Show clear and actionable query timeout error message (#2763) (@graceguo-supercat)
- [28ac350](https://github.com/airbnb/superset/commit/28ac3504d67f76c31aac23435dd15d76e0ca75bf) 0.18.1-alpha.1 (@mistercrunch)
- [ecc00bd](https://github.com/airbnb/superset/commit/ecc00bdd26517a832a35529f0fdd7d17972e6f8f) [explore] a bit less margin in left panel (#2758) (@mistercrunch)
- [e794645](https://github.com/airbnb/superset/commit/e7946451d6aa84229d0c70b7a683b29b784ca1a1) fixed 500 error when export dashboard (#2760) (@eeve)
- [9b34600](https://github.com/airbnb/superset/commit/9b34600c8e8df72ecbdfaaf94bdf023c08e26701) Remove duplicate text (#2761) (@awbush)
- [8846108](https://github.com/airbnb/superset/commit/884610861b8d39da91e4c1bce7934172d2486da9) 0.18.0 (@mistercrunch)
- [d9bd3d6](https://github.com/airbnb/superset/commit/d9bd3d646006d9e6ddf2ccded21d7984935c98c8) fix percentage change viz (#2757) (@yileic)
- [38375be](https://github.com/airbnb/superset/commit/38375be5c3062caf9f6cd4d6ac62109e1940bd10) Fix issues around % signs and Presto (#2755) (@mistercrunch)
- [91d951a](https://github.com/airbnb/superset/commit/91d951ac422a6411e59b2ec195011ea4dc44b0b1) Change hardcoded references to 'User' security model to allow custom class override (#2728) (@RichRadics)

### 0.18.0 (2017/05/12 03:36 +00:00)
- [d79a45f](https://github.com/airbnb/superset/commit/d79a45ff32ff8e2b5d601601507680dccf693bbc) add number format to pivot table (#2703) (@yileic)
- [818251f](https://github.com/airbnb/superset/commit/818251fc8519167be7e0730083c4a694972fb06b) make margin consistent (#2753) (@yileic)
- [75abd1f](https://github.com/airbnb/superset/commit/75abd1f44a12208fd54f28a1185d40ea8639396a) 0.18.0-alpha.4 (@mistercrunch)
- [f55df3b](https://github.com/airbnb/superset/commit/f55df3b18b67ff58d5ad3f6f12f7fe76e9697084) [sql lab] fix responsivity of grid (#2742) (@mistercrunch)
- [5dbfdef](https://github.com/airbnb/superset/commit/5dbfdefae82674d71ab1f1464622d199a6f72f30) [sql lab] fix partitionned table has no partitions (#2740) (@mistercrunch)
- [e558444](https://github.com/airbnb/superset/commit/e5584440cecdb0d9a79ba6c4ff1050e73e774035) Speed up all CRUD list views (#2747) (@mistercrunch)
- [d5e9d5d](https://github.com/airbnb/superset/commit/d5e9d5d045d342ef203c7d7cd480011626b6d7a1) fix auto select override pre-selected value bug (#2745) (@graceguo-supercat)
- [3208a01](https://github.com/airbnb/superset/commit/3208a014ffccfe44238fb5982f6e391a1764d4b3) fix dual line chart margin (#2737) (@yileic)
- [874c12a](https://github.com/airbnb/superset/commit/874c12ad2d99059b2f8f979bdd05e77d8768db03) 0.18.0-alpha.3 (@mistercrunch)
- [22d8075](https://github.com/airbnb/superset/commit/22d8075c536bdfc1790b23381e0017720cc921a5) Making the stop button instantaneous (#2738) (@mistercrunch)
- [baebba1](https://github.com/airbnb/superset/commit/baebba115930e95076e9252987fb4e107ddd23d5) 0.18.0-alpha.2 (@mistercrunch)
- [04748b4](https://github.com/airbnb/superset/commit/04748b4cdac7a4fd53f5d7716a36ceebea7bf7ca) [SQL Lab] fix gamma metadata access (#2702) (@mistercrunch)
- [a471afe](https://github.com/airbnb/superset/commit/a471afe206ca3357ea4c27c1accf94d44c8f5122) [sql lab] improvements to the left panel (#2709) (@mistercrunch)
- [5d0a01d](https://github.com/airbnb/superset/commit/5d0a01d0d099a9d73ba04fded7cad223a10e86f2) Decimal is a valid numeric type (#2720) (@hajdbo)
- [9e1272e](https://github.com/airbnb/superset/commit/9e1272e97c88a3ce2e8dfd15fa819de52e331342) 0.18.0-alpha.1 (@mistercrunch)
- [aeebd88](https://github.com/airbnb/superset/commit/aeebd8840d0551a7cd9a2d43039dcd07648d66ed) [table] fixing CSS glitches on table view (#2725) (@mistercrunch)
- [55d3b01](https://github.com/airbnb/superset/commit/55d3b012e504f788732488bf11a1ec7ef223a821) refactor: recentActions ajax call is redundant (#2722) (@S-YOU)
- [a6e1e18](https://github.com/airbnb/superset/commit/a6e1e18244951b5bf68ac76e897a16713c7d279b) [sql lab] fix CREATE TABLE AS (#2719) (@mistercrunch)
- [46d7a92](https://github.com/airbnb/superset/commit/46d7a925bb4be8891c89ac05d2f447e5ec750bf5) chore: remove unused methods with invalid models.Query usage (#2721) (@S-YOU)
- [5929ab7](https://github.com/airbnb/superset/commit/5929ab76890232068bef5412f23a54226dbed0ec) [dashboard] fix missing datasource issue (#2718) (@mistercrunch)
- [fffb7b5](https://github.com/airbnb/superset/commit/fffb7b500a313b9f9d76eecab18241bf0406c933) [sql lab]Add autoSelect (#2713) (@graceguo-supercat)
- [cb14640](https://github.com/airbnb/superset/commit/cb14640a823c3c6cc768169391779064c2469a68) Removing uneeded results_backends.py (#2717) (@mistercrunch)
- [d65054e](https://github.com/airbnb/superset/commit/d65054e01533f62e63e1c8788da4b97309f65cee) [sql lab] fix csv export where `%` in query (#2711) (@mistercrunch)
- [5d5060e](https://github.com/airbnb/superset/commit/5d5060eca61ad1a7f6baf7adced2985088c82d95) Remove unecessary handling of %% (#2714) (@mistercrunch)
- [9ff3515](https://github.com/airbnb/superset/commit/9ff351532ada993afc4da5060b9a942216e2a74b) Basic integration with ClickHouse (#1844) (@vavrusa)
- [59a6f44](https://github.com/airbnb/superset/commit/59a6f447ec1e92a0319a617ecdf4e22847bf5d95) Fix missing curUserId from SliderAdder.jsx (#2705) (@songyanho)

### 0.17.6 (2017/05/01 20:13 +00:00)
- [1887b5e](https://github.com/airbnb/superset/commit/1887b5e934b17864850a46d6e88a606b594e0634) 0.17.6 (@mistercrunch)
- [33758bf](https://github.com/airbnb/superset/commit/33758bfff59b9cdc86b58973244ef0613942dc80) 0.17.6-alpha.2 (@mistercrunch)
- [2d5beb1](https://github.com/airbnb/superset/commit/2d5beb1f91c304df948e943100cbfb66345a00e9) improve csrf expiration error handling (#2695) (@ascott)
- [5fd0e7d](https://github.com/airbnb/superset/commit/5fd0e7d02828df4bb02b6a3b34779517fe637123) [vis] bar values should match y axis format (#2701) (@justinpark)
- [ef0c4be](https://github.com/airbnb/superset/commit/ef0c4be06743083da5c33ed9ffbda7ff77b43e74) Fix for referring specific svg (#2612) (@songyanho)
- [ac3aba7](https://github.com/airbnb/superset/commit/ac3aba7c7da905f0f4bfeb0f80efb87136812b90) [sql lab] visualization flow: fixing the groupby parameter (#2681) (@mistercrunch)
- [0fdb57a](https://github.com/airbnb/superset/commit/0fdb57a18153912c2675b54a2c4e5e00691c7cc0) fix (#2696) (@yileic)
- [3e7b5df](https://github.com/airbnb/superset/commit/3e7b5df2876d1014a8411a57cdd7bb18ce64e5d9) [explore] fix empty chart when changing viz type (#2698) (@mistercrunch)
- [3cd16cf](https://github.com/airbnb/superset/commit/3cd16cf3680169dd17a542d83c84f94ca8220805) Fix test's warnings (#2697) (@dennybiasiolli)
- [a58adc8](https://github.com/airbnb/superset/commit/a58adc862ec28842a3ac7f9f1f205fa1c173015e) Fix orm query in HiveEngineSpec.handle_cursor (#2699) (@xrmx)
- [7d88f80](https://github.com/airbnb/superset/commit/7d88f80a9b2003f4529560160aea41c444283a9e) hack to dynamically adjust y axis left margin (#2689) (@yileic)
- [09be02f](https://github.com/airbnb/superset/commit/09be02f70a716819332629144160360e21c8920b) fix x axis label (#2691) (@yileic)
- [50fcdd3](https://github.com/airbnb/superset/commit/50fcdd3a34f3efe58435760ba0bf321d6767a3a5) Adding tails.com to inthewild (#2685) (@alanmcruickshank)
- [dee3649](https://github.com/airbnb/superset/commit/dee36491c5e9394c19dfbc00def353675079aa83) Fix js warnings (#2693) (@dennybiasiolli)
- [903612a](https://github.com/airbnb/superset/commit/903612ac6c802dd042417c1fa8a742812a2094bb) fix (#2692) (@yileic)
- [ce70505](https://github.com/airbnb/superset/commit/ce705054fa2e738612d746c8f07b577f6941a6e3) fix a bug in 'getMaxLabelSize' and x axis label not shown problem (#2694) (@yileic)
- [c589616](https://github.com/airbnb/superset/commit/c5896168830c0901a6488817d970a92ce3fa8f9a) [sql lab] Update event handler name (#2680) (@graceguo-supercat)
- [58309f2](https://github.com/airbnb/superset/commit/58309f275f3b9d123f75e795fe3e42b918a66aab) Mark a few more string for translation (#2651) (@xrmx)
- [edf4e4f](https://github.com/airbnb/superset/commit/edf4e4f24e9eeceb44e2b9a98d2cb02d8cefa6dd) Update README.md (#2676) (@aioue)
- [b3e0b5b](https://github.com/airbnb/superset/commit/b3e0b5b586d530cdd1def10ef38550f680f1922b) Specifying cryptography version in install docs (@mistercrunch)
- [6880298](https://github.com/airbnb/superset/commit/68802989bc8a13f76988eed004dc07fa06208733) Pinning cryptography lib to 1.7.2 (@mistercrunch)
- [70887d7](https://github.com/airbnb/superset/commit/70887d72e2a54fdae2ba58ad8f408528bd694878) 0.17.6-alpha.1 (@ascott)
- [1922225](https://github.com/airbnb/superset/commit/192222504292aed3ffa7368f85ca6cdc7f92aab5) Alternate fix for #2665 (#2671) (@mistercrunch)
- [0bdc301](https://github.com/airbnb/superset/commit/0bdc3010d8da0789df99d588105d6e62cc6b3280) [vis] fix pivot table scrolling when using more than 1 groupy col (#2674) (@ascott)
- [1df37e6](https://github.com/airbnb/superset/commit/1df37e6e4d609f7c0751faf2360a98a896e30f46) add option for pulling favourited dashboards by username (#2661) (@robert-digit)
- [e9ed416](https://github.com/airbnb/superset/commit/e9ed4166549cb515f5c15357b2395c3858736df1) fix csrf error on import_dashboards (#2672) (@ascott)
- [03c42b5](https://github.com/airbnb/superset/commit/03c42b5b87429f2a29ce1b5ef8c13e9a004b907e) Showing slices on datasource edit form (#2645) (@mistercrunch)
- [e055e6d](https://github.com/airbnb/superset/commit/e055e6d2c22e6087bf7c906174c08d543617a514) Fixing PropTypes warning messages (#2670) (@mistercrunch)
- [2978082](https://github.com/airbnb/superset/commit/29780821e8797fee3fbcbcfacbe3e0871750d19b) [druid] fixing the having clause in the explore view (#2648) (@mistercrunch)
- [f10ee13](https://github.com/airbnb/superset/commit/f10ee139011767fd72e20ff0fb6a6411f6b06d6b) [druid] fix FilterBox viz gets timestamps as values if granularity != all (#2647) (@mistercrunch)
- [cdfc4a3](https://github.com/airbnb/superset/commit/cdfc4a35b22e8b07bf2b0503214074761143e7d9) Optimizing the standalone view (#2663) (@mistercrunch)
- [eb762c8](https://github.com/airbnb/superset/commit/eb762c8bfec56a0da664c4aa71baf2197f58042f) add the missing right bracket (#2662) (@yileic)
- [83abfef](https://github.com/airbnb/superset/commit/83abfef8304a8fe83248d959136e7421ba0e04a8) superset: fix argument swap for SqliteEngineSpec.get_table_names (#2664) (@xrmx)
- [54137ad](https://github.com/airbnb/superset/commit/54137ad023f046780bd0e2089ccc57620787f118) Updating CHANGELOG (@mistercrunch)

### 0.17.5 (2017/04/21 20:56 +00:00)
- [4be6bfa](https://github.com/airbnb/superset/commit/4be6bfafaa07695cf47a9a27977855ab30ff87e4) 0.17.5 (@mistercrunch)
- [9ba6d48](https://github.com/airbnb/superset/commit/9ba6d489f31d2aba38594dac3cb7d75fbabcdc78) v0.17.5-alpha.10 (#2654) (@ascott)
- [af4bd40](https://github.com/airbnb/superset/commit/af4bd40853d477e5104d62c81931b65be0026b50) fix scrolling on markup vis (#2644) (@ascott)
- [84fa0d1](https://github.com/airbnb/superset/commit/84fa0d19407d7fe662ea1945bb0f9e2570945e50) don't default sort by to first column (#2653) (@ascott)
- [938e13a](https://github.com/airbnb/superset/commit/938e13a4297f13354ae7a989de1268cddbf042c4) [hotfix] Presto's latest_sub_partion rendering fail (@mistercrunch)
- [dc364da](https://github.com/airbnb/superset/commit/dc364daffddd740bd827aaaa71d07c13a928c7ef) [query-search] fix scrolling on query search and pagination styling (#2646) (@ascott)
- [1cadfec](https://github.com/airbnb/superset/commit/1cadfecd4bc0c69e0c66ddce12727fd5607b4364) update core.py label and zh po file (#2642) (@RoganW)
- [5b26667](https://github.com/airbnb/superset/commit/5b26667fd520ccf2b668f9d3f7b1a928a1bdaba7) 0.17.5-alpha.9 (@ascott)
- [899caf9](https://github.com/airbnb/superset/commit/899caf94497e22ab8d6a59f695d3805999ab2e4c) [sql-lab] fix scrolling in left hand panel for table meta data (#2641) (@ascott)
- [e6063f2](https://github.com/airbnb/superset/commit/e6063f2ddf14ae9ddb8c9fd8b5ebd548e272e7d5) 0.17.5-alpha.8 (@mistercrunch)
- [46486f8](https://github.com/airbnb/superset/commit/46486f82d9352cd7d340e4dfb6bd9ba2676b2c6c) Moving the warning message to the navbar (#2640) (@mistercrunch)
- [0089762](https://github.com/airbnb/superset/commit/00897629558a4d89c5a500b173b345d8136f52fa) 0.17.5-alpha.7 (@ascott)
- [2bd60c0](https://github.com/airbnb/superset/commit/2bd60c074716faf57a8a10e3a9c73b9fe500080f) [vis] fix line chart when slice is really narrow (#2620) (@ascott)
- [db6cd21](https://github.com/airbnb/superset/commit/db6cd215040220f3cf3636f1decb25139f395cad) [sqllab] table refactor (#2587) (@ascott)
- [f40499e](https://github.com/airbnb/superset/commit/f40499e550ae3ed7fea534b8c657c2c76d9f6070) [dashboard] improve error handling on dashboard (#2624) (@mistercrunch)
- [67a85b9](https://github.com/airbnb/superset/commit/67a85b9831f86a78fe987037000c8f2e6bd9c7d7) Fix dashboard edit button is disabled (#2634) (@mistercrunch)
- [cb3384b](https://github.com/airbnb/superset/commit/cb3384b3b225c1c392453616ce09c1c9e7136baa) Improving Presto error message in explore/dashboard (#2633) (@mistercrunch)
- [ac51a30](https://github.com/airbnb/superset/commit/ac51a30f98019d8cc593f03cd0f542aa35646889) Remove metrics control non-null validator in Table context (#2635) (@mistercrunch)
- [91fe02c](https://github.com/airbnb/superset/commit/91fe02cdc879097d517cddc06a8492536bc3b6ea) Setting adjust_database_uri for HiveEngineSpec (#2636) (@mistercrunch)
- [76042be](https://github.com/airbnb/superset/commit/76042be7c3b52c5019114b372dc841137205e14f) [hotfix/sqllab] setting up the connection in the try: block (@mistercrunch)
- [d3f55a0](https://github.com/airbnb/superset/commit/d3f55a0905e4aa7a2da22113ea8e25c174903c9f) 0.17.5-alpha.6 (@mistercrunch)
- [efaef8f](https://github.com/airbnb/superset/commit/efaef8fe0924ff39e77edbe8fe5e2ed337adccf3) [hotfix] fix  endpoint (@mistercrunch)
- [8757a24](https://github.com/airbnb/superset/commit/8757a24d89e44c13b44b8ae84be9ae12a50b8d48) 0.17.5-alpha.5 (@mistercrunch)
- [63785f0](https://github.com/airbnb/superset/commit/63785f039c0f7763c410c9e7a40a0d477b9bf23a) [hotfix] using UTC for caching timestamps (@mistercrunch)
- [d6689ee](https://github.com/airbnb/superset/commit/d6689ee700102926ebd7efa352cb3c66d970445f) 0.17.5-alpha.4 (@mistercrunch)
- [787daf6](https://github.com/airbnb/superset/commit/787daf6005d325b68a52644804d802a1168cf314) A nice CacheLabel React component (#2628) (@mistercrunch)
- [23aeee5](https://github.com/airbnb/superset/commit/23aeee5a9c1c17ef486fa5106da964acc0b4bd43) Slice level cache_timeout isn't taken into consideration (#2631) (@mistercrunch)
- [70c6cad](https://github.com/airbnb/superset/commit/70c6cad0e3b5e276158c1d9057de40b6fd9498eb) Add UNIX socket option to runserver (#2627) (@scaba)
- [6b1bf3b](https://github.com/airbnb/superset/commit/6b1bf3b395a61a8549b9f3297c8411bb41db52fa) [hotfix] missing explore's main.css (@mistercrunch)
- [f5216f6](https://github.com/airbnb/superset/commit/f5216f60479a2580b5a5532ec8c1b0882905d7a0) Adding owner(s) to dashboard makes them own underlying slices (#2610) (@mistercrunch)
- [15654a3](https://github.com/airbnb/superset/commit/15654a3082f4d6030fafd38d671299670443374e) fix filters on dashboard (#2619) (@ascott)
- [baff0cb](https://github.com/airbnb/superset/commit/baff0cba38554ae28e1024f2114ee5765648c45b) Fix separator widget CSS (#2623) (@mistercrunch)
- [c4ee098](https://github.com/airbnb/superset/commit/c4ee098bb7ffc0db970eba608bfe464ee7b3e60b) 0.17.5-alpha.3 (@mistercrunch)
- [612b8ca](https://github.com/airbnb/superset/commit/612b8ca3d7de9988f22b8f7f81c583ff0b8b19bc) [hotfix] legacy url not handled properly (@mistercrunch)
- [c43a9fd](https://github.com/airbnb/superset/commit/c43a9fd5541d5de0987607d913eddd899ee84e75) [hotfix] fixing the build (@mistercrunch)
- [6c68a21](https://github.com/airbnb/superset/commit/6c68a21e4f77757df57042eedbb91a96b21fa040) [sql lab] fix alt-enter runs out-of-date SQL (#2603) (@mistercrunch)
- [db02b33](https://github.com/airbnb/superset/commit/db02b33e09dd6391fb1d8f777b19d5c16a511abe) [explore] fix query text modal while loading (#2596) (@mistercrunch)
- [2df6baa](https://github.com/airbnb/superset/commit/2df6baa7a741a4bfff786b0f675f1165b122aaac) [sql lab] sorting database names in dropdowns (#2611) (@mistercrunch)
- [fc7bd63](https://github.com/airbnb/superset/commit/fc7bd630399c9f4f936b59be347d5d4d0e516744) [sql lab] fixes issues specific to Sqlite (#2606) (@mistercrunch)
- [959a09c](https://github.com/airbnb/superset/commit/959a09cc92682854e0051fae302bd866d9d5b8b5) [dashboard] fix css padding for markup viz (#2602) (@mistercrunch)
- [366ecef](https://github.com/airbnb/superset/commit/366ecefbaaf4cc31234cc981ebab7eb420efe019) Bumping the JS libs to fix the build (#2616) (@mistercrunch)
- [a2b30f3](https://github.com/airbnb/superset/commit/a2b30f35fcc3c081448d55df31ad445d4d9cec6c) 0.17.5-alpha.2 (@mistercrunch)
- [8bceda8](https://github.com/airbnb/superset/commit/8bceda8134c6e53f62b5b30910ec0eeb02f051e7) [hotfix] fix iframe viz (@mistercrunch)
- [bae1067](https://github.com/airbnb/superset/commit/bae1067015a4b8041d39b806062a45c1950e3f7c) 0.17.5-alpha.1 (@mistercrunch)
- [116dca3](https://github.com/airbnb/superset/commit/116dca3e6fc78ef109f0385b6c4dbf2650dda080) validationErrors is undedfined (@mistercrunch)
- [b448394](https://github.com/airbnb/superset/commit/b448394077eef18b9ed01c9703c58cf05f14d34c) 0.17.5-alpha.0 (@mistercrunch)
- [09f407f](https://github.com/airbnb/superset/commit/09f407f553eb8bca90f6da79cf60c742296488c7) add tooltips to big number vis (#2599) (@ascott)
- [0479118](https://github.com/airbnb/superset/commit/0479118efc0069da2b62c20dc631ebbd00493758) 0.17.5.dev0 (@mistercrunch)
- [c93411b](https://github.com/airbnb/superset/commit/c93411b1e75bc59b174d1256f3108d783eea3264) Fix for merge string as array (#2597) (@songyanho)
- [31283f1](https://github.com/airbnb/superset/commit/31283f14246ccd9f7cac4df238bd65cdd68c840b) Fix metric formating in Dashboard view + some refactoring (#2598) (@mistercrunch)
- [93c6597](https://github.com/airbnb/superset/commit/93c6597cf4f2c47869f9cf4f62cfdbe80cd37760) Adding docs/ to .eslintignore (@mistercrunch)
- [4446c74](https://github.com/airbnb/superset/commit/4446c745a88d4b31de8a30ccb45b4cd6dcc49dae) Fix backend-sync 2 (@mistercrunch)
- [38e90fe](https://github.com/airbnb/superset/commit/38e90fe3098018655a8e2206a053c60c8d7e64aa) Fix backend-sync (@mistercrunch)
- [f548946](https://github.com/airbnb/superset/commit/f5489467e534f3625079843cad82ae12de6cbf3a) Use correct dialect for escaping functions. (#2593) (@steveniemitz)
- [ab0bc5a](https://github.com/airbnb/superset/commit/ab0bc5a3fa81f3951b50828400de6bfc54235860) handle percentage case for tooltips (#2570) (@ascott)
- [412634c](https://github.com/airbnb/superset/commit/412634cb57f6094bbba168d252b8b5dbd56da954) Add missing flask-wtf dependency (#2586) (@xrmx)
- [a0ddbb9](https://github.com/airbnb/superset/commit/a0ddbb9ec954a65a77350bc054b83e35bc4dffeb) Make form_data dict a macro (#2585) (@mistercrunch)
- [a803705](https://github.com/airbnb/superset/commit/a803705ddca1c869ccd50977d033faa5c8a0464b) [bugfix] clarifying how to create a slice (#2565) (@mistercrunch)
- [75a358c](https://github.com/airbnb/superset/commit/75a358c616bf30e15dc752da59de1c3cd333a89c) [explore] force control validation before runQuery (#2544) (@mistercrunch)
- [493ba18](https://github.com/airbnb/superset/commit/493ba1836241146502d5dfa4d5c9ea57f4d8ad6c) Adding macros current_user_id & current_username (#2582) (@mistercrunch)
- [5e4fca4](https://github.com/airbnb/superset/commit/5e4fca4ea4b896a9c427032f30a30b59efbcec63) Bumping a set of Python libraries to the latest release (#2575) (@mistercrunch)
- [d289783](https://github.com/airbnb/superset/commit/d289783b67ef6503f58a330bcd729e3301c20393) Adding Vertica to installation docs (#2581) (@mistercrunch)
- [ac84fc2](https://github.com/airbnb/superset/commit/ac84fc2b65976c1473488e2ed47979d880df34f5) Fixing confusion when selecting schema across engines (#2572) (@mistercrunch)
- [40b3d3b](https://github.com/airbnb/superset/commit/40b3d3b3ef61124ec38d49130b57d751b98a1a67) [hotfix] add csrf_token api endpoint (@mistercrunch)
- [50a9e13](https://github.com/airbnb/superset/commit/50a9e13f9bb9bf0c10ca3b748e1989a15c97ee8a) [hotfix] add csrf_token api endpoint (@mistercrunch)
- [66bff01](https://github.com/airbnb/superset/commit/66bff01b45658547d9853e0d0c22e788550d8267) Changelog for 0.17.4 (@mistercrunch)
- [9691234](https://github.com/airbnb/superset/commit/9691234b7e33d8162253a6971f6eb298c037b748) [hotfix] casting db_id to int (@mistercrunch)

### 0.17.4 (2017/04/07 17:57 +00:00)
- [ddeabdd](https://github.com/airbnb/superset/commit/ddeabdd048296732c24bb7ca2317e5d3683fa17d) Fixing CSRF issues (#2569) (@mistercrunch)
- [3ed45ab](https://github.com/airbnb/superset/commit/3ed45ab98c2e351ced9520bcfce222dd34d45a94) [bugfix] saved query restore wouldn't pick the db (#2568) (@mistercrunch)
- [ca08e70](https://github.com/airbnb/superset/commit/ca08e7051ef47b5a8693dc5088c3af23b582b267) 0.17.4rc5 (@mistercrunch)
- [1fb21b8](https://github.com/airbnb/superset/commit/1fb21b8b45f1bdde4e89386ec791cfa7620986c4) [revert] reverting big num changes (#2567) (@ascott)
- [c581ea8](https://github.com/airbnb/superset/commit/c581ea8661dd229f42d5959a6745a26ce8f03289) Alternative PR for: Some bytes/str issues in py3 w/ zlib and json (#2558) (@rumbin)
- [f19d195](https://github.com/airbnb/superset/commit/f19d1958c51212ae19cef98cfa135b8898cb6bea) INTHEWILD: added Endress+Hauser (#2562) (@rumbin)
- [9c99be5](https://github.com/airbnb/superset/commit/9c99be510b3aaeb4329e1a33413129e1aaacebdd) [hotfix] iframe viz is broken (@mistercrunch)
- [7a08cdc](https://github.com/airbnb/superset/commit/7a08cdcb1c4378986cb1dc6934143a684ab49502) 0.17.4rc3 (@ascott)
- [f24ddfd](https://github.com/airbnb/superset/commit/f24ddfd467731d82206b5cf8185ac0c576a8a6f9) [big num] make sure scatterplot dots align properly (#2559) (@ascott)
- [23a8ea5](https://github.com/airbnb/superset/commit/23a8ea563693bd10635e0dadd97403958ca9d891) v0.17.4rc2 (@mistercrunch)
- [2c04d3c](https://github.com/airbnb/superset/commit/2c04d3c25098d15c9cc6f30a70f787eae6899c74) [bugfix] save dash fails with CSRF related error (#2552) (@mistercrunch)
- [337454b](https://github.com/airbnb/superset/commit/337454b646c71bc313714b849dec49b4d7459a4d) [hotfix] slice with missing datasource related (@mistercrunch)
- [b7f46eb](https://github.com/airbnb/superset/commit/b7f46ebe75b23d5a26d3c17fd219e1b05bff9327) [hotfix] dashboard fails when a slice is missing its datasource (@mistercrunch)
- [10773f9](https://github.com/airbnb/superset/commit/10773f96a7197197bcd5d6dea6d959c081d23156) URL Params macro (#2537) (@mistercrunch)
- [b97a827](https://github.com/airbnb/superset/commit/b97a8275d48c40beaff0a6fb7cf56257dd281fe6) Clarify docs on Redis package required for caching (#2557) (@rhunwicks)
- [081bdca](https://github.com/airbnb/superset/commit/081bdca71ef4979b77e0b7d5f9ab5cc8e6cde2dc) [hotfix] [sql lab] fix sqlite errors when schema is selected (@mistercrunch)
- [62959ca](https://github.com/airbnb/superset/commit/62959ca38ba31e5cc5a1d2b7b9e16bf981f97300) Db2 Grain Correct Data Format (#2545) (@openmax)
- [fe68bc3](https://github.com/airbnb/superset/commit/fe68bc31c334e553131cf6e7f6da7d2359646f6c) Revert "measure x axis labels too and use the longest to determine margins" (#2550) (@ascott)
- [3d2c791](https://github.com/airbnb/superset/commit/3d2c791ff1279af4c19108ee220a37c24710686a) [bug num vis] fix sizing for single digits (#2548) (@ascott)
- [d40ce52](https://github.com/airbnb/superset/commit/d40ce52139d7b9319ac8b86e5d77d3f4998b5926) v0.17.4rc1 (@mistercrunch)
- [122891c](https://github.com/airbnb/superset/commit/122891c29b8f46c986207d4903ae584b0ac44a8e) [sql lab] allow users to save their queries (#2528) (@mistercrunch)
- [c1d9918](https://github.com/airbnb/superset/commit/c1d9918abeb3bca33721fc5af9be59e89fffccbf) [vis] bug num improvements (#2523) (@ascott)
- [d93b1fc](https://github.com/airbnb/superset/commit/d93b1fc686e0f0518b04203e1b65967f6b84d441) [sql-lab] make query history scrollable (#2499) (@ascott)
- [02c5cac](https://github.com/airbnb/superset/commit/02c5cac26f853634bb0d244579c366abcb400c77) [hotfix] adding filterable to DruidColumnInlineView.edit_columns (@mistercrunch)
- [6566377](https://github.com/airbnb/superset/commit/65663777402c6770b796ca3f65fedc59d756da82) [sql lab] fix table dropdown with large schema make UI unresponsive (#2547) (@mistercrunch)
- [db6b2f3](https://github.com/airbnb/superset/commit/db6b2f3ae19740c86a537f031ec7fbee4b341742) pylint errors will now break the build (#2543) (@mistercrunch)
- [c31210b](https://github.com/airbnb/superset/commit/c31210b96d0b3aa96e826657da6e6754c87e59a0) Some column description clarifications (#2536) (@mistercrunch)
- [dcc6f2a](https://github.com/airbnb/superset/commit/dcc6f2a18fadda5ddb1a507508cf049b9932f02b) serve roboto font locally (#2519) (@ascott)
- [0c0666c](https://github.com/airbnb/superset/commit/0c0666caa0e7ce5725416115389fe797113b731c) druid: use six.string_types instead of basestring (#2541) (@xrmx)
- [243eead](https://github.com/airbnb/superset/commit/243eeadfd6994c6ac93467a334601fb23278888f) installation instructions for AWS Athena (#2538) (@dwa)
- [9ba5b49](https://github.com/airbnb/superset/commit/9ba5b49d8ac197a5ba908b229bd9061ce98c5fca) WIP: Initial commit to support the athena DB (#2531) (@dwa)

### 0.17.3 (2017/04/01 23:55 +00:00)
- [c870bd4](https://github.com/airbnb/superset/commit/c870bd414ecafe9b83f223dd5894544dc34fba0f) 0.17.3 (@mistercrunch)
- [4b01e92](https://github.com/airbnb/superset/commit/4b01e92509a903bcc25260749ee055be12e5949c) [dashboard] allow bar charts to scroll on x axis (#2513) (@mistercrunch)
- [513a090](https://github.com/airbnb/superset/commit/513a090cdc852c287c62c5d4dc47d6168974251c) [sql lab] address lingering spinner in schema select (#2512) (@mistercrunch)
- [abe79d1](https://github.com/airbnb/superset/commit/abe79d1427b94fb126bd3aec5511bbe2c905d94c) Deprecate is_featured as a datasource attribute (#2485) (@mistercrunch)
- [b81968d](https://github.com/airbnb/superset/commit/b81968dc2051d0cef22da1633fb315f076c7d94c) Redirect to explore view when saving a table (#2479) (@mistercrunch)
- [66cc546](https://github.com/airbnb/superset/commit/66cc546a300d63dd06385a0c35e2268453f70fd6) [hotfix] fixing the (one js lint err in the) build (@mistercrunch)
- [6e899ac](https://github.com/airbnb/superset/commit/6e899ac55f5fe093a9081c4001e28b945bc0f8f6) added tobii (#2526) (@dwa)
- [6b52384](https://github.com/airbnb/superset/commit/6b523840244ae55519641e621d83aac1342fc51b) [hotfix] fix pending queries race condition (@mistercrunch)
- [0a1d8db](https://github.com/airbnb/superset/commit/0a1d8db35783d37c2eea774f2e0c3b4d6a064fde) v0.17.3rc3 (@mistercrunch)
- [6f68ddb](https://github.com/airbnb/superset/commit/6f68ddb50516efff1525f6aebc28f67dbad8c38b) Adding  to polling states (@mistercrunch)
- [4f59abf](https://github.com/airbnb/superset/commit/4f59abf189f9b34654854607c5f943e774fbccbe) v0.17.3rc2 (@mistercrunch)
- [5c441f4](https://github.com/airbnb/superset/commit/5c441f4ddb84a58080b577497760ea65b7537f53) [hotfix]  queries trigger polling (#2517) (@mistercrunch)
- [be023ab](https://github.com/airbnb/superset/commit/be023aba8d972ad5460beed07f768f10398621c4) 0.17.3rc1 (@mistercrunch)
- [5399020](https://github.com/airbnb/superset/commit/53990201bc97ad2035e10500eda0d4c935f3bfb1) forgotten query_datasources_by_name function (#2497) (@wyndhblb)
- [37783d6](https://github.com/airbnb/superset/commit/37783d685fe7c7b52a3188ace5f1504f8e2eb367) Updating CHANGELOG (@mistercrunch)

### 0.17.2 (2017/03/29 14:46 +00:00)
- [25fdcac](https://github.com/airbnb/superset/commit/25fdcaca8b1dd32c05ecd7fd57d4cf32e8f72447) v0.17.2 (@mistercrunch)
- [ce6e7c1](https://github.com/airbnb/superset/commit/ce6e7c135943130fb104b10d284aca93e4f2d4dc) [hotfix] missing logging import in db_engined_specs (@mistercrunch)
- [9116766](https://github.com/airbnb/superset/commit/91167665b19ca094fd51dadf9538c12fd61bc55a) Track both query start time and button push time to track delay (#2502) (@mistercrunch)
- [f374345](https://github.com/airbnb/superset/commit/f374345860f4a3e307ea1772b099ce038868aa71) Adding a .pylintrc file and a bit of linting (#2507) (@mistercrunch)
- [d3b50cb](https://github.com/airbnb/superset/commit/d3b50cb92e046de316725f0e02fdd816573b6234) [explore] remove grey background in standalone mode (#2503) (@mistercrunch)
- [a58194b](https://github.com/airbnb/superset/commit/a58194bdb06a966c6d642bdfa7c80195cc9cf996) 0.17.2rc4 (@mistercrunch)
- [5f3484a](https://github.com/airbnb/superset/commit/5f3484ac5981f2dd6aa447cbc2e4f2a9afe4518c) Handle errors when the MQ is down (#2494) (@mistercrunch)
- [e14b74f](https://github.com/airbnb/superset/commit/e14b74fdbf876aeeeea7baa125926dcf719a0098) [explore] fixing bugs in controls (#2496) (@mistercrunch)
- [56f2885](https://github.com/airbnb/superset/commit/56f28859b7315767d3e312aa3777b777156a658d) Fixing filter_box css padding (#2498) (@mistercrunch)
- [f3cdb3b](https://github.com/airbnb/superset/commit/f3cdb3b787b804071a8f183569027169e432cb46) Add ibm_db_sa TimeStamp and Datatime Grain Spec. (#2500) (@openmax)
- [b35f6b0](https://github.com/airbnb/superset/commit/b35f6b0a94df2017b3bd908c6589d786f9feec6b) 0.17.2rc3 (@mistercrunch)
- [5574cfe](https://github.com/airbnb/superset/commit/5574cfef59a7326487f7cebf9a575070ab19a3c2) Fixing out-of-sync security (#2493) (@mistercrunch)
- [c301558](https://github.com/airbnb/superset/commit/c3015583ce09f259bf36e018ebd0820f9c0cb92f) Stabilizing master (#2478) (@mistercrunch)
- [7cc2c93](https://github.com/airbnb/superset/commit/7cc2c930ede176242cc9066baf16c00fccd23e01) [docs] adding notes on the Public role (#2486) (@mistercrunch)
- [2662bf1](https://github.com/airbnb/superset/commit/2662bf19df690c0a133318406a6935a27245a82f) v0.17.2rc2 (@mistercrunch)
- [62e3fe2](https://github.com/airbnb/superset/commit/62e3fe2345afa6fa8b8cb0da7f20bb44b48a0e54) [hotfix] SqlaTable has no attribute column_cls (@mistercrunch)
- [7d25d17](https://github.com/airbnb/superset/commit/7d25d171e29dce859c455a03d33cc4c3054775c7) [release] update to 0.17.2rc1 (#2492) (@ascott)
- [c5859c7](https://github.com/airbnb/superset/commit/c5859c7254448d2cdbc877b00580bd95fa6e7e2e) [hotfix] druid queries 'There was no query executed' issue (@mistercrunch)
- [dd7b4b8](https://github.com/airbnb/superset/commit/dd7b4b8310e27310f80a0415a2bd877f3098127b) Revert "[sql-lab] revert react-virtualized-select (#2489)" (#2491) (@ascott)
- [93551a6](https://github.com/airbnb/superset/commit/93551a65b845f430aaefaa50f75a40857f1b6ed6) only fetch tables if we have a schema, otherwise reset options. (#2490) (@ascott)
- [7eafbab](https://github.com/airbnb/superset/commit/7eafbabe65b430a2347ed6bba3e08d1f4d8c1946) [sql-lab] revert react-virtualized-select (#2489) (@ascott)
- [43dd948](https://github.com/airbnb/superset/commit/43dd948476190cf75649164f57a9b73687ca3d99) [sql-lab] performance updates - make ui more responsive (#2469) (@ascott)
- [75e7f2d](https://github.com/airbnb/superset/commit/75e7f2d22c7185f2a6393b7ded7a2b5d0558cfca) [hotfix] bumping QUERY_UPDATE_FREQ from 1000 to 2000ms (@mistercrunch)
- [26662ee](https://github.com/airbnb/superset/commit/26662eed9e08475a4c41d715f5a3608876a1afd1) Fixed CSS syntax for background linear-gradient (#2482) (@songyanho)
- [121b1d0](https://github.com/airbnb/superset/commit/121b1d0951049ac30ab35a225269c03451d14bbc) Refactoring more in the connector base classes (#2431) (@mistercrunch)
- [398036d](https://github.com/airbnb/superset/commit/398036d77e0c817796e3735797eae56e80dce437) [hotfix] 'NoneType' object has no attribute 'upper' (@mistercrunch)
- [59d5fcf](https://github.com/airbnb/superset/commit/59d5fcf88c0f484a189c7f02968982b2d39512ad) [hotfix] fixing checkboxes in Tables->Columns (@mistercrunch)
- [1f8e48b](https://github.com/airbnb/superset/commit/1f8e48b374adb091bf41e60634e99b132a37bf62) [sqllab] assign types for visualize flow (#2458) (@mistercrunch)
- [7bf19b1](https://github.com/airbnb/superset/commit/7bf19b12327504aec2be2c2fd36404efb1faec05) [WiP] making doubling '%' not required (#2459) (@mistercrunch)
- [1590b8c](https://github.com/airbnb/superset/commit/1590b8c7e5a070183a3c0e3153aec63992e3c60f) Speeding up polling by not checking access (#2466) (@mistercrunch)
- [22522fc](https://github.com/airbnb/superset/commit/22522fc05f8859b94299576f4a8b07bd42eaba00) [sql-lab] improve table select performance (#2457) (@ascott)
- [c9b59fa](https://github.com/airbnb/superset/commit/c9b59fab1fded7fa08fc9d44a8c18427865e11dd) Update INTHEWILD.md (#2455) (@jakubczaplicki)
- [69152e0](https://github.com/airbnb/superset/commit/69152e087a2b9900e53a8a97ed318c271f725649) [explore] remove 'SQL Clauses' section when using Druid (#2449) (@mistercrunch)
- [652e572](https://github.com/airbnb/superset/commit/652e572b56054cefdfe83403db2125a9d85f5a6a) [sql-lab] make results table scroll in static container (#2426) (@ascott)
- [65c89f5](https://github.com/airbnb/superset/commit/65c89f54dc845ee4f77b230fb334eba225bb14e6) [hotfix] merging db migration scripts (#2448) (@mistercrunch)
- [edf5c0e](https://github.com/airbnb/superset/commit/edf5c0e83b2c9023ef3ad9cabc7ce19d32551d84) [dist_bar] fix x scroll when overflowing (#2440) (@mistercrunch)
- [a4abbfe](https://github.com/airbnb/superset/commit/a4abbfe1266ab1593ba82ef23d6e733b3d8e8e33) Fix formatting in README.md (#2441) (@imagejan)
- [7b28bce](https://github.com/airbnb/superset/commit/7b28bcef15cd37284780e605f5076ede2864afb4) Fix documentation for adding a Redshift database (#2447) (@alexdebrie)
- [8042ac8](https://github.com/airbnb/superset/commit/8042ac876e80c08d72489287777cb1e9672b177a) [explore] improved filters (#2330) (@mistercrunch)
- [82bc907](https://github.com/airbnb/superset/commit/82bc907088be26206a7c8d1c84311ca399eb73b9) fix a bug in pie chart (#2423) (@yileic)
- [e2b572d](https://github.com/airbnb/superset/commit/e2b572d9e229fee503128cab8d7bff02a9cd881b) Prevent alarming users with stacktrace when using sqlite (@mistercrunch)
- [e71596d](https://github.com/airbnb/superset/commit/e71596dc45f96e6a3fdfb09f5ee6b00a9cdd018c) make dualline thumbnail have consistent size as other thumbnails (#2434) (@yileic)
- [c3be58d](https://github.com/airbnb/superset/commit/c3be58db437746c168e706e8a5710e2a1d363d0d) Add verbose name to db and druid cluster (#2429) (@bkyryliuk)
- [3d77a12](https://github.com/airbnb/superset/commit/3d77a12aa9b27375a02f7092c16a2883bd171913) Display the first partition. (#2425) (@bkyryliuk)
- [36deb8d](https://github.com/airbnb/superset/commit/36deb8da7157893d08d01148ab538f963aacf140) Allow users to alter column types (#2424) (@mistercrunch)

### 0.17.1 (2017/03/16 15:44 +00:00)
- [05ee8c0](https://github.com/airbnb/superset/commit/05ee8c0e3675b0ab88cf85d061971177ed871144) v0.17.1 (@mistercrunch)
- [5ca55a5](https://github.com/airbnb/superset/commit/5ca55a55858a59f6340284cfe4081fd26d2be489) [hotfix on dist_bar] bringing back overwritten handling of ints and tuples (@mistercrunch)
- [1b330a8](https://github.com/airbnb/superset/commit/1b330a8c55f0ec114970855c6682627434216ab5) Use connector registry for metrics (#2420) (@bkyryliuk)
- [696678c](https://github.com/airbnb/superset/commit/696678c9816d934c10243395e12e8483e2a42df0) Replace query once query response returned (#2415) (@vera-liu)
- [20aec3c](https://github.com/airbnb/superset/commit/20aec3cfcad082f921cdfc347382b2d0d4a4fd54) Use connector registry to fetch the table column class. (#2419) (@bkyryliuk)
- [4ded37e](https://github.com/airbnb/superset/commit/4ded37e71edf1306ee9652cf32324b5dc14a1328) [hotfix] handle missing or empty column type (@mistercrunch)
- [0674ed8](https://github.com/airbnb/superset/commit/0674ed846c478bd97e7b6953c375b5a3ab26802b) Use list instead of numpy array (#2412) (@bkyryliuk)
- [3107152](https://github.com/airbnb/superset/commit/3107152f5bb973b8b1a9c5cf3bc2bee1d7f47e0d) Revert "Preprocess the where clauses." (#2411) (@bkyryliuk)
- [5b19528](https://github.com/airbnb/superset/commit/5b19528662f5ea645ead5b066144d69469ecbf7c) Display full name. (#2378) (@bkyryliuk)
- [357773c](https://github.com/airbnb/superset/commit/357773c631ad39260109ec45d9c313d6d45cea89) Preprocess the where clauses. (#2405) (@bkyryliuk)
- [5e43d07](https://github.com/airbnb/superset/commit/5e43d074c3be9b909fe0b473f00e743b4ba9d56e) [explore ] templating can now reference query elements (#2388) (@mistercrunch)
- [08bdcd5](https://github.com/airbnb/superset/commit/08bdcd52b856f5ed6c91ab9c3805cf259223da0a) Fix bad d3.format metric setting and/or value === Infinity (#2399) (@mistercrunch)
- [0b8522b](https://github.com/airbnb/superset/commit/0b8522be502988d8b9bf64a8ea203068adf5957d) [filter_box] fix time filter and inverted instantFilter (#2402) (@mistercrunch)
- [c02a7fe](https://github.com/airbnb/superset/commit/c02a7fe7634b311c6f42968a9f7bafef147092e1) Add more tests to Save Modal specs (#2313) (@vera-liu)
- [dcd5bde](https://github.com/airbnb/superset/commit/dcd5bdeb00b8333d67234bde79397b5195fbb8f9) fix unicode issues (#2308 #2282) (#2401) (@asdf2014)
- [562b4f0](https://github.com/airbnb/superset/commit/562b4f04156f20a2aeec8d2c27758571d0aaa514) Do not silence error message for query. (#2396) (@bkyryliuk)
- [6160a3f](https://github.com/airbnb/superset/commit/6160a3fdffdcebe618191462633414c0dff7de30) Implement stop query functionality. (#2387) (@bkyryliuk)
- [0779da6](https://github.com/airbnb/superset/commit/0779da6d244c5686f6ab5faf2ef5067019266460) Keep column order in .csv (#2377) (@bkyryliuk)
- [740624b](https://github.com/airbnb/superset/commit/740624ba01edcfa305d6ff0a2676d413e59377f4) Fix monthly time grain in sqllite (#2380) (@bkyryliuk)
- [2969cc9](https://github.com/airbnb/superset/commit/2969cc9993325acc730b794f9d0d0b07fe1a60ec) Refactoring Druid & SQLa into a proper "Connector" interface (#2362) (@mistercrunch)
- [9a8c3a0](https://github.com/airbnb/superset/commit/9a8c3a044710bcfc578b77b498af1f15685f2bca) [table] metric ordering is wrong in some cases (#2373) (@mistercrunch)
- [e817382](https://github.com/airbnb/superset/commit/e817382efd5f18e09534a70f95cc47332288356e) Add more tests to Filter spec (#2315) (@vera-liu)
- [422d1fe](https://github.com/airbnb/superset/commit/422d1feb3e2ac964b77cd9756ed0fc1293056373) 0.17.1rc2 (@mistercrunch)
- [2b0cb2b](https://github.com/airbnb/superset/commit/2b0cb2b0a56d033cd59c13ae3326c3d922d53b22) Fix partition query (#2353) (@bkyryliuk)
- [705d09d](https://github.com/airbnb/superset/commit/705d09d3d07e05e3a5e070d25a348a45288d7721) Remove duplicate (#2351) (@bkyryliuk)
- [9114d86](https://github.com/airbnb/superset/commit/9114d86ecd0dbd0ad20c24d56f1fd29604de2047) Add hive to superset + monkey patch the pyhive (#2134) (@bkyryliuk)
- [ad4a950](https://github.com/airbnb/superset/commit/ad4a950b5646abef823357274298014292af091f) Fixes filters emitted from table viz (#2335) (@mistercrunch)
- [bd480e0](https://github.com/airbnb/superset/commit/bd480e0c6b9d5127d96d8c18fd53ebe6193aec70) Fix duplicate property DruidDatasource.database (#2348) (@mistercrunch)
- [af3415b](https://github.com/airbnb/superset/commit/af3415b0406399ba41c1592d31440b722556f90b) [filter_box] option to delay filtering with apply button (#2338) (@mistercrunch)
- [b4a96bd](https://github.com/airbnb/superset/commit/b4a96bd8409d38462ea14d2fbafa2f975defd741) Fix for RuntimeError: dictionary changed size during iteration (#2320) (@moranrf)
- [9d8d421](https://github.com/airbnb/superset/commit/9d8d4213840cc07d95ac971437632aeae4ff58b5) [hotfix] fix world map (@mistercrunch)
- [f6ffc00](https://github.com/airbnb/superset/commit/f6ffc007481c658293ae209982dfc369c0f82f95) Allow running Flask Blueprints alongside Superset (#2337) (@mistercrunch)
- [e35016f](https://github.com/airbnb/superset/commit/e35016f07d3880cd557f48c72c617e68d61b125d) remove unneeded tooltip/description text (#2303) (@ascott)
- [af8e252](https://github.com/airbnb/superset/commit/af8e2523a820080e06aaf3e50ff309ada1422bc6) fix version (#2336) (@ascott)
- [492df94](https://github.com/airbnb/superset/commit/492df94b2a3a4767af40edfb5ab074632baaea4d) [sqllab] reserved words should be upper case (#2316) (@mistercrunch)
- [b62f7e2](https://github.com/airbnb/superset/commit/b62f7e2820fc140a318b69b84c54a8a5fe965ed0) [version] use rc for production only releases (#2334) (@ascott)
- [5cc2fc1](https://github.com/airbnb/superset/commit/5cc2fc157cfc2dc14363424533eade67e1f48543) v0.17.1 (#2333) (@ascott)
- [266c049](https://github.com/airbnb/superset/commit/266c049f2df96bb7c815c91dd9f650fbefd6b513) Fix bug with breakdown (#2312) (@vera-liu)
- [4e848c8](https://github.com/airbnb/superset/commit/4e848c8cb55be50c5c5ddbb58694b20d4223a2a3) Updating CHANGELOG (@mistercrunch)
- [efff1ac](https://github.com/airbnb/superset/commit/efff1ac4a1d2b26ef932ac6937be0456fb901c09) Temp hack to make druid filters work in dashboard (#2300) (@vera-liu)
- [fc64a75](https://github.com/airbnb/superset/commit/fc64a75fbd5a3aed7a62b741a9a057acb2b9dca8) v0.17.0 (#2298) (@vera-liu)

### 0.17.0 (2017/02/28 19:47 +00:00)
0.17.0 introduces major changes that **YOU CANNOT ROLLBACK FROM**, take
a backup of your app's database before starting the upgrade progress.

* **bookmarks:** the URL scheme for the explore view changed, but previous
URLs are still supported, though there may be some edge cases there
* **translations**: 0.17.0 has a major regression around translations as
much of the logic in the explore view moved from the backend to the frontend
where we currently do not have a translation framework setup. If
translations are important to you, you should skip 0.17.* and get involved
in getting translations to work well in future versions. `1.0` will have
translations

- [dd9f431](https://github.com/airbnb/superset/commit/dd9f431b6fe6179ebdae015a375640adccb388c0) v0.17.0 (@mistercrunch)
- [c894c54](https://github.com/airbnb/superset/commit/c894c54d00af8b6981c8aafcde02be7195973a38) [table] Allowing to show the time grain in table view (#2294) (@mistercrunch)
- [4d349c7](https://github.com/airbnb/superset/commit/4d349c788559ee3fd7de6792d0e153b98d799487) [hotfix] Fix filter for sqlalchemy and druid (#2293) (@vera-liu)
- [675b819](https://github.com/airbnb/superset/commit/675b819e0a2601b23e21b37aedf0b49757e218f4) Revert "[hotfix] Fix druid filters" (#2292) (@vera-liu)
- [09f1083](https://github.com/airbnb/superset/commit/09f1083c509a690c1f5fcf68f9823fea661ba80f) [table viz] allow showing time granularity in table (#2284) (#2291) (@vera-liu)
- [47be3ef](https://github.com/airbnb/superset/commit/47be3ef3ea385925b5ef67cdecb0ba36adc2b3db) Fixing bugs in Sankey diagrams (#2290) (@mistercrunch)
- [9dd7778](https://github.com/airbnb/superset/commit/9dd7778597e3429c7bb93788172a2850dd33656e) [table viz] allow showing time granularity in table (#2284) (@mistercrunch)
- [efffa92](https://github.com/airbnb/superset/commit/efffa925edf3f54f76acb03660a5b85728133004) rc7 (@mistercrunch)
- [fa9bc92](https://github.com/airbnb/superset/commit/fa9bc92c9551669d5dc1fb99f06e8d49052938d1) [hotfix] filters broken on multi-datasource dashboards (@mistercrunch)
- [227c66c](https://github.com/airbnb/superset/commit/227c66c2c50dd88bdc1ae4eb81dcd2f8189aea98) [hotfix] add regex for druid filters (#2288) (@vera-liu)
- [e91bc9d](https://github.com/airbnb/superset/commit/e91bc9dfcceeb22b88efd57e6defe80d520079f0) added gcc-c++ for RHEL OS dependencies (#2286) (@soccerties)
- [bc29035](https://github.com/airbnb/superset/commit/bc29035bdadad7c2df6d430661314a02d1bafea4) 0.16.1rc6 (@mistercrunch)
- [f10e453](https://github.com/airbnb/superset/commit/f10e453c9bf0a0988769e7a5f126e94e40b50a49) Fixing bar charts x_axis labels (#2280) (@mistercrunch)
- [d4b59b3](https://github.com/airbnb/superset/commit/d4b59b36a801e0f50cde85c15da0538848a5a202) Fixed a bug when querying with schema path to Redshift/Postgresql (#1789) (@sungjuly)
- [4f644cd](https://github.com/airbnb/superset/commit/4f644cd0cae02af685cb12e42edc2875cb32acca) 0.16.1rc5 (@mistercrunch)
- [ed2935e](https://github.com/airbnb/superset/commit/ed2935ec69d72765d66d8c9afe45e0a0b070cc6a) Fixing multi value parsing on old URL (#2277) (@mistercrunch)
- [ea72c6b](https://github.com/airbnb/superset/commit/ea72c6b0188e9c5a662358e89c95801b319296f8) [bugfix] css editor dooesn't pop up (#2243) (@mistercrunch)
- [2df6ab3](https://github.com/airbnb/superset/commit/2df6ab36bf5dab7366ff76fc8d9454cb62a49046) Add Udemy to INTHEWILD (#2275) (@sungjuly)
- [10ea635](https://github.com/airbnb/superset/commit/10ea63557a29859e09cbc5bf93a539a9b9f3ea55) [hotfix] not grouped by -2 (@mistercrunch)
- [55e462d](https://github.com/airbnb/superset/commit/55e462d90b0d01baca8d5c5f2877220b039524ce) 0.16.1rc3 (@mistercrunch)
- [7339392](https://github.com/airbnb/superset/commit/73393925c0482007e498afa745be6d20d8c49b83) [hotfix] Table view doesn't allow SELECT (no group by) (#2274) (@mistercrunch)
- [f9852bc](https://github.com/airbnb/superset/commit/f9852bc807f5335987d0d3d46c665b975a5fb0c1) v0.16.1rc2 (#2272) (@ascott)
- [6e1901e](https://github.com/airbnb/superset/commit/6e1901e8e83d9e2a6e5fc20e3f8e3e996e1ea712) d is not defined, fix (#2270) (@ascott)
- [8758296](https://github.com/airbnb/superset/commit/87582962d98424050ff6f61794fd42fe1f5c0c2f) [Hotfix] access slice_id when slice exists (#2268) (@vera-liu)
- [3de2698](https://github.com/airbnb/superset/commit/3de2698657b389476a9778754fcbc6fb5acc6853) Introducing support for pre-depercate_v1 URL scheme (#2267) (@mistercrunch)
- [ec1f022](https://github.com/airbnb/superset/commit/ec1f0221cd48bb168d0280f55082832d73583f04) Parse filter values for possible integers and floats (#2263) (@vera-liu)
- [4d900c9](https://github.com/airbnb/superset/commit/4d900c9ee1e2ab2db0bf42a2c14268cf4ce91186) Do not add slice_name when slice doesn't exist (#2265) (@vera-liu)
- [3a75890](https://github.com/airbnb/superset/commit/3a758900eb295039c52be89ecfc13e1260c9b1da) [hotfix] separator renders markdown (@mistercrunch)
- [1ea7178](https://github.com/airbnb/superset/commit/1ea7178d17c5b2459e36d213611abcaac0b05620) v0.16.1rc1 (#2260) (@ascott)
- [c85c998](https://github.com/airbnb/superset/commit/c85c9988df3d4bba2a9bce36ebfa681225400e42) fix index error for bar charts (#2258) (@ascott)
- [34f6807](https://github.com/airbnb/superset/commit/34f68073a28d3dacc4162df7c0e2421cb527afe1) Default action to overwrite for users with overwrite permissions (#2257) (@vera-liu)

### 0.16.1 (2017/02/24 18:56 +00:00)
- [acc880c](https://github.com/airbnb/superset/commit/acc880c4dfc2a02b8d46249895259961e2574c42) [v0.16.1] bump version for prod release (#2250) (@ascott)
- [557b557](https://github.com/airbnb/superset/commit/557b557503b1835412337a4d0d4a574535133ec1) [bugfix] avoid caching errors (#2244) (@mistercrunch)
- [3018356](https://github.com/airbnb/superset/commit/301835658838fc0d9cb2d807ee8fa06b0ed44550) Support more druid postaggregations. (#2235) (@bkyryliuk)
- [ede4dff](https://github.com/airbnb/superset/commit/ede4dffcb71f6d31f9c062af4bcdeeaa9d4ca252) Add trailing slash (#2236) (@bkyryliuk)
- [cad392e](https://github.com/airbnb/superset/commit/cad392eb768e65f11b664ad1e2aeffa9741e1bd4) Fetch schemas separately. (#2227) (@bkyryliuk)
- [0296158](https://github.com/airbnb/superset/commit/02961581005ddb3abea89b38b1cce6af9247b8db) [docs] more specific about python versions (@mistercrunch)
- [b2a4692](https://github.com/airbnb/superset/commit/b2a4692a02a2e6864aa1a8c66f7f63502be3e40e) 0.16.0rc3 (@mistercrunch)
- [2fbadea](https://github.com/airbnb/superset/commit/2fbadea9e328554312742d7a8259d7f773ad314a) Fixing exploring a table (#2233) (@mistercrunch)
- [dc05be3](https://github.com/airbnb/superset/commit/dc05be36a60237c930ca60184bbbc054182eeab1) Check if the query is in state first. (#2226) (@bkyryliuk)
- [dac0d1d](https://github.com/airbnb/superset/commit/dac0d1d0dce2f5ab0c1d5b43814773688ef033c3) 0.16.0rc2 (@mistercrunch)
- [459f716](https://github.com/airbnb/superset/commit/459f7160ac7587f92c8213b496fb64518329c1be) Fixing filtering issues (#2223) (@mistercrunch)
- [aff524d](https://github.com/airbnb/superset/commit/aff524d84389b605e2f390350f4608f12ed67241) **Allow user to put dbname in url (#2209) (@vera-liu)
- [3a91667](https://github.com/airbnb/superset/commit/3a91667e92e0b3bbadd0df4d35d03558268fb6d3) Update cache for the command line command. (#2213) (@bkyryliuk)
- [3e0d358](https://github.com/airbnb/superset/commit/3e0d3584f77b2f493687c1c61af63fb4f321bd36) v0.16.0rc1 (@mistercrunch)
- [1e47d6f](https://github.com/airbnb/superset/commit/1e47d6fb41b8095e2ab24704c8340c16cf8c13e6) Renaming field to control (#2210) (@mistercrunch)
- [d5ba88b](https://github.com/airbnb/superset/commit/d5ba88b4072d45efbb82cc6492645627560794c1) Fixing the CACHING (#2203) (@mistercrunch)
- [#2202](https://github.com/airbnb/superset/pull/2202) Merge pull request #2202 from mistercrunch/clean_cli (@mistercrunch)
- [ec84aa7](https://github.com/airbnb/superset/commit/ec84aa75770b8a6c8f40f6519596571a5dfb48b5) Fixing typo (@mistercrunch)
- [8b4d72c](https://github.com/airbnb/superset/commit/8b4d72cf32fbaa05a196995246090907e197bf7f) Reverting react-select to rc2 (@mistercrunch)
- [85e6e65](https://github.com/airbnb/superset/commit/85e6e65a47e5d419b181876f2659038461b24974) Fixing the build (@mistercrunch)
- [7cad365](https://github.com/airbnb/superset/commit/7cad3655f5f0638acc76e2a0396baeb28702906a) Bumping react-select to 1.0.0-rc.3 (@mistercrunch)
- [b9e7f29](https://github.com/airbnb/superset/commit/b9e7f292c38610a23b75b57cf2ba04d1722fa94f) Cleaning up CLI stdout on startup (@mistercrunch)
- [fc85034](https://github.com/airbnb/superset/commit/fc85034c60422d3b504e039e6af87dfd2608d12a) Better error handling for presto (#2161) (@vera-liu)
- [f5e3d0c](https://github.com/airbnb/superset/commit/f5e3d0cc02628a51178001eecb65eaa6f04ec667) [hotfix] incompatible diamond flask-sqlalchemy version (@mistercrunch)
- [fe377e8](https://github.com/airbnb/superset/commit/fe377e8b9472cc6d16cb2034c2876c758df7ba34) [hotfix] dashboard won't load, error in fields.js (@mistercrunch)
- [5bb8713](https://github.com/airbnb/superset/commit/5bb87138e95a07f604e5b82dbac460b6ece06a40) [hotfix] Trends example slice is broken (@mistercrunch)
- [579e582](https://github.com/airbnb/superset/commit/579e58206e16b53e49fc736569d6d4ab4e234f70) Bumping up some of the python lib deps (@mistercrunch)

### 0.16.0 (2017/02/17 01:48 +00:00)
- [172b6ce](https://github.com/airbnb/superset/commit/172b6ce8920f79a78e19d49197864ac72ea6647a) v0.16.0 (@mistercrunch)
- [0cc8eff](https://github.com/airbnb/superset/commit/0cc8eff1c3f4296bccf495c9deba01eb73b72b83) [WiP] Deprecate Explore v1 (#2064) (@mistercrunch)
- [3b023e5](https://github.com/airbnb/superset/commit/3b023e5eaa7e5a4be7957a2a48a90672d2c65e71) add css to the data object to be saved (#2188) (@ascott)
- [615d8f1](https://github.com/airbnb/superset/commit/615d8f1624d890f6ce0d5bfe7469394a9245759b) Moving branding assets to folder (@mistercrunch)
- [b4409ac](https://github.com/airbnb/superset/commit/b4409ace2171158350ac6243e6b72bce6f89a864) Adding branding assets in the repo (@mistercrunch)
- [dbee6ac](https://github.com/airbnb/superset/commit/dbee6aca1fbe2d48c685b3976acbb8dfff3f0624) use pre-wrap for long lines (#2181) (@ascott)
- [acfe62e](https://github.com/airbnb/superset/commit/acfe62eaf793da4711a90cdb69aa6ec1ea292447) Add command to refresh datasources (#2180) (@bkyryliuk)
- [527a8af](https://github.com/airbnb/superset/commit/527a8af060798c014cde0f9b32d31a2e6540dd57) Return original state for query if query was stopped (#2164) (@vera-liu)
- [a5a931a](https://github.com/airbnb/superset/commit/a5a931a670871a9d6f1db9310512c5a064f005a0) Fix werkzeug instance was created twice in Debug Mode (#2135) (#2136) (@asdf2014)
- [2f05efa](https://github.com/airbnb/superset/commit/2f05efaf121f6bbcd091f88630115a7e006717c4) Set default time range of query search to the past month (#2162) (@vera-liu)
- [83ef8a2](https://github.com/airbnb/superset/commit/83ef8a2e1274ba57f1a64e5e71c94b021da4d933) Add parsing for nested json objects in resultset (#2163) (@vera-liu)
- [c564881](https://github.com/airbnb/superset/commit/c564881867abcda7b8dc354e6e2205371ab0a97c) Implement caching and dynamic data fetching. (#1466) (@bkyryliuk)
- [b16930f](https://github.com/airbnb/superset/commit/b16930f35dbba1a7d5e3a625dfb4a181cc3aa182) Keep order of axis data when storing df (#2092) (@vera-liu)
- [2d910e3](https://github.com/airbnb/superset/commit/2d910e3f07b1e86efba69c6d8e07dbdb5f63ce37) [vis] render line breaks in TableViz (#2118) (@ascott)
- [daa1420](https://github.com/airbnb/superset/commit/daa1420c8ec31a813d836474e3e2b04c4db54ab7) adding tests for #1131 (#1902) (@SalehHindi)
- [cea310e](https://github.com/airbnb/superset/commit/cea310e50b61f3c8c37d86207dd982d35ba19e28) Using the time zone with specific name for querying Druid (#2143) (@asdf2014)
- [fcdd5c6](https://github.com/airbnb/superset/commit/fcdd5c67523a81ffc6db68dbe27d13deb00b6084) [slices axis] fix axis spacing on dashboard and explore slices (#2145) (@ascott)
- [2ace73e](https://github.com/airbnb/superset/commit/2ace73e9a1f1cf1a20eff632d08ea440f5f88607) [sql-lab] make datasource name in visualize flow more descriptive (#2103) (@ascott)
- [80cfb08](https://github.com/airbnb/superset/commit/80cfb08794d3c8d91514f9b7731b057664628cf3) only call drawGraph once (#2132) (@ascott)
- [1edc2b9](https://github.com/airbnb/superset/commit/1edc2b91cf15f669097939c36c6bc8acef5b5913) Fix ExtDeprecationWarning (#2137) (#2138) (@asdf2014)
- [1f58e18](https://github.com/airbnb/superset/commit/1f58e18b6f134e2ad4c6865c6b63b40135889ebc) Some code refactoring (#2139) (@asdf2014)
- [f2bf316](https://github.com/airbnb/superset/commit/f2bf3160583533bd0dc5004f248f81251aa8c57e) Add NUMERIC num_type (#2127) (@auxsvr)
- [9cd38fa](https://github.com/airbnb/superset/commit/9cd38fa1eda63152c27b76c29dd948f29444b686) little code refactor in models.py (#2124) (@asdf2014)
- [edb0111](https://github.com/airbnb/superset/commit/edb0111775a05ed164019246ee3d7764a9fdba67) Increase query limit to 1M, add separate display limit. (#2111) (@bkyryliuk)
- [#2113](https://github.com/airbnb/superset/pull/2113) Merge pull request #2113 from airbnb/byolken/s3_cache_implementation (@airbnb)
- [461e41c](https://github.com/airbnb/superset/commit/461e41cd610d1bff33ac10c6ea5879b498a16f41) Use BytesIO instead of StringIO for python2/3 compatibility
- [7164061](https://github.com/airbnb/superset/commit/716406198e50b04d2f6600c518b01f65ad690748) Clean up imports of cPickle and StringIO
- [68592ae](https://github.com/airbnb/superset/commit/68592aeddfdd88a2cb291533a9e595cff9b5d6d2) Fix StringIO import in results_backends module
- [b927ff6](https://github.com/airbnb/superset/commit/b927ff6eef7e948be1f2a7e828f0d7de9458d2c2) Fix indentation errors in results_backends module
- [ce50e6e](https://github.com/airbnb/superset/commit/ce50e6e4fe2147cdf61288d687d49e174f3b7b1d) Fix python3 cPickle import errors
- [167ed33](https://github.com/airbnb/superset/commit/167ed33bba160f091e613bc2a351ca5ddc7c8189) Fix name of test in results_backends_tests module
- [0ee1abf](https://github.com/airbnb/superset/commit/0ee1abf31a021d2c9e40d9b3c321fce14d4d7179) Misc. fixes in response to code review feedback
- [6a0a1af](https://github.com/airbnb/superset/commit/6a0a1af67ebfc11fde51eb3d77db7b9ac6569c3c) Fix misc. style issues
- [f85481d](https://github.com/airbnb/superset/commit/f85481d51b3481d7e0ee7f9b73991fb5e2b219ef) Fix long lines in superset/results_backends.py
- [00b6b0a](https://github.com/airbnb/superset/commit/00b6b0ac68571df1a7c8e16fd0e79c64cbfe0a60) Misc. style tweaks to S3Cache changes and tests
- [1546b1a](https://github.com/airbnb/superset/commit/1546b1ae716d47dad7c583100dbf73665d88aa3b) Add tests for S3Cache
- [1e94498](https://github.com/airbnb/superset/commit/1e94498d9d548cbea6466a45dafa3b919c65bd1f) Add initial implementation of S3Cache
- [0f7189b](https://github.com/airbnb/superset/commit/0f7189b859f4a782fd43af694012029645f81b44) Do not fail is the filter cannot be parsed. (#2105) (@bkyryliuk)
- [a6e0f1b](https://github.com/airbnb/superset/commit/a6e0f1b75a5b60dbb81288b22d78d9686c3b565c) Add an option to configure celery workers size. (#2085) (@bkyryliuk)
- [543c22b](https://github.com/airbnb/superset/commit/543c22bb508a90741ff770e50670b412a45e1871) [dashboard] fix nvd3 tooltips (#2096) (@ascott)
- [07e067c](https://github.com/airbnb/superset/commit/07e067cf0b8fae39e5e7093914f0fc1795b15f41) Revert "Bump version to 0.15.4.1" (#2095) (@bkyryliuk)
- [6c256a3](https://github.com/airbnb/superset/commit/6c256a34a98a9323f1044b138c458d5c60e0e01f) Bump version to 0.15.4.1 (#2094) (@bkyryliuk)
- [6b2eb04](https://github.com/airbnb/superset/commit/6b2eb04a73a475b1d597076b15bc39c5e0156842) Put back a default count * metric (#2091) (@bkyryliuk)
- [898d80b](https://github.com/airbnb/superset/commit/898d80ba3837b44c00092f9339fc0ba25efc3162) Viz the compiled query rather than user input. (#2086) (@bkyryliuk)
- [ea8e4ad](https://github.com/airbnb/superset/commit/ea8e4ad05b7298db023c3cfb5079dff92a5da1d3) Display all columns if none are specified. (#2077) (@bkyryliuk)
- [27aeac6](https://github.com/airbnb/superset/commit/27aeac6859da39fea0aebc4920c1fce08fde61e5) Remove fetch results button for async queries (#2084) (@vera-liu)
- [8da371e](https://github.com/airbnb/superset/commit/8da371e324e490bec74d80eb84ca040c86dd6765) Make show query button work for v1 (#2080) (@vera-liu)
- [0c59fe9](https://github.com/airbnb/superset/commit/0c59fe933d0012eb63acfa02bb51273327b4e218) Only call topn when having_filters don't exist (#2075) (@vera-liu)
- [e169c67](https://github.com/airbnb/superset/commit/e169c67760b8ef3b0cafa3eebaf17ea662589ea4) [vis] fix axis labels display (#2066) (@ascott)
- [3a5a927](https://github.com/airbnb/superset/commit/3a5a927dc6e43fe095a0b5592505cea09c42f5e4) check if tempTable exists for ctas queries (#2073) (@vera-liu)
- [2d419e4](https://github.com/airbnb/superset/commit/2d419e4253c8a8874c1a913b4193402c3a4e0187) Return alert instead of fetch button when async results has no data (#2072) (@vera-liu)
- [87869a2](https://github.com/airbnb/superset/commit/87869a29c98b3fadbe1d6879437530f5623d774f) Customize tooltip with axis format (#2068) (@vera-liu)
- [544211f](https://github.com/airbnb/superset/commit/544211f5ecbe63958de72bcc014bc4de23f30bb7) Revert "Display no data alert when async result has zero rows" (#2069) (@vera-liu)
- [f6ac95e](https://github.com/airbnb/superset/commit/f6ac95e2dd14eff2ba6c86cc1512a88992e18538) Convert objects to json (#2050) (@bkyryliuk)
- [63bef2f](https://github.com/airbnb/superset/commit/63bef2f8440620407b6dfe9ebadf8305450fce28) [bugfix] only pop slice_id when it exists in url (#2065) (@vera-liu)
- [4a8cd04](https://github.com/airbnb/superset/commit/4a8cd04de6f1fd6aea060ee62968903dc3892fb8) Display no data when async result has zero rows (#2055) (@vera-liu)
- [8580662](https://github.com/airbnb/superset/commit/85806624db3d4651bc9d1b15e32b34c9d644cfdd) Use a key-value store model for sharing long queries (#1951) (@vera-liu)
- [1ac2273](https://github.com/airbnb/superset/commit/1ac22739848fef09b663ca3fbad9bf84eb706211) Reimplement has_access. (#2028) (@bkyryliuk)
- [a8c29c4](https://github.com/airbnb/superset/commit/a8c29c4ffec1bcf631cea0afbb40e95a4817cf07) Change validator of timeshift to allow for strings (#2051) (@vera-liu)
- [31af01c](https://github.com/airbnb/superset/commit/31af01c4f2b54c05a0f4bc66c7fcaaa9fe0b0681) Splitting dev-reqs.txt into requirements for development and docs (dev-reqs-for-docs.txt). Updating CONTRIBUTING.md accordingly (#2049) (@dylburger)
- [b1bba96](https://github.com/airbnb/superset/commit/b1bba96d04b636d77d557ca066e22d3f2bd3289b) Fix csv download. (#2036) (@bkyryliuk)
- [c5c7302](https://github.com/airbnb/superset/commit/c5c730224e6ab89cfbffb26f1c9a1fc0429e2299) Check datasource level perms for downloading csv and fetching results (#2032) (@bkyryliuk)
- [7441cf7](https://github.com/airbnb/superset/commit/7441cf7d39ffcdab4def1c9b098203610a067794) Fix inner query labels for Vertica (#2041) (@0x0ece)
- [45c72d2](https://github.com/airbnb/superset/commit/45c72d25df68dfceb1bcf5d305700c0972d48407) New administrator tutorial (#2046) (@dylburger)
- [3fff631](https://github.com/airbnb/superset/commit/3fff631b32579ed1d3fa5b50349542b83dc62fda) Expanded on documentation section, running through an example of committing a change to the docs end-to-end and describing the process for adding static assets (#2047) (@dylburger)
- [bfa2891](https://github.com/airbnb/superset/commit/bfa2891b23426740836226be31e160f0d6e132ae) models: add real to numeric types (#2044) (@xrmx)
- [5715f52](https://github.com/airbnb/superset/commit/5715f52fef633473d5e7e1d554a7be97c0840fa8) [hotfix] delete DAR when datasource requested does not exist anymore (#2040) (@vera-liu)
- [1f2126f](https://github.com/airbnb/superset/commit/1f2126f4637d6099bb1591f4c7715bd3c4385878) Fix Druid granularity timeZone (#2037) (@0x0ece)
- [27ed0b3](https://github.com/airbnb/superset/commit/27ed0b37bf3291a688124be5687738ecb37fa8b3) Cleanup fulfilled requests after approve (#1953) (@vera-liu)
- [cdbd2f8](https://github.com/airbnb/superset/commit/cdbd2f850706825f16a08afc40682237d6f6d54f) Guess the filter value type (#1978) (@bkyryliuk)
- [e46ba2b](https://github.com/airbnb/superset/commit/e46ba2b4a4f5ccc9f584db0a3c7c1fbaf2b7fdf0) Simplifying the viz interface (#2005) (@mistercrunch)
- [1c338ba](https://github.com/airbnb/superset/commit/1c338ba742108139c3fe5885765633f298734be5) [WIP] [explorev2] Refactor filter into FieldSet (#1981) (@vera-liu)
- [2b7673a](https://github.com/airbnb/superset/commit/2b7673ad5d95f63b3e251f08f6141f82447d0e23) Fixing pypi_push.sh (@mistercrunch)

### 0.15.4 (2017/01/24 19:33 +00:00)
- [2f27353](https://github.com/airbnb/superset/commit/2f27353015e18a1eab8ca415131023e91adf5399) v0.15.4 (@mistercrunch)
- [1b8c3f4](https://github.com/airbnb/superset/commit/1b8c3f420a6f74fa8dd6e5a0762e14d9ba5f7426) avoid  py3 error in setup.py (#2030) (@wyndhblb)
- [a3a0708](https://github.com/airbnb/superset/commit/a3a070855ccea84e75f89389c835772bbde66d10) Use dist instead of src in mapbox (#2027) (@0x0ece)
- [e84c639](https://github.com/airbnb/superset/commit/e84c6393b8658c7e8d9b321c08f0dea33335aa28) Correcting docs to `run npm build` instead of prod (@mistercrunch)

### 0.15.3 (2017/01/24 16:10 +00:00)
- [7413dd9](https://github.com/airbnb/superset/commit/7413dd9f4b99752d064024e764284beabb82a3cc) v0.15.3 (@mistercrunch)
- [9cbd667](https://github.com/airbnb/superset/commit/9cbd667eb7af96cb2cafaf05778906110cf50520) [explore-v2] Fix edit datasource link for druid datasources (#1982) (@ascott)
- [37fb56c](https://github.com/airbnb/superset/commit/37fb56c61ceb339079ff117971fc91bdd678db80) Week beginning Monday time grain for MySQL (#2014) (@alanmcruickshank)
- [404a94c](https://github.com/airbnb/superset/commit/404a94cadbe44a463bda2201b22f268201a7474c) [hotfix] fixing the hotfix (@mistercrunch)
- [0807a8d](https://github.com/airbnb/superset/commit/0807a8d0162ff824151df70e7d045f9179668ac0) [hotfix] load selectors in render (@mistercrunch)
- [4a98881](https://github.com/airbnb/superset/commit/4a9888157ebcd8513c083f381fdb417fc5f700de) Update INTHEWILD.md (#2000) (@silashundt)
- [83fbdcc](https://github.com/airbnb/superset/commit/83fbdcceac0c5ee836345ff6b0fe03b1c2c6d69f) Add Qunar to INTHEWILD (#2001) (@flametest)
- [b070ef5](https://github.com/airbnb/superset/commit/b070ef5fdb2ce61b288362878cfd7622d6e1270c) added Digit to inthewild (#1997) (@robert-digit)
- [7d380dc](https://github.com/airbnb/superset/commit/7d380dcd14939f8100405f9f1551a3e2a74054ce) Adding Clark.de and Yahoo to INTHEWILD (@mistercrunch)
- [a15dbd9](https://github.com/airbnb/superset/commit/a15dbd992d53870280700e6dd15f604bd76aa4fc) Adding Clark.de to INTHEWILD (@mistercrunch)
- [52c5d23](https://github.com/airbnb/superset/commit/52c5d235af43f659a36ddd0baeece95756395f1b) Add analysisTypes to refresh druid (#1983) (@noppanit)
- [495f646](https://github.com/airbnb/superset/commit/495f6460a40f4a2622f52c03f511778c4060b1f5) Add email functionality (#1914) (@bkyryliuk)
- [a96024d](https://github.com/airbnb/superset/commit/a96024d0e7c54e5559205beb4f770db1e0ff85bb) [explorev2] Fields can validate input and handle errors (#1980) (@mistercrunch)
- [99b84d2](https://github.com/airbnb/superset/commit/99b84d29091fcbdd233c91cc239cc6d2cf4b2e74) Reverting CLI changes in #1713 (#1964) (@mistercrunch)
- [24728b8](https://github.com/airbnb/superset/commit/24728b8b47037ba809be95e759dc73ce7a8f73a5) Permissions cleanup: remove none and duplicates. (#1967) (@bkyryliuk)
- [9750e49](https://github.com/airbnb/superset/commit/9750e49df8ff95d9dcbd25bea426eaa1ddcb67bd) Add the missing argument (#1969) (@flametest)
- [bf31783](https://github.com/airbnb/superset/commit/bf31783d0ccc62712800ed3cc7caf63890ba36b5) v0.15.2 (@ascott)

### 0.15.2 (2017/01/13 07:05 +00:00)
- [87eacf8](https://github.com/airbnb/superset/commit/87eacf88c3ee82f6fe3cf79c54672f6c64b7f3fb) fix timestamp error in table view (#1960) (@flametest)
- [1dbfb99](https://github.com/airbnb/superset/commit/1dbfb99ead4be6669752853e58504b0f0eab351d) Leave metrics empty if not specified (#1965) (@vera-liu)
- [ff4020e](https://github.com/airbnb/superset/commit/ff4020ea732de873feb82d94971cadcc5d5c0e74) [explorev2] using label in 'Visualization Type' Select instead of key (#1927) (@mistercrunch)
- [0ce7fc1](https://github.com/airbnb/superset/commit/0ce7fc18a883af3ba9d35a498912fcf49ab1e70c) Adding a way to see the git SHA from the website (#1956) (@mistercrunch)
- [470a6e9](https://github.com/airbnb/superset/commit/470a6e9d768493e7f9671d3cbe436e03ff15f137) [explorev2] adding support for client side validators on controls (#1920) (@mistercrunch)
- [fc74fbe](https://github.com/airbnb/superset/commit/fc74fbeeaa0834f1dcf5f83b25d3b709b1b9fd95) [explore-v2] make control panel sections and fields more dense (#1954) (@ascott)
- [9c6a579](https://github.com/airbnb/superset/commit/9c6a5793b9841686c483f818f9ef1af4cf0b9b73) Fix none view_menues. (#1950) (@bkyryliuk)
- [49b6b38](https://github.com/airbnb/superset/commit/49b6b387410987ef19da36118fc06b4a52d69c85) Pass query instead of slice to Action buttons to prevent lagging query (#1948) (@vera-liu)
- [a385ee9](https://github.com/airbnb/superset/commit/a385ee9e978c1175f95b3704669ab70489469860) Use POST in sqllab_viz instead of url params to avoid error with long queries (#1933) (@vera-liu)
- [f0917c6](https://github.com/airbnb/superset/commit/f0917c62f20e5f1a36e3fa99f155787ff5e54afd) Add a Async Select that fetches options from given endpoint (#1909) (@vera-liu)
- [94d2016](https://github.com/airbnb/superset/commit/94d20168dab4b85fc3f2d2172a2ae899de5aa2ba) Change fields for dual_line to match with new SelectField structure (#1932) (@vera-liu)
- [2d866e3](https://github.com/airbnb/superset/commit/2d866e3ffa9bfedd3b3dad0d3463767aae879a14) [hotfix] fix the logging fix that broke the build (#1940) (@mistercrunch)
- [5d94d70](https://github.com/airbnb/superset/commit/5d94d7067e3cc052f27c736c46a0d74c270ca387) [explore-v2] add edit link below datasource select (#1919) (@ascott)
- [7323f4c](https://github.com/airbnb/superset/commit/7323f4c2ab2eda54e91274a6e9281f0a98160850) Make up the user link string (#1947) (@flametest)
- [eca6dfe](https://github.com/airbnb/superset/commit/eca6dfef6afa05929fa240177e389e6c9a989aaf) switch order of period compare and rolling periods (#1946) (@patrickleotardif)
- [761462e](https://github.com/airbnb/superset/commit/761462ef930fa8ac1094629b403d0ec09bb5c0ab) Revert "#views users for created dashboards on profile page" (#1943) (@vera-liu)
- [98e8325](https://github.com/airbnb/superset/commit/98e83255e6efa18b72b7b17413d55d49ee9213b9) Added extra details around setting up admin user (#1937) (@mobcdi)
- [cbf3562](https://github.com/airbnb/superset/commit/cbf3562a6f4d2edaaf14592c0bee6cab8394108c) Fix double scrollbar in pivot table (UI bug) (#1931) (@SalehHindi)
- [a2c41bb](https://github.com/airbnb/superset/commit/a2c41bbace99eb3e749c59a3b2805c6e8e2b7130) viz: hotfix for saving in cache (#1922) (@xrmx)
- [2a12a3c](https://github.com/airbnb/superset/commit/2a12a3c70267987c4bc3ecfad08aba4a5769fa10) [hotfix] logging is down (@mistercrunch)
- [2ab6a41](https://github.com/airbnb/superset/commit/2ab6a411f4b9fa75bc86b83f4aa4e3707e90e002) Druid dashboard import/export.  (#1930) (@bkyryliuk)
- [14ed10b](https://github.com/airbnb/superset/commit/14ed10bdb0f6868e87c8cf39d770fcc616273e72) Fixing docs generation (@mistercrunch)
- [49e6fd5](https://github.com/airbnb/superset/commit/49e6fd5bfbdb90020bf821f843a7e850e70a4c6b) Revert "Druid dashboard import/export. " (#1923) (@mistercrunch)
- [af872fa](https://github.com/airbnb/superset/commit/af872fa4d4fbafb29bf47418c7c2b6716846f509) Druid dashboard import/export.  (#1811) (@bkyryliuk)
- [cec4cf0](https://github.com/airbnb/superset/commit/cec4cf014c91e5b664cc3dbfba34619388fd492e) #views users for created dashboards on profile page (#1667) (@vera-liu)
- [783ad70](https://github.com/airbnb/superset/commit/783ad703d06a1e3b75c76307174af02d843cda0d) [hotfix] delete ipdb breakpoint (#1917) (@vera-liu)
- [2226716](https://github.com/airbnb/superset/commit/222671675c31bdad9b8e2c8f3a5b814a02d85bee) [exploreV2] mapStateToProps for fields (#1882) (@mistercrunch)
- [9a62d94](https://github.com/airbnb/superset/commit/9a62d9463005631f2d43b57a0d782453db98931e) [sqllab] bugfix visualizing a query with a semi-colon (#1869) (@mistercrunch)
- [c3edc6e](https://github.com/airbnb/superset/commit/c3edc6e24bb55dcf26d29603b624ba513a562232) [WIP] Add dual-axis line chart to viz (#1782) (@vera-liu)
- [119b0c5](https://github.com/airbnb/superset/commit/119b0c55e972d4b4b93ff9df4d7e99d14b9b8453) [explore] fix height in embed mode (#1898) (@mistercrunch)
- [c14c7ed](https://github.com/airbnb/superset/commit/c14c7edc5ee798eb24b53ae65fec9a876fbe1fd9) [explore] show the broken query when failing (#1871) (@mistercrunch)
- [e3b296c](https://github.com/airbnb/superset/commit/e3b296c558dcad4f77b6c82c37ed20903b1699bf) utils: teach our json serializer to handle more types (#1907) (@xrmx)
- [c2d29fb](https://github.com/airbnb/superset/commit/c2d29fb54bbe8e57bdee03f4f4940469b48c2a92) Change ordering of fields when adding a table (#1899) (@mistercrunch)
- [7aab8b0](https://github.com/airbnb/superset/commit/7aab8b0ae3d6816cf861c09193c9e2e166e2d18a) Simplifying the Fields (Controls) interface (#1868) (@mistercrunch)
- [861a3bd](https://github.com/airbnb/superset/commit/861a3bd4ae85da2bb227c3d44a4ff56b9a836caf) docs: 8088 is the default port, no need to specify it (#1861) (@andreamelloncelli)
- [9bc7ad9](https://github.com/airbnb/superset/commit/9bc7ad9cd53b9204a044c5dff16185ca49bd66a4) Do not use persistState for explorev2 (#1894) (@vera-liu)
- [a1e3fc1](https://github.com/airbnb/superset/commit/a1e3fc1c230239c5535573cf708ff0e03d5eaa8a) [explorev2] giving more room for long textboxes (#1881) (@mistercrunch)
- [242869d](https://github.com/airbnb/superset/commit/242869db3aa8eab99558d19f0e99923a78fb9840) [sql lab] only show single run query button (#1858) (@ascott)
- [8924bb7](https://github.com/airbnb/superset/commit/8924bb79e74704632cc4401f0ed1f7134be11a1d) [explorev2] moving the "Time"  section up to 2nd section (#1885) (@mistercrunch)
- [a0d103d](https://github.com/airbnb/superset/commit/a0d103dac33201b55b2587d10d11f293bed0a0e7) Fix small typo (#1888) (@davejm)
- [d52b299](https://github.com/airbnb/superset/commit/d52b299df8812ff4af5fb05ded2c1b3aedaae865) Updating CHANGELOG (@mistercrunch)

### 0.15.1 (2016/12/28 21:29 +00:00)
- [092432f](https://github.com/airbnb/superset/commit/092432f04f0033e60493f009728a7bfd6a744b22) v0.15.1 (@mistercrunch)
- [ea8e663](https://github.com/airbnb/superset/commit/ea8e6634d6c304cde3a42c65d37ec694f76b8cec) read anon user role from config, remove reference to public role (#1878) (@willgroves)
- [3e6f90c](https://github.com/airbnb/superset/commit/3e6f90cf722f205e1f13ef7228be6d0d767c1d1d) Upgrading pydruid version and adopt 'merge' flag during refresh_druid operation (#1879) (@dkhwangbo)
- [1673105](https://github.com/airbnb/superset/commit/16731056edf25cd4422fa674de827215df9027b1) [sqllab] async queries - better error handling (#1853) (@mistercrunch)
- [0712894](https://github.com/airbnb/superset/commit/0712894353825ea2faa19d8000ca031c44debf39) Improving database logging by adding duration, referrer and post data (#1830) (@mistercrunch)
- [36fad80](https://github.com/airbnb/superset/commit/36fad803edf6666188746f270e498e03c2df363c) sqllab: don't hold database deletion because of query reference (#1863) (@xrmx)
- [6732f01](https://github.com/airbnb/superset/commit/6732f01cb7bb08e1b180bb74f263bf50317d7462) Enable freeform-select with fetched column values for filter values (#1697) (@vera-liu)
- [bb04e6f](https://github.com/airbnb/superset/commit/bb04e6fcfa1042b4532b50d8898555813be7fa29) Use APP_ICON in template (#1855) (@szmate1618)
- [007ee88](https://github.com/airbnb/superset/commit/007ee88d33f92e6d052122b35ccad84d176029a7) [explorev2] improving the scrolling/scrollbars placement (#1840) (@mistercrunch)

- [7a5bb94](https://github.com/airbnb/superset/commit/7a5bb947542fdc20e2ec70e18b1cf418b8d1dba8) Stop ChartContainer from rendering twice on chartStatus change (#1828) (@vera-liu)
- [e06a0cd](https://github.com/airbnb/superset/commit/e06a0cd89bc84f3a7e75ee6f03df8c9c3a2badeb) Add force_ctas_schema to query model when enabled (#1825) (@vera-liu)
- [b6cba13](https://github.com/airbnb/superset/commit/b6cba13293101f3022c16e120e96383b59cae03e) [explorev2] enabling redux dev tools (#1842) (@mistercrunch)
- [d929bbf](https://github.com/airbnb/superset/commit/d929bbfe3010f795cdf9ef28b48e9e249cf7ef86) [explorev2] making QueryAndSaveBtns disabled while running queries (#1841) (@mistercrunch)
- [bf67d64](https://github.com/airbnb/superset/commit/bf67d64708834800669e8be30ffa695d7a6db022) [explorev2] making Datasource an Viz controls not clearable (#1845) (@mistercrunch)
- [92aa1a6](https://github.com/airbnb/superset/commit/92aa1a612476fdef5f19eb68f961324a333b346c) Permissions refactoring, optimizations and unit testing. (#1798) (@bkyryliuk)
- [733ab80](https://github.com/airbnb/superset/commit/733ab8014bd83ae4e0e4961b9c454ad238556bd8) [explorev2] using a loader to load the explorev2 specific css (#1843) (@mistercrunch)
- [6aaa49f](https://github.com/airbnb/superset/commit/6aaa49f0bf182f449a970a1e15d86111987dde32) Change default gunicorn address (#1838) (@amancevice)
- [638f27c](https://github.com/airbnb/superset/commit/638f27c2df6540a50d5cba92847bc7000b33cb1b) [sqllab] Fix sql expression bug with count distinct metrics (#1805) (@vera-liu)
- [84a3b55](https://github.com/airbnb/superset/commit/84a3b559128bb7717869f5fa7339bfe1ac4003cc) [explorev2] remove unused file SqlClause.jsx (#1839) (@mistercrunch)
- [552d464](https://github.com/airbnb/superset/commit/552d46479bbf819e4fa7fb811ec05cff104a840c) [explorev2] no bootstrap data, just metadata in exploreV2 (#1827) (@mistercrunch)
- [fa9c066](https://github.com/airbnb/superset/commit/fa9c066ffe6b71a36f97e2e0d9fdb94b94183ca6) Add email-to option in action buttons for dashboard and slice (#1705) (@vera-liu)
- [e1e20b8](https://github.com/airbnb/superset/commit/e1e20b875748f677312d8c5ed3daf87113143b63) Sort searched queries by recency (#1735) (@vera-liu)
- [2fb94a8](https://github.com/airbnb/superset/commit/2fb94a89e2538710c5293404acaf6d8f0ef847ea) Add ADDITIONAL_MIDDLEWARE option to config (#1832) (@jr-minnaar)
- [7a9604a](https://github.com/airbnb/superset/commit/7a9604a3c918ce5fad1010e9e95fbf961a95420d) Workaround for slices "Not Found" issue in IE 11 (#1821) (@rlei)
- [e099088](https://github.com/airbnb/superset/commit/e0990880121643b63f66cc18fe917ea9fbe98554) [hotfix] fixing the build (@mistercrunch)
- [34e107e](https://github.com/airbnb/superset/commit/34e107e7d35b7d48385a13268b2ed713a2808114) [explore-v2] add config option for explore v2 beta users, and send through v2 path (#1671) (@ascott)

### 0.15.0 (2016/12/12 19:30 +00:00)
- [2254a4d](https://github.com/airbnb/superset/commit/2254a4d0b4480da7563c7c3afdeadecf66b08cf5) v0.15.0 (@mistercrunch)
- [9f7486f](https://github.com/airbnb/superset/commit/9f7486f4029fcbc18dfdeaeb4ff3c3c07242ad2b) remove extra call to get_viz in explorev2 (#1812) (@vera-liu)
- [699602d](https://github.com/airbnb/superset/commit/699602d1c5bdd7d15f6adb5f22e458c268bc1306) Add tooltips to RunAsync and CTAS button (#1792) (@vera-liu)
- [2993ff1](https://github.com/airbnb/superset/commit/2993ff1d75ff2391ffab388544f198cbb78364a9) Add NVD3's bullet chart (#1775) (@darabos)
- [afb3c24](https://github.com/airbnb/superset/commit/afb3c24d5a4951e7cc5a5714a79eb201e0b1aa24) Showing more fields in DatabaseView (@mistercrunch)
- [8ef730b](https://github.com/airbnb/superset/commit/8ef730b5feb8e27116552ca863e8dac42b1aa6ec) Added timer to explore v2 and share it with sqllab (#1802) (@vera-liu)
- [866cfe5](https://github.com/airbnb/superset/commit/866cfe52794d5c6df9f85f088243fa85f66eaec7) Add schema name to output column in query history (#1790) (@vera-liu)
- [68c2eab](https://github.com/airbnb/superset/commit/68c2eab6b93a13966b19aae20fb6c82fc34e3bcf) [hotfix] handling 0% change in big number with trendline (#1801) (@mistercrunch)
- [aeda5bd](https://github.com/airbnb/superset/commit/aeda5bd2606946a5cb6fd7dd5ecd4b73413c79a9) [sqllab] config item for SQLLAB_DEFAULT_DBID (#1793) (@mistercrunch)
- [a95cd71](https://github.com/airbnb/superset/commit/a95cd71456a0b24c08d4d020238fd9d89b2c9cd7) Add viz thumbnails to viz_type select (#1794) (@vera-liu)
- [34d0dd9](https://github.com/airbnb/superset/commit/34d0dd9d6e074e41968c39247d66e19fd551c57b) adjust header nav links so they are all aligned on the base line (#1786) (@ascott)
- [401d9af](https://github.com/airbnb/superset/commit/401d9afd54ce46f5c63a821094350098f07823a1) [ui] update logo, favicon, and new primary color (#1781) (@ascott)
- [74edb93](https://github.com/airbnb/superset/commit/74edb936a599ed54528389814ddf83e74f8452fd) [WIP] Add http to copied url and move function to componentWillReceiveProps (#1780) (@vera-liu)
- [c155857](https://github.com/airbnb/superset/commit/c1558578d7c555fb7bb9ee30eb98bad4d28fbd07) [explorev2] Breaking down large files, fixing JS warnings (#1773) (@mistercrunch)

- [3597fdb](https://github.com/airbnb/superset/commit/3597fdb7f869929e0b09ff0144ff430b81e67853) Filter table list based on the user permissions. (#1769) (@bkyryliuk)

- [43f2a37](https://github.com/airbnb/superset/commit/43f2a379a1b88b260d0a4bdeac97b3cb4478afcf) Make cell-click filter in table viz optional (#1762) (@vera-liu)
- [69702e3](https://github.com/airbnb/superset/commit/69702e3a1956ef5587e5aea2bffb3720b9b4cd35) Create users if not found. (#1753) (@bkyryliuk)
- [eb0655c](https://github.com/airbnb/superset/commit/eb0655cf85daad4329cf8630fe99e2a50d0e7e5a) [sqllab] Fixed js error when results are not available (#1715) (@vera-liu)
- [d8864bc](https://github.com/airbnb/superset/commit/d8864bc92b7566fa4ebb9d4863d75bd5eaa1e9c4) Enable overwrite sql in QueryHistory (#1731) (@vera-liu)
- [89fc9d7](https://github.com/airbnb/superset/commit/89fc9d7c80564e2f02949ed33113a63fc1e898e4) Make entire menuitem clickable for copy query (#1747) (@vera-liu)
- [76aa9f7](https://github.com/airbnb/superset/commit/76aa9f7e1047de5e41e8bd5bfee610fcd569b8ad) [explorev2] fix textfield and druid bug (#1732) (@vera-liu)
- [abd0974](https://github.com/airbnb/superset/commit/abd097489738eacc37fcd5dc9605d483c84071f6) Fix superset cli for python3 (#1760) (@xrmx)
- [c4e943a](https://github.com/airbnb/superset/commit/c4e943a24fe89824e59a105d6ce6e5d9255717c1) [sqllab] making 'click to retrieve results' a button (#1737) (@mistercrunch)
- [a3106bc](https://github.com/airbnb/superset/commit/a3106bcb3d0bc6fb0e5df2c356d453563a07c8a2) [bugfix] bignumber comparison wrong with neg values (#1743) (@mistercrunch)
- [b045075](https://github.com/airbnb/superset/commit/b045075a96232f1e2f2e14bdaa171eba67b0fa29) Sankey Tooltip fix (#1748) (#1750) (@ddol)
- [09d597f](https://github.com/airbnb/superset/commit/09d597f3adf4b238dc2a43b802fdda22b451dfe5) Prevent duplicated view_menu perms (#1751) (@bkyryliuk)
- [9d4c3d8](https://github.com/airbnb/superset/commit/9d4c3d83d0907925f1f37cbe48c5decd2c54639f) Update role based on usernames not emails. (#1749) (@bkyryliuk)
- [95580a0](https://github.com/airbnb/superset/commit/95580a004fe3322ff1c623ac4eec72150e1355b5) [explorev2] cosmetic, smaller size for input text (#1746) (@mistercrunch)
- [723f907](https://github.com/airbnb/superset/commit/723f90755e89e46287e212b18844c9f7abc6cf60) Fixing the sourcemap in dev mode (#1744) (@mistercrunch)
- [324205f](https://github.com/airbnb/superset/commit/324205f77ac7a77b6546da482979842d58ce9fbb) [sqllab] bugfix where a query has the same alias twice as output (#1734) (@mistercrunch)
- [0a40d8c](https://github.com/airbnb/superset/commit/0a40d8ce8f08ba6edc18370032aa85571495b570) Rremove unused symlinks (#1736) (@yolken)
- [168a252](https://github.com/airbnb/superset/commit/168a25239e712fe9eccf676f26df75fd91bd126f) State that npm should be between 3.9 and 4 (@bkyryliuk)
- [7eef46e](https://github.com/airbnb/superset/commit/7eef46e9413b01ec15be515567a9619c695d5501) Adding links pointing to the new user profile page (#1704) (@mistercrunch)
- [50da4f8](https://github.com/airbnb/superset/commit/50da4f8c0708f91ff24c0abd7189a137a1415bf6) Support running superset via pex (#1713) (@yolken)
- [2d0ebea](https://github.com/airbnb/superset/commit/2d0ebeae1bfd5e385000c9aa952891cf474821c6) [explorev2] Make chart container more responsive (#1724) (@vera-liu)
- [1a16491](https://github.com/airbnb/superset/commit/1a164919715d6eaf1a999b97daaa53acb94a827d) Display full table name (schema + name) if possible. (#1728) (@bkyryliuk)
- [7f4f250](https://github.com/airbnb/superset/commit/7f4f25097046dac9b436ef87f041debe2713827a) Redirects to login page if user not logged in at welcome page (#1723) (@vera-liu)
- [25acb78](https://github.com/airbnb/superset/commit/25acb78071acc2eec8b44cb7019f269c1b2a6deb) Pass schema to the select star query. (#1714) (@bkyryliuk)
- [e822d5a](https://github.com/airbnb/superset/commit/e822d5a1b7eb8f0cabcfcc85f5201df8199db796) Make edit / add / delete perms available to all users. (#1722) (@bkyryliuk)
- [32fc0ff](https://github.com/airbnb/superset/commit/32fc0ff6d0b437766d16db128a7b1d40a09080bb) [Bugfix] autocomplete in sqleditor doesnot use newly loaded table columns (#1712) (@vera-liu)

### 0.14.1 (2016/11/29 23:57 +00:00)
- [94dde07](https://github.com/airbnb/superset/commit/94dde075b3eab41797725e1e02c7f87b6b45471a) v0.14.1 (@mistercrunch)
- [65e9232](https://github.com/airbnb/superset/commit/65e92327abdd0d521a9dcb65319165b163da356c) Druid hotfix. (#1710) (@bkyryliuk)
- [0be02e6](https://github.com/airbnb/superset/commit/0be02e67a554d323efe4ed119a59bba53c559477) Updating CHANGELOG 0.14.0 (@mistercrunch)
- [7327c97](https://github.com/airbnb/superset/commit/7327c97e4c5efcf7c5b080a1e534d7b44129bb8b) v0.14.0 (@mistercrunch)

### 0.14.0 (2016/11/29 23:03 +00:00)
- [03b21dc](https://github.com/airbnb/superset/commit/03b21dcf0a3fc18e1290f7770004d3b74df8cef3) [explorev2] Bug fixes in Save Modal (#1707) (@vera-liu)
- [dc98c67](https://github.com/airbnb/superset/commit/dc98c6739fcccc8edc60ef7e761cb1491005f644) Implement table name extraction. (#1598) (@bkyryliuk)
- [fcb8707](https://github.com/airbnb/superset/commit/fcb870728db69bbee092d20c3f78cb7785fe2e61) Add per schema permissions. (#1698) (@bkyryliuk)
- [7919428](https://github.com/airbnb/superset/commit/7919428a1e02457a50ae00439e827f996403f71c) Vliu explorev2 bugs (#1701) (@vera-liu)
- [3496a80](https://github.com/airbnb/superset/commit/3496a80f5a85a0b66e59ec259ed13ca9ba3d5ba0) make stack trace more readable (#1672) (@ascott)
- [56b917a](https://github.com/airbnb/superset/commit/56b917a5c206d3083d9d9d3d0606b976c64b6044) [explore-v2] fix errors on table view (#1675) (@ascott)
- [18c43aa](https://github.com/airbnb/superset/commit/18c43aaea2f889e50211b22f0a68269f314bcafa) make chart title larger, fix explore actions btn spacing (#1680) (@ascott)
- [c43fc38](https://github.com/airbnb/superset/commit/c43fc38f69d6284729cd47368e796117adcc1d1b) [druid] fix having clause (#1694) (@mistercrunch)
- [c07f0ab](https://github.com/airbnb/superset/commit/c07f0ab9c72430f5892f701d6cba35718ef322ad) Config programmatic roles in the config.py (#1664) (@bkyryliuk)
- [1c429b2](https://github.com/airbnb/superset/commit/1c429b27bc425aa8ba0f8cc6b43887cfb91dcd15) Fixing issue #1689 (#1696) (@mistercrunch)
- [b7019ad](https://github.com/airbnb/superset/commit/b7019ad4f343ecbd5d33ce4a5800a72a9f4301b6) [sqllab] bugfix SouthPane doesn't update as expected (#1699) (@mistercrunch)
- [84e8f74](https://github.com/airbnb/superset/commit/84e8f741ae969888c4f2501ada132f58bdcfb249) Add 'Save As' feature for dashboards (#1669) (@the-dcruz)
- [e3a9b39](https://github.com/airbnb/superset/commit/e3a9b393c26ab173fe3ffe3dd14191705cab7119) Missing merge_perm function. Fixes 1691. (#1692) (@niconoe)
- [16aba51](https://github.com/airbnb/superset/commit/16aba517e4640300c9a71f6186776671540bc488) Use smaller size for node max_old_space_size (#1679) (@xrmx)
- [205928e](https://github.com/airbnb/superset/commit/205928e6df892060cdd3ffe0af6a1217a848f301) docs: fix python-redis link markup (#1683) (@xrmx)
- [39ce4aa](https://github.com/airbnb/superset/commit/39ce4aa049fffef3b9f6e368d64130ae85cb86d8) Added filter in ControlPanelsContainer for explore V2 (#1647) (@vera-liu)
- [cef4a82](https://github.com/airbnb/superset/commit/cef4a8296a6a9d46503dd63e268be3a35e9e8e91) [sqllab] adding a sql preprocessor for Presto (#1670) (@mistercrunch)
- [b370ef0](https://github.com/airbnb/superset/commit/b370ef0229377c6b85f78d9ba080d00ff6dba58e) Rerender chart without clicking query button for fields (#1658) (@vera-liu)
- [6b80f5b](https://github.com/airbnb/superset/commit/6b80f5bb35e497c79fe458b25ba87266e3c0f3bf) Get sections to render when switching datasource (#1660) (@vera-liu)
- [bdae570](https://github.com/airbnb/superset/commit/bdae570a69cd948987b05fed2e7653a221ef0d80) Temperary fix of a slice bug (#1648) (@vera-liu)
- [face524](https://github.com/airbnb/superset/commit/face5245a99d13089b9fa4cfa7521ee2ca6b209c) Make explore container resize with browser window (#1608) (@vera-liu)
- [db1ed2a](https://github.com/airbnb/superset/commit/db1ed2a765d317e55377f2550f169b78f981b4a0) Calculate height dynamically using jquery for scrollable sqllab  (#1611) (@vera-liu)
- [10982de](https://github.com/airbnb/superset/commit/10982dec3c69f1bed709b38616417eada995d2f4) Make QueryTable scrollable in Query Search page (#1656) (@vera-liu)
- [6825e75](https://github.com/airbnb/superset/commit/6825e75681b1249d066d9fa0bf0dca9f1824bb24) Fixed bug with querylink passing sql object instead of string (#1659) (@vera-liu)
- [bd6a439](https://github.com/airbnb/superset/commit/bd6a439e0b2a3a76f8aece91f11a7eee2ebf6d29) [QuerySearch] Add loading status to QuerySearch page (#1657) (@vera-liu)
- [c90dd49](https://github.com/airbnb/superset/commit/c90dd4902f18bb11c46bc38b8f70bfc14cfc2171) Programatically sync the role with user list. (#1619) (@bkyryliuk)
- [868e5c4](https://github.com/airbnb/superset/commit/868e5c45fed8e090750dffe88660f3943f373c19) Redirect URL requests with "caravel" to "superset" (#1651) (@kingo55)
- [7e1852e](https://github.com/airbnb/superset/commit/7e1852ee883628d38b2e3bb71e2b2b03fad41ba3) User profile pages (favorites, created content, recent activity, security & access) (#1615) (@mistercrunch)
- [5ae98bc](https://github.com/airbnb/superset/commit/5ae98bc7c9b432683d03d30a30631a6efd7a78a3) Improving jinja2 security by using SandboxedEnvironment (#1632) (@mistercrunch)
- [1624e7d](https://github.com/airbnb/superset/commit/1624e7de7dd50f1c4f5fdd9153adac4ba5b983d2) Add all_tables endpoint to allow airpal / superset perm sync. (#1614) (@bkyryliuk)
- [7a98f84](https://github.com/airbnb/superset/commit/7a98f848909ca2099e29d3f485fd299037142e65) Admin / Alpha permission cleanup and fixes. (#1645) (@bkyryliuk)
- [9b18128](https://github.com/airbnb/superset/commit/9b181280d44171cb0c724a07f50488eb08f98e72) include jQuery and bootstrap (#1642) (@ascott)
- [38e94b9](https://github.com/airbnb/superset/commit/38e94b9e43f82c682f311fe1563c8f502ae4157a) Save modal component for explore v2 (#1612) (@vera-liu)
- [dc25bc6](https://github.com/airbnb/superset/commit/dc25bc6f4d5eeb74665dd353bafda5d97ef5faa1) Fix alpha permission checks. (#1641) (@bkyryliuk)
- [f64a205](https://github.com/airbnb/superset/commit/f64a2056038e96883e31419df5fcd4fa396dffb6) Use Alert for visualization error (#1639) (@vera-liu)
- [a8480f5](https://github.com/airbnb/superset/commit/a8480f54922775992a28edd7878b1cfa7690264e) Added Alert for ControlPanel and ChartContainer (#1626) (@vera-liu)
- [0acf26b](https://github.com/airbnb/superset/commit/0acf26b37c7a59cb976cf7a929caf7cc5a1a968e) Fixed a bug with switching viz_type in exploreV2 (#1631) (@vera-liu)
- [2c068a1](https://github.com/airbnb/superset/commit/2c068a1a1583fa61db2f1797b0fcb2618cd6dbe3) increase space between fieldsset rows (#1629) (@ascott)
- [b961c95](https://github.com/airbnb/superset/commit/b961c95121e5e4d4342a2926746dbf8a62bd77ea) dim visualization during refresh (#1636) (@mistercrunch)
- [8269321](https://github.com/airbnb/superset/commit/82693211f0545affbdc306561a1abb4478c2de9a) Update faq.rst (#1637) (@dodysw)
- [e546746](https://github.com/airbnb/superset/commit/e5467462cb73630a9b487891845ab1f01245f2a8) Make nvd3 refresh smoother. (#1618) (@the-dcruz)
- [ab5a410](https://github.com/airbnb/superset/commit/ab5a4102cd8921ca2df234bfa6133973ba83a425) [dashboard] give user feedback when there are unsaved changes (#1633) (@ascott)
- [d5ef937](https://github.com/airbnb/superset/commit/d5ef937b315f4afc679349369b4e7ac7455748f0) Fixed bugs with viz in exploreV2 (#1609) (@vera-liu)
- [bce02e3](https://github.com/airbnb/superset/commit/bce02e3f518237c03273e3ed4d9d1a13d9f8f6a9) [security] improving the security scheme (#1587) (@mistercrunch)
- [aad9744](https://github.com/airbnb/superset/commit/aad9744d85b50721d55d5770aad70ba1ee397ede) add new screenshots (#1589) (@ascott)
- [506b781](https://github.com/airbnb/superset/commit/506b781f3a6048b433c12d25c1dbce614b5bd31b) [explore-v2] add fave star and edit button to chart header (#1623) (@ascott)
- [267fd5b](https://github.com/airbnb/superset/commit/267fd5b9bc4f21a55c4664ae8c3ee717cc1be82c) [table viz] adding support for pagination (#1616) (@mistercrunch)
- [c362f28](https://github.com/airbnb/superset/commit/c362f2869e012a4eeb9b76ff654ee3e82a190979) More Dashboard UX unit tests (#1603) (@mistercrunch)
- [4f7f437](https://github.com/airbnb/superset/commit/4f7f43752798f57daa8cd8b8ed8a9cbc9c948000) Vliu put datasource in store (#1610) (@vera-liu)
- [ab5da5b](https://github.com/airbnb/superset/commit/ab5da5ba2811ac6c2350c7d0534dd209906318af) [table viz] allow sorting on any column (#1601) (@mistercrunch)
- [7531bb8](https://github.com/airbnb/superset/commit/7531bb89429547fb541c36fe365791cd742d82a1) Fixed dashboard controls for standalone bug (#1617) (@vera-liu)
- [811ee8c](https://github.com/airbnb/superset/commit/811ee8ccdc76a2630a4c8014df26558391b981fe) Deleted unused components in exploreV2 (#1613) (@vera-liu)
- [51cb485](https://github.com/airbnb/superset/commit/51cb485ce3e8cb80c72ec8c732281a78441396fd) Add standalone to reactified dashboard page (#1596) (@vera-liu)
- [83d08b8](https://github.com/airbnb/superset/commit/83d08b8b8f7c73cbf4de25cadeab93dd3fdfc2fc) Get query button working in explorev2 (#1581) (@vera-liu)
- [ed3d44d](https://github.com/airbnb/superset/commit/ed3d44d5919fc2ba739cf8d82e75e2680630646d) Changelog entries for 0.13.2 (@mistercrunch)


### 0.13.2 (2016/11/16 00:23 +00:00)
- [895fe23](https://github.com/airbnb/superset/commit/895fe23203a85a4590f84625507849ce63d69f30) v0.13.2 (@mistercrunch)
- [af04a56](https://github.com/airbnb/superset/commit/af04a560c887ecbcee40b53c358ee9c2ad2f44ad) Moved check to the correct place. (#1606) (@edevil)
- [9124a17](https://github.com/airbnb/superset/commit/9124a17e864b8b2eb109af33fe1b8aad809069da) Removing ascii_art.p from code coverage analysis (@mistercrunch)
- [99b0d4c](https://github.com/airbnb/superset/commit/99b0d4c111b66f6da0eb9991b54b375e2fbeecc4) Fix MySql time grain issue (#1590) (@mistercrunch)
- [84b98c2](https://github.com/airbnb/superset/commit/84b98c234f852550ecf536e4a6e7ce2d7ebc5df6) Adding Greenplum to supported dbs (@mistercrunch)
- [bcc1428](https://github.com/airbnb/superset/commit/bcc1428ebf1cf7e83c93e351858bee3cfbb2e9c2) Updating CODECLIMATE_REPO_TOKEN to new location (@mistercrunch)
- [2133056](https://github.com/airbnb/superset/commit/2133056c04d20807ea0c503d0fed235ee20e94bb) Added different Select Fields (#1583) (@vera-liu)
- [4155a9d](https://github.com/airbnb/superset/commit/4155a9d7f996d09ebdfc8df0db3dcbe9ccf9b529) Removing broken link to old docker image (#1591) (@kingo55)
- [ed48255](https://github.com/airbnb/superset/commit/ed4825523ca54309272f044826f383c2606456a1) Fixed a bug with new dashboard (#1585) (@vera-liu)
- [fdbb2bb](https://github.com/airbnb/superset/commit/fdbb2bbdab5e5dbb2f3496b67eb227dc3dc5f2a7) fixing the build (@mistercrunch)
- [c064d6d](https://github.com/airbnb/superset/commit/c064d6d8475b07a63a3b5ca7b4dbd248a437f6ed) Correct part_fields variable name (#1586) (@geraneum)
- [d33874b](https://github.com/airbnb/superset/commit/d33874bd3d9ffffca7f4726a29c3eb9de2a68d42) [hotfix] postgres issue when slice_id is missing (@mistercrunch)
- [96d32dd](https://github.com/airbnb/superset/commit/96d32dd11f29afa3590b79d8683aaddd05f48a02) Improve Druid metadata fetching resilience (#1584) (@mistercrunch)
- [d6bc354](https://github.com/airbnb/superset/commit/d6bc354ff3e2f24aeb459dbc1413371f2b072306) [hotfix] fix support for presto DATE and TIMESTAMP type (@mistercrunch)
- [7325a4f](https://github.com/airbnb/superset/commit/7325a4fb4ba08f554454534fe9efe3d0eea5a6ce) [hotfix] table view not group by without orderby fails (@mistercrunch)
- [90f00c5](https://github.com/airbnb/superset/commit/90f00c5b292ff83802d35bac49a26e6b257de409) Minor documentation touchups (@mistercrunch)

### 0.13.1 (2016/11/10 18:01 +00:00)
- [8539c42](https://github.com/airbnb/superset/commit/8539c423ea61d84e8e0a81317275713103f99a8a) v0.13.1 (@mistercrunch)
- [e9bfbfc](https://github.com/airbnb/superset/commit/e9bfbfce84b5ab851c839c70adf5298b2538e9dc) Removing boat pic from README (@mistercrunch)
- [6e4f066](https://github.com/airbnb/superset/commit/6e4f0664cb49d5e7144dadba7ccda548cf58e905) [hotfix] lint (@mistercrunch)
- [3c920c9](https://github.com/airbnb/superset/commit/3c920c9d943540cc8ed0d6e3dfd2ae0eba3acb70) [hotfix] datatables import issues (@mistercrunch)
- [15b67b2](https://github.com/airbnb/superset/commit/15b67b2c6c3c2982f6620fce5d30bd05951458f7) [WiP] rename project from Caravel to Superset (#1576) (@mistercrunch)

### 0.13.0 (2016/11/10 05:37 +00:00)
- [973537f](https://github.com/airbnb/superset/commit/973537fd9a60766a6ee99bd2e7080aa7db21f540) [hotfix] resizing widgets (@mistercrunch)
- [d70a744](https://github.com/airbnb/superset/commit/d70a74479df87908de7a7b4df7c24c6b267bf9e3) Make Sqllab a one-page app -- body not scrollable (#1551) (@vera-liu)
- [946e4b7](https://github.com/airbnb/superset/commit/946e4b750afeebbfa16e6ce7e9fc61575136b237) Reactifying the dashboard (#1572) (@mistercrunch)
- [9789e3f](https://github.com/airbnb/superset/commit/9789e3fb9b658e1f38080915132ae43c541e68e9) Bind data preview tabs to sql editor (#1573) (@vera-liu)
- [6a15679](https://github.com/airbnb/superset/commit/6a15679d876c5c76d177b624a5d69da80ac75a3f) [hotfix] encode csv to utf-8 (@mistercrunch)
- [ad1cd55](https://github.com/airbnb/superset/commit/ad1cd5577c231e4100f5a214fe7a4d372de96a04) Pass values from global store to fields in exploreV2 (#1561) (@vera-liu)
- [55668ca](https://github.com/airbnb/superset/commit/55668ca6217f52924288f3849a0aa54c28d40ce1) Link to database-urls in databaseadd view (#1480) (@dirkkelly)
- [0c221a2](https://github.com/airbnb/superset/commit/0c221a28d10abc8cf4e929e50fd788a56136a9cf) add slice_name and table_name for title (#1567) (@ascott)
- [a475551](https://github.com/airbnb/superset/commit/a475551b23d5830ab2945f615328f31d48df36ca) [sqllab] bind alt+enter shortcut in AceEditor to run a query (#1554) (@mistercrunch)
- [bad7676](https://github.com/airbnb/superset/commit/bad7676414662b28a4b72eb680fbf42a5c6281a5) Bump cryptography dependency to 1.5.3 (#1569) (@xrmx)

- [51c0470](https://github.com/airbnb/superset/commit/51c0470f0be438312e90f2efb1f2e37291a30ce4) [explore v2] populate dynamic select field options (#1543) (@ascott)
- [4530047](https://github.com/airbnb/superset/commit/4530047c769ba6d5953ef1547b8507c62f657942) Added action buttons to Chart Container of explore V2 (#1562) (@vera-liu)
- [1bf83c3](https://github.com/airbnb/superset/commit/1bf83c3bf78de422df1b21c3049d106b1cb29385) [explore-v2] render columns based on length of fieldSets array (#1559) (@ascott)
- [bb6ab11](https://github.com/airbnb/superset/commit/bb6ab110013f2e29933fb9a70d6891d4486eb49d) Vliu link form data explore v2 (#1540) (@vera-liu)
- [e4bd188](https://github.com/airbnb/superset/commit/e4bd1884d34a1949b986410ebc385b75945afff8) [druid] adding support for dimensionspecs (#1545) (@mistercrunch)
- [4014a48](https://github.com/airbnb/superset/commit/4014a48f7df9fe166c77132f3d8d83cf615ac176) Added cache prop to ResultSet (#1552) (@vera-liu)
- [97ded32](https://github.com/airbnb/superset/commit/97ded32415e9e32ba2c6a7e4556a0ed96034244a) Update linting instructions. (#1478) (@pinkythalli97)
- [593ac08](https://github.com/airbnb/superset/commit/593ac081f06af5e95dc784597473d42aea52cf28) Added scroll bar and option to collapse for Sql Editor tool bar (#1532) (@vera-liu)
- [69f0a4e](https://github.com/airbnb/superset/commit/69f0a4e1cb2c7775617a15a5ba709836a568210c) Put data preview in south pane (#1486) (@vera-liu)
- [757e7de](https://github.com/airbnb/superset/commit/757e7de60cf7aa04f15160942ceaadb46daa15b5) add oracle time_grains (#1544) (@gschrader)
- [1d7d546](https://github.com/airbnb/superset/commit/1d7d5469a925690d4b4fd1e7a3cdf37779acffb6) [hotfix] remove failing Druid test (@mistercrunch)
- [98afc3e](https://github.com/airbnb/superset/commit/98afc3e590ef25d08fecf159bf4411ac292e95f0) Added setFilter(), containerID and getFilter() to (#1360) (@vera-liu)
- [ea18979](https://github.com/airbnb/superset/commit/ea189790f160dc6419ac97d8f6740afa62ba6e78) [hotfix] druid dist_bar viz issues with non-str x values (@mistercrunch)
- [6298707](https://github.com/airbnb/superset/commit/62987077fa31ebbedafbaa745b36527b7df0c9f7) Read the user origin specification. (#1541) (@bkyryliuk)
- [3b9f7cb](https://github.com/airbnb/superset/commit/3b9f7cb3f1d0dd1387d01204259b5ce7f2469793) [hotfix] groupby may be a set (@mistercrunch)
- [5882c7e](https://github.com/airbnb/superset/commit/5882c7e3447a06875e63b4424994a0a5e5fc58a5) Added jquery methods to ChartContainer to get world_map viz working in exploreV2 (#1443) (@vera-liu)
- [77b6e2c](https://github.com/airbnb/superset/commit/77b6e2cd2e796d063dbc6d42934143bf45bba8b0) Get pivot table working in explore v2 (#1432) (@vera-liu)
- [88b1f95](https://github.com/airbnb/superset/commit/88b1f956c7cd8bd457d04648447fb23700b859ae) [explore-v2] handle field overrides (#1535) (@ascott)
- [d9b49ca](https://github.com/airbnb/superset/commit/d9b49ca2bc1eab3221fc329d0ab5a9b421746110) [exploreV2] remove /exploreV2 endpoint, add v2 bootstrap data to /explore endpoint (#1536) (@ascott)
- [4156ad5](https://github.com/airbnb/superset/commit/4156ad5a3054f5194ea94b6fc146e53e4ccb0b57) [explore-v2] control panel fixes (#1529) (@ascott)
- [ae46561](https://github.com/airbnb/superset/commit/ae465616482c8e76634728bcd6990fcfb3b752ad) Support week_ending_saturday for Druid. (#1491) (@bkyryliuk)
- [1700a80](https://github.com/airbnb/superset/commit/1700a807e9a8ebc4cfb2749293308be733e42473) [sqllab] templating refactor (#1504) (@mistercrunch)
- [0bab15b](https://github.com/airbnb/superset/commit/0bab15b2132ae769ce81519f2d27858ad6d0b187) Update INTHEWILD.md (#1526) (@shashanksingh)
- [38d3075](https://github.com/airbnb/superset/commit/38d307555487d84b60dd6169006bbb6aa9fc87a5) [explore V2] render all control panels and fields dynamically for each vis type (#1493) (@ascott)
- [1b124bf](https://github.com/airbnb/superset/commit/1b124bfb87862a25a7b904e05929c23f0c61d0e2) [druid] optimize Druid queries where possible (#1517) (@mistercrunch)
- [cdf4dd0](https://github.com/airbnb/superset/commit/cdf4dd03024cff40f17845ab9b57ae6a6070e197) Add yearly and quarterly granularities to mysql engine backend (#1518) (@plumbeo)
- [a13bed2](https://github.com/airbnb/superset/commit/a13bed2db685a9fa913676bd71b570c81a190c6e) Moved sqllab tests from core_tests to sqllab_tests (#1502) (@vera-liu)
- [26318f9](https://github.com/airbnb/superset/commit/26318f94fef888a4b54a022bbbd44f269cfbf9b3) Moved queriesArray from render() to local state (#1505) (@vera-liu)
- [769fb08](https://github.com/airbnb/superset/commit/769fb0820fbefd1e58ced40fa79d2d7c923091e4) Strip sql and remove ; for csv download. (#1508) (@bkyryliuk)
- [5238053](https://github.com/airbnb/superset/commit/52380534f360cbb0e3d7ab46889066cd2df47440) Moved ajax call for fetching table metadata from SqlEditorLeftBar to actions (#1494) (@vera-liu)
- [2fd2526](https://github.com/airbnb/superset/commit/2fd252604689693c957a1b6875a18872a59d5ec8) Add support for jinja templates in WHERE/HAVING clauses (#1442) (@mistercrunch)
- [61509bb](https://github.com/airbnb/superset/commit/61509bbd446bbcc21f4f79229c88d82441d1fb98) [sqllab] surfacing more table metadata (indices, pk, fks) (#1485) (@mistercrunch)
- [76499af](https://github.com/airbnb/superset/commit/76499afd8d28289cac0cf0f2d7316e6e64bab089) [pep8] allowing 90 chars per line (@mistercrunch)
- [4023f32](https://github.com/airbnb/superset/commit/4023f328f7893fbe4b0e0af1612d598e1c931f72) [sqllab] run only the part of the query that is selected (#1479) (@mistercrunch)
- [4f49cb5](https://github.com/airbnb/superset/commit/4f49cb555be68c5e1daed817d1137fbd1c3f4e3f) Celery uses separate db engine with NullPool. (#1492) (@bkyryliuk)
- [4dc959a](https://github.com/airbnb/superset/commit/4dc959a3e4464ed38d4b5e580ae1fc009178e185) Revert "NullPool for the celery worker." (#1488) (@bkyryliuk)
- [518fbf5](https://github.com/airbnb/superset/commit/518fbf562cca638cf14d97dfae92756091630eb2) Minor Fixes (#1484) (@ronbak)
- [49828d3](https://github.com/airbnb/superset/commit/49828d3d9d51c02b13ce916a85cfe912bee43c54) add step to pypi build/push (@mistercrunch)
- [248e6a7](https://github.com/airbnb/superset/commit/248e6a7b05fd4ef30c4f2c006d0df935da84e052) fix name for postgresql (#1482) (@willgroves)
- [5561e6b](https://github.com/airbnb/superset/commit/5561e6b77086ffafb58c363a22e97a5800590e47) Fix celery module import in comments. (#1474) (@bkyryliuk)
- [ab083b8](https://github.com/airbnb/superset/commit/ab083b86f35c6f01dfa16bf84c8c212bf21743cf) [sqllab] slide animations when adding/removing/toggling TableElement (#1472) (@mistercrunch)
- [4bf5252](https://github.com/airbnb/superset/commit/4bf525222a609320acc28232f25b7651c54cfda0) [sqllab] add autocomplete to AceEditor for table and column names (#1475) (@mistercrunch)
- [45efcb3](https://github.com/airbnb/superset/commit/45efcb381c0d0b53b9de72a3437ec980b201bab0) Added time filter to query search page (#1329) (@vera-liu)
- [07a7736](https://github.com/airbnb/superset/commit/07a7736c71050c20dc04661ab3f1d21f58cb3b39) NullPool for the celery worker. (#1465) (@bkyryliuk)
- [d2826ab](https://github.com/airbnb/superset/commit/d2826ab7af4da1b36816150b71002ed966c553cd) Added checkbox in dist_bar viz to enable sorting of bars based on x axis labels (#1379) (@vera-liu)
- [6ab769f](https://github.com/airbnb/superset/commit/6ab769f38227788fbffb1eadb0e43c656f7c1da0) CHANGELOG for 0.12.0 (@mistercrunch)

### 0.12.0 (2016/10/28 16:40 +00:00)
- [3e1cd2b](https://github.com/apache/superset/commit/3e1cd2bdcabce219dc01c6ce7b80850ecd50f9ba) v0.12.0 (@mistercrunch)
- [22784b7](https://github.com/apache/superset/commit/22784b7f069d59e3fa7df03cfea84df9e147af13) run_specific_test: take the test as parameter (#1469) (@xrmx)
- [c492261](https://github.com/apache/superset/commit/c4922615eb707228cdc1badd49bf2d293c74a699) [sqllab] add column sort feature to TableElement (#1467) (@mistercrunch)
- [7307dda](https://github.com/apache/superset/commit/7307ddad3c9b60ec2178286cbc27a302e158de83) Highlight affected slices for filter change in dashboard view (#1439) (@vera-liu)
- [c7ba143](https://github.com/apache/superset/commit/c7ba143d039aff61302017329860cd3db432b0f6) Fix typo in sqllab docs (@mistercrunch)
- [b242063](https://github.com/apache/superset/commit/b24206387b09946df40a834db2d3b1deae21f865) [sqllab] optimizing React (#1438) (@mistercrunch)
- [64d1964](https://github.com/apache/superset/commit/64d196442fcd17f098ba6d71da8bad1f84bdbb5a) Added dashboard standalone page (#1429) (@vera-liu)
- [5944643](https://github.com/apache/superset/commit/5944643da67acb1ec38ed8d52f9ae6f58d7549ac) [sqllab] add support for Jinja templating (#1426) (@mistercrunch)
- [8c5e495](https://github.com/apache/superset/commit/8c5e4952727d7ff6e96e61c1a38de2e600b02208) Add github issue template (#1436) (@xrmx)
- [bb23685](https://github.com/apache/superset/commit/bb23685b9db623be89714153361ee3b03b46a39d) Added average metric AVG() to default metrics (#1413) (@vera-liu)
- [940659b](https://github.com/apache/superset/commit/940659bc14ed276a68478b66055356cf3b48ba29) [sqllab] some frontend tests (#1400) (@mistercrunch)
- [7c59337](https://github.com/apache/superset/commit/7c5933732bcb199e486ac8c4bf7ecec71013117d) Filter immune slices array stores strings. (#1402) (@bkyryliuk)
- [89df2fc](https://github.com/apache/superset/commit/89df2fcf76bdaca34dfef19a9d5bb752a9859c6d) Adjusted top margin of heatmap plot to get it working in V2 (#1361) (@vera-liu)
- [174a199](https://github.com/apache/superset/commit/174a199c30ad6c24505092975b814688e8a37292) [hotfix] Query search is unreachable (@mistercrunch)
- [6f1e7c3](https://github.com/apache/superset/commit/6f1e7c3016b53cf8d3c0e28dba3538861fe56086) Added url shortner for sharing query link (#1314) (@vera-liu)
- [9f81e23](https://github.com/apache/superset/commit/9f81e23f8f0698c94a9f4c34b49cbf3dda1e2e87) Fixed css class not being used by slice container (#1359) (@vera-liu)
- [19fab6e](https://github.com/apache/superset/commit/19fab6eea71bbd97974a0ef8dd74451011f3862f) Get table viz work in explore v2: Added d3 format to mock slice (#1353) (@vera-liu)
- [63161b1](https://github.com/apache/superset/commit/63161b11c347d5a6d62f7ae7dc91fa3c30b5dc93) [sqllab] proper, quoted, select * on the server side (#1404) (@mistercrunch)
- [4f886d6](https://github.com/apache/superset/commit/4f886d65ecc208149cf9b7663492a81df868dcc2) Fix None view_menues in permissions. (#1409) (@bkyryliuk)
- [62e0e19](https://github.com/apache/superset/commit/62e0e195e8eaa53afa41a5fec89cc4486a7114a3) [docfix] d3.format docs have moved (@mistercrunch)
- [e9d4749](https://github.com/apache/superset/commit/e9d4749f4470aee294f1351baa9422173a2a62c8) [hotfix] sqllab presto (@mistercrunch)
- [93f8e7d](https://github.com/apache/superset/commit/93f8e7d8e9b25a1aaf07e2b0c3772c327e523f0e) Fix the js build running out of heap space (#1408) (@mistercrunch)
- [3dea6e0](https://github.com/apache/superset/commit/3dea6e0da538ed1c0a7761ccbf97bd8f12ac7f2f) [sqllab] adding more descriptive labels to left panel (#1407) (@mistercrunch)
- [6fb3b30](https://github.com/apache/superset/commit/6fb3b305ad23c27d0555ded2ab80820000fdec50) [sqllab] add support for results backends (#1377) (@mistercrunch)
- [7dfe891](https://github.com/apache/superset/commit/7dfe891cc1d294bd55982d63c9c1eb8f9e9e4c25) [hotfix] timeseries_limit_metric: Not a valid choice (@mistercrunch)
- [5c3966a](https://github.com/apache/superset/commit/5c3966a32d454a2fc7fcabd75c66594662361586) Override the role with perms for given datasources. (#1399) (@bkyryliuk)
- [c198535](https://github.com/apache/superset/commit/c198535292869ae1ced6d66d08de536188be7e05) Change slice ids in the position json during dashboard import. (#1380) (@bkyryliuk)
- [ece69fb](https://github.com/apache/superset/commit/ece69fbb75086cb8855789881a32c6daca4be483) Fix migration for make creator owners (#1262) (@ShengyaoQian)
- [458651f](https://github.com/apache/superset/commit/458651fa3e0098f35412772b622e7c0b63d34299) Add parens for custom where and having (#1337) (@yejianye)
- [b2f7081](https://github.com/apache/superset/commit/b2f7081c6f3dde80846493330f1ec1e5fa3a414c) bumping versions of JS packages to latest (#1352) (@mistercrunch)
- [c255e89](https://github.com/apache/superset/commit/c255e89219c209b5a5371134fbb9a9b90036ded4) [sqllab] show partition metadata for Presto (#1342) (@mistercrunch)
- [2edce5b](https://github.com/apache/superset/commit/2edce5bf8afa7b74fdafd8ab8a2e6394d46e6391) Enable "Run Query in New Tab" in SQL Lab (#1343) (@nickbarnwell)
- [8f29944](https://github.com/apache/superset/commit/8f299448ea954f75f576399f6bc113dd8ac1c824) [bugfix] text as subquery fails with 'Series Limit' (#1347) (@mistercrunch)
- [ecb951b](https://github.com/apache/superset/commit/ecb951bb7474b9c829d0eef12792f6c146757dba) Specify the metric to order by for Series Limit (#1351) (@mistercrunch)
- [0dff6a9](https://github.com/apache/superset/commit/0dff6a9030d8f2ff7a03654258f3b02f01d9d57e) Add quarter time grain to postgresql (#1362) (@xrmx)
- [2095095](https://github.com/apache/superset/commit/2095095895d9cf5bc8131fb51fbb4868fae124dc) Fixed big number issue (#1355) (@vera-liu)
- [4fc8a17](https://github.com/apache/superset/commit/4fc8a17f2ae18dcc2be778e52b3d3ed7be29e95a) [hotfix] use  instead of prod for Travis build, take 3 (@mistercrunch)
- [3cb737f](https://github.com/apache/superset/commit/3cb737f8c890b018bd6b3275047a02f79abb7444) [hotfix] use  instead of prod for Travis build, take2 (@mistercrunch)
- [7449aa8](https://github.com/apache/superset/commit/7449aa813b8b695e6dc3b06eb25004bc2a55614f) [hotfix] use  instead of prod for Travis build (@mistercrunch)
- [7a3bcc2](https://github.com/apache/superset/commit/7a3bcc227cccdec756404ab6140a6ba0d3882419) [bugfix] NaN issue in Big Number viz (#1346) (@mistercrunch)
- [b669a14](https://github.com/apache/superset/commit/b669a140816b950237b7d66b73ac6af392f28d8a) [explore-v2] make chart container work with existing visualization files (#1333) (@ascott)
- [9db4cc8](https://github.com/apache/superset/commit/9db4cc8c6d0422f28357dc4283089ee3dde9a08e) add node/npm versions to contributing.md (#1344) (@ascott)
- [65c744f](https://github.com/apache/superset/commit/65c744f2424d111e950b385630bd8a13b3fa003e) Fix utc time calculation if provided datetime has tz info (#1287) (@labeneator)
- [82bcadf](https://github.com/apache/superset/commit/82bcadf7f829183fbf6feca81dcc6c69f08c358c) Moving 'CSS TEmplates' to the Manage menu category (#1336) (@mistercrunch)
- [f0f8478](https://github.com/apache/superset/commit/f0f8478922cbe8e4ac754fddcfd6183032bbb893) Revert "Override the role with perms for give datasources." (#1345) (@bkyryliuk)
- [40e7057](https://github.com/apache/superset/commit/40e7057bcec55421275d0121d365a2e4f2d38a29) Override the role with perms for give datasources. (#1335) (@bkyryliuk)
- [11a8e35](https://github.com/apache/superset/commit/11a8e3591d281a8cde6fb0ab57ed54ec97035e23) Some dashboard import/export fixes. (#1340) (@bkyryliuk)
- [5bea398](https://github.com/apache/superset/commit/5bea3986b26359eb98c62246c34729e2d0cc5a1b) [hotfix] handling json errors in explore view (@mistercrunch)
- [89cb726](https://github.com/apache/superset/commit/89cb726284b2a4f2707f26d3004ef9ae59b33970) [hotfix] explore errors are not raise properly 2 (@mistercrunch)
- [4e9392d](https://github.com/apache/superset/commit/4e9392d21bf7f43e8189eb4478cf9d737c3616bd) [hotfix] explore errors are not raise properly (@mistercrunch)
- [b785d27](https://github.com/apache/superset/commit/b785d27241e9f22dcb6a880414500ce8f9e67eb3) Taking out object spread operator (#1311) (@vera-liu)
- [451860a](https://github.com/apache/superset/commit/451860afcab971a0a16b521a7c884d1c4d910986) remove #app styling (#1312) (@ascott)
- [4cf4e38](https://github.com/apache/superset/commit/4cf4e3805c4d0a217fa6232ba1d6ee3a68c86ed2) Bugfix when there's only date filter in FilterBox (no groupby) (#1326) (@yejianye)
- [ef2670c](https://github.com/apache/superset/commit/ef2670ca32e8ba0a04f9dc7899db55812e2f9b46) Using inheritance scheme to organize db specific code (#1294) (@mistercrunch)
- [8626c80](https://github.com/apache/superset/commit/8626c80d3a491b842f8262c5807154903c107747) Stop duplicating datasources (#1321) (@bkyryliuk)
- [5cb3cc2](https://github.com/apache/superset/commit/5cb3cc2ed8c8c2f0295da7ecdf8ec33a526acee1) polyfill es2015 in older browsers and for phantomjs (#1323) (@ascott)
- [73cd2ea](https://github.com/apache/superset/commit/73cd2ea3b17574f8fef1112aa5e5b39f843882f6) Import / export of the dashboards.  (#1197) (@bkyryliuk)
- [cd2ab42](https://github.com/apache/superset/commit/cd2ab42abcd2ea5f93dd285321c448c97abf4580) do not overwrite the stored password with the masked password (#1209) (@dennisobrien)
- [bf1f5ea](https://github.com/apache/superset/commit/bf1f5ea3de23a62eca4f823474119e4c15270738) [sqllab] use encodeURIComponent for copy query URL (#1317) (@mistercrunch)
- [79460ab](https://github.com/apache/superset/commit/79460abdd230b2d53a9f2da15ac5160ba6db400b) [SQLLab] Fix the usage of Redux DevTools Enhancer (#1278) (@zalmoxisus)
- [1e6e144](https://github.com/apache/superset/commit/1e6e144d24da38aef0d306889dc3b8f962ca4b32) Fixed viewing dashboards as anonymous (#1320) (@Rapsutin)
- [fe66557](https://github.com/apache/superset/commit/fe66557bbb4848feed762e859abcd5884d72d369) [explore-v2] hook up ExploreViewContainer to state and add specs (#1300) (@ascott)
- [f8e2ce6](https://github.com/apache/superset/commit/f8e2ce6ff367047405be60d7cbcfd68e4f4521d8) Change status color in tab to match with success (#1247) (@vera-liu)
- [1967743](https://github.com/apache/superset/commit/19677438c23a9beab907b5b51d99f54ef62c8f92) Add cascade delete to the 1 to composite relationships. (#1295) (@bkyryliuk)
- [9012b11](https://github.com/apache/superset/commit/9012b11101805c9810745f049363223f110bc93e) add ImmutableMultiDict back to views.py (#1298) (@ascott)
- [f70d301](https://github.com/apache/superset/commit/f70d301f0d37fe6c4f94cd7d6026a72a56087d34) Refactor the explore view (#1252) (@mistercrunch)
- [b7d1f78](https://github.com/apache/superset/commit/b7d1f78f5e38bdcc99c7b6a15645092f5d76ca4a) Put formData in store (#1281) (@vera-liu)
- [3384e75](https://github.com/apache/superset/commit/3384e7598ee9e82f8b83ae71e3e5b587c6546443) Fixing explore actions & slice controller interactions (#1292) (@mistercrunch)
- [382b8e8](https://github.com/apache/superset/commit/382b8e85da36ed1a8f235775b883e54f5db90ab7) [explore v2] add scrollbar to control panel container (#1284) (@ascott)
- [0a3121c](https://github.com/apache/superset/commit/0a3121c2438f74ab1bd3730eac7a11bad0b317f5) [doc] installation, load examples before init (@mistercrunch)
- [ecfe1a2](https://github.com/apache/superset/commit/ecfe1a241786bc1fae1d5d3c45b45e21703e33a7) Updated eslinter for object rest spread (#1289) (@vera-liu)
- [609ae22](https://github.com/apache/superset/commit/609ae22bdabfb9a9cb99d1a4bfba62367f03a8d5) less number of default workers. (#1206) (@StefanoOrdine)
- [94578cb](https://github.com/apache/superset/commit/94578cb6a7e91cb4ca741a8f437636d264b56322) reduce chunk size for countries table (#1279) (@vivo75)
- [8a5f050](https://github.com/apache/superset/commit/8a5f050f6cbf2a4eca7f2799a244f94218bb11c1) [explore v2] fix explorev2 chart errors (#1277) (@ascott)
- [5c5b393](https://github.com/apache/superset/commit/5c5b393f2fd7be5a4496c0ea0a0808f720fdc904) Change userId, dbId to username and dbname (#1274) (@vera-liu)
- [f837733](https://github.com/apache/superset/commit/f837733d858643152304469c899c096e31d2bf24) [explorev2] chart and controls (#1251) (@ascott)
- [66b498d](https://github.com/apache/superset/commit/66b498de25b6bb3145eb441f64ef7fdaffc5a747) Added controls for Table Viz (#1253) (@vera-liu)
- [659bf6d](https://github.com/apache/superset/commit/659bf6d7e80d70def5b6c46a9d8a3a262e37a13e) Moved time column and grains to models.py (#1255) (@vera-liu)
- [a8a1690](https://github.com/apache/superset/commit/a8a16900e7497083f14de3b6dc50063f845401b7) docs: add libsasl as system requirement on linux (#1257) (@xrmx)
- [e50b59e](https://github.com/apache/superset/commit/e50b59e5535bc653e3321a2630287540ef99df86) docs: document that gunicorn does not work on windows (#1258) (@xrmx)
- [231804e](https://github.com/apache/superset/commit/231804e2b47771ed6b31cb48e36c2f417973cad1) CHANGELOG: Add proper credit to tan31989 for #744 (#1259) (@xrmx)
- [421a86a](https://github.com/apache/superset/commit/421a86ade5ac5ec4d147bdfb913ce32a7004b455) Some polish on query search (#1222) (@vera-liu)
- [140a055](https://github.com/apache/superset/commit/140a055e4ef85080bbe3e7defdfeb2dd7b828b58) [docs] add line in installation instructions (@mistercrunch)
- [5bf86d9](https://github.com/apache/superset/commit/5bf86d91ec9911e6155335ff1f97dc48c2c16a21) [docs] suggest to upgrade pip and setuptools (@mistercrunch)
- [715cdd9](https://github.com/apache/superset/commit/715cdd98fb213e06c687ee8587ded9437039fb2d) Changelog for 0.11.0 (@mistercrunch)

### 0.11.0 (2016/10/05 04:27 +00:00)
- [7a01d9d](https://github.com/apache/superset/commit/7a01d9dbcbbd7678960c33c8cca1b13680290ac7) v0.11.0 (@mistercrunch)
- [58dfa43](https://github.com/apache/superset/commit/58dfa436ee53aac185b457e721bfe2303b8d006a) Do not shadow _ function. (#1254) (@bkyryliuk)
- [8ab5e50](https://github.com/apache/superset/commit/8ab5e5015a7d2b64a552acbd6ddb4cc161888e65) Added access check + Druid in endpoint (#1224) (@vera-liu)
- [a92190c](https://github.com/apache/superset/commit/a92190c3aecb96d07de594f06afe5acd15c1e307) Fix npm linting error with version string (#1249) (@vera-liu)
- [055fb61](https://github.com/apache/superset/commit/055fb6110f0f2c0f18dbc2cd03b8141430dcbd81) bump version to 0.10.0.dev0 (@mistercrunch)
- [19ab3e2](https://github.com/apache/superset/commit/19ab3e2fbd2040798a33afc9104a809bf1721367) Adding a 'Misc Charts' dashboard as part of the examples (#1208) (@mistercrunch)
- [ae54ac9](https://github.com/apache/superset/commit/ae54ac9d58892878c37ff47d4504299d01edba21) [sql-lab] fix react warnings in dev (#1232) (@ascott)
- [e6e902e](https://github.com/apache/superset/commit/e6e902e8df0aabd3a750ed8a53b6de3a0fd4b204) [explore-v2] setup, basic layout, control panels, v2 url (#1233) (@ascott)
- [d8638db](https://github.com/apache/superset/commit/d8638dbcf3913c0097dd657a22f48f6ebb6bd9e3) revert devtool alert (#1238) (@vera-liu)
- [9795e4a](https://github.com/apache/superset/commit/9795e4a5325e8eba4366bee7725497976d0676e5) [SQLLab] Fix updating the database state. (#1225) (@bkyryliuk)
- [e11ef99](https://github.com/apache/superset/commit/e11ef994bb5691f5bdea6967e5e37665ab2b79c1) [SQLLab] user server for the query limit check. (#1230) (@bkyryliuk)
- [472679b](https://github.com/apache/superset/commit/472679bb3898e0d7ec1e8855c3175419c55e03b4) [security] allow for requesting access when denied on a dashboard view (#1192) (@mistercrunch)
- [d066f8b](https://github.com/apache/superset/commit/d066f8b726221bcaec18a8847582b54749d0e48e) Added alert to install redux devtool (#1228) (@vera-liu)
- [aa5bbe6](https://github.com/apache/superset/commit/aa5bbe6149833386a491bd70987f84c93d501f16) Fixed error of inserializable json for druid test (#1213) (@vera-liu)
- [9c83b90](https://github.com/apache/superset/commit/9c83b900ae961fa715bd3eb52cec32469d10a457) Bring DB in sync with the models.py (#1172) (@bkyryliuk)
- [f0289ce](https://github.com/apache/superset/commit/f0289cef3a373c40529951ce4688e3c92196421e) [minor] fixing the icons in the navbar (@mistercrunch)
- [96844c5](https://github.com/apache/superset/commit/96844c5c12c22e03bdbee61634c5b7dc138d19c5) Share query (#1154) (@vera-liu)
- [1a29163](https://github.com/apache/superset/commit/1a29163530a3879ef3404773a9b3f79a7dfa2ea4) A few bugfixes (@mistercrunch)
- [b67906c](https://github.com/apache/superset/commit/b67906cfe13a667105228e73fbca0f2dc0a11520) [hotfix] dashboard doesn't have filter_immune_slices pre-save (@mistercrunch)
- [1536675](https://github.com/apache/superset/commit/153667505f2d106a2aeb22e4b59553be1414696f) [hotfix] slice page is broken (@mistercrunch)
- [b6f4062](https://github.com/apache/superset/commit/b6f4062874c1d8419729357e9fa29517cd54e219) Update countries.md (#1194) (@Aveplatter)
- [44be42c](https://github.com/apache/superset/commit/44be42c9221168098c46bd83ee7fe0a42ad82351) Remove duplicate code for property name of SqlaTable (#1190) (@prokh)
- [5f6ef84](https://github.com/apache/superset/commit/5f6ef84c4e15fa70c8f86f9400bb8e68c49ef691) Vliu query search (#1187) (@vera-liu)
- [551c971](https://github.com/apache/superset/commit/551c97112c57b67526856208bf59f7916f621fd7) Revert "Query Search Page" (#1186) (@vera-liu)
- [d5c5c0d](https://github.com/apache/superset/commit/d5c5c0d6ac91d8dba6e167e991e2c7bb17f09f11) Query Search Page (#1122) (@vera-liu)
- [9890259](https://github.com/apache/superset/commit/98902599ff7db6eb186b2c415de13d28765ba087) [hotfix] issues around empty params (@mistercrunch)
- [7f3c205](https://github.com/apache/superset/commit/7f3c205c46fb40d662b0570801f93b04f3c50f5b) [hotfix] reactable bump to 0.14.0 (@mistercrunch)
- [199342a](https://github.com/apache/superset/commit/199342a2d314c36d76cbe748f3ee0142679500ab) Improving the docs around managing roles (#1183) (@mistercrunch)
- [d397c0b](https://github.com/apache/superset/commit/d397c0bbf833e2f8340fab213621831b8e60e0cd) [hotfix] FilterBox has issues with react-select version in prod (@mistercrunch)
- [6e5a93a](https://github.com/apache/superset/commit/6e5a93a6e1388acafc3e46554751220c62ecf6b6) [hotfix] result set always updates (@mistercrunch)
- [df89bec](https://github.com/apache/superset/commit/df89bec712cead1d2e3d3e4fcb300a889524a385) Infer types. Smart defaults for the visualize window. Basic implementation. (#1134) (@bkyryliuk)
- [fc921d6](https://github.com/apache/superset/commit/fc921d63a1acf6bc56a41f87de490495ee2f6a4b) Simplifying source_registry (#1180) (@mistercrunch)
- [aed473d](https://github.com/apache/superset/commit/aed473d0d242f1173bc9988b504291b82ae47158) [filtering] define combo of slice/fields unafected by filtering (#1179) (@mistercrunch)
- [7115c54](https://github.com/apache/superset/commit/7115c5458dd64158407c5bfd73f7fd060a986c1d) [FilterBox] dashboard date range filtering (#1165) (@mistercrunch)
- [8cb0bea](https://github.com/apache/superset/commit/8cb0bea57c67fba230346d387f1d950abe7790bd) [sqllab] db migration - setting Database.allow_run_sync=True (#1174) (@mistercrunch)
- [1fa1892](https://github.com/apache/superset/commit/1fa18922fa71f144e8eb713635da904c4e55b434) when adding a new database use Database.set_sqlalchemy_uri so that the password is stored encrypted. (#1177) (@dennisobrien)
- [49cefc8](https://github.com/apache/superset/commit/49cefc8b003921c45b0560ba8f475174ccbbe5e3) Improve the Test Connection error message (#1175) (@mistercrunch)
- [cbc70d3](https://github.com/apache/superset/commit/cbc70d373842419dfef9c6a7f8ab40fd4c27a395) Implement permission request/approve flow.  (#1095) (@bkyryliuk)
- [b855e2f](https://github.com/apache/superset/commit/b855e2f1a670458f5b2076fde2f9c4d3140e83d4) Add dashboard creator as owner of the dashboard (#1166) (@bkyryliuk)
- [bc7d0ff](https://github.com/apache/superset/commit/bc7d0ffad2e565827aa0dc7d54293a91ee107236) Fix TEST CONNECTION on a newly added database. (#1168) (@dennisobrien)
- [2f2ed22](https://github.com/apache/superset/commit/2f2ed229fb794369caa66bdd5143be7db3a3664f) [redux] move some redux utils to shared file (#1164) (@ascott)
- [b587576](https://github.com/apache/superset/commit/b5875764edfaec2b6377df03fdb281e1e196179b) [security] allowing to set static headers as configuration (#1126) (@mistercrunch)
- [f1e80a8](https://github.com/apache/superset/commit/f1e80a8e1b94cc7a58e0760c5b87b7e4ed594294) Adding indexes to table metadata (#1160) (@mistercrunch)
- [5a0e06e](https://github.com/apache/superset/commit/5a0e06e7a27307c2b4f5d5575c475df68e1cd7d7) Generalize switch between different datasources (#1078) (@ShengyaoQian)
- [ed2feaf](https://github.com/apache/superset/commit/ed2feaf84b470fda29670ffaededb36089e473eb) fix build with utf-8 connection string option to mysql (#1159) (@mistercrunch)
- [a1338ed](https://github.com/apache/superset/commit/a1338ed52ebd07f407cab9460e43b0b984fbb8d2) changing the travis build matrix for faster builds (@mistercrunch)
- [d41463b](https://github.com/apache/superset/commit/d41463ba72fdbf262a661f9bc643267f28e00437) changing the tox build matrix ordering (@mistercrunch)
- [0e7af8d](https://github.com/apache/superset/commit/0e7af8d8a64a1e6073f55e798a2e952a6602133c) [explore] refactor slice action button group (#1074) (@ascott)
- [32980a6](https://github.com/apache/superset/commit/32980a653c4e43a381135d5d95fad83e6e14d078) [big_number] fix subheader is missing (#1146) (@mistercrunch)
- [d15a212](https://github.com/apache/superset/commit/d15a212e64461bc3814cd7406c231fc9c28261d6) Add support for Werkzeug ProxyFix middleware (#1150) (@bobziuchkovski)
- [1ce8acc](https://github.com/apache/superset/commit/1ce8acc15437dbacfd74eb5ba8b1fe31fc15742e) Adding license to package.json (@mistercrunch)
- [e8088d5](https://github.com/apache/superset/commit/e8088d5c9a522db5e0e165988fba47893337fd5b) More improvements to SQL Lab (#1104) (@mistercrunch)
- [8081080](https://github.com/apache/superset/commit/8081080709722456b7671263e6c71f9c3a5f4951) log: be more robust against malformed input (#1127) (@xrmx)
- [8c619e8](https://github.com/apache/superset/commit/8c619e83834a834c830a237a04b76fddfb96a01c) models: fix slice creation (#1130) (@xrmx)
- [1c544c9](https://github.com/apache/superset/commit/1c544c9845f0fe0d8745f5b2cf531a1fd2ae0d0c) Enable list with checkboxes only on Table->Columns view (#1138) (@mistercrunch)
- [ca66ba4](https://github.com/apache/superset/commit/ca66ba489399a3c37e39875f6d1f6c278cfcb9be) Fix initialization of Database sqlalchemy_uri and password (#1137) (@dennisobrien)
- [afa1f09](https://github.com/apache/superset/commit/afa1f0916b061d86afc2898515463876be5fa011) Make sql test connection work with saved Database instance (#694) (@xrmx)
- [69d37d8](https://github.com/apache/superset/commit/69d37d8b2a8de4750b2949905a6e05b28cdf88a6) Fix double escaping of dttm expressions (#744) (#1103) (@tan31989)
- [b62d7e3](https://github.com/apache/superset/commit/b62d7e3e8eaa80e201af3141fb4fe26c39e1ff79) [security] prevent XSS on FAB list views (#1125) (@mistercrunch)
- [e8f1bab](https://github.com/apache/superset/commit/e8f1baba438c98a985c252297474c18eeaa41359) [explore] giving more room to Slice title (#1118) (@mistercrunch)
- [ffe6fb8](https://github.com/apache/superset/commit/ffe6fb849f4c2eb0fc33d866d40cb4afb801af38) Apply stretchMargin only to distribution bar (#1124) (@vera-liu)
- [3602d94](https://github.com/apache/superset/commit/3602d940ebe1917e1e6dc72ca2e6bb6ee648a73e) [hotfix] lint (@mistercrunch)
- [9389f89](https://github.com/apache/superset/commit/9389f89889840e17eca09d74189aec28339bb377) [welcome] removing calendar heatmap from welcome page (#1119) (@mistercrunch)
- [edcc2a1](https://github.com/apache/superset/commit/edcc2a11c620be1b73c8c0a00a164568480cb6e7) Fixing druid culster perms to mirror sqla databases (#1123) (@mistercrunch)
- [2adc8a0](https://github.com/apache/superset/commit/2adc8a027424ed348e32e7c272826a3f47625602) [explore] clarifying force-refresh message (@mistercrunch)
- [2432c31](https://github.com/apache/superset/commit/2432c3155a21f4b896a65215a467a0a04a5e455c) Associate version to entry files (#1060) (@vera-liu)
- [2132f67](https://github.com/apache/superset/commit/2132f6715e6e528a44a1a6387bcd9899063fbc7b) When the label size is too short, the constant for calculating (#1120) (@vera-liu)
- [e895807](https://github.com/apache/superset/commit/e895807158f754bc83a77b581949eb2499390019) [bugfix] namespacing the mapbox css (@mistercrunch)
- [c87f342](https://github.com/apache/superset/commit/c87f34285ac7dd33493040b5ef8a45982b9b3d41) Animated GIFs on README (#1109) (@mistercrunch)
- [17a3175](https://github.com/apache/superset/commit/17a317554ce8f5e2fe4cd23880ed169cc5259f9a) [bugfix] filter_immune_slices doesn't work (#1110) (@mistercrunch)
- [a871ee7](https://github.com/apache/superset/commit/a871ee78582a831c5ca00badf120b954e13fc13f) Clean up the druid sync api. (#1101) (@bkyryliuk)
- [2e6b4b1](https://github.com/apache/superset/commit/2e6b4b121fe2a1cf6d23afc153e7383eb01302cb) Time grain support for unix-timestamp columns (#1093) (@yejianye)
- [df533d3](https://github.com/apache/superset/commit/df533d30fc5d7b3b00385be80997e31cd3d51e6a) [sql lab] specify schema name when generating vanila query (#1096) (@mistercrunch)
- [1f761c6](https://github.com/apache/superset/commit/1f761c61ddf7de23b9258c15895f01ac8af6bc95) Single quote filter values with comma (#1084) (@vera-liu)
- [9bf5620](https://github.com/apache/superset/commit/9bf5620887f232c4ba60ccea8e6886e8b68ebaa2) [sqllab] hide SqlEditor textarea to prevent flicker (@mistercrunch)
- [1971bf6](https://github.com/apache/superset/commit/1971bf653c57da4c0d21e7311e760c360953372b) Numerous improvements to SQL Lab (#1088) (@mistercrunch)
- [c20ee0c](https://github.com/apache/superset/commit/c20ee0c12921e7bf9f320775c97c7c205952c948) Filter Druid Datasources by user permissions. (#1090) (@bkyryliuk)
- [6aadc6e](https://github.com/apache/superset/commit/6aadc6ec1373d5a6bb46c1485f744ac806ea9729) Simplifying the flow to add a table (#1068) (@mistercrunch)
- [8eb4cbf](https://github.com/apache/superset/commit/8eb4cbf66ea46fbc673e26cfbd5d7e619a6eef63) only show the reset state button if location param (#1075) (@ascott)
- [0e0eaa0](https://github.com/apache/superset/commit/0e0eaa0ccdef37abf4a072776d7a0da3deab0d62) [sql-lab] ui polish (#1079) (@ascott)
- [d454fb4](https://github.com/apache/superset/commit/d454fb402b6abf2b9092d072b065345ad62e5867) Add refresh druid datasources endpoint. (#1065) (@bkyryliuk)
- [9ae231a](https://github.com/apache/superset/commit/9ae231aeb8e826deee964e56df2732c81842336c) adjust bottom margin according to label sizes on x-axis (#1029) (@vera-liu)
- [e783219](https://github.com/apache/superset/commit/e783219a7601ab891531dc721b7920588a99115c) Add cache warmup endpoint (#1063) (@bkyryliuk)
- [49e4f70](https://github.com/apache/superset/commit/49e4f70f780e684ec261d7e1445df78c9730a809) Disable complexity check. (#1064) (@bkyryliuk)
- [62c7111](https://github.com/apache/superset/commit/62c71110df5ea4df4720a7a2059b8328901e7161) Adding a ShrinkSql component (#1058) (@mistercrunch)
- [544b3f3](https://github.com/apache/superset/commit/544b3f350f1f906579f974c9960c63912ba74e71) Add codeclimate cli instructions. (#1043) (@bkyryliuk)
- [9914901](https://github.com/apache/superset/commit/99149010998e18360aa1abb0fdacf46c4741a121) Change the font on axis (#1028) (@vera-liu)
- [badac73](https://github.com/apache/superset/commit/badac7379efa794567a94c7ce6773a1f4f165528) [touchup] using input-sm on text fields in explore view (@mistercrunch)
- [7dd01cf](https://github.com/apache/superset/commit/7dd01cff6f666f211c1300d75653d25866a99b4a) [bugfix] btn timer contianer was left behind (@mistercrunch)
- [4b77710](https://github.com/apache/superset/commit/4b77710016749d0a1eb65db24f2ccc5d2335f970) [SQL Lab] Adding DB options for SQL LAb (#1054) (@mistercrunch)
- [1667d15](https://github.com/apache/superset/commit/1667d15f3196a01e79bd5e351999ca1f24ecddad) Reactivating coveralls.io (@mistercrunch)
- [bae2119](https://github.com/apache/superset/commit/bae21194c1586955bb9b883d293537b383996bd7) Chris/remove redirect from slice id endpoint (#1044) (@williaster)
- [4f125ee](https://github.com/apache/superset/commit/4f125eedb51944c0e84a0a9f2f05e2c859c5c105) Add codeclimate labels. (#1050) (@bkyryliuk)
- [f300ee1](https://github.com/apache/superset/commit/f300ee101003cb0c974e72f528c6a2c4f94831ec) Small codeclimate fixes. (#1033) (@bkyryliuk)
- [85d03f5](https://github.com/apache/superset/commit/85d03f5e182865bc1eb255f7f3bec040b3ca14b7) Set up istanbul with codeclimate and travis. (#1046) (@bkyryliuk)
- [3f88949](https://github.com/apache/superset/commit/3f889492f90625a0c735baaab28513e707b2982c) Fixing the build [that I broke] (@mistercrunch)
- [508feb2](https://github.com/apache/superset/commit/508feb2bad581068a47193e06d35ed5926b25191) [hotfix] getting presto on track
- [9f8eef4](https://github.com/apache/superset/commit/9f8eef498c93ce2945e3d17cda1c3d2a24d05c92) [theme] a little bit less blue (#1024) (@mistercrunch)

- [561828c](https://github.com/apache/superset/commit/561828c2f890e179c4116f773cc7507103804dc6) [SQL Lab] moving the db/schema/table select to the left (#1038) (@mistercrunch)
- [fc1e637](https://github.com/apache/superset/commit/fc1e63761cc86a5673433b0e2efc0081325684d3) Adding celery_tests.py (@mistercrunch)
- [38b8db8](https://github.com/apache/superset/commit/38b8db8051490375d021c51fb76a9f1bdc3ccf1f) SQL Lab - A multi-tab SQL editor (#514) (@mistercrunch)
- [f17cfcb](https://github.com/apache/superset/commit/f17cfcbfa277669f4864981174ce48ba7cc1ebee) [filter box] making filter order matches the dropdown (#1007) (@mistercrunch)
- [7eceb14](https://github.com/apache/superset/commit/7eceb140be58d30f0caafa196f687b489012607d) [bugfix] slice description makes charts overflow (#993) (#1010) (@mistercrunch)
- [b93f9ec](https://github.com/apache/superset/commit/b93f9ec59857bb27efc4bccc3f33b0578d3efc41) [line chart] adding option for circle markers (#1006) (@mistercrunch)
- [36a6714](https://github.com/apache/superset/commit/36a6714e9e5a57480cf9bf86a9fa4ccd65ca1c54) slice/explore header (#996) (@ascott)
- [30071ee](https://github.com/apache/superset/commit/30071eef09533d142733e2e907d872d2e772e981) Reduced number of ticks provided as hint to d3.ticks (#1012) (@shkr)
- [e85978a](https://github.com/apache/superset/commit/e85978a7edbae570cb781cd1e6614652226372bc) add if enableAddSlice is truthy (#1015) (@ascott)
- [d1f43e3](https://github.com/apache/superset/commit/d1f43e3e28d51c3cb67b564205a088b902e8dd0d) [ui] a few unmerged rules  (#1014) (@ascott)
- [de39923](https://github.com/apache/superset/commit/de39923d067db93fd967d3c043bffbab716f1862) [ui] design review changes  - default/primary btn colors (#1008) (@ascott)
- [f800ff1](https://github.com/apache/superset/commit/f800ff16c1ebe03f5d4d2b380ee748f4e8950c91) Making default labels visible (#999) (@mistercrunch)
- [ef118de](https://github.com/apache/superset/commit/ef118dee6a423f7f08ee8f03f8b6529a562b4f1e) move staging alert out of nav (#995) (@ascott)
- [2bc1674](https://github.com/apache/superset/commit/2bc1674237e72783ee5b0831c8575f7f340d1875) [bugfix] slice description makes charts overflow (#993) (@mistercrunch)
- [9445549](https://github.com/apache/superset/commit/9445549afffc396670ef224942131d00adb78b11) [tweak] allowing markup widget to overflow (@mistercrunch)
- [95eb928](https://github.com/apache/superset/commit/95eb928beba6af3dda1d26579a5da746146accb3) [bugfix] markup image is missing in examples (@mistercrunch)
- [a8fd23d](https://github.com/apache/superset/commit/a8fd23dfa4a935a3e4de7f48f13d05539f2e71c3) Linting JSX files (#941) (@mistercrunch)
- [7f2805a](https://github.com/apache/superset/commit/7f2805a3c580531fd94b182042bd94ff78644446) [bugfix] fixing && linting the histogram viz (#987) (@mistercrunch)
- [a871529](https://github.com/apache/superset/commit/a8715294b01cc133a34effe334b6ae62b3078fb7) [bugfix] dashboard list doesn't populate in explore->saveas (#979) (@mistercrunch)
- [c7467f5](https://github.com/apache/superset/commit/c7467f544c10281538b8504add9510f3fcf20e60) Documenting making your own build (#990) (@mistercrunch)
- [30ef8eb](https://github.com/apache/superset/commit/30ef8eba37073c2cb0d2a6356fe3a9bcabab4913) [ui] hack bootswatch/cosmo theme to get better tabs for sql-lab (and other things) (#975) (@ascott)

- [23a5463](https://github.com/apache/superset/commit/23a54632081aa589e05a820ac774c8b4f6993252) Hack around the "last migration doesn't stamp" Alembic bug (#967) (@mistercrunch)
- [84213ab](https://github.com/apache/superset/commit/84213ab8cd27369f796131c68c075f12f8bd0ce2) [line] growth vs factor option for 'Period Ratio' (#970) (@mistercrunch)
- [379cf6c](https://github.com/apache/superset/commit/379cf6cbd9527617b6aae60501ad2fa4e252bb8f) [ui] tweaks and improvements (#965) (@ascott)
- [a029eaa](https://github.com/apache/superset/commit/a029eaa4512ab791ff8e461c9ba2cefc8000bbfa) docs: add a faq about mapbox api key (#968) (@xrmx)
- [ac512ef](https://github.com/apache/superset/commit/ac512ef73199d63b555075f44b8a14613e133b01) [hotfix] SQL endpoint JQUERY error (@mistercrunch)
- [8097495](https://github.com/apache/superset/commit/80974958bd46e515fe5c28075780b6f2806196c7) vera_liu-deleted_dashboard_title_column_in_welcome_page (#951)
- [cc058e5](https://github.com/apache/superset/commit/cc058e5c9e1cb07608c710da42ffd16437541652) viz: cache datetime.now() in query_obj (#955) (@xrmx)
- [061d4f1](https://github.com/apache/superset/commit/061d4f1ac7088de7b39c8eea4f901ee9e006ce66) Refine gamma experience (#883) (@xrmx)
- [88f4260](https://github.com/apache/superset/commit/88f426077776f0b8c43c477292d5aed5ca2096d9) Change default location for db and logs to ~/.caravel Fix #915 (#947) (@aljones)
- [66c2b84](https://github.com/apache/superset/commit/66c2b84cb45ac625f5d1502e28ae462964c5d3da) Add time grains for mssql. (#956) (@aljones)
- [348c096](https://github.com/apache/superset/commit/348c09624f456fb8e67bba43b107e0028f9d63fb) add amino to inthewild (#964) (@shkr)
- [3e551e4](https://github.com/apache/superset/commit/3e551e40a74d22e2a1e247418d37f85ab19b63a0) Update INTHEWILD.md (#960) (@LAlbertalli)
- [c474581](https://github.com/apache/superset/commit/c4745811385cadd1033638d45f29f9e8131ddcf2) Fixing the rendering of the separator widget (#936) (@mistercrunch)
- [5646aa0](https://github.com/apache/superset/commit/5646aa03d268405a3ba8c5b8345cec835c50c3e1) fixing the build (@mistercrunch)
- [6b5d6b4](https://github.com/apache/superset/commit/6b5d6b41560b393058274cb2f16945b3e5d4c67a) [typo] in setup.py (@mistercrunch)
- [4e1af9a](https://github.com/apache/superset/commit/4e1af9a2ca22d33768bdfd474c5384f1f6fbf38d) Adding codeclimate-test-reporter to  dev-reqs.txt (@mistercrunch)
- [7d1bec1](https://github.com/apache/superset/commit/7d1bec11f94747286c577894917943e98de1285b) Setting up python to allow 90 (@mistercrunch)
- [c60476e](https://github.com/apache/superset/commit/c60476eadddc9d63f8e4ebc0d8db68c066775008) Attempting to setup coverage (@mistercrunch)
- [d79220f](https://github.com/apache/superset/commit/d79220fb71b5166b19dbd43286b381992f8af7b0) .codeclimate.yml on the right spot (@mistercrunch)
- [a8131dd](https://github.com/apache/superset/commit/a8131dda7ad8e5d5735528b37ef0114f2b5d1fce) Attempting coverage integration with code climate (@mistercrunch)
- [10011d5](https://github.com/apache/superset/commit/10011d572a1deb26ad5fd0e2058700fd60e6f137) Adding Code Climate conf file (@mistercrunch)
- [d7d10d2](https://github.com/apache/superset/commit/d7d10d2847f2ab138d4e7ac06cdc6adfb1c7d8ea) rectify GitHub's name (#942) (@KrishMunot)
- [aa01283](https://github.com/apache/superset/commit/aa01283774ebf2a345122a0312cf28553aac86c3) [hotfix] adding react-select to package.json (@mistercrunch)
- [1b9458d](https://github.com/apache/superset/commit/1b9458dcf0750ba989b27209d59b00c9a55ff53a) Adding config element for alert message in navbar (#938) (@mistercrunch)
- [e243a14](https://github.com/apache/superset/commit/e243a14c64c97f81e205037bb11bcd9170c17163) Refactor around how visualizations/*.js are required (#913) (@mistercrunch)
- [198226a](https://github.com/apache/superset/commit/198226a39fe6367a9aa70576687232bbd3cb6c49) Fix date serialization (#873) (@gbrian)
- [2bfb9cc](https://github.com/apache/superset/commit/2bfb9cc7ddbd24e85ebad45d69f8c466cdbcabc5) pass the `standalone` request arg in the /caravel/slices/<slice_id>/ endpoint redirect (#876) (@williaster)
- [71bdabe](https://github.com/apache/superset/commit/71bdabe1a11339a6206020c99bf8dfcabd5b3f05) dashboard: don't enable buttons that would fail (#881) (@xrmx)
- [9b3b1f6](https://github.com/apache/superset/commit/9b3b1f69dfc2d2e31c54e578647e6aa1a491d397) Fixes explore view when no slice is defined (#924) (@mistercrunch)
- [3f21a89](https://github.com/apache/superset/commit/3f21a898c90ba1ef72629c295fdfd53fdea9b66a) Fixing some aspects of the theme (#923) (@mistercrunch)
- [bcbe08b](https://github.com/apache/superset/commit/bcbe08bd5c3569dff3e66da23dc3f1c16c928181) Fixing some aspects of the theme (#907) (@mistercrunch)
- [4247cab](https://github.com/apache/superset/commit/4247cabb179bb8a788b51ac25bde70d66e94e196) [david-dm] Adding badge for tracking js deps versions (@mistercrunch)
- [9a2c774](https://github.com/apache/superset/commit/9a2c7740f0ca4b215cf15c76f3e0ccb7e1d8a94a) [bugfix] nvd3's API changed and broke the range filter (#903) (@mistercrunch)
- [efdfa81](https://github.com/apache/superset/commit/efdfa81f21614176b300a0f95b4e30877ad36eb9) [bugfix] controls info bubble don't show up (#904) (@mistercrunch)
- [15ee6d8](https://github.com/apache/superset/commit/15ee6d82e30dbc7be783754b567bc85b7f322c14) Histogram (#888) (@shkr)
- [d15c557](https://github.com/apache/superset/commit/d15c557cd66d833582386904b7d70e06a49bae85) [bugfix] missing spinner in explore view (#914) (@mistercrunch)
- [08d6825](https://github.com/apache/superset/commit/08d682501edcf2b90dcf42426b12e327cb35b6cd) [webpack] set up proper dev/prod environment (#916) (@mistercrunch)
- [baf22c3](https://github.com/apache/superset/commit/baf22c3c60de38a1fe14de5f7120c76abe106460) docs: make it clear that some config keys really need to be changed (#912) (@xrmx)
- [5a937f1](https://github.com/apache/superset/commit/5a937f1d0b16f6c29900650dbb3a463583d89958) docs: simplify cryptography installation on Windows (#909) (@xrmx)
- [d6bb8c6](https://github.com/apache/superset/commit/d6bb8c6935b5e9dc8f8464c314ff35f2c02191d8) Add per database permissions for the SQL Lab. (#885) (@bkyryliuk)
- [b48101c](https://github.com/apache/superset/commit/b48101ca51da8bd07608ccdbd9912efb2000cd0b) docs: recommend python3 and virtualenv (#901) (@xrmx)
- [572c6ee](https://github.com/apache/superset/commit/572c6ee85ea4f46cca36a9d41e95a668a7a78a23) Update linting instructions. (#896) (@bkyryliuk)
- [b0a1f07](https://github.com/apache/superset/commit/b0a1f07818cc1454bb823933a783035f753d72e8) ui update (#879) (@ascott)
- [cb23362](https://github.com/apache/superset/commit/cb23362a5bff9cec8354968b5a8a612126e1d82d) handle UUID type field (some database like postgres support UUID type field) (#889) (@tninja)
- [7c810db](https://github.com/apache/superset/commit/7c810dbd20ef394c073ec78c0c46380f471fff4d) Miscellaneous style fixes spotted by landscape (#874) (@xrmx)
- [82a8e63](https://github.com/apache/superset/commit/82a8e6316f874b28c8b8ff718917006b524cd7d6) [bugfix] refresh dashboard widget button doesn't work (#878) (@mistercrunch)
- [aaef338](https://github.com/apache/superset/commit/aaef338539eff4ff855e0f87bcb17ca71440e251) Altering theme for more subtle alerts / labels / buttons (#798) (@mistercrunch)
- [e7ce38b](https://github.com/apache/superset/commit/e7ce38b486feddf144a3e1e25fe505f4e043f87e) Smarter redirect on slice creation (#691) (@xrmx)
- [862042b](https://github.com/apache/superset/commit/862042bb498f9c49f7e4c221f406b23d026e0076) add redis cache hint to docs (#861) (@linroex)
- [cbca740](https://github.com/apache/superset/commit/cbca740f9fb56396ee491a11801c96c552ffa9b3) use css transforms for dashboard grid cells (#848) (@georgeke)
- [e36bc24](https://github.com/apache/superset/commit/e36bc2477a422ae71a9661da29241528e5246070) Use flask_babel in CONTRIBUTING (#869) (@xrmx)
- [55afda3](https://github.com/apache/superset/commit/55afda3a7e0f56e29bd54260deb0c0c9169ea4f2) viz: use sort_values(inplace=True) instead of sort (#870) (@xrmx)
- [ee9141a](https://github.com/apache/superset/commit/ee9141a31a84c7c1114163995edb718f89372a15) New endpoint that receives SQL and returns data as JSON (#842) (@mistercrunch)
- [299e31f](https://github.com/apache/superset/commit/299e31fdff1861c434c18efaed804d63572aec16) Added order_by_cols to as_list. Fix to issue #821 (#823) (@rhp4515)
- [f9427b9](https://github.com/apache/superset/commit/f9427b9bfbe6e4dad0abbf8498fc24c7e75a8230) Fix mapbox radius calculations being off when changing latitude (#824) (@georgeke)
- [8872677](https://github.com/apache/superset/commit/88726773f125038ebc0377d683e341ed98c51727) Add an option to allow users to choose to what IP address the web server must bind to. Default to 0.0.0.0 (all IP addresses). (#826) (@plumbeo)
- [29e3dd4](https://github.com/apache/superset/commit/29e3dd404d8ff0d4332a34d159df8246786702e0) Let the user decide the label type of pie charts (#819) (@x4base)
- [1101de5](https://github.com/apache/superset/commit/1101de5ae4073628fd41d49e9cc854e7610b1da4) [js linting] use airbnb eslint settings (#796) (@ascott)
- [f43e5f1](https://github.com/apache/superset/commit/f43e5f18d58c73b10aea3d7ca603e916bed5ed9e) Support showing the values on top of the bars (#777) (@x4base)
- [2aea194](https://github.com/apache/superset/commit/2aea1943d6763748e563d94629585aeb5a8f2b0e) Add Maieutical Labs / cloudschooling.it to Caravel users (#816) (@xrmx)
- [7dd5b67](https://github.com/apache/superset/commit/7dd5b6716e44880f6481f0f454e415b545701503) Fixing serializing the lazy string (#818) (@mistercrunch)
- [2425b8f](https://github.com/apache/superset/commit/2425b8f6142e9c543351a2c08fc4fc1e90d0dc4d) [presto] Smaller granularity units; fallback support for H:m:s (#731) (@georgeke)
- [d11dd83](https://github.com/apache/superset/commit/d11dd83c94a2b11e6b3db3ee2d2c8f0c469d5340) [docs] faq entry about server timeouts (@mistercrunch)
- [6731a28](https://github.com/apache/superset/commit/6731a287b555b5c2000c007f59fa3fc0e57ca966) Filter add/remove fix (#779) (@georgeke)
- [cf785b4](https://github.com/apache/superset/commit/cf785b4d03c6b7541b93566c8bcb93d3a037fb7b) fix datasources foreign key size (#791) (@aljones)
- [8b694dd](https://github.com/apache/superset/commit/8b694ddd7a2e016ae5fa2b2208188555ba018d1a) Fix caching in python3 (#806) (@xrmx)
- [187149c](https://github.com/apache/superset/commit/187149caeb1c06af7479c8a3a0303a5107b88c6f) Update documentation url (#805) (@xrmx)
- [19f5371](https://github.com/apache/superset/commit/19f5371787df8d65137b7cf2ceb6c2a6b764cdca) In subquery use alias to do 'order by' (#795) (@yxjames)
- [9cdd289](https://github.com/apache/superset/commit/9cdd289081b9e5faf9f8136151502398f6c01369) Set BoxPlotViz to is_timeseries=False (#802) (@mistercrunch)
- [e813726](https://github.com/apache/superset/commit/e813726afb4b58fb17d0c4abca53ae7b1d56225b) Giving hingts that we support SparkSQL (#803) (@mistercrunch)
- [a704d4d](https://github.com/apache/superset/commit/a704d4ddeed45257d981f2583f8e60b6432d2cb4) remove z-index from slice div and .nvtooltip (#793) (@ascott)
- [fa0497d](https://github.com/apache/superset/commit/fa0497de5ed4dcc873e22ce9d960528cccb9f533) [eslint] changing to always-multiline on comma-dangle (#794) (@mistercrunch)
- [7bba9f7](https://github.com/apache/superset/commit/7bba9f73d0ed37a342e3f0519969110c03f142d3) [bugfix] fix dual alert messages where the second one is empty (@mistercrunch)
- [83d5ad2](https://github.com/apache/superset/commit/83d5ad216a9a82ac727965f7607480764535ffb8) update contributing.md with js testing details (#781) (@ascott)
- [7306b9c](https://github.com/apache/superset/commit/7306b9caaad5b4659d0ae7b05bd3be3dc9b7555d) Fix small typo in message strings (#778) (@smilin-desperado)
- [2b237f4](https://github.com/apache/superset/commit/2b237f483f305bb265980d9b2f272d99fb974c47) update-webpack-config to match babelrc (#776) (@ascott)
- [24e85f5](https://github.com/apache/superset/commit/24e85f52b4ead7f8f70b8d3d7e5724d8ca597bd9) get npm test working (#762) (@ascott)
- [1fed498](https://github.com/apache/superset/commit/1fed498e33865d57868607b9568883a1b3214fdb) [webpack] revert change to output extension (#760) (@ascott)
- [f034f27](https://github.com/apache/superset/commit/f034f2701e886d3b0e6b41203a65ad4c3fb1bea5) Allowing to define a default format string per-metric (#750) (@mistercrunch)
- [8312f1c](https://github.com/apache/superset/commit/8312f1c2aa306da1dee46871aacd96f551c505d1) Adding an option to make separators in dashboard (#699) (@mistercrunch)
- [3522bf9](https://github.com/apache/superset/commit/3522bf9b09ec9ea85505fd2bcb6016237dcb006a) Fixes #721 - [mktime out of range] (#756) (@mistercrunch)
- [8a69235](https://github.com/apache/superset/commit/8a69235220844e2929a3fa7c80c6f30503652679) fix development env  req (#761) (@7rack)
- [b295436](https://github.com/apache/superset/commit/b295436bff6ad958fb75852d577f83c36667b4a0) [bugfix] refresh button on dashboard widget dones't work (@mistercrunch)
- [8cfe9e9](https://github.com/apache/superset/commit/8cfe9e96b86533ff5073cd1a3980e9646463a2b9) Preselect filters (#752) (@x4base)
- [65efe53](https://github.com/apache/superset/commit/65efe53bfc6b66a9e0c463d18df97fc7dd8145cc) Adding in Second and Minute time grains for MySQL (#696) (@alanmcruickshank)
- [09c95fb](https://github.com/apache/superset/commit/09c95fb28a4497a90f529f1f6adc3b2df1d8a3c7) Fix the mapbox for Druid (#725) (@x4base)
- [212284c](https://github.com/apache/superset/commit/212284cbd445ee6d8123d419951804b3ec5fd53f) viz: make sunburst work again (#728) (@xrmx)
- [082645d](https://github.com/apache/superset/commit/082645d31298d9b5d9c8baf2c3ab7d3da6893b43) [bugfix] html points to dashboard.entry.js instead of jsx (#749) (@mistercrunch)
- [18b8e6f](https://github.com/apache/superset/commit/18b8e6fa5816982263faaaf6f49a45c6a0fe58b1) make show columns explicit, don't show password column (#748) (@ascott)
- [9d7c05a](https://github.com/apache/superset/commit/9d7c05a015a526756a766295565786c83089c90d) [hotfix] fix py3 compatibility broken by basestring (@mistercrunch)
- [3c92ba9](https://github.com/apache/superset/commit/3c92ba9bd57f412e1ebf7f610c1b7a630c0ba53c) Fix bugs in the world map and deal with edge cases (#722) (@x4base)
- [00970d6](https://github.com/apache/superset/commit/00970d6b99e49313d5ef0f8f486ba9367366064e) Fix erroneous options for default slices (#730) (@georgeke)
- [979782d](https://github.com/apache/superset/commit/979782d1cfc492d8c609cf02eea0d449bc9abe3f) Fix path for windows platfrom (#742) (@tienhv)
- [04f3e3b](https://github.com/apache/superset/commit/04f3e3bc8f989185c3d39f7545ff5347a91e6a44) "Add Slices" modal on dashboard page (#678) (@georgeke)
- [afff788](https://github.com/apache/superset/commit/afff78868f37e6b59d39ee304860a462fd78d439) remove console.log (#729) (@ascott)
- [8020464](https://github.com/apache/superset/commit/80204646020a77008c40e096437404b1dbb8942d) [explore] convert query and save btns to react (#690) (@ascott)
- [8135c24](https://github.com/apache/superset/commit/8135c240dc178014f03c943ba1b9beab26716325) Revert "Binding key Q to the running the query in explore view" (#713) (@mistercrunch)
- [1998314](https://github.com/apache/superset/commit/19983147a369ec76ecc30b6ecc82048dbc945b57) Binding key Q to the running the query in explore view (#685) (@mistercrunch)
- [d5b22dd](https://github.com/apache/superset/commit/d5b22dd86ef3f68d81864f29b6a3682f161c03fc) Filter empty strings or nulls, and add more operators (#704) (@x4base)
- [917bc98](https://github.com/apache/superset/commit/917bc984eb5ba52939b857b3280d2f77334f27bc) Make DruidDatasource.version_higher support funky version strings (#706) (@mistercrunch)
- [1a952a4](https://github.com/apache/superset/commit/1a952a496102b28cf60d9b31d53ded28337e8971) Dashboards can only be deleted by their owners (#701) (@x4base)
- [ee00aa6](https://github.com/apache/superset/commit/ee00aa65221c670492e1ba498e4b31b0348eda99) some Chinese simplified translation work (#710) (@lucky2you)
- [2e0e6e3](https://github.com/apache/superset/commit/2e0e6e33426dd26b3c2b3f8570e8e5f66a047a97) [quickfix] support isNaN aggregates in Table viz (@mistercrunch)
- [d4641e4](https://github.com/apache/superset/commit/d4641e44570c37560840f9f1a628a7d2be729587) [docs] FAQ how do I create my own viz? (@mistercrunch)
- [8b95d17](https://github.com/apache/superset/commit/8b95d17b7b33c4ca9f15130707128bb377ea6059) [quickfix] embeded view missing some dependencies (@mistercrunch)
- [f407bd4](https://github.com/apache/superset/commit/f407bd45fd118d7d315b18e7f4385422a2beca8e) [quickfix] fix broken CRUD column header links (@mistercrunch)
- [fa65888](https://github.com/apache/superset/commit/fa658885904b88e5fe9f4856bf54f06fbc7f40c8) Screenshot makeover in README (@mistercrunch)
- [dbb9356](https://github.com/apache/superset/commit/dbb9356d7e4c9f9e809fc42d6705542b83de6e79) Changelog updates for 0.10.0 (@mistercrunch)
- [1ac2fcc](https://github.com/apache/superset/commit/1ac2fccd2aa736bde485af83b24c96007c6715eb) fix small issue of dttm PR (#688) (@yxjames)

### 0.10.0 (2016/06/28 23:42 +00:00)
- [bd68378](https://github.com/apache/superset/commit/bd68378d9c065b4c538f91b5b9cdb8937b7c9a23) Saving slices and adding them to dashboards directly from explore view (#680) (@mistercrunch)
- [7a7f61a](https://github.com/apache/superset/commit/7a7f61a2965e0f869328da3308fae92dab859365) datetime format and database expression on column level (#652) (@yxjames)
- [6a34b72](https://github.com/apache/superset/commit/6a34b729e95bee8a6084b9080d5cc2c31dc5f220) Adapting Babel to new FAB version, regenerating translations (#684) (@mistercrunch)
- [4191b75](https://github.com/apache/superset/commit/4191b75966bdfec22a4dcb04eb62f6884765d55d) Adding padding to markup widget (@mistercrunch)
- [d5b8414](https://github.com/apache/superset/commit/d5b8414fde5e1a000f0faab9b801ba899959560a) Showing only dashboards on welcome page (#676) (@mistercrunch)
- [57ebb2b](https://github.com/apache/superset/commit/57ebb2bacf40653022450446a0d2c8eb5df566ac) Map visualization (#650) (@georgeke)
- [914f234](https://github.com/apache/superset/commit/914f23432fed91c877eecc5f1a4f88c6957677b1) Make text in sunburst path more readable (#675) (@mistercrunch)
- [967b2ff](https://github.com/apache/superset/commit/967b2ffeb074521dbd8c4b60e401596cd9047a94) Only creating perms for restricted metrics (#655) (@mistercrunch)
- [1313727](https://github.com/apache/superset/commit/131372740e79fa0d6ebd7484026cb9ac5918f631) Adding orderby to Table 'not grouped by' and fixing metrics ordering (#669) (@mistercrunch)
- [51024b5](https://github.com/apache/superset/commit/51024b5f8a7d5480ab18112cb28e460ed01620f1) Reintroducing showControls as an option (#672) (@mistercrunch)
- [141dc12](https://github.com/apache/superset/commit/141dc12e445f5a1bbaa720b988b135b01d329789) Adding quarter time grain for Presto (@mistercrunch)
- [e230d9d](https://github.com/apache/superset/commit/e230d9db4a06ba48886ff6ba0139a19c62515463) Don't force formatting when using "Period Ratio" (#668) (@mistercrunch)
- [4a8e62b](https://github.com/apache/superset/commit/4a8e62b4395cd44c50a7c3d98cc268732a7f21a2) Fixing the examples's dashboard positioning (#667) (@mistercrunch)
- [f949b88](https://github.com/apache/superset/commit/f949b88ebd6f6ef5097b5d38d8475837be2b9023) A cleaner right side of the navbar with a Github link (#666) (@mistercrunch)
- [ab71ee4](https://github.com/apache/superset/commit/ab71ee4f93abe6a2f83f367258fcc6f812640008) Make the headers of tables and pivot tables fixed (#651) (@x4base)
- [30da408](https://github.com/apache/superset/commit/30da408ace200e98acb810200dc169e032f565ac) Druid Intervals Issues prevents metadata pull (#526) (@kkalyan)
- [485234b](https://github.com/apache/superset/commit/485234bc78a568c7360cd1f801cc7a9fb7571f77) Add having filters (#553) (@x4base)
- [13095eb](https://github.com/apache/superset/commit/13095eb550efb59062975df16f5516a3eb076bcd) Show right messages as soon as possible (#632) (@x4base)
- [40e1787](https://github.com/apache/superset/commit/40e17879486d47074d3e53997fd1b2645afe8615) Improve the error message in the slices (#555) (@x4base)
- [7e8053a](https://github.com/apache/superset/commit/7e8053abef59d80a52a0e55fbbfa9ed26f45ba91) Adding list of table names to show Dashboard view (#648) (@mistercrunch)
- [d71a67c](https://github.com/apache/superset/commit/d71a67cdad3915eb1dd282f555ab26d61982e595) Bumping FAB and cryptography to current version (#647) (@mistercrunch)
- [5618df7](https://github.com/apache/superset/commit/5618df78f8e89799b58d821f0f65d1882565d0e0) Added documentation of the health check endpoint (#644) (@alanmcruickshank)
- [668ede1](https://github.com/apache/superset/commit/668ede1133e61edaf12157e46b42e817a1ab8932) expose /slice/<slice_id>/ endpoint to redirect to a slice's url (#633) (@williaster)
- [deb197a](https://github.com/apache/superset/commit/deb197a1d80bf7fd02f57627cc87238ce0c8038e) Adding contribution to total option to Bar chart (#641) (@mistercrunch)
- [55c549d](https://github.com/apache/superset/commit/55c549d86f6c6ba6a207cee17a5595783945c1b9) Adding option for reduceXTicks (#640) (@mistercrunch)
- [4c8523e](https://github.com/apache/superset/commit/4c8523efc057421e9f19f0302faa92ca82065849) Prevent potential db upgrading problem (#628) (@yxjames)
- [4400c70](https://github.com/apache/superset/commit/4400c705144046520956ca9959ecf4321e01e403) Make time grains translatable (#622) (@xrmx)
- [3105c9f](https://github.com/apache/superset/commit/3105c9f9aefed64a13ec49c8cd6f909af77d8347) Improvments to NVD3 charts (axis labels & min bar width) (#629) (@mistercrunch)
- [db30f20](https://github.com/apache/superset/commit/db30f203410eaa9e650b2f1854561120786a608f) Only initiate permissions of valid metrics (#630) (@x4base)
- [65d9feb](https://github.com/apache/superset/commit/65d9feb0a9fa671942b6c81d6c38e18e2bd560e3) Check ownership before a slice is deleted (#624) (@x4base)
- [77c5c94](https://github.com/apache/superset/commit/77c5c9400a62261a8054e95406b7a86bb6a09749) Update sql.js to fix a invalid error msg (#621) (@rocky1001)
- [5de8740](https://github.com/apache/superset/commit/5de8740a389969889b1eca2199495ec80571e816) minor correction on the right npm path (#618) (@peijiche)
- [ea8a7ec](https://github.com/apache/superset/commit/ea8a7ec1ba26393047f70bcacd335b9e22fc63b8) Redirect to druid datasource page when the user wants to add slice. Also, provide a link to the table page (#625) (@x4base)
- [b38590a](https://github.com/apache/superset/commit/b38590a0bb8234de2441b6db1b004291664c5803) Added Hour time grain for MySQL (#615) (@alanmcruickshank)
- [ee2d333](https://github.com/apache/superset/commit/ee2d3330aa612e0ae8fb30c1da19e4fd8f18fe98) Prevent the cannot-overwrite error message from being removed before it can be seen (#626) (@x4base)
- [aa2b8b4](https://github.com/apache/superset/commit/aa2b8b42d074f30ba301517a7f4a012c8c6639ef) Updating CHANGELOG (@mistercrunch)

### 0.9.1 (2016/06/15 16:46 +00:00)
- [d90a2c8](https://github.com/apache/superset/commit/d90a2c861aa02aff6cb634121bec7a1e48acbda6) Pinning all dependencies to specific versions (#627) (@mistercrunch)
- [a117498](https://github.com/apache/superset/commit/a11749899180c023a68b8f68a8061ed060c150d5) Adding some CRUD field descriptions to clarify things (@mistercrunch)
- [e29d71d](https://github.com/apache/superset/commit/e29d71d0ffb06ef401916a6ccac53edc59f5f75d) [hotfix] passing payload to Slice.done everywhere (@mistercrunch)
- [bacbd90](https://github.com/apache/superset/commit/bacbd909d1a76eb6b55690319d7a08341799affe) [hotfix] parallel coordinates grey background on hover (@mistercrunch)
- [77d8ccb](https://github.com/apache/superset/commit/77d8ccba87696e3819cfba82c9690e2aae20e515) Compress before caching, store more in each memcache key (#614) (@mistercrunch)
- [347c39b](https://github.com/apache/superset/commit/347c39b8e96828882c6033f57ae095b043642a30) Better support for Druid cardinality estimation mertics (#613) (@axeisghost)
- [bc58c5d](https://github.com/apache/superset/commit/bc58c5d03128a517e9501d2b642c2a090a6db2de) [hotfix] delete cache key when set fails (@mistercrunch)
- [267c019](https://github.com/apache/superset/commit/267c0191a810ca148125d79c86fd67cc88bb3f1a) Make sure cache.set never fails hard (#611) (@mistercrunch)
- [9ed8c32](https://github.com/apache/superset/commit/9ed8c32f762ebb5f14df0e60a5cc84b9203f8cad) Cranking up FAB to latest (1.7.1) version (#609) (@mistercrunch)
- [1a4c7af](https://github.com/apache/superset/commit/1a4c7afbef9e4439aa32d44a7b28a1840ba1a48a) Fixing a potential FK error when doing bulk updates (#606) (@mistercrunch)
- [c58fd63](https://github.com/apache/superset/commit/c58fd63efce09479aeabcfc5faa5cfabcbd6c9fa) [hotfix] caching indicator was missing on dashboard view (@mistercrunch)
- [fa13b77](https://github.com/apache/superset/commit/fa13b77cfabe6b359f0c3557e20f29c6cc71e356) Adding postgres to the build matrix (#604) (@mistercrunch)
- [c490138](https://github.com/apache/superset/commit/c490138afed46f32a5446254c5af6890b7304967) Fixing json issues (#602) (@mistercrunch)
- [327fcee](https://github.com/apache/superset/commit/327fceefb763fdff1b2c072cd2e52ce586da7421) [hotfix] fixes issue around multidict (@mistercrunch)
- [1631137](https://github.com/apache/superset/commit/1631137da1448770c75028c3a787e957bda1b997) fix missing multiple values for the same parameter name (#565) (@Marigold)
- [4661b02](https://github.com/apache/superset/commit/4661b0210ddb5e90739eee69bc2a5262b060747c) Popover to generate iframe html tag when standalone button is clicked (#575) (@axeisghost)
- [a8136bb](https://github.com/apache/superset/commit/a8136bb9f536319003b8f29d26816d5d9fbb425b) Update translations files (#595) (@xrmx)
- [4c6026f](https://github.com/apache/superset/commit/4c6026fddac9342c4667e01980cf6b0201af81f7) Add access control over metrics (#584) (@x4base)
- [55baab4](https://github.com/apache/superset/commit/55baab413a5a15b51471393318004ff84be62ec9) [hotfix] fixing the build (#594) (@mistercrunch)
- [2f60801](https://github.com/apache/superset/commit/2f60801059e188e6d7907733bb3c7fc300b3b3f1) [hotfix] fixing the build (@mistercrunch)
- [2644dd1](https://github.com/apache/superset/commit/2644dd19848f7b0934c5893cbaef2e723cd43cd5) Adding a test for welcome page (@mistercrunch)
- [c35e0e8](https://github.com/apache/superset/commit/c35e0e831c977b4d1976a0c047dc3ecd4e9a5086) [hotfix] csv and json link are off (#592) (@mistercrunch)
- [60ed3e4](https://github.com/apache/superset/commit/60ed3e40507cf428f5dd3598a22af08e3de96037) TOX / Travis build matrix (#593) (@mistercrunch)
- [dd662ea](https://github.com/apache/superset/commit/dd662eaca345adcb57b3cde4a2afeeaffdce1437) caravel: mark more strings for translations in viz (#586) (@xrmx)
- [e3da785](https://github.com/apache/superset/commit/e3da7853212320eed0d16b146705110c5d15d0dc) caravel: reduce usage of choicify in forms (#591) (@xrmx)
- [f4c92da](https://github.com/apache/superset/commit/f4c92da4e67a66a8a6544801bf84cb402c4fc484) Make sure the APP_ICON config is used in the template (#590) (@jeremi)
- [eb208b9](https://github.com/apache/superset/commit/eb208b921c52ff0217dcd70618c3ab779f82efb2) config: there's no such thing as WEBSERVER_THREADS (#587) (@xrmx)
- [8a579e2](https://github.com/apache/superset/commit/8a579e2a2a621937c4caa8f3c748df995336fc2a) Mark more strings for translations (#581) (@xrmx)
- [cdb573e](https://github.com/apache/superset/commit/cdb573e7937327d0279ec7c0f12cde391c03972e) caravel: add missing test requirements in setup.py (#582) (@xrmx)
- [ad5507c](https://github.com/apache/superset/commit/ad5507c5f4bc10fbeba3000763803b17bb11ae09) views: translate labels and not names (#567) (@xrmx)
- [24a68f5](https://github.com/apache/superset/commit/24a68f5c48159a1360fd72a99055945dbd5a9746) Two hotfixes (#574) (@georgeke)
- [0d800fa](https://github.com/apache/superset/commit/0d800fa302878a8b26ccc48850376d01f95dcd0f) Fixing bugs where params aren't reflected on nvd3* (#564) (@mistercrunch)
- [dc33506](https://github.com/apache/superset/commit/dc33506bfa6f05d9c0ccd00bd27f66f8b058fee4) Removing deprecated refs to flask.ext.* (#566) (@mistercrunch)
- [89f9efd](https://github.com/apache/superset/commit/89f9efd3a3de9316d5163ccc68d74d8802b90406) Fixing the dashboard's look after resizing the window (#556) (@mistercrunch)
- [52c2b23](https://github.com/apache/superset/commit/52c2b2348aebea0a7da0be4fa2117d99e7d09c8d) allow for multiple columns in NOT GROUP BY (#560) (@georgeke)
- [b5fe9db](https://github.com/apache/superset/commit/b5fe9dbe336b1b93cfcadf9350ba5343b9150224) Adding a security section to the docs (#561) (@mistercrunch)
- [5bc5021](https://github.com/apache/superset/commit/5bc50210ad665f3d0348326b49c81d97011b36f3) utils: generalize utility to find find_constraint_name (#557) (@xrmx)
- [fe40246](https://github.com/apache/superset/commit/fe402465b164cf35a629e7de2e6e1d76267ceca4) caravel: catch only ImportError when loading config (#559) (@xrmx)
- [3ee9a68](https://github.com/apache/superset/commit/3ee9a68c09750317f20eedd3968e9f36f6da10a1) Only owners can update their objects (#507) (@mistercrunch)
- [2917051](https://github.com/apache/superset/commit/29170512ab1567301e159dca46544459684ba201) Adapting default CSS templates to the new grid layout (@mistercrunch)
- [b5614a4](https://github.com/apache/superset/commit/b5614a433ef2acc8650c2a0a672c8da227db3d31) Fixing 2 bugs that happen when fields are removed from table (#551) (@mistercrunch)
- [5f005d6](https://github.com/apache/superset/commit/5f005d67e3213e67e0fc7b663c3dc68ad42780ab) Add CORS support (#478) (@itajaja)
- [c78d368](https://github.com/apache/superset/commit/c78d3682ac6a6f155e0aa239175290dd15ee11a0) Reactify dashboard grid (#523) (@georgeke)
- [fe6628b](https://github.com/apache/superset/commit/fe6628b0a411929c06a5454cc154d4afeb192035) Fix #529 2 - "This Session's transaction has been rolled back" (#531) (@LAlbertalli)
- [cb384d0](https://github.com/apache/superset/commit/cb384d051badcc9823f24a6491bcbe3cdb9dee7e) Fix for Not Grouped By on Table View (#544) (@georgeke)
- [849063c](https://github.com/apache/superset/commit/849063c797ed2d79d932f01712175e841711c803) fix world_map appending to old world map when updating (#549) (@georgeke)
- [087c47a](https://github.com/apache/superset/commit/087c47a37e45bb9c2608bbb2279188b59547e449) Fix #529 1 "This Session's transaction has been rolled back" (#530) (@LAlbertalli)
- [b193539](https://github.com/apache/superset/commit/b193539fa40a9803e85229481fb44510430f8131) i18n: Fix typo in Druid cluster broker port label (#512) (@xrmx)
- [ae7fb01](https://github.com/apache/superset/commit/ae7fb012a95c2b919b8e2f7f10ddaf935da6fdf5) Added support for Vertica Grains (#515) (@LAlbertalli)
- [409233d](https://github.com/apache/superset/commit/409233d4fc2f935ce5014186915bfb801157596d) Update models.py (#541) (@Jimexist)
- [7d27692](https://github.com/apache/superset/commit/7d276928286687e528318532a9a26ceb597203b5) [hotfix] forcing newer pydruid version (@mistercrunch)
- [dee4c34](https://github.com/apache/superset/commit/dee4c344116baf8e97e2125333e24cba68219aa8) [hotfix] adapting to pydruid 0.2.3 (@mistercrunch)
- [eb3bfb5](https://github.com/apache/superset/commit/eb3bfb5c5657c6048c48bd982e6e35f17618bcaf) Cranking FAB to 1.6.2 (#505) (@mistercrunch)
- [57990bf](https://github.com/apache/superset/commit/57990bfd835936726077964ff84f232704915bc0) Implementing druid's regex filters (#501) (@mistercrunch)
- [29f5ace](https://github.com/apache/superset/commit/29f5ace4368968d27b34347f33679dea23a56b9d) complete Chinese translation (#503) (@Xuefeng-Zhu)
- [0fcab30](https://github.com/apache/superset/commit/0fcab30652f1b41104f1bc27c151ca34d2159583) More translation instrumentation and some french to test (#502) (@mistercrunch)
- [c53874c](https://github.com/apache/superset/commit/c53874c8ab5457c94c6e5f00e5cbe2510bbd33db) [hotfix] treemap was broken (@mistercrunch)
- [e77d50b](https://github.com/apache/superset/commit/e77d50bc61f00674a555078d73179f5997195579) Adding a doc page for Druid (@mistercrunch)
- [f0c6a98](https://github.com/apache/superset/commit/f0c6a980271bdd52892b61ef9d5f5fbe3753d286) Gunicorn tweaks, unlimited limit-request-line & limit-request-field_size (#500) (@mistercrunch)
- [58d78be](https://github.com/apache/superset/commit/58d78beeaa8a1441c711f6399ef5e662c899a077) [bugfix] 'Y Axis Zero' would force 1 in Y axis (#497) (@mistercrunch)
- [e1a3854](https://github.com/apache/superset/commit/e1a3854f2a4ce44ea14a66796a0a53ca57f2b537) utils: add special serializer for numpy.int64 (#492) (@xrmx)
- [7630d73](https://github.com/apache/superset/commit/7630d73002e15f38215fcf03fa5b41da1660fe08) fix typo (#484) (@benoitf)
- [3cfc58e](https://github.com/apache/superset/commit/3cfc58e3a23d768028ac91df08ac1efa99f8cef8) Add italian translation (#491) (@xrmx)
- [3ee102b](https://github.com/apache/superset/commit/3ee102b79f3204a9a2e475066dad5f3032d3f14d) Made '__' prefix into suffix. (#496) (@joshwalters)
- [f5180d8](https://github.com/apache/superset/commit/f5180d8724272540c911a9d4a91325fd356c91e5) [hotfix] fix name change on test dashboard triggers error (@mistercrunch)
- [4738b01](https://github.com/apache/superset/commit/4738b011256c7ea83337aa4e4313c140af05a33c) [hotfix] setting default value for druid_time_origin (@mistercrunch)
- [d1f0276](https://github.com/apache/superset/commit/d1f0276408301581dc96955c585aff49539dfc5f) Introducing Horizon charts (#472) (@mistercrunch)
- [1766f6e](https://github.com/apache/superset/commit/1766f6edd6b3e6e427a6994603e5a7dd7af9fc04) [hotfix] making druid_time_origin stick (@mistercrunch)
- [8a406b1](https://github.com/apache/superset/commit/8a406b18f5cce1b4a941e05bd53e98ed3fddb28a) Add PUBLIC_ROLE_LIKE_GAMMA config flag (#473) (@asydorchuk)
- [2620aec](https://github.com/apache/superset/commit/2620aeca02ab2971153decaa154cbcd1ce3b7093) Fixing the heatmap calendar color ranges in the Welcome page (#474) (@mistercrunch)
- [5c0e30e](https://github.com/apache/superset/commit/5c0e30ed70743563e0ee86e10c28a4212026dd71) Added Calendar Heatmap (#475) (@georgeke)
- [607e1f9](https://github.com/apache/superset/commit/607e1f941bdc19ebc9850657a8d2124f32217ba5) Fixing the build 2 out of 2 (@mistercrunch)
- [d305679](https://github.com/apache/superset/commit/d30567959bb25e5211ed11d506dfea34607a2571) [fixing the build] a new version of eslint is more picky (@mistercrunch)
- [83e0e58](https://github.com/apache/superset/commit/83e0e58888dc02482c994f32032307289acd373e) [hotfix] Druid explore/table dropdown doesn't change anything (@mistercrunch)
- [5a870fe](https://github.com/apache/superset/commit/5a870fe1c2b98dcbb8b10253f5731bbe2e8915b6) Mysql key length (#459) (@x4base)
- [d846cb3](https://github.com/apache/superset/commit/d846cb3d73452f304a197cc07a6e49fefcaea049) Updating changelog (@mistercrunch)

### 0.9.0 (2016/05/12 15:24 +00:00)
- [a0099ad](https://github.com/apache/superset/commit/a0099ad6d673163facc7134e93e6eb87f7a29eb2) v0.9.0 (@mistercrunch)
- [f28c2b2](https://github.com/apache/superset/commit/f28c2b2557a56725c900d30bef06e8953c394e4f) Cosmetric tweaks in the CRUD list view (#458) (@mistercrunch)
- [52bbb38](https://github.com/apache/superset/commit/52bbb38188505c2f1b03be3f352b5befed0328af) Don't limit parallel coordinates table size (#455) (@mistercrunch)
- [aa6e6bd](https://github.com/apache/superset/commit/aa6e6bdf7a29a00d7160f26f625d60321f9186cc) Allowing for templated urls in iFrame (#460) (@mistercrunch)
- [6c333d5](https://github.com/apache/superset/commit/6c333d50108f6ccb0c3997e9f687cfceb3e85552) Fixing the missing searchbox bug (#431) (@mistercrunch)
- [673cce9](https://github.com/apache/superset/commit/673cce9e561d9f264d70efb0ac2449fab64d05d1) Attempting to fix #412 (#430) (@mistercrunch)
- [d79089c](https://github.com/apache/superset/commit/d79089c5874cab21709cf473d27f75aaa55c72ce) Improving the parallel coordinate viz (#452) (@mistercrunch)
- [c4e3020](https://github.com/apache/superset/commit/c4e3020369fe883afa581d1eda1eeed054521925) Conververting datetime based on database dialects (#446) (@mistercrunch)
- [77e9e6a](https://github.com/apache/superset/commit/77e9e6a5d70e589b282eb9c0a60c93ac96b7899e) Fixing issue #444 color function chokes on non-string param (#447) (@mistercrunch)
- [a75d6bc](https://github.com/apache/superset/commit/a75d6bc52ca7677099e361671e31486fbf112507) add timestamp toggle in chart options (Table Viz) (#439) (@sid88in)
- [c5fcbc0](https://github.com/apache/superset/commit/c5fcbc07097810ec3d562f314bc3d78491aabe44) Support hyperUniqueCardinality type in post aggregation (#451) (@x4base)
- [2f64c42](https://github.com/apache/superset/commit/2f64c42062dc041408371dd0cecddd940e0bcf47) blacklist druid datasources to be refreshed because it takes forever to load all druid datasources metadata which is not even required (given the use cases user should be able to blacklist data sources which are not required to be refreshed). (#441) (@sid88in)
- [d304ee0](https://github.com/apache/superset/commit/d304ee005a976b2582f0be3b5bfc8cd9aa7c60e8) Bugfix in line chart where the series name is an empty string (#434) (@mistercrunch)
- [82fa501](https://github.com/apache/superset/commit/82fa501deacc9b1f9c3207f0b449c9387be5f7ab) Update Chinese translation (#438) (@liaojunshuo)
- [bc71707](https://github.com/apache/superset/commit/bc7170769baf6cbcebeaa1ee05188315291269f3) Recursively get the dependency fields of post aggregators (#437) (@x4base)
- [6941f1d](https://github.com/apache/superset/commit/6941f1de64795fae017a14b1dd1aedfcd2d71869) add unicode data to tests (#432) (@andrewhn)
- [a3f549b](https://github.com/apache/superset/commit/a3f549bb9e55affc0da46dfe6f8a4b721905f716) Some chinese translations as a Proof of Concept (#435) (@mistercrunch)
- [0bedaed](https://github.com/apache/superset/commit/0bedaed3676c2185aff8f0de52f07fd40b45b985) Make sure anonymous user with proper permissions can access data (#415) (@asydorchuk)
- [1d0863a](https://github.com/apache/superset/commit/1d0863abfe9295b4287bc07647265ddc4cb93d12) Rename the dummy variable _ to avoid conflict with lazy_gettext (#427) (@x4base)
- [a3a9ec9](https://github.com/apache/superset/commit/a3a9ec926fbb74dec6b427015109f04ebb592a3c) [hotfix] piechart goes black on refresh (#424) (@mistercrunch)
- [a8d0ae1](https://github.com/apache/superset/commit/a8d0ae1361e9816fca681b78b55a7becec52ff74) Fix name of test script in contributing guide (#428) (@itajaja)
- [9a08c45](https://github.com/apache/superset/commit/9a08c45e593cd3c25cea8814d02377fde85b3747) add additional postgres and redshift time grains (#429) (@itajaja)
- [88c9516](https://github.com/apache/superset/commit/88c9516e20bbfd1f5fb9ec478cc9a1624f6eed33) Getting started on translations (#423) (@mistercrunch)
- [ec7dbed](https://github.com/apache/superset/commit/ec7dbed800d42b6e0bd6e480939196b5ad1010a6) Blank theme (#419) (@mistercrunch)
- [26d2736](https://github.com/apache/superset/commit/26d273643b9798af24e8e55303e8eeb41297d36d) Allowing for druid post aggregations (#418) (@mistercrunch)
- [0ca3f5e](https://github.com/apache/superset/commit/0ca3f5ec800b5543747a00f24377a86a6f017226) Improving SQLA query generation (#421) (@mistercrunch)
- [d7ea473](https://github.com/apache/superset/commit/d7ea47387f13f13e6586cc8d897bcf25dfb45827) enable timerotateloghandler (configurable) (#311) (@sid88in)
- [7b5b602](https://github.com/apache/superset/commit/7b5b602e962c20fc745909994075c7bbdc54d8e5) Use batch_alter_table to drop column in the migration script (#406) (@x4base)
- [b78ec54](https://github.com/apache/superset/commit/b78ec54650e1602d800f73cc7bd8a49eebdd0835) Merge pull request #414 from airbnb/chris/fix-sunburst-level-trunc (@williaster)
- [77e4d4b](https://github.com/apache/superset/commit/77e4d4b2d4e0e2f29998896b1089c0a78330144c) Fixgin README link (@mistercrunch)
- [2198fd4](https://github.com/apache/superset/commit/2198fd4e3d0ea2d19e3539f05f17a3c2c675ded3) Adding badge for python versions (@mistercrunch)
- [bd47a29](https://github.com/apache/superset/commit/bd47a29076c4558b907554d97eccb35bf67f8b50) CHANGELOG update (@mistercrunch)

### 0.8.9 (2016/04/28 02:38 +00:00)
- [337c9d5](https://github.com/apache/superset/commit/337c9d59ae68778ecea84afee999c9799fcf9d5f) v0.8.9 (@mistercrunch)
- [54860a8](https://github.com/apache/superset/commit/54860a874c69e7d13e2bd0c57eb29c9d6f472511) Adding reference to another docker image in READMEM (@mistercrunch)
- [89d1a77](https://github.com/apache/superset/commit/89d1a77281b83a3d86835a70a936b71cee67b3e1) [hotfix] filter_immune_slices fix (@mistercrunch)
- [b634d03](https://github.com/apache/superset/commit/b634d03ac3d5ce36b8b44805e18bb26bc0c08be4) Show only Slices and Dashboards users have access to (#404) (@mistercrunch)
- [ab64a26](https://github.com/apache/superset/commit/ab64a26b5b7d5cad88e5fd8f48865a685c339bea) fix img loading overlay in explore view (#403) (@mistercrunch)
- [a2f2ad8](https://github.com/apache/superset/commit/a2f2ad84da3e98d6fa51af670a7d1a4f51826243) add navigation, zoom to treemap (#396) (@andrewhn)
- [c0fb9ee](https://github.com/apache/superset/commit/c0fb9eeca484c00647117645ce620edb6cdaba24) [bugfix] big_number doesn't fadeout on hover (@mistercrunch)
- [42ac46c](https://github.com/apache/superset/commit/42ac46c1e15b6b446491b6d3f7020f59f45e41b4) [bugfix] fix context confusion in Slice (@mistercrunch)
- [7b10759](https://github.com/apache/superset/commit/7b1075990cfb89a6bd12761c12e25dd38e9a169f) [hotfix] periodic refresh dashboard feature had broken caching (@mistercrunch)
- [37be01b](https://github.com/apache/superset/commit/37be01bc1261599dd381181e3dc9eeb4506c31c3) [hotfix] adding cache_key in payload (@mistercrunch)
- [7d90f26](https://github.com/apache/superset/commit/7d90f265548d38c89999867e16b31f5c00ef78fb) Fixing #388 (#391) (@mistercrunch)
- [f1e10d8](https://github.com/apache/superset/commit/f1e10d8d25eba04fd5326d77ee3028bef893b9d2) One more Druid test (#387) (@mistercrunch)
- [b01d378](https://github.com/apache/superset/commit/b01d3784756f8ea5d8e7eab391c1823df22aa38a) Fix the label of the periodic-refresh button (#386) (@x4base)
- [a5f33fe](https://github.com/apache/superset/commit/a5f33fecd81ce1c86859856bdc1a3a4f73b7893c) Adding login call for Druid test (@mistercrunch)
- [f4177bf](https://github.com/apache/superset/commit/f4177bfa9481a04cd3293216ad25fb671dcb6ac0) More examples / tests (#385) (@mistercrunch)
- [d8a2b62](https://github.com/apache/superset/commit/d8a2b621d8b4895560be0eca6529e8a52d62be2b) Periodically update the slices in the dashboard (#374) (@x4base)
- [9a33557](https://github.com/apache/superset/commit/9a335571128a012aa042ba95b44daf21624b9546) Removing forgotten print statement (@mistercrunch)
- [efc6bf4](https://github.com/apache/superset/commit/efc6bf4eb8f9b4619e334c2e896242dc1a08c80b) Redirect application log to stderr, which is picked up by gunicorn. (#335) (@coleslaw)
- [17e711f](https://github.com/apache/superset/commit/17e711fda2659cd025410ec8c4002475164cbb7f) Druid unit tests using Mock (#384) (@mistercrunch)
- [01a8c96](https://github.com/apache/superset/commit/01a8c96820f13639d33fcaeb3faf11f6494eb8f1) Specifying python versions supported in setup.py (#382) (@mistercrunch)
- [d96b634](https://github.com/apache/superset/commit/d96b634ded33353881907ba6c683f45d4ea32aaf) split sunburst breadcrumb names on '_' to apply ' '-dependent wrapping more freqently (#376) (@williaster)
- [afcdcf0](https://github.com/apache/superset/commit/afcdcf06a17319a19001f19e0cccbc7050b251b8) Fixing overwrite and save slice permissions for a give role (#298) (@sid88in)
- [5597eb4](https://github.com/apache/superset/commit/5597eb4cc4f8739016c66a5e18d3875fcca059f7) Fix db upgrade script b4456560d4f3 (#370) (@mistercrunch)
- [3f0171b](https://github.com/apache/superset/commit/3f0171b77be43adbce17a98b0e109e1935a6d96f) Configure Visualizations (#365) (@sid88in)
- [badcd8b](https://github.com/apache/superset/commit/badcd8bfa19ee7725509fe83bdd686a33482845d) Storing version number in only one place (#362) (@mistercrunch)
- [04f1b17](https://github.com/apache/superset/commit/04f1b176c49fc3d005178e18db39d08b8fc7de30) Fixes issue #364 (@mistercrunch)
- [899fe19](https://github.com/apache/superset/commit/899fe19afb5f0ded2e02a054d9c00060ed362590) [WiP] Attempting to support Druid's granularity origin as a hidden url param (#194) (@mistercrunch)
- [f316851](https://github.com/apache/superset/commit/f3168518e2d2dd45fa522d694db2bac433e87ea8) New url default for iframe viz (@mistercrunch)
- [04d769f](https://github.com/apache/superset/commit/04d769ff249e8c9e616133dc17639088438667cb) Some more error handling when rendering the explore view (#361) (@mistercrunch)
- [01c2c7b](https://github.com/apache/superset/commit/01c2c7baf88d3876d2f73ccf802376648797d060) Fixing unique constraint in SqlaTable model (#360) (@mistercrunch)

### 0.8.8 (2016/04/15 04:25 +00:00)
- [2d420ee](https://github.com/apache/superset/commit/2d420eee25b4c039350c72c5dea30d5eaaff88d8) v0.8.8 (@mistercrunch)
- [1a6757f](https://github.com/apache/superset/commit/1a6757f10a6e68377776cd498a5bb3cba66b7b09) Better type detection for inference of column matrix (#353) (@mistercrunch)
- [63e5e93](https://github.com/apache/superset/commit/63e5e932cb0c6ba80e4f21c1dcf