/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { t } from '@superset-ui/translation';
import styled from '@superset-ui/style';
import Button from 'src/components/Button';

type Callback = (...args: any[]) => void;

interface Props {
  height: number;
  width: number;
  onQuery: Callback;
}

const RefreshOverlayWrapper = styled.div`
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
  text-align: center;

  .refresh-btn {
    font-weight: ${({ theme }) => theme.typography.weights.bold};
  }
`;

class RefreshChartOverlay extends React.PureComponent<Props> {
  render() {
    return (
      <RefreshOverlayWrapper>
        <div>
          <Button
            className="refresh-btn"
            onClick={this.props.onQuery}
            bsStyle="primary"
          >
            {t('Run Query')}
          </Button>
        </div>
      </RefreshOverlayWrapper>
    );
  }
}

export default RefreshChartOverlay;
