/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.url;

import com.opensymphony.xwork2.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.url.QueryStringParser;
import org.apache.struts2.url.UrlDecoder;

public class StrutsQueryStringParser
implements QueryStringParser {
    private static final Logger LOG = LogManager.getLogger(StrutsQueryStringParser.class);
    private final UrlDecoder decoder;

    @Inject
    public StrutsQueryStringParser(UrlDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public Map<String, Object> parse(String queryString, boolean forceValueArray) {
        String[] params;
        if (StringUtils.isEmpty((CharSequence)queryString)) {
            LOG.debug("Query String is empty, returning an empty map");
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> queryParams = new LinkedHashMap<String, Object>();
        for (String param : params = queryString.split("&")) {
            if (StringUtils.isBlank((CharSequence)param)) {
                LOG.debug("Param [{}] is blank, skipping", (Object)param);
                continue;
            }
            String[] tmpParams = param.split("=");
            String paramName = null;
            String paramValue = "";
            if (tmpParams.length > 0) {
                paramName = tmpParams[0];
            }
            if (tmpParams.length > 1) {
                paramValue = tmpParams[1];
            }
            if (paramName == null) continue;
            this.extractParam(paramName, paramValue, queryParams, forceValueArray);
        }
        return queryParams;
    }

    private void extractParam(String paramName, String paramValue, Map<String, Object> queryParams, boolean forceValueArray) {
        String decodedParamName = this.decoder.decode(paramName, true);
        String decodedParamValue = this.decoder.decode(paramValue, true);
        if (queryParams.containsKey(decodedParamName) || forceValueArray) {
            Object currentParam = queryParams.get(decodedParamName);
            if (currentParam instanceof String) {
                queryParams.put(decodedParamName, new String[]{(String)currentParam, decodedParamValue});
            } else {
                String[] currentParamValues = (String[])currentParam;
                if (currentParamValues != null) {
                    ArrayList<String> paramList = new ArrayList<String>(Arrays.asList(currentParamValues));
                    paramList.add(decodedParamValue);
                    queryParams.put(decodedParamName, paramList.toArray(new String[0]));
                } else {
                    queryParams.put(decodedParamName, new String[]{decodedParamValue});
                }
            }
        } else {
            queryParams.put(decodedParamName, decodedParamValue);
        }
    }
}

