/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.oval.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.TextProviderFactory;
import com.opensymphony.xwork2.Validateable;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.interceptor.PrefixMethodInvocationUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.Validator;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.MethodReturnValueContext;
import net.sf.oval.context.OValContext;
import net.sf.oval.expression.ExpressionLanguage;
import net.sf.oval.localization.context.OValContextRenderer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.oval.annotation.Profiles;
import org.apache.struts2.oval.interceptor.ExpressionLanguageOGNL;
import org.apache.struts2.oval.interceptor.MethodNameExtractor;
import org.apache.struts2.oval.interceptor.OValValidationManager;
import org.apache.struts2.oval.interceptor.StrutsContextRenderer;

public class OValValidationInterceptor
extends MethodFilterInterceptor
implements MethodNameExtractor {
    public static final String STRUTS_OVAL_VALIDATE_JPAANNOTATIONS = "struts.oval.validateJPAAnnotations";
    private static final Logger LOG = LogManager.getLogger(OValValidationInterceptor.class);
    protected static final String VALIDATE_PREFIX = "validate";
    protected static final String ALT_VALIDATE_PREFIX = "validateDo";
    protected boolean alwaysInvokeValidate = true;
    protected boolean programmatic = true;
    protected OValValidationManager validationManager;
    protected boolean validateJPAAnnotations;
    protected TextProviderFactory textProviderFactory;
    private final ExpressionLanguage ognlExpressionLanguage = new ExpressionLanguageOGNL();

    public OValValidationInterceptor() {
        Validator.setContextRenderer((OValContextRenderer)new StrutsContextRenderer());
    }

    @Inject
    public void setValidationManager(OValValidationManager validationManager) {
        this.validationManager = validationManager;
    }

    @Inject
    public void setTextProviderFactory(TextProviderFactory textProviderFactory) {
        this.textProviderFactory = textProviderFactory;
    }

    @Inject(value="struts.oval.validateJPAAnnotations")
    public void setValidateJPAAnnotations(String validateJPAAnnotations) {
        this.validateJPAAnnotations = Boolean.parseBoolean(validateJPAAnnotations);
    }

    public void setProgrammatic(boolean programmatic) {
        this.programmatic = programmatic;
    }

    public void setAlwaysInvokeValidate(String alwaysInvokeValidate) {
        this.alwaysInvokeValidate = Boolean.parseBoolean(alwaysInvokeValidate);
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        ActionProxy proxy = invocation.getProxy();
        ValueStack valueStack = invocation.getStack();
        String methodName = proxy.getMethod();
        String context = proxy.getConfig().getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating [{}/{}] with method [{}]", (Object)invocation.getProxy().getNamespace(), (Object)invocation.getProxy().getActionName(), (Object)methodName);
        }
        this.performOValValidation(action, valueStack, methodName, context);
        this.performProgrammaticValidation(invocation, action);
        return invocation.invoke();
    }

    private void performProgrammaticValidation(ActionInvocation invocation, Object action) throws Exception {
        if (action instanceof Validateable && this.programmatic) {
            Exception exception = null;
            Validateable validateable = (Validateable)action;
            LOG.debug("Invoking validate() on action [{}]", (Object)validateable);
            try {
                PrefixMethodInvocationUtil.invokePrefixMethod((ActionInvocation)invocation, (String[])new String[]{VALIDATE_PREFIX, ALT_VALIDATE_PREFIX});
            }
            catch (Exception e) {
                LOG.warn("An exception occurred while executing the prefix method", (Throwable)e);
                exception = e;
            }
            if (this.alwaysInvokeValidate) {
                validateable.validate();
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    protected void performOValValidation(Object action, ValueStack valueStack, String methodName, String context) throws NoSuchMethodException {
        Object[] profileNames;
        Class<?> clazz = action.getClass();
        List<Configurer> configurers = this.validationManager.getConfigurers(clazz, context, this.validateJPAAnnotations);
        Validator validator = configurers.isEmpty() ? new Validator() : new Validator(configurers);
        validator.getExpressionLanguageRegistry().registerExpressionLanguage("ognl", this.ognlExpressionLanguage);
        Method method = clazz.getMethod(methodName, new Class[0]);
        Profiles profiles = method.getAnnotation(Profiles.class);
        if (profiles != null && (profileNames = profiles.value()) != null && profileNames.length > 0) {
            validator.disableAllProfiles();
            LOG.debug("Enabling profiles [{}]", (Object)StringUtils.join((Object[])profileNames, (String)","));
            for (Object profileName : profileNames) {
                validator.enableProfile((String)profileName);
            }
        }
        List violations = validator.validate(action);
        this.addValidationErrors(violations.toArray(new ConstraintViolation[0]), action, valueStack, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addValidationErrors(ConstraintViolation[] violations, Object action, ValueStack valueStack, String parentFieldname) {
        if (violations != null) {
            DelegatingValidatorContext validatorContext = new DelegatingValidatorContext(action, this.textProviderFactory);
            for (ConstraintViolation violation : violations) {
                String message;
                String key = violation.getMessage();
                valueStack.push((Object)violation.getMessageVariables());
                valueStack.push((Object)violation.getContext());
                try {
                    message = validatorContext.getText(key);
                }
                finally {
                    valueStack.pop();
                    valueStack.pop();
                }
                if (this.isActionError(violation)) {
                    LOG.debug("Adding action error '{}'", (Object)message);
                    validatorContext.addActionError(message);
                    continue;
                }
                ValidationError validationError = this.buildValidationError(violation.getContextPath(), message);
                String fieldName = validationError.getFieldName();
                if (parentFieldname != null) {
                    fieldName = parentFieldname + "." + fieldName;
                }
                LOG.debug("Adding field error [{}] with message '{}'", (Object)fieldName, (Object)validationError.getMessage());
                validatorContext.addFieldError(fieldName, validationError.getMessage());
                this.addValidationErrors(violation.getCauses(), action, valueStack, fieldName);
            }
        }
    }

    protected ValidationError buildValidationError(List<OValContext> contextPath, String message) {
        StringBuilder fieldName = new StringBuilder();
        String finalMessage = message;
        for (OValContext context : contextPath) {
            String className;
            if (fieldName.length() > 0) {
                fieldName.append(".");
            }
            if (context instanceof FieldContext) {
                Field field = ((FieldContext)context).getField();
                className = field.getDeclaringClass().getName();
                finalMessage = StringUtils.removeStart((String)finalMessage, (String)(className + "."));
                fieldName.append(field.getName());
                continue;
            }
            if (context instanceof MethodReturnValueContext) {
                Method method = ((MethodReturnValueContext)context).getMethod();
                className = method.getDeclaringClass().getName();
                String methodName = method.getName();
                finalMessage = StringUtils.removeStart((String)message, (String)(className + "."));
                fieldName.append(this.extractName(method));
                if (fieldName.length() != 0) continue;
                finalMessage = finalMessage.replaceAll(methodName + "\\(.*?\\)", fieldName.toString());
                continue;
            }
            fieldName.append(context.toStringUnqualified());
        }
        return new ValidationError(fieldName.toString(), message);
    }

    protected boolean isActionError(ConstraintViolation violation) {
        return false;
    }

    static class ValidationError {
        private final String fieldName;
        private final String message;

        ValidationError(String fieldName, String message) {
            this.fieldName = fieldName;
            this.message = message;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

