/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor.csp;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import java.net.URI;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.interceptor.csp.CspSettings;
import org.apache.struts2.interceptor.csp.DefaultCspSettings;

public final class CspInterceptor
extends AbstractInterceptor
implements PreResultListener {
    private static final Logger LOG = LogManager.getLogger(CspInterceptor.class);
    private final CspSettings settings = new DefaultCspSettings();
    private boolean disabled = false;

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        if (this.disabled) {
            LOG.trace("CSP interceptor has been disabled");
        } else {
            invocation.addPreResultListener(this);
        }
        return invocation.invoke();
    }

    @Override
    public void beforeResult(ActionInvocation invocation, String resultCode) {
        if (this.disabled) {
            return;
        }
        HttpServletRequest request = invocation.getInvocationContext().getServletRequest();
        HttpServletResponse response = invocation.getInvocationContext().getServletResponse();
        this.settings.addCspHeaders(request, response);
    }

    public void setReportUri(String reportUri) {
        Optional<URI> uri = this.buildUri(reportUri);
        if (!uri.isPresent()) {
            throw new IllegalArgumentException("Could not parse configured report URI for CSP interceptor: " + reportUri);
        }
        if (!uri.get().isAbsolute() && !reportUri.startsWith("/")) {
            throw new IllegalArgumentException("Illegal configuration: report URI is not relative to the root. Please set a report URI that starts with /");
        }
        this.settings.setReportUri(reportUri);
    }

    private Optional<URI> buildUri(String reportUri) {
        try {
            return Optional.of(URI.create(reportUri));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    public void setEnforcingMode(String value) {
        boolean enforcingMode = Boolean.parseBoolean(value);
        this.settings.setEnforcingMode(enforcingMode);
    }

    public void setDisabled(String value) {
        this.disabled = Boolean.parseBoolean(value);
    }
}

