/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.locale.LocaleUtil;

public class LocaleUrlDefinitionDAO
extends BaseLocaleUrlDefinitionDAO {
    public LocaleUrlDefinitionDAO(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public Definition getDefinition(String name, Locale customizationKey) {
        Map<String, Definition> defsMap = this.getDefinitions(customizationKey);
        return defsMap.get(name);
    }

    @Override
    public Map<String, Definition> getDefinitions(Locale customizationKey) {
        ArrayList<Locale> postfixes = this.computeLocales(customizationKey);
        HashMap<String, Definition> localeDefsMap = new HashMap<String, Definition>();
        for (Locale postfix : postfixes) {
            for (ApplicationResource resource : this.sources) {
                Map<String, Definition> defsMap;
                ApplicationResource newResource = this.applicationContext.getResource(resource, postfix);
                if (newResource == null || (defsMap = this.loadDefinitionsFromResource(newResource)) == null) continue;
                localeDefsMap.putAll(defsMap);
            }
        }
        return localeDefsMap;
    }

    private ArrayList<Locale> computeLocales(Locale customizationKey) {
        Locale postfix = customizationKey == null ? Locale.ROOT : customizationKey;
        ArrayList<Locale> postfixes = new ArrayList<Locale>();
        while (postfix != null) {
            postfixes.add(postfix);
            postfix = LocaleUtil.getParentLocale((Locale)postfix);
        }
        Collections.reverse(postfixes);
        return postfixes;
    }
}

