/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;

public class ExampleExpression
extends Expression {
    private final Expression subexpression;
    private final String example;

    public ExampleExpression(Expression subexpression, String example) {
        super(subexpression);
        this.subexpression = Preconditions.checkNotNull(subexpression);
        this.example = Preconditions.checkNotNull(example);
    }

    public Expression withSubexpression(Expression newSubexpression) {
        return newSubexpression.equals(this.subexpression) ? this : new ExampleExpression(newSubexpression, this.example);
    }

    public Expression getSubexpression() {
        return this.subexpression;
    }

    public String getExample() {
        return this.example;
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitExampleExpression(this);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof ExampleExpression && this.equals((ExampleExpression)that);
    }

    public boolean equals(ExampleExpression that) {
        return this.equalsExpression(that) && this.subexpression.equals(that.subexpression) && this.example.equals(that.example);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.subexpression, this.example);
    }
}

