/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.ognl.OgnlCache;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class OgnlLRUCache<Key, Value>
implements OgnlCache<Key, Value> {
    private final Map<Key, Value> ognlLRUCache;
    private final AtomicInteger cacheEvictionLimit = new AtomicInteger(2500);

    public OgnlLRUCache(int evictionLimit, int initialCapacity, float loadFactor) {
        this.cacheEvictionLimit.set(evictionLimit);
        this.ognlLRUCache = Collections.synchronizedMap(new LinkedHashMap<Key, Value>(initialCapacity, loadFactor, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Key, Value> eldest) {
                return this.size() > OgnlLRUCache.this.cacheEvictionLimit.get();
            }
        });
    }

    @Override
    public Value get(Key key) {
        return this.ognlLRUCache.get(key);
    }

    @Override
    public void put(Key key, Value value) {
        this.ognlLRUCache.put(key, value);
    }

    @Override
    public void putIfAbsent(Key key, Value value) {
        this.ognlLRUCache.putIfAbsent(key, value);
    }

    @Override
    public int size() {
        return this.ognlLRUCache.size();
    }

    @Override
    public void clear() {
        this.ognlLRUCache.clear();
    }

    @Override
    public int getEvictionLimit() {
        return this.cacheEvictionLimit.get();
    }

    @Override
    public void setEvictionLimit(int cacheEvictionLimit) {
        this.cacheEvictionLimit.set(cacheEvictionLimit);
    }
}

