/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor.csp;

import com.opensymphony.xwork2.ActionContext;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.interceptor.csp.CspSettings;

public class DefaultCspSettings
implements CspSettings {
    private final SecureRandom sRand = new SecureRandom();
    private final Supplier<String> lazyPolicyBuilder = new Supplier<String>(){
        boolean hasBeenCalled;
        String policyFormat;

        @Override
        public String get() {
            if (!this.hasBeenCalled) {
                StringBuilder policyFormatBuilder = new StringBuilder().append("object-src").append(String.format(" '%s'; ", "none")).append("script-src").append(" 'nonce-%s' ").append(String.format("'%s' ", "strict-dynamic")).append(String.format("%s %s; ", "http:", "https:")).append("base-uri").append(String.format(" '%s'; ", "none"));
                if (DefaultCspSettings.this.reportUri != null) {
                    policyFormatBuilder.append("report-uri").append(String.format(" %s", DefaultCspSettings.this.reportUri));
                }
                this.policyFormat = policyFormatBuilder.toString();
            }
            return String.format(this.policyFormat, DefaultCspSettings.this.getNonceString());
        }
    };
    private String reportUri;
    private String cspHeader = "Content-Security-Policy-Report-Only";

    @Override
    public void addCspHeaders(HttpServletResponse response) {
        this.associateNonceWithSession();
        response.setHeader(this.cspHeader, this.lazyPolicyBuilder.get());
    }

    private String getNonceString() {
        Map<String, Object> session = ActionContext.getContext().getSession();
        return (String)session.get("nonce");
    }

    private void associateNonceWithSession() {
        Map<String, Object> session = ActionContext.getContext().getSession();
        String nonceValue = Base64.getUrlEncoder().encodeToString(this.getRandomBytes());
        session.put("nonce", nonceValue);
    }

    private byte[] getRandomBytes() {
        byte[] ret = new byte[18];
        this.sRand.nextBytes(ret);
        return ret;
    }

    @Override
    public void setEnforcingMode(boolean enforcingMode) {
        if (enforcingMode) {
            this.cspHeader = "Content-Security-Policy";
        }
    }

    @Override
    public void setReportUri(String reportUri) {
        this.reportUri = reportUri;
    }
}

