/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.css;

import com.google.gxp.base.GxpContext;
import com.google.gxp.com.google.common.base.CharEscaper;
import com.google.gxp.com.google.common.base.CharEscaperBuilder;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.css.CssClosure;
import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.util.Locale;

public class CssAppender {
    public static final CssAppender INSTANCE = new CssAppender();
    private static final NumberFormat numberFormatter = CssAppender.getNumberFormatter();
    private static final CharEscaper CSS_STRING_ESCAPER = new CharEscaperBuilder().addEscape('\\', "\\\\").addEscape('\n', "\\a ").addEscape('\'', "\\'").addEscape('\"', "\\\"").toEscaper();

    private CssAppender() {
    }

    private static NumberFormat getNumberFormatter() {
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.US);
        formatter.setGroupingUsed(false);
        return formatter;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, int value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, double value) throws IOException {
        out.append(numberFormatter.format(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, CssClosure closure) throws IOException {
        Preconditions.checkNotNull(closure);
        closure.write(out, gxpContext);
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, CharSequence value) throws IOException {
        Preconditions.checkNotNull(value);
        out.append('\"');
        CSS_STRING_ESCAPER.escape(out).append(value);
        out.append('\"');
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, URI value) throws IOException {
        Preconditions.checkNotNull(value);
        out.append("url(\"");
        String s = value.toString();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '\'': 
                case '(': 
                case ')': 
                case ',': 
                case '\\': {
                    out.append("\\");
                }
            }
            out.append(c);
        }
        out.append("\")");
        return out;
    }
}

