/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.sitegraph.entities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.sitegraph.entities.Target;
import org.apache.struts2.sitegraph.entities.View;

public abstract class FileBasedView
implements View {
    private String name;
    private String contents;
    private static final Logger LOG = LogManager.getLogger(FileBasedView.class);

    public FileBasedView(File file) {
        this.name = file.getName();
        this.contents = this.readFile(file).replaceAll("[\r\n ]+", " ");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<Target> getTargets() {
        TreeSet<Target> targets = new TreeSet<Target>();
        this.matchPatterns(this.getLinkPattern(), targets, 2);
        this.matchPatterns(this.getActionPattern(), targets, 1);
        this.matchPatterns(this.getFormPattern(), targets, 0);
        return targets;
    }

    protected Pattern getLinkPattern() {
        String ext = "action";
        String actionRegex = "([A-Za-z0-9\\._\\-!]+\\." + ext + ")";
        return Pattern.compile(actionRegex);
    }

    private void matchPatterns(Pattern pattern, Set<Target> targets, int type) {
        Matcher matcher = pattern.matcher(this.contents);
        while (matcher.find()) {
            String target = matcher.group(1);
            targets.add(new Target(target, type));
        }
    }

    protected abstract Pattern getActionPattern();

    protected abstract Pattern getFormPattern();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readFile(File file) {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String s;
            StringBuilder buffer = new StringBuilder();
            while ((s = in.readLine()) != null) {
                buffer.append(s).append('\n');
            }
            String string = buffer.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            if (!LOG.isWarnEnabled()) return null;
            LOG.warn("File not found");
            return null;
        }
        catch (IOException e) {
            LOG.error("Cannot read file: " + file, (Throwable)e);
        }
        return null;
    }
}

