/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.oval.context.ClassContext;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.MethodEntryContext;
import net.sf.oval.context.MethodExitContext;
import net.sf.oval.context.MethodReturnValueContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextCache {
    private static final Map<Class<?>, ClassContext> CLASS_CONTEXTS = new WeakHashMap();
    private static final Map<Field, FieldContext> FIELD_CONTEXTS = new WeakHashMap<Field, FieldContext>();
    private static final Map<Method, MethodEntryContext> METHOD_ENTRY_CONTEXTS = new WeakHashMap<Method, MethodEntryContext>();
    private static final Map<Method, MethodExitContext> METHOD_EXIT_CONTEXTS = new WeakHashMap<Method, MethodExitContext>();
    private static final Map<Method, MethodReturnValueContext> METHOD_RETURN_VALUE_CONTEXTS = new WeakHashMap<Method, MethodReturnValueContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassContext getClassContext(Class<?> clazz) {
        Map<Class<?>, ClassContext> map = CLASS_CONTEXTS;
        synchronized (map) {
            ClassContext ctx = CLASS_CONTEXTS.get(clazz);
            if (ctx == null) {
                ctx = new ClassContext(clazz);
                CLASS_CONTEXTS.put(clazz, ctx);
            }
            return ctx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldContext getFieldContext(Field field) {
        Map<Field, FieldContext> map = FIELD_CONTEXTS;
        synchronized (map) {
            FieldContext ctx = FIELD_CONTEXTS.get(field);
            if (ctx == null) {
                ctx = new FieldContext(field);
                FIELD_CONTEXTS.put(field, ctx);
            }
            return ctx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodEntryContext getMethodEntryContext(Method method) {
        Map<Method, MethodEntryContext> map = METHOD_ENTRY_CONTEXTS;
        synchronized (map) {
            MethodEntryContext ctx = METHOD_ENTRY_CONTEXTS.get(method);
            if (ctx == null) {
                ctx = new MethodEntryContext(method);
                METHOD_ENTRY_CONTEXTS.put(method, ctx);
            }
            return ctx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodExitContext getMethodExitContext(Method method) {
        Map<Method, MethodExitContext> map = METHOD_EXIT_CONTEXTS;
        synchronized (map) {
            MethodExitContext ctx = METHOD_EXIT_CONTEXTS.get(method);
            if (ctx == null) {
                ctx = new MethodExitContext(method);
                METHOD_EXIT_CONTEXTS.put(method, ctx);
            }
            return ctx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodReturnValueContext getMethodReturnValueContext(Method method) {
        Map<Method, MethodReturnValueContext> map = METHOD_RETURN_VALUE_CONTEXTS;
        synchronized (map) {
            MethodReturnValueContext ctx = METHOD_RETURN_VALUE_CONTEXTS.get(method);
            if (ctx == null) {
                ctx = new MethodReturnValueContext(method);
                METHOD_RETURN_VALUE_CONTEXTS.put(method, ctx);
            }
            return ctx;
        }
    }

    private ContextCache() {
    }
}

