/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.compat.BaseV10Converter;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class ObjectConverter
extends BaseV10Converter
implements Converter {
    private boolean force;
    private List exclusions = null;
    private List inclusions = null;
    private Class instanceType = null;
    private static final Logger log = Logger.getLogger(class$uk$ltd$getahead$dwr$convert$ObjectConverter == null ? (class$uk$ltd$getahead$dwr$convert$ObjectConverter = ObjectConverter.class$("uk.ltd.getahead.dwr.convert.ObjectConverter")) : class$uk$ltd$getahead$dwr$convert$ObjectConverter);
    private ConverterManager config = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$convert$ObjectConverter;

    public void setForce(String force) {
        this.force = Boolean.valueOf(force);
    }

    public void setExclude(String excludes) {
        if (this.inclusions != null) {
            throw new IllegalArgumentException(Messages.getString("HibernateBeanConverter.OnlyIncludeOrExclude"));
        }
        this.exclusions = new ArrayList();
        String toSplit = LocalUtil.replace(excludes, ",", " ");
        StringTokenizer st = new StringTokenizer(toSplit);
        while (st.hasMoreTokens()) {
            String rule = st.nextToken();
            if (rule.startsWith("get")) {
                log.warn("Exclusions are based on property names and not method names. '" + rule + "' starts with 'get' so it looks like a method name and not a property name.");
            }
            this.exclusions.add(rule);
        }
    }

    public void setInclude(String includes) {
        if (this.exclusions != null) {
            throw new IllegalArgumentException(Messages.getString("HibernateBeanConverter.OnlyIncludeOrExclude"));
        }
        this.inclusions = new ArrayList();
        String toSplit = LocalUtil.replace(includes, ",", " ");
        StringTokenizer st = new StringTokenizer(toSplit);
        while (st.hasMoreTokens()) {
            String rule = st.nextToken();
            if (rule.startsWith("get")) {
                log.warn("Inclusions are based on property names and not method names. '" + rule + "' starts with 'get' so it looks like a method name and not a property name.");
            }
            this.inclusions.add(rule);
        }
    }

    public void setImplementation(String name) throws ClassNotFoundException {
        this.setInstanceType(Class.forName(name));
    }

    public Class getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(Class instanceType) {
        this.instanceType = instanceType;
    }

    public void setConverterManager(ConverterManager newConfig) {
        this.config = newConfig;
    }

    public ConverterManager getConverterManager() {
        return this.config;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        String value = iv.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{")) {
            throw new IllegalArgumentException(Messages.getString("BeanConverter.MissingOpener", "{"));
        }
        if (!value.endsWith("}")) {
            throw new IllegalArgumentException(Messages.getString("BeanConverter.MissingCloser", "{"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            Object bean = null;
            bean = this.instanceType != null ? this.instanceType.newInstance() : paramType.newInstance();
            Field[] fields = this.getAllFields(bean);
            HashMap<String, Field> props = new HashMap<String, Field>();
            for (int i = 0; i < fields.length; ++i) {
                String key = fields[i].getName();
                props.put(key, fields[i]);
            }
            if (this.instanceType != null) {
                inctx.addConverted(iv, this.instanceType, bean);
            } else {
                inctx.addConverted(iv, paramType, bean);
            }
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            for (int i = 0; i < size; ++i) {
                String token = st.nextToken();
                if (token.trim().length() == 0) continue;
                int colonpos = token.indexOf(":");
                if (colonpos == -1) {
                    throw new ConversionException(Messages.getString("BeanConverter.MissingSeparator", ":", token));
                }
                String key = token.substring(0, colonpos).trim();
                String val = token.substring(colonpos + 1).trim();
                Field field = (Field)props.get(key);
                if (field == null) {
                    log.warn("No field for " + key);
                    StringBuffer all = new StringBuffer();
                    Iterator it = props.keySet().iterator();
                    while (it.hasNext()) {
                        all.append(it.next());
                        if (!it.hasNext()) continue;
                        all.append(',');
                    }
                    log.warn("Fields exist for (" + all + ").");
                    continue;
                }
                Class<?> propType = field.getType();
                String[] split = LocalUtil.splitInbound(val);
                String splitValue = split[1];
                String splitType = split[0];
                InboundVariable nested = new InboundVariable(iv.getLookup(), null, splitType, splitValue);
                if (!field.isAccessible()) {
                    if (this.force) {
                        field.setAccessible(true);
                    } else {
                        log.debug("Field: " + field.getName() + " is not accessible. use <param name='force' value='true'/>");
                        continue;
                    }
                }
                Object output = this.config.convertInbound(propType, nested, inctx, inctx.getCurrentTypeHintContext());
                field.set(bean, new Object[]{output});
            }
            return bean;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }

    public String convertOutbound(Object data, String varname, OutboundContext outctx) throws ConversionException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("var ");
        buffer.append(varname);
        buffer.append("={};");
        try {
            Field[] fields = this.getAllFields(data);
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                String name = field.getName();
                try {
                    if (name.equals("class")) continue;
                    if (!this.isAllowed(name)) {
                        log.debug("Skipping marshalling " + name + " due to include/exclude rules");
                        continue;
                    }
                    if (!this.isAvailable(data, name)) {
                        log.debug("Skipping marshalling " + name + " due to availability rules");
                        continue;
                    }
                    if (!field.isAccessible()) {
                        if (this.force) {
                            field.setAccessible(true);
                        } else {
                            log.debug("Field: " + field.getName() + " is not accessible. use <param name='force' value='true'/>");
                            continue;
                        }
                    }
                    Object value = field.get(data);
                    OutboundVariable nested = this.getConverterManager().convertOutbound(value, outctx);
                    buffer.append(nested.getInitCode());
                    buffer.append(varname);
                    buffer.append('.');
                    buffer.append(name);
                    buffer.append('=');
                    buffer.append(nested.getAssignCode());
                    buffer.append(';');
                    continue;
                }
                catch (Exception ex) {
                    log.warn("Failed to convert " + name, ex);
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
        return buffer.toString();
    }

    protected Field[] getAllFields(Object bean) {
        HashSet<Field> allFields = new HashSet<Field>();
        for (Class<?> clazz = bean.getClass(); clazz != (class$java$lang$Object == null ? ObjectConverter.class$("java.lang.Object") : class$java$lang$Object); clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                allFields.add(fields[i]);
            }
        }
        return allFields.toArray(new Field[allFields.size()]);
    }

    protected boolean isAllowed(String property) {
        String test;
        Iterator it;
        if (this.exclusions != null) {
            it = this.exclusions.iterator();
            while (it.hasNext()) {
                test = (String)it.next();
                if (!property.equals(test)) continue;
                return false;
            }
        }
        if (this.inclusions != null) {
            it = this.inclusions.iterator();
            while (it.hasNext()) {
                test = (String)it.next();
                if (!property.equals(test)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isAvailable(Object data, String property) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

