/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.AbstractExpressionLanguage;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ObjectCache;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageOGNLImpl
extends AbstractExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageOGNLImpl.class);
    private final ObjectCache<String, Object> expressionCache = new ObjectCache();

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        LOG.debug("Evaluating OGNL expression: {1}", expression);
        try {
            OgnlContext ctx = (OgnlContext)Ognl.createDefaultContext(null);
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                ctx.put((Object)entry.getKey(), entry.getValue());
            }
            Object expr = this.expressionCache.get(expression);
            if (expr == null) {
                expr = Ognl.parseExpression((String)expression);
                this.expressionCache.put(expression, expr);
            }
            return Ognl.getValue((Object)expr, (Object)ctx);
        }
        catch (OgnlException ex) {
            throw new ExpressionEvaluationException("Evaluating MVEL expression failed: " + expression, ex);
        }
    }
}

