/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.sitegraph.renderers;

import com.opensymphony.xwork2.ActionChainResult;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.struts2.sitegraph.StrutsConfigRetriever;
import org.apache.struts2.sitegraph.entities.Target;
import org.apache.struts2.sitegraph.entities.View;
import org.apache.struts2.sitegraph.model.ActionNode;
import org.apache.struts2.sitegraph.model.Graph;
import org.apache.struts2.sitegraph.model.IndentWriter;
import org.apache.struts2.sitegraph.model.Link;
import org.apache.struts2.sitegraph.model.SiteGraphNode;
import org.apache.struts2.sitegraph.model.SubGraph;
import org.apache.struts2.sitegraph.model.ViewNode;

public class DOTRenderer {
    private Writer writer;
    private List<TempLink> links = new ArrayList<TempLink>();

    public DOTRenderer(Writer writer) {
        this.writer = writer;
    }

    public void render(String ns) {
        Graph graph = new Graph();
        TreeMap<ViewNode, View> viewMap = new TreeMap<ViewNode, View>(new Comparator<ViewNode>(){

            @Override
            public int compare(ViewNode v1, ViewNode v2) {
                return v1.getFullName().compareTo(v2.getFullName());
            }
        });
        Set<String> namespaces = StrutsConfigRetriever.getNamespaces();
        for (String string : namespaces) {
            if (!string.startsWith(ns)) continue;
            SubGraph subGraph = graph.create(string);
            Set<String> actionNames = StrutsConfigRetriever.getActionNames(string);
            for (String actionName : actionNames) {
                ActionConfig actionConfig = StrutsConfigRetriever.getActionConfig(string, actionName);
                ActionNode action = new ActionNode(actionName);
                subGraph.addNode(action);
                Set resultNames = actionConfig.getResults().keySet();
                for (String resultName : resultNames) {
                    String location;
                    ResultConfig resultConfig = (ResultConfig)actionConfig.getResults().get(resultName);
                    String resultClassName = resultConfig.getClassName();
                    if (resultClassName.equals(ActionChainResult.class.getName())) continue;
                    if (resultClassName.contains("Dispatcher") || resultClassName.contains("Velocity") || resultClassName.contains("Freemarker")) {
                        if (resultConfig.getParams().get("location") == null) continue;
                        String location2 = this.getViewLocation((String)resultConfig.getParams().get("location"), string);
                        if (location2.endsWith("action")) {
                            this.addTempLink(action, location2, 3, resultConfig.getName());
                            continue;
                        }
                        ViewNode view = new ViewNode(this.stripLocation(location2));
                        subGraph.addNode(view);
                        this.addTempLink(action, location2, 3, resultConfig.getName());
                        View viewFile = this.getView(string, actionName, resultName, location2);
                        if (viewFile == null) continue;
                        viewMap.put(view, viewFile);
                        continue;
                    }
                    if (resultClassName.contains("Jasper") || resultClassName.contains("XSLT") || !resultClassName.contains("Redirect")) continue;
                    String locationConfig = (String)resultConfig.getParams().get("location");
                    if (locationConfig == null) {
                        locationConfig = (String)resultConfig.getParams().get("actionName");
                    }
                    if ((location = this.getViewLocation(locationConfig, string)).endsWith("action")) {
                        this.addTempLink(action, location, 4, resultConfig.getName());
                        continue;
                    }
                    ViewNode view = new ViewNode(this.stripLocation(location));
                    subGraph.addNode(view);
                    this.addTempLink(action, location, 4, resultConfig.getName());
                    View viewFile = this.getView(string, actionName, resultName, location);
                    if (viewFile == null) continue;
                    viewMap.put(view, viewFile);
                }
            }
        }
        for (Map.Entry entry : viewMap.entrySet()) {
            ViewNode view = (ViewNode)entry.getKey();
            View viewFile = (View)entry.getValue();
            Set<Target> targets = viewFile.getTargets();
            for (Target target : targets) {
                String viewTarget = target.getTarget();
                this.addTempLink(view, viewTarget, target.getType(), "");
            }
        }
        for (TempLink tempLink : this.links) {
            SiteGraphNode to;
            String location = tempLink.location;
            if (location.endsWith("action") && (location = location.substring(0, location.indexOf("action") - 1)).indexOf(33) != -1) {
                tempLink.label = tempLink.label + "\\n(" + location.substring(location.indexOf(33)) + ")";
                location = location.substring(0, location.indexOf(33));
            }
            if ((to = graph.findNode(location, tempLink.node)) == null) continue;
            graph.addLink(new Link(tempLink.node, to, tempLink.typeResult, tempLink.label));
        }
        try {
            graph.render(new IndentWriter(this.writer));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addTempLink(SiteGraphNode node, String location, int type, String label) {
        this.links.add(new TempLink(node, location, type, label));
    }

    private String stripLocation(String location) {
        return location.substring(location.lastIndexOf(47) + 1);
    }

    private View getView(String namespace, String actionName, String resultName, String location) {
        int type = 0;
        if (location.endsWith(".fm") || location.endsWith(".ftl")) {
            type = 2;
        } else if (location.endsWith(".vm")) {
            type = 1;
        }
        return StrutsConfigRetriever.getView(namespace, actionName, resultName, type);
    }

    private String getViewLocation(String location, String namespace) {
        String view = !location.startsWith("/") ? namespace + "/" + location : location;
        if (view.indexOf(63) != -1) {
            view = view.substring(0, view.indexOf(63));
        }
        return view;
    }

    class TempLink {
        SiteGraphNode node;
        String location;
        int typeResult;
        String label;

        public TempLink(SiteGraphNode node, String location, int typeResult, String label) {
            this.node = node;
            this.location = location;
            this.typeResult = typeResult;
            this.label = label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TempLink)) {
                return false;
            }
            TempLink tempLink = (TempLink)o;
            if (this.typeResult != tempLink.typeResult) {
                return false;
            }
            if (this.label != null ? !this.label.equals(tempLink.label) : tempLink.label != null) {
                return false;
            }
            if (this.location != null ? !this.location.equals(tempLink.location) : tempLink.location != null) {
                return false;
            }
            return !(this.node != null ? !this.node.equals(tempLink.node) : tempLink.node != null);
        }

        public int hashCode() {
            int result = this.node != null ? this.node.hashCode() : 0;
            result = 29 * result + (this.location != null ? this.location.hashCode() : 0);
            result = 29 * result + this.typeResult;
            result = 29 * result + (this.label != null ? this.label.hashCode() : 0);
            return result;
        }
    }
}

