/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.streampipes.connect.adapters.ti;

import org.junit.Test;

import java.util.Map;

import static org.junit.Assert.assertEquals;

public class TISensorTagTest {
  String event = "{\n"
      + "\"ambientTemp\":\"19.58\",\n"
      + "\"objectTemp\":\"16.59\",\n"
      + "\"humidity\":\"38.3917\",\n"
      + "\"accelX\":\"0.28\",\n"
      + "\"accelY\":\"-0.48\",\n"
      + "\"accelZ\":\"-0.91\",\n"
      + "\"gyroX\":\"4.88\",\n"
      + "\"gyroY\":\"4.53\",\n"
      + "\"gyroZ\":\"-2.96\",\n"
      + "\"magX\":\"134.16\",\n"
      + "\"magY\":\"-17.84\" \n"
      + "\"magZ\":\"18.44\" \n"
      + "\"light\":\"0.00\" \n"
      + "\n"
      + "}";

  @Test
  public void parseEvent() {
    Map<String, Object> result = TISensorTag.parseEvent(event);

    assertEquals(16, result.keySet().size());
    assertEquals(result.get("ambientTemp"), 19.58);
    assertEquals(result.get("objectTemp"), 16.59);
    assertEquals(result.get("humidity"), 38.3917);
    assertEquals(result.get("accelX"), 0.28);
    assertEquals(result.get("accelY"), -0.48);
    assertEquals(result.get("accelZ"), -0.91);
    assertEquals(result.get("gyroX"), 4.88);
    assertEquals(result.get("gyroY"), 4.53);
    assertEquals(result.get("gyroZ"), -2.96);
    assertEquals(result.get("magX"), 134.16);
    assertEquals(result.get("magY"), -17.84);
    assertEquals(result.get("magZ"), 18.44);
    assertEquals(result.get("light"), 0.00);
  }
}