/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

import { BaseDialogConfig } from '../base-dialog/base-dialog.config';
import { DialogPanelConfig } from '../base-dialog/base-dialog.model';
import { Overlay } from '@angular/cdk/overlay';

export class StandardDialogConfig implements BaseDialogConfig {

  getConfig(): DialogPanelConfig {
    const config: DialogPanelConfig = {} as DialogPanelConfig;
    config.maxWidth = '90vw';
    config.height = '50vh';
    return config;
  }

  getPosition(overlay: Overlay) {
    return overlay
        .position()
        .global()
        .centerHorizontally()
        .centerVertically();
  }

  getOverlayConfig(config: any, positionStrategy: any) {
    return {
      hasBackdrop: true,
      positionStrategy,
      panelClass: 'dialog-container',
      width: config.width,
      maxWidth: '90vw',
    };
  }
}
