/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.streampipes.model.function;

import org.apache.streampipes.model.shared.annotation.TsModel;

@TsModel
public class FunctionId {

  private String id;
  private int version;

  public static FunctionId from(String id,
                                int version) {
    return new FunctionId(id, version);
  }

  public FunctionId() {
  }

  private FunctionId(String id,
                     int version) {
    this.id = id;
    this.version = version;
  }

  public String getId() {
    return id;
  }

  public int getVersion() {
    return version;
  }

  public void setId(String id) {
    this.id = id;
  }

  public void setVersion(int version) {
    this.version = version;
  }

  @Override
  public String toString() {
    return "FunctionId{" +
        "id='" + id + '\'' +
        ", version=" + version +
        '}';
  }
}
