/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.streampipes.dataexplorer.v4.query.elements;

import org.apache.streampipes.dataexplorer.v4.params.QueryParamsV4;

public abstract class QueryElement<QP extends QueryParamsV4> {
    protected String queryStatement;

    public QueryElement(QP params) {
        this.queryStatement = buildStatement(params);
    }

    protected abstract String buildStatement(QP params);

    public String getStatement() {
        return queryStatement;
    }
}
