/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.streampipes.wrapper.siddhi.constants;

public class SiddhiConstants {

  public static final String SELECT = "select";
  public static final String INSERT = "insert";
  public static final String FROM = "from";
  public static final String OFFSET = "offset";

  public static final String WHITESPACE = " ";
  public static final String COMMA = ",";
  public static final String COLON = ":";
  public static final String DOT = ".";
  public static final String EMPTY = "";
  public static final String HASH = "#";
  public static final String PARENTHESIS_OPEN = "(";
  public static final String PARENTHESIS_CLOSE = ")";
  public static final String SQUARE_BRACKET_OPEN = "[";
  public static final String SQUARE_BRACKED_CLOSE = "]";
  public static final String ANGLE_BRACKET_OPEN = "<";
  public static final String ANGLE_BRACKET_CLOSE = ">";
  public static final String AS = "as";
  public static final String EQUALS = "=";
  public static final String EVERY = "every";
  public static final String SEQUENCE = "->";
  public static final String WITHIN = "within";

  public static final String ASTERISK = "*";

  public static final String FIRST_STREAM_PREFIX = "s0";
  public static final String SECOND_STREAM_PREFIX = "s1";

  public static final String SIDDHI_LONG_TYPE = "LONG";
  public static final String SIDDHI_INT_TYPE = "INT";
  public static final String SIDDHI_DOUBLE_TYPE = "DOUBLE";
  public static final String SIDDHI_BOOLEAN_TYPE = "BOOL";
  public static final String SIDDHI_STRING_TYPE = "STRING";
  public static final String SIDDHI_OBJECT_TYPE = "OBJECT";
}
