/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.streampipes.manager.verification.structure;

import org.apache.streampipes.manager.verification.messages.VerificationResult;
import org.apache.streampipes.model.base.NamedStreamPipesEntity;
import org.apache.streampipes.model.message.NotificationType;
import org.apache.streampipes.sdk.utils.Assets;

import java.util.List;

public class GeneralVerifier<T extends NamedStreamPipesEntity> extends AbstractVerifier {

	private T description;
	
	public GeneralVerifier(T description)
	{
		this.description = description;
	}
	
	@Override
	public List<VerificationResult> validate() {
		if (!description.isIncludesAssets() || !description.getIncludedAssets().contains(Assets.ICON)) addWarning(NotificationType.WARNING_NO_ICON);
		if (description.getName() == null) addWarning(NotificationType.WARNING_NO_NAME);
		
		return validationResults;
	}

}
