/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.streampipes.model.staticproperty;

import java.util.List;

public class RuntimeResolvableAnyStaticProperty extends AnyStaticProperty {

  private List<String> dependsOn;

  public RuntimeResolvableAnyStaticProperty() {
    super(StaticPropertyType.RuntimeResolvableAnyStaticProperty);
  }

  public RuntimeResolvableAnyStaticProperty(RuntimeResolvableAnyStaticProperty other) {
    super(other);
    this.dependsOn = other.getDependsOn();
  }

  public RuntimeResolvableAnyStaticProperty(String internalName, String label, String description) {
    super(StaticPropertyType.RuntimeResolvableAnyStaticProperty, internalName, label, description);
  }

  public RuntimeResolvableAnyStaticProperty(String internalName, String label, String description, boolean horizontalRendering) {
    super(StaticPropertyType.RuntimeResolvableAnyStaticProperty, internalName, label, description, horizontalRendering);
  }


  public List<String> getDependsOn() {
    return dependsOn;
  }

  public void setDependsOn(List<String> dependsOn) {
    this.dependsOn = dependsOn;
  }
}
