/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sorted.state;

import java.io.IOException;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.streaming.api.operators.sorted.state.MergingAbstractBatchExecutionKeyState;

class BatchExecutionKeyAggregatingState<K, N, IN, ACC, OUT>
extends MergingAbstractBatchExecutionKeyState<K, N, ACC, IN, OUT>
implements InternalAggregatingState<K, N, IN, ACC, OUT> {
    private final AggregateFunction<IN, ACC, OUT> aggFunction;

    public BatchExecutionKeyAggregatingState(ACC defaultValue, AggregateFunction<IN, ACC, OUT> aggregateFunction, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<ACC> stateSerializer) {
        super(defaultValue, keySerializer, namespaceSerializer, stateSerializer);
        this.aggFunction = aggregateFunction;
    }

    public OUT get() {
        Object acc = this.getOrDefault();
        return (OUT)(acc != null ? this.aggFunction.getResult(acc) : null);
    }

    public void add(IN value) throws IOException {
        if (value == null) {
            this.clear();
            return;
        }
        try {
            if (this.getCurrentNamespaceValue() == null) {
                this.setCurrentNamespaceValue(this.aggFunction.createAccumulator());
            }
            this.setCurrentNamespaceValue(this.aggFunction.add(value, this.getCurrentNamespaceValue()));
        }
        catch (Exception e) {
            throw new IOException("Exception while applying AggregateFunction in aggregating state", e);
        }
    }

    static <T, K, N, SV, S extends State, IS extends S> IS create(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, StateDescriptor<S, SV> stateDesc) {
        return (IS)new BatchExecutionKeyAggregatingState(stateDesc.getDefaultValue(), ((AggregatingStateDescriptor)stateDesc).getAggregateFunction(), keySerializer, namespaceSerializer, stateDesc.getSerializer());
    }

    @Override
    protected ACC merge(ACC target, ACC source) {
        return (ACC)this.aggFunction.merge(target, source);
    }
}

