/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class JobSubmissionFiles {
    private static final Logger LOG = LoggerFactory.getLogger(JobSubmissionFiles.class);
    public static final FsPermission JOB_DIR_PERMISSION = FsPermission.createImmutable((short)448);
    public static final FsPermission JOB_FILE_PERMISSION = FsPermission.createImmutable((short)420);

    public static Path getJobSplitFile(Path jobSubmissionDir) {
        return new Path(jobSubmissionDir, "job.split");
    }

    public static Path getJobSplitMetaFile(Path jobSubmissionDir) {
        return new Path(jobSubmissionDir, "job.splitmetainfo");
    }

    public static Path getJobConfPath(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "job.xml");
    }

    public static Path getJobJar(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "job.jar");
    }

    public static Path getJobDistCacheFiles(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "files");
    }

    public static Path getJobLog4jFile(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "log4j");
    }

    public static Path getJobDistCacheArchives(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "archives");
    }

    public static Path getJobDistCacheLibjars(Path jobSubmitDir) {
        return new Path(jobSubmitDir, "libjars");
    }

    public static Path getStagingDir(Cluster cluster, Configuration conf) throws IOException, InterruptedException {
        UserGroupInformation user = UserGroupInformation.getLoginUser();
        return JobSubmissionFiles.getStagingDir(cluster, conf, user);
    }

    @VisibleForTesting
    public static Path getStagingDir(Cluster cluster, Configuration conf, UserGroupInformation realUser) throws IOException, InterruptedException {
        Path stagingArea = cluster.getStagingAreaDir();
        FileSystem fs = stagingArea.getFileSystem(conf);
        UserGroupInformation currentUser = realUser.getCurrentUser();
        try {
            FileStatus fsStatus = fs.getFileStatus(stagingArea);
            String fileOwner = fsStatus.getOwner();
            if (!(fileOwner.equals(currentUser.getShortUserName()) || fileOwner.equalsIgnoreCase(currentUser.getUserName()) || fileOwner.equals(realUser.getShortUserName()) || fileOwner.equalsIgnoreCase(realUser.getUserName()))) {
                String errorMessage = "The ownership on the staging directory " + stagingArea + " is not as expected. It is owned by " + fileOwner + ". The directory must be owned by the submitter " + currentUser.getShortUserName() + " or " + currentUser.getUserName();
                if (!realUser.getUserName().equals(currentUser.getUserName())) {
                    throw new IOException(errorMessage + " or " + realUser.getShortUserName() + " or " + realUser.getUserName());
                }
                throw new IOException(errorMessage);
            }
            if (!fsStatus.getPermission().equals(JOB_DIR_PERMISSION)) {
                LOG.info("Permissions on staging directory " + stagingArea + " are incorrect: " + fsStatus.getPermission() + ". Fixing permissions to correct value " + JOB_DIR_PERMISSION);
                fs.setPermission(stagingArea, JOB_DIR_PERMISSION);
            }
        }
        catch (FileNotFoundException e) {
            fs.mkdirs(stagingArea, new FsPermission(JOB_DIR_PERMISSION));
        }
        return stagingArea;
    }
}

