/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ProjectedVolumeSource;
import io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.VolumeProjection;
import io.fabric8.kubernetes.api.model.VolumeProjectionBuilder;
import io.fabric8.kubernetes.api.model.VolumeProjectionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ProjectedVolumeSourceFluentImpl<A extends ProjectedVolumeSourceFluent<A>>
extends BaseFluent<A>
implements ProjectedVolumeSourceFluent<A> {
    private Integer defaultMode;
    private List<VolumeProjectionBuilder> sources = new ArrayList<VolumeProjectionBuilder>();

    public ProjectedVolumeSourceFluentImpl() {
    }

    public ProjectedVolumeSourceFluentImpl(ProjectedVolumeSource instance) {
        this.withDefaultMode(instance.getDefaultMode());
        this.withSources(instance.getSources());
    }

    @Override
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    @Override
    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    @Override
    public A addToSources(int index, VolumeProjection item) {
        if (this.sources == null) {
            this.sources = new ArrayList<VolumeProjectionBuilder>();
        }
        VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
        this._visitables.get("sources").add(index >= 0 ? index : this._visitables.get("sources").size(), builder);
        this.sources.add(index >= 0 ? index : this.sources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSources(int index, VolumeProjection item) {
        if (this.sources == null) {
            this.sources = new ArrayList<VolumeProjectionBuilder>();
        }
        VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
        if (index < 0 || index >= this._visitables.get("sources").size()) {
            this._visitables.get("sources").add(builder);
        } else {
            this._visitables.get("sources").set(index, builder);
        }
        if (index < 0 || index >= this.sources.size()) {
            this.sources.add(builder);
        } else {
            this.sources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSources(VolumeProjection ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList<VolumeProjectionBuilder>();
        }
        for (VolumeProjection item : items) {
            VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSources(Collection<VolumeProjection> items) {
        if (this.sources == null) {
            this.sources = new ArrayList<VolumeProjectionBuilder>();
        }
        for (VolumeProjection item : items) {
            VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSources(VolumeProjection ... items) {
        for (VolumeProjection item : items) {
            VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
            this._visitables.get("sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSources(Collection<VolumeProjection> items) {
        for (VolumeProjection item : items) {
            VolumeProjectionBuilder builder = new VolumeProjectionBuilder(item);
            this._visitables.get("sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSources(Predicate<VolumeProjectionBuilder> predicate) {
        if (this.sources == null) {
            return (A)this;
        }
        Iterator<VolumeProjectionBuilder> each = this.sources.iterator();
        Object visitables = this._visitables.get("sources");
        while (each.hasNext()) {
            VolumeProjectionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<VolumeProjection> getSources() {
        return ProjectedVolumeSourceFluentImpl.build(this.sources);
    }

    @Override
    public List<VolumeProjection> buildSources() {
        return ProjectedVolumeSourceFluentImpl.build(this.sources);
    }

    @Override
    public VolumeProjection buildSource(int index) {
        return this.sources.get(index).build();
    }

    @Override
    public VolumeProjection buildFirstSource() {
        return this.sources.get(0).build();
    }

    @Override
    public VolumeProjection buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    @Override
    public VolumeProjection buildMatchingSource(Predicate<VolumeProjectionBuilder> predicate) {
        for (VolumeProjectionBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSource(Predicate<VolumeProjectionBuilder> predicate) {
        for (VolumeProjectionBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSources(List<VolumeProjection> sources) {
        if (this.sources != null) {
            this._visitables.get("sources").removeAll(this.sources);
        }
        if (sources != null) {
            this.sources = new ArrayList<VolumeProjectionBuilder>();
            for (VolumeProjection item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)this;
    }

    @Override
    public A withSources(VolumeProjection ... sources) {
        if (this.sources != null) {
            this.sources.clear();
        }
        if (sources != null) {
            for (VolumeProjection item : sources) {
                this.addToSources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    @Override
    public ProjectedVolumeSourceFluent.SourcesNested<A> addNewSource() {
        return new SourcesNestedImpl();
    }

    @Override
    public ProjectedVolumeSourceFluent.SourcesNested<A> addNewSourceLike(VolumeProjection item) {
        return new SourcesNestedImpl(-1, item);
    }

    @Override
    public ProjectedVolumeSourceFluent.SourcesNested<A> setNewSourceLike(int index, VolumeProjection item) {
        return new SourcesNestedImpl(index, item);
    }

    @Override
    public ProjectedVolumeSourceFluent.SourcesNested<A> editSource(int index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public ProjectedVolumeSourceFluent.SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    @Override
    public ProjectedVolumeSourceFluent.SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public ProjectedVolumeSourceFluent.SourcesNested<A> editMatchingSource(Predicate<VolumeProjectionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectedVolumeSourceFluentImpl that = (ProjectedVolumeSourceFluentImpl)o;
        if (this.defaultMode != null ? !this.defaultMode.equals(that.defaultMode) : that.defaultMode != null) {
            return false;
        }
        return !(this.sources != null ? !this.sources.equals(that.sources) : that.sources != null);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMode, this.sources, super.hashCode());
    }

    public class SourcesNestedImpl<N>
    extends VolumeProjectionFluentImpl<ProjectedVolumeSourceFluent.SourcesNested<N>>
    implements ProjectedVolumeSourceFluent.SourcesNested<N>,
    Nested<N> {
        private final VolumeProjectionBuilder builder;
        private final int index;

        SourcesNestedImpl(int index, VolumeProjection item) {
            this.index = index;
            this.builder = new VolumeProjectionBuilder(this, item);
        }

        SourcesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeProjectionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProjectedVolumeSourceFluentImpl.this.setToSources(this.index, this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }
}

