#!/usr/bin/env python
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

#
# Autogenerated by Thrift Compiler (0.13.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:utf8strings
#

from thrift.Thrift import TType, TMessageType, TFrozenDict, TException, TApplicationException
from thrift.protocol.TProtocol import TProtocolException
from thrift.TRecursive import fix_spec

import sys

from thrift.transport import TTransport
all_structs = []


class ComponentType(object):
    BOLT = 1
    SPOUT = 2

    _VALUES_TO_NAMES = {
        1: "BOLT",
        2: "SPOUT",
    }

    _NAMES_TO_VALUES = {
        "BOLT": 1,
        "SPOUT": 2,
    }


class TopologyInitialStatus(object):
    ACTIVE = 1
    INACTIVE = 2

    _VALUES_TO_NAMES = {
        1: "ACTIVE",
        2: "INACTIVE",
    }

    _NAMES_TO_VALUES = {
        "ACTIVE": 1,
        "INACTIVE": 2,
    }


class AccessControlType(object):
    OTHER = 1
    USER = 2

    _VALUES_TO_NAMES = {
        1: "OTHER",
        2: "USER",
    }

    _NAMES_TO_VALUES = {
        "OTHER": 1,
        "USER": 2,
    }


class TopologyStatus(object):
    ACTIVE = 1
    INACTIVE = 2
    REBALANCING = 3
    KILLED = 4

    _VALUES_TO_NAMES = {
        1: "ACTIVE",
        2: "INACTIVE",
        3: "REBALANCING",
        4: "KILLED",
    }

    _NAMES_TO_VALUES = {
        "ACTIVE": 1,
        "INACTIVE": 2,
        "REBALANCING": 3,
        "KILLED": 4,
    }


class NumErrorsChoice(object):
    ALL = 0
    NONE = 1
    ONE = 2

    _VALUES_TO_NAMES = {
        0: "ALL",
        1: "NONE",
        2: "ONE",
    }

    _NAMES_TO_VALUES = {
        "ALL": 0,
        "NONE": 1,
        "ONE": 2,
    }


class ProfileAction(object):
    JPROFILE_STOP = 0
    JPROFILE_START = 1
    JPROFILE_DUMP = 2
    JMAP_DUMP = 3
    JSTACK_DUMP = 4
    JVM_RESTART = 5

    _VALUES_TO_NAMES = {
        0: "JPROFILE_STOP",
        1: "JPROFILE_START",
        2: "JPROFILE_DUMP",
        3: "JMAP_DUMP",
        4: "JSTACK_DUMP",
        5: "JVM_RESTART",
    }

    _NAMES_TO_VALUES = {
        "JPROFILE_STOP": 0,
        "JPROFILE_START": 1,
        "JPROFILE_DUMP": 2,
        "JMAP_DUMP": 3,
        "JSTACK_DUMP": 4,
        "JVM_RESTART": 5,
    }


class LogLevelAction(object):
    UNCHANGED = 1
    UPDATE = 2
    REMOVE = 3

    _VALUES_TO_NAMES = {
        1: "UNCHANGED",
        2: "UPDATE",
        3: "REMOVE",
    }

    _NAMES_TO_VALUES = {
        "UNCHANGED": 1,
        "UPDATE": 2,
        "REMOVE": 3,
    }


class DRPCExceptionType(object):
    INTERNAL_ERROR = 0
    SERVER_SHUTDOWN = 1
    SERVER_TIMEOUT = 2
    FAILED_REQUEST = 3

    _VALUES_TO_NAMES = {
        0: "INTERNAL_ERROR",
        1: "SERVER_SHUTDOWN",
        2: "SERVER_TIMEOUT",
        3: "FAILED_REQUEST",
    }

    _NAMES_TO_VALUES = {
        "INTERNAL_ERROR": 0,
        "SERVER_SHUTDOWN": 1,
        "SERVER_TIMEOUT": 2,
        "FAILED_REQUEST": 3,
    }


class HBServerMessageType(object):
    CREATE_PATH = 0
    CREATE_PATH_RESPONSE = 1
    EXISTS = 2
    EXISTS_RESPONSE = 3
    SEND_PULSE = 4
    SEND_PULSE_RESPONSE = 5
    GET_ALL_PULSE_FOR_PATH = 6
    GET_ALL_PULSE_FOR_PATH_RESPONSE = 7
    GET_ALL_NODES_FOR_PATH = 8
    GET_ALL_NODES_FOR_PATH_RESPONSE = 9
    GET_PULSE = 10
    GET_PULSE_RESPONSE = 11
    DELETE_PATH = 12
    DELETE_PATH_RESPONSE = 13
    DELETE_PULSE_ID = 14
    DELETE_PULSE_ID_RESPONSE = 15
    CONTROL_MESSAGE = 16
    SASL_MESSAGE_TOKEN = 17
    NOT_AUTHORIZED = 18

    _VALUES_TO_NAMES = {
        0: "CREATE_PATH",
        1: "CREATE_PATH_RESPONSE",
        2: "EXISTS",
        3: "EXISTS_RESPONSE",
        4: "SEND_PULSE",
        5: "SEND_PULSE_RESPONSE",
        6: "GET_ALL_PULSE_FOR_PATH",
        7: "GET_ALL_PULSE_FOR_PATH_RESPONSE",
        8: "GET_ALL_NODES_FOR_PATH",
        9: "GET_ALL_NODES_FOR_PATH_RESPONSE",
        10: "GET_PULSE",
        11: "GET_PULSE_RESPONSE",
        12: "DELETE_PATH",
        13: "DELETE_PATH_RESPONSE",
        14: "DELETE_PULSE_ID",
        15: "DELETE_PULSE_ID_RESPONSE",
        16: "CONTROL_MESSAGE",
        17: "SASL_MESSAGE_TOKEN",
        18: "NOT_AUTHORIZED",
    }

    _NAMES_TO_VALUES = {
        "CREATE_PATH": 0,
        "CREATE_PATH_RESPONSE": 1,
        "EXISTS": 2,
        "EXISTS_RESPONSE": 3,
        "SEND_PULSE": 4,
        "SEND_PULSE_RESPONSE": 5,
        "GET_ALL_PULSE_FOR_PATH": 6,
        "GET_ALL_PULSE_FOR_PATH_RESPONSE": 7,
        "GET_ALL_NODES_FOR_PATH": 8,
        "GET_ALL_NODES_FOR_PATH_RESPONSE": 9,
        "GET_PULSE": 10,
        "GET_PULSE_RESPONSE": 11,
        "DELETE_PATH": 12,
        "DELETE_PATH_RESPONSE": 13,
        "DELETE_PULSE_ID": 14,
        "DELETE_PULSE_ID_RESPONSE": 15,
        "CONTROL_MESSAGE": 16,
        "SASL_MESSAGE_TOKEN": 17,
        "NOT_AUTHORIZED": 18,
    }


class WorkerTokenServiceType(object):
    NIMBUS = 0
    DRPC = 1
    SUPERVISOR = 2

    _VALUES_TO_NAMES = {
        0: "NIMBUS",
        1: "DRPC",
        2: "SUPERVISOR",
    }

    _NAMES_TO_VALUES = {
        "NIMBUS": 0,
        "DRPC": 1,
        "SUPERVISOR": 2,
    }


class JavaObjectArg(object):
    """
    Attributes:
     - int_arg
     - long_arg
     - string_arg
     - bool_arg
     - binary_arg
     - double_arg

    """


    def __init__(self, int_arg=None, long_arg=None, string_arg=None, bool_arg=None, binary_arg=None, double_arg=None,):
        self.int_arg = int_arg
        self.long_arg = long_arg
        self.string_arg = string_arg
        self.bool_arg = bool_arg
        self.binary_arg = binary_arg
        self.double_arg = double_arg

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.int_arg = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I64:
                    self.long_arg = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.string_arg = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.BOOL:
                    self.bool_arg = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.binary_arg = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.DOUBLE:
                    self.double_arg = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('JavaObjectArg')
        if self.int_arg is not None:
            oprot.writeFieldBegin('int_arg', TType.I32, 1)
            oprot.writeI32(self.int_arg)
            oprot.writeFieldEnd()
        if self.long_arg is not None:
            oprot.writeFieldBegin('long_arg', TType.I64, 2)
            oprot.writeI64(self.long_arg)
            oprot.writeFieldEnd()
        if self.string_arg is not None:
            oprot.writeFieldBegin('string_arg', TType.STRING, 3)
            oprot.writeString(self.string_arg.encode('utf-8') if sys.version_info[0] == 2 else self.string_arg)
            oprot.writeFieldEnd()
        if self.bool_arg is not None:
            oprot.writeFieldBegin('bool_arg', TType.BOOL, 4)
            oprot.writeBool(self.bool_arg)
            oprot.writeFieldEnd()
        if self.binary_arg is not None:
            oprot.writeFieldBegin('binary_arg', TType.STRING, 5)
            oprot.writeBinary(self.binary_arg)
            oprot.writeFieldEnd()
        if self.double_arg is not None:
            oprot.writeFieldBegin('double_arg', TType.DOUBLE, 6)
            oprot.writeDouble(self.double_arg)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class JavaObject(object):
    """
    Attributes:
     - full_class_name
     - args_list

    """


    def __init__(self, full_class_name=None, args_list=None,):
        self.full_class_name = full_class_name
        self.args_list = args_list

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.full_class_name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.args_list = []
                    (_etype3, _size0) = iprot.readListBegin()
                    for _i4 in range(_size0):
                        _elem5 = JavaObjectArg()
                        _elem5.read(iprot)
                        self.args_list.append(_elem5)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('JavaObject')
        if self.full_class_name is not None:
            oprot.writeFieldBegin('full_class_name', TType.STRING, 1)
            oprot.writeString(self.full_class_name.encode('utf-8') if sys.version_info[0] == 2 else self.full_class_name)
            oprot.writeFieldEnd()
        if self.args_list is not None:
            oprot.writeFieldBegin('args_list', TType.LIST, 2)
            oprot.writeListBegin(TType.STRUCT, len(self.args_list))
            for iter6 in self.args_list:
                iter6.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.full_class_name is None:
            raise TProtocolException(message='Required field full_class_name is unset!')
        if self.args_list is None:
            raise TProtocolException(message='Required field args_list is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class NullStruct(object):


    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('NullStruct')
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class GlobalStreamId(object):
    """
    Attributes:
     - componentId
     - streamId

    """


    def __init__(self, componentId=None, streamId=None,):
        self.componentId = componentId
        self.streamId = streamId

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.componentId = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.streamId = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('GlobalStreamId')
        if self.componentId is not None:
            oprot.writeFieldBegin('componentId', TType.STRING, 1)
            oprot.writeString(self.componentId.encode('utf-8') if sys.version_info[0] == 2 else self.componentId)
            oprot.writeFieldEnd()
        if self.streamId is not None:
            oprot.writeFieldBegin('streamId', TType.STRING, 2)
            oprot.writeString(self.streamId.encode('utf-8') if sys.version_info[0] == 2 else self.streamId)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.componentId is None:
            raise TProtocolException(message='Required field componentId is unset!')
        if self.streamId is None:
            raise TProtocolException(message='Required field streamId is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class Grouping(object):
    """
    Attributes:
     - fields
     - shuffle
     - all
     - none
     - direct
     - custom_object
     - custom_serialized
     - local_or_shuffle

    """


    def __init__(self, fields=None, shuffle=None, all=None, none=None, direct=None, custom_object=None, custom_serialized=None, local_or_shuffle=None,):
        self.fields = fields
        self.shuffle = shuffle
        self.all = all
        self.none = none
        self.direct = direct
        self.custom_object = custom_object
        self.custom_serialized = custom_serialized
        self.local_or_shuffle = local_or_shuffle

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.fields = []
                    (_etype10, _size7) = iprot.readListBegin()
                    for _i11 in range(_size7):
                        _elem12 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.fields.append(_elem12)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.shuffle = NullStruct()
                    self.shuffle.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRUCT:
                    self.all = NullStruct()
                    self.all.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.STRUCT:
                    self.none = NullStruct()
                    self.none.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRUCT:
                    self.direct = NullStruct()
                    self.direct.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.STRUCT:
                    self.custom_object = JavaObject()
                    self.custom_object.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.STRING:
                    self.custom_serialized = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.STRUCT:
                    self.local_or_shuffle = NullStruct()
                    self.local_or_shuffle.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Grouping')
        if self.fields is not None:
            oprot.writeFieldBegin('fields', TType.LIST, 1)
            oprot.writeListBegin(TType.STRING, len(self.fields))
            for iter13 in self.fields:
                oprot.writeString(iter13.encode('utf-8') if sys.version_info[0] == 2 else iter13)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.shuffle is not None:
            oprot.writeFieldBegin('shuffle', TType.STRUCT, 2)
            self.shuffle.write(oprot)
            oprot.writeFieldEnd()
        if self.all is not None:
            oprot.writeFieldBegin('all', TType.STRUCT, 3)
            self.all.write(oprot)
            oprot.writeFieldEnd()
        if self.none is not None:
            oprot.writeFieldBegin('none', TType.STRUCT, 4)
            self.none.write(oprot)
            oprot.writeFieldEnd()
        if self.direct is not None:
            oprot.writeFieldBegin('direct', TType.STRUCT, 5)
            self.direct.write(oprot)
            oprot.writeFieldEnd()
        if self.custom_object is not None:
            oprot.writeFieldBegin('custom_object', TType.STRUCT, 6)
            self.custom_object.write(oprot)
            oprot.writeFieldEnd()
        if self.custom_serialized is not None:
            oprot.writeFieldBegin('custom_serialized', TType.STRING, 7)
            oprot.writeBinary(self.custom_serialized)
            oprot.writeFieldEnd()
        if self.local_or_shuffle is not None:
            oprot.writeFieldBegin('local_or_shuffle', TType.STRUCT, 8)
            self.local_or_shuffle.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class StreamInfo(object):
    """
    Attributes:
     - output_fields
     - direct

    """


    def __init__(self, output_fields=None, direct=None,):
        self.output_fields = output_fields
        self.direct = direct

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.output_fields = []
                    (_etype17, _size14) = iprot.readListBegin()
                    for _i18 in range(_size14):
                        _elem19 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.output_fields.append(_elem19)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.BOOL:
                    self.direct = iprot.readBool()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('StreamInfo')
        if self.output_fields is not None:
            oprot.writeFieldBegin('output_fields', TType.LIST, 1)
            oprot.writeListBegin(TType.STRING, len(self.output_fields))
            for iter20 in self.output_fields:
                oprot.writeString(iter20.encode('utf-8') if sys.version_info[0] == 2 else iter20)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.direct is not None:
            oprot.writeFieldBegin('direct', TType.BOOL, 2)
            oprot.writeBool(self.direct)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.output_fields is None:
            raise TProtocolException(message='Required field output_fields is unset!')
        if self.direct is None:
            raise TProtocolException(message='Required field direct is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ShellComponent(object):
    """
    Attributes:
     - execution_command
     - script

    """


    def __init__(self, execution_command=None, script=None,):
        self.execution_command = execution_command
        self.script = script

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.execution_command = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.script = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ShellComponent')
        if self.execution_command is not None:
            oprot.writeFieldBegin('execution_command', TType.STRING, 1)
            oprot.writeString(self.execution_command.encode('utf-8') if sys.version_info[0] == 2 else self.execution_command)
            oprot.writeFieldEnd()
        if self.script is not None:
            oprot.writeFieldBegin('script', TType.STRING, 2)
            oprot.writeString(self.script.encode('utf-8') if sys.version_info[0] == 2 else self.script)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ComponentObject(object):
    """
    Attributes:
     - serialized_java
     - shell
     - java_object

    """


    def __init__(self, serialized_java=None, shell=None, java_object=None,):
        self.serialized_java = serialized_java
        self.shell = shell
        self.java_object = java_object

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.serialized_java = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.shell = ShellComponent()
                    self.shell.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRUCT:
                    self.java_object = JavaObject()
                    self.java_object.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ComponentObject')
        if self.serialized_java is not None:
            oprot.writeFieldBegin('serialized_java', TType.STRING, 1)
            oprot.writeBinary(self.serialized_java)
            oprot.writeFieldEnd()
        if self.shell is not None:
            oprot.writeFieldBegin('shell', TType.STRUCT, 2)
            self.shell.write(oprot)
            oprot.writeFieldEnd()
        if self.java_object is not None:
            oprot.writeFieldBegin('java_object', TType.STRUCT, 3)
            self.java_object.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ComponentCommon(object):
    """
    Attributes:
     - inputs
     - streams
     - parallelism_hint
     - json_conf

    """


    def __init__(self, inputs=None, streams=None, parallelism_hint=None, json_conf=None,):
        self.inputs = inputs
        self.streams = streams
        self.parallelism_hint = parallelism_hint
        self.json_conf = json_conf

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.inputs = {}
                    (_ktype22, _vtype23, _size21) = iprot.readMapBegin()
                    for _i25 in range(_size21):
                        _key26 = GlobalStreamId()
                        _key26.read(iprot)
                        _val27 = Grouping()
                        _val27.read(iprot)
                        self.inputs[_key26] = _val27
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.MAP:
                    self.streams = {}
                    (_ktype29, _vtype30, _size28) = iprot.readMapBegin()
                    for _i32 in range(_size28):
                        _key33 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val34 = StreamInfo()
                        _val34.read(iprot)
                        self.streams[_key33] = _val34
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.parallelism_hint = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.STRING:
                    self.json_conf = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ComponentCommon')
        if self.inputs is not None:
            oprot.writeFieldBegin('inputs', TType.MAP, 1)
            oprot.writeMapBegin(TType.STRUCT, TType.STRUCT, len(self.inputs))
            for kiter35, viter36 in self.inputs.items():
                kiter35.write(oprot)
                viter36.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.streams is not None:
            oprot.writeFieldBegin('streams', TType.MAP, 2)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.streams))
            for kiter37, viter38 in self.streams.items():
                oprot.writeString(kiter37.encode('utf-8') if sys.version_info[0] == 2 else kiter37)
                viter38.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.parallelism_hint is not None:
            oprot.writeFieldBegin('parallelism_hint', TType.I32, 3)
            oprot.writeI32(self.parallelism_hint)
            oprot.writeFieldEnd()
        if self.json_conf is not None:
            oprot.writeFieldBegin('json_conf', TType.STRING, 4)
            oprot.writeString(self.json_conf.encode('utf-8') if sys.version_info[0] == 2 else self.json_conf)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.inputs is None:
            raise TProtocolException(message='Required field inputs is unset!')
        if self.streams is None:
            raise TProtocolException(message='Required field streams is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SpoutSpec(object):
    """
    Attributes:
     - spout_object
     - common

    """


    def __init__(self, spout_object=None, common=None,):
        self.spout_object = spout_object
        self.common = common

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.spout_object = ComponentObject()
                    self.spout_object.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.common = ComponentCommon()
                    self.common.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SpoutSpec')
        if self.spout_object is not None:
            oprot.writeFieldBegin('spout_object', TType.STRUCT, 1)
            self.spout_object.write(oprot)
            oprot.writeFieldEnd()
        if self.common is not None:
            oprot.writeFieldBegin('common', TType.STRUCT, 2)
            self.common.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.spout_object is None:
            raise TProtocolException(message='Required field spout_object is unset!')
        if self.common is None:
            raise TProtocolException(message='Required field common is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class Bolt(object):
    """
    Attributes:
     - bolt_object
     - common

    """


    def __init__(self, bolt_object=None, common=None,):
        self.bolt_object = bolt_object
        self.common = common

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.bolt_object = ComponentObject()
                    self.bolt_object.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.common = ComponentCommon()
                    self.common.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Bolt')
        if self.bolt_object is not None:
            oprot.writeFieldBegin('bolt_object', TType.STRUCT, 1)
            self.bolt_object.write(oprot)
            oprot.writeFieldEnd()
        if self.common is not None:
            oprot.writeFieldBegin('common', TType.STRUCT, 2)
            self.common.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.bolt_object is None:
            raise TProtocolException(message='Required field bolt_object is unset!')
        if self.common is None:
            raise TProtocolException(message='Required field common is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class StateSpoutSpec(object):
    """
    Attributes:
     - state_spout_object
     - common

    """


    def __init__(self, state_spout_object=None, common=None,):
        self.state_spout_object = state_spout_object
        self.common = common

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.state_spout_object = ComponentObject()
                    self.state_spout_object.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.common = ComponentCommon()
                    self.common.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('StateSpoutSpec')
        if self.state_spout_object is not None:
            oprot.writeFieldBegin('state_spout_object', TType.STRUCT, 1)
            self.state_spout_object.write(oprot)
            oprot.writeFieldEnd()
        if self.common is not None:
            oprot.writeFieldBegin('common', TType.STRUCT, 2)
            self.common.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.state_spout_object is None:
            raise TProtocolException(message='Required field state_spout_object is unset!')
        if self.common is None:
            raise TProtocolException(message='Required field common is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SharedMemory(object):
    """
    Attributes:
     - name
     - on_heap
     - off_heap_worker
     - off_heap_node

    """


    def __init__(self, name=None, on_heap=None, off_heap_worker=None, off_heap_node=None,):
        self.name = name
        self.on_heap = on_heap
        self.off_heap_worker = off_heap_worker
        self.off_heap_node = off_heap_node

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.DOUBLE:
                    self.on_heap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.DOUBLE:
                    self.off_heap_worker = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.DOUBLE:
                    self.off_heap_node = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SharedMemory')
        if self.name is not None:
            oprot.writeFieldBegin('name', TType.STRING, 1)
            oprot.writeString(self.name.encode('utf-8') if sys.version_info[0] == 2 else self.name)
            oprot.writeFieldEnd()
        if self.on_heap is not None:
            oprot.writeFieldBegin('on_heap', TType.DOUBLE, 2)
            oprot.writeDouble(self.on_heap)
            oprot.writeFieldEnd()
        if self.off_heap_worker is not None:
            oprot.writeFieldBegin('off_heap_worker', TType.DOUBLE, 3)
            oprot.writeDouble(self.off_heap_worker)
            oprot.writeFieldEnd()
        if self.off_heap_node is not None:
            oprot.writeFieldBegin('off_heap_node', TType.DOUBLE, 4)
            oprot.writeDouble(self.off_heap_node)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.name is None:
            raise TProtocolException(message='Required field name is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class StormTopology(object):
    """
    Attributes:
     - spouts
     - bolts
     - state_spouts
     - worker_hooks
     - dependency_jars
     - dependency_artifacts
     - storm_version
     - jdk_version
     - component_to_shared_memory
     - shared_memory

    """


    def __init__(self, spouts=None, bolts=None, state_spouts=None, worker_hooks=None, dependency_jars=None, dependency_artifacts=None, storm_version=None, jdk_version=None, component_to_shared_memory=None, shared_memory=None,):
        self.spouts = spouts
        self.bolts = bolts
        self.state_spouts = state_spouts
        self.worker_hooks = worker_hooks
        self.dependency_jars = dependency_jars
        self.dependency_artifacts = dependency_artifacts
        self.storm_version = storm_version
        self.jdk_version = jdk_version
        self.component_to_shared_memory = component_to_shared_memory
        self.shared_memory = shared_memory

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.spouts = {}
                    (_ktype40, _vtype41, _size39) = iprot.readMapBegin()
                    for _i43 in range(_size39):
                        _key44 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val45 = SpoutSpec()
                        _val45.read(iprot)
                        self.spouts[_key44] = _val45
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.MAP:
                    self.bolts = {}
                    (_ktype47, _vtype48, _size46) = iprot.readMapBegin()
                    for _i50 in range(_size46):
                        _key51 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val52 = Bolt()
                        _val52.read(iprot)
                        self.bolts[_key51] = _val52
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.MAP:
                    self.state_spouts = {}
                    (_ktype54, _vtype55, _size53) = iprot.readMapBegin()
                    for _i57 in range(_size53):
                        _key58 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val59 = StateSpoutSpec()
                        _val59.read(iprot)
                        self.state_spouts[_key58] = _val59
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.LIST:
                    self.worker_hooks = []
                    (_etype63, _size60) = iprot.readListBegin()
                    for _i64 in range(_size60):
                        _elem65 = iprot.readBinary()
                        self.worker_hooks.append(_elem65)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.LIST:
                    self.dependency_jars = []
                    (_etype69, _size66) = iprot.readListBegin()
                    for _i70 in range(_size66):
                        _elem71 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.dependency_jars.append(_elem71)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.LIST:
                    self.dependency_artifacts = []
                    (_etype75, _size72) = iprot.readListBegin()
                    for _i76 in range(_size72):
                        _elem77 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.dependency_artifacts.append(_elem77)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.STRING:
                    self.storm_version = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.STRING:
                    self.jdk_version = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 9:
                if ftype == TType.MAP:
                    self.component_to_shared_memory = {}
                    (_ktype79, _vtype80, _size78) = iprot.readMapBegin()
                    for _i82 in range(_size78):
                        _key83 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val84 = set()
                        (_etype88, _size85) = iprot.readSetBegin()
                        for _i89 in range(_size85):
                            _elem90 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                            _val84.add(_elem90)
                        iprot.readSetEnd()
                        self.component_to_shared_memory[_key83] = _val84
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 10:
                if ftype == TType.MAP:
                    self.shared_memory = {}
                    (_ktype92, _vtype93, _size91) = iprot.readMapBegin()
                    for _i95 in range(_size91):
                        _key96 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val97 = SharedMemory()
                        _val97.read(iprot)
                        self.shared_memory[_key96] = _val97
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('StormTopology')
        if self.spouts is not None:
            oprot.writeFieldBegin('spouts', TType.MAP, 1)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.spouts))
            for kiter98, viter99 in self.spouts.items():
                oprot.writeString(kiter98.encode('utf-8') if sys.version_info[0] == 2 else kiter98)
                viter99.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.bolts is not None:
            oprot.writeFieldBegin('bolts', TType.MAP, 2)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.bolts))
            for kiter100, viter101 in self.bolts.items():
                oprot.writeString(kiter100.encode('utf-8') if sys.version_info[0] == 2 else kiter100)
                viter101.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.state_spouts is not None:
            oprot.writeFieldBegin('state_spouts', TType.MAP, 3)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.state_spouts))
            for kiter102, viter103 in self.state_spouts.items():
                oprot.writeString(kiter102.encode('utf-8') if sys.version_info[0] == 2 else kiter102)
                viter103.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.worker_hooks is not None:
            oprot.writeFieldBegin('worker_hooks', TType.LIST, 4)
            oprot.writeListBegin(TType.STRING, len(self.worker_hooks))
            for iter104 in self.worker_hooks:
                oprot.writeBinary(iter104)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.dependency_jars is not None:
            oprot.writeFieldBegin('dependency_jars', TType.LIST, 5)
            oprot.writeListBegin(TType.STRING, len(self.dependency_jars))
            for iter105 in self.dependency_jars:
                oprot.writeString(iter105.encode('utf-8') if sys.version_info[0] == 2 else iter105)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.dependency_artifacts is not None:
            oprot.writeFieldBegin('dependency_artifacts', TType.LIST, 6)
            oprot.writeListBegin(TType.STRING, len(self.dependency_artifacts))
            for iter106 in self.dependency_artifacts:
                oprot.writeString(iter106.encode('utf-8') if sys.version_info[0] == 2 else iter106)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.storm_version is not None:
            oprot.writeFieldBegin('storm_version', TType.STRING, 7)
            oprot.writeString(self.storm_version.encode('utf-8') if sys.version_info[0] == 2 else self.storm_version)
            oprot.writeFieldEnd()
        if self.jdk_version is not None:
            oprot.writeFieldBegin('jdk_version', TType.STRING, 8)
            oprot.writeString(self.jdk_version.encode('utf-8') if sys.version_info[0] == 2 else self.jdk_version)
            oprot.writeFieldEnd()
        if self.component_to_shared_memory is not None:
            oprot.writeFieldBegin('component_to_shared_memory', TType.MAP, 9)
            oprot.writeMapBegin(TType.STRING, TType.SET, len(self.component_to_shared_memory))
            for kiter107, viter108 in self.component_to_shared_memory.items():
                oprot.writeString(kiter107.encode('utf-8') if sys.version_info[0] == 2 else kiter107)
                oprot.writeSetBegin(TType.STRING, len(viter108))
                for iter109 in viter108:
                    oprot.writeString(iter109.encode('utf-8') if sys.version_info[0] == 2 else iter109)
                oprot.writeSetEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.shared_memory is not None:
            oprot.writeFieldBegin('shared_memory', TType.MAP, 10)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.shared_memory))
            for kiter110, viter111 in self.shared_memory.items():
                oprot.writeString(kiter110.encode('utf-8') if sys.version_info[0] == 2 else kiter110)
                viter111.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.spouts is None:
            raise TProtocolException(message='Required field spouts is unset!')
        if self.bolts is None:
            raise TProtocolException(message='Required field bolts is unset!')
        if self.state_spouts is None:
            raise TProtocolException(message='Required field state_spouts is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class AlreadyAliveException(TException):
    """
    Attributes:
     - msg

    """


    def __init__(self, msg=None,):
        self.msg = msg

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.msg = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('AlreadyAliveException')
        if self.msg is not None:
            oprot.writeFieldBegin('msg', TType.STRING, 1)
            oprot.writeString(self.msg.encode('utf-8') if sys.version_info[0] == 2 else self.msg)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.msg is None:
            raise TProtocolException(message='Required field msg is unset!')
        return

    def __str__(self):
        return repr(self)

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class NotAliveException(TException):
    """
    Attributes:
     - msg

    """


    def __init__(self, msg=None,):
        self.msg = msg

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.msg = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('NotAliveException')
        if self.msg is not None:
            oprot.writeFieldBegin('msg', TType.STRING, 1)
            oprot.writeString(self.msg.encode('utf-8') if sys.version_info[0] == 2 else self.msg)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.msg is None:
            raise TProtocolException(message='Required field msg is unset!')
        return

    def __str__(self):
        return repr(self)

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class AuthorizationException(TException):
    """
    Attributes:
     - msg

    """


    def __init__(self, msg=None,):
        self.msg = msg

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.msg = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('AuthorizationException')
        if self.msg is not None:
            oprot.writeFieldBegin('msg', TType.STRING, 1)
            oprot.writeString(self.msg.encode('utf-8') if sys.version_info[0] == 2 else self.msg)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.msg is None:
            raise TProtocolException(message='Required field msg is unset!')
        return

    def __str__(self):
        return repr(self)

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class InvalidTopologyException(TException):
    """
    Attributes:
     - msg

    """


    def __init__(self, msg=None,):
        self.msg = msg

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.msg = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('InvalidTopologyException')
        if self.msg is not None:
            oprot.writeFieldBegin('msg', TType.STRING, 1)
            oprot.writeString(self.msg.encode('utf-8') if sys.version_info[0] == 2 else self.msg)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.msg is None:
            raise TProtocolException(message='Required field msg is unset!')
        return

    def __str__(self):
        return repr(self)

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class KeyNotFoundException(TException):
    """
    Attributes:
     - msg

    """


    def __init__(self, msg=None,):
        self.msg = msg

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.msg = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('KeyNotFoundException')
        if self.msg is not None:
            oprot.writeFieldBegin('msg', TType.STRING, 1)
            oprot.writeString(self.msg.encode('utf-8') if sys.version_info[0] == 2 else self.msg)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.msg is None:
            raise TProtocolException(message='Required field msg is unset!')
        return

    def __str__(self):
        return repr(self)

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class IllegalStateException(TException):
    """
    Attributes:
     - msg

    """


    def __init__(self, msg=None,):
        self.msg = msg

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.msg = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('IllegalStateException')
        if self.msg is not None:
            oprot.writeFieldBegin('msg', TType.STRING, 1)
            oprot.writeString(self.msg.encode('utf-8') if sys.version_info[0] == 2 else self.msg)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.msg is None:
            raise TProtocolException(message='Required field msg is unset!')
        return

    def __str__(self):
        return repr(self)

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class KeyAlreadyExistsException(TException):
    """
    Attributes:
     - msg

    """


    def __init__(self, msg=None,):
        self.msg = msg

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.msg = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('KeyAlreadyExistsException')
        if self.msg is not None:
            oprot.writeFieldBegin('msg', TType.STRING, 1)
            oprot.writeString(self.msg.encode('utf-8') if sys.version_info[0] == 2 else self.msg)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.msg is None:
            raise TProtocolException(message='Required field msg is unset!')
        return

    def __str__(self):
        return repr(self)

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class TopologySummary(object):
    """
    Attributes:
     - id
     - name
     - num_tasks
     - num_executors
     - num_workers
     - uptime_secs
     - status
     - storm_version
     - topology_version
     - sched_status
     - owner
     - replication_count
     - requested_memonheap
     - requested_memoffheap
     - requested_cpu
     - assigned_memonheap
     - assigned_memoffheap
     - assigned_cpu
     - requested_generic_resources
     - assigned_generic_resources

    """


    def __init__(self, id=None, name=None, num_tasks=None, num_executors=None, num_workers=None, uptime_secs=None, status=None, storm_version=None, topology_version=None, sched_status=None, owner=None, replication_count=None, requested_memonheap=None, requested_memoffheap=None, requested_cpu=None, assigned_memonheap=None, assigned_memoffheap=None, assigned_cpu=None, requested_generic_resources=None, assigned_generic_resources=None,):
        self.id = id
        self.name = name
        self.num_tasks = num_tasks
        self.num_executors = num_executors
        self.num_workers = num_workers
        self.uptime_secs = uptime_secs
        self.status = status
        self.storm_version = storm_version
        self.topology_version = topology_version
        self.sched_status = sched_status
        self.owner = owner
        self.replication_count = replication_count
        self.requested_memonheap = requested_memonheap
        self.requested_memoffheap = requested_memoffheap
        self.requested_cpu = requested_cpu
        self.assigned_memonheap = assigned_memonheap
        self.assigned_memoffheap = assigned_memoffheap
        self.assigned_cpu = assigned_cpu
        self.requested_generic_resources = requested_generic_resources
        self.assigned_generic_resources = assigned_generic_resources

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.num_tasks = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I32:
                    self.num_executors = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.I32:
                    self.num_workers = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.I32:
                    self.uptime_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.STRING:
                    self.status = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.STRING:
                    self.storm_version = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 9:
                if ftype == TType.STRING:
                    self.topology_version = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 513:
                if ftype == TType.STRING:
                    self.sched_status = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 514:
                if ftype == TType.STRING:
                    self.owner = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 515:
                if ftype == TType.I32:
                    self.replication_count = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 521:
                if ftype == TType.DOUBLE:
                    self.requested_memonheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 522:
                if ftype == TType.DOUBLE:
                    self.requested_memoffheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 523:
                if ftype == TType.DOUBLE:
                    self.requested_cpu = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 524:
                if ftype == TType.DOUBLE:
                    self.assigned_memonheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 525:
                if ftype == TType.DOUBLE:
                    self.assigned_memoffheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 526:
                if ftype == TType.DOUBLE:
                    self.assigned_cpu = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 527:
                if ftype == TType.MAP:
                    self.requested_generic_resources = {}
                    (_ktype113, _vtype114, _size112) = iprot.readMapBegin()
                    for _i116 in range(_size112):
                        _key117 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val118 = iprot.readDouble()
                        self.requested_generic_resources[_key117] = _val118
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 528:
                if ftype == TType.MAP:
                    self.assigned_generic_resources = {}
                    (_ktype120, _vtype121, _size119) = iprot.readMapBegin()
                    for _i123 in range(_size119):
                        _key124 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val125 = iprot.readDouble()
                        self.assigned_generic_resources[_key124] = _val125
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('TopologySummary')
        if self.id is not None:
            oprot.writeFieldBegin('id', TType.STRING, 1)
            oprot.writeString(self.id.encode('utf-8') if sys.version_info[0] == 2 else self.id)
            oprot.writeFieldEnd()
        if self.name is not None:
            oprot.writeFieldBegin('name', TType.STRING, 2)
            oprot.writeString(self.name.encode('utf-8') if sys.version_info[0] == 2 else self.name)
            oprot.writeFieldEnd()
        if self.num_tasks is not None:
            oprot.writeFieldBegin('num_tasks', TType.I32, 3)
            oprot.writeI32(self.num_tasks)
            oprot.writeFieldEnd()
        if self.num_executors is not None:
            oprot.writeFieldBegin('num_executors', TType.I32, 4)
            oprot.writeI32(self.num_executors)
            oprot.writeFieldEnd()
        if self.num_workers is not None:
            oprot.writeFieldBegin('num_workers', TType.I32, 5)
            oprot.writeI32(self.num_workers)
            oprot.writeFieldEnd()
        if self.uptime_secs is not None:
            oprot.writeFieldBegin('uptime_secs', TType.I32, 6)
            oprot.writeI32(self.uptime_secs)
            oprot.writeFieldEnd()
        if self.status is not None:
            oprot.writeFieldBegin('status', TType.STRING, 7)
            oprot.writeString(self.status.encode('utf-8') if sys.version_info[0] == 2 else self.status)
            oprot.writeFieldEnd()
        if self.storm_version is not None:
            oprot.writeFieldBegin('storm_version', TType.STRING, 8)
            oprot.writeString(self.storm_version.encode('utf-8') if sys.version_info[0] == 2 else self.storm_version)
            oprot.writeFieldEnd()
        if self.topology_version is not None:
            oprot.writeFieldBegin('topology_version', TType.STRING, 9)
            oprot.writeString(self.topology_version.encode('utf-8') if sys.version_info[0] == 2 else self.topology_version)
            oprot.writeFieldEnd()
        if self.sched_status is not None:
            oprot.writeFieldBegin('sched_status', TType.STRING, 513)
            oprot.writeString(self.sched_status.encode('utf-8') if sys.version_info[0] == 2 else self.sched_status)
            oprot.writeFieldEnd()
        if self.owner is not None:
            oprot.writeFieldBegin('owner', TType.STRING, 514)
            oprot.writeString(self.owner.encode('utf-8') if sys.version_info[0] == 2 else self.owner)
            oprot.writeFieldEnd()
        if self.replication_count is not None:
            oprot.writeFieldBegin('replication_count', TType.I32, 515)
            oprot.writeI32(self.replication_count)
            oprot.writeFieldEnd()
        if self.requested_memonheap is not None:
            oprot.writeFieldBegin('requested_memonheap', TType.DOUBLE, 521)
            oprot.writeDouble(self.requested_memonheap)
            oprot.writeFieldEnd()
        if self.requested_memoffheap is not None:
            oprot.writeFieldBegin('requested_memoffheap', TType.DOUBLE, 522)
            oprot.writeDouble(self.requested_memoffheap)
            oprot.writeFieldEnd()
        if self.requested_cpu is not None:
            oprot.writeFieldBegin('requested_cpu', TType.DOUBLE, 523)
            oprot.writeDouble(self.requested_cpu)
            oprot.writeFieldEnd()
        if self.assigned_memonheap is not None:
            oprot.writeFieldBegin('assigned_memonheap', TType.DOUBLE, 524)
            oprot.writeDouble(self.assigned_memonheap)
            oprot.writeFieldEnd()
        if self.assigned_memoffheap is not None:
            oprot.writeFieldBegin('assigned_memoffheap', TType.DOUBLE, 525)
            oprot.writeDouble(self.assigned_memoffheap)
            oprot.writeFieldEnd()
        if self.assigned_cpu is not None:
            oprot.writeFieldBegin('assigned_cpu', TType.DOUBLE, 526)
            oprot.writeDouble(self.assigned_cpu)
            oprot.writeFieldEnd()
        if self.requested_generic_resources is not None:
            oprot.writeFieldBegin('requested_generic_resources', TType.MAP, 527)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.requested_generic_resources))
            for kiter126, viter127 in self.requested_generic_resources.items():
                oprot.writeString(kiter126.encode('utf-8') if sys.version_info[0] == 2 else kiter126)
                oprot.writeDouble(viter127)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.assigned_generic_resources is not None:
            oprot.writeFieldBegin('assigned_generic_resources', TType.MAP, 528)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.assigned_generic_resources))
            for kiter128, viter129 in self.assigned_generic_resources.items():
                oprot.writeString(kiter128.encode('utf-8') if sys.version_info[0] == 2 else kiter128)
                oprot.writeDouble(viter129)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.id is None:
            raise TProtocolException(message='Required field id is unset!')
        if self.name is None:
            raise TProtocolException(message='Required field name is unset!')
        if self.num_tasks is None:
            raise TProtocolException(message='Required field num_tasks is unset!')
        if self.num_executors is None:
            raise TProtocolException(message='Required field num_executors is unset!')
        if self.num_workers is None:
            raise TProtocolException(message='Required field num_workers is unset!')
        if self.uptime_secs is None:
            raise TProtocolException(message='Required field uptime_secs is unset!')
        if self.status is None:
            raise TProtocolException(message='Required field status is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SupervisorSummary(object):
    """
    Attributes:
     - host
     - uptime_secs
     - num_workers
     - num_used_workers
     - supervisor_id
     - version
     - total_resources
     - used_mem
     - used_cpu
     - fragmented_mem
     - fragmented_cpu
     - blacklisted
     - used_generic_resources

    """


    def __init__(self, host=None, uptime_secs=None, num_workers=None, num_used_workers=None, supervisor_id=None, version="VERSION_NOT_PROVIDED", total_resources=None, used_mem=None, used_cpu=None, fragmented_mem=None, fragmented_cpu=None, blacklisted=None, used_generic_resources=None,):
        self.host = host
        self.uptime_secs = uptime_secs
        self.num_workers = num_workers
        self.num_used_workers = num_used_workers
        self.supervisor_id = supervisor_id
        self.version = version
        self.total_resources = total_resources
        self.used_mem = used_mem
        self.used_cpu = used_cpu
        self.fragmented_mem = fragmented_mem
        self.fragmented_cpu = fragmented_cpu
        self.blacklisted = blacklisted
        self.used_generic_resources = used_generic_resources

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.host = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.uptime_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.num_workers = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I32:
                    self.num_used_workers = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.supervisor_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.STRING:
                    self.version = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.MAP:
                    self.total_resources = {}
                    (_ktype131, _vtype132, _size130) = iprot.readMapBegin()
                    for _i134 in range(_size130):
                        _key135 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val136 = iprot.readDouble()
                        self.total_resources[_key135] = _val136
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.DOUBLE:
                    self.used_mem = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 9:
                if ftype == TType.DOUBLE:
                    self.used_cpu = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 10:
                if ftype == TType.DOUBLE:
                    self.fragmented_mem = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 11:
                if ftype == TType.DOUBLE:
                    self.fragmented_cpu = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 12:
                if ftype == TType.BOOL:
                    self.blacklisted = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 13:
                if ftype == TType.MAP:
                    self.used_generic_resources = {}
                    (_ktype138, _vtype139, _size137) = iprot.readMapBegin()
                    for _i141 in range(_size137):
                        _key142 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val143 = iprot.readDouble()
                        self.used_generic_resources[_key142] = _val143
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SupervisorSummary')
        if self.host is not None:
            oprot.writeFieldBegin('host', TType.STRING, 1)
            oprot.writeString(self.host.encode('utf-8') if sys.version_info[0] == 2 else self.host)
            oprot.writeFieldEnd()
        if self.uptime_secs is not None:
            oprot.writeFieldBegin('uptime_secs', TType.I32, 2)
            oprot.writeI32(self.uptime_secs)
            oprot.writeFieldEnd()
        if self.num_workers is not None:
            oprot.writeFieldBegin('num_workers', TType.I32, 3)
            oprot.writeI32(self.num_workers)
            oprot.writeFieldEnd()
        if self.num_used_workers is not None:
            oprot.writeFieldBegin('num_used_workers', TType.I32, 4)
            oprot.writeI32(self.num_used_workers)
            oprot.writeFieldEnd()
        if self.supervisor_id is not None:
            oprot.writeFieldBegin('supervisor_id', TType.STRING, 5)
            oprot.writeString(self.supervisor_id.encode('utf-8') if sys.version_info[0] == 2 else self.supervisor_id)
            oprot.writeFieldEnd()
        if self.version is not None:
            oprot.writeFieldBegin('version', TType.STRING, 6)
            oprot.writeString(self.version.encode('utf-8') if sys.version_info[0] == 2 else self.version)
            oprot.writeFieldEnd()
        if self.total_resources is not None:
            oprot.writeFieldBegin('total_resources', TType.MAP, 7)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.total_resources))
            for kiter144, viter145 in self.total_resources.items():
                oprot.writeString(kiter144.encode('utf-8') if sys.version_info[0] == 2 else kiter144)
                oprot.writeDouble(viter145)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.used_mem is not None:
            oprot.writeFieldBegin('used_mem', TType.DOUBLE, 8)
            oprot.writeDouble(self.used_mem)
            oprot.writeFieldEnd()
        if self.used_cpu is not None:
            oprot.writeFieldBegin('used_cpu', TType.DOUBLE, 9)
            oprot.writeDouble(self.used_cpu)
            oprot.writeFieldEnd()
        if self.fragmented_mem is not None:
            oprot.writeFieldBegin('fragmented_mem', TType.DOUBLE, 10)
            oprot.writeDouble(self.fragmented_mem)
            oprot.writeFieldEnd()
        if self.fragmented_cpu is not None:
            oprot.writeFieldBegin('fragmented_cpu', TType.DOUBLE, 11)
            oprot.writeDouble(self.fragmented_cpu)
            oprot.writeFieldEnd()
        if self.blacklisted is not None:
            oprot.writeFieldBegin('blacklisted', TType.BOOL, 12)
            oprot.writeBool(self.blacklisted)
            oprot.writeFieldEnd()
        if self.used_generic_resources is not None:
            oprot.writeFieldBegin('used_generic_resources', TType.MAP, 13)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.used_generic_resources))
            for kiter146, viter147 in self.used_generic_resources.items():
                oprot.writeString(kiter146.encode('utf-8') if sys.version_info[0] == 2 else kiter146)
                oprot.writeDouble(viter147)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.host is None:
            raise TProtocolException(message='Required field host is unset!')
        if self.uptime_secs is None:
            raise TProtocolException(message='Required field uptime_secs is unset!')
        if self.num_workers is None:
            raise TProtocolException(message='Required field num_workers is unset!')
        if self.num_used_workers is None:
            raise TProtocolException(message='Required field num_used_workers is unset!')
        if self.supervisor_id is None:
            raise TProtocolException(message='Required field supervisor_id is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class NimbusSummary(object):
    """
    Attributes:
     - host
     - port
     - uptime_secs
     - isLeader
     - version

    """


    def __init__(self, host=None, port=None, uptime_secs=None, isLeader=None, version=None,):
        self.host = host
        self.port = port
        self.uptime_secs = uptime_secs
        self.isLeader = isLeader
        self.version = version

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.host = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.port = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.uptime_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.BOOL:
                    self.isLeader = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.version = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('NimbusSummary')
        if self.host is not None:
            oprot.writeFieldBegin('host', TType.STRING, 1)
            oprot.writeString(self.host.encode('utf-8') if sys.version_info[0] == 2 else self.host)
            oprot.writeFieldEnd()
        if self.port is not None:
            oprot.writeFieldBegin('port', TType.I32, 2)
            oprot.writeI32(self.port)
            oprot.writeFieldEnd()
        if self.uptime_secs is not None:
            oprot.writeFieldBegin('uptime_secs', TType.I32, 3)
            oprot.writeI32(self.uptime_secs)
            oprot.writeFieldEnd()
        if self.isLeader is not None:
            oprot.writeFieldBegin('isLeader', TType.BOOL, 4)
            oprot.writeBool(self.isLeader)
            oprot.writeFieldEnd()
        if self.version is not None:
            oprot.writeFieldBegin('version', TType.STRING, 5)
            oprot.writeString(self.version.encode('utf-8') if sys.version_info[0] == 2 else self.version)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.host is None:
            raise TProtocolException(message='Required field host is unset!')
        if self.port is None:
            raise TProtocolException(message='Required field port is unset!')
        if self.uptime_secs is None:
            raise TProtocolException(message='Required field uptime_secs is unset!')
        if self.isLeader is None:
            raise TProtocolException(message='Required field isLeader is unset!')
        if self.version is None:
            raise TProtocolException(message='Required field version is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ClusterSummary(object):
    """
    Attributes:
     - supervisors
     - topologies
     - nimbuses

    """


    def __init__(self, supervisors=None, topologies=None, nimbuses=None,):
        self.supervisors = supervisors
        self.topologies = topologies
        self.nimbuses = nimbuses

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.supervisors = []
                    (_etype151, _size148) = iprot.readListBegin()
                    for _i152 in range(_size148):
                        _elem153 = SupervisorSummary()
                        _elem153.read(iprot)
                        self.supervisors.append(_elem153)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.topologies = []
                    (_etype157, _size154) = iprot.readListBegin()
                    for _i158 in range(_size154):
                        _elem159 = TopologySummary()
                        _elem159.read(iprot)
                        self.topologies.append(_elem159)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.LIST:
                    self.nimbuses = []
                    (_etype163, _size160) = iprot.readListBegin()
                    for _i164 in range(_size160):
                        _elem165 = NimbusSummary()
                        _elem165.read(iprot)
                        self.nimbuses.append(_elem165)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ClusterSummary')
        if self.supervisors is not None:
            oprot.writeFieldBegin('supervisors', TType.LIST, 1)
            oprot.writeListBegin(TType.STRUCT, len(self.supervisors))
            for iter166 in self.supervisors:
                iter166.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.topologies is not None:
            oprot.writeFieldBegin('topologies', TType.LIST, 3)
            oprot.writeListBegin(TType.STRUCT, len(self.topologies))
            for iter167 in self.topologies:
                iter167.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.nimbuses is not None:
            oprot.writeFieldBegin('nimbuses', TType.LIST, 4)
            oprot.writeListBegin(TType.STRUCT, len(self.nimbuses))
            for iter168 in self.nimbuses:
                iter168.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.supervisors is None:
            raise TProtocolException(message='Required field supervisors is unset!')
        if self.topologies is None:
            raise TProtocolException(message='Required field topologies is unset!')
        if self.nimbuses is None:
            raise TProtocolException(message='Required field nimbuses is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ErrorInfo(object):
    """
    Attributes:
     - error
     - error_time_secs
     - host
     - port

    """


    def __init__(self, error=None, error_time_secs=None, host=None, port=None,):
        self.error = error
        self.error_time_secs = error_time_secs
        self.host = host
        self.port = port

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.error = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.error_time_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.host = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I32:
                    self.port = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ErrorInfo')
        if self.error is not None:
            oprot.writeFieldBegin('error', TType.STRING, 1)
            oprot.writeString(self.error.encode('utf-8') if sys.version_info[0] == 2 else self.error)
            oprot.writeFieldEnd()
        if self.error_time_secs is not None:
            oprot.writeFieldBegin('error_time_secs', TType.I32, 2)
            oprot.writeI32(self.error_time_secs)
            oprot.writeFieldEnd()
        if self.host is not None:
            oprot.writeFieldBegin('host', TType.STRING, 3)
            oprot.writeString(self.host.encode('utf-8') if sys.version_info[0] == 2 else self.host)
            oprot.writeFieldEnd()
        if self.port is not None:
            oprot.writeFieldBegin('port', TType.I32, 4)
            oprot.writeI32(self.port)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.error is None:
            raise TProtocolException(message='Required field error is unset!')
        if self.error_time_secs is None:
            raise TProtocolException(message='Required field error_time_secs is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class BoltStats(object):
    """
    Attributes:
     - acked
     - failed
     - process_ms_avg
     - executed
     - execute_ms_avg

    """


    def __init__(self, acked=None, failed=None, process_ms_avg=None, executed=None, execute_ms_avg=None,):
        self.acked = acked
        self.failed = failed
        self.process_ms_avg = process_ms_avg
        self.executed = executed
        self.execute_ms_avg = execute_ms_avg

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.acked = {}
                    (_ktype170, _vtype171, _size169) = iprot.readMapBegin()
                    for _i173 in range(_size169):
                        _key174 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val175 = {}
                        (_ktype177, _vtype178, _size176) = iprot.readMapBegin()
                        for _i180 in range(_size176):
                            _key181 = GlobalStreamId()
                            _key181.read(iprot)
                            _val182 = iprot.readI64()
                            _val175[_key181] = _val182
                        iprot.readMapEnd()
                        self.acked[_key174] = _val175
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.MAP:
                    self.failed = {}
                    (_ktype184, _vtype185, _size183) = iprot.readMapBegin()
                    for _i187 in range(_size183):
                        _key188 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val189 = {}
                        (_ktype191, _vtype192, _size190) = iprot.readMapBegin()
                        for _i194 in range(_size190):
                            _key195 = GlobalStreamId()
                            _key195.read(iprot)
                            _val196 = iprot.readI64()
                            _val189[_key195] = _val196
                        iprot.readMapEnd()
                        self.failed[_key188] = _val189
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.MAP:
                    self.process_ms_avg = {}
                    (_ktype198, _vtype199, _size197) = iprot.readMapBegin()
                    for _i201 in range(_size197):
                        _key202 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val203 = {}
                        (_ktype205, _vtype206, _size204) = iprot.readMapBegin()
                        for _i208 in range(_size204):
                            _key209 = GlobalStreamId()
                            _key209.read(iprot)
                            _val210 = iprot.readDouble()
                            _val203[_key209] = _val210
                        iprot.readMapEnd()
                        self.process_ms_avg[_key202] = _val203
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.executed = {}
                    (_ktype212, _vtype213, _size211) = iprot.readMapBegin()
                    for _i215 in range(_size211):
                        _key216 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val217 = {}
                        (_ktype219, _vtype220, _size218) = iprot.readMapBegin()
                        for _i222 in range(_size218):
                            _key223 = GlobalStreamId()
                            _key223.read(iprot)
                            _val224 = iprot.readI64()
                            _val217[_key223] = _val224
                        iprot.readMapEnd()
                        self.executed[_key216] = _val217
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.MAP:
                    self.execute_ms_avg = {}
                    (_ktype226, _vtype227, _size225) = iprot.readMapBegin()
                    for _i229 in range(_size225):
                        _key230 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val231 = {}
                        (_ktype233, _vtype234, _size232) = iprot.readMapBegin()
                        for _i236 in range(_size232):
                            _key237 = GlobalStreamId()
                            _key237.read(iprot)
                            _val238 = iprot.readDouble()
                            _val231[_key237] = _val238
                        iprot.readMapEnd()
                        self.execute_ms_avg[_key230] = _val231
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('BoltStats')
        if self.acked is not None:
            oprot.writeFieldBegin('acked', TType.MAP, 1)
            oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.acked))
            for kiter239, viter240 in self.acked.items():
                oprot.writeString(kiter239.encode('utf-8') if sys.version_info[0] == 2 else kiter239)
                oprot.writeMapBegin(TType.STRUCT, TType.I64, len(viter240))
                for kiter241, viter242 in viter240.items():
                    kiter241.write(oprot)
                    oprot.writeI64(viter242)
                oprot.writeMapEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.failed is not None:
            oprot.writeFieldBegin('failed', TType.MAP, 2)
            oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.failed))
            for kiter243, viter244 in self.failed.items():
                oprot.writeString(kiter243.encode('utf-8') if sys.version_info[0] == 2 else kiter243)
                oprot.writeMapBegin(TType.STRUCT, TType.I64, len(viter244))
                for kiter245, viter246 in viter244.items():
                    kiter245.write(oprot)
                    oprot.writeI64(viter246)
                oprot.writeMapEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.process_ms_avg is not None:
            oprot.writeFieldBegin('process_ms_avg', TType.MAP, 3)
            oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.process_ms_avg))
            for kiter247, viter248 in self.process_ms_avg.items():
                oprot.writeString(kiter247.encode('utf-8') if sys.version_info[0] == 2 else kiter247)
                oprot.writeMapBegin(TType.STRUCT, TType.DOUBLE, len(viter248))
                for kiter249, viter250 in viter248.items():
                    kiter249.write(oprot)
                    oprot.writeDouble(viter250)
                oprot.writeMapEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.executed is not None:
            oprot.writeFieldBegin('executed', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.executed))
            for kiter251, viter252 in self.executed.items():
                oprot.writeString(kiter251.encode('utf-8') if sys.version_info[0] == 2 else kiter251)
                oprot.writeMapBegin(TType.STRUCT, TType.I64, len(viter252))
                for kiter253, viter254 in viter252.items():
                    kiter253.write(oprot)
                    oprot.writeI64(viter254)
                oprot.writeMapEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.execute_ms_avg is not None:
            oprot.writeFieldBegin('execute_ms_avg', TType.MAP, 5)
            oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.execute_ms_avg))
            for kiter255, viter256 in self.execute_ms_avg.items():
                oprot.writeString(kiter255.encode('utf-8') if sys.version_info[0] == 2 else kiter255)
                oprot.writeMapBegin(TType.STRUCT, TType.DOUBLE, len(viter256))
                for kiter257, viter258 in viter256.items():
                    kiter257.write(oprot)
                    oprot.writeDouble(viter258)
                oprot.writeMapEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.acked is None:
            raise TProtocolException(message='Required field acked is unset!')
        if self.failed is None:
            raise TProtocolException(message='Required field failed is unset!')
        if self.process_ms_avg is None:
            raise TProtocolException(message='Required field process_ms_avg is unset!')
        if self.executed is None:
            raise TProtocolException(message='Required field executed is unset!')
        if self.execute_ms_avg is None:
            raise TProtocolException(message='Required field execute_ms_avg is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SpoutStats(object):
    """
    Attributes:
     - acked
     - failed
     - complete_ms_avg

    """


    def __init__(self, acked=None, failed=None, complete_ms_avg=None,):
        self.acked = acked
        self.failed = failed
        self.complete_ms_avg = complete_ms_avg

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.acked = {}
                    (_ktype260, _vtype261, _size259) = iprot.readMapBegin()
                    for _i263 in range(_size259):
                        _key264 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val265 = {}
                        (_ktype267, _vtype268, _size266) = iprot.readMapBegin()
                        for _i270 in range(_size266):
                            _key271 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                            _val272 = iprot.readI64()
                            _val265[_key271] = _val272
                        iprot.readMapEnd()
                        self.acked[_key264] = _val265
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.MAP:
                    self.failed = {}
                    (_ktype274, _vtype275, _size273) = iprot.readMapBegin()
                    for _i277 in range(_size273):
                        _key278 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val279 = {}
                        (_ktype281, _vtype282, _size280) = iprot.readMapBegin()
                        for _i284 in range(_size280):
                            _key285 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                            _val286 = iprot.readI64()
                            _val279[_key285] = _val286
                        iprot.readMapEnd()
                        self.failed[_key278] = _val279
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.MAP:
                    self.complete_ms_avg = {}
                    (_ktype288, _vtype289, _size287) = iprot.readMapBegin()
                    for _i291 in range(_size287):
                        _key292 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val293 = {}
                        (_ktype295, _vtype296, _size294) = iprot.readMapBegin()
                        for _i298 in range(_size294):
                            _key299 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                            _val300 = iprot.readDouble()
                            _val293[_key299] = _val300
                        iprot.readMapEnd()
                        self.complete_ms_avg[_key292] = _val293
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SpoutStats')
        if self.acked is not None:
            oprot.writeFieldBegin('acked', TType.MAP, 1)
            oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.acked))
            for kiter301, viter302 in self.acked.items():
                oprot.writeString(kiter301.encode('utf-8') if sys.version_info[0] == 2 else kiter301)
                oprot.writeMapBegin(TType.STRING, TType.I64, len(viter302))
                for kiter303, viter304 in viter302.items():
                    oprot.writeString(kiter303.encode('utf-8') if sys.version_info[0] == 2 else kiter303)
                    oprot.writeI64(viter304)
                oprot.writeMapEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.failed is not None:
            oprot.writeFieldBegin('failed', TType.MAP, 2)
            oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.failed))
            for kiter305, viter306 in self.failed.items():
                oprot.writeString(kiter305.encode('utf-8') if sys.version_info[0] == 2 else kiter305)
                oprot.writeMapBegin(TType.STRING, TType.I64, len(viter306))
                for kiter307, viter308 in viter306.items():
                    oprot.writeString(kiter307.encode('utf-8') if sys.version_info[0] == 2 else kiter307)
                    oprot.writeI64(viter308)
                oprot.writeMapEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.complete_ms_avg is not None:
            oprot.writeFieldBegin('complete_ms_avg', TType.MAP, 3)
            oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.complete_ms_avg))
            for kiter309, viter310 in self.complete_ms_avg.items():
                oprot.writeString(kiter309.encode('utf-8') if sys.version_info[0] == 2 else kiter309)
                oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(viter310))
                for kiter311, viter312 in viter310.items():
                    oprot.writeString(kiter311.encode('utf-8') if sys.version_info[0] == 2 else kiter311)
                    oprot.writeDouble(viter312)
                oprot.writeMapEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.acked is None:
            raise TProtocolException(message='Required field acked is unset!')
        if self.failed is None:
            raise TProtocolException(message='Required field failed is unset!')
        if self.complete_ms_avg is None:
            raise TProtocolException(message='Required field complete_ms_avg is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ExecutorSpecificStats(object):
    """
    Attributes:
     - bolt
     - spout

    """


    def __init__(self, bolt=None, spout=None,):
        self.bolt = bolt
        self.spout = spout

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.bolt = BoltStats()
                    self.bolt.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.spout = SpoutStats()
                    self.spout.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ExecutorSpecificStats')
        if self.bolt is not None:
            oprot.writeFieldBegin('bolt', TType.STRUCT, 1)
            self.bolt.write(oprot)
            oprot.writeFieldEnd()
        if self.spout is not None:
            oprot.writeFieldBegin('spout', TType.STRUCT, 2)
            self.spout.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ExecutorStats(object):
    """
    Attributes:
     - emitted
     - transferred
     - specific
     - rate

    """


    def __init__(self, emitted=None, transferred=None, specific=None, rate=None,):
        self.emitted = emitted
        self.transferred = transferred
        self.specific = specific
        self.rate = rate

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.emitted = {}
                    (_ktype314, _vtype315, _size313) = iprot.readMapBegin()
                    for _i317 in range(_size313):
                        _key318 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val319 = {}
                        (_ktype321, _vtype322, _size320) = iprot.readMapBegin()
                        for _i324 in range(_size320):
                            _key325 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                            _val326 = iprot.readI64()
                            _val319[_key325] = _val326
                        iprot.readMapEnd()
                        self.emitted[_key318] = _val319
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.MAP:
                    self.transferred = {}
                    (_ktype328, _vtype329, _size327) = iprot.readMapBegin()
                    for _i331 in range(_size327):
                        _key332 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val333 = {}
                        (_ktype335, _vtype336, _size334) = iprot.readMapBegin()
                        for _i338 in range(_size334):
                            _key339 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                            _val340 = iprot.readI64()
                            _val333[_key339] = _val340
                        iprot.readMapEnd()
                        self.transferred[_key332] = _val333
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRUCT:
                    self.specific = ExecutorSpecificStats()
                    self.specific.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.DOUBLE:
                    self.rate = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ExecutorStats')
        if self.emitted is not None:
            oprot.writeFieldBegin('emitted', TType.MAP, 1)
            oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.emitted))
            for kiter341, viter342 in self.emitted.items():
                oprot.writeString(kiter341.encode('utf-8') if sys.version_info[0] == 2 else kiter341)
                oprot.writeMapBegin(TType.STRING, TType.I64, len(viter342))
                for kiter343, viter344 in viter342.items():
                    oprot.writeString(kiter343.encode('utf-8') if sys.version_info[0] == 2 else kiter343)
                    oprot.writeI64(viter344)
                oprot.writeMapEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.transferred is not None:
            oprot.writeFieldBegin('transferred', TType.MAP, 2)
            oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.transferred))
            for kiter345, viter346 in self.transferred.items():
                oprot.writeString(kiter345.encode('utf-8') if sys.version_info[0] == 2 else kiter345)
                oprot.writeMapBegin(TType.STRING, TType.I64, len(viter346))
                for kiter347, viter348 in viter346.items():
                    oprot.writeString(kiter347.encode('utf-8') if sys.version_info[0] == 2 else kiter347)
                    oprot.writeI64(viter348)
                oprot.writeMapEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.specific is not None:
            oprot.writeFieldBegin('specific', TType.STRUCT, 3)
            self.specific.write(oprot)
            oprot.writeFieldEnd()
        if self.rate is not None:
            oprot.writeFieldBegin('rate', TType.DOUBLE, 4)
            oprot.writeDouble(self.rate)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.emitted is None:
            raise TProtocolException(message='Required field emitted is unset!')
        if self.transferred is None:
            raise TProtocolException(message='Required field transferred is unset!')
        if self.specific is None:
            raise TProtocolException(message='Required field specific is unset!')
        if self.rate is None:
            raise TProtocolException(message='Required field rate is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ExecutorInfo(object):
    """
    Attributes:
     - task_start
     - task_end

    """


    def __init__(self, task_start=None, task_end=None,):
        self.task_start = task_start
        self.task_end = task_end

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.task_start = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.task_end = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ExecutorInfo')
        if self.task_start is not None:
            oprot.writeFieldBegin('task_start', TType.I32, 1)
            oprot.writeI32(self.task_start)
            oprot.writeFieldEnd()
        if self.task_end is not None:
            oprot.writeFieldBegin('task_end', TType.I32, 2)
            oprot.writeI32(self.task_end)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.task_start is None:
            raise TProtocolException(message='Required field task_start is unset!')
        if self.task_end is None:
            raise TProtocolException(message='Required field task_end is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ExecutorSummary(object):
    """
    Attributes:
     - executor_info
     - component_id
     - host
     - port
     - uptime_secs
     - stats

    """


    def __init__(self, executor_info=None, component_id=None, host=None, port=None, uptime_secs=None, stats=None,):
        self.executor_info = executor_info
        self.component_id = component_id
        self.host = host
        self.port = port
        self.uptime_secs = uptime_secs
        self.stats = stats

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.executor_info = ExecutorInfo()
                    self.executor_info.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.component_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.host = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I32:
                    self.port = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.I32:
                    self.uptime_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.STRUCT:
                    self.stats = ExecutorStats()
                    self.stats.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ExecutorSummary')
        if self.executor_info is not None:
            oprot.writeFieldBegin('executor_info', TType.STRUCT, 1)
            self.executor_info.write(oprot)
            oprot.writeFieldEnd()
        if self.component_id is not None:
            oprot.writeFieldBegin('component_id', TType.STRING, 2)
            oprot.writeString(self.component_id.encode('utf-8') if sys.version_info[0] == 2 else self.component_id)
            oprot.writeFieldEnd()
        if self.host is not None:
            oprot.writeFieldBegin('host', TType.STRING, 3)
            oprot.writeString(self.host.encode('utf-8') if sys.version_info[0] == 2 else self.host)
            oprot.writeFieldEnd()
        if self.port is not None:
            oprot.writeFieldBegin('port', TType.I32, 4)
            oprot.writeI32(self.port)
            oprot.writeFieldEnd()
        if self.uptime_secs is not None:
            oprot.writeFieldBegin('uptime_secs', TType.I32, 5)
            oprot.writeI32(self.uptime_secs)
            oprot.writeFieldEnd()
        if self.stats is not None:
            oprot.writeFieldBegin('stats', TType.STRUCT, 7)
            self.stats.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.executor_info is None:
            raise TProtocolException(message='Required field executor_info is unset!')
        if self.component_id is None:
            raise TProtocolException(message='Required field component_id is unset!')
        if self.host is None:
            raise TProtocolException(message='Required field host is unset!')
        if self.port is None:
            raise TProtocolException(message='Required field port is unset!')
        if self.uptime_secs is None:
            raise TProtocolException(message='Required field uptime_secs is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class DebugOptions(object):
    """
    Attributes:
     - enable
     - samplingpct

    """


    def __init__(self, enable=None, samplingpct=None,):
        self.enable = enable
        self.samplingpct = samplingpct

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.BOOL:
                    self.enable = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.DOUBLE:
                    self.samplingpct = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('DebugOptions')
        if self.enable is not None:
            oprot.writeFieldBegin('enable', TType.BOOL, 1)
            oprot.writeBool(self.enable)
            oprot.writeFieldEnd()
        if self.samplingpct is not None:
            oprot.writeFieldBegin('samplingpct', TType.DOUBLE, 2)
            oprot.writeDouble(self.samplingpct)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class TopologyInfo(object):
    """
    Attributes:
     - id
     - name
     - uptime_secs
     - executors
     - status
     - errors
     - component_debug
     - storm_version
     - sched_status
     - owner
     - replication_count
     - requested_memonheap
     - requested_memoffheap
     - requested_cpu
     - assigned_memonheap
     - assigned_memoffheap
     - assigned_cpu

    """


    def __init__(self, id=None, name=None, uptime_secs=None, executors=None, status=None, errors=None, component_debug=None, storm_version=None, sched_status=None, owner=None, replication_count=None, requested_memonheap=None, requested_memoffheap=None, requested_cpu=None, assigned_memonheap=None, assigned_memoffheap=None, assigned_cpu=None,):
        self.id = id
        self.name = name
        self.uptime_secs = uptime_secs
        self.executors = executors
        self.status = status
        self.errors = errors
        self.component_debug = component_debug
        self.storm_version = storm_version
        self.sched_status = sched_status
        self.owner = owner
        self.replication_count = replication_count
        self.requested_memonheap = requested_memonheap
        self.requested_memoffheap = requested_memoffheap
        self.requested_cpu = requested_cpu
        self.assigned_memonheap = assigned_memonheap
        self.assigned_memoffheap = assigned_memoffheap
        self.assigned_cpu = assigned_cpu

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.uptime_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.LIST:
                    self.executors = []
                    (_etype352, _size349) = iprot.readListBegin()
                    for _i353 in range(_size349):
                        _elem354 = ExecutorSummary()
                        _elem354.read(iprot)
                        self.executors.append(_elem354)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.status = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.MAP:
                    self.errors = {}
                    (_ktype356, _vtype357, _size355) = iprot.readMapBegin()
                    for _i359 in range(_size355):
                        _key360 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val361 = []
                        (_etype365, _size362) = iprot.readListBegin()
                        for _i366 in range(_size362):
                            _elem367 = ErrorInfo()
                            _elem367.read(iprot)
                            _val361.append(_elem367)
                        iprot.readListEnd()
                        self.errors[_key360] = _val361
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.MAP:
                    self.component_debug = {}
                    (_ktype369, _vtype370, _size368) = iprot.readMapBegin()
                    for _i372 in range(_size368):
                        _key373 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val374 = DebugOptions()
                        _val374.read(iprot)
                        self.component_debug[_key373] = _val374
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.STRING:
                    self.storm_version = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 513:
                if ftype == TType.STRING:
                    self.sched_status = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 514:
                if ftype == TType.STRING:
                    self.owner = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 515:
                if ftype == TType.I32:
                    self.replication_count = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 521:
                if ftype == TType.DOUBLE:
                    self.requested_memonheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 522:
                if ftype == TType.DOUBLE:
                    self.requested_memoffheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 523:
                if ftype == TType.DOUBLE:
                    self.requested_cpu = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 524:
                if ftype == TType.DOUBLE:
                    self.assigned_memonheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 525:
                if ftype == TType.DOUBLE:
                    self.assigned_memoffheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 526:
                if ftype == TType.DOUBLE:
                    self.assigned_cpu = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('TopologyInfo')
        if self.id is not None:
            oprot.writeFieldBegin('id', TType.STRING, 1)
            oprot.writeString(self.id.encode('utf-8') if sys.version_info[0] == 2 else self.id)
            oprot.writeFieldEnd()
        if self.name is not None:
            oprot.writeFieldBegin('name', TType.STRING, 2)
            oprot.writeString(self.name.encode('utf-8') if sys.version_info[0] == 2 else self.name)
            oprot.writeFieldEnd()
        if self.uptime_secs is not None:
            oprot.writeFieldBegin('uptime_secs', TType.I32, 3)
            oprot.writeI32(self.uptime_secs)
            oprot.writeFieldEnd()
        if self.executors is not None:
            oprot.writeFieldBegin('executors', TType.LIST, 4)
            oprot.writeListBegin(TType.STRUCT, len(self.executors))
            for iter375 in self.executors:
                iter375.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.status is not None:
            oprot.writeFieldBegin('status', TType.STRING, 5)
            oprot.writeString(self.status.encode('utf-8') if sys.version_info[0] == 2 else self.status)
            oprot.writeFieldEnd()
        if self.errors is not None:
            oprot.writeFieldBegin('errors', TType.MAP, 6)
            oprot.writeMapBegin(TType.STRING, TType.LIST, len(self.errors))
            for kiter376, viter377 in self.errors.items():
                oprot.writeString(kiter376.encode('utf-8') if sys.version_info[0] == 2 else kiter376)
                oprot.writeListBegin(TType.STRUCT, len(viter377))
                for iter378 in viter377:
                    iter378.write(oprot)
                oprot.writeListEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.component_debug is not None:
            oprot.writeFieldBegin('component_debug', TType.MAP, 7)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.component_debug))
            for kiter379, viter380 in self.component_debug.items():
                oprot.writeString(kiter379.encode('utf-8') if sys.version_info[0] == 2 else kiter379)
                viter380.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.storm_version is not None:
            oprot.writeFieldBegin('storm_version', TType.STRING, 8)
            oprot.writeString(self.storm_version.encode('utf-8') if sys.version_info[0] == 2 else self.storm_version)
            oprot.writeFieldEnd()
        if self.sched_status is not None:
            oprot.writeFieldBegin('sched_status', TType.STRING, 513)
            oprot.writeString(self.sched_status.encode('utf-8') if sys.version_info[0] == 2 else self.sched_status)
            oprot.writeFieldEnd()
        if self.owner is not None:
            oprot.writeFieldBegin('owner', TType.STRING, 514)
            oprot.writeString(self.owner.encode('utf-8') if sys.version_info[0] == 2 else self.owner)
            oprot.writeFieldEnd()
        if self.replication_count is not None:
            oprot.writeFieldBegin('replication_count', TType.I32, 515)
            oprot.writeI32(self.replication_count)
            oprot.writeFieldEnd()
        if self.requested_memonheap is not None:
            oprot.writeFieldBegin('requested_memonheap', TType.DOUBLE, 521)
            oprot.writeDouble(self.requested_memonheap)
            oprot.writeFieldEnd()
        if self.requested_memoffheap is not None:
            oprot.writeFieldBegin('requested_memoffheap', TType.DOUBLE, 522)
            oprot.writeDouble(self.requested_memoffheap)
            oprot.writeFieldEnd()
        if self.requested_cpu is not None:
            oprot.writeFieldBegin('requested_cpu', TType.DOUBLE, 523)
            oprot.writeDouble(self.requested_cpu)
            oprot.writeFieldEnd()
        if self.assigned_memonheap is not None:
            oprot.writeFieldBegin('assigned_memonheap', TType.DOUBLE, 524)
            oprot.writeDouble(self.assigned_memonheap)
            oprot.writeFieldEnd()
        if self.assigned_memoffheap is not None:
            oprot.writeFieldBegin('assigned_memoffheap', TType.DOUBLE, 525)
            oprot.writeDouble(self.assigned_memoffheap)
            oprot.writeFieldEnd()
        if self.assigned_cpu is not None:
            oprot.writeFieldBegin('assigned_cpu', TType.DOUBLE, 526)
            oprot.writeDouble(self.assigned_cpu)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.id is None:
            raise TProtocolException(message='Required field id is unset!')
        if self.name is None:
            raise TProtocolException(message='Required field name is unset!')
        if self.uptime_secs is None:
            raise TProtocolException(message='Required field uptime_secs is unset!')
        if self.executors is None:
            raise TProtocolException(message='Required field executors is unset!')
        if self.status is None:
            raise TProtocolException(message='Required field status is unset!')
        if self.errors is None:
            raise TProtocolException(message='Required field errors is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class CommonAggregateStats(object):
    """
    Attributes:
     - num_executors
     - num_tasks
     - emitted
     - transferred
     - acked
     - failed
     - resources_map

    """


    def __init__(self, num_executors=None, num_tasks=None, emitted=None, transferred=None, acked=None, failed=None, resources_map=None,):
        self.num_executors = num_executors
        self.num_tasks = num_tasks
        self.emitted = emitted
        self.transferred = transferred
        self.acked = acked
        self.failed = failed
        self.resources_map = resources_map

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.num_executors = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.num_tasks = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.emitted = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I64:
                    self.transferred = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.I64:
                    self.acked = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.I64:
                    self.failed = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.MAP:
                    self.resources_map = {}
                    (_ktype382, _vtype383, _size381) = iprot.readMapBegin()
                    for _i385 in range(_size381):
                        _key386 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val387 = iprot.readDouble()
                        self.resources_map[_key386] = _val387
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('CommonAggregateStats')
        if self.num_executors is not None:
            oprot.writeFieldBegin('num_executors', TType.I32, 1)
            oprot.writeI32(self.num_executors)
            oprot.writeFieldEnd()
        if self.num_tasks is not None:
            oprot.writeFieldBegin('num_tasks', TType.I32, 2)
            oprot.writeI32(self.num_tasks)
            oprot.writeFieldEnd()
        if self.emitted is not None:
            oprot.writeFieldBegin('emitted', TType.I64, 3)
            oprot.writeI64(self.emitted)
            oprot.writeFieldEnd()
        if self.transferred is not None:
            oprot.writeFieldBegin('transferred', TType.I64, 4)
            oprot.writeI64(self.transferred)
            oprot.writeFieldEnd()
        if self.acked is not None:
            oprot.writeFieldBegin('acked', TType.I64, 5)
            oprot.writeI64(self.acked)
            oprot.writeFieldEnd()
        if self.failed is not None:
            oprot.writeFieldBegin('failed', TType.I64, 6)
            oprot.writeI64(self.failed)
            oprot.writeFieldEnd()
        if self.resources_map is not None:
            oprot.writeFieldBegin('resources_map', TType.MAP, 7)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.resources_map))
            for kiter388, viter389 in self.resources_map.items():
                oprot.writeString(kiter388.encode('utf-8') if sys.version_info[0] == 2 else kiter388)
                oprot.writeDouble(viter389)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SpoutAggregateStats(object):
    """
    Attributes:
     - complete_latency_ms

    """


    def __init__(self, complete_latency_ms=None,):
        self.complete_latency_ms = complete_latency_ms

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.DOUBLE:
                    self.complete_latency_ms = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SpoutAggregateStats')
        if self.complete_latency_ms is not None:
            oprot.writeFieldBegin('complete_latency_ms', TType.DOUBLE, 1)
            oprot.writeDouble(self.complete_latency_ms)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class BoltAggregateStats(object):
    """
    Attributes:
     - execute_latency_ms
     - process_latency_ms
     - executed
     - capacity

    """


    def __init__(self, execute_latency_ms=None, process_latency_ms=None, executed=None, capacity=None,):
        self.execute_latency_ms = execute_latency_ms
        self.process_latency_ms = process_latency_ms
        self.executed = executed
        self.capacity = capacity

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.DOUBLE:
                    self.execute_latency_ms = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.DOUBLE:
                    self.process_latency_ms = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.executed = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.DOUBLE:
                    self.capacity = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('BoltAggregateStats')
        if self.execute_latency_ms is not None:
            oprot.writeFieldBegin('execute_latency_ms', TType.DOUBLE, 1)
            oprot.writeDouble(self.execute_latency_ms)
            oprot.writeFieldEnd()
        if self.process_latency_ms is not None:
            oprot.writeFieldBegin('process_latency_ms', TType.DOUBLE, 2)
            oprot.writeDouble(self.process_latency_ms)
            oprot.writeFieldEnd()
        if self.executed is not None:
            oprot.writeFieldBegin('executed', TType.I64, 3)
            oprot.writeI64(self.executed)
            oprot.writeFieldEnd()
        if self.capacity is not None:
            oprot.writeFieldBegin('capacity', TType.DOUBLE, 4)
            oprot.writeDouble(self.capacity)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SpecificAggregateStats(object):
    """
    Attributes:
     - bolt
     - spout

    """


    def __init__(self, bolt=None, spout=None,):
        self.bolt = bolt
        self.spout = spout

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.bolt = BoltAggregateStats()
                    self.bolt.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.spout = SpoutAggregateStats()
                    self.spout.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SpecificAggregateStats')
        if self.bolt is not None:
            oprot.writeFieldBegin('bolt', TType.STRUCT, 1)
            self.bolt.write(oprot)
            oprot.writeFieldEnd()
        if self.spout is not None:
            oprot.writeFieldBegin('spout', TType.STRUCT, 2)
            self.spout.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ComponentAggregateStats(object):
    """
    Attributes:
     - type
     - common_stats
     - specific_stats
     - last_error

    """


    def __init__(self, type=None, common_stats=None, specific_stats=None, last_error=None,):
        self.type = type
        self.common_stats = common_stats
        self.specific_stats = specific_stats
        self.last_error = last_error

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.type = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.common_stats = CommonAggregateStats()
                    self.common_stats.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRUCT:
                    self.specific_stats = SpecificAggregateStats()
                    self.specific_stats.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.STRUCT:
                    self.last_error = ErrorInfo()
                    self.last_error.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ComponentAggregateStats')
        if self.type is not None:
            oprot.writeFieldBegin('type', TType.I32, 1)
            oprot.writeI32(self.type)
            oprot.writeFieldEnd()
        if self.common_stats is not None:
            oprot.writeFieldBegin('common_stats', TType.STRUCT, 2)
            self.common_stats.write(oprot)
            oprot.writeFieldEnd()
        if self.specific_stats is not None:
            oprot.writeFieldBegin('specific_stats', TType.STRUCT, 3)
            self.specific_stats.write(oprot)
            oprot.writeFieldEnd()
        if self.last_error is not None:
            oprot.writeFieldBegin('last_error', TType.STRUCT, 4)
            self.last_error.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class TopologyStats(object):
    """
    Attributes:
     - window_to_emitted
     - window_to_transferred
     - window_to_complete_latencies_ms
     - window_to_acked
     - window_to_failed

    """


    def __init__(self, window_to_emitted=None, window_to_transferred=None, window_to_complete_latencies_ms=None, window_to_acked=None, window_to_failed=None,):
        self.window_to_emitted = window_to_emitted
        self.window_to_transferred = window_to_transferred
        self.window_to_complete_latencies_ms = window_to_complete_latencies_ms
        self.window_to_acked = window_to_acked
        self.window_to_failed = window_to_failed

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.window_to_emitted = {}
                    (_ktype391, _vtype392, _size390) = iprot.readMapBegin()
                    for _i394 in range(_size390):
                        _key395 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val396 = iprot.readI64()
                        self.window_to_emitted[_key395] = _val396
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.MAP:
                    self.window_to_transferred = {}
                    (_ktype398, _vtype399, _size397) = iprot.readMapBegin()
                    for _i401 in range(_size397):
                        _key402 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val403 = iprot.readI64()
                        self.window_to_transferred[_key402] = _val403
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.MAP:
                    self.window_to_complete_latencies_ms = {}
                    (_ktype405, _vtype406, _size404) = iprot.readMapBegin()
                    for _i408 in range(_size404):
                        _key409 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val410 = iprot.readDouble()
                        self.window_to_complete_latencies_ms[_key409] = _val410
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.window_to_acked = {}
                    (_ktype412, _vtype413, _size411) = iprot.readMapBegin()
                    for _i415 in range(_size411):
                        _key416 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val417 = iprot.readI64()
                        self.window_to_acked[_key416] = _val417
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.MAP:
                    self.window_to_failed = {}
                    (_ktype419, _vtype420, _size418) = iprot.readMapBegin()
                    for _i422 in range(_size418):
                        _key423 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val424 = iprot.readI64()
                        self.window_to_failed[_key423] = _val424
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('TopologyStats')
        if self.window_to_emitted is not None:
            oprot.writeFieldBegin('window_to_emitted', TType.MAP, 1)
            oprot.writeMapBegin(TType.STRING, TType.I64, len(self.window_to_emitted))
            for kiter425, viter426 in self.window_to_emitted.items():
                oprot.writeString(kiter425.encode('utf-8') if sys.version_info[0] == 2 else kiter425)
                oprot.writeI64(viter426)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.window_to_transferred is not None:
            oprot.writeFieldBegin('window_to_transferred', TType.MAP, 2)
            oprot.writeMapBegin(TType.STRING, TType.I64, len(self.window_to_transferred))
            for kiter427, viter428 in self.window_to_transferred.items():
                oprot.writeString(kiter427.encode('utf-8') if sys.version_info[0] == 2 else kiter427)
                oprot.writeI64(viter428)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.window_to_complete_latencies_ms is not None:
            oprot.writeFieldBegin('window_to_complete_latencies_ms', TType.MAP, 3)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.window_to_complete_latencies_ms))
            for kiter429, viter430 in self.window_to_complete_latencies_ms.items():
                oprot.writeString(kiter429.encode('utf-8') if sys.version_info[0] == 2 else kiter429)
                oprot.writeDouble(viter430)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.window_to_acked is not None:
            oprot.writeFieldBegin('window_to_acked', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.I64, len(self.window_to_acked))
            for kiter431, viter432 in self.window_to_acked.items():
                oprot.writeString(kiter431.encode('utf-8') if sys.version_info[0] == 2 else kiter431)
                oprot.writeI64(viter432)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.window_to_failed is not None:
            oprot.writeFieldBegin('window_to_failed', TType.MAP, 5)
            oprot.writeMapBegin(TType.STRING, TType.I64, len(self.window_to_failed))
            for kiter433, viter434 in self.window_to_failed.items():
                oprot.writeString(kiter433.encode('utf-8') if sys.version_info[0] == 2 else kiter433)
                oprot.writeI64(viter434)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class WorkerSummary(object):
    """
    Attributes:
     - supervisor_id
     - host
     - port
     - topology_id
     - topology_name
     - num_executors
     - component_to_num_tasks
     - time_secs
     - uptime_secs
     - requested_memonheap
     - requested_memoffheap
     - requested_cpu
     - assigned_memonheap
     - assigned_memoffheap
     - assigned_cpu
     - owner

    """


    def __init__(self, supervisor_id=None, host=None, port=None, topology_id=None, topology_name=None, num_executors=None, component_to_num_tasks=None, time_secs=None, uptime_secs=None, requested_memonheap=None, requested_memoffheap=None, requested_cpu=None, assigned_memonheap=None, assigned_memoffheap=None, assigned_cpu=None, owner=None,):
        self.supervisor_id = supervisor_id
        self.host = host
        self.port = port
        self.topology_id = topology_id
        self.topology_name = topology_name
        self.num_executors = num_executors
        self.component_to_num_tasks = component_to_num_tasks
        self.time_secs = time_secs
        self.uptime_secs = uptime_secs
        self.requested_memonheap = requested_memonheap
        self.requested_memoffheap = requested_memoffheap
        self.requested_cpu = requested_cpu
        self.assigned_memonheap = assigned_memonheap
        self.assigned_memoffheap = assigned_memoffheap
        self.assigned_cpu = assigned_cpu
        self.owner = owner

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.supervisor_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.host = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.port = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.STRING:
                    self.topology_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.topology_name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.I32:
                    self.num_executors = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.MAP:
                    self.component_to_num_tasks = {}
                    (_ktype436, _vtype437, _size435) = iprot.readMapBegin()
                    for _i439 in range(_size435):
                        _key440 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val441 = iprot.readI64()
                        self.component_to_num_tasks[_key440] = _val441
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.I32:
                    self.time_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 9:
                if ftype == TType.I32:
                    self.uptime_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 521:
                if ftype == TType.DOUBLE:
                    self.requested_memonheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 522:
                if ftype == TType.DOUBLE:
                    self.requested_memoffheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 523:
                if ftype == TType.DOUBLE:
                    self.requested_cpu = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 524:
                if ftype == TType.DOUBLE:
                    self.assigned_memonheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 525:
                if ftype == TType.DOUBLE:
                    self.assigned_memoffheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 526:
                if ftype == TType.DOUBLE:
                    self.assigned_cpu = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 527:
                if ftype == TType.STRING:
                    self.owner = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('WorkerSummary')
        if self.supervisor_id is not None:
            oprot.writeFieldBegin('supervisor_id', TType.STRING, 1)
            oprot.writeString(self.supervisor_id.encode('utf-8') if sys.version_info[0] == 2 else self.supervisor_id)
            oprot.writeFieldEnd()
        if self.host is not None:
            oprot.writeFieldBegin('host', TType.STRING, 2)
            oprot.writeString(self.host.encode('utf-8') if sys.version_info[0] == 2 else self.host)
            oprot.writeFieldEnd()
        if self.port is not None:
            oprot.writeFieldBegin('port', TType.I32, 3)
            oprot.writeI32(self.port)
            oprot.writeFieldEnd()
        if self.topology_id is not None:
            oprot.writeFieldBegin('topology_id', TType.STRING, 4)
            oprot.writeString(self.topology_id.encode('utf-8') if sys.version_info[0] == 2 else self.topology_id)
            oprot.writeFieldEnd()
        if self.topology_name is not None:
            oprot.writeFieldBegin('topology_name', TType.STRING, 5)
            oprot.writeString(self.topology_name.encode('utf-8') if sys.version_info[0] == 2 else self.topology_name)
            oprot.writeFieldEnd()
        if self.num_executors is not None:
            oprot.writeFieldBegin('num_executors', TType.I32, 6)
            oprot.writeI32(self.num_executors)
            oprot.writeFieldEnd()
        if self.component_to_num_tasks is not None:
            oprot.writeFieldBegin('component_to_num_tasks', TType.MAP, 7)
            oprot.writeMapBegin(TType.STRING, TType.I64, len(self.component_to_num_tasks))
            for kiter442, viter443 in self.component_to_num_tasks.items():
                oprot.writeString(kiter442.encode('utf-8') if sys.version_info[0] == 2 else kiter442)
                oprot.writeI64(viter443)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.time_secs is not None:
            oprot.writeFieldBegin('time_secs', TType.I32, 8)
            oprot.writeI32(self.time_secs)
            oprot.writeFieldEnd()
        if self.uptime_secs is not None:
            oprot.writeFieldBegin('uptime_secs', TType.I32, 9)
            oprot.writeI32(self.uptime_secs)
            oprot.writeFieldEnd()
        if self.requested_memonheap is not None:
            oprot.writeFieldBegin('requested_memonheap', TType.DOUBLE, 521)
            oprot.writeDouble(self.requested_memonheap)
            oprot.writeFieldEnd()
        if self.requested_memoffheap is not None:
            oprot.writeFieldBegin('requested_memoffheap', TType.DOUBLE, 522)
            oprot.writeDouble(self.requested_memoffheap)
            oprot.writeFieldEnd()
        if self.requested_cpu is not None:
            oprot.writeFieldBegin('requested_cpu', TType.DOUBLE, 523)
            oprot.writeDouble(self.requested_cpu)
            oprot.writeFieldEnd()
        if self.assigned_memonheap is not None:
            oprot.writeFieldBegin('assigned_memonheap', TType.DOUBLE, 524)
            oprot.writeDouble(self.assigned_memonheap)
            oprot.writeFieldEnd()
        if self.assigned_memoffheap is not None:
            oprot.writeFieldBegin('assigned_memoffheap', TType.DOUBLE, 525)
            oprot.writeDouble(self.assigned_memoffheap)
            oprot.writeFieldEnd()
        if self.assigned_cpu is not None:
            oprot.writeFieldBegin('assigned_cpu', TType.DOUBLE, 526)
            oprot.writeDouble(self.assigned_cpu)
            oprot.writeFieldEnd()
        if self.owner is not None:
            oprot.writeFieldBegin('owner', TType.STRING, 527)
            oprot.writeString(self.owner.encode('utf-8') if sys.version_info[0] == 2 else self.owner)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SupervisorPageInfo(object):
    """
    Attributes:
     - supervisor_summaries
     - worker_summaries

    """


    def __init__(self, supervisor_summaries=None, worker_summaries=None,):
        self.supervisor_summaries = supervisor_summaries
        self.worker_summaries = worker_summaries

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.supervisor_summaries = []
                    (_etype447, _size444) = iprot.readListBegin()
                    for _i448 in range(_size444):
                        _elem449 = SupervisorSummary()
                        _elem449.read(iprot)
                        self.supervisor_summaries.append(_elem449)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.worker_summaries = []
                    (_etype453, _size450) = iprot.readListBegin()
                    for _i454 in range(_size450):
                        _elem455 = WorkerSummary()
                        _elem455.read(iprot)
                        self.worker_summaries.append(_elem455)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SupervisorPageInfo')
        if self.supervisor_summaries is not None:
            oprot.writeFieldBegin('supervisor_summaries', TType.LIST, 1)
            oprot.writeListBegin(TType.STRUCT, len(self.supervisor_summaries))
            for iter456 in self.supervisor_summaries:
                iter456.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.worker_summaries is not None:
            oprot.writeFieldBegin('worker_summaries', TType.LIST, 2)
            oprot.writeListBegin(TType.STRUCT, len(self.worker_summaries))
            for iter457 in self.worker_summaries:
                iter457.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class TopologyPageInfo(object):
    """
    Attributes:
     - id
     - name
     - uptime_secs
     - status
     - num_tasks
     - num_workers
     - num_executors
     - topology_conf
     - id_to_spout_agg_stats
     - id_to_bolt_agg_stats
     - sched_status
     - topology_stats
     - owner
     - debug_options
     - replication_count
     - workers
     - storm_version
     - topology_version
     - requested_memonheap
     - requested_memoffheap
     - requested_cpu
     - assigned_memonheap
     - assigned_memoffheap
     - assigned_cpu
     - requested_regular_on_heap_memory
     - requested_shared_on_heap_memory
     - requested_regular_off_heap_memory
     - requested_shared_off_heap_memory
     - assigned_regular_on_heap_memory
     - assigned_shared_on_heap_memory
     - assigned_regular_off_heap_memory
     - assigned_shared_off_heap_memory
     - requested_generic_resources
     - assigned_generic_resources

    """


    def __init__(self, id=None, name=None, uptime_secs=None, status=None, num_tasks=None, num_workers=None, num_executors=None, topology_conf=None, id_to_spout_agg_stats=None, id_to_bolt_agg_stats=None, sched_status=None, topology_stats=None, owner=None, debug_options=None, replication_count=None, workers=None, storm_version=None, topology_version=None, requested_memonheap=None, requested_memoffheap=None, requested_cpu=None, assigned_memonheap=None, assigned_memoffheap=None, assigned_cpu=None, requested_regular_on_heap_memory=None, requested_shared_on_heap_memory=None, requested_regular_off_heap_memory=None, requested_shared_off_heap_memory=None, assigned_regular_on_heap_memory=None, assigned_shared_on_heap_memory=None, assigned_regular_off_heap_memory=None, assigned_shared_off_heap_memory=None, requested_generic_resources=None, assigned_generic_resources=None,):
        self.id = id
        self.name = name
        self.uptime_secs = uptime_secs
        self.status = status
        self.num_tasks = num_tasks
        self.num_workers = num_workers
        self.num_executors = num_executors
        self.topology_conf = topology_conf
        self.id_to_spout_agg_stats = id_to_spout_agg_stats
        self.id_to_bolt_agg_stats = id_to_bolt_agg_stats
        self.sched_status = sched_status
        self.topology_stats = topology_stats
        self.owner = owner
        self.debug_options = debug_options
        self.replication_count = replication_count
        self.workers = workers
        self.storm_version = storm_version
        self.topology_version = topology_version
        self.requested_memonheap = requested_memonheap
        self.requested_memoffheap = requested_memoffheap
        self.requested_cpu = requested_cpu
        self.assigned_memonheap = assigned_memonheap
        self.assigned_memoffheap = assigned_memoffheap
        self.assigned_cpu = assigned_cpu
        self.requested_regular_on_heap_memory = requested_regular_on_heap_memory
        self.requested_shared_on_heap_memory = requested_shared_on_heap_memory
        self.requested_regular_off_heap_memory = requested_regular_off_heap_memory
        self.requested_shared_off_heap_memory = requested_shared_off_heap_memory
        self.assigned_regular_on_heap_memory = assigned_regular_on_heap_memory
        self.assigned_shared_on_heap_memory = assigned_shared_on_heap_memory
        self.assigned_regular_off_heap_memory = assigned_regular_off_heap_memory
        self.assigned_shared_off_heap_memory = assigned_shared_off_heap_memory
        self.requested_generic_resources = requested_generic_resources
        self.assigned_generic_resources = assigned_generic_resources

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.uptime_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.STRING:
                    self.status = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.I32:
                    self.num_tasks = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.I32:
                    self.num_workers = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.I32:
                    self.num_executors = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.STRING:
                    self.topology_conf = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 9:
                if ftype == TType.MAP:
                    self.id_to_spout_agg_stats = {}
                    (_ktype459, _vtype460, _size458) = iprot.readMapBegin()
                    for _i462 in range(_size458):
                        _key463 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val464 = ComponentAggregateStats()
                        _val464.read(iprot)
                        self.id_to_spout_agg_stats[_key463] = _val464
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 10:
                if ftype == TType.MAP:
                    self.id_to_bolt_agg_stats = {}
                    (_ktype466, _vtype467, _size465) = iprot.readMapBegin()
                    for _i469 in range(_size465):
                        _key470 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val471 = ComponentAggregateStats()
                        _val471.read(iprot)
                        self.id_to_bolt_agg_stats[_key470] = _val471
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 11:
                if ftype == TType.STRING:
                    self.sched_status = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 12:
                if ftype == TType.STRUCT:
                    self.topology_stats = TopologyStats()
                    self.topology_stats.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 13:
                if ftype == TType.STRING:
                    self.owner = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 14:
                if ftype == TType.STRUCT:
                    self.debug_options = DebugOptions()
                    self.debug_options.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 15:
                if ftype == TType.I32:
                    self.replication_count = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 16:
                if ftype == TType.LIST:
                    self.workers = []
                    (_etype475, _size472) = iprot.readListBegin()
                    for _i476 in range(_size472):
                        _elem477 = WorkerSummary()
                        _elem477.read(iprot)
                        self.workers.append(_elem477)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 17:
                if ftype == TType.STRING:
                    self.storm_version = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 18:
                if ftype == TType.STRING:
                    self.topology_version = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 521:
                if ftype == TType.DOUBLE:
                    self.requested_memonheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 522:
                if ftype == TType.DOUBLE:
                    self.requested_memoffheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 523:
                if ftype == TType.DOUBLE:
                    self.requested_cpu = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 524:
                if ftype == TType.DOUBLE:
                    self.assigned_memonheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 525:
                if ftype == TType.DOUBLE:
                    self.assigned_memoffheap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 526:
                if ftype == TType.DOUBLE:
                    self.assigned_cpu = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 527:
                if ftype == TType.DOUBLE:
                    self.requested_regular_on_heap_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 528:
                if ftype == TType.DOUBLE:
                    self.requested_shared_on_heap_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 529:
                if ftype == TType.DOUBLE:
                    self.requested_regular_off_heap_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 530:
                if ftype == TType.DOUBLE:
                    self.requested_shared_off_heap_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 531:
                if ftype == TType.DOUBLE:
                    self.assigned_regular_on_heap_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 532:
                if ftype == TType.DOUBLE:
                    self.assigned_shared_on_heap_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 533:
                if ftype == TType.DOUBLE:
                    self.assigned_regular_off_heap_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 534:
                if ftype == TType.DOUBLE:
                    self.assigned_shared_off_heap_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 535:
                if ftype == TType.MAP:
                    self.requested_generic_resources = {}
                    (_ktype479, _vtype480, _size478) = iprot.readMapBegin()
                    for _i482 in range(_size478):
                        _key483 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val484 = iprot.readDouble()
                        self.requested_generic_resources[_key483] = _val484
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 536:
                if ftype == TType.MAP:
                    self.assigned_generic_resources = {}
                    (_ktype486, _vtype487, _size485) = iprot.readMapBegin()
                    for _i489 in range(_size485):
                        _key490 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val491 = iprot.readDouble()
                        self.assigned_generic_resources[_key490] = _val491
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('TopologyPageInfo')
        if self.id is not None:
            oprot.writeFieldBegin('id', TType.STRING, 1)
            oprot.writeString(self.id.encode('utf-8') if sys.version_info[0] == 2 else self.id)
            oprot.writeFieldEnd()
        if self.name is not None:
            oprot.writeFieldBegin('name', TType.STRING, 2)
            oprot.writeString(self.name.encode('utf-8') if sys.version_info[0] == 2 else self.name)
            oprot.writeFieldEnd()
        if self.uptime_secs is not None:
            oprot.writeFieldBegin('uptime_secs', TType.I32, 3)
            oprot.writeI32(self.uptime_secs)
            oprot.writeFieldEnd()
        if self.status is not None:
            oprot.writeFieldBegin('status', TType.STRING, 4)
            oprot.writeString(self.status.encode('utf-8') if sys.version_info[0] == 2 else self.status)
            oprot.writeFieldEnd()
        if self.num_tasks is not None:
            oprot.writeFieldBegin('num_tasks', TType.I32, 5)
            oprot.writeI32(self.num_tasks)
            oprot.writeFieldEnd()
        if self.num_workers is not None:
            oprot.writeFieldBegin('num_workers', TType.I32, 6)
            oprot.writeI32(self.num_workers)
            oprot.writeFieldEnd()
        if self.num_executors is not None:
            oprot.writeFieldBegin('num_executors', TType.I32, 7)
            oprot.writeI32(self.num_executors)
            oprot.writeFieldEnd()
        if self.topology_conf is not None:
            oprot.writeFieldBegin('topology_conf', TType.STRING, 8)
            oprot.writeString(self.topology_conf.encode('utf-8') if sys.version_info[0] == 2 else self.topology_conf)
            oprot.writeFieldEnd()
        if self.id_to_spout_agg_stats is not None:
            oprot.writeFieldBegin('id_to_spout_agg_stats', TType.MAP, 9)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.id_to_spout_agg_stats))
            for kiter492, viter493 in self.id_to_spout_agg_stats.items():
                oprot.writeString(kiter492.encode('utf-8') if sys.version_info[0] == 2 else kiter492)
                viter493.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.id_to_bolt_agg_stats is not None:
            oprot.writeFieldBegin('id_to_bolt_agg_stats', TType.MAP, 10)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.id_to_bolt_agg_stats))
            for kiter494, viter495 in self.id_to_bolt_agg_stats.items():
                oprot.writeString(kiter494.encode('utf-8') if sys.version_info[0] == 2 else kiter494)
                viter495.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.sched_status is not None:
            oprot.writeFieldBegin('sched_status', TType.STRING, 11)
            oprot.writeString(self.sched_status.encode('utf-8') if sys.version_info[0] == 2 else self.sched_status)
            oprot.writeFieldEnd()
        if self.topology_stats is not None:
            oprot.writeFieldBegin('topology_stats', TType.STRUCT, 12)
            self.topology_stats.write(oprot)
            oprot.writeFieldEnd()
        if self.owner is not None:
            oprot.writeFieldBegin('owner', TType.STRING, 13)
            oprot.writeString(self.owner.encode('utf-8') if sys.version_info[0] == 2 else self.owner)
            oprot.writeFieldEnd()
        if self.debug_options is not None:
            oprot.writeFieldBegin('debug_options', TType.STRUCT, 14)
            self.debug_options.write(oprot)
            oprot.writeFieldEnd()
        if self.replication_count is not None:
            oprot.writeFieldBegin('replication_count', TType.I32, 15)
            oprot.writeI32(self.replication_count)
            oprot.writeFieldEnd()
        if self.workers is not None:
            oprot.writeFieldBegin('workers', TType.LIST, 16)
            oprot.writeListBegin(TType.STRUCT, len(self.workers))
            for iter496 in self.workers:
                iter496.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.storm_version is not None:
            oprot.writeFieldBegin('storm_version', TType.STRING, 17)
            oprot.writeString(self.storm_version.encode('utf-8') if sys.version_info[0] == 2 else self.storm_version)
            oprot.writeFieldEnd()
        if self.topology_version is not None:
            oprot.writeFieldBegin('topology_version', TType.STRING, 18)
            oprot.writeString(self.topology_version.encode('utf-8') if sys.version_info[0] == 2 else self.topology_version)
            oprot.writeFieldEnd()
        if self.requested_memonheap is not None:
            oprot.writeFieldBegin('requested_memonheap', TType.DOUBLE, 521)
            oprot.writeDouble(self.requested_memonheap)
            oprot.writeFieldEnd()
        if self.requested_memoffheap is not None:
            oprot.writeFieldBegin('requested_memoffheap', TType.DOUBLE, 522)
            oprot.writeDouble(self.requested_memoffheap)
            oprot.writeFieldEnd()
        if self.requested_cpu is not None:
            oprot.writeFieldBegin('requested_cpu', TType.DOUBLE, 523)
            oprot.writeDouble(self.requested_cpu)
            oprot.writeFieldEnd()
        if self.assigned_memonheap is not None:
            oprot.writeFieldBegin('assigned_memonheap', TType.DOUBLE, 524)
            oprot.writeDouble(self.assigned_memonheap)
            oprot.writeFieldEnd()
        if self.assigned_memoffheap is not None:
            oprot.writeFieldBegin('assigned_memoffheap', TType.DOUBLE, 525)
            oprot.writeDouble(self.assigned_memoffheap)
            oprot.writeFieldEnd()
        if self.assigned_cpu is not None:
            oprot.writeFieldBegin('assigned_cpu', TType.DOUBLE, 526)
            oprot.writeDouble(self.assigned_cpu)
            oprot.writeFieldEnd()
        if self.requested_regular_on_heap_memory is not None:
            oprot.writeFieldBegin('requested_regular_on_heap_memory', TType.DOUBLE, 527)
            oprot.writeDouble(self.requested_regular_on_heap_memory)
            oprot.writeFieldEnd()
        if self.requested_shared_on_heap_memory is not None:
            oprot.writeFieldBegin('requested_shared_on_heap_memory', TType.DOUBLE, 528)
            oprot.writeDouble(self.requested_shared_on_heap_memory)
            oprot.writeFieldEnd()
        if self.requested_regular_off_heap_memory is not None:
            oprot.writeFieldBegin('requested_regular_off_heap_memory', TType.DOUBLE, 529)
            oprot.writeDouble(self.requested_regular_off_heap_memory)
            oprot.writeFieldEnd()
        if self.requested_shared_off_heap_memory is not None:
            oprot.writeFieldBegin('requested_shared_off_heap_memory', TType.DOUBLE, 530)
            oprot.writeDouble(self.requested_shared_off_heap_memory)
            oprot.writeFieldEnd()
        if self.assigned_regular_on_heap_memory is not None:
            oprot.writeFieldBegin('assigned_regular_on_heap_memory', TType.DOUBLE, 531)
            oprot.writeDouble(self.assigned_regular_on_heap_memory)
            oprot.writeFieldEnd()
        if self.assigned_shared_on_heap_memory is not None:
            oprot.writeFieldBegin('assigned_shared_on_heap_memory', TType.DOUBLE, 532)
            oprot.writeDouble(self.assigned_shared_on_heap_memory)
            oprot.writeFieldEnd()
        if self.assigned_regular_off_heap_memory is not None:
            oprot.writeFieldBegin('assigned_regular_off_heap_memory', TType.DOUBLE, 533)
            oprot.writeDouble(self.assigned_regular_off_heap_memory)
            oprot.writeFieldEnd()
        if self.assigned_shared_off_heap_memory is not None:
            oprot.writeFieldBegin('assigned_shared_off_heap_memory', TType.DOUBLE, 534)
            oprot.writeDouble(self.assigned_shared_off_heap_memory)
            oprot.writeFieldEnd()
        if self.requested_generic_resources is not None:
            oprot.writeFieldBegin('requested_generic_resources', TType.MAP, 535)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.requested_generic_resources))
            for kiter497, viter498 in self.requested_generic_resources.items():
                oprot.writeString(kiter497.encode('utf-8') if sys.version_info[0] == 2 else kiter497)
                oprot.writeDouble(viter498)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.assigned_generic_resources is not None:
            oprot.writeFieldBegin('assigned_generic_resources', TType.MAP, 536)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.assigned_generic_resources))
            for kiter499, viter500 in self.assigned_generic_resources.items():
                oprot.writeString(kiter499.encode('utf-8') if sys.version_info[0] == 2 else kiter499)
                oprot.writeDouble(viter500)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.id is None:
            raise TProtocolException(message='Required field id is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ExecutorAggregateStats(object):
    """
    Attributes:
     - exec_summary
     - stats

    """


    def __init__(self, exec_summary=None, stats=None,):
        self.exec_summary = exec_summary
        self.stats = stats

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.exec_summary = ExecutorSummary()
                    self.exec_summary.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.stats = ComponentAggregateStats()
                    self.stats.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ExecutorAggregateStats')
        if self.exec_summary is not None:
            oprot.writeFieldBegin('exec_summary', TType.STRUCT, 1)
            self.exec_summary.write(oprot)
            oprot.writeFieldEnd()
        if self.stats is not None:
            oprot.writeFieldBegin('stats', TType.STRUCT, 2)
            self.stats.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ComponentPageInfo(object):
    """
    Attributes:
     - component_id
     - component_type
     - topology_id
     - topology_name
     - num_executors
     - num_tasks
     - window_to_stats
     - gsid_to_input_stats
     - sid_to_output_stats
     - exec_stats
     - errors
     - eventlog_host
     - eventlog_port
     - debug_options
     - topology_status
     - resources_map

    """


    def __init__(self, component_id=None, component_type=None, topology_id=None, topology_name=None, num_executors=None, num_tasks=None, window_to_stats=None, gsid_to_input_stats=None, sid_to_output_stats=None, exec_stats=None, errors=None, eventlog_host=None, eventlog_port=None, debug_options=None, topology_status=None, resources_map=None,):
        self.component_id = component_id
        self.component_type = component_type
        self.topology_id = topology_id
        self.topology_name = topology_name
        self.num_executors = num_executors
        self.num_tasks = num_tasks
        self.window_to_stats = window_to_stats
        self.gsid_to_input_stats = gsid_to_input_stats
        self.sid_to_output_stats = sid_to_output_stats
        self.exec_stats = exec_stats
        self.errors = errors
        self.eventlog_host = eventlog_host
        self.eventlog_port = eventlog_port
        self.debug_options = debug_options
        self.topology_status = topology_status
        self.resources_map = resources_map

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.component_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.component_type = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.topology_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.STRING:
                    self.topology_name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.I32:
                    self.num_executors = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.I32:
                    self.num_tasks = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.MAP:
                    self.window_to_stats = {}
                    (_ktype502, _vtype503, _size501) = iprot.readMapBegin()
                    for _i505 in range(_size501):
                        _key506 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val507 = ComponentAggregateStats()
                        _val507.read(iprot)
                        self.window_to_stats[_key506] = _val507
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.MAP:
                    self.gsid_to_input_stats = {}
                    (_ktype509, _vtype510, _size508) = iprot.readMapBegin()
                    for _i512 in range(_size508):
                        _key513 = GlobalStreamId()
                        _key513.read(iprot)
                        _val514 = ComponentAggregateStats()
                        _val514.read(iprot)
                        self.gsid_to_input_stats[_key513] = _val514
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 9:
                if ftype == TType.MAP:
                    self.sid_to_output_stats = {}
                    (_ktype516, _vtype517, _size515) = iprot.readMapBegin()
                    for _i519 in range(_size515):
                        _key520 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val521 = ComponentAggregateStats()
                        _val521.read(iprot)
                        self.sid_to_output_stats[_key520] = _val521
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 10:
                if ftype == TType.LIST:
                    self.exec_stats = []
                    (_etype525, _size522) = iprot.readListBegin()
                    for _i526 in range(_size522):
                        _elem527 = ExecutorAggregateStats()
                        _elem527.read(iprot)
                        self.exec_stats.append(_elem527)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 11:
                if ftype == TType.LIST:
                    self.errors = []
                    (_etype531, _size528) = iprot.readListBegin()
                    for _i532 in range(_size528):
                        _elem533 = ErrorInfo()
                        _elem533.read(iprot)
                        self.errors.append(_elem533)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 12:
                if ftype == TType.STRING:
                    self.eventlog_host = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 13:
                if ftype == TType.I32:
                    self.eventlog_port = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 14:
                if ftype == TType.STRUCT:
                    self.debug_options = DebugOptions()
                    self.debug_options.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 15:
                if ftype == TType.STRING:
                    self.topology_status = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 16:
                if ftype == TType.MAP:
                    self.resources_map = {}
                    (_ktype535, _vtype536, _size534) = iprot.readMapBegin()
                    for _i538 in range(_size534):
                        _key539 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val540 = iprot.readDouble()
                        self.resources_map[_key539] = _val540
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ComponentPageInfo')
        if self.component_id is not None:
            oprot.writeFieldBegin('component_id', TType.STRING, 1)
            oprot.writeString(self.component_id.encode('utf-8') if sys.version_info[0] == 2 else self.component_id)
            oprot.writeFieldEnd()
        if self.component_type is not None:
            oprot.writeFieldBegin('component_type', TType.I32, 2)
            oprot.writeI32(self.component_type)
            oprot.writeFieldEnd()
        if self.topology_id is not None:
            oprot.writeFieldBegin('topology_id', TType.STRING, 3)
            oprot.writeString(self.topology_id.encode('utf-8') if sys.version_info[0] == 2 else self.topology_id)
            oprot.writeFieldEnd()
        if self.topology_name is not None:
            oprot.writeFieldBegin('topology_name', TType.STRING, 4)
            oprot.writeString(self.topology_name.encode('utf-8') if sys.version_info[0] == 2 else self.topology_name)
            oprot.writeFieldEnd()
        if self.num_executors is not None:
            oprot.writeFieldBegin('num_executors', TType.I32, 5)
            oprot.writeI32(self.num_executors)
            oprot.writeFieldEnd()
        if self.num_tasks is not None:
            oprot.writeFieldBegin('num_tasks', TType.I32, 6)
            oprot.writeI32(self.num_tasks)
            oprot.writeFieldEnd()
        if self.window_to_stats is not None:
            oprot.writeFieldBegin('window_to_stats', TType.MAP, 7)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.window_to_stats))
            for kiter541, viter542 in self.window_to_stats.items():
                oprot.writeString(kiter541.encode('utf-8') if sys.version_info[0] == 2 else kiter541)
                viter542.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.gsid_to_input_stats is not None:
            oprot.writeFieldBegin('gsid_to_input_stats', TType.MAP, 8)
            oprot.writeMapBegin(TType.STRUCT, TType.STRUCT, len(self.gsid_to_input_stats))
            for kiter543, viter544 in self.gsid_to_input_stats.items():
                kiter543.write(oprot)
                viter544.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.sid_to_output_stats is not None:
            oprot.writeFieldBegin('sid_to_output_stats', TType.MAP, 9)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.sid_to_output_stats))
            for kiter545, viter546 in self.sid_to_output_stats.items():
                oprot.writeString(kiter545.encode('utf-8') if sys.version_info[0] == 2 else kiter545)
                viter546.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.exec_stats is not None:
            oprot.writeFieldBegin('exec_stats', TType.LIST, 10)
            oprot.writeListBegin(TType.STRUCT, len(self.exec_stats))
            for iter547 in self.exec_stats:
                iter547.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.errors is not None:
            oprot.writeFieldBegin('errors', TType.LIST, 11)
            oprot.writeListBegin(TType.STRUCT, len(self.errors))
            for iter548 in self.errors:
                iter548.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.eventlog_host is not None:
            oprot.writeFieldBegin('eventlog_host', TType.STRING, 12)
            oprot.writeString(self.eventlog_host.encode('utf-8') if sys.version_info[0] == 2 else self.eventlog_host)
            oprot.writeFieldEnd()
        if self.eventlog_port is not None:
            oprot.writeFieldBegin('eventlog_port', TType.I32, 13)
            oprot.writeI32(self.eventlog_port)
            oprot.writeFieldEnd()
        if self.debug_options is not None:
            oprot.writeFieldBegin('debug_options', TType.STRUCT, 14)
            self.debug_options.write(oprot)
            oprot.writeFieldEnd()
        if self.topology_status is not None:
            oprot.writeFieldBegin('topology_status', TType.STRING, 15)
            oprot.writeString(self.topology_status.encode('utf-8') if sys.version_info[0] == 2 else self.topology_status)
            oprot.writeFieldEnd()
        if self.resources_map is not None:
            oprot.writeFieldBegin('resources_map', TType.MAP, 16)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.resources_map))
            for kiter549, viter550 in self.resources_map.items():
                oprot.writeString(kiter549.encode('utf-8') if sys.version_info[0] == 2 else kiter549)
                oprot.writeDouble(viter550)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.component_id is None:
            raise TProtocolException(message='Required field component_id is unset!')
        if self.component_type is None:
            raise TProtocolException(message='Required field component_type is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class KillOptions(object):
    """
    Attributes:
     - wait_secs

    """


    def __init__(self, wait_secs=None,):
        self.wait_secs = wait_secs

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.wait_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('KillOptions')
        if self.wait_secs is not None:
            oprot.writeFieldBegin('wait_secs', TType.I32, 1)
            oprot.writeI32(self.wait_secs)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class RebalanceOptions(object):
    """
    Attributes:
     - wait_secs
     - num_workers
     - num_executors
     - topology_resources_overrides
     - topology_conf_overrides
     - principal

    """


    def __init__(self, wait_secs=None, num_workers=None, num_executors=None, topology_resources_overrides=None, topology_conf_overrides=None, principal=None,):
        self.wait_secs = wait_secs
        self.num_workers = num_workers
        self.num_executors = num_executors
        self.topology_resources_overrides = topology_resources_overrides
        self.topology_conf_overrides = topology_conf_overrides
        self.principal = principal

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.wait_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.num_workers = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.MAP:
                    self.num_executors = {}
                    (_ktype552, _vtype553, _size551) = iprot.readMapBegin()
                    for _i555 in range(_size551):
                        _key556 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val557 = iprot.readI32()
                        self.num_executors[_key556] = _val557
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.topology_resources_overrides = {}
                    (_ktype559, _vtype560, _size558) = iprot.readMapBegin()
                    for _i562 in range(_size558):
                        _key563 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val564 = {}
                        (_ktype566, _vtype567, _size565) = iprot.readMapBegin()
                        for _i569 in range(_size565):
                            _key570 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                            _val571 = iprot.readDouble()
                            _val564[_key570] = _val571
                        iprot.readMapEnd()
                        self.topology_resources_overrides[_key563] = _val564
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.topology_conf_overrides = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.STRING:
                    self.principal = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('RebalanceOptions')
        if self.wait_secs is not None:
            oprot.writeFieldBegin('wait_secs', TType.I32, 1)
            oprot.writeI32(self.wait_secs)
            oprot.writeFieldEnd()
        if self.num_workers is not None:
            oprot.writeFieldBegin('num_workers', TType.I32, 2)
            oprot.writeI32(self.num_workers)
            oprot.writeFieldEnd()
        if self.num_executors is not None:
            oprot.writeFieldBegin('num_executors', TType.MAP, 3)
            oprot.writeMapBegin(TType.STRING, TType.I32, len(self.num_executors))
            for kiter572, viter573 in self.num_executors.items():
                oprot.writeString(kiter572.encode('utf-8') if sys.version_info[0] == 2 else kiter572)
                oprot.writeI32(viter573)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.topology_resources_overrides is not None:
            oprot.writeFieldBegin('topology_resources_overrides', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.topology_resources_overrides))
            for kiter574, viter575 in self.topology_resources_overrides.items():
                oprot.writeString(kiter574.encode('utf-8') if sys.version_info[0] == 2 else kiter574)
                oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(viter575))
                for kiter576, viter577 in viter575.items():
                    oprot.writeString(kiter576.encode('utf-8') if sys.version_info[0] == 2 else kiter576)
                    oprot.writeDouble(viter577)
                oprot.writeMapEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.topology_conf_overrides is not None:
            oprot.writeFieldBegin('topology_conf_overrides', TType.STRING, 5)
            oprot.writeString(self.topology_conf_overrides.encode('utf-8') if sys.version_info[0] == 2 else self.topology_conf_overrides)
            oprot.writeFieldEnd()
        if self.principal is not None:
            oprot.writeFieldBegin('principal', TType.STRING, 6)
            oprot.writeString(self.principal.encode('utf-8') if sys.version_info[0] == 2 else self.principal)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class Credentials(object):
    """
    Attributes:
     - creds
     - topoOwner

    """


    def __init__(self, creds=None, topoOwner=None,):
        self.creds = creds
        self.topoOwner = topoOwner

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.creds = {}
                    (_ktype579, _vtype580, _size578) = iprot.readMapBegin()
                    for _i582 in range(_size578):
                        _key583 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val584 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.creds[_key583] = _val584
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.topoOwner = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Credentials')
        if self.creds is not None:
            oprot.writeFieldBegin('creds', TType.MAP, 1)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.creds))
            for kiter585, viter586 in self.creds.items():
                oprot.writeString(kiter585.encode('utf-8') if sys.version_info[0] == 2 else kiter585)
                oprot.writeString(viter586.encode('utf-8') if sys.version_info[0] == 2 else viter586)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.topoOwner is not None:
            oprot.writeFieldBegin('topoOwner', TType.STRING, 2)
            oprot.writeString(self.topoOwner.encode('utf-8') if sys.version_info[0] == 2 else self.topoOwner)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.creds is None:
            raise TProtocolException(message='Required field creds is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SubmitOptions(object):
    """
    Attributes:
     - initial_status
     - creds

    """


    def __init__(self, initial_status=None, creds=None,):
        self.initial_status = initial_status
        self.creds = creds

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.initial_status = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.creds = Credentials()
                    self.creds.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SubmitOptions')
        if self.initial_status is not None:
            oprot.writeFieldBegin('initial_status', TType.I32, 1)
            oprot.writeI32(self.initial_status)
            oprot.writeFieldEnd()
        if self.creds is not None:
            oprot.writeFieldBegin('creds', TType.STRUCT, 2)
            self.creds.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.initial_status is None:
            raise TProtocolException(message='Required field initial_status is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class AccessControl(object):
    """
    Attributes:
     - type
     - name
     - access

    """


    def __init__(self, type=None, name=None, access=None,):
        self.type = type
        self.name = name
        self.access = access

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.type = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.access = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('AccessControl')
        if self.type is not None:
            oprot.writeFieldBegin('type', TType.I32, 1)
            oprot.writeI32(self.type)
            oprot.writeFieldEnd()
        if self.name is not None:
            oprot.writeFieldBegin('name', TType.STRING, 2)
            oprot.writeString(self.name.encode('utf-8') if sys.version_info[0] == 2 else self.name)
            oprot.writeFieldEnd()
        if self.access is not None:
            oprot.writeFieldBegin('access', TType.I32, 3)
            oprot.writeI32(self.access)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.type is None:
            raise TProtocolException(message='Required field type is unset!')
        if self.access is None:
            raise TProtocolException(message='Required field access is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SettableBlobMeta(object):
    """
    Attributes:
     - acl
     - replication_factor

    """


    def __init__(self, acl=None, replication_factor=None,):
        self.acl = acl
        self.replication_factor = replication_factor

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.acl = []
                    (_etype590, _size587) = iprot.readListBegin()
                    for _i591 in range(_size587):
                        _elem592 = AccessControl()
                        _elem592.read(iprot)
                        self.acl.append(_elem592)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.replication_factor = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SettableBlobMeta')
        if self.acl is not None:
            oprot.writeFieldBegin('acl', TType.LIST, 1)
            oprot.writeListBegin(TType.STRUCT, len(self.acl))
            for iter593 in self.acl:
                iter593.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.replication_factor is not None:
            oprot.writeFieldBegin('replication_factor', TType.I32, 2)
            oprot.writeI32(self.replication_factor)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.acl is None:
            raise TProtocolException(message='Required field acl is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ReadableBlobMeta(object):
    """
    Attributes:
     - settable
     - version

    """


    def __init__(self, settable=None, version=None,):
        self.settable = settable
        self.version = version

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.settable = SettableBlobMeta()
                    self.settable.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I64:
                    self.version = iprot.readI64()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ReadableBlobMeta')
        if self.settable is not None:
            oprot.writeFieldBegin('settable', TType.STRUCT, 1)
            self.settable.write(oprot)
            oprot.writeFieldEnd()
        if self.version is not None:
            oprot.writeFieldBegin('version', TType.I64, 2)
            oprot.writeI64(self.version)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.settable is None:
            raise TProtocolException(message='Required field settable is unset!')
        if self.version is None:
            raise TProtocolException(message='Required field version is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ListBlobsResult(object):
    """
    Attributes:
     - keys
     - session

    """


    def __init__(self, keys=None, session=None,):
        self.keys = keys
        self.session = session

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.keys = []
                    (_etype597, _size594) = iprot.readListBegin()
                    for _i598 in range(_size594):
                        _elem599 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.keys.append(_elem599)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.session = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ListBlobsResult')
        if self.keys is not None:
            oprot.writeFieldBegin('keys', TType.LIST, 1)
            oprot.writeListBegin(TType.STRING, len(self.keys))
            for iter600 in self.keys:
                oprot.writeString(iter600.encode('utf-8') if sys.version_info[0] == 2 else iter600)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.session is not None:
            oprot.writeFieldBegin('session', TType.STRING, 2)
            oprot.writeString(self.session.encode('utf-8') if sys.version_info[0] == 2 else self.session)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.keys is None:
            raise TProtocolException(message='Required field keys is unset!')
        if self.session is None:
            raise TProtocolException(message='Required field session is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class BeginDownloadResult(object):
    """
    Attributes:
     - version
     - session
     - data_size

    """


    def __init__(self, version=None, session=None, data_size=None,):
        self.version = version
        self.session = session
        self.data_size = data_size

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I64:
                    self.version = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.session = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.data_size = iprot.readI64()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('BeginDownloadResult')
        if self.version is not None:
            oprot.writeFieldBegin('version', TType.I64, 1)
            oprot.writeI64(self.version)
            oprot.writeFieldEnd()
        if self.session is not None:
            oprot.writeFieldBegin('session', TType.STRING, 2)
            oprot.writeString(self.session.encode('utf-8') if sys.version_info[0] == 2 else self.session)
            oprot.writeFieldEnd()
        if self.data_size is not None:
            oprot.writeFieldBegin('data_size', TType.I64, 3)
            oprot.writeI64(self.data_size)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.version is None:
            raise TProtocolException(message='Required field version is unset!')
        if self.session is None:
            raise TProtocolException(message='Required field session is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SupervisorInfo(object):
    """
    Attributes:
     - time_secs
     - hostname
     - assignment_id
     - used_ports
     - meta
     - scheduler_meta
     - uptime_secs
     - version
     - resources_map
     - server_port

    """


    def __init__(self, time_secs=None, hostname=None, assignment_id=None, used_ports=None, meta=None, scheduler_meta=None, uptime_secs=None, version=None, resources_map=None, server_port=None,):
        self.time_secs = time_secs
        self.hostname = hostname
        self.assignment_id = assignment_id
        self.used_ports = used_ports
        self.meta = meta
        self.scheduler_meta = scheduler_meta
        self.uptime_secs = uptime_secs
        self.version = version
        self.resources_map = resources_map
        self.server_port = server_port

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I64:
                    self.time_secs = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.hostname = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.assignment_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.LIST:
                    self.used_ports = []
                    (_etype604, _size601) = iprot.readListBegin()
                    for _i605 in range(_size601):
                        _elem606 = iprot.readI64()
                        self.used_ports.append(_elem606)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.LIST:
                    self.meta = []
                    (_etype610, _size607) = iprot.readListBegin()
                    for _i611 in range(_size607):
                        _elem612 = iprot.readI64()
                        self.meta.append(_elem612)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.MAP:
                    self.scheduler_meta = {}
                    (_ktype614, _vtype615, _size613) = iprot.readMapBegin()
                    for _i617 in range(_size613):
                        _key618 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val619 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.scheduler_meta[_key618] = _val619
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.I64:
                    self.uptime_secs = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.STRING:
                    self.version = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 9:
                if ftype == TType.MAP:
                    self.resources_map = {}
                    (_ktype621, _vtype622, _size620) = iprot.readMapBegin()
                    for _i624 in range(_size620):
                        _key625 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val626 = iprot.readDouble()
                        self.resources_map[_key625] = _val626
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 10:
                if ftype == TType.I32:
                    self.server_port = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SupervisorInfo')
        if self.time_secs is not None:
            oprot.writeFieldBegin('time_secs', TType.I64, 1)
            oprot.writeI64(self.time_secs)
            oprot.writeFieldEnd()
        if self.hostname is not None:
            oprot.writeFieldBegin('hostname', TType.STRING, 2)
            oprot.writeString(self.hostname.encode('utf-8') if sys.version_info[0] == 2 else self.hostname)
            oprot.writeFieldEnd()
        if self.assignment_id is not None:
            oprot.writeFieldBegin('assignment_id', TType.STRING, 3)
            oprot.writeString(self.assignment_id.encode('utf-8') if sys.version_info[0] == 2 else self.assignment_id)
            oprot.writeFieldEnd()
        if self.used_ports is not None:
            oprot.writeFieldBegin('used_ports', TType.LIST, 4)
            oprot.writeListBegin(TType.I64, len(self.used_ports))
            for iter627 in self.used_ports:
                oprot.writeI64(iter627)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.meta is not None:
            oprot.writeFieldBegin('meta', TType.LIST, 5)
            oprot.writeListBegin(TType.I64, len(self.meta))
            for iter628 in self.meta:
                oprot.writeI64(iter628)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.scheduler_meta is not None:
            oprot.writeFieldBegin('scheduler_meta', TType.MAP, 6)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.scheduler_meta))
            for kiter629, viter630 in self.scheduler_meta.items():
                oprot.writeString(kiter629.encode('utf-8') if sys.version_info[0] == 2 else kiter629)
                oprot.writeString(viter630.encode('utf-8') if sys.version_info[0] == 2 else viter630)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.uptime_secs is not None:
            oprot.writeFieldBegin('uptime_secs', TType.I64, 7)
            oprot.writeI64(self.uptime_secs)
            oprot.writeFieldEnd()
        if self.version is not None:
            oprot.writeFieldBegin('version', TType.STRING, 8)
            oprot.writeString(self.version.encode('utf-8') if sys.version_info[0] == 2 else self.version)
            oprot.writeFieldEnd()
        if self.resources_map is not None:
            oprot.writeFieldBegin('resources_map', TType.MAP, 9)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.resources_map))
            for kiter631, viter632 in self.resources_map.items():
                oprot.writeString(kiter631.encode('utf-8') if sys.version_info[0] == 2 else kiter631)
                oprot.writeDouble(viter632)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.server_port is not None:
            oprot.writeFieldBegin('server_port', TType.I32, 10)
            oprot.writeI32(self.server_port)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.time_secs is None:
            raise TProtocolException(message='Required field time_secs is unset!')
        if self.hostname is None:
            raise TProtocolException(message='Required field hostname is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class NodeInfo(object):
    """
    Attributes:
     - node
     - port

    """


    def __init__(self, node=None, port=None,):
        self.node = node
        self.port = port

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.node = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.SET:
                    self.port = set()
                    (_etype636, _size633) = iprot.readSetBegin()
                    for _i637 in range(_size633):
                        _elem638 = iprot.readI64()
                        self.port.add(_elem638)
                    iprot.readSetEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('NodeInfo')
        if self.node is not None:
            oprot.writeFieldBegin('node', TType.STRING, 1)
            oprot.writeString(self.node.encode('utf-8') if sys.version_info[0] == 2 else self.node)
            oprot.writeFieldEnd()
        if self.port is not None:
            oprot.writeFieldBegin('port', TType.SET, 2)
            oprot.writeSetBegin(TType.I64, len(self.port))
            for iter639 in self.port:
                oprot.writeI64(iter639)
            oprot.writeSetEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.node is None:
            raise TProtocolException(message='Required field node is unset!')
        if self.port is None:
            raise TProtocolException(message='Required field port is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class WorkerResources(object):
    """
    Attributes:
     - mem_on_heap
     - mem_off_heap
     - cpu
     - shared_mem_on_heap
     - shared_mem_off_heap
     - resources
     - shared_resources

    """


    def __init__(self, mem_on_heap=None, mem_off_heap=None, cpu=None, shared_mem_on_heap=None, shared_mem_off_heap=None, resources=None, shared_resources=None,):
        self.mem_on_heap = mem_on_heap
        self.mem_off_heap = mem_off_heap
        self.cpu = cpu
        self.shared_mem_on_heap = shared_mem_on_heap
        self.shared_mem_off_heap = shared_mem_off_heap
        self.resources = resources
        self.shared_resources = shared_resources

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.DOUBLE:
                    self.mem_on_heap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.DOUBLE:
                    self.mem_off_heap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.DOUBLE:
                    self.cpu = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.DOUBLE:
                    self.shared_mem_on_heap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.DOUBLE:
                    self.shared_mem_off_heap = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.MAP:
                    self.resources = {}
                    (_ktype641, _vtype642, _size640) = iprot.readMapBegin()
                    for _i644 in range(_size640):
                        _key645 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val646 = iprot.readDouble()
                        self.resources[_key645] = _val646
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.MAP:
                    self.shared_resources = {}
                    (_ktype648, _vtype649, _size647) = iprot.readMapBegin()
                    for _i651 in range(_size647):
                        _key652 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val653 = iprot.readDouble()
                        self.shared_resources[_key652] = _val653
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('WorkerResources')
        if self.mem_on_heap is not None:
            oprot.writeFieldBegin('mem_on_heap', TType.DOUBLE, 1)
            oprot.writeDouble(self.mem_on_heap)
            oprot.writeFieldEnd()
        if self.mem_off_heap is not None:
            oprot.writeFieldBegin('mem_off_heap', TType.DOUBLE, 2)
            oprot.writeDouble(self.mem_off_heap)
            oprot.writeFieldEnd()
        if self.cpu is not None:
            oprot.writeFieldBegin('cpu', TType.DOUBLE, 3)
            oprot.writeDouble(self.cpu)
            oprot.writeFieldEnd()
        if self.shared_mem_on_heap is not None:
            oprot.writeFieldBegin('shared_mem_on_heap', TType.DOUBLE, 4)
            oprot.writeDouble(self.shared_mem_on_heap)
            oprot.writeFieldEnd()
        if self.shared_mem_off_heap is not None:
            oprot.writeFieldBegin('shared_mem_off_heap', TType.DOUBLE, 5)
            oprot.writeDouble(self.shared_mem_off_heap)
            oprot.writeFieldEnd()
        if self.resources is not None:
            oprot.writeFieldBegin('resources', TType.MAP, 6)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.resources))
            for kiter654, viter655 in self.resources.items():
                oprot.writeString(kiter654.encode('utf-8') if sys.version_info[0] == 2 else kiter654)
                oprot.writeDouble(viter655)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.shared_resources is not None:
            oprot.writeFieldBegin('shared_resources', TType.MAP, 7)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.shared_resources))
            for kiter656, viter657 in self.shared_resources.items():
                oprot.writeString(kiter656.encode('utf-8') if sys.version_info[0] == 2 else kiter656)
                oprot.writeDouble(viter657)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class Assignment(object):
    """
    Attributes:
     - master_code_dir
     - node_host
     - executor_node_port
     - executor_start_time_secs
     - worker_resources
     - total_shared_off_heap
     - owner

    """


    def __init__(self, master_code_dir=None, node_host={
    }, executor_node_port={
    }, executor_start_time_secs={
    }, worker_resources={
    }, total_shared_off_heap={
    }, owner=None,):
        self.master_code_dir = master_code_dir
        if node_host is self.thrift_spec[2][4]:
            node_host = {
            }
        self.node_host = node_host
        if executor_node_port is self.thrift_spec[3][4]:
            executor_node_port = {
            }
        self.executor_node_port = executor_node_port
        if executor_start_time_secs is self.thrift_spec[4][4]:
            executor_start_time_secs = {
            }
        self.executor_start_time_secs = executor_start_time_secs
        if worker_resources is self.thrift_spec[5][4]:
            worker_resources = {
            }
        self.worker_resources = worker_resources
        if total_shared_off_heap is self.thrift_spec[6][4]:
            total_shared_off_heap = {
            }
        self.total_shared_off_heap = total_shared_off_heap
        self.owner = owner

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.master_code_dir = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.MAP:
                    self.node_host = {}
                    (_ktype659, _vtype660, _size658) = iprot.readMapBegin()
                    for _i662 in range(_size658):
                        _key663 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val664 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.node_host[_key663] = _val664
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.MAP:
                    self.executor_node_port = {}
                    (_ktype666, _vtype667, _size665) = iprot.readMapBegin()
                    for _i669 in range(_size665):
                        _key670 = []
                        (_etype675, _size672) = iprot.readListBegin()
                        for _i676 in range(_size672):
                            _elem677 = iprot.readI64()
                            _key670.append(_elem677)
                        iprot.readListEnd()
                        _val671 = NodeInfo()
                        _val671.read(iprot)
                        self.executor_node_port[_key670] = _val671
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.executor_start_time_secs = {}
                    (_ktype679, _vtype680, _size678) = iprot.readMapBegin()
                    for _i682 in range(_size678):
                        _key683 = []
                        (_etype688, _size685) = iprot.readListBegin()
                        for _i689 in range(_size685):
                            _elem690 = iprot.readI64()
                            _key683.append(_elem690)
                        iprot.readListEnd()
                        _val684 = iprot.readI64()
                        self.executor_start_time_secs[_key683] = _val684
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.MAP:
                    self.worker_resources = {}
                    (_ktype692, _vtype693, _size691) = iprot.readMapBegin()
                    for _i695 in range(_size691):
                        _key696 = NodeInfo()
                        _key696.read(iprot)
                        _val697 = WorkerResources()
                        _val697.read(iprot)
                        self.worker_resources[_key696] = _val697
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.MAP:
                    self.total_shared_off_heap = {}
                    (_ktype699, _vtype700, _size698) = iprot.readMapBegin()
                    for _i702 in range(_size698):
                        _key703 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val704 = iprot.readDouble()
                        self.total_shared_off_heap[_key703] = _val704
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.STRING:
                    self.owner = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Assignment')
        if self.master_code_dir is not None:
            oprot.writeFieldBegin('master_code_dir', TType.STRING, 1)
            oprot.writeString(self.master_code_dir.encode('utf-8') if sys.version_info[0] == 2 else self.master_code_dir)
            oprot.writeFieldEnd()
        if self.node_host is not None:
            oprot.writeFieldBegin('node_host', TType.MAP, 2)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.node_host))
            for kiter705, viter706 in self.node_host.items():
                oprot.writeString(kiter705.encode('utf-8') if sys.version_info[0] == 2 else kiter705)
                oprot.writeString(viter706.encode('utf-8') if sys.version_info[0] == 2 else viter706)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.executor_node_port is not None:
            oprot.writeFieldBegin('executor_node_port', TType.MAP, 3)
            oprot.writeMapBegin(TType.LIST, TType.STRUCT, len(self.executor_node_port))
            for kiter707, viter708 in self.executor_node_port.items():
                oprot.writeListBegin(TType.I64, len(kiter707))
                for iter709 in kiter707:
                    oprot.writeI64(iter709)
                oprot.writeListEnd()
                viter708.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.executor_start_time_secs is not None:
            oprot.writeFieldBegin('executor_start_time_secs', TType.MAP, 4)
            oprot.writeMapBegin(TType.LIST, TType.I64, len(self.executor_start_time_secs))
            for kiter710, viter711 in self.executor_start_time_secs.items():
                oprot.writeListBegin(TType.I64, len(kiter710))
                for iter712 in kiter710:
                    oprot.writeI64(iter712)
                oprot.writeListEnd()
                oprot.writeI64(viter711)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.worker_resources is not None:
            oprot.writeFieldBegin('worker_resources', TType.MAP, 5)
            oprot.writeMapBegin(TType.STRUCT, TType.STRUCT, len(self.worker_resources))
            for kiter713, viter714 in self.worker_resources.items():
                kiter713.write(oprot)
                viter714.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.total_shared_off_heap is not None:
            oprot.writeFieldBegin('total_shared_off_heap', TType.MAP, 6)
            oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.total_shared_off_heap))
            for kiter715, viter716 in self.total_shared_off_heap.items():
                oprot.writeString(kiter715.encode('utf-8') if sys.version_info[0] == 2 else kiter715)
                oprot.writeDouble(viter716)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.owner is not None:
            oprot.writeFieldBegin('owner', TType.STRING, 7)
            oprot.writeString(self.owner.encode('utf-8') if sys.version_info[0] == 2 else self.owner)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.master_code_dir is None:
            raise TProtocolException(message='Required field master_code_dir is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class TopologyActionOptions(object):
    """
    Attributes:
     - kill_options
     - rebalance_options

    """


    def __init__(self, kill_options=None, rebalance_options=None,):
        self.kill_options = kill_options
        self.rebalance_options = rebalance_options

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.kill_options = KillOptions()
                    self.kill_options.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.rebalance_options = RebalanceOptions()
                    self.rebalance_options.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('TopologyActionOptions')
        if self.kill_options is not None:
            oprot.writeFieldBegin('kill_options', TType.STRUCT, 1)
            self.kill_options.write(oprot)
            oprot.writeFieldEnd()
        if self.rebalance_options is not None:
            oprot.writeFieldBegin('rebalance_options', TType.STRUCT, 2)
            self.rebalance_options.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class StormBase(object):
    """
    Attributes:
     - name
     - status
     - num_workers
     - component_executors
     - launch_time_secs
     - owner
     - topology_action_options
     - prev_status
     - component_debug
     - principal
     - topology_version

    """


    def __init__(self, name=None, status=None, num_workers=None, component_executors=None, launch_time_secs=None, owner=None, topology_action_options=None, prev_status=None, component_debug=None, principal=None, topology_version=None,):
        self.name = name
        self.status = status
        self.num_workers = num_workers
        self.component_executors = component_executors
        self.launch_time_secs = launch_time_secs
        self.owner = owner
        self.topology_action_options = topology_action_options
        self.prev_status = prev_status
        self.component_debug = component_debug
        self.principal = principal
        self.topology_version = topology_version

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.status = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.num_workers = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.component_executors = {}
                    (_ktype718, _vtype719, _size717) = iprot.readMapBegin()
                    for _i721 in range(_size717):
                        _key722 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val723 = iprot.readI32()
                        self.component_executors[_key722] = _val723
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.I32:
                    self.launch_time_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.STRING:
                    self.owner = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.STRUCT:
                    self.topology_action_options = TopologyActionOptions()
                    self.topology_action_options.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.I32:
                    self.prev_status = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 9:
                if ftype == TType.MAP:
                    self.component_debug = {}
                    (_ktype725, _vtype726, _size724) = iprot.readMapBegin()
                    for _i728 in range(_size724):
                        _key729 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val730 = DebugOptions()
                        _val730.read(iprot)
                        self.component_debug[_key729] = _val730
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 10:
                if ftype == TType.STRING:
                    self.principal = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 11:
                if ftype == TType.STRING:
                    self.topology_version = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('StormBase')
        if self.name is not None:
            oprot.writeFieldBegin('name', TType.STRING, 1)
            oprot.writeString(self.name.encode('utf-8') if sys.version_info[0] == 2 else self.name)
            oprot.writeFieldEnd()
        if self.status is not None:
            oprot.writeFieldBegin('status', TType.I32, 2)
            oprot.writeI32(self.status)
            oprot.writeFieldEnd()
        if self.num_workers is not None:
            oprot.writeFieldBegin('num_workers', TType.I32, 3)
            oprot.writeI32(self.num_workers)
            oprot.writeFieldEnd()
        if self.component_executors is not None:
            oprot.writeFieldBegin('component_executors', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.I32, len(self.component_executors))
            for kiter731, viter732 in self.component_executors.items():
                oprot.writeString(kiter731.encode('utf-8') if sys.version_info[0] == 2 else kiter731)
                oprot.writeI32(viter732)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.launch_time_secs is not None:
            oprot.writeFieldBegin('launch_time_secs', TType.I32, 5)
            oprot.writeI32(self.launch_time_secs)
            oprot.writeFieldEnd()
        if self.owner is not None:
            oprot.writeFieldBegin('owner', TType.STRING, 6)
            oprot.writeString(self.owner.encode('utf-8') if sys.version_info[0] == 2 else self.owner)
            oprot.writeFieldEnd()
        if self.topology_action_options is not None:
            oprot.writeFieldBegin('topology_action_options', TType.STRUCT, 7)
            self.topology_action_options.write(oprot)
            oprot.writeFieldEnd()
        if self.prev_status is not None:
            oprot.writeFieldBegin('prev_status', TType.I32, 8)
            oprot.writeI32(self.prev_status)
            oprot.writeFieldEnd()
        if self.component_debug is not None:
            oprot.writeFieldBegin('component_debug', TType.MAP, 9)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.component_debug))
            for kiter733, viter734 in self.component_debug.items():
                oprot.writeString(kiter733.encode('utf-8') if sys.version_info[0] == 2 else kiter733)
                viter734.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.principal is not None:
            oprot.writeFieldBegin('principal', TType.STRING, 10)
            oprot.writeString(self.principal.encode('utf-8') if sys.version_info[0] == 2 else self.principal)
            oprot.writeFieldEnd()
        if self.topology_version is not None:
            oprot.writeFieldBegin('topology_version', TType.STRING, 11)
            oprot.writeString(self.topology_version.encode('utf-8') if sys.version_info[0] == 2 else self.topology_version)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.name is None:
            raise TProtocolException(message='Required field name is unset!')
        if self.status is None:
            raise TProtocolException(message='Required field status is unset!')
        if self.num_workers is None:
            raise TProtocolException(message='Required field num_workers is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ClusterWorkerHeartbeat(object):
    """
    Attributes:
     - storm_id
     - executor_stats
     - time_secs
     - uptime_secs

    """


    def __init__(self, storm_id=None, executor_stats=None, time_secs=None, uptime_secs=None,):
        self.storm_id = storm_id
        self.executor_stats = executor_stats
        self.time_secs = time_secs
        self.uptime_secs = uptime_secs

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.storm_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.MAP:
                    self.executor_stats = {}
                    (_ktype736, _vtype737, _size735) = iprot.readMapBegin()
                    for _i739 in range(_size735):
                        _key740 = ExecutorInfo()
                        _key740.read(iprot)
                        _val741 = ExecutorStats()
                        _val741.read(iprot)
                        self.executor_stats[_key740] = _val741
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.time_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I32:
                    self.uptime_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ClusterWorkerHeartbeat')
        if self.storm_id is not None:
            oprot.writeFieldBegin('storm_id', TType.STRING, 1)
            oprot.writeString(self.storm_id.encode('utf-8') if sys.version_info[0] == 2 else self.storm_id)
            oprot.writeFieldEnd()
        if self.executor_stats is not None:
            oprot.writeFieldBegin('executor_stats', TType.MAP, 2)
            oprot.writeMapBegin(TType.STRUCT, TType.STRUCT, len(self.executor_stats))
            for kiter742, viter743 in self.executor_stats.items():
                kiter742.write(oprot)
                viter743.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.time_secs is not None:
            oprot.writeFieldBegin('time_secs', TType.I32, 3)
            oprot.writeI32(self.time_secs)
            oprot.writeFieldEnd()
        if self.uptime_secs is not None:
            oprot.writeFieldBegin('uptime_secs', TType.I32, 4)
            oprot.writeI32(self.uptime_secs)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.storm_id is None:
            raise TProtocolException(message='Required field storm_id is unset!')
        if self.executor_stats is None:
            raise TProtocolException(message='Required field executor_stats is unset!')
        if self.time_secs is None:
            raise TProtocolException(message='Required field time_secs is unset!')
        if self.uptime_secs is None:
            raise TProtocolException(message='Required field uptime_secs is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ThriftSerializedObject(object):
    """
    Attributes:
     - name
     - bits

    """


    def __init__(self, name=None, bits=None,):
        self.name = name
        self.bits = bits

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.bits = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ThriftSerializedObject')
        if self.name is not None:
            oprot.writeFieldBegin('name', TType.STRING, 1)
            oprot.writeString(self.name.encode('utf-8') if sys.version_info[0] == 2 else self.name)
            oprot.writeFieldEnd()
        if self.bits is not None:
            oprot.writeFieldBegin('bits', TType.STRING, 2)
            oprot.writeBinary(self.bits)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.name is None:
            raise TProtocolException(message='Required field name is unset!')
        if self.bits is None:
            raise TProtocolException(message='Required field bits is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class LocalStateData(object):
    """
    Attributes:
     - serialized_parts

    """


    def __init__(self, serialized_parts=None,):
        self.serialized_parts = serialized_parts

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.serialized_parts = {}
                    (_ktype745, _vtype746, _size744) = iprot.readMapBegin()
                    for _i748 in range(_size744):
                        _key749 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val750 = ThriftSerializedObject()
                        _val750.read(iprot)
                        self.serialized_parts[_key749] = _val750
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('LocalStateData')
        if self.serialized_parts is not None:
            oprot.writeFieldBegin('serialized_parts', TType.MAP, 1)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.serialized_parts))
            for kiter751, viter752 in self.serialized_parts.items():
                oprot.writeString(kiter751.encode('utf-8') if sys.version_info[0] == 2 else kiter751)
                viter752.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.serialized_parts is None:
            raise TProtocolException(message='Required field serialized_parts is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class LocalAssignment(object):
    """
    Attributes:
     - topology_id
     - executors
     - resources
     - total_node_shared
     - owner

    """


    def __init__(self, topology_id=None, executors=None, resources=None, total_node_shared=None, owner=None,):
        self.topology_id = topology_id
        self.executors = executors
        self.resources = resources
        self.total_node_shared = total_node_shared
        self.owner = owner

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.topology_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.executors = []
                    (_etype756, _size753) = iprot.readListBegin()
                    for _i757 in range(_size753):
                        _elem758 = ExecutorInfo()
                        _elem758.read(iprot)
                        self.executors.append(_elem758)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRUCT:
                    self.resources = WorkerResources()
                    self.resources.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.DOUBLE:
                    self.total_node_shared = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.owner = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('LocalAssignment')
        if self.topology_id is not None:
            oprot.writeFieldBegin('topology_id', TType.STRING, 1)
            oprot.writeString(self.topology_id.encode('utf-8') if sys.version_info[0] == 2 else self.topology_id)
            oprot.writeFieldEnd()
        if self.executors is not None:
            oprot.writeFieldBegin('executors', TType.LIST, 2)
            oprot.writeListBegin(TType.STRUCT, len(self.executors))
            for iter759 in self.executors:
                iter759.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.resources is not None:
            oprot.writeFieldBegin('resources', TType.STRUCT, 3)
            self.resources.write(oprot)
            oprot.writeFieldEnd()
        if self.total_node_shared is not None:
            oprot.writeFieldBegin('total_node_shared', TType.DOUBLE, 4)
            oprot.writeDouble(self.total_node_shared)
            oprot.writeFieldEnd()
        if self.owner is not None:
            oprot.writeFieldBegin('owner', TType.STRING, 5)
            oprot.writeString(self.owner.encode('utf-8') if sys.version_info[0] == 2 else self.owner)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.topology_id is None:
            raise TProtocolException(message='Required field topology_id is unset!')
        if self.executors is None:
            raise TProtocolException(message='Required field executors is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class LSSupervisorId(object):
    """
    Attributes:
     - supervisor_id

    """


    def __init__(self, supervisor_id=None,):
        self.supervisor_id = supervisor_id

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.supervisor_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('LSSupervisorId')
        if self.supervisor_id is not None:
            oprot.writeFieldBegin('supervisor_id', TType.STRING, 1)
            oprot.writeString(self.supervisor_id.encode('utf-8') if sys.version_info[0] == 2 else self.supervisor_id)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.supervisor_id is None:
            raise TProtocolException(message='Required field supervisor_id is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class LSApprovedWorkers(object):
    """
    Attributes:
     - approved_workers

    """


    def __init__(self, approved_workers=None,):
        self.approved_workers = approved_workers

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.approved_workers = {}
                    (_ktype761, _vtype762, _size760) = iprot.readMapBegin()
                    for _i764 in range(_size760):
                        _key765 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val766 = iprot.readI32()
                        self.approved_workers[_key765] = _val766
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('LSApprovedWorkers')
        if self.approved_workers is not None:
            oprot.writeFieldBegin('approved_workers', TType.MAP, 1)
            oprot.writeMapBegin(TType.STRING, TType.I32, len(self.approved_workers))
            for kiter767, viter768 in self.approved_workers.items():
                oprot.writeString(kiter767.encode('utf-8') if sys.version_info[0] == 2 else kiter767)
                oprot.writeI32(viter768)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.approved_workers is None:
            raise TProtocolException(message='Required field approved_workers is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class LSSupervisorAssignments(object):
    """
    Attributes:
     - assignments

    """


    def __init__(self, assignments=None,):
        self.assignments = assignments

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.assignments = {}
                    (_ktype770, _vtype771, _size769) = iprot.readMapBegin()
                    for _i773 in range(_size769):
                        _key774 = iprot.readI32()
                        _val775 = LocalAssignment()
                        _val775.read(iprot)
                        self.assignments[_key774] = _val775
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('LSSupervisorAssignments')
        if self.assignments is not None:
            oprot.writeFieldBegin('assignments', TType.MAP, 1)
            oprot.writeMapBegin(TType.I32, TType.STRUCT, len(self.assignments))
            for kiter776, viter777 in self.assignments.items():
                oprot.writeI32(kiter776)
                viter777.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.assignments is None:
            raise TProtocolException(message='Required field assignments is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class LSWorkerHeartbeat(object):
    """
    Attributes:
     - time_secs
     - topology_id
     - executors
     - port

    """


    def __init__(self, time_secs=None, topology_id=None, executors=None, port=None,):
        self.time_secs = time_secs
        self.topology_id = topology_id
        self.executors = executors
        self.port = port

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.time_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.topology_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.executors = []
                    (_etype781, _size778) = iprot.readListBegin()
                    for _i782 in range(_size778):
                        _elem783 = ExecutorInfo()
                        _elem783.read(iprot)
                        self.executors.append(_elem783)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I32:
                    self.port = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('LSWorkerHeartbeat')
        if self.time_secs is not None:
            oprot.writeFieldBegin('time_secs', TType.I32, 1)
            oprot.writeI32(self.time_secs)
            oprot.writeFieldEnd()
        if self.topology_id is not None:
            oprot.writeFieldBegin('topology_id', TType.STRING, 2)
            oprot.writeString(self.topology_id.encode('utf-8') if sys.version_info[0] == 2 else self.topology_id)
            oprot.writeFieldEnd()
        if self.executors is not None:
            oprot.writeFieldBegin('executors', TType.LIST, 3)
            oprot.writeListBegin(TType.STRUCT, len(self.executors))
            for iter784 in self.executors:
                iter784.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.port is not None:
            oprot.writeFieldBegin('port', TType.I32, 4)
            oprot.writeI32(self.port)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.time_secs is None:
            raise TProtocolException(message='Required field time_secs is unset!')
        if self.topology_id is None:
            raise TProtocolException(message='Required field topology_id is unset!')
        if self.executors is None:
            raise TProtocolException(message='Required field executors is unset!')
        if self.port is None:
            raise TProtocolException(message='Required field port is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class LSTopoHistory(object):
    """
    Attributes:
     - topology_id
     - time_stamp
     - users
     - groups

    """


    def __init__(self, topology_id=None, time_stamp=None, users=None, groups=None,):
        self.topology_id = topology_id
        self.time_stamp = time_stamp
        self.users = users
        self.groups = groups

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.topology_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I64:
                    self.time_stamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.users = []
                    (_etype788, _size785) = iprot.readListBegin()
                    for _i789 in range(_size785):
                        _elem790 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.users.append(_elem790)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.LIST:
                    self.groups = []
                    (_etype794, _size791) = iprot.readListBegin()
                    for _i795 in range(_size791):
                        _elem796 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.groups.append(_elem796)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('LSTopoHistory')
        if self.topology_id is not None:
            oprot.writeFieldBegin('topology_id', TType.STRING, 1)
            oprot.writeString(self.topology_id.encode('utf-8') if sys.version_info[0] == 2 else self.topology_id)
            oprot.writeFieldEnd()
        if self.time_stamp is not None:
            oprot.writeFieldBegin('time_stamp', TType.I64, 2)
            oprot.writeI64(self.time_stamp)
            oprot.writeFieldEnd()
        if self.users is not None:
            oprot.writeFieldBegin('users', TType.LIST, 3)
            oprot.writeListBegin(TType.STRING, len(self.users))
            for iter797 in self.users:
                oprot.writeString(iter797.encode('utf-8') if sys.version_info[0] == 2 else iter797)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.groups is not None:
            oprot.writeFieldBegin('groups', TType.LIST, 4)
            oprot.writeListBegin(TType.STRING, len(self.groups))
            for iter798 in self.groups:
                oprot.writeString(iter798.encode('utf-8') if sys.version_info[0] == 2 else iter798)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.topology_id is None:
            raise TProtocolException(message='Required field topology_id is unset!')
        if self.time_stamp is None:
            raise TProtocolException(message='Required field time_stamp is unset!')
        if self.users is None:
            raise TProtocolException(message='Required field users is unset!')
        if self.groups is None:
            raise TProtocolException(message='Required field groups is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class LSTopoHistoryList(object):
    """
    Attributes:
     - topo_history

    """


    def __init__(self, topo_history=None,):
        self.topo_history = topo_history

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.topo_history = []
                    (_etype802, _size799) = iprot.readListBegin()
                    for _i803 in range(_size799):
                        _elem804 = LSTopoHistory()
                        _elem804.read(iprot)
                        self.topo_history.append(_elem804)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('LSTopoHistoryList')
        if self.topo_history is not None:
            oprot.writeFieldBegin('topo_history', TType.LIST, 1)
            oprot.writeListBegin(TType.STRUCT, len(self.topo_history))
            for iter805 in self.topo_history:
                iter805.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.topo_history is None:
            raise TProtocolException(message='Required field topo_history is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ProfileRequest(object):
    """
    Attributes:
     - nodeInfo
     - action
     - time_stamp

    """


    def __init__(self, nodeInfo=None, action=None, time_stamp=None,):
        self.nodeInfo = nodeInfo
        self.action = action
        self.time_stamp = time_stamp

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.nodeInfo = NodeInfo()
                    self.nodeInfo.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.action = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.time_stamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ProfileRequest')
        if self.nodeInfo is not None:
            oprot.writeFieldBegin('nodeInfo', TType.STRUCT, 1)
            self.nodeInfo.write(oprot)
            oprot.writeFieldEnd()
        if self.action is not None:
            oprot.writeFieldBegin('action', TType.I32, 2)
            oprot.writeI32(self.action)
            oprot.writeFieldEnd()
        if self.time_stamp is not None:
            oprot.writeFieldBegin('time_stamp', TType.I64, 3)
            oprot.writeI64(self.time_stamp)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.nodeInfo is None:
            raise TProtocolException(message='Required field nodeInfo is unset!')
        if self.action is None:
            raise TProtocolException(message='Required field action is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class GetInfoOptions(object):
    """
    Attributes:
     - num_err_choice

    """


    def __init__(self, num_err_choice=None,):
        self.num_err_choice = num_err_choice

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.num_err_choice = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('GetInfoOptions')
        if self.num_err_choice is not None:
            oprot.writeFieldBegin('num_err_choice', TType.I32, 1)
            oprot.writeI32(self.num_err_choice)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class LogLevel(object):
    """
    Attributes:
     - action
     - target_log_level
     - reset_log_level_timeout_secs
     - reset_log_level_timeout_epoch
     - reset_log_level

    """


    def __init__(self, action=None, target_log_level=None, reset_log_level_timeout_secs=None, reset_log_level_timeout_epoch=None, reset_log_level=None,):
        self.action = action
        self.target_log_level = target_log_level
        self.reset_log_level_timeout_secs = reset_log_level_timeout_secs
        self.reset_log_level_timeout_epoch = reset_log_level_timeout_epoch
        self.reset_log_level = reset_log_level

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.action = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.target_log_level = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.reset_log_level_timeout_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I64:
                    self.reset_log_level_timeout_epoch = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.reset_log_level = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('LogLevel')
        if self.action is not None:
            oprot.writeFieldBegin('action', TType.I32, 1)
            oprot.writeI32(self.action)
            oprot.writeFieldEnd()
        if self.target_log_level is not None:
            oprot.writeFieldBegin('target_log_level', TType.STRING, 2)
            oprot.writeString(self.target_log_level.encode('utf-8') if sys.version_info[0] == 2 else self.target_log_level)
            oprot.writeFieldEnd()
        if self.reset_log_level_timeout_secs is not None:
            oprot.writeFieldBegin('reset_log_level_timeout_secs', TType.I32, 3)
            oprot.writeI32(self.reset_log_level_timeout_secs)
            oprot.writeFieldEnd()
        if self.reset_log_level_timeout_epoch is not None:
            oprot.writeFieldBegin('reset_log_level_timeout_epoch', TType.I64, 4)
            oprot.writeI64(self.reset_log_level_timeout_epoch)
            oprot.writeFieldEnd()
        if self.reset_log_level is not None:
            oprot.writeFieldBegin('reset_log_level', TType.STRING, 5)
            oprot.writeString(self.reset_log_level.encode('utf-8') if sys.version_info[0] == 2 else self.reset_log_level)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.action is None:
            raise TProtocolException(message='Required field action is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class LogConfig(object):
    """
    Attributes:
     - named_logger_level

    """


    def __init__(self, named_logger_level=None,):
        self.named_logger_level = named_logger_level

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 2:
                if ftype == TType.MAP:
                    self.named_logger_level = {}
                    (_ktype807, _vtype808, _size806) = iprot.readMapBegin()
                    for _i810 in range(_size806):
                        _key811 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val812 = LogLevel()
                        _val812.read(iprot)
                        self.named_logger_level[_key811] = _val812
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('LogConfig')
        if self.named_logger_level is not None:
            oprot.writeFieldBegin('named_logger_level', TType.MAP, 2)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.named_logger_level))
            for kiter813, viter814 in self.named_logger_level.items():
                oprot.writeString(kiter813.encode('utf-8') if sys.version_info[0] == 2 else kiter813)
                viter814.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class TopologyHistoryInfo(object):
    """
    Attributes:
     - topo_ids

    """


    def __init__(self, topo_ids=None,):
        self.topo_ids = topo_ids

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.topo_ids = []
                    (_etype818, _size815) = iprot.readListBegin()
                    for _i819 in range(_size815):
                        _elem820 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.topo_ids.append(_elem820)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('TopologyHistoryInfo')
        if self.topo_ids is not None:
            oprot.writeFieldBegin('topo_ids', TType.LIST, 1)
            oprot.writeListBegin(TType.STRING, len(self.topo_ids))
            for iter821 in self.topo_ids:
                oprot.writeString(iter821.encode('utf-8') if sys.version_info[0] == 2 else iter821)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class OwnerResourceSummary(object):
    """
    Attributes:
     - owner
     - total_topologies
     - total_executors
     - total_workers
     - memory_usage
     - cpu_usage
     - memory_guarantee
     - cpu_guarantee
     - memory_guarantee_remaining
     - cpu_guarantee_remaining
     - isolated_node_guarantee
     - total_tasks
     - requested_on_heap_memory
     - requested_off_heap_memory
     - requested_total_memory
     - requested_cpu
     - assigned_on_heap_memory
     - assigned_off_heap_memory

    """


    def __init__(self, owner=None, total_topologies=None, total_executors=None, total_workers=None, memory_usage=None, cpu_usage=None, memory_guarantee=None, cpu_guarantee=None, memory_guarantee_remaining=None, cpu_guarantee_remaining=None, isolated_node_guarantee=None, total_tasks=None, requested_on_heap_memory=None, requested_off_heap_memory=None, requested_total_memory=None, requested_cpu=None, assigned_on_heap_memory=None, assigned_off_heap_memory=None,):
        self.owner = owner
        self.total_topologies = total_topologies
        self.total_executors = total_executors
        self.total_workers = total_workers
        self.memory_usage = memory_usage
        self.cpu_usage = cpu_usage
        self.memory_guarantee = memory_guarantee
        self.cpu_guarantee = cpu_guarantee
        self.memory_guarantee_remaining = memory_guarantee_remaining
        self.cpu_guarantee_remaining = cpu_guarantee_remaining
        self.isolated_node_guarantee = isolated_node_guarantee
        self.total_tasks = total_tasks
        self.requested_on_heap_memory = requested_on_heap_memory
        self.requested_off_heap_memory = requested_off_heap_memory
        self.requested_total_memory = requested_total_memory
        self.requested_cpu = requested_cpu
        self.assigned_on_heap_memory = assigned_on_heap_memory
        self.assigned_off_heap_memory = assigned_off_heap_memory

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.owner = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.total_topologies = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.total_executors = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I32:
                    self.total_workers = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.DOUBLE:
                    self.memory_usage = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.DOUBLE:
                    self.cpu_usage = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.DOUBLE:
                    self.memory_guarantee = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.DOUBLE:
                    self.cpu_guarantee = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 9:
                if ftype == TType.DOUBLE:
                    self.memory_guarantee_remaining = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 10:
                if ftype == TType.DOUBLE:
                    self.cpu_guarantee_remaining = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 11:
                if ftype == TType.I32:
                    self.isolated_node_guarantee = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 12:
                if ftype == TType.I32:
                    self.total_tasks = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 13:
                if ftype == TType.DOUBLE:
                    self.requested_on_heap_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 14:
                if ftype == TType.DOUBLE:
                    self.requested_off_heap_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 15:
                if ftype == TType.DOUBLE:
                    self.requested_total_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 16:
                if ftype == TType.DOUBLE:
                    self.requested_cpu = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 17:
                if ftype == TType.DOUBLE:
                    self.assigned_on_heap_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 18:
                if ftype == TType.DOUBLE:
                    self.assigned_off_heap_memory = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('OwnerResourceSummary')
        if self.owner is not None:
            oprot.writeFieldBegin('owner', TType.STRING, 1)
            oprot.writeString(self.owner.encode('utf-8') if sys.version_info[0] == 2 else self.owner)
            oprot.writeFieldEnd()
        if self.total_topologies is not None:
            oprot.writeFieldBegin('total_topologies', TType.I32, 2)
            oprot.writeI32(self.total_topologies)
            oprot.writeFieldEnd()
        if self.total_executors is not None:
            oprot.writeFieldBegin('total_executors', TType.I32, 3)
            oprot.writeI32(self.total_executors)
            oprot.writeFieldEnd()
        if self.total_workers is not None:
            oprot.writeFieldBegin('total_workers', TType.I32, 4)
            oprot.writeI32(self.total_workers)
            oprot.writeFieldEnd()
        if self.memory_usage is not None:
            oprot.writeFieldBegin('memory_usage', TType.DOUBLE, 5)
            oprot.writeDouble(self.memory_usage)
            oprot.writeFieldEnd()
        if self.cpu_usage is not None:
            oprot.writeFieldBegin('cpu_usage', TType.DOUBLE, 6)
            oprot.writeDouble(self.cpu_usage)
            oprot.writeFieldEnd()
        if self.memory_guarantee is not None:
            oprot.writeFieldBegin('memory_guarantee', TType.DOUBLE, 7)
            oprot.writeDouble(self.memory_guarantee)
            oprot.writeFieldEnd()
        if self.cpu_guarantee is not None:
            oprot.writeFieldBegin('cpu_guarantee', TType.DOUBLE, 8)
            oprot.writeDouble(self.cpu_guarantee)
            oprot.writeFieldEnd()
        if self.memory_guarantee_remaining is not None:
            oprot.writeFieldBegin('memory_guarantee_remaining', TType.DOUBLE, 9)
            oprot.writeDouble(self.memory_guarantee_remaining)
            oprot.writeFieldEnd()
        if self.cpu_guarantee_remaining is not None:
            oprot.writeFieldBegin('cpu_guarantee_remaining', TType.DOUBLE, 10)
            oprot.writeDouble(self.cpu_guarantee_remaining)
            oprot.writeFieldEnd()
        if self.isolated_node_guarantee is not None:
            oprot.writeFieldBegin('isolated_node_guarantee', TType.I32, 11)
            oprot.writeI32(self.isolated_node_guarantee)
            oprot.writeFieldEnd()
        if self.total_tasks is not None:
            oprot.writeFieldBegin('total_tasks', TType.I32, 12)
            oprot.writeI32(self.total_tasks)
            oprot.writeFieldEnd()
        if self.requested_on_heap_memory is not None:
            oprot.writeFieldBegin('requested_on_heap_memory', TType.DOUBLE, 13)
            oprot.writeDouble(self.requested_on_heap_memory)
            oprot.writeFieldEnd()
        if self.requested_off_heap_memory is not None:
            oprot.writeFieldBegin('requested_off_heap_memory', TType.DOUBLE, 14)
            oprot.writeDouble(self.requested_off_heap_memory)
            oprot.writeFieldEnd()
        if self.requested_total_memory is not None:
            oprot.writeFieldBegin('requested_total_memory', TType.DOUBLE, 15)
            oprot.writeDouble(self.requested_total_memory)
            oprot.writeFieldEnd()
        if self.requested_cpu is not None:
            oprot.writeFieldBegin('requested_cpu', TType.DOUBLE, 16)
            oprot.writeDouble(self.requested_cpu)
            oprot.writeFieldEnd()
        if self.assigned_on_heap_memory is not None:
            oprot.writeFieldBegin('assigned_on_heap_memory', TType.DOUBLE, 17)
            oprot.writeDouble(self.assigned_on_heap_memory)
            oprot.writeFieldEnd()
        if self.assigned_off_heap_memory is not None:
            oprot.writeFieldBegin('assigned_off_heap_memory', TType.DOUBLE, 18)
            oprot.writeDouble(self.assigned_off_heap_memory)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.owner is None:
            raise TProtocolException(message='Required field owner is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SupervisorWorkerHeartbeat(object):
    """
    Attributes:
     - storm_id
     - executors
     - time_secs

    """


    def __init__(self, storm_id=None, executors=None, time_secs=None,):
        self.storm_id = storm_id
        self.executors = executors
        self.time_secs = time_secs

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.storm_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.executors = []
                    (_etype825, _size822) = iprot.readListBegin()
                    for _i826 in range(_size822):
                        _elem827 = ExecutorInfo()
                        _elem827.read(iprot)
                        self.executors.append(_elem827)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.time_secs = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SupervisorWorkerHeartbeat')
        if self.storm_id is not None:
            oprot.writeFieldBegin('storm_id', TType.STRING, 1)
            oprot.writeString(self.storm_id.encode('utf-8') if sys.version_info[0] == 2 else self.storm_id)
            oprot.writeFieldEnd()
        if self.executors is not None:
            oprot.writeFieldBegin('executors', TType.LIST, 2)
            oprot.writeListBegin(TType.STRUCT, len(self.executors))
            for iter828 in self.executors:
                iter828.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.time_secs is not None:
            oprot.writeFieldBegin('time_secs', TType.I32, 3)
            oprot.writeI32(self.time_secs)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.storm_id is None:
            raise TProtocolException(message='Required field storm_id is unset!')
        if self.executors is None:
            raise TProtocolException(message='Required field executors is unset!')
        if self.time_secs is None:
            raise TProtocolException(message='Required field time_secs is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SupervisorWorkerHeartbeats(object):
    """
    Attributes:
     - supervisor_id
     - worker_heartbeats

    """


    def __init__(self, supervisor_id=None, worker_heartbeats=None,):
        self.supervisor_id = supervisor_id
        self.worker_heartbeats = worker_heartbeats

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.supervisor_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.worker_heartbeats = []
                    (_etype832, _size829) = iprot.readListBegin()
                    for _i833 in range(_size829):
                        _elem834 = SupervisorWorkerHeartbeat()
                        _elem834.read(iprot)
                        self.worker_heartbeats.append(_elem834)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SupervisorWorkerHeartbeats')
        if self.supervisor_id is not None:
            oprot.writeFieldBegin('supervisor_id', TType.STRING, 1)
            oprot.writeString(self.supervisor_id.encode('utf-8') if sys.version_info[0] == 2 else self.supervisor_id)
            oprot.writeFieldEnd()
        if self.worker_heartbeats is not None:
            oprot.writeFieldBegin('worker_heartbeats', TType.LIST, 2)
            oprot.writeListBegin(TType.STRUCT, len(self.worker_heartbeats))
            for iter835 in self.worker_heartbeats:
                iter835.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.supervisor_id is None:
            raise TProtocolException(message='Required field supervisor_id is unset!')
        if self.worker_heartbeats is None:
            raise TProtocolException(message='Required field worker_heartbeats is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SupervisorAssignments(object):
    """
    Attributes:
     - storm_assignment

    """


    def __init__(self, storm_assignment={
    },):
        if storm_assignment is self.thrift_spec[1][4]:
            storm_assignment = {
            }
        self.storm_assignment = storm_assignment

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.storm_assignment = {}
                    (_ktype837, _vtype838, _size836) = iprot.readMapBegin()
                    for _i840 in range(_size836):
                        _key841 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        _val842 = Assignment()
                        _val842.read(iprot)
                        self.storm_assignment[_key841] = _val842
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SupervisorAssignments')
        if self.storm_assignment is not None:
            oprot.writeFieldBegin('storm_assignment', TType.MAP, 1)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.storm_assignment))
            for kiter843, viter844 in self.storm_assignment.items():
                oprot.writeString(kiter843.encode('utf-8') if sys.version_info[0] == 2 else kiter843)
                viter844.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class WorkerMetricPoint(object):
    """
    Attributes:
     - metricName
     - timestamp
     - metricValue
     - componentId
     - executorId
     - streamId

    """


    def __init__(self, metricName=None, timestamp=None, metricValue=None, componentId=None, executorId=None, streamId=None,):
        self.metricName = metricName
        self.timestamp = timestamp
        self.metricValue = metricValue
        self.componentId = componentId
        self.executorId = executorId
        self.streamId = streamId

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.metricName = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I64:
                    self.timestamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.DOUBLE:
                    self.metricValue = iprot.readDouble()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.STRING:
                    self.componentId = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.executorId = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.STRING:
                    self.streamId = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('WorkerMetricPoint')
        if self.metricName is not None:
            oprot.writeFieldBegin('metricName', TType.STRING, 1)
            oprot.writeString(self.metricName.encode('utf-8') if sys.version_info[0] == 2 else self.metricName)
            oprot.writeFieldEnd()
        if self.timestamp is not None:
            oprot.writeFieldBegin('timestamp', TType.I64, 2)
            oprot.writeI64(self.timestamp)
            oprot.writeFieldEnd()
        if self.metricValue is not None:
            oprot.writeFieldBegin('metricValue', TType.DOUBLE, 3)
            oprot.writeDouble(self.metricValue)
            oprot.writeFieldEnd()
        if self.componentId is not None:
            oprot.writeFieldBegin('componentId', TType.STRING, 4)
            oprot.writeString(self.componentId.encode('utf-8') if sys.version_info[0] == 2 else self.componentId)
            oprot.writeFieldEnd()
        if self.executorId is not None:
            oprot.writeFieldBegin('executorId', TType.STRING, 5)
            oprot.writeString(self.executorId.encode('utf-8') if sys.version_info[0] == 2 else self.executorId)
            oprot.writeFieldEnd()
        if self.streamId is not None:
            oprot.writeFieldBegin('streamId', TType.STRING, 6)
            oprot.writeString(self.streamId.encode('utf-8') if sys.version_info[0] == 2 else self.streamId)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.metricName is None:
            raise TProtocolException(message='Required field metricName is unset!')
        if self.timestamp is None:
            raise TProtocolException(message='Required field timestamp is unset!')
        if self.metricValue is None:
            raise TProtocolException(message='Required field metricValue is unset!')
        if self.componentId is None:
            raise TProtocolException(message='Required field componentId is unset!')
        if self.executorId is None:
            raise TProtocolException(message='Required field executorId is unset!')
        if self.streamId is None:
            raise TProtocolException(message='Required field streamId is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class WorkerMetricList(object):
    """
    Attributes:
     - metrics

    """


    def __init__(self, metrics=None,):
        self.metrics = metrics

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.metrics = []
                    (_etype848, _size845) = iprot.readListBegin()
                    for _i849 in range(_size845):
                        _elem850 = WorkerMetricPoint()
                        _elem850.read(iprot)
                        self.metrics.append(_elem850)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('WorkerMetricList')
        if self.metrics is not None:
            oprot.writeFieldBegin('metrics', TType.LIST, 1)
            oprot.writeListBegin(TType.STRUCT, len(self.metrics))
            for iter851 in self.metrics:
                iter851.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class WorkerMetrics(object):
    """
    Attributes:
     - topologyId
     - port
     - hostname
     - metricList

    """


    def __init__(self, topologyId=None, port=None, hostname=None, metricList=None,):
        self.topologyId = topologyId
        self.port = port
        self.hostname = hostname
        self.metricList = metricList

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.topologyId = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.port = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.hostname = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.STRUCT:
                    self.metricList = WorkerMetricList()
                    self.metricList.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('WorkerMetrics')
        if self.topologyId is not None:
            oprot.writeFieldBegin('topologyId', TType.STRING, 1)
            oprot.writeString(self.topologyId.encode('utf-8') if sys.version_info[0] == 2 else self.topologyId)
            oprot.writeFieldEnd()
        if self.port is not None:
            oprot.writeFieldBegin('port', TType.I32, 2)
            oprot.writeI32(self.port)
            oprot.writeFieldEnd()
        if self.hostname is not None:
            oprot.writeFieldBegin('hostname', TType.STRING, 3)
            oprot.writeString(self.hostname.encode('utf-8') if sys.version_info[0] == 2 else self.hostname)
            oprot.writeFieldEnd()
        if self.metricList is not None:
            oprot.writeFieldBegin('metricList', TType.STRUCT, 4)
            self.metricList.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.topologyId is None:
            raise TProtocolException(message='Required field topologyId is unset!')
        if self.port is None:
            raise TProtocolException(message='Required field port is unset!')
        if self.hostname is None:
            raise TProtocolException(message='Required field hostname is unset!')
        if self.metricList is None:
            raise TProtocolException(message='Required field metricList is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class DRPCRequest(object):
    """
    Attributes:
     - func_args
     - request_id

    """


    def __init__(self, func_args=None, request_id=None,):
        self.func_args = func_args
        self.request_id = request_id

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.func_args = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.request_id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('DRPCRequest')
        if self.func_args is not None:
            oprot.writeFieldBegin('func_args', TType.STRING, 1)
            oprot.writeString(self.func_args.encode('utf-8') if sys.version_info[0] == 2 else self.func_args)
            oprot.writeFieldEnd()
        if self.request_id is not None:
            oprot.writeFieldBegin('request_id', TType.STRING, 2)
            oprot.writeString(self.request_id.encode('utf-8') if sys.version_info[0] == 2 else self.request_id)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.func_args is None:
            raise TProtocolException(message='Required field func_args is unset!')
        if self.request_id is None:
            raise TProtocolException(message='Required field request_id is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class DRPCExecutionException(TException):
    """
    Attributes:
     - msg
     - type

    """


    def __init__(self, msg=None, type=None,):
        self.msg = msg
        self.type = type

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.msg = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.type = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('DRPCExecutionException')
        if self.msg is not None:
            oprot.writeFieldBegin('msg', TType.STRING, 1)
            oprot.writeString(self.msg.encode('utf-8') if sys.version_info[0] == 2 else self.msg)
            oprot.writeFieldEnd()
        if self.type is not None:
            oprot.writeFieldBegin('type', TType.I32, 2)
            oprot.writeI32(self.type)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.msg is None:
            raise TProtocolException(message='Required field msg is unset!')
        return

    def __str__(self):
        return repr(self)

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class HBPulse(object):
    """
    Attributes:
     - id
     - details

    """


    def __init__(self, id=None, details=None,):
        self.id = id
        self.details = details

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.id = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.details = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('HBPulse')
        if self.id is not None:
            oprot.writeFieldBegin('id', TType.STRING, 1)
            oprot.writeString(self.id.encode('utf-8') if sys.version_info[0] == 2 else self.id)
            oprot.writeFieldEnd()
        if self.details is not None:
            oprot.writeFieldBegin('details', TType.STRING, 2)
            oprot.writeBinary(self.details)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.id is None:
            raise TProtocolException(message='Required field id is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class HBRecords(object):
    """
    Attributes:
     - pulses

    """


    def __init__(self, pulses=None,):
        self.pulses = pulses

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.pulses = []
                    (_etype855, _size852) = iprot.readListBegin()
                    for _i856 in range(_size852):
                        _elem857 = HBPulse()
                        _elem857.read(iprot)
                        self.pulses.append(_elem857)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('HBRecords')
        if self.pulses is not None:
            oprot.writeFieldBegin('pulses', TType.LIST, 1)
            oprot.writeListBegin(TType.STRUCT, len(self.pulses))
            for iter858 in self.pulses:
                iter858.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class HBNodes(object):
    """
    Attributes:
     - pulseIds

    """


    def __init__(self, pulseIds=None,):
        self.pulseIds = pulseIds

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.pulseIds = []
                    (_etype862, _size859) = iprot.readListBegin()
                    for _i863 in range(_size859):
                        _elem864 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.pulseIds.append(_elem864)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('HBNodes')
        if self.pulseIds is not None:
            oprot.writeFieldBegin('pulseIds', TType.LIST, 1)
            oprot.writeListBegin(TType.STRING, len(self.pulseIds))
            for iter865 in self.pulseIds:
                oprot.writeString(iter865.encode('utf-8') if sys.version_info[0] == 2 else iter865)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class HBMessageData(object):
    """
    Attributes:
     - path
     - pulse
     - boolval
     - records
     - nodes
     - message_blob

    """


    def __init__(self, path=None, pulse=None, boolval=None, records=None, nodes=None, message_blob=None,):
        self.path = path
        self.pulse = pulse
        self.boolval = boolval
        self.records = records
        self.nodes = nodes
        self.message_blob = message_blob

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.path = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.pulse = HBPulse()
                    self.pulse.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.BOOL:
                    self.boolval = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.STRUCT:
                    self.records = HBRecords()
                    self.records.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRUCT:
                    self.nodes = HBNodes()
                    self.nodes.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.STRING:
                    self.message_blob = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('HBMessageData')
        if self.path is not None:
            oprot.writeFieldBegin('path', TType.STRING, 1)
            oprot.writeString(self.path.encode('utf-8') if sys.version_info[0] == 2 else self.path)
            oprot.writeFieldEnd()
        if self.pulse is not None:
            oprot.writeFieldBegin('pulse', TType.STRUCT, 2)
            self.pulse.write(oprot)
            oprot.writeFieldEnd()
        if self.boolval is not None:
            oprot.writeFieldBegin('boolval', TType.BOOL, 3)
            oprot.writeBool(self.boolval)
            oprot.writeFieldEnd()
        if self.records is not None:
            oprot.writeFieldBegin('records', TType.STRUCT, 4)
            self.records.write(oprot)
            oprot.writeFieldEnd()
        if self.nodes is not None:
            oprot.writeFieldBegin('nodes', TType.STRUCT, 5)
            self.nodes.write(oprot)
            oprot.writeFieldEnd()
        if self.message_blob is not None:
            oprot.writeFieldBegin('message_blob', TType.STRING, 7)
            oprot.writeBinary(self.message_blob)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class HBMessage(object):
    """
    Attributes:
     - type
     - data
     - message_id

    """


    def __init__(self, type=None, data=None, message_id=-1,):
        self.type = type
        self.data = data
        self.message_id = message_id

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.type = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.data = HBMessageData()
                    self.data.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.message_id = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('HBMessage')
        if self.type is not None:
            oprot.writeFieldBegin('type', TType.I32, 1)
            oprot.writeI32(self.type)
            oprot.writeFieldEnd()
        if self.data is not None:
            oprot.writeFieldBegin('data', TType.STRUCT, 2)
            self.data.write(oprot)
            oprot.writeFieldEnd()
        if self.message_id is not None:
            oprot.writeFieldBegin('message_id', TType.I32, 3)
            oprot.writeI32(self.message_id)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class HBAuthorizationException(TException):
    """
    Attributes:
     - msg

    """


    def __init__(self, msg=None,):
        self.msg = msg

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.msg = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('HBAuthorizationException')
        if self.msg is not None:
            oprot.writeFieldBegin('msg', TType.STRING, 1)
            oprot.writeString(self.msg.encode('utf-8') if sys.version_info[0] == 2 else self.msg)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.msg is None:
            raise TProtocolException(message='Required field msg is unset!')
        return

    def __str__(self):
        return repr(self)

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class HBExecutionException(TException):
    """
    Attributes:
     - msg

    """


    def __init__(self, msg=None,):
        self.msg = msg

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.msg = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('HBExecutionException')
        if self.msg is not None:
            oprot.writeFieldBegin('msg', TType.STRING, 1)
            oprot.writeString(self.msg.encode('utf-8') if sys.version_info[0] == 2 else self.msg)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.msg is None:
            raise TProtocolException(message='Required field msg is unset!')
        return

    def __str__(self):
        return repr(self)

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class WorkerTokenInfo(object):
    """
    Attributes:
     - userName
     - topologyId
     - secretVersion
     - expirationTimeMillis

    """


    def __init__(self, userName=None, topologyId=None, secretVersion=None, expirationTimeMillis=None,):
        self.userName = userName
        self.topologyId = topologyId
        self.secretVersion = secretVersion
        self.expirationTimeMillis = expirationTimeMillis

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.userName = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.topologyId = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.secretVersion = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I64:
                    self.expirationTimeMillis = iprot.readI64()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('WorkerTokenInfo')
        if self.userName is not None:
            oprot.writeFieldBegin('userName', TType.STRING, 1)
            oprot.writeString(self.userName.encode('utf-8') if sys.version_info[0] == 2 else self.userName)
            oprot.writeFieldEnd()
        if self.topologyId is not None:
            oprot.writeFieldBegin('topologyId', TType.STRING, 2)
            oprot.writeString(self.topologyId.encode('utf-8') if sys.version_info[0] == 2 else self.topologyId)
            oprot.writeFieldEnd()
        if self.secretVersion is not None:
            oprot.writeFieldBegin('secretVersion', TType.I64, 3)
            oprot.writeI64(self.secretVersion)
            oprot.writeFieldEnd()
        if self.expirationTimeMillis is not None:
            oprot.writeFieldBegin('expirationTimeMillis', TType.I64, 4)
            oprot.writeI64(self.expirationTimeMillis)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.userName is None:
            raise TProtocolException(message='Required field userName is unset!')
        if self.topologyId is None:
            raise TProtocolException(message='Required field topologyId is unset!')
        if self.secretVersion is None:
            raise TProtocolException(message='Required field secretVersion is unset!')
        if self.expirationTimeMillis is None:
            raise TProtocolException(message='Required field expirationTimeMillis is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class WorkerToken(object):
    """
    Attributes:
     - serviceType
     - info
     - signature

    """


    def __init__(self, serviceType=None, info=None, signature=None,):
        self.serviceType = serviceType
        self.info = info
        self.signature = signature

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.serviceType = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.info = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.signature = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('WorkerToken')
        if self.serviceType is not None:
            oprot.writeFieldBegin('serviceType', TType.I32, 1)
            oprot.writeI32(self.serviceType)
            oprot.writeFieldEnd()
        if self.info is not None:
            oprot.writeFieldBegin('info', TType.STRING, 2)
            oprot.writeBinary(self.info)
            oprot.writeFieldEnd()
        if self.signature is not None:
            oprot.writeFieldBegin('signature', TType.STRING, 3)
            oprot.writeBinary(self.signature)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.serviceType is None:
            raise TProtocolException(message='Required field serviceType is unset!')
        if self.info is None:
            raise TProtocolException(message='Required field info is unset!')
        if self.signature is None:
            raise TProtocolException(message='Required field signature is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class PrivateWorkerKey(object):
    """
    Attributes:
     - key
     - userName
     - expirationTimeMillis

    """


    def __init__(self, key=None, userName=None, expirationTimeMillis=None,):
        self.key = key
        self.userName = userName
        self.expirationTimeMillis = expirationTimeMillis

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.key = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.userName = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.expirationTimeMillis = iprot.readI64()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('PrivateWorkerKey')
        if self.key is not None:
            oprot.writeFieldBegin('key', TType.STRING, 1)
            oprot.writeBinary(self.key)
            oprot.writeFieldEnd()
        if self.userName is not None:
            oprot.writeFieldBegin('userName', TType.STRING, 2)
            oprot.writeString(self.userName.encode('utf-8') if sys.version_info[0] == 2 else self.userName)
            oprot.writeFieldEnd()
        if self.expirationTimeMillis is not None:
            oprot.writeFieldBegin('expirationTimeMillis', TType.I64, 3)
            oprot.writeI64(self.expirationTimeMillis)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.key is None:
            raise TProtocolException(message='Required field key is unset!')
        if self.userName is None:
            raise TProtocolException(message='Required field userName is unset!')
        if self.expirationTimeMillis is None:
            raise TProtocolException(message='Required field expirationTimeMillis is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(JavaObjectArg)
JavaObjectArg.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'int_arg', None, None, ),  # 1
    (2, TType.I64, 'long_arg', None, None, ),  # 2
    (3, TType.STRING, 'string_arg', 'UTF8', None, ),  # 3
    (4, TType.BOOL, 'bool_arg', None, None, ),  # 4
    (5, TType.STRING, 'binary_arg', 'BINARY', None, ),  # 5
    (6, TType.DOUBLE, 'double_arg', None, None, ),  # 6
)
all_structs.append(JavaObject)
JavaObject.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'full_class_name', 'UTF8', None, ),  # 1
    (2, TType.LIST, 'args_list', (TType.STRUCT, [JavaObjectArg, None], False), None, ),  # 2
)
all_structs.append(NullStruct)
NullStruct.thrift_spec = (
)
all_structs.append(GlobalStreamId)
GlobalStreamId.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'componentId', 'UTF8', None, ),  # 1
    (2, TType.STRING, 'streamId', 'UTF8', None, ),  # 2
)
all_structs.append(Grouping)
Grouping.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'fields', (TType.STRING, 'UTF8', False), None, ),  # 1
    (2, TType.STRUCT, 'shuffle', [NullStruct, None], None, ),  # 2
    (3, TType.STRUCT, 'all', [NullStruct, None], None, ),  # 3
    (4, TType.STRUCT, 'none', [NullStruct, None], None, ),  # 4
    (5, TType.STRUCT, 'direct', [NullStruct, None], None, ),  # 5
    (6, TType.STRUCT, 'custom_object', [JavaObject, None], None, ),  # 6
    (7, TType.STRING, 'custom_serialized', 'BINARY', None, ),  # 7
    (8, TType.STRUCT, 'local_or_shuffle', [NullStruct, None], None, ),  # 8
)
all_structs.append(StreamInfo)
StreamInfo.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'output_fields', (TType.STRING, 'UTF8', False), None, ),  # 1
    (2, TType.BOOL, 'direct', None, None, ),  # 2
)
all_structs.append(ShellComponent)
ShellComponent.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'execution_command', 'UTF8', None, ),  # 1
    (2, TType.STRING, 'script', 'UTF8', None, ),  # 2
)
all_structs.append(ComponentObject)
ComponentObject.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'serialized_java', 'BINARY', None, ),  # 1
    (2, TType.STRUCT, 'shell', [ShellComponent, None], None, ),  # 2
    (3, TType.STRUCT, 'java_object', [JavaObject, None], None, ),  # 3
)
all_structs.append(ComponentCommon)
ComponentCommon.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'inputs', (TType.STRUCT, [GlobalStreamId, None], TType.STRUCT, [Grouping, None], False), None, ),  # 1
    (2, TType.MAP, 'streams', (TType.STRING, 'UTF8', TType.STRUCT, [StreamInfo, None], False), None, ),  # 2
    (3, TType.I32, 'parallelism_hint', None, None, ),  # 3
    (4, TType.STRING, 'json_conf', 'UTF8', None, ),  # 4
)
all_structs.append(SpoutSpec)
SpoutSpec.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'spout_object', [ComponentObject, None], None, ),  # 1
    (2, TType.STRUCT, 'common', [ComponentCommon, None], None, ),  # 2
)
all_structs.append(Bolt)
Bolt.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'bolt_object', [ComponentObject, None], None, ),  # 1
    (2, TType.STRUCT, 'common', [ComponentCommon, None], None, ),  # 2
)
all_structs.append(StateSpoutSpec)
StateSpoutSpec.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'state_spout_object', [ComponentObject, None], None, ),  # 1
    (2, TType.STRUCT, 'common', [ComponentCommon, None], None, ),  # 2
)
all_structs.append(SharedMemory)
SharedMemory.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'name', 'UTF8', None, ),  # 1
    (2, TType.DOUBLE, 'on_heap', None, None, ),  # 2
    (3, TType.DOUBLE, 'off_heap_worker', None, None, ),  # 3
    (4, TType.DOUBLE, 'off_heap_node', None, None, ),  # 4
)
all_structs.append(StormTopology)
StormTopology.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'spouts', (TType.STRING, 'UTF8', TType.STRUCT, [SpoutSpec, None], False), None, ),  # 1
    (2, TType.MAP, 'bolts', (TType.STRING, 'UTF8', TType.STRUCT, [Bolt, None], False), None, ),  # 2
    (3, TType.MAP, 'state_spouts', (TType.STRING, 'UTF8', TType.STRUCT, [StateSpoutSpec, None], False), None, ),  # 3
    (4, TType.LIST, 'worker_hooks', (TType.STRING, 'BINARY', False), None, ),  # 4
    (5, TType.LIST, 'dependency_jars', (TType.STRING, 'UTF8', False), None, ),  # 5
    (6, TType.LIST, 'dependency_artifacts', (TType.STRING, 'UTF8', False), None, ),  # 6
    (7, TType.STRING, 'storm_version', 'UTF8', None, ),  # 7
    (8, TType.STRING, 'jdk_version', 'UTF8', None, ),  # 8
    (9, TType.MAP, 'component_to_shared_memory', (TType.STRING, 'UTF8', TType.SET, (TType.STRING, 'UTF8', False), False), None, ),  # 9
    (10, TType.MAP, 'shared_memory', (TType.STRING, 'UTF8', TType.STRUCT, [SharedMemory, None], False), None, ),  # 10
)
all_structs.append(AlreadyAliveException)
AlreadyAliveException.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'msg', 'UTF8', None, ),  # 1
)
all_structs.append(NotAliveException)
NotAliveException.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'msg', 'UTF8', None, ),  # 1
)
all_structs.append(AuthorizationException)
AuthorizationException.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'msg', 'UTF8', None, ),  # 1
)
all_structs.append(InvalidTopologyException)
InvalidTopologyException.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'msg', 'UTF8', None, ),  # 1
)
all_structs.append(KeyNotFoundException)
KeyNotFoundException.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'msg', 'UTF8', None, ),  # 1
)
all_structs.append(IllegalStateException)
IllegalStateException.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'msg', 'UTF8', None, ),  # 1
)
all_structs.append(KeyAlreadyExistsException)
KeyAlreadyExistsException.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'msg', 'UTF8', None, ),  # 1
)
all_structs.append(TopologySummary)
TopologySummary.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'id', 'UTF8', None, ),  # 1
    (2, TType.STRING, 'name', 'UTF8', None, ),  # 2
    (3, TType.I32, 'num_tasks', None, None, ),  # 3
    (4, TType.I32, 'num_executors', None, None, ),  # 4
    (5, TType.I32, 'num_workers', None, None, ),  # 5
    (6, TType.I32, 'uptime_secs', None, None, ),  # 6
    (7, TType.STRING, 'status', 'UTF8', None, ),  # 7
    (8, TType.STRING, 'storm_version', 'UTF8', None, ),  # 8
    (9, TType.STRING, 'topology_version', 'UTF8', None, ),  # 9
    None,  # 10
    None,  # 11
    None,  # 12
    None,  # 13
    None,  # 14
    None,  # 15
    None,  # 16
    None,  # 17
    None,  # 18
    None,  # 19
    None,  # 20
    None,  # 21
    None,  # 22
    None,  # 23
    None,  # 24
    None,  # 25
    None,  # 26
    None,  # 27
    None,  # 28
    None,  # 29
    None,  # 30
    None,  # 31
    None,  # 32
    None,  # 33
    None,  # 34
    None,  # 35
    None,  # 36
    None,  # 37
    None,  # 38
    None,  # 39
    None,  # 40
    None,  # 41
    None,  # 42
    None,  # 43
    None,  # 44
    None,  # 45
    None,  # 46
    None,  # 47
    None,  # 48
    None,  # 49
    None,  # 50
    None,  # 51
    None,  # 52
    None,  # 53
    None,  # 54
    None,  # 55
    None,  # 56
    None,  # 57
    None,  # 58
    None,  # 59
    None,  # 60
    None,  # 61
    None,  # 62
    None,  # 63
    None,  # 64
    None,  # 65
    None,  # 66
    None,  # 67
    None,  # 68
    None,  # 69
    None,  # 70
    None,  # 71
    None,  # 72
    None,  # 73
    None,  # 74
    None,  # 75
    None,  # 76
    None,  # 77
    None,  # 78
    None,  # 79
    None,  # 80
    None,  # 81
    None,  # 82
    None,  # 83
    None,  # 84
    None,  # 85
    None,  # 86
    None,  # 87
    None,  # 88
    None,  # 89
    None,  # 90
    None,  # 91
    None,  # 92
    None,  # 93
    None,  # 94
    None,  # 95
    None,  # 96
    None,  # 97
    None,  # 98
    None,  # 99
    None,  # 100
    None,  # 101
    None,  # 102
    None,  # 103
    None,  # 104
    None,  # 105
    None,  # 106
    None,  # 107
    None,  # 108
    None,  # 109
    None,  # 110
    None,  # 111
    None,  # 112
    None,  # 113
    None,  # 114
    None,  # 115
    None,  # 116
    None,  # 117
    None,  # 118
    None,  # 119
    None,  # 120
    None,  # 121
    None,  # 122
    None,  # 123
    None,  # 124
    None,  # 125
    None,  # 126
    None,  # 127
    None,  # 128
    None,  # 129
    None,  # 130
    None,  # 131
    None,  # 132
    None,  # 133
    None,  # 134
    None,  # 135
    None,  # 136
    None,  # 137
    None,  # 138
    None,  # 139
    None,  # 140
    None,  # 141
    None,  # 142
    None,  # 143
    None,  # 144
    None,  # 145
    None,  # 146
    None,  # 147
    None,  # 148
    None,  # 149
    None,  # 150
    None,  # 151
    None,  # 152
    None,  # 153
    None,  # 154
    None,  # 155
    None,  # 156
    None,  # 157
    None,  # 158
    None,  # 159
    None,  # 160
    None,  # 161
    None,  # 162
    None,  # 163
    None,  # 164
    None,  # 165
    None,  # 166
    None,  # 167
    None,  # 168
    None,  # 169
    None,  # 170
    None,  # 171
    None,  # 172
    None,  # 173
    None,  # 174
    None,  # 175
    None,  # 176
    None,  # 177
    None,  # 178
    None,  # 179
    None,  # 180
    None,  # 181
    None,  # 182
    None,  # 183
    None,  # 184
    None,  # 185
    None,  # 186
    None,  # 187
    None,  # 188
    None,  # 189
    None,  # 190
    None,  # 191
    None,  # 192
    None,  # 193
    None,  # 194
    None,  # 195
    None,  # 196
    None,  # 197
    None,  # 198
    None,  # 199
    None,  # 200
    None,  # 201
    None,  # 202
    None,  # 203
    None,  # 204
    None,  # 205
    None,  # 206
    None,  # 207
    None,  # 208
    None,  # 209
    None,  # 210
    None,  # 211
    None,  # 212
    None,  # 213
    None,  # 214
    None,  # 215
    None,  # 216
    None,  # 217
    None,  # 218
    None,  # 219
    None,  # 220
    None,  # 221
    None,  # 222
    None,  # 223
    None,  # 224
    None,  # 225
    None,  # 226
    None,  # 227
    None,  # 228
    None,  # 229
    None,  # 230
    None,  # 231
    None,  # 232
    None,  # 233
    None,  # 234
    None,  # 235
    None,  # 236
    None,  # 237
    None,  # 238
    None,  # 239
    None,  # 240
    None,  # 241
    None,  # 242
    None,  # 243
    None,  # 244
    None,  # 245
    None,  # 246
    None,  # 247
    None,  # 248
    None,  # 249
    None,  # 250
    None,  # 251
    None,  # 252
    None,  # 253
    None,  # 254
    None,  # 255
    None,  # 256
    None,  # 257
    None,  # 258
    None,  # 259
    None,  # 260
    None,  # 261
    None,  # 262
    None,  # 263
    None,  # 264
    None,  # 265
    None,  # 266
    None,  # 267
    None,  # 268
    None,  # 269
    None,  # 270
    None,  # 271
    None,  # 272
    None,  # 273
    None,  # 274
    None,  # 275
    None,  # 276
    None,  # 277
    None,  # 278
    None,  # 279
    None,  # 280
    None,  # 281
    None,  # 282
    None,  # 283
    None,  # 284
    None,  # 285
    None,  # 286
    None,  # 287
    None,  # 288
    None,  # 289
    None,  # 290
    None,  # 291
    None,  # 292
    None,  # 293
    None,  # 294
    None,  # 295
    None,  # 296
    None,  # 297
    None,  # 298
    None,  # 299
    None,  # 300
    None,  # 301
    None,  # 302
    None,  # 303
    None,  # 304
    None,  # 305
    None,  # 306
    None,  # 307
    None,  # 308
    None,  # 309
    None,  # 310
    None,  # 311
    None,  # 312
    None,  # 313
    None,  # 314
    None,  # 315
    None,  # 316
    None,  # 317
    None,  # 318
    None,  # 319
    None,  # 320
    None,  # 321
    None,  # 322
    None,  # 323
    None,  # 324
    None,  # 325
    None,  # 326
    None,  # 327
    None,  # 328
    None,  # 329
    None,  # 330
    None,  # 331
    None,  # 332
    None,  # 333
    None,  # 334
    None,  # 335
    None,  # 336
    None,  # 337
    None,  # 338
    None,  # 339
    None,  # 340
    None,  # 341
    None,  # 342
    None,  # 343
    None,  # 344
    None,  # 345
    None,  # 346
    None,  # 347
    None,  # 348
    None,  # 349
    None,  # 350
    None,  # 351
    None,  # 352
    None,  # 353
    None,  # 354
    None,  # 355
    None,  # 356
    None,  # 357
    None,  # 358
    None,  # 359
    None,  # 360
    None,  # 361
    None,  # 362
    None,  # 363
    None,  # 364
    None,  # 365
    None,  # 366
    None,  # 367
    None,  # 368
    None,  # 369
    None,  # 370
    None,  # 371
    None,  # 372
    None,  # 373
    None,  # 374
    None,  # 375
    None,  # 376
    None,  # 377
    None,  # 378
    None,  # 379
    None,  # 380
    None,  # 381
    None,  # 382
    None,  # 383
    None,  # 384
    None,  # 385
    None,  # 386
    None,  # 387
    None,  # 388
    None,  # 389
    None,  # 390
    None,  # 391
    None,  # 392
    None,  # 393
    None,  # 394
    None,  # 395
    None,  # 396
    None,  # 397
    None,  # 398
    None,  # 399
    None,  # 400
    None,  # 401
    None,  # 402
    None,  # 403
    None,  # 404
    None,  # 405
    None,  # 406
    None,  # 407
    None,  # 408
    None,  # 409
    None,  # 410
    None,  # 411
    None,  # 412
    None,  # 413
    None,  # 414
    None,  # 415
    None,  # 416
    None,  # 417
    None,  # 418
    None,  # 419
    None,  # 420
    None,  # 421
    None,  # 422
    None,  # 423
    None,  # 424
    None,  # 425
    None,  # 426
    None,  # 427
    None,  # 428
    None,  # 429
    None,  # 430
    None,  # 431
    None,  # 432
    None,  # 433
    None,  # 434
    None,  # 435
    None,  # 436
    None,  # 437
    None,  # 438
    None,  # 439
    None,  # 440
    None,  # 441
    None,  # 442
    None,  # 443
    None,  # 444
    None,  # 445
    None,  # 446
    None,  # 447
    None,  # 448
    None,  # 449
    None,  # 450
    None,  # 451
    None,  # 452
    None,  # 453
    None,  # 454
    None,  # 455
    None,  # 456
    None,  # 457
    None,  # 458
    None,  # 459
    None,  # 460
    None,  # 461
    None,  # 462
    None,  # 463
    None,  # 464
    None,  # 465
    None,  # 466
    None,  # 467
    None,  # 468
    None,  # 469
    None,  # 470
    None,  # 471
    None,  # 472
    None,  # 473
    None,  # 474
    None,  # 475
    None,  # 476
    None,  # 477
    None,  # 478
    None,  # 479
    None,  # 480
    None,  # 481
    None,  # 482
    None,  # 483
    None,  # 484
    None,  # 485
    None,  # 486
    None,  # 487
    None,  # 488
    None,  # 489
    None,  # 490
    None,  # 491
    None,  # 492
    None,  # 493
    None,  # 494
    None,  # 495
    None,  # 496
    None,  # 497
    None,  # 498
    None,  # 499
    None,  # 500
    None,  # 501
    None,  # 502
    None,  # 503
    None,  # 504
    None,  # 505
    None,  # 506
    None,  # 507
    None,  # 508
    None,  # 509
    None,  # 510
    None,  # 511
    None,  # 512
    (513, TType.STRING, 'sched_status', 'UTF8', None, ),  # 513
    (514, TType.STRING, 'owner', 'UTF8', None, ),  # 514
    (515, TType.I32, 'replication_count', None, None, ),  # 515
    None,  # 516
    None,  # 517
    None,  # 518
    None,  # 519
    None,  # 520
    (521, TType.DOUBLE, 'requested_memonheap', None, None, ),  # 521
    (522, TType.DOUBLE, 'requested_memoffheap', None, None, ),  # 522
    (523, TType.DOUBLE, 'requested_cpu', None, None, ),  # 523
    (524, TType.DOUBLE, 'assigned_memonheap', None, None, ),  # 524
    (525, TType.DOUBLE, 'assigned_memoffheap', None, None, ),  # 525
    (526, TType.DOUBLE, 'assigned_cpu', None, None, ),  # 526
    (527, TType.MAP, 'requested_generic_resources', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), None, ),  # 527
    (528, TType.MAP, 'assigned_generic_resources', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), None, ),  # 528
)
all_structs.append(SupervisorSummary)
SupervisorSummary.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'host', 'UTF8', None, ),  # 1
    (2, TType.I32, 'uptime_secs', None, None, ),  # 2
    (3, TType.I32, 'num_workers', None, None, ),  # 3
    (4, TType.I32, 'num_used_workers', None, None, ),  # 4
    (5, TType.STRING, 'supervisor_id', 'UTF8', None, ),  # 5
    (6, TType.STRING, 'version', 'UTF8', "VERSION_NOT_PROVIDED", ),  # 6
    (7, TType.MAP, 'total_resources', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), None, ),  # 7
    (8, TType.DOUBLE, 'used_mem', None, None, ),  # 8
    (9, TType.DOUBLE, 'used_cpu', None, None, ),  # 9
    (10, TType.DOUBLE, 'fragmented_mem', None, None, ),  # 10
    (11, TType.DOUBLE, 'fragmented_cpu', None, None, ),  # 11
    (12, TType.BOOL, 'blacklisted', None, None, ),  # 12
    (13, TType.MAP, 'used_generic_resources', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), None, ),  # 13
)
all_structs.append(NimbusSummary)
NimbusSummary.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'host', 'UTF8', None, ),  # 1
    (2, TType.I32, 'port', None, None, ),  # 2
    (3, TType.I32, 'uptime_secs', None, None, ),  # 3
    (4, TType.BOOL, 'isLeader', None, None, ),  # 4
    (5, TType.STRING, 'version', 'UTF8', None, ),  # 5
)
all_structs.append(ClusterSummary)
ClusterSummary.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'supervisors', (TType.STRUCT, [SupervisorSummary, None], False), None, ),  # 1
    None,  # 2
    (3, TType.LIST, 'topologies', (TType.STRUCT, [TopologySummary, None], False), None, ),  # 3
    (4, TType.LIST, 'nimbuses', (TType.STRUCT, [NimbusSummary, None], False), None, ),  # 4
)
all_structs.append(ErrorInfo)
ErrorInfo.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'error', 'UTF8', None, ),  # 1
    (2, TType.I32, 'error_time_secs', None, None, ),  # 2
    (3, TType.STRING, 'host', 'UTF8', None, ),  # 3
    (4, TType.I32, 'port', None, None, ),  # 4
)
all_structs.append(BoltStats)
BoltStats.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'acked', (TType.STRING, 'UTF8', TType.MAP, (TType.STRUCT, [GlobalStreamId, None], TType.I64, None, False), False), None, ),  # 1
    (2, TType.MAP, 'failed', (TType.STRING, 'UTF8', TType.MAP, (TType.STRUCT, [GlobalStreamId, None], TType.I64, None, False), False), None, ),  # 2
    (3, TType.MAP, 'process_ms_avg', (TType.STRING, 'UTF8', TType.MAP, (TType.STRUCT, [GlobalStreamId, None], TType.DOUBLE, None, False), False), None, ),  # 3
    (4, TType.MAP, 'executed', (TType.STRING, 'UTF8', TType.MAP, (TType.STRUCT, [GlobalStreamId, None], TType.I64, None, False), False), None, ),  # 4
    (5, TType.MAP, 'execute_ms_avg', (TType.STRING, 'UTF8', TType.MAP, (TType.STRUCT, [GlobalStreamId, None], TType.DOUBLE, None, False), False), None, ),  # 5
)
all_structs.append(SpoutStats)
SpoutStats.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'acked', (TType.STRING, 'UTF8', TType.MAP, (TType.STRING, 'UTF8', TType.I64, None, False), False), None, ),  # 1
    (2, TType.MAP, 'failed', (TType.STRING, 'UTF8', TType.MAP, (TType.STRING, 'UTF8', TType.I64, None, False), False), None, ),  # 2
    (3, TType.MAP, 'complete_ms_avg', (TType.STRING, 'UTF8', TType.MAP, (TType.STRING, 'UTF8', TType.DOUBLE, None, False), False), None, ),  # 3
)
all_structs.append(ExecutorSpecificStats)
ExecutorSpecificStats.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'bolt', [BoltStats, None], None, ),  # 1
    (2, TType.STRUCT, 'spout', [SpoutStats, None], None, ),  # 2
)
all_structs.append(ExecutorStats)
ExecutorStats.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'emitted', (TType.STRING, 'UTF8', TType.MAP, (TType.STRING, 'UTF8', TType.I64, None, False), False), None, ),  # 1
    (2, TType.MAP, 'transferred', (TType.STRING, 'UTF8', TType.MAP, (TType.STRING, 'UTF8', TType.I64, None, False), False), None, ),  # 2
    (3, TType.STRUCT, 'specific', [ExecutorSpecificStats, None], None, ),  # 3
    (4, TType.DOUBLE, 'rate', None, None, ),  # 4
)
all_structs.append(ExecutorInfo)
ExecutorInfo.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'task_start', None, None, ),  # 1
    (2, TType.I32, 'task_end', None, None, ),  # 2
)
all_structs.append(ExecutorSummary)
ExecutorSummary.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'executor_info', [ExecutorInfo, None], None, ),  # 1
    (2, TType.STRING, 'component_id', 'UTF8', None, ),  # 2
    (3, TType.STRING, 'host', 'UTF8', None, ),  # 3
    (4, TType.I32, 'port', None, None, ),  # 4
    (5, TType.I32, 'uptime_secs', None, None, ),  # 5
    None,  # 6
    (7, TType.STRUCT, 'stats', [ExecutorStats, None], None, ),  # 7
)
all_structs.append(DebugOptions)
DebugOptions.thrift_spec = (
    None,  # 0
    (1, TType.BOOL, 'enable', None, None, ),  # 1
    (2, TType.DOUBLE, 'samplingpct', None, None, ),  # 2
)
all_structs.append(TopologyInfo)
TopologyInfo.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'id', 'UTF8', None, ),  # 1
    (2, TType.STRING, 'name', 'UTF8', None, ),  # 2
    (3, TType.I32, 'uptime_secs', None, None, ),  # 3
    (4, TType.LIST, 'executors', (TType.STRUCT, [ExecutorSummary, None], False), None, ),  # 4
    (5, TType.STRING, 'status', 'UTF8', None, ),  # 5
    (6, TType.MAP, 'errors', (TType.STRING, 'UTF8', TType.LIST, (TType.STRUCT, [ErrorInfo, None], False), False), None, ),  # 6
    (7, TType.MAP, 'component_debug', (TType.STRING, 'UTF8', TType.STRUCT, [DebugOptions, None], False), None, ),  # 7
    (8, TType.STRING, 'storm_version', 'UTF8', None, ),  # 8
    None,  # 9
    None,  # 10
    None,  # 11
    None,  # 12
    None,  # 13
    None,  # 14
    None,  # 15
    None,  # 16
    None,  # 17
    None,  # 18
    None,  # 19
    None,  # 20
    None,  # 21
    None,  # 22
    None,  # 23
    None,  # 24
    None,  # 25
    None,  # 26
    None,  # 27
    None,  # 28
    None,  # 29
    None,  # 30
    None,  # 31
    None,  # 32
    None,  # 33
    None,  # 34
    None,  # 35
    None,  # 36
    None,  # 37
    None,  # 38
    None,  # 39
    None,  # 40
    None,  # 41
    None,  # 42
    None,  # 43
    None,  # 44
    None,  # 45
    None,  # 46
    None,  # 47
    None,  # 48
    None,  # 49
    None,  # 50
    None,  # 51
    None,  # 52
    None,  # 53
    None,  # 54
    None,  # 55
    None,  # 56
    None,  # 57
    None,  # 58
    None,  # 59
    None,  # 60
    None,  # 61
    None,  # 62
    None,  # 63
    None,  # 64
    None,  # 65
    None,  # 66
    None,  # 67
    None,  # 68
    None,  # 69
    None,  # 70
    None,  # 71
    None,  # 72
    None,  # 73
    None,  # 74
    None,  # 75
    None,  # 76
    None,  # 77
    None,  # 78
    None,  # 79
    None,  # 80
    None,  # 81
    None,  # 82
    None,  # 83
    None,  # 84
    None,  # 85
    None,  # 86
    None,  # 87
    None,  # 88
    None,  # 89
    None,  # 90
    None,  # 91
    None,  # 92
    None,  # 93
    None,  # 94
    None,  # 95
    None,  # 96
    None,  # 97
    None,  # 98
    None,  # 99
    None,  # 100
    None,  # 101
    None,  # 102
    None,  # 103
    None,  # 104
    None,  # 105
    None,  # 106
    None,  # 107
    None,  # 108
    None,  # 109
    None,  # 110
    None,  # 111
    None,  # 112
    None,  # 113
    None,  # 114
    None,  # 115
    None,  # 116
    None,  # 117
    None,  # 118
    None,  # 119
    None,  # 120
    None,  # 121
    None,  # 122
    None,  # 123
    None,  # 124
    None,  # 125
    None,  # 126
    None,  # 127
    None,  # 128
    None,  # 129
    None,  # 130
    None,  # 131
    None,  # 132
    None,  # 133
    None,  # 134
    None,  # 135
    None,  # 136
    None,  # 137
    None,  # 138
    None,  # 139
    None,  # 140
    None,  # 141
    None,  # 142
    None,  # 143
    None,  # 144
    None,  # 145
    None,  # 146
    None,  # 147
    None,  # 148
    None,  # 149
    None,  # 150
    None,  # 151
    None,  # 152
    None,  # 153
    None,  # 154
    None,  # 155
    None,  # 156
    None,  # 157
    None,  # 158
    None,  # 159
    None,  # 160
    None,  # 161
    None,  # 162
    None,  # 163
    None,  # 164
    None,  # 165
    None,  # 166
    None,  # 167
    None,  # 168
    None,  # 169
    None,  # 170
    None,  # 171
    None,  # 172
    None,  # 173
    None,  # 174
    None,  # 175
    None,  # 176
    None,  # 177
    None,  # 178
    None,  # 179
    None,  # 180
    None,  # 181
    None,  # 182
    None,  # 183
    None,  # 184
    None,  # 185
    None,  # 186
    None,  # 187
    None,  # 188
    None,  # 189
    None,  # 190
    None,  # 191
    None,  # 192
    None,  # 193
    None,  # 194
    None,  # 195
    None,  # 196
    None,  # 197
    None,  # 198
    None,  # 199
    None,  # 200
    None,  # 201
    None,  # 202
    None,  # 203
    None,  # 204
    None,  # 205
    None,  # 206
    None,  # 207
    None,  # 208
    None,  # 209
    None,  # 210
    None,  # 211
    None,  # 212
    None,  # 213
    None,  # 214
    None,  # 215
    None,  # 216
    None,  # 217
    None,  # 218
    None,  # 219
    None,  # 220
    None,  # 221
    None,  # 222
    None,  # 223
    None,  # 224
    None,  # 225
    None,  # 226
    None,  # 227
    None,  # 228
    None,  # 229
    None,  # 230
    None,  # 231
    None,  # 232
    None,  # 233
    None,  # 234
    None,  # 235
    None,  # 236
    None,  # 237
    None,  # 238
    None,  # 239
    None,  # 240
    None,  # 241
    None,  # 242
    None,  # 243
    None,  # 244
    None,  # 245
    None,  # 246
    None,  # 247
    None,  # 248
    None,  # 249
    None,  # 250
    None,  # 251
    None,  # 252
    None,  # 253
    None,  # 254
    None,  # 255
    None,  # 256
    None,  # 257
    None,  # 258
    None,  # 259
    None,  # 260
    None,  # 261
    None,  # 262
    None,  # 263
    None,  # 264
    None,  # 265
    None,  # 266
    None,  # 267
    None,  # 268
    None,  # 269
    None,  # 270
    None,  # 271
    None,  # 272
    None,  # 273
    None,  # 274
    None,  # 275
    None,  # 276
    None,  # 277
    None,  # 278
    None,  # 279
    None,  # 280
    None,  # 281
    None,  # 282
    None,  # 283
    None,  # 284
    None,  # 285
    None,  # 286
    None,  # 287
    None,  # 288
    None,  # 289
    None,  # 290
    None,  # 291
    None,  # 292
    None,  # 293
    None,  # 294
    None,  # 295
    None,  # 296
    None,  # 297
    None,  # 298
    None,  # 299
    None,  # 300
    None,  # 301
    None,  # 302
    None,  # 303
    None,  # 304
    None,  # 305
    None,  # 306
    None,  # 307
    None,  # 308
    None,  # 309
    None,  # 310
    None,  # 311
    None,  # 312
    None,  # 313
    None,  # 314
    None,  # 315
    None,  # 316
    None,  # 317
    None,  # 318
    None,  # 319
    None,  # 320
    None,  # 321
    None,  # 322
    None,  # 323
    None,  # 324
    None,  # 325
    None,  # 326
    None,  # 327
    None,  # 328
    None,  # 329
    None,  # 330
    None,  # 331
    None,  # 332
    None,  # 333
    None,  # 334
    None,  # 335
    None,  # 336
    None,  # 337
    None,  # 338
    None,  # 339
    None,  # 340
    None,  # 341
    None,  # 342
    None,  # 343
    None,  # 344
    None,  # 345
    None,  # 346
    None,  # 347
    None,  # 348
    None,  # 349
    None,  # 350
    None,  # 351
    None,  # 352
    None,  # 353
    None,  # 354
    None,  # 355
    None,  # 356
    None,  # 357
    None,  # 358
    None,  # 359
    None,  # 360
    None,  # 361
    None,  # 362
    None,  # 363
    None,  # 364
    None,  # 365
    None,  # 366
    None,  # 367
    None,  # 368
    None,  # 369
    None,  # 370
    None,  # 371
    None,  # 372
    None,  # 373
    None,  # 374
    None,  # 375
    None,  # 376
    None,  # 377
    None,  # 378
    None,  # 379
    None,  # 380
    None,  # 381
    None,  # 382
    None,  # 383
    None,  # 384
    None,  # 385
    None,  # 386
    None,  # 387
    None,  # 388
    None,  # 389
    None,  # 390
    None,  # 391
    None,  # 392
    None,  # 393
    None,  # 394
    None,  # 395
    None,  # 396
    None,  # 397
    None,  # 398
    None,  # 399
    None,  # 400
    None,  # 401
    None,  # 402
    None,  # 403
    None,  # 404
    None,  # 405
    None,  # 406
    None,  # 407
    None,  # 408
    None,  # 409
    None,  # 410
    None,  # 411
    None,  # 412
    None,  # 413
    None,  # 414
    None,  # 415
    None,  # 416
    None,  # 417
    None,  # 418
    None,  # 419
    None,  # 420
    None,  # 421
    None,  # 422
    None,  # 423
    None,  # 424
    None,  # 425
    None,  # 426
    None,  # 427
    None,  # 428
    None,  # 429
    None,  # 430
    None,  # 431
    None,  # 432
    None,  # 433
    None,  # 434
    None,  # 435
    None,  # 436
    None,  # 437
    None,  # 438
    None,  # 439
    None,  # 440
    None,  # 441
    None,  # 442
    None,  # 443
    None,  # 444
    None,  # 445
    None,  # 446
    None,  # 447
    None,  # 448
    None,  # 449
    None,  # 450
    None,  # 451
    None,  # 452
    None,  # 453
    None,  # 454
    None,  # 455
    None,  # 456
    None,  # 457
    None,  # 458
    None,  # 459
    None,  # 460
    None,  # 461
    None,  # 462
    None,  # 463
    None,  # 464
    None,  # 465
    None,  # 466
    None,  # 467
    None,  # 468
    None,  # 469
    None,  # 470
    None,  # 471
    None,  # 472
    None,  # 473
    None,  # 474
    None,  # 475
    None,  # 476
    None,  # 477
    None,  # 478
    None,  # 479
    None,  # 480
    None,  # 481
    None,  # 482
    None,  # 483
    None,  # 484
    None,  # 485
    None,  # 486
    None,  # 487
    None,  # 488
    None,  # 489
    None,  # 490
    None,  # 491
    None,  # 492
    None,  # 493
    None,  # 494
    None,  # 495
    None,  # 496
    None,  # 497
    None,  # 498
    None,  # 499
    None,  # 500
    None,  # 501
    None,  # 502
    None,  # 503
    None,  # 504
    None,  # 505
    None,  # 506
    None,  # 507
    None,  # 508
    None,  # 509
    None,  # 510
    None,  # 511
    None,  # 512
    (513, TType.STRING, 'sched_status', 'UTF8', None, ),  # 513
    (514, TType.STRING, 'owner', 'UTF8', None, ),  # 514
    (515, TType.I32, 'replication_count', None, None, ),  # 515
    None,  # 516
    None,  # 517
    None,  # 518
    None,  # 519
    None,  # 520
    (521, TType.DOUBLE, 'requested_memonheap', None, None, ),  # 521
    (522, TType.DOUBLE, 'requested_memoffheap', None, None, ),  # 522
    (523, TType.DOUBLE, 'requested_cpu', None, None, ),  # 523
    (524, TType.DOUBLE, 'assigned_memonheap', None, None, ),  # 524
    (525, TType.DOUBLE, 'assigned_memoffheap', None, None, ),  # 525
    (526, TType.DOUBLE, 'assigned_cpu', None, None, ),  # 526
)
all_structs.append(CommonAggregateStats)
CommonAggregateStats.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'num_executors', None, None, ),  # 1
    (2, TType.I32, 'num_tasks', None, None, ),  # 2
    (3, TType.I64, 'emitted', None, None, ),  # 3
    (4, TType.I64, 'transferred', None, None, ),  # 4
    (5, TType.I64, 'acked', None, None, ),  # 5
    (6, TType.I64, 'failed', None, None, ),  # 6
    (7, TType.MAP, 'resources_map', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), None, ),  # 7
)
all_structs.append(SpoutAggregateStats)
SpoutAggregateStats.thrift_spec = (
    None,  # 0
    (1, TType.DOUBLE, 'complete_latency_ms', None, None, ),  # 1
)
all_structs.append(BoltAggregateStats)
BoltAggregateStats.thrift_spec = (
    None,  # 0
    (1, TType.DOUBLE, 'execute_latency_ms', None, None, ),  # 1
    (2, TType.DOUBLE, 'process_latency_ms', None, None, ),  # 2
    (3, TType.I64, 'executed', None, None, ),  # 3
    (4, TType.DOUBLE, 'capacity', None, None, ),  # 4
)
all_structs.append(SpecificAggregateStats)
SpecificAggregateStats.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'bolt', [BoltAggregateStats, None], None, ),  # 1
    (2, TType.STRUCT, 'spout', [SpoutAggregateStats, None], None, ),  # 2
)
all_structs.append(ComponentAggregateStats)
ComponentAggregateStats.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'type', None, None, ),  # 1
    (2, TType.STRUCT, 'common_stats', [CommonAggregateStats, None], None, ),  # 2
    (3, TType.STRUCT, 'specific_stats', [SpecificAggregateStats, None], None, ),  # 3
    (4, TType.STRUCT, 'last_error', [ErrorInfo, None], None, ),  # 4
)
all_structs.append(TopologyStats)
TopologyStats.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'window_to_emitted', (TType.STRING, 'UTF8', TType.I64, None, False), None, ),  # 1
    (2, TType.MAP, 'window_to_transferred', (TType.STRING, 'UTF8', TType.I64, None, False), None, ),  # 2
    (3, TType.MAP, 'window_to_complete_latencies_ms', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), None, ),  # 3
    (4, TType.MAP, 'window_to_acked', (TType.STRING, 'UTF8', TType.I64, None, False), None, ),  # 4
    (5, TType.MAP, 'window_to_failed', (TType.STRING, 'UTF8', TType.I64, None, False), None, ),  # 5
)
all_structs.append(WorkerSummary)
WorkerSummary.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'supervisor_id', 'UTF8', None, ),  # 1
    (2, TType.STRING, 'host', 'UTF8', None, ),  # 2
    (3, TType.I32, 'port', None, None, ),  # 3
    (4, TType.STRING, 'topology_id', 'UTF8', None, ),  # 4
    (5, TType.STRING, 'topology_name', 'UTF8', None, ),  # 5
    (6, TType.I32, 'num_executors', None, None, ),  # 6
    (7, TType.MAP, 'component_to_num_tasks', (TType.STRING, 'UTF8', TType.I64, None, False), None, ),  # 7
    (8, TType.I32, 'time_secs', None, None, ),  # 8
    (9, TType.I32, 'uptime_secs', None, None, ),  # 9
    None,  # 10
    None,  # 11
    None,  # 12
    None,  # 13
    None,  # 14
    None,  # 15
    None,  # 16
    None,  # 17
    None,  # 18
    None,  # 19
    None,  # 20
    None,  # 21
    None,  # 22
    None,  # 23
    None,  # 24
    None,  # 25
    None,  # 26
    None,  # 27
    None,  # 28
    None,  # 29
    None,  # 30
    None,  # 31
    None,  # 32
    None,  # 33
    None,  # 34
    None,  # 35
    None,  # 36
    None,  # 37
    None,  # 38
    None,  # 39
    None,  # 40
    None,  # 41
    None,  # 42
    None,  # 43
    None,  # 44
    None,  # 45
    None,  # 46
    None,  # 47
    None,  # 48
    None,  # 49
    None,  # 50
    None,  # 51
    None,  # 52
    None,  # 53
    None,  # 54
    None,  # 55
    None,  # 56
    None,  # 57
    None,  # 58
    None,  # 59
    None,  # 60
    None,  # 61
    None,  # 62
    None,  # 63
    None,  # 64
    None,  # 65
    None,  # 66
    None,  # 67
    None,  # 68
    None,  # 69
    None,  # 70
    None,  # 71
    None,  # 72
    None,  # 73
    None,  # 74
    None,  # 75
    None,  # 76
    None,  # 77
    None,  # 78
    None,  # 79
    None,  # 80
    None,  # 81
    None,  # 82
    None,  # 83
    None,  # 84
    None,  # 85
    None,  # 86
    None,  # 87
    None,  # 88
    None,  # 89
    None,  # 90
    None,  # 91
    None,  # 92
    None,  # 93
    None,  # 94
    None,  # 95
    None,  # 96
    None,  # 97
    None,  # 98
    None,  # 99
    None,  # 100
    None,  # 101
    None,  # 102
    None,  # 103
    None,  # 104
    None,  # 105
    None,  # 106
    None,  # 107
    None,  # 108
    None,  # 109
    None,  # 110
    None,  # 111
    None,  # 112
    None,  # 113
    None,  # 114
    None,  # 115
    None,  # 116
    None,  # 117
    None,  # 118
    None,  # 119
    None,  # 120
    None,  # 121
    None,  # 122
    None,  # 123
    None,  # 124
    None,  # 125
    None,  # 126
    None,  # 127
    None,  # 128
    None,  # 129
    None,  # 130
    None,  # 131
    None,  # 132
    None,  # 133
    None,  # 134
    None,  # 135
    None,  # 136
    None,  # 137
    None,  # 138
    None,  # 139
    None,  # 140
    None,  # 141
    None,  # 142
    None,  # 143
    None,  # 144
    None,  # 145
    None,  # 146
    None,  # 147
    None,  # 148
    None,  # 149
    None,  # 150
    None,  # 151
    None,  # 152
    None,  # 153
    None,  # 154
    None,  # 155
    None,  # 156
    None,  # 157
    None,  # 158
    None,  # 159
    None,  # 160
    None,  # 161
    None,  # 162
    None,  # 163
    None,  # 164
    None,  # 165
    None,  # 166
    None,  # 167
    None,  # 168
    None,  # 169
    None,  # 170
    None,  # 171
    None,  # 172
    None,  # 173
    None,  # 174
    None,  # 175
    None,  # 176
    None,  # 177
    None,  # 178
    None,  # 179
    None,  # 180
    None,  # 181
    None,  # 182
    None,  # 183
    None,  # 184
    None,  # 185
    None,  # 186
    None,  # 187
    None,  # 188
    None,  # 189
    None,  # 190
    None,  # 191
    None,  # 192
    None,  # 193
    None,  # 194
    None,  # 195
    None,  # 196
    None,  # 197
    None,  # 198
    None,  # 199
    None,  # 200
    None,  # 201
    None,  # 202
    None,  # 203
    None,  # 204
    None,  # 205
    None,  # 206
    None,  # 207
    None,  # 208
    None,  # 209
    None,  # 210
    None,  # 211
    None,  # 212
    None,  # 213
    None,  # 214
    None,  # 215
    None,  # 216
    None,  # 217
    None,  # 218
    None,  # 219
    None,  # 220
    None,  # 221
    None,  # 222
    None,  # 223
    None,  # 224
    None,  # 225
    None,  # 226
    None,  # 227
    None,  # 228
    None,  # 229
    None,  # 230
    None,  # 231
    None,  # 232
    None,  # 233
    None,  # 234
    None,  # 235
    None,  # 236
    None,  # 237
    None,  # 238
    None,  # 239
    None,  # 240
    None,  # 241
    None,  # 242
    None,  # 243
    None,  # 244
    None,  # 245
    None,  # 246
    None,  # 247
    None,  # 248
    None,  # 249
    None,  # 250
    None,  # 251
    None,  # 252
    None,  # 253
    None,  # 254
    None,  # 255
    None,  # 256
    None,  # 257
    None,  # 258
    None,  # 259
    None,  # 260
    None,  # 261
    None,  # 262
    None,  # 263
    None,  # 264
    None,  # 265
    None,  # 266
    None,  # 267
    None,  # 268
    None,  # 269
    None,  # 270
    None,  # 271
    None,  # 272
    None,  # 273
    None,  # 274
    None,  # 275
    None,  # 276
    None,  # 277
    None,  # 278
    None,  # 279
    None,  # 280
    None,  # 281
    None,  # 282
    None,  # 283
    None,  # 284
    None,  # 285
    None,  # 286
    None,  # 287
    None,  # 288
    None,  # 289
    None,  # 290
    None,  # 291
    None,  # 292
    None,  # 293
    None,  # 294
    None,  # 295
    None,  # 296
    None,  # 297
    None,  # 298
    None,  # 299
    None,  # 300
    None,  # 301
    None,  # 302
    None,  # 303
    None,  # 304
    None,  # 305
    None,  # 306
    None,  # 307
    None,  # 308
    None,  # 309
    None,  # 310
    None,  # 311
    None,  # 312
    None,  # 313
    None,  # 314
    None,  # 315
    None,  # 316
    None,  # 317
    None,  # 318
    None,  # 319
    None,  # 320
    None,  # 321
    None,  # 322
    None,  # 323
    None,  # 324
    None,  # 325
    None,  # 326
    None,  # 327
    None,  # 328
    None,  # 329
    None,  # 330
    None,  # 331
    None,  # 332
    None,  # 333
    None,  # 334
    None,  # 335
    None,  # 336
    None,  # 337
    None,  # 338
    None,  # 339
    None,  # 340
    None,  # 341
    None,  # 342
    None,  # 343
    None,  # 344
    None,  # 345
    None,  # 346
    None,  # 347
    None,  # 348
    None,  # 349
    None,  # 350
    None,  # 351
    None,  # 352
    None,  # 353
    None,  # 354
    None,  # 355
    None,  # 356
    None,  # 357
    None,  # 358
    None,  # 359
    None,  # 360
    None,  # 361
    None,  # 362
    None,  # 363
    None,  # 364
    None,  # 365
    None,  # 366
    None,  # 367
    None,  # 368
    None,  # 369
    None,  # 370
    None,  # 371
    None,  # 372
    None,  # 373
    None,  # 374
    None,  # 375
    None,  # 376
    None,  # 377
    None,  # 378
    None,  # 379
    None,  # 380
    None,  # 381
    None,  # 382
    None,  # 383
    None,  # 384
    None,  # 385
    None,  # 386
    None,  # 387
    None,  # 388
    None,  # 389
    None,  # 390
    None,  # 391
    None,  # 392
    None,  # 393
    None,  # 394
    None,  # 395
    None,  # 396
    None,  # 397
    None,  # 398
    None,  # 399
    None,  # 400
    None,  # 401
    None,  # 402
    None,  # 403
    None,  # 404
    None,  # 405
    None,  # 406
    None,  # 407
    None,  # 408
    None,  # 409
    None,  # 410
    None,  # 411
    None,  # 412
    None,  # 413
    None,  # 414
    None,  # 415
    None,  # 416
    None,  # 417
    None,  # 418
    None,  # 419
    None,  # 420
    None,  # 421
    None,  # 422
    None,  # 423
    None,  # 424
    None,  # 425
    None,  # 426
    None,  # 427
    None,  # 428
    None,  # 429
    None,  # 430
    None,  # 431
    None,  # 432
    None,  # 433
    None,  # 434
    None,  # 435
    None,  # 436
    None,  # 437
    None,  # 438
    None,  # 439
    None,  # 440
    None,  # 441
    None,  # 442
    None,  # 443
    None,  # 444
    None,  # 445
    None,  # 446
    None,  # 447
    None,  # 448
    None,  # 449
    None,  # 450
    None,  # 451
    None,  # 452
    None,  # 453
    None,  # 454
    None,  # 455
    None,  # 456
    None,  # 457
    None,  # 458
    None,  # 459
    None,  # 460
    None,  # 461
    None,  # 462
    None,  # 463
    None,  # 464
    None,  # 465
    None,  # 466
    None,  # 467
    None,  # 468
    None,  # 469
    None,  # 470
    None,  # 471
    None,  # 472
    None,  # 473
    None,  # 474
    None,  # 475
    None,  # 476
    None,  # 477
    None,  # 478
    None,  # 479
    None,  # 480
    None,  # 481
    None,  # 482
    None,  # 483
    None,  # 484
    None,  # 485
    None,  # 486
    None,  # 487
    None,  # 488
    None,  # 489
    None,  # 490
    None,  # 491
    None,  # 492
    None,  # 493
    None,  # 494
    None,  # 495
    None,  # 496
    None,  # 497
    None,  # 498
    None,  # 499
    None,  # 500
    None,  # 501
    None,  # 502
    None,  # 503
    None,  # 504
    None,  # 505
    None,  # 506
    None,  # 507
    None,  # 508
    None,  # 509
    None,  # 510
    None,  # 511
    None,  # 512
    None,  # 513
    None,  # 514
    None,  # 515
    None,  # 516
    None,  # 517
    None,  # 518
    None,  # 519
    None,  # 520
    (521, TType.DOUBLE, 'requested_memonheap', None, None, ),  # 521
    (522, TType.DOUBLE, 'requested_memoffheap', None, None, ),  # 522
    (523, TType.DOUBLE, 'requested_cpu', None, None, ),  # 523
    (524, TType.DOUBLE, 'assigned_memonheap', None, None, ),  # 524
    (525, TType.DOUBLE, 'assigned_memoffheap', None, None, ),  # 525
    (526, TType.DOUBLE, 'assigned_cpu', None, None, ),  # 526
    (527, TType.STRING, 'owner', 'UTF8', None, ),  # 527
)
all_structs.append(SupervisorPageInfo)
SupervisorPageInfo.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'supervisor_summaries', (TType.STRUCT, [SupervisorSummary, None], False), None, ),  # 1
    (2, TType.LIST, 'worker_summaries', (TType.STRUCT, [WorkerSummary, None], False), None, ),  # 2
)
all_structs.append(TopologyPageInfo)
TopologyPageInfo.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'id', 'UTF8', None, ),  # 1
    (2, TType.STRING, 'name', 'UTF8', None, ),  # 2
    (3, TType.I32, 'uptime_secs', None, None, ),  # 3
    (4, TType.STRING, 'status', 'UTF8', None, ),  # 4
    (5, TType.I32, 'num_tasks', None, None, ),  # 5
    (6, TType.I32, 'num_workers', None, None, ),  # 6
    (7, TType.I32, 'num_executors', None, None, ),  # 7
    (8, TType.STRING, 'topology_conf', 'UTF8', None, ),  # 8
    (9, TType.MAP, 'id_to_spout_agg_stats', (TType.STRING, 'UTF8', TType.STRUCT, [ComponentAggregateStats, None], False), None, ),  # 9
    (10, TType.MAP, 'id_to_bolt_agg_stats', (TType.STRING, 'UTF8', TType.STRUCT, [ComponentAggregateStats, None], False), None, ),  # 10
    (11, TType.STRING, 'sched_status', 'UTF8', None, ),  # 11
    (12, TType.STRUCT, 'topology_stats', [TopologyStats, None], None, ),  # 12
    (13, TType.STRING, 'owner', 'UTF8', None, ),  # 13
    (14, TType.STRUCT, 'debug_options', [DebugOptions, None], None, ),  # 14
    (15, TType.I32, 'replication_count', None, None, ),  # 15
    (16, TType.LIST, 'workers', (TType.STRUCT, [WorkerSummary, None], False), None, ),  # 16
    (17, TType.STRING, 'storm_version', 'UTF8', None, ),  # 17
    (18, TType.STRING, 'topology_version', 'UTF8', None, ),  # 18
    None,  # 19
    None,  # 20
    None,  # 21
    None,  # 22
    None,  # 23
    None,  # 24
    None,  # 25
    None,  # 26
    None,  # 27
    None,  # 28
    None,  # 29
    None,  # 30
    None,  # 31
    None,  # 32
    None,  # 33
    None,  # 34
    None,  # 35
    None,  # 36
    None,  # 37
    None,  # 38
    None,  # 39
    None,  # 40
    None,  # 41
    None,  # 42
    None,  # 43
    None,  # 44
    None,  # 45
    None,  # 46
    None,  # 47
    None,  # 48
    None,  # 49
    None,  # 50
    None,  # 51
    None,  # 52
    None,  # 53
    None,  # 54
    None,  # 55
    None,  # 56
    None,  # 57
    None,  # 58
    None,  # 59
    None,  # 60
    None,  # 61
    None,  # 62
    None,  # 63
    None,  # 64
    None,  # 65
    None,  # 66
    None,  # 67
    None,  # 68
    None,  # 69
    None,  # 70
    None,  # 71
    None,  # 72
    None,  # 73
    None,  # 74
    None,  # 75
    None,  # 76
    None,  # 77
    None,  # 78
    None,  # 79
    None,  # 80
    None,  # 81
    None,  # 82
    None,  # 83
    None,  # 84
    None,  # 85
    None,  # 86
    None,  # 87
    None,  # 88
    None,  # 89
    None,  # 90
    None,  # 91
    None,  # 92
    None,  # 93
    None,  # 94
    None,  # 95
    None,  # 96
    None,  # 97
    None,  # 98
    None,  # 99
    None,  # 100
    None,  # 101
    None,  # 102
    None,  # 103
    None,  # 104
    None,  # 105
    None,  # 106
    None,  # 107
    None,  # 108
    None,  # 109
    None,  # 110
    None,  # 111
    None,  # 112
    None,  # 113
    None,  # 114
    None,  # 115
    None,  # 116
    None,  # 117
    None,  # 118
    None,  # 119
    None,  # 120
    None,  # 121
    None,  # 122
    None,  # 123
    None,  # 124
    None,  # 125
    None,  # 126
    None,  # 127
    None,  # 128
    None,  # 129
    None,  # 130
    None,  # 131
    None,  # 132
    None,  # 133
    None,  # 134
    None,  # 135
    None,  # 136
    None,  # 137
    None,  # 138
    None,  # 139
    None,  # 140
    None,  # 141
    None,  # 142
    None,  # 143
    None,  # 144
    None,  # 145
    None,  # 146
    None,  # 147
    None,  # 148
    None,  # 149
    None,  # 150
    None,  # 151
    None,  # 152
    None,  # 153
    None,  # 154
    None,  # 155
    None,  # 156
    None,  # 157
    None,  # 158
    None,  # 159
    None,  # 160
    None,  # 161
    None,  # 162
    None,  # 163
    None,  # 164
    None,  # 165
    None,  # 166
    None,  # 167
    None,  # 168
    None,  # 169
    None,  # 170
    None,  # 171
    None,  # 172
    None,  # 173
    None,  # 174
    None,  # 175
    None,  # 176
    None,  # 177
    None,  # 178
    None,  # 179
    None,  # 180
    None,  # 181
    None,  # 182
    None,  # 183
    None,  # 184
    None,  # 185
    None,  # 186
    None,  # 187
    None,  # 188
    None,  # 189
    None,  # 190
    None,  # 191
    None,  # 192
    None,  # 193
    None,  # 194
    None,  # 195
    None,  # 196
    None,  # 197
    None,  # 198
    None,  # 199
    None,  # 200
    None,  # 201
    None,  # 202
    None,  # 203
    None,  # 204
    None,  # 205
    None,  # 206
    None,  # 207
    None,  # 208
    None,  # 209
    None,  # 210
    None,  # 211
    None,  # 212
    None,  # 213
    None,  # 214
    None,  # 215
    None,  # 216
    None,  # 217
    None,  # 218
    None,  # 219
    None,  # 220
    None,  # 221
    None,  # 222
    None,  # 223
    None,  # 224
    None,  # 225
    None,  # 226
    None,  # 227
    None,  # 228
    None,  # 229
    None,  # 230
    None,  # 231
    None,  # 232
    None,  # 233
    None,  # 234
    None,  # 235
    None,  # 236
    None,  # 237
    None,  # 238
    None,  # 239
    None,  # 240
    None,  # 241
    None,  # 242
    None,  # 243
    None,  # 244
    None,  # 245
    None,  # 246
    None,  # 247
    None,  # 248
    None,  # 249
    None,  # 250
    None,  # 251
    None,  # 252
    None,  # 253
    None,  # 254
    None,  # 255
    None,  # 256
    None,  # 257
    None,  # 258
    None,  # 259
    None,  # 260
    None,  # 261
    None,  # 262
    None,  # 263
    None,  # 264
    None,  # 265
    None,  # 266
    None,  # 267
    None,  # 268
    None,  # 269
    None,  # 270
    None,  # 271
    None,  # 272
    None,  # 273
    None,  # 274
    None,  # 275
    None,  # 276
    None,  # 277
    None,  # 278
    None,  # 279
    None,  # 280
    None,  # 281
    None,  # 282
    None,  # 283
    None,  # 284
    None,  # 285
    None,  # 286
    None,  # 287
    None,  # 288
    None,  # 289
    None,  # 290
    None,  # 291
    None,  # 292
    None,  # 293
    None,  # 294
    None,  # 295
    None,  # 296
    None,  # 297
    None,  # 298
    None,  # 299
    None,  # 300
    None,  # 301
    None,  # 302
    None,  # 303
    None,  # 304
    None,  # 305
    None,  # 306
    None,  # 307
    None,  # 308
    None,  # 309
    None,  # 310
    None,  # 311
    None,  # 312
    None,  # 313
    None,  # 314
    None,  # 315
    None,  # 316
    None,  # 317
    None,  # 318
    None,  # 319
    None,  # 320
    None,  # 321
    None,  # 322
    None,  # 323
    None,  # 324
    None,  # 325
    None,  # 326
    None,  # 327
    None,  # 328
    None,  # 329
    None,  # 330
    None,  # 331
    None,  # 332
    None,  # 333
    None,  # 334
    None,  # 335
    None,  # 336
    None,  # 337
    None,  # 338
    None,  # 339
    None,  # 340
    None,  # 341
    None,  # 342
    None,  # 343
    None,  # 344
    None,  # 345
    None,  # 346
    None,  # 347
    None,  # 348
    None,  # 349
    None,  # 350
    None,  # 351
    None,  # 352
    None,  # 353
    None,  # 354
    None,  # 355
    None,  # 356
    None,  # 357
    None,  # 358
    None,  # 359
    None,  # 360
    None,  # 361
    None,  # 362
    None,  # 363
    None,  # 364
    None,  # 365
    None,  # 366
    None,  # 367
    None,  # 368
    None,  # 369
    None,  # 370
    None,  # 371
    None,  # 372
    None,  # 373
    None,  # 374
    None,  # 375
    None,  # 376
    None,  # 377
    None,  # 378
    None,  # 379
    None,  # 380
    None,  # 381
    None,  # 382
    None,  # 383
    None,  # 384
    None,  # 385
    None,  # 386
    None,  # 387
    None,  # 388
    None,  # 389
    None,  # 390
    None,  # 391
    None,  # 392
    None,  # 393
    None,  # 394
    None,  # 395
    None,  # 396
    None,  # 397
    None,  # 398
    None,  # 399
    None,  # 400
    None,  # 401
    None,  # 402
    None,  # 403
    None,  # 404
    None,  # 405
    None,  # 406
    None,  # 407
    None,  # 408
    None,  # 409
    None,  # 410
    None,  # 411
    None,  # 412
    None,  # 413
    None,  # 414
    None,  # 415
    None,  # 416
    None,  # 417
    None,  # 418
    None,  # 419
    None,  # 420
    None,  # 421
    None,  # 422
    None,  # 423
    None,  # 424
    None,  # 425
    None,  # 426
    None,  # 427
    None,  # 428
    None,  # 429
    None,  # 430
    None,  # 431
    None,  # 432
    None,  # 433
    None,  # 434
    None,  # 435
    None,  # 436
    None,  # 437
    None,  # 438
    None,  # 439
    None,  # 440
    None,  # 441
    None,  # 442
    None,  # 443
    None,  # 444
    None,  # 445
    None,  # 446
    None,  # 447
    None,  # 448
    None,  # 449
    None,  # 450
    None,  # 451
    None,  # 452
    None,  # 453
    None,  # 454
    None,  # 455
    None,  # 456
    None,  # 457
    None,  # 458
    None,  # 459
    None,  # 460
    None,  # 461
    None,  # 462
    None,  # 463
    None,  # 464
    None,  # 465
    None,  # 466
    None,  # 467
    None,  # 468
    None,  # 469
    None,  # 470
    None,  # 471
    None,  # 472
    None,  # 473
    None,  # 474
    None,  # 475
    None,  # 476
    None,  # 477
    None,  # 478
    None,  # 479
    None,  # 480
    None,  # 481
    None,  # 482
    None,  # 483
    None,  # 484
    None,  # 485
    None,  # 486
    None,  # 487
    None,  # 488
    None,  # 489
    None,  # 490
    None,  # 491
    None,  # 492
    None,  # 493
    None,  # 494
    None,  # 495
    None,  # 496
    None,  # 497
    None,  # 498
    None,  # 499
    None,  # 500
    None,  # 501
    None,  # 502
    None,  # 503
    None,  # 504
    None,  # 505
    None,  # 506
    None,  # 507
    None,  # 508
    None,  # 509
    None,  # 510
    None,  # 511
    None,  # 512
    None,  # 513
    None,  # 514
    None,  # 515
    None,  # 516
    None,  # 517
    None,  # 518
    None,  # 519
    None,  # 520
    (521, TType.DOUBLE, 'requested_memonheap', None, None, ),  # 521
    (522, TType.DOUBLE, 'requested_memoffheap', None, None, ),  # 522
    (523, TType.DOUBLE, 'requested_cpu', None, None, ),  # 523
    (524, TType.DOUBLE, 'assigned_memonheap', None, None, ),  # 524
    (525, TType.DOUBLE, 'assigned_memoffheap', None, None, ),  # 525
    (526, TType.DOUBLE, 'assigned_cpu', None, None, ),  # 526
    (527, TType.DOUBLE, 'requested_regular_on_heap_memory', None, None, ),  # 527
    (528, TType.DOUBLE, 'requested_shared_on_heap_memory', None, None, ),  # 528
    (529, TType.DOUBLE, 'requested_regular_off_heap_memory', None, None, ),  # 529
    (530, TType.DOUBLE, 'requested_shared_off_heap_memory', None, None, ),  # 530
    (531, TType.DOUBLE, 'assigned_regular_on_heap_memory', None, None, ),  # 531
    (532, TType.DOUBLE, 'assigned_shared_on_heap_memory', None, None, ),  # 532
    (533, TType.DOUBLE, 'assigned_regular_off_heap_memory', None, None, ),  # 533
    (534, TType.DOUBLE, 'assigned_shared_off_heap_memory', None, None, ),  # 534
    (535, TType.MAP, 'requested_generic_resources', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), None, ),  # 535
    (536, TType.MAP, 'assigned_generic_resources', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), None, ),  # 536
)
all_structs.append(ExecutorAggregateStats)
ExecutorAggregateStats.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'exec_summary', [ExecutorSummary, None], None, ),  # 1
    (2, TType.STRUCT, 'stats', [ComponentAggregateStats, None], None, ),  # 2
)
all_structs.append(ComponentPageInfo)
ComponentPageInfo.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'component_id', 'UTF8', None, ),  # 1
    (2, TType.I32, 'component_type', None, None, ),  # 2
    (3, TType.STRING, 'topology_id', 'UTF8', None, ),  # 3
    (4, TType.STRING, 'topology_name', 'UTF8', None, ),  # 4
    (5, TType.I32, 'num_executors', None, None, ),  # 5
    (6, TType.I32, 'num_tasks', None, None, ),  # 6
    (7, TType.MAP, 'window_to_stats', (TType.STRING, 'UTF8', TType.STRUCT, [ComponentAggregateStats, None], False), None, ),  # 7
    (8, TType.MAP, 'gsid_to_input_stats', (TType.STRUCT, [GlobalStreamId, None], TType.STRUCT, [ComponentAggregateStats, None], False), None, ),  # 8
    (9, TType.MAP, 'sid_to_output_stats', (TType.STRING, 'UTF8', TType.STRUCT, [ComponentAggregateStats, None], False), None, ),  # 9
    (10, TType.LIST, 'exec_stats', (TType.STRUCT, [ExecutorAggregateStats, None], False), None, ),  # 10
    (11, TType.LIST, 'errors', (TType.STRUCT, [ErrorInfo, None], False), None, ),  # 11
    (12, TType.STRING, 'eventlog_host', 'UTF8', None, ),  # 12
    (13, TType.I32, 'eventlog_port', None, None, ),  # 13
    (14, TType.STRUCT, 'debug_options', [DebugOptions, None], None, ),  # 14
    (15, TType.STRING, 'topology_status', 'UTF8', None, ),  # 15
    (16, TType.MAP, 'resources_map', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), None, ),  # 16
)
all_structs.append(KillOptions)
KillOptions.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'wait_secs', None, None, ),  # 1
)
all_structs.append(RebalanceOptions)
RebalanceOptions.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'wait_secs', None, None, ),  # 1
    (2, TType.I32, 'num_workers', None, None, ),  # 2
    (3, TType.MAP, 'num_executors', (TType.STRING, 'UTF8', TType.I32, None, False), None, ),  # 3
    (4, TType.MAP, 'topology_resources_overrides', (TType.STRING, 'UTF8', TType.MAP, (TType.STRING, 'UTF8', TType.DOUBLE, None, False), False), None, ),  # 4
    (5, TType.STRING, 'topology_conf_overrides', 'UTF8', None, ),  # 5
    (6, TType.STRING, 'principal', 'UTF8', None, ),  # 6
)
all_structs.append(Credentials)
Credentials.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'creds', (TType.STRING, 'UTF8', TType.STRING, 'UTF8', False), None, ),  # 1
    (2, TType.STRING, 'topoOwner', 'UTF8', None, ),  # 2
)
all_structs.append(SubmitOptions)
SubmitOptions.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'initial_status', None, None, ),  # 1
    (2, TType.STRUCT, 'creds', [Credentials, None], None, ),  # 2
)
all_structs.append(AccessControl)
AccessControl.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'type', None, None, ),  # 1
    (2, TType.STRING, 'name', 'UTF8', None, ),  # 2
    (3, TType.I32, 'access', None, None, ),  # 3
)
all_structs.append(SettableBlobMeta)
SettableBlobMeta.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'acl', (TType.STRUCT, [AccessControl, None], False), None, ),  # 1
    (2, TType.I32, 'replication_factor', None, None, ),  # 2
)
all_structs.append(ReadableBlobMeta)
ReadableBlobMeta.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'settable', [SettableBlobMeta, None], None, ),  # 1
    (2, TType.I64, 'version', None, None, ),  # 2
)
all_structs.append(ListBlobsResult)
ListBlobsResult.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'keys', (TType.STRING, 'UTF8', False), None, ),  # 1
    (2, TType.STRING, 'session', 'UTF8', None, ),  # 2
)
all_structs.append(BeginDownloadResult)
BeginDownloadResult.thrift_spec = (
    None,  # 0
    (1, TType.I64, 'version', None, None, ),  # 1
    (2, TType.STRING, 'session', 'UTF8', None, ),  # 2
    (3, TType.I64, 'data_size', None, None, ),  # 3
)
all_structs.append(SupervisorInfo)
SupervisorInfo.thrift_spec = (
    None,  # 0
    (1, TType.I64, 'time_secs', None, None, ),  # 1
    (2, TType.STRING, 'hostname', 'UTF8', None, ),  # 2
    (3, TType.STRING, 'assignment_id', 'UTF8', None, ),  # 3
    (4, TType.LIST, 'used_ports', (TType.I64, None, False), None, ),  # 4
    (5, TType.LIST, 'meta', (TType.I64, None, False), None, ),  # 5
    (6, TType.MAP, 'scheduler_meta', (TType.STRING, 'UTF8', TType.STRING, 'UTF8', False), None, ),  # 6
    (7, TType.I64, 'uptime_secs', None, None, ),  # 7
    (8, TType.STRING, 'version', 'UTF8', None, ),  # 8
    (9, TType.MAP, 'resources_map', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), None, ),  # 9
    (10, TType.I32, 'server_port', None, None, ),  # 10
)
all_structs.append(NodeInfo)
NodeInfo.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'node', 'UTF8', None, ),  # 1
    (2, TType.SET, 'port', (TType.I64, None, False), None, ),  # 2
)
all_structs.append(WorkerResources)
WorkerResources.thrift_spec = (
    None,  # 0
    (1, TType.DOUBLE, 'mem_on_heap', None, None, ),  # 1
    (2, TType.DOUBLE, 'mem_off_heap', None, None, ),  # 2
    (3, TType.DOUBLE, 'cpu', None, None, ),  # 3
    (4, TType.DOUBLE, 'shared_mem_on_heap', None, None, ),  # 4
    (5, TType.DOUBLE, 'shared_mem_off_heap', None, None, ),  # 5
    (6, TType.MAP, 'resources', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), None, ),  # 6
    (7, TType.MAP, 'shared_resources', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), None, ),  # 7
)
all_structs.append(Assignment)
Assignment.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'master_code_dir', 'UTF8', None, ),  # 1
    (2, TType.MAP, 'node_host', (TType.STRING, 'UTF8', TType.STRING, 'UTF8', False), {
    }, ),  # 2
    (3, TType.MAP, 'executor_node_port', (TType.LIST, (TType.I64, None, False), TType.STRUCT, [NodeInfo, None], False), {
    }, ),  # 3
    (4, TType.MAP, 'executor_start_time_secs', (TType.LIST, (TType.I64, None, False), TType.I64, None, False), {
    }, ),  # 4
    (5, TType.MAP, 'worker_resources', (TType.STRUCT, [NodeInfo, None], TType.STRUCT, [WorkerResources, None], False), {
    }, ),  # 5
    (6, TType.MAP, 'total_shared_off_heap', (TType.STRING, 'UTF8', TType.DOUBLE, None, False), {
    }, ),  # 6
    (7, TType.STRING, 'owner', 'UTF8', None, ),  # 7
)
all_structs.append(TopologyActionOptions)
TopologyActionOptions.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'kill_options', [KillOptions, None], None, ),  # 1
    (2, TType.STRUCT, 'rebalance_options', [RebalanceOptions, None], None, ),  # 2
)
all_structs.append(StormBase)
StormBase.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'name', 'UTF8', None, ),  # 1
    (2, TType.I32, 'status', None, None, ),  # 2
    (3, TType.I32, 'num_workers', None, None, ),  # 3
    (4, TType.MAP, 'component_executors', (TType.STRING, 'UTF8', TType.I32, None, False), None, ),  # 4
    (5, TType.I32, 'launch_time_secs', None, None, ),  # 5
    (6, TType.STRING, 'owner', 'UTF8', None, ),  # 6
    (7, TType.STRUCT, 'topology_action_options', [TopologyActionOptions, None], None, ),  # 7
    (8, TType.I32, 'prev_status', None, None, ),  # 8
    (9, TType.MAP, 'component_debug', (TType.STRING, 'UTF8', TType.STRUCT, [DebugOptions, None], False), None, ),  # 9
    (10, TType.STRING, 'principal', 'UTF8', None, ),  # 10
    (11, TType.STRING, 'topology_version', 'UTF8', None, ),  # 11
)
all_structs.append(ClusterWorkerHeartbeat)
ClusterWorkerHeartbeat.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'storm_id', 'UTF8', None, ),  # 1
    (2, TType.MAP, 'executor_stats', (TType.STRUCT, [ExecutorInfo, None], TType.STRUCT, [ExecutorStats, None], False), None, ),  # 2
    (3, TType.I32, 'time_secs', None, None, ),  # 3
    (4, TType.I32, 'uptime_secs', None, None, ),  # 4
)
all_structs.append(ThriftSerializedObject)
ThriftSerializedObject.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'name', 'UTF8', None, ),  # 1
    (2, TType.STRING, 'bits', 'BINARY', None, ),  # 2
)
all_structs.append(LocalStateData)
LocalStateData.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'serialized_parts', (TType.STRING, 'UTF8', TType.STRUCT, [ThriftSerializedObject, None], False), None, ),  # 1
)
all_structs.append(LocalAssignment)
LocalAssignment.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'topology_id', 'UTF8', None, ),  # 1
    (2, TType.LIST, 'executors', (TType.STRUCT, [ExecutorInfo, None], False), None, ),  # 2
    (3, TType.STRUCT, 'resources', [WorkerResources, None], None, ),  # 3
    (4, TType.DOUBLE, 'total_node_shared', None, None, ),  # 4
    (5, TType.STRING, 'owner', 'UTF8', None, ),  # 5
)
all_structs.append(LSSupervisorId)
LSSupervisorId.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'supervisor_id', 'UTF8', None, ),  # 1
)
all_structs.append(LSApprovedWorkers)
LSApprovedWorkers.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'approved_workers', (TType.STRING, 'UTF8', TType.I32, None, False), None, ),  # 1
)
all_structs.append(LSSupervisorAssignments)
LSSupervisorAssignments.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'assignments', (TType.I32, None, TType.STRUCT, [LocalAssignment, None], False), None, ),  # 1
)
all_structs.append(LSWorkerHeartbeat)
LSWorkerHeartbeat.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'time_secs', None, None, ),  # 1
    (2, TType.STRING, 'topology_id', 'UTF8', None, ),  # 2
    (3, TType.LIST, 'executors', (TType.STRUCT, [ExecutorInfo, None], False), None, ),  # 3
    (4, TType.I32, 'port', None, None, ),  # 4
)
all_structs.append(LSTopoHistory)
LSTopoHistory.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'topology_id', 'UTF8', None, ),  # 1
    (2, TType.I64, 'time_stamp', None, None, ),  # 2
    (3, TType.LIST, 'users', (TType.STRING, 'UTF8', False), None, ),  # 3
    (4, TType.LIST, 'groups', (TType.STRING, 'UTF8', False), None, ),  # 4
)
all_structs.append(LSTopoHistoryList)
LSTopoHistoryList.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'topo_history', (TType.STRUCT, [LSTopoHistory, None], False), None, ),  # 1
)
all_structs.append(ProfileRequest)
ProfileRequest.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'nodeInfo', [NodeInfo, None], None, ),  # 1
    (2, TType.I32, 'action', None, None, ),  # 2
    (3, TType.I64, 'time_stamp', None, None, ),  # 3
)
all_structs.append(GetInfoOptions)
GetInfoOptions.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'num_err_choice', None, None, ),  # 1
)
all_structs.append(LogLevel)
LogLevel.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'action', None, None, ),  # 1
    (2, TType.STRING, 'target_log_level', 'UTF8', None, ),  # 2
    (3, TType.I32, 'reset_log_level_timeout_secs', None, None, ),  # 3
    (4, TType.I64, 'reset_log_level_timeout_epoch', None, None, ),  # 4
    (5, TType.STRING, 'reset_log_level', 'UTF8', None, ),  # 5
)
all_structs.append(LogConfig)
LogConfig.thrift_spec = (
    None,  # 0
    None,  # 1
    (2, TType.MAP, 'named_logger_level', (TType.STRING, 'UTF8', TType.STRUCT, [LogLevel, None], False), None, ),  # 2
)
all_structs.append(TopologyHistoryInfo)
TopologyHistoryInfo.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'topo_ids', (TType.STRING, 'UTF8', False), None, ),  # 1
)
all_structs.append(OwnerResourceSummary)
OwnerResourceSummary.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'owner', 'UTF8', None, ),  # 1
    (2, TType.I32, 'total_topologies', None, None, ),  # 2
    (3, TType.I32, 'total_executors', None, None, ),  # 3
    (4, TType.I32, 'total_workers', None, None, ),  # 4
    (5, TType.DOUBLE, 'memory_usage', None, None, ),  # 5
    (6, TType.DOUBLE, 'cpu_usage', None, None, ),  # 6
    (7, TType.DOUBLE, 'memory_guarantee', None, None, ),  # 7
    (8, TType.DOUBLE, 'cpu_guarantee', None, None, ),  # 8
    (9, TType.DOUBLE, 'memory_guarantee_remaining', None, None, ),  # 9
    (10, TType.DOUBLE, 'cpu_guarantee_remaining', None, None, ),  # 10
    (11, TType.I32, 'isolated_node_guarantee', None, None, ),  # 11
    (12, TType.I32, 'total_tasks', None, None, ),  # 12
    (13, TType.DOUBLE, 'requested_on_heap_memory', None, None, ),  # 13
    (14, TType.DOUBLE, 'requested_off_heap_memory', None, None, ),  # 14
    (15, TType.DOUBLE, 'requested_total_memory', None, None, ),  # 15
    (16, TType.DOUBLE, 'requested_cpu', None, None, ),  # 16
    (17, TType.DOUBLE, 'assigned_on_heap_memory', None, None, ),  # 17
    (18, TType.DOUBLE, 'assigned_off_heap_memory', None, None, ),  # 18
)
all_structs.append(SupervisorWorkerHeartbeat)
SupervisorWorkerHeartbeat.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'storm_id', 'UTF8', None, ),  # 1
    (2, TType.LIST, 'executors', (TType.STRUCT, [ExecutorInfo, None], False), None, ),  # 2
    (3, TType.I32, 'time_secs', None, None, ),  # 3
)
all_structs.append(SupervisorWorkerHeartbeats)
SupervisorWorkerHeartbeats.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'supervisor_id', 'UTF8', None, ),  # 1
    (2, TType.LIST, 'worker_heartbeats', (TType.STRUCT, [SupervisorWorkerHeartbeat, None], False), None, ),  # 2
)
all_structs.append(SupervisorAssignments)
SupervisorAssignments.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'storm_assignment', (TType.STRING, 'UTF8', TType.STRUCT, [Assignment, None], False), {
    }, ),  # 1
)
all_structs.append(WorkerMetricPoint)
WorkerMetricPoint.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'metricName', 'UTF8', None, ),  # 1
    (2, TType.I64, 'timestamp', None, None, ),  # 2
    (3, TType.DOUBLE, 'metricValue', None, None, ),  # 3
    (4, TType.STRING, 'componentId', 'UTF8', None, ),  # 4
    (5, TType.STRING, 'executorId', 'UTF8', None, ),  # 5
    (6, TType.STRING, 'streamId', 'UTF8', None, ),  # 6
)
all_structs.append(WorkerMetricList)
WorkerMetricList.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'metrics', (TType.STRUCT, [WorkerMetricPoint, None], False), None, ),  # 1
)
all_structs.append(WorkerMetrics)
WorkerMetrics.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'topologyId', 'UTF8', None, ),  # 1
    (2, TType.I32, 'port', None, None, ),  # 2
    (3, TType.STRING, 'hostname', 'UTF8', None, ),  # 3
    (4, TType.STRUCT, 'metricList', [WorkerMetricList, None], None, ),  # 4
)
all_structs.append(DRPCRequest)
DRPCRequest.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'func_args', 'UTF8', None, ),  # 1
    (2, TType.STRING, 'request_id', 'UTF8', None, ),  # 2
)
all_structs.append(DRPCExecutionException)
DRPCExecutionException.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'msg', 'UTF8', None, ),  # 1
    (2, TType.I32, 'type', None, None, ),  # 2
)
all_structs.append(HBPulse)
HBPulse.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'id', 'UTF8', None, ),  # 1
    (2, TType.STRING, 'details', 'BINARY', None, ),  # 2
)
all_structs.append(HBRecords)
HBRecords.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'pulses', (TType.STRUCT, [HBPulse, None], False), None, ),  # 1
)
all_structs.append(HBNodes)
HBNodes.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'pulseIds', (TType.STRING, 'UTF8', False), None, ),  # 1
)
all_structs.append(HBMessageData)
HBMessageData.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'path', 'UTF8', None, ),  # 1
    (2, TType.STRUCT, 'pulse', [HBPulse, None], None, ),  # 2
    (3, TType.BOOL, 'boolval', None, None, ),  # 3
    (4, TType.STRUCT, 'records', [HBRecords, None], None, ),  # 4
    (5, TType.STRUCT, 'nodes', [HBNodes, None], None, ),  # 5
    None,  # 6
    (7, TType.STRING, 'message_blob', 'BINARY', None, ),  # 7
)
all_structs.append(HBMessage)
HBMessage.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'type', None, None, ),  # 1
    (2, TType.STRUCT, 'data', [HBMessageData, None], None, ),  # 2
    (3, TType.I32, 'message_id', None, -1, ),  # 3
)
all_structs.append(HBAuthorizationException)
HBAuthorizationException.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'msg', 'UTF8', None, ),  # 1
)
all_structs.append(HBExecutionException)
HBExecutionException.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'msg', 'UTF8', None, ),  # 1
)
all_structs.append(WorkerTokenInfo)
WorkerTokenInfo.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'userName', 'UTF8', None, ),  # 1
    (2, TType.STRING, 'topologyId', 'UTF8', None, ),  # 2
    (3, TType.I64, 'secretVersion', None, None, ),  # 3
    (4, TType.I64, 'expirationTimeMillis', None, None, ),  # 4
)
all_structs.append(WorkerToken)
WorkerToken.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'serviceType', None, None, ),  # 1
    (2, TType.STRING, 'info', 'BINARY', None, ),  # 2
    (3, TType.STRING, 'signature', 'BINARY', None, ),  # 3
)
all_structs.append(PrivateWorkerKey)
PrivateWorkerKey.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'key', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'userName', 'UTF8', None, ),  # 2
    (3, TType.I64, 'expirationTimeMillis', None, None, ),  # 3
)
fix_spec(all_structs)
del all_structs
