/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.artifact;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.spark.JobArtifactState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.rpc.RpcEnvFileServer;
import org.apache.spark.sql.artifact.ArtifactStateForCleanup;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.CacheId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ArtifactManager$
implements Logging {
    public static final ArtifactManager$ MODULE$ = new ArtifactManager$();
    private static Path artifactRootDirectory;
    private static final String forwardToFSPrefix;
    private static final String ARTIFACT_DIRECTORY_PREFIX;
    private static final Cleaner org$apache$spark$sql$artifact$ArtifactManager$$cleaner;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        forwardToFSPrefix = "forward_to_fs";
        ARTIFACT_DIRECTORY_PREFIX = "artifacts";
        org$apache$spark$sql$artifact$ArtifactManager$$cleaner = Cleaner.create();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String forwardToFSPrefix() {
        return forwardToFSPrefix;
    }

    public String ARTIFACT_DIRECTORY_PREFIX() {
        return ARTIFACT_DIRECTORY_PREFIX;
    }

    private Path artifactRootDirectory$lzycompute() {
        ArtifactManager$ artifactManager$ = this;
        synchronized (artifactManager$) {
            if (!bitmap$0) {
                artifactRootDirectory = Utils$.MODULE$.createTempDir(this.ARTIFACT_DIRECTORY_PREFIX(), Utils$.MODULE$.createTempDir$default$2()).toPath();
                bitmap$0 = true;
            }
        }
        return artifactRootDirectory;
    }

    public Path artifactRootDirectory() {
        if (!bitmap$0) {
            return this.artifactRootDirectory$lzycompute();
        }
        return artifactRootDirectory;
    }

    public CacheId org$apache$spark$sql$artifact$ArtifactManager$$copyBlock(CacheId fromId, CacheId toId, BlockManager blockManager) {
        CacheId cacheId = fromId;
        CacheId cacheId2 = toId;
        Predef$.MODULE$.require(cacheId == null ? cacheId2 != null : !cacheId.equals(cacheId2));
        Option option = blockManager.getLocalBytes((BlockId)fromId);
        if (option instanceof Some) {
            Some some = (Some)option;
            BlockData blockData = (BlockData)some.value();
            Function0 & Serializable x$1 = (Function0 & Serializable)() -> {
                BlockManager.ByteBufferBlockStoreUpdater updater = new BlockManager.ByteBufferBlockStoreUpdater(blockManager, (BlockId)toId, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), blockData.toChunkedByteBuffer((Function1 & Serializable)x$1 -> ArtifactManager$.$anonfun$copyBlock$2(BoxesRunTime.unboxToInt((Object)x$1))), false, blockManager.ByteBufferBlockStoreUpdater().apply$default$6());
                updater.save();
                return toId;
            };
            JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> {
                blockManager.releaseLock((BlockId)fromId, blockManager.releaseLock$default$2());
                blockData.dispose();
            };
            JFunction0.mcV.sp & Serializable x$3 = (JFunction0.mcV.sp & Serializable)() -> Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$2(x$1);
            return (CacheId)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$1, (Function0)x$3, (Function0)x$2);
        }
        if (None$.MODULE$.equals(option)) {
            throw SparkException$.MODULE$.internalError("Block " + fromId + " not found in the block manager.");
        }
        throw new MatchError((Object)option);
    }

    public Cleaner org$apache$spark$sql$artifact$ArtifactManager$$cleaner() {
        return org$apache$spark$sql$artifact$ArtifactManager$$cleaner;
    }

    public void org$apache$spark$sql$artifact$ArtifactManager$$cleanUpGlobalResources(ArtifactStateForCleanup cleanupState) {
        Tuple4 tuple4 = new Tuple4((Object)cleanupState.sparkSessionUUID(), (Object)cleanupState.sparkContext(), (Object)cleanupState.jobArtifactState(), (Object)cleanupState.artifactPath());
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        String sparkSessionUUID = (String)tuple4._1();
        SparkContext sparkContext = (SparkContext)tuple4._2();
        JobArtifactState state = (JobArtifactState)tuple4._3();
        Path artifactPath = (Path)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)sparkSessionUUID, (Object)sparkContext, (Object)state, (Object)artifactPath);
        String sparkSessionUUID2 = (String)tuple42._1();
        SparkContext sparkContext2 = (SparkContext)tuple42._2();
        JobArtifactState state2 = (JobArtifactState)tuple42._3();
        Path artifactPath2 = (Path)tuple42._4();
        RpcEnvFileServer fileServer = SparkEnv$.MODULE$.get().rpcEnv().fileServer();
        if (state2 != null) {
            boolean shouldUpdateEnv;
            boolean bl = shouldUpdateEnv = sparkContext2.addedFiles().contains((Object)state2.uuid()) || sparkContext2.addedArchives().contains((Object)state2.uuid()) || sparkContext2.addedJars().contains((Object)state2.uuid());
            if (shouldUpdateEnv) {
                sparkContext2.addedFiles().remove((Object)state2.uuid()).foreach((Function1 & Serializable)x$6 -> {
                    ArtifactManager$.$anonfun$cleanUpGlobalResources$1(fileServer, x$6);
                    return BoxedUnit.UNIT;
                });
                sparkContext2.addedArchives().remove((Object)state2.uuid()).foreach((Function1 & Serializable)x$7 -> {
                    ArtifactManager$.$anonfun$cleanUpGlobalResources$3(fileServer, x$7);
                    return BoxedUnit.UNIT;
                });
                sparkContext2.addedJars().remove((Object)state2.uuid()).foreach((Function1 & Serializable)x$8 -> {
                    ArtifactManager$.$anonfun$cleanUpGlobalResources$5(fileServer, x$8);
                    return BoxedUnit.UNIT;
                });
                sparkContext2.postEnvironmentUpdate();
            }
        }
        BlockManager blockManager = sparkContext2.env().blockManager();
        blockManager.removeCache(sparkSessionUUID2);
        try {
            FileUtils.deleteDirectory((File)artifactPath2.toFile());
        }
        catch (IOException e) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete directory ", ": "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)artifactPath2.toFile())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXCEPTION$.MODULE$, (Object)e.getMessage())})))), (Throwable)e);
        }
    }

    public static final /* synthetic */ ByteBuffer $anonfun$copyBlock$2(int x$1) {
        return ByteBuffer.allocate(x$1);
    }

    public static final /* synthetic */ void $anonfun$cleanUpGlobalResources$1(RpcEnvFileServer fileServer$1, scala.collection.concurrent.Map x$6) {
        x$6.keys().foreach((Function1 & Serializable)key -> {
            fileServer$1.removeFile(key);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$cleanUpGlobalResources$3(RpcEnvFileServer fileServer$1, scala.collection.concurrent.Map x$7) {
        x$7.keys().foreach((Function1 & Serializable)key -> {
            fileServer$1.removeFile(key);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$cleanUpGlobalResources$5(RpcEnvFileServer fileServer$1, scala.collection.concurrent.Map x$8) {
        x$8.keys().foreach((Function1 & Serializable)key -> {
            fileServer$1.removeJar(key);
            return BoxedUnit.UNIT;
        });
    }

    private ArtifactManager$() {
    }
}

