/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.CollationAwareUTF8String;
import org.apache.spark.sql.internal.types.StringTypeNonCSAICollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`. Both `pairDelim` and `keyValueDelim` are treated as regular expressions.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       {\"a\":\"1\",\"b\":\"2\",\"c\":\"3\"}\n      > SELECT _FUNC_('a');\n       {\"a\":null}\n  ", since="2.0.1", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0005c\u0001B\u0015+\u0001^B\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005'\"Aq\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003T\u0011!I\u0006A!f\u0001\n\u0003\u0011\u0006\u0002\u0003.\u0001\u0005#\u0005\u000b\u0011B*\t\u000bm\u0003A\u0011\u0001/\t\u000b\u0005\u0004A\u0011\t2\t\u000bm\u0003A\u0011\u00014\t\u000bm\u0003A\u0011\u00016\t\u000b1\u0004A\u0011\t2\t\u000b5\u0004A\u0011\t*\t\u000b9\u0004A\u0011\t*\t\u000b=\u0004A\u0011\t*\t\u000bA\u0004A\u0011I9\t\u000bm\u0004A\u0011\t?\t\u0015\u0005\u0005\u0001\u0001#b\u0001\n\u0013\t\u0019\u0001\u0003\u0006\u0002\u0012\u0001A)\u0019!C\u0007\u0003'Aq!a\u0007\u0001\t\u0003\ni\u0002C\u0004\u00022\u0001!\t&a\r\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!9\u00111\r\u0001\u0005R\u0005\u0015\u0004\"CA:\u0001\u0005\u0005I\u0011AA;\u0011%\ti\bAI\u0001\n\u0003\ty\bC\u0005\u0002\u0016\u0002\t\n\u0011\"\u0001\u0002\u0000!I\u0011q\u0013\u0001\u0012\u0002\u0013\u0005\u0011q\u0010\u0005\n\u00033\u0003\u0011\u0011!C!\u00037C\u0011\"a+\u0001\u0003\u0003%\t!a\u0005\t\u0013\u00055\u0006!!A\u0005\u0002\u0005=\u0006\"CA[\u0001\u0005\u0005I\u0011IA\\\u0011%\t)\rAA\u0001\n\u0003\t9\rC\u0005\u0002L\u0002\t\t\u0011\"\u0011\u0002N\"I\u0011\u0011\u001b\u0001\u0002\u0002\u0013\u0005\u00131[\u0004\n\u0003oT\u0013\u0011!E\u0001\u0003s4\u0001\"\u000b\u0016\u0002\u0002#\u0005\u00111 \u0005\u00077\u000e\"\tAa\u0005\t\u0013\tU1%!A\u0005F\t]\u0001\"\u0003B\rG\u0005\u0005I\u0011\u0011B\u000e\u0011%\u0011\u0019cIA\u0001\n\u0003\u0013)\u0003C\u0005\u00038\r\n\t\u0011\"\u0003\u0003:\tY1\u000b\u001e:j]\u001e$v.T1q\u0015\tYC&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0017/\u0003!\u0019\u0017\r^1msN$(BA\u00181\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003cI\nQa\u001d9be.T!a\r\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0014aA8sO\u000e\u00011#\u0002\u00019y}*\u0005CA\u001d;\u001b\u0005Q\u0013BA\u001e+\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003suJ!A\u0010\u0016\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015IA\u0004Qe>$Wo\u0019;\u0011\u0005\u0019seBA$M\u001d\tA5*D\u0001J\u0015\tQe'\u0001\u0004=e>|GOP\u0005\u0002\u0005&\u0011Q*Q\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0005K\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002N\u0003\u0006!A/\u001a=u+\u0005\u0019\u0006CA\u001dU\u0013\t)&F\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001^3yi\u0002\n\u0011\u0002]1je\u0012+G.[7\u0002\u0015A\f\u0017N\u001d#fY&l\u0007%A\u0007lKf4\u0016\r\\;f\t\u0016d\u0017.\\\u0001\u000fW\u0016Lh+\u00197vK\u0012+G.[7!\u0003\u0019a\u0014N\\5u}Q!QLX0a!\tI\u0004\u0001C\u0003R\u000f\u0001\u00071\u000bC\u0003X\u000f\u0001\u00071\u000bC\u0003Z\u000f\u0001\u00071+\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0016\u0003\r\u0004\"\u0001\u00113\n\u0005\u0015\f%a\u0002\"p_2,\u0017M\u001c\u000b\u0004;\u001eL\u0007\"\u00025\n\u0001\u0004\u0019\u0016!B2iS2$\u0007\"B,\n\u0001\u0004\u0019FCA/l\u0011\u0015A'\u00021\u0001T\u0003!\u0019H/\u0019;fMVd\u0017!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u001d\t\u0004\rN,\u0018B\u0001;Q\u0005\r\u0019V-\u001d\t\u0003mfl\u0011a\u001e\u0006\u0003q:\nQ\u0001^=qKNL!A_<\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003u\u0004\"A\u001e@\n\u0005}<(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00155\f\u0007OQ;jY\u0012,'/\u0006\u0002\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f1\nA!\u001e;jY&!\u0011qBA\u0005\u0005Q\t%O]1z\u0005\u0006\u001cX\rZ'ba\n+\u0018\u000e\u001c3fe\u0006Y1m\u001c7mCRLwN\\%e+\t\t)\u0002E\u0002A\u0003/I1!!\u0007B\u0005\rIe\u000e^\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\t\u0003?\t)#!\u000b\u0002.A\u0019\u0001)!\t\n\u0007\u0005\r\u0012IA\u0002B]fDq!a\n\u0014\u0001\u0004\ty\"A\u0006j]B,Ho\u0015;sS:<\u0007bBA\u0016'\u0001\u0007\u0011qD\u0001\u0010gR\u0014\u0018N\\4EK2LW.\u001b;fe\"9\u0011qF\nA\u0002\u0005}\u0011!E6fsZ\u000bG.^3EK2LW.\u001b;fe\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003k\t\t%a\u0013\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f+\u0003\u001d\u0019w\u000eZ3hK:LA!a\u0010\u0002:\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002DQ\u0001\r!!\u0012\u0002\u0007\r$\b\u0010\u0005\u0003\u00028\u0005\u001d\u0013\u0002BA%\u0003s\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002NQ\u0001\r!!\u000e\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u00111\u000b\t\u0005\u0003+\niF\u0004\u0003\u0002X\u0005e\u0003C\u0001%B\u0013\r\tY&Q\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0013\u0011\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005m\u0013)A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR91+a\u001a\u0002l\u0005=\u0004BBA5-\u0001\u00071+\u0001\u0005oK^4\u0015N]:u\u0011\u0019\tiG\u0006a\u0001'\u0006Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0007\u0003c2\u0002\u0019A*\u0002\u00119,w\u000f\u00165je\u0012\fAaY8qsR9Q,a\u001e\u0002z\u0005m\u0004bB)\u0018!\u0003\u0005\ra\u0015\u0005\b/^\u0001\n\u00111\u0001T\u0011\u001dIv\u0003%AA\u0002M\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0002*\u001a1+a!,\u0005\u0005\u0015\u0005\u0003BAD\u0003#k!!!#\u000b\t\u0005-\u0015QR\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a$B\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\u000bIIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\n\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\t1\fgn\u001a\u0006\u0003\u0003O\u000bAA[1wC&!\u0011qLAQ\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\b\u00022\"I\u00111W\u000f\u0002\u0002\u0003\u0007\u0011QC\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0006CBA^\u0003\u0003\fy\"\u0004\u0002\u0002>*\u0019\u0011qX!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002D\u0006u&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2aYAe\u0011%\t\u0019lHA\u0001\u0002\u0004\ty\"\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAO\u0003\u001fD\u0011\"a-!\u0003\u0003\u0005\r!!\u0006\u0002\r\u0015\fX/\u00197t)\r\u0019\u0017Q\u001b\u0005\n\u0003g\u000b\u0013\u0011!a\u0001\u0003?A3\u0003AAm\u0003?\f\t/!:\u0002h\u0006-\u0018Q^Ay\u0003g\u00042!OAn\u0013\r\tiN\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019/\u0001B\f?\u001a+fjQ0)i\u0016DHo\u0017\u0017!a\u0006L'\u000fR3mS6\\F\u0006I6fsZ\u000bG.^3EK2LW.X/*A5\u00023I]3bi\u0016\u001c\b%\u0019\u0011nCB\u0004\u0013M\u001a;fe\u0002\u001a\b\u000f\\5ui&tw\r\t;iK\u0002\"X\r\u001f;!S:$x\u000eI6fs>2\u0018\r\\;fAA\f\u0017N]:!kNLgn\u001a\u0011eK2LW.\u001b;feNt\u0003\u0005R3gCVdG\u000f\t3fY&l\u0017\u000e^3sg\u0002\n'/\u001a\u0011(Y\u001d\u0002cm\u001c:!AB\f\u0017N\u001d#fY&l\u0007\rI1oI\u0002:#h\n\u0011g_J\u0004\u0003m[3z-\u0006dW/\u001a#fY&l\u0007M\f\u0011C_RD\u0007\u0005\u00199bSJ$U\r\\5nA\u0002\ng\u000e\u001a\u0011aW\u0016Lh+\u00197vK\u0012+G.[7aA\u0005\u0014X\r\t;sK\u0006$X\r\u001a\u0011bg\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8t]\u0005AQ\r_1na2,7/\t\u0002\u0002j\u0006\t\tC\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(Cj\nDF\u0019\u001e3Y\rT4g\n\u0017!O1:C\u0006I\u0014;O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012bEi\u0012\u0013G\t\u0017#E\nR$E\r\u0012-E\r\u0014#HI\u001a#{*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%Y\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;]VdG. \u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011q^\u0001\u0006e9\u0002d&M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003k\f\u0011\"\\1q?\u001a,hnY:\u0002\u0017M#(/\u001b8h)>l\u0015\r\u001d\t\u0003s\r\u001aRaIA\u007f\u0005\u0013\u0001\u0002\"a@\u0003\u0006M\u001b6+X\u0007\u0003\u0005\u0003Q1Aa\u0001B\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0002\u0003\u0002\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\t-!\u0011C\u0007\u0003\u0005\u001bQAAa\u0004\u0002&\u0006\u0011\u0011n\\\u0005\u0004\u001f\n5ACAA}\u0003!!xn\u0015;sS:<GCAAO\u0003\u0015\t\u0007\u000f\u001d7z)\u001di&Q\u0004B\u0010\u0005CAQ!\u0015\u0014A\u0002MCQa\u0016\u0014A\u0002MCQ!\u0017\u0014A\u0002M\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003(\tM\u0002#\u0002!\u0003*\t5\u0012b\u0001B\u0016\u0003\n1q\n\u001d;j_:\u0004b\u0001\u0011B\u0018'N\u001b\u0016b\u0001B\u0019\u0003\n1A+\u001e9mKNB\u0001B!\u000e(\u0003\u0003\u0005\r!X\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u001e!\u0011\tyJ!\u0010\n\t\t}\u0012\u0011\u0015\u0002\u0007\u001f\nTWm\u0019;")
public class StringToMap
extends TernaryExpression
implements ExpectsInputTypes,
Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private int collationId;
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap x$0) {
        return StringToMap$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public Expression first() {
        return this.text();
    }

    @Override
    public Expression second() {
        return this.pairDelim();
    }

    @Override
    public Expression third() {
        return this.keyValueDelim();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$, (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$, (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(this.first().dataType(), this.first().dataType());
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.first().dataType(), this.first().dataType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.mapBuilder$lzycompute();
        }
        return this.mapBuilder;
    }

    private int collationId$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.collationId = ((StringType)this.text().dataType()).collationId();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.collationId;
    }

    private final int collationId() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = CollationAwareUTF8String.splitSQL((UTF8String)((UTF8String)inputString), (UTF8String)((UTF8String)stringDelimiter), (int)-1, (int)this.collationId());
        UTF8String keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter;
        for (int i = 0; i < keyValues.length; ++i) {
            UTF8String[] keyValueArray = CollationAwareUTF8String.splitSQL((UTF8String)keyValues[i], (UTF8String)keyValueDelimiterUTF8String, (int)2, (int)this.collationId());
            UTF8String key = keyValueArray[0];
            UTF8String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            this.mapBuilder().put(key, value);
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        String keyValues = ctx.freshName("kvs");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(text, pd, kvd) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |UTF8String[] " + keyValues + " = CollationAwareUTF8String.splitSQL(" + text + ", " + pd + ", -1, " + this.collationId() + ");\n         |for(UTF8String kvEntry: " + keyValues + ") {\n         |  UTF8String[] kv = CollationAwareUTF8String.splitSQL(kvEntry, " + kvd + ", 2, " + this.collationId() + ");\n         |  " + builderTerm + ".put(kv[0], kv.length == 2 ? kv[1] : null);\n         |}\n         |" + ev.value() + " = " + builderTerm + ".build();\n         |")));
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.text();
            }
            case 1: {
                return this.pairDelim();
            }
            case 2: {
                return this.keyValueDelim();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "text";
            }
            case 1: {
                return "pairDelim";
            }
            case 2: {
                return "keyValueDelim";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.create(":", (DataType)StringType$.MODULE$));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.create(",", (DataType)StringType$.MODULE$), Literal$.MODULE$.create(":", (DataType)StringType$.MODULE$));
    }
}

