/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.ExecuteKey;
import org.apache.spark.sql.connect.service.ExecuteKey$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf!B\u000e\u001d\u0001yA\u0003\"B\u001b\u0001\t\u00039\u0004b\u0002\u001e\u0001\u0005\u0004%Ia\u000f\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002\u001f\t\u000f5\u0003!\u0019!C\u0005\u001d\"1a\f\u0001Q\u0001\n=Cqa\u0018\u0001A\u0002\u0013%\u0001\rC\u0004h\u0001\u0001\u0007I\u0011\u00025\t\r9\u0004\u0001\u0015)\u0003b\u0011\u001dy\u0007\u00011A\u0005\nADqa\u001e\u0001A\u0002\u0013%\u0001\u0010\u0003\u0004{\u0001\u0001\u0006K!\u001d\u0005\u0007w\u0002!\tA\b?\t\u0011\u00055\u0001\u0001\"\u0001\u001f\u0003\u001fA!\"a\b\u0001#\u0003%\tAHA\u0011\u0011!\t9\u0004\u0001C\u0001=\u0005e\u0002\u0002CA\"\u0001\u0011\u0005a$!\u0012\t\u0011\u0005=\u0003\u0001\"\u0001\u001f\u0003#Bq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002\u0000\u0001!\t!!!\t\u0011\u0005\r\u0005\u0001\"\u0001\u001f\u0003\u000bCq!a\"\u0001\t\u0013\t)\tC\u0004\u0002\n\u0002!I!!\"\t\u0011\u0005-\u0005\u0001\"\u0001\u001f\u0003\u001bC\u0001\"a%\u0001\t\u0003q\u0012Q\u0013\u0005\t\u00037\u0003A\u0011\u0001\u0010\u0002\u0006\"A\u0011Q\u0014\u0001\u0005\u0002y\tyJ\u0001\u000fTa\u0006\u00148nQ8o]\u0016\u001cG/\u0012=fGV$\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005uq\u0012aB:feZL7-\u001a\u0006\u0003?\u0001\nqaY8o]\u0016\u001cGO\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c2\u0001A\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011\u0001gM\u0007\u0002c)\u0011!GI\u0001\tS:$XM\u001d8bY&\u0011A'\r\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u001d\u0011\u0005e\u0002Q\"\u0001\u000f\u0002\u0015\u0015DXmY;uS>t7/F\u0001=!\u0011iDIR%\u000e\u0003yR!a\u0010!\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002B\u0005\u0006!Q\u000f^5m\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!!\u0012 \u0003\u001b\r{gnY;se\u0016tG/T1q!\tIt)\u0003\u0002I9\tQQ\t_3dkR,7*Z=\u0011\u0005eR\u0015BA&\u001d\u00055)\u00050Z2vi\u0016Du\u000e\u001c3fe\u0006YQ\r_3dkRLwN\\:!\u0003M\t'-\u00198e_:,G\rV8nEN$xN\\3t+\u0005y\u0005\u0003\u0002)Z\rnk\u0011!\u0015\u0006\u0003%N\u000bQaY1dQ\u0016T!\u0001V+\u0002\r\r|W.\\8o\u0015\t1v+\u0001\u0004h_><G.\u001a\u0006\u00021\u0006\u00191m\\7\n\u0005i\u000b&!B\"bG\",\u0007CA\u001d]\u0013\tiFDA\u0006Fq\u0016\u001cW\u000f^3J]\u001a|\u0017\u0001F1cC:$wN\\3e)>l'm\u001d;p]\u0016\u001c\b%A\nmCN$X\t_3dkRLwN\u001c+j[\u0016t5/F\u0001b!\t\u0011W-D\u0001d\u0015\t!g(\u0001\u0004bi>l\u0017nY\u0005\u0003M\u000e\u0014!\"\u0011;p[&\u001cGj\u001c8h\u0003]a\u0017m\u001d;Fq\u0016\u001cW\u000f^5p]RKW.\u001a(t?\u0012*\u0017\u000f\u0006\u0002jYB\u0011!F[\u0005\u0003W.\u0012A!\u00168ji\"9QnBA\u0001\u0002\u0004\t\u0017a\u0001=%c\u0005!B.Y:u\u000bb,7-\u001e;j_:$\u0016.\\3Og\u0002\n\u0011c]2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s+\u0005\t\bc\u00012si&\u00111o\u0019\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u0011Q(^\u0005\u0003mz\u0012\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003U\u00198\r[3ek2,G-\u0012=fGV$xN]0%KF$\"![=\t\u000f5T\u0011\u0011!a\u0001c\u0006\u00112o\u00195fIVdW\rZ#yK\u000e,Ho\u001c:!\u0003M\u0019'/Z1uK\u0016CXmY;uK\"{G\u000eZ3s)\tIU\u0010C\u0003\u007f\u0019\u0001\u0007q0A\u0004sKF,Xm\u001d;\u0011\t\u0005\u0005\u0011\u0011B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005)\u0001O]8u_*\u0011qDI\u0005\u0005\u0003\u0017\t\u0019A\u0001\nFq\u0016\u001cW\u000f^3QY\u0006t'+Z9vKN$\u0018a\u0005:f[>4X-\u0012=fGV$X\rS8mI\u0016\u0014H#B5\u0002\u0012\u0005U\u0001BBA\n\u001b\u0001\u0007a)A\u0002lKfD\u0011\"a\u0006\u000e!\u0003\u0005\r!!\u0007\u0002\u0013\u0005\u0014\u0017M\u001c3p]\u0016$\u0007c\u0001\u0016\u0002\u001c%\u0019\u0011QD\u0016\u0003\u000f\t{w\u000e\\3b]\u0006i\"/Z7pm\u0016,\u00050Z2vi\u0016Du\u000e\u001c3fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002$)\"\u0011\u0011DA\u0013W\t\t9\u0003\u0005\u0003\u0002*\u0005MRBAA\u0016\u0015\u0011\ti#a\f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0019W\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00121\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E4fi\u0016CXmY;uK\"{G\u000eZ3s)\u0011\tY$!\u0011\u0011\t)\ni$S\u0005\u0004\u0003\u007fY#AB(qi&|g\u000e\u0003\u0004\u0002\u0014=\u0001\rAR\u0001\u001ee\u0016lwN^3BY2,\u00050Z2vi&|gn\u001d$peN+7o]5p]R\u0019\u0011.a\u0012\t\u000f\u0005M\u0001\u00031\u0001\u0002JA\u0019\u0011(a\u0013\n\u0007\u00055CD\u0001\u0006TKN\u001c\u0018n\u001c8LKf\fQcZ3u\u0003\n\fg\u000eZ8oK\u0012$v.\u001c2ti>tW\r\u0006\u0003\u0002T\u0005U\u0003\u0003\u0002\u0016\u0002>mCa!a\u0005\u0012\u0001\u00041\u0015\u0001\u00067jgR\f5\r^5wK\u0016CXmY;uS>t7/\u0006\u0002\u0002\\AA\u0011QLA7\u0003g\nIH\u0004\u0003\u0002`\u0005%d\u0002BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015d'\u0001\u0004=e>|GOP\u0005\u0002Y%\u0019\u00111N\u0016\u0002\u000fA\f7m[1hK&!\u0011qNA9\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u00111N\u0016\u0011\u0007)\n)(C\u0002\u0002x-\u0012A\u0001T8oOB)\u0011QLA>7&!\u0011QPA9\u0005\r\u0019V-]\u0001\u0018Y&\u001cH/\u00112b]\u0012|g.\u001a3Fq\u0016\u001cW\u000f^5p]N,\"!!\u001f\u0002\u0011MDW\u000f\u001e3po:$\u0012![\u0001\u0018kB$\u0017\r^3MCN$X\t_3dkRLwN\u001c+j[\u0016\fac]2iK\u0012,H.\u001a)fe&|G-[2DQ\u0016\u001c7n]\u0001\u0014a\u0016\u0014\u0018n\u001c3jG6\u000b\u0017N\u001c;f]\u0006t7-\u001a\u000b\u0004S\u0006=\u0005bBAI/\u0001\u0007\u00111O\u0001\ni&lWm\\;u\u001dN\f!c]3u\u00032d'\u000bU\"t\t\u0016\fG\r\\5oKR\u0019\u0011.a&\t\u000f\u0005e\u0005\u00041\u0001\u0002t\u0005QA-Z1eY&tWMT:\u0002!%tG/\u001a:skB$\u0018\t\u001c7S!\u000e\u001b\u0018A\u00057jgR,\u00050Z2vi\u0016Du\u000e\u001c3feN,\"!!)\u0011\u000b\u0005u\u00131P%")
public class SparkConnectExecutionManager
implements Logging {
    private final ConcurrentMap<ExecuteKey, ExecuteHolder> executions;
    private final Cache<ExecuteKey, ExecuteInfo> abandonedTombstones;
    private AtomicLong lastExecutionTimeNs;
    private AtomicReference<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<ExecuteKey, ExecuteHolder> executions() {
        return this.executions;
    }

    private Cache<ExecuteKey, ExecuteInfo> abandonedTombstones() {
        return this.abandonedTombstones;
    }

    private AtomicLong lastExecutionTimeNs() {
        return this.lastExecutionTimeNs;
    }

    private void lastExecutionTimeNs_$eq(AtomicLong x$1) {
        this.lastExecutionTimeNs = x$1;
    }

    private AtomicReference<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void scheduledExecutor_$eq(AtomicReference<ScheduledExecutorService> x$1) {
        this.scheduledExecutor = x$1;
    }

    public ExecuteHolder createExecuteHolder(ExecutePlanRequest request) {
        Some some;
        boolean bl = request.hasClientObservedServerSideSessionId();
        if (bl) {
            some = new Some((Object)request.getClientObservedServerSideSessionId());
        } else if (!bl) {
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        Some previousSessionId = some;
        SessionHolder sessionHolder = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(request.getUserContext().getUserId(), request.getSessionId(), (Option<String>)previousSessionId);
        ExecuteKey executeKey2 = ExecuteKey$.MODULE$.apply(request, sessionHolder);
        ExecuteHolder executeHolder = this.executions().compute(executeKey2, (executeKey, oldExecuteHolder) -> {
            if (oldExecuteHolder != null) {
                throw new SparkSQLException("INVALID_HANDLE.OPERATION_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)executeKey.operationId())})));
            }
            if (this.getAbandonedTombstone((ExecuteKey)executeKey).isDefined()) {
                throw new SparkSQLException("INVALID_HANDLE.OPERATION_ABANDONED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)executeKey.operationId())})));
            }
            return new ExecuteHolder((ExecuteKey)executeKey, request, sessionHolder);
        });
        sessionHolder.addOperationId(executeHolder.operationId());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ExecuteHolder ", " is created."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_KEY$.MODULE$, (Object)executeHolder.key())}))));
        this.schedulePeriodicChecks();
        return executeHolder;
    }

    public void removeExecuteHolder(ExecuteKey key, boolean abandoned) {
        ExecuteHolder executeHolder = (ExecuteHolder)this.executions().get(key);
        if (executeHolder == null) {
            return;
        }
        if (abandoned) {
            this.abandonedTombstones().put(key, executeHolder.getExecuteInfo());
        }
        this.executions().remove(key);
        executeHolder.sessionHolder().removeOperationId(executeHolder.operationId());
        this.updateLastExecutionTime();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ExecuteHolder ", " is removed."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_KEY$.MODULE$, (Object)key)}))));
        executeHolder.close();
        if (abandoned) {
            this.abandonedTombstones().put(key, executeHolder.getExecuteInfo());
            return;
        }
    }

    public boolean removeExecuteHolder$default$2() {
        return false;
    }

    public Option<ExecuteHolder> getExecuteHolder(ExecuteKey key) {
        return Option$.MODULE$.apply(this.executions().get(key));
    }

    public void removeAllExecutionsForSession(SessionKey key) {
        this.executions().forEach((x$1, executeHolder) -> {
            SessionKey sessionKey = executeHolder.sessionHolder().key();
            SessionKey sessionKey2 = key;
            if (!(sessionKey != null ? !((Object)sessionKey).equals(sessionKey2) : sessionKey2 != null)) {
                ExecuteInfo info = executeHolder.getExecuteInfo();
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Execution ", " removed in removeSessionExecutions."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_INFO$.MODULE$, (Object)info)}))));
                this.removeExecuteHolder(executeHolder.key(), true);
                return;
            }
        });
    }

    public Option<ExecuteInfo> getAbandonedTombstone(ExecuteKey key) {
        return Option$.MODULE$.apply((Object)this.abandonedTombstones().getIfPresent(key));
    }

    public Either<Object, Seq<ExecuteInfo>> listActiveExecutions() {
        if (this.executions().isEmpty()) {
            return new Left((Object)BoxesRunTime.boxToLong((long)this.lastExecutionTimeNs().getAcquire()));
        }
        return new Right((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().map((Function1 & Serializable)x$2 -> x$2.getExecuteInfo())).toBuffer().toSeq());
    }

    public Seq<ExecuteInfo> listAbandonedExecutions() {
        return CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.abandonedTombstones().asMap()).asScala().values().toSeq();
    }

    public void shutdown() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAndSet(null);
        if (executor != null) {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)executor, (Duration)FiniteDuration$.MODULE$.apply(1L, TimeUnit.MINUTES));
        }
        this.executions().clear();
        this.abandonedTombstones().invalidateAll();
        this.updateLastExecutionTime();
    }

    private void updateLastExecutionTime() {
        this.lastExecutionTimeNs().getAndUpdate(prev -> RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(prev), System.nanoTime()));
    }

    private void schedulePeriodicChecks() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAcquire();
        if (executor == null) {
            executor = Executors.newSingleThreadScheduledExecutor();
            if (this.scheduledExecutor().compareAndExchangeRelease(null, executor) == null) {
                long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_MAINTENANCE_INTERVAL()));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting thread for cleanup of abandoned executions every "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToLong((long)interval))})))));
                executor.scheduleAtFixedRate(() -> {
                    try {
                        long timeoutNs = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_DETACHED_TIMEOUT())) * 1000000L;
                        this.periodicMaintenance(timeoutNs);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", throwable2);
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
    }

    public void periodicMaintenance(long timeoutNs) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectExecutionManager maintenance.");
        long nowNs = System.nanoTime();
        this.executions().forEach((x$3, executeHolder) -> {
            Option<Object> option = executeHolder.lastAttachedRpcTimeNs();
            if (option instanceof Some) {
                Some some = (Some)option;
                long detachedNs = BoxesRunTime.unboxToLong((Object)some.value());
                if (detachedNs + timeoutNs <= nowNs) {
                    ExecuteInfo info = executeHolder.getExecuteInfo();
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found execution ", " that was abandoned "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_INFO$.MODULE$, (Object)info)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and expired and will be removed."}))).log((Seq)Nil$.MODULE$))));
                    this.removeExecuteHolder(executeHolder.key(), true);
                    return;
                }
                return;
            }
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectExecutionManager maintenance.");
    }

    public void setAllRPCsDeadline(long deadlineNs) {
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().foreach((Function1 & Serializable)x$4 -> {
            x$4.setGrpcResponseSendersDeadline(deadlineNs);
            return BoxedUnit.UNIT;
        });
    }

    public void interruptAllRPCs() {
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().foreach((Function1 & Serializable)x$5 -> {
            x$5.interruptGrpcResponseSenders();
            return BoxedUnit.UNIT;
        });
    }

    public Seq<ExecuteHolder> listExecuteHolders() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().toSeq();
    }

    public SparkConnectExecutionManager() {
        Logging.$init$((Logging)this);
        this.executions = new ConcurrentHashMap<ExecuteKey, ExecuteHolder>();
        this.abandonedTombstones = CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_ABANDONED_TOMBSTONES_SIZE()))).build();
        this.lastExecutionTimeNs = new AtomicLong(System.nanoTime());
        this.scheduledExecutor = new AtomicReference();
    }
}

