/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import io.netty.channel.unix.Errors;
import jakarta.ws.rs.core.UriBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.spark.ReadOnlySparkConf;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.Streaming$;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.Worker$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.security.GroupMappingServiceProvider;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.status.api.v1.StackTrace;
import org.apache.spark.status.api.v1.ThreadStackTrace;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.CallSite$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.SignalUtils$;
import org.apache.spark.util.SparkClassUtils;
import org.apache.spark.util.SparkEnvUtils;
import org.apache.spark.util.SparkErrorUtils;
import org.apache.spark.util.SparkFileUtils;
import org.apache.spark.util.SparkSerDeUtils;
import org.apache.spark.util.SparkStreamUtils;
import org.apache.spark.util.SparkStringUtils;
import org.apache.spark.util.SparkUncaughtExceptionHandler;
import org.apache.spark.util.SparkUncaughtExceptionHandler$;
import org.apache.spark.util.Utils;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBufferOutputStream;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.CacheBuilder;
import org.sparkproject.guava.cache.CacheLoader;
import org.sparkproject.guava.cache.LoadingCache;
import org.sparkproject.guava.collect.Interner;
import org.sparkproject.guava.collect.Interners;
import org.sparkproject.guava.io.ByteStreams;
import org.sparkproject.guava.io.Files;
import org.sparkproject.guava.net.InetAddresses;
import org.sparkproject.jetty.util.MultiException;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyBoolean;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger$;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class Utils$
implements SparkClassUtils,
SparkEnvUtils,
SparkErrorUtils,
SparkFileUtils,
SparkSerDeUtils,
SparkStreamUtils,
SparkStringUtils {
    public static final Utils$ MODULE$ = new Utils$();
    private static InetAddress localIpAddress;
    private static Tuple2<LoggerContext, LoggerConfig> getLogContext;
    private static boolean isG1GC;
    private static final SparkUncaughtExceptionHandler sparkUncaughtExceptionHandler;
    private static volatile String cachedLocalDir;
    private static final int DEFAULT_DRIVER_MEM_MB;
    private static final int MAX_DIR_CREATION_ATTEMPTS;
    private static volatile String[] localRootDirs;
    private static final String LOCAL_SCHEME;
    private static final Interner<String> weakStringInterner;
    private static final Regex PATTERN_FOR_COMMAND_LINE_ARG;
    private static final int COPY_BUFFER_LEN;
    private static final ThreadLocal<byte[]> copyBuffer;
    private static Option<String> customHostname;
    private static final ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults;
    private static final long[] siByteSizes;
    private static final String[] siByteSuffixes;
    private static final String TRY_WITH_CALLER_STACKTRACE_FULL_STACKTRACE;
    private static final Regex SPARK_CORE_CLASS_REGEX;
    private static final Regex SPARK_SQL_CLASS_REGEX;
    private static LoadingCache<String, Long> compressedLogFileLengthCache;
    private static final boolean isWindows;
    private static final boolean isMac;
    private static final boolean isJavaVersionAtLeast21;
    private static final boolean isMacOnAppleSilicon;
    private static final boolean preferIPv6;
    private static final Regex windowsDrive;
    private static final Set<String> EMPTY_USER_GROUPS;
    private static final String BACKUP_STANDALONE_MASTER_PREFIX;
    private static final String REDACTION_REPLACEMENT_TEXT;
    private static final Regex fullWidthRegex;
    private static Random random;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile byte bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        SparkClassUtils.$init$((SparkClassUtils)MODULE$);
        SparkEnvUtils.$init$((SparkEnvUtils)MODULE$);
        SparkErrorUtils.$init$((SparkErrorUtils)MODULE$);
        SparkFileUtils.$init$((SparkFileUtils)MODULE$);
        SparkSerDeUtils.$init$((SparkSerDeUtils)MODULE$);
        SparkStreamUtils.$init$((SparkStreamUtils)MODULE$);
        SparkStringUtils.$init$((SparkStringUtils)MODULE$);
        sparkUncaughtExceptionHandler = new SparkUncaughtExceptionHandler(SparkUncaughtExceptionHandler$.MODULE$.$lessinit$greater$default$1());
        cachedLocalDir = "";
        DEFAULT_DRIVER_MEM_MB = 1024;
        MAX_DIR_CREATION_ATTEMPTS = 10;
        localRootDirs = null;
        LOCAL_SCHEME = "local";
        weakStringInterner = Interners.newWeakInterner();
        PATTERN_FOR_COMMAND_LINE_ARG = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("-D(.+?)=(.+)"));
        COPY_BUFFER_LEN = 1024;
        copyBuffer = ThreadLocal.withInitial(() -> new byte[MODULE$.COPY_BUFFER_LEN()]);
        customHostname = scala.sys.package$.MODULE$.env().get((Object)"SPARK_LOCAL_HOSTNAME");
        hostPortParseResults = new ConcurrentHashMap();
        siByteSizes = new long[]{0x1000000000000000L, 0x4000000000000L, 0x10000000000L, 0x40000000L, 0x100000L, 1024L, 1L};
        siByteSuffixes = (String[])((Object[])new String[]{"EiB", "PiB", "TiB", "GiB", "MiB", "KiB", "B"});
        TRY_WITH_CALLER_STACKTRACE_FULL_STACKTRACE = "Full stacktrace of original doTryWithCallerStacktrace caller";
        SPARK_CORE_CLASS_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^org\\.apache\\.spark(\\.api\\.java)?(\\.util)?(\\.rdd)?(\\.broadcast)?\\.[A-Z]"));
        SPARK_SQL_CLASS_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^org\\.apache\\.spark\\.sql.*"));
        compressedLogFileLengthCache = null;
        isWindows = SystemUtils.IS_OS_WINDOWS;
        isMac = SystemUtils.IS_OS_MAC_OSX;
        isJavaVersionAtLeast21 = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21);
        isMacOnAppleSilicon = SystemUtils.IS_OS_MAC_OSX && SystemUtils.OS_ARCH.equals("aarch64");
        preferIPv6 = "true".equals(System.getProperty("java.net.preferIPv6Addresses"));
        windowsDrive = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([a-zA-Z])"));
        EMPTY_USER_GROUPS = Predef$.MODULE$.Set().empty();
        BACKUP_STANDALONE_MASTER_PREFIX = "Current state is not alive";
        REDACTION_REPLACEMENT_TEXT = "*********(redacted)";
        fullWidthRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[\u1100-\u115f\u2e80-\ua4cf\uac00-\ud7a3\uf900-\ufaff\ufe10-\ufe19\ufe30-\ufe6f\uff00-\uff60\uffe0-\uffe6]"));
    }

    public Seq<String> stringToSeq(String str) {
        return SparkStringUtils.stringToSeq$((SparkStringUtils)this, (String)str);
    }

    public long copyStream(InputStream in, OutputStream out, boolean closeStreams, boolean transferToEnabled) {
        return SparkStreamUtils.copyStream$((SparkStreamUtils)this, (InputStream)in, (OutputStream)out, (boolean)closeStreams, (boolean)transferToEnabled);
    }

    public boolean copyStream$default$3() {
        return SparkStreamUtils.copyStream$default$3$((SparkStreamUtils)this);
    }

    public boolean copyStream$default$4() {
        return SparkStreamUtils.copyStream$default$4$((SparkStreamUtils)this);
    }

    public void copyFileStreamNIO(FileChannel input, WritableByteChannel output, long startPosition, long bytesToCopy) {
        SparkStreamUtils.copyFileStreamNIO$((SparkStreamUtils)this, (FileChannel)input, (WritableByteChannel)output, (long)startPosition, (long)bytesToCopy);
    }

    public <T> byte[] serialize(T o) {
        return SparkSerDeUtils.serialize$((SparkSerDeUtils)this, o);
    }

    public <T> T deserialize(byte[] bytes) {
        return (T)SparkSerDeUtils.deserialize$((SparkSerDeUtils)this, (byte[])bytes);
    }

    public <T> T deserialize(byte[] bytes, ClassLoader loader) {
        return (T)SparkSerDeUtils.deserialize$((SparkSerDeUtils)this, (byte[])bytes, (ClassLoader)loader);
    }

    public URI resolveURI(String path) {
        return SparkFileUtils.resolveURI$((SparkFileUtils)this, (String)path);
    }

    public File[] recursiveList(File f) {
        return SparkFileUtils.recursiveList$((SparkFileUtils)this, (File)f);
    }

    public boolean createDirectory(File dir) {
        return SparkFileUtils.createDirectory$((SparkFileUtils)this, (File)dir);
    }

    public File createDirectory(String root, String namePrefix) {
        return SparkFileUtils.createDirectory$((SparkFileUtils)this, (String)root, (String)namePrefix);
    }

    public String createDirectory$default$2() {
        return SparkFileUtils.createDirectory$default$2$((SparkFileUtils)this);
    }

    public File createTempDir() {
        return SparkFileUtils.createTempDir$((SparkFileUtils)this);
    }

    public <T> T tryOrIOException(Function0<T> block) {
        return (T)SparkErrorUtils.tryOrIOException$((SparkErrorUtils)this, block);
    }

    public <R extends Closeable, T> T tryWithResource(Function0<R> createResource, Function1<R, T> f) {
        return (T)SparkErrorUtils.tryWithResource$((SparkErrorUtils)this, createResource, f);
    }

    public <R extends Closeable, T> T tryInitializeResource(Function0<R> createResource, Function1<R, T> initialize) {
        return (T)SparkErrorUtils.tryInitializeResource$((SparkErrorUtils)this, createResource, initialize);
    }

    public <T> T tryWithSafeFinally(Function0<T> block, Function0<BoxedUnit> finallyBlock) {
        return (T)SparkErrorUtils.tryWithSafeFinally$((SparkErrorUtils)this, block, finallyBlock);
    }

    public String stackTraceToString(Throwable t) {
        return SparkErrorUtils.stackTraceToString$((SparkErrorUtils)this, (Throwable)t);
    }

    public boolean isTesting() {
        return SparkEnvUtils.isTesting$((SparkEnvUtils)this);
    }

    public ClassLoader getSparkClassLoader() {
        return SparkClassUtils.getSparkClassLoader$((SparkClassUtils)this);
    }

    public ClassLoader getContextOrSparkClassLoader() {
        return SparkClassUtils.getContextOrSparkClassLoader$((SparkClassUtils)this);
    }

    public <C> Class<C> classForName(String className, boolean initialize, boolean noSparkClassLoader) {
        return SparkClassUtils.classForName$((SparkClassUtils)this, (String)className, (boolean)initialize, (boolean)noSparkClassLoader);
    }

    public <C> boolean classForName$default$2() {
        return SparkClassUtils.classForName$default$2$((SparkClassUtils)this);
    }

    public <C> boolean classForName$default$3() {
        return SparkClassUtils.classForName$default$3$((SparkClassUtils)this);
    }

    public boolean classIsLoadable(String clazz) {
        return SparkClassUtils.classIsLoadable$((SparkClassUtils)this, (String)clazz);
    }

    public boolean classIsLoadableAndAssignableFrom(String clazz, Class<?> targetClass) {
        return SparkClassUtils.classIsLoadableAndAssignableFrom$((SparkClassUtils)this, (String)clazz, targetClass);
    }

    public String getFormattedClassName(Object obj) {
        return SparkClassUtils.getFormattedClassName$((SparkClassUtils)this, (Object)obj);
    }

    public String getSimpleName(Class<?> cls) {
        return SparkClassUtils.getSimpleName$((SparkClassUtils)this, cls);
    }

    public final String stripDollars(String s) {
        return SparkClassUtils.stripDollars$((SparkClassUtils)this, (String)s);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Random random() {
        return random;
    }

    public void org$apache$spark$util$SparkClassUtils$_setter_$random_$eq(Random x$1) {
        random = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkUncaughtExceptionHandler sparkUncaughtExceptionHandler() {
        return sparkUncaughtExceptionHandler;
    }

    private String cachedLocalDir() {
        return cachedLocalDir;
    }

    private void cachedLocalDir_$eq(String x$1) {
        cachedLocalDir = x$1;
    }

    public int DEFAULT_DRIVER_MEM_MB() {
        return DEFAULT_DRIVER_MEM_MB;
    }

    public int MAX_DIR_CREATION_ATTEMPTS() {
        return MAX_DIR_CREATION_ATTEMPTS;
    }

    private String[] localRootDirs() {
        return localRootDirs;
    }

    private void localRootDirs_$eq(String[] x$1) {
        localRootDirs = x$1;
    }

    public String LOCAL_SCHEME() {
        return LOCAL_SCHEME;
    }

    private Interner<String> weakStringInterner() {
        return weakStringInterner;
    }

    private Regex PATTERN_FOR_COMMAND_LINE_ARG() {
        return PATTERN_FOR_COMMAND_LINE_ARG;
    }

    private int COPY_BUFFER_LEN() {
        return COPY_BUFFER_LEN;
    }

    private ThreadLocal<byte[]> copyBuffer() {
        return copyBuffer;
    }

    public long deserializeLongValue(byte[] bytes) {
        long result = (long)bytes[7] & 0xFFL;
        result += ((long)bytes[6] & 0xFFL) << 8;
        result += ((long)bytes[5] & 0xFFL) << 16;
        result += ((long)bytes[4] & 0xFFL) << 24;
        result += ((long)bytes[3] & 0xFFL) << 32;
        result += ((long)bytes[2] & 0xFFL) << 40;
        return (result += ((long)bytes[1] & 0xFFL) << 48) + (((long)bytes[0] & 0xFFL) << 56);
    }

    public void serializeViaNestedStream(OutputStream os, SerializerInstance ser, Function1<SerializationStream, BoxedUnit> f) {
        try (SerializationStream osWrapper = ser.serializeStream(new OutputStream(os){
            private final OutputStream os$1;

            public void write(int b) {
                this.os$1.write(b);
            }

            public void write(byte[] b, int off, int len) {
                this.os$1.write(b, off, len);
            }
            {
                this.os$1 = os$1;
            }
        });){
            f.apply((Object)osWrapper);
        }
    }

    public void deserializeViaNestedStream(InputStream is, SerializerInstance ser, Function1<DeserializationStream, BoxedUnit> f) {
        try (DeserializationStream isWrapper = ser.deserializeStream(new InputStream(is){
            private final InputStream is$1;

            public int read() {
                return this.is$1.read();
            }

            public int read(byte[] b, int off, int len) {
                return this.is$1.read(b, off, len);
            }
            {
                this.is$1 = is$1;
            }
        });){
            f.apply((Object)isWrapper);
        }
    }

    public String weakIntern(String s) {
        return (String)this.weakStringInterner().intern((Object)s);
    }

    public <T> T withContextClassLoader(ClassLoader ctxClassLoader, Function0<T> fn) {
        Object object;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ctxClassLoader);
            object = fn.apply();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return (T)object;
    }

    private void writeByteBufferImpl(ByteBuffer bb, Function3<byte[], Object, Object, BoxedUnit> writer) {
        if (bb.hasArray()) {
            writer.apply((Object)bb.array(), (Object)BoxesRunTime.boxToInteger((int)(bb.arrayOffset() + bb.position())), (Object)BoxesRunTime.boxToInteger((int)bb.remaining()));
            return;
        }
        byte[] buffer = this.copyBuffer().get();
        int originalPosition = bb.position();
        int bytesToCopy = Math.min(bb.remaining(), this.COPY_BUFFER_LEN());
        while (bytesToCopy > 0) {
            bb.get(buffer, 0, bytesToCopy);
            writer.apply((Object)buffer, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)bytesToCopy));
            bytesToCopy = Math.min(bb.remaining(), this.COPY_BUFFER_LEN());
        }
        bb.position(originalPosition);
    }

    public void writeByteBuffer(ByteBuffer bb, DataOutput out) {
        this.writeByteBufferImpl(bb, (Function3<byte[], Object, Object, BoxedUnit>)(Function3 & Serializable)(x$1, x$2, x$3) -> {
            out.write(x$1, BoxesRunTime.unboxToInt((Object)x$2), BoxesRunTime.unboxToInt((Object)x$3));
            return BoxedUnit.UNIT;
        });
    }

    public void writeByteBuffer(ByteBuffer bb, OutputStream out) {
        this.writeByteBufferImpl(bb, (Function3<byte[], Object, Object, BoxedUnit>)(Function3 & Serializable)(x$1, x$2, x$3) -> {
            out.write(x$1, BoxesRunTime.unboxToInt((Object)x$2), BoxesRunTime.unboxToInt((Object)x$3));
            return BoxedUnit.UNIT;
        });
    }

    public boolean chmod700(File file) {
        return file.setReadable(false, false) && file.setReadable(true, true) && file.setWritable(false, false) && file.setWritable(true, true) && file.setExecutable(false, false) && file.setExecutable(true, true);
    }

    public File createTempDir(String root, String namePrefix) {
        File dir = this.createDirectory(root, namePrefix);
        ShutdownHookManager$.MODULE$.registerShutdownDeleteDir(dir);
        return dir;
    }

    public String createTempDir$default$1() {
        return System.getProperty("java.io.tmpdir");
    }

    public String createTempDir$default$2() {
        return "spark";
    }

    public InputStream copyStreamUpTo(InputStream in, long maxSize) {
        ChunkedByteBufferOutputStream out;
        LongRef count = LongRef.create((long)0L);
        boolean fullyCopied = BoxesRunTime.unboxToBoolean(this.tryWithSafeFinally((Function0)((JFunction0.mcZ.sp & Serializable)() -> Utils$.$anonfun$copyStreamUpTo$2(maxSize, count, in, out = new ChunkedByteBufferOutputStream(65536, (Function1<Object, ByteBuffer>)(Function1 & Serializable)x$1 -> Utils$.$anonfun$copyStreamUpTo$1(BoxesRunTime.unboxToInt((Object)x$1))))), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            try {
                if (count$1.elem < maxSize) {
                    in.close();
                }
            }
            finally {
                out.close();
            }
        }));
        if (fullyCopied) {
            return out.toChunkedByteBuffer().toInputStream(true);
        }
        return new SequenceInputStream(out.toChunkedByteBuffer().toInputStream(true), in);
    }

    public String encodeFileNameToURIRawPath(String fileName) {
        Predef$.MODULE$.require(!fileName.contains("/") && !fileName.contains("\\"));
        return this.encodeRelativeUnixPathToURIRawPath(fileName);
    }

    public String encodeRelativeUnixPathToURIRawPath(String path) {
        Predef$.MODULE$.require(!path.startsWith("/") && !path.contains("\\"));
        return new URI("file", null, "localhost", -1, "/" + path, null, null).getRawPath().substring(1);
    }

    public String decodeFileNameInURI(URI uri) {
        String rawPath = uri.getRawPath();
        String rawFileName = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])rawPath.split("/")));
        return new URI("file:///" + rawFileName).getPath().substring(1);
    }

    public File fetchFile(String url, File targetDir, SparkConf conf, Configuration hadoopConf, long timestamp, boolean useCache, boolean shouldUntar) {
        String fileName = this.decodeFileNameInURI(new URI(url));
        File targetFile = new File(targetDir, fileName);
        boolean fetchCacheEnabled = conf.getBoolean("spark.files.useFetchCache", true);
        if (useCache && fetchCacheEnabled) {
            String cachedFileName = "" + url.hashCode() + timestamp + "_cache";
            String lockFileName = "" + url.hashCode() + timestamp + "_lock";
            if (this.cachedLocalDir().isEmpty()) {
                Utils$ utils$ = this;
                synchronized (utils$) {
                    if (this.cachedLocalDir().isEmpty()) {
                        this.cachedLocalDir_$eq(this.getLocalDir(conf));
                    }
                }
            }
            File localDir = new File(this.cachedLocalDir());
            File lockFile = new File(localDir, lockFileName);
            FileChannel lockFileChannel = new RandomAccessFile(lockFile, "rw").getChannel();
            FileLock lock = lockFileChannel.lock();
            File cachedFile = new File(localDir, cachedFileName);
            try {
                Object object = !cachedFile.exists() ? this.doFetchFile(url, localDir, cachedFileName, conf, hadoopConf) : BoxedUnit.UNIT;
            }
            finally {
                lock.release();
                lockFileChannel.close();
            }
            this.copyFile(url, cachedFile, targetFile, conf.getBoolean("spark.files.overwrite", false), this.copyFile$default$5());
            v2 = BoxedUnit.UNIT;
        } else {
            v2 = this.doFetchFile(url, targetDir, fileName, conf, hadoopConf);
        }
        if (shouldUntar) {
            if (fileName.endsWith(".tar.gz") || fileName.endsWith(".tgz")) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Untarring behavior will be deprecated at spark.files and SparkContext.addFile. Consider using spark.archives or SparkContext.addArchive instead.");
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Untarring ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)fileName)}))));
                v3 = this.executeAndGetOutput((Seq<String>)new .colon.colon((Object)"tar", (List)new .colon.colon((Object)"-xzf", (List)new .colon.colon((Object)fileName, (List)Nil$.MODULE$))), targetDir, this.executeAndGetOutput$default$3(), this.executeAndGetOutput$default$4());
            } else if (fileName.endsWith(".tar")) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Untarring behavior will be deprecated at spark.files and SparkContext.addFile. Consider using spark.archives or SparkContext.addArchive instead.");
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Untarring ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)fileName)}))));
                v3 = this.executeAndGetOutput((Seq<String>)new .colon.colon((Object)"tar", (List)new .colon.colon((Object)"-xf", (List)new .colon.colon((Object)fileName, (List)Nil$.MODULE$))), targetDir, this.executeAndGetOutput$default$3(), this.executeAndGetOutput$default$4());
            } else {
                v3 = BoxedUnit.UNIT;
            }
        } else {
            v3 = BoxedUnit.UNIT;
        }
        FileUtil.chmod((String)targetFile.getAbsolutePath(), (String)"a+x");
        Object object = this.isWindows() ? BoxesRunTime.boxToInteger((int)FileUtil.chmod((String)targetFile.getAbsolutePath(), (String)"u+r")) : BoxedUnit.UNIT;
        return targetFile;
    }

    public boolean fetchFile$default$7() {
        return true;
    }

    public void unpack(File source, File dest) {
        if (!source.exists()) {
            throw new FileNotFoundException(source.getAbsolutePath());
        }
        String lowerSrc = StringUtils.toLowerCase((String)source.getName());
        if (lowerSrc.endsWith(".jar")) {
            RunJar.unJar((File)source, (File)dest, (Pattern)RunJar.MATCH_ANY);
            return;
        }
        if (lowerSrc.endsWith(".zip")) {
            FileUtil.unZip((File)source, (File)dest);
            return;
        }
        if (lowerSrc.endsWith(".tar.gz") || lowerSrc.endsWith(".tgz")) {
            FileUtil.unTar((File)source, (File)dest);
            return;
        }
        if (lowerSrc.endsWith(".tar")) {
            this.unTarUsingJava(source, dest);
            return;
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot unpack ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME$.MODULE$, (Object)source)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"just copying it to ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FILE_NAME2$.MODULE$, (Object)dest)})))));
        this.copyRecursive(source, dest);
    }

    private void unTarUsingJava(File source, File dest) {
        if (!dest.mkdirs() && !dest.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + dest);
        }
        try {
            Method mth = FileUtil.class.getDeclaredMethod("unTarUsingJava", File.class, File.class, Boolean.TYPE);
            mth.setAccessible(true);
            mth.invoke(null, source, dest, Boolean.FALSE);
        }
        catch (Throwable throwable) {
            InvocationTargetException invocationTargetException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)throwable2).getCause() != null) {
                throw invocationTargetException.getCause();
            }
            throw throwable;
        }
    }

    public <T> Tuple2<T, Object> timeTakenMs(Function0<T> body2) {
        long startTime = System.nanoTime();
        Object result = body2.apply();
        long endTime = System.nanoTime();
        return new Tuple2(result, (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(TimeUnit.NANOSECONDS.toMillis(endTime - startTime), 0L)));
    }

    private void downloadFile(String url, InputStream in, File destFile, boolean fileOverwrite) {
        File tempFile = File.createTempFile("fetchFileTemp", null, new File(destFile.getParentFile().getAbsolutePath()));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching ", " to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.URL$.MODULE$, (Object)url), new MDC((LogKey)LogKeys.FILE_ABSOLUTE_PATH$.MODULE$, (Object)tempFile)}))));
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            this.copyStream(in, out, true, this.copyStream$default$4());
            this.copyFile(url, tempFile, destFile, fileOverwrite, true);
        }
        finally {
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFile(String url, File sourceFile, File destFile, boolean fileOverwrite, boolean removeSourceFile) {
        if (destFile.exists()) {
            if (!this.filesEqualRecursive(sourceFile, destFile)) {
                if (!fileOverwrite) throw new SparkException("File " + destFile + " exists and does not match contents of " + url);
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " exists and does not match contents of"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DESTINATION_PATH$.MODULE$, (Object)destFile)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" ", ", replacing it with ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.URL$.MODULE$, (Object)url), new MDC((LogKey)LogKeys.URL2$.MODULE$, (Object)url)})))));
                if (!destFile.delete()) {
                    throw new SparkException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Failed to delete %s while attempting to overwrite it with %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{destFile.getAbsolutePath(), sourceFile.getAbsolutePath()})));
                }
            } else {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " has been previously"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SOURCE_PATH$.MODULE$, (Object)sourceFile.getAbsolutePath())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" copied to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DESTINATION_PATH$.MODULE$, (Object)destFile.getAbsolutePath())})))));
                return;
            }
        }
        if (removeSourceFile) {
            java.nio.file.Files.move(sourceFile.toPath(), destFile.toPath(), new CopyOption[0]);
            return;
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Copying ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SOURCE_PATH$.MODULE$, (Object)sourceFile.getAbsolutePath())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DESTINATION_PATH$.MODULE$, (Object)destFile.getAbsolutePath())})))));
        this.copyRecursive(sourceFile, destFile);
    }

    private boolean copyFile$default$5() {
        return false;
    }

    private boolean filesEqualRecursive(File file1, File file2) {
        if (file1.isDirectory() && file2.isDirectory()) {
            File[] subfiles1 = file1.listFiles();
            File[] subfiles2 = file2.listFiles();
            if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])subfiles1)) != ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])subfiles2))) {
                return false;
            }
            return ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])subfiles1), (Function1 & Serializable)x$1 -> x$1.getName(), (Ordering)Ordering.String$.MODULE$)), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])subfiles2), (Function1 & Serializable)x$2 -> x$2.getName(), (Ordering)Ordering.String$.MODULE$)))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$filesEqualRecursive$3(x0$1)));
        }
        if (file1.isFile() && file2.isFile()) {
            return Files.equal((File)file1, (File)file2);
        }
        return false;
    }

    private void copyRecursive(File source, File dest) {
        if (source.isDirectory()) {
            if (!dest.mkdir()) {
                throw new IOException("Failed to create directory " + dest.getPath());
            }
            File[] subfiles = source.listFiles();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])subfiles), (Function1 & Serializable)f -> {
                Utils$.MODULE$.copyRecursive(f, new File(dest, f.getName()));
                return BoxedUnit.UNIT;
            });
            return;
        }
        java.nio.file.Files.copy(source.toPath(), dest.toPath(), new CopyOption[0]);
    }

    public File doFetchFile(String url, File targetDir, String filename, SparkConf conf, Configuration hadoopConf) {
        File targetFile;
        block12: {
            boolean fileOverwrite;
            URI uri;
            block11: {
                targetFile = new File(targetDir, filename);
                uri = new URI(url);
                fileOverwrite = conf.getBoolean("spark.files.overwrite", false);
                String string = (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0 & Serializable)() -> "file");
                switch (string == null ? 0 : string.hashCode()) {
                    case 101730: {
                        if ("ftp".equals(string)) {
                            break;
                        }
                        break block11;
                    }
                    case 3143036: {
                        if (!"file".equals(string)) break block11;
                        File sourceFile = uri.isAbsolute() ? new File(uri) : new File(uri.getPath());
                        this.copyFile(url, sourceFile, targetFile, fileOverwrite, this.copyFile$default$5());
                        break block12;
                    }
                    case 3213448: {
                        if ("http".equals(string)) {
                            break;
                        }
                        break block11;
                    }
                    case 99617003: {
                        if ("https".equals(string)) {
                            break;
                        }
                        break block11;
                    }
                    case 109638365: {
                        if (!"spark".equals(string)) break block11;
                        if (SparkEnv$.MODULE$.get() == null) {
                            throw new IllegalStateException("Cannot retrieve files with 'spark' scheme without an active SparkEnv.");
                        }
                        ReadableByteChannel source = SparkEnv$.MODULE$.get().rpcEnv().openChannel(url);
                        InputStream is = Channels.newInputStream(source);
                        this.downloadFile(url, is, targetFile, fileOverwrite);
                        break block12;
                    }
                    default: {
                        break block11;
                    }
                }
                URLConnection uc = new URI(url).toURL().openConnection();
                int timeoutMs = (int)conf.getTimeAsSeconds("spark.files.fetchTimeout", "60s") * 1000;
                uc.setConnectTimeout(timeoutMs);
                uc.setReadTimeout(timeoutMs);
                uc.connect();
                InputStream in = uc.getInputStream();
                this.downloadFile(url, in, targetFile, fileOverwrite);
                break block12;
            }
            FileSystem fs = this.getHadoopFileSystem(uri, hadoopConf);
            Path path = new Path(uri);
            this.fetchHcfsFile(path, targetDir, fs, conf, hadoopConf, fileOverwrite, (Option<String>)new Some((Object)filename));
        }
        return targetFile;
    }

    public void fetchHcfsFile(Path path, File targetDir, FileSystem fs, SparkConf conf, Configuration hadoopConf, boolean fileOverwrite, Option<String> filename) {
        if (!targetDir.exists() && !targetDir.mkdir()) {
            throw new IOException("Failed to create directory " + targetDir.getPath());
        }
        File dest = new File(targetDir, (String)filename.getOrElse((Function0 & Serializable)() -> path.getName()));
        if (fs.getFileStatus(path).isFile()) {
            try (FSDataInputStream in = fs.open(path);){
                this.downloadFile(path.toString(), (InputStream)in, dest, fileOverwrite);
            }
            return;
        }
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path)), (Function1 & Serializable)fileStatus -> {
            Utils$.MODULE$.fetchHcfsFile(fileStatus.getPath(), dest, fs, conf, hadoopConf, fileOverwrite, Utils$.MODULE$.fetchHcfsFile$default$7());
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> fetchHcfsFile$default$7() {
        return None$.MODULE$;
    }

    public void validateURL(URI uri) throws MalformedURLException {
        block10: {
            String string = (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0 & Serializable)() -> "file");
            switch (string == null ? 0 : string.hashCode()) {
                case 101730: {
                    if ("ftp".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 3213448: {
                    if ("http".equals(string)) {
                        break;
                    }
                    break block10;
                }
                case 99617003: {
                    if ("https".equals(string)) {
                        break;
                    }
                    break block10;
                }
                default: {
                    break block10;
                }
            }
            try {
                uri.toURL();
            }
            catch (MalformedURLException e) {
                MalformedURLException ex = new MalformedURLException("URI (" + uri.toString() + ") is not a valid URL.");
                ex.initCause(e);
                throw ex;
            }
        }
    }

    public String getLocalDir(SparkConf conf) {
        String[] localRootDirs = this.getOrCreateLocalRootDirs(conf);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])localRootDirs))) {
            String[] configuredLocalDirs = this.getConfiguredLocalDirs(conf);
            throw new IOException("Failed to get a temp directory under [" + Predef$.MODULE$.wrapRefArray((Object[])configuredLocalDirs).mkString(",") + "].");
        }
        return localRootDirs[Random$.MODULE$.nextInt(localRootDirs.length)];
    }

    public boolean isRunningInYarnContainer(SparkConf conf) {
        return conf.getenv("CONTAINER_ID") != null;
    }

    public boolean isInRunningSparkTask() {
        return TaskContext$.MODULE$.get() != null;
    }

    public String[] getOrCreateLocalRootDirs(SparkConf conf) {
        if (this.localRootDirs() == null) {
            Utils$ utils$ = this;
            synchronized (utils$) {
                if (this.localRootDirs() == null) {
                    this.localRootDirs_$eq(this.getOrCreateLocalRootDirsImpl(conf));
                }
            }
        }
        return this.localRootDirs();
    }

    public String[] getConfiguredLocalDirs(SparkConf conf) {
        if (this.isRunningInYarnContainer(conf)) {
            return (String[])this.randomizeInPlace(this.getYarnLocalDirs(conf).split(","), this.randomizeInPlace$default$2());
        }
        if (conf.getenv("SPARK_EXECUTOR_DIRS") != null) {
            return conf.getenv("SPARK_EXECUTOR_DIRS").split(File.pathSeparator);
        }
        if (conf.getenv("SPARK_LOCAL_DIRS") != null) {
            return conf.getenv("SPARK_LOCAL_DIRS").split(",");
        }
        return conf.get("spark.local.dir", System.getProperty("java.io.tmpdir")).split(",");
    }

    private String[] getOrCreateLocalRootDirsImpl(SparkConf conf) {
        String[] configuredLocalDirs;
        block0: {
            configuredLocalDirs = this.getConfiguredLocalDirs(conf);
            String[] uris = (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])configuredLocalDirs), (Function1 & Serializable)root -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$getOrCreateLocalRootDirsImpl$1(root)));
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])uris))) break block0;
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The configured local directories are not expected to be URIs; "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"however, got suspicious values ["}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "]. "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.URIS$.MODULE$, (Object)Predef$.MODULE$.wrapRefArray((Object[])uris).mkString(", "))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Please check your configured local directories."}))).log((Seq)Nil$.MODULE$))));
        }
        return (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])configuredLocalDirs), (Function1 & Serializable)root -> {
            None$ none$;
            block3: {
                try {
                    File rootDir = new File((String)root);
                    if (rootDir.exists() || rootDir.mkdirs()) {
                        File dir = MODULE$.createTempDir((String)root, MODULE$.createTempDir$default$2());
                        MODULE$.chmod700(dir);
                        none$ = new Some((Object)dir.getAbsolutePath());
                        break block3;
                    }
                    MODULE$.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create dir in ", ". Ignoring this directory."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, root)}))));
                    none$ = None$.MODULE$;
                }
                catch (IOException e) {
                    MODULE$.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create local root dir in ", ". Ignoring this directory."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, root)}))));
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        }, ClassTag$.MODULE$.apply(String.class));
    }

    private String getYarnLocalDirs(SparkConf conf) {
        String localDirs = (String)Option$.MODULE$.apply((Object)conf.getenv("LOCAL_DIRS")).getOrElse((Function0 & Serializable)() -> "");
        if (localDirs.isEmpty()) {
            throw new Exception("Yarn Local dirs can't be empty");
        }
        return localDirs;
    }

    public void clearLocalRootDirs() {
        this.localRootDirs_$eq(null);
    }

    public <T> Seq<T> randomize(IterableOnce<T> seq, ClassTag<T> evidence$1) {
        return ArrayImplicits$.MODULE$.SparkArrayOps(this.randomizeInPlace(seq.iterator().toArray(evidence$1), this.randomizeInPlace$default$2())).toImmutableArraySeq();
    }

    public <T> Object randomizeInPlace(Object arr, Random rand) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(arr) - 1), 1).by(-1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int j = rand.nextInt(i + 1);
            Object tmp = ScalaRunTime$.MODULE$.array_apply(arr, j);
            ScalaRunTime$.MODULE$.array_update(arr, j, ScalaRunTime$.MODULE$.array_apply(arr, i));
            ScalaRunTime$.MODULE$.array_update(arr, i, tmp);
        });
        return arr;
    }

    public <T> Random randomizeInPlace$default$2() {
        return new Random();
    }

    private InetAddress localIpAddress$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                localIpAddress = this.findLocalInetAddress();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return localIpAddress;
    }

    private InetAddress localIpAddress() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.localIpAddress$lzycompute();
        }
        return localIpAddress;
    }

    /*
     * WARNING - void declaration
     */
    private InetAddress findLocalInetAddress() {
        InetAddress inetAddress;
        Object object = new Object();
        try {
            String defaultIpOverride = System.getenv("SPARK_LOCAL_IP");
            if (defaultIpOverride != null) {
                inetAddress = InetAddress.getByName(defaultIpOverride);
            } else {
                void var3_3;
                InetAddress address = InetAddress.getLocalHost();
                if (address.isLoopbackAddress()) {
                    Seq activeNetworkIFs = CollectionConverters$.MODULE$.EnumerationHasAsScala(NetworkInterface.getNetworkInterfaces()).asScala().toSeq();
                    Seq reOrderedNetworkIFs = this.isWindows() ? activeNetworkIFs : (Seq)activeNetworkIFs.reverse();
                    reOrderedNetworkIFs.foreach((Function1 & Serializable)ni -> {
                        Utils$.$anonfun$findLocalInetAddress$1(address, object, ni);
                        return BoxedUnit.UNIT;
                    });
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Your hostname, ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HOST$.MODULE$, (Object)InetAddress.getLocalHost().getHostName())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"resolves to a loopback address: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HOST_PORT$.MODULE$, (Object)address.getHostAddress())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"but we couldn't find any external IP address!"}))).log((Seq)Nil$.MODULE$))));
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Set SPARK_LOCAL_IP if you need to bind to another address");
                }
                inetAddress = var3_3;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                inetAddress = (InetAddress)ex.value();
            }
            throw ex;
        }
        return inetAddress;
    }

    private Option<String> customHostname() {
        return customHostname;
    }

    private void customHostname_$eq(Option<String> x$1) {
        customHostname = x$1;
    }

    public void setCustomHostname(String hostname) {
        this.checkHost(hostname);
        this.customHostname_$eq((Option<String>)new Some((Object)hostname));
    }

    public String localCanonicalHostName() {
        return this.addBracketsIfNeeded((String)this.customHostname().getOrElse((Function0 & Serializable)() -> MODULE$.localIpAddress().getCanonicalHostName()));
    }

    public String localHostName() {
        return this.addBracketsIfNeeded((String)this.customHostname().getOrElse((Function0 & Serializable)() -> MODULE$.localIpAddress().getHostAddress()));
    }

    public String localHostNameForURI() {
        return this.addBracketsIfNeeded((String)this.customHostname().getOrElse((Function0 & Serializable)() -> InetAddresses.toUriString((InetAddress)MODULE$.localIpAddress())));
    }

    public String addBracketsIfNeeded(String addr) {
        if (addr.contains(":") && !addr.contains("[")) {
            return "[" + addr + "]";
        }
        return addr;
    }

    public String normalizeIpIfNeeded(String host) {
        Option option;
        Regex addressRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\[{0,1}([0-9:]+?:[0-9]*)\\]{0,1}$"));
        String string = host;
        if (string != null && !(option = addressRe.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String unbracketed = (String)((LinearSeqOps)option.get()).apply(0);
            return this.addBracketsIfNeeded(InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)unbracketed)));
        }
        return host;
    }

    public void checkHost(String host) {
        if (host != null && host.split(":").length > 2) {
            Predef$.MODULE$.assert(host.startsWith("[") && host.endsWith("]"), (Function0 & Serializable)() -> "Expected hostname or IPv6 IP enclosed in [] but got " + host);
            return;
        }
        Predef$.MODULE$.assert(host != null && host.indexOf(58) == -1, (Function0 & Serializable)() -> "Expected hostname or IP but got " + host);
    }

    public void checkHostPort(String hostPort) {
        if (hostPort != null && hostPort.split(":").length > 2) {
            Predef$.MODULE$.assert(hostPort != null && hostPort.indexOf("]:") != -1, (Function0 & Serializable)() -> "Expected host and port but got " + hostPort);
            return;
        }
        Predef$.MODULE$.assert(hostPort != null && hostPort.indexOf(58) != -1, (Function0 & Serializable)() -> "Expected host and port but got " + hostPort);
    }

    private ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults() {
        return hostPortParseResults;
    }

    public Tuple2<String, Object> parseHostPort(String hostPort) {
        Tuple2<String, Object> cached = this.hostPortParseResults().get(hostPort);
        if (cached != null) {
            return cached;
        }
        if (hostPort != null && hostPort.split(":").length > 2) {
            int index = hostPort.lastIndexOf("]:");
            if (-1 == index) {
                return this.setDefaultPortValue$1(hostPort);
            }
            String port = hostPort.substring(index + 2).trim();
            Tuple2 retval = new Tuple2((Object)hostPort.substring(0, index + 1).trim(), (Object)(port.isEmpty() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(port)))));
            v0 = this.hostPortParseResults().putIfAbsent(hostPort, (Tuple2<String, Object>)retval);
        } else {
            int index = hostPort.lastIndexOf(58);
            if (-1 == index) {
                return this.setDefaultPortValue$1(hostPort);
            }
            String port = hostPort.substring(index + 1).trim();
            Tuple2 retval = new Tuple2((Object)hostPort.substring(0, index).trim(), (Object)(port.isEmpty() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(port)))));
            v0 = this.hostPortParseResults().putIfAbsent(hostPort, (Tuple2<String, Object>)retval);
        }
        return this.hostPortParseResults().get(hostPort);
    }

    public String getUsedTimeNs(long startTimeNs) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs) + " ms";
    }

    public void deleteRecursively(File file) {
        SparkFileUtils.deleteRecursively$((SparkFileUtils)this, (File)file);
        if (file != null) {
            ShutdownHookManager$.MODULE$.removeShutdownDeleteDir(file);
            return;
        }
    }

    public boolean doesDirectoryContainAnyNewFiles(File dir, long cutoff) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory!");
        }
        File[] filesAndDirs = dir.listFiles();
        long cutoffTimeInMillis = System.currentTimeMillis() - cutoff * 1000L;
        return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])filesAndDirs), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$doesDirectoryContainAnyNewFiles$1(cutoffTimeInMillis, x$4))) || ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])filesAndDirs), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDirectory()))), (Function1 & Serializable)subdir -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.doesDirectoryContainAnyNewFiles(subdir, cutoff)));
    }

    public long timeStringAsMs(String str) {
        return JavaUtils.timeStringAsMs((String)str);
    }

    public long timeStringAsSeconds(String str) {
        return JavaUtils.timeStringAsSec((String)str);
    }

    public long byteStringAsBytes(String str) {
        return JavaUtils.byteStringAsBytes((String)str);
    }

    public long byteStringAsKb(String str) {
        return JavaUtils.byteStringAsKb((String)str);
    }

    public long byteStringAsMb(String str) {
        return JavaUtils.byteStringAsMb((String)str);
    }

    public long byteStringAsGb(String str) {
        return JavaUtils.byteStringAsGb((String)str);
    }

    public int memoryStringToMb(String str) {
        return (int)(JavaUtils.byteStringAsBytes((String)str) / 1024L / 1024L);
    }

    public String bytesToString(long size) {
        int i;
        for (i = 0; i < siByteSizes.length - 1 && size < 2L * siByteSizes[i]; ++i) {
        }
        return StringOps$.MODULE$.formatLocal$extension(Predef$.MODULE$.augmentString("%.1f %s"), Locale.US, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)size / (double)siByteSizes[i])), siByteSuffixes[i]}));
    }

    public String bytesToString(BigInt size) {
        long EiB = 0x1000000000000000L;
        if (size.isValidLong()) {
            return this.bytesToString(size.toLong());
        }
        if (size.$less((Object)scala.package$.MODULE$.BigInt().apply(2048L).$times(BigInt$.MODULE$.long2bigInt(EiB)))) {
            return StringOps$.MODULE$.formatLocal$extension(Predef$.MODULE$.augmentString("%.1f EiB"), Locale.US, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(EiB))}));
        }
        return scala.package$.MODULE$.BigDecimal().apply(size, new MathContext(3, RoundingMode.HALF_UP)).toString() + " B";
    }

    public String msDurationToString(long ms) {
        int second = 1000;
        int minute = 60 * second;
        int hour = 60 * minute;
        Locale locale = Locale.US;
        long l = ms;
        if (l < (long)second) {
            return StringOps$.MODULE$.formatLocal$extension(Predef$.MODULE$.augmentString("%d ms"), locale, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)}));
        }
        if (l < (long)minute) {
            return StringOps$.MODULE$.formatLocal$extension(Predef$.MODULE$.augmentString("%.1f s"), locale, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)second))}));
        }
        if (l < (long)hour) {
            return StringOps$.MODULE$.formatLocal$extension(Predef$.MODULE$.augmentString("%.1f m"), locale, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)minute))}));
        }
        return StringOps$.MODULE$.formatLocal$extension(Predef$.MODULE$.augmentString("%.2f h"), locale, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)hour))}));
    }

    public String megabytesToString(long megabytes) {
        return this.bytesToString(megabytes * 1024L * 1024L);
    }

    public Process executeCommand(Seq<String> command, File workingDir, Map<String, String> extraEnvironment, boolean redirectStderr) {
        ProcessBuilder builder = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class))).directory(workingDir);
        java.util.Map<String, String> environment = builder.environment();
        extraEnvironment.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$executeCommand$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return environment.put(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        Process process = builder.start();
        if (redirectStderr) {
            String threadName = "redirect stderr for command " + command.apply(0);
            v0 = this.processStreamByLine(threadName, process.getErrorStream(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
                this.log$1(s);
                return BoxedUnit.UNIT;
            });
        } else {
            v0 = BoxedUnit.UNIT;
        }
        return process;
    }

    public File executeCommand$default$2() {
        return new File(".");
    }

    public Map<String, String> executeCommand$default$3() {
        return (Map)Map$.MODULE$.empty();
    }

    public boolean executeCommand$default$4() {
        return true;
    }

    public String executeAndGetOutput(Seq<String> command, File workingDir, Map<String, String> extraEnvironment, boolean redirectStderr) {
        Process process = this.executeCommand(command, workingDir, extraEnvironment, redirectStderr);
        StringBuilder output = new StringBuilder();
        String threadName = "read stdout for " + command.apply(0);
        Thread stdoutThread = this.processStreamByLine(threadName, process.getInputStream(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
            Utils$.appendToOutput$1(s, output);
            return BoxedUnit.UNIT;
        });
        int exitCode = process.waitFor();
        stdoutThread.join();
        if (exitCode != 0) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Process ", " exited with code "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.COMMAND$.MODULE$, (Object)command)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXIT_CODE$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)exitCode)), new MDC((LogKey)LogKeys.COMMAND_OUTPUT$.MODULE$, (Object)output)})))));
            throw new SparkException("Process " + command + " exited with code " + exitCode);
        }
        return output.toString();
    }

    public File executeAndGetOutput$default$2() {
        return new File(".");
    }

    public Map<String, String> executeAndGetOutput$default$3() {
        return (Map)Map$.MODULE$.empty();
    }

    public boolean executeAndGetOutput$default$4() {
        return true;
    }

    public Thread processStreamByLine(String threadName, InputStream inputStream, Function1<String, BoxedUnit> processLine) {
        Thread t = new Thread(threadName, inputStream, processLine){
            private final InputStream inputStream$1;
            private final Function1 processLine$1;

            public void run() {
                Source$.MODULE$.fromInputStream(this.inputStream$1, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable)line -> {
                    anon.3.$anonfun$run$1(this, line);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$run$1(anon.3 $this, String line) {
                $this.processLine$1.apply((Object)line);
            }
            {
                this.inputStream$1 = inputStream$1;
                this.processLine$1 = processLine$1;
                super(threadName$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.spark.util.Utils$$anon$3 java.lang.String )}, serializedLambda);
            }
        };
        t.setDaemon(true);
        t.start();
        return t;
    }

    public void tryOrExit(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (ControlThrowable e) {
            throw e;
        }
        catch (Throwable t) {
            this.sparkUncaughtExceptionHandler().uncaughtException(t);
        }
    }

    public void tryOrStopSparkContext(SparkContext sc, Function0<BoxedUnit> block) {
        block4: {
            try {
                block.apply$mcV$sp();
            }
            catch (ControlThrowable e) {
                throw e;
            }
            catch (Throwable t) {
                String currentThreadName = Thread.currentThread().getName();
                if (sc != null) {
                    this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"uncaught error in thread ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.THREAD_NAME$.MODULE$, (Object)currentThreadName)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"stopping SparkContext"}))).log((Seq)Nil$.MODULE$))), t);
                    sc.stopInNewThread();
                }
                if (NonFatal$.MODULE$.apply(t)) break block4;
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"throw uncaught fatal error in thread ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.THREAD_NAME$.MODULE$, (Object)currentThreadName)}))), t);
                throw t;
            }
        }
    }

    public void tryLogNonFatalError(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Uncaught exception in thread ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.THREAD_NAME$.MODULE$, (Object)Thread.currentThread().getName())}))), throwable2);
            }
            throw throwable;
        }
    }

    public <T> T tryWithSafeFinallyAndFailureCallbacks(Function0<T> block, Function0<BoxedUnit> catchBlock, Function0<BoxedUnit> finallyBlock) {
        Object object;
        Throwable originalThrowable = null;
        try {
            try {
                object = block.apply();
            }
            catch (Throwable cause) {
                block18: {
                    originalThrowable = cause;
                    try {
                        this.logError((Function0<String>)(Function0 & Serializable)() -> "Aborting task", originalThrowable);
                        if (TaskContext$.MODULE$.get() != null) {
                            TaskContext$.MODULE$.get().markTaskFailed(originalThrowable);
                        }
                        catchBlock.apply$mcV$sp();
                    }
                    catch (Throwable t) {
                        Throwable throwable = originalThrowable;
                        Throwable throwable2 = t;
                        if (!(throwable == null ? throwable2 != null : !throwable.equals(throwable2))) break block18;
                        originalThrowable.addSuppressed(t);
                        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Suppressing exception in catch: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ERROR$.MODULE$, (Object)t.getMessage())}))), t);
                    }
                }
                throw originalThrowable;
            }
        }
        catch (Throwable throwable) {
            try {
                finallyBlock.apply$mcV$sp();
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                if (throwable4 != null) {
                    Throwable throwable5 = throwable4;
                    if (originalThrowable != null) {
                        Throwable throwable6 = originalThrowable;
                        Throwable throwable7 = throwable5;
                        if (throwable6 == null ? throwable7 != null : !throwable6.equals(throwable7)) {
                            originalThrowable.addSuppressed(throwable5);
                            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Suppressing exception in finally: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ERROR$.MODULE$, (Object)throwable5.getMessage())}))), throwable5);
                            throw originalThrowable;
                        }
                    }
                }
                throw throwable3;
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            finallyBlock.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (throwable8 != null) {
                Throwable throwable9 = throwable8;
                if (originalThrowable != null) {
                    Throwable throwable10 = originalThrowable;
                    Throwable throwable11 = throwable9;
                    if (throwable10 == null ? throwable11 != null : !throwable10.equals(throwable11)) {
                        originalThrowable.addSuppressed(throwable9);
                        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Suppressing exception in finally: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ERROR$.MODULE$, (Object)throwable5.getMessage())}))), throwable9);
                        throw originalThrowable;
                    }
                }
            }
            throw throwable;
        }
        return (T)object2;
    }

    public <T> void tryWithSafeFinallyAndFailureCallbacks$default$2(Function0<T> block) {
    }

    public <T> void tryWithSafeFinallyAndFailureCallbacks$default$3(Function0<T> block) {
    }

    public String TRY_WITH_CALLER_STACKTRACE_FULL_STACKTRACE() {
        return TRY_WITH_CALLER_STACKTRACE_FULL_STACKTRACE;
    }

    public <T> Try<T> doTryWithCallerStacktrace(Function0<T> f) {
        Try t = Try$.MODULE$.apply(f);
        Try try_ = t;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            StackTraceElement[] origStackTrace = ex.getStackTrace();
            StackTraceElement[] currentStackTrace = Thread.currentThread().getStackTrace();
            int commonSuffixLen = ((Tuple2[])ArrayOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])origStackTrace))), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])currentStackTrace))))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$doTryWithCallerStacktrace$1(x0$1)))).length;
            Utils.OriginalTryStackTraceException origEx = (Utils.OriginalTryStackTraceException)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])ex.getSuppressed()), (Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$doTryWithCallerStacktrace$2(e))).getOrElse((Function0 & Serializable)() -> {
                Utils.OriginalTryStackTraceException fullEx = new Utils.OriginalTryStackTraceException();
                fullEx.setStackTrace(origStackTrace);
                ex.addSuppressed(fullEx);
                return fullEx;
            });
            origEx.doTryWithCallerStacktraceDepth_$eq(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])origStackTrace)) - commonSuffixLen);
        } else if (try_ instanceof Success) {
        } else {
            throw new MatchError((Object)try_);
        }
        return t;
    }

    public <T> T getTryWithCallerStacktrace(Try<T> t) {
        Try<T> try_ = t;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            Utils.OriginalTryStackTraceException originalStacktraceEx = (Utils.OriginalTryStackTraceException)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])ex.getSuppressed()), (Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$getTryWithCallerStacktrace$1(e))).getOrElse((Function0 & Serializable)() -> {
                throw ex;
            });
            StackTraceElement[] belowStacktrace = (StackTraceElement[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])originalStacktraceEx.getStackTrace()), originalStacktraceEx.doTryWithCallerStacktraceDepth());
            ex.setStackTrace((StackTraceElement[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])belowStacktrace), ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()), 1), ClassTag$.MODULE$.apply(StackTraceElement.class)));
            throw ex;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object s = success.value();
            return (T)s;
        }
        throw new MatchError(try_);
    }

    private Regex SPARK_CORE_CLASS_REGEX() {
        return SPARK_CORE_CLASS_REGEX;
    }

    private Regex SPARK_SQL_CLASS_REGEX() {
        return SPARK_SQL_CLASS_REGEX;
    }

    private boolean sparkInternalExclusionFunction(String className) {
        String SCALA_CORE_CLASS_PREFIX = "scala";
        boolean isSparkClass = this.SPARK_CORE_CLASS_REGEX().findFirstIn((CharSequence)className).isDefined() || this.SPARK_SQL_CLASS_REGEX().findFirstIn((CharSequence)className).isDefined();
        boolean isScalaClass = className.startsWith(SCALA_CORE_CLASS_PREFIX);
        return isSparkClass || isScalaClass;
    }

    public CallSite getCallSite(Function1<String, Object> skipClass) {
        ObjectRef lastSparkMethod = ObjectRef.create((Object)"<unknown>");
        ObjectRef firstUserFile = ObjectRef.create((Object)"<unknown>");
        IntRef firstUserLine = IntRef.create((int)0);
        BooleanRef insideSpark = BooleanRef.create((boolean)true);
        ArrayBuffer callStack = (ArrayBuffer)new ArrayBuffer().$colon$plus((Object)"<unknown>");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()), (Function1 & Serializable)ste -> {
            if (ste != null && ste.getMethodName() != null && !ste.getMethodName().contains("getStackTrace")) {
                if (insideSpark$1.elem) {
                    if (BoxesRunTime.unboxToBoolean((Object)skipClass.apply((Object)ste.getClassName()))) {
                        String string = ste.getMethodName();
                        String string2 = "<init>";
                        lastSparkMethod$1.elem = !(string != null ? !string.equals(string2) : string2 != null) ? ste.getClassName().substring(ste.getClassName().lastIndexOf(46) + 1) : ste.getMethodName();
                        callStack.update(0, (Object)ste.toString());
                        return BoxedUnit.UNIT;
                    }
                    if (ste.getFileName() != null) {
                        firstUserFile$1.elem = ste.getFileName();
                        if (ste.getLineNumber() >= 0) {
                            firstUserLine$1.elem = ste.getLineNumber();
                        }
                    }
                    callStack.$plus$eq((Object)ste.toString());
                    insideSpark$1.elem = false;
                    return BoxedUnit.UNIT;
                }
                return callStack.$plus$eq((Object)ste.toString());
            }
            return BoxedUnit.UNIT;
        });
        int callStackDepth = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(System.getProperty("spark.callstack.depth", "20")));
        String string = (String)firstUserFile.elem;
        String string2 = "HiveSessionImpl.java";
        String shortForm = !(string != null ? !string.equals(string2) : string2 != null) ? "Spark JDBC Server Query" : (String)lastSparkMethod.elem + " at " + (String)firstUserFile.elem + ":" + firstUserLine.elem;
        String longForm = ((IterableOnceOps)callStack.take(callStackDepth)).mkString("\n");
        return new CallSite(shortForm, longForm);
    }

    public Function1<String, Object> getCallSite$default$1() {
        return (Function1 & Serializable)className -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.sparkInternalExclusionFunction(className));
    }

    private LoadingCache<String, Long> compressedLogFileLengthCache() {
        return compressedLogFileLengthCache;
    }

    private void compressedLogFileLengthCache_$eq(LoadingCache<String, Long> x$1) {
        compressedLogFileLengthCache = x$1;
    }

    private synchronized LoadingCache<String, Long> getCompressedLogFileLengthCache(SparkConf sparkConf) {
        block0: {
            if (this.compressedLogFileLengthCache() != null) break block0;
            int compressedLogFileLengthCacheSize = BoxesRunTime.unboxToInt((Object)sparkConf.get(Worker$.MODULE$.UNCOMPRESSED_LOG_FILE_LENGTH_CACHE_SIZE_CONF()));
            this.compressedLogFileLengthCache_$eq((LoadingCache<String, Long>)CacheBuilder.newBuilder().maximumSize((long)compressedLogFileLengthCacheSize).build((CacheLoader)new CacheLoader<String, Long>(){

                public Long load(String path) {
                    return Predef$.MODULE$.long2Long(Utils$.MODULE$.org$apache$spark$util$Utils$$getCompressedFileLength(new File(path)));
                }
            }));
        }
        return this.compressedLogFileLengthCache();
    }

    public long getFileLength(File file, SparkConf workConf) {
        if (file.getName().endsWith(".gz")) {
            return Predef$.MODULE$.Long2long((Long)this.getCompressedLogFileLengthCache(workConf).get((Object)file.getAbsolutePath()));
        }
        return file.length();
    }

    /*
     * WARNING - void declaration
     */
    public long org$apache$spark$util$Utils$$getCompressedFileLength(File file) {
        void v0;
        try (GZIPInputStream gzInputStream = null;){
            try {
                void var3_3;
                long fileSize = 0L;
                gzInputStream = new GZIPInputStream(new FileInputStream(file));
                int bufSize = 1024;
                byte[] buf = new byte[bufSize];
                int numBytes = ByteStreams.read((InputStream)gzInputStream, (byte[])buf, (int)0, (int)bufSize);
                while (numBytes > 0) {
                    fileSize += (long)numBytes;
                    numBytes = ByteStreams.read((InputStream)gzInputStream, (byte[])buf, (int)0, (int)bufSize);
                }
                v0 = var3_3;
            }
            catch (Throwable e) {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot get file length of ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)file)}))), e);
                throw e;
            }
        }
        return (long)v0;
    }

    public String offsetBytes(String path, long length, long start, long end) {
        File file = new File(path);
        long effectiveEnd = package$.MODULE$.min(length, end);
        long effectiveStart = package$.MODULE$.max(0L, start);
        byte[] buff = new byte[(int)(effectiveEnd - effectiveStart)];
        try (InputStream stream = path.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);){
            ByteStreams.skipFully((InputStream)stream, (long)effectiveStart);
            ByteStreams.readFully((InputStream)stream, (byte[])buff);
        }
        return Source$.MODULE$.fromBytes(buff, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    public String offsetBytes(Seq<File> files, Seq<Object> fileLengths, long start, long end) {
        Predef$.MODULE$.assert(files.length() == fileLengths.length());
        long startIndex = package$.MODULE$.max(start, 0L);
        long endIndex = package$.MODULE$.min(end, BoxesRunTime.unboxToLong((Object)fileLengths.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        scala.collection.immutable.Map<File, Object> fileToLength = org.apache.spark.util.collection.Utils$.MODULE$.toMap(files, fileLengths);
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Log files: \n" + fileToLength.mkString("\n"));
        StringBuffer stringBuffer = new StringBuffer((int)(endIndex - startIndex));
        LongRef sum = LongRef.create((long)0L);
        ((IterableOnceOps)files.zip(fileLengths)).foreach((Function1 & Serializable)x0$1 -> {
            Utils$.$anonfun$offsetBytes$2(sum, fileToLength, endIndex, startIndex, stringBuffer, x0$1);
            return BoxedUnit.UNIT;
        });
        return stringBuffer.toString();
    }

    public <T> T clone(T value, SerializerInstance serializer, ClassTag<T> evidence$2) {
        return serializer.deserialize(serializer.serialize(value, evidence$2), evidence$2);
    }

    private boolean isSpace(char c) {
        return " \t\r\n".indexOf(c) != -1;
    }

    public Seq<String> splitCommandString(String s) {
        ArrayBuffer buf;
        block14: {
            buf = new ArrayBuffer();
            boolean inWord = false;
            boolean inSingleQuote = false;
            boolean inDoubleQuote = false;
            StringBuilder curWord = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                BoxedUnit boxedUnit;
                char nextChar = s.charAt(i);
                if (inDoubleQuote) {
                    if (nextChar == '\"') {
                        inDoubleQuote = false;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (nextChar == '\\') {
                        if (i < s.length() - 1) {
                            curWord.append(s.charAt(i + 1));
                            ++i;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = curWord.append(nextChar);
                    continue;
                }
                if (inSingleQuote) {
                    if (nextChar == '\'') {
                        inSingleQuote = false;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = curWord.append(nextChar);
                    continue;
                }
                if (nextChar == '\"') {
                    inWord = true;
                    inDoubleQuote = true;
                } else if (nextChar == '\'') {
                    inWord = true;
                    inSingleQuote = true;
                } else if (!this.isSpace(nextChar)) {
                    curWord.append(nextChar);
                    inWord = true;
                } else if (inWord && this.isSpace(nextChar)) {
                    Utils$.endWord$1(buf, curWord);
                    inWord = false;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!inWord && !inDoubleQuote && !inSingleQuote) break block14;
            Utils$.endWord$1(buf, curWord);
        }
        return buf.toSeq();
    }

    public int nonNegativeMod(int x, int mod) {
        int rawMod;
        return rawMod + ((rawMod = x % mod) < 0 ? mod : 0);
    }

    public int nonNegativeHash(Object obj) {
        if (obj == null) {
            return 0;
        }
        int hash = obj.hashCode();
        int hashAbs = Integer.MIN_VALUE != hash ? package$.MODULE$.abs(hash) : 0;
        return hashAbs;
    }

    public Map<String, String> getSystemProperties() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(System.getProperties().stringPropertyNames()).asScala().map((Function1 & Serializable)key -> new Tuple2(key, (Object)System.getProperty(key)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void times(int numIters, Function0<BoxedUnit> f) {
        for (int i = 0; i < numIters; ++i) {
            f.apply$mcV$sp();
        }
    }

    public long timeIt(int numIters, Function0<BoxedUnit> f, Option<Function0<BoxedUnit>> prepare) {
        if (prepare.isEmpty()) {
            long startNs = System.nanoTime();
            this.times(numIters, f);
            return System.nanoTime() - startNs;
        }
        long sum = 0L;
        for (int i = 0; i < numIters; ++i) {
            ((Function0)prepare.get()).apply$mcV$sp();
            long startNs = System.nanoTime();
            f.apply$mcV$sp();
            sum += System.nanoTime() - startNs;
        }
        return sum;
    }

    public Option<Function0<BoxedUnit>> timeIt$default$3(int numIters) {
        return None$.MODULE$;
    }

    public long getIteratorSize(Iterator<Object> iterator) {
        if (iterator.knownSize() >= 0) {
            return iterator.knownSize();
        }
        long count = 0L;
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    public <T> Iterator<Tuple2<T, Object>> getIteratorZipWithIndex(Iterator<T> iter, long startIndex) {
        return new Iterator<Tuple2<T, Object>>(startIndex, iter){
            private long index;
            private final Iterator iter$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<Tuple2<T, Object>> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<Tuple2<T, Object>> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<Tuple2<T, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<Tuple2<T, Object>>, Iterator<Tuple2<T, Object>>> partition(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<T, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<T, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<Tuple2<T, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<Tuple2<T, Object>> filter(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<Tuple2<T, Object>> filterNot(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<Tuple2<T, Object>> filterImpl(Function1<Tuple2<T, Object>, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<Tuple2<T, Object>> withFilter(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<T, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<Tuple2<T, Object>> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<Tuple2<T, Object>> distinctBy(Function1<Tuple2<T, Object>, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<Tuple2<T, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<T, Object>, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<Tuple2<T, Object>, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<Tuple2<T, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<T, Object>> takeWhile(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<Tuple2<T, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<T, Object>> dropWhile(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<T, Object>>, Iterator<Tuple2<T, Object>>> span(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<T, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<T, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<Tuple2<T, Object>, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<Tuple2<T, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<Tuple2<T, Object>>, Iterator<Tuple2<T, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U$> Iterator<Tuple2<T, Object>> tapEach(Function1<Tuple2<T, Object>, U$> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<Tuple2<T, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<T, Object>>, Iterator<Tuple2<T, Object>>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U$> void foreach(Function1<Tuple2<T, Object>, U$> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Tuple2<T, Object>, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Tuple2<T, Object>, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Tuple2<T, Object>, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Tuple2<T, Object>> find(Function1<Tuple2<T, Object>, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<T, Object>, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<T, Object>, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, Tuple2<T, Object>, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<Tuple2<T, Object>, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<T, Object>, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<T, Object>, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<T, Object>, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<T, Object>, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple2<T, Object>> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Tuple2<T, Object>> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<Tuple2<T, Object>> maxByOption(Function1<Tuple2<T, Object>, B> f, Ordering<B> ord) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
            }

            public Object minBy(Function1 f, Ordering ord) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<Tuple2<T, Object>> minByOption(Function1<Tuple2<T, Object>, B> f, Ordering<B> ord) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<T, Object>, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<T, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<Tuple2<T, Object>, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Tuple2<T, Object>, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Tuple2<T, Object>> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Tuple2<T, Object>> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<Tuple2<T, Object>> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K$, V$> scala.collection.immutable.Map<K$, V$> toMap(.less.colon.less<Tuple2<T, Object>, Tuple2<K$, V$>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Tuple2<T, Object>> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Tuple2<T, Object>> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Tuple2<T, Object>> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Tuple2<T, Object>> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<Tuple2<T, Object>, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private long index() {
                return this.index;
            }

            private void index_$eq(long x$1) {
                this.index = x$1;
            }

            public boolean hasNext() {
                return this.iter$1.hasNext();
            }

            public Tuple2<T, Object> next() {
                this.index_$eq(this.index() + 1L);
                return new Tuple2(this.iter$1.next(), (Object)BoxesRunTime.boxToLong((long)this.index()));
            }
            {
                this.iter$1 = iter$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                Predef$.MODULE$.require(startIndex$2 >= 0L, (Function0 & Serializable)() -> "startIndex should be >= 0.");
                this.index = startIndex$2 - 1L;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1()}, serializedLambda);
            }
        };
    }

    public void symlink(File src, File dst) {
        if (!src.isAbsolute()) {
            throw new IOException("Source must be absolute");
        }
        if (dst.isAbsolute()) {
            throw new IOException("Destination must be relative");
        }
        java.nio.file.Files.createSymbolicLink(dst.toPath(), src.toPath(), new FileAttribute[0]);
    }

    public FileSystem getHadoopFileSystem(URI path, Configuration conf) {
        return FileSystem.get((URI)path, (Configuration)conf);
    }

    public FileSystem getHadoopFileSystem(String path, Configuration conf) {
        return this.getHadoopFileSystem(new URI(path), conf);
    }

    public boolean isWindows() {
        return isWindows;
    }

    public boolean isMac() {
        return isMac;
    }

    public boolean isJavaVersionAtLeast21() {
        return isJavaVersionAtLeast21;
    }

    public boolean isMacOnAppleSilicon() {
        return isMacOnAppleSilicon;
    }

    public boolean preferIPv6() {
        return preferIPv6;
    }

    public Regex windowsDrive() {
        return windowsDrive;
    }

    public Option<Object> terminateProcess(Process process, long timeoutMs) {
        Process process2;
        process.destroy();
        if (process.waitFor(timeoutMs, TimeUnit.MILLISECONDS)) {
            return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
        }
        try {
            process2 = process.destroyForcibly();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Exception when attempting to kill process", throwable2);
                process2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        if (process.waitFor(timeoutMs, TimeUnit.MILLISECONDS)) {
            return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
        }
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Timed out waiting to forcibly kill process");
        return None$.MODULE$;
    }

    public Option<String> getStderr(Process process, long timeoutMs) {
        boolean terminated = process.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
        if (terminated) {
            return new Some((Object)Source$.MODULE$.fromInputStream(process.getErrorStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n"));
        }
        return None$.MODULE$;
    }

    public <T> T logUncaughtExceptions(Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (ControlThrowable ct) {
            throw ct;
        }
        catch (Throwable t) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Uncaught exception in thread ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.THREAD_NAME$.MODULE$, (Object)Thread.currentThread().getName())}))), t);
            throw t;
        }
        return (T)object;
    }

    public <T> Try<T> tryLog(Function0<T> f) {
        Success success;
        try {
            Object res = f.apply();
            success = new Success(res);
        }
        catch (ControlThrowable ct) {
            throw ct;
        }
        catch (Throwable t) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Uncaught exception in thread ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.THREAD_NAME$.MODULE$, (Object)Thread.currentThread().getName())}))), t);
            success = new Failure(t);
        }
        return success;
    }

    public boolean isFatalError(Throwable e) {
        Option option;
        Throwable throwable = e;
        return !(throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty() ? true : (throwable instanceof InterruptedException ? true : (throwable instanceof NotImplementedError ? true : (throwable instanceof ControlThrowable ? true : throwable instanceof LinkageError))));
    }

    public String resolveURIs(String paths) {
        if (paths == null || paths.trim().isEmpty()) {
            return "";
        }
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])paths.split(",")), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7.trim()))))), (Function1 & Serializable)p -> MODULE$.resolveURI((String)p), ClassTag$.MODULE$.apply(URI.class))).mkString(",");
    }

    public String[] nonLocalPaths(String paths, boolean testWindows) {
        boolean windows;
        boolean bl = windows = this.isWindows() || testWindows;
        if (paths == null || paths.trim().isEmpty()) {
            return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        return (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])paths.split(",")), (Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$nonLocalPaths$1(windows, p)));
    }

    public boolean nonLocalPaths$default$2() {
        return false;
    }

    public String loadDefaultSparkProperties(SparkConf conf, String filePath) {
        String path = (String)Option$.MODULE$.apply((Object)filePath).getOrElse((Function0 & Serializable)() -> MODULE$.getDefaultPropertiesFile(MODULE$.getDefaultPropertiesFile$default$1()));
        Option$.MODULE$.apply((Object)path).foreach((Function1 & Serializable)confFile -> {
            Utils$.$anonfun$loadDefaultSparkProperties$2(conf, confFile);
            return BoxedUnit.UNIT;
        });
        return path;
    }

    public String loadDefaultSparkProperties$default$2() {
        return null;
    }

    public String trimExceptCRLF(String str) {
        Function1 & Serializable nonSpaceOrNaturalLineDelimiter = (Function1 & Serializable)ch -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$trimExceptCRLF$1(BoxesRunTime.unboxToChar((Object)ch)));
        String qual$1 = Predef$.MODULE$.augmentString(str);
        Function1 & Serializable x$1 = nonSpaceOrNaturalLineDelimiter;
        int x$2 = StringOps$.MODULE$.indexWhere$default$2$extension(qual$1);
        int firstPos = StringOps$.MODULE$.indexWhere$extension(qual$1, (Function1)x$1, x$2);
        String qual$2 = Predef$.MODULE$.augmentString(str);
        Function1 & Serializable x$3 = nonSpaceOrNaturalLineDelimiter;
        int x$4 = StringOps$.MODULE$.lastIndexWhere$default$2$extension(qual$2);
        int lastPos = StringOps$.MODULE$.lastIndexWhere$extension(qual$2, (Function1)x$3, x$4);
        if (firstPos >= 0 && lastPos >= 0) {
            return str.substring(firstPos, lastPos + 1);
        }
        return "";
    }

    public Map<String, String> getPropertiesFromFile(String filename) {
        scala.collection.immutable.Map map;
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable)() -> "Properties file " + file + " does not exist");
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable)() -> "Properties file " + file + " is not a normal file");
        try (InputStreamReader inReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            try {
                Properties properties = new Properties();
                properties.load(inReader);
                map = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(properties.stringPropertyNames()).asScala().map((Function1 & Serializable)k -> new Tuple2(k, (Object)MODULE$.trimExceptCRLF(properties.getProperty((String)k))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            catch (IOException e) {
                throw new SparkException("Failed when loading Spark properties from " + filename, (Throwable)e);
            }
        }
        return map;
    }

    public String getDefaultPropertiesFile(Map<String, String> env) {
        return (String)env.get((Object)"SPARK_CONF_DIR").orElse((Function0 & Serializable)() -> env.get((Object)"SPARK_HOME").map((Function1 & Serializable)t -> t + File.separator + "conf")).map((Function1 & Serializable)t -> new File(t + File.separator + "spark-defaults.conf")).filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isFile())).map((Function1 & Serializable)x$9 -> x$9.getAbsolutePath()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, String> getDefaultPropertiesFile$default$1() {
        return scala.sys.package$.MODULE$.env();
    }

    public String exceptionString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private Utils.Lock Lock(LockInfo lock) {
        return new Utils.Lock(lock);
    }

    public ThreadStackTrace[] getThreadDump() {
        ThreadInfo[] threadInfos = (ThreadInfo[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$getThreadDump$1(x$10)));
        return (ThreadStackTrace[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortWith$extension(Predef$.MODULE$.refArrayOps((Object[])threadInfos), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$getThreadDump$2(x0$1, x1$1)))), (Function1 & Serializable)threadInfo -> MODULE$.threadInfoToThreadStackTrace((ThreadInfo)threadInfo), ClassTag$.MODULE$.apply(ThreadStackTrace.class));
    }

    public String[] getHeapHistogram() {
        String pid = String.valueOf(ProcessHandle.current().pid());
        String jmap = System.getProperty("java.home") + "/bin/jmap";
        ProcessBuilder builder = new ProcessBuilder(jmap, "-histo:live", pid);
        Process p = builder.start();
        ArrayBuffer rows = ArrayBuffer$.MODULE$.empty();
        this.tryWithResource((Function0 & Serializable)() -> new BufferedReader(new InputStreamReader(p.getInputStream())), (Function1 & Serializable)r -> {
            Utils$.$anonfun$getHeapHistogram$2(rows, r);
            return BoxedUnit.UNIT;
        });
        return (String[])rows.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Option<ThreadStackTrace> getThreadDumpForThread(long threadId) {
        if (threadId <= 0L) {
            return None$.MODULE$;
        }
        Option threadInfo2 = Option$.MODULE$.apply((Object)ManagementFactory.getThreadMXBean().getThreadInfo(threadId, Integer.MAX_VALUE));
        return threadInfo2.map((Function1 & Serializable)threadInfo -> MODULE$.threadInfoToThreadStackTrace((ThreadInfo)threadInfo));
    }

    private ThreadStackTrace threadInfoToThreadStackTrace(ThreadInfo threadInfo) {
        Thread.State threadState = threadInfo.getThreadState();
        scala.collection.immutable.Map monitors = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])threadInfo.getLockedMonitors()), (Function1 & Serializable)m -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)m.getLockedStackDepth())), (Object)m.toString()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        StackTrace stackTrace = new StackTrace((Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])threadInfo.getStackTrace()))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Thread.State state;
                StackTraceElement frame = (StackTraceElement)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String locked = idx == 0 && threadInfo.getLockInfo() != null ? (((Object)((Object)Thread.State.BLOCKED)).equals((Object)(state = threadState)) ? "\t-  blocked on " + threadInfo.getLockInfo() + "\n" : ((((Object)((Object)Thread.State.WAITING)).equals((Object)state) ? true : ((Object)((Object)Thread.State.TIMED_WAITING)).equals((Object)state)) ? "\t-  waiting on " + threadInfo.getLockInfo() + "\n" : "")) : "";
                String locking = (String)monitors.get((Object)BoxesRunTime.boxToInteger((int)idx)).map((Function1 & Serializable)mi -> "\t-  locked " + mi + "\n").getOrElse((Function0 & Serializable)() -> "");
                return frame.toString() + "\n" + locked + locking;
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq());
        String[] synchronizers = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])threadInfo.getLockedSynchronizers()), (Function1 & Serializable)x$11 -> x$11.toString(), ClassTag$.MODULE$.apply(String.class));
        Seq monitorStrs = monitors.values().toSeq();
        return new ThreadStackTrace(threadInfo.getThreadId(), threadInfo.getThreadName(), threadState, stackTrace, (Option<Object>)(threadInfo.getLockOwnerId() < 0L ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)threadInfo.getLockOwnerId()))), (String)Option$.MODULE$.apply((Object)threadInfo.getLockInfo()).map((Function1 & Serializable)x$12 -> MODULE$.Lock((LockInfo)x$12).lockString()).getOrElse((Function0 & Serializable)() -> ""), (Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])synchronizers), (IterableOnce)monitorStrs, ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq(), (Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)synchronizers).toImmutableArraySeq(), (Seq<String>)monitorStrs, (Option<String>)Option$.MODULE$.apply((Object)threadInfo.getLockName()), (Option<String>)Option$.MODULE$.apply((Object)threadInfo.getLockOwnerName()), threadInfo.isSuspended(), threadInfo.isInNative(), threadInfo.isDaemon(), threadInfo.getPriority());
    }

    public Seq<String> sparkJavaOpts(SparkConf conf, Function1<String, Object> filterKey) {
        return ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])conf.getAll()), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$sparkJavaOpts$1(filterKey, x0$1)))), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return "-D" + k + "=" + v;
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq();
    }

    public Function1<String, Object> sparkJavaOpts$default$2() {
        return (Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$sparkJavaOpts$default$2$1(x$13));
    }

    public int portMaxRetries(SparkConf conf) {
        Option maxRetries = conf.getOption("spark.port.maxRetries").map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$14))));
        if (conf.contains((ConfigEntry<?>)Tests$.MODULE$.IS_TESTING())) {
            return BoxesRunTime.unboxToInt((Object)maxRetries.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 100));
        }
        return BoxesRunTime.unboxToInt((Object)maxRetries.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 16));
    }

    public int userPort(int base, int offset) {
        return (base + offset - 1024) % 64512 + 1024;
    }

    public <T> Tuple2<T, Object> startServiceOnPort(int startPort, Function1<Object, Tuple2<T, Object>> startService, SparkConf conf, String serviceName) {
        return this.startServiceOnPort(startPort, startService, this.portMaxRetries(conf), serviceName);
    }

    public <T> Tuple2<T, Object> startServiceOnPort(int startPort, Function1<Object, Tuple2<T, Object>> startService, int maxRetries, String serviceName) {
        Object object = new Object();
        try {
            Predef$.MODULE$.require(startPort == 0 || 1024 <= startPort && startPort < 65536, (Function0 & Serializable)() -> "startPort should be between 1024 and 65535 (inclusive), or 0 for a random free port.");
            Object serviceString = serviceName.isEmpty() ? "" : " '" + serviceName + "'";
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), maxRetries).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> Utils$.$anonfun$startServiceOnPort$2(startPort, startService, (String)serviceString, object, maxRetries, arg_0)));
            throw new SparkException("Failed to start service" + (String)serviceString + " on port " + startPort);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple2)ex.value();
        }
    }

    public <T> String startServiceOnPort$default$4() {
        return "";
    }

    public boolean isBindCollision(Throwable exception2) {
        while (true) {
            Throwable throwable;
            if ((throwable = exception2) instanceof BindException) {
                BindException bindException = (BindException)throwable;
                if (bindException.getMessage() != null) {
                    return true;
                }
                exception2 = bindException.getCause();
                continue;
            }
            if (throwable instanceof MultiException) {
                MultiException multiException = (MultiException)throwable;
                return CollectionConverters$.MODULE$.ListHasAsScala(multiException.getThrowables()).asScala().exists((Function1 & Serializable)exception -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isBindCollision(exception)));
            }
            if (throwable instanceof Errors.NativeIoException) {
                Errors.NativeIoException nativeIoException = (Errors.NativeIoException)throwable;
                if (nativeIoException.getMessage() == null || !nativeIoException.getMessage().startsWith("bind() failed: ")) {
                    exception2 = nativeIoException.getCause();
                    continue;
                }
                return true;
            }
            if (throwable instanceof IOException) {
                IOException iOException = (IOException)throwable;
                if (iOException.getMessage() == null || !iOException.getMessage().startsWith("Failed to bind to address")) {
                    exception2 = iOException.getCause();
                    continue;
                }
                return true;
            }
            if (!(throwable instanceof Exception)) break;
            Exception exception3 = (Exception)throwable;
            exception2 = exception3.getCause();
        }
        return false;
    }

    public void setLogLevel(Level l) {
        Tuple2<LoggerContext, LoggerConfig> tuple2 = this.getLogContext();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LoggerContext ctx = (LoggerContext)tuple2._1();
        LoggerConfig loggerConfig = (LoggerConfig)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)ctx, (Object)loggerConfig);
        LoggerContext ctx2 = (LoggerContext)tuple22._1();
        LoggerConfig loggerConfig2 = (LoggerConfig)tuple22._2();
        loggerConfig2.setLevel(l);
        ctx2.updateLoggers();
        Logging$.MODULE$.sparkShellThresholdLevel_$eq(null);
    }

    public void setLogLevelIfNeeded(String newLogLevel) {
        String string = newLogLevel;
        String string2 = this.getLogLevel();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.setLogLevel(Level.toLevel((String)newLogLevel));
            return;
        }
    }

    private Tuple2<LoggerContext, LoggerConfig> getLogContext$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
                getLogContext = new Tuple2((Object)ctx, (Object)ctx.getConfiguration().getLoggerConfig(""));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return getLogContext;
    }

    private Tuple2<LoggerContext, LoggerConfig> getLogContext() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.getLogContext$lzycompute();
        }
        return getLogContext;
    }

    public String getLogLevel() {
        Tuple2<LoggerContext, LoggerConfig> tuple2 = this.getLogContext();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LoggerConfig loggerConfig = (LoggerConfig)tuple2._2();
        LoggerConfig loggerConfig2 = loggerConfig;
        return loggerConfig2.getLevel().name();
    }

    public String libraryPathEnvName() {
        if (this.isWindows()) {
            return "PATH";
        }
        if (this.isMac()) {
            return "DYLD_LIBRARY_PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    public String libraryPathEnvPrefix(Seq<String> libraryPaths) {
        String libraryPathScriptVar = this.isWindows() ? "%" + this.libraryPathEnvName() + "%" : "$" + this.libraryPathEnvName();
        String libraryPath = ((IterableOnceOps)libraryPaths.$colon$plus((Object)libraryPathScriptVar)).mkString("\"", File.pathSeparator, "\"");
        String ampersand = this.isWindows() ? " &" : "";
        return this.libraryPathEnvName() + "=" + libraryPath + ampersand;
    }

    public String getSparkOrYarnConfig(SparkConf conf, String key, String string) {
        if (conf.contains(key)) {
            return conf.get(key, string);
        }
        String string2 = conf.get("spark.master", null);
        String string3 = "yarn";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new YarnConfiguration(SparkHadoopUtil$.MODULE$.get().newConfiguration(conf)).get(key, string);
        }
        return string;
    }

    public Tuple2<String, Object> extractHostPortFromSparkUrl(String sparkUrl) throws SparkException {
        Tuple2 tuple2;
        try {
            int port;
            String host;
            block5: {
                block4: {
                    URI uri = new URI(sparkUrl);
                    host = uri.getHost();
                    port = uri.getPort();
                    String string = uri.getScheme();
                    String string2 = "spark";
                    if (string != null ? !string.equals(string2) : string2 != null) break block4;
                    if (host != null && port >= 0 && (uri.getPath() == null || uri.getPath().isEmpty()) && uri.getFragment() == null && uri.getQuery() == null && uri.getUserInfo() == null) break block5;
                }
                throw new SparkException("Invalid master URL: " + sparkUrl);
            }
            tuple2 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
        }
        catch (URISyntaxException e) {
            throw new SparkException("Invalid master URL: " + sparkUrl, (Throwable)e);
        }
        return tuple2;
    }

    public String getCurrentUserName() {
        return (String)Option$.MODULE$.apply((Object)System.getenv("SPARK_USER")).getOrElse((Function0 & Serializable)() -> UserGroupInformation.getCurrentUser().getShortUserName());
    }

    public Set<String> EMPTY_USER_GROUPS() {
        return EMPTY_USER_GROUPS;
    }

    public Set<String> getCurrentUserGroups(SparkConf sparkConf, String username) {
        String groupProviderClassName;
        String string = groupProviderClassName = sparkConf.get(UI$.MODULE$.USER_GROUPS_MAPPING());
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            try {
                GroupMappingServiceProvider groupMappingServiceProvider = (GroupMappingServiceProvider)this.classForName(groupProviderClassName, this.classForName$default$2(), this.classForName$default$3()).getConstructor(new Class[0]).newInstance(new Object[0]);
                Set<String> currentUserGroups = groupMappingServiceProvider.getGroups(username);
                return currentUserGroups;
            }
            catch (Exception e) {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error getting groups for user=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.USER_NAME$.MODULE$, (Object)username)}))), (Throwable)e);
            }
        }
        return this.EMPTY_USER_GROUPS();
    }

    public String[] parseStandaloneMasterUrls(String masterUrls) {
        return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(masterUrls), "spark://").split(",")), (Function1 & Serializable)x$17 -> "spark://" + x$17, ClassTag$.MODULE$.apply(String.class));
    }

    public String BACKUP_STANDALONE_MASTER_PREFIX() {
        return BACKUP_STANDALONE_MASTER_PREFIX;
    }

    public boolean responseFromBackup(String msg) {
        return msg.startsWith(this.BACKUP_STANDALONE_MASTER_PREFIX());
    }

    public <T> T withDummyCallSite(SparkContext sc, Function0<T> body2) {
        Object object;
        String oldShortCallSite = sc.getLocalProperty(CallSite$.MODULE$.SHORT_FORM());
        String oldLongCallSite = sc.getLocalProperty(CallSite$.MODULE$.LONG_FORM());
        try {
            sc.setLocalProperty(CallSite$.MODULE$.SHORT_FORM(), "");
            sc.setLocalProperty(CallSite$.MODULE$.LONG_FORM(), "");
            object = body2.apply();
        }
        finally {
            sc.setLocalProperty(CallSite$.MODULE$.SHORT_FORM(), oldShortCallSite);
            sc.setLocalProperty(CallSite$.MODULE$.LONG_FORM(), oldLongCallSite);
        }
        return (T)object;
    }

    public boolean isInDirectory(File parent, File child) {
        while (child != null && parent != null) {
            if (!(child.exists() && parent.exists() && parent.isDirectory())) {
                return false;
            }
            if (parent.equals(child)) {
                return true;
            }
            child = child.getParentFile();
        }
        return false;
    }

    public boolean isLocalMaster(ReadOnlySparkConf conf) {
        String master;
        String string = master = conf.get("spark.master", "");
        String string2 = "local";
        return !(string == null ? string2 != null : !string.equals(string2)) || master.startsWith("local[");
    }

    /*
     * Unable to fully structure code
     */
    public boolean isPushBasedShuffleEnabled(SparkConf conf, boolean isDriver, boolean checkSerializer) {
        block3: {
            pushBasedShuffleEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.PUSH_BASED_SHUFFLE_ENABLED()));
            if (!pushBasedShuffleEnabled) break block3;
            serializerIsSupported$lzy = new LazyBoolean();
            isTesting = BoxesRunTime.unboxToBoolean((Object)((Option)conf.get(Tests$.MODULE$.IS_TESTING())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$isPushBasedShuffleEnabled$1(), ()Z)()));
            if (!BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) ** GOTO lbl-1000
            v0 = conf.get("spark.master", null);
            var9_7 = "yarn";
            if (!(v0 != null ? v0.equals(var9_7) == false : var9_7 != null)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            isShuffleServiceAndYarn = v1;
            ioEncryptionDisabled = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.IO_ENCRYPTION_ENABLED())) == false;
            v2 = canDoPushBasedShuffle = (isShuffleServiceAndYarn != false || isTesting != false) && ioEncryptionDisabled != false && Utils$.serializerIsSupported$1(serializerIsSupported$lzy, checkSerializer, conf, isDriver) != false;
            if (!canDoPushBasedShuffle) {
                this.logWarning(LogEntry$.MODULE$.from((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$isPushBasedShuffleEnabled$5(), ()Lorg/apache/spark/internal/MessageWithContext;)()));
            }
            return canDoPushBasedShuffle;
        }
        return false;
    }

    public boolean isPushBasedShuffleEnabled$default$3() {
        return true;
    }

    public <T> T instantiateSerializerOrShuffleManager(String className, SparkConf conf, boolean isDriver) {
        Object c;
        Class cls = this.classForName(className, this.classForName$default$2(), this.classForName$default$3());
        try {
            c = cls.getConstructor(SparkConf.class, Boolean.TYPE).newInstance(conf, isDriver);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                c = cls.getConstructor(SparkConf.class).newInstance(conf);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                c = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        return (T)c;
    }

    public <T> T instantiateSerializerFromConf(ConfigEntry<String> propertyName, SparkConf conf, boolean isDriver) {
        return this.instantiateSerializerOrShuffleManager(conf.get(propertyName), conf, isDriver);
    }

    public boolean isDynamicAllocationEnabled(ReadOnlySparkConf conf) {
        boolean dynamicAllocationEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_ENABLED()));
        return dynamicAllocationEnabled && (!this.isLocalMaster(conf) || BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_TESTING())));
    }

    public boolean isStreamingDynamicAllocationEnabled(SparkConf conf) {
        boolean streamingDynamicAllocationEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_ENABLED()));
        return streamingDynamicAllocationEnabled && (!this.isLocalMaster(conf) || BoxesRunTime.unboxToBoolean((Object)conf.get(Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_TESTING())));
    }

    public int getDynamicAllocationInitialExecutors(SparkConf conf) {
        if (BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_INITIAL_EXECUTORS())) < BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS()))) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " less than "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG$.MODULE$, (Object)org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_INITIAL_EXECUTORS().key())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is invalid, ignoring its setting, "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG2$.MODULE$, (Object)org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS().key())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"please update your configs."}))).log((Seq)Nil$.MODULE$))));
        }
        if (BoxesRunTime.unboxToInt((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) < BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS()))) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " less than "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG$.MODULE$, (Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is invalid, ignoring its setting, "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG2$.MODULE$, (Object)org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS().key())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"please update your configs."}))).log((Seq)Nil$.MODULE$))));
        }
        int initialExecutors = BoxesRunTime.unboxToInt((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS())), BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_INITIAL_EXECUTORS())), BoxesRunTime.unboxToInt((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0))})).max((Ordering)Ordering.Int$.MODULE$));
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Using initial executors = ", ", max of "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_EXECUTORS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)initialExecutors))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ","}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG$.MODULE$, (Object)org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_INITIAL_EXECUTORS().key())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " and"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG2$.MODULE$, (Object)org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS().key())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG3$.MODULE$, (Object)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key())})))));
        return initialExecutors;
    }

    public File tempFileWith(File path) {
        return new File(path.getAbsolutePath() + "." + UUID.randomUUID());
    }

    public String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    public void initDaemon(Logger log) {
        log.info("Started daemon with process name: " + this.getProcessName());
        SignalUtils$.MODULE$.registerLogger(log);
    }

    public void resetStructuredLogging() {
        if (System.getProperty(org.apache.spark.internal.config.package$.MODULE$.STRUCTURED_LOGGING_ENABLED().key(), "false").equals("false")) {
            Logging$.MODULE$.disableStructuredLogging();
            return;
        }
        Logging$.MODULE$.enableStructuredLogging();
    }

    public void resetStructuredLogging(SparkConf sparkConf) {
        if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.STRUCTURED_LOGGING_ENABLED()))) {
            Logging$.MODULE$.enableStructuredLogging();
            return;
        }
        Logging$.MODULE$.disableStructuredLogging();
    }

    public Seq<String> getUserJars(SparkConf conf) {
        return (Seq)((IterableOps)conf.get(org.apache.spark.internal.config.package$.MODULE$.JARS())).filter((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$20))));
    }

    public Seq<String> getLocalUserJarsForShell(SparkConf conf) {
        Option<String> localJars = conf.getOption("spark.repl.local.jars");
        return (Seq)Option$.MODULE$.option2Iterable(localJars.map((Function1 & Serializable)x$21 -> x$21.split(",")).map((Function1 & Serializable)x$22 -> (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])x$22), (Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$23)))))).toSeq().flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
    }

    public String REDACTION_REPLACEMENT_TEXT() {
        return REDACTION_REPLACEMENT_TEXT;
    }

    public scala.collection.Seq<Tuple2<String, String>> redact(SparkConf conf, scala.collection.Seq<Tuple2<String, String>> kvs) {
        Regex redactionPattern = conf.get(org.apache.spark.internal.config.package$.MODULE$.SECRET_REDACTION_PATTERN());
        return this.redact(redactionPattern, kvs);
    }

    public <K, V> scala.collection.Seq<Tuple2<K, V>> redact(Option<Regex> regex, scala.collection.Seq<Tuple2<K, V>> kvs) {
        Option<Regex> option = regex;
        if (None$.MODULE$.equals(option)) {
            return kvs;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex r = (Regex)some.value();
            return this.redact(r, kvs);
        }
        throw new MatchError(option);
    }

    public String redact(Option<Regex> regex, String text) {
        Option<Regex> option = regex;
        if (None$.MODULE$.equals(option)) {
            return text;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex r = (Regex)some.value();
            if (text == null || text.isEmpty()) {
                return text;
            }
            return r.replaceAllIn((CharSequence)text, this.REDACTION_REPLACEMENT_TEXT());
        }
        throw new MatchError(option);
    }

    private <K, V> scala.collection.Seq<Tuple2<K, V>> redact(Regex redactionPattern, scala.collection.Seq<Tuple2<K, V>> kvs) {
        return (scala.collection.Seq)kvs.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                if (key instanceof String) {
                    String string = (String)key;
                    if (value instanceof String) {
                        String string2 = (String)value;
                        return (Tuple2)redactionPattern.findFirstIn((CharSequence)string).orElse((Function0 & Serializable)() -> redactionPattern.findFirstIn((CharSequence)string2)).map((Function1 & Serializable)x$24 -> new Tuple2((Object)string, (Object)MODULE$.REDACTION_REPLACEMENT_TEXT())).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)string, (Object)string2));
                    }
                }
            }
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                if (value instanceof String) {
                    String string = (String)value;
                    return (Tuple2)redactionPattern.findFirstIn((CharSequence)string).map((Function1 & Serializable)x$25 -> new Tuple2(key, (Object)MODULE$.REDACTION_REPLACEMENT_TEXT())).getOrElse((Function0 & Serializable)() -> new Tuple2(key, (Object)string));
                }
            }
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                return new Tuple2(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public scala.collection.Seq<Tuple2<String, String>> redact(Map<String, String> kvs) {
        Regex redactionPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString((String)kvs.getOrElse((Object)org.apache.spark.internal.config.package$.MODULE$.SECRET_REDACTION_PATTERN().key(), (Function0 & Serializable)() -> org.apache.spark.internal.config.package$.MODULE$.SECRET_REDACTION_PATTERN().defaultValueString())));
        return this.redact(redactionPattern, (scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])kvs.toArray(ClassTag$.MODULE$.apply(Tuple2.class))));
    }

    public Seq<String> redactCommandLineArgs(SparkConf conf, Seq<String> commands) {
        Regex redactionPattern = conf.get(org.apache.spark.internal.config.package$.MODULE$.SECRET_REDACTION_PATTERN());
        return (Seq)commands.map((Function1 & Serializable)x0$1 -> {
            Option option;
            String string = x0$1;
            if (string != null && !(option = MODULE$.PATTERN_FOR_COMMAND_LINE_ARG().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
                String value;
                String key = (String)((LinearSeqOps)option.get()).apply(0);
                Tuple2 tuple2 = (Tuple2)MODULE$.redact(redactionPattern, (scala.collection.Seq)new .colon.colon((Object)new Tuple2((Object)key, (Object)(value = (String)((LinearSeqOps)option.get()).apply(1))), (List)Nil$.MODULE$)).head();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String newValue = (String)tuple2._2();
                String newValue2 = newValue;
                return "-D" + key + "=" + newValue2;
            }
            return string;
        });
    }

    public <T> Seq<T> loadExtensions(Class<T> extClass, Seq<String> classes, SparkConf conf) {
        return (Seq)classes.flatMap((Function1 & Serializable)name -> {
            None$ none$;
            try {
                Object object;
                Class klass = MODULE$.classForName((String)name, MODULE$.classForName$default$2(), MODULE$.classForName$default$3());
                Predef$.MODULE$.require(extClass.isAssignableFrom(klass), (Function0 & Serializable)() -> name + " is not a subclass of " + extClass.getName() + ".");
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> klass.getConstructor(SparkConf.class));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Constructor ctor = (Constructor)success.value();
                    object = ctor.newInstance(conf);
                } else if (try_ instanceof Failure) {
                    object = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    throw new MatchError((Object)try_);
                }
                Object ext = object;
                none$ = new Some(ext);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SparkException(name + " did not have a zero-argument constructor or a single-argument constructor that accepts SparkConf. Note: if the class is defined inside of another Scala class, then its constructors may accept an implicit parameter that references the enclosing class; in this case, you must define the class as a top-level class in order to prevent this extra parameter from breaking Spark's ability to find a valid constructor.");
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof UnsupportedOperationException) {
                    UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Extension " + name + " not being initialized.", (Throwable)unsupportedOperationException);
                    MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Extension ", " not being initialized."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CLASS_NAME$.MODULE$, name)}))));
                    none$ = None$.MODULE$;
                }
                if (throwable == null) {
                    throw e;
                }
                throw throwable;
            }
            return none$;
        });
    }

    /*
     * Unable to fully structure code
     */
    public String checkAndGetK8sMasterUrl(String rawMasterURL) {
        Predef$.MODULE$.require(rawMasterURL.startsWith("k8s://"), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkAndGetK8sMasterUrl$1(), ()Ljava/lang/String;)());
        masterWithoutK8sPrefix = rawMasterURL.substring("k8s://".length());
        if (!masterWithoutK8sPrefix.contains("://")) {
            resolvedURL = "https://" + masterWithoutK8sPrefix;
            this.logInfo(LogEntry$.MODULE$.from((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkAndGetK8sMasterUrl$2(java.lang.String ), ()Lorg/apache/spark/internal/MessageWithContext;)((String)resolvedURL)));
            return "k8s://" + resolvedURL;
        }
        masterScheme = new URI(masterWithoutK8sPrefix).getScheme();
        var7_5 = false;
        var8_6 = null;
        var9_7 = Option$.MODULE$.apply((Object)masterScheme).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$checkAndGetK8sMasterUrl$3(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
        if (!(var9_7 instanceof Some)) ** GOTO lbl-1000
        var7_5 = true;
        var8_6 = (Some)var9_7;
        var10_8 = (String)var8_6.value();
        if ("https".equals(var10_8)) {
            v0 = masterWithoutK8sPrefix;
        } else if (var7_5 && "http".equals(var11_9 = (String)var8_6.value())) {
            this.logWarning(LogEntry$.MODULE$.from((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkAndGetK8sMasterUrl$4(), ()Lorg/apache/spark/internal/MessageWithContext;)()));
            v0 = masterWithoutK8sPrefix;
        } else {
            throw new IllegalArgumentException("Invalid Kubernetes master scheme: " + masterScheme + " found in URL: " + masterWithoutK8sPrefix);
        }
        resolvedURL = v0;
        return "k8s://" + resolvedURL;
    }

    public String substituteAppNExecIds(String opt, String appId, String execId) {
        return opt.replace("{{APP_ID}}", appId).replace("{{EXECUTOR_ID}}", execId);
    }

    public String substituteAppId(String opt, String appId) {
        return opt.replace("{{APP_ID}}", appId);
    }

    public String createSecret(SparkConf conf) {
        int bits = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.AUTH_SECRET_BIT_LENGTH()));
        SecureRandom rnd = new SecureRandom();
        byte[] secretBytes = new byte[bits / 8];
        rnd.nextBytes(secretBytes);
        return Hex.encodeHexString((byte[])secretBytes);
    }

    private Regex fullWidthRegex() {
        return fullWidthRegex;
    }

    public int stringHalfWidth(String str) {
        if (str == null) {
            return 0;
        }
        return str.length() + this.fullWidthRegex().findAllIn((CharSequence)str).size();
    }

    public String sanitizeDirName(String str) {
        return str.replaceAll("[ :/]", "-").replaceAll("[.${}'\"]", "_").toLowerCase(Locale.ROOT);
    }

    public String nameForAppAndAttempt(String appId, Option<String> appAttemptId) {
        String base = this.sanitizeDirName(appId);
        if (appAttemptId.isDefined()) {
            return base + "_" + this.sanitizeDirName((String)appAttemptId.get());
        }
        return base;
    }

    public boolean isClientMode(SparkConf conf) {
        return "client".equals(conf.get("spark.submit.deployMode", "client"));
    }

    public boolean isLocalUri(String uri) {
        return uri.startsWith(this.LOCAL_SCHEME() + ":");
    }

    public UriBuilder getUriBuilder(URI uri) {
        return UriBuilder.fromUri((URI)uri);
    }

    public UriBuilder getUriBuilder(String uri) {
        return UriBuilder.fromUri((String)uri);
    }

    public boolean isFileSplittable(Path path, CompressionCodecFactory codecFactory) {
        CompressionCodec codec = codecFactory.getCodec(path);
        return codec == null || codec instanceof SplittableCompressionCodec;
    }

    public Properties cloneProperties(Properties props) {
        if (props == null) {
            return props;
        }
        Properties resultProps = new Properties();
        resultProps.putAll((java.util.Map<?, ?>)((Properties)props.clone()));
        return resultProps;
    }

    public String buildLocationMetadata(Seq<Path> paths, int stopAppendingThreshold) {
        int index;
        StringBuilder metadata = new StringBuilder("(" + paths.length() + " paths)[");
        for (index = 0; index < paths.length() && metadata.length() < stopAppendingThreshold; ++index) {
            Object object = index > 0 ? metadata.append(", ") : BoxedUnit.UNIT;
            metadata.append(((Path)paths.apply(index)).toString());
        }
        if (paths.length() > index) {
            Object object = index > 0 ? metadata.append(", ") : BoxedUnit.UNIT;
            v2 = metadata.append("...");
        } else {
            v2 = BoxedUnit.UNIT;
        }
        metadata.append("]");
        return metadata.toString();
    }

    public int executorOffHeapMemorySizeAsMb(SparkConf sparkConf) {
        int sizeInMB = this.memoryStringToMb(sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_SIZE()).toString());
        return (int)this.checkOffHeapEnabled(sparkConf, sizeInMB);
    }

    public long checkOffHeapEnabled(SparkConf sparkConf, long offHeapSize) {
        if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_ENABLED()))) {
            Predef$.MODULE$.require(offHeapSize > 0L, (Function0 & Serializable)() -> org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_SIZE().key() + " must be > 0 when " + org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_ENABLED().key() + " == true");
            return offHeapSize;
        }
        return 0L;
    }

    public MessageWithContext createFailedToGetTokenMessage(String serviceName, Throwable e) {
        return this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get token from service ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SERVICE_NAME$.MODULE$, (Object)serviceName)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"due to ", ". If ", " is not used, "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ERROR$.MODULE$, (Object)e), new MDC((LogKey)LogKeys.SERVICE_NAME$.MODULE$, (Object)serviceName)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"set spark.security.credentials.", ".enabled to false."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SERVICE_NAME$.MODULE$, (Object)serviceName)})));
    }

    public Seq<File> unzipFilesFromFile(FileSystem fs, Path dfsZipFile, File localDir) {
        ArrayBuffer files = new ArrayBuffer();
        ZipInputStream in = new ZipInputStream((InputStream)fs.open(dfsZipFile));
        FileOutputStream out = null;
        try {
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String fileName = ((Object)localDir.toPath().resolve(entry.getName()).getFileName()).toString();
                    File outFile = new File(localDir, fileName);
                    files.$plus$eq((Object)outFile);
                    out = new FileOutputStream(outFile);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    ((OutputStream)out).close();
                    in.closeEntry();
                }
                entry = in.getNextEntry();
            }
            in.close();
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unzipped from ", "\\n\\t", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)dfsZipFile), new MDC((LogKey)LogKeys.PATHS$.MODULE$, (Object)files.mkString("\n\t"))}))));
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly(out);
        }
        return files.toSeq();
    }

    public <R extends Closeable> R createResourceUninterruptiblyIfInTaskThread(Function0<R> createResource) {
        return (R)((Closeable)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable)x$27 -> x$27.createResourceUninterruptibly(createResource)).getOrElse(createResource));
    }

    public long median(long[] sizes, boolean alreadySorted) {
        int len = sizes.length;
        long[] sortedSize = alreadySorted ? sizes : (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(sizes), (Ordering)Ordering.Long$.MODULE$);
        int n = len;
        switch (n) {
            default: 
        }
        if (len % 2 == 0) {
            return package$.MODULE$.max((sortedSize[len / 2] + sortedSize[len / 2 - 1]) / 2L, 1L);
        }
        return package$.MODULE$.max(sortedSize[len / 2], 1L);
    }

    public boolean checkCommandAvailable(String command) {
        Try attempt = this.isWindows() ? Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> Process$.MODULE$.apply((scala.collection.Seq)new .colon.colon((Object)"cmd.exe", (List)new .colon.colon((Object)"/C", (List)new .colon.colon((Object)("where " + command), (List)Nil$.MODULE$)))).run(ProcessLogger$.MODULE$.apply((Function1 & Serializable)x$28 -> {
            Utils$.$anonfun$checkCommandAvailable$2(x$28);
            return BoxedUnit.UNIT;
        })).exitValue()) : Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> Process$.MODULE$.apply((scala.collection.Seq)new .colon.colon((Object)"sh", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)("command -v " + command), (List)Nil$.MODULE$)))).run(ProcessLogger$.MODULE$.apply((Function1 & Serializable)x$29 -> {
            Utils$.$anonfun$checkCommandAvailable$4(x$29);
            return BoxedUnit.UNIT;
        })).exitValue());
        return attempt.isSuccess() && BoxesRunTime.unboxToInt((Object)attempt.get()) == 0;
    }

    private boolean isG1GC$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                isG1GC = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                    Class clazz = MODULE$.classForName("com.sun.management.HotSpotDiagnosticMXBean", MODULE$.classForName$default$2(), MODULE$.classForName$default$3());
                    Class vmOptionClazz = MODULE$.classForName("com.sun.management.VMOption", MODULE$.classForName$default$2(), MODULE$.classForName$default$3());
                    Object hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(clazz);
                    Method vmOptionMethod = clazz.getMethod("getVMOption", String.class);
                    Method valueMethod = vmOptionClazz.getMethod("getValue", new Class[0]);
                    Object useG1GCObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "UseG1GC");
                    String useG1GC = (String)valueMethod.invoke(useG1GCObject, new Object[0]);
                    return "true".equals(useG1GC);
                }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return isG1GC;
    }

    public boolean isG1GC() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.isG1GC$lzycompute();
        }
        return isG1GC;
    }

    public static final /* synthetic */ ByteBuffer $anonfun$copyStreamUpTo$1(int x$1) {
        return ByteBuffer.allocate(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$copyStreamUpTo$2(long maxSize$1, LongRef count$1, InputStream in$1, ChunkedByteBufferOutputStream out$3) {
        long bufSize = Math.min(8192L, maxSize$1);
        byte[] buf = new byte[(int)bufSize];
        int n = 0;
        while (n != -1 && count$1.elem < maxSize$1) {
            n = in$1.read(buf, 0, (int)Math.min(maxSize$1 - count$1.elem, bufSize));
            if (n == -1) continue;
            out$3.write(buf, 0, n);
            count$1.elem += (long)n;
        }
        return count$1.elem < maxSize$1;
    }

    public static final /* synthetic */ boolean $anonfun$filesEqualRecursive$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            File f1 = (File)tuple2._1();
            File f2 = (File)tuple2._2();
            return MODULE$.filesEqualRecursive(f1, f2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getOrCreateLocalRootDirsImpl$1(String root) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> new URI(root).getScheme() != null).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$2(InetAddress addr) {
        return addr.isLinkLocalAddress() || addr.isLoopbackAddress();
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$3(InetAddress x$3) {
        return x$3 instanceof Inet4Address;
    }

    public static final /* synthetic */ void $anonfun$findLocalInetAddress$1(InetAddress address$1, Object nonLocalReturnKey1$1, NetworkInterface ni) {
        Seq addresses = CollectionConverters$.MODULE$.EnumerationHasAsScala(ni.getInetAddresses()).asScala().filterNot((Function1 & Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findLocalInetAddress$2(addr))).toSeq();
        if (addresses.nonEmpty()) {
            InetAddress addr2 = (InetAddress)addresses.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findLocalInetAddress$3(x$3))).getOrElse((Function0 & Serializable)() -> (InetAddress)addresses.head());
            InetAddress strippedAddress = InetAddress.getByAddress(addr2.getAddress());
            MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Your hostname, ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HOST$.MODULE$, (Object)InetAddress.getLocalHost().getHostName())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"resolves to a loopback address: ", "; "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HOST_PORT$.MODULE$, (Object)address$1.getHostAddress())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"using ", " instead (on interface "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HOST_PORT2$.MODULE$, (Object)strippedAddress.getHostAddress())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ")"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NETWORK_IF$.MODULE$, (Object)ni.getName())})))));
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> "Set SPARK_LOCAL_IP if you need to bind to another address");
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)strippedAddress);
        }
    }

    private final Tuple2 setDefaultPortValue$1(String hostPort$2) {
        Tuple2 retval = new Tuple2((Object)hostPort$2, (Object)BoxesRunTime.boxToInteger((int)0));
        this.hostPortParseResults().put(hostPort$2, (Tuple2<String, Object>)retval);
        return retval;
    }

    public static final /* synthetic */ boolean $anonfun$doesDirectoryContainAnyNewFiles$1(long cutoffTimeInMillis$1, File x$4) {
        return x$4.lastModified() > cutoffTimeInMillis$1;
    }

    public static final /* synthetic */ boolean $anonfun$executeCommand$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private final void log$1(String s) {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.LINE$.MODULE$, (Object)s)}))));
    }

    private static final void appendToOutput$1(String s, StringBuilder output$1) {
        output$1.append(s).append("\n");
    }

    public static final /* synthetic */ boolean $anonfun$doTryWithCallerStacktrace$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StackTraceElement exElem = (StackTraceElement)tuple2._1();
            StackTraceElement currentElem = (StackTraceElement)tuple2._2();
            StackTraceElement stackTraceElement = exElem;
            StackTraceElement stackTraceElement2 = currentElem;
            return !(stackTraceElement != null ? !((Object)stackTraceElement).equals(stackTraceElement2) : stackTraceElement2 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$doTryWithCallerStacktrace$2(Throwable e) {
        return e instanceof Utils.OriginalTryStackTraceException;
    }

    public static final /* synthetic */ boolean $anonfun$getTryWithCallerStacktrace$1(Throwable e) {
        return e instanceof Utils.OriginalTryStackTraceException;
    }

    public static final /* synthetic */ void $anonfun$offsetBytes$2(LongRef sum$1, scala.collection.immutable.Map fileToLength$1, long endIndex$1, long startIndex$1, StringBuffer stringBuffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            File file = (File)tuple2._1();
            long fileLength = tuple2._2$mcJ$sp();
            long startIndexOfFile = sum$1.elem;
            long endIndexOfFile = sum$1.elem + BoxesRunTime.unboxToLong((Object)fileToLength$1.apply((Object)file));
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Processing file " + file + ", with start index = " + startIndexOfFile + ", end index = " + endIndex$1);
            if (startIndex$1 <= startIndexOfFile && endIndex$1 >= endIndexOfFile) {
                v0 = stringBuffer$1.append(MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, 0L, BoxesRunTime.unboxToLong((Object)fileToLength$1.apply((Object)file))));
            } else if (startIndex$1 > startIndexOfFile && startIndex$1 < endIndexOfFile) {
                long effectiveStartIndex = startIndex$1 - startIndexOfFile;
                long effectiveEndIndex = package$.MODULE$.min(endIndex$1 - startIndexOfFile, BoxesRunTime.unboxToLong((Object)fileToLength$1.apply((Object)file)));
                v0 = stringBuffer$1.append(MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, effectiveStartIndex, effectiveEndIndex));
            } else if (endIndex$1 > startIndexOfFile && endIndex$1 < endIndexOfFile) {
                long effectiveStartIndex = package$.MODULE$.max(startIndex$1 - startIndexOfFile, 0L);
                long effectiveEndIndex = endIndex$1 - startIndexOfFile;
                v0 = stringBuffer$1.append(MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, effectiveStartIndex, effectiveEndIndex));
            } else {
                v0 = BoxedUnit.UNIT;
            }
            sum$1.elem += BoxesRunTime.unboxToLong((Object)fileToLength$1.apply((Object)file));
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "After processing file " + file + ", string built is " + stringBuffer$1.toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final void endWord$1(ArrayBuffer buf$1, StringBuilder curWord$1) {
        buf$1.$plus$eq((Object)curWord$1.toString());
        curWord$1.clear();
    }

    public static final /* synthetic */ boolean $anonfun$nonLocalPaths$1(boolean windows$1, String p) {
        Option option;
        URI uri = MODULE$.resolveURI(p);
        String string = (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0 & Serializable)() -> "file");
        if (string != null && !(option = MODULE$.windowsDrive().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0 && windows$1) {
            return false;
        }
        return !("local".equals(string) ? true : "file".equals(string));
    }

    public static final /* synthetic */ boolean $anonfun$loadDefaultSparkProperties$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return k.startsWith("spark.");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$loadDefaultSparkProperties$2(SparkConf conf$2, String confFile) {
        ((IterableOnceOps)MODULE$.getPropertiesFromFile(confFile).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$loadDefaultSparkProperties$3(x0$1)))).foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                conf$2.setIfMissing(k, v);
                return (String)scala.sys.package$.MODULE$.props().getOrElseUpdate((Object)k, (Function0 & Serializable)() -> v);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ boolean $anonfun$trimExceptCRLF$1(char ch) {
        return ch > ' ' || ch == '\r' || ch == '\n';
    }

    public static final /* synthetic */ boolean $anonfun$getThreadDump$1(ThreadInfo x$10) {
        return x$10 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getThreadDump$2(ThreadInfo x0$1, ThreadInfo x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            boolean v2;
            ThreadInfo threadTrace1 = (ThreadInfo)tuple2._1();
            ThreadInfo threadTrace2 = (ThreadInfo)tuple2._2();
            boolean v1 = threadTrace1.getThreadName().contains("Executor task launch");
            boolean bl = v2 = threadTrace2.getThreadName().contains("Executor task launch");
            if (v1 == v2) {
                String name2;
                String name1 = threadTrace1.getThreadName().toLowerCase(Locale.ROOT);
                int nameCmpRes = name1.compareTo(name2 = threadTrace2.getThreadName().toLowerCase(Locale.ROOT));
                if (nameCmpRes == 0) {
                    return threadTrace1.getThreadId() < threadTrace2.getThreadId();
                }
                return nameCmpRes < 0;
            }
            return v1 > v2;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$getHeapHistogram$2(ArrayBuffer rows$1, BufferedReader r) {
        String line = "";
        while (line != null) {
            Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(line)) ? rows$1.$plus$eq((Object)line) : BoxedUnit.UNIT;
            line = r.readLine();
        }
    }

    public static final /* synthetic */ boolean $anonfun$sparkJavaOpts$1(Function1 filterKey$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return BoxesRunTime.unboxToBoolean((Object)filterKey$1.apply((Object)k));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$sparkJavaOpts$default$2$1(String x$13) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$startServiceOnPort$2(int startPort$1, Function1 startService$1, String serviceString$1, Object nonLocalReturnKey2$1, int maxRetries$1, int offset) {
        int tryPort = startPort$1 == 0 ? startPort$1 : MODULE$.userPort(startPort$1, offset);
        try {
            Tuple2 tuple2 = (Tuple2)startService$1.apply((Object)BoxesRunTime.boxToInteger((int)tryPort));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object service = tuple2._1();
            int port = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2(service, (Object)BoxesRunTime.boxToInteger((int)port));
            Object service2 = tuple22._1();
            int port2 = tuple22._2$mcI$sp();
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully started service", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SERVICE_NAME$.MODULE$, (Object)serviceString$1)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" on port ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PORT$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)port2))})))));
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)new Tuple2(service2, (Object)BoxesRunTime.boxToInteger((int)port2)));
        }
        catch (Throwable throwable) {
            Exception exception;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof Exception && MODULE$.isBindCollision(exception = (Exception)throwable2)) {
                if (offset >= maxRetries$1) {
                    String exceptionMessage = startPort$1 == 0 ? exception.getMessage() + ": Service" + serviceString$1 + " failed after " + maxRetries$1 + " retries (on a random free port)! Consider explicitly setting the appropriate binding address for the service" + serviceString$1 + " (for example " + org.apache.spark.internal.config.package$.MODULE$.DRIVER_BIND_ADDRESS().key() + " for SparkDriver) to the correct binding address." : exception.getMessage() + ": Service" + serviceString$1 + " failed after " + maxRetries$1 + " retries (starting from " + startPort$1 + ")! Consider explicitly setting the appropriate port for the service" + serviceString$1 + " (for example spark.ui.port for SparkUI) to an available port or increasing spark.port.maxRetries.";
                    BindException exception2 = new BindException(exceptionMessage);
                    exception2.setStackTrace(exception.getStackTrace());
                    throw exception2;
                }
                if (startPort$1 == 0) {
                    MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Service", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SERVICE_NAME$.MODULE$, (Object)serviceString$1)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"could not bind on a random free port. "}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"You may check whether configuring an appropriate binding address."}))).log((Seq)Nil$.MODULE$))));
                } else {
                    MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Service", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SERVICE_NAME$.MODULE$, (Object)serviceString$1)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"could not bind on port ", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PORT$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)tryPort))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting port ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PORT2$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)(tryPort + 1)))})))));
                }
            } else {
                throw throwable;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$isPushBasedShuffleEnabled$1() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$isPushBasedShuffleEnabled$3(Serializer x$19) {
        return x$19 != null;
    }

    private static final /* synthetic */ boolean serializerIsSupported$lzycompute$1(LazyBoolean serializerIsSupported$lzy$1, boolean checkSerializer$1, SparkConf conf$3, boolean isDriver$1) {
        boolean bl;
        LazyBoolean lazyBoolean = serializerIsSupported$lzy$1;
        synchronized (lazyBoolean) {
            bl = serializerIsSupported$lzy$1.initialized() ? serializerIsSupported$lzy$1.value() : serializerIsSupported$lzy$1.initialize(checkSerializer$1 ? ((Serializer)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable)x$18 -> x$18.serializer()).filter((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$isPushBasedShuffleEnabled$3(x$19))).getOrElse((Function0 & Serializable)() -> (Serializer)MODULE$.instantiateSerializerFromConf(org.apache.spark.internal.config.package$.MODULE$.SERIALIZER(), conf$3, isDriver$1))).supportsRelocationOfSerializedObjects() : true);
        }
        return bl;
    }

    private static final boolean serializerIsSupported$1(LazyBoolean serializerIsSupported$lzy$1, boolean checkSerializer$1, SparkConf conf$3, boolean isDriver$1) {
        if (serializerIsSupported$lzy$1.initialized()) {
            return serializerIsSupported$lzy$1.value();
        }
        return Utils$.serializerIsSupported$lzycompute$1(serializerIsSupported$lzy$1, checkSerializer$1, conf$3, isDriver$1);
    }

    public static final /* synthetic */ MessageWithContext $anonfun$isPushBasedShuffleEnabled$5() {
        return MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Push-based shuffle can only be enabled when the application is submitted "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to run in YARN mode, with external shuffle service enabled, IO encryption "}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"disabled, and relocation of serialized objects supported."}))).log((Seq)Nil$.MODULE$));
    }

    public static final /* synthetic */ String $anonfun$checkAndGetK8sMasterUrl$1() {
        return "Kubernetes master URL must start with k8s://.";
    }

    public static final /* synthetic */ MessageWithContext $anonfun$checkAndGetK8sMasterUrl$2(String resolvedURL$1) {
        return MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"No scheme specified for kubernetes master URL, so defaulting to https."}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" Resolved URL is ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.URL$.MODULE$, (Object)resolvedURL$1)})));
    }

    public static final /* synthetic */ String $anonfun$checkAndGetK8sMasterUrl$3(String x$26) {
        return x$26.toLowerCase(Locale.ROOT);
    }

    public static final /* synthetic */ MessageWithContext $anonfun$checkAndGetK8sMasterUrl$4() {
        return MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Kubernetes master URL uses HTTP instead of HTTPS."}))).log((Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$checkCommandAvailable$2(String x$28) {
    }

    public static final /* synthetic */ void $anonfun$checkCommandAvailable$4(String x$29) {
    }

    private Utils$() {
    }
}

