/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: StateMessage.proto

package org.apache.spark.sql.execution.streaming.state;

public final class StateMessage {
  private StateMessage() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * Protobuf enum {@code org.apache.spark.sql.execution.streaming.state.HandleState}
   */
  public enum HandleState
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>CREATED = 0;</code>
     */
    CREATED(0),
    /**
     * <code>INITIALIZED = 1;</code>
     */
    INITIALIZED(1),
    /**
     * <code>DATA_PROCESSED = 2;</code>
     */
    DATA_PROCESSED(2),
    /**
     * <code>CLOSED = 3;</code>
     */
    CLOSED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     * <code>CREATED = 0;</code>
     */
    public static final int CREATED_VALUE = 0;
    /**
     * <code>INITIALIZED = 1;</code>
     */
    public static final int INITIALIZED_VALUE = 1;
    /**
     * <code>DATA_PROCESSED = 2;</code>
     */
    public static final int DATA_PROCESSED_VALUE = 2;
    /**
     * <code>CLOSED = 3;</code>
     */
    public static final int CLOSED_VALUE = 3;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HandleState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static HandleState forNumber(int value) {
      switch (value) {
        case 0: return CREATED;
        case 1: return INITIALIZED;
        case 2: return DATA_PROCESSED;
        case 3: return CLOSED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HandleState>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        HandleState> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<HandleState>() {
            public HandleState findValueByNumber(int number) {
              return HandleState.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.getDescriptor().getEnumTypes().get(0);
    }

    private static final HandleState[] VALUES = values();

    public static HandleState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private HandleState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:org.apache.spark.sql.execution.streaming.state.HandleState)
  }

  public interface StateRequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.StateRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>int32 version = 1;</code>
     * @return The version.
     */
    int getVersion();

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
     * @return Whether the statefulProcessorCall field is set.
     */
    boolean hasStatefulProcessorCall();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
     * @return The statefulProcessorCall.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall getStatefulProcessorCall();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCallOrBuilder getStatefulProcessorCallOrBuilder();

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
     * @return Whether the stateVariableRequest field is set.
     */
    boolean hasStateVariableRequest();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
     * @return The stateVariableRequest.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest getStateVariableRequest();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequestOrBuilder getStateVariableRequestOrBuilder();

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
     * @return Whether the implicitGroupingKeyRequest field is set.
     */
    boolean hasImplicitGroupingKeyRequest();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
     * @return The implicitGroupingKeyRequest.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest getImplicitGroupingKeyRequest();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequestOrBuilder getImplicitGroupingKeyRequestOrBuilder();

    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest.MethodCase getMethodCase();
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.StateRequest}
   */
  public static final class StateRequest extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.StateRequest)
      StateRequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use StateRequest.newBuilder() to construct.
    private StateRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private StateRequest() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new StateRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest.class, org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest.Builder.class);
    }

    private int methodCase_ = 0;
    private java.lang.Object method_;
    public enum MethodCase
        implements com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      STATEFULPROCESSORCALL(2),
      STATEVARIABLEREQUEST(3),
      IMPLICITGROUPINGKEYREQUEST(4),
      METHOD_NOT_SET(0);
      private final int value;
      private MethodCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static MethodCase valueOf(int value) {
        return forNumber(value);
      }

      public static MethodCase forNumber(int value) {
        switch (value) {
          case 2: return STATEFULPROCESSORCALL;
          case 3: return STATEVARIABLEREQUEST;
          case 4: return IMPLICITGROUPINGKEYREQUEST;
          case 0: return METHOD_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public MethodCase
    getMethodCase() {
      return MethodCase.forNumber(
          methodCase_);
    }

    public static final int VERSION_FIELD_NUMBER = 1;
    private int version_;
    /**
     * <code>int32 version = 1;</code>
     * @return The version.
     */
    @java.lang.Override
    public int getVersion() {
      return version_;
    }

    public static final int STATEFULPROCESSORCALL_FIELD_NUMBER = 2;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
     * @return Whether the statefulProcessorCall field is set.
     */
    @java.lang.Override
    public boolean hasStatefulProcessorCall() {
      return methodCase_ == 2;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
     * @return The statefulProcessorCall.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall getStatefulProcessorCall() {
      if (methodCase_ == 2) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCallOrBuilder getStatefulProcessorCallOrBuilder() {
      if (methodCase_ == 2) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.getDefaultInstance();
    }

    public static final int STATEVARIABLEREQUEST_FIELD_NUMBER = 3;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
     * @return Whether the stateVariableRequest field is set.
     */
    @java.lang.Override
    public boolean hasStateVariableRequest() {
      return methodCase_ == 3;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
     * @return The stateVariableRequest.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest getStateVariableRequest() {
      if (methodCase_ == 3) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequestOrBuilder getStateVariableRequestOrBuilder() {
      if (methodCase_ == 3) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.getDefaultInstance();
    }

    public static final int IMPLICITGROUPINGKEYREQUEST_FIELD_NUMBER = 4;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
     * @return Whether the implicitGroupingKeyRequest field is set.
     */
    @java.lang.Override
    public boolean hasImplicitGroupingKeyRequest() {
      return methodCase_ == 4;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
     * @return The implicitGroupingKeyRequest.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest getImplicitGroupingKeyRequest() {
      if (methodCase_ == 4) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequestOrBuilder getImplicitGroupingKeyRequestOrBuilder() {
      if (methodCase_ == 4) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (version_ != 0) {
        output.writeInt32(1, version_);
      }
      if (methodCase_ == 2) {
        output.writeMessage(2, (org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall) method_);
      }
      if (methodCase_ == 3) {
        output.writeMessage(3, (org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest) method_);
      }
      if (methodCase_ == 4) {
        output.writeMessage(4, (org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest) method_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (version_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(1, version_);
      }
      if (methodCase_ == 2) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, (org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall) method_);
      }
      if (methodCase_ == 3) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, (org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest) method_);
      }
      if (methodCase_ == 4) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, (org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest) method_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest other = (org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest) obj;

      if (getVersion()
          != other.getVersion()) return false;
      if (!getMethodCase().equals(other.getMethodCase())) return false;
      switch (methodCase_) {
        case 2:
          if (!getStatefulProcessorCall()
              .equals(other.getStatefulProcessorCall())) return false;
          break;
        case 3:
          if (!getStateVariableRequest()
              .equals(other.getStateVariableRequest())) return false;
          break;
        case 4:
          if (!getImplicitGroupingKeyRequest()
              .equals(other.getImplicitGroupingKeyRequest())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion();
      switch (methodCase_) {
        case 2:
          hash = (37 * hash) + STATEFULPROCESSORCALL_FIELD_NUMBER;
          hash = (53 * hash) + getStatefulProcessorCall().hashCode();
          break;
        case 3:
          hash = (37 * hash) + STATEVARIABLEREQUEST_FIELD_NUMBER;
          hash = (53 * hash) + getStateVariableRequest().hashCode();
          break;
        case 4:
          hash = (37 * hash) + IMPLICITGROUPINGKEYREQUEST_FIELD_NUMBER;
          hash = (53 * hash) + getImplicitGroupingKeyRequest().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.StateRequest}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.StateRequest)
        org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest.class, org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        version_ = 0;

        if (statefulProcessorCallBuilder_ != null) {
          statefulProcessorCallBuilder_.clear();
        }
        if (stateVariableRequestBuilder_ != null) {
          stateVariableRequestBuilder_.clear();
        }
        if (implicitGroupingKeyRequestBuilder_ != null) {
          implicitGroupingKeyRequestBuilder_.clear();
        }
        methodCase_ = 0;
        method_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateRequest_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest result = new org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest(this);
        result.version_ = version_;
        if (methodCase_ == 2) {
          if (statefulProcessorCallBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = statefulProcessorCallBuilder_.build();
          }
        }
        if (methodCase_ == 3) {
          if (stateVariableRequestBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = stateVariableRequestBuilder_.build();
          }
        }
        if (methodCase_ == 4) {
          if (implicitGroupingKeyRequestBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = implicitGroupingKeyRequestBuilder_.build();
          }
        }
        result.methodCase_ = methodCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest.getDefaultInstance()) return this;
        if (other.getVersion() != 0) {
          setVersion(other.getVersion());
        }
        switch (other.getMethodCase()) {
          case STATEFULPROCESSORCALL: {
            mergeStatefulProcessorCall(other.getStatefulProcessorCall());
            break;
          }
          case STATEVARIABLEREQUEST: {
            mergeStateVariableRequest(other.getStateVariableRequest());
            break;
          }
          case IMPLICITGROUPINGKEYREQUEST: {
            mergeImplicitGroupingKeyRequest(other.getImplicitGroupingKeyRequest());
            break;
          }
          case METHOD_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                version_ = input.readInt32();

                break;
              } // case 8
              case 18: {
                input.readMessage(
                    getStatefulProcessorCallFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 2;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getStateVariableRequestFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 3;
                break;
              } // case 26
              case 34: {
                input.readMessage(
                    getImplicitGroupingKeyRequestFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 4;
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int methodCase_ = 0;
      private java.lang.Object method_;
      public MethodCase
          getMethodCase() {
        return MethodCase.forNumber(
            methodCase_);
      }

      public Builder clearMethod() {
        methodCase_ = 0;
        method_ = null;
        onChanged();
        return this;
      }


      private int version_ ;
      /**
       * <code>int32 version = 1;</code>
       * @return The version.
       */
      @java.lang.Override
      public int getVersion() {
        return version_;
      }
      /**
       * <code>int32 version = 1;</code>
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(int value) {
        
        version_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>int32 version = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearVersion() {
        
        version_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall, org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCallOrBuilder> statefulProcessorCallBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
       * @return Whether the statefulProcessorCall field is set.
       */
      @java.lang.Override
      public boolean hasStatefulProcessorCall() {
        return methodCase_ == 2;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
       * @return The statefulProcessorCall.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall getStatefulProcessorCall() {
        if (statefulProcessorCallBuilder_ == null) {
          if (methodCase_ == 2) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.getDefaultInstance();
        } else {
          if (methodCase_ == 2) {
            return statefulProcessorCallBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
       */
      public Builder setStatefulProcessorCall(org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall value) {
        if (statefulProcessorCallBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          statefulProcessorCallBuilder_.setMessage(value);
        }
        methodCase_ = 2;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
       */
      public Builder setStatefulProcessorCall(
          org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.Builder builderForValue) {
        if (statefulProcessorCallBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          statefulProcessorCallBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 2;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
       */
      public Builder mergeStatefulProcessorCall(org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall value) {
        if (statefulProcessorCallBuilder_ == null) {
          if (methodCase_ == 2 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 2) {
            statefulProcessorCallBuilder_.mergeFrom(value);
          } else {
            statefulProcessorCallBuilder_.setMessage(value);
          }
        }
        methodCase_ = 2;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
       */
      public Builder clearStatefulProcessorCall() {
        if (statefulProcessorCallBuilder_ == null) {
          if (methodCase_ == 2) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 2) {
            methodCase_ = 0;
            method_ = null;
          }
          statefulProcessorCallBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.Builder getStatefulProcessorCallBuilder() {
        return getStatefulProcessorCallFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCallOrBuilder getStatefulProcessorCallOrBuilder() {
        if ((methodCase_ == 2) && (statefulProcessorCallBuilder_ != null)) {
          return statefulProcessorCallBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 2) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall statefulProcessorCall = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall, org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCallOrBuilder> 
          getStatefulProcessorCallFieldBuilder() {
        if (statefulProcessorCallBuilder_ == null) {
          if (!(methodCase_ == 2)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.getDefaultInstance();
          }
          statefulProcessorCallBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall, org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCallOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 2;
        onChanged();;
        return statefulProcessorCallBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest, org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequestOrBuilder> stateVariableRequestBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
       * @return Whether the stateVariableRequest field is set.
       */
      @java.lang.Override
      public boolean hasStateVariableRequest() {
        return methodCase_ == 3;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
       * @return The stateVariableRequest.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest getStateVariableRequest() {
        if (stateVariableRequestBuilder_ == null) {
          if (methodCase_ == 3) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.getDefaultInstance();
        } else {
          if (methodCase_ == 3) {
            return stateVariableRequestBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
       */
      public Builder setStateVariableRequest(org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest value) {
        if (stateVariableRequestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          stateVariableRequestBuilder_.setMessage(value);
        }
        methodCase_ = 3;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
       */
      public Builder setStateVariableRequest(
          org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.Builder builderForValue) {
        if (stateVariableRequestBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          stateVariableRequestBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 3;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
       */
      public Builder mergeStateVariableRequest(org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest value) {
        if (stateVariableRequestBuilder_ == null) {
          if (methodCase_ == 3 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 3) {
            stateVariableRequestBuilder_.mergeFrom(value);
          } else {
            stateVariableRequestBuilder_.setMessage(value);
          }
        }
        methodCase_ = 3;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
       */
      public Builder clearStateVariableRequest() {
        if (stateVariableRequestBuilder_ == null) {
          if (methodCase_ == 3) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 3) {
            methodCase_ = 0;
            method_ = null;
          }
          stateVariableRequestBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.Builder getStateVariableRequestBuilder() {
        return getStateVariableRequestFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequestOrBuilder getStateVariableRequestOrBuilder() {
        if ((methodCase_ == 3) && (stateVariableRequestBuilder_ != null)) {
          return stateVariableRequestBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 3) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateVariableRequest stateVariableRequest = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest, org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequestOrBuilder> 
          getStateVariableRequestFieldBuilder() {
        if (stateVariableRequestBuilder_ == null) {
          if (!(methodCase_ == 3)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.getDefaultInstance();
          }
          stateVariableRequestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest, org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequestOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 3;
        onChanged();;
        return stateVariableRequestBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest, org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequestOrBuilder> implicitGroupingKeyRequestBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
       * @return Whether the implicitGroupingKeyRequest field is set.
       */
      @java.lang.Override
      public boolean hasImplicitGroupingKeyRequest() {
        return methodCase_ == 4;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
       * @return The implicitGroupingKeyRequest.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest getImplicitGroupingKeyRequest() {
        if (implicitGroupingKeyRequestBuilder_ == null) {
          if (methodCase_ == 4) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.getDefaultInstance();
        } else {
          if (methodCase_ == 4) {
            return implicitGroupingKeyRequestBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
       */
      public Builder setImplicitGroupingKeyRequest(org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest value) {
        if (implicitGroupingKeyRequestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          implicitGroupingKeyRequestBuilder_.setMessage(value);
        }
        methodCase_ = 4;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
       */
      public Builder setImplicitGroupingKeyRequest(
          org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.Builder builderForValue) {
        if (implicitGroupingKeyRequestBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          implicitGroupingKeyRequestBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 4;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
       */
      public Builder mergeImplicitGroupingKeyRequest(org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest value) {
        if (implicitGroupingKeyRequestBuilder_ == null) {
          if (methodCase_ == 4 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 4) {
            implicitGroupingKeyRequestBuilder_.mergeFrom(value);
          } else {
            implicitGroupingKeyRequestBuilder_.setMessage(value);
          }
        }
        methodCase_ = 4;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
       */
      public Builder clearImplicitGroupingKeyRequest() {
        if (implicitGroupingKeyRequestBuilder_ == null) {
          if (methodCase_ == 4) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 4) {
            methodCase_ = 0;
            method_ = null;
          }
          implicitGroupingKeyRequestBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.Builder getImplicitGroupingKeyRequestBuilder() {
        return getImplicitGroupingKeyRequestFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequestOrBuilder getImplicitGroupingKeyRequestOrBuilder() {
        if ((methodCase_ == 4) && (implicitGroupingKeyRequestBuilder_ != null)) {
          return implicitGroupingKeyRequestBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 4) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest implicitGroupingKeyRequest = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest, org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequestOrBuilder> 
          getImplicitGroupingKeyRequestFieldBuilder() {
        if (implicitGroupingKeyRequestBuilder_ == null) {
          if (!(methodCase_ == 4)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.getDefaultInstance();
          }
          implicitGroupingKeyRequestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest, org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequestOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 4;
        onChanged();;
        return implicitGroupingKeyRequestBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.StateRequest)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.StateRequest)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StateRequest>
        PARSER = new com.google.protobuf.AbstractParser<StateRequest>() {
      @java.lang.Override
      public StateRequest parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<StateRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StateRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateRequest getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface StateResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.StateResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>int32 statusCode = 1;</code>
     * @return The statusCode.
     */
    int getStatusCode();

    /**
     * <code>string errorMessage = 2;</code>
     * @return The errorMessage.
     */
    java.lang.String getErrorMessage();
    /**
     * <code>string errorMessage = 2;</code>
     * @return The bytes for errorMessage.
     */
    com.google.protobuf.ByteString
        getErrorMessageBytes();

    /**
     * <code>bytes value = 3;</code>
     * @return The value.
     */
    com.google.protobuf.ByteString getValue();
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.StateResponse}
   */
  public static final class StateResponse extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.StateResponse)
      StateResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use StateResponse.newBuilder() to construct.
    private StateResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private StateResponse() {
      errorMessage_ = "";
      value_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new StateResponse();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse.class, org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse.Builder.class);
    }

    public static final int STATUSCODE_FIELD_NUMBER = 1;
    private int statusCode_;
    /**
     * <code>int32 statusCode = 1;</code>
     * @return The statusCode.
     */
    @java.lang.Override
    public int getStatusCode() {
      return statusCode_;
    }

    public static final int ERRORMESSAGE_FIELD_NUMBER = 2;
    private volatile java.lang.Object errorMessage_;
    /**
     * <code>string errorMessage = 2;</code>
     * @return The errorMessage.
     */
    @java.lang.Override
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      }
    }
    /**
     * <code>string errorMessage = 2;</code>
     * @return The bytes for errorMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 3;
    private com.google.protobuf.ByteString value_;
    /**
     * <code>bytes value = 3;</code>
     * @return The value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValue() {
      return value_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (statusCode_ != 0) {
        output.writeInt32(1, statusCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, errorMessage_);
      }
      if (!value_.isEmpty()) {
        output.writeBytes(3, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (statusCode_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(1, statusCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, errorMessage_);
      }
      if (!value_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse other = (org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse) obj;

      if (getStatusCode()
          != other.getStatusCode()) return false;
      if (!getErrorMessage()
          .equals(other.getErrorMessage())) return false;
      if (!getValue()
          .equals(other.getValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATUSCODE_FIELD_NUMBER;
      hash = (53 * hash) + getStatusCode();
      hash = (37 * hash) + ERRORMESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getErrorMessage().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.StateResponse}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.StateResponse)
        org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse.class, org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        statusCode_ = 0;

        errorMessage_ = "";

        value_ = com.google.protobuf.ByteString.EMPTY;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateResponse_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse result = new org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse(this);
        result.statusCode_ = statusCode_;
        result.errorMessage_ = errorMessage_;
        result.value_ = value_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse.getDefaultInstance()) return this;
        if (other.getStatusCode() != 0) {
          setStatusCode(other.getStatusCode());
        }
        if (!other.getErrorMessage().isEmpty()) {
          errorMessage_ = other.errorMessage_;
          onChanged();
        }
        if (other.getValue() != com.google.protobuf.ByteString.EMPTY) {
          setValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                statusCode_ = input.readInt32();

                break;
              } // case 8
              case 18: {
                errorMessage_ = input.readStringRequireUtf8();

                break;
              } // case 18
              case 26: {
                value_ = input.readBytes();

                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int statusCode_ ;
      /**
       * <code>int32 statusCode = 1;</code>
       * @return The statusCode.
       */
      @java.lang.Override
      public int getStatusCode() {
        return statusCode_;
      }
      /**
       * <code>int32 statusCode = 1;</code>
       * @param value The statusCode to set.
       * @return This builder for chaining.
       */
      public Builder setStatusCode(int value) {
        
        statusCode_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>int32 statusCode = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStatusCode() {
        
        statusCode_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object errorMessage_ = "";
      /**
       * <code>string errorMessage = 2;</code>
       * @return The errorMessage.
       */
      public java.lang.String getErrorMessage() {
        java.lang.Object ref = errorMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          errorMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string errorMessage = 2;</code>
       * @return The bytes for errorMessage.
       */
      public com.google.protobuf.ByteString
          getErrorMessageBytes() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          errorMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string errorMessage = 2;</code>
       * @param value The errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessage(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        errorMessage_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string errorMessage = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearErrorMessage() {
        
        errorMessage_ = getDefaultInstance().getErrorMessage();
        onChanged();
        return this;
      }
      /**
       * <code>string errorMessage = 2;</code>
       * @param value The bytes for errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessageBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        errorMessage_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>bytes value = 3;</code>
       * @return The value.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getValue() {
        return value_;
      }
      /**
       * <code>bytes value = 3;</code>
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>bytes value = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        
        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.StateResponse)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.StateResponse)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StateResponse>
        PARSER = new com.google.protobuf.AbstractParser<StateResponse>() {
      @java.lang.Override
      public StateResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<StateResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StateResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface StatefulProcessorCallOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
     * @return Whether the setHandleState field is set.
     */
    boolean hasSetHandleState();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
     * @return The setHandleState.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState getSetHandleState();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleStateOrBuilder getSetHandleStateOrBuilder();

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
     * @return Whether the getValueState field is set.
     */
    boolean hasGetValueState();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
     * @return The getValueState.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand getGetValueState();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder getGetValueStateOrBuilder();

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
     * @return Whether the getListState field is set.
     */
    boolean hasGetListState();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
     * @return The getListState.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand getGetListState();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder getGetListStateOrBuilder();

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
     * @return Whether the getMapState field is set.
     */
    boolean hasGetMapState();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
     * @return The getMapState.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand getGetMapState();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder getGetMapStateOrBuilder();

    public org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.MethodCase getMethodCase();
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall}
   */
  public static final class StatefulProcessorCall extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall)
      StatefulProcessorCallOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use StatefulProcessorCall.newBuilder() to construct.
    private StatefulProcessorCall(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private StatefulProcessorCall() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new StatefulProcessorCall();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StatefulProcessorCall_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StatefulProcessorCall_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.class, org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.Builder.class);
    }

    private int methodCase_ = 0;
    private java.lang.Object method_;
    public enum MethodCase
        implements com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SETHANDLESTATE(1),
      GETVALUESTATE(2),
      GETLISTSTATE(3),
      GETMAPSTATE(4),
      METHOD_NOT_SET(0);
      private final int value;
      private MethodCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static MethodCase valueOf(int value) {
        return forNumber(value);
      }

      public static MethodCase forNumber(int value) {
        switch (value) {
          case 1: return SETHANDLESTATE;
          case 2: return GETVALUESTATE;
          case 3: return GETLISTSTATE;
          case 4: return GETMAPSTATE;
          case 0: return METHOD_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public MethodCase
    getMethodCase() {
      return MethodCase.forNumber(
          methodCase_);
    }

    public static final int SETHANDLESTATE_FIELD_NUMBER = 1;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
     * @return Whether the setHandleState field is set.
     */
    @java.lang.Override
    public boolean hasSetHandleState() {
      return methodCase_ == 1;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
     * @return The setHandleState.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState getSetHandleState() {
      if (methodCase_ == 1) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleStateOrBuilder getSetHandleStateOrBuilder() {
      if (methodCase_ == 1) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.getDefaultInstance();
    }

    public static final int GETVALUESTATE_FIELD_NUMBER = 2;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
     * @return Whether the getValueState field is set.
     */
    @java.lang.Override
    public boolean hasGetValueState() {
      return methodCase_ == 2;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
     * @return The getValueState.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand getGetValueState() {
      if (methodCase_ == 2) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder getGetValueStateOrBuilder() {
      if (methodCase_ == 2) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
    }

    public static final int GETLISTSTATE_FIELD_NUMBER = 3;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
     * @return Whether the getListState field is set.
     */
    @java.lang.Override
    public boolean hasGetListState() {
      return methodCase_ == 3;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
     * @return The getListState.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand getGetListState() {
      if (methodCase_ == 3) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder getGetListStateOrBuilder() {
      if (methodCase_ == 3) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
    }

    public static final int GETMAPSTATE_FIELD_NUMBER = 4;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
     * @return Whether the getMapState field is set.
     */
    @java.lang.Override
    public boolean hasGetMapState() {
      return methodCase_ == 4;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
     * @return The getMapState.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand getGetMapState() {
      if (methodCase_ == 4) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder getGetMapStateOrBuilder() {
      if (methodCase_ == 4) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (methodCase_ == 1) {
        output.writeMessage(1, (org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState) method_);
      }
      if (methodCase_ == 2) {
        output.writeMessage(2, (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_);
      }
      if (methodCase_ == 3) {
        output.writeMessage(3, (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_);
      }
      if (methodCase_ == 4) {
        output.writeMessage(4, (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (methodCase_ == 1) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, (org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState) method_);
      }
      if (methodCase_ == 2) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_);
      }
      if (methodCase_ == 3) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_);
      }
      if (methodCase_ == 4) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall other = (org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall) obj;

      if (!getMethodCase().equals(other.getMethodCase())) return false;
      switch (methodCase_) {
        case 1:
          if (!getSetHandleState()
              .equals(other.getSetHandleState())) return false;
          break;
        case 2:
          if (!getGetValueState()
              .equals(other.getGetValueState())) return false;
          break;
        case 3:
          if (!getGetListState()
              .equals(other.getGetListState())) return false;
          break;
        case 4:
          if (!getGetMapState()
              .equals(other.getGetMapState())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (methodCase_) {
        case 1:
          hash = (37 * hash) + SETHANDLESTATE_FIELD_NUMBER;
          hash = (53 * hash) + getSetHandleState().hashCode();
          break;
        case 2:
          hash = (37 * hash) + GETVALUESTATE_FIELD_NUMBER;
          hash = (53 * hash) + getGetValueState().hashCode();
          break;
        case 3:
          hash = (37 * hash) + GETLISTSTATE_FIELD_NUMBER;
          hash = (53 * hash) + getGetListState().hashCode();
          break;
        case 4:
          hash = (37 * hash) + GETMAPSTATE_FIELD_NUMBER;
          hash = (53 * hash) + getGetMapState().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall)
        org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCallOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StatefulProcessorCall_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StatefulProcessorCall_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.class, org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (setHandleStateBuilder_ != null) {
          setHandleStateBuilder_.clear();
        }
        if (getValueStateBuilder_ != null) {
          getValueStateBuilder_.clear();
        }
        if (getListStateBuilder_ != null) {
          getListStateBuilder_.clear();
        }
        if (getMapStateBuilder_ != null) {
          getMapStateBuilder_.clear();
        }
        methodCase_ = 0;
        method_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StatefulProcessorCall_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall result = new org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall(this);
        if (methodCase_ == 1) {
          if (setHandleStateBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = setHandleStateBuilder_.build();
          }
        }
        if (methodCase_ == 2) {
          if (getValueStateBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = getValueStateBuilder_.build();
          }
        }
        if (methodCase_ == 3) {
          if (getListStateBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = getListStateBuilder_.build();
          }
        }
        if (methodCase_ == 4) {
          if (getMapStateBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = getMapStateBuilder_.build();
          }
        }
        result.methodCase_ = methodCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall.getDefaultInstance()) return this;
        switch (other.getMethodCase()) {
          case SETHANDLESTATE: {
            mergeSetHandleState(other.getSetHandleState());
            break;
          }
          case GETVALUESTATE: {
            mergeGetValueState(other.getGetValueState());
            break;
          }
          case GETLISTSTATE: {
            mergeGetListState(other.getGetListState());
            break;
          }
          case GETMAPSTATE: {
            mergeGetMapState(other.getGetMapState());
            break;
          }
          case METHOD_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getSetHandleStateFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 1;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getGetValueStateFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 2;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getGetListStateFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 3;
                break;
              } // case 26
              case 34: {
                input.readMessage(
                    getGetMapStateFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 4;
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int methodCase_ = 0;
      private java.lang.Object method_;
      public MethodCase
          getMethodCase() {
        return MethodCase.forNumber(
            methodCase_);
      }

      public Builder clearMethod() {
        methodCase_ = 0;
        method_ = null;
        onChanged();
        return this;
      }


      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState, org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleStateOrBuilder> setHandleStateBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
       * @return Whether the setHandleState field is set.
       */
      @java.lang.Override
      public boolean hasSetHandleState() {
        return methodCase_ == 1;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
       * @return The setHandleState.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState getSetHandleState() {
        if (setHandleStateBuilder_ == null) {
          if (methodCase_ == 1) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.getDefaultInstance();
        } else {
          if (methodCase_ == 1) {
            return setHandleStateBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
       */
      public Builder setSetHandleState(org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState value) {
        if (setHandleStateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          setHandleStateBuilder_.setMessage(value);
        }
        methodCase_ = 1;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
       */
      public Builder setSetHandleState(
          org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.Builder builderForValue) {
        if (setHandleStateBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          setHandleStateBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 1;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
       */
      public Builder mergeSetHandleState(org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState value) {
        if (setHandleStateBuilder_ == null) {
          if (methodCase_ == 1 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 1) {
            setHandleStateBuilder_.mergeFrom(value);
          } else {
            setHandleStateBuilder_.setMessage(value);
          }
        }
        methodCase_ = 1;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
       */
      public Builder clearSetHandleState() {
        if (setHandleStateBuilder_ == null) {
          if (methodCase_ == 1) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 1) {
            methodCase_ = 0;
            method_ = null;
          }
          setHandleStateBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.Builder getSetHandleStateBuilder() {
        return getSetHandleStateFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleStateOrBuilder getSetHandleStateOrBuilder() {
        if ((methodCase_ == 1) && (setHandleStateBuilder_ != null)) {
          return setHandleStateBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 1) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetHandleState setHandleState = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState, org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleStateOrBuilder> 
          getSetHandleStateFieldBuilder() {
        if (setHandleStateBuilder_ == null) {
          if (!(methodCase_ == 1)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.getDefaultInstance();
          }
          setHandleStateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState, org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleStateOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 1;
        onChanged();;
        return setHandleStateBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder> getValueStateBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
       * @return Whether the getValueState field is set.
       */
      @java.lang.Override
      public boolean hasGetValueState() {
        return methodCase_ == 2;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
       * @return The getValueState.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand getGetValueState() {
        if (getValueStateBuilder_ == null) {
          if (methodCase_ == 2) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
        } else {
          if (methodCase_ == 2) {
            return getValueStateBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
       */
      public Builder setGetValueState(org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand value) {
        if (getValueStateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          getValueStateBuilder_.setMessage(value);
        }
        methodCase_ = 2;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
       */
      public Builder setGetValueState(
          org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder builderForValue) {
        if (getValueStateBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          getValueStateBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 2;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
       */
      public Builder mergeGetValueState(org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand value) {
        if (getValueStateBuilder_ == null) {
          if (methodCase_ == 2 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 2) {
            getValueStateBuilder_.mergeFrom(value);
          } else {
            getValueStateBuilder_.setMessage(value);
          }
        }
        methodCase_ = 2;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
       */
      public Builder clearGetValueState() {
        if (getValueStateBuilder_ == null) {
          if (methodCase_ == 2) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 2) {
            methodCase_ = 0;
            method_ = null;
          }
          getValueStateBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder getGetValueStateBuilder() {
        return getGetValueStateFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder getGetValueStateOrBuilder() {
        if ((methodCase_ == 2) && (getValueStateBuilder_ != null)) {
          return getValueStateBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 2) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getValueState = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder> 
          getGetValueStateFieldBuilder() {
        if (getValueStateBuilder_ == null) {
          if (!(methodCase_ == 2)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
          }
          getValueStateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 2;
        onChanged();;
        return getValueStateBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder> getListStateBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
       * @return Whether the getListState field is set.
       */
      @java.lang.Override
      public boolean hasGetListState() {
        return methodCase_ == 3;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
       * @return The getListState.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand getGetListState() {
        if (getListStateBuilder_ == null) {
          if (methodCase_ == 3) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
        } else {
          if (methodCase_ == 3) {
            return getListStateBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
       */
      public Builder setGetListState(org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand value) {
        if (getListStateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          getListStateBuilder_.setMessage(value);
        }
        methodCase_ = 3;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
       */
      public Builder setGetListState(
          org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder builderForValue) {
        if (getListStateBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          getListStateBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 3;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
       */
      public Builder mergeGetListState(org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand value) {
        if (getListStateBuilder_ == null) {
          if (methodCase_ == 3 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 3) {
            getListStateBuilder_.mergeFrom(value);
          } else {
            getListStateBuilder_.setMessage(value);
          }
        }
        methodCase_ = 3;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
       */
      public Builder clearGetListState() {
        if (getListStateBuilder_ == null) {
          if (methodCase_ == 3) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 3) {
            methodCase_ = 0;
            method_ = null;
          }
          getListStateBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder getGetListStateBuilder() {
        return getGetListStateFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder getGetListStateOrBuilder() {
        if ((methodCase_ == 3) && (getListStateBuilder_ != null)) {
          return getListStateBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 3) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getListState = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder> 
          getGetListStateFieldBuilder() {
        if (getListStateBuilder_ == null) {
          if (!(methodCase_ == 3)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
          }
          getListStateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 3;
        onChanged();;
        return getListStateBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder> getMapStateBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
       * @return Whether the getMapState field is set.
       */
      @java.lang.Override
      public boolean hasGetMapState() {
        return methodCase_ == 4;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
       * @return The getMapState.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand getGetMapState() {
        if (getMapStateBuilder_ == null) {
          if (methodCase_ == 4) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
        } else {
          if (methodCase_ == 4) {
            return getMapStateBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
       */
      public Builder setGetMapState(org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand value) {
        if (getMapStateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          getMapStateBuilder_.setMessage(value);
        }
        methodCase_ = 4;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
       */
      public Builder setGetMapState(
          org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder builderForValue) {
        if (getMapStateBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          getMapStateBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 4;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
       */
      public Builder mergeGetMapState(org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand value) {
        if (getMapStateBuilder_ == null) {
          if (methodCase_ == 4 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 4) {
            getMapStateBuilder_.mergeFrom(value);
          } else {
            getMapStateBuilder_.setMessage(value);
          }
        }
        methodCase_ = 4;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
       */
      public Builder clearGetMapState() {
        if (getMapStateBuilder_ == null) {
          if (methodCase_ == 4) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 4) {
            methodCase_ = 0;
            method_ = null;
          }
          getMapStateBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder getGetMapStateBuilder() {
        return getGetMapStateFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder getGetMapStateOrBuilder() {
        if ((methodCase_ == 4) && (getMapStateBuilder_ != null)) {
          return getMapStateBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 4) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.StateCallCommand getMapState = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder> 
          getGetMapStateFieldBuilder() {
        if (getMapStateBuilder_ == null) {
          if (!(methodCase_ == 4)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
          }
          getMapStateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 4;
        onChanged();;
        return getMapStateBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.StatefulProcessorCall)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StatefulProcessorCall>
        PARSER = new com.google.protobuf.AbstractParser<StatefulProcessorCall>() {
      @java.lang.Override
      public StatefulProcessorCall parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<StatefulProcessorCall> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StatefulProcessorCall> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StatefulProcessorCall getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface StateVariableRequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.StateVariableRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
     * @return Whether the valueStateCall field is set.
     */
    boolean hasValueStateCall();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
     * @return The valueStateCall.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall getValueStateCall();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCallOrBuilder getValueStateCallOrBuilder();

    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.MethodCase getMethodCase();
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.StateVariableRequest}
   */
  public static final class StateVariableRequest extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.StateVariableRequest)
      StateVariableRequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use StateVariableRequest.newBuilder() to construct.
    private StateVariableRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private StateVariableRequest() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new StateVariableRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateVariableRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateVariableRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.class, org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.Builder.class);
    }

    private int methodCase_ = 0;
    private java.lang.Object method_;
    public enum MethodCase
        implements com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      VALUESTATECALL(1),
      METHOD_NOT_SET(0);
      private final int value;
      private MethodCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static MethodCase valueOf(int value) {
        return forNumber(value);
      }

      public static MethodCase forNumber(int value) {
        switch (value) {
          case 1: return VALUESTATECALL;
          case 0: return METHOD_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public MethodCase
    getMethodCase() {
      return MethodCase.forNumber(
          methodCase_);
    }

    public static final int VALUESTATECALL_FIELD_NUMBER = 1;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
     * @return Whether the valueStateCall field is set.
     */
    @java.lang.Override
    public boolean hasValueStateCall() {
      return methodCase_ == 1;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
     * @return The valueStateCall.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall getValueStateCall() {
      if (methodCase_ == 1) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCallOrBuilder getValueStateCallOrBuilder() {
      if (methodCase_ == 1) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (methodCase_ == 1) {
        output.writeMessage(1, (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall) method_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (methodCase_ == 1) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall) method_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest other = (org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest) obj;

      if (!getMethodCase().equals(other.getMethodCase())) return false;
      switch (methodCase_) {
        case 1:
          if (!getValueStateCall()
              .equals(other.getValueStateCall())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (methodCase_) {
        case 1:
          hash = (37 * hash) + VALUESTATECALL_FIELD_NUMBER;
          hash = (53 * hash) + getValueStateCall().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.StateVariableRequest}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.StateVariableRequest)
        org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateVariableRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateVariableRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.class, org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (valueStateCallBuilder_ != null) {
          valueStateCallBuilder_.clear();
        }
        methodCase_ = 0;
        method_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateVariableRequest_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest result = new org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest(this);
        if (methodCase_ == 1) {
          if (valueStateCallBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = valueStateCallBuilder_.build();
          }
        }
        result.methodCase_ = methodCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest.getDefaultInstance()) return this;
        switch (other.getMethodCase()) {
          case VALUESTATECALL: {
            mergeValueStateCall(other.getValueStateCall());
            break;
          }
          case METHOD_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getValueStateCallFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 1;
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int methodCase_ = 0;
      private java.lang.Object method_;
      public MethodCase
          getMethodCase() {
        return MethodCase.forNumber(
            methodCase_);
      }

      public Builder clearMethod() {
        methodCase_ = 0;
        method_ = null;
        onChanged();
        return this;
      }


      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCallOrBuilder> valueStateCallBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
       * @return Whether the valueStateCall field is set.
       */
      @java.lang.Override
      public boolean hasValueStateCall() {
        return methodCase_ == 1;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
       * @return The valueStateCall.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall getValueStateCall() {
        if (valueStateCallBuilder_ == null) {
          if (methodCase_ == 1) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.getDefaultInstance();
        } else {
          if (methodCase_ == 1) {
            return valueStateCallBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
       */
      public Builder setValueStateCall(org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall value) {
        if (valueStateCallBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          valueStateCallBuilder_.setMessage(value);
        }
        methodCase_ = 1;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
       */
      public Builder setValueStateCall(
          org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.Builder builderForValue) {
        if (valueStateCallBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          valueStateCallBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 1;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
       */
      public Builder mergeValueStateCall(org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall value) {
        if (valueStateCallBuilder_ == null) {
          if (methodCase_ == 1 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 1) {
            valueStateCallBuilder_.mergeFrom(value);
          } else {
            valueStateCallBuilder_.setMessage(value);
          }
        }
        methodCase_ = 1;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
       */
      public Builder clearValueStateCall() {
        if (valueStateCallBuilder_ == null) {
          if (methodCase_ == 1) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 1) {
            methodCase_ = 0;
            method_ = null;
          }
          valueStateCallBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.Builder getValueStateCallBuilder() {
        return getValueStateCallFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCallOrBuilder getValueStateCallOrBuilder() {
        if ((methodCase_ == 1) && (valueStateCallBuilder_ != null)) {
          return valueStateCallBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 1) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateCall valueStateCall = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCallOrBuilder> 
          getValueStateCallFieldBuilder() {
        if (valueStateCallBuilder_ == null) {
          if (!(methodCase_ == 1)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.getDefaultInstance();
          }
          valueStateCallBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCallOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 1;
        onChanged();;
        return valueStateCallBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.StateVariableRequest)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.StateVariableRequest)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StateVariableRequest>
        PARSER = new com.google.protobuf.AbstractParser<StateVariableRequest>() {
      @java.lang.Override
      public StateVariableRequest parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<StateVariableRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StateVariableRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateVariableRequest getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ImplicitGroupingKeyRequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
     * @return Whether the setImplicitKey field is set.
     */
    boolean hasSetImplicitKey();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
     * @return The setImplicitKey.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey getSetImplicitKey();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKeyOrBuilder getSetImplicitKeyOrBuilder();

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
     * @return Whether the removeImplicitKey field is set.
     */
    boolean hasRemoveImplicitKey();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
     * @return The removeImplicitKey.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey getRemoveImplicitKey();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKeyOrBuilder getRemoveImplicitKeyOrBuilder();

    public org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.MethodCase getMethodCase();
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest}
   */
  public static final class ImplicitGroupingKeyRequest extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest)
      ImplicitGroupingKeyRequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ImplicitGroupingKeyRequest.newBuilder() to construct.
    private ImplicitGroupingKeyRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ImplicitGroupingKeyRequest() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ImplicitGroupingKeyRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ImplicitGroupingKeyRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ImplicitGroupingKeyRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.class, org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.Builder.class);
    }

    private int methodCase_ = 0;
    private java.lang.Object method_;
    public enum MethodCase
        implements com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SETIMPLICITKEY(1),
      REMOVEIMPLICITKEY(2),
      METHOD_NOT_SET(0);
      private final int value;
      private MethodCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static MethodCase valueOf(int value) {
        return forNumber(value);
      }

      public static MethodCase forNumber(int value) {
        switch (value) {
          case 1: return SETIMPLICITKEY;
          case 2: return REMOVEIMPLICITKEY;
          case 0: return METHOD_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public MethodCase
    getMethodCase() {
      return MethodCase.forNumber(
          methodCase_);
    }

    public static final int SETIMPLICITKEY_FIELD_NUMBER = 1;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
     * @return Whether the setImplicitKey field is set.
     */
    @java.lang.Override
    public boolean hasSetImplicitKey() {
      return methodCase_ == 1;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
     * @return The setImplicitKey.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey getSetImplicitKey() {
      if (methodCase_ == 1) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKeyOrBuilder getSetImplicitKeyOrBuilder() {
      if (methodCase_ == 1) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.getDefaultInstance();
    }

    public static final int REMOVEIMPLICITKEY_FIELD_NUMBER = 2;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
     * @return Whether the removeImplicitKey field is set.
     */
    @java.lang.Override
    public boolean hasRemoveImplicitKey() {
      return methodCase_ == 2;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
     * @return The removeImplicitKey.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey getRemoveImplicitKey() {
      if (methodCase_ == 2) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKeyOrBuilder getRemoveImplicitKeyOrBuilder() {
      if (methodCase_ == 2) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (methodCase_ == 1) {
        output.writeMessage(1, (org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey) method_);
      }
      if (methodCase_ == 2) {
        output.writeMessage(2, (org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey) method_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (methodCase_ == 1) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, (org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey) method_);
      }
      if (methodCase_ == 2) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, (org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey) method_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest other = (org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest) obj;

      if (!getMethodCase().equals(other.getMethodCase())) return false;
      switch (methodCase_) {
        case 1:
          if (!getSetImplicitKey()
              .equals(other.getSetImplicitKey())) return false;
          break;
        case 2:
          if (!getRemoveImplicitKey()
              .equals(other.getRemoveImplicitKey())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (methodCase_) {
        case 1:
          hash = (37 * hash) + SETIMPLICITKEY_FIELD_NUMBER;
          hash = (53 * hash) + getSetImplicitKey().hashCode();
          break;
        case 2:
          hash = (37 * hash) + REMOVEIMPLICITKEY_FIELD_NUMBER;
          hash = (53 * hash) + getRemoveImplicitKey().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest)
        org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ImplicitGroupingKeyRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ImplicitGroupingKeyRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.class, org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (setImplicitKeyBuilder_ != null) {
          setImplicitKeyBuilder_.clear();
        }
        if (removeImplicitKeyBuilder_ != null) {
          removeImplicitKeyBuilder_.clear();
        }
        methodCase_ = 0;
        method_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ImplicitGroupingKeyRequest_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest result = new org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest(this);
        if (methodCase_ == 1) {
          if (setImplicitKeyBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = setImplicitKeyBuilder_.build();
          }
        }
        if (methodCase_ == 2) {
          if (removeImplicitKeyBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = removeImplicitKeyBuilder_.build();
          }
        }
        result.methodCase_ = methodCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest.getDefaultInstance()) return this;
        switch (other.getMethodCase()) {
          case SETIMPLICITKEY: {
            mergeSetImplicitKey(other.getSetImplicitKey());
            break;
          }
          case REMOVEIMPLICITKEY: {
            mergeRemoveImplicitKey(other.getRemoveImplicitKey());
            break;
          }
          case METHOD_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getSetImplicitKeyFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 1;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getRemoveImplicitKeyFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 2;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int methodCase_ = 0;
      private java.lang.Object method_;
      public MethodCase
          getMethodCase() {
        return MethodCase.forNumber(
            methodCase_);
      }

      public Builder clearMethod() {
        methodCase_ = 0;
        method_ = null;
        onChanged();
        return this;
      }


      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey, org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKeyOrBuilder> setImplicitKeyBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
       * @return Whether the setImplicitKey field is set.
       */
      @java.lang.Override
      public boolean hasSetImplicitKey() {
        return methodCase_ == 1;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
       * @return The setImplicitKey.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey getSetImplicitKey() {
        if (setImplicitKeyBuilder_ == null) {
          if (methodCase_ == 1) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.getDefaultInstance();
        } else {
          if (methodCase_ == 1) {
            return setImplicitKeyBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
       */
      public Builder setSetImplicitKey(org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey value) {
        if (setImplicitKeyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          setImplicitKeyBuilder_.setMessage(value);
        }
        methodCase_ = 1;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
       */
      public Builder setSetImplicitKey(
          org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.Builder builderForValue) {
        if (setImplicitKeyBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          setImplicitKeyBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 1;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
       */
      public Builder mergeSetImplicitKey(org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey value) {
        if (setImplicitKeyBuilder_ == null) {
          if (methodCase_ == 1 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 1) {
            setImplicitKeyBuilder_.mergeFrom(value);
          } else {
            setImplicitKeyBuilder_.setMessage(value);
          }
        }
        methodCase_ = 1;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
       */
      public Builder clearSetImplicitKey() {
        if (setImplicitKeyBuilder_ == null) {
          if (methodCase_ == 1) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 1) {
            methodCase_ = 0;
            method_ = null;
          }
          setImplicitKeyBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.Builder getSetImplicitKeyBuilder() {
        return getSetImplicitKeyFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKeyOrBuilder getSetImplicitKeyOrBuilder() {
        if ((methodCase_ == 1) && (setImplicitKeyBuilder_ != null)) {
          return setImplicitKeyBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 1) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.SetImplicitKey setImplicitKey = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey, org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKeyOrBuilder> 
          getSetImplicitKeyFieldBuilder() {
        if (setImplicitKeyBuilder_ == null) {
          if (!(methodCase_ == 1)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.getDefaultInstance();
          }
          setImplicitKeyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey, org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKeyOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 1;
        onChanged();;
        return setImplicitKeyBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey, org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKeyOrBuilder> removeImplicitKeyBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
       * @return Whether the removeImplicitKey field is set.
       */
      @java.lang.Override
      public boolean hasRemoveImplicitKey() {
        return methodCase_ == 2;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
       * @return The removeImplicitKey.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey getRemoveImplicitKey() {
        if (removeImplicitKeyBuilder_ == null) {
          if (methodCase_ == 2) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.getDefaultInstance();
        } else {
          if (methodCase_ == 2) {
            return removeImplicitKeyBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
       */
      public Builder setRemoveImplicitKey(org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey value) {
        if (removeImplicitKeyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          removeImplicitKeyBuilder_.setMessage(value);
        }
        methodCase_ = 2;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
       */
      public Builder setRemoveImplicitKey(
          org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.Builder builderForValue) {
        if (removeImplicitKeyBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          removeImplicitKeyBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 2;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
       */
      public Builder mergeRemoveImplicitKey(org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey value) {
        if (removeImplicitKeyBuilder_ == null) {
          if (methodCase_ == 2 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 2) {
            removeImplicitKeyBuilder_.mergeFrom(value);
          } else {
            removeImplicitKeyBuilder_.setMessage(value);
          }
        }
        methodCase_ = 2;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
       */
      public Builder clearRemoveImplicitKey() {
        if (removeImplicitKeyBuilder_ == null) {
          if (methodCase_ == 2) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 2) {
            methodCase_ = 0;
            method_ = null;
          }
          removeImplicitKeyBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.Builder getRemoveImplicitKeyBuilder() {
        return getRemoveImplicitKeyFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKeyOrBuilder getRemoveImplicitKeyOrBuilder() {
        if ((methodCase_ == 2) && (removeImplicitKeyBuilder_ != null)) {
          return removeImplicitKeyBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 2) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey removeImplicitKey = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey, org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKeyOrBuilder> 
          getRemoveImplicitKeyFieldBuilder() {
        if (removeImplicitKeyBuilder_ == null) {
          if (!(methodCase_ == 2)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.getDefaultInstance();
          }
          removeImplicitKeyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey, org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKeyOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 2;
        onChanged();;
        return removeImplicitKeyBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.ImplicitGroupingKeyRequest)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ImplicitGroupingKeyRequest>
        PARSER = new com.google.protobuf.AbstractParser<ImplicitGroupingKeyRequest>() {
      @java.lang.Override
      public ImplicitGroupingKeyRequest parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<ImplicitGroupingKeyRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ImplicitGroupingKeyRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.ImplicitGroupingKeyRequest getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface StateCallCommandOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.StateCallCommand)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>string stateName = 1;</code>
     * @return The stateName.
     */
    java.lang.String getStateName();
    /**
     * <code>string stateName = 1;</code>
     * @return The bytes for stateName.
     */
    com.google.protobuf.ByteString
        getStateNameBytes();

    /**
     * <code>string schema = 2;</code>
     * @return The schema.
     */
    java.lang.String getSchema();
    /**
     * <code>string schema = 2;</code>
     * @return The bytes for schema.
     */
    com.google.protobuf.ByteString
        getSchemaBytes();

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
     * @return Whether the ttl field is set.
     */
    boolean hasTtl();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
     * @return The ttl.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig getTtl();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfigOrBuilder getTtlOrBuilder();
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.StateCallCommand}
   */
  public static final class StateCallCommand extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.StateCallCommand)
      StateCallCommandOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use StateCallCommand.newBuilder() to construct.
    private StateCallCommand(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private StateCallCommand() {
      stateName_ = "";
      schema_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new StateCallCommand();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateCallCommand_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateCallCommand_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.class, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder.class);
    }

    public static final int STATENAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object stateName_;
    /**
     * <code>string stateName = 1;</code>
     * @return The stateName.
     */
    @java.lang.Override
    public java.lang.String getStateName() {
      java.lang.Object ref = stateName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateName_ = s;
        return s;
      }
    }
    /**
     * <code>string stateName = 1;</code>
     * @return The bytes for stateName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getStateNameBytes() {
      java.lang.Object ref = stateName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        stateName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_FIELD_NUMBER = 2;
    private volatile java.lang.Object schema_;
    /**
     * <code>string schema = 2;</code>
     * @return The schema.
     */
    @java.lang.Override
    public java.lang.String getSchema() {
      java.lang.Object ref = schema_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schema_ = s;
        return s;
      }
    }
    /**
     * <code>string schema = 2;</code>
     * @return The bytes for schema.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSchemaBytes() {
      java.lang.Object ref = schema_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schema_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TTL_FIELD_NUMBER = 3;
    private org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig ttl_;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
     * @return Whether the ttl field is set.
     */
    @java.lang.Override
    public boolean hasTtl() {
      return ttl_ != null;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
     * @return The ttl.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig getTtl() {
      return ttl_ == null ? org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.getDefaultInstance() : ttl_;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfigOrBuilder getTtlOrBuilder() {
      return getTtl();
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, stateName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schema_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, schema_);
      }
      if (ttl_ != null) {
        output.writeMessage(3, getTtl());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, stateName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schema_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, schema_);
      }
      if (ttl_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getTtl());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand other = (org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) obj;

      if (!getStateName()
          .equals(other.getStateName())) return false;
      if (!getSchema()
          .equals(other.getSchema())) return false;
      if (hasTtl() != other.hasTtl()) return false;
      if (hasTtl()) {
        if (!getTtl()
            .equals(other.getTtl())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATENAME_FIELD_NUMBER;
      hash = (53 * hash) + getStateName().hashCode();
      hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getSchema().hashCode();
      if (hasTtl()) {
        hash = (37 * hash) + TTL_FIELD_NUMBER;
        hash = (53 * hash) + getTtl().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.StateCallCommand}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.StateCallCommand)
        org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommandOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateCallCommand_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateCallCommand_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.class, org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        stateName_ = "";

        schema_ = "";

        if (ttlBuilder_ == null) {
          ttl_ = null;
        } else {
          ttl_ = null;
          ttlBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_StateCallCommand_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand result = new org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand(this);
        result.stateName_ = stateName_;
        result.schema_ = schema_;
        if (ttlBuilder_ == null) {
          result.ttl_ = ttl_;
        } else {
          result.ttl_ = ttlBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand.getDefaultInstance()) return this;
        if (!other.getStateName().isEmpty()) {
          stateName_ = other.stateName_;
          onChanged();
        }
        if (!other.getSchema().isEmpty()) {
          schema_ = other.schema_;
          onChanged();
        }
        if (other.hasTtl()) {
          mergeTtl(other.getTtl());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                stateName_ = input.readStringRequireUtf8();

                break;
              } // case 10
              case 18: {
                schema_ = input.readStringRequireUtf8();

                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getTtlFieldBuilder().getBuilder(),
                    extensionRegistry);

                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object stateName_ = "";
      /**
       * <code>string stateName = 1;</code>
       * @return The stateName.
       */
      public java.lang.String getStateName() {
        java.lang.Object ref = stateName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          stateName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string stateName = 1;</code>
       * @return The bytes for stateName.
       */
      public com.google.protobuf.ByteString
          getStateNameBytes() {
        java.lang.Object ref = stateName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stateName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string stateName = 1;</code>
       * @param value The stateName to set.
       * @return This builder for chaining.
       */
      public Builder setStateName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        stateName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string stateName = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStateName() {
        
        stateName_ = getDefaultInstance().getStateName();
        onChanged();
        return this;
      }
      /**
       * <code>string stateName = 1;</code>
       * @param value The bytes for stateName to set.
       * @return This builder for chaining.
       */
      public Builder setStateNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        stateName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object schema_ = "";
      /**
       * <code>string schema = 2;</code>
       * @return The schema.
       */
      public java.lang.String getSchema() {
        java.lang.Object ref = schema_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          schema_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string schema = 2;</code>
       * @return The bytes for schema.
       */
      public com.google.protobuf.ByteString
          getSchemaBytes() {
        java.lang.Object ref = schema_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schema_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string schema = 2;</code>
       * @param value The schema to set.
       * @return This builder for chaining.
       */
      public Builder setSchema(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        schema_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string schema = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearSchema() {
        
        schema_ = getDefaultInstance().getSchema();
        onChanged();
        return this;
      }
      /**
       * <code>string schema = 2;</code>
       * @param value The bytes for schema to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        schema_ = value;
        onChanged();
        return this;
      }

      private org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig ttl_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig, org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfigOrBuilder> ttlBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
       * @return Whether the ttl field is set.
       */
      public boolean hasTtl() {
        return ttlBuilder_ != null || ttl_ != null;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
       * @return The ttl.
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig getTtl() {
        if (ttlBuilder_ == null) {
          return ttl_ == null ? org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.getDefaultInstance() : ttl_;
        } else {
          return ttlBuilder_.getMessage();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
       */
      public Builder setTtl(org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig value) {
        if (ttlBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ttl_ = value;
          onChanged();
        } else {
          ttlBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
       */
      public Builder setTtl(
          org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.Builder builderForValue) {
        if (ttlBuilder_ == null) {
          ttl_ = builderForValue.build();
          onChanged();
        } else {
          ttlBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
       */
      public Builder mergeTtl(org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig value) {
        if (ttlBuilder_ == null) {
          if (ttl_ != null) {
            ttl_ =
              org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.newBuilder(ttl_).mergeFrom(value).buildPartial();
          } else {
            ttl_ = value;
          }
          onChanged();
        } else {
          ttlBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
       */
      public Builder clearTtl() {
        if (ttlBuilder_ == null) {
          ttl_ = null;
          onChanged();
        } else {
          ttl_ = null;
          ttlBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.Builder getTtlBuilder() {
        
        onChanged();
        return getTtlFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfigOrBuilder getTtlOrBuilder() {
        if (ttlBuilder_ != null) {
          return ttlBuilder_.getMessageOrBuilder();
        } else {
          return ttl_ == null ?
              org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.getDefaultInstance() : ttl_;
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.TTLConfig ttl = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig, org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfigOrBuilder> 
          getTtlFieldBuilder() {
        if (ttlBuilder_ == null) {
          ttlBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig, org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfigOrBuilder>(
                  getTtl(),
                  getParentForChildren(),
                  isClean());
          ttl_ = null;
        }
        return ttlBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.StateCallCommand)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.StateCallCommand)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StateCallCommand>
        PARSER = new com.google.protobuf.AbstractParser<StateCallCommand>() {
      @java.lang.Override
      public StateCallCommand parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<StateCallCommand> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StateCallCommand> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.StateCallCommand getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ValueStateCallOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.ValueStateCall)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>string stateName = 1;</code>
     * @return The stateName.
     */
    java.lang.String getStateName();
    /**
     * <code>string stateName = 1;</code>
     * @return The bytes for stateName.
     */
    com.google.protobuf.ByteString
        getStateNameBytes();

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
     * @return Whether the exists field is set.
     */
    boolean hasExists();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
     * @return The exists.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.Exists getExists();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.ExistsOrBuilder getExistsOrBuilder();

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
     * @return Whether the get field is set.
     */
    boolean hasGet();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
     * @return The get.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.Get getGet();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.GetOrBuilder getGetOrBuilder();

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
     * @return Whether the valueStateUpdate field is set.
     */
    boolean hasValueStateUpdate();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
     * @return The valueStateUpdate.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate getValueStateUpdate();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdateOrBuilder getValueStateUpdateOrBuilder();

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
     * @return Whether the clear field is set.
     */
    boolean hasClear();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
     * @return The clear.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.Clear getClear();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.ClearOrBuilder getClearOrBuilder();

    public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.MethodCase getMethodCase();
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.ValueStateCall}
   */
  public static final class ValueStateCall extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.ValueStateCall)
      ValueStateCallOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ValueStateCall.newBuilder() to construct.
    private ValueStateCall(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ValueStateCall() {
      stateName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ValueStateCall();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateCall_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateCall_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.class, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.Builder.class);
    }

    private int methodCase_ = 0;
    private java.lang.Object method_;
    public enum MethodCase
        implements com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      EXISTS(2),
      GET(3),
      VALUESTATEUPDATE(4),
      CLEAR(5),
      METHOD_NOT_SET(0);
      private final int value;
      private MethodCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static MethodCase valueOf(int value) {
        return forNumber(value);
      }

      public static MethodCase forNumber(int value) {
        switch (value) {
          case 2: return EXISTS;
          case 3: return GET;
          case 4: return VALUESTATEUPDATE;
          case 5: return CLEAR;
          case 0: return METHOD_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public MethodCase
    getMethodCase() {
      return MethodCase.forNumber(
          methodCase_);
    }

    public static final int STATENAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object stateName_;
    /**
     * <code>string stateName = 1;</code>
     * @return The stateName.
     */
    @java.lang.Override
    public java.lang.String getStateName() {
      java.lang.Object ref = stateName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateName_ = s;
        return s;
      }
    }
    /**
     * <code>string stateName = 1;</code>
     * @return The bytes for stateName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getStateNameBytes() {
      java.lang.Object ref = stateName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        stateName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EXISTS_FIELD_NUMBER = 2;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
     * @return Whether the exists field is set.
     */
    @java.lang.Override
    public boolean hasExists() {
      return methodCase_ == 2;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
     * @return The exists.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.Exists getExists() {
      if (methodCase_ == 2) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.Exists) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.ExistsOrBuilder getExistsOrBuilder() {
      if (methodCase_ == 2) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.Exists) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.getDefaultInstance();
    }

    public static final int GET_FIELD_NUMBER = 3;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
     * @return Whether the get field is set.
     */
    @java.lang.Override
    public boolean hasGet() {
      return methodCase_ == 3;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
     * @return The get.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.Get getGet() {
      if (methodCase_ == 3) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.Get) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.Get.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.GetOrBuilder getGetOrBuilder() {
      if (methodCase_ == 3) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.Get) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.Get.getDefaultInstance();
    }

    public static final int VALUESTATEUPDATE_FIELD_NUMBER = 4;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
     * @return Whether the valueStateUpdate field is set.
     */
    @java.lang.Override
    public boolean hasValueStateUpdate() {
      return methodCase_ == 4;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
     * @return The valueStateUpdate.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate getValueStateUpdate() {
      if (methodCase_ == 4) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdateOrBuilder getValueStateUpdateOrBuilder() {
      if (methodCase_ == 4) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.getDefaultInstance();
    }

    public static final int CLEAR_FIELD_NUMBER = 5;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
     * @return Whether the clear field is set.
     */
    @java.lang.Override
    public boolean hasClear() {
      return methodCase_ == 5;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
     * @return The clear.
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.Clear getClear() {
      if (methodCase_ == 5) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.Clear) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.getDefaultInstance();
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
     */
    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.ClearOrBuilder getClearOrBuilder() {
      if (methodCase_ == 5) {
         return (org.apache.spark.sql.execution.streaming.state.StateMessage.Clear) method_;
      }
      return org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, stateName_);
      }
      if (methodCase_ == 2) {
        output.writeMessage(2, (org.apache.spark.sql.execution.streaming.state.StateMessage.Exists) method_);
      }
      if (methodCase_ == 3) {
        output.writeMessage(3, (org.apache.spark.sql.execution.streaming.state.StateMessage.Get) method_);
      }
      if (methodCase_ == 4) {
        output.writeMessage(4, (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate) method_);
      }
      if (methodCase_ == 5) {
        output.writeMessage(5, (org.apache.spark.sql.execution.streaming.state.StateMessage.Clear) method_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, stateName_);
      }
      if (methodCase_ == 2) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, (org.apache.spark.sql.execution.streaming.state.StateMessage.Exists) method_);
      }
      if (methodCase_ == 3) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, (org.apache.spark.sql.execution.streaming.state.StateMessage.Get) method_);
      }
      if (methodCase_ == 4) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate) method_);
      }
      if (methodCase_ == 5) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, (org.apache.spark.sql.execution.streaming.state.StateMessage.Clear) method_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall other = (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall) obj;

      if (!getStateName()
          .equals(other.getStateName())) return false;
      if (!getMethodCase().equals(other.getMethodCase())) return false;
      switch (methodCase_) {
        case 2:
          if (!getExists()
              .equals(other.getExists())) return false;
          break;
        case 3:
          if (!getGet()
              .equals(other.getGet())) return false;
          break;
        case 4:
          if (!getValueStateUpdate()
              .equals(other.getValueStateUpdate())) return false;
          break;
        case 5:
          if (!getClear()
              .equals(other.getClear())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATENAME_FIELD_NUMBER;
      hash = (53 * hash) + getStateName().hashCode();
      switch (methodCase_) {
        case 2:
          hash = (37 * hash) + EXISTS_FIELD_NUMBER;
          hash = (53 * hash) + getExists().hashCode();
          break;
        case 3:
          hash = (37 * hash) + GET_FIELD_NUMBER;
          hash = (53 * hash) + getGet().hashCode();
          break;
        case 4:
          hash = (37 * hash) + VALUESTATEUPDATE_FIELD_NUMBER;
          hash = (53 * hash) + getValueStateUpdate().hashCode();
          break;
        case 5:
          hash = (37 * hash) + CLEAR_FIELD_NUMBER;
          hash = (53 * hash) + getClear().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.ValueStateCall}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.ValueStateCall)
        org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCallOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateCall_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateCall_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.class, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        stateName_ = "";

        if (existsBuilder_ != null) {
          existsBuilder_.clear();
        }
        if (getBuilder_ != null) {
          getBuilder_.clear();
        }
        if (valueStateUpdateBuilder_ != null) {
          valueStateUpdateBuilder_.clear();
        }
        if (clearBuilder_ != null) {
          clearBuilder_.clear();
        }
        methodCase_ = 0;
        method_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateCall_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall result = new org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall(this);
        result.stateName_ = stateName_;
        if (methodCase_ == 2) {
          if (existsBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = existsBuilder_.build();
          }
        }
        if (methodCase_ == 3) {
          if (getBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = getBuilder_.build();
          }
        }
        if (methodCase_ == 4) {
          if (valueStateUpdateBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = valueStateUpdateBuilder_.build();
          }
        }
        if (methodCase_ == 5) {
          if (clearBuilder_ == null) {
            result.method_ = method_;
          } else {
            result.method_ = clearBuilder_.build();
          }
        }
        result.methodCase_ = methodCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall.getDefaultInstance()) return this;
        if (!other.getStateName().isEmpty()) {
          stateName_ = other.stateName_;
          onChanged();
        }
        switch (other.getMethodCase()) {
          case EXISTS: {
            mergeExists(other.getExists());
            break;
          }
          case GET: {
            mergeGet(other.getGet());
            break;
          }
          case VALUESTATEUPDATE: {
            mergeValueStateUpdate(other.getValueStateUpdate());
            break;
          }
          case CLEAR: {
            mergeClear(other.getClear());
            break;
          }
          case METHOD_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                stateName_ = input.readStringRequireUtf8();

                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getExistsFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 2;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getGetFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 3;
                break;
              } // case 26
              case 34: {
                input.readMessage(
                    getValueStateUpdateFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 4;
                break;
              } // case 34
              case 42: {
                input.readMessage(
                    getClearFieldBuilder().getBuilder(),
                    extensionRegistry);
                methodCase_ = 5;
                break;
              } // case 42
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int methodCase_ = 0;
      private java.lang.Object method_;
      public MethodCase
          getMethodCase() {
        return MethodCase.forNumber(
            methodCase_);
      }

      public Builder clearMethod() {
        methodCase_ = 0;
        method_ = null;
        onChanged();
        return this;
      }


      private java.lang.Object stateName_ = "";
      /**
       * <code>string stateName = 1;</code>
       * @return The stateName.
       */
      public java.lang.String getStateName() {
        java.lang.Object ref = stateName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          stateName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string stateName = 1;</code>
       * @return The bytes for stateName.
       */
      public com.google.protobuf.ByteString
          getStateNameBytes() {
        java.lang.Object ref = stateName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stateName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string stateName = 1;</code>
       * @param value The stateName to set.
       * @return This builder for chaining.
       */
      public Builder setStateName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        stateName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string stateName = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStateName() {
        
        stateName_ = getDefaultInstance().getStateName();
        onChanged();
        return this;
      }
      /**
       * <code>string stateName = 1;</code>
       * @param value The bytes for stateName to set.
       * @return This builder for chaining.
       */
      public Builder setStateNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        stateName_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.Exists, org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ExistsOrBuilder> existsBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
       * @return Whether the exists field is set.
       */
      @java.lang.Override
      public boolean hasExists() {
        return methodCase_ == 2;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
       * @return The exists.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Exists getExists() {
        if (existsBuilder_ == null) {
          if (methodCase_ == 2) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.Exists) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.getDefaultInstance();
        } else {
          if (methodCase_ == 2) {
            return existsBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
       */
      public Builder setExists(org.apache.spark.sql.execution.streaming.state.StateMessage.Exists value) {
        if (existsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          existsBuilder_.setMessage(value);
        }
        methodCase_ = 2;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
       */
      public Builder setExists(
          org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.Builder builderForValue) {
        if (existsBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          existsBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 2;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
       */
      public Builder mergeExists(org.apache.spark.sql.execution.streaming.state.StateMessage.Exists value) {
        if (existsBuilder_ == null) {
          if (methodCase_ == 2 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.Exists) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 2) {
            existsBuilder_.mergeFrom(value);
          } else {
            existsBuilder_.setMessage(value);
          }
        }
        methodCase_ = 2;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
       */
      public Builder clearExists() {
        if (existsBuilder_ == null) {
          if (methodCase_ == 2) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 2) {
            methodCase_ = 0;
            method_ = null;
          }
          existsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.Builder getExistsBuilder() {
        return getExistsFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ExistsOrBuilder getExistsOrBuilder() {
        if ((methodCase_ == 2) && (existsBuilder_ != null)) {
          return existsBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 2) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.Exists) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Exists exists = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.Exists, org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ExistsOrBuilder> 
          getExistsFieldBuilder() {
        if (existsBuilder_ == null) {
          if (!(methodCase_ == 2)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.getDefaultInstance();
          }
          existsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.Exists, org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ExistsOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.Exists) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 2;
        onChanged();;
        return existsBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.Get, org.apache.spark.sql.execution.streaming.state.StateMessage.Get.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.GetOrBuilder> getBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
       * @return Whether the get field is set.
       */
      @java.lang.Override
      public boolean hasGet() {
        return methodCase_ == 3;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
       * @return The get.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Get getGet() {
        if (getBuilder_ == null) {
          if (methodCase_ == 3) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.Get) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.Get.getDefaultInstance();
        } else {
          if (methodCase_ == 3) {
            return getBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.Get.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
       */
      public Builder setGet(org.apache.spark.sql.execution.streaming.state.StateMessage.Get value) {
        if (getBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          getBuilder_.setMessage(value);
        }
        methodCase_ = 3;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
       */
      public Builder setGet(
          org.apache.spark.sql.execution.streaming.state.StateMessage.Get.Builder builderForValue) {
        if (getBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          getBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 3;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
       */
      public Builder mergeGet(org.apache.spark.sql.execution.streaming.state.StateMessage.Get value) {
        if (getBuilder_ == null) {
          if (methodCase_ == 3 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.Get.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.Get.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.Get) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 3) {
            getBuilder_.mergeFrom(value);
          } else {
            getBuilder_.setMessage(value);
          }
        }
        methodCase_ = 3;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
       */
      public Builder clearGet() {
        if (getBuilder_ == null) {
          if (methodCase_ == 3) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 3) {
            methodCase_ = 0;
            method_ = null;
          }
          getBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Get.Builder getGetBuilder() {
        return getGetFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.GetOrBuilder getGetOrBuilder() {
        if ((methodCase_ == 3) && (getBuilder_ != null)) {
          return getBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 3) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.Get) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.Get.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Get get = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.Get, org.apache.spark.sql.execution.streaming.state.StateMessage.Get.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.GetOrBuilder> 
          getGetFieldBuilder() {
        if (getBuilder_ == null) {
          if (!(methodCase_ == 3)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.Get.getDefaultInstance();
          }
          getBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.Get, org.apache.spark.sql.execution.streaming.state.StateMessage.Get.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.GetOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.Get) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 3;
        onChanged();;
        return getBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdateOrBuilder> valueStateUpdateBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
       * @return Whether the valueStateUpdate field is set.
       */
      @java.lang.Override
      public boolean hasValueStateUpdate() {
        return methodCase_ == 4;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
       * @return The valueStateUpdate.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate getValueStateUpdate() {
        if (valueStateUpdateBuilder_ == null) {
          if (methodCase_ == 4) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.getDefaultInstance();
        } else {
          if (methodCase_ == 4) {
            return valueStateUpdateBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
       */
      public Builder setValueStateUpdate(org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate value) {
        if (valueStateUpdateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          valueStateUpdateBuilder_.setMessage(value);
        }
        methodCase_ = 4;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
       */
      public Builder setValueStateUpdate(
          org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.Builder builderForValue) {
        if (valueStateUpdateBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          valueStateUpdateBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 4;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
       */
      public Builder mergeValueStateUpdate(org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate value) {
        if (valueStateUpdateBuilder_ == null) {
          if (methodCase_ == 4 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 4) {
            valueStateUpdateBuilder_.mergeFrom(value);
          } else {
            valueStateUpdateBuilder_.setMessage(value);
          }
        }
        methodCase_ = 4;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
       */
      public Builder clearValueStateUpdate() {
        if (valueStateUpdateBuilder_ == null) {
          if (methodCase_ == 4) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 4) {
            methodCase_ = 0;
            method_ = null;
          }
          valueStateUpdateBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.Builder getValueStateUpdateBuilder() {
        return getValueStateUpdateFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdateOrBuilder getValueStateUpdateOrBuilder() {
        if ((methodCase_ == 4) && (valueStateUpdateBuilder_ != null)) {
          return valueStateUpdateBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 4) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.ValueStateUpdate valueStateUpdate = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdateOrBuilder> 
          getValueStateUpdateFieldBuilder() {
        if (valueStateUpdateBuilder_ == null) {
          if (!(methodCase_ == 4)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.getDefaultInstance();
          }
          valueStateUpdateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdateOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 4;
        onChanged();;
        return valueStateUpdateBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.Clear, org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ClearOrBuilder> clearBuilder_;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
       * @return Whether the clear field is set.
       */
      @java.lang.Override
      public boolean hasClear() {
        return methodCase_ == 5;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
       * @return The clear.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Clear getClear() {
        if (clearBuilder_ == null) {
          if (methodCase_ == 5) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.Clear) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.getDefaultInstance();
        } else {
          if (methodCase_ == 5) {
            return clearBuilder_.getMessage();
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
       */
      public Builder setClear(org.apache.spark.sql.execution.streaming.state.StateMessage.Clear value) {
        if (clearBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
          onChanged();
        } else {
          clearBuilder_.setMessage(value);
        }
        methodCase_ = 5;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
       */
      public Builder setClear(
          org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.Builder builderForValue) {
        if (clearBuilder_ == null) {
          method_ = builderForValue.build();
          onChanged();
        } else {
          clearBuilder_.setMessage(builderForValue.build());
        }
        methodCase_ = 5;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
       */
      public Builder mergeClear(org.apache.spark.sql.execution.streaming.state.StateMessage.Clear value) {
        if (clearBuilder_ == null) {
          if (methodCase_ == 5 &&
              method_ != org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.getDefaultInstance()) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.newBuilder((org.apache.spark.sql.execution.streaming.state.StateMessage.Clear) method_)
                .mergeFrom(value).buildPartial();
          } else {
            method_ = value;
          }
          onChanged();
        } else {
          if (methodCase_ == 5) {
            clearBuilder_.mergeFrom(value);
          } else {
            clearBuilder_.setMessage(value);
          }
        }
        methodCase_ = 5;
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
       */
      public Builder clearClear() {
        if (clearBuilder_ == null) {
          if (methodCase_ == 5) {
            methodCase_ = 0;
            method_ = null;
            onChanged();
          }
        } else {
          if (methodCase_ == 5) {
            methodCase_ = 0;
            method_ = null;
          }
          clearBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
       */
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.Builder getClearBuilder() {
        return getClearFieldBuilder().getBuilder();
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ClearOrBuilder getClearOrBuilder() {
        if ((methodCase_ == 5) && (clearBuilder_ != null)) {
          return clearBuilder_.getMessageOrBuilder();
        } else {
          if (methodCase_ == 5) {
            return (org.apache.spark.sql.execution.streaming.state.StateMessage.Clear) method_;
          }
          return org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.getDefaultInstance();
        }
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.Clear clear = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.spark.sql.execution.streaming.state.StateMessage.Clear, org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ClearOrBuilder> 
          getClearFieldBuilder() {
        if (clearBuilder_ == null) {
          if (!(methodCase_ == 5)) {
            method_ = org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.getDefaultInstance();
          }
          clearBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.spark.sql.execution.streaming.state.StateMessage.Clear, org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.Builder, org.apache.spark.sql.execution.streaming.state.StateMessage.ClearOrBuilder>(
                  (org.apache.spark.sql.execution.streaming.state.StateMessage.Clear) method_,
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        methodCase_ = 5;
        onChanged();;
        return clearBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.ValueStateCall)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.ValueStateCall)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ValueStateCall>
        PARSER = new com.google.protobuf.AbstractParser<ValueStateCall>() {
      @java.lang.Override
      public ValueStateCall parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<ValueStateCall> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ValueStateCall> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateCall getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SetImplicitKeyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.SetImplicitKey)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>bytes key = 1;</code>
     * @return The key.
     */
    com.google.protobuf.ByteString getKey();
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.SetImplicitKey}
   */
  public static final class SetImplicitKey extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.SetImplicitKey)
      SetImplicitKeyOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SetImplicitKey.newBuilder() to construct.
    private SetImplicitKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SetImplicitKey() {
      key_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new SetImplicitKey();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_SetImplicitKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_SetImplicitKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.class, org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.Builder.class);
    }

    public static final int KEY_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString key_;
    /**
     * <code>bytes key = 1;</code>
     * @return The key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKey() {
      return key_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!key_.isEmpty()) {
        output.writeBytes(1, key_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!key_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, key_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey other = (org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey) obj;

      if (!getKey()
          .equals(other.getKey())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.SetImplicitKey}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.SetImplicitKey)
        org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKeyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_SetImplicitKey_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_SetImplicitKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.class, org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        key_ = com.google.protobuf.ByteString.EMPTY;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_SetImplicitKey_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey result = new org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey(this);
        result.key_ = key_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey.getDefaultInstance()) return this;
        if (other.getKey() != com.google.protobuf.ByteString.EMPTY) {
          setKey(other.getKey());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                key_ = input.readBytes();

                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.protobuf.ByteString key_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>bytes key = 1;</code>
       * @return The key.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getKey() {
        return key_;
      }
      /**
       * <code>bytes key = 1;</code>
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        key_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>bytes key = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        
        key_ = getDefaultInstance().getKey();
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.SetImplicitKey)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.SetImplicitKey)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SetImplicitKey>
        PARSER = new com.google.protobuf.AbstractParser<SetImplicitKey>() {
      @java.lang.Override
      public SetImplicitKey parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<SetImplicitKey> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SetImplicitKey> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.SetImplicitKey getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface RemoveImplicitKeyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey}
   */
  public static final class RemoveImplicitKey extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey)
      RemoveImplicitKeyOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use RemoveImplicitKey.newBuilder() to construct.
    private RemoveImplicitKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private RemoveImplicitKey() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new RemoveImplicitKey();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_RemoveImplicitKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_RemoveImplicitKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.class, org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey other = (org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey)
        org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKeyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_RemoveImplicitKey_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_RemoveImplicitKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.class, org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_RemoveImplicitKey_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey result = new org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.RemoveImplicitKey)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RemoveImplicitKey>
        PARSER = new com.google.protobuf.AbstractParser<RemoveImplicitKey>() {
      @java.lang.Override
      public RemoveImplicitKey parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<RemoveImplicitKey> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RemoveImplicitKey> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.RemoveImplicitKey getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ExistsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.Exists)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.Exists}
   */
  public static final class Exists extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.Exists)
      ExistsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Exists.newBuilder() to construct.
    private Exists(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Exists() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Exists();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Exists_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Exists_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.class, org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.Exists)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.Exists other = (org.apache.spark.sql.execution.streaming.state.StateMessage.Exists) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.Exists prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.Exists}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.Exists)
        org.apache.spark.sql.execution.streaming.state.StateMessage.ExistsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Exists_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Exists_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.class, org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Exists_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Exists getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Exists build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.Exists result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Exists buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.Exists result = new org.apache.spark.sql.execution.streaming.state.StateMessage.Exists(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.Exists) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.Exists)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.Exists other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.Exists.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.Exists)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.Exists)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.Exists DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.Exists();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Exists getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Exists>
        PARSER = new com.google.protobuf.AbstractParser<Exists>() {
      @java.lang.Override
      public Exists parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Exists> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Exists> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.Exists getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.Get)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.Get}
   */
  public static final class Get extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.Get)
      GetOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Get.newBuilder() to construct.
    private Get(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Get() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Get();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Get_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Get_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.Get.class, org.apache.spark.sql.execution.streaming.state.StateMessage.Get.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.Get)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.Get other = (org.apache.spark.sql.execution.streaming.state.StateMessage.Get) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.Get prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.Get}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.Get)
        org.apache.spark.sql.execution.streaming.state.StateMessage.GetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Get_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Get_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.Get.class, org.apache.spark.sql.execution.streaming.state.StateMessage.Get.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.Get.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Get_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Get getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.Get.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Get build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.Get result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Get buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.Get result = new org.apache.spark.sql.execution.streaming.state.StateMessage.Get(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.Get) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.Get)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.Get other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.Get.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.Get)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.Get)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.Get DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.Get();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Get getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Get>
        PARSER = new com.google.protobuf.AbstractParser<Get>() {
      @java.lang.Override
      public Get parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Get> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Get> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.Get getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ValueStateUpdateOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.ValueStateUpdate)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>bytes value = 1;</code>
     * @return The value.
     */
    com.google.protobuf.ByteString getValue();
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.ValueStateUpdate}
   */
  public static final class ValueStateUpdate extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.ValueStateUpdate)
      ValueStateUpdateOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ValueStateUpdate.newBuilder() to construct.
    private ValueStateUpdate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ValueStateUpdate() {
      value_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ValueStateUpdate();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateUpdate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateUpdate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.class, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString value_;
    /**
     * <code>bytes value = 1;</code>
     * @return The value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValue() {
      return value_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!value_.isEmpty()) {
        output.writeBytes(1, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!value_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate other = (org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate) obj;

      if (!getValue()
          .equals(other.getValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.ValueStateUpdate}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.ValueStateUpdate)
        org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateUpdate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateUpdate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.class, org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        value_ = com.google.protobuf.ByteString.EMPTY;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateUpdate_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate result = new org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate(this);
        result.value_ = value_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate.getDefaultInstance()) return this;
        if (other.getValue() != com.google.protobuf.ByteString.EMPTY) {
          setValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                value_ = input.readBytes();

                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>bytes value = 1;</code>
       * @return The value.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getValue() {
        return value_;
      }
      /**
       * <code>bytes value = 1;</code>
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>bytes value = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        
        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.ValueStateUpdate)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.ValueStateUpdate)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ValueStateUpdate>
        PARSER = new com.google.protobuf.AbstractParser<ValueStateUpdate>() {
      @java.lang.Override
      public ValueStateUpdate parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<ValueStateUpdate> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ValueStateUpdate> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.ValueStateUpdate getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ClearOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.Clear)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.Clear}
   */
  public static final class Clear extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.Clear)
      ClearOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Clear.newBuilder() to construct.
    private Clear(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Clear() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Clear();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Clear_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Clear_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.class, org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.Clear)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.Clear other = (org.apache.spark.sql.execution.streaming.state.StateMessage.Clear) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.Clear prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.Clear}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.Clear)
        org.apache.spark.sql.execution.streaming.state.StateMessage.ClearOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Clear_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Clear_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.class, org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_Clear_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Clear getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Clear build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.Clear result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.Clear buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.Clear result = new org.apache.spark.sql.execution.streaming.state.StateMessage.Clear(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.Clear) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.Clear)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.Clear other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.Clear.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.Clear)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.Clear)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.Clear DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.Clear();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.Clear getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Clear>
        PARSER = new com.google.protobuf.AbstractParser<Clear>() {
      @java.lang.Override
      public Clear parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Clear> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Clear> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.Clear getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SetHandleStateOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.SetHandleState)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.HandleState state = 1;</code>
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.HandleState state = 1;</code>
     * @return The state.
     */
    org.apache.spark.sql.execution.streaming.state.StateMessage.HandleState getState();
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.SetHandleState}
   */
  public static final class SetHandleState extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.SetHandleState)
      SetHandleStateOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SetHandleState.newBuilder() to construct.
    private SetHandleState(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SetHandleState() {
      state_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new SetHandleState();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_SetHandleState_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_SetHandleState_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.class, org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.Builder.class);
    }

    public static final int STATE_FIELD_NUMBER = 1;
    private int state_;
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.HandleState state = 1;</code>
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override public int getStateValue() {
      return state_;
    }
    /**
     * <code>.org.apache.spark.sql.execution.streaming.state.HandleState state = 1;</code>
     * @return The state.
     */
    @java.lang.Override public org.apache.spark.sql.execution.streaming.state.StateMessage.HandleState getState() {
      @SuppressWarnings("deprecation")
      org.apache.spark.sql.execution.streaming.state.StateMessage.HandleState result = org.apache.spark.sql.execution.streaming.state.StateMessage.HandleState.valueOf(state_);
      return result == null ? org.apache.spark.sql.execution.streaming.state.StateMessage.HandleState.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (state_ != org.apache.spark.sql.execution.streaming.state.StateMessage.HandleState.CREATED.getNumber()) {
        output.writeEnum(1, state_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_ != org.apache.spark.sql.execution.streaming.state.StateMessage.HandleState.CREATED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, state_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState other = (org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState) obj;

      if (state_ != other.state_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.SetHandleState}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.SetHandleState)
        org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleStateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_SetHandleState_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_SetHandleState_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.class, org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        state_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_SetHandleState_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState result = new org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState(this);
        result.state_ = state_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState.getDefaultInstance()) return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                state_ = input.readEnum();

                break;
              } // case 8
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int state_ = 0;
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.HandleState state = 1;</code>
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override public int getStateValue() {
        return state_;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.HandleState state = 1;</code>
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        
        state_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.HandleState state = 1;</code>
       * @return The state.
       */
      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.HandleState getState() {
        @SuppressWarnings("deprecation")
        org.apache.spark.sql.execution.streaming.state.StateMessage.HandleState result = org.apache.spark.sql.execution.streaming.state.StateMessage.HandleState.valueOf(state_);
        return result == null ? org.apache.spark.sql.execution.streaming.state.StateMessage.HandleState.UNRECOGNIZED : result;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.HandleState state = 1;</code>
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(org.apache.spark.sql.execution.streaming.state.StateMessage.HandleState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>.org.apache.spark.sql.execution.streaming.state.HandleState state = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearState() {
        
        state_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.SetHandleState)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.SetHandleState)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SetHandleState>
        PARSER = new com.google.protobuf.AbstractParser<SetHandleState>() {
      @java.lang.Override
      public SetHandleState parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<SetHandleState> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SetHandleState> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.SetHandleState getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TTLConfigOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.spark.sql.execution.streaming.state.TTLConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>int32 durationMs = 1;</code>
     * @return The durationMs.
     */
    int getDurationMs();
  }
  /**
   * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.TTLConfig}
   */
  public static final class TTLConfig extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.spark.sql.execution.streaming.state.TTLConfig)
      TTLConfigOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TTLConfig.newBuilder() to construct.
    private TTLConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TTLConfig() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new TTLConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_TTLConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_TTLConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.class, org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.Builder.class);
    }

    public static final int DURATIONMS_FIELD_NUMBER = 1;
    private int durationMs_;
    /**
     * <code>int32 durationMs = 1;</code>
     * @return The durationMs.
     */
    @java.lang.Override
    public int getDurationMs() {
      return durationMs_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (durationMs_ != 0) {
        output.writeInt32(1, durationMs_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (durationMs_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(1, durationMs_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig)) {
        return super.equals(obj);
      }
      org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig other = (org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig) obj;

      if (getDurationMs()
          != other.getDurationMs()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DURATIONMS_FIELD_NUMBER;
      hash = (53 * hash) + getDurationMs();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.spark.sql.execution.streaming.state.TTLConfig}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.spark.sql.execution.streaming.state.TTLConfig)
        org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_TTLConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_TTLConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.class, org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.Builder.class);
      }

      // Construct using org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        durationMs_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.internal_static_org_apache_spark_sql_execution_streaming_state_TTLConfig_descriptor;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig getDefaultInstanceForType() {
        return org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig build() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig buildPartial() {
        org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig result = new org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig(this);
        result.durationMs_ = durationMs_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig) {
          return mergeFrom((org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig other) {
        if (other == org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig.getDefaultInstance()) return this;
        if (other.getDurationMs() != 0) {
          setDurationMs(other.getDurationMs());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                durationMs_ = input.readInt32();

                break;
              } // case 8
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int durationMs_ ;
      /**
       * <code>int32 durationMs = 1;</code>
       * @return The durationMs.
       */
      @java.lang.Override
      public int getDurationMs() {
        return durationMs_;
      }
      /**
       * <code>int32 durationMs = 1;</code>
       * @param value The durationMs to set.
       * @return This builder for chaining.
       */
      public Builder setDurationMs(int value) {
        
        durationMs_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>int32 durationMs = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearDurationMs() {
        
        durationMs_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.spark.sql.execution.streaming.state.TTLConfig)
    }

    // @@protoc_insertion_point(class_scope:org.apache.spark.sql.execution.streaming.state.TTLConfig)
    private static final org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig();
    }

    public static org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TTLConfig>
        PARSER = new com.google.protobuf.AbstractParser<TTLConfig>() {
      @java.lang.Override
      public TTLConfig parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<TTLConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TTLConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.spark.sql.execution.streaming.state.StateMessage.TTLConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_StateRequest_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_StateRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_StateResponse_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_StateResponse_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_StatefulProcessorCall_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_StatefulProcessorCall_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_StateVariableRequest_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_StateVariableRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_ImplicitGroupingKeyRequest_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_ImplicitGroupingKeyRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_StateCallCommand_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_StateCallCommand_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateCall_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateCall_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_SetImplicitKey_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_SetImplicitKey_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_RemoveImplicitKey_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_RemoveImplicitKey_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_Exists_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_Exists_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_Get_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_Get_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateUpdate_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateUpdate_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_Clear_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_Clear_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_SetHandleState_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_SetHandleState_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_org_apache_spark_sql_execution_streaming_state_TTLConfig_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_spark_sql_execution_streaming_state_TTLConfig_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\022StateMessage.proto\022.org.apache.spark.s" +
      "ql.execution.streaming.state\"\351\002\n\014StateRe" +
      "quest\022\017\n\007version\030\001 \001(\005\022f\n\025statefulProces" +
      "sorCall\030\002 \001(\0132E.org.apache.spark.sql.exe" +
      "cution.streaming.state.StatefulProcessor" +
      "CallH\000\022d\n\024stateVariableRequest\030\003 \001(\0132D.o" +
      "rg.apache.spark.sql.execution.streaming." +
      "state.StateVariableRequestH\000\022p\n\032implicit" +
      "GroupingKeyRequest\030\004 \001(\0132J.org.apache.sp" +
      "ark.sql.execution.streaming.state.Implic" +
      "itGroupingKeyRequestH\000B\010\n\006method\"H\n\rStat" +
      "eResponse\022\022\n\nstatusCode\030\001 \001(\005\022\024\n\014errorMe" +
      "ssage\030\002 \001(\t\022\r\n\005value\030\003 \001(\014\"\211\003\n\025StatefulP" +
      "rocessorCall\022X\n\016setHandleState\030\001 \001(\0132>.o" +
      "rg.apache.spark.sql.execution.streaming." +
      "state.SetHandleStateH\000\022Y\n\rgetValueState\030" +
      "\002 \001(\0132@.org.apache.spark.sql.execution.s" +
      "treaming.state.StateCallCommandH\000\022X\n\014get" +
      "ListState\030\003 \001(\0132@.org.apache.spark.sql.e" +
      "xecution.streaming.state.StateCallComman" +
      "dH\000\022W\n\013getMapState\030\004 \001(\0132@.org.apache.sp" +
      "ark.sql.execution.streaming.state.StateC" +
      "allCommandH\000B\010\n\006method\"z\n\024StateVariableR" +
      "equest\022X\n\016valueStateCall\030\001 \001(\0132>.org.apa" +
      "che.spark.sql.execution.streaming.state." +
      "ValueStateCallH\000B\010\n\006method\"\340\001\n\032ImplicitG" +
      "roupingKeyRequest\022X\n\016setImplicitKey\030\001 \001(" +
      "\0132>.org.apache.spark.sql.execution.strea" +
      "ming.state.SetImplicitKeyH\000\022^\n\021removeImp" +
      "licitKey\030\002 \001(\0132A.org.apache.spark.sql.ex" +
      "ecution.streaming.state.RemoveImplicitKe" +
      "yH\000B\010\n\006method\"}\n\020StateCallCommand\022\021\n\tsta" +
      "teName\030\001 \001(\t\022\016\n\006schema\030\002 \001(\t\022F\n\003ttl\030\003 \001(" +
      "\01329.org.apache.spark.sql.execution.strea" +
      "ming.state.TTLConfig\"\341\002\n\016ValueStateCall\022" +
      "\021\n\tstateName\030\001 \001(\t\022H\n\006exists\030\002 \001(\01326.org" +
      ".apache.spark.sql.execution.streaming.st" +
      "ate.ExistsH\000\022B\n\003get\030\003 \001(\01323.org.apache.s" +
      "park.sql.execution.streaming.state.GetH\000" +
      "\022\\\n\020valueStateUpdate\030\004 \001(\0132@.org.apache." +
      "spark.sql.execution.streaming.state.Valu" +
      "eStateUpdateH\000\022F\n\005clear\030\005 \001(\01325.org.apac" +
      "he.spark.sql.execution.streaming.state.C" +
      "learH\000B\010\n\006method\"\035\n\016SetImplicitKey\022\013\n\003ke" +
      "y\030\001 \001(\014\"\023\n\021RemoveImplicitKey\"\010\n\006Exists\"\005" +
      "\n\003Get\"!\n\020ValueStateUpdate\022\r\n\005value\030\001 \001(\014" +
      "\"\007\n\005Clear\"\\\n\016SetHandleState\022J\n\005state\030\001 \001" +
      "(\0162;.org.apache.spark.sql.execution.stre" +
      "aming.state.HandleState\"\037\n\tTTLConfig\022\022\n\n" +
      "durationMs\030\001 \001(\005*K\n\013HandleState\022\013\n\007CREAT" +
      "ED\020\000\022\017\n\013INITIALIZED\020\001\022\022\n\016DATA_PROCESSED\020" +
      "\002\022\n\n\006CLOSED\020\003b\006proto3"
    };
    descriptor = com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
        });
    internal_static_org_apache_spark_sql_execution_streaming_state_StateRequest_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_org_apache_spark_sql_execution_streaming_state_StateRequest_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_StateRequest_descriptor,
        new java.lang.String[] { "Version", "StatefulProcessorCall", "StateVariableRequest", "ImplicitGroupingKeyRequest", "Method", });
    internal_static_org_apache_spark_sql_execution_streaming_state_StateResponse_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_org_apache_spark_sql_execution_streaming_state_StateResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_StateResponse_descriptor,
        new java.lang.String[] { "StatusCode", "ErrorMessage", "Value", });
    internal_static_org_apache_spark_sql_execution_streaming_state_StatefulProcessorCall_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_org_apache_spark_sql_execution_streaming_state_StatefulProcessorCall_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_StatefulProcessorCall_descriptor,
        new java.lang.String[] { "SetHandleState", "GetValueState", "GetListState", "GetMapState", "Method", });
    internal_static_org_apache_spark_sql_execution_streaming_state_StateVariableRequest_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_org_apache_spark_sql_execution_streaming_state_StateVariableRequest_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_StateVariableRequest_descriptor,
        new java.lang.String[] { "ValueStateCall", "Method", });
    internal_static_org_apache_spark_sql_execution_streaming_state_ImplicitGroupingKeyRequest_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_org_apache_spark_sql_execution_streaming_state_ImplicitGroupingKeyRequest_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_ImplicitGroupingKeyRequest_descriptor,
        new java.lang.String[] { "SetImplicitKey", "RemoveImplicitKey", "Method", });
    internal_static_org_apache_spark_sql_execution_streaming_state_StateCallCommand_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_org_apache_spark_sql_execution_streaming_state_StateCallCommand_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_StateCallCommand_descriptor,
        new java.lang.String[] { "StateName", "Schema", "Ttl", });
    internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateCall_descriptor =
      getDescriptor().getMessageTypes().get(6);
    internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateCall_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateCall_descriptor,
        new java.lang.String[] { "StateName", "Exists", "Get", "ValueStateUpdate", "Clear", "Method", });
    internal_static_org_apache_spark_sql_execution_streaming_state_SetImplicitKey_descriptor =
      getDescriptor().getMessageTypes().get(7);
    internal_static_org_apache_spark_sql_execution_streaming_state_SetImplicitKey_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_SetImplicitKey_descriptor,
        new java.lang.String[] { "Key", });
    internal_static_org_apache_spark_sql_execution_streaming_state_RemoveImplicitKey_descriptor =
      getDescriptor().getMessageTypes().get(8);
    internal_static_org_apache_spark_sql_execution_streaming_state_RemoveImplicitKey_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_RemoveImplicitKey_descriptor,
        new java.lang.String[] { });
    internal_static_org_apache_spark_sql_execution_streaming_state_Exists_descriptor =
      getDescriptor().getMessageTypes().get(9);
    internal_static_org_apache_spark_sql_execution_streaming_state_Exists_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_Exists_descriptor,
        new java.lang.String[] { });
    internal_static_org_apache_spark_sql_execution_streaming_state_Get_descriptor =
      getDescriptor().getMessageTypes().get(10);
    internal_static_org_apache_spark_sql_execution_streaming_state_Get_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_Get_descriptor,
        new java.lang.String[] { });
    internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateUpdate_descriptor =
      getDescriptor().getMessageTypes().get(11);
    internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateUpdate_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_ValueStateUpdate_descriptor,
        new java.lang.String[] { "Value", });
    internal_static_org_apache_spark_sql_execution_streaming_state_Clear_descriptor =
      getDescriptor().getMessageTypes().get(12);
    internal_static_org_apache_spark_sql_execution_streaming_state_Clear_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_Clear_descriptor,
        new java.lang.String[] { });
    internal_static_org_apache_spark_sql_execution_streaming_state_SetHandleState_descriptor =
      getDescriptor().getMessageTypes().get(13);
    internal_static_org_apache_spark_sql_execution_streaming_state_SetHandleState_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_SetHandleState_descriptor,
        new java.lang.String[] { "State", });
    internal_static_org_apache_spark_sql_execution_streaming_state_TTLConfig_descriptor =
      getDescriptor().getMessageTypes().get(14);
    internal_static_org_apache_spark_sql_execution_streaming_state_TTLConfig_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_spark_sql_execution_streaming_state_TTLConfig_descriptor,
        new java.lang.String[] { "DurationMs", });
  }

  // @@protoc_insertion_point(outer_class_scope)
}
