---
layout: global
title: SQL Reference
redirect_from: /sql-reference
displayTitle: SQL Reference
license: |
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
---

Spark SQL is Apache Spark's module for working with structured data. This guide is a reference for Structured Query Language (SQL) and includes syntax, semantics, keywords, and examples for common SQL usage. It contains information for the following topics:

 * [ANSI Compliance](sql-ref-ansi-compliance.html)
 * [Data Types](sql-ref-datatypes.html)
 * [Datetime Pattern](sql-ref-datetime-pattern.html)
 * [Number Pattern](sql-ref-number-pattern.html)
 * [Functions](sql-ref-functions.html)
   * [Built-in Functions](sql-ref-functions-builtin.html)
   * [Scalar User-Defined Functions (UDFs)](sql-ref-functions-udf-scalar.html)
   * [User-Defined Aggregate Functions (UDAFs)](sql-ref-functions-udf-aggregate.html)
   * [Integration with Hive UDFs/UDAFs/UDTFs](sql-ref-functions-udf-hive.html)
   * [Function Invocation](sql-ref-function-invocation.html)
 * [Identifiers](sql-ref-identifier.html)
 * [IDENTIFIER clause](sql-ref-identifier-clause.html)
 * [Literals](sql-ref-literals.html)
 * [Null Semantics](sql-ref-null-semantics.html)
 * [SQL Syntax](sql-ref-syntax.html)
   * [DDL Statements](sql-ref-syntax.html#ddl-statements)
   * [DML Statements](sql-ref-syntax.html#dml-statements)
   * [Data Retrieval Statements](sql-ref-syntax.html#data-retrieval-statements)
   * [Auxiliary Statements](sql-ref-syntax.html#auxiliary-statements)
