/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.tree.model.RandomForestModel$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RandomForestRegressionExample$ {
    public static final RandomForestRegressionExample$ MODULE$ = new RandomForestRegressionExample$();

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("RandomForestRegressionExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD[] splits = data.randomSplit(new double[]{0.7, 0.3}, data.randomSplit$default$2());
        Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)splits[1]);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RDD trainingData = (RDD)tuple2._1();
        RDD testData = (RDD)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)trainingData, (Object)testData);
        Tuple2 tuple23 = tuple22;
        RDD trainingData2 = (RDD)tuple23._1();
        RDD testData2 = (RDD)tuple23._2();
        int numClasses = 2;
        Map categoricalFeaturesInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        int numTrees = 3;
        String featureSubsetStrategy = "auto";
        String impurity = "variance";
        int maxDepth = 4;
        int maxBins = 32;
        RandomForestModel model = RandomForest$.MODULE$.trainRegressor(trainingData2, categoricalFeaturesInfo, numTrees, featureSubsetStrategy, impurity, maxDepth, maxBins, RandomForest$.MODULE$.trainRegressor$default$8());
        RDD labelsAndPredictions = testData2.map((Function1 & Serializable)point -> {
            double prediction = model.predict(point.features());
            return new Tuple2.mcDD.sp(point.label(), prediction);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        double testMSE = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(labelsAndPredictions.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RandomForestRegressionExample$.$anonfun$main$2(x0$1)), (ClassTag)ClassTag$.MODULE$.Double())).mean();
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("Test Mean Squared Error = ").append(testMSE).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(34).append("Learned regression forest model:\n ").append(model.toDebugString()).toString());
        model.save(sc, "target/tmp/myRandomForestRegressionModel");
        RandomForestModel sameModel = RandomForestModel$.MODULE$.load(sc, "target/tmp/myRandomForestRegressionModel");
        sc.stop();
    }

    public static final /* synthetic */ double $anonfun$main$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double v = tuple2._1$mcD$sp();
        double p = tuple2._2$mcD$sp();
        double d = package$.MODULE$.pow(v - p, 2.0);
        return d;
    }

    private RandomForestRegressionExample$() {
    }
}

