/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.paths.SparkPath$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FileSourceConstantMetadataAttribute$;
import org.apache.spark.sql.catalyst.expressions.InterpretedPredicate;
import org.apache.spark.sql.catalyst.expressions.Predicate$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.FileIndexOptions$;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionDirectory$;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitionSpec$;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.datasources.PathFilterFactory$;
import org.apache.spark.sql.execution.datasources.PathFilterStrategy;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dh!\u0002\u0010 \u0003\u0003a\u0003\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\t\u0003!\u0011!Q\u0001\n\rC\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t7\u0002\u0011\t\u0011)A\u00059\")q\f\u0001C\u0001A\")a\r\u0001D\u0001O\")1\u000e\u0001C!Y\"9Q\u000e\u0001b\u0001\n#q\u0007BB<\u0001A\u0003%q\u000eC\u0003y\u0001\u0019E\u0011\u0010C\u0004\u0002\u0018\u00011\t\"!\u0007\t\u0013\u0005\r\u0002A1A\u0005\n\u0005\u0015\u0002\u0002CA\u001c\u0001\u0001\u0006I!a\n\t\u0013\u0005e\u0002A1A\u0005\n\u0005m\u0002\u0002CA+\u0001\u0001\u0006I!!\u0010\t\u000f\u0005]\u0003\u0001\"\u0005\u0002Z!Q\u0011Q\r\u0001\t\u0006\u0004%\t\"a\u001a\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l!9\u00111\u0012\u0001\u0005B\u00055\u0005bBAI\u0001\u0011\u0005\u00131\u0013\u0005\b\u00037\u0003A\u0011AAO\u0011\u0019\t\t\u000b\u0001C\tO\"9\u00111\u0015\u0001\u0005\n\u0005\u0015\u0006bBA[\u0001\u0011%\u0011q\u0017\u0005\b\u0003\u007f\u0003A\u0011BAa\u000f%\t9mHA\u0001\u0012\u0003\tIM\u0002\u0005\u001f?\u0005\u0005\t\u0012AAf\u0011\u0019y6\u0004\"\u0001\u0002N\"I\u0011qZ\u000e\u0012\u0002\u0013\u0005\u0011\u0011\u001b\u0002\u001b!\u0006\u0014H/\u001b;j_:LgnZ!xCJ,g)\u001b7f\u0013:$W\r\u001f\u0006\u0003A\u0005\n1\u0002Z1uCN|WO]2fg*\u0011!eI\u0001\nKb,7-\u001e;j_:T!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u00174oA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\u0004\"\u0001N\u001b\u000e\u0003}I!AN\u0010\u0003\u0013\u0019KG.Z%oI\u0016D\bC\u0001\u001d<\u001b\u0005I$B\u0001\u001e&\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001f:\u0005\u001daunZ4j]\u001e\fAb\u001d9be.\u001cVm]:j_:\u0004\"a\u0010!\u000e\u0003\rJ!!Q\u0012\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003E\u0017:seBA#J!\t1u&D\u0001H\u0015\tA5&\u0001\u0004=e>|GOP\u0005\u0003\u0015>\na\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\ri\u0015\r\u001d\u0006\u0003\u0015>\u0002\"\u0001R(\n\u0005Ak%AB*ue&tw-A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017\rE\u0002/'VK!\u0001V\u0018\u0003\r=\u0003H/[8o!\t1\u0016,D\u0001X\u0015\tA6%A\u0003usB,7/\u0003\u0002[/\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u001f\u0019LG.Z*uCR,8oQ1dQ\u0016\u0004\"\u0001N/\n\u0005y{\"a\u0004$jY\u0016\u001cF/\u0019;vg\u000e\u000b7\r[3\u0002\rqJg.\u001b;?)\u0015\t'm\u00193f!\t!\u0004\u0001C\u0003>\u000b\u0001\u0007a\bC\u0003C\u000b\u0001\u00071\tC\u0003R\u000b\u0001\u0007!\u000bC\u0004\\\u000bA\u0005\t\u0019\u0001/\u0002\u001bA\f'\u000f^5uS>t7\u000b]3d)\u0005A\u0007C\u0001\u001bj\u0013\tQwDA\u0007QCJ$\u0018\u000e^5p]N\u0003XmY\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nCV\tQ+\u0001\u0006iC\u0012|w\u000e]\"p]\u001a,\u0012a\u001c\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fAaY8oM*\u0011AoJ\u0001\u0007Q\u0006$wn\u001c9\n\u0005Y\f(!D\"p]\u001aLw-\u001e:bi&|g.A\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\u0013!\u00037fC\u001a4\u0015\u000e\\3t+\u0005Q\bcB>\u0002\u0002\u0005\u0015\u0011\u0011C\u0007\u0002y*\u0011QP`\u0001\b[V$\u0018M\u00197f\u0015\tyx&\u0001\u0006d_2dWm\u0019;j_:L1!a\u0001}\u00055a\u0015N\\6fI\"\u000b7\u000f['baB!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\fM\f!AZ:\n\t\u0005=\u0011\u0011\u0002\u0002\u0005!\u0006$\b\u000e\u0005\u0003\u0002\b\u0005M\u0011\u0002BA\u000b\u0003\u0013\u0011!BR5mKN#\u0018\r^;t\u0003YaW-\u00194ESJ$vn\u00115jY\u0012\u0014XM\u001c$jY\u0016\u001cXCAA\u000e!\u0019!5*!\u0002\u0002\u001eA)a&a\b\u0002\u0012%\u0019\u0011\u0011E\u0018\u0003\u000b\u0005\u0013(/Y=\u0002%\r\f7/Z%og\u0016t7/\u001b;jm\u0016l\u0015\r]\u000b\u0003\u0003O\u0001R!!\u000b\u000249k!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0005kRLGNC\u0002\u00022\r\n\u0001bY1uC2L8\u000f^\u0005\u0005\u0003k\tYC\u0001\nDCN,\u0017J\\:f]NLG/\u001b<f\u001b\u0006\u0004\u0018aE2bg\u0016Len]3og&$\u0018N^3NCB\u0004\u0013a\u00039bi\"4\u0015\u000e\u001c;feN,\"!!\u0010\u0011\r\u0005}\u0012\u0011JA(\u001d\u0011\t\t%!\u0012\u000f\u0007\u0019\u000b\u0019%C\u00011\u0013\r\t9eL\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY%!\u0014\u0003\u0007M+\u0017OC\u0002\u0002H=\u00022\u0001NA)\u0013\r\t\u0019f\b\u0002\u0013!\u0006$\bNR5mi\u0016\u00148\u000b\u001e:bi\u0016<\u00170\u0001\u0007qCRDg)\u001b7uKJ\u001c\b%\u0001\tnCR\u001c\u0007\u000eU1uQB\u000bG\u000f^3s]R!\u00111LA1!\rq\u0013QL\u0005\u0004\u0003?z#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003G\u0002\u0002\u0019AA\t\u0003\u00111\u0017\u000e\\3\u0002'I,7-\u001e:tSZ,g)\u001b7f\u0019>|7.\u001e9\u0016\u0005\u0005m\u0013!\u00037jgR4\u0015\u000e\\3t)\u0019\ti'!\u001e\u0002\bB1\u0011qHA%\u0003_\u00022\u0001NA9\u0013\r\t\u0019h\b\u0002\u0013!\u0006\u0014H/\u001b;j_:$\u0015N]3di>\u0014\u0018\u0010C\u0004\u0002xI\u0001\r!!\u001f\u0002!A\f'\u000f^5uS>tg)\u001b7uKJ\u001c\bCBA \u0003\u0013\nY\b\u0005\u0003\u0002~\u0005\rUBAA@\u0015\u0011\t\t)a\f\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003\u000b\u000byH\u0001\u0006FqB\u0014Xm]:j_:Dq!!#\u0013\u0001\u0004\tI(A\u0006eCR\fg)\u001b7uKJ\u001c\u0018AC5oaV$h)\u001b7fgV\u0011\u0011q\u0012\t\u0005]\u0005}a*A\u0006tSj,\u0017J\u001c\"zi\u0016\u001cXCAAK!\rq\u0013qS\u0005\u0004\u00033{#\u0001\u0002'p]\u001e\f\u0001\"\u00197m\r&dWm\u001d\u000b\u0003\u0003?\u0003b!a\u0010\u0002J\u0005E\u0011!E5oM\u0016\u0014\b+\u0019:uSRLwN\\5oO\u0006y\u0001O];oKB\u000b'\u000f^5uS>t7\u000f\u0006\u0004\u0002(\u0006=\u00161\u0017\t\u0007\u0003\u007f\tI%!+\u0011\u0007Q\nY+C\u0002\u0002.~\u0011Q\u0002U1si&$\u0018n\u001c8QCRD\u0007bBAY/\u0001\u0007\u0011\u0011P\u0001\u000baJ,G-[2bi\u0016\u001c\b\"\u00024\u0018\u0001\u0004A\u0017!\u00032bg\u0016\u0004\u0016\r\u001e5t+\t\tI\fE\u0003E\u0003w\u000b)!C\u0002\u0002>6\u00131aU3u\u0003)I7\u000fR1uCB\u000bG\u000f\u001b\u000b\u0005\u00037\n\u0019\rC\u0004\u0002Ff\u0001\r!!\u0002\u0002\tA\fG\u000f[\u0001\u001b!\u0006\u0014H/\u001b;j_:LgnZ!xCJ,g)\u001b7f\u0013:$W\r\u001f\t\u0003im\u0019\"aG\u0017\u0015\u0005\u0005%\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002T*\u001aA,!6,\u0005\u0005]\u0007\u0003BAm\u0003Gl!!a7\u000b\t\u0005u\u0017q\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!90\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\fYNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public abstract class PartitioningAwareFileIndex
implements FileIndex,
Logging {
    private boolean recursiveFileLookup;
    private final SparkSession sparkSession;
    private final Map<String, String> parameters;
    private final Option<StructType> userSpecifiedSchema;
    private final Configuration hadoopConf;
    private final CaseInsensitiveMap<String> caseInsensitiveMap;
    private final Seq<PathFilterStrategy> pathFilters;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static FileStatusCache $lessinit$greater$default$4() {
        return PartitioningAwareFileIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Option<Object> metadataOpsTimeNs() {
        return FileIndex.metadataOpsTimeNs$(this);
    }

    @Override
    public String toString() {
        return FileIndex.toString$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract PartitionSpec partitionSpec();

    @Override
    public StructType partitionSchema() {
        return this.partitionSpec().partitionColumns();
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public abstract LinkedHashMap<Path, FileStatus> leafFiles();

    public abstract Map<Path, FileStatus[]> leafDirToChildrenFiles();

    private CaseInsensitiveMap<String> caseInsensitiveMap() {
        return this.caseInsensitiveMap;
    }

    private Seq<PathFilterStrategy> pathFilters() {
        return this.pathFilters;
    }

    public boolean matchPathPattern(FileStatus file) {
        return this.pathFilters().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.accept(file)));
    }

    private boolean recursiveFileLookup$lzycompute() {
        PartitioningAwareFileIndex partitioningAwareFileIndex = this;
        synchronized (partitioningAwareFileIndex) {
            if (!this.bitmap$0) {
                this.recursiveFileLookup = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)this.caseInsensitiveMap().getOrElse((Object)FileIndexOptions$.MODULE$.RECURSIVE_FILE_LOOKUP(), (Function0 & Serializable)() -> "false")));
                this.bitmap$0 = true;
            }
        }
        return this.recursiveFileLookup;
    }

    public boolean recursiveFileLookup() {
        return !this.bitmap$0 ? this.recursiveFileLookup$lzycompute() : this.recursiveFileLookup;
    }

    @Override
    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        Seq seq;
        Option fileMetadataFilterOpt = ((IterableOnceOps)dataFilters.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$listFiles$1(f)))).reduceOption((Function2)And$.MODULE$);
        Buffer requiredMetadataColumnNames = (Buffer)Buffer$.MODULE$.empty();
        Option boundedFilterMetadataStructOpt = fileMetadataFilterOpt.map((Function1 & Serializable)fileMetadataFilter -> Predicate$.MODULE$.createInterpreted((Expression)fileMetadataFilter.transform((PartialFunction)new Serializable(null, requiredMetadataColumnNames){
            private static final long serialVersionUID = 0L;
            private final Buffer requiredMetadataColumnNames$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    int n;
                    AttributeReference attributeReference = (AttributeReference)A1;
                    int existingMetadataColumnIndex = this.requiredMetadataColumnNames$1.indexOf((Object)attributeReference.name());
                    if (existingMetadataColumnIndex >= 0) {
                        n = existingMetadataColumnIndex;
                    } else {
                        this.requiredMetadataColumnNames$1.$plus$eq((Object)attributeReference.name());
                        n = this.requiredMetadataColumnNames$1.length() - 1;
                    }
                    int metadataColumnIndex = n;
                    object = new BoundReference(metadataColumnIndex, attributeReference.dataType(), true);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof AttributeReference;
                return bl;
            }
            {
                this.requiredMetadataColumnNames$1 = requiredMetadataColumnNames$1;
            }
        })));
        if (this.partitionSpec().partitionColumns().isEmpty()) {
            PartitionDirectory partitionDirectory = PartitionDirectory$.MODULE$.apply(InternalRow$.MODULE$.empty(), (FileStatus[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.allFiles().toArray(ClassTag$.MODULE$.apply(FileStatus.class))), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$listFiles$5(this, boundedFilterMetadataStructOpt, requiredMetadataColumnNames, f))));
            seq = package$.MODULE$.Nil().$colon$colon((Object)partitionDirectory);
        } else {
            if (this.recursiveFileLookup()) {
                throw new IllegalArgumentException("Datasource with partition do not allow recursive file loading.");
            }
            seq = (Seq)this.prunePartitions(partitionFilters, this.partitionSpec()).map((Function1 & Serializable)x0$2 -> {
                Nil$ nil$;
                PartitionPath partitionPath = x0$2;
                if (partitionPath == null) throw new MatchError((Object)partitionPath);
                InternalRow values = partitionPath.values();
                Path path = partitionPath.path();
                Option option = this.leafDirToChildrenFiles().get((Object)path);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FileStatus[] existingDir = (FileStatus[])some.value();
                    nil$ = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])existingDir), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$listFiles$7(this, values, boundedFilterMetadataStructOpt, requiredMetadataColumnNames, f))));
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    nil$ = package$.MODULE$.Nil();
                }
                Nil$ files = nil$;
                return PartitionDirectory$.MODULE$.apply(values, (FileStatus[])files.toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
            });
        }
        Seq selectedPartitions = seq;
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Selected files after partition pruning:\n\t").append(selectedPartitions.mkString("\n\t")).toString());
        return selectedPartitions;
    }

    @Override
    public String[] inputFiles() {
        return (String[])((IterableOnceOps)this.allFiles().map((Function1 & Serializable)fs -> SparkPath$.MODULE$.fromFileStatus(fs).urlEncoded())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    @Override
    public long sizeInBytes() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.allFiles().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getLen()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public Seq<FileStatus> allFiles() {
        Seq files = this.partitionSpec().partitionColumns().isEmpty() && !this.recursiveFileLookup() ? (Seq)this.rootPaths().flatMap((Function1 & Serializable)path -> {
            FileSystem fs = path.getFileSystem(this.hadoopConf());
            Path qualifiedPathPre = fs.makeQualified(path);
            Path qualifiedPath = qualifiedPathPre.isRoot() && !qualifiedPathPre.isAbsolute() ? new Path(qualifiedPathPre, "/") : qualifiedPathPre;
            return Predef$.MODULE$.wrapRefArray((Object[])this.leafDirToChildrenFiles().get((Object)qualifiedPath).orElse((Function0 & Serializable)() -> this.leafFiles().get((Object)qualifiedPath).map((Function1 & Serializable)x$3 -> (FileStatus[])((Object[])new FileStatus[]{x$3}))).getOrElse((Function0 & Serializable)() -> (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class))));
        }) : this.leafFiles().values().toSeq();
        return (Seq)files.filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)this.matchPathPattern(file)));
    }

    public PartitionSpec inferPartitioning() {
        PartitionSpec partitionSpec;
        if (this.recursiveFileLookup()) {
            partitionSpec = PartitionSpec$.MODULE$.emptySpec();
        } else {
            Seq leafDirs = ((MapOps)this.leafDirToChildrenFiles().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$inferPartitioning$1(this, x0$1)))).keys().toSeq();
            CaseInsensitiveMap caseInsensitiveOptions = CaseInsensitiveMap$.MODULE$.apply(this.parameters);
            String timeZoneId = (String)caseInsensitiveOptions.get(FileIndexOptions$.MODULE$.TIME_ZONE()).getOrElse((Function0 & Serializable)() -> $this.sparkSession.sessionState().conf().sessionLocalTimeZone());
            partitionSpec = PartitioningUtils$.MODULE$.parsePartitions((Seq<Path>)leafDirs, this.sparkSession.sessionState().conf().partitionColumnTypeInferenceEnabled(), this.basePaths(), this.userSpecifiedSchema, this.sparkSession.sqlContext().conf().caseSensitiveAnalysis(), this.sparkSession.sqlContext().conf().validatePartitionColumns(), timeZoneId);
        }
        return partitionSpec;
    }

    private Seq<PartitionPath> prunePartitions(Seq<Expression> predicates, PartitionSpec partitionSpec) {
        Seq seq;
        PartitionSpec partitionSpec2 = partitionSpec;
        if (partitionSpec2 == null) {
            throw new MatchError((Object)partitionSpec2);
        }
        StructType partitionColumns = partitionSpec2.partitionColumns();
        Seq<PartitionPath> partitions = partitionSpec2.partitions();
        Tuple2 tuple2 = new Tuple2((Object)partitionColumns, partitions);
        Tuple2 tuple22 = tuple2;
        StructType partitionColumns2 = (StructType)tuple22._1();
        Seq partitions2 = (Seq)tuple22._2();
        scala.collection.immutable.Set partitionColumnNames = ((IterableOnceOps)partitionColumns2.map((Function1 & Serializable)x$5 -> x$5.name())).toSet();
        Seq partitionPruningPredicates = (Seq)predicates.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$prunePartitions$2(partitionColumnNames, x$6)));
        if (partitionPruningPredicates.nonEmpty()) {
            Expression predicate = (Expression)partitionPruningPredicates.reduce((Function2)And$.MODULE$);
            InterpretedPredicate boundPredicate = Predicate$.MODULE$.createInterpreted((Expression)predicate.transform((PartialFunction)new Serializable(null, partitionColumns2){
                private static final long serialVersionUID = 0L;
                private final StructType partitionColumns$1;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof AttributeReference) {
                        AttributeReference attributeReference = (AttributeReference)A1;
                        int index = this.partitionColumns$1.indexWhere((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$1.$anonfun$applyOrElse$1(attributeReference, x$8)));
                        object = new BoundReference(index, this.partitionColumns$1.apply(index).dataType(), true);
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    boolean bl = expression instanceof AttributeReference;
                    return bl;
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$1(AttributeReference x2$1, StructField x$8) {
                    String string = x2$1.name();
                    String string2 = x$8.name();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
                {
                    this.partitionColumns$1 = partitionColumns$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.AttributeReference org.apache.spark.sql.types.StructField )}, serializedLambda);
                }
            }));
            Seq selected = (Seq)partitions2.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$prunePartitions$4(boundPredicate, x0$1)));
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> {
                int total = partitions2.length();
                int selectedSize = selected.length();
                double percentPruned = (1.0 - (double)selectedSize / (double)total) * (double)100;
                return new StringBuilder(0).append(new StringBuilder(30).append("Selected ").append(selectedSize).append(" partitions out of ").append(total).append(", ").toString()).append(new StringBuilder(19).append("pruned ").append((Object)(total == 0 ? "0" : new StringBuilder(1).append(percentPruned).append("%").toString())).append(" partitions.").toString()).toString();
            });
            seq = selected;
        } else {
            seq = partitions2;
        }
        return seq;
    }

    private scala.collection.immutable.Set<Path> basePaths() {
        scala.collection.immutable.Set set;
        Option option = this.caseInsensitiveMap().get(FileIndexOptions$.MODULE$.BASE_PATH_PARAM()).map((Function1 & Serializable)x$9 -> new Path(x$9));
        if (option instanceof Some) {
            Some some = (Some)option;
            Path userDefinedBasePath = (Path)some.value();
            FileSystem fs = userDefinedBasePath.getFileSystem(this.hadoopConf());
            if (!fs.isDirectory(userDefinedBasePath)) {
                throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(10).append("Option '").append(FileIndexOptions$.MODULE$.BASE_PATH_PARAM()).append("' ").toString()).append("must be a directory").toString());
            }
            Path qualifiedBasePath = fs.makeQualified(userDefinedBasePath);
            String qualifiedBasePathStr = qualifiedBasePath.toString();
            this.rootPaths().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$basePaths$2(fs, qualifiedBasePathStr, x$10))).foreach((Function1 & Serializable)rp -> {
                throw new IllegalArgumentException(new StringBuilder(35).append("Wrong basePath ").append(userDefinedBasePath).append(" for the root path: ").append(rp).toString());
            });
            set = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{qualifiedBasePath}));
        } else if (None$.MODULE$.equals(option)) {
            set = ((IterableOnceOps)this.rootPaths().map((Function1 & Serializable)path -> {
                void var2_2;
                Path qualifiedPath = path.getFileSystem(this.hadoopConf()).makeQualified(path);
                return this.leafFiles().contains((Object)qualifiedPath) ? qualifiedPath.getParent() : var2_2;
            })).toSet();
        } else {
            throw new MatchError((Object)option);
        }
        return set;
    }

    private boolean isDataPath(Path path) {
        String name = path.getName();
        return (!name.startsWith("_") || name.contains("=")) && !name.startsWith(".");
    }

    private final boolean isNonEmptyFile$1(FileStatus f) {
        return this.isDataPath(f.getPath()) && f.getLen() > 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$listFiles$2(Attribute x0$1) {
        Attribute attribute = x0$1;
        if (!(attribute instanceof AttributeReference)) return false;
        AttributeReference attributeReference = (AttributeReference)attribute;
        Option option = FileSourceConstantMetadataAttribute$.MODULE$.unapply(attributeReference);
        if (option.isEmpty()) return false;
        AttributeReference metadataAttr = (AttributeReference)option.get();
        String string = metadataAttr.name();
        String string2 = FileFormat$.MODULE$.FILE_BLOCK_START();
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = metadataAttr.name();
        String string4 = FileFormat$.MODULE$.FILE_BLOCK_LENGTH();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$1(Expression f) {
        return f.references().nonEmpty() && f.references().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$listFiles$2(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$4(InternalRow partitionValues$1, Buffer requiredMetadataColumnNames$1, FileStatus f$1, InterpretedPredicate boundedFilter) {
        InternalRow row = FileFormat$.MODULE$.createMetadataInternalRow(partitionValues$1, (Seq<String>)requiredMetadataColumnNames$1.toSeq(), SparkPath$.MODULE$.fromFileStatus(f$1), f$1.getLen(), f$1.getModificationTime());
        return boundedFilter.eval(row);
    }

    private static final boolean matchFileMetadataPredicate$1(InternalRow partitionValues, FileStatus f, Option boundedFilterMetadataStructOpt$1, Buffer requiredMetadataColumnNames$1) {
        return boundedFilterMetadataStructOpt$1.forall((Function1 & Serializable)boundedFilter -> BoxesRunTime.boxToBoolean((boolean)PartitioningAwareFileIndex.$anonfun$listFiles$4(partitionValues, requiredMetadataColumnNames$1, f, boundedFilter)));
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$5(PartitioningAwareFileIndex $this, Option boundedFilterMetadataStructOpt$1, Buffer requiredMetadataColumnNames$1, FileStatus f) {
        return $this.isNonEmptyFile$1(f) && PartitioningAwareFileIndex.matchFileMetadataPredicate$1(InternalRow$.MODULE$.empty(), f, boundedFilterMetadataStructOpt$1, requiredMetadataColumnNames$1);
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$7(PartitioningAwareFileIndex $this, InternalRow values$1, Option boundedFilterMetadataStructOpt$1, Buffer requiredMetadataColumnNames$1, FileStatus f) {
        return $this.matchPathPattern(f) && $this.isNonEmptyFile$1(f) && PartitioningAwareFileIndex.matchFileMetadataPredicate$1(values$1, f, boundedFilterMetadataStructOpt$1, requiredMetadataColumnNames$1);
    }

    public static final /* synthetic */ boolean $anonfun$inferPartitioning$1(PartitioningAwareFileIndex $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileStatus[] files = (FileStatus[])tuple2._2();
        boolean bl = ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)$this.isDataPath(f.getPath())));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$prunePartitions$2(scala.collection.immutable.Set partitionColumnNames$1, Expression x$6) {
        return ((IterableOnceOps)x$6.references().map((Function1 & Serializable)x$7 -> x$7.name())).toSet().subsetOf((Set)partitionColumnNames$1);
    }

    public static final /* synthetic */ boolean $anonfun$prunePartitions$4(InterpretedPredicate boundPredicate$1, PartitionPath x0$1) {
        PartitionPath partitionPath = x0$1;
        if (partitionPath == null) {
            throw new MatchError((Object)partitionPath);
        }
        InternalRow values = partitionPath.values();
        boolean bl = boundPredicate$1.eval(values);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$basePaths$2(FileSystem fs$1, String qualifiedBasePathStr$1, Path x$10) {
        return !fs$1.makeQualified(x$10).toString().startsWith(qualifiedBasePathStr$1);
    }

    public PartitioningAwareFileIndex(SparkSession sparkSession, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache) {
        this.sparkSession = sparkSession;
        this.parameters = parameters;
        this.userSpecifiedSchema = userSpecifiedSchema;
        FileIndex.$init$(this);
        Logging.$init$((Logging)this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConfWithOptions(parameters);
        this.caseInsensitiveMap = CaseInsensitiveMap$.MODULE$.apply(parameters);
        this.pathFilters = PathFilterFactory$.MODULE$.create(this.caseInsensitiveMap());
    }
}

