/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.LocalTimestamp$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampNTZType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_() - Returns the current timestamp without time zone at the start of query evaluation. All calls of localtimestamp within the same query return the same value.\n\n    _FUNC_ - Returns the current local date-time at the session time zone at the start of query evaluation.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       2020-04-25 15:49:11.914\n  ", group="datetime_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001\u0002\u0010 \u00012B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t3\u0002\u0011\t\u0012)A\u0005\u001d\")!\f\u0001C\u00017\")!\f\u0001C\u0001=\")q\f\u0001C!A\")A\r\u0001C!A\")Q\r\u0001C!M\")Q\u000e\u0001C#]\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011%\ty\u0003AA\u0001\n\u0003\t\t\u0004C\u0005\u00026\u0001\t\n\u0011\"\u0001\u00028!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0013q\n\u0005\n\u0003?\u0002\u0011\u0011!C\u0001\u0003CB\u0011\"!\u001b\u0001\u0003\u0003%\t!a\u001b\t\u0013\u0005E\u0004!!A\u0005B\u0005M\u0004\"CAA\u0001\u0005\u0005I\u0011AAB\u0011%\t9\tAA\u0001\n\u0003\nI\tC\u0005\u0002\u000e\u0002\t\t\u0011\"\u0011\u0002\u0010\u001eI\u00111W\u0010\u0002\u0002#\u0005\u0011Q\u0017\u0004\t=}\t\t\u0011#\u0001\u00028\"1!L\u0006C\u0001\u0003\u001fD\u0011\"!5\u0017\u0003\u0003%)%a5\t\u0013\u0005Ug#!A\u0005\u0002\u0006]\u0007\"CAn-E\u0005I\u0011AA\u001c\u0011%\tiNFA\u0001\n\u0003\u000by\u000eC\u0005\u0002hZ\t\n\u0011\"\u0001\u00028!I\u0011\u0011\u001e\f\u0002\u0002\u0013%\u00111\u001e\u0002\u000f\u0019>\u001c\u0017\r\u001c+j[\u0016\u001cH/Y7q\u0015\t\u0001\u0013%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0012$\u0003!\u0019\u0017\r^1msN$(B\u0001\u0013&\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003M\u001d\nQa\u001d9be.T!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO\u000e\u00011C\u0002\u0001.cQR\u0004\t\u0005\u0002/_5\tq$\u0003\u00021?\tqA*Z1g\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00183\u0013\t\u0019tDA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011Q\u0007O\u0007\u0002m)\u0011qgH\u0001\bG>$WmZ3o\u0013\tIdGA\bD_\u0012,w-\u001a8GC2d'-Y2l!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u001d\u0001&o\u001c3vGR\u0004\"!Q%\u000f\u0005\t;eBA\"G\u001b\u0005!%BA#,\u0003\u0019a$o\\8u}%\tQ(\u0003\u0002Iy\u00059\u0001/Y2lC\u001e,\u0017B\u0001&L\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tAE(\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012A\u0014\t\u0004w=\u000b\u0016B\u0001)=\u0005\u0019y\u0005\u000f^5p]B\u0011!K\u0016\b\u0003'R\u0003\"a\u0011\u001f\n\u0005Uc\u0014A\u0002)sK\u0012,g-\u0003\u0002X1\n11\u000b\u001e:j]\u001eT!!\u0016\u001f\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005qk\u0006C\u0001\u0018\u0001\u0011\u001da5\u0001%AA\u00029#\u0012\u0001X\u0001\tM>dG-\u00192mKV\t\u0011\r\u0005\u0002<E&\u00111\r\u0010\u0002\b\u0005>|G.Z1o\u0003!qW\u000f\u001c7bE2,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u001d\u0004\"\u0001[6\u000e\u0003%T!A[\u0012\u0002\u000bQL\b/Z:\n\u00051L'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002)9|G-\u001a)biR,'O\\:J]R,'O\\1m)\u0005y\u0007cA!qe&\u0011\u0011o\u0013\u0002\u0004'\u0016\f\bcA:\u0002\n9\u0019A/a\u0001\u000f\u0005U|hB\u0001<\u007f\u001d\t9XP\u0004\u0002yy:\u0011\u0011p\u001f\b\u0003\u0007jL\u0011AK\u0005\u0003Q%J!AJ\u0014\n\u0005\u0011*\u0013B\u0001\u0012$\u0013\r\t\t!I\u0001\u0006iJ,Wm]\u0005\u0005\u0003\u000b\t9!A\u0006Ue\u0016,\u0007+\u0019;uKJt'bAA\u0001C%!\u00111BA\u0007\u0005-!&/Z3QCR$XM\u001d8\u000b\t\u0005\u0015\u0011qA\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0004c\u0005M\u0001\"\u0002'\n\u0001\u0004\t\u0016\u0001B3wC2$B!!\u0007\u0002 A\u00191(a\u0007\n\u0007\u0005uAHA\u0002B]fD\u0011\"!\t\u000b!\u0003\u0005\r!a\t\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005\u0015\u0012qE\u0007\u0002C%\u0019\u0011\u0011F\u0011\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u000baJ,G\u000f^=OC6,W#A)\u0002\t\r|\u0007/\u001f\u000b\u00049\u0006M\u0002b\u0002'\r!\u0003\u0005\rAT\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIDK\u0002O\u0003wY#!!\u0010\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000fb\u0014AC1o]>$\u0018\r^5p]&!\u00111JA!\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005E\u0003\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u0005Y\u0006twM\u0003\u0002\u0002\\\u0005!!.\u0019<b\u0013\r9\u0016QK\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003G\u00022aOA3\u0013\r\t9\u0007\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u00033\ti\u0007C\u0005\u0002pA\t\t\u00111\u0001\u0002d\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001e\u0011\r\u0005]\u0014QPA\r\u001b\t\tIHC\u0002\u0002|q\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty(!\u001f\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004C\u0006\u0015\u0005\"CA8%\u0005\u0005\t\u0019AA\r\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005E\u00131\u0012\u0005\n\u0003_\u001a\u0012\u0011!a\u0001\u0003G\na!Z9vC2\u001cHcA1\u0002\u0012\"I\u0011q\u000e\u000b\u0002\u0002\u0003\u0007\u0011\u0011\u0004\u0015\u0014\u0001\u0005U\u00151TAO\u0003C\u000b\u0019+a*\u0002*\u00065\u0016q\u0016\t\u0004]\u0005]\u0015bAAM?\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAP\u0003\tU\"\u0002\t\u0011!A}3UKT\"`Q%\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043-\u001e:sK:$\b\u0005^5nKN$\u0018-\u001c9!o&$\bn\\;uAQLW.\u001a\u0011{_:,\u0007%\u0019;!i\",\u0007e\u001d;beR\u0004sN\u001a\u0011rk\u0016\u0014\u0018\u0010I3wC2,\u0018\r^5p]:\u0002\u0013\t\u001c7!G\u0006dGn\u001d\u0011pM\u0002bwnY1mi&lWm\u001d;b[B\u0004s/\u001b;iS:\u0004C\u000f[3!g\u0006lW\rI9vKJL\bE]3ukJt\u0007\u0005\u001e5fAM\fW.\u001a\u0011wC2,XM\f\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006%\f\u0011SKR,(O\\:!i\",\u0007eY;se\u0016tG\u000f\t7pG\u0006d\u0007\u0005Z1uK6\"\u0018.\\3!CR\u0004C\u000f[3!g\u0016\u001c8/[8oAQLW.\u001a\u0011{_:,\u0007%\u0019;!i\",\u0007e\u001d;beR\u0004sN\u001a\u0011rk\u0016\u0014\u0018\u0010I3wC2,\u0018\r^5p]:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QU\u0001J\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1eAj\u0003\u0007N\u00173k\u0001\nTG\u000f\u001b:uE\nd&O\u00195\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAV\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!!-\u0002\u000bMrCG\f\u0019\u0002\u001d1{7-\u00197US6,7\u000f^1naB\u0011aFF\n\u0006-\u0005e\u0016Q\u0019\t\u0007\u0003w\u000b\tM\u0014/\u000e\u0005\u0005u&bAA`y\u00059!/\u001e8uS6,\u0017\u0002BAb\u0003{\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\t9-!4\u000e\u0005\u0005%'\u0002BAf\u00033\n!![8\n\u0007)\u000bI\r\u0006\u0002\u00026\u0006AAo\\*ue&tw\r\u0006\u0002\u0002R\u0005)\u0011\r\u001d9msR\u0019A,!7\t\u000f1K\u0002\u0013!a\u0001\u001d\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0005\u00181\u001d\t\u0004w=s\u0005\u0002CAs7\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003[\u0004B!a\u0015\u0002p&!\u0011\u0011_A+\u0005\u0019y%M[3di\u0002")
public class LocalTimestamp
extends LeafExpression
implements TimeZoneAwareExpression,
CodegenFallback,
Serializable {
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$1() {
        return LocalTimestamp$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<String>> unapply(LocalTimestamp x$0) {
        return LocalTimestamp$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$1() {
        return LocalTimestamp$.MODULE$.apply$default$1();
    }

    public static <A> Function1<Option<String>, A> andThen(Function1<LocalTimestamp, A> g) {
        return LocalTimestamp$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, LocalTimestamp> compose(Function1<A$, Option<String>> g) {
        return LocalTimestamp$.MODULE$.compose(g);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        LocalTimestamp localTimestamp = this;
        synchronized (localTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        LocalTimestamp localTimestamp = this;
        synchronized (localTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean foldable() {
        return true;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return TimestampNTZType$.MODULE$;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.CURRENT_LIKE()}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        return this.copy((Option<String>)Option$.MODULE$.apply((Object)timeZoneId));
    }

    @Override
    public Object eval(InternalRow input) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.now(this.zoneId())));
    }

    @Override
    public String prettyName() {
        return "localtimestamp";
    }

    public LocalTimestamp copy(Option<String> timeZoneId) {
        return new LocalTimestamp(timeZoneId);
    }

    public Option<String> copy$default$1() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "LocalTimestamp";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.timeZoneId();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LocalTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "timeZoneId";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LocalTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        LocalTimestamp localTimestamp = (LocalTimestamp)x$1;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = localTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!localTimestamp.canEqual(this)) return false;
        return true;
    }

    public LocalTimestamp(Option<String> timeZoneId) {
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        Statics.releaseFence();
    }

    public LocalTimestamp() {
        this((Option<String>)None$.MODULE$);
    }
}

