/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityGenerator;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StructsToCsv$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a CSV string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       1,2\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       26/08/2015\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0001\t5e\u0001\u0002\u0016,\u0001bB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\tG\u0002\u0011\t\u0012)A\u0005+\"AA\r\u0001BK\u0002\u0013\u0005Q\r\u0003\u0005j\u0001\tE\t\u0015!\u0003g\u0011!Q\u0007A!f\u0001\n\u0003Y\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u00027\t\u000bA\u0004A\u0011A9\t\u000bY\u0004A\u0011I<\t\u000bA\u0004A\u0011A>\t\u000bA\u0004A\u0011\u0001@\t\rA\u0004A\u0011AA\u0001\u0011)\t9\u0001\u0001EC\u0002\u0013\u0005\u0011\u0011\u0002\u0005\u000b\u0003G\u0001\u0001R1A\u0005\u0002\u0005\u0015\u0002BCA\u001b\u0001!\u0015\r\u0011\"\u0001\u00028!Q\u0011q\t\u0001\t\u0006\u0004%\t!!\u0013\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j!9\u0011\u0011\u000f\u0001\u0005B\u0005M\u0004bBA<\u0001\u0011\u0005\u0013\u0011\u0010\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\tI\n\u0001C!\u00037Cq!!(\u0001\t#\ny\nC\u0004\u0002&\u0002!\t&a*\t\u0013\u0005\r\u0007!!A\u0005\u0002\u0005\u0015\u0007\"CAg\u0001E\u0005I\u0011AAh\u0011%\t)\u000fAI\u0001\n\u0003\t9\u000fC\u0005\u0002l\u0002\t\n\u0011\"\u0001\u0002n\"I\u0011\u0011\u001f\u0001\u0002\u0002\u0013\u0005\u00131\u001f\u0005\n\u0003\u007f\u0004\u0011\u0011!C\u0001\u0005\u0003A\u0011B!\u0003\u0001\u0003\u0003%\tAa\u0003\t\u0013\tE\u0001!!A\u0005B\tM\u0001\"\u0003B\u0011\u0001\u0005\u0005I\u0011\u0001B\u0012\u0011%\u00119\u0003AA\u0001\n\u0003\u0012IcB\u0005\u0003N-\n\t\u0011#\u0001\u0003P\u0019A!fKA\u0001\u0012\u0003\u0011\t\u0006\u0003\u0004qE\u0011\u0005!q\f\u0005\n\u0005C\u0012\u0013\u0011!C#\u0005GB\u0011B!\u001a#\u0003\u0003%\tIa\u001a\t\u0013\t=$%%A\u0005\u0002\u00055\b\"\u0003B9E\u0005\u0005I\u0011\u0011B:\u0011%\u0011\tIII\u0001\n\u0003\ti\u000fC\u0005\u0003\u0004\n\n\t\u0011\"\u0003\u0003\u0006\na1\u000b\u001e:vGR\u001cHk\\\"tm*\u0011A&L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002/_\u0005A1-\u0019;bYf\u001cHO\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001aE\u0004\u0001su\u00025I\u0013)\u0011\u0005iZT\"A\u0016\n\u0005qZ#aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ir\u0014BA ,\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u0002;\u0003&\u0011!i\u000b\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001#H\u001d\tQT)\u0003\u0002GW\u00059\u0001/Y2lC\u001e,\u0017B\u0001%J\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!AR\u0016\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\u000fA\u0013x\u000eZ;diB\u00111*U\u0005\u0003%2\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fqa\u001c9uS>t7/F\u0001V!\u00111V\f\u00191\u000f\u0005][\u0006C\u0001-M\u001b\u0005I&B\u0001.8\u0003\u0019a$o\\8u}%\u0011A\fT\u0001\u0007!J,G-\u001a4\n\u0005y{&aA'ba*\u0011A\f\u0014\t\u0003-\u0006L!AY0\u0003\rM#(/\u001b8h\u0003!y\u0007\u000f^5p]N\u0004\u0013!B2iS2$W#\u00014\u0011\u0005i:\u0017B\u00015,\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u0015QLW.\u001a.p]\u0016LE-F\u0001m!\rYU\u000eY\u0005\u0003]2\u0013aa\u00149uS>t\u0017a\u0003;j[\u0016TvN\\3JI\u0002\na\u0001P5oSRtD\u0003\u0002:tiV\u0004\"A\u000f\u0001\t\u000bM;\u0001\u0019A+\t\u000b\u0011<\u0001\u0019\u00014\t\u000f)<\u0001\u0013!a\u0001Y\u0006Aa.\u001e7mC\ndW-F\u0001y!\tY\u00150\u0003\u0002{\u0019\n9!i\\8mK\u0006tGc\u0001:}{\")1+\u0003a\u0001+\")A-\u0003a\u0001MR\u0011!o \u0005\u0006I*\u0001\rA\u001a\u000b\u0006e\u0006\r\u0011Q\u0001\u0005\u0006I.\u0001\rA\u001a\u0005\u0006'.\u0001\rAZ\u0001\u0007oJLG/\u001a:\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0003S>T!!!\u0006\u0002\t)\fg/Y\u0005\u0005\u00033\tyAA\bDQ\u0006\u0014\u0018I\u001d:bs^\u0013\u0018\u000e^3sQ\ra\u0011Q\u0004\t\u0004\u0017\u0006}\u0011bAA\u0011\u0019\nIAO]1og&,g\u000e^\u0001\fS:\u0004X\u000f^*dQ\u0016l\u0017-\u0006\u0002\u0002(A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.=\nQ\u0001^=qKNLA!!\r\u0002,\tQ1\u000b\u001e:vGR$\u0016\u0010]3)\u00075\ti\"A\u0002hK:,\"!!\u000f\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010.\u0003\r\u00197O^\u0005\u0005\u0003\u0007\niD\u0001\nV]&4xnY5us\u001e+g.\u001a:bi>\u0014\bf\u0001\b\u0002\u001e\u0005I1m\u001c8wKJ$XM]\u000b\u0003\u0003\u0017\u0002raSA'\u0003#\n9&C\u0002\u0002P1\u0013\u0011BR;oGRLwN\\\u0019\u0011\u0007-\u000b\u0019&C\u0002\u0002V1\u00131!\u00118z!\u0011\tI&!\u0019\u000e\u0005\u0005m#\u0002BA\u0017\u0003;R1!a\u00182\u0003\u0019)hn]1gK&!\u00111MA.\u0005))FK\u0012\u001dTiJLgn\u001a\u0015\u0004\u001f\u0005u\u0011\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005-\u0004\u0003BA\u0015\u0003[JA!a\u001c\u0002,\tAA)\u0019;b)f\u0004X-\u0001\u0007xSRDG+[7f5>tW\rF\u0002>\u0003kBQA[\tA\u0002\u0001\fAB\\;mYN\u000bg-Z#wC2$B!!\u0015\u0002|!9\u0011Q\u0010\nA\u0002\u0005E\u0013!\u0002<bYV,\u0017AC5oaV$H+\u001f9fgV\u0011\u00111\u0011\t\u0007\u0003\u000b\u000bi)a%\u000f\t\u0005\u001d\u00151\u0012\b\u00041\u0006%\u0015\"A'\n\u0005\u0019c\u0015\u0002BAH\u0003#\u00131aU3r\u0015\t1E\n\u0005\u0003\u0002*\u0005U\u0015\u0002BAL\u0003W\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001a\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019!/!)\t\r\u0005\rV\u00031\u0001g\u0003!qWm^\"iS2$\u0017!\u00033p\u000f\u0016t7i\u001c3f)\u0019\tI+!.\u0002@B!\u00111VAY\u001b\t\tiKC\u0002\u00020.\nqaY8eK\u001e,g.\u0003\u0003\u00024\u00065&\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005]f\u00031\u0001\u0002:\u0006\u00191\r\u001e=\u0011\t\u0005-\u00161X\u0005\u0005\u0003{\u000biK\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005\u0005g\u00031\u0001\u0002*\u0006\u0011QM^\u0001\u0005G>\u0004\u0018\u0010F\u0004s\u0003\u000f\fI-a3\t\u000fM;\u0002\u0013!a\u0001+\"9Am\u0006I\u0001\u0002\u00041\u0007b\u00026\u0018!\u0003\u0005\r\u0001\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tNK\u0002V\u0003'\\#!!6\u0011\t\u0005]\u0017\u0011]\u0007\u0003\u00033TA!a7\u0002^\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?d\u0015AC1o]>$\u0018\r^5p]&!\u00111]Am\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIOK\u0002g\u0003'\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002p*\u001aA.a5\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0010\u0005\u0003\u0002x\u0006uXBAA}\u0015\u0011\tY0a\u0005\u0002\t1\fgnZ\u0005\u0004E\u0006e\u0018\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0002!\rY%QA\u0005\u0004\u0005\u000fa%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA)\u0005\u001bA\u0011Ba\u0004\u001e\u0003\u0003\u0005\rAa\u0001\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\u0002\u0005\u0004\u0003\u0018\tu\u0011\u0011K\u0007\u0003\u00053Q1Aa\u0007M\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005?\u0011IB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001=\u0003&!I!qB\u0010\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0007KF,\u0018\r\\:\u0015\u0007a\u0014Y\u0003C\u0005\u0003\u0010\u0001\n\t\u00111\u0001\u0002R!\u001a\u0002Aa\f\u00036\t]\"1\bB\u001f\u0005\u0003\u0012\u0019Ea\u0012\u0003JA\u0019!H!\r\n\u0007\tM2FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\te\u0012\u0001S0G+:\u001bu\fK3yaJ\\F\u0006I8qi&|gn]/*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011D'Z\u00033\u000f\u001e:j]\u001e\u0004s/\u001b;iA\u0005\u0004s-\u001b<f]\u0002\u001aHO];di\u00022\u0018\r\\;f\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B \u0003\u0005\u0005'\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b8b[\u0016$wl\u001d;sk\u000e$\bfJ1(Y\u0001\nD\u0006I\u0014cO1\u0002#'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEb#G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015oC6,GmX:ueV\u001cG\u000fK\u0014uS6,w\u0005\f\u0011u_~#\u0018.\\3ti\u0006l\u0007\u000fK\u00143aE*T\u0006\r\u001d.eY:C\u0006I\u0014zsfLX&T'.I\u0012<\u0013&\u000b\u0017![\u0006\u0004\bf\n;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;(Y\u0001:C\rZ\u0018N\u001b>J\u00180_=(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u001c0aaz#\u0007M\u00196\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B#\u0003\u0015\u0019d\u0006\r\u00181\u0003\u00159'o\\;qC\t\u0011Y%A\u0005dgZ|f-\u001e8dg\u0006a1\u000b\u001e:vGR\u001cHk\\\"tmB\u0011!HI\n\u0005E\tM\u0003\u000b\u0005\u0005\u0003V\tmSK\u001a7s\u001b\t\u00119FC\u0002\u0003Z1\u000bqA];oi&lW-\u0003\u0003\u0003^\t]#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011!qJ\u0001\ti>\u001cFO]5oOR\u0011\u0011Q_\u0001\u0006CB\u0004H.\u001f\u000b\be\n%$1\u000eB7\u0011\u0015\u0019V\u00051\u0001V\u0011\u0015!W\u00051\u0001g\u0011\u001dQW\u0005%AA\u00021\fq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)H! \u0011\t-k'q\u000f\t\u0007\u0017\neTK\u001a7\n\u0007\tmDJ\u0001\u0004UkBdWm\r\u0005\t\u0005\u007f:\u0013\u0011!a\u0001e\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u001d\u0005\u0003BA|\u0005\u0013KAAa#\u0002z\n1qJ\u00196fGR\u0004")
public class StructsToCsv
extends UnaryExpression
implements TimeZoneAwareExpression,
ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient CharArrayWriter writer;
    private transient StructType inputSchema;
    private transient UnivocityGenerator gen;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToCsv$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToCsv structsToCsv) {
        return StructsToCsv$.MODULE$.unapply(structsToCsv);
    }

    public static Option<String> apply$default$3() {
        return StructsToCsv$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToCsv> tupled() {
        return StructsToCsv$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToCsv>>> curried() {
        return StructsToCsv$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.writer$lzycompute();
        }
        return this.writer;
    }

    private StructType inputSchema$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                DataType dataType = this.child().dataType();
                if (!(dataType instanceof StructType)) {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Unsupported input type ").append(dataType.catalogString()).toString());
                }
                StructType structType = (StructType)dataType;
                this.inputSchema = structType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputSchema;
    }

    public StructType inputSchema() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.inputSchema$lzycompute();
        }
        return this.inputSchema;
    }

    private UnivocityGenerator gen$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.gen = new UnivocityGenerator(this.inputSchema(), this.writer(), new CSVOptions(this.options(), true, (String)this.timeZoneId().get()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.gen;
    }

    public UnivocityGenerator gen() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.gen$lzycompute();
        }
        return this.gen;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.converter = (Function1 & Serializable & scala.Serializable)row -> UTF8String.fromString((String)this.gen().writeToString((InternalRow)row));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.converter$lzycompute();
        }
        return this.converter;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StructType$ structType$ = StructType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)structType$);
    }

    @Override
    public String prettyName() {
        return "to_csv";
    }

    @Override
    public StructsToCsv withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Map<String, String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String structsToCsv = ctx.addReferenceObj("structsToCsv", this, ctx.addReferenceObj$default$3());
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)eval -> new StringBuilder(37).append(ev.value()).append(" = (UTF8String) ").append(structsToCsv).append(".converter().apply(").append((String)eval).append(");").toString());
    }

    public StructsToCsv copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToCsv(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToCsv";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.options();
            }
            case 1: {
                return this.child();
            }
            case 2: {
                return this.timeZoneId();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToCsv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToCsv)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToCsv structsToCsv = (StructsToCsv)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToCsv.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToCsv.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToCsv.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToCsv.canEqual(this)) return false;
        return true;
    }

    public StructsToCsv(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public StructsToCsv(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

