/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.SVMModel$;
import org.apache.spark.mllib.classification.impl.GLMClassificationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.pmml.PMMLExportable;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.util.Saveable;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\"\u0010\u0001\u0003\u0006\u0004%\tE\u0010\u0005\n\u001d\u0002\u0011\t\u0011)A\u0005\u007f=C\u0001\"\u0015\u0001\u0003\u0006\u0004%\tE\u0015\u0005\n3\u0002\u0011\t\u0011)A\u0005'jCQ\u0001\u0018\u0001\u0005\u0002uCqA\u001a\u0001A\u0002\u0013%q\rC\u0004l\u0001\u0001\u0007I\u0011\u00027\t\rI\u0004\u0001\u0015)\u0003i\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0015A\b\u0001\"\u0001h\u0011\u0015a\b\u0001\"\u0001~\u0011\u0019y\b\u0001\"\u0015\u0002\u0002!9\u0011Q\u0002\u0001\u0005B\u0005=\u0001bBA\u001d\u0001\u0011\u0005\u00131H\u0004\b\u0003\u007f)\u0002\u0012AA!\r\u0019!R\u0003#\u0001\u0002D!1A\f\u0005C\u0001\u0003#Bq!a\u0015\u0011\t\u0003\n)\u0006C\u0005\u0002^A\t\t\u0011\"\u0003\u0002`\tA1KV'N_\u0012,GN\u0003\u0002\u0017/\u0005q1\r\\1tg&4\u0017nY1uS>t'B\u0001\r\u001a\u0003\u0015iG\u000e\\5c\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0007\u0001\u0005:3&M\u001c\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011:\u0012A\u0003:fOJ,7o]5p]&\u0011ae\t\u0002\u0017\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014Xj\u001c3fYB\u0011\u0001&K\u0007\u0002+%\u0011!&\u0006\u0002\u0014\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003eUj\u0011a\r\u0006\u0003i]\tA!\u001e;jY&\u0011ag\r\u0002\t'\u00064X-\u00192mKB\u0011\u0001hO\u0007\u0002s)\u0011!hF\u0001\u0005a6lG.\u0003\u0002=s\tq\u0001+T'M\u000bb\u0004xN\u001d;bE2,\u0017aB<fS\u001eDGo]\u000b\u0002\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!iF\u0001\u0007Y&t\u0017\r\\4\n\u0005\u0011\u000b%A\u0002,fGR|'\u000fK\u0002\u0002\r2\u0003\"a\u0012&\u000e\u0003!S!!S\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002L\u0011\n)1+\u001b8dK\u0006\nQ*A\u00032]Ar\u0003'\u0001\u0005xK&<\u0007\u000e^:!\u0013\tiT\u0005K\u0002\u0003\r2\u000b\u0011\"\u001b8uKJ\u001cW\r\u001d;\u0016\u0003M\u0003\"\u0001\f+\n\u0005Uk#A\u0002#pk\ndW\rK\u0002\u0004\r^\u000b\u0013\u0001W\u0001\u0006a9Bd\u0006M\u0001\u000bS:$XM]2faR\u0004\u0013BA)&Q\r!aiV\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007y{\u0016\r\u0005\u0002)\u0001!)Q(\u0002a\u0001\u007f!\u001aqL\u0012'\t\u000bE+\u0001\u0019A*)\u0007\u00054u\u000bK\u0002\u0006\r\u0012\f\u0013!Z\u0001\u0006c9\nd\u0006M\u0001\ni\"\u0014Xm\u001d5pY\u0012,\u0012\u0001\u001b\t\u0004Y%\u001c\u0016B\u00016.\u0005\u0019y\u0005\u000f^5p]\u0006iA\u000f\u001b:fg\"|G\u000eZ0%KF$\"!\u001c9\u0011\u00051r\u0017BA8.\u0005\u0011)f.\u001b;\t\u000fE<\u0011\u0011!a\u0001Q\u0006\u0019\u0001\u0010J\u0019\u0002\u0015QD'/Z:i_2$\u0007%\u0001\u0007tKR$\u0006N]3tQ>dG\r\u0006\u0002vm6\t\u0001\u0001C\u0003g\u0013\u0001\u00071\u000bK\u0002\n\r2\u000bAbZ3u)\"\u0014Xm\u001d5pY\u0012D3A\u0003${C\u0005Y\u0018!B\u0019/g9\u0002\u0014AD2mK\u0006\u0014H\u000b\u001b:fg\"|G\u000e\u001a\u000b\u0002k\"\u001a1B\u0012'\u0002\u0019A\u0014X\rZ5diB{\u0017N\u001c;\u0015\u000fM\u000b\u0019!a\u0002\u0002\f!1\u0011Q\u0001\u0007A\u0002}\n!\u0002Z1uC6\u000bGO]5y\u0011\u0019\tI\u0001\u0004a\u0001\u007f\u0005aq/Z5hQRl\u0015\r\u001e:jq\")\u0011\u000b\u0004a\u0001'\u0006!1/\u0019<f)\u0015i\u0017\u0011CA\u000f\u0011\u001d\t\u0019\"\u0004a\u0001\u0003+\t!a]2\u0011\t\u0005]\u0011\u0011D\u0007\u00023%\u0019\u00111D\r\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000f\u0005}Q\u00021\u0001\u0002\"\u0005!\u0001/\u0019;i!\u0011\t\u0019#!\r\u000f\t\u0005\u0015\u0012Q\u0006\t\u0004\u0003OiSBAA\u0015\u0015\r\tYcH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=R&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\t)D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003_i\u0003fA\u0007Gu\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\"!\u001a\u0001AR,\u0002\u0011M3V*T8eK2\u0004\"\u0001\u000b\t\u0014\rA\t)%a\u0013,!\ra\u0013qI\u0005\u0004\u0003\u0013j#AB!osJ+g\r\u0005\u00033\u0003\u001br\u0016bAA(g\t1Aj\\1eKJ$\"!!\u0011\u0002\t1|\u0017\r\u001a\u000b\u0006=\u0006]\u0013\u0011\f\u0005\b\u0003'\u0011\u0002\u0019AA\u000b\u0011\u001d\tyB\u0005a\u0001\u0003CA3A\u0005${\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0005\u0004\u0003BA2\u0003[j!!!\u001a\u000b\t\u0005\u001d\u0014\u0011N\u0001\u0005Y\u0006twM\u0003\u0002\u0002l\u0005!!.\u0019<b\u0013\u0011\ty'!\u001a\u0003\r=\u0013'.Z2uQ\r\u0001bI\u001f\u0015\u0004\u001f\u0019S\b")
public class SVMModel
extends GeneralizedLinearModel
implements ClassificationModel,
Saveable,
PMMLExportable {
    private Option<Object> threshold;

    public static SVMModel load(SparkContext sparkContext, String string) {
        return SVMModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public void toPMML(String localPath) {
        PMMLExportable.toPMML$((PMMLExportable)this, localPath);
    }

    @Override
    public void toPMML(SparkContext sc, String path) {
        PMMLExportable.toPMML$(this, sc, path);
    }

    @Override
    public void toPMML(OutputStream outputStream) {
        PMMLExportable.toPMML$((PMMLExportable)this, outputStream);
    }

    @Override
    public String toPMML() {
        return PMMLExportable.toPMML$(this);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel.predict$(this, testData);
    }

    @Override
    public Vector weights() {
        return super.weights();
    }

    @Override
    public double intercept() {
        return super.intercept();
    }

    private Option<Object> threshold() {
        return this.threshold;
    }

    private void threshold_$eq(Option<Object> x$1) {
        this.threshold = x$1;
    }

    public SVMModel setThreshold(double threshold) {
        this.threshold_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)threshold)));
        return this;
    }

    public Option<Object> getThreshold() {
        return this.threshold();
    }

    public SVMModel clearThreshold() {
        this.threshold_$eq((Option<Object>)None$.MODULE$);
        return this;
    }

    @Override
    public double predictPoint(Vector dataMatrix, Vector weightMatrix, double intercept) {
        double margin = BLAS$.MODULE$.dot(weightMatrix, dataMatrix) + intercept;
        Option<Object> option = this.threshold();
        if (option instanceof Some) {
            Some some = (Some)option;
            double t = BoxesRunTime.unboxToDouble((Object)some.value());
            if (margin > t) {
                return 1.0;
            }
            return 0.0;
        }
        if (None$.MODULE$.equals(option)) {
            return margin;
        }
        throw new MatchError(option);
    }

    @Override
    public void save(SparkContext sc, String path) {
        GLMClassificationModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getClass().getName(), this.weights().size(), 2, this.weights(), this.intercept(), this.threshold());
    }

    @Override
    public String toString() {
        return new StringBuilder(30).append(super.toString()).append(", numClasses = 2, threshold = ").append(this.threshold().getOrElse((Function0 & Serializable & scala.Serializable)() -> "None")).toString();
    }

    public SVMModel(Vector weights, double intercept) {
        super(weights, intercept);
        ClassificationModel.$init$(this);
        PMMLExportable.$init$(this);
        this.threshold = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
    }
}

