/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.DenseKMeans;
import org.apache.spark.examples.mllib.DenseKMeans$;
import org.apache.spark.examples.mllib.DenseKMeans$InitializationMode$;
import org.apache.spark.examples.mllib.DenseKMeans$Params$;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class DenseKMeans$ {
    public static DenseKMeans$ MODULE$;

    static {
        new DenseKMeans$();
    }

    public void main(String[] args) {
        DenseKMeans.Params defaultParams = new DenseKMeans.Params(DenseKMeans$Params$.MODULE$.apply$default$1(), DenseKMeans$Params$.MODULE$.apply$default$2(), DenseKMeans$Params$.MODULE$.apply$default$3(), DenseKMeans$Params$.MODULE$.apply$default$4());
        OptionParser<DenseKMeans.Params> parser = new OptionParser<DenseKMeans.Params>(defaultParams){

            public static final /* synthetic */ DenseKMeans.Params $anonfun$new$1(int x, DenseKMeans.Params c) {
                int x$1 = x;
                String x$2 = c.copy$default$1();
                int x$3 = c.copy$default$3();
                Enumeration.Value x$4 = c.copy$default$4();
                return c.copy(x$2, x$1, x$3, x$4);
            }

            public static final /* synthetic */ DenseKMeans.Params $anonfun$new$2(int x, DenseKMeans.Params c) {
                int x$5 = x;
                String x$6 = c.copy$default$1();
                int x$7 = c.copy$default$2();
                Enumeration.Value x$8 = c.copy$default$4();
                return c.copy(x$6, x$7, x$5, x$8);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DenseKMeans: an example k-means app for dense data."}));
                this.opt('k', "k", Read$.MODULE$.intRead()).required().text("number of clusters, required").action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("numIterations", Read$.MODULE$.intRead()).text(new StringBuilder(31).append("number of iterations, default: ").append(defaultParams$1.numIterations()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("initMode", Read$.MODULE$.stringRead()).text(new StringBuilder(33).append("initialization mode (").append(DenseKMeans$InitializationMode$.MODULE$.values().mkString(",")).append("), ").append("default: ").append(defaultParams$1.initializationMode()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    Enumeration.Value x$9 = DenseKMeans$InitializationMode$.MODULE$.withName((String)x);
                    String x$10 = c.copy$default$1();
                    int x$11 = c.copy$default$2();
                    int x$12 = c.copy$default$3();
                    return c.copy(x$10, x$11, x$12, x$9);
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input paths to examples").required().action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.mllib.DenseKMeans$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.mllib.DenseKMeans$Params ), $anonfun$new$3(java.lang.String org.apache.spark.examples.mllib.DenseKMeans$Params ), $anonfun$new$4(java.lang.String org.apache.spark.examples.mllib.DenseKMeans$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (!(option instanceof Some)) {
            throw package$.MODULE$.exit(1);
        }
        Some some = (Some)option;
        DenseKMeans.Params params = (DenseKMeans.Params)some.value();
        this.run(params);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void run(DenseKMeans.Params params) {
        String string;
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(17).append("DenseKMeans with ").append(params).toString());
        SparkContext sc = new SparkContext(conf);
        Configurator.setRootLevel((Level)Level.WARN);
        RDD examples = sc.textFile(params.input(), sc.textFile$default$2()).map((Function1 & Serializable & scala.Serializable)line -> Vectors$.MODULE$.dense((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(line)).split(' '))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)DenseKMeans$.$anonfun$run$2(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), ClassTag$.MODULE$.apply(Vector.class)).cache();
        long numExamples = examples.count();
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("numExamples = ").append(numExamples).append(".").toString());
        Enumeration.Value value = params.initializationMode();
        Enumeration.Value value2 = DenseKMeans$InitializationMode$.MODULE$.Random();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = KMeans$.MODULE$.RANDOM();
        } else {
            Enumeration.Value value4 = DenseKMeans$InitializationMode$.MODULE$.Parallel();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = KMeans$.MODULE$.K_MEANS_PARALLEL();
            } else {
                throw new MatchError((Object)value);
            }
        }
        String initMode = string;
        KMeansModel model = new KMeans().setInitializationMode(initMode).setK(params.k()).setMaxIterations(params.numIterations()).run(examples);
        double cost = model.computeCost(examples);
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("Total cost = ").append(cost).append(".").toString());
        sc.stop();
    }

    public static final /* synthetic */ double $anonfun$run$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
    }

    private DenseKMeans$() {
        MODULE$ = this;
    }
}

