/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Locale;
import org.apache.spark.examples.ml.DecisionTreeExample;
import org.apache.spark.examples.ml.DecisionTreeExample$;
import org.apache.spark.examples.ml.DecisionTreeExample$Params$;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.DecisionTreeClassifier;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.DecisionTreeRegressor;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scopt.OptionDef;
import scopt.OptionParser;
import scopt.Read$;

public final class DecisionTreeExample$ {
    public static DecisionTreeExample$ MODULE$;

    static {
        new DecisionTreeExample$();
    }

    public void main(String[] args) {
        DecisionTreeExample.Params defaultParams = new DecisionTreeExample.Params(DecisionTreeExample$Params$.MODULE$.apply$default$1(), DecisionTreeExample$Params$.MODULE$.apply$default$2(), DecisionTreeExample$Params$.MODULE$.apply$default$3(), DecisionTreeExample$Params$.MODULE$.apply$default$4(), DecisionTreeExample$Params$.MODULE$.apply$default$5(), DecisionTreeExample$Params$.MODULE$.apply$default$6(), DecisionTreeExample$Params$.MODULE$.apply$default$7(), DecisionTreeExample$Params$.MODULE$.apply$default$8(), DecisionTreeExample$Params$.MODULE$.apply$default$9(), DecisionTreeExample$Params$.MODULE$.apply$default$10(), DecisionTreeExample$Params$.MODULE$.apply$default$11(), DecisionTreeExample$Params$.MODULE$.apply$default$12());
        OptionParser<DecisionTreeExample.Params> parser = new OptionParser<DecisionTreeExample.Params>(defaultParams){

            public static final /* synthetic */ DecisionTreeExample.Params $anonfun$new$2(int x, DecisionTreeExample.Params c) {
                int x$13 = x;
                String x$14 = c.copy$default$1();
                String x$15 = c.copy$default$2();
                String x$16 = c.copy$default$3();
                String x$17 = c.copy$default$4();
                int x$18 = c.copy$default$6();
                int x$19 = c.copy$default$7();
                double x$20 = c.copy$default$8();
                double x$21 = c.copy$default$9();
                boolean x$22 = c.copy$default$10();
                Option<String> x$23 = c.copy$default$11();
                int x$24 = c.copy$default$12();
                return c.copy(x$14, x$15, x$16, x$17, x$13, x$18, x$19, x$20, x$21, x$22, x$23, x$24);
            }

            public static final /* synthetic */ DecisionTreeExample.Params $anonfun$new$3(int x, DecisionTreeExample.Params c) {
                int x$25 = x;
                String x$26 = c.copy$default$1();
                String x$27 = c.copy$default$2();
                String x$28 = c.copy$default$3();
                String x$29 = c.copy$default$4();
                int x$30 = c.copy$default$5();
                int x$31 = c.copy$default$7();
                double x$32 = c.copy$default$8();
                double x$33 = c.copy$default$9();
                boolean x$34 = c.copy$default$10();
                Option<String> x$35 = c.copy$default$11();
                int x$36 = c.copy$default$12();
                return c.copy(x$26, x$27, x$28, x$29, x$30, x$25, x$31, x$32, x$33, x$34, x$35, x$36);
            }

            public static final /* synthetic */ DecisionTreeExample.Params $anonfun$new$4(int x, DecisionTreeExample.Params c) {
                int x$37 = x;
                String x$38 = c.copy$default$1();
                String x$39 = c.copy$default$2();
                String x$40 = c.copy$default$3();
                String x$41 = c.copy$default$4();
                int x$42 = c.copy$default$5();
                int x$43 = c.copy$default$6();
                double x$44 = c.copy$default$8();
                double x$45 = c.copy$default$9();
                boolean x$46 = c.copy$default$10();
                Option<String> x$47 = c.copy$default$11();
                int x$48 = c.copy$default$12();
                return c.copy(x$38, x$39, x$40, x$41, x$42, x$43, x$37, x$44, x$45, x$46, x$47, x$48);
            }

            public static final /* synthetic */ DecisionTreeExample.Params $anonfun$new$5(double x, DecisionTreeExample.Params c) {
                double x$49 = x;
                String x$50 = c.copy$default$1();
                String x$51 = c.copy$default$2();
                String x$52 = c.copy$default$3();
                String x$53 = c.copy$default$4();
                int x$54 = c.copy$default$5();
                int x$55 = c.copy$default$6();
                int x$56 = c.copy$default$7();
                double x$57 = c.copy$default$9();
                boolean x$58 = c.copy$default$10();
                Option<String> x$59 = c.copy$default$11();
                int x$60 = c.copy$default$12();
                return c.copy(x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$49, x$57, x$58, x$59, x$60);
            }

            public static final /* synthetic */ DecisionTreeExample.Params $anonfun$new$6(double x, DecisionTreeExample.Params c) {
                double x$61 = x;
                String x$62 = c.copy$default$1();
                String x$63 = c.copy$default$2();
                String x$64 = c.copy$default$3();
                String x$65 = c.copy$default$4();
                int x$66 = c.copy$default$5();
                int x$67 = c.copy$default$6();
                int x$68 = c.copy$default$7();
                double x$69 = c.copy$default$8();
                boolean x$70 = c.copy$default$10();
                Option<String> x$71 = c.copy$default$11();
                int x$72 = c.copy$default$12();
                return c.copy(x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$61, x$70, x$71, x$72);
            }

            public static final /* synthetic */ DecisionTreeExample.Params $anonfun$new$7(boolean x, DecisionTreeExample.Params c) {
                boolean x$73 = x;
                String x$74 = c.copy$default$1();
                String x$75 = c.copy$default$2();
                String x$76 = c.copy$default$3();
                String x$77 = c.copy$default$4();
                int x$78 = c.copy$default$5();
                int x$79 = c.copy$default$6();
                int x$80 = c.copy$default$7();
                double x$81 = c.copy$default$8();
                double x$82 = c.copy$default$9();
                Option<String> x$83 = c.copy$default$11();
                int x$84 = c.copy$default$12();
                return c.copy(x$74, x$75, x$76, x$77, x$78, x$79, x$80, x$81, x$82, x$73, x$83, x$84);
            }

            public static final /* synthetic */ DecisionTreeExample.Params $anonfun$new$9(int x, DecisionTreeExample.Params c) {
                int x$97 = x;
                String x$98 = c.copy$default$1();
                String x$99 = c.copy$default$2();
                String x$100 = c.copy$default$3();
                String x$101 = c.copy$default$4();
                int x$102 = c.copy$default$5();
                int x$103 = c.copy$default$6();
                int x$104 = c.copy$default$7();
                double x$105 = c.copy$default$8();
                double x$106 = c.copy$default$9();
                boolean x$107 = c.copy$default$10();
                Option<String> x$108 = c.copy$default$11();
                return c.copy(x$98, x$99, x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$97);
            }
            {
                String string;
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTreeExample: an example decision tree app."}));
                this.opt("algo", Read$.MODULE$.stringRead()).text(new StringBuilder(49).append("algorithm (classification, regression), default: ").append(defaultParams$1.algo()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$1 = x;
                    String x$2 = c.copy$default$1();
                    String x$3 = c.copy$default$2();
                    String x$4 = c.copy$default$3();
                    int x$5 = c.copy$default$5();
                    int x$6 = c.copy$default$6();
                    int x$7 = c.copy$default$7();
                    double x$8 = c.copy$default$8();
                    double x$9 = c.copy$default$9();
                    boolean x$10 = c.copy$default$10();
                    Option<String> x$11 = c.copy$default$11();
                    int x$12 = c.copy$default$12();
                    return c.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
                });
                this.opt("maxDepth", Read$.MODULE$.intRead()).text(new StringBuilder(32).append("max depth of the tree, default: ").append(defaultParams$1.maxDepth()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("maxBins", Read$.MODULE$.intRead()).text(new StringBuilder(29).append("max number of bins, default: ").append(defaultParams$1.maxBins()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("minInstancesPerNode", Read$.MODULE$.intRead()).text(new StringBuilder(85).append("min number of instances required at child nodes to create the parent split,").append(" default: ").append(defaultParams$1.minInstancesPerNode()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("minInfoGain", Read$.MODULE$.doubleRead()).text(new StringBuilder(51).append("min info gain required to create a split, default: ").append(defaultParams$1.minInfoGain()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$5(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("fracTest", Read$.MODULE$.doubleRead()).text(new StringBuilder(102).append("fraction of data to hold out for testing. If given option testInput, ").append("this option is ignored. default: ").append(defaultParams$1.fracTest()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$6(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("cacheNodeIds", Read$.MODULE$.booleanRead()).text(new StringBuilder(55).append("whether to use node Id cache during training, ").append("default: ").append(defaultParams$1.cacheNodeIds()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$7(BoxesRunTime.unboxToBoolean((Object)x), c));
                OptionDef optionDef = this.opt("checkpointDir", Read$.MODULE$.stringRead());
                StringBuilder stringBuilder = new StringBuilder(80).append("checkpoint directory where intermediate node Id caches will be stored, ").append("default: ");
                Option<String> option = defaultParams$1.checkpointDir();
                if (option instanceof Some) {
                    String strVal;
                    Some some = (Some)option;
                    string = strVal = (String)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    string = "None";
                } else {
                    throw new MatchError(option);
                }
                optionDef.text(stringBuilder.append((Object)string).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    Some x$85 = new Some(x);
                    String x$86 = c.copy$default$1();
                    String x$87 = c.copy$default$2();
                    String x$88 = c.copy$default$3();
                    String x$89 = c.copy$default$4();
                    int x$90 = c.copy$default$5();
                    int x$91 = c.copy$default$6();
                    int x$92 = c.copy$default$7();
                    double x$93 = c.copy$default$8();
                    double x$94 = c.copy$default$9();
                    boolean x$95 = c.copy$default$10();
                    int x$96 = c.copy$default$12();
                    return c.copy(x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, (Option<String>)x$85, x$96);
                });
                this.opt("checkpointInterval", Read$.MODULE$.intRead()).text(new StringBuilder(52).append("how often to checkpoint the node Id cache, ").append("default: ").append(defaultParams$1.checkpointInterval()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("testInput", Read$.MODULE$.stringRead()).text(new StringBuilder(75).append("input path to test dataset. If given, option fracTest is ignored.").append(" default: ").append(defaultParams$1.testInput()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$109 = x;
                    String x$110 = c.copy$default$1();
                    String x$111 = c.copy$default$3();
                    String x$112 = c.copy$default$4();
                    int x$113 = c.copy$default$5();
                    int x$114 = c.copy$default$6();
                    int x$115 = c.copy$default$7();
                    double x$116 = c.copy$default$8();
                    double x$117 = c.copy$default$9();
                    boolean x$118 = c.copy$default$10();
                    Option<String> x$119 = c.copy$default$11();
                    int x$120 = c.copy$default$12();
                    return c.copy(x$110, x$109, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120);
                });
                this.opt("dataFormat", Read$.MODULE$.stringRead()).text("data format: libsvm (default), dense (deprecated in Spark v1.1)").action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$121 = x;
                    String x$122 = c.copy$default$1();
                    String x$123 = c.copy$default$2();
                    String x$124 = c.copy$default$4();
                    int x$125 = c.copy$default$5();
                    int x$126 = c.copy$default$6();
                    int x$127 = c.copy$default$7();
                    double x$128 = c.copy$default$8();
                    double x$129 = c.copy$default$9();
                    boolean x$130 = c.copy$default$10();
                    Option<String> x$131 = c.copy$default$11();
                    int x$132 = c.copy$default$12();
                    return c.copy(x$122, x$123, x$121, x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$131, x$132);
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input path to labeled examples").required().action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12()));
                this.checkConfig((Function1 & Serializable & scala.Serializable)params -> params.fracTest() < 0.0 || params.fracTest() >= 1.0 ? this.failure(new StringBuilder(46).append("fracTest ").append(params.fracTest()).append(" value incorrect; should be in [0,1).").toString()) : this.success());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String org.apache.spark.examples.ml.DecisionTreeExample$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.ml.DecisionTreeExample$Params ), $anonfun$new$3$adapted(java.lang.Object org.apache.spark.examples.ml.DecisionTreeExample$Params ), $anonfun$new$4$adapted(java.lang.Object org.apache.spark.examples.ml.DecisionTreeExample$Params ), $anonfun$new$5$adapted(java.lang.Object org.apache.spark.examples.ml.DecisionTreeExample$Params ), $anonfun$new$6$adapted(java.lang.Object org.apache.spark.examples.ml.DecisionTreeExample$Params ), $anonfun$new$7$adapted(java.lang.Object org.apache.spark.examples.ml.DecisionTreeExample$Params ), $anonfun$new$8(java.lang.String org.apache.spark.examples.ml.DecisionTreeExample$Params ), $anonfun$new$9$adapted(java.lang.Object org.apache.spark.examples.ml.DecisionTreeExample$Params ), $anonfun$new$10(java.lang.String org.apache.spark.examples.ml.DecisionTreeExample$Params ), $anonfun$new$11(java.lang.String org.apache.spark.examples.ml.DecisionTreeExample$Params ), $anonfun$new$12(java.lang.String org.apache.spark.examples.ml.DecisionTreeExample$Params ), $anonfun$new$13(org.apache.spark.examples.ml.DecisionTreeExample$$anon$1 org.apache.spark.examples.ml.DecisionTreeExample$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (!(option instanceof Some)) {
            throw scala.sys.package$.MODULE$.exit(1);
        }
        Some some = (Some)option;
        DecisionTreeExample.Params params = (DecisionTreeExample.Params)some.value();
        this.run(params);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Dataset<Row> loadData(SparkSession spark, String path, String format, Option<Object> expectedNumFeatures) {
        Dataset dataset;
        String string = format;
        if ("dense".equals(string)) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_spark_examples_ml_DecisionTreeExample$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.mllib.regression.LabeledPoint").asType().toTypeConstructor();
                }

                public Org_apache_spark_examples_ml_DecisionTreeExample$$typecreator6$1() {
                }
            }
            dataset = spark.implicits().rddToDatasetHolder(MLUtils$.MODULE$.loadLabeledPoints(spark.sparkContext(), path), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_ml_DecisionTreeExample$$typecreator6$1()))).toDF();
        } else if ("libsvm".equals(string)) {
            Dataset dataset2;
            Option<Object> option = expectedNumFeatures;
            if (option instanceof Some) {
                Some some = (Some)option;
                int numFeatures = BoxesRunTime.unboxToInt((Object)some.value());
                dataset2 = spark.read().option("numFeatures", Integer.toString(numFeatures)).format("libsvm").load(path);
            } else if (None$.MODULE$.equals(option)) {
                dataset2 = spark.read().format("libsvm").load(path);
            } else {
                throw new MatchError(option);
            }
            dataset = dataset2;
        } else {
            throw new IllegalArgumentException(new StringBuilder(17).append("Bad data format: ").append(format).toString());
        }
        return dataset;
    }

    public Option<Object> loadData$default$4() {
        return None$.MODULE$;
    }

    public Tuple2<Dataset<Row>, Dataset<Row>> loadDatasets(String input, String dataFormat, String testInput, String algo, double fracTest) {
        Dataset[] datasetArray;
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        Dataset<Row> origExamples = this.loadData(spark, input, dataFormat, this.loadData$default$4());
        String string = testInput;
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            int numFeatures = ((Vector)((Row)origExamples.first()).getAs(1)).size();
            Dataset<Row> origTestExamples = this.loadData(spark, testInput, dataFormat, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numFeatures)));
            datasetArray = (Dataset[])((Object[])new Dataset[]{origExamples, origTestExamples});
        } else {
            datasetArray = origExamples.randomSplit(new double[]{1.0 - fracTest, fracTest}, 12345L);
        }
        Dataset[] dataframes = datasetArray;
        Dataset training = dataframes[0].cache();
        Dataset test = dataframes[1].cache();
        long numTraining = training.count();
        long numTest = test.count();
        int numFeatures = ((Vector)((Row)training.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getAs(0)).size();
        Predef$.MODULE$.println((Object)"Loaded data:");
        Predef$.MODULE$.println((Object)new StringBuilder(28).append("  numTraining = ").append(numTraining).append(", numTest = ").append(numTest).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(16).append("  numFeatures = ").append(numFeatures).toString());
        return new Tuple2((Object)training, (Object)test);
    }

    public void run(DecisionTreeExample.Params params) {
        DecisionTreeClassifier decisionTreeClassifier;
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset test;
        String algo;
        SparkSession spark;
        block22: {
            Tuple2<Dataset<Row>, Dataset<Row>> tuple2;
            block21: {
                spark = SparkSession$.MODULE$.builder().appName(new StringBuilder(25).append("DecisionTreeExample with ").append(params).toString()).getOrCreate();
                params.checkpointDir().foreach((Function1 & Serializable & scala.Serializable)directory -> {
                    DecisionTreeExample$.$anonfun$run$1(spark, directory);
                    return BoxedUnit.UNIT;
                });
                algo = params.algo().toLowerCase(Locale.ROOT);
                Predef$.MODULE$.println((Object)new StringBuilder(37).append("DecisionTreeExample with parameters:\n").append(params).toString());
                tuple2 = this.loadDatasets(params.input(), params.dataFormat(), params.testInput(), algo, params.fracTest());
                if (tuple2 == null) break block21;
                Dataset training = (Dataset)tuple2._1();
                test = (Dataset)tuple2._2();
                if (training == null) break block21;
                dataset = training;
                if (test != null) break block22;
            }
            throw new MatchError(tuple2);
        }
        Dataset dataset2 = test;
        Tuple2 tuple2 = new Tuple2((Object)dataset, (Object)dataset2);
        Tuple2 tuple22 = tuple2;
        Dataset training = (Dataset)tuple22._1();
        Dataset test2 = (Dataset)tuple22._2();
        ArrayBuffer stages = new ArrayBuffer();
        String string = algo;
        String string2 = "classification";
        String labelColName = !(string != null ? !string.equals(string2) : string2 != null) ? "indexedLabel" : "label";
        String string3 = algo;
        String string4 = "classification";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            StringIndexer labelIndexer = new StringIndexer().setInputCol("label").setOutputCol(labelColName);
            boxedUnit = stages.$plus$eq((Object)labelIndexer);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        VectorIndexer featuresIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(10);
        stages.$plus$eq((Object)featuresIndexer);
        String string5 = algo;
        if ("classification".equals(string5)) {
            decisionTreeClassifier = ((DecisionTreeClassifier)new DecisionTreeClassifier().setFeaturesCol("indexedFeatures").setLabelCol(labelColName)).setMaxDepth(params.maxDepth()).setMaxBins(params.maxBins()).setMinInstancesPerNode(params.minInstancesPerNode()).setMinInfoGain(params.minInfoGain()).setCacheNodeIds(params.cacheNodeIds()).setCheckpointInterval(params.checkpointInterval());
        } else if ("regression".equals(string5)) {
            decisionTreeClassifier = ((DecisionTreeRegressor)new DecisionTreeRegressor().setFeaturesCol("indexedFeatures").setLabelCol(labelColName)).setMaxDepth(params.maxDepth()).setMaxBins(params.maxBins()).setMinInstancesPerNode(params.minInstancesPerNode()).setMinInfoGain(params.minInfoGain()).setCacheNodeIds(params.cacheNodeIds()).setCheckpointInterval(params.checkpointInterval());
        } else {
            throw new IllegalArgumentException(new StringBuilder(20).append("Algo ").append(params.algo()).append(" not supported.").toString());
        }
        DecisionTreeClassifier dt = decisionTreeClassifier;
        stages.$plus$eq((Object)dt);
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])stages.toArray(ClassTag$.MODULE$.apply(PipelineStage.class)));
        long startTime = System.nanoTime();
        PipelineModel pipelineModel = pipeline.fit(training);
        double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Training time: ").append(elapsedTime).append(" seconds").toString());
        String string6 = algo;
        if ("classification".equals(string6)) {
            BoxedUnit boxedUnit2;
            DecisionTreeClassificationModel treeModel = (DecisionTreeClassificationModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pipelineModel.stages())).last();
            if (treeModel.numNodes() < 20) {
                Predef$.MODULE$.println((Object)treeModel.toDebugString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                Predef$.MODULE$.println((Object)treeModel);
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
        } else if ("regression".equals(string6)) {
            BoxedUnit boxedUnit4;
            DecisionTreeRegressionModel treeModel = (DecisionTreeRegressionModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pipelineModel.stages())).last();
            if (treeModel.numNodes() < 20) {
                Predef$.MODULE$.println((Object)treeModel.toDebugString());
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                Predef$.MODULE$.println((Object)treeModel);
                boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit4;
        } else {
            throw new IllegalArgumentException(new StringBuilder(20).append("Algo ").append(params.algo()).append(" not supported.").toString());
        }
        String string7 = algo;
        if ("classification".equals(string7)) {
            Predef$.MODULE$.println((Object)"Training data results:");
            this.evaluateClassificationModel((Transformer)pipelineModel, (Dataset<Row>)training, labelColName);
            Predef$.MODULE$.println((Object)"Test data results:");
            this.evaluateClassificationModel((Transformer)pipelineModel, (Dataset<Row>)test2, labelColName);
            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
        } else if ("regression".equals(string7)) {
            Predef$.MODULE$.println((Object)"Training data results:");
            this.evaluateRegressionModel((Transformer)pipelineModel, (Dataset<Row>)training, labelColName);
            Predef$.MODULE$.println((Object)"Test data results:");
            this.evaluateRegressionModel((Transformer)pipelineModel, (Dataset<Row>)test2, labelColName);
            BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(20).append("Algo ").append(params.algo()).append(" not supported.").toString());
        }
        spark.stop();
    }

    public void evaluateClassificationModel(Transformer model, Dataset<Row> data, String labelColName) {
        int n;
        Dataset fullPredictions = model.transform(data).cache();
        RDD predictions = fullPredictions.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.getDouble(0)), ClassTag$.MODULE$.Double());
        RDD labels = fullPredictions.select(labelColName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.getDouble(0)), ClassTag$.MODULE$.Double());
        Option option = MetadataUtils$.MODULE$.getNumClasses(fullPredictions.schema().apply(labelColName));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new RuntimeException("Unknown failure when indexing labels for classification.");
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        int n2 = n = BoxesRunTime.unboxToInt((Object)some.value());
        int numClasses = n2;
        double accuracy = new MulticlassMetrics(predictions.zip(labels, ClassTag$.MODULE$.Double())).accuracy();
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("  Accuracy (").append(numClasses).append(" classes): ").append(accuracy).toString());
    }

    public void evaluateRegressionModel(Transformer model, Dataset<Row> data, String labelColName) {
        Dataset fullPredictions = model.transform(data).cache();
        RDD predictions = fullPredictions.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4.getDouble(0)), ClassTag$.MODULE$.Double());
        RDD labels = fullPredictions.select(labelColName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5.getDouble(0)), ClassTag$.MODULE$.Double());
        double RMSE = new RegressionMetrics(predictions.zip(labels, ClassTag$.MODULE$.Double())).rootMeanSquaredError();
        Predef$.MODULE$.println((Object)new StringBuilder(34).append("  Root mean squared error (RMSE): ").append(RMSE).toString());
    }

    public static final /* synthetic */ void $anonfun$run$1(SparkSession spark$1, String directory) {
        spark$1.sparkContext().setCheckpointDir(directory);
    }

    private DecisionTreeExample$() {
        MODULE$ = this;
    }
}

