/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.PowerIterationClusteringExample;
import org.apache.spark.examples.mllib.PowerIterationClusteringExample$;
import org.apache.spark.examples.mllib.PowerIterationClusteringExample$Params$;
import org.apache.spark.mllib.clustering.PowerIterationClustering;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scopt.OptionParser;
import scopt.Read$;

public final class PowerIterationClusteringExample$ {
    public static PowerIterationClusteringExample$ MODULE$;

    static {
        new PowerIterationClusteringExample$();
    }

    public void main(String[] args) {
        PowerIterationClusteringExample.Params defaultParams = new PowerIterationClusteringExample.Params(PowerIterationClusteringExample$Params$.MODULE$.apply$default$1(), PowerIterationClusteringExample$Params$.MODULE$.apply$default$2(), PowerIterationClusteringExample$Params$.MODULE$.apply$default$3());
        OptionParser<PowerIterationClusteringExample.Params> parser = new OptionParser<PowerIterationClusteringExample.Params>(defaultParams){

            public static final /* synthetic */ PowerIterationClusteringExample.Params $anonfun$new$1(int x, PowerIterationClusteringExample.Params c) {
                return c.copy(x, c.copy$default$2(), c.copy$default$3());
            }

            public static final /* synthetic */ PowerIterationClusteringExample.Params $anonfun$new$2(int x, PowerIterationClusteringExample.Params c) {
                int x$1 = x;
                int x$2 = c.copy$default$1();
                int x$3 = c.copy$default$3();
                return c.copy(x$2, x$1, x$3);
            }

            public static final /* synthetic */ PowerIterationClusteringExample.Params $anonfun$new$3(int x, PowerIterationClusteringExample.Params c) {
                int x$4 = x;
                int x$5 = c.copy$default$1();
                int x$6 = c.copy$default$2();
                return c.copy(x$5, x$6, x$4);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PowerIterationClusteringExample: an example PIC app using concentric circles."}));
                this.opt('k', "k", Read$.MODULE$.intRead()).text(new StringBuilder(39).append("number of circles (clusters), default: ").append(defaultParams$1.k()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt('n', "n", Read$.MODULE$.intRead()).text(new StringBuilder(46).append("number of points in smallest circle, default: ").append(defaultParams$1.numPoints()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("maxIterations", Read$.MODULE$.intRead()).text(new StringBuilder(31).append("number of iterations, default: ").append(defaultParams$1.maxIterations()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)x), c));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.mllib.PowerIterationClusteringExample$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.mllib.PowerIterationClusteringExample$Params ), $anonfun$new$3$adapted(java.lang.Object org.apache.spark.examples.mllib.PowerIterationClusteringExample$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (!(option instanceof Some)) {
            throw scala.sys.package$.MODULE$.exit(1);
        }
        Some some = (Some)option;
        PowerIterationClusteringExample.Params params = (PowerIterationClusteringExample.Params)some.value();
        this.run(params);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void run(PowerIterationClusteringExample.Params params) {
        SparkConf conf = new SparkConf().setMaster("local").setAppName(new StringBuilder(30).append("PowerIterationClustering with ").append(params).toString());
        SparkContext sc = new SparkContext(conf);
        Configurator.setRootLevel((Level)Level.WARN);
        RDD<Tuple3<Object, Object, Object>> circlesRdd = this.generateCirclesRdd(sc, params.k(), params.numPoints());
        PowerIterationClusteringModel model = new PowerIterationClustering().setK(params.k()).setMaxIterations(params.maxIterations()).setInitializationMode("degree").run(circlesRdd);
        Map clusters = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.assignments().collect())).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.cluster())).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.id()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())));
        List assignments = (List)clusters.toList().sortBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)PowerIterationClusteringExample$.$anonfun$run$4(x0$1)), (Ordering)Ordering.Int$.MODULE$);
        String assignmentsStr = ((TraversableOnce)assignments.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int k = tuple2._1$mcI$sp();
            long[] v = (long[])tuple2._2();
            String string = new StringBuilder(4).append(k).append(" -> ").append(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(v)).sorted((Ordering)Ordering.Long$.MODULE$))).mkString("[", ",", "]")).toString();
            return string;
        }, List$.MODULE$.canBuildFrom())).mkString(", ");
        String sizesStr = ((TraversableOnce)((SeqLike)assignments.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)PowerIterationClusteringExample$.$anonfun$run$6(x$4)), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$)).mkString("(", ",", ")");
        Predef$.MODULE$.println((Object)new StringBuilder(37).append("Cluster assignments: ").append(assignmentsStr).append("\ncluster sizes: ").append(sizesStr).toString());
        sc.stop();
    }

    public Seq<Tuple2<Object, Object>> generateCircle(double radius, int n) {
        return (Seq)Seq$.MODULE$.tabulate(n, (Function1 & Serializable & scala.Serializable)i -> PowerIterationClusteringExample$.$anonfun$generateCircle$1(n, radius, BoxesRunTime.unboxToInt((Object)i)));
    }

    public RDD<Tuple3<Object, Object, Object>> generateCirclesRdd(SparkContext sc, int nCircles, int nPoints) {
        IndexedSeq points = (IndexedSeq)((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), nCircles).flatMap((Function1 & Serializable & scala.Serializable)i -> PowerIterationClusteringExample$.MODULE$.generateCircle(BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)i) * nPoints), IndexedSeq$.MODULE$.canBuildFrom())).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom());
        RDD rdd = sc.parallelize((Seq)points, sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD distancesRdd = rdd.cartesian(rdd, ClassTag$.MODULE$.apply(Tuple2.class)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int i1;
            Tuple2 tuple2;
            double y0;
            double x0;
            int i0;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    Tuple2 tuple24 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    Tuple2 tuple25 = (Tuple2)tuple23._1();
                    i0 = tuple23._2$mcI$sp();
                    if (tuple25 == null) break block2;
                    x0 = tuple25._1$mcD$sp();
                    y0 = tuple25._2$mcD$sp();
                    if (tuple24 == null) break block2;
                    tuple2 = (Tuple2)tuple24._1();
                    i1 = tuple24._2$mcI$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            double x1 = tuple2._1$mcD$sp();
            double y1 = tuple2._2$mcD$sp();
            Iterable iterable = i0 < i1 ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)i0), (Object)BoxesRunTime.boxToLong((long)i1), (Object)BoxesRunTime.boxToDouble((double)MODULE$.gaussianSimilarity((Tuple2<Object, Object>)new Tuple2.mcDD.sp(x0, y0), (Tuple2<Object, Object>)new Tuple2.mcDD.sp(x1, y1)))))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            return iterable;
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        return distancesRdd;
    }

    public double gaussianSimilarity(Tuple2<Object, Object> p1, Tuple2<Object, Object> p2) {
        double ssquares = (p1._1$mcD$sp() - p2._1$mcD$sp()) * (p1._1$mcD$sp() - p2._1$mcD$sp()) + (p1._2$mcD$sp() - p2._2$mcD$sp()) * (p1._2$mcD$sp() - p2._2$mcD$sp());
        return package$.MODULE$.exp(-ssquares / 2.0);
    }

    public static final /* synthetic */ int $anonfun$run$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long[] v = (long[])tuple2._2();
        int n = v.length;
        return n;
    }

    public static final /* synthetic */ int $anonfun$run$6(Tuple2 x$4) {
        return ((long[])x$4._2()).length;
    }

    public static final /* synthetic */ Tuple2 $anonfun$generateCircle$1(int n$1, double radius$1, int i) {
        double theta = Math.PI * 2 * (double)i / (double)n$1;
        return new Tuple2.mcDD.sp(radius$1 * package$.MODULE$.cos(theta), radius$1 * package$.MODULE$.sin(theta));
    }

    private PowerIterationClusteringExample$() {
        MODULE$ = this;
    }
}

