/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.linalg.squaredDistance$;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class SparkKMeans$ {
    public static SparkKMeans$ MODULE$;

    static {
        new SparkKMeans$();
    }

    public Vector<Object> parseVector(String line) {
        return DenseVector$.MODULE$.apply$mDc$sp((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(line)).split(' '))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)SparkKMeans$.$anonfun$parseVector$1(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    public int closestPoint(Vector<Object> p, Vector<Object>[] centers) {
        IntRef bestIndex = IntRef.create((int)0);
        DoubleRef closest = DoubleRef.create((double)Double.POSITIVE_INFINITY);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), centers.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                double tempDist = BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)p, (Object)centers[i], squaredDistance$.MODULE$.squaredDistanceFromZippedValues((UFunc.UImpl2)Vector$.MODULE$.zipValuesImpl_V_V_Double())));
                if (!(tempDist < closest$1.elem)) break block0;
                closest$1.elem = tempDist;
                bestIndex$1.elem = i;
            }
        });
        return bestIndex.elem;
    }

    public void showWarning() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of KMeans Clustering and is given as an example!\n        |Please use org.apache.spark.ml.clustering.KMeans\n        |for more conventional use.\n      ")).stripMargin());
    }

    public void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: SparkKMeans <file> <k> <convergeDist>");
            System.exit(1);
        }
        this.showWarning();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("SparkKMeans").getOrCreate();
        RDD lines = spark.read().textFile(args[0]).rdd();
        RDD data = lines.map((Function1 & Serializable & scala.Serializable)line -> MODULE$.parseVector((String)line), ClassTag$.MODULE$.apply(Vector.class)).cache();
        int K = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        double convergeDist = new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble();
        Vector[] kPoints = (Vector[])data.takeSample(false, K, 42L);
        DoubleRef tempDist = DoubleRef.create((double)1.0);
        while (tempDist.elem > convergeDist) {
            RDD closest = data.map((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)MODULE$.closestPoint((Vector<Object>)p, kPoints)), (Object)new Tuple2(p, (Object)BoxesRunTime.boxToInteger((int)1))), ClassTag$.MODULE$.apply(Tuple2.class));
            RDD pointStats = RDD$.MODULE$.rddToPairRDDFunctions(closest, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(a, b) -> MODULE$.mergeResults((Tuple2<Vector<Object>, Object>)a, (Tuple2<Vector<Object>, Object>)b));
            Map newPoints = RDD$.MODULE$.rddToPairRDDFunctions(pointStats.map((Function1 & Serializable & scala.Serializable)pair -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)pair._1$mcI$sp()), ((ImmutableNumericOps)((Tuple2)pair._2())._1()).$times((Object)BoxesRunTime.boxToDouble((double)(1.0 / (double)((Tuple2)pair._2())._2$mcI$sp())), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix())), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            tempDist.elem = 0.0;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), K).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> tempDist$1.elem += BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)kPoints[i], newPoints.apply((Object)BoxesRunTime.boxToInteger((int)i)), squaredDistance$.MODULE$.squaredDistanceFromZippedValues((UFunc.UImpl2)Vector$.MODULE$.zipValuesImpl_V_V_Double()))));
            newPoints.foreach((Function1 & Serializable & scala.Serializable)newP -> {
                kPoints[newP._1$mcI$sp()] = (Vector)newP._2();
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.println((Object)new StringBuilder(29).append("Finished iteration (delta = ").append(tempDist.elem).append(")").toString());
        }
        Predef$.MODULE$.println((Object)"Final centers:");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kPoints)).foreach((Function1 & Serializable & scala.Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
        spark.stop();
    }

    private Tuple2<Vector<Object>, Object> mergeResults(Tuple2<Vector<Object>, Object> a, Tuple2<Vector<Object>, Object> b) {
        return new Tuple2(((NumericOps)a._1()).$plus(b._1(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd()), (Object)BoxesRunTime.boxToInteger((int)(a._2$mcI$sp() + b._2$mcI$sp())));
    }

    public static final /* synthetic */ double $anonfun$parseVector$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
    }

    private SparkKMeans$() {
        MODULE$ = this;
    }
}

