/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringSplit$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regex, limit) - Splits `str` around occurrences that match `regex` and returns an array with a length of at most `limit`", arguments="\n    Arguments:\n      * str - a string expression to split.\n      * regex - a string representing a regular expression. The regex string should be a\n        Java regular expression.\n      * limit - an integer expression which controls the number of times the regex is applied.\n          * limit > 0: The resulting array's length will not be more than `limit`,\n            and the resulting array's last entry will contain all input\n            beyond the last matched regex.\n          * limit <= 0: `regex` will be applied as many times as possible, and\n            the resulting array can be of any size.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]');\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', -1);\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', 2);\n       [\"one\",\"twoBthreeC\"]\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\tEa\u0001B\u0012%\u0001FB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011!\t\u0006A!f\u0001\n\u0003Q\u0005\u0002\u0003*\u0001\u0005#\u0005\u000b\u0011B&\t\u000bM\u0003A\u0011\u0001+\t\u000be\u0003A\u0011\t.\t\u000b\u0005\u0004A\u0011\t2\t\u000b9\u0004A\u0011\t&\t\u000b=\u0004A\u0011\t&\t\u000bA\u0004A\u0011\t&\t\u000bM\u0003A\u0011A9\t\u000bU\u0004A\u0011\t<\t\u000by\u0004A\u0011I@\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u0011q\u0006\u0001\u0005R\u0005E\u0002\"CA \u0001\u0005\u0005I\u0011AA!\u0011%\tI\u0005AI\u0001\n\u0003\tY\u0005C\u0005\u0002b\u0001\t\n\u0011\"\u0001\u0002L!I\u00111\r\u0001\u0012\u0002\u0013\u0005\u00111\n\u0005\n\u0003K\u0002\u0011\u0011!C!\u0003OB\u0011\"a\u001e\u0001\u0003\u0003%\t!!\u001f\t\u0013\u0005\u0005\u0005!!A\u0005\u0002\u0005\r\u0005\"CAE\u0001\u0005\u0005I\u0011IAF\u0011%\tI\nAA\u0001\n\u0003\tY\nC\u0005\u0002&\u0002\t\t\u0011\"\u0011\u0002(\u001eI\u0011\u0011\u001b\u0013\u0002\u0002#\u0005\u00111\u001b\u0004\tG\u0011\n\t\u0011#\u0001\u0002V\"11+\bC\u0001\u0003GD\u0011\"!:\u001e\u0003\u0003%)%a:\t\u0013\u0005%X$!A\u0005\u0002\u0006-\b\"CAz;\u0005\u0005I\u0011QA{\u0011%\u00119!HA\u0001\n\u0013\u0011IAA\u0006TiJLgnZ*qY&$(BA\u0013'\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dB\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%R\u0013aA:rY*\u00111\u0006L\u0001\u0006gB\f'o\u001b\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0011d'\u000f!G!\t\u0019D'D\u0001%\u0013\t)DEA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"aM\u001c\n\u0005a\"#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005ijdBA\u001a<\u0013\taD%A\u0004qC\u000e\\\u0017mZ3\n\u0005yz$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003y\u0011\u0002\"!\u0011#\u000e\u0003\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002B\u000f&\u0011\u0001J\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0004gR\u0014X#A&\u0011\u0005Mb\u0015BA'%\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0005gR\u0014\b%A\u0003sK\u001e,\u00070\u0001\u0004sK\u001e,\u0007\u0010I\u0001\u0006Y&l\u0017\u000e^\u0001\u0007Y&l\u0017\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\u0011)fk\u0016-\u0011\u0005M\u0002\u0001\"B%\b\u0001\u0004Y\u0005\"B(\b\u0001\u0004Y\u0005\"B)\b\u0001\u0004Y\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003m\u0003\"\u0001X0\u000e\u0003uS!A\u0018\u0015\u0002\u000bQL\b/Z:\n\u0005\u0001l&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001d!\r!7n\u0017\b\u0003K*t!AZ5\u000e\u0003\u001dT!\u0001\u001b\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0015B\u0001\u001fC\u0013\taWNA\u0002TKFT!\u0001\u0010\"\u0002\u000b\u0019L'o\u001d;\u0002\rM,7m\u001c8e\u0003\u0015!\b.\u001b:e)\r)&\u000f\u001e\u0005\u0006g6\u0001\raS\u0001\u0004Kb\u0004\b\"B(\u000e\u0001\u0004Y\u0015\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003B<{yv\u0004\"!\u0011=\n\u0005e\u0014%aA!os\")1P\u0004a\u0001o\u000611\u000f\u001e:j]\u001eDQa\u0014\bA\u0002]DQ!\u0015\bA\u0002]\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005\u0005\u0011QBA\f!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004I\u000591m\u001c3fO\u0016t\u0017\u0002BA\u0006\u0003\u000b\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u001fy\u0001\u0019AA\t\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0007\t\u0019\"\u0003\u0003\u0002\u0016\u0005\u0015!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u00033y\u0001\u0019AA\u0001\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\b\u0011\t\u0005\u0005\u0012\u0011\u0006\b\u0005\u0003G\t)\u0003\u0005\u0002g\u0005&\u0019\u0011q\u0005\"\u0002\rA\u0013X\rZ3g\u0013\u0011\tY#!\f\u0003\rM#(/\u001b8h\u0015\r\t9CQ\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$r!VA\u001a\u0003o\tY\u0004\u0003\u0004\u00026E\u0001\raS\u0001\t]\u0016<h)\u001b:ti\"1\u0011\u0011H\tA\u0002-\u000b\u0011B\\3x'\u0016\u001cwN\u001c3\t\r\u0005u\u0012\u00031\u0001L\u0003!qWm\u001e+iSJ$\u0017\u0001B2paf$r!VA\"\u0003\u000b\n9\u0005C\u0004J%A\u0005\t\u0019A&\t\u000f=\u0013\u0002\u0013!a\u0001\u0017\"9\u0011K\u0005I\u0001\u0002\u0004Y\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001bR3aSA(W\t\t\t\u0006\u0005\u0003\u0002T\u0005uSBAA+\u0015\u0011\t9&!\u0017\u0002\u0013Ut7\r[3dW\u0016$'bAA.\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0013Q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u000e\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0014\u0001\u00026bm\u0006LA!a\u000b\u0002n\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0010\t\u0004\u0003\u0006u\u0014bAA@\u0005\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019q/!\"\t\u0013\u0005\u001d\u0005$!AA\u0002\u0005m\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u000eB)\u0011qRAKo6\u0011\u0011\u0011\u0013\u0006\u0004\u0003'\u0013\u0015AC2pY2,7\r^5p]&!\u0011qSAI\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005u\u00151\u0015\t\u0004\u0003\u0006}\u0015bAAQ\u0005\n9!i\\8mK\u0006t\u0007\u0002CAD5\u0005\u0005\t\u0019A<\u0002\r\u0015\fX/\u00197t)\u0011\ti*!+\t\u0011\u0005\u001d5$!AA\u0002]Ds\u0003AAW\u0003g\u000b),!/\u0002<\u0006}\u0016\u0011YAc\u0003\u000f\fY-!4\u0011\u0007M\ny+C\u0002\u00022\u0012\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00028\u0006\tIa\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001\u0012XmZ3yY\u0001b\u0017.\\5uS\u0001j\u0003e\u00159mSR\u001c\b\u0005Y:ue\u0002\u0004\u0013M]8v]\u0012\u0004snY2veJ,gnY3tAQD\u0017\r\u001e\u0011nCR\u001c\u0007\u000e\t1sK\u001e,\u0007\u0010\u0019\u0011b]\u0012\u0004#/\u001a;ve:\u001c\b%\u00198!CJ\u0014\u0018-\u001f\u0011xSRD\u0007%\u0019\u0011mK:<G\u000f\u001b\u0011pM\u0002\nG\u000fI7pgR\u0004\u0003\r\\5nSR\u0004\u0017!C1sOVlWM\u001c;tC\t\ti,\u0001Ca\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8oAQ|\u0007e\u001d9mSRt#\u0002\t\u0011!A\u0001\u0002#\u0006\t:fO\u0016D\b%\f\u0011bAM$(/\u001b8hAI,\u0007O]3tK:$\u0018N\\4!C\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\r\t:fO\u0016D\be\u001d;sS:<\u0007e\u001d5pk2$\u0007EY3!C*\u0001\u0003\u0005\t\u0011!A\u0001\u0002#*\u0019<bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A1LW.\u001b;![\u0001\ng\u000eI5oi\u0016<WM\u001d\u0011fqB\u0014Xm]:j_:\u0004s\u000f[5dQ\u0002\u001awN\u001c;s_2\u001c\b\u0005\u001e5fA9,XNY3sA=4\u0007\u0005^5nKN\u0004C\u000f[3!e\u0016<W\r\u001f\u0011jg\u0002\n\u0007\u000f\u001d7jK\u0012t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!U\u0001b\u0017.\\5uAy\u0002\u0003G\u000f\u0011UQ\u0016\u0004#/Z:vYRLgn\u001a\u0011beJ\f\u0017pJ:!Y\u0016tw\r\u001e5!o&dG\u000e\t8pi\u0002\u0012W\rI7pe\u0016\u0004C\u000f[1oA\u0001d\u0017.\\5uA2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\r\t;iK\u0002\u0012Xm];mi&tw\rI1se\u0006Lxe\u001d\u0011mCN$\b%\u001a8uef\u0004s/\u001b7mA\r|g\u000e^1j]\u0002\nG\u000e\u001c\u0011j]B,HO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#-Z=p]\u0012\u0004C\u000f[3!Y\u0006\u001cH\u000fI7bi\u000eDW\r\u001a\u0011sK\u001e,\u0007P\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001R\u0003\u0005\\5nSR\u0004C(\u0010\u00111u\u0001\u0002'/Z4fq\u0002\u0004s/\u001b7mA\t,\u0007%\u00199qY&,G\rI1tA5\fg.\u001f\u0011uS6,7\u000fI1tAA|7o]5cY\u0016d\u0003%\u00198e\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011uQ\u0016\u0004#/Z:vYRLgn\u001a\u0011beJ\f\u0017\u0010I2b]\u0002\u0012W\rI8gA\u0005t\u0017\u0010I:ju\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a1\u0002\u0005+Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ8oK\u0006#xo\u001c\"uQJ,WmQ\u0014-A\u001dZ\u0016IQ\"^O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0012p]\u0016\u0014CF\t;x_\nb#\u0005\u001e5sK\u0016\u0014CF\t\u0012^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":sN\\3Bi^|'\t\u001e5sK\u0016\u001cu\u0005\f\u0011(7\u0006\u00135)X\u0014-A5\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\E=tWM\t\u0017#i^|'\u0005\f\u0012uQJ,WM\t\u0017#EuS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ8oK\u0006#xo\u001c\"uQJ,WmQ\u0014-A\u001dZ\u0016IQ\"^O1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\nzg.\u001a\u0012-EQ<xN\u0011;ie\u0016,7II/\u000bA\u0001\nQa]5oG\u0016\f#!!3\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005=\u0017\u0001D:ue&twm\u00184v]\u000e\u001c\u0018aC*ue&twm\u00159mSR\u0004\"aM\u000f\u0014\tu\t9N\u0012\t\t\u00033\fynS&L+6\u0011\u00111\u001c\u0006\u0004\u0003;\u0014\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003C\fYNA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!a5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fU\u000bi/a<\u0002r\")\u0011\n\ta\u0001\u0017\")q\n\ta\u0001\u0017\")\u0011\u000b\ta\u0001\u0017\u00069QO\\1qa2LH\u0003BA|\u0005\u0007\u0001R!QA}\u0003{L1!a?C\u0005\u0019y\u0005\u000f^5p]B1\u0011)a@L\u0017.K1A!\u0001C\u0005\u0019!V\u000f\u001d7fg!A!QA\u0011\u0002\u0002\u0003\u0007Q+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!1\u0002\t\u0005\u0003W\u0012i!\u0003\u0003\u0003\u0010\u00055$AB(cU\u0016\u001cG\u000f")
public class StringSplit
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression str;
    private final Expression regex;
    private final Expression limit;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringSplit stringSplit) {
        return StringSplit$.MODULE$.unapply(stringSplit);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringSplit> tupled() {
        return StringSplit$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringSplit>>> curried() {
        return StringSplit$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression regex() {
        return this.regex;
    }

    public Expression limit() {
        return this.limit;
    }

    @Override
    public DataType dataType() {
        return new ArrayType(StringType$.MODULE$, false);
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.regex();
    }

    @Override
    public Expression third() {
        return this.limit();
    }

    @Override
    public Object nullSafeEval(Object string, Object regex, Object limit) {
        UTF8String[] strings = ((UTF8String)string).split((UTF8String)regex, BoxesRunTime.unboxToInt((Object)limit));
        return new GenericArrayData(strings);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String arrayClass = GenericArrayData.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, regex, limit) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(19).append(ev.value()).append(" = new ").append(arrayClass).append("(").append((String)str).append(".split(").append((String)regex).append(",").append((String)limit).append("));").toString())).stripMargin());
    }

    @Override
    public String prettyName() {
        return "split";
    }

    @Override
    public StringSplit withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringSplit copy(Expression str, Expression regex, Expression limit) {
        return new StringSplit(str, regex, limit);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.regex();
    }

    public Expression copy$default$3() {
        return this.limit();
    }

    @Override
    public String productPrefix() {
        return "StringSplit";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.regex();
                break;
            }
            case 2: {
                expression = this.limit();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringSplit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringSplit)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringSplit stringSplit = (StringSplit)x$1;
        Expression expression = this.str();
        Expression expression2 = stringSplit.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regex();
        Expression expression4 = stringSplit.regex();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.limit();
        Expression expression6 = stringSplit.limit();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringSplit.canEqual(this)) return false;
        return true;
    }

    public StringSplit(Expression str, Expression regex, Expression limit) {
        this.str = str;
        this.regex = regex;
        this.limit = limit;
        ExpectsInputTypes.$init$(this);
    }

    public StringSplit(Expression exp, Expression regex) {
        this(exp, regex, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)-1)));
    }
}

