/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Editable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.scheduler.ExecutorDecommissionInfo;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.GenerateExecID;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t%e!\u0002\u00180\u0001UZ\u0004\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t/\u0002\u0011\t\u0011)A\u00051\"A!\r\u0001B\u0001B\u0003%1\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!Y\u0007A!A!\u0002\u0013a\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011M\u0004!\u0011!Q\u0001\nQDQa\u001e\u0001\u0005\u0002aD\u0011\"a\u0002\u0001\u0005\u0004%I!!\u0003\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003\u0017A\u0011\"a\n\u0001\u0005\u0004%\t&!\u000b\t\u0011\u0005M\u0002\u0001)A\u0005\u0003WA\u0011\"!\u000e\u0001\u0005\u0004%I!a\u000e\t\u0011\u0005}\u0002\u0001)A\u0005\u0003sA\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005-\u0003\u0001)A\u0005\u0003\u000bB\u0011\"!\u0014\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u000bB\u0011\"!\u0015\u0001\u0005\u0004%I!a\u0015\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u0003+B\u0001\"a\u0019\u0001\t\u0003y\u0013Q\r\u0005\b\u0003w\u0002A\u0011BA?\u0011\u001d\tI\n\u0001C!\u00037Cq!!(\u0001\t\u0003\ny\nC\u0004\u0002\"\u0002!\t%a(\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u00111\u0018\u0001\u0005B\u0005u\u0006bBA`\u0001\u0011\u0005\u0013\u0011\u0019\u0005\b\u0003+\u0004A\u0011BAl\u0011\u001d\ti\u000e\u0001C!\u0003?Dq!a@\u0001\t\u0003\u0012\t\u0001C\u0004\u0003\b\u0001!\tE!\u0003\t\u0013\tM\u0001A1A\u0005\u0002\tU\u0001\u0002\u0003B\u0012\u0001\u0001\u0006IAa\u0006\t\u000f\t\u0015\u0002\u0001\"\u0015\u0003(!9!1\b\u0001\u0005R\tubA\u0002B#\u0001\u0011\u00119\u0005\u0003\u0004xO\u0011\u0005!\u0011\n\u0005\b\u0005\u001b:C\u0011\u0002B(\u0011\u001d\u0011ig\nC\u0005\u0005_BqA!\u001d(\t\u0003\u0012\u0019\bC\u0004\u0003x\u001d\"\tE!\u001f\t\u001d\t\u0015\u0005\u0001%A\u0002\u0002\u0003%I!a(\u0003\b\n\t3*\u001e2fe:,G/Z:DYV\u001cH/\u001a:TG\",G-\u001e7fe\n\u000b7m[3oI*\u0011\u0001'M\u0001\u0004Wb\u001a(B\u0001\u001a4\u0003\u001d\u0019G.^:uKJT!\u0001N\u001b\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u001c8\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0014(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0005\u0019qN]4\u0014\u0005\u0001a\u0004CA\u001f?\u001b\u0005\t\u0014BA 2\u0005u\u0019u.\u0019:tK\u001e\u0013\u0018-\u001b8fIN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$7\u0001\u0001\t\u0003\u0005\u000ek\u0011aM\u0005\u0003\tN\u0012\u0011\u0003V1tWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018*\u001c9m\u0003\t\u00198\r\u0005\u0002H\u00116\tQ'\u0003\u0002Jk\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003\u0019Vk\u0011!\u0014\u0006\u0003\u001d>\u000baa\u00197jK:$(B\u0001)R\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003%N\u000bqAZ1ce&\u001c\u0007HC\u0001U\u0003\tIw.\u0003\u0002W\u001b\n\u00012*\u001e2fe:,G/Z:DY&,g\u000e^\u0001\u0010Kb,7-\u001e;peN+'O^5dKB\u0011\u0011\fY\u0007\u00025*\u00111\fX\u0001\u000bG>t7-\u001e:sK:$(BA/_\u0003\u0011)H/\u001b7\u000b\u0003}\u000bAA[1wC&\u0011\u0011M\u0017\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017AD:oCB\u001c\bn\u001c;t'R|'/\u001a\t\u0003I\u0016l\u0011aL\u0005\u0003M>\u0012!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\fA\u0002]8e\u00032dwnY1u_J\u0004\"\u0001Z5\n\u0005)|#!F!cgR\u0014\u0018m\u0019;Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN]\u0001\u0016Y&4WmY=dY\u0016,e/\u001a8u\u0011\u0006tG\r\\3s!\t!W.\u0003\u0002o_\taR\t_3dkR|'\u000fU8eg2Kg-Z2zG2,W*\u00198bO\u0016\u0014\u0018aC<bi\u000eDWI^3oiN\u0004\"\u0001Z9\n\u0005I|#aH#yK\u000e,Ho\u001c:Q_\u0012\u001cx+\u0019;dQNs\u0017\r]:i_R\u001cv.\u001e:dK\u0006Q\u0001o\u001c7m\u000bZ,g\u000e^:\u0011\u0005\u0011,\u0018B\u0001<0\u0005\u0005*\u00050Z2vi>\u0014\bk\u001c3t!>dG.\u001b8h':\f\u0007o\u001d5piN{WO]2f\u0003\u0019a\u0014N\\5u}Qi\u0011P_>}{z|\u0018\u0011AA\u0002\u0003\u000b\u0001\"\u0001\u001a\u0001\t\u000bQR\u0001\u0019A!\t\u000b\u0015S\u0001\u0019\u0001$\t\u000b)S\u0001\u0019A&\t\u000b]S\u0001\u0019\u0001-\t\u000b\tT\u0001\u0019A2\t\u000b\u001dT\u0001\u0019\u00015\t\u000b-T\u0001\u0019\u00017\t\u000b=T\u0001\u0019\u00019\t\u000bMT\u0001\u0019\u0001;\u0002\u000b\u0005\u0004\b/\u00133\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003?qA!a\u0004\u0002\u001cA!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\u0001\u000ba\u0001\u0010:p_Rt$BAA\r\u0003\u0015\u00198-\u00197b\u0013\u0011\ti\"a\u0006\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#a\t\u0003\rM#(/\u001b8h\u0015\u0011\ti\"a\u0006\u0002\r\u0005\u0004\b/\u00133!\u0003Ii\u0017N\u001c*fO&\u001cH/\u001a:fIJ\u000bG/[8\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003_i!!a\u0006\n\t\u0005E\u0012q\u0003\u0002\u0007\t>,(\r\\3\u0002'5LgNU3hSN$XM]3e%\u0006$\u0018n\u001c\u0011\u0002!%t\u0017\u000e^5bY\u0016CXmY;u_J\u001cXCAA\u001d!\u0011\ti#a\u000f\n\t\u0005u\u0012q\u0003\u0002\u0004\u0013:$\u0018!E5oSRL\u0017\r\\#yK\u000e,Ho\u001c:tA\u0005I2\u000f[8vY\u0012$U\r\\3uK\u0012\u0013\u0018N^3s'\u0016\u0014h/[2f+\t\t)\u0005\u0005\u0003\u0002.\u0005\u001d\u0013\u0002BA%\u0003/\u0011qAQ8pY\u0016\fg.\u0001\u000etQ>,H\u000e\u001a#fY\u0016$X\r\u0012:jm\u0016\u00148+\u001a:wS\u000e,\u0007%A\u000btQ>,H\u000e\u001a#fY\u0016$X-\u0012=fGV$xN]:\u0002-MDw.\u001e7e\t\u0016dW\r^3Fq\u0016\u001cW\u000f^8sg\u0002\na\u0002Z3gCVdG\u000f\u0015:pM&dW-\u0006\u0002\u0002VA!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\U\n\u0001B]3t_V\u00148-Z\u0005\u0005\u0003?\nIFA\bSKN|WO]2f!J|g-\u001b7f\u0003=!WMZ1vYR\u0004&o\u001c4jY\u0016\u0004\u0013\u0001\u00053p%\u0016lwN^3Fq\u0016\u001cW\u000f^8s)\u0019\t9'!\u001c\u0002rA!\u0011QFA5\u0013\u0011\tY'a\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003_:\u0002\u0019AA\u0006\u0003))\u00070Z2vi>\u0014\u0018\n\u001a\u0005\b\u0003g:\u0002\u0019AA;\u0003\u0019\u0011X-Y:p]B\u0019!)a\u001e\n\u0007\u0005e4G\u0001\nFq\u0016\u001cW\u000f^8s\u0019>\u001c8OU3bg>t\u0017AF:fiV\u0003X\t_3dkR|'oQ8oM&<W*\u00199\u0015\t\u0005\u001d\u0014q\u0010\u0005\b\u0003\u0003C\u0002\u0019AAB\u0003%!'/\u001b<feB{G\r\u0005\u0004\u0002.\u0005\u0015\u0015\u0011R\u0005\u0005\u0003\u000f\u000b9B\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0017\u000b)*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003\u0015iw\u000eZ3m\u0015\r\t\u0019jT\u0001\u0004CBL\u0017\u0002BAL\u0003\u001b\u00131\u0001U8e\u00035\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JIR\u0011\u00111B\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003O\nAa\u001d;pa\u00069Bm\u001c*fcV,7\u000f\u001e+pi\u0006dW\t_3dkR|'o\u001d\u000b\u0005\u0003O\u000b\t\f\u0005\u0004\u0002*\u00065\u0016QI\u0007\u0003\u0003WS1aWA\f\u0013\u0011\ty+a+\u0003\r\u0019+H/\u001e:f\u0011\u001d\t\u0019\f\ba\u0001\u0003k\u000b1D]3t_V\u00148-\u001a)s_\u001aLG.\u001a+p)>$\u0018\r\\#yK\u000e\u001c\b\u0003CA\u0007\u0003o\u000b)&!\u000f\n\t\u0005e\u00161\u0005\u0002\u0004\u001b\u0006\u0004\u0018!H:vM\u001aL7-[3oiJ+7o\\;sG\u0016\u001c(+Z4jgR,'/\u001a3\u0015\u0005\u0005\u0015\u0013AD4fi\u0016CXmY;u_JLEm\u001d\u000b\u0003\u0003\u0007\u0004b!!2\u0002P\u0006-a\u0002BAd\u0003\u0017tA!!\u0005\u0002J&\u0011\u0011\u0011D\u0005\u0005\u0003\u001b\f9\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00171\u001b\u0002\u0004'\u0016\f(\u0002BAg\u0003/\t\u0011\u0004\\1cK2$UmY8n[&\u001c8/[8oS:<W\t_3dgR!\u0011qMAm\u0011\u001d\tYn\ba\u0001\u0003\u0007\fq!\u001a=fG&#7/A\u000beK\u000e|W.\\5tg&|g.\u0012=fGV$xN]:\u0015\u0011\u0005\r\u0017\u0011]A|\u0003wDq!a9!\u0001\u0004\t)/A\u000bfq\u0016\u001cW\u000f^8sg\u0006sG\rR3d_6LeNZ8\u0011\r\u00055\u0012q]Av\u0013\u0011\tI/a\u0006\u0003\u000b\u0005\u0013(/Y=\u0011\u0011\u00055\u0012Q^A\u0006\u0003cLA!a<\u0002\u0018\t1A+\u001e9mKJ\u00022AQAz\u0013\r\t)p\r\u0002\u0019\u000bb,7-\u001e;pe\u0012+7m\\7nSN\u001c\u0018n\u001c8J]\u001a|\u0007bBA}A\u0001\u0007\u0011QI\u0001\u0019C\u0012TWo\u001d;UCJ<W\r\u001e(v[\u0016CXmY;u_J\u001c\bbBA\u007fA\u0001\u0007\u0011QI\u0001\u0014iJLwmZ3sK\u0012\u0014\u00150\u0012=fGV$xN]\u0001\u0010I>\\\u0015\u000e\u001c7Fq\u0016\u001cW\u000f^8sgR!\u0011q\u0015B\u0002\u0011\u001d\u0011)!\ta\u0001\u0003\u0007\f1\"\u001a=fGV$xN]%eg\u0006!2M]3bi\u0016$%/\u001b<fe\u0016sG\r]8j]R$\"Aa\u0003\u0011\t\t5!qB\u0007\u0002\u0001%\u0019!\u0011\u0003 \u0003\u001d\u0011\u0013\u0018N^3s\u000b:$\u0007o\\5oi\u00061Q\r_3d\u0013\u0012,\"Aa\u0006\u0011\t\te!qD\u0007\u0003\u00057Q1A!\b[\u0003\u0019\tGo\\7jG&!!\u0011\u0005B\u000e\u00055\tEo\\7jG&sG/Z4fe\u00069Q\r_3d\u0013\u0012\u0004\u0013AE2sK\u0006$X\rV8lK:l\u0015M\\1hKJ$\"A!\u000b\u0011\r\u00055\u0012Q\u0011B\u0016!\u0011\u0011iCa\u000e\u000e\u0005\t=\"\u0002\u0002B\u0019\u0005g\t\u0001b]3dkJLG/\u001f\u0006\u0004\u0005k)\u0014A\u00023fa2|\u00170\u0003\u0003\u0003:\t=\"\u0001\b%bI>|\u0007\u000fR3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM]\u0001\u0013SN,\u00050Z2vi>\u0014X\t_2mk\u0012,G\r\u0006\u0004\u0002F\t}\"\u0011\t\u0005\b\u0003_2\u0003\u0019AA\u0006\u0011\u001d\u0011\u0019E\na\u0001\u0003\u0017\t\u0001\u0002[8ti:\fW.\u001a\u0002\u0019\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ,e\u000e\u001a9pS:$8cA\u0014\u0003\fQ\u0011!1\n\t\u0004\u0005\u001b9\u0013AD4f]\u0016\u0014\u0018\r^3Fq\u0016\u001c\u0017\n\u0012\u000b\u0005\u0005#\u0012i\u0006\u0005\u0005\u0002.\tM#qKA4\u0013\u0011\u0011)&a\u0006\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004B!!\f\u0003Z%!!1LA\f\u0005\r\te.\u001f\u0005\b\u0005?J\u0003\u0019\u0001B1\u0003\u001d\u0019wN\u001c;fqR\u0004BAa\u0019\u0003j5\u0011!Q\r\u0006\u0004\u0005O*\u0014a\u0001:qG&!!1\u000eB3\u00059\u0011\u0006oY\"bY2\u001cuN\u001c;fqR\fa%[4o_J,'+Z4jgR,'/\u0012=fGV$xN]!u'R|\u0007\u000f]3e\u0007>tG/\u001a=u+\t\u0011\t&A\bsK\u000e,\u0017N^3B]\u0012\u0014V\r\u001d7z)\u0011\u0011\tF!\u001e\t\u000f\t}3\u00061\u0001\u0003b\u0005qqN\u001c#jg\u000e|gN\\3di\u0016$G\u0003BA4\u0005wBqA! -\u0001\u0004\u0011y(\u0001\u0006sa\u000e\fE\r\u001a:fgN\u0004BAa\u0019\u0003\u0002&!!1\u0011B3\u0005)\u0011\u0006oY!eIJ,7o]\u0001\u000bgV\u0004XM\u001d\u0013ti>\u0004\u0018bAAQ}\u0001")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    public final SparkContext org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc;
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient;
    public final ScheduledExecutorService org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final AbstractPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleEventHandler;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final String appId;
    private final double minRegisteredRatio;
    private final int initialExecutors;
    private final boolean shouldDeleteDriverService;
    private final boolean shouldDeleteExecutors;
    private final ResourceProfile defaultProfile;
    private final AtomicInteger execId;

    private /* synthetic */ void super$stop() {
        super.stop();
    }

    private String appId() {
        return this.appId;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    private boolean shouldDeleteDriverService() {
        return this.shouldDeleteDriverService;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        this.removeExecutor(executorId, reason);
    }

    private void setUpExecutorConfigMap(Option<Pod> driverPod) {
        String configMapName = KubernetesClientUtils$.MODULE$.configMapNameExecutor();
        Map resolvedExecutorProperties = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_NAMESPACE().key()), this.conf().get(Config$.MODULE$.KUBERNETES_NAMESPACE()))}));
        Map confFilesMap = KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, this.conf(), (Map<String, String>)resolvedExecutorProperties).$plus$plus((GenTraversableOnce)resolvedExecutorProperties);
        Map labels = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.applicationId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())}));
        ConfigMap configMap = KubernetesClientUtils$.MODULE$.buildConfigMap(configMapName, (Map<String, String>)confFilesMap, (Map<String, String>)labels);
        KubernetesUtils$.MODULE$.addOwnerReference((Pod)driverPod.orNull(Predef$.MODULE$.$conforms()), (Seq<HasMetadata>)((Seq)new .colon.colon((Object)configMap, (List)Nil$.MODULE$)));
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().create((Object)configMap);
    }

    public String applicationId() {
        return (String)this.conf().getOption("spark.app.id").getOrElse((Function0 & Serializable & scala.Serializable)() -> this.appId());
    }

    public void start() {
        block0: {
            super.start();
            this.podAllocator.start(this.applicationId(), this);
            Map initExecs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)this.initialExecutors()))}));
            this.podAllocator.setTotalExpectedExecutors((Map<ResourceProfile, Object>)initExecs);
            this.lifecycleEventHandler.start(this);
            this.watchEvents.start(this.applicationId());
            this.pollEvents.start(this.applicationId());
            if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()))) break block0;
            this.setUpExecutorConfigMap(this.podAllocator.driverPod());
        }
    }

    public void stop() {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.super$stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.pollEvents.stop());
        if (this.shouldDeleteDriverService()) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.services().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).delete());
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.persistentVolumeClaims().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).delete());
        if (this.shouldDeleteExecutors()) {
            this.podAllocator.stop(this.applicationId());
            if (!BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()))) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
            }
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ThreadUtils$.MODULE$.shutdown((ExecutorService)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        this.podAllocator.setTotalExpectedExecutors(resourceProfileToTotalExecs);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    private void labelDecommissioningExecs(Seq<String> execIds) {
        ((Option)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DECOMMISSION_LABEL())).foreach((Function1 & Serializable & scala.Serializable)label -> {
            KubernetesClusterSchedulerBackend.$anonfun$labelDecommissioningExecs$1(this, execIds, label);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<String> decommissionExecutors(Tuple2<String, ExecutorDecommissionInfo>[] executorsAndDecomInfo, boolean adjustTargetNumExecutors, boolean triggeredByExecutor) {
        block0: {
            if (triggeredByExecutor) break block0;
            this.labelDecommissioningExecs((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])executorsAndDecomInfo)).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        }
        return super.decommissionExecutors(executorsAndDecomInfo, adjustTargetNumExecutors, triggeredByExecutor);
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        this.labelDecommissioningExecs(executorIds);
        executorIds.foreach((Function1 & Serializable & scala.Serializable)id -> {
            this.removeExecutor(id, (ExecutorLossReason)ExecutorKilled$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Runnable killTask = new Runnable(this, executorIds){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq executorIds$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block0: {
                        FilterWatchListDeletable running = (FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withField("status.phase", "Running")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.executorIds$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                        if (((PodList)running.list()).getItems().isEmpty()) break block0;
                        $this.$outer.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Forcefully deleting ").append(((PodList)running.list()).getItems().size()).append(" pods ").append("(out of ").append($this.executorIds$1.size()).append(") that are still running after graceful shutdown period.").toString());
                        running.delete();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorIds$1 = executorIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$5(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$2 ), $anonfun$run$6(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$2 io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable )}, serializedLambda);
            }
        };
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.schedule(killTask, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())), TimeUnit.MILLISECONDS);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new KubernetesDriverEndpoint(this);
    }

    public AtomicInteger execId() {
        return this.execId;
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.conf(), this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public boolean isExecutorExcluded(String executorId, String hostname) {
        return this.podAllocator.isDeleted(executorId);
    }

    public static final /* synthetic */ void $anonfun$labelDecommissioningExecs$1(KubernetesClusterSchedulerBackend $this, Seq execIds$1, String label) {
        Runnable labelTask = new Runnable($this, execIds$1, label){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq execIds$1;
            private final String label$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Buffer podsToLabel = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((PodList)((Listable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.execIds$1.toArray(ClassTag$.MODULE$.apply(String.class)))).list()).getItems()).asScala();
                    podsToLabel.foreach((Function1 & Serializable & scala.Serializable)pod -> (Pod)((Editable)((Nameable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName())).edit(p -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(p).editMetadata().addToLabels($this.label$1, (String)((Option)$this.$outer.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DECOMMISSION_LABEL_VALUE())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))).endMetadata()).build()));
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.execIds$1 = execIds$1;
                this.label$1 = label$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 ), $anonfun$run$4(), $anonfun$run$2(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 io.fabric8.kubernetes.api.model.Pod )}, serializedLambda);
            }
        };
        $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.execute(labelTask);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, KubernetesClient kubernetesClient, ScheduledExecutorService executorService, ExecutorPodsSnapshotsStore snapshotsStore, AbstractPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleEventHandler, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc = sc;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient = kubernetesClient;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService = executorService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleEventHandler = lifecycleEventHandler;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, sc.env().rpcEnv());
        this.appId = KubernetesConf$.MODULE$.getKubernetesAppId();
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
        this.shouldDeleteDriverService = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_DELETE_ON_TERMINATION()));
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.defaultProfile = scheduler.sc().resourceProfileManager().defaultResourceProfile();
        this.execId = new AtomicInteger(0);
    }

    private class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        private PartialFunction<Object, BoxedUnit> generateExecID(RpcCallContext context) {
            return new scala.Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KubernetesDriverEndpoint $outer;
                private final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof GenerateExecID) {
                        GenerateExecID generateExecID2 = (GenerateExecID)A1;
                        String newId = Integer.toString(this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().execId().incrementAndGet());
                        this.context$1.reply((Object)newId);
                        Runnable labelTask = new Runnable(this, generateExecID2, newId){
                            private final /* synthetic */ KubernetesDriverEndpoint$$anonfun$generateExecID$1 $outer;
                            private final GenerateExecID x2$1;
                            private final String newId$1;

                            public void run() {
                                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Editable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().withName($this.x2$1.podName())).edit(p -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(p).editMetadata().addToLabels(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), $this.newId$1)).endMetadata()).build()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.x2$1 = x2$1;
                                this.newId$1 = newId$1;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$7(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$generateExecID$1$$anon$3 )}, serializedLambda);
                            }
                        };
                        this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.execute(labelTask);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof GenerateExecID;
                    return bl;
                }

                public /* synthetic */ KubernetesDriverEndpoint org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            };
        }

        private PartialFunction<Object, BoxedUnit> ignoreRegisterExecutorAtStoppedContext() {
            return new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KubernetesDriverEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 instanceof CoarseGrainedClusterMessages.RegisterExecutor && this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.isStopped() ? BoxedUnit.UNIT : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RegisterExecutor && this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.isStopped();
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return this.generateExecID(context).orElse(this.ignoreRegisterExecutorAtStoppedContext().orElse(super.receiveAndReply(context)));
        }

        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> BoxesRunTime.boxToBoolean((boolean)this.disableExecutor(executorId)));
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }
}

