/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.SparseNaiveBayes;
import org.apache.spark.examples.mllib.SparseNaiveBayes$;
import org.apache.spark.examples.mllib.SparseNaiveBayes$Params$;
import org.apache.spark.mllib.classification.NaiveBayes;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class SparseNaiveBayes$ {
    public static SparseNaiveBayes$ MODULE$;

    static {
        new SparseNaiveBayes$();
    }

    public void main(String[] args) {
        SparseNaiveBayes.Params defaultParams = new SparseNaiveBayes.Params(SparseNaiveBayes$Params$.MODULE$.apply$default$1(), SparseNaiveBayes$Params$.MODULE$.apply$default$2(), SparseNaiveBayes$Params$.MODULE$.apply$default$3(), SparseNaiveBayes$Params$.MODULE$.apply$default$4());
        OptionParser<SparseNaiveBayes.Params> parser = new OptionParser<SparseNaiveBayes.Params>(defaultParams){

            public static final /* synthetic */ SparseNaiveBayes.Params $anonfun$new$1(int x, SparseNaiveBayes.Params c) {
                int x$1 = x;
                String x$2 = c.copy$default$1();
                int x$3 = c.copy$default$3();
                double x$4 = c.copy$default$4();
                return c.copy(x$2, x$1, x$3, x$4);
            }

            public static final /* synthetic */ SparseNaiveBayes.Params $anonfun$new$2(int x, SparseNaiveBayes.Params c) {
                int x$5 = x;
                String x$6 = c.copy$default$1();
                int x$7 = c.copy$default$2();
                double x$8 = c.copy$default$4();
                return c.copy(x$6, x$7, x$5, x$8);
            }

            public static final /* synthetic */ SparseNaiveBayes.Params $anonfun$new$3(double x, SparseNaiveBayes.Params c) {
                double x$9 = x;
                String x$10 = c.copy$default$1();
                int x$11 = c.copy$default$2();
                int x$12 = c.copy$default$3();
                return c.copy(x$10, x$11, x$12, x$9);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SparseNaiveBayes: an example naive Bayes app for LIBSVM data."}));
                this.opt("numPartitions", Read$.MODULE$.intRead()).text("min number of partitions").action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("numFeatures", Read$.MODULE$.intRead()).text("number of features").action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("lambda", Read$.MODULE$.doubleRead()).text(new StringBuilder(38).append("lambda (smoothing constant), default: ").append(defaultParams$1.lambda()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToDouble((Object)x), c));
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input paths to labeled examples in LIBSVM format").required().action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.mllib.SparseNaiveBayes$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.mllib.SparseNaiveBayes$Params ), $anonfun$new$3$adapted(java.lang.Object org.apache.spark.examples.mllib.SparseNaiveBayes$Params ), $anonfun$new$4(java.lang.String org.apache.spark.examples.mllib.SparseNaiveBayes$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (!(option instanceof Some)) {
            throw package$.MODULE$.exit(1);
        }
        Some some = (Some)option;
        SparseNaiveBayes.Params params = (SparseNaiveBayes.Params)some.value();
        this.run(params);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void run(SparseNaiveBayes.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(22).append("SparseNaiveBayes with ").append(params).toString());
        SparkContext sc = new SparkContext(conf);
        Configurator.setRootLevel((Level)Level.WARN);
        int minPartitions = params.minPartitions() > 0 ? params.minPartitions() : sc.defaultMinPartitions();
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input(), params.numFeatures(), minPartitions);
        examples.cache();
        RDD[] splits = examples.randomSplit(new double[]{0.8, 0.2}, examples.randomSplit$default$2());
        RDD training = splits[0];
        RDD test = splits[1];
        long numTraining = training.count();
        long numTest = test.count();
        Predef$.MODULE$.println((Object)new StringBuilder(27).append("numTraining = ").append(numTraining).append(", numTest = ").append(numTest).append(".").toString());
        NaiveBayesModel model = new NaiveBayes().setLambda(params.lambda()).run(training);
        RDD prediction = model.predict(test.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.features(), ClassTag$.MODULE$.apply(Vector.class)));
        RDD predictionAndLabel = prediction.zip(test.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.label()), ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.Double());
        double accuracy = (double)predictionAndLabel.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)SparseNaiveBayes$.$anonfun$run$3(x))).count() / (double)numTest;
        Predef$.MODULE$.println((Object)new StringBuilder(17).append("Test accuracy = ").append(accuracy).append(".").toString());
        sc.stop();
    }

    public static final /* synthetic */ boolean $anonfun$run$3(Tuple2 x) {
        return x._1$mcD$sp() == x._2$mcD$sp();
    }

    private SparseNaiveBayes$() {
        MODULE$ = this;
    }
}

