/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfUtil;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.HiveSparkClient;
import org.apache.hadoop.hive.ql.exec.spark.HiveVoidFunction;
import org.apache.hadoop.hive.ql.exec.spark.SparkPlan;
import org.apache.hadoop.hive.ql.exec.spark.SparkPlanGenerator;
import org.apache.hadoop.hive.ql.exec.spark.SparkReporter;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobRef;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.JobMetricsListener;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.LocalSparkJobRef;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.LocalSparkJobStatus;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.spark.counter.SparkCounters;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaFutureAction;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.VoidFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHiveSparkClient
implements HiveSparkClient {
    private static final long serialVersionUID = 1L;
    private static final String MR_JAR_PROPERTY = "tmpjars";
    protected static final transient Logger LOG = LoggerFactory.getLogger(LocalHiveSparkClient.class);
    private static final Splitter CSV_SPLITTER = Splitter.on((String)",").omitEmptyStrings();
    private static LocalHiveSparkClient client;
    private final JavaSparkContext sc;
    private final List<String> localJars = new ArrayList<String>();
    private final List<String> localFiles = new ArrayList<String>();
    private final JobMetricsListener jobMetricsListener;

    public static synchronized LocalHiveSparkClient getInstance(SparkConf sparkConf) {
        if (client == null) {
            client = new LocalHiveSparkClient(sparkConf);
        }
        return client;
    }

    private LocalHiveSparkClient(SparkConf sparkConf) {
        this.sc = new JavaSparkContext(sparkConf);
        this.jobMetricsListener = new JobMetricsListener();
        this.sc.sc().listenerBus().addListener((Object)this.jobMetricsListener);
    }

    @Override
    public SparkConf getSparkConf() {
        return this.sc.sc().conf();
    }

    @Override
    public int getExecutorCount() {
        return this.sc.sc().getExecutorMemoryStatus().size();
    }

    @Override
    public int getDefaultParallelism() throws Exception {
        return this.sc.sc().defaultParallelism();
    }

    @Override
    public SparkJobRef execute(DriverContext driverContext, SparkWork sparkWork) throws Exception {
        Context ctx = driverContext.getCtx();
        HiveConf hiveConf = (HiveConf)ctx.getConf();
        this.refreshLocalResources(sparkWork, hiveConf);
        JobConf jobConf = new JobConf((Configuration)hiveConf);
        Path emptyScratchDir = ctx.getMRTmpPath();
        FileSystem fs = emptyScratchDir.getFileSystem((Configuration)jobConf);
        fs.mkdirs(emptyScratchDir);
        HiveConfUtil.updateJobCredentialProviders((Configuration)jobConf);
        SparkCounters sparkCounters = new SparkCounters(this.sc);
        Map<String, List<String>> prefixes = sparkWork.getRequiredCounterPrefix();
        if (prefixes != null) {
            for (String group : prefixes.keySet()) {
                for (String counterName : prefixes.get(group)) {
                    sparkCounters.createCounter(group, counterName);
                }
            }
        }
        SparkReporter sparkReporter = new SparkReporter(sparkCounters);
        SparkPlanGenerator gen = new SparkPlanGenerator(this.sc, ctx, jobConf, emptyScratchDir, sparkReporter);
        SparkPlan plan = gen.generate(sparkWork);
        if (driverContext.isShutdown()) {
            throw new HiveException("Operation is cancelled.");
        }
        JavaPairRDD<HiveKey, BytesWritable> finalRDD = plan.generateGraph();
        JavaFutureAction future = finalRDD.foreachAsync((VoidFunction)HiveVoidFunction.getInstance());
        int jobId = (Integer)future.jobIds().get(0);
        LocalSparkJobStatus sparkJobStatus = new LocalSparkJobStatus(this.sc, jobId, this.jobMetricsListener, sparkCounters, plan.getCachedRDDIds(), (JavaFutureAction<Void>)future);
        return new LocalSparkJobRef(Integer.toString(jobId), hiveConf, sparkJobStatus, this.sc);
    }

    private synchronized void refreshLocalResources(SparkWork sparkWork, HiveConf conf) {
        this.addJars(new JobConf(this.getClass()).getJar());
        this.addJars(conf.getAuxJars());
        this.addJars(SessionState.get() == null ? null : SessionState.get().getReloadableAuxJars());
        String addedJars = Utilities.getResourceFiles((Configuration)conf, SessionState.ResourceType.JAR);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEADDEDJARS, (String)addedJars);
        this.addJars(addedJars);
        JobConf jobConf = new JobConf((Configuration)conf);
        jobConf.set(MR_JAR_PROPERTY, "");
        for (BaseWork work : sparkWork.getAllWork()) {
            work.configureJobConf(jobConf);
        }
        this.addJars(conf.get(MR_JAR_PROPERTY));
        String addedFiles = Utilities.getResourceFiles((Configuration)conf, SessionState.ResourceType.FILE);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEADDEDFILES, (String)addedFiles);
        this.addResources(addedFiles);
        String addedArchives = Utilities.getResourceFiles((Configuration)conf, SessionState.ResourceType.ARCHIVE);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEADDEDARCHIVES, (String)addedArchives);
        this.addResources(addedArchives);
    }

    private void addResources(String addedFiles) {
        for (String addedFile : CSV_SPLITTER.split((CharSequence)Strings.nullToEmpty((String)addedFiles))) {
            if (this.localFiles.contains(addedFile)) continue;
            this.localFiles.add(addedFile);
            this.sc.addFile(addedFile);
        }
    }

    private void addJars(String addedJars) {
        for (String addedJar : CSV_SPLITTER.split((CharSequence)Strings.nullToEmpty((String)addedJars))) {
            if (this.localJars.contains(addedJar)) continue;
            this.localJars.add(addedJar);
            this.sc.addJar(addedJar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Class<LocalHiveSparkClient> clazz = LocalHiveSparkClient.class;
        synchronized (LocalHiveSparkClient.class) {
            client = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.sc != null) {
                this.sc.stop();
            }
            return;
        }
    }
}

