% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparkR.R
\name{sparkR.session}
\alias{sparkR.session}
\title{Get the existing SparkSession or initialize a new SparkSession.}
\usage{
sparkR.session(
  master = "",
  appName = "SparkR",
  sparkHome = Sys.getenv("SPARK_HOME"),
  sparkConfig = list(),
  sparkJars = "",
  sparkPackages = "",
  enableHiveSupport = TRUE,
  ...
)
}
\arguments{
\item{master}{the Spark master URL.}

\item{appName}{application name to register with cluster manager.}

\item{sparkHome}{Spark Home directory.}

\item{sparkConfig}{named list of Spark configuration to set on worker nodes.}

\item{sparkJars}{character vector of jar files to pass to the worker nodes.}

\item{sparkPackages}{character vector of package coordinates}

\item{enableHiveSupport}{enable support for Hive, fallback if not built with Hive support; once
set, this cannot be turned off on an existing session}

\item{...}{named Spark properties passed to the method.}
}
\description{
SparkSession is the entry point into SparkR. \code{sparkR.session} gets the existing
SparkSession or initializes a new SparkSession.
Additional Spark properties can be set in \code{...}, and these named parameters take priority
over values in \code{master}, \code{appName}, named lists of \code{sparkConfig}.
}
\details{
When called in an interactive session, this method checks for the Spark installation, and, if not
found, it will be downloaded and cached automatically. Alternatively, \code{install.spark} can
be called manually.

A default warehouse is created automatically in the current directory when a managed table is
created via \code{sql} statement \code{CREATE TABLE}, for example. To change the location of the
warehouse, set the named parameter \code{spark.sql.warehouse.dir} to the SparkSession. Along with
the warehouse, an accompanied metastore may also be automatically created in the current
directory when a new SparkSession is initialized with \code{enableHiveSupport} set to
\code{TRUE}, which is the default. For more details, refer to Hive configuration at
\url{http://spark.apache.org/docs/latest/sql-programming-guide.html#hive-tables}.

For details on how to initialize and use SparkR, refer to SparkR programming guide at
\url{http://spark.apache.org/docs/latest/sparkr.html#starting-up-sparksession}.
}
\note{
sparkR.session since 2.0.0
}
\examples{
\dontrun{
sparkR.session()
df <- read.json(path)

sparkR.session("local[2]", "SparkR", "/home/spark")
sparkR.session("yarn", "SparkR", "/home/spark",
               list(spark.executor.memory="4g", spark.submit.deployMode="client"),
               c("one.jar", "two.jar", "three.jar"),
               c("com.databricks:spark-avro_2.12:2.0.1"))
sparkR.session(spark.master = "yarn", spark.submit.deployMode = "client",
               spark.executor.memory = "4g")
}
}
