/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.nio.ByteOrder;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;

public final class RecordBinaryComparator
extends RecordComparator {
    private static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);

    public int compare(Object leftObj, long leftOff, int leftLen, Object rightObj, long rightOff, int rightLen) {
        byte v2;
        int i;
        if (leftLen != rightLen) {
            return leftLen - rightLen;
        }
        if (leftOff % 8L == rightOff % 8L) {
            for (i = 0; (leftOff + (long)i) % 8L != 0L && i < leftLen; ++i) {
                byte v1 = Platform.getByte((Object)leftObj, (long)(leftOff + (long)i));
                if (v1 == (v2 = Platform.getByte((Object)rightObj, (long)(rightOff + (long)i)))) continue;
                return (v1 & 0xFF) > (v2 & 0xFF) ? 1 : -1;
            }
        }
        if (Platform.unaligned() || (leftOff + (long)i) % 8L == 0L && (rightOff + (long)i) % 8L == 0L) {
            while (i <= leftLen - 8) {
                long v22;
                long v1 = Platform.getLong((Object)leftObj, (long)(leftOff + (long)i));
                if (v1 != (v22 = Platform.getLong((Object)rightObj, (long)(rightOff + (long)i)))) {
                    if (LITTLE_ENDIAN) {
                        v1 = Long.reverseBytes(v1);
                        v22 = Long.reverseBytes(v22);
                    }
                    return Long.compareUnsigned(v1, v22);
                }
                i += 8;
            }
        }
        while (i < leftLen) {
            byte v1 = Platform.getByte((Object)leftObj, (long)(leftOff + (long)i));
            if (v1 != (v2 = Platform.getByte((Object)rightObj, (long)(rightOff + (long)i)))) {
                return (v1 & 0xFF) > (v2 & 0xFF) ? 1 : -1;
            }
            ++i;
        }
        return 0;
    }
}

